---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, pages, couleurs, fond, style de page, 
              xcolor, fancyhdr, en-têtes et pieds de page
---

# Comment changer la couleur de fond des pages ?


L'extension <ctanpkg:xcolor> permet la gestion des couleurs. 
La commande `\pagecolor{⟨couleur⟩}` spécifie la couleur d’arrière-plan 
de la page en cours et de toutes les pages suivantes. 

L'exemple suivant illustre cette commande mais montre aussi une façon 
de gérer la couleur des en-têtes et pieds de page (avec 
l'extension <ctanpkg:fancyhdr>) afin qu'ils restent lisibles. Ici, le style 
de page `fancy` est défini pour afficher par défaut un numéro de pied 
de page en blanc (utile sur les pages noires). Sur ce sujet, vous pouvez 
consulter la question "[](entetes/composer_des_en-tetes_et_pieds_de_page)".

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}       % Encodage T1 (adapté au français)
  \usepackage{lmodern}           % Caractères plus lisibles
  \usepackage{babel}             % Réglages linguistiques (avec french)
  \usepackage{fancyhdr}
  \usepackage{lipsum}            % Du faux texte
  \usepackage[x11names]{xcolor}  % L'option apporte des couleurs prédéfinies

  % Modification des styles des en-têtes et pieds de page
  \usepackage{fancyhdr}
  \pagestyle{fancy}  % Définition d'un style de page personnalisé
  \renewcommand{\headrulewidth}{0pt}    % Supprime le filet des en-têtes
  \fancyfoot[C]{\color{white}\thepage}  % Couleur du numéro de page (centré)

\begin{document}
\thispagestyle{plain}        % Style de page classique sur la page courante
\lipsum[1-5]

\newpage
\pagecolor{AntiqueWhite1}    % Utilisation d'une couleur prédéfinie
\thispagestyle{plain}        % Style de page classique sur la page courante
\lipsum[6-10]

\newpage
\pagecolor{black!66}         % Couleur du fond de la page et des suivantes
\color{white}\lipsum[11-20]  % couleur du texte
\end{document}
```


:::{sources}
- Documentation de <ctanpkg:xcolor> : <texdoc:xcolor>.
- Documentation de <ctanpkg:fancyhdr> : <texdoc:fancyhdr>.
:::
