/*
   Unix SMB/CIFS implementation.
   test suite for Windows Offline Join files

   Copyright (C) Guenther Deschner 2021

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "includes.h"
#include "torture/ndr/ndr.h"
#include "librpc/gen_ndr/ndr_ODJ.h"
#include "torture/ndr/proto.h"

static const uint8_t ODJ_PROVISION_DATA_data[] = {
	0x01, 0x10, 0x08, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xb0, 0x07, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x18, 0x03, 0x00, 0x00, 0x08, 0x00, 0x02, 0x00,
	0x02, 0x00, 0x00, 0x00, 0x60, 0x04, 0x00, 0x00, 0x0c, 0x00, 0x02, 0x00,
	0x18, 0x03, 0x00, 0x00, 0x01, 0x10, 0x08, 0x00, 0xcc, 0xcc, 0xcc, 0xcc,
	0x08, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x9c, 0x4f, 0x93,
	0x20, 0xfc, 0x4f, 0x93, 0x90, 0xbf, 0x50, 0x93, 0x60, 0xbf, 0x50, 0x93,
	0x10, 0x00, 0x12, 0x00, 0x40, 0x7f, 0x4f, 0x93, 0x2e, 0x00, 0x30, 0x00,
	0x60, 0xf3, 0x4f, 0x93, 0x2e, 0x00, 0x30, 0x00, 0x50, 0xf4, 0x4f, 0x93,
	0x96, 0x1a, 0x76, 0xc0, 0x42, 0xe2, 0xc2, 0x4e, 0x91, 0x60, 0x7a, 0x66,
	0xa4, 0xac, 0x49, 0x29, 0x00, 0x85, 0x4f, 0x93, 0x30, 0xa1, 0x4f, 0x93,
	0x80, 0xf1, 0x4f, 0x93, 0x01, 0x00, 0x00, 0x00, 0x96, 0x1a, 0x76, 0xc0,
	0x42, 0xe2, 0xc2, 0x4e, 0x91, 0x60, 0x7a, 0x66, 0xa4, 0xac, 0x49, 0x29,
	0x10, 0xfd, 0x4f, 0x93, 0x40, 0xf5, 0x4f, 0x93, 0xfd, 0xf3, 0x03, 0xe0,
	0xf0, 0xf9, 0x4f, 0x93, 0xb0, 0xfd, 0x4f, 0x93, 0x04, 0x00, 0x00, 0x00,
	0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
	0x77, 0x00, 0x32, 0x00, 0x6b, 0x00, 0x31, 0x00, 0x39, 0x00, 0x64, 0x00,
	0x6f, 0x00, 0x6d, 0x00, 0x2e, 0x00, 0x62, 0x00, 0x65, 0x00, 0x72, 0x00,
	0x2e, 0x00, 0x72, 0x00, 0x65, 0x00, 0x64, 0x00, 0x68, 0x00, 0x61, 0x00,
	0x74, 0x00, 0x2e, 0x00, 0x63, 0x00, 0x6f, 0x00, 0x6d, 0x00, 0x00, 0x00,
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
	0x77, 0x00, 0x75, 0x00, 0x72, 0x00, 0x73, 0x00, 0x74, 0x00, 0x32, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x07, 0x00, 0x00, 0x00, 0x77, 0x00, 0x75, 0x00, 0x72, 0x00, 0x73, 0x00,
	0x74, 0x00, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x57, 0x00, 0x32, 0x00,
	0x4b, 0x00, 0x31, 0x00, 0x39, 0x00, 0x44, 0x00, 0x4f, 0x00, 0x4d, 0x00,
	0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00,
	0x77, 0x00, 0x32, 0x00, 0x6b, 0x00, 0x31, 0x00, 0x39, 0x00, 0x64, 0x00,
	0x6f, 0x00, 0x6d, 0x00, 0x2e, 0x00, 0x62, 0x00, 0x65, 0x00, 0x72, 0x00,
	0x2e, 0x00, 0x72, 0x00, 0x65, 0x00, 0x64, 0x00, 0x68, 0x00, 0x61, 0x00,
	0x74, 0x00, 0x2e, 0x00, 0x63, 0x00, 0x6f, 0x00, 0x6d, 0x00, 0x00, 0x00,
	0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00,
	0x77, 0x00, 0x32, 0x00, 0x6b, 0x00, 0x31, 0x00, 0x39, 0x00, 0x64, 0x00,
	0x6f, 0x00, 0x6d, 0x00, 0x2e, 0x00, 0x62, 0x00, 0x65, 0x00, 0x72, 0x00,
	0x2e, 0x00, 0x72, 0x00, 0x65, 0x00, 0x64, 0x00, 0x68, 0x00, 0x61, 0x00,
	0x74, 0x00, 0x2e, 0x00, 0x63, 0x00, 0x6f, 0x00, 0x6d, 0x00, 0x00, 0x00,
	0x04, 0x00, 0x00, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
	0x15, 0x00, 0x00, 0x00, 0xe8, 0xf2, 0x4b, 0x12, 0x6a, 0xe6, 0x55, 0x41,
	0x43, 0xa4, 0xb4, 0x74, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x24, 0x00, 0x00, 0x00, 0x5c, 0x00, 0x5c, 0x00, 0x67, 0x00, 0x64, 0x00,
	0x77, 0x00, 0x32, 0x00, 0x6b, 0x00, 0x31, 0x00, 0x39, 0x00, 0x64, 0x00,
	0x63, 0x00, 0x2e, 0x00, 0x77, 0x00, 0x32, 0x00, 0x6b, 0x00, 0x31, 0x00,
	0x39, 0x00, 0x64, 0x00, 0x6f, 0x00, 0x6d, 0x00, 0x2e, 0x00, 0x62, 0x00,
	0x65, 0x00, 0x72, 0x00, 0x2e, 0x00, 0x72, 0x00, 0x65, 0x00, 0x64, 0x00,
	0x68, 0x00, 0x61, 0x00, 0x74, 0x00, 0x2e, 0x00, 0x63, 0x00, 0x6f, 0x00,
	0x6d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x11, 0x00, 0x00, 0x00, 0x5c, 0x00, 0x5c, 0x00, 0x31, 0x00, 0x39, 0x00,
	0x32, 0x00, 0x2e, 0x00, 0x31, 0x00, 0x36, 0x00, 0x38, 0x00, 0x2e, 0x00,
	0x35, 0x00, 0x36, 0x00, 0x2e, 0x00, 0x31, 0x00, 0x30, 0x00, 0x38, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x00, 0x00, 0x00, 0x77, 0x00, 0x32, 0x00, 0x6b, 0x00, 0x31, 0x00,
	0x39, 0x00, 0x64, 0x00, 0x6f, 0x00, 0x6d, 0x00, 0x2e, 0x00, 0x62, 0x00,
	0x65, 0x00, 0x72, 0x00, 0x2e, 0x00, 0x72, 0x00, 0x65, 0x00, 0x64, 0x00,
	0x68, 0x00, 0x61, 0x00, 0x74, 0x00, 0x2e, 0x00, 0x63, 0x00, 0x6f, 0x00,
	0x6d, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x00, 0x00, 0x00, 0x77, 0x00, 0x32, 0x00, 0x6b, 0x00, 0x31, 0x00,
	0x39, 0x00, 0x64, 0x00, 0x6f, 0x00, 0x6d, 0x00, 0x2e, 0x00, 0x62, 0x00,
	0x65, 0x00, 0x72, 0x00, 0x2e, 0x00, 0x72, 0x00, 0x65, 0x00, 0x64, 0x00,
	0x68, 0x00, 0x61, 0x00, 0x74, 0x00, 0x2e, 0x00, 0x63, 0x00, 0x6f, 0x00,
	0x6d, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x00, 0x00, 0x00, 0x44, 0x00, 0x65, 0x00, 0x66, 0x00, 0x61, 0x00,
	0x75, 0x00, 0x6c, 0x00, 0x74, 0x00, 0x2d, 0x00, 0x46, 0x00, 0x69, 0x00,
	0x72, 0x00, 0x73, 0x00, 0x74, 0x00, 0x2d, 0x00, 0x53, 0x00, 0x69, 0x00,
	0x74, 0x00, 0x65, 0x00, 0x2d, 0x00, 0x4e, 0x00, 0x61, 0x00, 0x6d, 0x00,
	0x65, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x00, 0x00, 0x00, 0x44, 0x00, 0x65, 0x00, 0x66, 0x00, 0x61, 0x00,
	0x75, 0x00, 0x6c, 0x00, 0x74, 0x00, 0x2d, 0x00, 0x46, 0x00, 0x69, 0x00,
	0x72, 0x00, 0x73, 0x00, 0x74, 0x00, 0x2d, 0x00, 0x53, 0x00, 0x69, 0x00,
	0x74, 0x00, 0x65, 0x00, 0x2d, 0x00, 0x4e, 0x00, 0x61, 0x00, 0x6d, 0x00,
	0x65, 0x00, 0x00, 0x00, 0x60, 0x04, 0x00, 0x00, 0x01, 0x10, 0x08, 0x00,
	0xcc, 0xcc, 0xcc, 0xcc, 0x50, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x04, 0x00, 0x00, 0x04, 0x00, 0x02, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x04, 0x00, 0x00, 0x01, 0x10, 0x08, 0x00, 0xcc, 0xcc, 0xcc, 0xcc,
	0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
	0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x21, 0x76, 0x1c, 0x63,
	0x89, 0x52, 0x21, 0x43, 0xbc, 0x9e, 0x80, 0xf8, 0x43, 0xf8, 0x68, 0xc3,
	0x01, 0x00, 0x00, 0x00, 0x18, 0x03, 0x00, 0x00, 0x08, 0x00, 0x02, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0xcf, 0x0c, 0xfc,
	0xfa, 0x7f, 0x4a, 0x47, 0x86, 0x11, 0x69, 0xff, 0xe2, 0x69, 0x64, 0x5f,
	0x00, 0x00, 0x00, 0x00, 0x88, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x02, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x03, 0x00, 0x00,
	0x01, 0x10, 0x08, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0x08, 0x03, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x80, 0x9c, 0x4f, 0x93, 0x20, 0xfc, 0x4f, 0x93,
	0x90, 0xbf, 0x50, 0x93, 0x60, 0xbf, 0x50, 0x93, 0x10, 0x00, 0x12, 0x00,
	0x40, 0x7f, 0x4f, 0x93, 0x2e, 0x00, 0x30, 0x00, 0x60, 0xf3, 0x4f, 0x93,
	0x2e, 0x00, 0x30, 0x00, 0x50, 0xf4, 0x4f, 0x93, 0x96, 0x1a, 0x76, 0xc0,
	0x42, 0xe2, 0xc2, 0x4e, 0x91, 0x60, 0x7a, 0x66, 0xa4, 0xac, 0x49, 0x29,
	0x00, 0x85, 0x4f, 0x93, 0x30, 0xa1, 0x4f, 0x93, 0x80, 0xf1, 0x4f, 0x93,
	0x01, 0x00, 0x00, 0x00, 0x96, 0x1a, 0x76, 0xc0, 0x42, 0xe2, 0xc2, 0x4e,
	0x91, 0x60, 0x7a, 0x66, 0xa4, 0xac, 0x49, 0x29, 0x10, 0xfd, 0x4f, 0x93,
	0x40, 0xf5, 0x4f, 0x93, 0xfd, 0xf3, 0x03, 0xe0, 0xf0, 0xf9, 0x4f, 0x93,
	0xb0, 0xfd, 0x4f, 0x93, 0x04, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x77, 0x00, 0x32, 0x00,
	0x6b, 0x00, 0x31, 0x00, 0x39, 0x00, 0x64, 0x00, 0x6f, 0x00, 0x6d, 0x00,
	0x2e, 0x00, 0x62, 0x00, 0x65, 0x00, 0x72, 0x00, 0x2e, 0x00, 0x72, 0x00,
	0x65, 0x00, 0x64, 0x00, 0x68, 0x00, 0x61, 0x00, 0x74, 0x00, 0x2e, 0x00,
	0x63, 0x00, 0x6f, 0x00, 0x6d, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x77, 0x00, 0x75, 0x00,
	0x72, 0x00, 0x73, 0x00, 0x74, 0x00, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
	0x77, 0x00, 0x75, 0x00, 0x72, 0x00, 0x73, 0x00, 0x74, 0x00, 0x32, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x00, 0x00, 0x00, 0x57, 0x00, 0x32, 0x00, 0x4b, 0x00, 0x31, 0x00,
	0x39, 0x00, 0x44, 0x00, 0x4f, 0x00, 0x4d, 0x00, 0x18, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x77, 0x00, 0x32, 0x00,
	0x6b, 0x00, 0x31, 0x00, 0x39, 0x00, 0x64, 0x00, 0x6f, 0x00, 0x6d, 0x00,
	0x2e, 0x00, 0x62, 0x00, 0x65, 0x00, 0x72, 0x00, 0x2e, 0x00, 0x72, 0x00,
	0x65, 0x00, 0x64, 0x00, 0x68, 0x00, 0x61, 0x00, 0x74, 0x00, 0x2e, 0x00,
	0x63, 0x00, 0x6f, 0x00, 0x6d, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x77, 0x00, 0x32, 0x00,
	0x6b, 0x00, 0x31, 0x00, 0x39, 0x00, 0x64, 0x00, 0x6f, 0x00, 0x6d, 0x00,
	0x2e, 0x00, 0x62, 0x00, 0x65, 0x00, 0x72, 0x00, 0x2e, 0x00, 0x72, 0x00,
	0x65, 0x00, 0x64, 0x00, 0x68, 0x00, 0x61, 0x00, 0x74, 0x00, 0x2e, 0x00,
	0x63, 0x00, 0x6f, 0x00, 0x6d, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
	0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x15, 0x00, 0x00, 0x00,
	0xe8, 0xf2, 0x4b, 0x12, 0x6a, 0xe6, 0x55, 0x41, 0x43, 0xa4, 0xb4, 0x74,
	0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00,
	0x5c, 0x00, 0x5c, 0x00, 0x67, 0x00, 0x64, 0x00, 0x77, 0x00, 0x32, 0x00,
	0x6b, 0x00, 0x31, 0x00, 0x39, 0x00, 0x64, 0x00, 0x63, 0x00, 0x2e, 0x00,
	0x77, 0x00, 0x32, 0x00, 0x6b, 0x00, 0x31, 0x00, 0x39, 0x00, 0x64, 0x00,
	0x6f, 0x00, 0x6d, 0x00, 0x2e, 0x00, 0x62, 0x00, 0x65, 0x00, 0x72, 0x00,
	0x2e, 0x00, 0x72, 0x00, 0x65, 0x00, 0x64, 0x00, 0x68, 0x00, 0x61, 0x00,
	0x74, 0x00, 0x2e, 0x00, 0x63, 0x00, 0x6f, 0x00, 0x6d, 0x00, 0x00, 0x00,
	0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00,
	0x5c, 0x00, 0x5c, 0x00, 0x31, 0x00, 0x39, 0x00, 0x32, 0x00, 0x2e, 0x00,
	0x31, 0x00, 0x36, 0x00, 0x38, 0x00, 0x2e, 0x00, 0x35, 0x00, 0x36, 0x00,
	0x2e, 0x00, 0x31, 0x00, 0x30, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
	0x77, 0x00, 0x32, 0x00, 0x6b, 0x00, 0x31, 0x00, 0x39, 0x00, 0x64, 0x00,
	0x6f, 0x00, 0x6d, 0x00, 0x2e, 0x00, 0x62, 0x00, 0x65, 0x00, 0x72, 0x00,
	0x2e, 0x00, 0x72, 0x00, 0x65, 0x00, 0x64, 0x00, 0x68, 0x00, 0x61, 0x00,
	0x74, 0x00, 0x2e, 0x00, 0x63, 0x00, 0x6f, 0x00, 0x6d, 0x00, 0x00, 0x00,
	0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
	0x77, 0x00, 0x32, 0x00, 0x6b, 0x00, 0x31, 0x00, 0x39, 0x00, 0x64, 0x00,
	0x6f, 0x00, 0x6d, 0x00, 0x2e, 0x00, 0x62, 0x00, 0x65, 0x00, 0x72, 0x00,
	0x2e, 0x00, 0x72, 0x00, 0x65, 0x00, 0x64, 0x00, 0x68, 0x00, 0x61, 0x00,
	0x74, 0x00, 0x2e, 0x00, 0x63, 0x00, 0x6f, 0x00, 0x6d, 0x00, 0x00, 0x00,
	0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
	0x44, 0x00, 0x65, 0x00, 0x66, 0x00, 0x61, 0x00, 0x75, 0x00, 0x6c, 0x00,
	0x74, 0x00, 0x2d, 0x00, 0x46, 0x00, 0x69, 0x00, 0x72, 0x00, 0x73, 0x00,
	0x74, 0x00, 0x2d, 0x00, 0x53, 0x00, 0x69, 0x00, 0x74, 0x00, 0x65, 0x00,
	0x2d, 0x00, 0x4e, 0x00, 0x61, 0x00, 0x6d, 0x00, 0x65, 0x00, 0x00, 0x00,
	0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
	0x44, 0x00, 0x65, 0x00, 0x66, 0x00, 0x61, 0x00, 0x75, 0x00, 0x6c, 0x00,
	0x74, 0x00, 0x2d, 0x00, 0x46, 0x00, 0x69, 0x00, 0x72, 0x00, 0x73, 0x00,
	0x74, 0x00, 0x2d, 0x00, 0x53, 0x00, 0x69, 0x00, 0x74, 0x00, 0x65, 0x00,
	0x2d, 0x00, 0x4e, 0x00, 0x61, 0x00, 0x6d, 0x00, 0x65, 0x00, 0x00, 0x00,
	0x88, 0x00, 0x00, 0x00, 0x01, 0x10, 0x08, 0x00, 0xcc, 0xcc, 0xcc, 0xcc,
	0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
	0x45, 0x06, 0x00, 0x00, 0x04, 0x00, 0x02, 0x00, 0x2e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x2e, 0x00, 0x00, 0x00, 0x53, 0x00, 0x2d, 0x00,
	0x31, 0x00, 0x2d, 0x00, 0x35, 0x00, 0x2d, 0x00, 0x32, 0x00, 0x31, 0x00,
	0x2d, 0x00, 0x33, 0x00, 0x30, 0x00, 0x36, 0x00, 0x39, 0x00, 0x36, 0x00,
	0x37, 0x00, 0x32, 0x00, 0x37, 0x00, 0x32, 0x00, 0x2d, 0x00, 0x31, 0x00,
	0x30, 0x00, 0x39, 0x00, 0x36, 0x00, 0x31, 0x00, 0x34, 0x00, 0x38, 0x00,
	0x35, 0x00, 0x38, 0x00, 0x36, 0x00, 0x2d, 0x00, 0x31, 0x00, 0x39, 0x00,
	0x35, 0x00, 0x37, 0x00, 0x39, 0x00, 0x39, 0x00, 0x35, 0x00, 0x35, 0x00,
	0x38, 0x00, 0x37, 0x00, 0x2d, 0x00, 0x31, 0x00, 0x36, 0x00, 0x30, 0x00,
	0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00
};

static bool ODJ_PROVISION_DATA_check(struct torture_context *tctx,
				     struct ODJ_PROVISION_DATA_serialized_ptr *r)
{
	return true;
}

struct torture_suite *ndr_ODJ_suite(TALLOC_CTX *ctx)
{
	struct torture_suite *suite = torture_suite_create(ctx, "ODJ");

	torture_suite_add_ndr_pull_test(suite,
					ODJ_PROVISION_DATA_serialized_ptr,
					ODJ_PROVISION_DATA_data,
					ODJ_PROVISION_DATA_check);
	return suite;
}
