# Generated by make -f Makefile-cigraph, do not edit by hand
# styler: off

empty_impl <- function(n=0, directed=TRUE) {
  # Argument checks
  n <- as.numeric(n)
  directed <- as.logical(directed)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_empty, n, directed)

  res
}

add_edges_impl <- function(graph, edges) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_add_edges, graph, edges)

  res
}

copy_impl <- function(from) {
  # Argument checks
  ensure_igraph(from)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_copy, from)

  res
}

delete_vertices_idx_impl <- function(graph, vertices) {
  # Argument checks
  ensure_igraph(graph)
  vertices <- as_igraph_vs(graph, vertices)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_delete_vertices_idx, graph, vertices-1)

  res
}

vcount_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_vcount, graph)


  res
}

neighbors_impl <- function(graph, vid, mode=c("all", "out", "in", "total")) {
  # Argument checks
  ensure_igraph(graph)
  vid <- as_igraph_vs(graph, vid)
  if (length(vid) == 0) {
    stop("No vertex was specified")
  }
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_neighbors, graph, vid-1, mode)
  if (igraph_opt("return.vs.es")) {
    res <- create_vs(graph, res)
  }
  res
}

degree_impl <- function(graph, vids=V(graph), mode=c("all", "out", "in", "total"), loops=TRUE) {
  # Argument checks
  ensure_igraph(graph)
  vids <- as_igraph_vs(graph, vids)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)
  loops <- as.logical(loops)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_degree, graph, vids-1, mode, loops)

  res
}

get_all_eids_between_impl <- function(graph, from, to, directed=TRUE) {
  # Argument checks
  ensure_igraph(graph)
  from <- as_igraph_vs(graph, from)
  if (length(from) == 0) {
    stop("No vertex was specified")
  }
  to <- as_igraph_vs(graph, to)
  if (length(to) == 0) {
    stop("No vertex was specified")
  }
  directed <- as.logical(directed)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_get_all_eids_between, graph, from-1, to-1, directed)
  if (igraph_opt("return.vs.es")) {
    res <- create_es(graph, res)
  }
  res
}

wheel_impl <- function(n, mode=c("out", "in", "undirected", "mutual"), center=0) {
  # Argument checks
  n <- as.numeric(n)
  mode <- switch(igraph.match.arg(mode), "out"=0L, "in"=1L, "undirected"=2L, "mutual"=3L)
  center <- as.numeric(center)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_wheel, n, mode, center)

  res
}

hypercube_impl <- function(n, directed=FALSE) {
  # Argument checks
  n <- as.numeric(n)
  directed <- as.logical(directed)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_hypercube, n, directed)

  res
}

square_lattice_impl <- function(dimvector, nei=1, directed=FALSE, mutual=FALSE, periodic=NULL) {
  # Argument checks
  dimvector <- as.numeric(dimvector)
  nei <- as.numeric(nei)
  directed <- as.logical(directed)
  mutual <- as.logical(mutual)
  if (!is.null(periodic)) periodic <- as.logical(periodic)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_square_lattice, dimvector, nei, directed, mutual, periodic)

  res
}

triangular_lattice_impl <- function(dimvector, directed=FALSE, mutual=FALSE) {
  # Argument checks
  dimvector <- as.numeric(dimvector)
  directed <- as.logical(directed)
  mutual <- as.logical(mutual)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_triangular_lattice, dimvector, directed, mutual)

  res
}

path_graph_impl <- function(n, directed=FALSE, mutual=FALSE) {
  # Argument checks
  n <- as.numeric(n)
  directed <- as.logical(directed)
  mutual <- as.logical(mutual)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_path_graph, n, directed, mutual)

  res
}

cycle_graph_impl <- function(n, directed=FALSE, mutual=FALSE) {
  # Argument checks
  n <- as.numeric(n)
  directed <- as.logical(directed)
  mutual <- as.logical(mutual)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_cycle_graph, n, directed, mutual)

  res
}

symmetric_tree_impl <- function(branches, type=c("out", "in", "undirected")) {
  # Argument checks
  branches <- as.numeric(branches)
  type <- switch(igraph.match.arg(type), "out"=0L, "in"=1L, "undirected"=2L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_symmetric_tree, branches, type)

  res
}

regular_tree_impl <- function(h, k=3, type=c("undirected", "out", "in")) {
  # Argument checks
  h <- as.numeric(h)
  k <- as.numeric(k)
  type <- switch(igraph.match.arg(type), "out"=0L, "in"=1L, "undirected"=2L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_regular_tree, h, k, type)

  res
}

full_citation_impl <- function(n, directed=TRUE) {
  # Argument checks
  n <- as.numeric(n)
  directed <- as.logical(directed)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_full_citation, n, directed)

  res
}

atlas_impl <- function(number=0) {
  # Argument checks
  number <- as.numeric(number)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_atlas, number)

  res
}

extended_chordal_ring_impl <- function(nodes, W, directed=FALSE) {
  # Argument checks
  nodes <- as.numeric(nodes)
  directed <- as.logical(directed)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_extended_chordal_ring, nodes, W, directed)

  res
}

graph_power_impl <- function(graph, order, directed=FALSE) {
  # Argument checks
  ensure_igraph(graph)
  order <- as.numeric(order)
  directed <- as.logical(directed)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_graph_power, graph, order, directed)

  res
}

linegraph_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_linegraph, graph)

  res
}

de_bruijn_impl <- function(m, n) {
  # Argument checks
  m <- as.numeric(m)
  n <- as.numeric(n)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_de_bruijn, m, n)

  res
}

kautz_impl <- function(m, n) {
  # Argument checks
  m <- as.numeric(m)
  n <- as.numeric(n)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_kautz, m, n)

  res
}

lcf_vector_impl <- function(n, shifts, repeats=1) {
  # Argument checks
  n <- as.numeric(n)
  shifts <- as.numeric(shifts)
  repeats <- as.numeric(repeats)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_lcf_vector, n, shifts, repeats)

  if (igraph_opt("add.params")) {
    res$name <- 'LCF graph'
  }

  res
}

mycielski_graph_impl <- function(k) {
  # Argument checks
  k <- as.numeric(k)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_mycielski_graph, k)

  res
}

adjlist_impl <- function(adjlist, mode=c("out", "in", "all", "total"), duplicate=TRUE) {
  # Argument checks
  adjlist <- lapply(adjlist, function(x) as.numeric(x)-1)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)
  duplicate <- as.logical(duplicate)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_adjlist, adjlist, mode, duplicate)

  res
}

full_bipartite_impl <- function(n1, n2, directed=FALSE, mode=c("all", "out", "in", "total")) {
  # Argument checks
  n1 <- as.numeric(n1)
  n2 <- as.numeric(n2)
  directed <- as.logical(directed)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_full_bipartite, n1, n2, directed, mode)
  if (igraph_opt("add.vertex.names") && is_named(res$graph)) {
    names(res$types) <- vertex_attr(res$graph, "name")
  }
  res
}

full_multipartite_impl <- function(n, directed=FALSE, mode=c("all", "out", "in", "total")) {
  # Argument checks
  n <- as.numeric(n)
  directed <- as.logical(directed)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_full_multipartite, n, directed, mode)

  res
}

realize_degree_sequence_impl <- function(out.deg, in.deg=NULL, allowed.edge.types=c("simple", "loops", "multi", "all"), method=c("smallest", "largest", "index")) {
  # Argument checks
  out.deg <- as.numeric(out.deg)
  if (!is.null(in.deg)) in.deg <- as.numeric(in.deg)
  allowed.edge.types <- switch(igraph.match.arg(allowed.edge.types),
    "simple"=0L, "loop"=1L, "loops"=1L, "multi"=6L, "multiple"=6L, "all"=7L)
  method <- switch(igraph.match.arg(method), "smallest"=0L, "largest"=1L, "index"=2L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_realize_degree_sequence, out.deg, in.deg, allowed.edge.types, method)

  if (igraph_opt("add.params")) {
    res$name <- 'Graph from degree sequence'
    res$out.deg <- out.deg
    res$in.deg <- in.deg
    res$allowed.edge.types <- allowed.edge.types
    res$method <- method
  }

  res
}

realize_bipartite_degree_sequence_impl <- function(degrees1, degrees2, allowed.edge.types=c("simple", "loops", "multi", "all"), method=c("smallest", "largest", "index")) {
  # Argument checks
  degrees1 <- as.numeric(degrees1)
  degrees2 <- as.numeric(degrees2)
  allowed.edge.types <- switch(igraph.match.arg(allowed.edge.types),
    "simple"=0L, "loop"=1L, "loops"=1L, "multi"=6L, "multiple"=6L, "all"=7L)
  method <- switch(igraph.match.arg(method), "smallest"=0L, "largest"=1L, "index"=2L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_realize_bipartite_degree_sequence, degrees1, degrees2, allowed.edge.types, method)

  if (igraph_opt("add.params")) {
    res$name <- 'Bipartite graph from degree sequence'
    res$degrees1 <- degrees1
    res$degrees2 <- degrees2
    res$allowed.edge.types <- allowed.edge.types
    res$method <- method
  }

  res
}

circulant_impl <- function(n, shifts, directed=FALSE) {
  # Argument checks
  n <- as.numeric(n)
  shifts <- as.numeric(shifts)
  directed <- as.logical(directed)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_circulant, n, shifts, directed)

  res
}

generalized_petersen_impl <- function(n, k) {
  # Argument checks
  n <- as.numeric(n)
  k <- as.numeric(k)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_generalized_petersen, n, k)

  res
}

turan_impl <- function(n, r) {
  # Argument checks
  n <- as.numeric(n)
  r <- as.numeric(r)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_turan, n, r)

  res
}

erdos_renyi_game_gnp_impl <- function(n, p, directed=FALSE, loops=FALSE) {
  # Argument checks
  n <- as.numeric(n)
  p <- as.numeric(p)
  directed <- as.logical(directed)
  loops <- as.logical(loops)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_erdos_renyi_game_gnp, n, p, directed, loops)

  res
}

erdos_renyi_game_gnm_impl <- function(n, m, directed=FALSE, loops=FALSE) {
  # Argument checks
  n <- as.numeric(n)
  m <- as.numeric(m)
  directed <- as.logical(directed)
  loops <- as.logical(loops)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_erdos_renyi_game_gnm, n, m, directed, loops)

  res
}

growing_random_game_impl <- function(n, m=1, ..., directed=TRUE, citation=FALSE) {
  # Argument checks
  check_dots_empty()
  n <- as.numeric(n)
  m <- as.numeric(m)
  directed <- as.logical(directed)
  citation <- as.logical(citation)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_growing_random_game, n, m, directed, citation)

  if (igraph_opt("add.params")) {
    res$name <- 'Growing random graph'
    res$m <- m
    res$citation <- citation
  }

  res
}

preference_game_impl <- function(nodes, types, type.dist, fixed.sizes=FALSE, pref.matrix, directed=FALSE, loops=FALSE) {
  # Argument checks
  nodes <- as.numeric(nodes)
  types <- as.numeric(types)
  type.dist <- as.numeric(type.dist)
  fixed.sizes <- as.logical(fixed.sizes)
  pref.matrix[] <- as.numeric(pref.matrix)
  directed <- as.logical(directed)
  loops <- as.logical(loops)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_preference_game, nodes, types, type.dist, fixed.sizes, pref.matrix, directed, loops)

  res
}

asymmetric_preference_game_impl <- function(nodes, out.types, in.types, type.dist.matrix, pref.matrix, loops=FALSE) {
  # Argument checks
  nodes <- as.numeric(nodes)
  out.types <- as.numeric(out.types)
  in.types <- as.numeric(in.types)
  type.dist.matrix[] <- as.numeric(type.dist.matrix)
  pref.matrix[] <- as.numeric(pref.matrix)
  loops <- as.logical(loops)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_asymmetric_preference_game, nodes, out.types, in.types, type.dist.matrix, pref.matrix, loops)

  res
}

rewire_edges_impl <- function(graph, prob, loops=FALSE, multiple=FALSE) {
  # Argument checks
  ensure_igraph(graph)
  prob <- as.numeric(prob)
  loops <- as.logical(loops)
  multiple <- as.logical(multiple)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_rewire_edges, graph, prob, loops, multiple)

  res
}

rewire_directed_edges_impl <- function(graph, prob, loops=FALSE, mode=c("out", "in", "all", "total")) {
  # Argument checks
  ensure_igraph(graph)
  prob <- as.numeric(prob)
  loops <- as.logical(loops)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_rewire_directed_edges, graph, prob, loops, mode)

  res
}

forest_fire_game_impl <- function(nodes, fw.prob, bw.factor=1, ambs=1, directed=TRUE) {
  # Argument checks
  nodes <- as.numeric(nodes)
  fw.prob <- as.numeric(fw.prob)
  bw.factor <- as.numeric(bw.factor)
  ambs <- as.numeric(ambs)
  directed <- as.logical(directed)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_forest_fire_game, nodes, fw.prob, bw.factor, ambs, directed)

  if (igraph_opt("add.params")) {
    res$name <- 'Forest fire model'
    res$fw.prob <- fw.prob
    res$bw.factor <- bw.factor
    res$ambs <- ambs
  }

  res
}

simple_interconnected_islands_game_impl <- function(islands.n, islands.size, islands.pin, n.inter) {
  # Argument checks
  islands.n <- as.numeric(islands.n)
  islands.size <- as.numeric(islands.size)
  islands.pin <- as.numeric(islands.pin)
  n.inter <- as.numeric(n.inter)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_simple_interconnected_islands_game, islands.n, islands.size, islands.pin, n.inter)

  if (igraph_opt("add.params")) {
    res$name <- 'Interconnected islands model'
    res$islands.n <- islands.n
    res$islands.size <- islands.size
    res$islands.pin <- islands.pin
    res$n.inter <- n.inter
  }

  res
}

chung_lu_game_impl <- function(out.weights, in.weights=NULL, ..., loops=TRUE, variant=c("original", "maxent", "nr")) {
  # Argument checks
  check_dots_empty()
  out.weights <- as.numeric(out.weights)
  if (!is.null(in.weights)) in.weights <- as.numeric(in.weights)
  loops <- as.logical(loops)
  variant <- switch(igraph.match.arg(variant), "original"=0L, "maxent"=1L, "nr"=2L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_chung_lu_game, out.weights, in.weights, loops, variant)

  if (igraph_opt("add.params")) {
    res$name <- 'Chung-Lu model'
    res$variant <- variant
  }

  res
}

static_fitness_game_impl <- function(no.of.edges, fitness.out, fitness.in=NULL, loops=FALSE, multiple=FALSE) {
  # Argument checks
  no.of.edges <- as.numeric(no.of.edges)
  fitness.out <- as.numeric(fitness.out)
  if (!is.null(fitness.in)) fitness.in <- as.numeric(fitness.in)
  loops <- as.logical(loops)
  multiple <- as.logical(multiple)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_static_fitness_game, no.of.edges, fitness.out, fitness.in, loops, multiple)

  if (igraph_opt("add.params")) {
    res$name <- 'Static fitness model'
    res$loops <- loops
    res$multiple <- multiple
  }

  res
}

static_power_law_game_impl <- function(no.of.nodes, no.of.edges, exponent.out, exponent.in=-1, loops=FALSE, multiple=FALSE, finite.size.correction=TRUE) {
  # Argument checks
  no.of.nodes <- as.numeric(no.of.nodes)
  no.of.edges <- as.numeric(no.of.edges)
  exponent.out <- as.numeric(exponent.out)
  exponent.in <- as.numeric(exponent.in)
  loops <- as.logical(loops)
  multiple <- as.logical(multiple)
  finite.size.correction <- as.logical(finite.size.correction)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_static_power_law_game, no.of.nodes, no.of.edges, exponent.out, exponent.in, loops, multiple, finite.size.correction)

  if (igraph_opt("add.params")) {
    res$name <- 'Static power law model'
    res$exponent.out <- exponent.out
    res$exponent.in <- exponent.in
    res$loops <- loops
    res$multiple <- multiple
    res$finite.size.correction <- finite.size.correction
  }

  res
}

k_regular_game_impl <- function(no.of.nodes, k, directed=FALSE, multiple=FALSE) {
  # Argument checks
  no.of.nodes <- as.numeric(no.of.nodes)
  k <- as.numeric(k)
  directed <- as.logical(directed)
  multiple <- as.logical(multiple)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_k_regular_game, no.of.nodes, k, directed, multiple)

  if (igraph_opt("add.params")) {
    res$name <- 'k-regular graph'
    res$k <- k
  }

  res
}

sbm_game_impl <- function(n, pref.matrix, block.sizes, directed=FALSE, loops=FALSE) {
  # Argument checks
  n <- as.numeric(n)
  pref.matrix[] <- as.numeric(pref.matrix)
  block.sizes <- as.numeric(block.sizes)
  directed <- as.logical(directed)
  loops <- as.logical(loops)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_sbm_game, n, pref.matrix, block.sizes, directed, loops)

  if (igraph_opt("add.params")) {
    res$name <- 'Stochastic block model'
    res$loops <- loops
  }

  res
}

hsbm_game_impl <- function(n, m, rho, C, p) {
  # Argument checks
  n <- as.numeric(n)
  m <- as.numeric(m)
  rho <- as.numeric(rho)
  C[] <- as.numeric(C)
  p <- as.numeric(p)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_hsbm_game, n, m, rho, C, p)

  if (igraph_opt("add.params")) {
    res$name <- 'Hierarchical stochastic block model'
    res$m <- m
    res$rho <- rho
    res$C <- C
    res$p <- p
  }

  res
}

hsbm_list_game_impl <- function(n, mlist, rholist, Clist, p) {
  # Argument checks
  n <- as.numeric(n)
  mlist <- as.numeric(mlist)
  p <- as.numeric(p)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_hsbm_list_game, n, mlist, rholist, Clist, p)

  if (igraph_opt("add.params")) {
    res$name <- 'Hierarchical stochastic block model'
    res$p <- p
  }

  res
}

correlated_game_impl <- function(old.graph, corr, p=edge_density(old.graph), permutation=NULL) {
  # Argument checks
  ensure_igraph(old.graph)
  corr <- as.numeric(corr)
  p <- as.numeric(p)
  if (!is.null(permutation)) permutation <- as.numeric(permutation)-1

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_correlated_game, old.graph, corr, p, permutation)

  if (igraph_opt("add.params")) {
    res$name <- 'Correlated random graph'
    res$corr <- corr
    res$p <- p
  }

  res
}

correlated_pair_game_impl <- function(n, corr, p, directed=FALSE, permutation=NULL) {
  # Argument checks
  n <- as.numeric(n)
  corr <- as.numeric(corr)
  p <- as.numeric(p)
  directed <- as.logical(directed)
  if (!is.null(permutation)) permutation <- as.numeric(permutation)-1

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_correlated_pair_game, n, corr, p, directed, permutation)

  res
}

dot_product_game_impl <- function(vecs, directed=FALSE) {
  # Argument checks
  vecs[] <- as.numeric(vecs)
  directed <- as.logical(directed)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_dot_product_game, vecs, directed)

  res
}

sample_sphere_surface_impl <- function(dim, n=1, radius=1, positive=TRUE) {
  # Argument checks
  dim <- as.numeric(dim)
  n <- as.numeric(n)
  radius <- as.numeric(radius)
  positive <- as.logical(positive)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_sample_sphere_surface, dim, n, radius, positive)

  res
}

sample_sphere_volume_impl <- function(dim, n=1, radius=1, positive=TRUE) {
  # Argument checks
  dim <- as.numeric(dim)
  n <- as.numeric(n)
  radius <- as.numeric(radius)
  positive <- as.logical(positive)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_sample_sphere_volume, dim, n, radius, positive)

  res
}

sample_dirichlet_impl <- function(n, alpha) {
  # Argument checks
  n <- as.numeric(n)
  alpha <- as.numeric(alpha)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_sample_dirichlet, n, alpha)

  res
}

are_adjacent_impl <- function(graph, v1, v2) {
  # Argument checks
  ensure_igraph(graph)
  v1 <- as_igraph_vs(graph, v1)
  if (length(v1) == 0) {
    stop("No vertex was specified")
  }
  v2 <- as_igraph_vs(graph, v2)
  if (length(v2) == 0) {
    stop("No vertex was specified")
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_are_adjacent, graph, v1-1, v2-1)

  res
}

closeness_impl <- function(graph, vids=V(graph), mode=c("out", "in", "all", "total"), weights=NULL, normalized=FALSE) {
  # Argument checks
  ensure_igraph(graph)
  vids <- as_igraph_vs(graph, vids)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  normalized <- as.logical(normalized)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_closeness, graph, vids-1, mode, weights, normalized)
  if (igraph_opt("add.vertex.names") && is_named(graph)) {
    names(res$res) <- vertex_attr(graph, "name", vids)
  }
  res
}

closeness_cutoff_impl <- function(graph, vids=V(graph), mode=c("out", "in", "all", "total"), weights=NULL, normalized=FALSE, cutoff=-1) {
  # Argument checks
  ensure_igraph(graph)
  vids <- as_igraph_vs(graph, vids)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  normalized <- as.logical(normalized)
  cutoff <- as.numeric(cutoff)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_closeness_cutoff, graph, vids-1, mode, weights, normalized, cutoff)
  if (igraph_opt("add.vertex.names") && is_named(graph)) {
    names(res$res) <- vertex_attr(graph, "name", vids)
  }
  res
}

get_shortest_path_impl <- function(graph, from, to, mode=c("out", "in", "all", "total")) {
  # Argument checks
  ensure_igraph(graph)
  from <- as_igraph_vs(graph, from)
  if (length(from) == 0) {
    stop("No vertex was specified")
  }
  to <- as_igraph_vs(graph, to)
  if (length(to) == 0) {
    stop("No vertex was specified")
  }
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_get_shortest_path, graph, from-1, to-1, mode)
  if (igraph_opt("return.vs.es")) {
    res$vertices <- create_vs(graph, res$vertices)
  }
  if (igraph_opt("return.vs.es")) {
    res$edges <- create_es(graph, res$edges)
  }
  res
}

get_shortest_path_bellman_ford_impl <- function(graph, from, to, weights=NULL, mode=c("out", "in", "all", "total")) {
  # Argument checks
  ensure_igraph(graph)
  from <- as_igraph_vs(graph, from)
  if (length(from) == 0) {
    stop("No vertex was specified")
  }
  to <- as_igraph_vs(graph, to)
  if (length(to) == 0) {
    stop("No vertex was specified")
  }
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_get_shortest_path_bellman_ford, graph, from-1, to-1, weights, mode)
  if (igraph_opt("return.vs.es")) {
    res$vertices <- create_vs(graph, res$vertices)
  }
  if (igraph_opt("return.vs.es")) {
    res$edges <- create_es(graph, res$edges)
  }
  res
}

get_shortest_path_dijkstra_impl <- function(graph, from, to, weights=NULL, mode=c("out", "in", "all", "total")) {
  # Argument checks
  ensure_igraph(graph)
  from <- as_igraph_vs(graph, from)
  if (length(from) == 0) {
    stop("No vertex was specified")
  }
  to <- as_igraph_vs(graph, to)
  if (length(to) == 0) {
    stop("No vertex was specified")
  }
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_get_shortest_path_dijkstra, graph, from-1, to-1, weights, mode)
  if (igraph_opt("return.vs.es")) {
    res$vertices <- create_vs(graph, res$vertices)
  }
  if (igraph_opt("return.vs.es")) {
    res$edges <- create_es(graph, res$edges)
  }
  res
}

get_all_shortest_paths_impl <- function(graph, from, to, mode=c("out", "in", "all", "total")) {
  # Argument checks
  ensure_igraph(graph)
  from <- as_igraph_vs(graph, from)
  if (length(from) == 0) {
    stop("No vertex was specified")
  }
  to <- as_igraph_vs(graph, to)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_get_all_shortest_paths, graph, from-1, to-1, mode)
  if (igraph_opt("return.vs.es")) {
    res$vpaths <- lapply(res$vpaths, unsafe_create_vs, graph = graph, verts = V(graph))
  }
  if (igraph_opt("return.vs.es")) {
    res$epaths <- lapply(res$epaths, unsafe_create_es, graph = graph, es = E(graph))
  }
  res
}

get_all_shortest_paths_dijkstra_impl <- function(graph, from, to=V(graph), weights=NULL, mode=c("out", "in", "all", "total")) {
  # Argument checks
  ensure_igraph(graph)
  from <- as_igraph_vs(graph, from)
  if (length(from) == 0) {
    stop("No vertex was specified")
  }
  to <- as_igraph_vs(graph, to)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_get_all_shortest_paths_dijkstra, graph, from-1, to-1, weights, mode)
  if (igraph_opt("return.vs.es")) {
    res$vpaths <- lapply(res$vpaths, unsafe_create_vs, graph = graph, verts = V(graph))
  }
  if (igraph_opt("return.vs.es")) {
    res$epaths <- lapply(res$epaths, unsafe_create_es, graph = graph, es = E(graph))
  }
  res
}

voronoi_impl <- function(graph, generators, ..., weights=NULL, mode=c("out", "in", "all", "total"), tiebreaker=c("random", "first", "last")) {
  # Argument checks
  check_dots_empty()
  ensure_igraph(graph)
  generators <- as_igraph_vs(graph, generators)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)
  tiebreaker <- switch(igraph.match.arg(tiebreaker), "first"=0L, "last"=1L, "random"=2L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_voronoi, graph, generators-1, weights, mode, tiebreaker)

  res
}

get_all_simple_paths_impl <- function(graph, from, to=V(graph), cutoff=-1, mode=c("out", "in", "all", "total")) {
  # Argument checks
  ensure_igraph(graph)
  from <- as_igraph_vs(graph, from)
  if (length(from) == 0) {
    stop("No vertex was specified")
  }
  to <- as_igraph_vs(graph, to)
  cutoff <- as.numeric(cutoff)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_get_all_simple_paths, graph, from-1, to-1, cutoff, mode)
  if (igraph_opt("return.vs.es")) {
    res <- create_vs(graph, res)
  }
  res
}

get_k_shortest_paths_impl <- function(graph, from, to, ..., k, weights=NULL, mode=c("out", "in", "all", "total")) {
  # Argument checks
  check_dots_empty()
  ensure_igraph(graph)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  k <- as.numeric(k)
  from <- as_igraph_vs(graph, from)
  if (length(from) == 0) {
    stop("No vertex was specified")
  }
  to <- as_igraph_vs(graph, to)
  if (length(to) == 0) {
    stop("No vertex was specified")
  }
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_get_k_shortest_paths, graph, weights, k, from-1, to-1, mode)
  if (igraph_opt("return.vs.es")) {
    res$vpaths <- lapply(res$vpaths, unsafe_create_vs, graph = graph, verts = V(graph))
  }
  if (igraph_opt("return.vs.es")) {
    res$epaths <- lapply(res$epaths, unsafe_create_es, graph = graph, es = E(graph))
  }
  res
}

get_widest_path_impl <- function(graph, from, to, weights=NULL, mode=c("out", "in", "all", "total")) {
  # Argument checks
  ensure_igraph(graph)
  from <- as_igraph_vs(graph, from)
  if (length(from) == 0) {
    stop("No vertex was specified")
  }
  to <- as_igraph_vs(graph, to)
  if (length(to) == 0) {
    stop("No vertex was specified")
  }
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_get_widest_path, graph, from-1, to-1, weights, mode)
  if (igraph_opt("return.vs.es")) {
    res$vertices <- create_vs(graph, res$vertices)
  }
  if (igraph_opt("return.vs.es")) {
    res$edges <- create_es(graph, res$edges)
  }
  res
}

get_widest_paths_impl <- function(graph, from, to=V(graph), weights=NULL, mode=c("out", "in", "all", "total")) {
  # Argument checks
  ensure_igraph(graph)
  from <- as_igraph_vs(graph, from)
  if (length(from) == 0) {
    stop("No vertex was specified")
  }
  to <- as_igraph_vs(graph, to)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_get_widest_paths, graph, from-1, to-1, weights, mode)
  if (igraph_opt("return.vs.es")) {
    res$vertices <- lapply(res$vertices, unsafe_create_vs, graph = graph, verts = V(graph))
  }
  if (igraph_opt("return.vs.es")) {
    res$edges <- lapply(res$edges, unsafe_create_es, graph = graph, es = E(graph))
  }
  res
}

widest_path_widths_dijkstra_impl <- function(graph, from=V(graph), to=V(graph), weights=NULL, mode=c("out", "in", "all", "total")) {
  # Argument checks
  ensure_igraph(graph)
  from <- as_igraph_vs(graph, from)
  to <- as_igraph_vs(graph, to)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_widest_path_widths_dijkstra, graph, from-1, to-1, weights, mode)

  res
}

widest_path_widths_floyd_warshall_impl <- function(graph, from=V(graph), to=V(graph), weights=NULL, mode=c("out", "in", "all", "total")) {
  # Argument checks
  ensure_igraph(graph)
  from <- as_igraph_vs(graph, from)
  to <- as_igraph_vs(graph, to)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_widest_path_widths_floyd_warshall, graph, from-1, to-1, weights, mode)

  res
}

spanner_impl <- function(graph, stretch, weights=NULL) {
  # Argument checks
  ensure_igraph(graph)
  stretch <- as.numeric(stretch)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_spanner, graph, stretch, weights)
  if (igraph_opt("return.vs.es")) {
    res <- create_es(graph, res)
  }
  res
}

betweenness_cutoff_impl <- function(graph, vids=V(graph), directed=TRUE, weights=NULL, cutoff=-1) {
  # Argument checks
  ensure_igraph(graph)
  vids <- as_igraph_vs(graph, vids)
  directed <- as.logical(directed)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  cutoff <- as.numeric(cutoff)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_betweenness_cutoff, graph, vids-1, directed, weights, cutoff)
  if (igraph_opt("add.vertex.names") && is_named(graph)) {
    names(res) <- vertex_attr(graph, "name", vids)
  }
  res
}

betweenness_subset_impl <- function(graph, vids=V(graph), directed=TRUE, sources=V(graph), targets=V(graph), weights=NULL) {
  # Argument checks
  ensure_igraph(graph)
  vids <- as_igraph_vs(graph, vids)
  directed <- as.logical(directed)
  sources <- as_igraph_vs(graph, sources)
  targets <- as_igraph_vs(graph, targets)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_betweenness_subset, graph, vids-1, directed, sources-1, targets-1, weights)
  if (igraph_opt("add.vertex.names") && is_named(graph)) {
    names(res) <- vertex_attr(graph, "name", vids)
  }
  res
}

edge_betweenness_impl <- function(graph, directed=TRUE, weights=NULL) {
  # Argument checks
  ensure_igraph(graph)
  directed <- as.logical(directed)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_edge_betweenness, graph, directed, weights)

  res
}

edge_betweenness_cutoff_impl <- function(graph, directed=TRUE, weights=NULL, cutoff=-1) {
  # Argument checks
  ensure_igraph(graph)
  directed <- as.logical(directed)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  cutoff <- as.numeric(cutoff)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_edge_betweenness_cutoff, graph, directed, weights, cutoff)

  res
}

edge_betweenness_subset_impl <- function(graph, eids=E(graph), directed=TRUE, sources=V(graph), targets=V(graph), weights=NULL) {
  # Argument checks
  ensure_igraph(graph)
  eids <- as_igraph_es(graph, eids)
  directed <- as.logical(directed)
  sources <- as_igraph_vs(graph, sources)
  targets <- as_igraph_vs(graph, targets)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_edge_betweenness_subset, graph, eids-1, directed, sources-1, targets-1, weights)

  res
}

harmonic_centrality_cutoff_impl <- function(graph, vids=V(graph), mode=c("out", "in", "all", "total"), weights=NULL, normalized=FALSE, cutoff=-1) {
  # Argument checks
  ensure_igraph(graph)
  vids <- as_igraph_vs(graph, vids)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  normalized <- as.logical(normalized)
  cutoff <- as.numeric(cutoff)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_harmonic_centrality_cutoff, graph, vids-1, mode, weights, normalized, cutoff)
  if (igraph_opt("add.vertex.names") && is_named(graph)) {
    names(res) <- vertex_attr(graph, "name", vids)
  }
  res
}

personalized_pagerank_impl <- function(graph, algo=c("prpack", "arpack"), vids=V(graph), directed=TRUE, damping=0.85, personalized=NULL, weights=NULL, options=NULL) {
  # Argument checks
  ensure_igraph(graph)
  algo <- switch(igraph.match.arg(algo), "arpack"=1L, "prpack"=2L)
  vids <- as_igraph_vs(graph, vids)
  directed <- as.logical(directed)
  damping <- as.numeric(damping)
  if (!is.null(personalized)) personalized <- as.numeric(personalized)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  if (is.null(options)) {
    if (algo == 0L) {
      options <- list(niter=1000, eps=0.001)
    } else if (algo == 1L) {
      options <- arpack_defaults()
    } else {
      options <- NULL
    }
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_personalized_pagerank, graph, algo, vids-1, directed, damping, personalized, weights, options)
  if (igraph_opt("add.vertex.names") && is_named(graph)) {
    names(res$vector) <- vertex_attr(graph, "name", vids)
  }
  res
}

personalized_pagerank_vs_impl <- function(graph, algo=c("prpack", "arpack"), vids=V(graph), directed=TRUE, damping=0.85, reset.vids, weights=NULL, options=NULL, details=FALSE) {
  # Argument checks
  ensure_igraph(graph)
  algo <- switch(igraph.match.arg(algo), "arpack"=1L, "prpack"=2L)
  vids <- as_igraph_vs(graph, vids)
  directed <- as.logical(directed)
  damping <- as.numeric(damping)
  reset.vids <- as_igraph_vs(graph, reset.vids)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  if (is.null(options)) {
    if (algo == 0L) {
      options <- list(niter=1000, eps=0.001)
    } else if (algo == 1L) {
      options <- arpack_defaults()
    } else {
      options <- NULL
    }
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_personalized_pagerank_vs, graph, algo, vids-1, directed, damping, reset.vids-1, weights, options)
  if (igraph_opt("add.vertex.names") && is_named(graph)) {
    names(res$vector) <- vertex_attr(graph, "name", vids)
  }
  if (!details) {
    res <- res$vector
  }
  res
}

induced_subgraph_impl <- function(graph, vids, impl=c("auto", "copy_and_delete", "create_from_scratch")) {
  # Argument checks
  ensure_igraph(graph)
  vids <- as_igraph_vs(graph, vids)
  impl <- switch(igraph.match.arg(impl), "auto"=0L, "copy_and_delete"=1L, "create_from_scratch"=2L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_induced_subgraph, graph, vids-1, impl)

  res
}

subgraph_from_edges_impl <- function(graph, eids, delete.vertices=TRUE) {
  # Argument checks
  ensure_igraph(graph)
  eids <- as_igraph_es(graph, eids)
  delete.vertices <- as.logical(delete.vertices)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_subgraph_from_edges, graph, eids-1, delete.vertices)

  res
}

reverse_edges_impl <- function(graph, eids=E(graph)) {
  # Argument checks
  ensure_igraph(graph)
  eids <- as_igraph_es(graph, eids)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_reverse_edges, graph, eids-1)

  res
}

average_path_length_dijkstra_impl <- function(graph, weights=NULL, directed=TRUE, unconnected=TRUE, details=FALSE) {
  # Argument checks
  ensure_igraph(graph)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  directed <- as.logical(directed)
  unconnected <- as.logical(unconnected)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_average_path_length_dijkstra, graph, weights, directed, unconnected)
  if (!details) {
    res <- res$res
  }
  res
}

path_length_hist_impl <- function(graph, directed=TRUE) {
  # Argument checks
  ensure_igraph(graph)
  directed <- as.logical(directed)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_path_length_hist, graph, directed)

  res
}

simplify_impl <- function(graph, remove.multiple=TRUE, remove.loops=TRUE, edge.attr.comb=igraph_opt("edge.attr.comb")) {
  # Argument checks
  ensure_igraph(graph)
  remove.multiple <- as.logical(remove.multiple)
  remove.loops <- as.logical(remove.loops)
  edge.attr.comb <- igraph.i.attribute.combination(edge.attr.comb)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_simplify, graph, remove.multiple, remove.loops, edge.attr.comb)

  res
}

transitivity_undirected_impl <- function(graph, mode=c("nan", "zero")) {
  # Argument checks
  ensure_igraph(graph)
  mode <- switch(igraph.match.arg(mode), "nan"=0L, "zero"=1L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_transitivity_undirected, graph, mode)

  res
}

transitivity_local_undirected_impl <- function(graph, vids=V(graph), mode=c("nan", "zero")) {
  # Argument checks
  ensure_igraph(graph)
  vids <- as_igraph_vs(graph, vids)
  mode <- switch(igraph.match.arg(mode), "nan"=0L, "zero"=1L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_transitivity_local_undirected, graph, vids-1, mode)

  res
}

transitivity_avglocal_undirected_impl <- function(graph, mode=c("nan", "zero")) {
  # Argument checks
  ensure_igraph(graph)
  mode <- switch(igraph.match.arg(mode), "nan"=0L, "zero"=1L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_transitivity_avglocal_undirected, graph, mode)

  res
}

transitivity_barrat_impl <- function(graph, vids=V(graph), weights=NULL, mode=c("nan", "zero")) {
  # Argument checks
  ensure_igraph(graph)
  vids <- as_igraph_vs(graph, vids)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  mode <- switch(igraph.match.arg(mode), "nan"=0L, "zero"=1L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_transitivity_barrat, graph, vids-1, weights, mode)

  res
}

ecc_impl <- function(graph, eids=E(graph), k=3, offset=FALSE, normalize=TRUE) {
  # Argument checks
  ensure_igraph(graph)
  eids <- as_igraph_es(graph, eids)
  k <- as.numeric(k)
  offset <- as.logical(offset)
  normalize <- as.logical(normalize)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_ecc, graph, eids-1, k, offset, normalize)

  res
}

reciprocity_impl <- function(graph, ignore.loops=TRUE, mode=c("default", "ratio")) {
  # Argument checks
  ensure_igraph(graph)
  ignore.loops <- as.logical(ignore.loops)
  mode <- switch(igraph.match.arg(mode), "default"=0L, "ratio"=1L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_reciprocity, graph, ignore.loops, mode)

  res
}

maxdegree_impl <- function(graph, ..., v=V(graph), mode=c("all", "out", "in", "total"), loops=TRUE) {
  # Argument checks
  check_dots_empty()
  ensure_igraph(graph)
  v <- as_igraph_vs(graph, v)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)
  loops <- as.logical(loops)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_maxdegree, graph, v-1, mode, loops)

  res
}

density_impl <- function(graph, loops=FALSE) {
  # Argument checks
  ensure_igraph(graph)
  loops <- as.logical(loops)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_density, graph, loops)

  res
}

mean_degree_impl <- function(graph, loops=TRUE) {
  # Argument checks
  ensure_igraph(graph)
  loops <- as.logical(loops)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_mean_degree, graph, loops)

  res
}

feedback_arc_set_impl <- function(graph, weights=NULL, algo=c("approx_eades", "exact_ip")) {
  # Argument checks
  ensure_igraph(graph)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  algo <- switch(igraph.match.arg(algo), "exact_ip"=0L, "approx_eades"=1L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_feedback_arc_set, graph, weights, algo)
  if (igraph_opt("return.vs.es")) {
    res <- create_es(graph, res)
  }
  res
}

feedback_vertex_set_impl <- function(graph, weights=NULL, algo=c("exact_ip")) {
  # Argument checks
  ensure_igraph(graph)
  if (is.null(weights) && "weight" %in% vertex_attr_names(graph)) {
    weights <- V(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  algo <- switch(igraph.match.arg(algo), "exact_ip"=0L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_feedback_vertex_set, graph, weights, algo)
  if (igraph_opt("return.vs.es")) {
    res <- create_vs(graph, res)
  }
  res
}

is_loop_impl <- function(graph, eids=E(graph)) {
  # Argument checks
  ensure_igraph(graph)
  eids <- as_igraph_es(graph, eids)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_is_loop, graph, eids-1)

  res
}

is_dag_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_is_dag, graph)

  res
}

is_acyclic_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_is_acyclic, graph)

  res
}

is_simple_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_is_simple, graph)

  res
}

is_multiple_impl <- function(graph, eids=E(graph)) {
  # Argument checks
  ensure_igraph(graph)
  eids <- as_igraph_es(graph, eids)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_is_multiple, graph, eids-1)

  res
}

has_loop_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_has_loop, graph)

  res
}

has_multiple_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_has_multiple, graph)

  res
}

count_loops_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_count_loops, graph)

  res
}

count_multiple_impl <- function(graph, eids=E(graph)) {
  # Argument checks
  ensure_igraph(graph)
  eids <- as_igraph_es(graph, eids)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_count_multiple, graph, eids-1)

  res
}

is_perfect_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_is_perfect, graph)

  res
}

eigenvector_centrality_impl <- function(graph, directed=FALSE, scale=TRUE, weights=NULL, options=arpack_defaults()) {
  # Argument checks
  ensure_igraph(graph)
  directed <- as.logical(directed)
  scale <- as.logical(scale)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  options <- modify_list(arpack_defaults(), options)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_eigenvector_centrality, graph, directed, scale, weights, options)
  if (igraph_opt("add.vertex.names") && is_named(graph)) {
    names(res$vector) <- vertex_attr(graph, "name", V(graph))
  }
  res
}

hub_and_authority_scores_impl <- function(graph, scale=TRUE, weights=NULL, options=arpack_defaults()) {
  # Argument checks
  ensure_igraph(graph)
  scale <- as.logical(scale)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  options <- modify_list(arpack_defaults(), options)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_hub_and_authority_scores, graph, scale, weights, options)
  if (igraph_opt("add.vertex.names") && is_named(graph)) {
    names(res$hub) <- vertex_attr(graph, "name", V(graph))
  }
  if (igraph_opt("add.vertex.names") && is_named(graph)) {
    names(res$authority) <- vertex_attr(graph, "name", V(graph))
  }
  res
}

unfold_tree_impl <- function(graph, mode=c("all", "out", "in", "total"), roots) {
  # Argument checks
  ensure_igraph(graph)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)
  roots <- as.numeric(roots)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_unfold_tree, graph, mode, roots)

  res
}

is_mutual_impl <- function(graph, eids=E(graph), loops=TRUE) {
  # Argument checks
  ensure_igraph(graph)
  eids <- as_igraph_es(graph, eids)
  loops <- as.logical(loops)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_is_mutual, graph, eids-1, loops)

  res
}

has_mutual_impl <- function(graph, loops=TRUE) {
  # Argument checks
  ensure_igraph(graph)
  loops <- as.logical(loops)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_has_mutual, graph, loops)

  res
}

maximum_cardinality_search_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_maximum_cardinality_search, graph)
  if (igraph_opt("return.vs.es")) {
    res$alpham1 <- create_vs(graph, res$alpham1)
  }
  res
}

avg_nearest_neighbor_degree_impl <- function(graph, vids=V(graph), mode=c("all", "out", "in", "total"), neighbor.degree.mode=c("all", "out", "in", "total"), weights=NULL) {
  # Argument checks
  ensure_igraph(graph)
  vids <- as_igraph_vs(graph, vids)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)
  neighbor.degree.mode <- switch(igraph.match.arg(neighbor.degree.mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_avg_nearest_neighbor_degree, graph, vids-1, mode, neighbor.degree.mode, weights)
  if (igraph_opt("add.vertex.names") && is_named(graph)) {
    names(res$knn) <- vertex_attr(graph, "name", vids)
  }
  res
}

degree_correlation_vector_impl <- function(graph, weights=NULL, from.mode=c("out", "in", "all", "total"), to.mode=c("in", "out", "all", "total"), directed.neighbors=TRUE) {
  # Argument checks
  ensure_igraph(graph)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  from.mode <- switch(igraph.match.arg(from.mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)
  to.mode <- switch(igraph.match.arg(to.mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)
  directed.neighbors <- as.logical(directed.neighbors)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_degree_correlation_vector, graph, weights, from.mode, to.mode, directed.neighbors)

  res
}

rich_club_sequence_impl <- function(graph, weights=NULL, vertex.order, normalized=TRUE, loops=FALSE, directed=TRUE) {
  # Argument checks
  ensure_igraph(graph)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  vertex.order <- as.numeric(vertex.order)-1
  normalized <- as.logical(normalized)
  loops <- as.logical(loops)
  directed <- as.logical(directed)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_rich_club_sequence, graph, weights, vertex.order, normalized, loops, directed)

  res
}

strength_impl <- function(graph, vids=V(graph), mode=c("all", "out", "in", "total"), loops=TRUE, weights=NULL) {
  # Argument checks
  ensure_igraph(graph)
  vids <- as_igraph_vs(graph, vids)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)
  loops <- as.logical(loops)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_strength, graph, vids-1, mode, loops, weights)
  if (igraph_opt("add.vertex.names") && is_named(graph)) {
    names(res) <- vertex_attr(graph, "name", vids)
  }
  res
}

centralization_impl <- function(scores, theoretical.max=0, normalized=TRUE) {
  # Argument checks
  scores <- as.numeric(scores)
  theoretical.max <- as.numeric(theoretical.max)
  normalized <- as.logical(normalized)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_centralization, scores, theoretical.max, normalized)


  res
}

centralization_degree_impl <- function(graph, mode=c("all", "out", "in", "total"), loops=TRUE, normalized=TRUE) {
  # Argument checks
  ensure_igraph(graph)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)
  loops <- as.logical(loops)
  normalized <- as.logical(normalized)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_centralization_degree, graph, mode, loops, normalized)

  res
}

centralization_degree_tmax_impl <- function(graph=NULL, nodes=0, mode=c("all", "out", "in", "total"), loops) {
  # Argument checks
  if (!is.null(graph)) ensure_igraph(graph)
  nodes <- as.numeric(nodes)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)
  loops <- as.logical(loops)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_centralization_degree_tmax, graph, nodes, mode, loops)

  res
}

centralization_betweenness_impl <- function(graph, directed=TRUE, normalized=TRUE) {
  # Argument checks
  ensure_igraph(graph)
  directed <- as.logical(directed)
  normalized <- as.logical(normalized)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_centralization_betweenness, graph, directed, normalized)

  res
}

centralization_betweenness_tmax_impl <- function(graph=NULL, nodes=0, directed=TRUE) {
  # Argument checks
  if (!is.null(graph)) ensure_igraph(graph)
  nodes <- as.numeric(nodes)
  directed <- as.logical(directed)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_centralization_betweenness_tmax, graph, nodes, directed)

  res
}

centralization_closeness_impl <- function(graph, mode=c("out", "in", "all", "total"), normalized=TRUE) {
  # Argument checks
  ensure_igraph(graph)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)
  normalized <- as.logical(normalized)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_centralization_closeness, graph, mode, normalized)

  res
}

centralization_closeness_tmax_impl <- function(graph=NULL, nodes=0, mode=c("out", "in", "all", "total")) {
  # Argument checks
  if (!is.null(graph)) ensure_igraph(graph)
  nodes <- as.numeric(nodes)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_centralization_closeness_tmax, graph, nodes, mode)

  res
}

centralization_eigenvector_centrality_impl <- function(graph, directed=FALSE, scale=TRUE, options=arpack_defaults(), normalized=TRUE) {
  # Argument checks
  ensure_igraph(graph)
  directed <- as.logical(directed)
  scale <- as.logical(scale)
  options <- modify_list(arpack_defaults(), options)
  normalized <- as.logical(normalized)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_centralization_eigenvector_centrality, graph, directed, scale, options, normalized)

  res
}

centralization_eigenvector_centrality_tmax_impl <- function(graph=NULL, nodes=0, directed=FALSE, scale=TRUE) {
  # Argument checks
  if (!is.null(graph)) ensure_igraph(graph)
  nodes <- as.numeric(nodes)
  directed <- as.logical(directed)
  scale <- as.logical(scale)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_centralization_eigenvector_centrality_tmax, graph, nodes, directed, scale)

  res
}

assortativity_nominal_impl <- function(graph, types, directed=TRUE, normalized=TRUE) {
  # Argument checks
  ensure_igraph(graph)
  types <- as.numeric(types)-1
  directed <- as.logical(directed)
  normalized <- as.logical(normalized)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_assortativity_nominal, graph, types, directed, normalized)

  res
}

assortativity_impl <- function(graph, values, values.in=NULL, directed=TRUE, normalized=TRUE) {
  # Argument checks
  ensure_igraph(graph)
  values <- as.numeric(values)
  if (!is.null(values.in)) values.in <- as.numeric(values.in)
  directed <- as.logical(directed)
  normalized <- as.logical(normalized)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_assortativity, graph, values, values.in, directed, normalized)

  res
}

assortativity_degree_impl <- function(graph, directed=TRUE) {
  # Argument checks
  ensure_igraph(graph)
  directed <- as.logical(directed)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_assortativity_degree, graph, directed)

  res
}

joint_degree_matrix_impl <- function(graph, weights=NULL, max.out.degree=-1, max.in.degree=-1) {
  # Argument checks
  ensure_igraph(graph)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  max.out.degree <- as.numeric(max.out.degree)
  max.in.degree <- as.numeric(max.in.degree)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_joint_degree_matrix, graph, weights, max.out.degree, max.in.degree)

  res
}

joint_degree_distribution_impl <- function(graph, weights=NULL, from.mode=c("out", "in", "all", "total"), to.mode=c("in", "out", "all", "total"), directed.neighbors=TRUE, normalized=TRUE, max.from.degree=-1, max.to.degree=-1) {
  # Argument checks
  ensure_igraph(graph)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  from.mode <- switch(igraph.match.arg(from.mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)
  to.mode <- switch(igraph.match.arg(to.mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)
  directed.neighbors <- as.logical(directed.neighbors)
  normalized <- as.logical(normalized)
  max.from.degree <- as.numeric(max.from.degree)
  max.to.degree <- as.numeric(max.to.degree)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_joint_degree_distribution, graph, weights, from.mode, to.mode, directed.neighbors, normalized, max.from.degree, max.to.degree)

  res
}

joint_type_distribution_impl <- function(graph, weights=NULL, from.types, to.types=NULL, directed=TRUE, normalized=TRUE) {
  # Argument checks
  ensure_igraph(graph)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  from.types <- as.numeric(from.types)-1
  if (!is.null(to.types)) to.types <- as.numeric(to.types)-1
  directed <- as.logical(directed)
  normalized <- as.logical(normalized)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_joint_type_distribution, graph, weights, from.types, to.types, directed, normalized)

  res
}

contract_vertices_impl <- function(graph, mapping, vertex.attr.comb=igraph_opt("vertex.attr.comb")) {
  # Argument checks
  ensure_igraph(graph)
  mapping <- as.numeric(mapping)-1
  vertex.attr.comb <- igraph.i.attribute.combination(vertex.attr.comb)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_contract_vertices, graph, mapping, vertex.attr.comb)

  res
}

eccentricity_dijkstra_impl <- function(graph, vids=V(graph), ..., weights=NULL, mode=c("all", "out", "in", "total")) {
  # Argument checks
  check_dots_empty()
  ensure_igraph(graph)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  vids <- as_igraph_vs(graph, vids)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_eccentricity_dijkstra, graph, weights, vids-1, mode)
  if (igraph_opt("add.vertex.names") && is_named(graph)) {
    names(res) <- vertex_attr(graph, "name", vids)
  }
  res
}

graph_center_dijkstra_impl <- function(graph, ..., weights=NULL, mode=c("all", "out", "in", "total")) {
  # Argument checks
  check_dots_empty()
  ensure_igraph(graph)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_graph_center_dijkstra, graph, weights, mode)
  if (igraph_opt("return.vs.es")) {
    res <- create_vs(graph, res)
  }
  res
}

radius_dijkstra_impl <- function(graph, ..., weights=NULL, mode=c("all", "out", "in", "total")) {
  # Argument checks
  check_dots_empty()
  ensure_igraph(graph)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_radius_dijkstra, graph, weights, mode)

  res
}

pseudo_diameter_impl <- function(graph, start.vid, directed=TRUE, unconnected=TRUE) {
  # Argument checks
  ensure_igraph(graph)
  start.vid <- as_igraph_vs(graph, start.vid)
  if (length(start.vid) == 0) {
    stop("No vertex was specified")
  }
  directed <- as.logical(directed)
  unconnected <- as.logical(unconnected)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_pseudo_diameter, graph, start.vid-1, directed, unconnected)

  res
}

pseudo_diameter_dijkstra_impl <- function(graph, weights=NULL, start.vid, directed=TRUE, unconnected=TRUE) {
  # Argument checks
  ensure_igraph(graph)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  start.vid <- as_igraph_vs(graph, start.vid)
  if (length(start.vid) == 0) {
    stop("No vertex was specified")
  }
  directed <- as.logical(directed)
  unconnected <- as.logical(unconnected)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_pseudo_diameter_dijkstra, graph, weights, start.vid-1, directed, unconnected)

  res
}

diversity_impl <- function(graph, weights=NULL, vids=V(graph)) {
  # Argument checks
  ensure_igraph(graph)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  vids <- as_igraph_vs(graph, vids)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_diversity, graph, weights, vids-1)
  if (igraph_opt("add.vertex.names") && is_named(graph)) {
    names(res) <- vertex_attr(graph, "name", vids)
  }
  res
}

random_walk_impl <- function(graph, start, steps, weights=NULL, mode=c("out", "in", "all", "total"), stuck=c("return", "error")) {
  # Argument checks
  ensure_igraph(graph)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  start <- as_igraph_vs(graph, start)
  if (length(start) == 0) {
    stop("No vertex was specified")
  }
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)
  steps <- as.numeric(steps)
  stuck <- switch(igraph.match.arg(stuck), "error" = 0L, "return" = 1L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_random_walk, graph, weights, start-1, mode, steps, stuck)
  if (igraph_opt("return.vs.es")) {
    res$vertices <- create_vs(graph, res$vertices)
  }
  if (igraph_opt("return.vs.es")) {
    res$edges <- create_es(graph, res$edges)
  }
  res
}

global_efficiency_impl <- function(graph, weights=NULL, directed=TRUE) {
  # Argument checks
  ensure_igraph(graph)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  directed <- as.logical(directed)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_global_efficiency, graph, weights, directed)

  res
}

local_efficiency_impl <- function(graph, vids=V(graph), weights=NULL, directed=TRUE, mode=c("all", "out", "in", "total")) {
  # Argument checks
  ensure_igraph(graph)
  vids <- as_igraph_vs(graph, vids)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  directed <- as.logical(directed)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_local_efficiency, graph, vids-1, weights, directed, mode)
  if (igraph_opt("add.vertex.names") && is_named(graph)) {
    names(res) <- vertex_attr(graph, "name", vids)
  }
  res
}

average_local_efficiency_impl <- function(graph, weights=NULL, directed=TRUE, mode=c("all", "out", "in", "total")) {
  # Argument checks
  ensure_igraph(graph)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  directed <- as.logical(directed)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_average_local_efficiency, graph, weights, directed, mode)

  res
}

transitive_closure_dag_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_transitive_closure_dag, graph)

  res
}

transitive_closure_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_transitive_closure, graph)

  res
}

trussness_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_trussness, graph)

  res
}

is_graphical_impl <- function(out.deg, in.deg=NULL, allowed.edge.types=c("simple", "loops", "multi", "all")) {
  # Argument checks
  out.deg <- as.numeric(out.deg)
  if (!is.null(in.deg)) in.deg <- as.numeric(in.deg)
  allowed.edge.types <- switch(igraph.match.arg(allowed.edge.types),
    "simple"=0L, "loop"=1L, "loops"=1L, "multi"=6L, "multiple"=6L, "all"=7L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_is_graphical, out.deg, in.deg, allowed.edge.types)

  res
}

bfs_simple_impl <- function(graph, root, mode=c("out", "in", "all", "total")) {
  # Argument checks
  ensure_igraph(graph)
  root <- as_igraph_vs(graph, root)
  if (length(root) == 0) {
    stop("No vertex was specified")
  }
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_bfs_simple, graph, root-1, mode)
  if (igraph_opt("return.vs.es")) {
    res$order <- create_vs(graph, res$order)
  }
  res
}

bipartite_projection_size_impl <- function(graph, types=NULL) {
  # Argument checks
  ensure_igraph(graph)
  types <- handle_vertex_type_arg(types, graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_bipartite_projection_size, graph, types)

  res
}

biadjacency_impl <- function(incidence, directed=FALSE, mode=c("all", "out", "in", "total"), multiple=FALSE) {
  # Argument checks
  incidence[] <- as.numeric(incidence)
  directed <- as.logical(directed)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)
  multiple <- as.logical(multiple)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_biadjacency, incidence, directed, mode, multiple)
  if (igraph_opt("add.vertex.names") && is_named(res$graph)) {
    names(res$types) <- vertex_attr(res$graph, "name", V(res$graph))
  }
  res
}

get_biadjacency_impl <- function(graph, types) {
  # Argument checks
  ensure_igraph(graph)
  types <- handle_vertex_type_arg(types, graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_get_biadjacency, graph, types)

  res
}

is_bipartite_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_is_bipartite, graph)
  if (igraph_opt("add.vertex.names") && is_named(graph)) {
    names(res$type) <- vertex_attr(graph, "name", V(graph))
  }
  res
}

bipartite_game_gnp_impl <- function(n1, n2, p, directed=FALSE, mode=c("all", "out", "in", "total")) {
  # Argument checks
  n1 <- as.numeric(n1)
  n2 <- as.numeric(n2)
  p <- as.numeric(p)
  directed <- as.logical(directed)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_bipartite_game_gnp, n1, n2, p, directed, mode)

  res
}

bipartite_game_gnm_impl <- function(n1, n2, m, directed=FALSE, mode=c("all", "out", "in", "total")) {
  # Argument checks
  n1 <- as.numeric(n1)
  n2 <- as.numeric(n2)
  m <- as.numeric(m)
  directed <- as.logical(directed)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_bipartite_game_gnm, n1, n2, m, directed, mode)

  res
}

get_laplacian_impl <- function(graph, mode=c("out", "in", "all", "total"), normalization=c("unnormalized", "symmetric", "left", "right"), weights=NULL) {
  # Argument checks
  ensure_igraph(graph)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)
  normalization <- switch(igraph.match.arg(normalization), "unnormalized"=0L, "symmetric"=1L, "left"=2L, "right"=3L)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_get_laplacian, graph, mode, normalization, weights)

  res
}

get_laplacian_sparse_impl <- function(graph, mode=c("out", "in", "all", "total"), normalization=c("unnormalized", "symmetric", "left", "right"), weights=NULL) {
  # Argument checks
  ensure_igraph(graph)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)
  normalization <- switch(igraph.match.arg(normalization), "unnormalized"=0L, "symmetric"=1L, "left"=2L, "right"=3L)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_get_laplacian_sparse, graph, mode, normalization, weights)

  res
}

connected_components_impl <- function(graph, mode=c("weak", "strong"), details=FALSE) {
  # Argument checks
  ensure_igraph(graph)
  mode <- switch(igraph.match.arg(mode), "weak"=1L, "strong"=2L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_connected_components, graph, mode)
  if (!details) {
    res <- res$membership
  }
  res
}

is_connected_impl <- function(graph, mode=c("weak", "strong")) {
  # Argument checks
  ensure_igraph(graph)
  mode <- switch(igraph.match.arg(mode), "weak"=1L, "strong"=2L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_is_connected, graph, mode)

  res
}

articulation_points_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_articulation_points, graph)
  if (igraph_opt("return.vs.es")) {
    res <- create_vs(graph, res)
  }
  res
}

biconnected_components_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_biconnected_components, graph)
  if (igraph_opt("return.vs.es")) {
    res$tree.edges <- lapply(res$tree.edges, unsafe_create_es, graph = graph, es = E(graph))
  }
  if (igraph_opt("return.vs.es")) {
    res$component.edges <- lapply(res$component.edges, unsafe_create_es, graph = graph, es = E(graph))
  }
  if (igraph_opt("return.vs.es")) {
    res$components <- lapply(res$components, unsafe_create_vs, graph = graph, verts = V(graph))
  }
  if (igraph_opt("return.vs.es")) {
    res$articulation.points <- create_vs(graph, res$articulation.points)
  }
  res
}

bridges_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_bridges, graph)
  if (igraph_opt("return.vs.es")) {
    res <- create_es(graph, res)
  }
  res
}

is_biconnected_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_is_biconnected, graph)

  res
}

count_reachable_impl <- function(graph, mode=c("out", "in", "all", "total")) {
  # Argument checks
  ensure_igraph(graph)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_count_reachable, graph, mode)

  res
}

bond_percolation_impl <- function(graph, edge.order=NULL) {
  # Argument checks
  ensure_igraph(graph)
  if (!is.null(edge.order)) edge.order <- as_igraph_es(graph, edge.order)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_bond_percolation, graph, edge.order-1)

  res
}

site_percolation_impl <- function(graph, vertex.order=NULL) {
  # Argument checks
  ensure_igraph(graph)
  if (!is.null(vertex.order)) vertex.order <- as_igraph_vs(graph, vertex.order)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_site_percolation, graph, vertex.order-1)

  res
}

edgelist_percolation_impl <- function(edges) {
  # Argument checks


  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_edgelist_percolation, edges)

  res
}

is_clique_impl <- function(graph, candidate, directed=FALSE) {
  # Argument checks
  ensure_igraph(graph)
  candidate <- as_igraph_vs(graph, candidate)
  directed <- as.logical(directed)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_is_clique, graph, candidate-1, directed)

  res
}

cliques_impl <- function(graph, min=0, max=0) {
  # Argument checks
  ensure_igraph(graph)
  min <- as.numeric(min)
  max <- as.numeric(max)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_cliques, graph, min, max)
  if (igraph_opt("return.vs.es")) {
    res <- lapply(res, unsafe_create_vs, graph = graph, verts = V(graph))
  }
  res
}

clique_size_hist_impl <- function(graph, min.size=0, max.size=0) {
  # Argument checks
  ensure_igraph(graph)
  min.size <- as.numeric(min.size)
  max.size <- as.numeric(max.size)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_clique_size_hist, graph, min.size, max.size)

  res
}

largest_cliques_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_largest_cliques, graph)
  if (igraph_opt("return.vs.es")) {
    res <- lapply(res, unsafe_create_vs, graph = graph, verts = V(graph))
  }
  res
}

maximal_cliques_hist_impl <- function(graph, min.size=0, max.size=0) {
  # Argument checks
  ensure_igraph(graph)
  min.size <- as.numeric(min.size)
  max.size <- as.numeric(max.size)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_maximal_cliques_hist, graph, min.size, max.size)

  res
}

clique_number_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_clique_number, graph)

  res
}

weighted_cliques_impl <- function(graph, vertex.weights=NULL, min.weight=0, max.weight=0, maximal=FALSE) {
  # Argument checks
  ensure_igraph(graph)
  if (is.null(vertex.weights) && "weight" %in% vertex_attr_names(graph)) {
    vertex.weights <- V(graph)$weight
  }
  if (!is.null(vertex.weights) && !all(is.na(vertex.weights))) {
    vertex.weights <- as.numeric(vertex.weights)
  } else {
    vertex.weights <- NULL
  }
  min.weight <- as.numeric(min.weight)
  max.weight <- as.numeric(max.weight)
  maximal <- as.logical(maximal)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_weighted_cliques, graph, vertex.weights, min.weight, max.weight, maximal)
  if (igraph_opt("return.vs.es")) {
    res <- lapply(res, unsafe_create_vs, graph = graph, verts = V(graph))
  }
  res
}

largest_weighted_cliques_impl <- function(graph, vertex.weights=NULL) {
  # Argument checks
  ensure_igraph(graph)
  if (is.null(vertex.weights) && "weight" %in% vertex_attr_names(graph)) {
    vertex.weights <- V(graph)$weight
  }
  if (!is.null(vertex.weights) && !all(is.na(vertex.weights))) {
    vertex.weights <- as.numeric(vertex.weights)
  } else {
    vertex.weights <- NULL
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_largest_weighted_cliques, graph, vertex.weights)
  if (igraph_opt("return.vs.es")) {
    res <- lapply(res, unsafe_create_vs, graph = graph, verts = V(graph))
  }
  res
}

weighted_clique_number_impl <- function(graph, vertex.weights=NULL) {
  # Argument checks
  ensure_igraph(graph)
  if (is.null(vertex.weights) && "weight" %in% vertex_attr_names(graph)) {
    vertex.weights <- V(graph)$weight
  }
  if (!is.null(vertex.weights) && !all(is.na(vertex.weights))) {
    vertex.weights <- as.numeric(vertex.weights)
  } else {
    vertex.weights <- NULL
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_weighted_clique_number, graph, vertex.weights)

  res
}

is_independent_vertex_set_impl <- function(graph, candidate) {
  # Argument checks
  ensure_igraph(graph)
  candidate <- as_igraph_vs(graph, candidate)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_is_independent_vertex_set, graph, candidate-1)

  res
}

layout_random_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_layout_random, graph)

  res
}

layout_circle_impl <- function(graph, order=V(graph)) {
  # Argument checks
  ensure_igraph(graph)
  order <- as_igraph_vs(graph, order)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_layout_circle, graph, order-1)

  res
}

layout_star_impl <- function(graph, center=V(graph)[1], order=NULL) {
  # Argument checks
  ensure_igraph(graph)
  center <- as_igraph_vs(graph, center)
  if (length(center) == 0) {
    stop("No vertex was specified")
  }
  if (!is.null(order)) order <- as.numeric(order)-1

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_layout_star, graph, center-1, order)

  res
}

layout_grid_impl <- function(graph, width=0) {
  # Argument checks
  ensure_igraph(graph)
  width <- as.numeric(width)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_layout_grid, graph, width)

  res
}

layout_grid_3d_impl <- function(graph, width=0, height=0) {
  # Argument checks
  ensure_igraph(graph)
  width <- as.numeric(width)
  height <- as.numeric(height)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_layout_grid_3d, graph, width, height)

  res
}

roots_for_tree_layout_impl <- function(graph, mode=c("out", "in", "all", "total"), heuristic) {
  # Argument checks
  ensure_igraph(graph)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_roots_for_tree_layout, graph, mode, heuristic)
  if (igraph_opt("return.vs.es")) {
    res <- create_vs(graph, res)
  }
  res
}

layout_random_3d_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_layout_random_3d, graph)

  res
}

layout_sphere_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_layout_sphere, graph)

  res
}

layout_sugiyama_impl <- function(graph, layers=NULL, hgap=1, vgap=1, maxiter=100, weights=NULL) {
  # Argument checks
  ensure_igraph(graph)
  if (!is.null(layers)) layers <- as.numeric(layers)-1
  hgap <- as.numeric(hgap)
  vgap <- as.numeric(vgap)
  maxiter <- as.numeric(maxiter)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_layout_sugiyama, graph, layers, hgap, vgap, maxiter, weights)

  res
}

layout_mds_impl <- function(graph, dist=NULL, dim=2) {
  # Argument checks
  ensure_igraph(graph)
  if (!is.null(dist)) dist[] <- as.numeric(dist)
  dim <- as.numeric(dim)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_layout_mds, graph, dist, dim)

  res
}

layout_bipartite_impl <- function(graph, types, hgap=1, vgap=1, maxiter=100) {
  # Argument checks
  ensure_igraph(graph)
  types <- handle_vertex_type_arg(types, graph)
  hgap <- as.numeric(hgap)
  vgap <- as.numeric(vgap)
  maxiter <- as.numeric(maxiter)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_layout_bipartite, graph, types, hgap, vgap, maxiter)

  res
}

layout_gem_impl <- function(graph, res=matrix(), use.seed=FALSE, maxiter=40*vcount(graph)^2, temp.max=vcount(graph), temp.min=1/10, temp.init=sqrt(vcount(graph))) {
  # Argument checks
  ensure_igraph(graph)
  res[] <- as.numeric(res)
  use.seed <- as.logical(use.seed)
  maxiter <- as.numeric(maxiter)
  temp.max <- as.numeric(temp.max)
  temp.min <- as.numeric(temp.min)
  temp.init <- as.numeric(temp.init)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_layout_gem, graph, res, use.seed, maxiter, temp.max, temp.min, temp.init)

  res
}

layout_davidson_harel_impl <- function(graph, res=matrix(), use.seed=FALSE, maxiter=10, fineiter=max(10, log2(vcount(graph))), cool.fact=0.75, weight.node.dist=1.0, weight.border=0.0, weight.edge.lengths=edge_density(graph) / 10, weight.edge.crossings=1.0 - sqrt(edge_density(graph)), weight.node.edge.dist=0.2 * (1-edge_density(graph))) {
  # Argument checks
  ensure_igraph(graph)
  res[] <- as.numeric(res)
  use.seed <- as.logical(use.seed)
  maxiter <- as.numeric(maxiter)
  fineiter <- as.numeric(fineiter)
  cool.fact <- as.numeric(cool.fact)
  weight.node.dist <- as.numeric(weight.node.dist)
  weight.border <- as.numeric(weight.border)
  weight.edge.lengths <- as.numeric(weight.edge.lengths)
  weight.edge.crossings <- as.numeric(weight.edge.crossings)
  weight.node.edge.dist <- as.numeric(weight.node.edge.dist)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_layout_davidson_harel, graph, res, use.seed, maxiter, fineiter, cool.fact, weight.node.dist, weight.border, weight.edge.lengths, weight.edge.crossings, weight.node.edge.dist)

  res
}

layout_umap_impl <- function(graph, res, use.seed=FALSE, distances=NULL, min.dist=0.0, epochs=200, distances.are.weights=FALSE) {
  # Argument checks
  ensure_igraph(graph)
  res[] <- as.numeric(res)
  use.seed <- as.logical(use.seed)
  if (!is.null(distances)) distances <- as.numeric(distances)
  min.dist <- as.numeric(min.dist)
  epochs <- as.numeric(epochs)
  distances.are.weights <- as.logical(distances.are.weights)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_layout_umap, graph, res, use.seed, distances, min.dist, epochs, distances.are.weights)

  res
}

layout_umap_3d_impl <- function(graph, res, use.seed=FALSE, distances=NULL, min.dist=0.0, epochs=200, distances.are.weights=FALSE) {
  # Argument checks
  ensure_igraph(graph)
  res[] <- as.numeric(res)
  use.seed <- as.logical(use.seed)
  if (!is.null(distances)) distances <- as.numeric(distances)
  min.dist <- as.numeric(min.dist)
  epochs <- as.numeric(epochs)
  distances.are.weights <- as.logical(distances.are.weights)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_layout_umap_3d, graph, res, use.seed, distances, min.dist, epochs, distances.are.weights)

  res
}

layout_umap_compute_weights_impl <- function(graph, distances, weights) {
  # Argument checks
  ensure_igraph(graph)
  distances <- as.numeric(distances)
  weights <- as.numeric(weights)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_layout_umap_compute_weights, graph, distances, weights)

  res
}

layout_align_impl <- function(graph, layout) {
  # Argument checks
  ensure_igraph(graph)
  layout[] <- as.numeric(layout)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_layout_align, graph, layout)

  res
}

similarity_dice_impl <- function(graph, vids=V(graph), mode=c("all", "out", "in", "total"), loops=FALSE) {
  # Argument checks
  ensure_igraph(graph)
  vids <- as_igraph_vs(graph, vids)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)
  loops <- as.logical(loops)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_similarity_dice, graph, vids-1, mode, loops)

  res
}

similarity_dice_es_impl <- function(graph, es=E(graph), mode=c("all", "out", "in", "total"), loops=FALSE) {
  # Argument checks
  ensure_igraph(graph)
  es <- as_igraph_es(graph, es)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)
  loops <- as.logical(loops)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_similarity_dice_es, graph, es-1, mode, loops)

  res
}

similarity_dice_pairs_impl <- function(graph, pairs, mode=c("all", "out", "in", "total"), loops=FALSE) {
  # Argument checks
  ensure_igraph(graph)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)
  loops <- as.logical(loops)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_similarity_dice_pairs, graph, pairs, mode, loops)

  res
}

similarity_inverse_log_weighted_impl <- function(graph, vids=V(graph), mode=c("all", "out", "in", "total")) {
  # Argument checks
  ensure_igraph(graph)
  vids <- as_igraph_vs(graph, vids)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_similarity_inverse_log_weighted, graph, vids-1, mode)

  res
}

similarity_jaccard_impl <- function(graph, vids=V(graph), mode=c("all", "out", "in", "total"), loops=FALSE) {
  # Argument checks
  ensure_igraph(graph)
  vids <- as_igraph_vs(graph, vids)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)
  loops <- as.logical(loops)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_similarity_jaccard, graph, vids-1, mode, loops)

  res
}

similarity_jaccard_es_impl <- function(graph, es=E(graph), mode=c("all", "out", "in", "total"), loops=FALSE) {
  # Argument checks
  ensure_igraph(graph)
  es <- as_igraph_es(graph, es)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)
  loops <- as.logical(loops)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_similarity_jaccard_es, graph, es-1, mode, loops)

  res
}

similarity_jaccard_pairs_impl <- function(graph, pairs, mode=c("all", "out", "in", "total"), loops=FALSE) {
  # Argument checks
  ensure_igraph(graph)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)
  loops <- as.logical(loops)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_similarity_jaccard_pairs, graph, pairs, mode, loops)

  res
}

compare_communities_impl <- function(comm1, comm2, method=c("vi", "nmi", "split.join", "rand", "adjusted.rand")) {
  # Argument checks
  comm1 <- as.numeric(comm1)
  comm2 <- as.numeric(comm2)
  method <- switch(igraph.match.arg(method), "vi"=0L, "nmi"=1L, "split.join"=2L, "rand"=3L, "adjusted.rand"=4L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_compare_communities, comm1, comm2, method)

  res
}

modularity_impl <- function(graph, membership, weights=NULL, resolution=1.0, directed=TRUE) {
  # Argument checks
  ensure_igraph(graph)
  membership <- as.numeric(membership)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  resolution <- as.numeric(resolution)
  directed <- as.logical(directed)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_modularity, graph, membership, weights, resolution, directed)

  res
}

modularity_matrix_impl <- function(graph, weights=NULL, resolution=1.0, directed=TRUE) {
  # Argument checks
  ensure_igraph(graph)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  resolution <- as.numeric(resolution)
  directed <- as.logical(directed)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_modularity_matrix, graph, weights, resolution, directed)

  res
}

community_fluid_communities_impl <- function(graph, no.of.communities) {
  # Argument checks
  ensure_igraph(graph)
  no.of.communities <- as.numeric(no.of.communities)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_community_fluid_communities, graph, no.of.communities)

  res
}

community_label_propagation_impl <- function(graph, mode=c("all", "out", "in", "total"), weights=NULL, initial=NULL, fixed=NULL) {
  # Argument checks
  ensure_igraph(graph)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  if (!is.null(initial)) initial <- as.numeric(initial)-1
  if (!is.null(fixed)) fixed <- as.logical(fixed)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_community_label_propagation, graph, mode, weights, initial, fixed)

  res
}

community_multilevel_impl <- function(graph, weights=NULL, resolution=1.0) {
  # Argument checks
  ensure_igraph(graph)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  resolution <- as.numeric(resolution)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_community_multilevel, graph, weights, resolution)

  res
}

community_optimal_modularity_impl <- function(graph, weights=NULL) {
  # Argument checks
  ensure_igraph(graph)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_community_optimal_modularity, graph, weights)

  res
}

community_leiden_impl <- function(graph, weights=NULL, vertex.weights=NULL, resolution, beta=0.01, start, n.iterations=2, membership=NULL) {
  # Argument checks
  ensure_igraph(graph)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  if (is.null(vertex.weights) && "weight" %in% vertex_attr_names(graph)) {
    vertex.weights <- V(graph)$weight
  }
  if (!is.null(vertex.weights) && !all(is.na(vertex.weights))) {
    vertex.weights <- as.numeric(vertex.weights)
  } else {
    vertex.weights <- NULL
  }
  resolution <- as.numeric(resolution)
  beta <- as.numeric(beta)
  start <- as.logical(start)
  n.iterations <- as.numeric(n.iterations)
  if (!is.null(membership)) membership <- as.numeric(membership)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_community_leiden, graph, weights, vertex.weights, resolution, beta, start, n.iterations, membership)

  res
}

split_join_distance_impl <- function(comm1, comm2) {
  # Argument checks
  comm1 <- as.numeric(comm1)
  comm2 <- as.numeric(comm2)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_split_join_distance, comm1, comm2)

  res
}

community_infomap_impl <- function(graph, e.weights=NULL, v.weights=NULL, nb.trials=10) {
  # Argument checks
  ensure_igraph(graph)
  if (is.null(e.weights) && "weight" %in% edge_attr_names(graph)) {
    e.weights <- E(graph)$weight
  }
  if (!is.null(e.weights) && !all(is.na(e.weights))) {
    e.weights <- as.numeric(e.weights)
  } else {
    e.weights <- NULL
  }
  if (is.null(v.weights) && "weight" %in% vertex_attr_names(graph)) {
    v.weights <- V(graph)$weight
  }
  if (!is.null(v.weights) && !all(is.na(v.weights))) {
    v.weights <- as.numeric(v.weights)
  } else {
    v.weights <- NULL
  }
  nb.trials <- as.numeric(nb.trials)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_community_infomap, graph, e.weights, v.weights, nb.trials)

  res
}

graphlets_impl <- function(graph, weights=NULL, niter=1000) {
  # Argument checks
  ensure_igraph(graph)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  niter <- as.numeric(niter)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_graphlets, graph, weights, niter)
  if (igraph_opt("return.vs.es")) {
    res$cliques <- lapply(res$cliques, unsafe_create_vs, graph = graph, verts = V(graph))
  }
  res
}

hrg_fit_impl <- function(graph, hrg=NULL, start=FALSE, steps=0) {
  # Argument checks
  ensure_igraph(graph)
  if (is.null(hrg)) {
    hrg <- list(left=c(), right=c(), prob=c(), edges=c(), vertices=c())
  }
  hrg <- lapply(hrg[c("left","right","prob","edges","vertices")], as.numeric)
  start <- as.logical(start)
  steps <- as.numeric(steps)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_hrg_fit, graph, hrg, start, steps)

  res
}

hrg_sample_impl <- function(hrg) {
  # Argument checks
  if (is.null(hrg)) {
    hrg <- list(left=c(), right=c(), prob=c(), edges=c(), vertices=c())
  }
  hrg <- lapply(hrg[c("left","right","prob","edges","vertices")], as.numeric)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_hrg_sample, hrg)

  res
}

hrg_sample_many_impl <- function(hrg, num.samples) {
  # Argument checks
  if (is.null(hrg)) {
    hrg <- list(left=c(), right=c(), prob=c(), edges=c(), vertices=c())
  }
  hrg <- lapply(hrg[c("left","right","prob","edges","vertices")], as.numeric)
  num.samples <- as.numeric(num.samples)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_hrg_sample_many, hrg, num.samples)

  res
}

hrg_game_impl <- function(hrg) {
  # Argument checks
  if (is.null(hrg)) {
    hrg <- list(left=c(), right=c(), prob=c(), edges=c(), vertices=c())
  }
  hrg <- lapply(hrg[c("left","right","prob","edges","vertices")], as.numeric)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_hrg_game, hrg)

  if (igraph_opt("add.params")) {
    res$name <- 'Hierarchical random graph model'
  }

  res
}

hrg_consensus_impl <- function(graph, hrg=NULL, start=FALSE, num.samples=10000) {
  # Argument checks
  ensure_igraph(graph)
  if (is.null(hrg)) {
    hrg <- list(left=c(), right=c(), prob=c(), edges=c(), vertices=c())
  }
  hrg <- lapply(hrg[c("left","right","prob","edges","vertices")], as.numeric)
  start <- as.logical(start)
  num.samples <- as.numeric(num.samples)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_hrg_consensus, graph, hrg, start, num.samples)

  res
}

hrg_predict_impl <- function(graph, hrg=NULL, start=FALSE, num.samples=10000, num.bins=25) {
  # Argument checks
  ensure_igraph(graph)
  if (is.null(hrg)) {
    hrg <- list(left=c(), right=c(), prob=c(), edges=c(), vertices=c())
  }
  hrg <- lapply(hrg[c("left","right","prob","edges","vertices")], as.numeric)
  start <- as.logical(start)
  num.samples <- as.numeric(num.samples)
  num.bins <- as.numeric(num.bins)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_hrg_predict, graph, hrg, start, num.samples, num.bins)
  if (igraph_opt("return.vs.es")) {
    res$edges <- create_vs(graph, res$edges)
  }
  res
}

hrg_create_impl <- function(graph, prob) {
  # Argument checks
  ensure_igraph(graph)
  prob <- as.numeric(prob)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_hrg_create, graph, prob)

  class(res) <- "igraphHRG"
  res
}

hrg_resize_impl <- function(hrg, newsize) {
  # Argument checks
  if (is.null(hrg)) {
    hrg <- list(left=c(), right=c(), prob=c(), edges=c(), vertices=c())
  }
  hrg <- lapply(hrg[c("left","right","prob","edges","vertices")], as.numeric)
  newsize <- as.numeric(newsize)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_hrg_resize, hrg, newsize)

  res
}

hrg_size_impl <- function(hrg) {
  # Argument checks
  if (is.null(hrg)) {
    hrg <- list(left=c(), right=c(), prob=c(), edges=c(), vertices=c())
  }
  hrg <- lapply(hrg[c("left","right","prob","edges","vertices")], as.numeric)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_hrg_size, hrg)


  res
}

from_hrg_dendrogram_impl <- function(hrg) {
  # Argument checks
  if (is.null(hrg)) {
    hrg <- list(left=c(), right=c(), prob=c(), edges=c(), vertices=c())
  }
  hrg <- lapply(hrg[c("left","right","prob","edges","vertices")], as.numeric)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_from_hrg_dendrogram, hrg)

  res
}

get_adjacency_sparse_impl <- function(graph, type=c("both", "upper", "lower"), weights=NULL, loops=c("once", "none", "twice")) {
  # Argument checks
  ensure_igraph(graph)
  type <- switch(igraph.match.arg(type), "upper"=0L, "lower"=1L, "both"=2L)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  loops <- switch(igraph.match.arg(loops), "none"=0L, "twice"=1L, "once"=2L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_get_adjacency_sparse, graph, type, weights, loops)

  res
}

get_stochastic_impl <- function(graph, column.wise=FALSE, weights=NULL) {
  # Argument checks
  ensure_igraph(graph)
  column.wise <- as.logical(column.wise)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_get_stochastic, graph, column.wise, weights)

  res
}

get_stochastic_sparse_impl <- function(graph, column.wise=FALSE, weights=NULL) {
  # Argument checks
  ensure_igraph(graph)
  column.wise <- as.logical(column.wise)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_get_stochastic_sparse, graph, column.wise, weights)

  res
}

to_directed_impl <- function(graph, mode=c("mutual", "arbitrary", "random", "acyclic")) {
  # Argument checks
  ensure_igraph(graph)
  mode <- switch(igraph.match.arg(mode), "arbitrary"=0L, "mutual"=1L, "random"=2L, "acyclic"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_to_directed, graph, mode)

  res
}

to_undirected_impl <- function(graph, mode=c("collapse", "each", "mutual"), edge.attr.comb=igraph_opt("edge.attr.comb")) {
  # Argument checks
  ensure_igraph(graph)
  mode <- switch(igraph.match.arg(mode), "collapse"=1L, "each"=0L, "mutual"=2L)
  edge.attr.comb <- igraph.i.attribute.combination(edge.attr.comb)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_to_undirected, graph, mode, edge.attr.comb)

  res
}

motifs_randesu_impl <- function(graph, size=3, cut.prob=NULL) {
  # Argument checks
  ensure_igraph(graph)
  size <- as.numeric(size)
  if (!is.null(cut.prob)) cut.prob <- as.numeric(cut.prob)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_motifs_randesu, graph, size, cut.prob)

  res
}

motifs_randesu_estimate_impl <- function(graph, size=3, cut.prob=NULL, sample.size, sample=NULL) {
  # Argument checks
  ensure_igraph(graph)
  size <- as.numeric(size)
  if (!is.null(cut.prob)) cut.prob <- as.numeric(cut.prob)
  sample.size <- as.numeric(sample.size)
  if (!is.null(sample)) sample <- as.numeric(sample)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_motifs_randesu_estimate, graph, size, cut.prob, sample.size, sample)

  res
}

motifs_randesu_no_impl <- function(graph, size=3, cut.prob=NULL) {
  # Argument checks
  ensure_igraph(graph)
  size <- as.numeric(size)
  if (!is.null(cut.prob)) cut.prob <- as.numeric(cut.prob)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_motifs_randesu_no, graph, size, cut.prob)

  res
}

dyad_census_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_dyad_census, graph)

  res
}

triad_census_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_triad_census, graph)

  res
}

count_adjacent_triangles_impl <- function(graph, vids=V(graph)) {
  # Argument checks
  ensure_igraph(graph)
  vids <- as_igraph_vs(graph, vids)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_count_adjacent_triangles, graph, vids-1)

  res
}

count_triangles_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_count_triangles, graph)

  res
}

local_scan_0_impl <- function(graph, weights=NULL, mode=c("out", "in", "all", "total")) {
  # Argument checks
  ensure_igraph(graph)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_local_scan_0, graph, weights, mode)

  res
}

local_scan_0_them_impl <- function(us, them, weights.them=NULL, mode=c("out", "in", "all", "total")) {
  # Argument checks
  ensure_igraph(us)
  ensure_igraph(them)
  if (is.null(weights.them) && "weight" %in% edge_attr_names(them)) {
    weights.them <- E(them)$weight
  }
  if (!is.null(weights.them) && !all(is.na(weights.them))) {
    weights.them <- as.numeric(weights.them)
  } else {
    weights.them <- NULL
  }
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_local_scan_0_them, us, them, weights.them, mode)

  res
}

local_scan_1_ecount_impl <- function(graph, weights=NULL, mode=c("out", "in", "all", "total")) {
  # Argument checks
  ensure_igraph(graph)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_local_scan_1_ecount, graph, weights, mode)

  res
}

local_scan_1_ecount_them_impl <- function(us, them, weights.them=NULL, mode=c("out", "in", "all", "total")) {
  # Argument checks
  ensure_igraph(us)
  ensure_igraph(them)
  if (is.null(weights.them) && "weight" %in% edge_attr_names(them)) {
    weights.them <- E(them)$weight
  }
  if (!is.null(weights.them) && !all(is.na(weights.them))) {
    weights.them <- as.numeric(weights.them)
  } else {
    weights.them <- NULL
  }
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_local_scan_1_ecount_them, us, them, weights.them, mode)

  res
}

local_scan_k_ecount_impl <- function(graph, k, weights=NULL, mode=c("out", "in", "all", "total")) {
  # Argument checks
  ensure_igraph(graph)
  k <- as.numeric(k)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_local_scan_k_ecount, graph, k, weights, mode)

  res
}

local_scan_k_ecount_them_impl <- function(us, them, k, weights.them=NULL, mode=c("out", "in", "all", "total")) {
  # Argument checks
  ensure_igraph(us)
  ensure_igraph(them)
  k <- as.numeric(k)
  if (is.null(weights.them) && "weight" %in% edge_attr_names(them)) {
    weights.them <- E(them)$weight
  }
  if (!is.null(weights.them) && !all(is.na(weights.them))) {
    weights.them <- as.numeric(weights.them)
  } else {
    weights.them <- NULL
  }
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_local_scan_k_ecount_them, us, them, k, weights.them, mode)

  res
}

local_scan_neighborhood_ecount_impl <- function(graph, weights=NULL, neighborhoods) {
  # Argument checks
  ensure_igraph(graph)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_local_scan_neighborhood_ecount, graph, weights, lapply(neighborhoods, function(.x) .x-1))

  res
}

local_scan_subset_ecount_impl <- function(graph, weights=NULL, subsets) {
  # Argument checks
  ensure_igraph(graph)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_local_scan_subset_ecount, graph, weights, lapply(subsets, function(.x) .x-1))

  res
}

list_triangles_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_list_triangles, graph)
  if (igraph_opt("return.vs.es")) {
    res <- create_vs(graph, res)
  }
  res
}

join_impl <- function(left, right) {
  # Argument checks
  ensure_igraph(left)
  ensure_igraph(right)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_join, left, right)

  res
}

induced_subgraph_map_impl <- function(graph, vids, impl=c("auto", "copy_and_delete", "create_from_scratch")) {
  # Argument checks
  ensure_igraph(graph)
  vids <- as_igraph_vs(graph, vids)
  impl <- switch(igraph.match.arg(impl), "auto"=0L, "copy_and_delete"=1L, "create_from_scratch"=2L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_induced_subgraph_map, graph, vids-1, impl)

  res
}

mycielskian_impl <- function(graph, k=1) {
  # Argument checks
  ensure_igraph(graph)
  k <- as.numeric(k)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_mycielskian, graph, k)

  res
}

product_impl <- function(g1, g2, type=c("cartesian", "lexicographic", "strong", "tensor", "modular")) {
  # Argument checks
  ensure_igraph(g1)
  ensure_igraph(g2)
  type <- switch(igraph.match.arg(type), "cartesian"=0L, "lexicographic"=1L, "strong"=2L, "tensor"=3L, "modular"=4L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_product, g1, g2, type)

  res
}

rooted_product_impl <- function(g1, g2, root) {
  # Argument checks
  ensure_igraph(g1)
  ensure_igraph(g2)
  root <- as_igraph_vs(g2, root)
  if (length(root) == 0) {
    stop("No vertex was specified")
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_rooted_product, g1, g2, root-1)

  res
}

gomory_hu_tree_impl <- function(graph, capacity=NULL) {
  # Argument checks
  ensure_igraph(graph)
  if (is.null(capacity) && "capacity" %in% edge_attr_names(graph)) {
    capacity <- E(graph)$capacity
  }
  if (!is.null(capacity) && !all(is.na(capacity))) {
    capacity <- as.numeric(capacity)
  } else {
    capacity <- NULL
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_gomory_hu_tree, graph, capacity)

  res
}

maxflow_impl <- function(graph, source, target, capacity=NULL) {
  # Argument checks
  ensure_igraph(graph)
  source <- as_igraph_vs(graph, source)
  if (length(source) == 0) {
    stop("No vertex was specified")
  }
  target <- as_igraph_vs(graph, target)
  if (length(target) == 0) {
    stop("No vertex was specified")
  }
  if (is.null(capacity) && "capacity" %in% edge_attr_names(graph)) {
    capacity <- E(graph)$capacity
  }
  if (!is.null(capacity) && !all(is.na(capacity))) {
    capacity <- as.numeric(capacity)
  } else {
    capacity <- NULL
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_maxflow, graph, source-1, target-1, capacity)
  if (igraph_opt("return.vs.es")) {
    res$cut <- create_es(graph, res$cut)
  }
  if (igraph_opt("return.vs.es")) {
    res$partition1 <- create_vs(graph, res$partition1)
  }
  if (igraph_opt("return.vs.es")) {
    res$partition2 <- create_vs(graph, res$partition2)
  }
  res
}

residual_graph_impl <- function(graph, capacity, flow) {
  # Argument checks
  ensure_igraph(graph)
  if (is.null(capacity) && "capacity" %in% edge_attr_names(graph)) {
    capacity <- E(graph)$capacity
  }
  if (!is.null(capacity) && !all(is.na(capacity))) {
    capacity <- as.numeric(capacity)
  } else {
    capacity <- NULL
  }
  flow <- as.numeric(flow)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_residual_graph, graph, capacity, flow)

  res
}

reverse_residual_graph_impl <- function(graph, capacity, flow) {
  # Argument checks
  ensure_igraph(graph)
  if (is.null(capacity) && "capacity" %in% edge_attr_names(graph)) {
    capacity <- E(graph)$capacity
  }
  if (!is.null(capacity) && !all(is.na(capacity))) {
    capacity <- as.numeric(capacity)
  } else {
    capacity <- NULL
  }
  flow <- as.numeric(flow)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_reverse_residual_graph, graph, capacity, flow)

  res
}

st_mincut_impl <- function(graph, source, target, capacity=NULL) {
  # Argument checks
  ensure_igraph(graph)
  source <- as_igraph_vs(graph, source)
  if (length(source) == 0) {
    stop("No vertex was specified")
  }
  target <- as_igraph_vs(graph, target)
  if (length(target) == 0) {
    stop("No vertex was specified")
  }
  if (is.null(capacity) && "capacity" %in% edge_attr_names(graph)) {
    capacity <- E(graph)$capacity
  }
  if (!is.null(capacity) && !all(is.na(capacity))) {
    capacity <- as.numeric(capacity)
  } else {
    capacity <- NULL
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_st_mincut, graph, source-1, target-1, capacity)
  if (igraph_opt("return.vs.es")) {
    res$cut <- create_es(graph, res$cut)
  }
  if (igraph_opt("return.vs.es")) {
    res$partition1 <- create_vs(graph, res$partition1)
  }
  if (igraph_opt("return.vs.es")) {
    res$partition2 <- create_vs(graph, res$partition2)
  }
  res
}

dominator_tree_impl <- function(graph, root, mode=c("out", "in", "all", "total")) {
  # Argument checks
  ensure_igraph(graph)
  root <- as_igraph_vs(graph, root)
  if (length(root) == 0) {
    stop("No vertex was specified")
  }
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_dominator_tree, graph, root-1, mode)
  if (igraph_opt("return.vs.es")) {
    res$leftout <- create_vs(graph, res$leftout)
  }
  res
}

all_st_cuts_impl <- function(graph, source, target) {
  # Argument checks
  ensure_igraph(graph)
  source <- as_igraph_vs(graph, source)
  if (length(source) == 0) {
    stop("No vertex was specified")
  }
  target <- as_igraph_vs(graph, target)
  if (length(target) == 0) {
    stop("No vertex was specified")
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_all_st_cuts, graph, source-1, target-1)
  if (igraph_opt("return.vs.es")) {
    res$cuts <- lapply(res$cuts, unsafe_create_es, graph = graph, es = E(graph))
  }
  if (igraph_opt("return.vs.es")) {
    res$partition1s <- lapply(res$partition1s, unsafe_create_vs, graph = graph, verts = V(graph))
  }
  res
}

all_st_mincuts_impl <- function(graph, source, target, capacity=NULL) {
  # Argument checks
  ensure_igraph(graph)
  source <- as_igraph_vs(graph, source)
  if (length(source) == 0) {
    stop("No vertex was specified")
  }
  target <- as_igraph_vs(graph, target)
  if (length(target) == 0) {
    stop("No vertex was specified")
  }
  if (is.null(capacity) && "capacity" %in% edge_attr_names(graph)) {
    capacity <- E(graph)$capacity
  }
  if (!is.null(capacity) && !all(is.na(capacity))) {
    capacity <- as.numeric(capacity)
  } else {
    capacity <- NULL
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_all_st_mincuts, graph, source-1, target-1, capacity)
  if (igraph_opt("return.vs.es")) {
    res$cuts <- lapply(res$cuts, unsafe_create_es, graph = graph, es = E(graph))
  }
  if (igraph_opt("return.vs.es")) {
    res$partition1s <- lapply(res$partition1s, unsafe_create_vs, graph = graph, verts = V(graph))
  }
  res
}

even_tarjan_reduction_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_even_tarjan_reduction, graph)

  res
}

is_separator_impl <- function(graph, candidate) {
  # Argument checks
  ensure_igraph(graph)
  candidate <- as_igraph_vs(graph, candidate)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_is_separator, graph, candidate-1)

  res
}

is_minimal_separator_impl <- function(graph, candidate) {
  # Argument checks
  ensure_igraph(graph)
  candidate <- as_igraph_vs(graph, candidate)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_is_minimal_separator, graph, candidate-1)

  res
}

all_minimal_st_separators_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_all_minimal_st_separators, graph)
  if (igraph_opt("return.vs.es")) {
    res <- lapply(res, unsafe_create_vs, graph = graph, verts = V(graph))
  }
  res
}

minimum_size_separators_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_minimum_size_separators, graph)
  if (igraph_opt("return.vs.es")) {
    res <- lapply(res, unsafe_create_vs, graph = graph, verts = V(graph))
  }
  res
}

isoclass_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_isoclass, graph)

  res
}

isomorphic_impl <- function(graph1, graph2) {
  # Argument checks
  ensure_igraph(graph1)
  ensure_igraph(graph2)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_isomorphic, graph1, graph2)

  res
}

isoclass_subgraph_impl <- function(graph, vids) {
  # Argument checks
  ensure_igraph(graph)
  vids <- as.numeric(vids)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_isoclass_subgraph, graph, vids)

  res
}

isoclass_create_impl <- function(size, number, directed=TRUE) {
  # Argument checks
  size <- as.numeric(size)
  number <- as.numeric(number)
  directed <- as.logical(directed)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_isoclass_create, size, number, directed)

  res
}

isomorphic_vf2_impl <- function(graph1, graph2, vertex.color1=NULL, vertex.color2=NULL, edge.color1=NULL, edge.color2=NULL) {
  # Argument checks
  ensure_igraph(graph1)
  ensure_igraph(graph2)
  if (missing(vertex.color1)) {
    if ("color" %in% vertex_attr_names(graph1)) {
      vertex.color1 <- V(graph1)$color
    } else {
      vertex.color1 <- NULL
    }
  }
  if (!is.null(vertex.color1)) {
    vertex.color1 <- as.numeric(vertex.color1)-1
  }
  if (missing(vertex.color2)) {
    if ("color" %in% vertex_attr_names(graph2)) {
      vertex.color2 <- V(graph2)$color
    } else {
      vertex.color2 <- NULL
    }
  }
  if (!is.null(vertex.color2)) {
    vertex.color2 <- as.numeric(vertex.color2)-1
  }
  if (missing(edge.color1)) {
    if ("color" %in% edge_attr_names(graph1)) {
      edge.color1 <- E(graph1)$color
    } else {
      edge.color1 <- NULL
    }
  }
  if (!is.null(edge.color1)) {
    edge.color1 <- as.numeric(edge.color1)-1
  }
  if (missing(edge.color2)) {
    if ("color" %in% edge_attr_names(graph2)) {
      edge.color2 <- E(graph2)$color
    } else {
      edge.color2 <- NULL
    }
  }
  if (!is.null(edge.color2)) {
    edge.color2 <- as.numeric(edge.color2)-1
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_isomorphic_vf2, graph1, graph2, vertex.color1, vertex.color2, edge.color1, edge.color2)

  res
}

get_isomorphisms_vf2_callback_impl <- function(graph1, graph2, vertex.color1=NULL, vertex.color2=NULL, edge.color1=NULL, edge.color2=NULL, ishohandler.fn) {
  # Argument checks
  ensure_igraph(graph1)
  ensure_igraph(graph2)
  if (missing(vertex.color1)) {
    if ("color" %in% vertex_attr_names(graph1)) {
      vertex.color1 <- V(graph1)$color
    } else {
      vertex.color1 <- NULL
    }
  }
  if (!is.null(vertex.color1)) {
    vertex.color1 <- as.numeric(vertex.color1)-1
  }
  if (missing(vertex.color2)) {
    if ("color" %in% vertex_attr_names(graph2)) {
      vertex.color2 <- V(graph2)$color
    } else {
      vertex.color2 <- NULL
    }
  }
  if (!is.null(vertex.color2)) {
    vertex.color2 <- as.numeric(vertex.color2)-1
  }
  if (missing(edge.color1)) {
    if ("color" %in% edge_attr_names(graph1)) {
      edge.color1 <- E(graph1)$color
    } else {
      edge.color1 <- NULL
    }
  }
  if (!is.null(edge.color1)) {
    edge.color1 <- as.numeric(edge.color1)-1
  }
  if (missing(edge.color2)) {
    if ("color" %in% edge_attr_names(graph2)) {
      edge.color2 <- E(graph2)$color
    } else {
      edge.color2 <- NULL
    }
  }
  if (!is.null(edge.color2)) {
    edge.color2 <- as.numeric(edge.color2)-1
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(
    R_igraph_get_isomorphisms_vf2_callback,
    graph1,
    graph2,
    vertex.color1,
    vertex.color2,
    edge.color1,
    edge.color2
  )

  res
}

count_isomorphisms_vf2_impl <- function(graph1, graph2, vertex.color1=NULL, vertex.color2=NULL, edge.color1=NULL, edge.color2=NULL) {
  # Argument checks
  ensure_igraph(graph1)
  ensure_igraph(graph2)
  if (missing(vertex.color1)) {
    if ("color" %in% vertex_attr_names(graph1)) {
      vertex.color1 <- V(graph1)$color
    } else {
      vertex.color1 <- NULL
    }
  }
  if (!is.null(vertex.color1)) {
    vertex.color1 <- as.numeric(vertex.color1)-1
  }
  if (missing(vertex.color2)) {
    if ("color" %in% vertex_attr_names(graph2)) {
      vertex.color2 <- V(graph2)$color
    } else {
      vertex.color2 <- NULL
    }
  }
  if (!is.null(vertex.color2)) {
    vertex.color2 <- as.numeric(vertex.color2)-1
  }
  if (missing(edge.color1)) {
    if ("color" %in% edge_attr_names(graph1)) {
      edge.color1 <- E(graph1)$color
    } else {
      edge.color1 <- NULL
    }
  }
  if (!is.null(edge.color1)) {
    edge.color1 <- as.numeric(edge.color1)-1
  }
  if (missing(edge.color2)) {
    if ("color" %in% edge_attr_names(graph2)) {
      edge.color2 <- E(graph2)$color
    } else {
      edge.color2 <- NULL
    }
  }
  if (!is.null(edge.color2)) {
    edge.color2 <- as.numeric(edge.color2)-1
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_count_isomorphisms_vf2, graph1, graph2, vertex.color1, vertex.color2, edge.color1, edge.color2)

  res
}

get_isomorphisms_vf2_impl <- function(graph1, graph2, vertex.color1=NULL, vertex.color2=NULL, edge.color1=NULL, edge.color2=NULL) {
  # Argument checks
  ensure_igraph(graph1)
  ensure_igraph(graph2)
  if (missing(vertex.color1)) {
    if ("color" %in% vertex_attr_names(graph1)) {
      vertex.color1 <- V(graph1)$color
    } else {
      vertex.color1 <- NULL
    }
  }
  if (!is.null(vertex.color1)) {
    vertex.color1 <- as.numeric(vertex.color1)-1
  }
  if (missing(vertex.color2)) {
    if ("color" %in% vertex_attr_names(graph2)) {
      vertex.color2 <- V(graph2)$color
    } else {
      vertex.color2 <- NULL
    }
  }
  if (!is.null(vertex.color2)) {
    vertex.color2 <- as.numeric(vertex.color2)-1
  }
  if (missing(edge.color1)) {
    if ("color" %in% edge_attr_names(graph1)) {
      edge.color1 <- E(graph1)$color
    } else {
      edge.color1 <- NULL
    }
  }
  if (!is.null(edge.color1)) {
    edge.color1 <- as.numeric(edge.color1)-1
  }
  if (missing(edge.color2)) {
    if ("color" %in% edge_attr_names(graph2)) {
      edge.color2 <- E(graph2)$color
    } else {
      edge.color2 <- NULL
    }
  }
  if (!is.null(edge.color2)) {
    edge.color2 <- as.numeric(edge.color2)-1
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_get_isomorphisms_vf2, graph1, graph2, vertex.color1, vertex.color2, edge.color1, edge.color2)

  res
}

subisomorphic_impl <- function(graph1, graph2) {
  # Argument checks
  ensure_igraph(graph1)
  ensure_igraph(graph2)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_subisomorphic, graph1, graph2)

  res
}

subisomorphic_vf2_impl <- function(graph1, graph2, vertex.color1=NULL, vertex.color2=NULL, edge.color1=NULL, edge.color2=NULL) {
  # Argument checks
  ensure_igraph(graph1)
  ensure_igraph(graph2)
  if (missing(vertex.color1)) {
    if ("color" %in% vertex_attr_names(graph1)) {
      vertex.color1 <- V(graph1)$color
    } else {
      vertex.color1 <- NULL
    }
  }
  if (!is.null(vertex.color1)) {
    vertex.color1 <- as.numeric(vertex.color1)-1
  }
  if (missing(vertex.color2)) {
    if ("color" %in% vertex_attr_names(graph2)) {
      vertex.color2 <- V(graph2)$color
    } else {
      vertex.color2 <- NULL
    }
  }
  if (!is.null(vertex.color2)) {
    vertex.color2 <- as.numeric(vertex.color2)-1
  }
  if (missing(edge.color1)) {
    if ("color" %in% edge_attr_names(graph1)) {
      edge.color1 <- E(graph1)$color
    } else {
      edge.color1 <- NULL
    }
  }
  if (!is.null(edge.color1)) {
    edge.color1 <- as.numeric(edge.color1)-1
  }
  if (missing(edge.color2)) {
    if ("color" %in% edge_attr_names(graph2)) {
      edge.color2 <- E(graph2)$color
    } else {
      edge.color2 <- NULL
    }
  }
  if (!is.null(edge.color2)) {
    edge.color2 <- as.numeric(edge.color2)-1
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_subisomorphic_vf2, graph1, graph2, vertex.color1, vertex.color2, edge.color1, edge.color2)

  res
}

count_subisomorphisms_vf2_impl <- function(graph1, graph2, vertex.color1=NULL, vertex.color2=NULL, edge.color1=NULL, edge.color2=NULL) {
  # Argument checks
  ensure_igraph(graph1)
  ensure_igraph(graph2)
  if (missing(vertex.color1)) {
    if ("color" %in% vertex_attr_names(graph1)) {
      vertex.color1 <- V(graph1)$color
    } else {
      vertex.color1 <- NULL
    }
  }
  if (!is.null(vertex.color1)) {
    vertex.color1 <- as.numeric(vertex.color1)-1
  }
  if (missing(vertex.color2)) {
    if ("color" %in% vertex_attr_names(graph2)) {
      vertex.color2 <- V(graph2)$color
    } else {
      vertex.color2 <- NULL
    }
  }
  if (!is.null(vertex.color2)) {
    vertex.color2 <- as.numeric(vertex.color2)-1
  }
  if (missing(edge.color1)) {
    if ("color" %in% edge_attr_names(graph1)) {
      edge.color1 <- E(graph1)$color
    } else {
      edge.color1 <- NULL
    }
  }
  if (!is.null(edge.color1)) {
    edge.color1 <- as.numeric(edge.color1)-1
  }
  if (missing(edge.color2)) {
    if ("color" %in% edge_attr_names(graph2)) {
      edge.color2 <- E(graph2)$color
    } else {
      edge.color2 <- NULL
    }
  }
  if (!is.null(edge.color2)) {
    edge.color2 <- as.numeric(edge.color2)-1
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_count_subisomorphisms_vf2, graph1, graph2, vertex.color1, vertex.color2, edge.color1, edge.color2)

  res
}

get_subisomorphisms_vf2_impl <- function(graph1, graph2, vertex.color1=NULL, vertex.color2=NULL, edge.color1=NULL, edge.color2=NULL) {
  # Argument checks
  ensure_igraph(graph1)
  ensure_igraph(graph2)
  if (missing(vertex.color1)) {
    if ("color" %in% vertex_attr_names(graph1)) {
      vertex.color1 <- V(graph1)$color
    } else {
      vertex.color1 <- NULL
    }
  }
  if (!is.null(vertex.color1)) {
    vertex.color1 <- as.numeric(vertex.color1)-1
  }
  if (missing(vertex.color2)) {
    if ("color" %in% vertex_attr_names(graph2)) {
      vertex.color2 <- V(graph2)$color
    } else {
      vertex.color2 <- NULL
    }
  }
  if (!is.null(vertex.color2)) {
    vertex.color2 <- as.numeric(vertex.color2)-1
  }
  if (missing(edge.color1)) {
    if ("color" %in% edge_attr_names(graph1)) {
      edge.color1 <- E(graph1)$color
    } else {
      edge.color1 <- NULL
    }
  }
  if (!is.null(edge.color1)) {
    edge.color1 <- as.numeric(edge.color1)-1
  }
  if (missing(edge.color2)) {
    if ("color" %in% edge_attr_names(graph2)) {
      edge.color2 <- E(graph2)$color
    } else {
      edge.color2 <- NULL
    }
  }
  if (!is.null(edge.color2)) {
    edge.color2 <- as.numeric(edge.color2)-1
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_get_subisomorphisms_vf2, graph1, graph2, vertex.color1, vertex.color2, edge.color1, edge.color2)

  res
}

canonical_permutation_impl <- function(graph, colors=NULL, sh=c("fm", "f", "fs", "fl", "flm", "fsm")) {
  # Argument checks
  ensure_igraph(graph)
  if (missing(colors)) {
    if ("color" %in% vertex_attr_names(graph)) {
      colors <- V(graph)$color
    } else {
      colors <- NULL
    }
  }
  if (!is.null(colors)) {
    colors <- as.numeric(colors)-1
  }
  sh <- switch(igraph.match.arg(sh), "f"=0L, "fl"=1L, "fs"=2L, "fm"=3L, "flm"=4L, "fsm"=5L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_canonical_permutation, graph, colors, sh)

  res
}

permute_vertices_impl <- function(graph, permutation) {
  # Argument checks
  ensure_igraph(graph)
  permutation <- as.numeric(permutation)-1

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_permute_vertices, graph, permutation)

  res
}

isomorphic_bliss_impl <- function(graph1, graph2, colors1=NULL, colors2=NULL, sh=c("fm", "f", "fs", "fl", "flm", "fsm")) {
  # Argument checks
  ensure_igraph(graph1)
  ensure_igraph(graph2)
  if (missing(colors1)) {
    if ("color" %in% vertex_attr_names(graph1)) {
      colors1 <- V(graph1)$color
    } else {
      colors1 <- NULL
    }
  }
  if (!is.null(colors1)) {
    colors1 <- as.numeric(colors1)-1
  }
  if (missing(colors2)) {
    if ("color" %in% vertex_attr_names(graph2)) {
      colors2 <- V(graph2)$color
    } else {
      colors2 <- NULL
    }
  }
  if (!is.null(colors2)) {
    colors2 <- as.numeric(colors2)-1
  }
  sh <- switch(igraph.match.arg(sh), "f"=0L, "fl"=1L, "fs"=2L, "fm"=3L, "flm"=4L, "fsm"=5L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_isomorphic_bliss, graph1, graph2, colors1, colors2, sh)

  res
}

count_automorphisms_impl <- function(graph, colors=NULL, sh=c("fm", "f", "fs", "fl", "flm", "fsm")) {
  # Argument checks
  ensure_igraph(graph)
  if (missing(colors)) {
    if ("color" %in% vertex_attr_names(graph)) {
      colors <- V(graph)$color
    } else {
      colors <- NULL
    }
  }
  if (!is.null(colors)) {
    colors <- as.numeric(colors)-1
  }
  sh <- switch(igraph.match.arg(sh), "f"=0L, "fl"=1L, "fs"=2L, "fm"=3L, "flm"=4L, "fsm"=5L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_count_automorphisms, graph, colors, sh)

  res
}

automorphism_group_impl <- function(graph, colors=NULL, sh=c("fm", "f", "fs", "fl", "flm", "fsm"), details=FALSE) {
  # Argument checks
  ensure_igraph(graph)
  if (missing(colors)) {
    if ("color" %in% vertex_attr_names(graph)) {
      colors <- V(graph)$color
    } else {
      colors <- NULL
    }
  }
  if (!is.null(colors)) {
    colors <- as.numeric(colors)-1
  }
  sh <- switch(igraph.match.arg(sh), "f"=0L, "fl"=1L, "fs"=2L, "fm"=3L, "flm"=4L, "fsm"=5L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_automorphism_group, graph, colors, sh)
  if (igraph_opt("return.vs.es")) {
    res$generators <- lapply(res$generators, unsafe_create_vs, graph = graph, verts = V(graph))
  }
  if (!details) {
    res <- res$generators
  }
  res
}

simplify_and_colorize_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_simplify_and_colorize, graph)

  res
}

graph_count_impl <- function(n, directed=FALSE) {
  # Argument checks
  n <- as.numeric(n)
  directed <- as.logical(directed)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_graph_count, n, directed)

  res
}

is_matching_impl <- function(graph, types=NULL, matching) {
  # Argument checks
  ensure_igraph(graph)
  if (!is.null(types)) types <- handle_vertex_type_arg(types, graph)
  matching <- as.numeric(matching)-1

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_is_matching, graph, types, matching)

  res
}

is_maximal_matching_impl <- function(graph, types=NULL, matching) {
  # Argument checks
  ensure_igraph(graph)
  if (!is.null(types)) types <- handle_vertex_type_arg(types, graph)
  matching <- as.numeric(matching)-1

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_is_maximal_matching, graph, types, matching)

  res
}

maximum_bipartite_matching_impl <- function(graph, types, weights=NULL, eps=.Machine$double.eps) {
  # Argument checks
  ensure_igraph(graph)
  types <- handle_vertex_type_arg(types, graph)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  eps <- as.numeric(eps)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_maximum_bipartite_matching, graph, types, weights, eps)

  res
}

adjacency_spectral_embedding_impl <- function(graph, no, weights=NULL, which=c("lm", "la", "sa"), scaled=TRUE, cvec=strength(graph, weights=weights)/(vcount(graph)-1), options=arpack_defaults()) {
  # Argument checks
  ensure_igraph(graph)
  no <- as.numeric(no)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  which <- switch(igraph.match.arg(which), "lm"=0L, "la"=2L, "sa"=3L)
  scaled <- as.logical(scaled)
  cvec <- as.numeric(cvec)
  options <- modify_list(arpack_defaults(), options)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_adjacency_spectral_embedding, graph, no, weights, which, scaled, cvec, options)

  res
}

laplacian_spectral_embedding_impl <- function(graph, no, weights=NULL, which=c("lm", "la", "sa"), type=c("default", "D-A", "DAD", "I-DAD", "OAP"), scaled=TRUE, options=arpack_defaults()) {
  # Argument checks
  ensure_igraph(graph)
  no <- as.numeric(no)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  which <- switch(igraph.match.arg(which), "lm"=0L, "la"=2L, "sa"=3L)
  type <- switch(igraph.match.arg(type),
    "default"=if (is_directed(graph)) 3L else 0L,
    "da"=0L, "d-a"=0L, "idad"=1L, "i-dad"=1L, "dad"=2L,
    "oap"=3L)
  scaled <- as.logical(scaled)
  options <- modify_list(arpack_defaults(), options)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_laplacian_spectral_embedding, graph, no, weights, which, type, scaled, options)

  res
}

eigen_adjacency_impl <- function(graph, algorithm=c("arpack", "auto", "lapack", "comp_auto", "comp_lapack", "comp_arpack"), which=list(), options=arpack_defaults()) {
  # Argument checks
  ensure_igraph(graph)
  algorithm <- switch(igraph.match.arg(algorithm), "auto"=0L, "lapack"=1L,
    "arpack"=2L, "comp_auto"=3L, "comp_lapack"=4L,
    "comp_arpack"=5L)
  which.tmp <- eigen_defaults();
  which.tmp[ names(which) ] <- which ; which <- which.tmp
  options <- modify_list(arpack_defaults(), options)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_eigen_adjacency, graph, algorithm, which, options)

  res
}

power_law_fit_impl <- function(data, xmin=-1, force.continuous=FALSE) {
  # Argument checks
  data <- as.numeric(data)
  xmin <- as.numeric(xmin)
  force.continuous <- as.logical(force.continuous)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_power_law_fit, data, xmin, force.continuous)

  res
}

sir_impl <- function(graph, beta, gamma, no.sim=100) {
  # Argument checks
  ensure_igraph(graph)
  beta <- as.numeric(beta)
  gamma <- as.numeric(gamma)
  no.sim <- as.numeric(no.sim)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_sir, graph, beta, gamma, no.sim)

  class(res) <- "sir"
  res
}

convex_hull_2d_impl <- function(data) {
  # Argument checks
  data[] <- as.numeric(data)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_convex_hull_2d, data)

  res
}

dim_select_impl <- function(sv) {
  # Argument checks
  sv <- as.numeric(sv)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_dim_select, sv)

  res
}

solve_lsap_impl <- function(c, n) {
  # Argument checks
  c[] <- as.numeric(c)
  n <- as.numeric(n)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_solve_lsap, c, n)

  res
}

find_cycle_impl <- function(graph, mode=c("out", "in", "all", "total")) {
  # Argument checks
  ensure_igraph(graph)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_find_cycle, graph, mode)
  if (igraph_opt("return.vs.es")) {
    res$vertices <- create_vs(graph, res$vertices)
  }
  if (igraph_opt("return.vs.es")) {
    res$edges <- create_es(graph, res$edges)
  }
  res
}

simple_cycles_impl <- function(graph, mode=c("out", "in", "all", "total"), min.cycle.length=-1, max.cycle.length=-1) {
  # Argument checks
  ensure_igraph(graph)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)
  min.cycle.length <- as.numeric(min.cycle.length)
  max.cycle.length <- as.numeric(max.cycle.length)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_simple_cycles, graph, mode, min.cycle.length, max.cycle.length)
  if (igraph_opt("return.vs.es")) {
    res$vertices <- lapply(res$vertices, unsafe_create_vs, graph = graph, verts = V(graph))
  }
  if (igraph_opt("return.vs.es")) {
    res$edges <- lapply(res$edges, unsafe_create_es, graph = graph, es = E(graph))
  }
  res
}

is_eulerian_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_is_eulerian, graph)

  res
}

eulerian_path_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_eulerian_path, graph)
  if (igraph_opt("return.vs.es")) {
    res$epath <- create_es(graph, res$epath)
  }
  if (igraph_opt("return.vs.es")) {
    res$vpath <- create_vs(graph, res$vpath)
  }
  res
}

eulerian_cycle_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_eulerian_cycle, graph)
  if (igraph_opt("return.vs.es")) {
    res$epath <- create_es(graph, res$epath)
  }
  if (igraph_opt("return.vs.es")) {
    res$vpath <- create_vs(graph, res$vpath)
  }
  res
}

fundamental_cycles_impl <- function(graph, start=NULL, bfs.cutoff=-1, weights=NULL) {
  # Argument checks
  ensure_igraph(graph)
  if (!is.null(start)) start <- as_igraph_vs(graph, start)
  if (length(start) == 0) {
    stop("No vertex was specified")
  }
  bfs.cutoff <- as.numeric(bfs.cutoff)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_fundamental_cycles, graph, start-1, bfs.cutoff, weights)
  if (igraph_opt("return.vs.es")) {
    res <- lapply(res, unsafe_create_es, graph = graph, es = E(graph))
  }
  res
}

minimum_cycle_basis_impl <- function(graph, bfs.cutoff=-1, complete=TRUE, use.cycle.order=TRUE, weights=NULL) {
  # Argument checks
  ensure_igraph(graph)
  bfs.cutoff <- as.numeric(bfs.cutoff)
  complete <- as.logical(complete)
  use.cycle.order <- as.logical(use.cycle.order)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_minimum_cycle_basis, graph, bfs.cutoff, complete, use.cycle.order, weights)
  if (igraph_opt("return.vs.es")) {
    res <- lapply(res, unsafe_create_es, graph = graph, es = E(graph))
  }
  res
}

is_tree_impl <- function(graph, mode=c("out", "in", "all", "total"), details=FALSE) {
  # Argument checks
  ensure_igraph(graph)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_is_tree, graph, mode)
  if (igraph_opt("return.vs.es") && vcount(graph) != 0) {
    res$root <- create_vs(graph, res$root)
  }
  if (!details) {
    res <- res$res
  }
  res
}

is_forest_impl <- function(graph, mode=c("out", "in", "all", "total"), details=FALSE) {
  # Argument checks
  ensure_igraph(graph)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_is_forest, graph, mode)
  if (igraph_opt("return.vs.es")) {
    res$roots <- create_vs(graph, res$roots)
  }
  if (!details) {
    res <- res$res
  }
  res
}

from_prufer_impl <- function(prufer) {
  # Argument checks
  prufer <- as.numeric(prufer)-1

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_from_prufer, prufer)

  if (igraph_opt("add.params")) {
    res$name <- 'Tree from Prufer sequence'
    res$prufer <- prufer
  }

  res
}

to_prufer_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_to_prufer, graph)

  res
}

tree_from_parent_vector_impl <- function(parents, type=c("out", "in", "undirected")) {
  # Argument checks
  parents <- as.numeric(parents)-1
  type <- switch(igraph.match.arg(type), "out"=0L, "in"=1L, "undirected"=2L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_tree_from_parent_vector, parents, type)

  res
}

is_complete_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_is_complete, graph)

  res
}

random_spanning_tree_impl <- function(graph, vid=0) {
  # Argument checks
  ensure_igraph(graph)
  if (!is.null(vid)) vid <- as_igraph_vs(graph, vid)
  if (length(vid) == 0) {
    stop("No vertex was specified")
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_random_spanning_tree, graph, vid-1)
  if (igraph_opt("return.vs.es")) {
    res <- create_es(graph, res)
  }
  res
}

tree_game_impl <- function(n, directed=FALSE, method=c("lerw", "prufer")) {
  # Argument checks
  n <- as.numeric(n)
  directed <- as.logical(directed)
  method <- switch(igraph.match.arg(method), "prufer"=0L, "lerw"=1L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_tree_game, n, directed, method)

  res
}

vertex_coloring_greedy_impl <- function(graph, heuristic=c("colored_neighbors", "dsatur")) {
  # Argument checks
  ensure_igraph(graph)
  heuristic <- switch(igraph.match.arg(heuristic), "colored_neighbors"=0L, "dsatur"=1L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_vertex_coloring_greedy, graph, heuristic)
  res <- res+1
  if (igraph_opt("add.vertex.names") && is_named(graph)) {
    names(res) <- vertex_attr(graph, "name")
  }
  res
}

is_vertex_coloring_impl <- function(graph, types) {
  # Argument checks
  ensure_igraph(graph)
  if (missing(types)) {
    if ("color" %in% vertex_attr_names(graph)) {
      types <- V(graph)$color
    } else {
      types <- NULL
    }
  }
  if (!is.null(types)) {
    types <- as.numeric(types)-1
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_is_vertex_coloring, graph, types)

  res
}

is_bipartite_coloring_impl <- function(graph, types) {
  # Argument checks
  ensure_igraph(graph)
  types <- handle_vertex_type_arg(types, graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_is_bipartite_coloring, graph, types)

  res
}

is_edge_coloring_impl <- function(graph, types) {
  # Argument checks
  ensure_igraph(graph)
  if (missing(types)) {
    if ("color" %in% edge_attr_names(graph)) {
      types <- E(graph)$color
    } else {
      types <- NULL
    }
  }
  if (!is.null(types)) {
    types <- as.numeric(types)-1
  }

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_is_edge_coloring, graph, types)

  res
}

deterministic_optimal_imitation_impl <- function(graph, vid, optimality=c("maximum", "minimum"), quantities, strategies, mode=c("out", "in", "all", "total")) {
  # Argument checks
  ensure_igraph(graph)
  vid <- as_igraph_vs(graph, vid)
  if (length(vid) == 0) {
    stop("No vertex was specified")
  }
  optimality <- switch(igraph.match.arg(optimality), "minimum"=0L, "maximum"=1L)
  strategies <- as.numeric(strategies)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_deterministic_optimal_imitation, graph, vid-1, optimality, quantities, strategies, mode)

  res
}

moran_process_impl <- function(graph, weights=NULL, quantities, strategies, mode=c("out", "in", "all", "total")) {
  # Argument checks
  ensure_igraph(graph)
  if (is.null(weights) && "weight" %in% edge_attr_names(graph)) {
    weights <- E(graph)$weight
  }
  if (!is.null(weights) && !all(is.na(weights))) {
    weights <- as.numeric(weights)
  } else {
    weights <- NULL
  }
  strategies <- as.numeric(strategies)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_moran_process, graph, weights, quantities, strategies, mode)
  if (igraph_opt("add.vertex.names") && is_named(graph)) {
    names(res$quantities) <- vertex_attr(graph, "name", V(graph))
  }
  res
}

roulette_wheel_imitation_impl <- function(graph, vid, is.local, quantities, strategies, mode=c("out", "in", "all", "total")) {
  # Argument checks
  ensure_igraph(graph)
  vid <- as_igraph_vs(graph, vid)
  if (length(vid) == 0) {
    stop("No vertex was specified")
  }
  is.local <- as.logical(is.local)
  strategies <- as.numeric(strategies)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_roulette_wheel_imitation, graph, vid-1, is.local, quantities, strategies, mode)

  res
}

stochastic_imitation_impl <- function(graph, vid, algo, quantities, strategies, mode=c("out", "in", "all", "total")) {
  # Argument checks
  ensure_igraph(graph)
  vid <- as_igraph_vs(graph, vid)
  if (length(vid) == 0) {
    stop("No vertex was specified")
  }
  strategies <- as.numeric(strategies)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_stochastic_imitation, graph, vid-1, algo, quantities, strategies, mode)

  res
}

invalidate_cache_impl <- function(graph) {
  # Argument checks
  ensure_igraph(graph)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_invalidate_cache, graph)

  res
}

vertex_path_from_edge_path_impl <- function(graph, start=NULL, edge.path, mode=c("out", "in", "all", "total")) {
  # Argument checks
  ensure_igraph(graph)
  if (!is.null(start)) start <- as_igraph_vs(graph, start)
  if (length(start) == 0) {
    stop("No vertex was specified")
  }
  edge.path <- as_igraph_es(graph, edge.path)
  mode <- switch(igraph.match.arg(mode), "out"=1L, "in"=2L, "all"=3L, "total"=3L)

  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_vertex_path_from_edge_path, graph, start-1, edge.path-1, mode)
  if (igraph_opt("return.vs.es")) {
    res <- create_vs(graph, res)
  }
  res
}

version_impl <- function() {
  # Argument checks


  on.exit( .Call(R_igraph_finalizer) )
  # Function call
  res <- .Call(R_igraph_version)

  res
}

