% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_cross.R
\name{augment_chisq_add_phi}
\alias{augment_chisq_add_phi}
\title{Augment a chi-squared test and compute phi coefficients}
\usage{
augment_chisq_add_phi(x)
}
\arguments{
\item{x}{a chi-squared test as returned by \code{\link[stats:chisq.test]{stats::chisq.test()}}}
}
\value{
A \code{tibble}.
}
\description{
Augment a chi-squared test and compute phi coefficients
}
\details{
Phi coefficients are a measurement of the degree of association
between two binary variables.
\itemize{
\item A value between -1.0 to -0.7 indicates a strong negative association.
\item A value between -0.7 to -0.3 indicates a weak negative association.
\item A value between -0.3 to +0.3 indicates a little or no association.
\item A value between +0.3 to +0.7 indicates a weak positive association.
\item A value between +0.7 to +1.0 indicates a strong positive association.
}
}
\examples{
tab <- xtabs(Freq ~ Sex + Class, data = as.data.frame(Titanic))
augment_chisq_add_phi(chisq.test(tab))
}
\seealso{
\code{\link[=stat_cross]{stat_cross()}}, \code{GDAtools::phi.table()} or \code{psych::phi()}
}
