% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete-atlassian.R
\name{pal_atlassian}
\alias{pal_atlassian}
\title{Atlassian Design System palette}
\usage{
pal_atlassian(palette = c("categorical8"), alpha = 1)
}
\arguments{
\item{palette}{Palette type.
Currently there is one available option: \code{"categorical8"}
(8-color palette).}

\item{alpha}{Transparency level, a real number in (0, 1].
See \code{alpha} in \code{\link[grDevices:rgb]{grDevices::rgb()}} for details.}
}
\description{
The Atlassian Design System categorical data visualization palette.
}
\examples{
library("scales")
show_col(pal_atlassian("categorical8")(8))
show_col(pal_atlassian("categorical8", alpha = 0.6)(8))
}
\references{
Atlassian (2025). "Atlassian Design System categorical chart colors."
\url{https://atlassian.design/foundations/color-new/data-visualization-color}
}
\author{
Nan Xiao | \email{me@nanx.me} | \url{https://nanx.me}
}
