(function() {
  var CustomEvents;

  CustomEvents = {
    bind: function(element, eventName, handler) {
      if (element.addEventListener) {
        return element.addEventListener(eventName, handler, false);
      } else if (element.attachEvent) {
        element[eventName] = 1;
        return element.attachEvent('onpropertychange', function(event) {
          if (event.propertyName === eventName) {
            return handler();
          }
        });
      } else {
        throw new Error("Attempt to attach custom event " + eventName + " to something which isn't a DOMElement");
      }
    },
    fire: function(element, eventName) {
      var event;
      if (element.addEventListener) {
        event = document.createEvent('HTMLEvents');
        event.initEvent(eventName, true, true);
        return document.dispatchEvent(event);
      } else if (element.attachEvent) {
        if (element[eventName]) {
          return element[eventName]++;
        }
      } else {
        throw new Error("Attempt to fire custom event " + eventName + " on something which isn't a DOMElement");
      }
    }
  };

  exports.bind = CustomEvents.bind;

  exports.fire = CustomEvents.fire;

}).call(this);
