
// output12ax7_table generated by DK/circ_table_gen.py -- do not modify manually

 // variables used
 // --sig_max  3.000000
 // --table_div  73.995059
 // --table_op  0.100000

struct tableoutput12ax7 { // 1-dimensional function table
    float low;
    float high;
    float istep;
    int size;
    float data[];
};

template <int tab_size>
struct tableoutput12ax7_imp {
    float low;
    float high;
    float istep;
    int size;
    float data[tab_size];
    operator tableoutput12ax7&() const { return *(tableoutput12ax7*)this; }
};

 static tableoutput12ax7_imp<2048> output12ax7_table __rt_data = {
	0,-0.833333,68.2333,2048, {
	0.000000000000,-0.000586917199,-0.001173631533,-0.001760143043,-0.002346451768,
	-0.002932557749,-0.003518461024,-0.004104161635,-0.004689659621,-0.005274955022,
	-0.005860047878,-0.006444938229,-0.007029626116,-0.007614111578,-0.008198394655,
	-0.008782475389,-0.009366353818,-0.009950029984,-0.010533503926,-0.011116775685,
	-0.011699845300,-0.012282712814,-0.012865378265,-0.013447841695,-0.014030103143,
	-0.014612162650,-0.015194020257,-0.015775676005,-0.016357129933,-0.016938382082,
	-0.017519432493,-0.018100281207,-0.018680928264,-0.019261373705,-0.019841617571,
	-0.020421659902,-0.021001500739,-0.021581140123,-0.022160578095,-0.022739814696,
	-0.023318849966,-0.023897683947,-0.024476316679,-0.025054748203,-0.025632978561,
	-0.026211007793,-0.026788835940,-0.027366463044,-0.027943889145,-0.028521114285,
	-0.029098138504,-0.029674961845,-0.030251584347,-0.030828006053,-0.031404227004,
	-0.031980247241,-0.032556066804,-0.033131685736,-0.033707104078,-0.034282321871,
	-0.034857339157,-0.035432155977,-0.036006772372,-0.036581188384,-0.037155404054,
	-0.037729419425,-0.038303234536,-0.038876849431,-0.039450264151,-0.040023478736,
	-0.040596493230,-0.041169307673,-0.041741922107,-0.042314336575,-0.042886551117,
	-0.043458565775,-0.044030380591,-0.044601995608,-0.045173410866,-0.045744626408,
	-0.046315642275,-0.046886458510,-0.047457075155,-0.048027492250,-0.048597709839,
	-0.049167727963,-0.049737546664,-0.050307165985,-0.050876585966,-0.051445806652,
	-0.052014828082,-0.052583650301,-0.053152273349,-0.053720697269,-0.054288922103,
	-0.054856947894,-0.055424774683,-0.055992402512,-0.056559831425,-0.057127061463,
	-0.057694092669,-0.058260925085,-0.058827558753,-0.059393993716,-0.059960230016,
	-0.060526267696,-0.061092106798,-0.061657747364,-0.062223189437,-0.062788433059,
	-0.063353478274,-0.063918325123,-0.064482973649,-0.065047423894,-0.065611675902,
	-0.066175729715,-0.066739585375,-0.067303242926,-0.067866702409,-0.068429963868,
	-0.068993027345,-0.069555892883,-0.070118560525,-0.070681030314,-0.071243302292,
	-0.071805376502,-0.072367252987,-0.072928931790,-0.073490412954,-0.074051696521,
	-0.074612782535,-0.075173671039,-0.075734362075,-0.076294855687,-0.076855151916,
	-0.077415250808,-0.077975152404,-0.078534856747,-0.079094363881,-0.079653673848,
	-0.080212786692,-0.080771702456,-0.081330421183,-0.081888942917,-0.082447267699,
	-0.083005395574,-0.083563326585,-0.084121060775,-0.084678598186,-0.085235938864,
	-0.085793082850,-0.086350030188,-0.086906780921,-0.087463335093,-0.088019692747,
	-0.088575853926,-0.089131818674,-0.089687587034,-0.090243159049,-0.090798534764,
	-0.091353714221,-0.091908697463,-0.092463484535,-0.093018075480,-0.093572470341,
	-0.094126669162,-0.094680671987,-0.095234478858,-0.095788089820,-0.096341504916,
	-0.096894724189,-0.097447747684,-0.098000575444,-0.098553207513,-0.099105643934,
	-0.099657884751,-0.100209930007,-0.100761779747,-0.101313434014,-0.101864892852,
	-0.102416156304,-0.102967224415,-0.103518097228,-0.104068774787,-0.104619257136,
	-0.105169544318,-0.105719636378,-0.106269533359,-0.106819235306,-0.107368742261,
	-0.107918054270,-0.108467171375,-0.109016093621,-0.109564821052,-0.110113353712,
	-0.110661691645,-0.111209834894,-0.111757783504,-0.112305537519,-0.112853096983,
	-0.113400461939,-0.113947632433,-0.114494608507,-0.115041390206,-0.115587977575,
	-0.116134370656,-0.116680569496,-0.117226574136,-0.117772384622,-0.118318000999,
	-0.118863423309,-0.119408651597,-0.119953685908,-0.120498526285,-0.121043172773,
	-0.121587625417,-0.122131884259,-0.122675949346,-0.123219820720,-0.123763498426,
	-0.124306982509,-0.124850273012,-0.125393369981,-0.125936273459,-0.126478983491,
	-0.127021500121,-0.127563823394,-0.128105953354,-0.128647890045,-0.129189633511,
	-0.129731183798,-0.130272540950,-0.130813705010,-0.131354676024,-0.131895454036,
	-0.132436039091,-0.132976431232,-0.133516630505,-0.134056636954,-0.134596450623,
	-0.135136071558,-0.135675499802,-0.136214735400,-0.136753778396,-0.137292628836,
	-0.137831286764,-0.138369752225,-0.138908025262,-0.139446105921,-0.139983994246,
	-0.140521690283,-0.141059194075,-0.141596505667,-0.142133625104,-0.142670552431,
	-0.143207287692,-0.143743830932,-0.144280182196,-0.144816341528,-0.145352308974,
	-0.145888084577,-0.146423668383,-0.146959060437,-0.147494260782,-0.148029269465,
	-0.148564086530,-0.149098712021,-0.149633145983,-0.150167388462,-0.150701439501,
	-0.151235299147,-0.151768967443,-0.152302444435,-0.152835730167,-0.153368824685,
	-0.153901728032,-0.154434440255,-0.154966961398,-0.155499291505,-0.156031430623,
	-0.156563378795,-0.157095136066,-0.157626702483,-0.158158078088,-0.158689262929,
	-0.159220257048,-0.159751060492,-0.160281673306,-0.160812095534,-0.161342327221,
	-0.161872368413,-0.162402219154,-0.162931879489,-0.163461349464,-0.163990629124,
	-0.164519718513,-0.165048617676,-0.165577326659,-0.166105845507,-0.166634174265,
	-0.167162312977,-0.167690261690,-0.168218020447,-0.168745589295,-0.169272968278,
	-0.169800157441,-0.170327156830,-0.170853966489,-0.171380586464,-0.171907016800,
	-0.172433257543,-0.172959308736,-0.173485170426,-0.174010842657,-0.174536325475,
	-0.175061618925,-0.175586723052,-0.176111637902,-0.176636363519,-0.177160899948,
	-0.177685247236,-0.178209405427,-0.178733374566,-0.179257154699,-0.179780745871,
	-0.180304148126,-0.180827361512,-0.181350386072,-0.181873221851,-0.182395868896,
	-0.182918327252,-0.183440596963,-0.183962678075,-0.184484570633,-0.185006274683,
	-0.185527790270,-0.186049117439,-0.186570256236,-0.187091206706,-0.187611968893,
	-0.188132542844,-0.188652928605,-0.189173126219,-0.189693135733,-0.190212957191,
	-0.190732590640,-0.191252036125,-0.191771293690,-0.192290363382,-0.192809245246,
	-0.193327939326,-0.193846445669,-0.194364764320,-0.194882895324,-0.195400838727,
	-0.195918594574,-0.196436162911,-0.196953543782,-0.197470737233,-0.197987743311,
	-0.198504562059,-0.199021193524,-0.199537637751,-0.200053894785,-0.200569964672,
	-0.201085847458,-0.201601543187,-0.202117051906,-0.202632373659,-0.203147508492,
	-0.203662456451,-0.204177217581,-0.204691791927,-0.205206179535,-0.205720380451,
	-0.206234394720,-0.206748222387,-0.207261863498,-0.207775318098,-0.208288586234,
	-0.208801667950,-0.209314563291,-0.209827272304,-0.210339795034,-0.210852131526,
	-0.211364281827,-0.211876245980,-0.212388024033,-0.212899616030,-0.213411022017,
	-0.213922242039,-0.214433276143,-0.214944124373,-0.215454786775,-0.215965263395,
	-0.216475554278,-0.216985659470,-0.217495579016,-0.218005312962,-0.218514861353,
	-0.219024224235,-0.219533401653,-0.220042393654,-0.220551200282,-0.221059821583,
	-0.221568257602,-0.222076508386,-0.222584573980,-0.223092454429,-0.223600149779,
	-0.224107660076,-0.224614985365,-0.225122125691,-0.225629081100,-0.226135851638,
	-0.226642437351,-0.227148838284,-0.227655054482,-0.228161085991,-0.228666932856,
	-0.229172595125,-0.229678072840,-0.230183366050,-0.230688474798,-0.231193399131,
	-0.231698139094,-0.232202694733,-0.232707066094,-0.233211253221,-0.233715256161,
	-0.234219074959,-0.234722709660,-0.235226160312,-0.235729426958,-0.236232509644,
	-0.236735408417,-0.237238123321,-0.237740654403,-0.238243001708,-0.238745165281,
	-0.239247145169,-0.239748941416,-0.240250554068,-0.240751983171,-0.241253228771,
	-0.241754290913,-0.242255169643,-0.242755865006,-0.243256377048,-0.243756705815,
	-0.244256851352,-0.244756813704,-0.245256592918,-0.245756189039,-0.246255602112,
	-0.246754832184,-0.247253879299,-0.247752743504,-0.248251424843,-0.248749923364,
	-0.249248239110,-0.249746372128,-0.250244322463,-0.250742090162,-0.251239675269,
	-0.251737077830,-0.252234297890,-0.252731335496,-0.253228190693,-0.253724863527,
	-0.254221354043,-0.254717662286,-0.255213788303,-0.255709732138,-0.256205493838,
	-0.256701073448,-0.257196471014,-0.257691686581,-0.258186720195,-0.258681571901,
	-0.259176241745,-0.259670729773,-0.260165036030,-0.260659160561,-0.261153103413,
	-0.261646864631,-0.262140444260,-0.262633842346,-0.263127058935,-0.263620094072,
	-0.264112947803,-0.264605620173,-0.265098111228,-0.265590421013,-0.266082549574,
	-0.266574496957,-0.267066263207,-0.267557848370,-0.268049252490,-0.268540475615,
	-0.269031517789,-0.269522379057,-0.270013059466,-0.270503559061,-0.270993877888,
	-0.271484015991,-0.271973973417,-0.272463750211,-0.272953346419,-0.273442762086,
	-0.273931997257,-0.274421051979,-0.274909926296,-0.275398620255,-0.275887133900,
	-0.276375467278,-0.276863620433,-0.277351593412,-0.277839386260,-0.278326999021,
	-0.278814431743,-0.279301684470,-0.279788757247,-0.280275650121,-0.280762363137,
	-0.281248896340,-0.281735249776,-0.282221423489,-0.282707417527,-0.283193231934,
	-0.283678866755,-0.284164322036,-0.284649597823,-0.285134694161,-0.285619611096,
	-0.286104348672,-0.286588906936,-0.287073285933,-0.287557485708,-0.288041506306,
	-0.288525347774,-0.289009010156,-0.289492493499,-0.289975797846,-0.290458923245,
	-0.290941869740,-0.291424637376,-0.291907226200,-0.292389636256,-0.292871867590,
	-0.293353920248,-0.293835794274,-0.294317489714,-0.294799006614,-0.295280345018,
	-0.295761504973,-0.296242486524,-0.296723289715,-0.297203914593,-0.297684361202,
	-0.298164629589,-0.298644719798,-0.299124631875,-0.299604365865,-0.300083921813,
	-0.300563299766,-0.301042499767,-0.301521521863,-0.302000366099,-0.302479032519,
	-0.302957521171,-0.303435832097,-0.303913965345,-0.304391920960,-0.304869698986,
	-0.305347299469,-0.305824722454,-0.306301967987,-0.306779036112,-0.307255926875,
	-0.307732640322,-0.308209176498,-0.308685535447,-0.309161717215,-0.309637721848,
	-0.310113549390,-0.310589199887,-0.311064673384,-0.311539969926,-0.312015089559,
	-0.312490032328,-0.312964798277,-0.313439387453,-0.313913799900,-0.314388035663,
	-0.314862094789,-0.315335977321,-0.315809683305,-0.316283212786,-0.316756565810,
	-0.317229742421,-0.317702742666,-0.318175566588,-0.318648214233,-0.319120685646,
	-0.319592980872,-0.320065099957,-0.320537042946,-0.321008809883,-0.321480400814,
	-0.321951815784,-0.322423054838,-0.322894118021,-0.323365005378,-0.323835716954,
	-0.324306252795,-0.324776612945,-0.325246797449,-0.325716806353,-0.326186639702,
	-0.326656297540,-0.327125779913,-0.327595086866,-0.328064218443,-0.328533174690,
	-0.329001955651,-0.329470561373,-0.329938991899,-0.330407247275,-0.330875327545,
	-0.331343232756,-0.331810962951,-0.332278518175,-0.332745898475,-0.333213103894,
	-0.333680134477,-0.334146990270,-0.334613671317,-0.335080177663,-0.335546509354,
	-0.336012666434,-0.336478648948,-0.336944456941,-0.337410090457,-0.337875549543,
	-0.338340834242,-0.338805944599,-0.339270880660,-0.339735642469,-0.340200230072,
	-0.340664643512,-0.341128882835,-0.341592948085,-0.342056839308,-0.342520556548,
	-0.342984099850,-0.343447469259,-0.343910664819,-0.344373686576,-0.344836534574,
	-0.345299208859,-0.345761709473,-0.346224036464,-0.346686189874,-0.347148169750,
	-0.347609976135,-0.348071609074,-0.348533068613,-0.348994354796,-0.349455467667,
	-0.349916407271,-0.350377173654,-0.350837766859,-0.351298186931,-0.351758433916,
	-0.352218507857,-0.352678408799,-0.353138136787,-0.353597691866,-0.354057074080,
	-0.354516283474,-0.354975320092,-0.355434183979,-0.355892875180,-0.356351393739,
	-0.356809739700,-0.357267913109,-0.357725914010,-0.358183742448,-0.358641398466,
	-0.359098882110,-0.359556193424,-0.360013332453,-0.360470299241,-0.360927093832,
	-0.361383716271,-0.361840166604,-0.362296444873,-0.362752551123,-0.363208485400,
	-0.363664247747,-0.364119838209,-0.364575256830,-0.365030503655,-0.365485578729,
	-0.365940482094,-0.366395213797,-0.366849773882,-0.367304162391,-0.367758379372,
	-0.368212424866,-0.368666298920,-0.369120001576,-0.369573532881,-0.370026892877,
	-0.370480081609,-0.370933099122,-0.371385945460,-0.371838620666,-0.372291124787,
	-0.372743457865,-0.373195619944,-0.373647611070,-0.374099431287,-0.374551080638,
	-0.375002559168,-0.375453866922,-0.375905003942,-0.376355970274,-0.376806765962,
	-0.377257391050,-0.377707845582,-0.378158129603,-0.378608243155,-0.379058186285,
	-0.379507959035,-0.379957561450,-0.380406993574,-0.380856255451,-0.381305347125,
	-0.381754268640,-0.382203020041,-0.382651601372,-0.383100012675,-0.383548253997,
	-0.383996325380,-0.384444226868,-0.384891958506,-0.385339520338,-0.385786912407,
	-0.386234134758,-0.386681187435,-0.387128070481,-0.387574783941,-0.388021327859,
	-0.388467702278,-0.388913907242,-0.389359942795,-0.389805808982,-0.390251505846,
	-0.390697033431,-0.391142391781,-0.391587580940,-0.392032600951,-0.392477451859,
	-0.392922133707,-0.393366646539,-0.393810990400,-0.394255165332,-0.394699171380,
	-0.395143008587,-0.395586676997,-0.396030176654,-0.396473507602,-0.396916669885,
	-0.397359663545,-0.397802488628,-0.398245145176,-0.398687633234,-0.399129952844,
	-0.399572104052,-0.400014086899,-0.400455901431,-0.400897547691,-0.401339025722,
	-0.401780335567,-0.402221477272,-0.402662450879,-0.403103256431,-0.403543893973,
	-0.403984363548,-0.404424665200,-0.404864798971,-0.405304764907,-0.405744563049,
	-0.406184193443,-0.406623656130,-0.407062951155,-0.407502078562,-0.407941038393,
	-0.408379830693,-0.408818455504,-0.409256912870,-0.409695202834,-0.410133325441,
	-0.410571280733,-0.411009068754,-0.411446689546,-0.411884143155,-0.412321429622,
	-0.412758548992,-0.413195501307,-0.413632286611,-0.414068904947,-0.414505356359,
	-0.414941640890,-0.415377758583,-0.415813709481,-0.416249493628,-0.416685111067,
	-0.417120561841,-0.417555845994,-0.417990963568,-0.418425914607,-0.418860699154,
	-0.419295317252,-0.419729768945,-0.420164054275,-0.420598173286,-0.421032126021,
	-0.421465912522,-0.421899532834,-0.422332986999,-0.422766275060,-0.423199397061,
	-0.423632353044,-0.424065143052,-0.424497767129,-0.424930225318,-0.425362517661,
	-0.425794644201,-0.426226604982,-0.426658400047,-0.427090029438,-0.427521493198,
	-0.427952791371,-0.428383924000,-0.428814891126,-0.429245692794,-0.429676329046,
	-0.430106799924,-0.430537105473,-0.430967245734,-0.431397220750,-0.431827030565,
	-0.432256675221,-0.432686154761,-0.433115469228,-0.433544618665,-0.433973603113,
	-0.434402422617,-0.434831077219,-0.435259566961,-0.435687891886,-0.436116052038,
	-0.436544047458,-0.436971878189,-0.437399544275,-0.437827045757,-0.438254382679,
	-0.438681555082,-0.439108563010,-0.439535406506,-0.439962085611,-0.440388600368,
	-0.440814950821,-0.441241137011,-0.441667158981,-0.442093016773,-0.442518710431,
	-0.442944239996,-0.443369605512,-0.443794807019,-0.444219844562,-0.444644718183,
	-0.445069427923,-0.445493973826,-0.445918355933,-0.446342574287,-0.446766628932,
	-0.447190519907,-0.447614247258,-0.448037811025,-0.448461211250,-0.448884447977,
	-0.449307521248,-0.449730431104,-0.450153177589,-0.450575760744,-0.450998180612,
	-0.451420437234,-0.451842530654,-0.452264460913,-0.452686228053,-0.453107832118,
	-0.453529273148,-0.453950551186,-0.454371666274,-0.454792618455,-0.455213407770,
	-0.455634034261,-0.456054497972,-0.456474798943,-0.456894937216,-0.457314912835,
	-0.457734725840,-0.458154376274,-0.458573864179,-0.458993189597,-0.459412352570,
	-0.459831353139,-0.460250191348,-0.460668867237,-0.461087380848,-0.461505732224,
	-0.461923921407,-0.462341948438,-0.462759813359,-0.463177516211,-0.463595057038,
	-0.464012435881,-0.464429652781,-0.464846707780,-0.465263600920,-0.465680332243,
	-0.466096901791,-0.466513309605,-0.466929555727,-0.467345640199,-0.467761563062,
	-0.468177324358,-0.468592924130,-0.469008362417,-0.469423639263,-0.469838754708,
	-0.470253708795,-0.470668501564,-0.471083133058,-0.471497603319,-0.471911912386,
	-0.472326060303,-0.472740047111,-0.473153872850,-0.473567537564,-0.473981041292,
	-0.474394384077,-0.474807565960,-0.475220586983,-0.475633447186,-0.476046146612,
	-0.476458685301,-0.476871063296,-0.477283280636,-0.477695337365,-0.478107233523,
	-0.478518969151,-0.478930544290,-0.479341958983,-0.479753213270,-0.480164307193,
	-0.480575240792,-0.480986014109,-0.481396627185,-0.481807080062,-0.482217372780,
	-0.482627505381,-0.483037477905,-0.483447290395,-0.483856942891,-0.484266435434,
	-0.484675768065,-0.485084940826,-0.485493953756,-0.485902806899,-0.486311500294,
	-0.486720033982,-0.487128408005,-0.487536622403,-0.487944677217,-0.488352572489,
	-0.488760308260,-0.489167884569,-0.489575301458,-0.489982558969,-0.490389657141,
	-0.490796596016,-0.491203375634,-0.491609996037,-0.492016457265,-0.492422759359,
	-0.492828902360,-0.493234886308,-0.493640711244,-0.494046377209,-0.494451884244,
	-0.494857232389,-0.495262421685,-0.495667452173,-0.496072323893,-0.496477036886,
	-0.496881591193,-0.497285986854,-0.497690223909,-0.498094302400,-0.498498222367,
	-0.498901983850,-0.499305586890,-0.499709031528,-0.500112317803,-0.500515445756,
	-0.500918415429,-0.501321226861,-0.501723880092,-0.502126375163,-0.502528712115,
	-0.502930890988,-0.503332911821,-0.503734774657,-0.504136479534,-0.504538026493,
	-0.504939415574,-0.505340646819,-0.505741720266,-0.506142635956,-0.506543393930,
	-0.506943994227,-0.507344436888,-0.507744721953,-0.508144849462,-0.508544819455,
	-0.508944631973,-0.509344287055,-0.509743784742,-0.510143125073,-0.510542308088,
	-0.510941333829,-0.511340202334,-0.511738913644,-0.512137467798,-0.512535864838,
	-0.512934104801,-0.513332187730,-0.513730113662,-0.514127882639,-0.514525494701,
	-0.514922949886,-0.515320248235,-0.515717389788,-0.516114374584,-0.516511202664,
	-0.516907874067,-0.517304388833,-0.517700747002,-0.518096948612,-0.518492993705,
	-0.518888882320,-0.519284614496,-0.519680190273,-0.520075609690,-0.520470872788,
	-0.520865979606,-0.521260930184,-0.521655724560,-0.522050362775,-0.522444844868,
	-0.522839170879,-0.523233340847,-0.523627354812,-0.524021212813,-0.524414914889,
	-0.524808461080,-0.525201851425,-0.525595085964,-0.525988164737,-0.526381087781,
	-0.526773855138,-0.527166466845,-0.527558922943,-0.527951223471,-0.528343368467,
	-0.528735357972,-0.529127192024,-0.529518870662,-0.529910393926,-0.530301761856,
	-0.530692974489,-0.531084031866,-0.531474934024,-0.531865681005,-0.532256272845,
	-0.532646709586,-0.533036991265,-0.533427117921,-0.533817089594,-0.534206906323,
	-0.534596568146,-0.534986075103,-0.535375427232,-0.535764624572,-0.536153667163,
	-0.536542555043,-0.536931288251,-0.537319866825,-0.537708290805,-0.538096560229,
	-0.538484675137,-0.538872635567,-0.539260441557,-0.539648093146,-0.540035590374,
	-0.540422933278,-0.540810121898,-0.541197156271,-0.541584036438,-0.541970762435,
	-0.542357334303,-0.542743752079,-0.543130015802,-0.543516125510,-0.543902081243,
	-0.544287883037,-0.544673530933,-0.545059024968,-0.545444365181,-0.545829551611,
	-0.546214584294,-0.546599463271,-0.546984188580,-0.547368760257,-0.547753178343,
	-0.548137442875,-0.548521553892,-0.548905511431,-0.549289315532,-0.549672966231,
	-0.550056463569,-0.550439807581,-0.550822998308,-0.551206035786,-0.551588920054,
	-0.551971651151,-0.552354229113,-0.552736653980,-0.553118925789,-0.553501044578,
	-0.553883010386,-0.554264823249,-0.554646483207,-0.555027990297,-0.555409344557,
	-0.555790546025,-0.556171594738,-0.556552490735,-0.556933234054,-0.557313824732,
	-0.557694262806,-0.558074548316,-0.558454681298,-0.558834661790,-0.559214489830,
	-0.559594165456,-0.559973688706,-0.560353059616,-0.560732278224,-0.561111344569,
	-0.561490258688,-0.561869020617,-0.562247630396,-0.562626088061,-0.563004393650,
	-0.563382547200,-0.563760548749,-0.564138398334,-0.564516095993,-0.564893641762,
	-0.565271035680,-0.565648277784,-0.566025368111,-0.566402306697,-0.566779093582,
	-0.567155728802,-0.567532212393,-0.567908544394,-0.568284724841,-0.568660753772,
	-0.569036631224,-0.569412357234,-0.569787931839,-0.570163355076,-0.570538626982,
	-0.570913747594,-0.571288716950,-0.571663535086,-0.572038202035,-0.572412717842,
	-0.572787082541,-0.573161296167,-0.573535358759,-0.573909270352,-0.574283030985,
	-0.574656640692,-0.575030099512,-0.575403407481,-0.575776564635,-0.576149571012,
	-0.576522426649,-0.576895131581,-0.577267685846,-0.577640089480,-0.578012342520,
	-0.578384445002,-0.578756396964,-0.579128198441,-0.579499849470,-0.579871350087,
	-0.580242700330,-0.580613900234,-0.580984949836,-0.581355849173,-0.581726598280,
	-0.582097197195,-0.582467645953,-0.582837944591,-0.583208093145,-0.583578091651,
	-0.583947940146,-0.584317638666,-0.584687187246,-0.585056585924,-0.585425834736,
	-0.585794933717,-0.586163882904,-0.586532682332,-0.586901332038,-0.587269832058,
	-0.587638182428,-0.588006383184,-0.588374434361,-0.588742335997,-0.589110088125,
	-0.589477690784,-0.589845144008,-0.590212447833,-0.590579602295,-0.590946607431,
	-0.591313463275,-0.591680169863,-0.592046727232,-0.592413135416,-0.592779394452,
	-0.593145504375,-0.593511465221,-0.593877277025,-0.594242939824,-0.594608453652,
	-0.594973818545,-0.595339034538,-0.595704101668,-0.596069019970,-0.596433789478,
	-0.596798410229,-0.597162882257,-0.597527205599,-0.597891380289,-0.598255406362,
	-0.598619283855,-0.598983012802,-0.599346593239,-0.599710025200,-0.600073308722,
	-0.600436443838,-0.600799430584,-0.601162268996,-0.601524959109,-0.601887500956,
	-0.602249894574,-0.602612139998,-0.602974237262,-0.603336186402,-0.603697987451,
	-0.604059640446,-0.604421145421,-0.604782502411,-0.605143711451,-0.605504772575,
	-0.605865685819,-0.606226451217,-0.606587068803,-0.606947538613,-0.607307860681,
	-0.607668035042,-0.608028061730,-0.608387940780,-0.608747672227,-0.609107256104,
	-0.609466692447,-0.609825981291,-0.610185122668,-0.610544116615,-0.610902963165,
	-0.611261662352,-0.611620214212,-0.611978618777,-0.612336876084,-0.612694986165,
	-0.613052949056,-0.613410764789,-0.613768433400,-0.614125954923,-0.614483329392,
	-0.614840556840,-0.615197637302,-0.615554570813,-0.615911357405,-0.616267997113,
	-0.616624489971,-0.616980836013,-0.617337035273,-0.617693087784,-0.618048993581,
	-0.618404752697,-0.618760365166,-0.619115831022,-0.619471150298,-0.619826323029,
	-0.620181349248,-0.620536228988,-0.620890962284,-0.621245549168,-0.621599989674,
	-0.621954283837,-0.622308431689,-0.622662433264,-0.623016288595,-0.623369997716,
	-0.623723560659,-0.624076977460,-0.624430248150,-0.624783372763,-0.625136351333,
	-0.625489183892,-0.625841870475,-0.626194411113,-0.626546805840,-0.626899054690,
	-0.627251157694,-0.627603114888,-0.627954926303,-0.628306591972,-0.628658111929,
	-0.629009486206,-0.629360714837,-0.629711797853,-0.630062735289,-0.630413527177,
	-0.630764173549,-0.631114674439,-0.631465029878,-0.631815239901,-0.632165304539,
	-0.632515223826,-0.632864997793,-0.633214626473,-0.633564109900,-0.633913448105,
	-0.634262641120,-0.634611688979,-0.634960591714,-0.635309349357,-0.635657961941,
	-0.636006429497,-0.636354752059,-0.636702929657,-0.637050962326,-0.637398850096,
	-0.637746427749,-0.638093585013,-0.638440441559,-0.638787031235,-0.639133372309,
	-0.639479476733,-0.639825353131,-0.640171008113,-0.640516446959,-0.640861674017,
	-0.641206692950,-0.641551506899,-0.641896118601,-0.642240530469,-0.642584744651,
	-0.642928763075,-0.643272587488,-0.643616219482,-0.643959660515,-0.644302911931,
	-0.644645974972,-0.644988850793,-0.645331540472,-0.645674045017,-0.646016365375,
	-0.646358502436,-0.646700457041,-0.647042229987,-0.647383822026,-0.647725233877,
	-0.648066466220,-0.648407519708,-0.648748394961,-0.649089092575,-0.649429613119,
	-0.649769957139,-0.650110125162,-0.650450117693,-0.650789935218,-0.651129578206,
	-0.651469047110,-0.651808342367,-0.652147464401,-0.652486413621,-0.652825190424,
	-0.653163795193,-0.653502228302,-0.653840490114,-0.654178580979,-0.654516501241,
	-0.654854251232,-0.655191831276,-0.655529241689,-0.655866482779,-0.656203554845,
	-0.656540458182,-0.656877193074,-0.657213759801,-0.657550158636,-0.657886389846,
	-0.658222453691,-0.658558350428,-0.658894080306,-0.659229643570,-0.659565040460,
	-0.659900271212,-0.660235336055,-0.660570235216,-0.660904968918,-0.661239537376,
	-0.661573940807,-0.661908179418,-0.662242253418,-0.662576163008,-0.662909908388,
	-0.663243489754,-0.663576907298,-0.663910161211,-0.664243251678,-0.664576178884,
	-0.664908943009,-0.665241544231,-0.665573982726,-0.665906258667,-0.666238372224,
	-0.666570323564,-0.666902112853,-0.667233740255,-0.667565205930,-0.667896510036,
	-0.668227652732,-0.668558634170,-0.668889454505,-0.669220113885,-0.669550612461,
	-0.669880950378,-0.670211127782,-0.670541144816,-0.670871001622,-0.671200698339,
	-0.671530235105,-0.671859612058,-0.672188829331,-0.672517887060,-0.672846785375,
	-0.673175524407,-0.673504104286,-0.673832525138,-0.674160787092,-0.674488890270,
	-0.674816834799,-0.675144620798,-0.675472248391,-0.675799717697,-0.676127028834,
	-0.676454181921,-0.676781177074,-0.677108014409,-0.677434694038,-0.677761216077,
	-0.678087580636,-0.678413787828,-0.678739837762,-0.679065730546,-0.679391466290,
	-0.679717045101,-0.680042467084,-0.680367732345,-0.680692840989,-0.681017793118,
	-0.681342588835,-0.681667228243,-0.681991711442,-0.682316038532,-0.682640209613,
	-0.682964224782,-0.683288084138,-0.683611787777,-0.683935335796,-0.684258728290,
	-0.684581965354,-0.684905047081,-0.685227973565,-0.685550744899,-0.685873361173,
	-0.686195822480,-0.686518128910,-0.686840280552,-0.687162277496,-0.687484119831,
	-0.687805807643,-0.688127341021,-0.688448720052,-0.688769944821,-0.689091015413,
	-0.689411931914,-0.689732694409,-0.690053302980,-0.690373757711,-0.690694058684,
	-0.691014205982,-0.691334199687,-0.691654039879,-0.691973726639,-0.692293260047,
	-0.692612640182,-0.692931867123,-0.693250940949,-0.693569861739,-0.693888629568,
	-0.694207244515,-0.694525706656,-0.694844016067,-0.695162172824,-0.695480177002,
	-0.695798028676,-0.696115727920,-0.696433274808,-0.696750669413,-0.697067911809,
	-0.697385002067,-0.697701940261,-0.698018726462,-0.698335360742,-0.698651843171,
	-0.698968173819,-0.699284352758,-0.699600380057,-0.699916255785,-0.700231980011,
	-0.700547552805,-0.700862974233,-0.701178244365,-0.701493363268,-0.701808331008,
	-0.702123147653,-0.702437813269,-0.702752327922,-0.703066691679,-0.703380904604,
	-0.703694966762,-0.704008878219,-0.704322639039,-0.704636249286,-0.704949709023,
	-0.705263018314,-0.705576177223,-0.705889185811,-0.706202044142,-0.706514752278,
	-0.706827310280,-0.707139718211,-0.707451976131,-0.707764084101,-0.708076042182,
	-0.708387850435,-0.708699508919,-0.709011017695,-0.709322376821,-0.709633586358,
	-0.709944646363,-0.710255556895,-0.710566318015,-0.710876929778,-0.711187392243,
	-0.711497705467,-0.711807869509,-0.712117884424,-0.712427750270,-0.712737467102,
	-0.713047034979,-0.713356453954,-0.713665724084,-0.713974845424,-0.714283818031,
	-0.714592641958,-0.714901317260,-0.715209843992,-0.715518222209,-0.715826451963,
	-0.716134533309,-0.716442466300,-0.716750250989,-0.717057887430,-0.717365375675,
	-0.717672715777,-0.717979907788,-0.718286951761,-0.718593847746,-0.718900595796,
	-0.719207195962,-0.719513648295,-0.719819952846,-0.720126109666,-0.720432118806,
	-0.720737980315,-0.721043694243,-0.721349260642,-0.721654679559,-0.721959951045,
	-0.722265075149,-0.722570051920,-0.722874881406,-0.723179563656,-0.723484098719,
	-0.723788486642,-0.724092727474,-0.724396821262,-0.724700768054,-0.725004567897,
	-0.725308220839,-0.725611726925,-0.725915086203,-0.726218298721,-0.726521364522,
	-0.726824283655,-0.727127056164,-0.727429682096,-0.727732161497,-0.728034494410,
	-0.728336680882,-0.728638720958,-0.728940614682,-0.729242362100,-0.729543963254,
	-0.729845418190,-0.730146726952,-0.730447889583,-0.730748906127,-0.731049776628,
	-0.731350501128,-0.731651079672,-0.731951512301,-0.732251799058,-0.732551939987,
	-0.732851935130,-0.733151784528,-0.733451488223,-0.733751046258,-0.734050458674,
	-0.734349725513,-0.734648846815,-0.734947822623,-0.735246652976,-0.735545337917,
	-0.735843877484,-0.736142271719,-0.736440520663,-0.736738624354,-0.737036582833,
	-0.737334396140,-0.737632064314,-0.737929587395,-0.738226965421,-0.738524198433,
	-0.738821286468,-0.739118229566,-0.739415027765,-0.739711681103,-0.740008189619,
	-0.740304553350,-0.740600772335,-0.740896846612,-0.741192776217,-0.741488561188,
	-0.741784201562,-0.742079697378,-0.742375048670,-0.742670255476,-0.742965317833,
	-0.743260235777,-0.743555009344,-0.743849638571,-0.744144123493,-0.744438464146,
	-0.744732660565,-0.745026712786,-0.745320620845,-0.745614384776,-0.745908004614,
	-0.746201480395,-0.746494812152,-0.746787999921,-0.747081043735,-0.747373943628,
	-0.747666699636,-0.747959311791,-0.748251780127,-0.748544104678,-0.748836285477,
	-0.749128322557,-0.749420215952,-0.749711965695,-0.750003571817,-0.750295034352,
	-0.750586353332,-0.750877528789,-0.751168560756,-0.751459449264,-0.751750194346,
	-0.752040796032,-0.752331254355,-0.752621569346,-0.752911741035,-0.753201769455,
	-0.753491654636,-0.753781396608,-0.754070995403,-0.754360451050,-0.754649763581,
	-0.754938933024,-0.755227959410,-0.755516842770,-0.755805583132,-0.756094180526,
	-0.756382634981,-0.756670946527,-0.756959115193,-0.757247141007,-0.757535023999,
	-0.757822764197,-0.758110361629,-0.758397816324,-0.758685128310,-0.758972297614,
	-0.759259324265,-0.759546208291,-0.759832949719,-0.760119548576,-0.760406004889,
	-0.760692318687,-0.760978489995,-0.761264518840,-0.761550405249,-0.761836149249,
	-0.762121750866,-0.762407210125,-0.762692527054,-0.762977701678,-0.763262734022,
	-0.763547624113,-0.763832371975,-0.764116977634,-0.764401441115,-0.764685762443,
	-0.764969941643,-0.765253978740,-0.765537873758,-0.765821626721,-0.766105237654,
	-0.766388706580,-0.766672033524,-0.766955218509,-0.767238261560,-0.767521162699,
	-0.767803921949,-0.768086539335,-0.768369014878,-0.768651348602,-0.768933540530,
	-0.769215590683,-0.769497499085,-0.769779265758,-0.770060890723,-0.770342374002,
	-0.770623715620,-0.770904915593,-0.771185973949,-0.771466890702,-0.771747665880,
	-0.772028299500,-0.772308791586,-0.772589142154,-0.772869351228,-0.773149418828,
	-0.773429344974,-0.773709129686,-0.773988772984,-0.774268274888,-0.774547635417,
	-0.774826854592,-0.775105932430,-0.775384868952,-0.775663664176,-0.775942318122,
	-0.776220830808,-0.776499202252,-0.776777432474,-0.777055521491,-0.777333469321,
	-0.777611275982,-0.777888941492,-0.778166465870,-0.778443849131,-0.778721091294,
	-0.778998192375,-0.779275152392,-0.779551971362,-0.779828649301,-0.780105186225,
	-0.780381582152,-0.780657837097,-0.780933951076,-0.781209924105,-0.781485756201,
	-0.781761447378,-0.782036997652,-0.782312407038,-0.782587675551,-0.782862803207,
	-0.783137790020,-0.783412636004,-0.783687341175,-0.783961905546,-0.784236329131,
	-0.784510611945,-0.784784754002,-0.785058755314,-0.785332615896,-0.785606335761,
	-0.785879914921,-0.786153353391,-0.786426651183,-0.786699808309,-0.786972824782,
	-0.787245700614,-0.787518435819,-0.787791030406,-0.788063484389,-0.788335797780,
	-0.788607970589,-0.788880002827,-0.789151894508,-0.789423645640,-0.789695256236,
	-0.789966726305,-0.790238055859,-0.790509244907,-0.790780293461,-0.791051201529,
	-0.791321969122,-0.791592596249,-0.791863082921,-0.792133429146,-0.792403634933,
	-0.792673700292,-0.792943625231,-0.793213409759,-0.793483053885,-0.793752557617,
	-0.794021920963,-0.794291143931,-0.794560226528,-0.794829168763,-0.795097970643,
	-0.795366632175,-0.795635153367,-0.795903534225,-0.796171774755,-0.796439874966,
	-0.796707834862,-0.796975654451,-0.797243333738,-0.797510872730,-0.797778271431,
	-0.798045529848,-0.798312647986,-0.798579625849,-0.798846463444,-0.799113160775,
	-0.799379717846,-0.799646134662,-0.799912411228,-0.800178547547,-0.800444543623,
	-0.800710399460,-0.800976115061,-0.801241690431,-0.801507125572,-0.801772420487,
	-0.802037575179,-0.802302589650,-0.802567463904,-0.802832197942,-0.803096791766,
	-0.803361245379,-0.803625558782,-0.803889731977,-0.804153764964,-0.804417657746,
	-0.804681410322,-0.804945022695,-0.805208494864,-0.805471826829,-0.805735018592,
	-0.805998070152,-0.806260981509,-0.806523752662,-0.806786383612,-0.807048874356,
	-0.807311224895,-0.807573435227,-0.807835505351,-0.808097435266,-0.808359224969,
	-0.808620874458,-0.808882383733,-0.809143752789,-0.809404981626,-0.809666070239,
	-0.809927018627,-0.810187826786,-0.810448494712,-0.810709022404,-0.810969409855,
	-0.811229657064,-0.811489764025,-0.811749730735,-0.812009557189,-0.812269243381,
	-0.812528789308,-0.812788194965,-0.813047460345,-0.813306585444,-0.813565570255,
	-0.813824414773,-0.814083118992,-0.814341682905,-0.814600106506,-0.814858389788,
	-0.815116532743,-0.815374535366,-0.815632397648,-0.815890119583,-0.816147701161,
	-0.816405142375,-0.816662443217,-0.816919603679,-0.817176623751,-0.817433503426,
	-0.817690242693,-0.817946841544,-0.818203299968,-0.818459617957,-0.818715795501,
	-0.818971832589,-0.819227729210,-0.819483485355,-0.819739101012,-0.819994576170,
	-0.820249910819,-0.820505104946,-0.820760158540,-0.821015071590,-0.821269844082,
	-0.821524476004,-0.821778967345,-0.822033318090,-0.822287528228,-0.822541597744,
	-0.822795526626,-0.823049314859,-0.823302962429,-0.823556469323,-0.823809835526,
	-0.824063061023,-0.824316145800,-0.824569089841,-0.824821893131,-0.825074555654,
	-0.825327077395,-0.825579458338,-0.825831698466,-0.826083797762,-0.826335756211,
	-0.826587573794,-0.826839250495,-0.827090786297,-0.827342181181,-0.827593435129,
	-0.827844548124,-0.828095520148,-0.828346351180,-0.828597041203,-0.828847590197,
	-0.829097998143,-0.829348265021,-0.829598390811,-0.829848375493,-0.830098219048,
	-0.830347921453,-0.830597482688,-0.830846902733,-0.831096181565,-0.831345319163,
	-0.831594315505,-0.831843170569,-0.832091884333,-0.832340456773,-0.832588887868,
	-0.832837177593,-0.833085325926,-0.833333332842
	}
};

double always_inline output12ax7clip(double x) {
    double f = fabs(x);
    f = f * output12ax7_table.istep;
    int i = static_cast<int>(f);
    if (i < 0) {
        f = output12ax7_table.data[0];
    } else if (i >= output12ax7_table.size-1) {
        f = output12ax7_table.data[output12ax7_table.size-1];
    } else {
    f -= i;
    f = output12ax7_table.data[i]*(1-f) + output12ax7_table.data[i+1]*f;
    }
    return copysign(f, x);
}

