info = {
    "name": "ga",
    "date_order": "DMY",
    "january": [
        "ean",
        "eanáir"
    ],
    "february": [
        "feabh",
        "feabhra"
    ],
    "march": [
        "márta"
    ],
    "april": [
        "aib",
        "aibreán"
    ],
    "may": [
        "beal",
        "bealtaine"
    ],
    "june": [
        "meith",
        "meitheamh"
    ],
    "july": [
        "iúil"
    ],
    "august": [
        "lún",
        "lúnasa"
    ],
    "september": [
        "meán fómhair",
        "mfómh"
    ],
    "october": [
        "deireadh fómhair",
        "dfómh"
    ],
    "november": [
        "samh",
        "samhain"
    ],
    "december": [
        "noll",
        "nollaig"
    ],
    "monday": [
        "dé luain",
        "luan"
    ],
    "tuesday": [
        "dé máirt",
        "máirt"
    ],
    "wednesday": [
        "céad",
        "dé céadaoin"
    ],
    "thursday": [
        "déar",
        "déardaoin"
    ],
    "friday": [
        "aoine",
        "dé haoine"
    ],
    "saturday": [
        "dé sathairn",
        "sath"
    ],
    "sunday": [
        "domh",
        "dé domhnaigh"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "bl",
        "bliain"
    ],
    "month": [
        "mí"
    ],
    "week": [
        "scht",
        "seachtain"
    ],
    "day": [
        "lá"
    ],
    "hour": [
        "u",
        "uair"
    ],
    "minute": [
        "n",
        "nóim",
        "nóiméad"
    ],
    "second": [
        "s",
        "soic",
        "soicind"
    ],
    "relative-type": {
        "0 day ago": [
            "inniu"
        ],
        "0 hour ago": [
            "an uair seo"
        ],
        "0 minute ago": [
            "an nóiméad seo"
        ],
        "0 month ago": [
            "an mhí seo"
        ],
        "0 second ago": [
            "anois"
        ],
        "0 week ago": [
            "an tscht seo",
            "an tseachtain seo"
        ],
        "0 year ago": [
            "an bhl seo",
            "an bhliain seo"
        ],
        "1 day ago": [
            "inné"
        ],
        "1 month ago": [
            "an mhí seo caite"
        ],
        "1 week ago": [
            "an tscht seo caite",
            "an tseachtain seo caite"
        ],
        "1 year ago": [
            "anuraidh"
        ],
        "in 1 day": [
            "amárach"
        ],
        "in 1 month": [
            "an mhí seo chugainn"
        ],
        "in 1 week": [
            "an tscht seo chugainn",
            "an tseachtain seo chugainn"
        ],
        "in 1 year": [
            "an bhl seo chugainn",
            "an bhliain seo chugainn"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "(\\d+[.,]?\\d*) lá ó shin"
        ],
        "\\1 hour ago": [
            "(\\d+[.,]?\\d*) uair an chloig ó shin",
            "(\\d+[.,]?\\d*) uair ó shin"
        ],
        "\\1 minute ago": [
            "(\\d+[.,]?\\d*) nóim ó shin",
            "(\\d+[.,]?\\d*) nóiméad ó shin"
        ],
        "\\1 month ago": [
            "(\\d+[.,]?\\d*) mhí ó shin",
            "(\\d+[.,]?\\d*) mí ó shin"
        ],
        "\\1 second ago": [
            "(\\d+[.,]?\\d*) soic ó shin",
            "(\\d+[.,]?\\d*) soicind ó shin"
        ],
        "\\1 week ago": [
            "(\\d+[.,]?\\d*) scht ó shin",
            "(\\d+[.,]?\\d*) seachtain ó shin"
        ],
        "\\1 year ago": [
            "(\\d+[.,]?\\d*) bhl ó shin",
            "(\\d+[.,]?\\d*) bhliain ó shin",
            "(\\d+[.,]?\\d*) bl ó shin",
            "(\\d+[.,]?\\d*) bliain ó shin"
        ],
        "in \\1 day": [
            "i gceann (\\d+[.,]?\\d*) lá"
        ],
        "in \\1 hour": [
            "i gceann (\\d+[.,]?\\d*) uair",
            "i gceann (\\d+[.,]?\\d*) uair an chloig"
        ],
        "in \\1 minute": [
            "i gceann (\\d+[.,]?\\d*) nóim",
            "i gceann (\\d+[.,]?\\d*) nóiméad"
        ],
        "in \\1 month": [
            "i gceann (\\d+[.,]?\\d*) mhí",
            "i gceann (\\d+[.,]?\\d*) mí"
        ],
        "in \\1 second": [
            "i gceann (\\d+[.,]?\\d*) soic",
            "i gceann (\\d+[.,]?\\d*) soicind"
        ],
        "in \\1 week": [
            "i gceann (\\d+[.,]?\\d*) scht",
            "i gceann (\\d+[.,]?\\d*) seachtain"
        ],
        "in \\1 year": [
            "i gceann (\\d+[.,]?\\d*) bhliain",
            "i gceann (\\d+[.,]?\\d*) bl",
            "i gceann (\\d+[.,]?\\d*) bliain"
        ]
    },
    "locale_specific": {},
    "skip": [
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ]
}
