//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#ifndef PXR_IMAGING_HD_PLANE_SCHEMA_H
#define PXR_IMAGING_HD_PLANE_SCHEMA_H

/// \file

#include "pxr/imaging/hd/api.h"

#include "pxr/imaging/hd/schema.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

// --(BEGIN CUSTOM CODE: Declares)--
// --(END CUSTOM CODE: Declares)--

#define HD_PLANE_SCHEMA_TOKENS \
    (plane) \
    (doubleSided) \
    (axis) \
    (length) \
    (width) \
    (X) \
    (Y) \
    (Z) \

TF_DECLARE_PUBLIC_TOKENS(HdPlaneSchemaTokens, HD_API,
    HD_PLANE_SCHEMA_TOKENS);

//-----------------------------------------------------------------------------


/// \class HdPlaneSchema
///
class HdPlaneSchema : public HdSchema
{
public:
    /// \name Schema retrieval
    /// @{

    HdPlaneSchema(HdContainerDataSourceHandle container)
      : HdSchema(container) {}

    /// Retrieves a container data source with the schema's default name token
    /// "plane" from the parent container and constructs a
    /// HdPlaneSchema instance.
    /// Because the requested container data source may not exist, the result
    /// should be checked with IsDefined() or a bool comparison before use.
    HD_API
    static HdPlaneSchema GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer);

    /// @}

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

    /// \name Member accessor
    /// @{

    HD_API
    HdBoolDataSourceHandle GetDoubleSided() const;

    HD_API
    HdTokenDataSourceHandle GetAxis() const;

    HD_API
    HdDoubleDataSourceHandle GetLength() const;

    HD_API
    HdDoubleDataSourceHandle GetWidth() const; 

    /// @}

    /// \name Schema location
    /// @{

    /// Returns a token where the container representing this schema is found in
    /// a container by default.
    HD_API
    static const TfToken &GetSchemaToken();

    /// Returns an HdDataSourceLocator (relative to the prim-level data source)
    /// where the container representing this schema is found by default.
    HD_API
    static const HdDataSourceLocator &GetDefaultLocator();

    /// @} 

    /// \name Schema construction
    /// @{

    /// \deprecated Use Builder instead.
    ///
    /// Builds a container data source which includes the provided child data
    /// sources. Parameters with nullptr values are excluded. This is a
    /// low-level interface. For cases in which it's desired to define
    /// the container with a sparse set of child fields, the Builder class
    /// is often more convenient and readable.
    HD_API
    static HdContainerDataSourceHandle
    BuildRetained(
        const HdBoolDataSourceHandle &doubleSided,
        const HdTokenDataSourceHandle &axis,
        const HdDoubleDataSourceHandle &length,
        const HdDoubleDataSourceHandle &width
    );

    /// \class HdPlaneSchema::Builder
    /// 
    /// Utility class for setting sparse sets of child data source fields to be
    /// filled as arguments into BuildRetained. Because all setter methods
    /// return a reference to the instance, this can be used in the "builder
    /// pattern" form.
    class Builder
    {
    public:
        HD_API
        Builder &SetDoubleSided(
            const HdBoolDataSourceHandle &doubleSided);
        HD_API
        Builder &SetAxis(
            const HdTokenDataSourceHandle &axis);
        HD_API
        Builder &SetLength(
            const HdDoubleDataSourceHandle &length);
        HD_API
        Builder &SetWidth(
            const HdDoubleDataSourceHandle &width);

        /// Returns a container data source containing the members set thus far.
        HD_API
        HdContainerDataSourceHandle Build();

    private:
        HdBoolDataSourceHandle _doubleSided;
        HdTokenDataSourceHandle _axis;
        HdDoubleDataSourceHandle _length;
        HdDoubleDataSourceHandle _width;

    };

    /// Returns token data source for use as axis value.
    ///
    /// The following values will be stored statically and reused for future
    /// calls:
    /// - HdPlaneSchemaTokens->X
    /// - HdPlaneSchemaTokens->Y
    /// - HdPlaneSchemaTokens->Z
    HD_API
    static HdTokenDataSourceHandle BuildAxisDataSource(
        const TfToken &axis);

    /// @}
};

PXR_NAMESPACE_CLOSE_SCOPE

#endif