/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.dfa;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.regex.tregex.automaton.TransitionOp;
import com.oracle.truffle.regex.tregex.nodes.dfa.CounterTracker;
import com.oracle.truffle.regex.tregex.nodes.dfa.CounterTrackerData;
import java.util.Arrays;

public class CounterTrackerList
extends CounterTracker {
    private static final int MAX_UNUSED_BUFFER_SPACE = 512;
    private final int fixedOffset;
    private final int min;
    private final int max;
    private final int numberOfCells;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final long[] initTemplate;

    public CounterTrackerList(int min, int max, int numberOfCells, CounterTrackerData.Builder dataBuilder) {
        this.min = min;
        this.max = max;
        this.fixedOffset = dataBuilder.getFixedDataSize();
        dataBuilder.requestFixedSize(Field.values().length * numberOfCells);
        int arrayOffset = dataBuilder.getNumberOfIntArrays();
        dataBuilder.requestIntArrays(numberOfCells);
        this.numberOfCells = numberOfCells;
        this.initTemplate = new long[numberOfCells * Field.values().length];
        for (int i = 0; i < numberOfCells; ++i) {
            CounterTrackerList.setField(i, this.initTemplate, 0, Field.offset, 1);
            CounterTrackerList.setField(i, this.initTemplate, 0, Field.size, 0);
            CounterTrackerList.setField(i, this.initTemplate, 0, Field.start, 0);
            CounterTrackerList.setField(i, this.initTemplate, 0, Field.buffer, arrayOffset + i);
        }
    }

    private int getField(int sId, long[] fixedData, Field field) {
        assert (Field.values().length == 4) : "replace sId << 2 with sId * Field.values().length";
        return (int)fixedData[this.fixedOffset + (sId << 2) + field.ordinal()];
    }

    private void setField(int sId, long[] fixedData, Field field, int value) {
        CounterTrackerList.setField(sId, fixedData, this.fixedOffset, field, value);
    }

    private static void setField(int sId, long[] fixedData, int offset, Field field, int value) {
        assert (Field.values().length == 4) : "replace sId << 2 with sId * Field.values().length";
        fixedData[offset + (sId << 2) + field.ordinal()] = value;
    }

    private int getStart(int sId, long[] fixedData) {
        return this.getField(sId, fixedData, Field.start);
    }

    private int getSize(int sId, long[] fixedData) {
        return this.getField(sId, fixedData, Field.size);
    }

    private int getOffset(int sId, long[] fixedData) {
        return this.getField(sId, fixedData, Field.offset);
    }

    private int getBufferPointer(int sId, long[] fixedData) {
        return this.getField(sId, fixedData, Field.buffer);
    }

    private int[] getBuffer(int sId, long[] fixedData, int[][] intArrays) {
        return intArrays[this.getBufferPointer(sId, fixedData)];
    }

    private void setStart(int sId, long[] fixedData, int value) {
        this.setField(sId, fixedData, Field.start, value);
    }

    private void setSize(int sId, long[] fixedData, int value) {
        this.setField(sId, fixedData, Field.size, value);
    }

    private void setOffset(int sId, long[] fixedData, int value) {
        this.setField(sId, fixedData, Field.offset, value);
    }

    @Override
    protected boolean anyLtMax(int sId, long[] fixedData, int[][] intArrays) {
        assert (this.getSize(sId, fixedData) > 0);
        int offset = this.getOffset(sId, fixedData);
        if (this.max == -1 || offset < this.max) {
            return true;
        }
        return this.getMinValue(sId, fixedData, intArrays, offset) < this.max;
    }

    @Override
    protected boolean anyLtMin(int sId, long[] fixedData, int[][] intArrays) {
        assert (this.getSize(sId, fixedData) > 0);
        int offset = this.getOffset(sId, fixedData);
        if (offset < this.min) {
            return true;
        }
        return this.getMinValue(sId, fixedData, intArrays, offset) < this.min;
    }

    @Override
    protected boolean anyGeMin(int sId, long[] fixedData, int[][] intArrays) {
        assert (this.getSize(sId, fixedData) > 0);
        return this.getMaxValue(sId, fixedData, intArrays, this.getOffset(sId, fixedData)) >= this.min;
    }

    private int getMaxValue(int sId, long[] fixedData, int[][] intArrays, int offset) {
        return offset - this.getBuffer(sId, fixedData, intArrays)[this.getStart(sId, fixedData)];
    }

    private int getMinValue(int sId, long[] fixedData, int[][] intArrays, int offset) {
        return offset - this.getBuffer(sId, fixedData, intArrays)[this.getStart(sId, fixedData) + this.getSize(sId, fixedData) - 1];
    }

    private void clear(int sId, long[] fixedData) {
        this.setOffset(sId, fixedData, 1);
        this.setSize(sId, fixedData, 0);
        this.setStart(sId, fixedData, 0);
    }

    private void copy(int src, int dst, long[] fixedData, int[][] intArrays) {
        CompilerAsserts.partialEvaluationConstant((int)src);
        CompilerAsserts.partialEvaluationConstant((int)dst);
        int start = this.getStart(src, fixedData);
        int size = this.getSize(src, fixedData);
        this.setOffset(dst, fixedData, this.getOffset(src, fixedData));
        this.setSize(dst, fixedData, size);
        this.setStart(dst, fixedData, 0);
        int bufferPointerDst = this.getBufferPointer(dst, fixedData);
        int[] bufDst = intArrays[bufferPointerDst];
        if (CompilerDirectives.injectBranchProbability((double)0.25, (size > bufDst.length ? 1 : 0) != 0)) {
            bufDst = new int[1 << 32 - Integer.numberOfLeadingZeros(size - 1)];
            intArrays[bufferPointerDst] = bufDst;
        }
        System.arraycopy(this.getBuffer(src, fixedData, intArrays), start, bufDst, 0, size);
    }

    @Override
    public void apply(long op, long[] fixedData, int[][] intArrays) {
        int dest = TransitionOp.getTarget(op);
        int kind = TransitionOp.getKind(op);
        int modifier = TransitionOp.getModifier(op);
        switch (kind) {
            case 2: {
                if (modifier == 1) {
                    this.clear(dest, fixedData);
                }
                assert (modifier != 3);
                this.set1(dest, fixedData, intArrays);
                break;
            }
            case 1: {
                assert (modifier == 1);
                int src = TransitionOp.getSource(op);
                if (src != dest) {
                    this.copy(src, dest, fixedData, intArrays);
                }
                this.incAll(dest, fixedData, intArrays);
                break;
            }
            case 0: {
                assert (modifier == 3);
                this.swap(TransitionOp.getSource(op), dest, fixedData);
            }
        }
    }

    @ExplodeLoop
    private void swap(int from, int to, long[] fixedData) {
        if (from == to) {
            return;
        }
        for (Field field : Field.values()) {
            CompilerAsserts.partialEvaluationConstant((Object)((Object)field));
            int temp = this.getField(from, fixedData, field);
            this.setField(from, fixedData, field, this.getField(to, fixedData, field));
            this.setField(to, fixedData, field, temp);
        }
    }

    private void incAll(int sId, long[] fixedData, int[][] intArrays) {
        int[] buffer = this.getBuffer(sId, fixedData, intArrays);
        int offset = this.getOffset(sId, fixedData) + 1;
        this.setOffset(sId, fixedData, offset);
        int start = this.getStart(sId, fixedData);
        if (this.max != -1) {
            if (offset - buffer[start] > this.max) {
                int size = this.getSize(sId, fixedData);
                this.removeMaxValue(sId, fixedData, buffer, start, size);
            }
        } else if (offset - buffer[start] > this.min) {
            buffer[start] = offset - this.min;
            int size = this.getSize(sId, fixedData);
            if (size > 1 && buffer[start + 1] == offset - this.min) {
                this.removeMaxValue(sId, fixedData, buffer, start, size);
            }
        }
    }

    private void removeMaxValue(int sId, long[] fixedData, int[] buffer, int start, int size) {
        if (start >= 512) {
            System.arraycopy(buffer, start + 1, buffer, 0, size - 1);
            this.setStart(sId, fixedData, 0);
        } else {
            this.setStart(sId, fixedData, start + 1);
        }
        this.setSize(sId, fixedData, size - 1);
    }

    private void set1(int sId, long[] fixedData, int[][] intArrays) {
        int bufferPointer = this.getBufferPointer(sId, fixedData);
        int[] buf = intArrays[bufferPointer];
        int start = this.getStart(sId, fixedData);
        int size = this.getSize(sId, fixedData);
        int offset = this.getOffset(sId, fixedData);
        int insert1Value = offset - 1;
        if (size == 0 || buf[start + size - 1] != insert1Value) {
            if (start + size == buf.length) {
                buf = Arrays.copyOf(buf, buf.length << 1);
                intArrays[bufferPointer] = buf;
            }
            buf[start + size] = insert1Value;
            this.setSize(sId, fixedData, size + 1);
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void init(long[] fixedData, int[][] intArrays) {
        System.arraycopy(this.initTemplate, 0, fixedData, this.fixedOffset, this.initTemplate.length);
        for (int i = 0; i < this.numberOfCells; ++i) {
            intArrays[this.getBufferPointer((int)i, (long[])fixedData)] = new int[128];
        }
    }

    @Override
    public boolean support(long operation) {
        int kind = TransitionOp.getKind(operation);
        int modifier = TransitionOp.getModifier(operation);
        assert (modifier != 3 || kind == 0);
        return switch (kind) {
            case 0 -> {
                if (modifier == 3) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (modifier == 1) {
                    yield true;
                }
                yield false;
            }
            case 2 -> true;
            default -> throw CompilerDirectives.shouldNotReachHere();
        };
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String dumpState(int sId, long[] fixedData, int[][] intArrays) {
        int start = this.getStart(sId, fixedData);
        int size = this.getSize(sId, fixedData);
        int offset = this.getOffset(sId, fixedData);
        int[] buffer = this.getBuffer(sId, fixedData, intArrays);
        int[] values = new int[size];
        for (int i = 0; i < size; ++i) {
            values[i] = offset - buffer[start + i];
        }
        return String.format("List, start: %d, size: %d, offset: %d, values: %s", start, size, offset, Arrays.toString(values));
    }

    static enum Field {
        start,
        size,
        offset,
        buffer;

    }
}

