/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import org.ldaptive.AbstractOperation;
import org.ldaptive.Connection;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.Response;
import org.ldaptive.ResponseMessage;
import org.ldaptive.ResultCode;
import org.ldaptive.SearchEntry;
import org.ldaptive.SearchReference;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.cache.Cache;
import org.ldaptive.handler.HandlerResult;
import org.ldaptive.intermediate.IntermediateResponse;
import org.ldaptive.provider.SearchItem;
import org.ldaptive.provider.SearchIterator;

public class SearchOperation
extends AbstractOperation<SearchRequest, SearchResult> {
    private Cache<SearchRequest> cache;

    public SearchOperation(Connection conn) {
        super(conn);
    }

    public SearchOperation(Connection conn, Cache<SearchRequest> c) {
        super(conn);
        this.cache = c;
    }

    public Cache<SearchRequest> getCache() {
        return this.cache;
    }

    public void setCache(Cache<SearchRequest> c) {
        this.cache = c;
    }

    @Override
    protected Response<SearchResult> invoke(SearchRequest request) throws LdapException {
        Response<SearchResult> response;
        if (this.cache != null) {
            SearchResult sr = this.cache.get(request);
            if (sr == null) {
                response = this.executeSearch(request);
                this.cache.put(request, response.getResult());
                this.logger.debug("invoke stored result={} in cache", (Object)response.getResult());
            } else {
                this.logger.debug("invoke found result={} in cache", (Object)sr);
                response = new Response<SearchResult>(sr, null);
            }
        } else {
            response = this.executeSearch(request);
        }
        return response;
    }

    protected Response<SearchResult> executeSearch(SearchRequest request) throws LdapException {
        SearchIterator si = this.getConnection().getProviderConnection().search(request);
        SearchResult result = this.readResult(request, si);
        Response<Void> response = si.getResponse();
        return new Response<SearchResult>(result, response.getResultCode(), response.getMessage(), response.getMatchedDn(), response.getControls(), response.getReferralURLs(), response.getMessageId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SearchResult readResult(SearchRequest request, SearchIterator si) throws LdapException {
        SearchResult result = new SearchResult(request.getSortBehavior());
        try {
            while (si.hasNext()) {
                HandlerResult<ResponseMessage> hr;
                SearchItem item = si.next();
                this.logger.trace("Received search item={}", (Object)item);
                if (item.isSearchEntry()) {
                    SearchEntry se = item.getSearchEntry();
                    if (se == null) continue;
                    hr = this.executeHandlers(request.getSearchEntryHandlers(), request, se);
                    if (hr.getResult() != null) {
                        result.addEntry((LdapEntry)((Object)hr.getResult()));
                    }
                    if (!hr.getAbort()) continue;
                    this.logger.debug("Aborting search on entry=%s", (Object)se);
                } else if (item.isSearchReference()) {
                    SearchReference sr = item.getSearchReference();
                    if (sr == null) continue;
                    hr = this.executeHandlers(request.getSearchReferenceHandlers(), request, sr);
                    if (hr.getResult() != null) {
                        SearchReference reference = (SearchReference)hr.getResult();
                        Response<SearchResult> refResponse = reference.getReferenceResponse();
                        if (refResponse != null) {
                            if (refResponse.getResultCode() == ResultCode.SUCCESS) {
                                result.addEntries(refResponse.getResult().getEntries());
                            } else {
                                result.addReference(reference);
                            }
                        } else {
                            result.addReference(reference);
                        }
                    }
                    if (!hr.getAbort()) continue;
                    this.logger.debug("Aborting search on reference=%s", (Object)sr);
                } else {
                    IntermediateResponse ir;
                    if (!item.isIntermediateResponse() || (ir = item.getIntermediateResponse()) == null || !(hr = this.executeHandlers(request.getIntermediateResponseHandlers(), request, ir)).getAbort()) continue;
                    this.logger.debug("Aborting search on intermediate response=%s", (Object)ir);
                }
                break;
            }
        }
        finally {
            si.close();
        }
        return result;
    }
}

