/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.snapshot;

import java.io.PrintStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.SnapshotStatus;
import org.apache.hadoop.hdfs.tools.AdminHelper;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Private
public class LsSnapshot
extends Configured
implements Tool {
    public int run(String[] argv) throws Exception {
        String description = "hdfs lsSnapshot <snapshotDir>: \n\tGet the list of snapshots for a snapshottable directory.\n";
        if (argv.length != 1) {
            System.err.println("Invalid no of arguments");
            System.err.println("Usage: \n" + description);
            return 1;
        }
        Path snapshotRoot = new Path(argv[0]);
        try {
            DistributedFileSystem dfs = AdminHelper.getDFS(this.getConf());
            SnapshotStatus[] stats = dfs.getSnapshotListing(snapshotRoot);
            SnapshotStatus.print((SnapshotStatus[])stats, (PrintStream)System.out);
        }
        catch (Exception e) {
            String[] content = e.getLocalizedMessage().split("\n");
            System.err.println("lsSnapshot: " + content[0]);
            return 1;
        }
        return 0;
    }

    public static void main(String[] argv) throws Exception {
        int rc = ToolRunner.run((Tool)new LsSnapshot(), (String[])argv);
        System.exit(rc);
    }
}

