/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.util.Locale;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.LocaleStringConverter;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class LocaleAttributeConverter
implements AttributeConverter<Locale> {
    public static final LocaleStringConverter STRING_CONVERTER = LocaleStringConverter.create();

    public static LocaleAttributeConverter create() {
        return new LocaleAttributeConverter();
    }

    @Override
    public EnhancedType<Locale> type() {
        return EnhancedType.of(Locale.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.S;
    }

    @Override
    public AttributeValue transformFrom(Locale input) {
        return (AttributeValue)AttributeValue.builder().s(STRING_CONVERTER.toString(input)).build();
    }

    @Override
    public Locale transformTo(AttributeValue input) {
        return EnhancedAttributeValue.fromAttributeValue(input).convert(Visitor.INSTANCE);
    }

    private static final class Visitor
    extends TypeConvertingVisitor<Locale> {
        private static final Visitor INSTANCE = new Visitor();

        private Visitor() {
            super(Locale.class, LocaleAttributeConverter.class);
        }

        @Override
        public Locale convertString(String value) {
            return STRING_CONVERTER.fromString(value);
        }
    }
}

