/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.util;

import java.util.Locale;
import java.util.Objects;
import lombok.NonNull;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.MLModel;
import org.opensearch.ml.common.model.MLModelConfig;
import org.opensearch.neuralsearch.mappingtransformer.SemanticMappingTransformer;

public class SemanticMLModelUtils {
    public static String getModelType(@NonNull MLModel mlModel) {
        Objects.requireNonNull(mlModel, "mlModel is marked non-null but is null");
        FunctionName functionName = mlModel.getAlgorithm();
        String modelId = mlModel.getModelId();
        String errorInstruction = "After updating the model, you must update the semantic field in the index mapping with the new model ID. If the model ID remains the same, you still need to send an update mapping request that includes the semantic field to ensure the latest model configuration is applied.";
        return switch (functionName) {
            case FunctionName.TEXT_EMBEDDING, FunctionName.SPARSE_ENCODING, FunctionName.SPARSE_TOKENIZE -> functionName.name();
            case FunctionName.REMOTE -> {
                FunctionName modelTypeFunctionName;
                MLModelConfig remoteModelConfig = mlModel.getModelConfig();
                if (remoteModelConfig == null) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Model config is required for the remote model %s used for semantic fields. %s", modelId, "After updating the model, you must update the semantic field in the index mapping with the new model ID. If the model ID remains the same, you still need to send an update mapping request that includes the semantic field to ensure the latest model configuration is applied."));
                }
                String remoteModelType = remoteModelConfig.getModelType();
                String errMsgUnsupportedRemoteModelType = String.format(Locale.ROOT, "Semantic field cannot support the remote model type %s with the model id %s. It should be one of [%s]. %s", remoteModelType, modelId, String.join((CharSequence)",", SemanticMappingTransformer.SUPPORTED_REMOTE_MODEL_TYPES), "After updating the model, you must update the semantic field in the index mapping with the new model ID. If the model ID remains the same, you still need to send an update mapping request that includes the semantic field to ensure the latest model configuration is applied.");
                try {
                    modelTypeFunctionName = FunctionName.from((String)remoteModelType);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(errMsgUnsupportedRemoteModelType);
                }
                switch (modelTypeFunctionName) {
                    case TEXT_EMBEDDING: 
                    case SPARSE_ENCODING: 
                    case SPARSE_TOKENIZE: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(errMsgUnsupportedRemoteModelType);
                    }
                }
                yield FunctionName.REMOTE.name() + "_" + modelTypeFunctionName.name();
            }
            default -> throw new IllegalArgumentException(String.format(Locale.ROOT, "Semantic field cannot support the function name %s with the model id %s. It should be one of [%s]. %s", functionName.name(), modelId, String.join((CharSequence)",", SemanticMappingTransformer.SUPPORTED_MODEL_ALGORITHMS), "After updating the model, you must update the semantic field in the index mapping with the new model ID. If the model ID remains the same, you still need to send an update mapping request that includes the semantic field to ensure the latest model configuration is applied."));
        };
    }

    public static boolean isDenseModel(@NonNull String modelType) {
        Objects.requireNonNull(modelType, "modelType is marked non-null but is null");
        return FunctionName.TEXT_EMBEDDING.name().equals(modelType) || (FunctionName.REMOTE.name() + "_" + FunctionName.TEXT_EMBEDDING.name()).equals(modelType);
    }
}

