/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.lucene;

import java.io.IOException;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.search.DocIdSetIterator;

public class SeededMappedDISI
extends DocIdSetIterator {
    private final KnnVectorValues.DocIndexIterator indexedDISI;
    private final DocIdSetIterator sourceDISI;

    public SeededMappedDISI(KnnVectorValues.DocIndexIterator indexedDISI, DocIdSetIterator sourceDISI) {
        this.indexedDISI = indexedDISI;
        this.sourceDISI = sourceDISI;
    }

    public int advance(int target) throws IOException {
        int newTarget = this.sourceDISI.advance(target);
        if (newTarget != Integer.MAX_VALUE) {
            this.indexedDISI.advance(newTarget);
        }
        return this.docID();
    }

    public long cost() {
        return this.sourceDISI.cost();
    }

    public int docID() {
        if (this.indexedDISI.docID() == Integer.MAX_VALUE || this.sourceDISI.docID() == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return this.indexedDISI.index();
    }

    public int nextDoc() throws IOException {
        int newTarget = this.sourceDISI.nextDoc();
        if (newTarget != Integer.MAX_VALUE) {
            this.indexedDISI.advance(newTarget);
        }
        return this.docID();
    }
}

