/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jobscheduler.spi;

import java.io.IOException;
import java.util.Locale;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

public class JobDocVersion
implements Comparable<JobDocVersion>,
Writeable {
    private final long primaryTerm;
    private final long seqNo;
    private final long version;

    public JobDocVersion(long primaryTerm, long seqNo, long version) {
        this.primaryTerm = primaryTerm;
        this.seqNo = seqNo;
        this.version = version;
    }

    public JobDocVersion(StreamInput in) throws IOException {
        this.primaryTerm = in.readLong();
        this.seqNo = in.readLong();
        this.version = in.readLong();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.primaryTerm);
        out.writeLong(this.seqNo);
        out.writeLong(this.version);
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getVersion() {
        return this.version;
    }

    @Override
    public int compareTo(JobDocVersion v) {
        if (v == null) {
            return 1;
        }
        if (this.seqNo < v.seqNo) {
            return -1;
        }
        if (this.seqNo > v.seqNo) {
            return 1;
        }
        if (this.primaryTerm < v.primaryTerm) {
            return -1;
        }
        if (this.primaryTerm > v.primaryTerm) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return String.format(Locale.getDefault(), "{_version: %s, _primary_term: %s, _seq_no: %s}", this.version, this.primaryTerm, this.seqNo);
    }
}

