/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.inject;

import java.util.Iterator;
import java.util.List;
import org.opensearch.common.inject.Binding;
import org.opensearch.common.inject.InjectorImpl;
import org.opensearch.common.inject.InjectorShell;
import org.opensearch.common.inject.internal.Errors;
import org.opensearch.common.inject.spi.Element;
import org.opensearch.common.inject.spi.ElementVisitor;
import org.opensearch.common.inject.spi.InjectionRequest;
import org.opensearch.common.inject.spi.MembersInjectorLookup;
import org.opensearch.common.inject.spi.Message;
import org.opensearch.common.inject.spi.PrivateElements;
import org.opensearch.common.inject.spi.ProviderLookup;
import org.opensearch.common.inject.spi.ScopeBinding;
import org.opensearch.common.inject.spi.StaticInjectionRequest;
import org.opensearch.common.inject.spi.TypeConverterBinding;
import org.opensearch.common.inject.spi.TypeListenerBinding;

abstract class AbstractProcessor
implements ElementVisitor<Boolean> {
    protected Errors errors;
    protected InjectorImpl injector;

    protected AbstractProcessor(Errors errors) {
        this.errors = errors;
    }

    public void process(Iterable<InjectorShell> isolatedInjectorBuilders) {
        for (InjectorShell injectorShell : isolatedInjectorBuilders) {
            this.process(injectorShell.getInjector(), injectorShell.getElements());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(InjectorImpl injector, List<Element> elements) {
        Errors errorsAnyElement = this.errors;
        this.injector = injector;
        try {
            Iterator<Element> i = elements.iterator();
            while (i.hasNext()) {
                Element element = i.next();
                this.errors = errorsAnyElement.withSource(element.getSource());
                Boolean allDone = element.acceptVisitor(this);
                if (!allDone.booleanValue()) continue;
                i.remove();
            }
        }
        finally {
            this.errors = errorsAnyElement;
            this.injector = null;
        }
    }

    @Override
    public Boolean visit(Message message) {
        return false;
    }

    @Override
    public Boolean visit(ScopeBinding scopeBinding) {
        return false;
    }

    @Override
    public Boolean visit(InjectionRequest<?> injectionRequest) {
        return false;
    }

    @Override
    public Boolean visit(StaticInjectionRequest staticInjectionRequest) {
        return false;
    }

    @Override
    public Boolean visit(TypeConverterBinding typeConverterBinding) {
        return false;
    }

    @Override
    public <T> Boolean visit(Binding<T> binding) {
        return false;
    }

    @Override
    public <T> Boolean visit(ProviderLookup<T> providerLookup) {
        return false;
    }

    @Override
    public Boolean visit(PrivateElements privateElements) {
        return false;
    }

    @Override
    public <T> Boolean visit(MembersInjectorLookup<T> lookup) {
        return false;
    }

    @Override
    public Boolean visit(TypeListenerBinding binding) {
        return false;
    }
}

