/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.resource;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.jdbc.driver.resource.DriverResourceProvider;
import oracle.jdbc.driver.resource.InvalidProvider;
import oracle.jdbc.driver.resource.ProviderProperties;
import oracle.jdbc.driver.resource.ResourceProvider;
import oracle.jdbc.driver.resource.ResourceType;
import oracle.jdbc.spi.OracleResourceProvider;

public class DriverResources {
    private final Map<ResourceType<?, ?>, ResourceProvider<?, ?>> providers;

    public DriverResources(ProviderProperties providerProperties) throws SQLException {
        Collection<ResourceType<?, ?>> resourceTypes = ResourceType.allTypes();
        HashMap providers = new HashMap(resourceTypes.size());
        for (ResourceType<?, ?> resourceType : resourceTypes) {
            ResourceProvider<?, ?> provider = DriverResources.createProvider(resourceType, providerProperties);
            providers.put(resourceType, provider);
        }
        this.providers = Collections.unmodifiableMap(providers);
    }

    public boolean isProviderConfigured(ResourceType<?, ?> resourceType) {
        return null != this.providers.get(resourceType);
    }

    public <U> U getResource(ResourceType<?, U> resourceType) throws SQLException {
        ResourceProvider<?, ?> provider = this.providers.get(resourceType);
        if (provider == null) {
            return null;
        }
        Object resource = provider.getResource();
        return (U)resource;
    }

    private static <T extends OracleResourceProvider, U> ResourceProvider<T, U> createProvider(ResourceType<T, U> resourceType, ProviderProperties providerProperties) {
        String providerName = providerProperties.getProviderName(resourceType);
        if (providerName == null) {
            return null;
        }
        try {
            DriverResourceProvider.Builder<T, U> builder = DriverResourceProvider.builder(providerName, resourceType);
            Map<String, String> parameterValues = providerProperties.getParameterValues(resourceType);
            for (Map.Entry<String, String> entry : parameterValues.entrySet()) {
                builder.parameterValue(entry.getKey(), entry.getValue());
            }
            return builder.build();
        }
        catch (SQLException sqlException) {
            return new InvalidProvider(sqlException);
        }
    }
}

