/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.inchi;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import org.iupac.InChIStructureProvider;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.util.BSUtil;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.util.SimpleNode;
import org.jmol.viewer.Viewer;

class InchiToSmilesConverter {
    private Map<BS, int[]> mapTet;
    private Map<Integer, Boolean> mapPlanar;
    private Lst<SmilesAtom> listSmiles = new Lst();
    private InChIStructureProvider provider;

    public InchiToSmilesConverter(InChIStructureProvider provider) {
        this.provider = provider;
        provider.initializeModelForSmiles();
    }

    String getSmiles(Viewer vwr, String smilesOptions) {
        int i;
        boolean hackImine = smilesOptions.indexOf("imine") >= 0;
        BS bsImplicitH = smilesOptions.indexOf("amide") >= 0 ? new BS() : null;
        int nAtoms = this.provider.getNumAtoms();
        int nBonds = this.provider.getNumBonds();
        int nh = 0;
        for (int i2 = 0; i2 < nAtoms; ++i2) {
            nh += this.provider.setAtom(i2).getImplicitH();
        }
        Lst<SmilesAtom> atoms = new Lst<SmilesAtom>();
        this.mapTet = new Hashtable<BS, int[]>();
        this.mapPlanar = new Hashtable<Integer, Boolean>();
        int nb = 0;
        int na = 0;
        for (i = 0; i < nAtoms; ++i) {
            this.provider.setAtom(i);
            SmilesAtom n = new SmilesAtom(){

                @Override
                public boolean definesStereo() {
                    return true;
                }

                @Override
                public String getStereoAtAt(SimpleNode[] nodes) {
                    return InchiToSmilesConverter.this.decodeInchiStereo(nodes);
                }

                @Override
                public Boolean isStereoOpposite(int i2, int iA, int iB) {
                    return InchiToSmilesConverter.this.isInchiOpposite(this.getIndex(), i2, iA, iB);
                }
            };
            atoms.addLast(n);
            n.set((float)this.provider.getX(), (float)this.provider.getY(), (float)this.provider.getZ());
            n.setIndex(na++);
            n.setCharge(this.provider.getCharge());
            n.setSymbol(this.provider.getElementType());
            int m = this.provider.getIsotopicMass();
            if (m > 0) {
                n.setAtomicMass(m);
            }
            if ((nh = this.provider.getImplicitH()) > 0 && bsImplicitH != null) {
                bsImplicitH.set(na - 1);
            }
            for (int j = 0; j < nh; ++j) {
                this.addH(atoms, n, nb++);
                ++na;
            }
            this.listSmiles.addLast(n);
        }
        for (i = 0; i < nBonds; ++i) {
            this.provider.setBond(i);
            int bt = InchiToSmilesConverter.getJmolBondType(this.provider.getInchiBondType());
            SmilesAtom sa1 = (SmilesAtom)this.listSmiles.get(this.provider.getIndexOriginAtom());
            SmilesAtom sa2 = (SmilesAtom)this.listSmiles.get(this.provider.getIndexTargetAtom());
            SmilesBond sb = new SmilesBond(sa1, sa2, bt, false);
            sb.index = nb++;
        }
        nb = this.checkSpecial(atoms, nb, hackImine, bsImplicitH);
        na = atoms.size();
        Node[] aatoms = new SmilesAtom[na];
        atoms.toArray(aatoms);
        for (int i3 = 0; i3 < na; ++i3) {
            aatoms[i3].setBondArray();
        }
        int iA = -1;
        int iB = -1;
        int i4 = this.provider.getNumStereo0D();
        block17: while (--i4 >= 0) {
            String type;
            this.provider.setStereo0D(i4);
            int[] neighbors = this.provider.getNeighbors();
            if (neighbors.length != 4) continue;
            int centerAtom = this.provider.getCenterAtom();
            int i0 = ((SmilesAtom)this.listSmiles.get(neighbors[0])).getIndex();
            int i1 = ((SmilesAtom)this.listSmiles.get(neighbors[1])).getIndex();
            int i2 = ((SmilesAtom)this.listSmiles.get(neighbors[2])).getIndex();
            int i3 = ((SmilesAtom)this.listSmiles.get(neighbors[3])).getIndex();
            boolean isEven = this.provider.getParity().equals("EVEN");
            switch (type = this.provider.getStereoType()) {
                case "ALLENE": 
                case "DOUBLEBOND": {
                    iA = i1;
                    iB = i2;
                    i1 = InchiToSmilesConverter.getOtherEneAtom((SmilesAtom[])aatoms, i1, i0);
                    i2 = InchiToSmilesConverter.getOtherEneAtom((SmilesAtom[])aatoms, i2, i3);
                    break;
                }
                case "NONE": {
                    continue block17;
                }
            }
            if (centerAtom == -1) {
                this.setPlanarKey(i0, i3, iA, iB, isEven);
                this.setPlanarKey(i0, i2, iA, iB, !isEven);
                this.setPlanarKey(i1, i2, iA, iB, isEven);
                this.setPlanarKey(i1, i3, iA, iB, !isEven);
                this.setPlanarKey(i0, i1, iA, iB, Boolean.TRUE);
                this.setPlanarKey(i2, i3, iA, iB, Boolean.TRUE);
                continue;
            }
            int[] list = new int[]{isEven ? i0 : i1, isEven ? i1 : i0, i2, i3};
            this.mapTet.put(InchiToSmilesConverter.orderList(list), list);
        }
        try {
            SmilesMatcherInterface m = vwr.getSmilesMatcher();
            String smiles = m.getSmiles(aatoms, na, BSUtil.newBitSet2(0, na), smilesOptions, 1);
            Logger.info("InchiToSmiles: " + smiles);
            return smiles;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private void setPlanarKey(int i0, int i3, int iA, int iB, Boolean v) {
        this.mapPlanar.put(InchiToSmilesConverter.getIntKey(i0, iA, i3), v);
        this.mapPlanar.put(InchiToSmilesConverter.getIntKey(i0, iB, i3), v);
    }

    private SmilesAtom addH(Lst<SmilesAtom> atoms, SmilesAtom n, int nb) {
        SmilesAtom h = new SmilesAtom();
        h.setIndex(atoms.size());
        h.setSymbol("H");
        atoms.addLast(h);
        SmilesBond sb = new SmilesBond(n, h, 1, false);
        sb.index = nb;
        return h;
    }

    private int checkSpecial(Lst<SmilesAtom> atoms, int nb, boolean hackImine, BS bsImplicitH) {
        int i = atoms.size();
        while (--i >= 0) {
            SmilesAtom a = (SmilesAtom)atoms.get(i);
            int val = a.getValence();
            int nbonds = a.getCovalentBondCount();
            int nbtot = a.getBondCount();
            int ano = a.getElementNumber();
            int formalCharge = a.getCharge();
            SmilesBond b1 = null;
            SmilesBond b2 = null;
            block0 : switch (val * 10 + nbonds) {
                case 32: {
                    SmilesAtom o;
                    SmilesAtom c;
                    if (ano != 7) break;
                    if (hackImine) {
                        a.setSymbol("C");
                        a.setAtomicMass(17);
                        SmilesAtom h = this.addH(atoms, a, nb++);
                        h.setAtomicMass(5);
                        break;
                    }
                    if (bsImplicitH == null || (c = this.getOther(atoms, a, 2, 6)) == null || c.getElementNumber() != 6 || (o = this.getOther(atoms, c, 1, 8)) == null || !bsImplicitH.get(o.getIndex())) break;
                    SmilesAtom h = this.getOther(atoms, o, 1, 1);
                    SmilesBond nc = this.getBond(a, c);
                    SmilesBond co = this.getBond(o, c);
                    SmilesBond oh = h.getBond(0);
                    co.set2(2, false);
                    nc.set2(1, false);
                    oh.set2(4096, false);
                    SmilesBond b = new SmilesBond(h, a, 1, false);
                    b.index = oh.index;
                    break;
                }
                case 53: {
                    if (ano != 7 || formalCharge != 0) break;
                    for (int j = 0; j < nbtot; ++j) {
                        SmilesBond b = a.getBond(j);
                        if (b.getCovalentOrder() != 2) continue;
                        if (b1 == null) {
                            b1 = b;
                            continue;
                        }
                        b2 = b;
                        break block0;
                    }
                    break;
                }
            }
            if (b2 == null) continue;
            SmilesAtom a2 = b2.getOtherAtom(a);
            a2.setCharge(-1);
            a.setCharge(1);
            b2.set2(1, false);
        }
        return nb;
    }

    private SmilesBond getBond(SmilesAtom a, SmilesAtom c) {
        int i = a.getBondCount();
        while (--i >= 0) {
            SmilesBond b = a.getBond(i);
            if (b.getOtherAtom(a) != c) continue;
            return b;
        }
        return null;
    }

    private SmilesAtom getOther(Lst<SmilesAtom> atoms, SmilesAtom a, int bondType, int elemNo) {
        int i = a.getBondCount();
        while (--i >= 0) {
            SmilesAtom a2;
            if (a.getBond(i).getCovalentOrder() != bondType || (a2 = (SmilesAtom)atoms.get(a.getBondedAtomIndex(i))).getElementNumber() != elemNo) continue;
            return a2;
        }
        return null;
    }

    protected Boolean isInchiOpposite(int i1, int i2, int iA, int iB) {
        Boolean b = this.mapPlanar.get(InchiToSmilesConverter.getIntKey(i1, Math.max(iA, iB), i2));
        return b;
    }

    protected String decodeInchiStereo(SimpleNode[] nodes) {
        int[] list = new int[]{InchiToSmilesConverter.getNodeIndex(nodes[0]), InchiToSmilesConverter.getNodeIndex(nodes[1]), InchiToSmilesConverter.getNodeIndex(nodes[2]), InchiToSmilesConverter.getNodeIndex(nodes[3])};
        int[] list2 = this.mapTet.get(InchiToSmilesConverter.orderList(list));
        return list2 == null ? null : (InchiToSmilesConverter.isPermutation(list, list2) ? "@@" : "@");
    }

    private static int getNodeIndex(SimpleNode node) {
        return node == null ? -1 : node.getIndex();
    }

    private static Integer getIntKey(int i, int iA, int j) {
        Integer v = (Math.min(i, j) << 24) + (iA << 12) + Math.max(i, j);
        return v;
    }

    private static BS orderList(int[] list) {
        BS bs = new BS();
        for (int i = 0; i < list.length; ++i) {
            bs.set(list[i]);
        }
        return bs;
    }

    private static boolean isPermutation(int[] list, int[] list2) {
        boolean ok = true;
        for (int i = 0; i < 3; ++i) {
            int l1 = list[i];
            for (int j = i + 1; j < 4; ++j) {
                int l2 = list2[j];
                if (l2 != l1 || j == i) continue;
                list2[j] = list2[i];
                list2[i] = l2;
                ok = !ok;
            }
        }
        return ok;
    }

    private static int getOtherEneAtom(SmilesAtom[] atoms, int i0, int i1) {
        SmilesAtom a = atoms[i0];
        int i = a.getBondCount();
        while (--i >= 0) {
            int i2;
            if (a.getBond(i).getBondType() != 1 || (i2 = a.getBondedAtomIndex(i)) == i1) continue;
            return i2;
        }
        return -1;
    }

    public static int getJmolBondType(String type) {
        switch (type) {
            case "NONE": {
                return 0;
            }
            case "ALTERN": {
                return 515;
            }
            case "DOUBLE": {
                return 2;
            }
            case "TRIPLE": {
                return 3;
            }
        }
        return 1;
    }
}

