/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.data.Track;

public class MarkingData {
    private final Track _track;
    private byte[] _flags = null;

    public MarkingData(Track track) {
        this._track = track;
    }

    public boolean isPointMarkedForDeletion(int n) {
        this.checkSize();
        if (this._flags != null && n >= 0 && n < this._flags.length) {
            return this._flags[n] % 2 != 0;
        }
        return false;
    }

    public boolean isPointMarkedForSegmentBreak(int n) {
        this.checkSize();
        if (this._flags != null && n >= 0 && n < this._flags.length) {
            int n2 = this._flags[n] / 2;
            return n2 % 2 != 0;
        }
        return false;
    }

    private void checkSize() {
        if (this._flags != null && this._flags.length != this._track.getNumPoints()) {
            this._flags = null;
        }
    }

    public void clear() {
        this._flags = null;
    }

    public void markPointsForDeletion(boolean[] blArray) {
        this.markPointsForDeletion(blArray, null);
    }

    public void markPointsForDeletion(boolean[] blArray, boolean[] blArray2) {
        int n;
        int n2 = n = blArray == null ? 0 : blArray.length;
        if (this._flags == null || this._flags.length != n) {
            this._flags = new byte[n];
        }
        boolean[] blArray3 = blArray2;
        if (blArray2 != null && blArray2.length != n) {
            blArray3 = null;
        }
        int n3 = 0;
        while (n3 < n) {
            boolean bl = blArray[n3];
            boolean bl2 = blArray3 != null && blArray3[n3];
            int n4 = (bl ? 1 : 0) + (bl2 ? 2 : 0);
            this._flags[n3] = (byte)n4;
            ++n3;
        }
    }

    public void markPointForDeletion(int n) {
        this.markPointForDeletion(n, true);
    }

    public void markPointForDeletion(int n, boolean bl) {
        this.markPointForDeletion(n, bl, false);
    }

    public void markPointForDeletion(int n, boolean bl, boolean bl2) {
        this.checkSize();
        if (this._flags == null) {
            if (!bl) {
                return;
            }
            this._flags = new byte[this._track.getNumPoints()];
        }
        if (n < 0 || n >= this._flags.length) {
            return;
        }
        this._flags[n] = this.combineFlags(bl, bl2);
    }

    private byte combineFlags(boolean bl, boolean bl2) {
        if (bl) {
            return (byte)((bl2 ? 2 : 0) + 1);
        }
        return 0;
    }

    public boolean hasMarkedPoints() {
        this.checkSize();
        if (this._flags != null) {
            byte[] byArray = this._flags;
            int n = this._flags.length;
            int n2 = 0;
            while (n2 < n) {
                byte by = byArray[n2];
                if (by != 0) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public int getNumDeleted() {
        int n = 0;
        this.checkSize();
        if (this._flags != null) {
            byte[] byArray = this._flags;
            int n2 = this._flags.length;
            int n3 = 0;
            while (n3 < n2) {
                byte by = byArray[n3];
                if (by != 0) {
                    ++n;
                }
                ++n3;
            }
        }
        return n;
    }
}

