/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.math.geom;

import com.jogamp.math.Matrix4f;
import com.jogamp.math.Vec3f;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.geom.Frustum;

public class Cube {
    public final Vec3f lbf;
    public final Vec3f rbf;
    public final Vec3f rtf;
    public final Vec3f ltf;
    public final Vec3f lbn;
    public final Vec3f rbn;
    public final Vec3f rtn;
    public final Vec3f ltn;

    public final String toString() {
        return "[lbf " + this.lbf + ", rbf " + this.rbf + ", rtf " + this.rtf + ", lbn " + this.lbn + ", rbn " + this.rbn + ", rtn " + this.rtn + ", ltn " + this.ltn + "]";
    }

    public Cube() {
        this.lbf = new Vec3f();
        this.rbf = new Vec3f();
        this.rtf = new Vec3f();
        this.ltf = new Vec3f();
        this.lbn = new Vec3f();
        this.rbn = new Vec3f();
        this.rtn = new Vec3f();
        this.ltn = new Vec3f();
    }

    public Cube(Cube cube) {
        this.lbf = new Vec3f(cube.lbf);
        this.rbf = new Vec3f(cube.rbf);
        this.rtf = new Vec3f(cube.rtf);
        this.ltf = new Vec3f(cube.ltf);
        this.lbn = new Vec3f(cube.lbn);
        this.rbn = new Vec3f(cube.rbn);
        this.rtn = new Vec3f(cube.rtn);
        this.ltn = new Vec3f(cube.ltn);
    }

    public Cube(AABBox aABBox) {
        this(aABBox.getLow(), aABBox.getHigh());
    }

    public Cube(Vec3f vec3f, Vec3f vec3f2) {
        this.lbf = new Vec3f(vec3f);
        this.rtn = new Vec3f(vec3f2);
        this.rbf = new Vec3f(this.rtn.x(), this.lbf.y(), this.lbf.z());
        this.rtf = new Vec3f(this.rtn.x(), this.rtn.y(), this.lbf.z());
        this.ltf = new Vec3f(this.lbf.x(), this.rtn.y(), this.lbf.z());
        this.lbn = new Vec3f(this.lbf.x(), this.lbf.y(), this.rtn.z());
        this.rbn = new Vec3f(this.rtn.x(), this.lbf.y(), this.rtn.z());
        this.ltn = new Vec3f(this.lbf.x(), this.rtn.y(), this.rtn.z());
    }

    public Cube set(AABBox aABBox) {
        return this.set(aABBox.getLow(), aABBox.getHigh());
    }

    public Cube set(Vec3f vec3f, Vec3f vec3f2) {
        this.lbf.set(vec3f);
        this.rtn.set(vec3f2);
        this.rbf.set(this.rtn.x(), this.lbf.y(), this.lbf.z());
        this.rtf.set(this.rtn.x(), this.rtn.y(), this.lbf.z());
        this.ltf.set(this.lbf.x(), this.rtn.y(), this.lbf.z());
        this.lbn.set(this.lbf.x(), this.lbf.y(), this.rtn.z());
        this.rbn.set(this.rtn.x(), this.lbf.y(), this.rtn.z());
        this.ltn.set(this.lbf.x(), this.rtn.y(), this.rtn.z());
        return this;
    }

    public Cube set(Cube cube) {
        this.lbf.set(cube.lbf);
        this.rbf.set(cube.rbf);
        this.rtf.set(cube.rtf);
        this.ltf.set(cube.ltf);
        this.lbn.set(cube.lbn);
        this.rbn.set(cube.rbn);
        this.rtn.set(cube.rtn);
        this.ltn.set(cube.ltn);
        return this;
    }

    public Cube transform(Matrix4f matrix4f) {
        matrix4f.mulVec3f(this.lbf);
        matrix4f.mulVec3f(this.rbf);
        matrix4f.mulVec3f(this.rtf);
        matrix4f.mulVec3f(this.ltf);
        matrix4f.mulVec3f(this.lbn);
        matrix4f.mulVec3f(this.rbn);
        matrix4f.mulVec3f(this.rtn);
        matrix4f.mulVec3f(this.ltn);
        return this;
    }

    public Frustum updateFrustumPlanes(Frustum frustum) {
        frustum.getPlanes()[4].set(this.lbf.minus(this.lbn).normalize(), this.lbn);
        frustum.getPlanes()[5].set(this.lbn.minus(this.lbf).normalize(), this.lbf);
        frustum.getPlanes()[0].set(this.rbf.minus(this.lbf).normalize(), this.lbn);
        frustum.getPlanes()[1].set(this.lbf.minus(this.rbf).normalize(), this.rbn);
        frustum.getPlanes()[2].set(this.ltf.minus(this.lbf).normalize(), this.lbn);
        frustum.getPlanes()[3].set(this.lbf.minus(this.ltf).normalize(), this.ltn);
        return frustum;
    }
}

