/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.registry;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.engine.AIEngine;
import org.jkiss.dbeaver.model.ai.registry.AIEngineDescriptor;
import org.jkiss.utils.CommonUtils;

public class AIEngineRegistry {
    private static final Log log = Log.getLog(AIEngineRegistry.class);
    private static AIEngineRegistry instance = null;
    private final Map<String, AIEngineDescriptor> descriptorMap = new LinkedHashMap<String, AIEngineDescriptor>();
    private final Map<String, String> replaceMap = new LinkedHashMap<String, String>();
    private final Map<String, String> fallbackMap = new LinkedHashMap<String, String>();

    public static synchronized AIEngineRegistry getInstance() {
        if (instance == null) {
            instance = new AIEngineRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    public AIEngineRegistry(@NotNull IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("com.dbeaver.ai.engine");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if ("completionEngine".equals(ext.getName())) {
                String fallbacks;
                int n3;
                AIEngineDescriptor descriptor = new AIEngineDescriptor(ext);
                this.descriptorMap.put(descriptor.getId(), descriptor);
                String replaces = descriptor.getReplaces();
                if (!CommonUtils.isEmpty((String)replaces)) {
                    String[] stringArray = replaces.split(",");
                    n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String rl = stringArray[n4];
                        this.replaceMap.put(rl, descriptor.getId());
                        ++n4;
                    }
                }
                if (!CommonUtils.isEmpty((String)(fallbacks = descriptor.getFallbacks()))) {
                    String[] stringArray = fallbacks.split(",");
                    int n5 = stringArray.length;
                    n3 = 0;
                    while (n3 < n5) {
                        String rl = stringArray[n3];
                        this.fallbackMap.put(rl, descriptor.getId());
                        ++n3;
                    }
                }
            }
            ++n2;
        }
    }

    @NotNull
    public List<AIEngineDescriptor> getCompletionEngines() {
        ArrayList<AIEngineDescriptor> list = new ArrayList<AIEngineDescriptor>();
        for (Map.Entry<String, AIEngineDescriptor> entry : this.descriptorMap.entrySet()) {
            if (this.replaceMap.containsKey(entry.getKey())) continue;
            list.add(entry.getValue());
        }
        return list;
    }

    @Nullable
    public AIEngineDescriptor getDefaultCompletionEngineDescriptor() {
        return this.getCompletionEngines().stream().filter(AIEngineDescriptor::isDefault).findFirst().orElse(null);
    }

    @NotNull
    public AIEngine createEngine(@NotNull String id) throws DBException {
        AIEngineDescriptor descriptor = this.getEngineDescriptor(id);
        if (descriptor == null) {
            log.trace((Object)"Active engine is not present in the configuration, switching to default active engine");
            AIEngineDescriptor defaultCompletionEngineDescriptor = this.getDefaultCompletionEngineDescriptor();
            if (defaultCompletionEngineDescriptor == null) {
                throw new DBException("AI engine '" + id + "' not found");
            }
            descriptor = defaultCompletionEngineDescriptor;
        }
        return descriptor.createEngineInstance();
    }

    public boolean isEngineSupports(@NotNull String id, @NotNull Class<?> api) {
        AIEngineDescriptor descriptor = this.getEngineDescriptor(id);
        if (descriptor != null) {
            Class objectClass = descriptor.getEngineObjectType().getObjectClass();
            return objectClass != null && api.isAssignableFrom(objectClass);
        }
        return false;
    }

    @Nullable
    public AIEngineDescriptor getEngineDescriptor(@NotNull String id) {
        String follBackId;
        String replace;
        while ((replace = this.replaceMap.get(id)) != null) {
            id = replace;
        }
        AIEngineDescriptor engine = this.descriptorMap.get(id);
        if (engine == null && (follBackId = this.fallbackMap.get(id)) != null) {
            engine = this.descriptorMap.get(follBackId);
        }
        return engine;
    }
}

