/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSInspectorAuditResourcesObject.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "Document.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const InspectorAuditResourcesObject::Resource& dictionary)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDOMString::isNullValue(dictionary.id)) {
        auto idValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, IDLDOMString::extractValueFromNullable(dictionary.id));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "id"_s), idValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.mimeType)) {
        auto mimeTypeValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, IDLDOMString::extractValueFromNullable(dictionary.mimeType));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "mimeType"_s), mimeTypeValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.url)) {
        auto urlValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, IDLDOMString::extractValueFromNullable(dictionary.url));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "url"_s), urlValue);
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const InspectorAuditResourcesObject::ResourceContent& dictionary)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLBoolean::isNullValue(dictionary.base64Encoded)) {
        auto base64EncodedValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, IDLBoolean::extractValueFromNullable(dictionary.base64Encoded));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "base64Encoded"_s), base64EncodedValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.data)) {
        auto dataValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, IDLDOMString::extractValueFromNullable(dictionary.data));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "data"_s), dataValue);
    }
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsInspectorAuditResourcesObjectPrototypeFunction_getResources);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorAuditResourcesObjectPrototypeFunction_getResourceContent);

class JSInspectorAuditResourcesObjectPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSInspectorAuditResourcesObjectPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSInspectorAuditResourcesObjectPrototype* ptr = new (NotNull, JSC::allocateCell<JSInspectorAuditResourcesObjectPrototype>(vm)) JSInspectorAuditResourcesObjectPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSInspectorAuditResourcesObjectPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSInspectorAuditResourcesObjectPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSInspectorAuditResourcesObjectPrototype, JSInspectorAuditResourcesObjectPrototype::Base);

/* Hash table for prototype */

static const std::array<HashTableValue, 2> JSInspectorAuditResourcesObjectPrototypeTableValues {
    HashTableValue { "getResources"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorAuditResourcesObjectPrototypeFunction_getResources, 0 } },
    HashTableValue { "getResourceContent"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorAuditResourcesObjectPrototypeFunction_getResourceContent, 1 } },
};

const ClassInfo JSInspectorAuditResourcesObjectPrototype::s_info = { "InspectorAuditResourcesObject"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSInspectorAuditResourcesObjectPrototype) };

void JSInspectorAuditResourcesObjectPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSInspectorAuditResourcesObject::info(), JSInspectorAuditResourcesObjectPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSInspectorAuditResourcesObject::s_info = { "InspectorAuditResourcesObject"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSInspectorAuditResourcesObject) };

JSInspectorAuditResourcesObject::JSInspectorAuditResourcesObject(Structure* structure, JSDOMGlobalObject& globalObject, Ref<InspectorAuditResourcesObject>&& impl)
    : JSDOMWrapper<InspectorAuditResourcesObject>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, InspectorAuditResourcesObject>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSInspectorAuditResourcesObject::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSInspectorAuditResourcesObjectPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSInspectorAuditResourcesObjectPrototype::create(vm, &globalObject, structure);
}

JSObject* JSInspectorAuditResourcesObject::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSInspectorAuditResourcesObject>(vm, globalObject);
}

void JSInspectorAuditResourcesObject::destroy(JSC::JSCell* cell)
{
    JSInspectorAuditResourcesObject* thisObject = static_cast<JSInspectorAuditResourcesObject*>(cell);
    thisObject->JSInspectorAuditResourcesObject::~JSInspectorAuditResourcesObject();
}

static inline JSC::EncodedJSValue jsInspectorAuditResourcesObjectPrototypeFunction_getResourcesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorAuditResourcesObject>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RefPtr context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    Ref document = downcast<Document>(*context);
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLSequence<IDLDictionary<InspectorAuditResourcesObject::Resource>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getResources(document.get()))));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorAuditResourcesObjectPrototypeFunction_getResources, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorAuditResourcesObject>::call<jsInspectorAuditResourcesObjectPrototypeFunction_getResourcesBody>(*lexicalGlobalObject, *callFrame, "getResources");
}

static inline JSC::EncodedJSValue jsInspectorAuditResourcesObjectPrototypeFunction_getResourceContentBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorAuditResourcesObject>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    RefPtr context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    Ref document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto idConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (idConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDictionary<InspectorAuditResourcesObject::ResourceContent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getResourceContent(document.get(), idConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorAuditResourcesObjectPrototypeFunction_getResourceContent, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorAuditResourcesObject>::call<jsInspectorAuditResourcesObjectPrototypeFunction_getResourceContentBody>(*lexicalGlobalObject, *callFrame, "getResourceContent");
}

JSC::GCClient::IsoSubspace* JSInspectorAuditResourcesObject::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSInspectorAuditResourcesObject, UseCustomHeapCellType::No>(vm, "JSInspectorAuditResourcesObject"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForInspectorAuditResourcesObject.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForInspectorAuditResourcesObject = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForInspectorAuditResourcesObject.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForInspectorAuditResourcesObject = std::forward<decltype(space)>(space); }
    );
}

void JSInspectorAuditResourcesObject::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSInspectorAuditResourcesObject*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSInspectorAuditResourcesObjectOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSInspectorAuditResourcesObjectOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsInspectorAuditResourcesObject = static_cast<JSInspectorAuditResourcesObject*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsInspectorAuditResourcesObject->protectedWrapped().ptr(), jsInspectorAuditResourcesObject);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7InspectorAuditResourcesObject@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore29InspectorAuditResourcesObjectE[]; }
#endif
template<std::same_as<InspectorAuditResourcesObject> T>
static inline void verifyVTable(InspectorAuditResourcesObject* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7InspectorAuditResourcesObject@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore29InspectorAuditResourcesObjectE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // InspectorAuditResourcesObject has subclasses. If InspectorAuditResourcesObject has subclasses that get passed
        // to toJS() we currently require InspectorAuditResourcesObject you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<InspectorAuditResourcesObject>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<InspectorAuditResourcesObject>(impl.ptr());
#endif
    return createWrapper<InspectorAuditResourcesObject>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, InspectorAuditResourcesObject& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

InspectorAuditResourcesObject* JSInspectorAuditResourcesObject::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSInspectorAuditResourcesObject*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
