/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSEXTTextureCompressionBPTC.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

class JSEXTTextureCompressionBPTCPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSEXTTextureCompressionBPTCPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSEXTTextureCompressionBPTCPrototype* ptr = new (NotNull, JSC::allocateCell<JSEXTTextureCompressionBPTCPrototype>(vm)) JSEXTTextureCompressionBPTCPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTTextureCompressionBPTCPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSEXTTextureCompressionBPTCPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTTextureCompressionBPTCPrototype, JSEXTTextureCompressionBPTCPrototype::Base);

/* Hash table for prototype */

static const std::array<HashTableValue, 4> JSEXTTextureCompressionBPTCPrototypeTableValues {
    HashTableValue { "COMPRESSED_RGBA_BPTC_UNORM_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8E8C } },
    HashTableValue { "COMPRESSED_SRGB_ALPHA_BPTC_UNORM_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8E8D } },
    HashTableValue { "COMPRESSED_RGB_BPTC_SIGNED_FLOAT_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8E8E } },
    HashTableValue { "COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8E8F } },
};

const ClassInfo JSEXTTextureCompressionBPTCPrototype::s_info = { "EXTTextureCompressionBPTC"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTTextureCompressionBPTCPrototype) };

void JSEXTTextureCompressionBPTCPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSEXTTextureCompressionBPTC::info(), JSEXTTextureCompressionBPTCPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSEXTTextureCompressionBPTC::s_info = { "EXTTextureCompressionBPTC"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTTextureCompressionBPTC) };

JSEXTTextureCompressionBPTC::JSEXTTextureCompressionBPTC(Structure* structure, JSDOMGlobalObject& globalObject, Ref<EXTTextureCompressionBPTC>&& impl)
    : JSDOMWrapper<EXTTextureCompressionBPTC>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, EXTTextureCompressionBPTC>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSEXTTextureCompressionBPTC::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSEXTTextureCompressionBPTCPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSEXTTextureCompressionBPTCPrototype::create(vm, &globalObject, structure);
}

JSObject* JSEXTTextureCompressionBPTC::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSEXTTextureCompressionBPTC>(vm, globalObject);
}

void JSEXTTextureCompressionBPTC::destroy(JSC::JSCell* cell)
{
    JSEXTTextureCompressionBPTC* thisObject = static_cast<JSEXTTextureCompressionBPTC*>(cell);
    thisObject->JSEXTTextureCompressionBPTC::~JSEXTTextureCompressionBPTC();
}

JSC::GCClient::IsoSubspace* JSEXTTextureCompressionBPTC::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSEXTTextureCompressionBPTC, UseCustomHeapCellType::No>(vm, "JSEXTTextureCompressionBPTC"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForEXTTextureCompressionBPTC.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForEXTTextureCompressionBPTC = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForEXTTextureCompressionBPTC.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForEXTTextureCompressionBPTC = std::forward<decltype(space)>(space); }
    );
}

void JSEXTTextureCompressionBPTC::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSEXTTextureCompressionBPTC*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSEXTTextureCompressionBPTCOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsEXTTextureCompressionBPTC = jsCast<JSEXTTextureCompressionBPTC*>(handle.slot()->asCell());
    auto& owner = jsEXTTextureCompressionBPTC->wrapped();
    if (reason) [[unlikely]]
        *reason = "Reachable from jsEXTTextureCompressionBPTC"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSEXTTextureCompressionBPTCOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsEXTTextureCompressionBPTC = static_cast<JSEXTTextureCompressionBPTC*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsEXTTextureCompressionBPTC->protectedWrapped().ptr(), jsEXTTextureCompressionBPTC);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7EXTTextureCompressionBPTC@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore25EXTTextureCompressionBPTCE[]; }
#endif
template<std::same_as<EXTTextureCompressionBPTC> T>
static inline void verifyVTable(EXTTextureCompressionBPTC* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7EXTTextureCompressionBPTC@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore25EXTTextureCompressionBPTCE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // EXTTextureCompressionBPTC has subclasses. If EXTTextureCompressionBPTC has subclasses that get passed
        // to toJS() we currently require EXTTextureCompressionBPTC you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<EXTTextureCompressionBPTC>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<EXTTextureCompressionBPTC>(impl.ptr());
#endif
    return createWrapper<EXTTextureCompressionBPTC>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, EXTTextureCompressionBPTC& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

EXTTextureCompressionBPTC* JSEXTTextureCompressionBPTC::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSEXTTextureCompressionBPTC*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
