/*
	This file is part of Warzone 2100.
	Copyright (C) 2022-2025  Warzone 2100 Project

	Warzone 2100 is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	Warzone 2100 is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Warzone 2100; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
*/
/** @file
 *  Private header for sdl-backend only
 */

#pragma once

#include "lib/framework/frame.h"
#include <vector>
#include <memory>
#include <nonstd/optional.hpp>
using nonstd::optional;
using nonstd::nullopt;

void wzGetWindowToRendererScaleFactor(float *horizScaleFactor, float *vertScaleFactor);
float wzGetDisplayContentScale();

class VideoInitProgress
{
public:
	virtual ~VideoInitProgress();
	virtual void RecordAttemptingBackend(optional<video_backend> backend) = 0;
	virtual void RecordFailedBackend(optional<video_backend> backend, const char* errorMessage) = 0;
	virtual void RecordInitFinished(bool success) = 0;
};

std::unique_ptr<VideoInitProgress> wzResumeFailedVideoInit(optional<video_backend>& backend, std::vector<video_backend>& availableBackends, std::vector<std::string>& backendInitErrors);
