/* client functions auto-generated by pidl */

#include "includes.h"
#include <tevent.h>
#include "lib/util/tevent_ntstatus.h"
#include "bin/default/librpc/gen_ndr/ndr_netlogon.h"
#include "bin/default/librpc/gen_ndr/ndr_netlogon_c.h"

/* netlogon - client functions generated by pidl */

struct dcerpc_netr_LogonUasLogon_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_LogonUasLogon_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_LogonUasLogon_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_LogonUasLogon *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_LogonUasLogon_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_LogonUasLogon_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_LOGONUASLOGON, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_LogonUasLogon_r_done, req);

	return req;
}

static void dcerpc_netr_LogonUasLogon_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_LogonUasLogon_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_LogonUasLogon_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_LogonUasLogon_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_LogonUasLogon_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_LogonUasLogon *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_LOGONUASLOGON, mem_ctx, r);

	return status;
}

struct dcerpc_netr_LogonUasLogon_state {
	struct netr_LogonUasLogon orig;
	struct netr_LogonUasLogon tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_LogonUasLogon_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_LogonUasLogon_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  const char *_server_name /* [in] [charset(UTF16),unique] */,
						  const char *_account_name /* [in] [charset(UTF16),ref] */,
						  const char *_workstation /* [in] [charset(UTF16),ref] */,
						  struct netr_UasInfo **_info /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_LogonUasLogon_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_LogonUasLogon_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.account_name = _account_name;
	state->orig.in.workstation = _workstation;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_LogonUasLogon_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_LogonUasLogon_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_LogonUasLogon_done, req);
	return req;
}

static void dcerpc_netr_LogonUasLogon_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_LogonUasLogon_state *state = tevent_req_data(
		req, struct dcerpc_netr_LogonUasLogon_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_LogonUasLogon_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_LogonUasLogon_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct dcerpc_netr_LogonUasLogon_state *state = tevent_req_data(
		req, struct dcerpc_netr_LogonUasLogon_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_LogonUasLogon(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   const char *_server_name /* [in] [charset(UTF16),unique] */,
				   const char *_account_name /* [in] [charset(UTF16),ref] */,
				   const char *_workstation /* [in] [charset(UTF16),ref] */,
				   struct netr_UasInfo **_info /* [out] [ref] */,
				   WERROR *result)
{
	struct netr_LogonUasLogon r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.account_name = _account_name;
	r.in.workstation = _workstation;

	/* Out parameters */
	r.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_LogonUasLogon_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_LogonUasLogoff_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_LogonUasLogoff_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_LogonUasLogoff_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_LogonUasLogoff *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_LogonUasLogoff_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_LogonUasLogoff_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_LOGONUASLOGOFF, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_LogonUasLogoff_r_done, req);

	return req;
}

static void dcerpc_netr_LogonUasLogoff_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_LogonUasLogoff_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_LogonUasLogoff_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_LogonUasLogoff_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_LogonUasLogoff_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_LogonUasLogoff *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_LOGONUASLOGOFF, mem_ctx, r);

	return status;
}

struct dcerpc_netr_LogonUasLogoff_state {
	struct netr_LogonUasLogoff orig;
	struct netr_LogonUasLogoff tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_LogonUasLogoff_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_LogonUasLogoff_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   const char *_server_name /* [in] [charset(UTF16),unique] */,
						   const char *_account_name /* [in] [charset(UTF16),ref] */,
						   const char *_workstation /* [in] [charset(UTF16),ref] */,
						   struct netr_UasLogoffInfo *_info /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_LogonUasLogoff_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_LogonUasLogoff_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.account_name = _account_name;
	state->orig.in.workstation = _workstation;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_LogonUasLogoff_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_LogonUasLogoff_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_LogonUasLogoff_done, req);
	return req;
}

static void dcerpc_netr_LogonUasLogoff_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_LogonUasLogoff_state *state = tevent_req_data(
		req, struct dcerpc_netr_LogonUasLogoff_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_LogonUasLogoff_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_LogonUasLogoff_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result)
{
	struct dcerpc_netr_LogonUasLogoff_state *state = tevent_req_data(
		req, struct dcerpc_netr_LogonUasLogoff_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_LogonUasLogoff(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    const char *_server_name /* [in] [charset(UTF16),unique] */,
				    const char *_account_name /* [in] [charset(UTF16),ref] */,
				    const char *_workstation /* [in] [charset(UTF16),ref] */,
				    struct netr_UasLogoffInfo *_info /* [out] [ref] */,
				    WERROR *result)
{
	struct netr_LogonUasLogoff r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.account_name = _account_name;
	r.in.workstation = _workstation;

	/* Out parameters */
	r.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_LogonUasLogoff_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_LogonSamLogon_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_LogonSamLogon_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_LogonSamLogon_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_LogonSamLogon *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_LogonSamLogon_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_LogonSamLogon_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_LOGONSAMLOGON, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_LogonSamLogon_r_done, req);

	return req;
}

static void dcerpc_netr_LogonSamLogon_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_LogonSamLogon_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_LogonSamLogon_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_LogonSamLogon_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_LogonSamLogon_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_LogonSamLogon *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_LOGONSAMLOGON, mem_ctx, r);

	return status;
}

struct dcerpc_netr_LogonSamLogon_state {
	struct netr_LogonSamLogon orig;
	struct netr_LogonSamLogon tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_LogonSamLogon_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_LogonSamLogon_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  const char *_server_name /* [in] [charset(UTF16),unique] */,
						  const char *_computer_name /* [in] [charset(UTF16),unique] */,
						  struct netr_Authenticator *_credential /* [in] [unique] */,
						  struct netr_Authenticator *_return_authenticator /* [in,out] [unique] */,
						  enum netr_LogonInfoClass _logon_level /* [in]  */,
						  union netr_LogonLevel *_logon /* [in] [ref,switch_is(logon_level)] */,
						  uint16_t _validation_level /* [in]  */,
						  union netr_Validation *_validation /* [out] [ref,switch_is(validation_level)] */,
						  uint8_t *_authoritative /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_LogonSamLogon_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_LogonSamLogon_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.computer_name = _computer_name;
	state->orig.in.credential = _credential;
	state->orig.in.return_authenticator = _return_authenticator;
	state->orig.in.logon_level = _logon_level;
	state->orig.in.logon = _logon;
	state->orig.in.validation_level = _validation_level;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;
	state->orig.out.validation = _validation;
	state->orig.out.authoritative = _authoritative;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_LogonSamLogon_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_LogonSamLogon_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_LogonSamLogon_done, req);
	return req;
}

static void dcerpc_netr_LogonSamLogon_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_LogonSamLogon_state *state = tevent_req_data(
		req, struct dcerpc_netr_LogonSamLogon_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_LogonSamLogon_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.return_authenticator && state->tmp.out.return_authenticator) {
		*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;
	}
	*state->orig.out.validation = *state->tmp.out.validation;
	*state->orig.out.authoritative = *state->tmp.out.authoritative;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_LogonSamLogon_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					NTSTATUS *result)
{
	struct dcerpc_netr_LogonSamLogon_state *state = tevent_req_data(
		req, struct dcerpc_netr_LogonSamLogon_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_LogonSamLogon(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   const char *_server_name /* [in] [charset(UTF16),unique] */,
				   const char *_computer_name /* [in] [charset(UTF16),unique] */,
				   struct netr_Authenticator *_credential /* [in] [unique] */,
				   struct netr_Authenticator *_return_authenticator /* [in,out] [unique] */,
				   enum netr_LogonInfoClass _logon_level /* [in]  */,
				   union netr_LogonLevel *_logon /* [in] [ref,switch_is(logon_level)] */,
				   uint16_t _validation_level /* [in]  */,
				   union netr_Validation *_validation /* [out] [ref,switch_is(validation_level)] */,
				   uint8_t *_authoritative /* [out] [ref] */,
				   NTSTATUS *result)
{
	struct netr_LogonSamLogon r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.computer_name = _computer_name;
	r.in.credential = _credential;
	r.in.return_authenticator = _return_authenticator;
	r.in.logon_level = _logon_level;
	r.in.logon = _logon;
	r.in.validation_level = _validation_level;

	/* Out parameters */
	r.out.return_authenticator = _return_authenticator;
	r.out.validation = _validation;
	r.out.authoritative = _authoritative;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_LogonSamLogon_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_return_authenticator && r.out.return_authenticator) {
		*_return_authenticator = *r.out.return_authenticator;
	}
	*_validation = *r.out.validation;
	*_authoritative = *r.out.authoritative;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_LogonSamLogoff_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_LogonSamLogoff_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_LogonSamLogoff_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_LogonSamLogoff *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_LogonSamLogoff_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_LogonSamLogoff_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_LOGONSAMLOGOFF, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_LogonSamLogoff_r_done, req);

	return req;
}

static void dcerpc_netr_LogonSamLogoff_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_LogonSamLogoff_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_LogonSamLogoff_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_LogonSamLogoff_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_LogonSamLogoff_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_LogonSamLogoff *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_LOGONSAMLOGOFF, mem_ctx, r);

	return status;
}

struct dcerpc_netr_LogonSamLogoff_state {
	struct netr_LogonSamLogoff orig;
	struct netr_LogonSamLogoff tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_LogonSamLogoff_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_LogonSamLogoff_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   const char *_server_name /* [in] [charset(UTF16),unique] */,
						   const char *_computer_name /* [in] [charset(UTF16),unique] */,
						   struct netr_Authenticator *_credential /* [in] [unique] */,
						   struct netr_Authenticator *_return_authenticator /* [in,out] [unique] */,
						   enum netr_LogonInfoClass _logon_level /* [in]  */,
						   union netr_LogonLevel _logon /* [in] [switch_is(logon_level)] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_LogonSamLogoff_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_LogonSamLogoff_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.computer_name = _computer_name;
	state->orig.in.credential = _credential;
	state->orig.in.return_authenticator = _return_authenticator;
	state->orig.in.logon_level = _logon_level;
	state->orig.in.logon = _logon;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_LogonSamLogoff_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_LogonSamLogoff_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_LogonSamLogoff_done, req);
	return req;
}

static void dcerpc_netr_LogonSamLogoff_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_LogonSamLogoff_state *state = tevent_req_data(
		req, struct dcerpc_netr_LogonSamLogoff_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_LogonSamLogoff_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.return_authenticator && state->tmp.out.return_authenticator) {
		*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_LogonSamLogoff_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 NTSTATUS *result)
{
	struct dcerpc_netr_LogonSamLogoff_state *state = tevent_req_data(
		req, struct dcerpc_netr_LogonSamLogoff_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_LogonSamLogoff(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    const char *_server_name /* [in] [charset(UTF16),unique] */,
				    const char *_computer_name /* [in] [charset(UTF16),unique] */,
				    struct netr_Authenticator *_credential /* [in] [unique] */,
				    struct netr_Authenticator *_return_authenticator /* [in,out] [unique] */,
				    enum netr_LogonInfoClass _logon_level /* [in]  */,
				    union netr_LogonLevel _logon /* [in] [switch_is(logon_level)] */,
				    NTSTATUS *result)
{
	struct netr_LogonSamLogoff r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.computer_name = _computer_name;
	r.in.credential = _credential;
	r.in.return_authenticator = _return_authenticator;
	r.in.logon_level = _logon_level;
	r.in.logon = _logon;

	/* Out parameters */
	r.out.return_authenticator = _return_authenticator;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_LogonSamLogoff_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_return_authenticator && r.out.return_authenticator) {
		*_return_authenticator = *r.out.return_authenticator;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_ServerReqChallenge_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_ServerReqChallenge_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_ServerReqChallenge_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_ServerReqChallenge *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_ServerReqChallenge_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_ServerReqChallenge_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_SERVERREQCHALLENGE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_ServerReqChallenge_r_done, req);

	return req;
}

static void dcerpc_netr_ServerReqChallenge_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_ServerReqChallenge_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_ServerReqChallenge_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_ServerReqChallenge_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_ServerReqChallenge_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_ServerReqChallenge *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_SERVERREQCHALLENGE, mem_ctx, r);

	return status;
}

struct dcerpc_netr_ServerReqChallenge_state {
	struct netr_ServerReqChallenge orig;
	struct netr_ServerReqChallenge tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_ServerReqChallenge_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_ServerReqChallenge_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       const char *_server_name /* [in] [charset(UTF16),unique] */,
						       const char *_computer_name /* [in] [charset(UTF16),ref] */,
						       struct netr_Credential *_credentials /* [in] [ref] */,
						       struct netr_Credential *_return_credentials /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_ServerReqChallenge_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_ServerReqChallenge_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.computer_name = _computer_name;
	state->orig.in.credentials = _credentials;

	/* Out parameters */
	state->orig.out.return_credentials = _return_credentials;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_ServerReqChallenge_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_ServerReqChallenge_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_ServerReqChallenge_done, req);
	return req;
}

static void dcerpc_netr_ServerReqChallenge_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_ServerReqChallenge_state *state = tevent_req_data(
		req, struct dcerpc_netr_ServerReqChallenge_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_ServerReqChallenge_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_credentials = *state->tmp.out.return_credentials;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_ServerReqChallenge_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result)
{
	struct dcerpc_netr_ServerReqChallenge_state *state = tevent_req_data(
		req, struct dcerpc_netr_ServerReqChallenge_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_ServerReqChallenge(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					const char *_server_name /* [in] [charset(UTF16),unique] */,
					const char *_computer_name /* [in] [charset(UTF16),ref] */,
					struct netr_Credential *_credentials /* [in] [ref] */,
					struct netr_Credential *_return_credentials /* [out] [ref] */,
					NTSTATUS *result)
{
	struct netr_ServerReqChallenge r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.computer_name = _computer_name;
	r.in.credentials = _credentials;

	/* Out parameters */
	r.out.return_credentials = _return_credentials;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_ServerReqChallenge_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_return_credentials = *r.out.return_credentials;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_ServerAuthenticate_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_ServerAuthenticate_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_ServerAuthenticate_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_ServerAuthenticate *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_ServerAuthenticate_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_ServerAuthenticate_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_SERVERAUTHENTICATE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_ServerAuthenticate_r_done, req);

	return req;
}

static void dcerpc_netr_ServerAuthenticate_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_ServerAuthenticate_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_ServerAuthenticate_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_ServerAuthenticate_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_ServerAuthenticate_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_ServerAuthenticate *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_SERVERAUTHENTICATE, mem_ctx, r);

	return status;
}

struct dcerpc_netr_ServerAuthenticate_state {
	struct netr_ServerAuthenticate orig;
	struct netr_ServerAuthenticate tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_ServerAuthenticate_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_ServerAuthenticate_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       const char *_server_name /* [in] [charset(UTF16),unique] */,
						       const char *_account_name /* [in] [charset(UTF16),ref] */,
						       enum netr_SchannelType _secure_channel_type /* [in]  */,
						       const char *_computer_name /* [in] [charset(UTF16),ref] */,
						       struct netr_Credential *_credentials /* [in] [ref] */,
						       struct netr_Credential *_return_credentials /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_ServerAuthenticate_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_ServerAuthenticate_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.account_name = _account_name;
	state->orig.in.secure_channel_type = _secure_channel_type;
	state->orig.in.computer_name = _computer_name;
	state->orig.in.credentials = _credentials;

	/* Out parameters */
	state->orig.out.return_credentials = _return_credentials;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_ServerAuthenticate_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_ServerAuthenticate_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_ServerAuthenticate_done, req);
	return req;
}

static void dcerpc_netr_ServerAuthenticate_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_ServerAuthenticate_state *state = tevent_req_data(
		req, struct dcerpc_netr_ServerAuthenticate_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_ServerAuthenticate_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_credentials = *state->tmp.out.return_credentials;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_ServerAuthenticate_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result)
{
	struct dcerpc_netr_ServerAuthenticate_state *state = tevent_req_data(
		req, struct dcerpc_netr_ServerAuthenticate_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_ServerAuthenticate(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					const char *_server_name /* [in] [charset(UTF16),unique] */,
					const char *_account_name /* [in] [charset(UTF16),ref] */,
					enum netr_SchannelType _secure_channel_type /* [in]  */,
					const char *_computer_name /* [in] [charset(UTF16),ref] */,
					struct netr_Credential *_credentials /* [in] [ref] */,
					struct netr_Credential *_return_credentials /* [out] [ref] */,
					NTSTATUS *result)
{
	struct netr_ServerAuthenticate r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.account_name = _account_name;
	r.in.secure_channel_type = _secure_channel_type;
	r.in.computer_name = _computer_name;
	r.in.credentials = _credentials;

	/* Out parameters */
	r.out.return_credentials = _return_credentials;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_ServerAuthenticate_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_return_credentials = *r.out.return_credentials;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_ServerPasswordSet_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_ServerPasswordSet_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_ServerPasswordSet_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_ServerPasswordSet *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_ServerPasswordSet_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_ServerPasswordSet_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_SERVERPASSWORDSET, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_ServerPasswordSet_r_done, req);

	return req;
}

static void dcerpc_netr_ServerPasswordSet_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_ServerPasswordSet_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_ServerPasswordSet_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_ServerPasswordSet_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_ServerPasswordSet_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_ServerPasswordSet *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_SERVERPASSWORDSET, mem_ctx, r);

	return status;
}

struct dcerpc_netr_ServerPasswordSet_state {
	struct netr_ServerPasswordSet orig;
	struct netr_ServerPasswordSet tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_ServerPasswordSet_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_ServerPasswordSet_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      const char *_server_name /* [in] [charset(UTF16),unique] */,
						      const char *_account_name /* [in] [charset(UTF16),ref] */,
						      enum netr_SchannelType _secure_channel_type /* [in]  */,
						      const char *_computer_name /* [in] [charset(UTF16),ref] */,
						      struct netr_Authenticator *_credential /* [in] [ref] */,
						      struct netr_Authenticator *_return_authenticator /* [out] [ref] */,
						      struct samr_Password *_new_password /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_ServerPasswordSet_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_ServerPasswordSet_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.account_name = _account_name;
	state->orig.in.secure_channel_type = _secure_channel_type;
	state->orig.in.computer_name = _computer_name;
	state->orig.in.credential = _credential;
	state->orig.in.new_password = _new_password;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_ServerPasswordSet_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_ServerPasswordSet_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_ServerPasswordSet_done, req);
	return req;
}

static void dcerpc_netr_ServerPasswordSet_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_ServerPasswordSet_state *state = tevent_req_data(
		req, struct dcerpc_netr_ServerPasswordSet_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_ServerPasswordSet_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_ServerPasswordSet_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    NTSTATUS *result)
{
	struct dcerpc_netr_ServerPasswordSet_state *state = tevent_req_data(
		req, struct dcerpc_netr_ServerPasswordSet_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_ServerPasswordSet(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       const char *_server_name /* [in] [charset(UTF16),unique] */,
				       const char *_account_name /* [in] [charset(UTF16),ref] */,
				       enum netr_SchannelType _secure_channel_type /* [in]  */,
				       const char *_computer_name /* [in] [charset(UTF16),ref] */,
				       struct netr_Authenticator *_credential /* [in] [ref] */,
				       struct netr_Authenticator *_return_authenticator /* [out] [ref] */,
				       struct samr_Password *_new_password /* [in] [ref] */,
				       NTSTATUS *result)
{
	struct netr_ServerPasswordSet r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.account_name = _account_name;
	r.in.secure_channel_type = _secure_channel_type;
	r.in.computer_name = _computer_name;
	r.in.credential = _credential;
	r.in.new_password = _new_password;

	/* Out parameters */
	r.out.return_authenticator = _return_authenticator;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_ServerPasswordSet_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_return_authenticator = *r.out.return_authenticator;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_DatabaseDeltas_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_DatabaseDeltas_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_DatabaseDeltas_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_DatabaseDeltas *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_DatabaseDeltas_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_DatabaseDeltas_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_DATABASEDELTAS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_DatabaseDeltas_r_done, req);

	return req;
}

static void dcerpc_netr_DatabaseDeltas_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_DatabaseDeltas_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_DatabaseDeltas_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_DatabaseDeltas_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_DatabaseDeltas_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_DatabaseDeltas *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_DATABASEDELTAS, mem_ctx, r);

	return status;
}

struct dcerpc_netr_DatabaseDeltas_state {
	struct netr_DatabaseDeltas orig;
	struct netr_DatabaseDeltas tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_DatabaseDeltas_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_DatabaseDeltas_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   const char *_logon_server /* [in] [charset(UTF16),ref] */,
						   const char *_computername /* [in] [charset(UTF16),ref] */,
						   struct netr_Authenticator *_credential /* [in] [ref] */,
						   struct netr_Authenticator *_return_authenticator /* [in,out] [ref] */,
						   enum netr_SamDatabaseID _database_id /* [in]  */,
						   uint64_t *_sequence_num /* [in,out] [ref] */,
						   struct netr_DELTA_ENUM_ARRAY **_delta_enum_array /* [out] [ref] */,
						   uint32_t _preferredmaximumlength /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_netr_DatabaseDeltas_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_DatabaseDeltas_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.logon_server = _logon_server;
	state->orig.in.computername = _computername;
	state->orig.in.credential = _credential;
	state->orig.in.return_authenticator = _return_authenticator;
	state->orig.in.database_id = _database_id;
	state->orig.in.sequence_num = _sequence_num;
	state->orig.in.preferredmaximumlength = _preferredmaximumlength;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;
	state->orig.out.sequence_num = _sequence_num;
	state->orig.out.delta_enum_array = _delta_enum_array;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_DatabaseDeltas_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_DatabaseDeltas_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_DatabaseDeltas_done, req);
	return req;
}

static void dcerpc_netr_DatabaseDeltas_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_DatabaseDeltas_state *state = tevent_req_data(
		req, struct dcerpc_netr_DatabaseDeltas_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_DatabaseDeltas_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;
	*state->orig.out.sequence_num = *state->tmp.out.sequence_num;
	*state->orig.out.delta_enum_array = *state->tmp.out.delta_enum_array;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_DatabaseDeltas_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 NTSTATUS *result)
{
	struct dcerpc_netr_DatabaseDeltas_state *state = tevent_req_data(
		req, struct dcerpc_netr_DatabaseDeltas_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_DatabaseDeltas(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    const char *_logon_server /* [in] [charset(UTF16),ref] */,
				    const char *_computername /* [in] [charset(UTF16),ref] */,
				    struct netr_Authenticator *_credential /* [in] [ref] */,
				    struct netr_Authenticator *_return_authenticator /* [in,out] [ref] */,
				    enum netr_SamDatabaseID _database_id /* [in]  */,
				    uint64_t *_sequence_num /* [in,out] [ref] */,
				    struct netr_DELTA_ENUM_ARRAY **_delta_enum_array /* [out] [ref] */,
				    uint32_t _preferredmaximumlength /* [in]  */,
				    NTSTATUS *result)
{
	struct netr_DatabaseDeltas r;
	NTSTATUS status;

	/* In parameters */
	r.in.logon_server = _logon_server;
	r.in.computername = _computername;
	r.in.credential = _credential;
	r.in.return_authenticator = _return_authenticator;
	r.in.database_id = _database_id;
	r.in.sequence_num = _sequence_num;
	r.in.preferredmaximumlength = _preferredmaximumlength;

	/* Out parameters */
	r.out.return_authenticator = _return_authenticator;
	r.out.sequence_num = _sequence_num;
	r.out.delta_enum_array = _delta_enum_array;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_DatabaseDeltas_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_return_authenticator = *r.out.return_authenticator;
	*_sequence_num = *r.out.sequence_num;
	*_delta_enum_array = *r.out.delta_enum_array;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_DatabaseSync_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_DatabaseSync_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_DatabaseSync_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_DatabaseSync *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_DatabaseSync_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_DatabaseSync_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_DATABASESYNC, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_DatabaseSync_r_done, req);

	return req;
}

static void dcerpc_netr_DatabaseSync_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_DatabaseSync_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_DatabaseSync_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_DatabaseSync_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_DatabaseSync_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_DatabaseSync *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_DATABASESYNC, mem_ctx, r);

	return status;
}

struct dcerpc_netr_DatabaseSync_state {
	struct netr_DatabaseSync orig;
	struct netr_DatabaseSync tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_DatabaseSync_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_DatabaseSync_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 const char *_logon_server /* [in] [charset(UTF16),ref] */,
						 const char *_computername /* [in] [charset(UTF16),ref] */,
						 struct netr_Authenticator *_credential /* [in] [ref] */,
						 struct netr_Authenticator *_return_authenticator /* [in,out] [ref] */,
						 enum netr_SamDatabaseID _database_id /* [in]  */,
						 uint32_t *_sync_context /* [in,out] [ref] */,
						 struct netr_DELTA_ENUM_ARRAY **_delta_enum_array /* [out] [ref] */,
						 uint32_t _preferredmaximumlength /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_netr_DatabaseSync_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_DatabaseSync_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.logon_server = _logon_server;
	state->orig.in.computername = _computername;
	state->orig.in.credential = _credential;
	state->orig.in.return_authenticator = _return_authenticator;
	state->orig.in.database_id = _database_id;
	state->orig.in.sync_context = _sync_context;
	state->orig.in.preferredmaximumlength = _preferredmaximumlength;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;
	state->orig.out.sync_context = _sync_context;
	state->orig.out.delta_enum_array = _delta_enum_array;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_DatabaseSync_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_DatabaseSync_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_DatabaseSync_done, req);
	return req;
}

static void dcerpc_netr_DatabaseSync_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_DatabaseSync_state *state = tevent_req_data(
		req, struct dcerpc_netr_DatabaseSync_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_DatabaseSync_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;
	*state->orig.out.sync_context = *state->tmp.out.sync_context;
	*state->orig.out.delta_enum_array = *state->tmp.out.delta_enum_array;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_DatabaseSync_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       NTSTATUS *result)
{
	struct dcerpc_netr_DatabaseSync_state *state = tevent_req_data(
		req, struct dcerpc_netr_DatabaseSync_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_DatabaseSync(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  const char *_logon_server /* [in] [charset(UTF16),ref] */,
				  const char *_computername /* [in] [charset(UTF16),ref] */,
				  struct netr_Authenticator *_credential /* [in] [ref] */,
				  struct netr_Authenticator *_return_authenticator /* [in,out] [ref] */,
				  enum netr_SamDatabaseID _database_id /* [in]  */,
				  uint32_t *_sync_context /* [in,out] [ref] */,
				  struct netr_DELTA_ENUM_ARRAY **_delta_enum_array /* [out] [ref] */,
				  uint32_t _preferredmaximumlength /* [in]  */,
				  NTSTATUS *result)
{
	struct netr_DatabaseSync r;
	NTSTATUS status;

	/* In parameters */
	r.in.logon_server = _logon_server;
	r.in.computername = _computername;
	r.in.credential = _credential;
	r.in.return_authenticator = _return_authenticator;
	r.in.database_id = _database_id;
	r.in.sync_context = _sync_context;
	r.in.preferredmaximumlength = _preferredmaximumlength;

	/* Out parameters */
	r.out.return_authenticator = _return_authenticator;
	r.out.sync_context = _sync_context;
	r.out.delta_enum_array = _delta_enum_array;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_DatabaseSync_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_return_authenticator = *r.out.return_authenticator;
	*_sync_context = *r.out.sync_context;
	*_delta_enum_array = *r.out.delta_enum_array;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_AccountDeltas_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_AccountDeltas_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_AccountDeltas_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_AccountDeltas *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_AccountDeltas_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_AccountDeltas_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_ACCOUNTDELTAS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_AccountDeltas_r_done, req);

	return req;
}

static void dcerpc_netr_AccountDeltas_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_AccountDeltas_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_AccountDeltas_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_AccountDeltas_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_AccountDeltas_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_AccountDeltas *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_ACCOUNTDELTAS, mem_ctx, r);

	return status;
}

struct dcerpc_netr_AccountDeltas_state {
	struct netr_AccountDeltas orig;
	struct netr_AccountDeltas tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_AccountDeltas_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_AccountDeltas_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  const char *_logon_server /* [in] [charset(UTF16),unique] */,
						  const char *_computername /* [in] [charset(UTF16),ref] */,
						  struct netr_Authenticator _credential /* [in]  */,
						  struct netr_Authenticator *_return_authenticator /* [in,out] [ref] */,
						  struct netr_UAS_INFO_0 _uas /* [in]  */,
						  uint32_t _count /* [in]  */,
						  uint32_t _level /* [in]  */,
						  uint32_t _buffersize /* [in]  */,
						  struct netr_AccountBuffer *_buffer /* [out] [ref,subcontext(4)] */,
						  uint32_t *_count_returned /* [out] [ref] */,
						  uint32_t *_total_entries /* [out] [ref] */,
						  struct netr_UAS_INFO_0 *_recordid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_AccountDeltas_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_AccountDeltas_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.logon_server = _logon_server;
	state->orig.in.computername = _computername;
	state->orig.in.credential = _credential;
	state->orig.in.return_authenticator = _return_authenticator;
	state->orig.in.uas = _uas;
	state->orig.in.count = _count;
	state->orig.in.level = _level;
	state->orig.in.buffersize = _buffersize;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;
	state->orig.out.buffer = _buffer;
	state->orig.out.count_returned = _count_returned;
	state->orig.out.total_entries = _total_entries;
	state->orig.out.recordid = _recordid;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_AccountDeltas_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_AccountDeltas_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_AccountDeltas_done, req);
	return req;
}

static void dcerpc_netr_AccountDeltas_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_AccountDeltas_state *state = tevent_req_data(
		req, struct dcerpc_netr_AccountDeltas_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_AccountDeltas_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;
	*state->orig.out.buffer = *state->tmp.out.buffer;
	*state->orig.out.count_returned = *state->tmp.out.count_returned;
	*state->orig.out.total_entries = *state->tmp.out.total_entries;
	*state->orig.out.recordid = *state->tmp.out.recordid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_AccountDeltas_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					NTSTATUS *result)
{
	struct dcerpc_netr_AccountDeltas_state *state = tevent_req_data(
		req, struct dcerpc_netr_AccountDeltas_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_AccountDeltas(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   const char *_logon_server /* [in] [charset(UTF16),unique] */,
				   const char *_computername /* [in] [charset(UTF16),ref] */,
				   struct netr_Authenticator _credential /* [in]  */,
				   struct netr_Authenticator *_return_authenticator /* [in,out] [ref] */,
				   struct netr_UAS_INFO_0 _uas /* [in]  */,
				   uint32_t _count /* [in]  */,
				   uint32_t _level /* [in]  */,
				   uint32_t _buffersize /* [in]  */,
				   struct netr_AccountBuffer *_buffer /* [out] [ref,subcontext(4)] */,
				   uint32_t *_count_returned /* [out] [ref] */,
				   uint32_t *_total_entries /* [out] [ref] */,
				   struct netr_UAS_INFO_0 *_recordid /* [out] [ref] */,
				   NTSTATUS *result)
{
	struct netr_AccountDeltas r;
	NTSTATUS status;

	/* In parameters */
	r.in.logon_server = _logon_server;
	r.in.computername = _computername;
	r.in.credential = _credential;
	r.in.return_authenticator = _return_authenticator;
	r.in.uas = _uas;
	r.in.count = _count;
	r.in.level = _level;
	r.in.buffersize = _buffersize;

	/* Out parameters */
	r.out.return_authenticator = _return_authenticator;
	r.out.buffer = _buffer;
	r.out.count_returned = _count_returned;
	r.out.total_entries = _total_entries;
	r.out.recordid = _recordid;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_AccountDeltas_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_return_authenticator = *r.out.return_authenticator;
	*_buffer = *r.out.buffer;
	*_count_returned = *r.out.count_returned;
	*_total_entries = *r.out.total_entries;
	*_recordid = *r.out.recordid;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_AccountSync_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_AccountSync_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_AccountSync_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_AccountSync *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_AccountSync_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_AccountSync_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_ACCOUNTSYNC, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_AccountSync_r_done, req);

	return req;
}

static void dcerpc_netr_AccountSync_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_AccountSync_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_AccountSync_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_AccountSync_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_AccountSync_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_AccountSync *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_ACCOUNTSYNC, mem_ctx, r);

	return status;
}

struct dcerpc_netr_AccountSync_state {
	struct netr_AccountSync orig;
	struct netr_AccountSync tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_AccountSync_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_AccountSync_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						const char *_logon_server /* [in] [charset(UTF16),unique] */,
						const char *_computername /* [in] [charset(UTF16),ref] */,
						struct netr_Authenticator _credential /* [in]  */,
						struct netr_Authenticator *_return_authenticator /* [in,out] [ref] */,
						uint32_t _reference /* [in]  */,
						uint32_t _level /* [in]  */,
						uint32_t _buffersize /* [in]  */,
						struct netr_AccountBuffer *_buffer /* [out] [ref,subcontext(4)] */,
						uint32_t *_count_returned /* [out] [ref] */,
						uint32_t *_total_entries /* [out] [ref] */,
						uint32_t *_next_reference /* [out] [ref] */,
						struct netr_UAS_INFO_0 *_recordid /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_AccountSync_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_AccountSync_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.logon_server = _logon_server;
	state->orig.in.computername = _computername;
	state->orig.in.credential = _credential;
	state->orig.in.return_authenticator = _return_authenticator;
	state->orig.in.reference = _reference;
	state->orig.in.level = _level;
	state->orig.in.buffersize = _buffersize;
	state->orig.in.recordid = _recordid;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;
	state->orig.out.buffer = _buffer;
	state->orig.out.count_returned = _count_returned;
	state->orig.out.total_entries = _total_entries;
	state->orig.out.next_reference = _next_reference;
	state->orig.out.recordid = _recordid;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_AccountSync_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_AccountSync_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_AccountSync_done, req);
	return req;
}

static void dcerpc_netr_AccountSync_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_AccountSync_state *state = tevent_req_data(
		req, struct dcerpc_netr_AccountSync_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_AccountSync_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;
	*state->orig.out.buffer = *state->tmp.out.buffer;
	*state->orig.out.count_returned = *state->tmp.out.count_returned;
	*state->orig.out.total_entries = *state->tmp.out.total_entries;
	*state->orig.out.next_reference = *state->tmp.out.next_reference;
	*state->orig.out.recordid = *state->tmp.out.recordid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_AccountSync_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      NTSTATUS *result)
{
	struct dcerpc_netr_AccountSync_state *state = tevent_req_data(
		req, struct dcerpc_netr_AccountSync_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_AccountSync(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 const char *_logon_server /* [in] [charset(UTF16),unique] */,
				 const char *_computername /* [in] [charset(UTF16),ref] */,
				 struct netr_Authenticator _credential /* [in]  */,
				 struct netr_Authenticator *_return_authenticator /* [in,out] [ref] */,
				 uint32_t _reference /* [in]  */,
				 uint32_t _level /* [in]  */,
				 uint32_t _buffersize /* [in]  */,
				 struct netr_AccountBuffer *_buffer /* [out] [ref,subcontext(4)] */,
				 uint32_t *_count_returned /* [out] [ref] */,
				 uint32_t *_total_entries /* [out] [ref] */,
				 uint32_t *_next_reference /* [out] [ref] */,
				 struct netr_UAS_INFO_0 *_recordid /* [in,out] [ref] */,
				 NTSTATUS *result)
{
	struct netr_AccountSync r;
	NTSTATUS status;

	/* In parameters */
	r.in.logon_server = _logon_server;
	r.in.computername = _computername;
	r.in.credential = _credential;
	r.in.return_authenticator = _return_authenticator;
	r.in.reference = _reference;
	r.in.level = _level;
	r.in.buffersize = _buffersize;
	r.in.recordid = _recordid;

	/* Out parameters */
	r.out.return_authenticator = _return_authenticator;
	r.out.buffer = _buffer;
	r.out.count_returned = _count_returned;
	r.out.total_entries = _total_entries;
	r.out.next_reference = _next_reference;
	r.out.recordid = _recordid;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_AccountSync_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_return_authenticator = *r.out.return_authenticator;
	*_buffer = *r.out.buffer;
	*_count_returned = *r.out.count_returned;
	*_total_entries = *r.out.total_entries;
	*_next_reference = *r.out.next_reference;
	*_recordid = *r.out.recordid;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_GetDcName_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_GetDcName_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_GetDcName_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_GetDcName *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_GetDcName_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_GetDcName_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_GETDCNAME, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_GetDcName_r_done, req);

	return req;
}

static void dcerpc_netr_GetDcName_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_GetDcName_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_GetDcName_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_GetDcName_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_GetDcName_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_GetDcName *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_GETDCNAME, mem_ctx, r);

	return status;
}

struct dcerpc_netr_GetDcName_state {
	struct netr_GetDcName orig;
	struct netr_GetDcName tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_GetDcName_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_GetDcName_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct dcerpc_binding_handle *h,
					      const char *_logon_server /* [in] [charset(UTF16),ref] */,
					      const char *_domainname /* [in] [charset(UTF16),unique] */,
					      const char **_dcname /* [out] [charset(UTF16),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_GetDcName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_GetDcName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.logon_server = _logon_server;
	state->orig.in.domainname = _domainname;

	/* Out parameters */
	state->orig.out.dcname = _dcname;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_GetDcName_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_GetDcName_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_GetDcName_done, req);
	return req;
}

static void dcerpc_netr_GetDcName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_GetDcName_state *state = tevent_req_data(
		req, struct dcerpc_netr_GetDcName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_GetDcName_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.dcname = *state->tmp.out.dcname;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_GetDcName_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result)
{
	struct dcerpc_netr_GetDcName_state *state = tevent_req_data(
		req, struct dcerpc_netr_GetDcName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_GetDcName(struct dcerpc_binding_handle *h,
			       TALLOC_CTX *mem_ctx,
			       const char *_logon_server /* [in] [charset(UTF16),ref] */,
			       const char *_domainname /* [in] [charset(UTF16),unique] */,
			       const char **_dcname /* [out] [charset(UTF16),ref] */,
			       WERROR *result)
{
	struct netr_GetDcName r;
	NTSTATUS status;

	/* In parameters */
	r.in.logon_server = _logon_server;
	r.in.domainname = _domainname;

	/* Out parameters */
	r.out.dcname = _dcname;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_GetDcName_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_dcname = *r.out.dcname;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_LogonControl_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_LogonControl_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_LogonControl_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_LogonControl *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_LogonControl_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_LogonControl_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_LOGONCONTROL, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_LogonControl_r_done, req);

	return req;
}

static void dcerpc_netr_LogonControl_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_LogonControl_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_LogonControl_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_LogonControl_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_LogonControl_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_LogonControl *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_LOGONCONTROL, mem_ctx, r);

	return status;
}

struct dcerpc_netr_LogonControl_state {
	struct netr_LogonControl orig;
	struct netr_LogonControl tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_LogonControl_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_LogonControl_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 const char *_logon_server /* [in] [charset(UTF16),unique] */,
						 enum netr_LogonControlCode _function_code /* [in]  */,
						 uint32_t _level /* [in]  */,
						 union netr_CONTROL_QUERY_INFORMATION *_query /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_LogonControl_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_LogonControl_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.logon_server = _logon_server;
	state->orig.in.function_code = _function_code;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.query = _query;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_LogonControl_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_LogonControl_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_LogonControl_done, req);
	return req;
}

static void dcerpc_netr_LogonControl_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_LogonControl_state *state = tevent_req_data(
		req, struct dcerpc_netr_LogonControl_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_LogonControl_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.query = *state->tmp.out.query;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_LogonControl_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct dcerpc_netr_LogonControl_state *state = tevent_req_data(
		req, struct dcerpc_netr_LogonControl_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_LogonControl(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  const char *_logon_server /* [in] [charset(UTF16),unique] */,
				  enum netr_LogonControlCode _function_code /* [in]  */,
				  uint32_t _level /* [in]  */,
				  union netr_CONTROL_QUERY_INFORMATION *_query /* [out] [ref,switch_is(level)] */,
				  WERROR *result)
{
	struct netr_LogonControl r;
	NTSTATUS status;

	/* In parameters */
	r.in.logon_server = _logon_server;
	r.in.function_code = _function_code;
	r.in.level = _level;

	/* Out parameters */
	r.out.query = _query;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_LogonControl_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_query = *r.out.query;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_GetAnyDCName_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_GetAnyDCName_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_GetAnyDCName_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_GetAnyDCName *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_GetAnyDCName_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_GetAnyDCName_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_GETANYDCNAME, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_GetAnyDCName_r_done, req);

	return req;
}

static void dcerpc_netr_GetAnyDCName_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_GetAnyDCName_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_GetAnyDCName_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_GetAnyDCName_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_GetAnyDCName_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_GetAnyDCName *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_GETANYDCNAME, mem_ctx, r);

	return status;
}

struct dcerpc_netr_GetAnyDCName_state {
	struct netr_GetAnyDCName orig;
	struct netr_GetAnyDCName tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_GetAnyDCName_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_GetAnyDCName_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 const char *_logon_server /* [in] [charset(UTF16),unique] */,
						 const char *_domainname /* [in] [charset(UTF16),unique] */,
						 const char **_dcname /* [out] [charset(UTF16),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_GetAnyDCName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_GetAnyDCName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.logon_server = _logon_server;
	state->orig.in.domainname = _domainname;

	/* Out parameters */
	state->orig.out.dcname = _dcname;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_GetAnyDCName_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_GetAnyDCName_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_GetAnyDCName_done, req);
	return req;
}

static void dcerpc_netr_GetAnyDCName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_GetAnyDCName_state *state = tevent_req_data(
		req, struct dcerpc_netr_GetAnyDCName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_GetAnyDCName_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.dcname = *state->tmp.out.dcname;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_GetAnyDCName_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct dcerpc_netr_GetAnyDCName_state *state = tevent_req_data(
		req, struct dcerpc_netr_GetAnyDCName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_GetAnyDCName(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  const char *_logon_server /* [in] [charset(UTF16),unique] */,
				  const char *_domainname /* [in] [charset(UTF16),unique] */,
				  const char **_dcname /* [out] [charset(UTF16),ref] */,
				  WERROR *result)
{
	struct netr_GetAnyDCName r;
	NTSTATUS status;

	/* In parameters */
	r.in.logon_server = _logon_server;
	r.in.domainname = _domainname;

	/* Out parameters */
	r.out.dcname = _dcname;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_GetAnyDCName_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_dcname = *r.out.dcname;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_LogonControl2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_LogonControl2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_LogonControl2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_LogonControl2 *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_LogonControl2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_LogonControl2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_LOGONCONTROL2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_LogonControl2_r_done, req);

	return req;
}

static void dcerpc_netr_LogonControl2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_LogonControl2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_LogonControl2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_LogonControl2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_LogonControl2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_LogonControl2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_LOGONCONTROL2, mem_ctx, r);

	return status;
}

struct dcerpc_netr_LogonControl2_state {
	struct netr_LogonControl2 orig;
	struct netr_LogonControl2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_LogonControl2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_LogonControl2_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  const char *_logon_server /* [in] [charset(UTF16),unique] */,
						  enum netr_LogonControlCode _function_code /* [in]  */,
						  uint32_t _level /* [in]  */,
						  union netr_CONTROL_DATA_INFORMATION *_data /* [in] [ref,switch_is(function_code)] */,
						  union netr_CONTROL_QUERY_INFORMATION *_query /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_LogonControl2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_LogonControl2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.logon_server = _logon_server;
	state->orig.in.function_code = _function_code;
	state->orig.in.level = _level;
	state->orig.in.data = _data;

	/* Out parameters */
	state->orig.out.query = _query;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_LogonControl2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_LogonControl2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_LogonControl2_done, req);
	return req;
}

static void dcerpc_netr_LogonControl2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_LogonControl2_state *state = tevent_req_data(
		req, struct dcerpc_netr_LogonControl2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_LogonControl2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.query = *state->tmp.out.query;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_LogonControl2_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct dcerpc_netr_LogonControl2_state *state = tevent_req_data(
		req, struct dcerpc_netr_LogonControl2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_LogonControl2(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   const char *_logon_server /* [in] [charset(UTF16),unique] */,
				   enum netr_LogonControlCode _function_code /* [in]  */,
				   uint32_t _level /* [in]  */,
				   union netr_CONTROL_DATA_INFORMATION *_data /* [in] [ref,switch_is(function_code)] */,
				   union netr_CONTROL_QUERY_INFORMATION *_query /* [out] [ref,switch_is(level)] */,
				   WERROR *result)
{
	struct netr_LogonControl2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.logon_server = _logon_server;
	r.in.function_code = _function_code;
	r.in.level = _level;
	r.in.data = _data;

	/* Out parameters */
	r.out.query = _query;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_LogonControl2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_query = *r.out.query;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_ServerAuthenticate2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_ServerAuthenticate2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_ServerAuthenticate2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_ServerAuthenticate2 *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_ServerAuthenticate2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_ServerAuthenticate2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_SERVERAUTHENTICATE2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_ServerAuthenticate2_r_done, req);

	return req;
}

static void dcerpc_netr_ServerAuthenticate2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_ServerAuthenticate2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_ServerAuthenticate2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_ServerAuthenticate2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_ServerAuthenticate2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_ServerAuthenticate2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_SERVERAUTHENTICATE2, mem_ctx, r);

	return status;
}

struct dcerpc_netr_ServerAuthenticate2_state {
	struct netr_ServerAuthenticate2 orig;
	struct netr_ServerAuthenticate2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_ServerAuthenticate2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_ServerAuthenticate2_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							const char *_server_name /* [in] [charset(UTF16),unique] */,
							const char *_account_name /* [in] [charset(UTF16),ref] */,
							enum netr_SchannelType _secure_channel_type /* [in]  */,
							const char *_computer_name /* [in] [charset(UTF16),ref] */,
							struct netr_Credential *_credentials /* [in] [ref] */,
							struct netr_Credential *_return_credentials /* [out] [ref] */,
							uint32_t *_negotiate_flags /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_ServerAuthenticate2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_ServerAuthenticate2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.account_name = _account_name;
	state->orig.in.secure_channel_type = _secure_channel_type;
	state->orig.in.computer_name = _computer_name;
	state->orig.in.credentials = _credentials;
	state->orig.in.negotiate_flags = _negotiate_flags;

	/* Out parameters */
	state->orig.out.return_credentials = _return_credentials;
	state->orig.out.negotiate_flags = _negotiate_flags;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_ServerAuthenticate2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_ServerAuthenticate2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_ServerAuthenticate2_done, req);
	return req;
}

static void dcerpc_netr_ServerAuthenticate2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_ServerAuthenticate2_state *state = tevent_req_data(
		req, struct dcerpc_netr_ServerAuthenticate2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_ServerAuthenticate2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_credentials = *state->tmp.out.return_credentials;
	*state->orig.out.negotiate_flags = *state->tmp.out.negotiate_flags;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_ServerAuthenticate2_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      NTSTATUS *result)
{
	struct dcerpc_netr_ServerAuthenticate2_state *state = tevent_req_data(
		req, struct dcerpc_netr_ServerAuthenticate2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_ServerAuthenticate2(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 const char *_server_name /* [in] [charset(UTF16),unique] */,
					 const char *_account_name /* [in] [charset(UTF16),ref] */,
					 enum netr_SchannelType _secure_channel_type /* [in]  */,
					 const char *_computer_name /* [in] [charset(UTF16),ref] */,
					 struct netr_Credential *_credentials /* [in] [ref] */,
					 struct netr_Credential *_return_credentials /* [out] [ref] */,
					 uint32_t *_negotiate_flags /* [in,out] [ref] */,
					 NTSTATUS *result)
{
	struct netr_ServerAuthenticate2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.account_name = _account_name;
	r.in.secure_channel_type = _secure_channel_type;
	r.in.computer_name = _computer_name;
	r.in.credentials = _credentials;
	r.in.negotiate_flags = _negotiate_flags;

	/* Out parameters */
	r.out.return_credentials = _return_credentials;
	r.out.negotiate_flags = _negotiate_flags;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_ServerAuthenticate2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_return_credentials = *r.out.return_credentials;
	*_negotiate_flags = *r.out.negotiate_flags;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_DatabaseSync2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_DatabaseSync2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_DatabaseSync2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_DatabaseSync2 *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_DatabaseSync2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_DatabaseSync2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_DATABASESYNC2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_DatabaseSync2_r_done, req);

	return req;
}

static void dcerpc_netr_DatabaseSync2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_DatabaseSync2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_DatabaseSync2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_DatabaseSync2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_DatabaseSync2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_DatabaseSync2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_DATABASESYNC2, mem_ctx, r);

	return status;
}

struct dcerpc_netr_DatabaseSync2_state {
	struct netr_DatabaseSync2 orig;
	struct netr_DatabaseSync2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_DatabaseSync2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_DatabaseSync2_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  const char *_logon_server /* [in] [charset(UTF16),ref] */,
						  const char *_computername /* [in] [charset(UTF16),ref] */,
						  struct netr_Authenticator *_credential /* [in] [ref] */,
						  struct netr_Authenticator *_return_authenticator /* [in,out] [ref] */,
						  enum netr_SamDatabaseID _database_id /* [in]  */,
						  enum SyncStateEnum _restart_state /* [in]  */,
						  uint32_t *_sync_context /* [in,out] [ref] */,
						  struct netr_DELTA_ENUM_ARRAY **_delta_enum_array /* [out] [ref] */,
						  uint32_t _preferredmaximumlength /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_netr_DatabaseSync2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_DatabaseSync2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.logon_server = _logon_server;
	state->orig.in.computername = _computername;
	state->orig.in.credential = _credential;
	state->orig.in.return_authenticator = _return_authenticator;
	state->orig.in.database_id = _database_id;
	state->orig.in.restart_state = _restart_state;
	state->orig.in.sync_context = _sync_context;
	state->orig.in.preferredmaximumlength = _preferredmaximumlength;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;
	state->orig.out.sync_context = _sync_context;
	state->orig.out.delta_enum_array = _delta_enum_array;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_DatabaseSync2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_DatabaseSync2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_DatabaseSync2_done, req);
	return req;
}

static void dcerpc_netr_DatabaseSync2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_DatabaseSync2_state *state = tevent_req_data(
		req, struct dcerpc_netr_DatabaseSync2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_DatabaseSync2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;
	*state->orig.out.sync_context = *state->tmp.out.sync_context;
	*state->orig.out.delta_enum_array = *state->tmp.out.delta_enum_array;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_DatabaseSync2_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					NTSTATUS *result)
{
	struct dcerpc_netr_DatabaseSync2_state *state = tevent_req_data(
		req, struct dcerpc_netr_DatabaseSync2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_DatabaseSync2(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   const char *_logon_server /* [in] [charset(UTF16),ref] */,
				   const char *_computername /* [in] [charset(UTF16),ref] */,
				   struct netr_Authenticator *_credential /* [in] [ref] */,
				   struct netr_Authenticator *_return_authenticator /* [in,out] [ref] */,
				   enum netr_SamDatabaseID _database_id /* [in]  */,
				   enum SyncStateEnum _restart_state /* [in]  */,
				   uint32_t *_sync_context /* [in,out] [ref] */,
				   struct netr_DELTA_ENUM_ARRAY **_delta_enum_array /* [out] [ref] */,
				   uint32_t _preferredmaximumlength /* [in]  */,
				   NTSTATUS *result)
{
	struct netr_DatabaseSync2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.logon_server = _logon_server;
	r.in.computername = _computername;
	r.in.credential = _credential;
	r.in.return_authenticator = _return_authenticator;
	r.in.database_id = _database_id;
	r.in.restart_state = _restart_state;
	r.in.sync_context = _sync_context;
	r.in.preferredmaximumlength = _preferredmaximumlength;

	/* Out parameters */
	r.out.return_authenticator = _return_authenticator;
	r.out.sync_context = _sync_context;
	r.out.delta_enum_array = _delta_enum_array;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_DatabaseSync2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_return_authenticator = *r.out.return_authenticator;
	*_sync_context = *r.out.sync_context;
	*_delta_enum_array = *r.out.delta_enum_array;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_DatabaseRedo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_DatabaseRedo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_DatabaseRedo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_DatabaseRedo *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_DatabaseRedo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_DatabaseRedo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_DATABASEREDO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_DatabaseRedo_r_done, req);

	return req;
}

static void dcerpc_netr_DatabaseRedo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_DatabaseRedo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_DatabaseRedo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_DatabaseRedo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_DatabaseRedo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_DatabaseRedo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_DATABASEREDO, mem_ctx, r);

	return status;
}

struct dcerpc_netr_DatabaseRedo_state {
	struct netr_DatabaseRedo orig;
	struct netr_DatabaseRedo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_DatabaseRedo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_DatabaseRedo_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 const char *_logon_server /* [in] [charset(UTF16),ref] */,
						 const char *_computername /* [in] [charset(UTF16),ref] */,
						 struct netr_Authenticator *_credential /* [in] [ref] */,
						 struct netr_Authenticator *_return_authenticator /* [in,out] [ref] */,
						 struct netr_ChangeLogEntry _change_log_entry /* [in] [subcontext(4)] */,
						 uint32_t _change_log_entry_size /* [in] [value(ndr_size_netr_ChangeLogEntry(&change_log_entry,ndr->flags))] */,
						 struct netr_DELTA_ENUM_ARRAY **_delta_enum_array /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_DatabaseRedo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_DatabaseRedo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.logon_server = _logon_server;
	state->orig.in.computername = _computername;
	state->orig.in.credential = _credential;
	state->orig.in.return_authenticator = _return_authenticator;
	state->orig.in.change_log_entry = _change_log_entry;
	state->orig.in.change_log_entry_size = _change_log_entry_size;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;
	state->orig.out.delta_enum_array = _delta_enum_array;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_DatabaseRedo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_DatabaseRedo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_DatabaseRedo_done, req);
	return req;
}

static void dcerpc_netr_DatabaseRedo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_DatabaseRedo_state *state = tevent_req_data(
		req, struct dcerpc_netr_DatabaseRedo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_DatabaseRedo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;
	*state->orig.out.delta_enum_array = *state->tmp.out.delta_enum_array;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_DatabaseRedo_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       NTSTATUS *result)
{
	struct dcerpc_netr_DatabaseRedo_state *state = tevent_req_data(
		req, struct dcerpc_netr_DatabaseRedo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_DatabaseRedo(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  const char *_logon_server /* [in] [charset(UTF16),ref] */,
				  const char *_computername /* [in] [charset(UTF16),ref] */,
				  struct netr_Authenticator *_credential /* [in] [ref] */,
				  struct netr_Authenticator *_return_authenticator /* [in,out] [ref] */,
				  struct netr_ChangeLogEntry _change_log_entry /* [in] [subcontext(4)] */,
				  uint32_t _change_log_entry_size /* [in] [value(ndr_size_netr_ChangeLogEntry(&change_log_entry,ndr->flags))] */,
				  struct netr_DELTA_ENUM_ARRAY **_delta_enum_array /* [out] [ref] */,
				  NTSTATUS *result)
{
	struct netr_DatabaseRedo r;
	NTSTATUS status;

	/* In parameters */
	r.in.logon_server = _logon_server;
	r.in.computername = _computername;
	r.in.credential = _credential;
	r.in.return_authenticator = _return_authenticator;
	r.in.change_log_entry = _change_log_entry;
	r.in.change_log_entry_size = _change_log_entry_size;

	/* Out parameters */
	r.out.return_authenticator = _return_authenticator;
	r.out.delta_enum_array = _delta_enum_array;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_DatabaseRedo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_return_authenticator = *r.out.return_authenticator;
	*_delta_enum_array = *r.out.delta_enum_array;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_LogonControl2Ex_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_LogonControl2Ex_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_LogonControl2Ex_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_LogonControl2Ex *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_LogonControl2Ex_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_LogonControl2Ex_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_LOGONCONTROL2EX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_LogonControl2Ex_r_done, req);

	return req;
}

static void dcerpc_netr_LogonControl2Ex_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_LogonControl2Ex_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_LogonControl2Ex_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_LogonControl2Ex_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_LogonControl2Ex_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_LogonControl2Ex *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_LOGONCONTROL2EX, mem_ctx, r);

	return status;
}

struct dcerpc_netr_LogonControl2Ex_state {
	struct netr_LogonControl2Ex orig;
	struct netr_LogonControl2Ex tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_LogonControl2Ex_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_LogonControl2Ex_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    const char *_logon_server /* [in] [charset(UTF16),unique] */,
						    enum netr_LogonControlCode _function_code /* [in]  */,
						    uint32_t _level /* [in]  */,
						    union netr_CONTROL_DATA_INFORMATION *_data /* [in] [ref,switch_is(function_code)] */,
						    union netr_CONTROL_QUERY_INFORMATION *_query /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_LogonControl2Ex_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_LogonControl2Ex_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.logon_server = _logon_server;
	state->orig.in.function_code = _function_code;
	state->orig.in.level = _level;
	state->orig.in.data = _data;

	/* Out parameters */
	state->orig.out.query = _query;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_LogonControl2Ex_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_LogonControl2Ex_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_LogonControl2Ex_done, req);
	return req;
}

static void dcerpc_netr_LogonControl2Ex_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_LogonControl2Ex_state *state = tevent_req_data(
		req, struct dcerpc_netr_LogonControl2Ex_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_LogonControl2Ex_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.query = *state->tmp.out.query;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_LogonControl2Ex_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_netr_LogonControl2Ex_state *state = tevent_req_data(
		req, struct dcerpc_netr_LogonControl2Ex_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_LogonControl2Ex(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     const char *_logon_server /* [in] [charset(UTF16),unique] */,
				     enum netr_LogonControlCode _function_code /* [in]  */,
				     uint32_t _level /* [in]  */,
				     union netr_CONTROL_DATA_INFORMATION *_data /* [in] [ref,switch_is(function_code)] */,
				     union netr_CONTROL_QUERY_INFORMATION *_query /* [out] [ref,switch_is(level)] */,
				     WERROR *result)
{
	struct netr_LogonControl2Ex r;
	NTSTATUS status;

	/* In parameters */
	r.in.logon_server = _logon_server;
	r.in.function_code = _function_code;
	r.in.level = _level;
	r.in.data = _data;

	/* Out parameters */
	r.out.query = _query;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_LogonControl2Ex_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_query = *r.out.query;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_NetrEnumerateTrustedDomains_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_NetrEnumerateTrustedDomains_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_NetrEnumerateTrustedDomains_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_NetrEnumerateTrustedDomains *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_NetrEnumerateTrustedDomains_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_NetrEnumerateTrustedDomains_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_NETRENUMERATETRUSTEDDOMAINS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_NetrEnumerateTrustedDomains_r_done, req);

	return req;
}

static void dcerpc_netr_NetrEnumerateTrustedDomains_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_NetrEnumerateTrustedDomains_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_NetrEnumerateTrustedDomains_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_NetrEnumerateTrustedDomains_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_NetrEnumerateTrustedDomains_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_NetrEnumerateTrustedDomains *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_NETRENUMERATETRUSTEDDOMAINS, mem_ctx, r);

	return status;
}

struct dcerpc_netr_NetrEnumerateTrustedDomains_state {
	struct netr_NetrEnumerateTrustedDomains orig;
	struct netr_NetrEnumerateTrustedDomains tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_NetrEnumerateTrustedDomains_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_NetrEnumerateTrustedDomains_send(TALLOC_CTX *mem_ctx,
								struct tevent_context *ev,
								struct dcerpc_binding_handle *h,
								const char *_server_name /* [in] [charset(UTF16),unique] */,
								struct netr_Blob *_trusted_domains_blob /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_NetrEnumerateTrustedDomains_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_NetrEnumerateTrustedDomains_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;

	/* Out parameters */
	state->orig.out.trusted_domains_blob = _trusted_domains_blob;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_NetrEnumerateTrustedDomains_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_NetrEnumerateTrustedDomains_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_NetrEnumerateTrustedDomains_done, req);
	return req;
}

static void dcerpc_netr_NetrEnumerateTrustedDomains_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_NetrEnumerateTrustedDomains_state *state = tevent_req_data(
		req, struct dcerpc_netr_NetrEnumerateTrustedDomains_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_NetrEnumerateTrustedDomains_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.trusted_domains_blob = *state->tmp.out.trusted_domains_blob;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_NetrEnumerateTrustedDomains_recv(struct tevent_req *req,
						      TALLOC_CTX *mem_ctx,
						      NTSTATUS *result)
{
	struct dcerpc_netr_NetrEnumerateTrustedDomains_state *state = tevent_req_data(
		req, struct dcerpc_netr_NetrEnumerateTrustedDomains_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_NetrEnumerateTrustedDomains(struct dcerpc_binding_handle *h,
						 TALLOC_CTX *mem_ctx,
						 const char *_server_name /* [in] [charset(UTF16),unique] */,
						 struct netr_Blob *_trusted_domains_blob /* [out] [ref] */,
						 NTSTATUS *result)
{
	struct netr_NetrEnumerateTrustedDomains r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;

	/* Out parameters */
	r.out.trusted_domains_blob = _trusted_domains_blob;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_NetrEnumerateTrustedDomains_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_trusted_domains_blob = *r.out.trusted_domains_blob;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_DsRGetDCName_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_DsRGetDCName_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_DsRGetDCName_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_DsRGetDCName *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_DsRGetDCName_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_DsRGetDCName_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_DSRGETDCNAME, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_DsRGetDCName_r_done, req);

	return req;
}

static void dcerpc_netr_DsRGetDCName_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_DsRGetDCName_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_DsRGetDCName_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_DsRGetDCName_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_DsRGetDCName_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_DsRGetDCName *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_DSRGETDCNAME, mem_ctx, r);

	return status;
}

struct dcerpc_netr_DsRGetDCName_state {
	struct netr_DsRGetDCName orig;
	struct netr_DsRGetDCName tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_DsRGetDCName_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_DsRGetDCName_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 const char *_server_unc /* [in] [charset(UTF16),unique] */,
						 const char *_domain_name /* [in] [charset(UTF16),unique] */,
						 struct GUID *_domain_guid /* [in] [unique] */,
						 struct GUID *_site_guid /* [in] [unique] */,
						 uint32_t _flags /* [in]  */,
						 struct netr_DsRGetDCNameInfo **_info /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_DsRGetDCName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_DsRGetDCName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.domain_name = _domain_name;
	state->orig.in.domain_guid = _domain_guid;
	state->orig.in.site_guid = _site_guid;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_DsRGetDCName_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_DsRGetDCName_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_DsRGetDCName_done, req);
	return req;
}

static void dcerpc_netr_DsRGetDCName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_DsRGetDCName_state *state = tevent_req_data(
		req, struct dcerpc_netr_DsRGetDCName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_DsRGetDCName_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_DsRGetDCName_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct dcerpc_netr_DsRGetDCName_state *state = tevent_req_data(
		req, struct dcerpc_netr_DsRGetDCName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_DsRGetDCName(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  const char *_server_unc /* [in] [charset(UTF16),unique] */,
				  const char *_domain_name /* [in] [charset(UTF16),unique] */,
				  struct GUID *_domain_guid /* [in] [unique] */,
				  struct GUID *_site_guid /* [in] [unique] */,
				  uint32_t _flags /* [in]  */,
				  struct netr_DsRGetDCNameInfo **_info /* [out] [ref] */,
				  WERROR *result)
{
	struct netr_DsRGetDCName r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.domain_name = _domain_name;
	r.in.domain_guid = _domain_guid;
	r.in.site_guid = _site_guid;
	r.in.flags = _flags;

	/* Out parameters */
	r.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_DsRGetDCName_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_LogonGetCapabilities_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_LogonGetCapabilities_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_LogonGetCapabilities_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_LogonGetCapabilities *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_LogonGetCapabilities_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_LogonGetCapabilities_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_LOGONGETCAPABILITIES, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_LogonGetCapabilities_r_done, req);

	return req;
}

static void dcerpc_netr_LogonGetCapabilities_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_LogonGetCapabilities_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_LogonGetCapabilities_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_LogonGetCapabilities_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_LogonGetCapabilities_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_LogonGetCapabilities *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_LOGONGETCAPABILITIES, mem_ctx, r);

	return status;
}

struct dcerpc_netr_LogonGetCapabilities_state {
	struct netr_LogonGetCapabilities orig;
	struct netr_LogonGetCapabilities tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_LogonGetCapabilities_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_LogonGetCapabilities_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 const char *_server_name /* [in] [charset(UTF16),ref] */,
							 const char *_computer_name /* [in] [charset(UTF16),unique] */,
							 struct netr_Authenticator *_credential /* [in] [ref] */,
							 struct netr_Authenticator *_return_authenticator /* [in,out] [ref] */,
							 uint32_t _query_level /* [in]  */,
							 union netr_Capabilities *_capabilities /* [out] [ref,switch_is(query_level)] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_LogonGetCapabilities_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_LogonGetCapabilities_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.computer_name = _computer_name;
	state->orig.in.credential = _credential;
	state->orig.in.return_authenticator = _return_authenticator;
	state->orig.in.query_level = _query_level;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;
	state->orig.out.capabilities = _capabilities;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_LogonGetCapabilities_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_LogonGetCapabilities_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_LogonGetCapabilities_done, req);
	return req;
}

static void dcerpc_netr_LogonGetCapabilities_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_LogonGetCapabilities_state *state = tevent_req_data(
		req, struct dcerpc_netr_LogonGetCapabilities_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_LogonGetCapabilities_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;
	*state->orig.out.capabilities = *state->tmp.out.capabilities;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_LogonGetCapabilities_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       NTSTATUS *result)
{
	struct dcerpc_netr_LogonGetCapabilities_state *state = tevent_req_data(
		req, struct dcerpc_netr_LogonGetCapabilities_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_LogonGetCapabilities(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  const char *_server_name /* [in] [charset(UTF16),ref] */,
					  const char *_computer_name /* [in] [charset(UTF16),unique] */,
					  struct netr_Authenticator *_credential /* [in] [ref] */,
					  struct netr_Authenticator *_return_authenticator /* [in,out] [ref] */,
					  uint32_t _query_level /* [in]  */,
					  union netr_Capabilities *_capabilities /* [out] [ref,switch_is(query_level)] */,
					  NTSTATUS *result)
{
	struct netr_LogonGetCapabilities r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.computer_name = _computer_name;
	r.in.credential = _credential;
	r.in.return_authenticator = _return_authenticator;
	r.in.query_level = _query_level;

	/* Out parameters */
	r.out.return_authenticator = _return_authenticator;
	r.out.capabilities = _capabilities;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_LogonGetCapabilities_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_return_authenticator = *r.out.return_authenticator;
	*_capabilities = *r.out.capabilities;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_LogonGetTrustRid_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_LogonGetTrustRid_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_LogonGetTrustRid_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_LogonGetTrustRid *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_LogonGetTrustRid_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_LogonGetTrustRid_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_LOGONGETTRUSTRID, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_LogonGetTrustRid_r_done, req);

	return req;
}

static void dcerpc_netr_LogonGetTrustRid_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_LogonGetTrustRid_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_LogonGetTrustRid_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_LogonGetTrustRid_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_LogonGetTrustRid_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_LogonGetTrustRid *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_LOGONGETTRUSTRID, mem_ctx, r);

	return status;
}

struct dcerpc_netr_LogonGetTrustRid_state {
	struct netr_LogonGetTrustRid orig;
	struct netr_LogonGetTrustRid tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_LogonGetTrustRid_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_LogonGetTrustRid_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     const char *_server_name /* [in] [charset(UTF16),unique] */,
						     const char *_domain_name /* [in] [charset(UTF16),unique] */,
						     uint32_t *_rid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_LogonGetTrustRid_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_LogonGetTrustRid_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.domain_name = _domain_name;

	/* Out parameters */
	state->orig.out.rid = _rid;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_LogonGetTrustRid_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_LogonGetTrustRid_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_LogonGetTrustRid_done, req);
	return req;
}

static void dcerpc_netr_LogonGetTrustRid_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_LogonGetTrustRid_state *state = tevent_req_data(
		req, struct dcerpc_netr_LogonGetTrustRid_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_LogonGetTrustRid_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rid = *state->tmp.out.rid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_LogonGetTrustRid_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_netr_LogonGetTrustRid_state *state = tevent_req_data(
		req, struct dcerpc_netr_LogonGetTrustRid_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_LogonGetTrustRid(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      const char *_server_name /* [in] [charset(UTF16),unique] */,
				      const char *_domain_name /* [in] [charset(UTF16),unique] */,
				      uint32_t *_rid /* [out] [ref] */,
				      WERROR *result)
{
	struct netr_LogonGetTrustRid r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.domain_name = _domain_name;

	/* Out parameters */
	r.out.rid = _rid;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_LogonGetTrustRid_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rid = *r.out.rid;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_ServerAuthenticate3_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_ServerAuthenticate3_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_ServerAuthenticate3_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_ServerAuthenticate3 *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_ServerAuthenticate3_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_ServerAuthenticate3_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_SERVERAUTHENTICATE3, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_ServerAuthenticate3_r_done, req);

	return req;
}

static void dcerpc_netr_ServerAuthenticate3_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_ServerAuthenticate3_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_ServerAuthenticate3_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_ServerAuthenticate3_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_ServerAuthenticate3_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_ServerAuthenticate3 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_SERVERAUTHENTICATE3, mem_ctx, r);

	return status;
}

struct dcerpc_netr_ServerAuthenticate3_state {
	struct netr_ServerAuthenticate3 orig;
	struct netr_ServerAuthenticate3 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_ServerAuthenticate3_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_ServerAuthenticate3_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							const char *_server_name /* [in] [charset(UTF16),unique] */,
							const char *_account_name /* [in] [charset(UTF16),ref] */,
							enum netr_SchannelType _secure_channel_type /* [in]  */,
							const char *_computer_name /* [in] [charset(UTF16),ref] */,
							struct netr_Credential *_credentials /* [in] [ref] */,
							struct netr_Credential *_return_credentials /* [out] [ref] */,
							uint32_t *_negotiate_flags /* [in,out] [ref] */,
							uint32_t *_rid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_ServerAuthenticate3_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_ServerAuthenticate3_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.account_name = _account_name;
	state->orig.in.secure_channel_type = _secure_channel_type;
	state->orig.in.computer_name = _computer_name;
	state->orig.in.credentials = _credentials;
	state->orig.in.negotiate_flags = _negotiate_flags;

	/* Out parameters */
	state->orig.out.return_credentials = _return_credentials;
	state->orig.out.negotiate_flags = _negotiate_flags;
	state->orig.out.rid = _rid;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_ServerAuthenticate3_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_ServerAuthenticate3_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_ServerAuthenticate3_done, req);
	return req;
}

static void dcerpc_netr_ServerAuthenticate3_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_ServerAuthenticate3_state *state = tevent_req_data(
		req, struct dcerpc_netr_ServerAuthenticate3_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_ServerAuthenticate3_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_credentials = *state->tmp.out.return_credentials;
	*state->orig.out.negotiate_flags = *state->tmp.out.negotiate_flags;
	*state->orig.out.rid = *state->tmp.out.rid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_ServerAuthenticate3_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      NTSTATUS *result)
{
	struct dcerpc_netr_ServerAuthenticate3_state *state = tevent_req_data(
		req, struct dcerpc_netr_ServerAuthenticate3_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_ServerAuthenticate3(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 const char *_server_name /* [in] [charset(UTF16),unique] */,
					 const char *_account_name /* [in] [charset(UTF16),ref] */,
					 enum netr_SchannelType _secure_channel_type /* [in]  */,
					 const char *_computer_name /* [in] [charset(UTF16),ref] */,
					 struct netr_Credential *_credentials /* [in] [ref] */,
					 struct netr_Credential *_return_credentials /* [out] [ref] */,
					 uint32_t *_negotiate_flags /* [in,out] [ref] */,
					 uint32_t *_rid /* [out] [ref] */,
					 NTSTATUS *result)
{
	struct netr_ServerAuthenticate3 r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.account_name = _account_name;
	r.in.secure_channel_type = _secure_channel_type;
	r.in.computer_name = _computer_name;
	r.in.credentials = _credentials;
	r.in.negotiate_flags = _negotiate_flags;

	/* Out parameters */
	r.out.return_credentials = _return_credentials;
	r.out.negotiate_flags = _negotiate_flags;
	r.out.rid = _rid;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_ServerAuthenticate3_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_return_credentials = *r.out.return_credentials;
	*_negotiate_flags = *r.out.negotiate_flags;
	*_rid = *r.out.rid;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_DsRGetDCNameEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_DsRGetDCNameEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_DsRGetDCNameEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_DsRGetDCNameEx *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_DsRGetDCNameEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_DsRGetDCNameEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_DSRGETDCNAMEEX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_DsRGetDCNameEx_r_done, req);

	return req;
}

static void dcerpc_netr_DsRGetDCNameEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_DsRGetDCNameEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_DsRGetDCNameEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_DsRGetDCNameEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_DsRGetDCNameEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_DsRGetDCNameEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_DSRGETDCNAMEEX, mem_ctx, r);

	return status;
}

struct dcerpc_netr_DsRGetDCNameEx_state {
	struct netr_DsRGetDCNameEx orig;
	struct netr_DsRGetDCNameEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_DsRGetDCNameEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_DsRGetDCNameEx_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   const char *_server_unc /* [in] [charset(UTF16),unique] */,
						   const char *_domain_name /* [in] [charset(UTF16),unique] */,
						   struct GUID *_domain_guid /* [in] [unique] */,
						   const char *_site_name /* [in] [charset(UTF16),unique] */,
						   uint32_t _flags /* [in]  */,
						   struct netr_DsRGetDCNameInfo **_info /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_DsRGetDCNameEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_DsRGetDCNameEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.domain_name = _domain_name;
	state->orig.in.domain_guid = _domain_guid;
	state->orig.in.site_name = _site_name;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_DsRGetDCNameEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_DsRGetDCNameEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_DsRGetDCNameEx_done, req);
	return req;
}

static void dcerpc_netr_DsRGetDCNameEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_DsRGetDCNameEx_state *state = tevent_req_data(
		req, struct dcerpc_netr_DsRGetDCNameEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_DsRGetDCNameEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_DsRGetDCNameEx_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result)
{
	struct dcerpc_netr_DsRGetDCNameEx_state *state = tevent_req_data(
		req, struct dcerpc_netr_DsRGetDCNameEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_DsRGetDCNameEx(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    const char *_server_unc /* [in] [charset(UTF16),unique] */,
				    const char *_domain_name /* [in] [charset(UTF16),unique] */,
				    struct GUID *_domain_guid /* [in] [unique] */,
				    const char *_site_name /* [in] [charset(UTF16),unique] */,
				    uint32_t _flags /* [in]  */,
				    struct netr_DsRGetDCNameInfo **_info /* [out] [ref] */,
				    WERROR *result)
{
	struct netr_DsRGetDCNameEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.domain_name = _domain_name;
	r.in.domain_guid = _domain_guid;
	r.in.site_name = _site_name;
	r.in.flags = _flags;

	/* Out parameters */
	r.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_DsRGetDCNameEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_DsRGetSiteName_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_DsRGetSiteName_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_DsRGetSiteName_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_DsRGetSiteName *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_DsRGetSiteName_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_DsRGetSiteName_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_DSRGETSITENAME, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_DsRGetSiteName_r_done, req);

	return req;
}

static void dcerpc_netr_DsRGetSiteName_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_DsRGetSiteName_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_DsRGetSiteName_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_DsRGetSiteName_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_DsRGetSiteName_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_DsRGetSiteName *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_DSRGETSITENAME, mem_ctx, r);

	return status;
}

struct dcerpc_netr_DsRGetSiteName_state {
	struct netr_DsRGetSiteName orig;
	struct netr_DsRGetSiteName tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_DsRGetSiteName_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_DsRGetSiteName_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   const char *_computer_name /* [in] [charset(UTF16),unique] */,
						   const char **_site /* [out] [charset(UTF16),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_DsRGetSiteName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_DsRGetSiteName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.computer_name = _computer_name;

	/* Out parameters */
	state->orig.out.site = _site;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_DsRGetSiteName_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_DsRGetSiteName_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_DsRGetSiteName_done, req);
	return req;
}

static void dcerpc_netr_DsRGetSiteName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_DsRGetSiteName_state *state = tevent_req_data(
		req, struct dcerpc_netr_DsRGetSiteName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_DsRGetSiteName_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.site = *state->tmp.out.site;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_DsRGetSiteName_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result)
{
	struct dcerpc_netr_DsRGetSiteName_state *state = tevent_req_data(
		req, struct dcerpc_netr_DsRGetSiteName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_DsRGetSiteName(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    const char *_computer_name /* [in] [charset(UTF16),unique] */,
				    const char **_site /* [out] [charset(UTF16),ref] */,
				    WERROR *result)
{
	struct netr_DsRGetSiteName r;
	NTSTATUS status;

	/* In parameters */
	r.in.computer_name = _computer_name;

	/* Out parameters */
	r.out.site = _site;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_DsRGetSiteName_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_site = *r.out.site;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_LogonGetDomainInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_LogonGetDomainInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_LogonGetDomainInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_LogonGetDomainInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_LogonGetDomainInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_LogonGetDomainInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_LOGONGETDOMAININFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_LogonGetDomainInfo_r_done, req);

	return req;
}

static void dcerpc_netr_LogonGetDomainInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_LogonGetDomainInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_LogonGetDomainInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_LogonGetDomainInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_LogonGetDomainInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_LogonGetDomainInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_LOGONGETDOMAININFO, mem_ctx, r);

	return status;
}

struct dcerpc_netr_LogonGetDomainInfo_state {
	struct netr_LogonGetDomainInfo orig;
	struct netr_LogonGetDomainInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_LogonGetDomainInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_LogonGetDomainInfo_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       const char *_server_name /* [in] [charset(UTF16),ref] */,
						       const char *_computer_name /* [in] [charset(UTF16),unique] */,
						       struct netr_Authenticator *_credential /* [in] [ref] */,
						       struct netr_Authenticator *_return_authenticator /* [in,out] [ref] */,
						       uint32_t _level /* [in]  */,
						       union netr_WorkstationInfo *_query /* [in] [ref,switch_is(level)] */,
						       union netr_DomainInfo *_info /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_LogonGetDomainInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_LogonGetDomainInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.computer_name = _computer_name;
	state->orig.in.credential = _credential;
	state->orig.in.return_authenticator = _return_authenticator;
	state->orig.in.level = _level;
	state->orig.in.query = _query;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;
	state->orig.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_LogonGetDomainInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_LogonGetDomainInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_LogonGetDomainInfo_done, req);
	return req;
}

static void dcerpc_netr_LogonGetDomainInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_LogonGetDomainInfo_state *state = tevent_req_data(
		req, struct dcerpc_netr_LogonGetDomainInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_LogonGetDomainInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_LogonGetDomainInfo_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result)
{
	struct dcerpc_netr_LogonGetDomainInfo_state *state = tevent_req_data(
		req, struct dcerpc_netr_LogonGetDomainInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_LogonGetDomainInfo(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					const char *_server_name /* [in] [charset(UTF16),ref] */,
					const char *_computer_name /* [in] [charset(UTF16),unique] */,
					struct netr_Authenticator *_credential /* [in] [ref] */,
					struct netr_Authenticator *_return_authenticator /* [in,out] [ref] */,
					uint32_t _level /* [in]  */,
					union netr_WorkstationInfo *_query /* [in] [ref,switch_is(level)] */,
					union netr_DomainInfo *_info /* [out] [ref,switch_is(level)] */,
					NTSTATUS *result)
{
	struct netr_LogonGetDomainInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.computer_name = _computer_name;
	r.in.credential = _credential;
	r.in.return_authenticator = _return_authenticator;
	r.in.level = _level;
	r.in.query = _query;

	/* Out parameters */
	r.out.return_authenticator = _return_authenticator;
	r.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_LogonGetDomainInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_return_authenticator = *r.out.return_authenticator;
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_ServerPasswordSet2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_ServerPasswordSet2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_ServerPasswordSet2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_ServerPasswordSet2 *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_ServerPasswordSet2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_ServerPasswordSet2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_SERVERPASSWORDSET2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_ServerPasswordSet2_r_done, req);

	return req;
}

static void dcerpc_netr_ServerPasswordSet2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_ServerPasswordSet2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_ServerPasswordSet2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_ServerPasswordSet2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_ServerPasswordSet2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_ServerPasswordSet2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_SERVERPASSWORDSET2, mem_ctx, r);

	return status;
}

struct dcerpc_netr_ServerPasswordSet2_state {
	struct netr_ServerPasswordSet2 orig;
	struct netr_ServerPasswordSet2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_ServerPasswordSet2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_ServerPasswordSet2_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       const char *_server_name /* [in] [charset(UTF16),unique] */,
						       const char *_account_name /* [in] [charset(UTF16),ref] */,
						       enum netr_SchannelType _secure_channel_type /* [in]  */,
						       const char *_computer_name /* [in] [charset(UTF16),ref] */,
						       struct netr_Authenticator *_credential /* [in] [ref] */,
						       struct netr_Authenticator *_return_authenticator /* [out] [ref] */,
						       struct netr_CryptPassword *_new_password /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_ServerPasswordSet2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_ServerPasswordSet2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.account_name = _account_name;
	state->orig.in.secure_channel_type = _secure_channel_type;
	state->orig.in.computer_name = _computer_name;
	state->orig.in.credential = _credential;
	state->orig.in.new_password = _new_password;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_ServerPasswordSet2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_ServerPasswordSet2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_ServerPasswordSet2_done, req);
	return req;
}

static void dcerpc_netr_ServerPasswordSet2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_ServerPasswordSet2_state *state = tevent_req_data(
		req, struct dcerpc_netr_ServerPasswordSet2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_ServerPasswordSet2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_ServerPasswordSet2_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result)
{
	struct dcerpc_netr_ServerPasswordSet2_state *state = tevent_req_data(
		req, struct dcerpc_netr_ServerPasswordSet2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_ServerPasswordSet2(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					const char *_server_name /* [in] [charset(UTF16),unique] */,
					const char *_account_name /* [in] [charset(UTF16),ref] */,
					enum netr_SchannelType _secure_channel_type /* [in]  */,
					const char *_computer_name /* [in] [charset(UTF16),ref] */,
					struct netr_Authenticator *_credential /* [in] [ref] */,
					struct netr_Authenticator *_return_authenticator /* [out] [ref] */,
					struct netr_CryptPassword *_new_password /* [in] [ref] */,
					NTSTATUS *result)
{
	struct netr_ServerPasswordSet2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.account_name = _account_name;
	r.in.secure_channel_type = _secure_channel_type;
	r.in.computer_name = _computer_name;
	r.in.credential = _credential;
	r.in.new_password = _new_password;

	/* Out parameters */
	r.out.return_authenticator = _return_authenticator;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_ServerPasswordSet2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_return_authenticator = *r.out.return_authenticator;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_ServerPasswordGet_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_ServerPasswordGet_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_ServerPasswordGet_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_ServerPasswordGet *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_ServerPasswordGet_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_ServerPasswordGet_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_SERVERPASSWORDGET, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_ServerPasswordGet_r_done, req);

	return req;
}

static void dcerpc_netr_ServerPasswordGet_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_ServerPasswordGet_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_ServerPasswordGet_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_ServerPasswordGet_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_ServerPasswordGet_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_ServerPasswordGet *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_SERVERPASSWORDGET, mem_ctx, r);

	return status;
}

struct dcerpc_netr_ServerPasswordGet_state {
	struct netr_ServerPasswordGet orig;
	struct netr_ServerPasswordGet tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_ServerPasswordGet_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_ServerPasswordGet_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      const char *_server_name /* [in] [charset(UTF16),unique] */,
						      const char *_account_name /* [in] [charset(UTF16),ref] */,
						      enum netr_SchannelType _secure_channel_type /* [in]  */,
						      const char *_computer_name /* [in] [charset(UTF16),ref] */,
						      struct netr_Authenticator *_credential /* [in] [ref] */,
						      struct netr_Authenticator *_return_authenticator /* [out] [ref] */,
						      struct samr_Password *_password /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_ServerPasswordGet_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_ServerPasswordGet_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.account_name = _account_name;
	state->orig.in.secure_channel_type = _secure_channel_type;
	state->orig.in.computer_name = _computer_name;
	state->orig.in.credential = _credential;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;
	state->orig.out.password = _password;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_ServerPasswordGet_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_ServerPasswordGet_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_ServerPasswordGet_done, req);
	return req;
}

static void dcerpc_netr_ServerPasswordGet_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_ServerPasswordGet_state *state = tevent_req_data(
		req, struct dcerpc_netr_ServerPasswordGet_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_ServerPasswordGet_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;
	*state->orig.out.password = *state->tmp.out.password;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_ServerPasswordGet_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    NTSTATUS *result)
{
	struct dcerpc_netr_ServerPasswordGet_state *state = tevent_req_data(
		req, struct dcerpc_netr_ServerPasswordGet_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_ServerPasswordGet(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       const char *_server_name /* [in] [charset(UTF16),unique] */,
				       const char *_account_name /* [in] [charset(UTF16),ref] */,
				       enum netr_SchannelType _secure_channel_type /* [in]  */,
				       const char *_computer_name /* [in] [charset(UTF16),ref] */,
				       struct netr_Authenticator *_credential /* [in] [ref] */,
				       struct netr_Authenticator *_return_authenticator /* [out] [ref] */,
				       struct samr_Password *_password /* [out] [ref] */,
				       NTSTATUS *result)
{
	struct netr_ServerPasswordGet r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.account_name = _account_name;
	r.in.secure_channel_type = _secure_channel_type;
	r.in.computer_name = _computer_name;
	r.in.credential = _credential;

	/* Out parameters */
	r.out.return_authenticator = _return_authenticator;
	r.out.password = _password;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_ServerPasswordGet_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_return_authenticator = *r.out.return_authenticator;
	*_password = *r.out.password;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_NetrLogonSendToSam_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_NetrLogonSendToSam_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_NetrLogonSendToSam_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_NetrLogonSendToSam *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_NetrLogonSendToSam_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_NetrLogonSendToSam_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_NETRLOGONSENDTOSAM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_NetrLogonSendToSam_r_done, req);

	return req;
}

static void dcerpc_netr_NetrLogonSendToSam_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_NetrLogonSendToSam_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_NetrLogonSendToSam_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_NetrLogonSendToSam_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_NetrLogonSendToSam_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_NetrLogonSendToSam *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_NETRLOGONSENDTOSAM, mem_ctx, r);

	return status;
}

struct dcerpc_netr_NetrLogonSendToSam_state {
	struct netr_NetrLogonSendToSam orig;
	struct netr_NetrLogonSendToSam tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_NetrLogonSendToSam_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_NetrLogonSendToSam_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       const char *_server_name /* [in] [charset(UTF16),unique] */,
						       const char *_computer_name /* [in] [charset(UTF16),ref] */,
						       struct netr_Authenticator *_credential /* [in] [ref] */,
						       struct netr_Authenticator *_return_authenticator /* [out] [ref] */,
						       uint8_t *_opaque_buffer /* [in] [flag(LIBNDR_FLAG_IS_SECRET),ref,size_is(buffer_len)] */,
						       uint32_t _buffer_len /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_netr_NetrLogonSendToSam_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_NetrLogonSendToSam_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.computer_name = _computer_name;
	state->orig.in.credential = _credential;
	state->orig.in.opaque_buffer = _opaque_buffer;
	state->orig.in.buffer_len = _buffer_len;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_NetrLogonSendToSam_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_NetrLogonSendToSam_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_NetrLogonSendToSam_done, req);
	return req;
}

static void dcerpc_netr_NetrLogonSendToSam_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_NetrLogonSendToSam_state *state = tevent_req_data(
		req, struct dcerpc_netr_NetrLogonSendToSam_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_NetrLogonSendToSam_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_NetrLogonSendToSam_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result)
{
	struct dcerpc_netr_NetrLogonSendToSam_state *state = tevent_req_data(
		req, struct dcerpc_netr_NetrLogonSendToSam_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_NetrLogonSendToSam(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					const char *_server_name /* [in] [charset(UTF16),unique] */,
					const char *_computer_name /* [in] [charset(UTF16),ref] */,
					struct netr_Authenticator *_credential /* [in] [ref] */,
					struct netr_Authenticator *_return_authenticator /* [out] [ref] */,
					uint8_t *_opaque_buffer /* [in] [flag(LIBNDR_FLAG_IS_SECRET),ref,size_is(buffer_len)] */,
					uint32_t _buffer_len /* [in]  */,
					NTSTATUS *result)
{
	struct netr_NetrLogonSendToSam r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.computer_name = _computer_name;
	r.in.credential = _credential;
	r.in.opaque_buffer = _opaque_buffer;
	r.in.buffer_len = _buffer_len;

	/* Out parameters */
	r.out.return_authenticator = _return_authenticator;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_NetrLogonSendToSam_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_return_authenticator = *r.out.return_authenticator;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_DsRAddressToSitenamesW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_DsRAddressToSitenamesW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_DsRAddressToSitenamesW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_DsRAddressToSitenamesW *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_DsRAddressToSitenamesW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_DsRAddressToSitenamesW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_DSRADDRESSTOSITENAMESW, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_DsRAddressToSitenamesW_r_done, req);

	return req;
}

static void dcerpc_netr_DsRAddressToSitenamesW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_DsRAddressToSitenamesW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_DsRAddressToSitenamesW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_DsRAddressToSitenamesW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_DsRAddressToSitenamesW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_DsRAddressToSitenamesW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_DSRADDRESSTOSITENAMESW, mem_ctx, r);

	return status;
}

struct dcerpc_netr_DsRAddressToSitenamesW_state {
	struct netr_DsRAddressToSitenamesW orig;
	struct netr_DsRAddressToSitenamesW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_DsRAddressToSitenamesW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_DsRAddressToSitenamesW_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct dcerpc_binding_handle *h,
							   const char *_server_name /* [in] [charset(UTF16),unique] */,
							   uint32_t _count /* [in] [range(0,32000)] */,
							   struct netr_DsRAddress *_addresses /* [in] [ref,size_is(count)] */,
							   struct netr_DsRAddressToSitenamesWCtr **_ctr /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_DsRAddressToSitenamesW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_DsRAddressToSitenamesW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.count = _count;
	state->orig.in.addresses = _addresses;

	/* Out parameters */
	state->orig.out.ctr = _ctr;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_DsRAddressToSitenamesW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_DsRAddressToSitenamesW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_DsRAddressToSitenamesW_done, req);
	return req;
}

static void dcerpc_netr_DsRAddressToSitenamesW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_DsRAddressToSitenamesW_state *state = tevent_req_data(
		req, struct dcerpc_netr_DsRAddressToSitenamesW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_DsRAddressToSitenamesW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ctr = *state->tmp.out.ctr;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_DsRAddressToSitenamesW_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result)
{
	struct dcerpc_netr_DsRAddressToSitenamesW_state *state = tevent_req_data(
		req, struct dcerpc_netr_DsRAddressToSitenamesW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_DsRAddressToSitenamesW(struct dcerpc_binding_handle *h,
					    TALLOC_CTX *mem_ctx,
					    const char *_server_name /* [in] [charset(UTF16),unique] */,
					    uint32_t _count /* [in] [range(0,32000)] */,
					    struct netr_DsRAddress *_addresses /* [in] [ref,size_is(count)] */,
					    struct netr_DsRAddressToSitenamesWCtr **_ctr /* [out] [ref] */,
					    WERROR *result)
{
	struct netr_DsRAddressToSitenamesW r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.count = _count;
	r.in.addresses = _addresses;

	/* Out parameters */
	r.out.ctr = _ctr;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_DsRAddressToSitenamesW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ctr = *r.out.ctr;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_DsRGetDCNameEx2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_DsRGetDCNameEx2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_DsRGetDCNameEx2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_DsRGetDCNameEx2 *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_DsRGetDCNameEx2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_DsRGetDCNameEx2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_DSRGETDCNAMEEX2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_DsRGetDCNameEx2_r_done, req);

	return req;
}

static void dcerpc_netr_DsRGetDCNameEx2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_DsRGetDCNameEx2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_DsRGetDCNameEx2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_DsRGetDCNameEx2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_DsRGetDCNameEx2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_DsRGetDCNameEx2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_DSRGETDCNAMEEX2, mem_ctx, r);

	return status;
}

struct dcerpc_netr_DsRGetDCNameEx2_state {
	struct netr_DsRGetDCNameEx2 orig;
	struct netr_DsRGetDCNameEx2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_DsRGetDCNameEx2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_DsRGetDCNameEx2_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    const char *_server_unc /* [in] [charset(UTF16),unique] */,
						    const char *_client_account /* [in] [charset(UTF16),unique] */,
						    uint32_t _mask /* [in]  */,
						    const char *_domain_name /* [in] [charset(UTF16),unique] */,
						    struct GUID *_domain_guid /* [in] [unique] */,
						    const char *_site_name /* [in] [charset(UTF16),unique] */,
						    uint32_t _flags /* [in]  */,
						    struct netr_DsRGetDCNameInfo **_info /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_DsRGetDCNameEx2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_DsRGetDCNameEx2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.client_account = _client_account;
	state->orig.in.mask = _mask;
	state->orig.in.domain_name = _domain_name;
	state->orig.in.domain_guid = _domain_guid;
	state->orig.in.site_name = _site_name;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_DsRGetDCNameEx2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_DsRGetDCNameEx2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_DsRGetDCNameEx2_done, req);
	return req;
}

static void dcerpc_netr_DsRGetDCNameEx2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_DsRGetDCNameEx2_state *state = tevent_req_data(
		req, struct dcerpc_netr_DsRGetDCNameEx2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_DsRGetDCNameEx2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_DsRGetDCNameEx2_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_netr_DsRGetDCNameEx2_state *state = tevent_req_data(
		req, struct dcerpc_netr_DsRGetDCNameEx2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_DsRGetDCNameEx2(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     const char *_server_unc /* [in] [charset(UTF16),unique] */,
				     const char *_client_account /* [in] [charset(UTF16),unique] */,
				     uint32_t _mask /* [in]  */,
				     const char *_domain_name /* [in] [charset(UTF16),unique] */,
				     struct GUID *_domain_guid /* [in] [unique] */,
				     const char *_site_name /* [in] [charset(UTF16),unique] */,
				     uint32_t _flags /* [in]  */,
				     struct netr_DsRGetDCNameInfo **_info /* [out] [ref] */,
				     WERROR *result)
{
	struct netr_DsRGetDCNameEx2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.client_account = _client_account;
	r.in.mask = _mask;
	r.in.domain_name = _domain_name;
	r.in.domain_guid = _domain_guid;
	r.in.site_name = _site_name;
	r.in.flags = _flags;

	/* Out parameters */
	r.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_DsRGetDCNameEx2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_NetrEnumerateTrustedDomainsEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_NetrEnumerateTrustedDomainsEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_NetrEnumerateTrustedDomainsEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_NetrEnumerateTrustedDomainsEx *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_NetrEnumerateTrustedDomainsEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_NetrEnumerateTrustedDomainsEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_NETRENUMERATETRUSTEDDOMAINSEX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_NetrEnumerateTrustedDomainsEx_r_done, req);

	return req;
}

static void dcerpc_netr_NetrEnumerateTrustedDomainsEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_NetrEnumerateTrustedDomainsEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_NetrEnumerateTrustedDomainsEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_NetrEnumerateTrustedDomainsEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_NetrEnumerateTrustedDomainsEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_NetrEnumerateTrustedDomainsEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_NETRENUMERATETRUSTEDDOMAINSEX, mem_ctx, r);

	return status;
}

struct dcerpc_netr_NetrEnumerateTrustedDomainsEx_state {
	struct netr_NetrEnumerateTrustedDomainsEx orig;
	struct netr_NetrEnumerateTrustedDomainsEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_NetrEnumerateTrustedDomainsEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_NetrEnumerateTrustedDomainsEx_send(TALLOC_CTX *mem_ctx,
								  struct tevent_context *ev,
								  struct dcerpc_binding_handle *h,
								  const char *_server_name /* [in] [charset(UTF16),unique] */,
								  struct netr_DomainTrustList *_dom_trust_list /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_NetrEnumerateTrustedDomainsEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_NetrEnumerateTrustedDomainsEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;

	/* Out parameters */
	state->orig.out.dom_trust_list = _dom_trust_list;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_NetrEnumerateTrustedDomainsEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_NetrEnumerateTrustedDomainsEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_NetrEnumerateTrustedDomainsEx_done, req);
	return req;
}

static void dcerpc_netr_NetrEnumerateTrustedDomainsEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_NetrEnumerateTrustedDomainsEx_state *state = tevent_req_data(
		req, struct dcerpc_netr_NetrEnumerateTrustedDomainsEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_NetrEnumerateTrustedDomainsEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.dom_trust_list = *state->tmp.out.dom_trust_list;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_NetrEnumerateTrustedDomainsEx_recv(struct tevent_req *req,
							TALLOC_CTX *mem_ctx,
							WERROR *result)
{
	struct dcerpc_netr_NetrEnumerateTrustedDomainsEx_state *state = tevent_req_data(
		req, struct dcerpc_netr_NetrEnumerateTrustedDomainsEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_NetrEnumerateTrustedDomainsEx(struct dcerpc_binding_handle *h,
						   TALLOC_CTX *mem_ctx,
						   const char *_server_name /* [in] [charset(UTF16),unique] */,
						   struct netr_DomainTrustList *_dom_trust_list /* [out] [ref] */,
						   WERROR *result)
{
	struct netr_NetrEnumerateTrustedDomainsEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;

	/* Out parameters */
	r.out.dom_trust_list = _dom_trust_list;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_NetrEnumerateTrustedDomainsEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_dom_trust_list = *r.out.dom_trust_list;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_DsRAddressToSitenamesExW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_DsRAddressToSitenamesExW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_DsRAddressToSitenamesExW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_DsRAddressToSitenamesExW *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_DsRAddressToSitenamesExW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_DsRAddressToSitenamesExW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_DSRADDRESSTOSITENAMESEXW, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_DsRAddressToSitenamesExW_r_done, req);

	return req;
}

static void dcerpc_netr_DsRAddressToSitenamesExW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_DsRAddressToSitenamesExW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_DsRAddressToSitenamesExW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_DsRAddressToSitenamesExW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_DsRAddressToSitenamesExW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_DsRAddressToSitenamesExW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_DSRADDRESSTOSITENAMESEXW, mem_ctx, r);

	return status;
}

struct dcerpc_netr_DsRAddressToSitenamesExW_state {
	struct netr_DsRAddressToSitenamesExW orig;
	struct netr_DsRAddressToSitenamesExW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_DsRAddressToSitenamesExW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_DsRAddressToSitenamesExW_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct dcerpc_binding_handle *h,
							     const char *_server_name /* [in] [charset(UTF16),unique] */,
							     uint32_t _count /* [in] [range(0,32000)] */,
							     struct netr_DsRAddress *_addresses /* [in] [ref,size_is(count)] */,
							     struct netr_DsRAddressToSitenamesExWCtr **_ctr /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_DsRAddressToSitenamesExW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_DsRAddressToSitenamesExW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.count = _count;
	state->orig.in.addresses = _addresses;

	/* Out parameters */
	state->orig.out.ctr = _ctr;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_DsRAddressToSitenamesExW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_DsRAddressToSitenamesExW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_DsRAddressToSitenamesExW_done, req);
	return req;
}

static void dcerpc_netr_DsRAddressToSitenamesExW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_DsRAddressToSitenamesExW_state *state = tevent_req_data(
		req, struct dcerpc_netr_DsRAddressToSitenamesExW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_DsRAddressToSitenamesExW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ctr = *state->tmp.out.ctr;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_DsRAddressToSitenamesExW_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result)
{
	struct dcerpc_netr_DsRAddressToSitenamesExW_state *state = tevent_req_data(
		req, struct dcerpc_netr_DsRAddressToSitenamesExW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_DsRAddressToSitenamesExW(struct dcerpc_binding_handle *h,
					      TALLOC_CTX *mem_ctx,
					      const char *_server_name /* [in] [charset(UTF16),unique] */,
					      uint32_t _count /* [in] [range(0,32000)] */,
					      struct netr_DsRAddress *_addresses /* [in] [ref,size_is(count)] */,
					      struct netr_DsRAddressToSitenamesExWCtr **_ctr /* [out] [ref] */,
					      WERROR *result)
{
	struct netr_DsRAddressToSitenamesExW r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.count = _count;
	r.in.addresses = _addresses;

	/* Out parameters */
	r.out.ctr = _ctr;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_DsRAddressToSitenamesExW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ctr = *r.out.ctr;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_DsrGetDcSiteCoverageW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_DsrGetDcSiteCoverageW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_DsrGetDcSiteCoverageW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_DsrGetDcSiteCoverageW *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_DsrGetDcSiteCoverageW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_DsrGetDcSiteCoverageW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_DSRGETDCSITECOVERAGEW, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_DsrGetDcSiteCoverageW_r_done, req);

	return req;
}

static void dcerpc_netr_DsrGetDcSiteCoverageW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_DsrGetDcSiteCoverageW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_DsrGetDcSiteCoverageW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_DsrGetDcSiteCoverageW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_DsrGetDcSiteCoverageW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_DsrGetDcSiteCoverageW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_DSRGETDCSITECOVERAGEW, mem_ctx, r);

	return status;
}

struct dcerpc_netr_DsrGetDcSiteCoverageW_state {
	struct netr_DsrGetDcSiteCoverageW orig;
	struct netr_DsrGetDcSiteCoverageW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_DsrGetDcSiteCoverageW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_DsrGetDcSiteCoverageW_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  const char *_server_name /* [in] [charset(UTF16),unique] */,
							  struct DcSitesCtr **_ctr /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_DsrGetDcSiteCoverageW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_DsrGetDcSiteCoverageW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;

	/* Out parameters */
	state->orig.out.ctr = _ctr;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_DsrGetDcSiteCoverageW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_DsrGetDcSiteCoverageW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_DsrGetDcSiteCoverageW_done, req);
	return req;
}

static void dcerpc_netr_DsrGetDcSiteCoverageW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_DsrGetDcSiteCoverageW_state *state = tevent_req_data(
		req, struct dcerpc_netr_DsrGetDcSiteCoverageW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_DsrGetDcSiteCoverageW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ctr = *state->tmp.out.ctr;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_DsrGetDcSiteCoverageW_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_netr_DsrGetDcSiteCoverageW_state *state = tevent_req_data(
		req, struct dcerpc_netr_DsrGetDcSiteCoverageW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_DsrGetDcSiteCoverageW(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   const char *_server_name /* [in] [charset(UTF16),unique] */,
					   struct DcSitesCtr **_ctr /* [out] [ref] */,
					   WERROR *result)
{
	struct netr_DsrGetDcSiteCoverageW r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;

	/* Out parameters */
	r.out.ctr = _ctr;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_DsrGetDcSiteCoverageW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ctr = *r.out.ctr;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_LogonSamLogonEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_LogonSamLogonEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_LogonSamLogonEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_LogonSamLogonEx *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_LogonSamLogonEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_LogonSamLogonEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_LOGONSAMLOGONEX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_LogonSamLogonEx_r_done, req);

	return req;
}

static void dcerpc_netr_LogonSamLogonEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_LogonSamLogonEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_LogonSamLogonEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_LogonSamLogonEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_LogonSamLogonEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_LogonSamLogonEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_LOGONSAMLOGONEX, mem_ctx, r);

	return status;
}

struct dcerpc_netr_LogonSamLogonEx_state {
	struct netr_LogonSamLogonEx orig;
	struct netr_LogonSamLogonEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_LogonSamLogonEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_LogonSamLogonEx_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    const char *_server_name /* [in] [charset(UTF16),unique] */,
						    const char *_computer_name /* [in] [charset(UTF16),unique] */,
						    enum netr_LogonInfoClass _logon_level /* [in]  */,
						    union netr_LogonLevel *_logon /* [in] [ref,switch_is(logon_level)] */,
						    uint16_t _validation_level /* [in]  */,
						    union netr_Validation *_validation /* [out] [ref,switch_is(validation_level)] */,
						    uint8_t *_authoritative /* [out] [ref] */,
						    uint32_t *_flags /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_LogonSamLogonEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_LogonSamLogonEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.computer_name = _computer_name;
	state->orig.in.logon_level = _logon_level;
	state->orig.in.logon = _logon;
	state->orig.in.validation_level = _validation_level;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.validation = _validation;
	state->orig.out.authoritative = _authoritative;
	state->orig.out.flags = _flags;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_LogonSamLogonEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_LogonSamLogonEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_LogonSamLogonEx_done, req);
	return req;
}

static void dcerpc_netr_LogonSamLogonEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_LogonSamLogonEx_state *state = tevent_req_data(
		req, struct dcerpc_netr_LogonSamLogonEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_LogonSamLogonEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.validation = *state->tmp.out.validation;
	*state->orig.out.authoritative = *state->tmp.out.authoritative;
	*state->orig.out.flags = *state->tmp.out.flags;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_LogonSamLogonEx_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  NTSTATUS *result)
{
	struct dcerpc_netr_LogonSamLogonEx_state *state = tevent_req_data(
		req, struct dcerpc_netr_LogonSamLogonEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_LogonSamLogonEx(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     const char *_server_name /* [in] [charset(UTF16),unique] */,
				     const char *_computer_name /* [in] [charset(UTF16),unique] */,
				     enum netr_LogonInfoClass _logon_level /* [in]  */,
				     union netr_LogonLevel *_logon /* [in] [ref,switch_is(logon_level)] */,
				     uint16_t _validation_level /* [in]  */,
				     union netr_Validation *_validation /* [out] [ref,switch_is(validation_level)] */,
				     uint8_t *_authoritative /* [out] [ref] */,
				     uint32_t *_flags /* [in,out] [ref] */,
				     NTSTATUS *result)
{
	struct netr_LogonSamLogonEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.computer_name = _computer_name;
	r.in.logon_level = _logon_level;
	r.in.logon = _logon;
	r.in.validation_level = _validation_level;
	r.in.flags = _flags;

	/* Out parameters */
	r.out.validation = _validation;
	r.out.authoritative = _authoritative;
	r.out.flags = _flags;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_LogonSamLogonEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_validation = *r.out.validation;
	*_authoritative = *r.out.authoritative;
	*_flags = *r.out.flags;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_DsrEnumerateDomainTrusts_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_DsrEnumerateDomainTrusts_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_DsrEnumerateDomainTrusts_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_DsrEnumerateDomainTrusts *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_DsrEnumerateDomainTrusts_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_DsrEnumerateDomainTrusts_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_DSRENUMERATEDOMAINTRUSTS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_DsrEnumerateDomainTrusts_r_done, req);

	return req;
}

static void dcerpc_netr_DsrEnumerateDomainTrusts_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_DsrEnumerateDomainTrusts_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_DsrEnumerateDomainTrusts_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_DsrEnumerateDomainTrusts_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_DsrEnumerateDomainTrusts_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_DsrEnumerateDomainTrusts *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_DSRENUMERATEDOMAINTRUSTS, mem_ctx, r);

	return status;
}

struct dcerpc_netr_DsrEnumerateDomainTrusts_state {
	struct netr_DsrEnumerateDomainTrusts orig;
	struct netr_DsrEnumerateDomainTrusts tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_DsrEnumerateDomainTrusts_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_DsrEnumerateDomainTrusts_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct dcerpc_binding_handle *h,
							     const char *_server_name /* [in] [charset(UTF16),unique] */,
							     uint32_t _trust_flags /* [in]  */,
							     struct netr_DomainTrustList *_trusts /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_DsrEnumerateDomainTrusts_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_DsrEnumerateDomainTrusts_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.trust_flags = _trust_flags;

	/* Out parameters */
	state->orig.out.trusts = _trusts;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_DsrEnumerateDomainTrusts_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_DsrEnumerateDomainTrusts_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_DsrEnumerateDomainTrusts_done, req);
	return req;
}

static void dcerpc_netr_DsrEnumerateDomainTrusts_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_DsrEnumerateDomainTrusts_state *state = tevent_req_data(
		req, struct dcerpc_netr_DsrEnumerateDomainTrusts_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_DsrEnumerateDomainTrusts_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.trusts = *state->tmp.out.trusts;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_DsrEnumerateDomainTrusts_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result)
{
	struct dcerpc_netr_DsrEnumerateDomainTrusts_state *state = tevent_req_data(
		req, struct dcerpc_netr_DsrEnumerateDomainTrusts_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_DsrEnumerateDomainTrusts(struct dcerpc_binding_handle *h,
					      TALLOC_CTX *mem_ctx,
					      const char *_server_name /* [in] [charset(UTF16),unique] */,
					      uint32_t _trust_flags /* [in]  */,
					      struct netr_DomainTrustList *_trusts /* [out] [ref] */,
					      WERROR *result)
{
	struct netr_DsrEnumerateDomainTrusts r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.trust_flags = _trust_flags;

	/* Out parameters */
	r.out.trusts = _trusts;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_DsrEnumerateDomainTrusts_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_trusts = *r.out.trusts;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_DsrDeregisterDNSHostRecords_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_DsrDeregisterDNSHostRecords_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_DsrDeregisterDNSHostRecords_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_DsrDeregisterDNSHostRecords *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_DsrDeregisterDNSHostRecords_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_DsrDeregisterDNSHostRecords_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_DSRDEREGISTERDNSHOSTRECORDS, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_DsrDeregisterDNSHostRecords_r_done, req);

	return req;
}

static void dcerpc_netr_DsrDeregisterDNSHostRecords_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_DsrDeregisterDNSHostRecords_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_DsrDeregisterDNSHostRecords_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_DsrDeregisterDNSHostRecords_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_DsrDeregisterDNSHostRecords_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_DsrDeregisterDNSHostRecords *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_DSRDEREGISTERDNSHOSTRECORDS, mem_ctx, r);

	return status;
}

struct dcerpc_netr_DsrDeregisterDNSHostRecords_state {
	struct netr_DsrDeregisterDNSHostRecords orig;
	struct netr_DsrDeregisterDNSHostRecords tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_DsrDeregisterDNSHostRecords_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_DsrDeregisterDNSHostRecords_send(TALLOC_CTX *mem_ctx,
								struct tevent_context *ev,
								struct dcerpc_binding_handle *h,
								const char *_server_name /* [in] [charset(UTF16),unique] */,
								const char *_domain /* [in] [charset(UTF16),unique] */,
								struct GUID *_domain_guid /* [in] [unique] */,
								struct GUID *_dsa_guid /* [in] [unique] */,
								const char *_dns_host /* [in] [charset(UTF16),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_DsrDeregisterDNSHostRecords_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_DsrDeregisterDNSHostRecords_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.domain = _domain;
	state->orig.in.domain_guid = _domain_guid;
	state->orig.in.dsa_guid = _dsa_guid;
	state->orig.in.dns_host = _dns_host;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_DsrDeregisterDNSHostRecords_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_DsrDeregisterDNSHostRecords_done, req);
	return req;
}

static void dcerpc_netr_DsrDeregisterDNSHostRecords_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_DsrDeregisterDNSHostRecords_state *state = tevent_req_data(
		req, struct dcerpc_netr_DsrDeregisterDNSHostRecords_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_DsrDeregisterDNSHostRecords_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_DsrDeregisterDNSHostRecords_recv(struct tevent_req *req,
						      TALLOC_CTX *mem_ctx,
						      WERROR *result)
{
	struct dcerpc_netr_DsrDeregisterDNSHostRecords_state *state = tevent_req_data(
		req, struct dcerpc_netr_DsrDeregisterDNSHostRecords_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_DsrDeregisterDNSHostRecords(struct dcerpc_binding_handle *h,
						 TALLOC_CTX *mem_ctx,
						 const char *_server_name /* [in] [charset(UTF16),unique] */,
						 const char *_domain /* [in] [charset(UTF16),unique] */,
						 struct GUID *_domain_guid /* [in] [unique] */,
						 struct GUID *_dsa_guid /* [in] [unique] */,
						 const char *_dns_host /* [in] [charset(UTF16),ref] */,
						 WERROR *result)
{
	struct netr_DsrDeregisterDNSHostRecords r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.domain = _domain;
	r.in.domain_guid = _domain_guid;
	r.in.dsa_guid = _dsa_guid;
	r.in.dns_host = _dns_host;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_DsrDeregisterDNSHostRecords_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_ServerTrustPasswordsGet_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_ServerTrustPasswordsGet_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_ServerTrustPasswordsGet_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_ServerTrustPasswordsGet *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_ServerTrustPasswordsGet_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_ServerTrustPasswordsGet_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_SERVERTRUSTPASSWORDSGET, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_ServerTrustPasswordsGet_r_done, req);

	return req;
}

static void dcerpc_netr_ServerTrustPasswordsGet_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_ServerTrustPasswordsGet_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_ServerTrustPasswordsGet_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_ServerTrustPasswordsGet_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_ServerTrustPasswordsGet_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_ServerTrustPasswordsGet *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_SERVERTRUSTPASSWORDSGET, mem_ctx, r);

	return status;
}

struct dcerpc_netr_ServerTrustPasswordsGet_state {
	struct netr_ServerTrustPasswordsGet orig;
	struct netr_ServerTrustPasswordsGet tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_ServerTrustPasswordsGet_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_ServerTrustPasswordsGet_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct dcerpc_binding_handle *h,
							    const char *_server_name /* [in] [charset(UTF16),unique] */,
							    const char *_account_name /* [in] [charset(UTF16),ref] */,
							    enum netr_SchannelType _secure_channel_type /* [in]  */,
							    const char *_computer_name /* [in] [charset(UTF16),ref] */,
							    struct netr_Authenticator *_credential /* [in] [ref] */,
							    struct netr_Authenticator *_return_authenticator /* [out] [ref] */,
							    struct samr_Password *_new_owf_password /* [out] [ref] */,
							    struct samr_Password *_old_owf_password /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_ServerTrustPasswordsGet_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_ServerTrustPasswordsGet_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.account_name = _account_name;
	state->orig.in.secure_channel_type = _secure_channel_type;
	state->orig.in.computer_name = _computer_name;
	state->orig.in.credential = _credential;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;
	state->orig.out.new_owf_password = _new_owf_password;
	state->orig.out.old_owf_password = _old_owf_password;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_ServerTrustPasswordsGet_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_ServerTrustPasswordsGet_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_ServerTrustPasswordsGet_done, req);
	return req;
}

static void dcerpc_netr_ServerTrustPasswordsGet_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_ServerTrustPasswordsGet_state *state = tevent_req_data(
		req, struct dcerpc_netr_ServerTrustPasswordsGet_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_ServerTrustPasswordsGet_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;
	*state->orig.out.new_owf_password = *state->tmp.out.new_owf_password;
	*state->orig.out.old_owf_password = *state->tmp.out.old_owf_password;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_ServerTrustPasswordsGet_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  NTSTATUS *result)
{
	struct dcerpc_netr_ServerTrustPasswordsGet_state *state = tevent_req_data(
		req, struct dcerpc_netr_ServerTrustPasswordsGet_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_ServerTrustPasswordsGet(struct dcerpc_binding_handle *h,
					     TALLOC_CTX *mem_ctx,
					     const char *_server_name /* [in] [charset(UTF16),unique] */,
					     const char *_account_name /* [in] [charset(UTF16),ref] */,
					     enum netr_SchannelType _secure_channel_type /* [in]  */,
					     const char *_computer_name /* [in] [charset(UTF16),ref] */,
					     struct netr_Authenticator *_credential /* [in] [ref] */,
					     struct netr_Authenticator *_return_authenticator /* [out] [ref] */,
					     struct samr_Password *_new_owf_password /* [out] [ref] */,
					     struct samr_Password *_old_owf_password /* [out] [ref] */,
					     NTSTATUS *result)
{
	struct netr_ServerTrustPasswordsGet r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.account_name = _account_name;
	r.in.secure_channel_type = _secure_channel_type;
	r.in.computer_name = _computer_name;
	r.in.credential = _credential;

	/* Out parameters */
	r.out.return_authenticator = _return_authenticator;
	r.out.new_owf_password = _new_owf_password;
	r.out.old_owf_password = _old_owf_password;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_ServerTrustPasswordsGet_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_return_authenticator = *r.out.return_authenticator;
	*_new_owf_password = *r.out.new_owf_password;
	*_old_owf_password = *r.out.old_owf_password;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_DsRGetForestTrustInformation_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_DsRGetForestTrustInformation_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_DsRGetForestTrustInformation_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_DsRGetForestTrustInformation *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_DsRGetForestTrustInformation_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_DsRGetForestTrustInformation_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_DSRGETFORESTTRUSTINFORMATION, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_DsRGetForestTrustInformation_r_done, req);

	return req;
}

static void dcerpc_netr_DsRGetForestTrustInformation_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_DsRGetForestTrustInformation_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_DsRGetForestTrustInformation_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_DsRGetForestTrustInformation_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_DsRGetForestTrustInformation_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_DsRGetForestTrustInformation *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_DSRGETFORESTTRUSTINFORMATION, mem_ctx, r);

	return status;
}

struct dcerpc_netr_DsRGetForestTrustInformation_state {
	struct netr_DsRGetForestTrustInformation orig;
	struct netr_DsRGetForestTrustInformation tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_DsRGetForestTrustInformation_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_DsRGetForestTrustInformation_send(TALLOC_CTX *mem_ctx,
								 struct tevent_context *ev,
								 struct dcerpc_binding_handle *h,
								 const char *_server_name /* [in] [charset(UTF16),unique] */,
								 const char *_trusted_domain_name /* [in] [charset(UTF16),unique] */,
								 uint32_t _flags /* [in]  */,
								 struct lsa_ForestTrustInformation **_forest_trust_info /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_DsRGetForestTrustInformation_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_DsRGetForestTrustInformation_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.trusted_domain_name = _trusted_domain_name;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.forest_trust_info = _forest_trust_info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_DsRGetForestTrustInformation_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_DsRGetForestTrustInformation_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_DsRGetForestTrustInformation_done, req);
	return req;
}

static void dcerpc_netr_DsRGetForestTrustInformation_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_DsRGetForestTrustInformation_state *state = tevent_req_data(
		req, struct dcerpc_netr_DsRGetForestTrustInformation_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_DsRGetForestTrustInformation_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.forest_trust_info = *state->tmp.out.forest_trust_info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_DsRGetForestTrustInformation_recv(struct tevent_req *req,
						       TALLOC_CTX *mem_ctx,
						       WERROR *result)
{
	struct dcerpc_netr_DsRGetForestTrustInformation_state *state = tevent_req_data(
		req, struct dcerpc_netr_DsRGetForestTrustInformation_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_DsRGetForestTrustInformation(struct dcerpc_binding_handle *h,
						  TALLOC_CTX *mem_ctx,
						  const char *_server_name /* [in] [charset(UTF16),unique] */,
						  const char *_trusted_domain_name /* [in] [charset(UTF16),unique] */,
						  uint32_t _flags /* [in]  */,
						  struct lsa_ForestTrustInformation **_forest_trust_info /* [out] [ref] */,
						  WERROR *result)
{
	struct netr_DsRGetForestTrustInformation r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.trusted_domain_name = _trusted_domain_name;
	r.in.flags = _flags;

	/* Out parameters */
	r.out.forest_trust_info = _forest_trust_info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_DsRGetForestTrustInformation_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_forest_trust_info = *r.out.forest_trust_info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_GetForestTrustInformation_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_GetForestTrustInformation_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_GetForestTrustInformation_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_GetForestTrustInformation *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_GetForestTrustInformation_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_GetForestTrustInformation_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_GETFORESTTRUSTINFORMATION, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_GetForestTrustInformation_r_done, req);

	return req;
}

static void dcerpc_netr_GetForestTrustInformation_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_GetForestTrustInformation_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_GetForestTrustInformation_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_GetForestTrustInformation_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_GetForestTrustInformation_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_GetForestTrustInformation *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_GETFORESTTRUSTINFORMATION, mem_ctx, r);

	return status;
}

struct dcerpc_netr_GetForestTrustInformation_state {
	struct netr_GetForestTrustInformation orig;
	struct netr_GetForestTrustInformation tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_GetForestTrustInformation_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_GetForestTrustInformation_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct dcerpc_binding_handle *h,
							      const char *_server_name /* [in] [charset(UTF16),unique] */,
							      const char *_computer_name /* [in] [charset(UTF16),ref] */,
							      struct netr_Authenticator *_credential /* [in] [ref] */,
							      struct netr_Authenticator *_return_authenticator /* [out] [ref] */,
							      uint32_t _flags /* [in]  */,
							      struct lsa_ForestTrustInformation **_forest_trust_info /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_GetForestTrustInformation_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_GetForestTrustInformation_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.computer_name = _computer_name;
	state->orig.in.credential = _credential;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;
	state->orig.out.forest_trust_info = _forest_trust_info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_GetForestTrustInformation_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_GetForestTrustInformation_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_GetForestTrustInformation_done, req);
	return req;
}

static void dcerpc_netr_GetForestTrustInformation_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_GetForestTrustInformation_state *state = tevent_req_data(
		req, struct dcerpc_netr_GetForestTrustInformation_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_GetForestTrustInformation_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;
	*state->orig.out.forest_trust_info = *state->tmp.out.forest_trust_info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_GetForestTrustInformation_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx,
						    NTSTATUS *result)
{
	struct dcerpc_netr_GetForestTrustInformation_state *state = tevent_req_data(
		req, struct dcerpc_netr_GetForestTrustInformation_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_GetForestTrustInformation(struct dcerpc_binding_handle *h,
					       TALLOC_CTX *mem_ctx,
					       const char *_server_name /* [in] [charset(UTF16),unique] */,
					       const char *_computer_name /* [in] [charset(UTF16),ref] */,
					       struct netr_Authenticator *_credential /* [in] [ref] */,
					       struct netr_Authenticator *_return_authenticator /* [out] [ref] */,
					       uint32_t _flags /* [in]  */,
					       struct lsa_ForestTrustInformation **_forest_trust_info /* [out] [ref] */,
					       NTSTATUS *result)
{
	struct netr_GetForestTrustInformation r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.computer_name = _computer_name;
	r.in.credential = _credential;
	r.in.flags = _flags;

	/* Out parameters */
	r.out.return_authenticator = _return_authenticator;
	r.out.forest_trust_info = _forest_trust_info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_GetForestTrustInformation_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_return_authenticator = *r.out.return_authenticator;
	*_forest_trust_info = *r.out.forest_trust_info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_LogonSamLogonWithFlags_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_LogonSamLogonWithFlags_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_LogonSamLogonWithFlags_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_LogonSamLogonWithFlags *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_LogonSamLogonWithFlags_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_LogonSamLogonWithFlags_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_LOGONSAMLOGONWITHFLAGS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_LogonSamLogonWithFlags_r_done, req);

	return req;
}

static void dcerpc_netr_LogonSamLogonWithFlags_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_LogonSamLogonWithFlags_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_LogonSamLogonWithFlags_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_LogonSamLogonWithFlags_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_LogonSamLogonWithFlags_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_LogonSamLogonWithFlags *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_LOGONSAMLOGONWITHFLAGS, mem_ctx, r);

	return status;
}

struct dcerpc_netr_LogonSamLogonWithFlags_state {
	struct netr_LogonSamLogonWithFlags orig;
	struct netr_LogonSamLogonWithFlags tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_LogonSamLogonWithFlags_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_LogonSamLogonWithFlags_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct dcerpc_binding_handle *h,
							   const char *_server_name /* [in] [charset(UTF16),unique] */,
							   const char *_computer_name /* [in] [charset(UTF16),unique] */,
							   struct netr_Authenticator *_credential /* [in] [unique] */,
							   struct netr_Authenticator *_return_authenticator /* [in,out] [unique] */,
							   enum netr_LogonInfoClass _logon_level /* [in]  */,
							   union netr_LogonLevel *_logon /* [in] [ref,switch_is(logon_level)] */,
							   uint16_t _validation_level /* [in]  */,
							   union netr_Validation *_validation /* [out] [ref,switch_is(validation_level)] */,
							   uint8_t *_authoritative /* [out] [ref] */,
							   uint32_t *_flags /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_LogonSamLogonWithFlags_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_LogonSamLogonWithFlags_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.computer_name = _computer_name;
	state->orig.in.credential = _credential;
	state->orig.in.return_authenticator = _return_authenticator;
	state->orig.in.logon_level = _logon_level;
	state->orig.in.logon = _logon;
	state->orig.in.validation_level = _validation_level;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;
	state->orig.out.validation = _validation;
	state->orig.out.authoritative = _authoritative;
	state->orig.out.flags = _flags;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_LogonSamLogonWithFlags_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_LogonSamLogonWithFlags_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_LogonSamLogonWithFlags_done, req);
	return req;
}

static void dcerpc_netr_LogonSamLogonWithFlags_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_LogonSamLogonWithFlags_state *state = tevent_req_data(
		req, struct dcerpc_netr_LogonSamLogonWithFlags_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_LogonSamLogonWithFlags_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.return_authenticator && state->tmp.out.return_authenticator) {
		*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;
	}
	*state->orig.out.validation = *state->tmp.out.validation;
	*state->orig.out.authoritative = *state->tmp.out.authoritative;
	*state->orig.out.flags = *state->tmp.out.flags;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_LogonSamLogonWithFlags_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 NTSTATUS *result)
{
	struct dcerpc_netr_LogonSamLogonWithFlags_state *state = tevent_req_data(
		req, struct dcerpc_netr_LogonSamLogonWithFlags_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_LogonSamLogonWithFlags(struct dcerpc_binding_handle *h,
					    TALLOC_CTX *mem_ctx,
					    const char *_server_name /* [in] [charset(UTF16),unique] */,
					    const char *_computer_name /* [in] [charset(UTF16),unique] */,
					    struct netr_Authenticator *_credential /* [in] [unique] */,
					    struct netr_Authenticator *_return_authenticator /* [in,out] [unique] */,
					    enum netr_LogonInfoClass _logon_level /* [in]  */,
					    union netr_LogonLevel *_logon /* [in] [ref,switch_is(logon_level)] */,
					    uint16_t _validation_level /* [in]  */,
					    union netr_Validation *_validation /* [out] [ref,switch_is(validation_level)] */,
					    uint8_t *_authoritative /* [out] [ref] */,
					    uint32_t *_flags /* [in,out] [ref] */,
					    NTSTATUS *result)
{
	struct netr_LogonSamLogonWithFlags r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.computer_name = _computer_name;
	r.in.credential = _credential;
	r.in.return_authenticator = _return_authenticator;
	r.in.logon_level = _logon_level;
	r.in.logon = _logon;
	r.in.validation_level = _validation_level;
	r.in.flags = _flags;

	/* Out parameters */
	r.out.return_authenticator = _return_authenticator;
	r.out.validation = _validation;
	r.out.authoritative = _authoritative;
	r.out.flags = _flags;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_LogonSamLogonWithFlags_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_return_authenticator && r.out.return_authenticator) {
		*_return_authenticator = *r.out.return_authenticator;
	}
	*_validation = *r.out.validation;
	*_authoritative = *r.out.authoritative;
	*_flags = *r.out.flags;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_ServerGetTrustInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_ServerGetTrustInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_ServerGetTrustInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_ServerGetTrustInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_ServerGetTrustInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_ServerGetTrustInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_SERVERGETTRUSTINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_ServerGetTrustInfo_r_done, req);

	return req;
}

static void dcerpc_netr_ServerGetTrustInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_ServerGetTrustInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_ServerGetTrustInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_ServerGetTrustInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_ServerGetTrustInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_ServerGetTrustInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_SERVERGETTRUSTINFO, mem_ctx, r);

	return status;
}

struct dcerpc_netr_ServerGetTrustInfo_state {
	struct netr_ServerGetTrustInfo orig;
	struct netr_ServerGetTrustInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_ServerGetTrustInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_ServerGetTrustInfo_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       const char *_server_name /* [in] [charset(UTF16),unique] */,
						       const char *_account_name /* [in] [charset(UTF16),ref] */,
						       enum netr_SchannelType _secure_channel_type /* [in]  */,
						       const char *_computer_name /* [in] [charset(UTF16),ref] */,
						       struct netr_Authenticator *_credential /* [in] [ref] */,
						       struct netr_Authenticator *_return_authenticator /* [out] [ref] */,
						       struct samr_Password *_new_owf_password /* [out] [ref] */,
						       struct samr_Password *_old_owf_password /* [out] [ref] */,
						       struct netr_TrustInfo **_trust_info /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_ServerGetTrustInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_ServerGetTrustInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.account_name = _account_name;
	state->orig.in.secure_channel_type = _secure_channel_type;
	state->orig.in.computer_name = _computer_name;
	state->orig.in.credential = _credential;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;
	state->orig.out.new_owf_password = _new_owf_password;
	state->orig.out.old_owf_password = _old_owf_password;
	state->orig.out.trust_info = _trust_info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_ServerGetTrustInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_ServerGetTrustInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_ServerGetTrustInfo_done, req);
	return req;
}

static void dcerpc_netr_ServerGetTrustInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_ServerGetTrustInfo_state *state = tevent_req_data(
		req, struct dcerpc_netr_ServerGetTrustInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_ServerGetTrustInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;
	*state->orig.out.new_owf_password = *state->tmp.out.new_owf_password;
	*state->orig.out.old_owf_password = *state->tmp.out.old_owf_password;
	*state->orig.out.trust_info = *state->tmp.out.trust_info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_ServerGetTrustInfo_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result)
{
	struct dcerpc_netr_ServerGetTrustInfo_state *state = tevent_req_data(
		req, struct dcerpc_netr_ServerGetTrustInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_ServerGetTrustInfo(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					const char *_server_name /* [in] [charset(UTF16),unique] */,
					const char *_account_name /* [in] [charset(UTF16),ref] */,
					enum netr_SchannelType _secure_channel_type /* [in]  */,
					const char *_computer_name /* [in] [charset(UTF16),ref] */,
					struct netr_Authenticator *_credential /* [in] [ref] */,
					struct netr_Authenticator *_return_authenticator /* [out] [ref] */,
					struct samr_Password *_new_owf_password /* [out] [ref] */,
					struct samr_Password *_old_owf_password /* [out] [ref] */,
					struct netr_TrustInfo **_trust_info /* [out] [ref] */,
					NTSTATUS *result)
{
	struct netr_ServerGetTrustInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.account_name = _account_name;
	r.in.secure_channel_type = _secure_channel_type;
	r.in.computer_name = _computer_name;
	r.in.credential = _credential;

	/* Out parameters */
	r.out.return_authenticator = _return_authenticator;
	r.out.new_owf_password = _new_owf_password;
	r.out.old_owf_password = _old_owf_password;
	r.out.trust_info = _trust_info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_ServerGetTrustInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_return_authenticator = *r.out.return_authenticator;
	*_new_owf_password = *r.out.new_owf_password;
	*_old_owf_password = *r.out.old_owf_password;
	*_trust_info = *r.out.trust_info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_Unused47_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_Unused47_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_Unused47_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_Unused47 *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_Unused47_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_Unused47_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_UNUSED47, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_Unused47_r_done, req);

	return req;
}

static void dcerpc_netr_Unused47_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_Unused47_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_Unused47_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_Unused47_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_Unused47_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_Unused47 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_UNUSED47, mem_ctx, r);

	return status;
}

struct dcerpc_netr_Unused47_state {
	struct netr_Unused47 orig;
	struct netr_Unused47 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_Unused47_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_Unused47_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct dcerpc_binding_handle *h)
{
	struct tevent_req *req;
	struct dcerpc_netr_Unused47_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_Unused47_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_Unused47_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_Unused47_done, req);
	return req;
}

static void dcerpc_netr_Unused47_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_Unused47_state *state = tevent_req_data(
		req, struct dcerpc_netr_Unused47_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_Unused47_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_Unused47_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   NTSTATUS *result)
{
	struct dcerpc_netr_Unused47_state *state = tevent_req_data(
		req, struct dcerpc_netr_Unused47_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_Unused47(struct dcerpc_binding_handle *h,
			      TALLOC_CTX *mem_ctx,
			      NTSTATUS *result)
{
	struct netr_Unused47 r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_Unused47_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_DsrUpdateReadOnlyServerDnsRecords_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_DsrUpdateReadOnlyServerDnsRecords_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_DsrUpdateReadOnlyServerDnsRecords_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_DsrUpdateReadOnlyServerDnsRecords *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_DsrUpdateReadOnlyServerDnsRecords_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_DsrUpdateReadOnlyServerDnsRecords_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_DSRUPDATEREADONLYSERVERDNSRECORDS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_DsrUpdateReadOnlyServerDnsRecords_r_done, req);

	return req;
}

static void dcerpc_netr_DsrUpdateReadOnlyServerDnsRecords_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_DsrUpdateReadOnlyServerDnsRecords_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_DsrUpdateReadOnlyServerDnsRecords_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_DsrUpdateReadOnlyServerDnsRecords_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_DsrUpdateReadOnlyServerDnsRecords_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_DsrUpdateReadOnlyServerDnsRecords *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_DSRUPDATEREADONLYSERVERDNSRECORDS, mem_ctx, r);

	return status;
}

struct dcerpc_netr_DsrUpdateReadOnlyServerDnsRecords_state {
	struct netr_DsrUpdateReadOnlyServerDnsRecords orig;
	struct netr_DsrUpdateReadOnlyServerDnsRecords tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_DsrUpdateReadOnlyServerDnsRecords_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_DsrUpdateReadOnlyServerDnsRecords_send(TALLOC_CTX *mem_ctx,
								      struct tevent_context *ev,
								      struct dcerpc_binding_handle *h,
								      const char *_server_name /* [in] [charset(UTF16),unique] */,
								      const char *_computer_name /* [in] [charset(UTF16),ref] */,
								      struct netr_Authenticator *_credential /* [in] [ref] */,
								      struct netr_Authenticator *_return_authenticator /* [out] [ref] */,
								      const char *_site_name /* [in] [charset(UTF16),unique] */,
								      uint32_t _dns_ttl /* [in]  */,
								      struct NL_DNS_NAME_INFO_ARRAY *_dns_names /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_DsrUpdateReadOnlyServerDnsRecords_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_DsrUpdateReadOnlyServerDnsRecords_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.computer_name = _computer_name;
	state->orig.in.credential = _credential;
	state->orig.in.site_name = _site_name;
	state->orig.in.dns_ttl = _dns_ttl;
	state->orig.in.dns_names = _dns_names;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;
	state->orig.out.dns_names = _dns_names;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_DsrUpdateReadOnlyServerDnsRecords_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_DsrUpdateReadOnlyServerDnsRecords_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_DsrUpdateReadOnlyServerDnsRecords_done, req);
	return req;
}

static void dcerpc_netr_DsrUpdateReadOnlyServerDnsRecords_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_DsrUpdateReadOnlyServerDnsRecords_state *state = tevent_req_data(
		req, struct dcerpc_netr_DsrUpdateReadOnlyServerDnsRecords_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_DsrUpdateReadOnlyServerDnsRecords_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;
	*state->orig.out.dns_names = *state->tmp.out.dns_names;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_DsrUpdateReadOnlyServerDnsRecords_recv(struct tevent_req *req,
							    TALLOC_CTX *mem_ctx,
							    NTSTATUS *result)
{
	struct dcerpc_netr_DsrUpdateReadOnlyServerDnsRecords_state *state = tevent_req_data(
		req, struct dcerpc_netr_DsrUpdateReadOnlyServerDnsRecords_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_DsrUpdateReadOnlyServerDnsRecords(struct dcerpc_binding_handle *h,
						       TALLOC_CTX *mem_ctx,
						       const char *_server_name /* [in] [charset(UTF16),unique] */,
						       const char *_computer_name /* [in] [charset(UTF16),ref] */,
						       struct netr_Authenticator *_credential /* [in] [ref] */,
						       struct netr_Authenticator *_return_authenticator /* [out] [ref] */,
						       const char *_site_name /* [in] [charset(UTF16),unique] */,
						       uint32_t _dns_ttl /* [in]  */,
						       struct NL_DNS_NAME_INFO_ARRAY *_dns_names /* [in,out] [ref] */,
						       NTSTATUS *result)
{
	struct netr_DsrUpdateReadOnlyServerDnsRecords r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.computer_name = _computer_name;
	r.in.credential = _credential;
	r.in.site_name = _site_name;
	r.in.dns_ttl = _dns_ttl;
	r.in.dns_names = _dns_names;

	/* Out parameters */
	r.out.return_authenticator = _return_authenticator;
	r.out.dns_names = _dns_names;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_DsrUpdateReadOnlyServerDnsRecords_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_return_authenticator = *r.out.return_authenticator;
	*_dns_names = *r.out.dns_names;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_netr_ServerAuthenticateKerberos_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_ServerAuthenticateKerberos_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_ServerAuthenticateKerberos_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct netr_ServerAuthenticateKerberos *r)
{
	struct tevent_req *req;
	struct dcerpc_netr_ServerAuthenticateKerberos_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_ServerAuthenticateKerberos_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_SERVERAUTHENTICATEKERBEROS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_ServerAuthenticateKerberos_r_done, req);

	return req;
}

static void dcerpc_netr_ServerAuthenticateKerberos_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_ServerAuthenticateKerberos_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_netr_ServerAuthenticateKerberos_r_state *state =
		tevent_req_data(req,
		struct dcerpc_netr_ServerAuthenticateKerberos_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_ServerAuthenticateKerberos_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct netr_ServerAuthenticateKerberos *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netlogon,
			NDR_NETR_SERVERAUTHENTICATEKERBEROS, mem_ctx, r);

	return status;
}

struct dcerpc_netr_ServerAuthenticateKerberos_state {
	struct netr_ServerAuthenticateKerberos orig;
	struct netr_ServerAuthenticateKerberos tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_netr_ServerAuthenticateKerberos_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_netr_ServerAuthenticateKerberos_send(TALLOC_CTX *mem_ctx,
							       struct tevent_context *ev,
							       struct dcerpc_binding_handle *h,
							       const char *_server_name /* [in] [charset(UTF16),unique] */,
							       const char *_account_name /* [in] [charset(UTF16),ref] */,
							       enum netr_SchannelType _account_type /* [in]  */,
							       const char *_computer_name /* [in] [charset(UTF16),ref] */,
							       uint32_t *_negotiate_flags /* [in,out] [ref] */,
							       uint32_t *_rid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_netr_ServerAuthenticateKerberos_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_netr_ServerAuthenticateKerberos_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.account_name = _account_name;
	state->orig.in.account_type = _account_type;
	state->orig.in.computer_name = _computer_name;
	state->orig.in.negotiate_flags = _negotiate_flags;

	/* Out parameters */
	state->orig.out.negotiate_flags = _negotiate_flags;
	state->orig.out.rid = _rid;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_netr_ServerAuthenticateKerberos_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_netr_ServerAuthenticateKerberos_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_netr_ServerAuthenticateKerberos_done, req);
	return req;
}

static void dcerpc_netr_ServerAuthenticateKerberos_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_netr_ServerAuthenticateKerberos_state *state = tevent_req_data(
		req, struct dcerpc_netr_ServerAuthenticateKerberos_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_netr_ServerAuthenticateKerberos_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.negotiate_flags = *state->tmp.out.negotiate_flags;
	*state->orig.out.rid = *state->tmp.out.rid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_netr_ServerAuthenticateKerberos_recv(struct tevent_req *req,
						     TALLOC_CTX *mem_ctx,
						     NTSTATUS *result)
{
	struct dcerpc_netr_ServerAuthenticateKerberos_state *state = tevent_req_data(
		req, struct dcerpc_netr_ServerAuthenticateKerberos_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_netr_ServerAuthenticateKerberos(struct dcerpc_binding_handle *h,
						TALLOC_CTX *mem_ctx,
						const char *_server_name /* [in] [charset(UTF16),unique] */,
						const char *_account_name /* [in] [charset(UTF16),ref] */,
						enum netr_SchannelType _account_type /* [in]  */,
						const char *_computer_name /* [in] [charset(UTF16),ref] */,
						uint32_t *_negotiate_flags /* [in,out] [ref] */,
						uint32_t *_rid /* [out] [ref] */,
						NTSTATUS *result)
{
	struct netr_ServerAuthenticateKerberos r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.account_name = _account_name;
	r.in.account_type = _account_type;
	r.in.computer_name = _computer_name;
	r.in.negotiate_flags = _negotiate_flags;

	/* Out parameters */
	r.out.negotiate_flags = _negotiate_flags;
	r.out.rid = _rid;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_netr_ServerAuthenticateKerberos_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_negotiate_flags = *r.out.negotiate_flags;
	*_rid = *r.out.rid;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

