/* s3 compat server functions auto-generated by pidl */
#include "bin/default/librpc/gen_ndr/ndr_echo.h"
#include "bin/default/librpc/gen_ndr/ndr_echo_scompat.h"
#include <librpc/rpc/dcesrv_core.h>
#include <rpc_server/rpc_config.h>
#include <rpc_server/rpc_server.h>
#include <util/debug.h>

enum s3compat_rpc_dispatch {
	S3COMPAT_RPC_DISPATCH_EXTERNAL = 0x00000001,
	S3COMPAT_RPC_DISPATCH_INTERNAL = 0x00000002,
};

/* rpcecho - dcerpc server boilerplate generated by pidl */
static NTSTATUS rpcecho__op_bind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_RPCECHO_BIND
	return DCESRV_INTERFACE_RPCECHO_BIND(context,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void rpcecho__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_RPCECHO_UNBIND
	DCESRV_INTERFACE_RPCECHO_UNBIND(context, iface);
#else
	return;
#endif
}

NTSTATUS rpcecho__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= ndr_table_rpcecho.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_named(mem_ctx, ndr_table_rpcecho.calls[opnum].struct_size, "struct %s", ndr_table_rpcecho.calls[opnum].name);
	NT_STATUS_HAVE_NO_MEMORY(*r);

	/* unravel the NDR for the packet */
	ndr_err = ndr_table_rpcecho.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS rpcecho__op_dispatch_internal(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r, enum s3compat_rpc_dispatch dispatch)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;
	struct pipes_struct *p = NULL;
	NTSTATUS status = NT_STATUS_OK;
	bool impersonated = false;

	/* Retrieve pipes struct */
	p = dcesrv_get_pipes_struct(dce_call->conn);
	p->dce_call = dce_call;
	p->mem_ctx = mem_ctx;
	/* Reset pipes struct fault state */
	p->fault_state = 0;

	/* Impersonate */
	if (dispatch == S3COMPAT_RPC_DISPATCH_EXTERNAL) {
		impersonated = become_authenticated_pipe_user(dce_call->auth_state->session_info);
		if (!impersonated) {
			dce_call->fault_code = DCERPC_FAULT_ACCESS_DENIED;
			status = NT_STATUS_NET_WRITE_FAULT;
			goto fail;
		}
	}

	switch (opnum) {
	case 0: { /* echo_AddOne */
		struct echo_AddOne *r2 = (struct echo_AddOne *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(echo_AddOne, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.out_data = talloc_zero(r2, uint32_t);
		if (r2->out.out_data == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		_echo_AddOne(p, r2);
		break;
	}
	case 1: { /* echo_EchoData */
		struct echo_EchoData *r2 = (struct echo_EchoData *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(echo_EchoData, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.out_data = talloc_zero_array(r2, uint8_t, r2->in.len);
		if (r2->out.out_data == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		_echo_EchoData(p, r2);
		break;
	}
	case 2: { /* echo_SinkData */
		struct echo_SinkData *r2 = (struct echo_SinkData *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(echo_SinkData, NDR_IN, r2);
		}
		_echo_SinkData(p, r2);
		break;
	}
	case 3: { /* echo_SourceData */
		struct echo_SourceData *r2 = (struct echo_SourceData *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(echo_SourceData, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.data = talloc_zero_array(r2, uint8_t, r2->in.len);
		if (r2->out.data == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		_echo_SourceData(p, r2);
		break;
	}
	case 4: { /* echo_TestCall */
		struct echo_TestCall *r2 = (struct echo_TestCall *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(echo_TestCall, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.s2 = talloc_zero(r2, const char *);
		if (r2->out.s2 == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		_echo_TestCall(p, r2);
		break;
	}
	case 5: { /* echo_TestCall2 */
		struct echo_TestCall2 *r2 = (struct echo_TestCall2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(echo_TestCall2, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = talloc_zero(r2, union echo_Info);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _echo_TestCall2(p, r2);
		break;
	}
	case 6: { /* echo_TestSleep */
		struct echo_TestSleep *r2 = (struct echo_TestSleep *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(echo_TestSleep, NDR_IN, r2);
		}
		r2->out.result = _echo_TestSleep(p, r2);
		break;
	}
	case 7: { /* echo_TestEnum */
		struct echo_TestEnum *r2 = (struct echo_TestEnum *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(echo_TestEnum, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.foo1 = r2->in.foo1;
		r2->out.foo2 = r2->in.foo2;
		r2->out.foo3 = r2->in.foo3;
		_echo_TestEnum(p, r2);
		break;
	}
	case 8: { /* echo_TestSurrounding */
		struct echo_TestSurrounding *r2 = (struct echo_TestSurrounding *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(echo_TestSurrounding, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.data = r2->in.data;
		_echo_TestSurrounding(p, r2);
		break;
	}
	case 9: { /* echo_TestDoublePointer */
		struct echo_TestDoublePointer *r2 = (struct echo_TestDoublePointer *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(echo_TestDoublePointer, NDR_IN, r2);
		}
		r2->out.result = _echo_TestDoublePointer(p, r2);
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

fail:
	/* Unimpersonate */
	if (impersonated) {
		unbecome_authenticated_pipe_user();
	}

	p->dce_call = NULL;
	p->mem_ctx = NULL;
	/* Check pipes struct fault state */
	if (p->fault_state != 0) {
		dce_call->fault_code = p->fault_state;
	}
	if (dce_call->fault_code != 0) {
		status = NT_STATUS_NET_WRITE_FAULT;
	}

	return status;
}

NTSTATUS rpcecho__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return rpcecho__op_dispatch_internal(dce_call, mem_ctx, r, S3COMPAT_RPC_DISPATCH_EXTERNAL);
}

NTSTATUS rpcecho__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: { /* echo_AddOne */
		struct echo_AddOne *r2 = (struct echo_AddOne *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function echo_AddOne replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(echo_AddOne, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in echo_AddOne\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 1: { /* echo_EchoData */
		struct echo_EchoData *r2 = (struct echo_EchoData *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function echo_EchoData replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(echo_EchoData, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in echo_EchoData\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 2: { /* echo_SinkData */
		struct echo_SinkData *r2 = (struct echo_SinkData *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function echo_SinkData replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(echo_SinkData, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in echo_SinkData\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 3: { /* echo_SourceData */
		struct echo_SourceData *r2 = (struct echo_SourceData *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function echo_SourceData replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(echo_SourceData, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in echo_SourceData\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 4: { /* echo_TestCall */
		struct echo_TestCall *r2 = (struct echo_TestCall *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function echo_TestCall replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(echo_TestCall, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in echo_TestCall\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 5: { /* echo_TestCall2 */
		struct echo_TestCall2 *r2 = (struct echo_TestCall2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function echo_TestCall2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(echo_TestCall2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in echo_TestCall2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 6: { /* echo_TestSleep */
		struct echo_TestSleep *r2 = (struct echo_TestSleep *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function echo_TestSleep replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(echo_TestSleep, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in echo_TestSleep\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 7: { /* echo_TestEnum */
		struct echo_TestEnum *r2 = (struct echo_TestEnum *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function echo_TestEnum replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(echo_TestEnum, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in echo_TestEnum\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 8: { /* echo_TestSurrounding */
		struct echo_TestSurrounding *r2 = (struct echo_TestSurrounding *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function echo_TestSurrounding replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(echo_TestSurrounding, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in echo_TestSurrounding\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 9: { /* echo_TestDoublePointer */
		struct echo_TestDoublePointer *r2 = (struct echo_TestDoublePointer *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function echo_TestDoublePointer replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(echo_TestDoublePointer, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in echo_TestDoublePointer\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS rpcecho__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	ndr_err = ndr_table_rpcecho.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS rpcecho__op_local(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return rpcecho__op_dispatch_internal(dce_call, mem_ctx, r, S3COMPAT_RPC_DISPATCH_INTERNAL);
}

static const struct dcesrv_interface dcesrv_rpcecho_interface = {
	.name      = "rpcecho",
	.syntax_id = {{0x60a15ec5,0x4de8,0x11d7,{0xa6,0x37},{0x00,0x50,0x56,0xa2,0x01,0x82}},1.0},
	.bind      = rpcecho__op_bind,
	.unbind    = rpcecho__op_unbind,
	.ndr_pull  = rpcecho__op_ndr_pull,
	.dispatch  = rpcecho__op_dispatch,
	.reply     = rpcecho__op_reply,
	.ndr_push  = rpcecho__op_ndr_push,
	.local     = rpcecho__op_local,
#ifdef DCESRV_INTERFACE_RPCECHO_FLAGS
	.flags     = DCESRV_INTERFACE_RPCECHO_FLAGS
#else
	.flags     = 0
#endif
};

static NTSTATUS rpcecho__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	uint32_t i;
	NTSTATUS ret;

#ifdef DCESRV_INTERFACE_RPCECHO_NCACN_NP_SECONDARY_ENDPOINT
	const char *ncacn_np_secondary_endpoint = DCESRV_INTERFACE_RPCECHO_NCACN_NP_SECONDARY_ENDPOINT;
#else
	const char *ncacn_np_secondary_endpoint = NULL;
#endif

	for (i=0;i<ndr_table_rpcecho.endpoints->count;i++) {
		const char *name = ndr_table_rpcecho.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, ncacn_np_secondary_endpoint, &dcesrv_rpcecho_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DBG_ERR("Failed to register endpoint '%s'\n",name);
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static NTSTATUS rpcecho__op_shutdown_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	return NT_STATUS_OK;
}

static bool rpcecho__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_rpcecho_interface.syntax_id.if_version == if_version && GUID_equal(&dcesrv_rpcecho_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_rpcecho_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static bool rpcecho__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_rpcecho_interface.name, name)==0) {
		memcpy(iface, &dcesrv_rpcecho_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static const struct dcesrv_endpoint_server rpcecho_ep_server = {
	/* fill in our name */
	.name = "rpcecho",

	/* Initialization flag */
	.initialized = false,

	/* fill in all the operations */
#ifdef DCESRV_INTERFACE_RPCECHO_INIT_SERVER
	.init_server = DCESRV_INTERFACE_RPCECHO_INIT_SERVER,
#else
	.init_server = rpcecho__op_init_server,
#endif
#ifdef DCESRV_INTERFACE_RPCECHO_SHUTDOWN_SERVER
	.shutdown_server = DCESRV_INTERFACE_RPCECHO_SHUTDOWN_SERVER,
#else
	.shutdown_server = rpcecho__op_shutdown_server,
#endif
	.interface_by_uuid = rpcecho__op_interface_by_uuid,
	.interface_by_name = rpcecho__op_interface_by_name
};

const struct dcesrv_endpoint_server *rpcecho_get_ep_server(void)
{
	return &rpcecho_ep_server;
}
