/* server functions auto-generated by pidl */
#include "bin/default/librpc/gen_ndr/ndr_backupkey.h"
#include <util/debug.h>

NTSTATUS dcerpc_server_backupkey_init(TALLOC_CTX *);

/* backupkey - dcerpc server boilerplate generated by pidl */


static NTSTATUS backupkey__op_bind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_BACKUPKEY_BIND
	return DCESRV_INTERFACE_BACKUPKEY_BIND(context,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void backupkey__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_BACKUPKEY_UNBIND
	DCESRV_INTERFACE_BACKUPKEY_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS backupkey__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= ndr_table_backupkey.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_named(mem_ctx,
			  ndr_table_backupkey.calls[opnum].struct_size,
			  "struct %s",
			  ndr_table_backupkey.calls[opnum].name);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	ndr_err = ndr_table_backupkey.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS backupkey__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct bkrp_BackupKey *r2 = (struct bkrp_BackupKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(bkrp_BackupKey, NDR_IN, r2);
		}
		r2->out.result = dcesrv_bkrp_BackupKey(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function bkrp_BackupKey will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS backupkey__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct bkrp_BackupKey *r2 = (struct bkrp_BackupKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function bkrp_BackupKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(bkrp_BackupKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in bkrp_BackupKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS backupkey__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	ndr_err = ndr_table_backupkey.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static const struct dcesrv_interface dcesrv_backupkey_interface = {
	.name		    = "backupkey",
	.syntax_id          = {{0x3dde7c30,0x165d,0x11d1,{0xab,0x8f},{0x00,0x80,0x5f,0x14,0xdb,0x40}},1.0},
	.bind		    = backupkey__op_bind,
	.unbind		    = backupkey__op_unbind,
	.ndr_pull	    = backupkey__op_ndr_pull,
	.dispatch	    = backupkey__op_dispatch,
	.reply		    = backupkey__op_reply,
	.ndr_push	    = backupkey__op_ndr_push,
	.local		    = NULL,
#ifdef DCESRV_INTERFACE_BACKUPKEY_FLAGS
	.flags              = DCESRV_INTERFACE_BACKUPKEY_FLAGS
#else
	.flags              = 0
#endif
};


static NTSTATUS backupkey__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;
#ifdef DCESRV_INTERFACE_BACKUPKEY_NCACN_NP_SECONDARY_ENDPOINT
	const char *ncacn_np_secondary_endpoint =
		DCESRV_INTERFACE_BACKUPKEY_NCACN_NP_SECONDARY_ENDPOINT;
#else
	const char *ncacn_np_secondary_endpoint = NULL;
#endif

	for (i=0;i<ndr_table_backupkey.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = ndr_table_backupkey.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx,
						name,
						ncacn_np_secondary_endpoint,
						&dcesrv_backupkey_interface,
						NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("backupkey_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static NTSTATUS backupkey__op_shutdown_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	return NT_STATUS_OK;
}

static bool backupkey__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_backupkey_interface.syntax_id.if_version == if_version &&
		GUID_equal(&dcesrv_backupkey_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_backupkey_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static bool backupkey__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_backupkey_interface.name, name)==0) {
		memcpy(iface, &dcesrv_backupkey_interface, sizeof(*iface));
		return true;
	}

	return false;
}

NTSTATUS dcerpc_server_backupkey_init(TALLOC_CTX *ctx)
{
	NTSTATUS ret;
	static const struct dcesrv_endpoint_server ep_server = {
	    /* fill in our name */
	    .name = "backupkey",

	    /* Initialization flag */
	    .initialized = false,

	    /* fill in all the operations */
#ifdef DCESRV_INTERFACE_BACKUPKEY_INIT_SERVER
	    .init_server = DCESRV_INTERFACE_BACKUPKEY_INIT_SERVER,
#else
	    .init_server = backupkey__op_init_server,
#endif
#ifdef DCESRV_INTERFACE_BACKUPKEY_SHUTDOWN_SERVER
	    .shutdown_server = DCESRV_INTERFACE_BACKUPKEY_SHUTDOWN_SERVER,
#else
	    .shutdown_server = backupkey__op_shutdown_server,
#endif
	    .interface_by_uuid = backupkey__op_interface_by_uuid,
	    .interface_by_name = backupkey__op_interface_by_name
	};
	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'backupkey' endpoint server!\n"));
		return ret;
	}

	return ret;
}

