/* Auto-generated by scmangle.py */
#include <stdint.h>
#include <stdlib.h>
#include <string.h>

static inline uint8_t rol8_u8(uint8_t v, unsigned int r) { r &= 7; return (uint8_t)(((v << r) | (v >> (8 - r))) & 0xFF); }
static inline uint8_t ror8_u8(uint8_t v, unsigned int r) { r &= 7; return (uint8_t)(((v >> r) | (v << (8 - r))) & 0xFF); }
static inline uint32_t lcg_next_u32(uint32_t *s) { *s = 1664525u * (*s) + 1013904223u; return *s; }
static inline void gen_perm_idx(size_t n, uint32_t seed, size_t *perm) {
    for (size_t i = 0; i < n; i++) perm[i] = i;
    if (n <= 1) return;
    for (size_t i = n - 1; i > 0; i--) {
        uint32_t r = lcg_next_u32(&seed) % (uint32_t)(i + 1);
        size_t j = (size_t)r;
        size_t t = perm[i]; perm[i] = perm[j]; perm[j] = t;
    }
}

static inline ut8 *sc_decrypt(const ut8 *buf, size_t len) {
    if (!buf) return NULL;
    ut8 *cur = (ut8*)malloc(len);
    if (!cur) return NULL;
    if (len) memcpy(cur, buf, len);
    /* inverse: rol 7 */
    for (size_t i = 0; i < len; i++) cur[i] = (ut8)rol8_u8(cur[i], 7);
    /* inverse: untranspose seed=0x36604d3c */
    if (len > 1) {
        size_t *perm = (size_t*)malloc(sizeof(size_t) * len);
        if (!perm) { free(cur); return NULL; }
        gen_perm_idx(len, 0x36604d3cu, perm);
        ut8 *tmp = (ut8*)malloc(len);
        if (!tmp) { free(perm); free(cur); return NULL; }
        for (size_t i = 0; i < len; i++) tmp[i] = cur[perm[i]];
        free(cur); cur = tmp; free(perm);
    }
    /* inverse: ror 2 */
    for (size_t i = 0; i < len; i++) cur[i] = (ut8)ror8_u8(cur[i], 2);
    return cur;
}
