/* AbstractMountableRow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from AbstractMountableRow.vala, do not modify */

/* DeviceRow.vala
 *
 * Copyright 2021 elementary LLC. <https://elementary.io>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * Authors : Jeremy Wootten <jeremywootten@gmail.com>
 */
/* Used to determine first level sort order.*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include "pantheon-files-core.h"
#include <glib.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	MOUNTABLE_TYPE_VOLUMELESS_MOUNT,
	MOUNTABLE_TYPE_VOLUME,
	MOUNTABLE_TYPE_EMPTY_DRIVE
} MountableType;

#define TYPE_MOUNTABLE_TYPE (mountable_type_get_type ())

#define SIDEBAR_TYPE_BOOKMARK_ROW (sidebar_bookmark_row_get_type ())
#define SIDEBAR_BOOKMARK_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRow))
#define SIDEBAR_BOOKMARK_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRowClass))
#define SIDEBAR_IS_BOOKMARK_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_BOOKMARK_ROW))
#define SIDEBAR_IS_BOOKMARK_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_BOOKMARK_ROW))
#define SIDEBAR_BOOKMARK_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRowClass))

typedef struct _SidebarBookmarkRow SidebarBookmarkRow;
typedef struct _SidebarBookmarkRowClass SidebarBookmarkRowClass;
typedef struct _SidebarBookmarkRowPrivate SidebarBookmarkRowPrivate;

#define SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW (sidebar_abstract_mountable_row_get_type ())
#define SIDEBAR_ABSTRACT_MOUNTABLE_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, SidebarAbstractMountableRow))
#define SIDEBAR_ABSTRACT_MOUNTABLE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, SidebarAbstractMountableRowClass))
#define SIDEBAR_IS_ABSTRACT_MOUNTABLE_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW))
#define SIDEBAR_IS_ABSTRACT_MOUNTABLE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW))
#define SIDEBAR_ABSTRACT_MOUNTABLE_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, SidebarAbstractMountableRowClass))

typedef struct _SidebarAbstractMountableRow SidebarAbstractMountableRow;
typedef struct _SidebarAbstractMountableRowClass SidebarAbstractMountableRowClass;
typedef struct _SidebarAbstractMountableRowPrivate SidebarAbstractMountableRowPrivate;
enum  {
	SIDEBAR_ABSTRACT_MOUNTABLE_ROW_0_PROPERTY,
	SIDEBAR_ABSTRACT_MOUNTABLE_ROW_SORT_KEY_PROPERTY,
	SIDEBAR_ABSTRACT_MOUNTABLE_ROW_MOUNT_PROPERTY,
	SIDEBAR_ABSTRACT_MOUNTABLE_ROW_DRIVE_PROPERTY,
	SIDEBAR_ABSTRACT_MOUNTABLE_ROW_UUID_PROPERTY,
	SIDEBAR_ABSTRACT_MOUNTABLE_ROW_IS_MOUNTED_PROPERTY,
	SIDEBAR_ABSTRACT_MOUNTABLE_ROW_CAN_UNMOUNT_PROPERTY,
	SIDEBAR_ABSTRACT_MOUNTABLE_ROW_CAN_EJECT_PROPERTY,
	SIDEBAR_ABSTRACT_MOUNTABLE_ROW_WORKING_PROPERTY,
	SIDEBAR_ABSTRACT_MOUNTABLE_ROW_NUM_PROPERTIES
};
static GParamSpec* sidebar_abstract_mountable_row_properties[SIDEBAR_ABSTRACT_MOUNTABLE_ROW_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _SidebarAbstractMountableRowUnmountMountData SidebarAbstractMountableRowUnmountMountData;
typedef struct _SidebarAbstractMountableRowEjectMountData SidebarAbstractMountableRowEjectMountData;
typedef struct _SidebarAbstractMountableRowSafelyRemoveDriveData SidebarAbstractMountableRowSafelyRemoveDriveData;
typedef struct _SidebarAbstractMountableRowEjectDriveData SidebarAbstractMountableRowEjectDriveData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SidebarAbstractMountableRowGetFilesystemSpaceForRootData SidebarAbstractMountableRowGetFilesystemSpaceForRootData;
typedef struct _SidebarAbstractMountableRowGetStorageTextData SidebarAbstractMountableRowGetStorageTextData;
typedef struct _SidebarAbstractMountableRowAddMountableTooltipData SidebarAbstractMountableRowAddMountableTooltipData;
typedef struct _SidebarAbstractMountableRowGetFilesystemSpaceData SidebarAbstractMountableRowGetFilesystemSpaceData;

struct _SidebarBookmarkRow {
	GtkListBoxRow parent_instance;
	SidebarBookmarkRowPrivate * priv;
	GtkGrid* content_grid;
	GtkGrid* icon_label_grid;
	GtkStack* label_stack;
	GtkEntry* editable;
	GtkLabel* label;
	GtkRevealer* drop_revealer;
	FilesFile* target_file;
};

struct _SidebarBookmarkRowClass {
	GtkListBoxRowClass parent_class;
	gboolean (*on_key_press_event) (SidebarBookmarkRow* self, guint keyval, guint keycode, GdkModifierType state);
	void (*on_button_release_event) (SidebarBookmarkRow* self, gint n_press, gdouble x, gdouble y);
	void (*popup_context_menu) (SidebarBookmarkRow* self);
};

struct _SidebarAbstractMountableRow {
	SidebarBookmarkRow parent_instance;
	SidebarAbstractMountableRowPrivate * priv;
	gboolean valid;
};

struct _SidebarAbstractMountableRowClass {
	SidebarBookmarkRowClass parent_class;
	void (*update_free_space) (SidebarAbstractMountableRow* self);
	void (*add_mountable_tooltip) (SidebarAbstractMountableRow* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_mountable_tooltip_finish) (SidebarAbstractMountableRow* self, GAsyncResult* _res_);
	void (*on_mount_removed) (SidebarAbstractMountableRow* self, GMount* removed_mount);
	void (*on_mount_added) (SidebarAbstractMountableRow* self, GMount* added_mount);
	void (*show_mount_info) (SidebarAbstractMountableRow* self);
	void (*get_filesystem_space) (SidebarAbstractMountableRow* self, GCancellable* update_cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*get_filesystem_space_finish) (SidebarAbstractMountableRow* self, GAsyncResult* _res_);
	gboolean (*get_is_mounted) (SidebarAbstractMountableRow* self);
	gboolean (*get_can_unmount) (SidebarAbstractMountableRow* self);
	gboolean (*get_can_eject) (SidebarAbstractMountableRow* self);
};

struct _SidebarAbstractMountableRowPrivate {
	gdouble storage_capacity;
	gdouble storage_free;
	gchar* _sort_key;
	GtkStack* unmount_eject_working_stack;
	GtkRevealer* unmount_eject_revealer;
	GtkSpinner* working_spinner;
	GtkButton* unmount_eject_button;
	GtkLevelBar* storage_levelbar;
	GMount* _mount;
	GDrive* _drive;
	gchar* _uuid;
	gboolean _working;
};

struct _SidebarAbstractMountableRowUnmountMountData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SidebarAbstractMountableRow* self;
	gboolean result;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean success;
	GMount* _tmp6_;
	GtkWindow* _tmp7_;
	GtkWindow* _tmp8_;
	gboolean _tmp9_;
};

struct _SidebarAbstractMountableRowEjectMountData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SidebarAbstractMountableRow* self;
	gboolean result;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean success;
	GMount* _tmp6_;
	GtkWindow* _tmp7_;
	GtkWindow* _tmp8_;
	gboolean _tmp9_;
};

struct _SidebarAbstractMountableRowSafelyRemoveDriveData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SidebarAbstractMountableRow* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GDrive* _tmp4_;
	GDrive* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GDrive* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GDrive* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GDrive* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GDrive* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	GDrive* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GDrive* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GDrive* _tmp26_;
	GtkWindow* _tmp27_;
	GtkWindow* _tmp28_;
};

struct _SidebarAbstractMountableRowEjectDriveData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SidebarAbstractMountableRow* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GDrive* _tmp4_;
	GDrive* _tmp5_;
	GtkWindow* _tmp6_;
	GtkWindow* _tmp7_;
};

struct _SidebarAbstractMountableRowGetFilesystemSpaceForRootData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SidebarAbstractMountableRow* self;
	GFile* root;
	GCancellable* update_cancellable;
	gboolean result;
	gchar* scheme;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GNetworkMonitor* net_mon;
	GNetworkMonitor* _tmp7_;
	GNetworkMonitor* _tmp8_;
	GNetworkMonitor* _tmp9_;
	GFileInfo* info;
	GFileInfo* _tmp10_;
	GFileInfo* _tmp11_;
	GFileInfo* _tmp12_;
	GError* _error_;
	GError* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GError* _tmp16_;
	const gchar* _tmp17_;
	gboolean _tmp18_;
	GFileInfo* _tmp19_;
	GFileInfo* _tmp20_;
	GFileInfo* _tmp21_;
	GFileInfo* _tmp22_;
	GFileInfo* _tmp23_;
	GError* _inner_error0_;
};

struct _SidebarAbstractMountableRowGetStorageTextData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SidebarAbstractMountableRow* self;
	gchar* result;
	gchar* storage_text;
	gchar* _tmp0_;
	gchar* used_string;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* size_string;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	GtkLevelBar* _tmp14_;
	GtkLevelBar* _tmp15_;
	GtkLevelBar* _tmp16_;
};

struct _SidebarAbstractMountableRowAddMountableTooltipData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SidebarAbstractMountableRow* self;
	gchar* storage_text;
	gchar* _tmp0_;
	gchar* mount_text;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
};

struct _SidebarAbstractMountableRowGetFilesystemSpaceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SidebarAbstractMountableRow* self;
	GCancellable* update_cancellable;
	gboolean result;
};

static gint SidebarAbstractMountableRow_private_offset;
static gpointer sidebar_abstract_mountable_row_parent_class = NULL;
VALA_EXTERN GtkCssProvider* sidebar_abstract_mountable_row_devicerow_provider;
GtkCssProvider* sidebar_abstract_mountable_row_devicerow_provider = NULL;
VALA_EXTERN GVolumeMonitor* sidebar_abstract_mountable_row_volume_monitor;
GVolumeMonitor* sidebar_abstract_mountable_row_volume_monitor = NULL;
static SidebarSidebarItemInterfaceIface * sidebar_abstract_mountable_row_sidebar_sidebar_item_interface_parent_iface = NULL;

VALA_EXTERN GType mountable_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType sidebar_bookmark_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarBookmarkRow, g_object_unref)
VALA_EXTERN GType sidebar_abstract_mountable_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarAbstractMountableRow, g_object_unref)
VALA_EXTERN void sidebar_abstract_mountable_row_update_free_space (SidebarAbstractMountableRow* self);
VALA_EXTERN void sidebar_abstract_mountable_row_add_mountable_tooltip (SidebarAbstractMountableRow* self,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_);
VALA_EXTERN void sidebar_abstract_mountable_row_add_mountable_tooltip_finish (SidebarAbstractMountableRow* self,
                                                                  GAsyncResult* _res_);
VALA_EXTERN void sidebar_abstract_mountable_row_on_mount_removed (SidebarAbstractMountableRow* self,
                                                      GMount* removed_mount);
VALA_EXTERN void sidebar_abstract_mountable_row_on_mount_added (SidebarAbstractMountableRow* self,
                                                    GMount* added_mount);
VALA_EXTERN void sidebar_abstract_mountable_row_show_mount_info (SidebarAbstractMountableRow* self);
VALA_EXTERN void sidebar_abstract_mountable_row_get_filesystem_space (SidebarAbstractMountableRow* self,
                                                          GCancellable* update_cancellable,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_);
VALA_EXTERN gboolean sidebar_abstract_mountable_row_get_filesystem_space_finish (SidebarAbstractMountableRow* self,
                                                                     GAsyncResult* _res_);
VALA_EXTERN gboolean sidebar_abstract_mountable_row_get_is_mounted (SidebarAbstractMountableRow* self);
VALA_EXTERN gboolean sidebar_abstract_mountable_row_get_can_unmount (SidebarAbstractMountableRow* self);
VALA_EXTERN gboolean sidebar_abstract_mountable_row_get_can_eject (SidebarAbstractMountableRow* self);
VALA_EXTERN SidebarAbstractMountableRow* sidebar_abstract_mountable_row_construct (GType object_type,
                                                                       const gchar* name,
                                                                       const gchar* uri,
                                                                       GIcon* gicon,
                                                                       SidebarSidebarListInterface* list,
                                                                       gboolean pinned,
                                                                       gboolean permanent,
                                                                       const gchar* _uuid);
VALA_EXTERN void sidebar_abstract_mountable_row_update_visibilities (SidebarAbstractMountableRow* self);
static void sidebar_abstract_mountable_row_real_update_plugin_data (SidebarSidebarItemInterface* base,
                                                             FilesSidebarPluginItem* item);
VALA_EXTERN void sidebar_abstract_mountable_row_set_working (SidebarAbstractMountableRow* self,
                                                 gboolean value);
static void sidebar_abstract_mountable_row_unmount_mount_data_free (gpointer _data);
VALA_EXTERN void sidebar_abstract_mountable_row_unmount_mount (SidebarAbstractMountableRow* self,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
VALA_EXTERN gboolean sidebar_abstract_mountable_row_unmount_mount_finish (SidebarAbstractMountableRow* self,
                                                              GAsyncResult* _res_);
static gboolean sidebar_abstract_mountable_row_unmount_mount_co (SidebarAbstractMountableRowUnmountMountData* _data_);
VALA_EXTERN gboolean sidebar_abstract_mountable_row_get_working (SidebarAbstractMountableRow* self);
VALA_EXTERN GMount* sidebar_abstract_mountable_row_get_mount (SidebarAbstractMountableRow* self);
VALA_EXTERN GtkWindow* files_get_active_window (void);
static void sidebar_abstract_mountable_row_unmount_mount_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
static void sidebar_abstract_mountable_row_eject_mount_data_free (gpointer _data);
VALA_EXTERN void sidebar_abstract_mountable_row_eject_mount (SidebarAbstractMountableRow* self,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
VALA_EXTERN gboolean sidebar_abstract_mountable_row_eject_mount_finish (SidebarAbstractMountableRow* self,
                                                            GAsyncResult* _res_);
static gboolean sidebar_abstract_mountable_row_eject_mount_co (SidebarAbstractMountableRowEjectMountData* _data_);
static void sidebar_abstract_mountable_row_eject_mount_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
static void sidebar_abstract_mountable_row_safely_remove_drive_data_free (gpointer _data);
VALA_EXTERN void sidebar_abstract_mountable_row_safely_remove_drive (SidebarAbstractMountableRow* self,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_);
VALA_EXTERN void sidebar_abstract_mountable_row_safely_remove_drive_finish (SidebarAbstractMountableRow* self,
                                                                GAsyncResult* _res_);
static gboolean sidebar_abstract_mountable_row_safely_remove_drive_co (SidebarAbstractMountableRowSafelyRemoveDriveData* _data_);
VALA_EXTERN GDrive* sidebar_abstract_mountable_row_get_drive (SidebarAbstractMountableRow* self);
static void sidebar_abstract_mountable_row_safely_remove_drive_ready (GObject* source_object,
                                                               GAsyncResult* _res_,
                                                               gpointer _user_data_);
static void sidebar_abstract_mountable_row_eject_drive_data_free (gpointer _data);
VALA_EXTERN void sidebar_abstract_mountable_row_eject_drive (SidebarAbstractMountableRow* self,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
VALA_EXTERN void sidebar_abstract_mountable_row_eject_drive_finish (SidebarAbstractMountableRow* self,
                                                        GAsyncResult* _res_);
static gboolean sidebar_abstract_mountable_row_eject_drive_co (SidebarAbstractMountableRowEjectDriveData* _data_);
static void sidebar_abstract_mountable_row_eject_drive_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
VALA_EXTERN void sidebar_abstract_mountable_row_add_extra_menu_items_for_mount (SidebarAbstractMountableRow* self,
                                                                    GMount* mount,
                                                                    GMenu* menu);
static void sidebar_abstract_mountable_row_get_filesystem_space_for_root_data_free (gpointer _data);
VALA_EXTERN void sidebar_abstract_mountable_row_get_filesystem_space_for_root (SidebarAbstractMountableRow* self,
                                                                   GFile* root,
                                                                   GCancellable* update_cancellable,
                                                                   GAsyncReadyCallback _callback_,
                                                                   gpointer _user_data_);
VALA_EXTERN gboolean sidebar_abstract_mountable_row_get_filesystem_space_for_root_finish (SidebarAbstractMountableRow* self,
                                                                              GAsyncResult* _res_);
static gboolean sidebar_abstract_mountable_row_get_filesystem_space_for_root_co (SidebarAbstractMountableRowGetFilesystemSpaceForRootData* _data_);
static void sidebar_abstract_mountable_row_get_filesystem_space_for_root_ready (GObject* source_object,
                                                                         GAsyncResult* _res_,
                                                                         gpointer _user_data_);
static void sidebar_abstract_mountable_row_get_storage_text_data_free (gpointer _data);
VALA_EXTERN void sidebar_abstract_mountable_row_get_storage_text (SidebarAbstractMountableRow* self,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
VALA_EXTERN gchar* sidebar_abstract_mountable_row_get_storage_text_finish (SidebarAbstractMountableRow* self,
                                                               GAsyncResult* _res_);
static gboolean sidebar_abstract_mountable_row_get_storage_text_co (SidebarAbstractMountableRowGetStorageTextData* _data_);
static void sidebar_abstract_mountable_row_get_storage_text_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_);
static void sidebar_abstract_mountable_row_real_update_free_space (SidebarAbstractMountableRow* self);
static void sidebar_abstract_mountable_row_real_add_mountable_tooltip_data_free (gpointer _data);
static void sidebar_abstract_mountable_row_real_add_mountable_tooltip (SidebarAbstractMountableRow* self,
                                                                GAsyncReadyCallback _callback_,
                                                                gpointer _user_data_);
static gboolean sidebar_abstract_mountable_row_real_add_mountable_tooltip_co (SidebarAbstractMountableRowAddMountableTooltipData* _data_);
static void sidebar_abstract_mountable_row_add_mountable_tooltip_ready (GObject* source_object,
                                                                 GAsyncResult* _res_,
                                                                 gpointer _user_data_);
static void sidebar_abstract_mountable_row_real_on_mount_removed (SidebarAbstractMountableRow* self,
                                                           GMount* removed_mount);
static void sidebar_abstract_mountable_row_real_on_mount_added (SidebarAbstractMountableRow* self,
                                                         GMount* added_mount);
static void sidebar_abstract_mountable_row_real_show_mount_info (SidebarAbstractMountableRow* self);
static void sidebar_abstract_mountable_row_real_get_filesystem_space_data_free (gpointer _data);
static void sidebar_abstract_mountable_row_real_get_filesystem_space (SidebarAbstractMountableRow* self,
                                                               GCancellable* update_cancellable,
                                                               GAsyncReadyCallback _callback_,
                                                               gpointer _user_data_);
static gboolean sidebar_abstract_mountable_row_real_get_filesystem_space_co (SidebarAbstractMountableRowGetFilesystemSpaceData* _data_);
VALA_EXTERN const gchar* sidebar_abstract_mountable_row_get_sort_key (SidebarAbstractMountableRow* self);
VALA_EXTERN void sidebar_abstract_mountable_row_set_sort_key (SidebarAbstractMountableRow* self,
                                                  const gchar* value);
VALA_EXTERN void sidebar_abstract_mountable_row_set_mount (SidebarAbstractMountableRow* self,
                                               GMount* value);
static void sidebar_abstract_mountable_row_set_drive (SidebarAbstractMountableRow* self,
                                               GDrive* value);
VALA_EXTERN const gchar* sidebar_abstract_mountable_row_get_uuid (SidebarAbstractMountableRow* self);
VALA_EXTERN void sidebar_abstract_mountable_row_set_uuid (SidebarAbstractMountableRow* self,
                                              const gchar* value);
static GObject * sidebar_abstract_mountable_row_constructor (GType type,
                                                      guint n_construct_properties,
                                                      GObjectConstructParam * construct_properties);
static void _sidebar_abstract_mountable_row_on_mount_removed_g_volume_monitor_mount_removed (GVolumeMonitor* _sender,
                                                                                      GMount* mount,
                                                                                      gpointer self);
static void _sidebar_abstract_mountable_row_on_mount_added_g_volume_monitor_mount_added (GVolumeMonitor* _sender,
                                                                                  GMount* mount,
                                                                                  gpointer self);
static void _sidebar_abstract_mountable_row___lambda175_ (SidebarAbstractMountableRow* self);
static void __sidebar_abstract_mountable_row___lambda175__gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self);
static void _sidebar_abstract_mountable_row___lambda176_ (SidebarAbstractMountableRow* self);
static void __sidebar_abstract_mountable_row___lambda176__g_simple_action_activate (GSimpleAction* _sender,
                                                                             GVariant* parameter,
                                                                             gpointer self);
static void _sidebar_abstract_mountable_row___lambda177_ (SidebarAbstractMountableRow* self);
static void __sidebar_abstract_mountable_row___lambda177__g_simple_action_activate (GSimpleAction* _sender,
                                                                             GVariant* parameter,
                                                                             gpointer self);
static void _sidebar_abstract_mountable_row_show_mount_info_g_simple_action_activate (GSimpleAction* _sender,
                                                                               GVariant* parameter,
                                                                               gpointer self);
static void _sidebar_abstract_mountable_row___lambda178_ (SidebarAbstractMountableRow* self);
static void __sidebar_abstract_mountable_row___lambda178__g_simple_action_activate (GSimpleAction* _sender,
                                                                             GVariant* parameter,
                                                                             gpointer self);
static void _sidebar_abstract_mountable_row___lambda179_ (SidebarAbstractMountableRow* self);
static void __sidebar_abstract_mountable_row___lambda179__g_simple_action_activate (GSimpleAction* _sender,
                                                                             GVariant* parameter,
                                                                             gpointer self);
static void sidebar_abstract_mountable_row_finalize (GObject * obj);
static GType sidebar_abstract_mountable_row_get_type_once (void);
static void _vala_sidebar_abstract_mountable_row_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec);
static void _vala_sidebar_abstract_mountable_row_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec);

 G_GNUC_NO_INLINE static GType
mountable_type_get_type_once (void)
{
	static const GEnumValue values[] = {{MOUNTABLE_TYPE_VOLUMELESS_MOUNT, "MOUNTABLE_TYPE_VOLUMELESS_MOUNT", "volumeless-mount"}, {MOUNTABLE_TYPE_VOLUME, "MOUNTABLE_TYPE_VOLUME", "volume"}, {MOUNTABLE_TYPE_EMPTY_DRIVE, "MOUNTABLE_TYPE_EMPTY_DRIVE", "empty-drive"}, {0, NULL, NULL}};
	GType mountable_type_type_id;
	mountable_type_type_id = g_enum_register_static ("MountableType", values);
	return mountable_type_type_id;
}

GType
mountable_type_get_type (void)
{
	static volatile gsize mountable_type_type_id__once = 0;
	if (g_once_init_enter (&mountable_type_type_id__once)) {
		GType mountable_type_type_id;
		mountable_type_type_id = mountable_type_get_type_once ();
		g_once_init_leave (&mountable_type_type_id__once, mountable_type_type_id);
	}
	return mountable_type_type_id__once;
}

static inline gpointer
sidebar_abstract_mountable_row_get_instance_private (SidebarAbstractMountableRow* self)
{
	return G_STRUCT_MEMBER_P (self, SidebarAbstractMountableRow_private_offset);
}

SidebarAbstractMountableRow*
sidebar_abstract_mountable_row_construct (GType object_type,
                                          const gchar* name,
                                          const gchar* uri,
                                          GIcon* gicon,
                                          SidebarSidebarListInterface* list,
                                          gboolean pinned,
                                          gboolean permanent,
                                          const gchar* _uuid)
{
	SidebarAbstractMountableRow * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (gicon != NULL, NULL);
	g_return_val_if_fail (list != NULL, NULL);
	self = (SidebarAbstractMountableRow*) g_object_new (object_type, "custom-name", name, "uri", uri, "gicon", gicon, "list", list, "pinned", pinned, "permanent", permanent, "uuid", _uuid, NULL);
	return self;
}

void
sidebar_abstract_mountable_row_update_visibilities (SidebarAbstractMountableRow* self)
{
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GtkButton* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GtkRevealer* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	GtkLevelBar* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp1_ = sidebar_abstract_mountable_row_get_can_eject (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		_tmp0_ = _ ("Eject '%s'");
	} else {
		_tmp0_ = _ ("Unmount '%s'");
	}
	_tmp3_ = self->priv->unmount_eject_button;
	_tmp4_ = sidebar_sidebar_item_interface_get_custom_name ((SidebarSidebarItemInterface*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf (_tmp0_, _tmp5_);
	_tmp7_ = _tmp6_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp3_, _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = self->priv->unmount_eject_revealer;
	_tmp9_ = sidebar_abstract_mountable_row_get_can_unmount (self);
	_tmp10_ = _tmp9_;
	gtk_revealer_set_reveal_child (_tmp8_, _tmp10_);
	_tmp11_ = self->priv->storage_levelbar;
	_tmp12_ = sidebar_abstract_mountable_row_get_is_mounted (self);
	_tmp13_ = _tmp12_;
	gtk_widget_set_visible ((GtkWidget*) _tmp11_, _tmp13_);
}

static void
sidebar_abstract_mountable_row_real_update_plugin_data (SidebarSidebarItemInterface* base,
                                                        FilesSidebarPluginItem* item)
{
	SidebarAbstractMountableRow * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (SidebarAbstractMountableRow*) base;
	g_return_if_fail (item != NULL);
	sidebar_abstract_mountable_row_sidebar_sidebar_item_interface_parent_iface->update_plugin_data ((SidebarSidebarItemInterface*) G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRow), item);
	_tmp0_ = files_sidebar_plugin_item_get_show_spinner (item);
	_tmp1_ = _tmp0_;
	sidebar_abstract_mountable_row_set_working (self, _tmp1_);
}

static void
sidebar_abstract_mountable_row_unmount_mount_data_free (gpointer _data)
{
	SidebarAbstractMountableRowUnmountMountData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SidebarAbstractMountableRowUnmountMountData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
sidebar_abstract_mountable_row_unmount_mount (SidebarAbstractMountableRow* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	SidebarAbstractMountableRowUnmountMountData* _data_;
	SidebarAbstractMountableRow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SidebarAbstractMountableRowUnmountMountData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sidebar_abstract_mountable_row_unmount_mount_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	sidebar_abstract_mountable_row_unmount_mount_co (_data_);
}

gboolean
sidebar_abstract_mountable_row_unmount_mount_finish (SidebarAbstractMountableRow* self,
                                                     GAsyncResult* _res_)
{
	gboolean result;
	SidebarAbstractMountableRowUnmountMountData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
sidebar_abstract_mountable_row_unmount_mount_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	SidebarAbstractMountableRowUnmountMountData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	sidebar_abstract_mountable_row_unmount_mount_co (_data_);
}

static gboolean
sidebar_abstract_mountable_row_unmount_mount_co (SidebarAbstractMountableRowUnmountMountData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp2_ = sidebar_abstract_mountable_row_get_working (_data_->self);
	_data_->_tmp3_ = _data_->_tmp2_;
	if (_data_->_tmp3_) {
		_data_->_tmp1_ = TRUE;
	} else {
		_data_->_tmp1_ = !_data_->self->valid;
	}
	if (_data_->_tmp1_) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp4_ = sidebar_sidebar_item_interface_get_permanent ((SidebarSidebarItemInterface*) _data_->self);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp0_ = _data_->_tmp5_;
	}
	if (_data_->_tmp0_) {
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	sidebar_abstract_mountable_row_set_working (_data_->self, TRUE);
	_data_->_tmp6_ = _data_->self->priv->_mount;
	_data_->_tmp7_ = files_get_active_window ();
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_state_ = 1;
	marlin_file_operations_unmount_mount (_data_->_tmp6_, _data_->_tmp8_, sidebar_abstract_mountable_row_unmount_mount_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp9_ = marlin_file_operations_unmount_mount_finish (_data_->_res_);
	_g_object_unref0 (_data_->_tmp8_);
	_data_->success = _data_->_tmp9_;
	sidebar_abstract_mountable_row_set_working (_data_->self, FALSE);
	sidebar_abstract_mountable_row_update_visibilities (_data_->self);
	_data_->result = _data_->success;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
sidebar_abstract_mountable_row_eject_mount_data_free (gpointer _data)
{
	SidebarAbstractMountableRowEjectMountData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SidebarAbstractMountableRowEjectMountData, _data_);
}

void
sidebar_abstract_mountable_row_eject_mount (SidebarAbstractMountableRow* self,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	SidebarAbstractMountableRowEjectMountData* _data_;
	SidebarAbstractMountableRow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SidebarAbstractMountableRowEjectMountData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sidebar_abstract_mountable_row_eject_mount_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	sidebar_abstract_mountable_row_eject_mount_co (_data_);
}

gboolean
sidebar_abstract_mountable_row_eject_mount_finish (SidebarAbstractMountableRow* self,
                                                   GAsyncResult* _res_)
{
	gboolean result;
	SidebarAbstractMountableRowEjectMountData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
sidebar_abstract_mountable_row_eject_mount_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	SidebarAbstractMountableRowEjectMountData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	sidebar_abstract_mountable_row_eject_mount_co (_data_);
}

static gboolean
sidebar_abstract_mountable_row_eject_mount_co (SidebarAbstractMountableRowEjectMountData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp2_ = sidebar_abstract_mountable_row_get_working (_data_->self);
	_data_->_tmp3_ = _data_->_tmp2_;
	if (_data_->_tmp3_) {
		_data_->_tmp1_ = TRUE;
	} else {
		_data_->_tmp1_ = !_data_->self->valid;
	}
	if (_data_->_tmp1_) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp4_ = sidebar_sidebar_item_interface_get_permanent ((SidebarSidebarItemInterface*) _data_->self);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp0_ = _data_->_tmp5_;
	}
	if (_data_->_tmp0_) {
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	sidebar_abstract_mountable_row_set_working (_data_->self, TRUE);
	_data_->_tmp6_ = _data_->self->priv->_mount;
	_data_->_tmp7_ = files_get_active_window ();
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_state_ = 1;
	marlin_file_operations_eject_mount (_data_->_tmp6_, _data_->_tmp8_, sidebar_abstract_mountable_row_eject_mount_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp9_ = marlin_file_operations_eject_mount_finish (_data_->_res_);
	_g_object_unref0 (_data_->_tmp8_);
	_data_->success = _data_->_tmp9_;
	sidebar_abstract_mountable_row_set_working (_data_->self, FALSE);
	sidebar_abstract_mountable_row_update_visibilities (_data_->self);
	_data_->result = _data_->success;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
sidebar_abstract_mountable_row_safely_remove_drive_data_free (gpointer _data)
{
	SidebarAbstractMountableRowSafelyRemoveDriveData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SidebarAbstractMountableRowSafelyRemoveDriveData, _data_);
}

void
sidebar_abstract_mountable_row_safely_remove_drive (SidebarAbstractMountableRow* self,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_)
{
	SidebarAbstractMountableRowSafelyRemoveDriveData* _data_;
	SidebarAbstractMountableRow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SidebarAbstractMountableRowSafelyRemoveDriveData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sidebar_abstract_mountable_row_safely_remove_drive_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	sidebar_abstract_mountable_row_safely_remove_drive_co (_data_);
}

void
sidebar_abstract_mountable_row_safely_remove_drive_finish (SidebarAbstractMountableRow* self,
                                                           GAsyncResult* _res_)
{
	SidebarAbstractMountableRowSafelyRemoveDriveData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static void
sidebar_abstract_mountable_row_safely_remove_drive_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_)
{
	SidebarAbstractMountableRowSafelyRemoveDriveData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	sidebar_abstract_mountable_row_safely_remove_drive_co (_data_);
}

static gboolean
sidebar_abstract_mountable_row_safely_remove_drive_co (SidebarAbstractMountableRowSafelyRemoveDriveData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp2_ = sidebar_abstract_mountable_row_get_working (_data_->self);
	_data_->_tmp3_ = _data_->_tmp2_;
	if (_data_->_tmp3_) {
		_data_->_tmp1_ = TRUE;
	} else {
		_data_->_tmp1_ = !_data_->self->valid;
	}
	if (_data_->_tmp1_) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp4_ = _data_->self->priv->_drive;
		_data_->_tmp0_ = _data_->_tmp4_ == NULL;
	}
	if (_data_->_tmp0_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->self->priv->_drive;
	_data_->_tmp6_ = g_drive_get_name (_data_->_tmp5_);
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp8_ = _data_->self->priv->_drive;
	_data_->_tmp9_ = bool_to_string (g_drive_can_eject (_data_->_tmp8_));
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = _data_->self->priv->_drive;
	_data_->_tmp12_ = bool_to_string (g_drive_can_stop (_data_->_tmp11_));
	_data_->_tmp13_ = _data_->_tmp12_;
	_data_->_tmp14_ = _data_->self->priv->_drive;
	_data_->_tmp15_ = bool_to_string (g_drive_can_start (_data_->_tmp14_));
	_data_->_tmp16_ = _data_->_tmp15_;
	_data_->_tmp17_ = _data_->self->priv->_drive;
	_data_->_tmp18_ = bool_to_string (g_drive_can_start_degraded (_data_->_tmp17_));
	_data_->_tmp19_ = _data_->_tmp18_;
	_data_->_tmp20_ = _data_->self->priv->_drive;
	_data_->_tmp21_ = bool_to_string (g_drive_is_media_removable (_data_->_tmp20_));
	_data_->_tmp22_ = _data_->_tmp21_;
	_data_->_tmp23_ = _data_->self->priv->_drive;
	_data_->_tmp24_ = bool_to_string (g_drive_is_removable (_data_->_tmp23_));
	_data_->_tmp25_ = _data_->_tmp24_;
	g_debug ("AbstractMountableRow.vala:235: Eject/stop drive %s: can_eject %s, can_" \
"stop %s, can start %s, can start degraded %s, media_removable %s, driv" \
"e removable %s", _data_->_tmp7_, _data_->_tmp10_, _data_->_tmp13_, _data_->_tmp16_, _data_->_tmp19_, _data_->_tmp22_, _data_->_tmp25_);
	_g_free0 (_data_->_tmp25_);
	_g_free0 (_data_->_tmp22_);
	_g_free0 (_data_->_tmp19_);
	_g_free0 (_data_->_tmp16_);
	_g_free0 (_data_->_tmp13_);
	_g_free0 (_data_->_tmp10_);
	_g_free0 (_data_->_tmp7_);
	sidebar_abstract_mountable_row_set_working (_data_->self, TRUE);
	_data_->_tmp26_ = _data_->self->priv->_drive;
	_data_->_tmp27_ = files_get_active_window ();
	_data_->_tmp28_ = _data_->_tmp27_;
	_data_->_state_ = 1;
	marlin_file_operations_safely_remove_drive (_data_->_tmp26_, _data_->_tmp28_, sidebar_abstract_mountable_row_safely_remove_drive_ready, _data_);
	return FALSE;
	_state_1:
	marlin_file_operations_safely_remove_drive_finish (_data_->_res_);
	_g_object_unref0 (_data_->_tmp28_);
	sidebar_abstract_mountable_row_set_working (_data_->self, FALSE);
	sidebar_abstract_mountable_row_update_visibilities (_data_->self);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
sidebar_abstract_mountable_row_eject_drive_data_free (gpointer _data)
{
	SidebarAbstractMountableRowEjectDriveData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SidebarAbstractMountableRowEjectDriveData, _data_);
}

void
sidebar_abstract_mountable_row_eject_drive (SidebarAbstractMountableRow* self,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	SidebarAbstractMountableRowEjectDriveData* _data_;
	SidebarAbstractMountableRow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SidebarAbstractMountableRowEjectDriveData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sidebar_abstract_mountable_row_eject_drive_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	sidebar_abstract_mountable_row_eject_drive_co (_data_);
}

void
sidebar_abstract_mountable_row_eject_drive_finish (SidebarAbstractMountableRow* self,
                                                   GAsyncResult* _res_)
{
	SidebarAbstractMountableRowEjectDriveData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
sidebar_abstract_mountable_row_eject_drive_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	SidebarAbstractMountableRowEjectDriveData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	sidebar_abstract_mountable_row_eject_drive_co (_data_);
}

static gboolean
sidebar_abstract_mountable_row_eject_drive_co (SidebarAbstractMountableRowEjectDriveData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp2_ = sidebar_abstract_mountable_row_get_working (_data_->self);
	_data_->_tmp3_ = _data_->_tmp2_;
	if (_data_->_tmp3_) {
		_data_->_tmp1_ = TRUE;
	} else {
		_data_->_tmp1_ = !_data_->self->valid;
	}
	if (_data_->_tmp1_) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp4_ = _data_->self->priv->_drive;
		_data_->_tmp0_ = _data_->_tmp4_ == NULL;
	}
	if (_data_->_tmp0_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	sidebar_abstract_mountable_row_set_working (_data_->self, TRUE);
	_data_->_tmp5_ = _data_->self->priv->_drive;
	_data_->_tmp6_ = files_get_active_window ();
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_state_ = 1;
	marlin_file_operations_eject_drive (_data_->_tmp5_, _data_->_tmp7_, sidebar_abstract_mountable_row_eject_drive_ready, _data_);
	return FALSE;
	_state_1:
	marlin_file_operations_eject_drive_finish (_data_->_res_);
	_g_object_unref0 (_data_->_tmp7_);
	sidebar_abstract_mountable_row_set_working (_data_->self, FALSE);
	sidebar_abstract_mountable_row_update_visibilities (_data_->self);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
sidebar_abstract_mountable_row_add_extra_menu_items_for_mount (SidebarAbstractMountableRow* self,
                                                               GMount* mount,
                                                               GMenu* menu)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	GMenu* properties_section = NULL;
	GMenu* _tmp6_;
	GMenu* _tmp7_;
	GMenu* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	_tmp0_ = sidebar_abstract_mountable_row_get_working (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	if (mount != NULL) {
		GMenu* menu_section = NULL;
		GMenu* _tmp2_;
		GMenu* _tmp5_;
		_tmp2_ = g_menu_new ();
		menu_section = _tmp2_;
		if (marlin_file_operations_has_trash_files (mount)) {
			GMenu* _tmp3_;
			_tmp3_ = menu_section;
			g_menu_append (_tmp3_, _ ("Permanently Delete Trash on this Mount"), "mountable.empty-trash");
		}
		if (g_mount_can_unmount (mount)) {
			GMenu* _tmp4_;
			_tmp4_ = menu_section;
			g_menu_append (_tmp4_, _ ("_Unmount"), "mountable.unmount");
		}
		_tmp5_ = menu_section;
		g_menu_append_section (menu, NULL, (GMenuModel*) _tmp5_);
		_g_object_unref0 (menu_section);
	}
	_tmp6_ = g_menu_new ();
	properties_section = _tmp6_;
	_tmp7_ = properties_section;
	g_menu_append (_tmp7_, _ ("Properties"), "mountable.properties");
	_tmp8_ = properties_section;
	g_menu_append_section (menu, NULL, (GMenuModel*) _tmp8_);
	_g_object_unref0 (properties_section);
}

static void
sidebar_abstract_mountable_row_get_filesystem_space_for_root_data_free (gpointer _data)
{
	SidebarAbstractMountableRowGetFilesystemSpaceForRootData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->root);
	_g_object_unref0 (_data_->update_cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SidebarAbstractMountableRowGetFilesystemSpaceForRootData, _data_);
}

void
sidebar_abstract_mountable_row_get_filesystem_space_for_root (SidebarAbstractMountableRow* self,
                                                              GFile* root,
                                                              GCancellable* update_cancellable,
                                                              GAsyncReadyCallback _callback_,
                                                              gpointer _user_data_)
{
	SidebarAbstractMountableRowGetFilesystemSpaceForRootData* _data_;
	SidebarAbstractMountableRow* _tmp0_;
	GFile* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (root != NULL);
	_data_ = g_slice_new0 (SidebarAbstractMountableRowGetFilesystemSpaceForRootData);
	_data_->_async_result = g_task_new (G_OBJECT (self), update_cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sidebar_abstract_mountable_row_get_filesystem_space_for_root_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (root);
	_g_object_unref0 (_data_->root);
	_data_->root = _tmp1_;
	_tmp2_ = _g_object_ref0 (update_cancellable);
	_g_object_unref0 (_data_->update_cancellable);
	_data_->update_cancellable = _tmp2_;
	sidebar_abstract_mountable_row_get_filesystem_space_for_root_co (_data_);
}

gboolean
sidebar_abstract_mountable_row_get_filesystem_space_for_root_finish (SidebarAbstractMountableRow* self,
                                                                     GAsyncResult* _res_)
{
	gboolean result;
	SidebarAbstractMountableRowGetFilesystemSpaceForRootData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
sidebar_abstract_mountable_row_get_filesystem_space_for_root_ready (GObject* source_object,
                                                                    GAsyncResult* _res_,
                                                                    gpointer _user_data_)
{
	SidebarAbstractMountableRowGetFilesystemSpaceForRootData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	sidebar_abstract_mountable_row_get_filesystem_space_for_root_co (_data_);
}

static gboolean
sidebar_abstract_mountable_row_get_filesystem_space_for_root_co (SidebarAbstractMountableRowGetFilesystemSpaceForRootData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->self->priv->storage_capacity = (gdouble) 0;
	_data_->self->priv->storage_free = (gdouble) 0;
	_data_->_tmp0_ = sidebar_sidebar_item_interface_get_uri ((SidebarSidebarItemInterface*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = g_uri_parse_scheme (_data_->_tmp1_);
	_data_->scheme = _data_->_tmp2_;
	_data_->_tmp4_ = _data_->scheme;
	if (_data_->_tmp4_ == NULL) {
		_data_->_tmp3_ = TRUE;
	} else {
		_data_->_tmp5_ = _data_->scheme;
		_data_->_tmp3_ = string_contains ("sftp davs", _data_->_tmp5_);
	}
	if (_data_->_tmp3_) {
		_data_->result = FALSE;
		_g_free0 (_data_->scheme);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->scheme;
	if (string_contains ("smb afp", _data_->_tmp6_)) {
		_data_->_tmp7_ = g_network_monitor_get_default ();
		_data_->_tmp8_ = _g_object_ref0 (_data_->_tmp7_);
		_data_->net_mon = _data_->_tmp8_;
		_data_->_tmp9_ = _data_->net_mon;
		if (!g_network_monitor_get_network_available (_data_->_tmp9_)) {
			_data_->result = FALSE;
			_g_object_unref0 (_data_->net_mon);
			_g_free0 (_data_->scheme);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->net_mon);
	}
	{
		_data_->_state_ = 1;
		g_file_query_filesystem_info_async (_data_->root, "filesystem::*", 0, _data_->update_cancellable, sidebar_abstract_mountable_row_get_filesystem_space_for_root_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp11_ = g_file_query_filesystem_info_finish (_data_->root, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp10_ = _data_->_tmp11_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp12_ = _data_->_tmp10_;
		_data_->_tmp10_ = NULL;
		_g_object_unref0 (_data_->info);
		_data_->info = _data_->_tmp12_;
		_g_object_unref0 (_data_->_tmp10_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp13_ = _data_->_error_;
		if (!g_error_matches (_data_->_tmp13_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			_data_->_tmp14_ = g_file_get_uri (_data_->root);
			_data_->_tmp15_ = _data_->_tmp14_;
			_data_->_tmp16_ = _data_->_error_;
			_data_->_tmp17_ = _data_->_tmp16_->message;
			g_warning ("AbstractMountableRow.vala:305: Error querying filesystem info for '%s'" \
": %s", _data_->_tmp15_, _data_->_tmp17_);
			_g_free0 (_data_->_tmp15_);
		}
		_g_object_unref0 (_data_->info);
		_data_->info = NULL;
		_g_error_free0 (_data_->_error_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->info);
		_g_free0 (_data_->scheme);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (g_cancellable_is_cancelled (_data_->update_cancellable)) {
		_data_->_tmp18_ = TRUE;
	} else {
		_data_->_tmp19_ = _data_->info;
		_data_->_tmp18_ = _data_->_tmp19_ == NULL;
	}
	if (_data_->_tmp18_) {
		_data_->result = FALSE;
		_g_object_unref0 (_data_->info);
		_g_free0 (_data_->scheme);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp20_ = _data_->info;
		if (g_file_info_has_attribute (_data_->_tmp20_, G_FILE_ATTRIBUTE_FILESYSTEM_SIZE)) {
			_data_->_tmp21_ = _data_->info;
			_data_->self->priv->storage_capacity = (gdouble) g_file_info_get_attribute_uint64 (_data_->_tmp21_, G_FILE_ATTRIBUTE_FILESYSTEM_SIZE);
		}
		_data_->_tmp22_ = _data_->info;
		if (g_file_info_has_attribute (_data_->_tmp22_, G_FILE_ATTRIBUTE_FILESYSTEM_FREE)) {
			_data_->_tmp23_ = _data_->info;
			_data_->self->priv->storage_free = (gdouble) g_file_info_get_attribute_uint64 (_data_->_tmp23_, G_FILE_ATTRIBUTE_FILESYSTEM_FREE);
		}
		_data_->result = TRUE;
		_g_object_unref0 (_data_->info);
		_g_free0 (_data_->scheme);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
}

static void
sidebar_abstract_mountable_row_get_storage_text_data_free (gpointer _data)
{
	SidebarAbstractMountableRowGetStorageTextData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (SidebarAbstractMountableRowGetStorageTextData, _data_);
}

void
sidebar_abstract_mountable_row_get_storage_text (SidebarAbstractMountableRow* self,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	SidebarAbstractMountableRowGetStorageTextData* _data_;
	SidebarAbstractMountableRow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SidebarAbstractMountableRowGetStorageTextData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sidebar_abstract_mountable_row_get_storage_text_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	sidebar_abstract_mountable_row_get_storage_text_co (_data_);
}

gchar*
sidebar_abstract_mountable_row_get_storage_text_finish (SidebarAbstractMountableRow* self,
                                                        GAsyncResult* _res_)
{
	gchar* result;
	SidebarAbstractMountableRowGetStorageTextData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
sidebar_abstract_mountable_row_get_storage_text_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_)
{
	SidebarAbstractMountableRowGetStorageTextData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	sidebar_abstract_mountable_row_get_storage_text_co (_data_);
}

static gboolean
sidebar_abstract_mountable_row_get_storage_text_co (SidebarAbstractMountableRowGetStorageTextData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_strdup ("");
	_data_->storage_text = _data_->_tmp0_;
	_data_->self->priv->storage_capacity = (gdouble) 0;
	_data_->_state_ = 1;
	sidebar_abstract_mountable_row_get_filesystem_space (_data_->self, NULL, sidebar_abstract_mountable_row_get_storage_text_ready, _data_);
	return FALSE;
	_state_1:
	if (sidebar_abstract_mountable_row_get_filesystem_space_finish (_data_->self, _data_->_res_)) {
		if (_data_->self->priv->storage_capacity > ((gdouble) 0)) {
			_data_->_tmp1_ = g_format_size_full ((guint64) _data_->self->priv->storage_free, G_FORMAT_SIZE_DEFAULT);
			_data_->_tmp2_ = _data_->_tmp1_;
			_data_->_tmp3_ = g_strdup_printf (_ ("%s free"), _data_->_tmp2_);
			_data_->_tmp4_ = _data_->_tmp3_;
			_g_free0 (_data_->_tmp2_);
			_data_->used_string = _data_->_tmp4_;
			_data_->_tmp5_ = g_format_size_full ((guint64) (_data_->self->priv->storage_capacity - _data_->self->priv->storage_free), G_FORMAT_SIZE_DEFAULT);
			_data_->_tmp6_ = _data_->_tmp5_;
			_data_->_tmp7_ = g_format_size_full ((guint64) _data_->self->priv->storage_capacity, G_FORMAT_SIZE_DEFAULT);
			_data_->_tmp8_ = _data_->_tmp7_;
			_data_->_tmp9_ = g_strdup_printf (_ ("%s used of %s"), _data_->_tmp6_, _data_->_tmp8_);
			_data_->_tmp10_ = _data_->_tmp9_;
			_g_free0 (_data_->_tmp8_);
			_g_free0 (_data_->_tmp6_);
			_data_->size_string = _data_->_tmp10_;
			_data_->_tmp11_ = _data_->used_string;
			_data_->_tmp12_ = _data_->size_string;
			_data_->_tmp13_ = g_strdup_printf ("\n%s\n<span weight=\"600\" size=\"smaller\" alpha=\"75%\">%s</span>", _data_->_tmp11_, _data_->_tmp12_);
			_g_free0 (_data_->storage_text);
			_data_->storage_text = _data_->_tmp13_;
			_data_->_tmp14_ = _data_->self->priv->storage_levelbar;
			gtk_level_bar_set_value (_data_->_tmp14_, (_data_->self->priv->storage_capacity - _data_->self->priv->storage_free) / _data_->self->priv->storage_capacity);
			_data_->_tmp15_ = _data_->self->priv->storage_levelbar;
			gtk_widget_show ((GtkWidget*) _data_->_tmp15_);
			_g_free0 (_data_->size_string);
			_g_free0 (_data_->used_string);
		}
	}
	if (_data_->self->priv->storage_capacity == ((gdouble) 0)) {
		_data_->_tmp16_ = _data_->self->priv->storage_levelbar;
		gtk_widget_hide ((GtkWidget*) _data_->_tmp16_);
	}
	_data_->result = _data_->storage_text;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
sidebar_abstract_mountable_row_real_update_free_space (SidebarAbstractMountableRow* self)
{
	sidebar_abstract_mountable_row_add_mountable_tooltip (self, NULL, NULL);
}

void
sidebar_abstract_mountable_row_update_free_space (SidebarAbstractMountableRow* self)
{
	SidebarAbstractMountableRowClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SIDEBAR_ABSTRACT_MOUNTABLE_ROW_GET_CLASS (self);
	if (_klass_->update_free_space) {
		_klass_->update_free_space (self);
	}
}

static void
sidebar_abstract_mountable_row_real_add_mountable_tooltip_data_free (gpointer _data)
{
	SidebarAbstractMountableRowAddMountableTooltipData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SidebarAbstractMountableRowAddMountableTooltipData, _data_);
}

static void
sidebar_abstract_mountable_row_real_add_mountable_tooltip (SidebarAbstractMountableRow* self,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_)
{
	SidebarAbstractMountableRowAddMountableTooltipData* _data_;
	SidebarAbstractMountableRow* _tmp0_;
	_data_ = g_slice_new0 (SidebarAbstractMountableRowAddMountableTooltipData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sidebar_abstract_mountable_row_real_add_mountable_tooltip_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	sidebar_abstract_mountable_row_real_add_mountable_tooltip_co (_data_);
}

static void
sidebar_abstract_mountable_row_real_add_mountable_tooltip_finish (SidebarAbstractMountableRow* self,
                                                                  GAsyncResult* _res_)
{
	SidebarAbstractMountableRowAddMountableTooltipData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
sidebar_abstract_mountable_row_add_mountable_tooltip_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_)
{
	SidebarAbstractMountableRowAddMountableTooltipData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	sidebar_abstract_mountable_row_real_add_mountable_tooltip_co (_data_);
}

static gboolean
sidebar_abstract_mountable_row_real_add_mountable_tooltip_co (SidebarAbstractMountableRowAddMountableTooltipData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	sidebar_abstract_mountable_row_get_storage_text (_data_->self, sidebar_abstract_mountable_row_add_mountable_tooltip_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = sidebar_abstract_mountable_row_get_storage_text_finish (_data_->self, _data_->_res_);
	_data_->storage_text = _data_->_tmp0_;
	_data_->_tmp1_ = sidebar_sidebar_item_interface_get_uri ((SidebarSidebarItemInterface*) _data_->self);
	_data_->_tmp2_ = _data_->_tmp1_;
	if (g_strcmp0 (_data_->_tmp2_, "") != 0) {
		_data_->_tmp3_ = sidebar_sidebar_item_interface_get_uri ((SidebarSidebarItemInterface*) _data_->self);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = files_file_utils_sanitize_path (_data_->_tmp4_, NULL, FALSE);
		_g_free0 (_data_->mount_text);
		_data_->mount_text = _data_->_tmp5_;
	} else {
		_data_->_tmp6_ = sidebar_sidebar_item_interface_get_custom_name ((SidebarSidebarItemInterface*) _data_->self);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp8_ = g_strdup_printf (_ ("%s (%s)"), _data_->_tmp7_, _ ("Not mounted"));
		_g_free0 (_data_->mount_text);
		_data_->mount_text = _data_->_tmp8_;
	}
	_data_->_tmp9_ = _data_->mount_text;
	_data_->_tmp10_ = _data_->storage_text;
	_data_->_tmp11_ = g_strconcat (_data_->_tmp9_, _data_->_tmp10_, NULL);
	_data_->_tmp12_ = _data_->_tmp11_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _data_->self, _data_->_tmp12_);
	_g_free0 (_data_->_tmp12_);
	_g_free0 (_data_->mount_text);
	_g_free0 (_data_->storage_text);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
sidebar_abstract_mountable_row_add_mountable_tooltip (SidebarAbstractMountableRow* self,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_)
{
	SidebarAbstractMountableRowClass* _klass_;
	_klass_ = SIDEBAR_ABSTRACT_MOUNTABLE_ROW_GET_CLASS (self);
	if (_klass_->add_mountable_tooltip) {
		_klass_->add_mountable_tooltip (self, _callback_, _user_data_);
	}
}

void
sidebar_abstract_mountable_row_add_mountable_tooltip_finish (SidebarAbstractMountableRow* self,
                                                             GAsyncResult* _res_)
{
	SidebarAbstractMountableRowClass* _klass_;
	_klass_ = SIDEBAR_ABSTRACT_MOUNTABLE_ROW_GET_CLASS (self);
	if (_klass_->add_mountable_tooltip_finish) {
		_klass_->add_mountable_tooltip_finish (self, _res_);
	}
}

static void
sidebar_abstract_mountable_row_real_on_mount_removed (SidebarAbstractMountableRow* self,
                                                      GMount* removed_mount)
{
	g_return_if_fail (removed_mount != NULL);
}

void
sidebar_abstract_mountable_row_on_mount_removed (SidebarAbstractMountableRow* self,
                                                 GMount* removed_mount)
{
	SidebarAbstractMountableRowClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SIDEBAR_ABSTRACT_MOUNTABLE_ROW_GET_CLASS (self);
	if (_klass_->on_mount_removed) {
		_klass_->on_mount_removed (self, removed_mount);
	}
}

static void
sidebar_abstract_mountable_row_real_on_mount_added (SidebarAbstractMountableRow* self,
                                                    GMount* added_mount)
{
	g_return_if_fail (added_mount != NULL);
}

void
sidebar_abstract_mountable_row_on_mount_added (SidebarAbstractMountableRow* self,
                                               GMount* added_mount)
{
	SidebarAbstractMountableRowClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SIDEBAR_ABSTRACT_MOUNTABLE_ROW_GET_CLASS (self);
	if (_klass_->on_mount_added) {
		_klass_->on_mount_added (self, added_mount);
	}
}

static void
sidebar_abstract_mountable_row_real_show_mount_info (SidebarAbstractMountableRow* self)
{
}

void
sidebar_abstract_mountable_row_show_mount_info (SidebarAbstractMountableRow* self)
{
	SidebarAbstractMountableRowClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SIDEBAR_ABSTRACT_MOUNTABLE_ROW_GET_CLASS (self);
	if (_klass_->show_mount_info) {
		_klass_->show_mount_info (self);
	}
}

static void
sidebar_abstract_mountable_row_real_get_filesystem_space_data_free (gpointer _data)
{
	SidebarAbstractMountableRowGetFilesystemSpaceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->update_cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SidebarAbstractMountableRowGetFilesystemSpaceData, _data_);
}

static void
sidebar_abstract_mountable_row_real_get_filesystem_space (SidebarAbstractMountableRow* self,
                                                          GCancellable* update_cancellable,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_)
{
	SidebarAbstractMountableRowGetFilesystemSpaceData* _data_;
	SidebarAbstractMountableRow* _tmp0_;
	GCancellable* _tmp1_;
	_data_ = g_slice_new0 (SidebarAbstractMountableRowGetFilesystemSpaceData);
	_data_->_async_result = g_task_new (G_OBJECT (self), update_cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sidebar_abstract_mountable_row_real_get_filesystem_space_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (update_cancellable);
	_g_object_unref0 (_data_->update_cancellable);
	_data_->update_cancellable = _tmp1_;
	sidebar_abstract_mountable_row_real_get_filesystem_space_co (_data_);
}

static gboolean
sidebar_abstract_mountable_row_real_get_filesystem_space_finish (SidebarAbstractMountableRow* self,
                                                                 GAsyncResult* _res_)
{
	gboolean result;
	SidebarAbstractMountableRowGetFilesystemSpaceData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static gboolean
sidebar_abstract_mountable_row_real_get_filesystem_space_co (SidebarAbstractMountableRowGetFilesystemSpaceData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->result = FALSE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
sidebar_abstract_mountable_row_get_filesystem_space (SidebarAbstractMountableRow* self,
                                                     GCancellable* update_cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_)
{
	SidebarAbstractMountableRowClass* _klass_;
	_klass_ = SIDEBAR_ABSTRACT_MOUNTABLE_ROW_GET_CLASS (self);
	if (_klass_->get_filesystem_space) {
		_klass_->get_filesystem_space (self, update_cancellable, _callback_, _user_data_);
	}
}

gboolean
sidebar_abstract_mountable_row_get_filesystem_space_finish (SidebarAbstractMountableRow* self,
                                                            GAsyncResult* _res_)
{
	SidebarAbstractMountableRowClass* _klass_;
	_klass_ = SIDEBAR_ABSTRACT_MOUNTABLE_ROW_GET_CLASS (self);
	if (_klass_->get_filesystem_space_finish) {
		return _klass_->get_filesystem_space_finish (self, _res_);
	}
	return FALSE;
}

const gchar*
sidebar_abstract_mountable_row_get_sort_key (SidebarAbstractMountableRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sort_key;
	result = _tmp0_;
	return result;
}

void
sidebar_abstract_mountable_row_set_sort_key (SidebarAbstractMountableRow* self,
                                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sidebar_abstract_mountable_row_get_sort_key (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_sort_key);
		self->priv->_sort_key = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sidebar_abstract_mountable_row_properties[SIDEBAR_ABSTRACT_MOUNTABLE_ROW_SORT_KEY_PROPERTY]);
	}
}

GMount*
sidebar_abstract_mountable_row_get_mount (SidebarAbstractMountableRow* self)
{
	GMount* result;
	GMount* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mount;
	result = _tmp0_;
	return result;
}

void
sidebar_abstract_mountable_row_set_mount (SidebarAbstractMountableRow* self,
                                          GMount* value)
{
	GMount* old_value;
	g_return_if_fail (self != NULL);
	old_value = sidebar_abstract_mountable_row_get_mount (self);
	if (old_value != value) {
		GMount* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_mount);
		self->priv->_mount = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sidebar_abstract_mountable_row_properties[SIDEBAR_ABSTRACT_MOUNTABLE_ROW_MOUNT_PROPERTY]);
	}
}

GDrive*
sidebar_abstract_mountable_row_get_drive (SidebarAbstractMountableRow* self)
{
	GDrive* result;
	GDrive* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_drive;
	result = _tmp0_;
	return result;
}

static void
sidebar_abstract_mountable_row_set_drive (SidebarAbstractMountableRow* self,
                                          GDrive* value)
{
	GDrive* old_value;
	g_return_if_fail (self != NULL);
	old_value = sidebar_abstract_mountable_row_get_drive (self);
	if (old_value != value) {
		GDrive* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_drive);
		self->priv->_drive = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sidebar_abstract_mountable_row_properties[SIDEBAR_ABSTRACT_MOUNTABLE_ROW_DRIVE_PROPERTY]);
	}
}

const gchar*
sidebar_abstract_mountable_row_get_uuid (SidebarAbstractMountableRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uuid;
	result = _tmp0_;
	return result;
}

void
sidebar_abstract_mountable_row_set_uuid (SidebarAbstractMountableRow* self,
                                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sidebar_abstract_mountable_row_get_uuid (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uuid);
		self->priv->_uuid = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sidebar_abstract_mountable_row_properties[SIDEBAR_ABSTRACT_MOUNTABLE_ROW_UUID_PROPERTY]);
	}
}

gboolean
sidebar_abstract_mountable_row_get_is_mounted (SidebarAbstractMountableRow* self)
{
	SidebarAbstractMountableRowClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = SIDEBAR_ABSTRACT_MOUNTABLE_ROW_GET_CLASS (self);
	if (_klass_->get_is_mounted) {
		return _klass_->get_is_mounted (self);
	}
	return FALSE;
}

static gboolean
sidebar_abstract_mountable_row_real_get_is_mounted (SidebarAbstractMountableRow* base)
{
	gboolean result;
	SidebarAbstractMountableRow* self;
	GMount* _tmp0_;
	self = base;
	_tmp0_ = self->priv->_mount;
	result = _tmp0_ != NULL;
	return result;
}

gboolean
sidebar_abstract_mountable_row_get_can_unmount (SidebarAbstractMountableRow* self)
{
	SidebarAbstractMountableRowClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = SIDEBAR_ABSTRACT_MOUNTABLE_ROW_GET_CLASS (self);
	if (_klass_->get_can_unmount) {
		return _klass_->get_can_unmount (self);
	}
	return FALSE;
}

static gboolean
sidebar_abstract_mountable_row_real_get_can_unmount (SidebarAbstractMountableRow* base)
{
	gboolean result;
	SidebarAbstractMountableRow* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = base;
	_tmp1_ = sidebar_abstract_mountable_row_get_is_mounted (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GMount* _tmp3_;
		_tmp3_ = self->priv->_mount;
		_tmp0_ = g_mount_can_unmount (_tmp3_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
sidebar_abstract_mountable_row_get_can_eject (SidebarAbstractMountableRow* self)
{
	SidebarAbstractMountableRowClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = SIDEBAR_ABSTRACT_MOUNTABLE_ROW_GET_CLASS (self);
	if (_klass_->get_can_eject) {
		return _klass_->get_can_eject (self);
	}
	return FALSE;
}

static gboolean
sidebar_abstract_mountable_row_real_get_can_eject (SidebarAbstractMountableRow* base)
{
	gboolean result;
	SidebarAbstractMountableRow* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = base;
	_tmp1_ = sidebar_abstract_mountable_row_get_is_mounted (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GMount* _tmp3_;
		_tmp3_ = self->priv->_mount;
		_tmp0_ = g_mount_can_eject (_tmp3_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
sidebar_abstract_mountable_row_get_working (SidebarAbstractMountableRow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_working;
	return result;
}

void
sidebar_abstract_mountable_row_set_working (SidebarAbstractMountableRow* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	if (!self->valid) {
		return;
	}
	self->priv->_working = value;
	if (value) {
		GtkSpinner* _tmp0_;
		GtkStack* _tmp1_;
		GtkSpinner* _tmp2_;
		_tmp0_ = self->priv->working_spinner;
		gtk_spinner_start (_tmp0_);
		_tmp1_ = self->priv->unmount_eject_working_stack;
		_tmp2_ = self->priv->working_spinner;
		gtk_stack_set_visible_child (_tmp1_, (GtkWidget*) _tmp2_);
	} else {
		GtkStack* _tmp3_;
		GtkRevealer* _tmp4_;
		GtkSpinner* _tmp5_;
		_tmp3_ = self->priv->unmount_eject_working_stack;
		_tmp4_ = self->priv->unmount_eject_revealer;
		gtk_stack_set_visible_child (_tmp3_, (GtkWidget*) _tmp4_);
		_tmp5_ = self->priv->working_spinner;
		gtk_spinner_stop (_tmp5_);
	}
	g_object_notify_by_pspec ((GObject *) self, sidebar_abstract_mountable_row_properties[SIDEBAR_ABSTRACT_MOUNTABLE_ROW_WORKING_PROPERTY]);
}

static void
_sidebar_abstract_mountable_row_on_mount_removed_g_volume_monitor_mount_removed (GVolumeMonitor* _sender,
                                                                                 GMount* mount,
                                                                                 gpointer self)
{
	sidebar_abstract_mountable_row_on_mount_removed ((SidebarAbstractMountableRow*) self, mount);
}

static void
_sidebar_abstract_mountable_row_on_mount_added_g_volume_monitor_mount_added (GVolumeMonitor* _sender,
                                                                             GMount* mount,
                                                                             gpointer self)
{
	sidebar_abstract_mountable_row_on_mount_added ((SidebarAbstractMountableRow*) self, mount);
}

static void
_sidebar_abstract_mountable_row___lambda175_ (SidebarAbstractMountableRow* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	_tmp0_ = sidebar_abstract_mountable_row_get_can_eject (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		sidebar_abstract_mountable_row_eject_mount (self, NULL, NULL);
	} else {
		sidebar_abstract_mountable_row_unmount_mount (self, NULL, NULL);
	}
}

static void
__sidebar_abstract_mountable_row___lambda175__gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self)
{
	_sidebar_abstract_mountable_row___lambda175_ ((SidebarAbstractMountableRow*) self);
}

static void
_sidebar_abstract_mountable_row___lambda176_ (SidebarAbstractMountableRow* self)
{
	sidebar_abstract_mountable_row_safely_remove_drive (self, NULL, NULL);
}

static void
__sidebar_abstract_mountable_row___lambda176__g_simple_action_activate (GSimpleAction* _sender,
                                                                        GVariant* parameter,
                                                                        gpointer self)
{
	_sidebar_abstract_mountable_row___lambda176_ ((SidebarAbstractMountableRow*) self);
}

static void
_sidebar_abstract_mountable_row___lambda177_ (SidebarAbstractMountableRow* self)
{
	sidebar_abstract_mountable_row_eject_drive (self, NULL, NULL);
}

static void
__sidebar_abstract_mountable_row___lambda177__g_simple_action_activate (GSimpleAction* _sender,
                                                                        GVariant* parameter,
                                                                        gpointer self)
{
	_sidebar_abstract_mountable_row___lambda177_ ((SidebarAbstractMountableRow*) self);
}

static void
_sidebar_abstract_mountable_row_show_mount_info_g_simple_action_activate (GSimpleAction* _sender,
                                                                          GVariant* parameter,
                                                                          gpointer self)
{
	sidebar_abstract_mountable_row_show_mount_info ((SidebarAbstractMountableRow*) self);
}

static void
_sidebar_abstract_mountable_row___lambda178_ (SidebarAbstractMountableRow* self)
{
	sidebar_abstract_mountable_row_unmount_mount (self, NULL, NULL);
}

static void
__sidebar_abstract_mountable_row___lambda178__g_simple_action_activate (GSimpleAction* _sender,
                                                                        GVariant* parameter,
                                                                        gpointer self)
{
	_sidebar_abstract_mountable_row___lambda178_ ((SidebarAbstractMountableRow*) self);
}

static void
_sidebar_abstract_mountable_row___lambda179_ (SidebarAbstractMountableRow* self)
{
	GMount* _tmp0_;
	_tmp0_ = self->priv->_mount;
	marlin_file_operations_empty_trash_for_mount ((GtkWidget*) self, _tmp0_);
}

static void
__sidebar_abstract_mountable_row___lambda179__g_simple_action_activate (GSimpleAction* _sender,
                                                                        GVariant* parameter,
                                                                        gpointer self)
{
	_sidebar_abstract_mountable_row___lambda179_ ((SidebarAbstractMountableRow*) self);
}

static GObject *
sidebar_abstract_mountable_row_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SidebarAbstractMountableRow * self;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GtkButton* _tmp6_ = NULL;
	GtkButton* _tmp7_;
	GtkStyleContext* _tmp8_;
	GtkCssProvider* _tmp9_;
	GtkSpinner* _tmp10_;
	GtkButton* _tmp11_;
	GtkWidget* _tmp12_;
	GtkRevealer* _tmp13_ = NULL;
	GtkStack* _tmp14_ = NULL;
	GtkStack* _tmp15_;
	GtkRevealer* _tmp16_;
	GtkStack* _tmp17_;
	GtkSpinner* _tmp18_;
	GtkGrid* _tmp19_;
	GtkStack* _tmp20_;
	GtkLevelBar* _tmp21_ = NULL;
	GtkLevelBar* _tmp22_;
	GtkLevelBar* _tmp23_;
	GtkLevelBar* _tmp24_;
	GtkStyleContext* storage_style_context = NULL;
	GtkLevelBar* _tmp25_;
	GtkStyleContext* _tmp26_;
	GtkStyleContext* _tmp27_;
	GtkStyleContext* _tmp28_;
	GtkStyleContext* _tmp29_;
	GtkCssProvider* _tmp30_;
	GtkGrid* _tmp31_;
	GtkLevelBar* _tmp32_;
	GVolumeMonitor* _tmp33_;
	GVolumeMonitor* _tmp34_;
	GtkButton* _tmp35_;
	GSimpleAction* safely_remove_action = NULL;
	GSimpleAction* _tmp36_;
	GSimpleAction* _tmp37_;
	GSimpleAction* eject_action = NULL;
	GSimpleAction* _tmp38_;
	GSimpleAction* _tmp39_;
	GSimpleAction* properties_action = NULL;
	GSimpleAction* _tmp40_;
	GSimpleAction* _tmp41_;
	GSimpleAction* unmount_action = NULL;
	GSimpleAction* _tmp42_;
	GSimpleAction* _tmp43_;
	GSimpleAction* empty_trash_action = NULL;
	GSimpleAction* _tmp44_;
	GSimpleAction* _tmp45_;
	GSimpleActionGroup* action_group = NULL;
	GSimpleActionGroup* _tmp46_;
	GSimpleActionGroup* _tmp47_;
	GSimpleAction* _tmp48_;
	GSimpleActionGroup* _tmp49_;
	GSimpleAction* _tmp50_;
	GSimpleActionGroup* _tmp51_;
	GSimpleAction* _tmp52_;
	GSimpleActionGroup* _tmp53_;
	GSimpleAction* _tmp54_;
	GSimpleActionGroup* _tmp55_;
	GSimpleAction* _tmp56_;
	GSimpleActionGroup* _tmp57_;
	parent_class = G_OBJECT_CLASS (sidebar_abstract_mountable_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, SidebarAbstractMountableRow);
	_tmp1_ = sidebar_abstract_mountable_row_get_can_eject (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		_tmp0_ = _ ("Eject '%s'");
	} else {
		_tmp0_ = _ ("Unmount '%s'");
	}
	_tmp3_ = sidebar_sidebar_item_interface_get_custom_name ((SidebarSidebarItemInterface*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf (_tmp0_, _tmp4_);
	_tmp6_ = (GtkButton*) gtk_button_new_from_icon_name ("media-eject-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp6_, _tmp5_);
	_g_free0 (_tmp5_);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->unmount_eject_button);
	self->priv->unmount_eject_button = _tmp6_;
	_tmp7_ = self->priv->unmount_eject_button;
	_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) _tmp7_);
	_tmp9_ = sidebar_abstract_mountable_row_devicerow_provider;
	gtk_style_context_add_provider (_tmp8_, (GtkStyleProvider*) _tmp9_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp10_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->working_spinner);
	self->priv->working_spinner = _tmp10_;
	_tmp11_ = self->priv->unmount_eject_button;
	_tmp12_ = _g_object_ref0 ((GtkWidget*) _tmp11_);
	_tmp13_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_set ((GtkContainer*) _tmp13_, "child", _tmp12_, NULL);
	_g_object_unref0 (_tmp12_);
	gtk_revealer_set_transition_type (_tmp13_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_LEFT);
	gtk_widget_set_valign ((GtkWidget*) _tmp13_, GTK_ALIGN_CENTER);
	gtk_revealer_set_reveal_child (_tmp13_, FALSE);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->unmount_eject_revealer);
	self->priv->unmount_eject_revealer = _tmp13_;
	_tmp14_ = (GtkStack*) gtk_stack_new ();
	gtk_widget_set_margin_start ((GtkWidget*) _tmp14_, 6);
	gtk_stack_set_transition_type (_tmp14_, GTK_STACK_TRANSITION_TYPE_CROSSFADE);
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->unmount_eject_working_stack);
	self->priv->unmount_eject_working_stack = _tmp14_;
	_tmp15_ = self->priv->unmount_eject_working_stack;
	_tmp16_ = self->priv->unmount_eject_revealer;
	gtk_container_add ((GtkContainer*) _tmp15_, (GtkWidget*) _tmp16_);
	_tmp17_ = self->priv->unmount_eject_working_stack;
	_tmp18_ = self->priv->working_spinner;
	gtk_container_add ((GtkContainer*) _tmp17_, (GtkWidget*) _tmp18_);
	_tmp19_ = ((SidebarBookmarkRow*) self)->content_grid;
	_tmp20_ = self->priv->unmount_eject_working_stack;
	gtk_grid_attach (_tmp19_, (GtkWidget*) _tmp20_, 1, 0, 1, 1);
	_tmp21_ = (GtkLevelBar*) gtk_level_bar_new ();
	gtk_level_bar_set_value (_tmp21_, 0.5);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp21_, TRUE);
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp21_, TRUE);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->storage_levelbar);
	self->priv->storage_levelbar = _tmp21_;
	_tmp22_ = self->priv->storage_levelbar;
	gtk_level_bar_add_offset_value (_tmp22_, GTK_LEVEL_BAR_OFFSET_LOW, 0.9);
	_tmp23_ = self->priv->storage_levelbar;
	gtk_level_bar_add_offset_value (_tmp23_, GTK_LEVEL_BAR_OFFSET_HIGH, 0.95);
	_tmp24_ = self->priv->storage_levelbar;
	gtk_level_bar_add_offset_value (_tmp24_, GTK_LEVEL_BAR_OFFSET_FULL, (gdouble) 1);
	_tmp25_ = self->priv->storage_levelbar;
	_tmp26_ = gtk_widget_get_style_context ((GtkWidget*) _tmp25_);
	storage_style_context = _tmp26_;
	_tmp27_ = storage_style_context;
	gtk_style_context_add_class (_tmp27_, GTK_STYLE_CLASS_FLAT);
	_tmp28_ = storage_style_context;
	gtk_style_context_add_class (_tmp28_, "inverted");
	_tmp29_ = storage_style_context;
	_tmp30_ = sidebar_abstract_mountable_row_devicerow_provider;
	gtk_style_context_add_provider (_tmp29_, (GtkStyleProvider*) _tmp30_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp31_ = ((SidebarBookmarkRow*) self)->icon_label_grid;
	_tmp32_ = self->priv->storage_levelbar;
	gtk_grid_attach (_tmp31_, (GtkWidget*) _tmp32_, 1, 1, 1, 1);
	_tmp33_ = sidebar_abstract_mountable_row_volume_monitor;
	g_signal_connect_object (_tmp33_, "mount-removed", (GCallback) _sidebar_abstract_mountable_row_on_mount_removed_g_volume_monitor_mount_removed, self, 0);
	_tmp34_ = sidebar_abstract_mountable_row_volume_monitor;
	g_signal_connect_object (_tmp34_, "mount-added", (GCallback) _sidebar_abstract_mountable_row_on_mount_added_g_volume_monitor_mount_added, self, 0);
	_tmp35_ = self->priv->unmount_eject_button;
	g_signal_connect_object (_tmp35_, "clicked", (GCallback) __sidebar_abstract_mountable_row___lambda175__gtk_button_clicked, self, 0);
	gtk_widget_show_all ((GtkWidget*) self);
	sidebar_abstract_mountable_row_add_mountable_tooltip (self, NULL, NULL);
	sidebar_abstract_mountable_row_update_visibilities (self);
	_tmp36_ = g_simple_action_new ("safely-remove", NULL);
	safely_remove_action = _tmp36_;
	_tmp37_ = safely_remove_action;
	g_signal_connect_object (_tmp37_, "activate", (GCallback) __sidebar_abstract_mountable_row___lambda176__g_simple_action_activate, self, 0);
	_tmp38_ = g_simple_action_new ("eject", NULL);
	eject_action = _tmp38_;
	_tmp39_ = eject_action;
	g_signal_connect_object (_tmp39_, "activate", (GCallback) __sidebar_abstract_mountable_row___lambda177__g_simple_action_activate, self, 0);
	_tmp40_ = g_simple_action_new ("properties", NULL);
	properties_action = _tmp40_;
	_tmp41_ = properties_action;
	g_signal_connect_object (_tmp41_, "activate", (GCallback) _sidebar_abstract_mountable_row_show_mount_info_g_simple_action_activate, self, 0);
	_tmp42_ = g_simple_action_new ("unmount", NULL);
	unmount_action = _tmp42_;
	_tmp43_ = unmount_action;
	g_signal_connect_object (_tmp43_, "activate", (GCallback) __sidebar_abstract_mountable_row___lambda178__g_simple_action_activate, self, 0);
	_tmp44_ = g_simple_action_new ("empty-trash", NULL);
	empty_trash_action = _tmp44_;
	_tmp45_ = empty_trash_action;
	g_signal_connect_object (_tmp45_, "activate", (GCallback) __sidebar_abstract_mountable_row___lambda179__g_simple_action_activate, self, 0);
	_tmp46_ = g_simple_action_group_new ();
	action_group = _tmp46_;
	_tmp47_ = action_group;
	_tmp48_ = safely_remove_action;
	g_action_map_add_action ((GActionMap*) _tmp47_, (GAction*) _tmp48_);
	_tmp49_ = action_group;
	_tmp50_ = eject_action;
	g_action_map_add_action ((GActionMap*) _tmp49_, (GAction*) _tmp50_);
	_tmp51_ = action_group;
	_tmp52_ = properties_action;
	g_action_map_add_action ((GActionMap*) _tmp51_, (GAction*) _tmp52_);
	_tmp53_ = action_group;
	_tmp54_ = unmount_action;
	g_action_map_add_action ((GActionMap*) _tmp53_, (GAction*) _tmp54_);
	_tmp55_ = action_group;
	_tmp56_ = empty_trash_action;
	g_action_map_add_action ((GActionMap*) _tmp55_, (GAction*) _tmp56_);
	_tmp57_ = action_group;
	gtk_widget_insert_action_group ((GtkWidget*) self, "mountable", (GActionGroup*) _tmp57_);
	_g_object_unref0 (action_group);
	_g_object_unref0 (empty_trash_action);
	_g_object_unref0 (unmount_action);
	_g_object_unref0 (properties_action);
	_g_object_unref0 (eject_action);
	_g_object_unref0 (safely_remove_action);
	return obj;
}

static void
sidebar_abstract_mountable_row_class_init (SidebarAbstractMountableRowClass * klass,
                                           gpointer klass_data)
{
	GVolumeMonitor* _tmp0_;
	GtkCssProvider* _tmp1_;
	GtkCssProvider* _tmp2_;
	sidebar_abstract_mountable_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SidebarAbstractMountableRow_private_offset);
	((SidebarAbstractMountableRowClass *) klass)->update_free_space = (void (*) (SidebarAbstractMountableRow*)) sidebar_abstract_mountable_row_real_update_free_space;
	((SidebarAbstractMountableRowClass *) klass)->add_mountable_tooltip = (void (*) (SidebarAbstractMountableRow*, GAsyncReadyCallback, gpointer)) sidebar_abstract_mountable_row_real_add_mountable_tooltip;
	((SidebarAbstractMountableRowClass *) klass)->add_mountable_tooltip_finish = (void (*) (SidebarAbstractMountableRow*, GAsyncResult*)) sidebar_abstract_mountable_row_real_add_mountable_tooltip_finish;
	((SidebarAbstractMountableRowClass *) klass)->on_mount_removed = (void (*) (SidebarAbstractMountableRow*, GMount*)) sidebar_abstract_mountable_row_real_on_mount_removed;
	((SidebarAbstractMountableRowClass *) klass)->on_mount_added = (void (*) (SidebarAbstractMountableRow*, GMount*)) sidebar_abstract_mountable_row_real_on_mount_added;
	((SidebarAbstractMountableRowClass *) klass)->show_mount_info = (void (*) (SidebarAbstractMountableRow*)) sidebar_abstract_mountable_row_real_show_mount_info;
	((SidebarAbstractMountableRowClass *) klass)->get_filesystem_space = (void (*) (SidebarAbstractMountableRow*, GCancellable*, GAsyncReadyCallback, gpointer)) sidebar_abstract_mountable_row_real_get_filesystem_space;
	((SidebarAbstractMountableRowClass *) klass)->get_filesystem_space_finish = (gboolean (*) (SidebarAbstractMountableRow*, GAsyncResult*)) sidebar_abstract_mountable_row_real_get_filesystem_space_finish;
	SIDEBAR_ABSTRACT_MOUNTABLE_ROW_CLASS (klass)->get_is_mounted = (gboolean (*) (SidebarAbstractMountableRow*)) sidebar_abstract_mountable_row_real_get_is_mounted;
	SIDEBAR_ABSTRACT_MOUNTABLE_ROW_CLASS (klass)->get_can_unmount = (gboolean (*) (SidebarAbstractMountableRow*)) sidebar_abstract_mountable_row_real_get_can_unmount;
	SIDEBAR_ABSTRACT_MOUNTABLE_ROW_CLASS (klass)->get_can_eject = (gboolean (*) (SidebarAbstractMountableRow*)) sidebar_abstract_mountable_row_real_get_can_eject;
	G_OBJECT_CLASS (klass)->get_property = _vala_sidebar_abstract_mountable_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sidebar_abstract_mountable_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = sidebar_abstract_mountable_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = sidebar_abstract_mountable_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_ABSTRACT_MOUNTABLE_ROW_SORT_KEY_PROPERTY, sidebar_abstract_mountable_row_properties[SIDEBAR_ABSTRACT_MOUNTABLE_ROW_SORT_KEY_PROPERTY] = g_param_spec_string ("sort-key", "sort-key", "sort-key", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_ABSTRACT_MOUNTABLE_ROW_MOUNT_PROPERTY, sidebar_abstract_mountable_row_properties[SIDEBAR_ABSTRACT_MOUNTABLE_ROW_MOUNT_PROPERTY] = g_param_spec_object ("mount", "mount", "mount", g_mount_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_ABSTRACT_MOUNTABLE_ROW_DRIVE_PROPERTY, sidebar_abstract_mountable_row_properties[SIDEBAR_ABSTRACT_MOUNTABLE_ROW_DRIVE_PROPERTY] = g_param_spec_object ("drive", "drive", "drive", g_drive_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_ABSTRACT_MOUNTABLE_ROW_UUID_PROPERTY, sidebar_abstract_mountable_row_properties[SIDEBAR_ABSTRACT_MOUNTABLE_ROW_UUID_PROPERTY] = g_param_spec_string ("uuid", "uuid", "uuid", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_ABSTRACT_MOUNTABLE_ROW_IS_MOUNTED_PROPERTY, sidebar_abstract_mountable_row_properties[SIDEBAR_ABSTRACT_MOUNTABLE_ROW_IS_MOUNTED_PROPERTY] = g_param_spec_boolean ("is-mounted", "is-mounted", "is-mounted", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_ABSTRACT_MOUNTABLE_ROW_CAN_UNMOUNT_PROPERTY, sidebar_abstract_mountable_row_properties[SIDEBAR_ABSTRACT_MOUNTABLE_ROW_CAN_UNMOUNT_PROPERTY] = g_param_spec_boolean ("can-unmount", "can-unmount", "can-unmount", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_ABSTRACT_MOUNTABLE_ROW_CAN_EJECT_PROPERTY, sidebar_abstract_mountable_row_properties[SIDEBAR_ABSTRACT_MOUNTABLE_ROW_CAN_EJECT_PROPERTY] = g_param_spec_boolean ("can-eject", "can-eject", "can-eject", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_ABSTRACT_MOUNTABLE_ROW_WORKING_PROPERTY, sidebar_abstract_mountable_row_properties[SIDEBAR_ABSTRACT_MOUNTABLE_ROW_WORKING_PROPERTY] = g_param_spec_boolean ("working", "working", "working", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = g_volume_monitor_get ();
	_g_object_unref0 (sidebar_abstract_mountable_row_volume_monitor);
	sidebar_abstract_mountable_row_volume_monitor = _tmp0_;
	_tmp1_ = gtk_css_provider_new ();
	_g_object_unref0 (sidebar_abstract_mountable_row_devicerow_provider);
	sidebar_abstract_mountable_row_devicerow_provider = _tmp1_;
	_tmp2_ = sidebar_abstract_mountable_row_devicerow_provider;
	gtk_css_provider_load_from_resource (_tmp2_, "/io/elementary/files/DiskRenderer.css");
}

static void
sidebar_abstract_mountable_row_sidebar_sidebar_item_interface_interface_init (SidebarSidebarItemInterfaceIface * iface,
                                                                              gpointer iface_data)
{
	sidebar_abstract_mountable_row_sidebar_sidebar_item_interface_parent_iface = g_type_interface_peek_parent (iface);
	iface->update_plugin_data = (void (*) (SidebarSidebarItemInterface*, FilesSidebarPluginItem*)) sidebar_abstract_mountable_row_real_update_plugin_data;
}

static void
sidebar_abstract_mountable_row_instance_init (SidebarAbstractMountableRow * self,
                                              gpointer klass)
{
	gchar* _tmp0_;
	self->priv = sidebar_abstract_mountable_row_get_instance_private (self);
	self->priv->storage_capacity = (gdouble) 0;
	self->priv->storage_free = (gdouble) 0;
	_tmp0_ = g_strdup ("");
	self->priv->_sort_key = _tmp0_;
	self->priv->_mount = NULL;
	self->priv->_drive = NULL;
	self->valid = TRUE;
	self->priv->_working = FALSE;
}

static void
sidebar_abstract_mountable_row_finalize (GObject * obj)
{
	SidebarAbstractMountableRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, SidebarAbstractMountableRow);
	_g_free0 (self->priv->_sort_key);
	_g_object_unref0 (self->priv->unmount_eject_working_stack);
	_g_object_unref0 (self->priv->unmount_eject_revealer);
	_g_object_unref0 (self->priv->working_spinner);
	_g_object_unref0 (self->priv->unmount_eject_button);
	_g_object_unref0 (self->priv->storage_levelbar);
	_g_object_unref0 (self->priv->_mount);
	_g_object_unref0 (self->priv->_drive);
	_g_free0 (self->priv->_uuid);
	G_OBJECT_CLASS (sidebar_abstract_mountable_row_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
sidebar_abstract_mountable_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SidebarAbstractMountableRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sidebar_abstract_mountable_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SidebarAbstractMountableRow), 0, (GInstanceInitFunc) sidebar_abstract_mountable_row_instance_init, NULL };
	static const GInterfaceInfo sidebar_sidebar_item_interface_info = { (GInterfaceInitFunc) sidebar_abstract_mountable_row_sidebar_sidebar_item_interface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType sidebar_abstract_mountable_row_type_id;
	sidebar_abstract_mountable_row_type_id = g_type_register_static (SIDEBAR_TYPE_BOOKMARK_ROW, "SidebarAbstractMountableRow", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (sidebar_abstract_mountable_row_type_id, SIDEBAR_TYPE_SIDEBAR_ITEM_INTERFACE, &sidebar_sidebar_item_interface_info);
	SidebarAbstractMountableRow_private_offset = g_type_add_instance_private (sidebar_abstract_mountable_row_type_id, sizeof (SidebarAbstractMountableRowPrivate));
	return sidebar_abstract_mountable_row_type_id;
}

GType
sidebar_abstract_mountable_row_get_type (void)
{
	static volatile gsize sidebar_abstract_mountable_row_type_id__once = 0;
	if (g_once_init_enter (&sidebar_abstract_mountable_row_type_id__once)) {
		GType sidebar_abstract_mountable_row_type_id;
		sidebar_abstract_mountable_row_type_id = sidebar_abstract_mountable_row_get_type_once ();
		g_once_init_leave (&sidebar_abstract_mountable_row_type_id__once, sidebar_abstract_mountable_row_type_id);
	}
	return sidebar_abstract_mountable_row_type_id__once;
}

static void
_vala_sidebar_abstract_mountable_row_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec)
{
	SidebarAbstractMountableRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, SidebarAbstractMountableRow);
	switch (property_id) {
		case SIDEBAR_ABSTRACT_MOUNTABLE_ROW_SORT_KEY_PROPERTY:
		g_value_set_string (value, sidebar_abstract_mountable_row_get_sort_key (self));
		break;
		case SIDEBAR_ABSTRACT_MOUNTABLE_ROW_MOUNT_PROPERTY:
		g_value_set_object (value, sidebar_abstract_mountable_row_get_mount (self));
		break;
		case SIDEBAR_ABSTRACT_MOUNTABLE_ROW_DRIVE_PROPERTY:
		g_value_set_object (value, sidebar_abstract_mountable_row_get_drive (self));
		break;
		case SIDEBAR_ABSTRACT_MOUNTABLE_ROW_UUID_PROPERTY:
		g_value_set_string (value, sidebar_abstract_mountable_row_get_uuid (self));
		break;
		case SIDEBAR_ABSTRACT_MOUNTABLE_ROW_IS_MOUNTED_PROPERTY:
		g_value_set_boolean (value, sidebar_abstract_mountable_row_get_is_mounted (self));
		break;
		case SIDEBAR_ABSTRACT_MOUNTABLE_ROW_CAN_UNMOUNT_PROPERTY:
		g_value_set_boolean (value, sidebar_abstract_mountable_row_get_can_unmount (self));
		break;
		case SIDEBAR_ABSTRACT_MOUNTABLE_ROW_CAN_EJECT_PROPERTY:
		g_value_set_boolean (value, sidebar_abstract_mountable_row_get_can_eject (self));
		break;
		case SIDEBAR_ABSTRACT_MOUNTABLE_ROW_WORKING_PROPERTY:
		g_value_set_boolean (value, sidebar_abstract_mountable_row_get_working (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sidebar_abstract_mountable_row_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec)
{
	SidebarAbstractMountableRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, SidebarAbstractMountableRow);
	switch (property_id) {
		case SIDEBAR_ABSTRACT_MOUNTABLE_ROW_SORT_KEY_PROPERTY:
		sidebar_abstract_mountable_row_set_sort_key (self, g_value_get_string (value));
		break;
		case SIDEBAR_ABSTRACT_MOUNTABLE_ROW_MOUNT_PROPERTY:
		sidebar_abstract_mountable_row_set_mount (self, g_value_get_object (value));
		break;
		case SIDEBAR_ABSTRACT_MOUNTABLE_ROW_DRIVE_PROPERTY:
		sidebar_abstract_mountable_row_set_drive (self, g_value_get_object (value));
		break;
		case SIDEBAR_ABSTRACT_MOUNTABLE_ROW_UUID_PROPERTY:
		sidebar_abstract_mountable_row_set_uuid (self, g_value_get_string (value));
		break;
		case SIDEBAR_ABSTRACT_MOUNTABLE_ROW_WORKING_PROPERTY:
		sidebar_abstract_mountable_row_set_working (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

