// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef node_inspector_protocol_NodeWorker_h
#define node_inspector_protocol_NodeWorker_h

#include "src/node/inspector/protocol/Protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace node {
namespace inspector {
namespace protocol {
namespace NodeWorker {
using WorkerID = String;
using SessionID = String;
class WorkerInfo;

// ------------- Forward and enum declarations.

// ------------- Type and builder declarations.

class  WorkerInfo : public ::crdtp::ProtocolObject<WorkerInfo> {
public:
    ~WorkerInfo() override { }

    String getWorkerId() { return m_workerId; }
    void setWorkerId(const String& value) { m_workerId = value; }

    String getType() { return m_type; }
    void setType(const String& value) { m_type = value; }

    String getTitle() { return m_title; }
    void setTitle(const String& value) { m_title = value; }

    String getUrl() { return m_url; }
    void setUrl(const String& value) { m_url = value; }

    template<int STATE>
    class WorkerInfoBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            WorkerIdSet = 1 << 1,
            TypeSet = 1 << 2,
            TitleSet = 1 << 3,
            UrlSet = 1 << 4,
            AllFieldsSet = (WorkerIdSet | TypeSet | TitleSet | UrlSet | 0)};


        WorkerInfoBuilder<STATE | WorkerIdSet>& setWorkerId(const String& value)
        {
            static_assert(!(STATE & WorkerIdSet), "property workerId should not be set yet");
            m_result->setWorkerId(value);
            return castState<WorkerIdSet>();
        }

        WorkerInfoBuilder<STATE | TypeSet>& setType(const String& value)
        {
            static_assert(!(STATE & TypeSet), "property type should not be set yet");
            m_result->setType(value);
            return castState<TypeSet>();
        }

        WorkerInfoBuilder<STATE | TitleSet>& setTitle(const String& value)
        {
            static_assert(!(STATE & TitleSet), "property title should not be set yet");
            m_result->setTitle(value);
            return castState<TitleSet>();
        }

        WorkerInfoBuilder<STATE | UrlSet>& setUrl(const String& value)
        {
            static_assert(!(STATE & UrlSet), "property url should not be set yet");
            m_result->setUrl(value);
            return castState<UrlSet>();
        }

        std::unique_ptr<WorkerInfo> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class WorkerInfo;
        WorkerInfoBuilder() : m_result(new WorkerInfo()) { }

        template<int STEP> WorkerInfoBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<WorkerInfoBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::NodeWorker::WorkerInfo> m_result;
    };

    static WorkerInfoBuilder<0> create()
    {
        return WorkerInfoBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    WorkerInfo()
    {
    }

    String m_workerId;
    String m_type;
    String m_title;
    String m_url;
};


// ------------- Backend interface.

class  Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse sendMessageToWorker(const String& in_message, const String& in_sessionId) = 0;
    virtual DispatchResponse enable(bool in_waitForDebuggerOnStart) = 0;
    virtual DispatchResponse disable() = 0;
    virtual DispatchResponse detach(const String& in_sessionId) = 0;

};

// ------------- Frontend interface.

class  Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void attachedToWorker(const String& sessionId, std::unique_ptr<protocol::NodeWorker::WorkerInfo> workerInfo, bool waitingForDebugger);
    void detachedFromWorker(const String& sessionId);
    void receivedMessageFromWorker(const String& sessionId, const String& message);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class  Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class  Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace NodeWorker
} // namespace node
} // namespace inspector
} // namespace protocol

#endif // !defined(node_inspector_protocol_NodeWorker_h)
