// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: google/api/http.proto

package api

import (
	bytes "bytes"
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// Defines the HTTP configuration for an API service. It contains a list of
// [HttpRule][google.api.HttpRule], each specifying the mapping of an RPC method
// to one or more HTTP REST API methods.
type Http struct {
	// A list of HTTP configuration rules that apply to individual API methods.
	//
	// **NOTE:** All service configuration rules follow "last one wins" order.
	Rules []*HttpRule `protobuf:"bytes,1,rep,name=rules,proto3" json:"rules,omitempty"`
	// When set to true, URL path parameters will be fully URI-decoded except in
	// cases of single segment matches in reserved expansion, where "%2F" will be
	// left encoded.
	//
	// The default behavior is to not decode RFC 6570 reserved characters in multi
	// segment matches.
	FullyDecodeReservedExpansion bool     `protobuf:"varint,2,opt,name=fully_decode_reserved_expansion,json=fullyDecodeReservedExpansion,proto3" json:"fully_decode_reserved_expansion,omitempty"`
	XXX_NoUnkeyedLiteral         struct{} `json:"-"`
	XXX_unrecognized             []byte   `json:"-"`
	XXX_sizecache                int32    `json:"-"`
}

func (m *Http) Reset()      { *m = Http{} }
func (*Http) ProtoMessage() {}
func (*Http) Descriptor() ([]byte, []int) {
	return fileDescriptor_ff9994be407cdcc9, []int{0}
}
func (m *Http) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Http) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Http.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Http) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Http.Merge(m, src)
}
func (m *Http) XXX_Size() int {
	return m.Size()
}
func (m *Http) XXX_DiscardUnknown() {
	xxx_messageInfo_Http.DiscardUnknown(m)
}

var xxx_messageInfo_Http proto.InternalMessageInfo

func (m *Http) GetRules() []*HttpRule {
	if m != nil {
		return m.Rules
	}
	return nil
}

func (m *Http) GetFullyDecodeReservedExpansion() bool {
	if m != nil {
		return m.FullyDecodeReservedExpansion
	}
	return false
}

func (*Http) XXX_MessageName() string {
	return "google.api.Http"
}

// # gRPC Transcoding
//
// gRPC Transcoding is a feature for mapping between a gRPC method and one or
// more HTTP REST endpoints. It allows developers to build a single API service
// that supports both gRPC APIs and REST APIs. Many systems, including [Google
// APIs](https://github.com/googleapis/googleapis),
// [Cloud Endpoints](https://cloud.google.com/endpoints), [gRPC
// Gateway](https://github.com/grpc-ecosystem/grpc-gateway),
// and [Envoy](https://github.com/envoyproxy/envoy) proxy support this feature
// and use it for large scale production services.
//
// `HttpRule` defines the schema of the gRPC/REST mapping. The mapping specifies
// how different portions of the gRPC request message are mapped to the URL
// path, URL query parameters, and HTTP request body. It also controls how the
// gRPC response message is mapped to the HTTP response body. `HttpRule` is
// typically specified as an `google.api.http` annotation on the gRPC method.
//
// Each mapping specifies a URL path template and an HTTP method. The path
// template may refer to one or more fields in the gRPC request message, as long
// as each field is a non-repeated field with a primitive (non-message) type.
// The path template controls how fields of the request message are mapped to
// the URL path.
//
// Example:
//
//     service Messaging {
//       rpc GetMessage(GetMessageRequest) returns (Message) {
//         option (google.api.http) = {
//             get: "/v1/{name=messages/*}"
//         };
//       }
//     }
//     message GetMessageRequest {
//       string name = 1; // Mapped to URL path.
//     }
//     message Message {
//       string text = 1; // The resource content.
//     }
//
// This enables an HTTP REST to gRPC mapping as below:
//
// HTTP | gRPC
// -----|-----
// `GET /v1/messages/123456`  | `GetMessage(name: "messages/123456")`
//
// Any fields in the request message which are not bound by the path template
// automatically become HTTP query parameters if there is no HTTP request body.
// For example:
//
//     service Messaging {
//       rpc GetMessage(GetMessageRequest) returns (Message) {
//         option (google.api.http) = {
//             get:"/v1/messages/{message_id}"
//         };
//       }
//     }
//     message GetMessageRequest {
//       message SubMessage {
//         string subfield = 1;
//       }
//       string message_id = 1; // Mapped to URL path.
//       int64 revision = 2;    // Mapped to URL query parameter `revision`.
//       SubMessage sub = 3;    // Mapped to URL query parameter `sub.subfield`.
//     }
//
// This enables a HTTP JSON to RPC mapping as below:
//
// HTTP | gRPC
// -----|-----
// `GET /v1/messages/123456?revision=2&sub.subfield=foo` |
// `GetMessage(message_id: "123456" revision: 2 sub: SubMessage(subfield:
// "foo"))`
//
// Note that fields which are mapped to URL query parameters must have a
// primitive type or a repeated primitive type or a non-repeated message type.
// In the case of a repeated type, the parameter can be repeated in the URL
// as `...?param=A&param=B`. In the case of a message type, each field of the
// message is mapped to a separate parameter, such as
// `...?foo.a=A&foo.b=B&foo.c=C`.
//
// For HTTP methods that allow a request body, the `body` field
// specifies the mapping. Consider a REST update method on the
// message resource collection:
//
//     service Messaging {
//       rpc UpdateMessage(UpdateMessageRequest) returns (Message) {
//         option (google.api.http) = {
//           patch: "/v1/messages/{message_id}"
//           body: "message"
//         };
//       }
//     }
//     message UpdateMessageRequest {
//       string message_id = 1; // mapped to the URL
//       Message message = 2;   // mapped to the body
//     }
//
// The following HTTP JSON to RPC mapping is enabled, where the
// representation of the JSON in the request body is determined by
// protos JSON encoding:
//
// HTTP | gRPC
// -----|-----
// `PATCH /v1/messages/123456 { "text": "Hi!" }` | `UpdateMessage(message_id:
// "123456" message { text: "Hi!" })`
//
// The special name `*` can be used in the body mapping to define that
// every field not bound by the path template should be mapped to the
// request body.  This enables the following alternative definition of
// the update method:
//
//     service Messaging {
//       rpc UpdateMessage(Message) returns (Message) {
//         option (google.api.http) = {
//           patch: "/v1/messages/{message_id}"
//           body: "*"
//         };
//       }
//     }
//     message Message {
//       string message_id = 1;
//       string text = 2;
//     }
//
//
// The following HTTP JSON to RPC mapping is enabled:
//
// HTTP | gRPC
// -----|-----
// `PATCH /v1/messages/123456 { "text": "Hi!" }` | `UpdateMessage(message_id:
// "123456" text: "Hi!")`
//
// Note that when using `*` in the body mapping, it is not possible to
// have HTTP parameters, as all fields not bound by the path end in
// the body. This makes this option more rarely used in practice when
// defining REST APIs. The common usage of `*` is in custom methods
// which don't use the URL at all for transferring data.
//
// It is possible to define multiple HTTP methods for one RPC by using
// the `additional_bindings` option. Example:
//
//     service Messaging {
//       rpc GetMessage(GetMessageRequest) returns (Message) {
//         option (google.api.http) = {
//           get: "/v1/messages/{message_id}"
//           additional_bindings {
//             get: "/v1/users/{user_id}/messages/{message_id}"
//           }
//         };
//       }
//     }
//     message GetMessageRequest {
//       string message_id = 1;
//       string user_id = 2;
//     }
//
// This enables the following two alternative HTTP JSON to RPC mappings:
//
// HTTP | gRPC
// -----|-----
// `GET /v1/messages/123456` | `GetMessage(message_id: "123456")`
// `GET /v1/users/me/messages/123456` | `GetMessage(user_id: "me" message_id:
// "123456")`
//
// ## Rules for HTTP mapping
//
// 1. Leaf request fields (recursive expansion nested messages in the request
//    message) are classified into three categories:
//    - Fields referred by the path template. They are passed via the URL path.
//    - Fields referred by the [HttpRule.body][google.api.HttpRule.body]. They are passed via the HTTP
//      request body.
//    - All other fields are passed via the URL query parameters, and the
//      parameter name is the field path in the request message. A repeated
//      field can be represented as multiple query parameters under the same
//      name.
//  2. If [HttpRule.body][google.api.HttpRule.body] is "*", there is no URL query parameter, all fields
//     are passed via URL path and HTTP request body.
//  3. If [HttpRule.body][google.api.HttpRule.body] is omitted, there is no HTTP request body, all
//     fields are passed via URL path and URL query parameters.
//
// ### Path template syntax
//
//     Template = "/" Segments [ Verb ] ;
//     Segments = Segment { "/" Segment } ;
//     Segment  = "*" | "**" | LITERAL | Variable ;
//     Variable = "{" FieldPath [ "=" Segments ] "}" ;
//     FieldPath = IDENT { "." IDENT } ;
//     Verb     = ":" LITERAL ;
//
// The syntax `*` matches a single URL path segment. The syntax `**` matches
// zero or more URL path segments, which must be the last part of the URL path
// except the `Verb`.
//
// The syntax `Variable` matches part of the URL path as specified by its
// template. A variable template must not contain other variables. If a variable
// matches a single path segment, its template may be omitted, e.g. `{var}`
// is equivalent to `{var=*}`.
//
// The syntax `LITERAL` matches literal text in the URL path. If the `LITERAL`
// contains any reserved character, such characters should be percent-encoded
// before the matching.
//
// If a variable contains exactly one path segment, such as `"{var}"` or
// `"{var=*}"`, when such a variable is expanded into a URL path on the client
// side, all characters except `[-_.~0-9a-zA-Z]` are percent-encoded. The
// server side does the reverse decoding. Such variables show up in the
// [Discovery
// Document](https://developers.google.com/discovery/v1/reference/apis) as
// `{var}`.
//
// If a variable contains multiple path segments, such as `"{var=foo/*}"`
// or `"{var=**}"`, when such a variable is expanded into a URL path on the
// client side, all characters except `[-_.~/0-9a-zA-Z]` are percent-encoded.
// The server side does the reverse decoding, except "%2F" and "%2f" are left
// unchanged. Such variables show up in the
// [Discovery
// Document](https://developers.google.com/discovery/v1/reference/apis) as
// `{+var}`.
//
// ## Using gRPC API Service Configuration
//
// gRPC API Service Configuration (service config) is a configuration language
// for configuring a gRPC service to become a user-facing product. The
// service config is simply the YAML representation of the `google.api.Service`
// proto message.
//
// As an alternative to annotating your proto file, you can configure gRPC
// transcoding in your service config YAML files. You do this by specifying a
// `HttpRule` that maps the gRPC method to a REST endpoint, achieving the same
// effect as the proto annotation. This can be particularly useful if you
// have a proto that is reused in multiple services. Note that any transcoding
// specified in the service config will override any matching transcoding
// configuration in the proto.
//
// Example:
//
//     http:
//       rules:
//         # Selects a gRPC method and applies HttpRule to it.
//         - selector: example.v1.Messaging.GetMessage
//           get: /v1/messages/{message_id}/{sub.subfield}
//
// ## Special notes
//
// When gRPC Transcoding is used to map a gRPC to JSON REST endpoints, the
// proto to JSON conversion must follow the [proto3
// specification](https://developers.google.com/protocol-buffers/docs/proto3#json).
//
// While the single segment variable follows the semantics of
// [RFC 6570](https://tools.ietf.org/html/rfc6570) Section 3.2.2 Simple String
// Expansion, the multi segment variable **does not** follow RFC 6570 Section
// 3.2.3 Reserved Expansion. The reason is that the Reserved Expansion
// does not expand special characters like `?` and `#`, which would lead
// to invalid URLs. As the result, gRPC Transcoding uses a custom encoding
// for multi segment variables.
//
// The path variables **must not** refer to any repeated or mapped field,
// because client libraries are not capable of handling such variable expansion.
//
// The path variables **must not** capture the leading "/" character. The reason
// is that the most common use case "{var}" does not capture the leading "/"
// character. For consistency, all path variables must share the same behavior.
//
// Repeated message fields must not be mapped to URL query parameters, because
// no client library can support such complicated mapping.
//
// If an API needs to use a JSON array for request or response body, it can map
// the request or response body to a repeated field. However, some gRPC
// Transcoding implementations may not support this feature.
type HttpRule struct {
	// Selects a method to which this rule applies.
	//
	// Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
	Selector string `protobuf:"bytes,1,opt,name=selector,proto3" json:"selector,omitempty"`
	// Determines the URL pattern is matched by this rules. This pattern can be
	// used with any of the {get|put|post|delete|patch} methods. A custom method
	// can be defined using the 'custom' field.
	//
	// Types that are valid to be assigned to Pattern:
	//	*HttpRule_Get
	//	*HttpRule_Put
	//	*HttpRule_Post
	//	*HttpRule_Delete
	//	*HttpRule_Patch
	//	*HttpRule_Custom
	Pattern isHttpRule_Pattern `protobuf_oneof:"pattern"`
	// The name of the request field whose value is mapped to the HTTP request
	// body, or `*` for mapping all request fields not captured by the path
	// pattern to the HTTP body, or omitted for not having any HTTP request body.
	//
	// NOTE: the referred field must be present at the top-level of the request
	// message type.
	Body string `protobuf:"bytes,7,opt,name=body,proto3" json:"body,omitempty"`
	// Optional. The name of the response field whose value is mapped to the HTTP
	// response body. When omitted, the entire response message will be used
	// as the HTTP response body.
	//
	// NOTE: The referred field must be present at the top-level of the response
	// message type.
	ResponseBody string `protobuf:"bytes,12,opt,name=response_body,json=responseBody,proto3" json:"response_body,omitempty"`
	// Additional HTTP bindings for the selector. Nested bindings must
	// not contain an `additional_bindings` field themselves (that is,
	// the nesting may only be one level deep).
	AdditionalBindings   []*HttpRule `protobuf:"bytes,11,rep,name=additional_bindings,json=additionalBindings,proto3" json:"additional_bindings,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *HttpRule) Reset()      { *m = HttpRule{} }
func (*HttpRule) ProtoMessage() {}
func (*HttpRule) Descriptor() ([]byte, []int) {
	return fileDescriptor_ff9994be407cdcc9, []int{1}
}
func (m *HttpRule) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HttpRule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HttpRule.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HttpRule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HttpRule.Merge(m, src)
}
func (m *HttpRule) XXX_Size() int {
	return m.Size()
}
func (m *HttpRule) XXX_DiscardUnknown() {
	xxx_messageInfo_HttpRule.DiscardUnknown(m)
}

var xxx_messageInfo_HttpRule proto.InternalMessageInfo

type isHttpRule_Pattern interface {
	isHttpRule_Pattern()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type HttpRule_Get struct {
	Get string `protobuf:"bytes,2,opt,name=get,proto3,oneof" json:"get,omitempty"`
}
type HttpRule_Put struct {
	Put string `protobuf:"bytes,3,opt,name=put,proto3,oneof" json:"put,omitempty"`
}
type HttpRule_Post struct {
	Post string `protobuf:"bytes,4,opt,name=post,proto3,oneof" json:"post,omitempty"`
}
type HttpRule_Delete struct {
	Delete string `protobuf:"bytes,5,opt,name=delete,proto3,oneof" json:"delete,omitempty"`
}
type HttpRule_Patch struct {
	Patch string `protobuf:"bytes,6,opt,name=patch,proto3,oneof" json:"patch,omitempty"`
}
type HttpRule_Custom struct {
	Custom *CustomHttpPattern `protobuf:"bytes,8,opt,name=custom,proto3,oneof" json:"custom,omitempty"`
}

func (*HttpRule_Get) isHttpRule_Pattern()    {}
func (*HttpRule_Put) isHttpRule_Pattern()    {}
func (*HttpRule_Post) isHttpRule_Pattern()   {}
func (*HttpRule_Delete) isHttpRule_Pattern() {}
func (*HttpRule_Patch) isHttpRule_Pattern()  {}
func (*HttpRule_Custom) isHttpRule_Pattern() {}

func (m *HttpRule) GetPattern() isHttpRule_Pattern {
	if m != nil {
		return m.Pattern
	}
	return nil
}

func (m *HttpRule) GetSelector() string {
	if m != nil {
		return m.Selector
	}
	return ""
}

func (m *HttpRule) GetGet() string {
	if x, ok := m.GetPattern().(*HttpRule_Get); ok {
		return x.Get
	}
	return ""
}

func (m *HttpRule) GetPut() string {
	if x, ok := m.GetPattern().(*HttpRule_Put); ok {
		return x.Put
	}
	return ""
}

func (m *HttpRule) GetPost() string {
	if x, ok := m.GetPattern().(*HttpRule_Post); ok {
		return x.Post
	}
	return ""
}

func (m *HttpRule) GetDelete() string {
	if x, ok := m.GetPattern().(*HttpRule_Delete); ok {
		return x.Delete
	}
	return ""
}

func (m *HttpRule) GetPatch() string {
	if x, ok := m.GetPattern().(*HttpRule_Patch); ok {
		return x.Patch
	}
	return ""
}

func (m *HttpRule) GetCustom() *CustomHttpPattern {
	if x, ok := m.GetPattern().(*HttpRule_Custom); ok {
		return x.Custom
	}
	return nil
}

func (m *HttpRule) GetBody() string {
	if m != nil {
		return m.Body
	}
	return ""
}

func (m *HttpRule) GetResponseBody() string {
	if m != nil {
		return m.ResponseBody
	}
	return ""
}

func (m *HttpRule) GetAdditionalBindings() []*HttpRule {
	if m != nil {
		return m.AdditionalBindings
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*HttpRule) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*HttpRule_Get)(nil),
		(*HttpRule_Put)(nil),
		(*HttpRule_Post)(nil),
		(*HttpRule_Delete)(nil),
		(*HttpRule_Patch)(nil),
		(*HttpRule_Custom)(nil),
	}
}

func (*HttpRule) XXX_MessageName() string {
	return "google.api.HttpRule"
}

// A custom pattern is used for defining custom HTTP verb.
type CustomHttpPattern struct {
	// The name of this custom HTTP verb.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// The path matched by this custom verb.
	Path                 string   `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CustomHttpPattern) Reset()      { *m = CustomHttpPattern{} }
func (*CustomHttpPattern) ProtoMessage() {}
func (*CustomHttpPattern) Descriptor() ([]byte, []int) {
	return fileDescriptor_ff9994be407cdcc9, []int{2}
}
func (m *CustomHttpPattern) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CustomHttpPattern) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CustomHttpPattern.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CustomHttpPattern) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CustomHttpPattern.Merge(m, src)
}
func (m *CustomHttpPattern) XXX_Size() int {
	return m.Size()
}
func (m *CustomHttpPattern) XXX_DiscardUnknown() {
	xxx_messageInfo_CustomHttpPattern.DiscardUnknown(m)
}

var xxx_messageInfo_CustomHttpPattern proto.InternalMessageInfo

func (m *CustomHttpPattern) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

func (m *CustomHttpPattern) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (*CustomHttpPattern) XXX_MessageName() string {
	return "google.api.CustomHttpPattern"
}
func init() {
	proto.RegisterType((*Http)(nil), "google.api.Http")
	proto.RegisterType((*HttpRule)(nil), "google.api.HttpRule")
	proto.RegisterType((*CustomHttpPattern)(nil), "google.api.CustomHttpPattern")
}

func init() { proto.RegisterFile("google/api/http.proto", fileDescriptor_ff9994be407cdcc9) }

var fileDescriptor_ff9994be407cdcc9 = []byte{
	// 440 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x7c, 0x92, 0xb1, 0x8f, 0xd3, 0x30,
	0x14, 0xc6, 0xeb, 0x36, 0xed, 0xb5, 0xaf, 0x07, 0x12, 0xe6, 0x40, 0x16, 0x02, 0x53, 0x95, 0xa5,
	0x62, 0xe8, 0x49, 0xc7, 0xc0, 0xc0, 0x44, 0xa0, 0xe2, 0xd8, 0xaa, 0x4c, 0x88, 0x25, 0x72, 0xe3,
	0x47, 0x6b, 0x91, 0x8b, 0xad, 0xd8, 0x41, 0x74, 0xe3, 0x6f, 0x61, 0xe2, 0x4f, 0x61, 0x64, 0x44,
	0x4c, 0x34, 0x2c, 0x8c, 0x37, 0xde, 0x88, 0xec, 0xa4, 0x5c, 0x25, 0x24, 0xb6, 0xf7, 0x7d, 0xef,
	0x97, 0x97, 0x2f, 0x2f, 0x0f, 0xee, 0xac, 0xb5, 0x5e, 0xe7, 0x78, 0x2a, 0x8c, 0x3a, 0xdd, 0x38,
	0x67, 0xe6, 0xa6, 0xd4, 0x4e, 0x53, 0x68, 0xec, 0xb9, 0x30, 0x6a, 0xba, 0x85, 0xe8, 0xdc, 0x39,
	0x43, 0x1f, 0x43, 0xbf, 0xac, 0x72, 0xb4, 0x8c, 0x4c, 0x7a, 0xb3, 0xf1, 0xd9, 0xc9, 0xfc, 0x9a,
	0x99, 0x7b, 0x20, 0xa9, 0x72, 0x4c, 0x1a, 0x84, 0x2e, 0xe0, 0xe1, 0xbb, 0x2a, 0xcf, 0xb7, 0xa9,
	0xc4, 0x4c, 0x4b, 0x4c, 0x4b, 0xb4, 0x58, 0x7e, 0x40, 0x99, 0xe2, 0x47, 0x23, 0x0a, 0xab, 0x74,
	0xc1, 0xba, 0x13, 0x32, 0x1b, 0x26, 0xf7, 0x03, 0xf6, 0x32, 0x50, 0x49, 0x0b, 0x2d, 0xf6, 0xcc,
	0xf4, 0x47, 0x17, 0x86, 0xfb, 0xd1, 0xf4, 0x1e, 0x0c, 0x2d, 0xe6, 0x98, 0x39, 0x5d, 0x32, 0x32,
	0x21, 0xb3, 0x51, 0xf2, 0x57, 0x53, 0x0a, 0xbd, 0x35, 0xba, 0x30, 0x73, 0x74, 0xde, 0x49, 0xbc,
	0xf0, 0x9e, 0xa9, 0x1c, 0xeb, 0xed, 0x3d, 0x53, 0x39, 0x7a, 0x02, 0x91, 0xd1, 0xd6, 0xb1, 0xa8,
	0x35, 0x83, 0xa2, 0x0c, 0x06, 0x12, 0x73, 0x74, 0xc8, 0xfa, 0xad, 0xdf, 0x6a, 0x7a, 0x17, 0xfa,
	0x46, 0xb8, 0x6c, 0xc3, 0x06, 0x6d, 0xa3, 0x91, 0xf4, 0x29, 0x0c, 0xb2, 0xca, 0x3a, 0x7d, 0xc1,
	0x86, 0x13, 0x32, 0x1b, 0x9f, 0x3d, 0x38, 0x5c, 0xc6, 0x8b, 0xd0, 0xf1, 0xb9, 0x97, 0xc2, 0x39,
	0x2c, 0x0b, 0x3f, 0xb0, 0xc1, 0x29, 0x85, 0x68, 0xa5, 0xe5, 0x96, 0x1d, 0x85, 0x0f, 0x08, 0x35,
	0x7d, 0x04, 0x37, 0x4a, 0xb4, 0x46, 0x17, 0x16, 0xd3, 0xd0, 0x3c, 0x0e, 0xcd, 0xe3, 0xbd, 0x19,
	0x7b, 0x68, 0x01, 0xb7, 0x85, 0x94, 0xca, 0x29, 0x5d, 0x88, 0x3c, 0x5d, 0xa9, 0x42, 0xaa, 0x62,
	0x6d, 0xd9, 0xf8, 0x3f, 0xff, 0x82, 0x5e, 0x3f, 0x10, 0xb7, 0x7c, 0x3c, 0x82, 0x23, 0xd3, 0x84,
	0x9a, 0x3e, 0x83, 0x5b, 0xff, 0x24, 0xf5, 0xf9, 0xde, 0xab, 0x42, 0xb6, 0x0b, 0x0e, 0xb5, 0xf7,
	0x8c, 0x70, 0x9b, 0x66, 0xbb, 0x49, 0xa8, 0xe3, 0x37, 0xdf, 0x77, 0xbc, 0x73, 0xb9, 0xe3, 0xe4,
	0x6a, 0xc7, 0xc9, 0xa7, 0x9a, 0x93, 0x2f, 0x35, 0x27, 0x5f, 0x6b, 0x4e, 0xbe, 0xd5, 0x9c, 0xfc,
	0xac, 0x39, 0xf9, 0x5d, 0xf3, 0xce, 0xa5, 0xf7, 0x7e, 0x71, 0x02, 0x37, 0x33, 0x7d, 0x71, 0x10,
	0x31, 0x1e, 0x85, 0x57, 0xfa, 0x4b, 0x5b, 0x92, 0xb7, 0x3d, 0x61, 0xd4, 0x15, 0x21, 0x9f, 0xbb,
	0xd1, 0xab, 0xe7, 0xcb, 0xd7, 0xab, 0x41, 0xb8, 0xc0, 0x27, 0x7f, 0x02, 0x00, 0x00, 0xff, 0xff,
	0x1e, 0x40, 0xdc, 0xc0, 0x9a, 0x02, 0x00, 0x00,
}

func (this *Http) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Http)
	if !ok {
		that2, ok := that.(Http)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Rules) != len(that1.Rules) {
		return false
	}
	for i := range this.Rules {
		if !this.Rules[i].Equal(that1.Rules[i]) {
			return false
		}
	}
	if this.FullyDecodeReservedExpansion != that1.FullyDecodeReservedExpansion {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *HttpRule) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HttpRule)
	if !ok {
		that2, ok := that.(HttpRule)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Selector != that1.Selector {
		return false
	}
	if that1.Pattern == nil {
		if this.Pattern != nil {
			return false
		}
	} else if this.Pattern == nil {
		return false
	} else if !this.Pattern.Equal(that1.Pattern) {
		return false
	}
	if this.Body != that1.Body {
		return false
	}
	if this.ResponseBody != that1.ResponseBody {
		return false
	}
	if len(this.AdditionalBindings) != len(that1.AdditionalBindings) {
		return false
	}
	for i := range this.AdditionalBindings {
		if !this.AdditionalBindings[i].Equal(that1.AdditionalBindings[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *HttpRule_Get) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HttpRule_Get)
	if !ok {
		that2, ok := that.(HttpRule_Get)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Get != that1.Get {
		return false
	}
	return true
}
func (this *HttpRule_Put) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HttpRule_Put)
	if !ok {
		that2, ok := that.(HttpRule_Put)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Put != that1.Put {
		return false
	}
	return true
}
func (this *HttpRule_Post) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HttpRule_Post)
	if !ok {
		that2, ok := that.(HttpRule_Post)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Post != that1.Post {
		return false
	}
	return true
}
func (this *HttpRule_Delete) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HttpRule_Delete)
	if !ok {
		that2, ok := that.(HttpRule_Delete)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Delete != that1.Delete {
		return false
	}
	return true
}
func (this *HttpRule_Patch) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HttpRule_Patch)
	if !ok {
		that2, ok := that.(HttpRule_Patch)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Patch != that1.Patch {
		return false
	}
	return true
}
func (this *HttpRule_Custom) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HttpRule_Custom)
	if !ok {
		that2, ok := that.(HttpRule_Custom)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Custom.Equal(that1.Custom) {
		return false
	}
	return true
}
func (this *CustomHttpPattern) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CustomHttpPattern)
	if !ok {
		that2, ok := that.(CustomHttpPattern)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Kind != that1.Kind {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Http) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.Http{")
	if this.Rules != nil {
		s = append(s, "Rules: "+fmt.Sprintf("%#v", this.Rules)+",\n")
	}
	s = append(s, "FullyDecodeReservedExpansion: "+fmt.Sprintf("%#v", this.FullyDecodeReservedExpansion)+",\n")
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *HttpRule) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 14)
	s = append(s, "&api.HttpRule{")
	s = append(s, "Selector: "+fmt.Sprintf("%#v", this.Selector)+",\n")
	if this.Pattern != nil {
		s = append(s, "Pattern: "+fmt.Sprintf("%#v", this.Pattern)+",\n")
	}
	s = append(s, "Body: "+fmt.Sprintf("%#v", this.Body)+",\n")
	s = append(s, "ResponseBody: "+fmt.Sprintf("%#v", this.ResponseBody)+",\n")
	if this.AdditionalBindings != nil {
		s = append(s, "AdditionalBindings: "+fmt.Sprintf("%#v", this.AdditionalBindings)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *HttpRule_Get) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&api.HttpRule_Get{` +
		`Get:` + fmt.Sprintf("%#v", this.Get) + `}`}, ", ")
	return s
}
func (this *HttpRule_Put) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&api.HttpRule_Put{` +
		`Put:` + fmt.Sprintf("%#v", this.Put) + `}`}, ", ")
	return s
}
func (this *HttpRule_Post) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&api.HttpRule_Post{` +
		`Post:` + fmt.Sprintf("%#v", this.Post) + `}`}, ", ")
	return s
}
func (this *HttpRule_Delete) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&api.HttpRule_Delete{` +
		`Delete:` + fmt.Sprintf("%#v", this.Delete) + `}`}, ", ")
	return s
}
func (this *HttpRule_Patch) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&api.HttpRule_Patch{` +
		`Patch:` + fmt.Sprintf("%#v", this.Patch) + `}`}, ", ")
	return s
}
func (this *HttpRule_Custom) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&api.HttpRule_Custom{` +
		`Custom:` + fmt.Sprintf("%#v", this.Custom) + `}`}, ", ")
	return s
}
func (this *CustomHttpPattern) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.CustomHttpPattern{")
	s = append(s, "Kind: "+fmt.Sprintf("%#v", this.Kind)+",\n")
	s = append(s, "Path: "+fmt.Sprintf("%#v", this.Path)+",\n")
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringHttp(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *Http) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Http) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Http) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.FullyDecodeReservedExpansion {
		i--
		if m.FullyDecodeReservedExpansion {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.Rules) > 0 {
		for iNdEx := len(m.Rules) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Rules[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintHttp(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *HttpRule) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HttpRule) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HttpRule) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ResponseBody) > 0 {
		i -= len(m.ResponseBody)
		copy(dAtA[i:], m.ResponseBody)
		i = encodeVarintHttp(dAtA, i, uint64(len(m.ResponseBody)))
		i--
		dAtA[i] = 0x62
	}
	if len(m.AdditionalBindings) > 0 {
		for iNdEx := len(m.AdditionalBindings) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.AdditionalBindings[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintHttp(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x5a
		}
	}
	if m.Pattern != nil {
		{
			size := m.Pattern.Size()
			i -= size
			if _, err := m.Pattern.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if len(m.Body) > 0 {
		i -= len(m.Body)
		copy(dAtA[i:], m.Body)
		i = encodeVarintHttp(dAtA, i, uint64(len(m.Body)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Selector) > 0 {
		i -= len(m.Selector)
		copy(dAtA[i:], m.Selector)
		i = encodeVarintHttp(dAtA, i, uint64(len(m.Selector)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *HttpRule_Get) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HttpRule_Get) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Get)
	copy(dAtA[i:], m.Get)
	i = encodeVarintHttp(dAtA, i, uint64(len(m.Get)))
	i--
	dAtA[i] = 0x12
	return len(dAtA) - i, nil
}
func (m *HttpRule_Put) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HttpRule_Put) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Put)
	copy(dAtA[i:], m.Put)
	i = encodeVarintHttp(dAtA, i, uint64(len(m.Put)))
	i--
	dAtA[i] = 0x1a
	return len(dAtA) - i, nil
}
func (m *HttpRule_Post) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HttpRule_Post) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Post)
	copy(dAtA[i:], m.Post)
	i = encodeVarintHttp(dAtA, i, uint64(len(m.Post)))
	i--
	dAtA[i] = 0x22
	return len(dAtA) - i, nil
}
func (m *HttpRule_Delete) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HttpRule_Delete) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Delete)
	copy(dAtA[i:], m.Delete)
	i = encodeVarintHttp(dAtA, i, uint64(len(m.Delete)))
	i--
	dAtA[i] = 0x2a
	return len(dAtA) - i, nil
}
func (m *HttpRule_Patch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HttpRule_Patch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Patch)
	copy(dAtA[i:], m.Patch)
	i = encodeVarintHttp(dAtA, i, uint64(len(m.Patch)))
	i--
	dAtA[i] = 0x32
	return len(dAtA) - i, nil
}
func (m *HttpRule_Custom) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HttpRule_Custom) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Custom != nil {
		{
			size, err := m.Custom.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintHttp(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	return len(dAtA) - i, nil
}
func (m *CustomHttpPattern) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CustomHttpPattern) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CustomHttpPattern) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Path) > 0 {
		i -= len(m.Path)
		copy(dAtA[i:], m.Path)
		i = encodeVarintHttp(dAtA, i, uint64(len(m.Path)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Kind) > 0 {
		i -= len(m.Kind)
		copy(dAtA[i:], m.Kind)
		i = encodeVarintHttp(dAtA, i, uint64(len(m.Kind)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintHttp(dAtA []byte, offset int, v uint64) int {
	offset -= sovHttp(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func NewPopulatedHttp(r randyHttp, easy bool) *Http {
	this := &Http{}
	if r.Intn(5) == 0 {
		v1 := r.Intn(5)
		this.Rules = make([]*HttpRule, v1)
		for i := 0; i < v1; i++ {
			this.Rules[i] = NewPopulatedHttpRule(r, easy)
		}
	}
	this.FullyDecodeReservedExpansion = bool(bool(r.Intn(2) == 0))
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedHttp(r, 3)
	}
	return this
}

func NewPopulatedHttpRule(r randyHttp, easy bool) *HttpRule {
	this := &HttpRule{}
	this.Selector = string(randStringHttp(r))
	oneofNumber_Pattern := []int32{2, 3, 4, 5, 6, 8}[r.Intn(6)]
	switch oneofNumber_Pattern {
	case 2:
		this.Pattern = NewPopulatedHttpRule_Get(r, easy)
	case 3:
		this.Pattern = NewPopulatedHttpRule_Put(r, easy)
	case 4:
		this.Pattern = NewPopulatedHttpRule_Post(r, easy)
	case 5:
		this.Pattern = NewPopulatedHttpRule_Delete(r, easy)
	case 6:
		this.Pattern = NewPopulatedHttpRule_Patch(r, easy)
	case 8:
		this.Pattern = NewPopulatedHttpRule_Custom(r, easy)
	}
	this.Body = string(randStringHttp(r))
	if r.Intn(5) == 0 {
		v2 := r.Intn(5)
		this.AdditionalBindings = make([]*HttpRule, v2)
		for i := 0; i < v2; i++ {
			this.AdditionalBindings[i] = NewPopulatedHttpRule(r, easy)
		}
	}
	this.ResponseBody = string(randStringHttp(r))
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedHttp(r, 13)
	}
	return this
}

func NewPopulatedHttpRule_Get(r randyHttp, easy bool) *HttpRule_Get {
	this := &HttpRule_Get{}
	this.Get = string(randStringHttp(r))
	return this
}
func NewPopulatedHttpRule_Put(r randyHttp, easy bool) *HttpRule_Put {
	this := &HttpRule_Put{}
	this.Put = string(randStringHttp(r))
	return this
}
func NewPopulatedHttpRule_Post(r randyHttp, easy bool) *HttpRule_Post {
	this := &HttpRule_Post{}
	this.Post = string(randStringHttp(r))
	return this
}
func NewPopulatedHttpRule_Delete(r randyHttp, easy bool) *HttpRule_Delete {
	this := &HttpRule_Delete{}
	this.Delete = string(randStringHttp(r))
	return this
}
func NewPopulatedHttpRule_Patch(r randyHttp, easy bool) *HttpRule_Patch {
	this := &HttpRule_Patch{}
	this.Patch = string(randStringHttp(r))
	return this
}
func NewPopulatedHttpRule_Custom(r randyHttp, easy bool) *HttpRule_Custom {
	this := &HttpRule_Custom{}
	this.Custom = NewPopulatedCustomHttpPattern(r, easy)
	return this
}
func NewPopulatedCustomHttpPattern(r randyHttp, easy bool) *CustomHttpPattern {
	this := &CustomHttpPattern{}
	this.Kind = string(randStringHttp(r))
	this.Path = string(randStringHttp(r))
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedHttp(r, 3)
	}
	return this
}

type randyHttp interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneHttp(r randyHttp) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringHttp(r randyHttp) string {
	v3 := r.Intn(100)
	tmps := make([]rune, v3)
	for i := 0; i < v3; i++ {
		tmps[i] = randUTF8RuneHttp(r)
	}
	return string(tmps)
}
func randUnrecognizedHttp(r randyHttp, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldHttp(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldHttp(dAtA []byte, r randyHttp, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulateHttp(dAtA, uint64(key))
		v4 := r.Int63()
		if r.Intn(2) == 0 {
			v4 *= -1
		}
		dAtA = encodeVarintPopulateHttp(dAtA, uint64(v4))
	case 1:
		dAtA = encodeVarintPopulateHttp(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulateHttp(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulateHttp(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulateHttp(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulateHttp(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *Http) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Rules) > 0 {
		for _, e := range m.Rules {
			l = e.Size()
			n += 1 + l + sovHttp(uint64(l))
		}
	}
	if m.FullyDecodeReservedExpansion {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HttpRule) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Selector)
	if l > 0 {
		n += 1 + l + sovHttp(uint64(l))
	}
	if m.Pattern != nil {
		n += m.Pattern.Size()
	}
	l = len(m.Body)
	if l > 0 {
		n += 1 + l + sovHttp(uint64(l))
	}
	if len(m.AdditionalBindings) > 0 {
		for _, e := range m.AdditionalBindings {
			l = e.Size()
			n += 1 + l + sovHttp(uint64(l))
		}
	}
	l = len(m.ResponseBody)
	if l > 0 {
		n += 1 + l + sovHttp(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HttpRule_Get) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Get)
	n += 1 + l + sovHttp(uint64(l))
	return n
}
func (m *HttpRule_Put) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Put)
	n += 1 + l + sovHttp(uint64(l))
	return n
}
func (m *HttpRule_Post) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Post)
	n += 1 + l + sovHttp(uint64(l))
	return n
}
func (m *HttpRule_Delete) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Delete)
	n += 1 + l + sovHttp(uint64(l))
	return n
}
func (m *HttpRule_Patch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Patch)
	n += 1 + l + sovHttp(uint64(l))
	return n
}
func (m *HttpRule_Custom) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Custom != nil {
		l = m.Custom.Size()
		n += 1 + l + sovHttp(uint64(l))
	}
	return n
}
func (m *CustomHttpPattern) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Kind)
	if l > 0 {
		n += 1 + l + sovHttp(uint64(l))
	}
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovHttp(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovHttp(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozHttp(x uint64) (n int) {
	return sovHttp(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Http) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForRules := "[]*HttpRule{"
	for _, f := range this.Rules {
		repeatedStringForRules += strings.Replace(f.String(), "HttpRule", "HttpRule", 1) + ","
	}
	repeatedStringForRules += "}"
	s := strings.Join([]string{`&Http{`,
		`Rules:` + repeatedStringForRules + `,`,
		`FullyDecodeReservedExpansion:` + fmt.Sprintf("%v", this.FullyDecodeReservedExpansion) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HttpRule) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForAdditionalBindings := "[]*HttpRule{"
	for _, f := range this.AdditionalBindings {
		repeatedStringForAdditionalBindings += strings.Replace(f.String(), "HttpRule", "HttpRule", 1) + ","
	}
	repeatedStringForAdditionalBindings += "}"
	s := strings.Join([]string{`&HttpRule{`,
		`Selector:` + fmt.Sprintf("%v", this.Selector) + `,`,
		`Pattern:` + fmt.Sprintf("%v", this.Pattern) + `,`,
		`Body:` + fmt.Sprintf("%v", this.Body) + `,`,
		`AdditionalBindings:` + repeatedStringForAdditionalBindings + `,`,
		`ResponseBody:` + fmt.Sprintf("%v", this.ResponseBody) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HttpRule_Get) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HttpRule_Get{`,
		`Get:` + fmt.Sprintf("%v", this.Get) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HttpRule_Put) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HttpRule_Put{`,
		`Put:` + fmt.Sprintf("%v", this.Put) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HttpRule_Post) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HttpRule_Post{`,
		`Post:` + fmt.Sprintf("%v", this.Post) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HttpRule_Delete) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HttpRule_Delete{`,
		`Delete:` + fmt.Sprintf("%v", this.Delete) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HttpRule_Patch) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HttpRule_Patch{`,
		`Patch:` + fmt.Sprintf("%v", this.Patch) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HttpRule_Custom) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HttpRule_Custom{`,
		`Custom:` + strings.Replace(fmt.Sprintf("%v", this.Custom), "CustomHttpPattern", "CustomHttpPattern", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CustomHttpPattern) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CustomHttpPattern{`,
		`Kind:` + fmt.Sprintf("%v", this.Kind) + `,`,
		`Path:` + fmt.Sprintf("%v", this.Path) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringHttp(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Http) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHttp
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Http: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Http: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rules", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttp
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHttp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Rules = append(m.Rules, &HttpRule{})
			if err := m.Rules[len(m.Rules)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FullyDecodeReservedExpansion", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.FullyDecodeReservedExpansion = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipHttp(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthHttp
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HttpRule) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHttp
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HttpRule: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HttpRule: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Selector", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHttp
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHttp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Selector = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Get", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHttp
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHttp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Pattern = &HttpRule_Get{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Put", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHttp
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHttp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Pattern = &HttpRule_Put{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Post", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHttp
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHttp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Pattern = &HttpRule_Post{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Delete", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHttp
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHttp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Pattern = &HttpRule_Delete{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Patch", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHttp
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHttp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Pattern = &HttpRule_Patch{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Body", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHttp
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHttp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Body = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Custom", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttp
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHttp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &CustomHttpPattern{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Pattern = &HttpRule_Custom{v}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdditionalBindings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttp
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHttp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AdditionalBindings = append(m.AdditionalBindings, &HttpRule{})
			if err := m.AdditionalBindings[len(m.AdditionalBindings)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseBody", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHttp
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHttp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResponseBody = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipHttp(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthHttp
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CustomHttpPattern) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHttp
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CustomHttpPattern: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CustomHttpPattern: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHttp
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHttp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHttp
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHttp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipHttp(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthHttp
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipHttp(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowHttp
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowHttp
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowHttp
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthHttp
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupHttp
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthHttp
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthHttp        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowHttp          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupHttp = fmt.Errorf("proto: unexpected end of group")
)
