/* main-window.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from main-window.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 *
 * Copyright (C) 2011,2012 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Robert Ancell <robert.ancell@canonical.com>
 *          Michael Terry <michael.terry@canonical.com>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <lightdm.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <atk/atk.h>
#include <glib/gi18n-lib.h>
#include "config.h"
#include <glib/gstdio.h>

#define MAIN_WINDOW_MENUBAR_HEIGHT 32
#define UG_SETTINGS_KEY_CONTENT_ALIGN "content-align"
#define grid_size 40
#define UG_SETTINGS_KEY_BACKGROUND_COLOR "background-color"
#define GREETER_LIST_BORDER 4
#define UG_SETTINGS_KEY_ONLY_ON_MONITOR "only-on-monitor"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MENU_BAR (menu_bar_get_type ())
#define MENU_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MENU_BAR, MenuBar))
#define MENU_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MENU_BAR, MenuBarClass))
#define IS_MENU_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MENU_BAR))
#define IS_MENU_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MENU_BAR))
#define MENU_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MENU_BAR, MenuBarClass))

typedef struct _MenuBar MenuBar;
typedef struct _MenuBarClass MenuBarClass;

#define TYPE_LIST_STACK (list_stack_get_type ())
#define LIST_STACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIST_STACK, ListStack))
#define LIST_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIST_STACK, ListStackClass))
#define IS_LIST_STACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIST_STACK))
#define IS_LIST_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIST_STACK))
#define LIST_STACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIST_STACK, ListStackClass))

typedef struct _ListStack ListStack;
typedef struct _ListStackClass ListStackClass;

#define TYPE_MONITOR (monitor_get_type ())
#define MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITOR, Monitor))
#define MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MONITOR, MonitorClass))
#define IS_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITOR))
#define IS_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MONITOR))
#define MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MONITOR, MonitorClass))

typedef struct _Monitor Monitor;
typedef struct _MonitorClass MonitorClass;

#define TYPE_BACKGROUND (background_get_type ())
#define BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND, Background))
#define BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND, BackgroundClass))
#define IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND))
#define IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND))
#define BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND, BackgroundClass))

typedef struct _Background Background;
typedef struct _BackgroundClass BackgroundClass;

#define TYPE_SHUTDOWN_DIALOG (shutdown_dialog_get_type ())
#define SHUTDOWN_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SHUTDOWN_DIALOG, ShutdownDialog))
#define SHUTDOWN_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SHUTDOWN_DIALOG, ShutdownDialogClass))
#define IS_SHUTDOWN_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SHUTDOWN_DIALOG))
#define IS_SHUTDOWN_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SHUTDOWN_DIALOG))
#define SHUTDOWN_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SHUTDOWN_DIALOG, ShutdownDialogClass))

typedef struct _ShutdownDialog ShutdownDialog;
typedef struct _ShutdownDialogClass ShutdownDialogClass;
enum  {
	MAIN_WINDOW_0_PROPERTY,
	MAIN_WINDOW_NUM_PROPERTIES
};
static GParamSpec* main_window_properties[MAIN_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _monitor_unref0(var) ((var == NULL) ? NULL : (var = (monitor_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_FADABLE_BOX (fadable_box_get_type ())
#define FADABLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADABLE_BOX, FadableBox))
#define FADABLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FADABLE_BOX, FadableBoxClass))
#define IS_FADABLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADABLE_BOX))
#define IS_FADABLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FADABLE_BOX))
#define FADABLE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FADABLE_BOX, FadableBoxClass))

typedef struct _FadableBox FadableBox;
typedef struct _FadableBoxClass FadableBoxClass;

#define TYPE_GREETER_LIST (greeter_list_get_type ())
#define GREETER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GREETER_LIST, GreeterList))
#define GREETER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GREETER_LIST, GreeterListClass))
#define IS_GREETER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GREETER_LIST))
#define IS_GREETER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GREETER_LIST))
#define GREETER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GREETER_LIST, GreeterListClass))

typedef struct _GreeterList GreeterList;
typedef struct _GreeterListClass GreeterListClass;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _MonitorPrivate MonitorPrivate;

#define TYPE_USER_LIST (user_list_get_type ())
#define USER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_LIST, UserList))
#define USER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_LIST, UserListClass))
#define IS_USER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_LIST))
#define IS_USER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_LIST))
#define USER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_LIST, UserListClass))

typedef struct _UserList UserList;
typedef struct _UserListClass UserListClass;

#define TYPE_DASH_BOX (dash_box_get_type ())
#define DASH_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DASH_BOX, DashBox))
#define DASH_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DASH_BOX, DashBoxClass))
#define IS_DASH_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DASH_BOX))
#define IS_DASH_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DASH_BOX))
#define DASH_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DASH_BOX, DashBoxClass))

typedef struct _DashBox DashBox;
typedef struct _DashBoxClass DashBoxClass;

#define TYPE_FADABLE (fadable_get_type ())
#define FADABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADABLE, Fadable))
#define IS_FADABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADABLE))
#define FADABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FADABLE, FadableIface))

typedef struct _Fadable Fadable;
typedef struct _FadableIface FadableIface;

#define TYPE_FADE_TRACKER (fade_tracker_get_type ())
#define FADE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADE_TRACKER, FadeTracker))
#define FADE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FADE_TRACKER, FadeTrackerClass))
#define IS_FADE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADE_TRACKER))
#define IS_FADE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FADE_TRACKER))
#define FADE_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FADE_TRACKER, FadeTrackerClass))

typedef struct _FadeTracker FadeTracker;
typedef struct _FadeTrackerClass FadeTrackerClass;
typedef struct _FadableBoxPrivate FadableBoxPrivate;
typedef struct _GreeterListPrivate GreeterListPrivate;

#define TYPE_PROMPT_BOX (prompt_box_get_type ())
#define PROMPT_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROMPT_BOX, PromptBox))
#define PROMPT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROMPT_BOX, PromptBoxClass))
#define IS_PROMPT_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROMPT_BOX))
#define IS_PROMPT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROMPT_BOX))
#define PROMPT_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROMPT_BOX, PromptBoxClass))

typedef struct _PromptBox PromptBox;
typedef struct _PromptBoxClass PromptBoxClass;
typedef enum  {
	GREETER_LIST_MODE_ENTRY,
	GREETER_LIST_MODE_SCROLLING
} GreeterListMode;

#define GREETER_LIST_TYPE_MODE (greeter_list_mode_get_type ())

#define TYPE_SESSION_LIST (session_list_get_type ())
#define SESSION_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SESSION_LIST, SessionList))
#define SESSION_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SESSION_LIST, SessionListClass))
#define IS_SESSION_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SESSION_LIST))
#define IS_SESSION_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SESSION_LIST))
#define SESSION_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SESSION_LIST, SessionListClass))

typedef struct _SessionList SessionList;
typedef struct _SessionListClass SessionListClass;
typedef enum  {
	GREETER_LIST_SCROLL_TARGET_START,
	GREETER_LIST_SCROLL_TARGET_END,
	GREETER_LIST_SCROLL_TARGET_UP,
	GREETER_LIST_SCROLL_TARGET_DOWN
} GreeterListScrollTarget;

#define GREETER_LIST_TYPE_SCROLL_TARGET (greeter_list_scroll_target_get_type ())
typedef enum  {
	SHUTDOWN_DIALOG_TYPE_LOGOUT,
	SHUTDOWN_DIALOG_TYPE_SHUTDOWN,
	SHUTDOWN_DIALOG_TYPE_RESTART
} ShutdownDialogType;

#define TYPE_SHUTDOWN_DIALOG_TYPE (shutdown_dialog_type_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_SLICK_GREETER (slick_greeter_get_type ())
#define SLICK_GREETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SLICK_GREETER, SlickGreeter))
#define SLICK_GREETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SLICK_GREETER, SlickGreeterClass))
#define IS_SLICK_GREETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SLICK_GREETER))
#define IS_SLICK_GREETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SLICK_GREETER))
#define SLICK_GREETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SLICK_GREETER, SlickGreeterClass))

typedef struct _SlickGreeter SlickGreeter;
typedef struct _SlickGreeterClass SlickGreeterClass;
typedef struct _SlickGreeterPrivate SlickGreeterPrivate;

#define TYPE_FLAT_BUTTON (flat_button_get_type ())
#define FLAT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FLAT_BUTTON, FlatButton))
#define FLAT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FLAT_BUTTON, FlatButtonClass))
#define IS_FLAT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FLAT_BUTTON))
#define IS_FLAT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FLAT_BUTTON))
#define FLAT_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FLAT_BUTTON, FlatButtonClass))

typedef struct _FlatButton FlatButton;
typedef struct _FlatButtonClass FlatButtonClass;

struct _MainWindow {
	GtkWindow parent_instance;
	MainWindowPrivate * priv;
	MenuBar* menubar;
	ListStack* stack;
};

struct _MainWindowClass {
	GtkWindowClass parent_class;
};

struct _MainWindowPrivate {
	GList* monitors;
	Monitor* primary_monitor;
	Monitor* active_monitor;
	gchar* only_on_monitor;
	gboolean monitor_setting_ok;
	Background* background;
	GtkBox* login_box;
	GtkBox* hbox;
	GtkBox* content_box;
	GtkButton* back_button;
	ShutdownDialog* shutdown_dialog;
	gboolean do_resize;
};

struct _Monitor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MonitorPrivate * priv;
	gint x;
	gint y;
	gint width;
	gint height;
};

struct _MonitorClass {
	GTypeClass parent_class;
	void (*finalize) (Monitor *self);
};

struct _FadableIface {
	GTypeInterface parent_iface;
	FadeTracker* (*get_fade_tracker) (Fadable* self);
	void (*set_fade_tracker) (Fadable* self, FadeTracker* value);
};

struct _FadableBox {
	GtkEventBox parent_instance;
	FadableBoxPrivate * priv;
};

struct _FadableBoxClass {
	GtkEventBoxClass parent_class;
	void (*draw_full_alpha) (FadableBox* self, cairo_t* c);
};

struct _GreeterList {
	FadableBox parent_instance;
	GreeterListPrivate * priv;
	gchar* greeter_authenticating_user;
	gboolean _always_show_manual;
	GList* entries;
	DashBox* greeter_box;
	GreeterListMode mode;
	gboolean will_clear;
	gboolean prompted;
	gboolean unacknowledged_messages;
	gchar* test_username;
	gboolean test_is_authenticated;
};

struct _GreeterListClass {
	FadableBoxClass parent_class;
	gchar* (*get_selected_id) (GreeterList* self);
	void (*focus_prompt) (GreeterList* self);
	void (*show_authenticated) (GreeterList* self, gboolean successful);
	void (*insert_entry) (GreeterList* self, PromptBox* entry);
	void (*add_manual_entry) (GreeterList* self);
	gint (*get_position_y) (GreeterList* self, gdouble position);
	void (*setup_prompt_box) (GreeterList* self, gboolean fade);
	void (*show_prompt_cb) (GreeterList* self, const gchar* text, LightDMPromptType type);
	void (*authentication_complete_cb) (GreeterList* self);
	void (*start_authentication) (GreeterList* self);
	gchar* (*get_lightdm_session) (GreeterList* self);
	void (*test_start_authentication) (GreeterList* self);
};

struct _SlickGreeter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SlickGreeterPrivate * priv;
	gboolean test_mode;
	gboolean orca_needs_kick;
};

struct _SlickGreeterClass {
	GTypeClass parent_class;
	void (*finalize) (SlickGreeter *self);
};

static gint MainWindow_private_offset;
static gpointer main_window_parent_class = NULL;
VALA_EXTERN SlickGreeter* slick_greeter_singleton;

VALA_EXTERN GType main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
VALA_EXTERN GType menu_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MenuBar, g_object_unref)
VALA_EXTERN GType list_stack_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ListStack, g_object_unref)
VALA_EXTERN gpointer monitor_ref (gpointer instance);
VALA_EXTERN void monitor_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_monitor (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
VALA_EXTERN void value_set_monitor (GValue* value,
                        gpointer v_object);
VALA_EXTERN void value_take_monitor (GValue* value,
                         gpointer v_object);
VALA_EXTERN gpointer value_get_monitor (const GValue* value);
VALA_EXTERN GType monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Monitor, monitor_unref)
VALA_EXTERN GType background_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Background, g_object_unref)
VALA_EXTERN GType shutdown_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ShutdownDialog, g_object_unref)
static void _monitor_unref0_ (gpointer var);
static inline void _g_list_free__monitor_unref0_ (GList* self);
VALA_EXTERN GType fadable_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FadableBox, g_object_unref)
VALA_EXTERN GType greeter_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterList, g_object_unref)
VALA_EXTERN void main_window_push_list (MainWindow* self,
                            GreeterList* widget);
VALA_EXTERN void list_stack_push (ListStack* self,
                      GreeterList* pushed);
VALA_EXTERN guint list_stack_get_num_children (ListStack* self);
VALA_EXTERN void main_window_pop_list (MainWindow* self);
VALA_EXTERN void list_stack_pop (ListStack* self);
static void main_window_real_size_allocate (GtkWidget* base,
                                     GtkAllocation* allocation);
VALA_EXTERN gchar* ug_settings_get_string (const gchar* key);
VALA_EXTERN gint get_grid_offset (gint size);
static void main_window_real_realize (GtkWidget* base);
VALA_EXTERN void background_set_surface (Background* self,
                             cairo_surface_t* target_surface);
VALA_EXTERN void main_window_before_session_start (MainWindow* self);
VALA_EXTERN void menu_bar_cleanup (MenuBar* self);
VALA_EXTERN void main_window_setup_window (MainWindow* self);
VALA_EXTERN gint background_get_width (Background* self);
VALA_EXTERN gint background_get_height (Background* self);
static void main_window_move_to_monitor (MainWindow* self,
                                  Monitor* monitor);
static void main_window_monitors_changed_cb (MainWindow* self,
                                      GdkScreen* screen);
static gboolean main_window_monitor_is_unique_position (MainWindow* self,
                                                 GdkDisplay* display,
                                                 gint n);
VALA_EXTERN Monitor* monitor_new (gint x,
                      gint y,
                      gint width,
                      gint height);
VALA_EXTERN Monitor* monitor_construct (GType object_type,
                            gint x,
                            gint y,
                            gint width,
                            gint height);
VALA_EXTERN void background_set_monitors (Background* self,
                              GList* monitors);
static gboolean main_window_real_motion_notify_event (GtkWidget* base,
                                               GdkEventMotion* event);
VALA_EXTERN void background_set_active_monitor (Background* self,
                                    Monitor* monitor);
VALA_EXTERN void shutdown_dialog_set_active_monitor (ShutdownDialog* self,
                                         Monitor* m);
static void main_window_add_user_list (MainWindow* self);
VALA_EXTERN UserList* user_list_new (Background* bg,
                         MenuBar* mb);
VALA_EXTERN UserList* user_list_construct (GType object_type,
                               Background* bg,
                               MenuBar* mb);
VALA_EXTERN GType user_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UserList, g_object_unref)
VALA_EXTERN void slick_greeter_add_style_class (GtkWidget* widget);
VALA_EXTERN GType dash_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DashBox, g_object_unref)
VALA_EXTERN void background_connect_to_dashbox_transitions (Background* self,
                                                DashBox* dashbox);
VALA_EXTERN GType fade_tracker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FadeTracker, g_object_unref)
VALA_EXTERN GType fadable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Fadable, g_object_unref)
VALA_EXTERN GType prompt_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PromptBox, g_object_unref)
VALA_EXTERN GType greeter_list_mode_get_type (void) G_GNUC_CONST ;
static gboolean main_window_real_key_press_event (GtkWidget* base,
                                           GdkEventKey* event);
VALA_EXTERN GreeterList* list_stack_top (ListStack* self);
VALA_EXTERN gboolean user_list_get_show_hidden_users (UserList* self);
VALA_EXTERN void user_list_set_show_hidden_users (UserList* self,
                                      gboolean value);
VALA_EXTERN GType session_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SessionList, g_object_unref)
VALA_EXTERN void greeter_list_cancel_authentication (GreeterList* self);
VALA_EXTERN void shutdown_dialog_cancel (ShutdownDialog* self);
VALA_EXTERN GType greeter_list_scroll_target_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void greeter_list_scroll (GreeterList* self,
                          GreeterListScrollTarget target);
VALA_EXTERN GType shutdown_dialog_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void main_window_show_shutdown_dialog (MainWindow* self,
                                       ShutdownDialogType type);
VALA_EXTERN gpointer slick_greeter_ref (gpointer instance);
VALA_EXTERN void slick_greeter_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_slick_greeter (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void value_set_slick_greeter (GValue* value,
                              gpointer v_object);
VALA_EXTERN void value_take_slick_greeter (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer value_get_slick_greeter (const GValue* value);
VALA_EXTERN GType slick_greeter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SlickGreeter, slick_greeter_unref)
VALA_EXTERN void main_window_set_keyboard_state (MainWindow* self);
VALA_EXTERN void menu_bar_set_keyboard_state (MenuBar* self);
VALA_EXTERN ShutdownDialog* shutdown_dialog_new (ShutdownDialogType type,
                                     Background* bg);
VALA_EXTERN ShutdownDialog* shutdown_dialog_construct (GType object_type,
                                           ShutdownDialogType type,
                                           Background* bg);
VALA_EXTERN void main_window_close_shutdown_dialog (MainWindow* self);
static void _main_window_close_shutdown_dialog_shutdown_dialog_closed (ShutdownDialog* _sender,
                                                                gpointer self);
VALA_EXTERN MainWindow* main_window_new (void);
VALA_EXTERN MainWindow* main_window_construct (GType object_type);
static GObject * main_window_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties);
VALA_EXTERN Background* background_new (void);
VALA_EXTERN Background* background_construct (GType object_type);
VALA_EXTERN MenuBar* menu_bar_new (Background* bg,
                       GtkAccelGroup* ag,
                       MainWindow* mw);
VALA_EXTERN MenuBar* menu_bar_construct (GType object_type,
                             Background* bg,
                             GtkAccelGroup* ag,
                             MainWindow* mw);
VALA_EXTERN FlatButton* flat_button_new (void);
VALA_EXTERN FlatButton* flat_button_construct (GType object_type);
VALA_EXTERN GType flat_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FlatButton, g_object_unref)
static void _main_window_pop_list_gtk_button_clicked (GtkButton* _sender,
                                               gpointer self);
VALA_EXTERN ListStack* list_stack_new (void);
VALA_EXTERN ListStack* list_stack_construct (GType object_type);
static void _main_window_monitors_changed_cb_gdk_screen_monitors_changed (GdkScreen* _sender,
                                                                   gpointer self);
static void main_window_finalize (GObject * obj);
static GType main_window_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
main_window_get_instance_private (MainWindow* self)
{
	return G_STRUCT_MEMBER_P (self, MainWindow_private_offset);
}

static void
_monitor_unref0_ (gpointer var)
{
#line 25 "../src/main-window.vala"
	(var == NULL) ? NULL : (var = (monitor_unref (var), NULL));
#line 537 "main-window.c"
}

static inline void
_g_list_free__monitor_unref0_ (GList* self)
{
#line 25 "../src/main-window.vala"
	g_list_free_full (self, (GDestroyNotify) _monitor_unref0_);
#line 545 "main-window.c"
}

void
main_window_push_list (MainWindow* self,
                       GreeterList* widget)
{
	ListStack* _tmp0_;
	ListStack* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
#line 196 "../src/main-window.vala"
	g_return_if_fail (self != NULL);
#line 196 "../src/main-window.vala"
	g_return_if_fail (widget != NULL);
#line 198 "../src/main-window.vala"
	_tmp0_ = self->stack;
#line 198 "../src/main-window.vala"
	list_stack_push (_tmp0_, widget);
#line 200 "../src/main-window.vala"
	_tmp1_ = self->stack;
#line 200 "../src/main-window.vala"
	_tmp2_ = list_stack_get_num_children (_tmp1_);
#line 200 "../src/main-window.vala"
	_tmp3_ = _tmp2_;
#line 200 "../src/main-window.vala"
	if (_tmp3_ > ((guint) 1)) {
#line 572 "main-window.c"
		GtkButton* _tmp4_;
#line 201 "../src/main-window.vala"
		_tmp4_ = self->priv->back_button;
#line 201 "../src/main-window.vala"
		gtk_widget_show ((GtkWidget*) _tmp4_);
#line 578 "main-window.c"
	}
}

void
main_window_pop_list (MainWindow* self)
{
	ListStack* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	ListStack* _tmp4_;
#line 204 "../src/main-window.vala"
	g_return_if_fail (self != NULL);
#line 206 "../src/main-window.vala"
	_tmp0_ = self->stack;
#line 206 "../src/main-window.vala"
	_tmp1_ = list_stack_get_num_children (_tmp0_);
#line 206 "../src/main-window.vala"
	_tmp2_ = _tmp1_;
#line 206 "../src/main-window.vala"
	if (_tmp2_ <= ((guint) 2)) {
#line 599 "main-window.c"
		GtkButton* _tmp3_;
#line 207 "../src/main-window.vala"
		_tmp3_ = self->priv->back_button;
#line 207 "../src/main-window.vala"
		gtk_widget_hide ((GtkWidget*) _tmp3_);
#line 605 "main-window.c"
	}
#line 209 "../src/main-window.vala"
	_tmp4_ = self->stack;
#line 209 "../src/main-window.vala"
	list_stack_pop (_tmp4_);
#line 611 "main-window.c"
}

static void
main_window_real_size_allocate (GtkWidget* base,
                                GtkAllocation* allocation)
{
	MainWindow * self;
	GtkAllocation _tmp0_;
	GtkBox* _tmp1_;
#line 212 "../src/main-window.vala"
	self = (MainWindow*) base;
#line 212 "../src/main-window.vala"
	g_return_if_fail (allocation != NULL);
#line 214 "../src/main-window.vala"
	_tmp0_ = *allocation;
#line 214 "../src/main-window.vala"
	GTK_WIDGET_CLASS (main_window_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), &_tmp0_);
#line 216 "../src/main-window.vala"
	_tmp1_ = self->priv->content_box;
#line 216 "../src/main-window.vala"
	if (_tmp1_ != NULL) {
#line 633 "main-window.c"
		gchar* content_align = NULL;
		gchar* _tmp2_;
		gint _tmp3_ = 0;
		const gchar* _tmp4_;
		GtkBox* _tmp5_;
		gint _tmp6_ = 0;
		const gchar* _tmp7_;
		GtkBox* _tmp8_;
		GtkBox* _tmp9_;
		GtkBox* _tmp10_;
#line 218 "../src/main-window.vala"
		_tmp2_ = ug_settings_get_string (UG_SETTINGS_KEY_CONTENT_ALIGN);
#line 218 "../src/main-window.vala"
		content_align = _tmp2_;
#line 219 "../src/main-window.vala"
		_tmp4_ = content_align;
#line 219 "../src/main-window.vala"
		if (g_strcmp0 (_tmp4_, "left") == 0) {
#line 219 "../src/main-window.vala"
			_tmp3_ = grid_size;
#line 654 "main-window.c"
		} else {
#line 219 "../src/main-window.vala"
			_tmp3_ = 0;
#line 658 "main-window.c"
		}
#line 219 "../src/main-window.vala"
		_tmp5_ = self->priv->content_box;
#line 219 "../src/main-window.vala"
		gtk_widget_set_margin_left ((GtkWidget*) _tmp5_, get_grid_offset (gtk_widget_get_allocated_width ((GtkWidget*) self)) + _tmp3_);
#line 220 "../src/main-window.vala"
		_tmp7_ = content_align;
#line 220 "../src/main-window.vala"
		if (g_strcmp0 (_tmp7_, "right") == 0) {
#line 220 "../src/main-window.vala"
			_tmp6_ = grid_size;
#line 670 "main-window.c"
		} else {
#line 220 "../src/main-window.vala"
			_tmp6_ = 0;
#line 674 "main-window.c"
		}
#line 220 "../src/main-window.vala"
		_tmp8_ = self->priv->content_box;
#line 220 "../src/main-window.vala"
		gtk_widget_set_margin_right ((GtkWidget*) _tmp8_, get_grid_offset (gtk_widget_get_allocated_width ((GtkWidget*) self)) + _tmp6_);
#line 221 "../src/main-window.vala"
		_tmp9_ = self->priv->content_box;
#line 221 "../src/main-window.vala"
		gtk_widget_set_margin_top ((GtkWidget*) _tmp9_, get_grid_offset (gtk_widget_get_allocated_height ((GtkWidget*) self)));
#line 222 "../src/main-window.vala"
		_tmp10_ = self->priv->content_box;
#line 222 "../src/main-window.vala"
		gtk_widget_set_margin_bottom ((GtkWidget*) _tmp10_, get_grid_offset (gtk_widget_get_allocated_height ((GtkWidget*) self)));
#line 216 "../src/main-window.vala"
		_g_free0 (content_align);
#line 690 "main-window.c"
	}
}

static void
main_window_real_realize (GtkWidget* base)
{
	MainWindow * self;
	Background* _tmp0_;
	GdkWindow* _tmp1_;
	cairo_t* _tmp2_;
	cairo_t* _tmp3_;
	cairo_surface_t* _tmp4_;
#line 226 "../src/main-window.vala"
	self = (MainWindow*) base;
#line 228 "../src/main-window.vala"
	GTK_WIDGET_CLASS (main_window_parent_class)->realize ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
#line 229 "../src/main-window.vala"
	_tmp0_ = self->priv->background;
#line 229 "../src/main-window.vala"
	_tmp1_ = gtk_widget_get_window ((GtkWidget*) self);
#line 229 "../src/main-window.vala"
	_tmp2_ = gdk_cairo_create (_tmp1_);
#line 229 "../src/main-window.vala"
	_tmp3_ = _tmp2_;
#line 229 "../src/main-window.vala"
	_tmp4_ = cairo_get_target (_tmp3_);
#line 229 "../src/main-window.vala"
	background_set_surface (_tmp0_, _tmp4_);
#line 229 "../src/main-window.vala"
	_cairo_destroy0 (_tmp3_);
#line 721 "main-window.c"
}

void
main_window_before_session_start (MainWindow* self)
{
	MenuBar* _tmp0_;
#line 232 "../src/main-window.vala"
	g_return_if_fail (self != NULL);
#line 234 "../src/main-window.vala"
	g_debug ("main-window.vala:234: Killing orca and onboard");
#line 235 "../src/main-window.vala"
	_tmp0_ = self->menubar;
#line 235 "../src/main-window.vala"
	menu_bar_cleanup (_tmp0_);
#line 736 "main-window.c"
}

void
main_window_setup_window (MainWindow* self)
{
	Background* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	Background* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	Monitor* _tmp6_;
#line 239 "../src/main-window.vala"
	g_return_if_fail (self != NULL);
#line 241 "../src/main-window.vala"
	_tmp0_ = self->priv->background;
#line 241 "../src/main-window.vala"
	_tmp1_ = background_get_width (_tmp0_);
#line 241 "../src/main-window.vala"
	_tmp2_ = _tmp1_;
#line 241 "../src/main-window.vala"
	_tmp3_ = self->priv->background;
#line 241 "../src/main-window.vala"
	_tmp4_ = background_get_height (_tmp3_);
#line 241 "../src/main-window.vala"
	_tmp5_ = _tmp4_;
#line 241 "../src/main-window.vala"
	gtk_window_resize ((GtkWindow*) self, _tmp2_, _tmp5_);
#line 242 "../src/main-window.vala"
	gtk_window_move ((GtkWindow*) self, 0, 0);
#line 243 "../src/main-window.vala"
	_tmp6_ = self->priv->primary_monitor;
#line 243 "../src/main-window.vala"
	main_window_move_to_monitor (self, _tmp6_);
#line 771 "main-window.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 248 "../src/main-window.vala"
	return self ? g_object_ref (self) : NULL;
#line 779 "main-window.c"
}

static gpointer
_monitor_ref0 (gpointer self)
{
#line 265 "../src/main-window.vala"
	return self ? monitor_ref (self) : NULL;
#line 787 "main-window.c"
}

static void
main_window_monitors_changed_cb (MainWindow* self,
                                 GdkScreen* screen)
{
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkMonitor* primary = NULL;
	GdkDisplay* _tmp2_;
	GdkMonitor* _tmp3_;
	GdkMonitor* _tmp4_;
	GdkRectangle geometry = {0};
	Background* _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	Background* _tmp42_;
	gint _tmp43_;
	gint _tmp44_;
	Background* _tmp45_;
	GList* _tmp46_;
#line 246 "../src/main-window.vala"
	g_return_if_fail (self != NULL);
#line 246 "../src/main-window.vala"
	g_return_if_fail (screen != NULL);
#line 248 "../src/main-window.vala"
	_tmp0_ = gdk_screen_get_display (screen);
#line 248 "../src/main-window.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 248 "../src/main-window.vala"
	display = _tmp1_;
#line 249 "../src/main-window.vala"
	_tmp2_ = display;
#line 249 "../src/main-window.vala"
	_tmp3_ = gdk_display_get_primary_monitor (_tmp2_);
#line 249 "../src/main-window.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 249 "../src/main-window.vala"
	primary = _tmp4_;
#line 252 "../src/main-window.vala"
	(self->priv->monitors == NULL) ? NULL : (self->priv->monitors = (_g_list_free__monitor_unref0_ (self->priv->monitors), NULL));
#line 252 "../src/main-window.vala"
	self->priv->monitors = NULL;
#line 253 "../src/main-window.vala"
	_monitor_unref0 (self->priv->primary_monitor);
#line 253 "../src/main-window.vala"
	self->priv->primary_monitor = NULL;
#line 836 "main-window.c"
	{
		gint i = 0;
#line 255 "../src/main-window.vala"
		i = 0;
#line 841 "main-window.c"
		{
			gboolean _tmp5_ = FALSE;
#line 255 "../src/main-window.vala"
			_tmp5_ = TRUE;
#line 255 "../src/main-window.vala"
			while (TRUE) {
#line 848 "main-window.c"
				GdkDisplay* _tmp7_;
				GdkMonitor* monitor = NULL;
				GdkDisplay* _tmp8_;
				GdkMonitor* _tmp9_;
				GdkMonitor* _tmp10_;
				GdkMonitor* _tmp11_;
				GdkRectangle _tmp12_ = {0};
				GdkRectangle _tmp13_;
				GdkRectangle _tmp14_;
				GdkRectangle _tmp15_;
				GdkRectangle _tmp16_;
				GdkDisplay* _tmp17_;
#line 255 "../src/main-window.vala"
				if (!_tmp5_) {
#line 863 "main-window.c"
					gint _tmp6_;
#line 255 "../src/main-window.vala"
					_tmp6_ = i;
#line 255 "../src/main-window.vala"
					i = _tmp6_ + 1;
#line 869 "main-window.c"
				}
#line 255 "../src/main-window.vala"
				_tmp5_ = FALSE;
#line 255 "../src/main-window.vala"
				_tmp7_ = display;
#line 255 "../src/main-window.vala"
				if (!(i < gdk_display_get_n_monitors (_tmp7_))) {
#line 255 "../src/main-window.vala"
					break;
#line 879 "main-window.c"
				}
#line 257 "../src/main-window.vala"
				_tmp8_ = display;
#line 257 "../src/main-window.vala"
				_tmp9_ = gdk_display_get_monitor (_tmp8_, i);
#line 257 "../src/main-window.vala"
				_tmp10_ = _g_object_ref0 (_tmp9_);
#line 257 "../src/main-window.vala"
				monitor = _tmp10_;
#line 258 "../src/main-window.vala"
				_tmp11_ = monitor;
#line 258 "../src/main-window.vala"
				gdk_monitor_get_geometry (_tmp11_, &_tmp12_);
#line 258 "../src/main-window.vala"
				geometry = _tmp12_;
#line 259 "../src/main-window.vala"
				_tmp13_ = geometry;
#line 259 "../src/main-window.vala"
				_tmp14_ = geometry;
#line 259 "../src/main-window.vala"
				_tmp15_ = geometry;
#line 259 "../src/main-window.vala"
				_tmp16_ = geometry;
#line 259 "../src/main-window.vala"
				g_debug ("main-window.vala:259: Monitor %d is %dx%d pixels at %d,%d", i, _tmp13_.width, _tmp14_.height, _tmp15_.x, _tmp16_.y);
#line 261 "../src/main-window.vala"
				_tmp17_ = display;
#line 261 "../src/main-window.vala"
				if (main_window_monitor_is_unique_position (self, _tmp17_, i)) {
#line 909 "main-window.c"
					Monitor* greeter_monitor = NULL;
					GdkRectangle _tmp18_;
					GdkRectangle _tmp19_;
					GdkRectangle _tmp20_;
					GdkRectangle _tmp21_;
					Monitor* _tmp22_;
					gchar* plug_name = NULL;
					GdkMonitor* _tmp23_;
					const gchar* _tmp24_;
					gchar* _tmp25_;
					Monitor* _tmp26_;
					Monitor* _tmp27_;
					const gchar* _tmp28_;
					const gchar* _tmp29_;
					gboolean _tmp30_ = FALSE;
					gboolean _tmp31_ = FALSE;
					const gchar* _tmp32_;
					const gchar* _tmp33_;
#line 263 "../src/main-window.vala"
					_tmp18_ = geometry;
#line 263 "../src/main-window.vala"
					_tmp19_ = geometry;
#line 263 "../src/main-window.vala"
					_tmp20_ = geometry;
#line 263 "../src/main-window.vala"
					_tmp21_ = geometry;
#line 263 "../src/main-window.vala"
					_tmp22_ = monitor_new (_tmp18_.x, _tmp19_.y, _tmp20_.width, _tmp21_.height);
#line 263 "../src/main-window.vala"
					greeter_monitor = _tmp22_;
#line 264 "../src/main-window.vala"
					_tmp23_ = monitor;
#line 264 "../src/main-window.vala"
					_tmp24_ = gdk_monitor_get_model (_tmp23_);
#line 264 "../src/main-window.vala"
					_tmp25_ = g_strdup (_tmp24_);
#line 264 "../src/main-window.vala"
					plug_name = _tmp25_;
#line 265 "../src/main-window.vala"
					_tmp26_ = greeter_monitor;
#line 265 "../src/main-window.vala"
					_tmp27_ = _monitor_ref0 (_tmp26_);
#line 265 "../src/main-window.vala"
					self->priv->monitors = g_list_append (self->priv->monitors, _tmp27_);
#line 267 "../src/main-window.vala"
					_tmp28_ = plug_name;
#line 267 "../src/main-window.vala"
					_tmp29_ = self->priv->only_on_monitor;
#line 267 "../src/main-window.vala"
					if (g_strcmp0 (_tmp28_, _tmp29_) == 0) {
#line 268 "../src/main-window.vala"
						self->priv->monitor_setting_ok = TRUE;
#line 962 "main-window.c"
					}
#line 270 "../src/main-window.vala"
					_tmp32_ = plug_name;
#line 270 "../src/main-window.vala"
					_tmp33_ = self->priv->only_on_monitor;
#line 270 "../src/main-window.vala"
					if (g_strcmp0 (_tmp32_, _tmp33_) == 0) {
#line 270 "../src/main-window.vala"
						_tmp31_ = TRUE;
#line 972 "main-window.c"
					} else {
						Monitor* _tmp34_;
#line 270 "../src/main-window.vala"
						_tmp34_ = self->priv->primary_monitor;
#line 270 "../src/main-window.vala"
						_tmp31_ = _tmp34_ == NULL;
#line 979 "main-window.c"
					}
#line 270 "../src/main-window.vala"
					if (_tmp31_) {
#line 270 "../src/main-window.vala"
						_tmp30_ = TRUE;
#line 985 "main-window.c"
					} else {
						GdkMonitor* _tmp35_;
						GdkMonitor* _tmp36_;
#line 270 "../src/main-window.vala"
						_tmp35_ = primary;
#line 270 "../src/main-window.vala"
						_tmp36_ = monitor;
#line 270 "../src/main-window.vala"
						_tmp30_ = _tmp35_ == _tmp36_;
#line 995 "main-window.c"
					}
#line 270 "../src/main-window.vala"
					if (_tmp30_) {
#line 999 "main-window.c"
						Monitor* _tmp37_;
						Monitor* _tmp38_;
#line 271 "../src/main-window.vala"
						_tmp37_ = greeter_monitor;
#line 271 "../src/main-window.vala"
						_tmp38_ = _monitor_ref0 (_tmp37_);
#line 271 "../src/main-window.vala"
						_monitor_unref0 (self->priv->primary_monitor);
#line 271 "../src/main-window.vala"
						self->priv->primary_monitor = _tmp38_;
#line 1010 "main-window.c"
					}
#line 261 "../src/main-window.vala"
					_g_free0 (plug_name);
#line 261 "../src/main-window.vala"
					_monitor_unref0 (greeter_monitor);
#line 1016 "main-window.c"
				}
#line 255 "../src/main-window.vala"
				_g_object_unref0 (monitor);
#line 1020 "main-window.c"
			}
		}
	}
#line 275 "../src/main-window.vala"
	_tmp39_ = self->priv->background;
#line 275 "../src/main-window.vala"
	_tmp40_ = background_get_width (_tmp39_);
#line 275 "../src/main-window.vala"
	_tmp41_ = _tmp40_;
#line 275 "../src/main-window.vala"
	_tmp42_ = self->priv->background;
#line 275 "../src/main-window.vala"
	_tmp43_ = background_get_height (_tmp42_);
#line 275 "../src/main-window.vala"
	_tmp44_ = _tmp43_;
#line 275 "../src/main-window.vala"
	g_debug ("main-window.vala:275: MainWindow is %dx%d pixels", _tmp41_, _tmp44_);
#line 277 "../src/main-window.vala"
	_tmp45_ = self->priv->background;
#line 277 "../src/main-window.vala"
	_tmp46_ = self->priv->monitors;
#line 277 "../src/main-window.vala"
	background_set_monitors (_tmp45_, _tmp46_);
#line 279 "../src/main-window.vala"
	if (self->priv->do_resize) {
#line 281 "../src/main-window.vala"
		main_window_setup_window (self);
#line 1048 "main-window.c"
	} else {
#line 285 "../src/main-window.vala"
		self->priv->do_resize = TRUE;
#line 1052 "main-window.c"
	}
#line 246 "../src/main-window.vala"
	_g_object_unref0 (primary);
#line 246 "../src/main-window.vala"
	_g_object_unref0 (display);
#line 1058 "main-window.c"
}

static gboolean
main_window_monitor_is_unique_position (MainWindow* self,
                                        GdkDisplay* display,
                                        gint n)
{
	GdkRectangle g0 = {0};
	GdkMonitor* mon0 = NULL;
	GdkMonitor* _tmp0_;
	GdkMonitor* _tmp1_;
	GdkMonitor* _tmp2_;
	GdkRectangle _tmp3_ = {0};
	gboolean result;
#line 290 "../src/main-window.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 290 "../src/main-window.vala"
	g_return_val_if_fail (display != NULL, FALSE);
#line 294 "../src/main-window.vala"
	_tmp0_ = gdk_display_get_monitor (display, n);
#line 294 "../src/main-window.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 294 "../src/main-window.vala"
	_g_object_unref0 (mon0);
#line 294 "../src/main-window.vala"
	mon0 = _tmp1_;
#line 295 "../src/main-window.vala"
	_tmp2_ = mon0;
#line 295 "../src/main-window.vala"
	gdk_monitor_get_geometry (_tmp2_, &_tmp3_);
#line 295 "../src/main-window.vala"
	g0 = _tmp3_;
#line 1091 "main-window.c"
	{
		gint i = 0;
#line 297 "../src/main-window.vala"
		i = n + 1;
#line 1096 "main-window.c"
		{
			gboolean _tmp4_ = FALSE;
#line 297 "../src/main-window.vala"
			_tmp4_ = TRUE;
#line 297 "../src/main-window.vala"
			while (TRUE) {
#line 1103 "main-window.c"
				GdkRectangle g1 = {0};
				GdkMonitor* mon1 = NULL;
				GdkMonitor* _tmp6_;
				GdkMonitor* _tmp7_;
				GdkMonitor* _tmp8_;
				GdkRectangle _tmp9_ = {0};
				gboolean _tmp10_ = FALSE;
				GdkRectangle _tmp11_;
				GdkRectangle _tmp12_;
#line 297 "../src/main-window.vala"
				if (!_tmp4_) {
#line 1115 "main-window.c"
					gint _tmp5_;
#line 297 "../src/main-window.vala"
					_tmp5_ = i;
#line 297 "../src/main-window.vala"
					i = _tmp5_ + 1;
#line 1121 "main-window.c"
				}
#line 297 "../src/main-window.vala"
				_tmp4_ = FALSE;
#line 297 "../src/main-window.vala"
				if (!(i < gdk_display_get_n_monitors (display))) {
#line 297 "../src/main-window.vala"
					break;
#line 1129 "main-window.c"
				}
#line 301 "../src/main-window.vala"
				_tmp6_ = gdk_display_get_monitor (display, i);
#line 301 "../src/main-window.vala"
				_tmp7_ = _g_object_ref0 (_tmp6_);
#line 301 "../src/main-window.vala"
				_g_object_unref0 (mon1);
#line 301 "../src/main-window.vala"
				mon1 = _tmp7_;
#line 302 "../src/main-window.vala"
				_tmp8_ = mon1;
#line 302 "../src/main-window.vala"
				gdk_monitor_get_geometry (_tmp8_, &_tmp9_);
#line 302 "../src/main-window.vala"
				g1 = _tmp9_;
#line 304 "../src/main-window.vala"
				_tmp11_ = g0;
#line 304 "../src/main-window.vala"
				_tmp12_ = g1;
#line 304 "../src/main-window.vala"
				if (_tmp11_.x == _tmp12_.x) {
#line 1151 "main-window.c"
					GdkRectangle _tmp13_;
					GdkRectangle _tmp14_;
#line 304 "../src/main-window.vala"
					_tmp13_ = g0;
#line 304 "../src/main-window.vala"
					_tmp14_ = g1;
#line 304 "../src/main-window.vala"
					_tmp10_ = _tmp13_.y == _tmp14_.y;
#line 1160 "main-window.c"
				} else {
#line 304 "../src/main-window.vala"
					_tmp10_ = FALSE;
#line 1164 "main-window.c"
				}
#line 304 "../src/main-window.vala"
				if (_tmp10_) {
#line 305 "../src/main-window.vala"
					result = FALSE;
#line 305 "../src/main-window.vala"
					_g_object_unref0 (mon1);
#line 305 "../src/main-window.vala"
					_g_object_unref0 (mon0);
#line 305 "../src/main-window.vala"
					return result;
#line 1176 "main-window.c"
				}
#line 297 "../src/main-window.vala"
				_g_object_unref0 (mon1);
#line 1180 "main-window.c"
			}
		}
	}
#line 308 "../src/main-window.vala"
	result = TRUE;
#line 308 "../src/main-window.vala"
	_g_object_unref0 (mon0);
#line 308 "../src/main-window.vala"
	return result;
#line 1190 "main-window.c"
}

static gboolean
main_window_real_motion_notify_event (GtkWidget* base,
                                      GdkEventMotion* event)
{
	MainWindow * self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
#line 311 "../src/main-window.vala"
	self = (MainWindow*) base;
#line 311 "../src/main-window.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 313 "../src/main-window.vala"
	if (!self->priv->monitor_setting_ok) {
#line 313 "../src/main-window.vala"
		_tmp0_ = TRUE;
#line 1208 "main-window.c"
	} else {
		const gchar* _tmp1_;
#line 313 "../src/main-window.vala"
		_tmp1_ = self->priv->only_on_monitor;
#line 313 "../src/main-window.vala"
		_tmp0_ = g_strcmp0 (_tmp1_, "auto") == 0;
#line 1215 "main-window.c"
	}
#line 313 "../src/main-window.vala"
	if (_tmp0_) {
#line 1219 "main-window.c"
		gint x = 0;
		gint y = 0;
		GdkWindow* _tmp2_;
		GdkWindow* _tmp3_;
		GList* _tmp10_;
#line 315 "../src/main-window.vala"
		x = (gint) (event->x + 0.5);
#line 316 "../src/main-window.vala"
		y = (gint) (event->y + 0.5);
#line 319 "../src/main-window.vala"
		_tmp2_ = event->window;
#line 319 "../src/main-window.vala"
		_tmp3_ = gtk_widget_get_window ((GtkWidget*) self);
#line 319 "../src/main-window.vala"
		if (_tmp2_ != _tmp3_) {
#line 1235 "main-window.c"
			gint w_x = 0;
			gint w_y = 0;
			GdkWindow* _tmp4_;
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			GdkWindow* _tmp7_;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
#line 322 "../src/main-window.vala"
			_tmp4_ = gtk_widget_get_window ((GtkWidget*) self);
#line 322 "../src/main-window.vala"
			gdk_window_get_origin (_tmp4_, &_tmp5_, &_tmp6_);
#line 322 "../src/main-window.vala"
			w_x = _tmp5_;
#line 322 "../src/main-window.vala"
			w_y = _tmp6_;
#line 323 "../src/main-window.vala"
			x -= w_x;
#line 324 "../src/main-window.vala"
			y -= w_y;
#line 325 "../src/main-window.vala"
			_tmp7_ = event->window;
#line 325 "../src/main-window.vala"
			gdk_window_get_origin (_tmp7_, &_tmp8_, &_tmp9_);
#line 325 "../src/main-window.vala"
			w_x = _tmp8_;
#line 325 "../src/main-window.vala"
			w_y = _tmp9_;
#line 326 "../src/main-window.vala"
			x += w_x;
#line 327 "../src/main-window.vala"
			y += w_y;
#line 1268 "main-window.c"
		}
#line 330 "../src/main-window.vala"
		_tmp10_ = self->priv->monitors;
#line 1272 "main-window.c"
		{
			GList* m_collection = NULL;
			GList* m_it = NULL;
#line 330 "../src/main-window.vala"
			m_collection = _tmp10_;
#line 330 "../src/main-window.vala"
			for (m_it = m_collection; m_it != NULL; m_it = m_it->next) {
#line 1280 "main-window.c"
				Monitor* _tmp11_;
				Monitor* m = NULL;
#line 330 "../src/main-window.vala"
				_tmp11_ = _monitor_ref0 ((Monitor*) m_it->data);
#line 330 "../src/main-window.vala"
				m = _tmp11_;
#line 1287 "main-window.c"
				{
					gboolean _tmp12_ = FALSE;
					gboolean _tmp13_ = FALSE;
					gboolean _tmp14_ = FALSE;
					Monitor* _tmp15_;
#line 332 "../src/main-window.vala"
					_tmp15_ = m;
#line 332 "../src/main-window.vala"
					if (x >= _tmp15_->x) {
#line 1297 "main-window.c"
						Monitor* _tmp16_;
						Monitor* _tmp17_;
#line 332 "../src/main-window.vala"
						_tmp16_ = m;
#line 332 "../src/main-window.vala"
						_tmp17_ = m;
#line 332 "../src/main-window.vala"
						_tmp14_ = x <= (_tmp16_->x + _tmp17_->width);
#line 1306 "main-window.c"
					} else {
#line 332 "../src/main-window.vala"
						_tmp14_ = FALSE;
#line 1310 "main-window.c"
					}
#line 332 "../src/main-window.vala"
					if (_tmp14_) {
#line 1314 "main-window.c"
						Monitor* _tmp18_;
#line 332 "../src/main-window.vala"
						_tmp18_ = m;
#line 332 "../src/main-window.vala"
						_tmp13_ = y >= _tmp18_->y;
#line 1320 "main-window.c"
					} else {
#line 332 "../src/main-window.vala"
						_tmp13_ = FALSE;
#line 1324 "main-window.c"
					}
#line 332 "../src/main-window.vala"
					if (_tmp13_) {
#line 1328 "main-window.c"
						Monitor* _tmp19_;
						Monitor* _tmp20_;
#line 332 "../src/main-window.vala"
						_tmp19_ = m;
#line 332 "../src/main-window.vala"
						_tmp20_ = m;
#line 332 "../src/main-window.vala"
						_tmp12_ = y <= (_tmp19_->y + _tmp20_->height);
#line 1337 "main-window.c"
					} else {
#line 332 "../src/main-window.vala"
						_tmp12_ = FALSE;
#line 1341 "main-window.c"
					}
#line 332 "../src/main-window.vala"
					if (_tmp12_) {
#line 1345 "main-window.c"
						Monitor* _tmp21_;
#line 334 "../src/main-window.vala"
						_tmp21_ = m;
#line 334 "../src/main-window.vala"
						main_window_move_to_monitor (self, _tmp21_);
#line 335 "../src/main-window.vala"
						_monitor_unref0 (m);
#line 335 "../src/main-window.vala"
						break;
#line 1355 "main-window.c"
					}
#line 330 "../src/main-window.vala"
					_monitor_unref0 (m);
#line 1359 "main-window.c"
				}
			}
		}
	}
#line 340 "../src/main-window.vala"
	result = FALSE;
#line 340 "../src/main-window.vala"
	return result;
#line 1368 "main-window.c"
}

static void
main_window_move_to_monitor (MainWindow* self,
                             Monitor* monitor)
{
	Monitor* _tmp0_;
	GtkBox* _tmp1_;
	Background* _tmp2_;
	Background* _tmp3_;
	GtkBox* _tmp4_;
	ShutdownDialog* _tmp5_;
#line 343 "../src/main-window.vala"
	g_return_if_fail (self != NULL);
#line 343 "../src/main-window.vala"
	g_return_if_fail (monitor != NULL);
#line 345 "../src/main-window.vala"
	_tmp0_ = _monitor_ref0 (monitor);
#line 345 "../src/main-window.vala"
	_monitor_unref0 (self->priv->active_monitor);
#line 345 "../src/main-window.vala"
	self->priv->active_monitor = _tmp0_;
#line 346 "../src/main-window.vala"
	_tmp1_ = self->priv->login_box;
#line 346 "../src/main-window.vala"
	gtk_widget_set_size_request ((GtkWidget*) _tmp1_, monitor->width, monitor->height);
#line 347 "../src/main-window.vala"
	_tmp2_ = self->priv->background;
#line 347 "../src/main-window.vala"
	background_set_active_monitor (_tmp2_, monitor);
#line 348 "../src/main-window.vala"
	_tmp3_ = self->priv->background;
#line 348 "../src/main-window.vala"
	_tmp4_ = self->priv->login_box;
#line 348 "../src/main-window.vala"
	gtk_fixed_move ((GtkFixed*) _tmp3_, (GtkWidget*) _tmp4_, monitor->x, monitor->y);
#line 350 "../src/main-window.vala"
	_tmp5_ = self->priv->shutdown_dialog;
#line 350 "../src/main-window.vala"
	if (_tmp5_ != NULL) {
#line 1409 "main-window.c"
		ShutdownDialog* _tmp6_;
		Background* _tmp7_;
		ShutdownDialog* _tmp8_;
#line 352 "../src/main-window.vala"
		_tmp6_ = self->priv->shutdown_dialog;
#line 352 "../src/main-window.vala"
		shutdown_dialog_set_active_monitor (_tmp6_, monitor);
#line 353 "../src/main-window.vala"
		_tmp7_ = self->priv->background;
#line 353 "../src/main-window.vala"
		_tmp8_ = self->priv->shutdown_dialog;
#line 353 "../src/main-window.vala"
		gtk_fixed_move ((GtkFixed*) _tmp7_, (GtkWidget*) _tmp8_, monitor->x, monitor->y);
#line 1423 "main-window.c"
	}
}

static void
main_window_add_user_list (MainWindow* self)
{
	GreeterList* greeter_list = NULL;
	Background* _tmp0_;
	MenuBar* _tmp1_;
	UserList* _tmp2_;
	Background* _tmp3_;
	DashBox* _tmp4_;
#line 357 "../src/main-window.vala"
	g_return_if_fail (self != NULL);
#line 360 "../src/main-window.vala"
	_tmp0_ = self->priv->background;
#line 360 "../src/main-window.vala"
	_tmp1_ = self->menubar;
#line 360 "../src/main-window.vala"
	_tmp2_ = user_list_new (_tmp0_, _tmp1_);
#line 360 "../src/main-window.vala"
	g_object_ref_sink (_tmp2_);
#line 360 "../src/main-window.vala"
	_g_object_unref0 (greeter_list);
#line 360 "../src/main-window.vala"
	greeter_list = (GreeterList*) _tmp2_;
#line 361 "../src/main-window.vala"
	gtk_widget_show ((GtkWidget*) greeter_list);
#line 362 "../src/main-window.vala"
	slick_greeter_add_style_class ((GtkWidget*) greeter_list);
#line 365 "../src/main-window.vala"
	_tmp3_ = self->priv->background;
#line 365 "../src/main-window.vala"
	_tmp4_ = greeter_list->greeter_box;
#line 365 "../src/main-window.vala"
	background_connect_to_dashbox_transitions (_tmp3_, _tmp4_);
#line 367 "../src/main-window.vala"
	main_window_push_list (self, greeter_list);
#line 357 "../src/main-window.vala"
	_g_object_unref0 (greeter_list);
#line 1464 "main-window.c"
}

static gboolean
main_window_real_key_press_event (GtkWidget* base,
                                  GdkEventKey* event)
{
	MainWindow * self;
	GreeterList* top = NULL;
	ListStack* _tmp0_;
	GreeterList* _tmp1_;
	ListStack* _tmp2_;
	GreeterList* _tmp3_;
	GreeterList* _tmp4_;
	gboolean _tmp5_;
	GError* _inner_error0_ = NULL;
	gboolean result;
#line 370 "../src/main-window.vala"
	self = (MainWindow*) base;
#line 370 "../src/main-window.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 372 "../src/main-window.vala"
	_tmp0_ = self->stack;
#line 372 "../src/main-window.vala"
	_tmp1_ = list_stack_top (_tmp0_);
#line 372 "../src/main-window.vala"
	top = _tmp1_;
#line 374 "../src/main-window.vala"
	_tmp2_ = self->stack;
#line 374 "../src/main-window.vala"
	_tmp3_ = list_stack_top (_tmp2_);
#line 374 "../src/main-window.vala"
	_tmp4_ = _tmp3_;
#line 374 "../src/main-window.vala"
	_tmp5_ = IS_USER_LIST (_tmp4_);
#line 374 "../src/main-window.vala"
	_g_object_unref0 (_tmp4_);
#line 374 "../src/main-window.vala"
	if (_tmp5_) {
#line 1503 "main-window.c"
		UserList* user_list = NULL;
		ListStack* _tmp6_;
		GreeterList* _tmp7_;
		UserList* _tmp8_;
		GdkModifierType shift_mask = 0U;
		GdkModifierType control_mask = 0U;
		GdkModifierType alt_mask = 0U;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
#line 376 "../src/main-window.vala"
		_tmp6_ = self->stack;
#line 376 "../src/main-window.vala"
		_tmp7_ = list_stack_top (_tmp6_);
#line 376 "../src/main-window.vala"
		_tmp8_ = IS_USER_LIST (_tmp7_) ? ((UserList*) _tmp7_) : NULL;
#line 376 "../src/main-window.vala"
		if (_tmp8_ == NULL) {
#line 376 "../src/main-window.vala"
			_g_object_unref0 (_tmp7_);
#line 1525 "main-window.c"
		}
#line 376 "../src/main-window.vala"
		user_list = _tmp8_;
#line 377 "../src/main-window.vala"
		shift_mask = GDK_CONTROL_MASK | GDK_MOD1_MASK;
#line 378 "../src/main-window.vala"
		control_mask = GDK_SHIFT_MASK | GDK_MOD1_MASK;
#line 379 "../src/main-window.vala"
		alt_mask = GDK_CONTROL_MASK | GDK_SHIFT_MASK;
#line 380 "../src/main-window.vala"
		if (event->keyval == GDK_KEY_Shift_L) {
#line 380 "../src/main-window.vala"
			_tmp12_ = TRUE;
#line 1539 "main-window.c"
		} else {
#line 380 "../src/main-window.vala"
			_tmp12_ = event->keyval == GDK_KEY_Shift_R;
#line 1543 "main-window.c"
		}
#line 380 "../src/main-window.vala"
		if (_tmp12_) {
#line 380 "../src/main-window.vala"
			_tmp11_ = (event->state & shift_mask) == shift_mask;
#line 1549 "main-window.c"
		} else {
#line 380 "../src/main-window.vala"
			_tmp11_ = FALSE;
#line 1553 "main-window.c"
		}
#line 380 "../src/main-window.vala"
		if (_tmp11_) {
#line 380 "../src/main-window.vala"
			_tmp10_ = TRUE;
#line 1559 "main-window.c"
		} else {
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_ = FALSE;
#line 381 "../src/main-window.vala"
			if (event->keyval == GDK_KEY_Control_L) {
#line 381 "../src/main-window.vala"
				_tmp14_ = TRUE;
#line 1567 "main-window.c"
			} else {
#line 381 "../src/main-window.vala"
				_tmp14_ = event->keyval == GDK_KEY_Control_R;
#line 1571 "main-window.c"
			}
#line 381 "../src/main-window.vala"
			if (_tmp14_) {
#line 381 "../src/main-window.vala"
				_tmp13_ = (event->state & control_mask) == control_mask;
#line 1577 "main-window.c"
			} else {
#line 381 "../src/main-window.vala"
				_tmp13_ = FALSE;
#line 1581 "main-window.c"
			}
#line 381 "../src/main-window.vala"
			_tmp10_ = _tmp13_;
#line 1585 "main-window.c"
		}
#line 380 "../src/main-window.vala"
		if (_tmp10_) {
#line 380 "../src/main-window.vala"
			_tmp9_ = TRUE;
#line 1591 "main-window.c"
		} else {
			gboolean _tmp15_ = FALSE;
			gboolean _tmp16_ = FALSE;
#line 382 "../src/main-window.vala"
			if (event->keyval == GDK_KEY_Alt_L) {
#line 382 "../src/main-window.vala"
				_tmp16_ = TRUE;
#line 1599 "main-window.c"
			} else {
#line 382 "../src/main-window.vala"
				_tmp16_ = event->keyval == GDK_KEY_Alt_R;
#line 1603 "main-window.c"
			}
#line 382 "../src/main-window.vala"
			if (_tmp16_) {
#line 382 "../src/main-window.vala"
				_tmp15_ = (event->state & alt_mask) == alt_mask;
#line 1609 "main-window.c"
			} else {
#line 382 "../src/main-window.vala"
				_tmp15_ = FALSE;
#line 1613 "main-window.c"
			}
#line 382 "../src/main-window.vala"
			_tmp9_ = _tmp15_;
#line 1617 "main-window.c"
		}
#line 380 "../src/main-window.vala"
		if (_tmp9_) {
#line 1621 "main-window.c"
			UserList* _tmp17_;
			UserList* _tmp18_;
			gboolean _tmp19_;
			gboolean _tmp20_;
#line 384 "../src/main-window.vala"
			g_debug ("main-window.vala:384: Hidden user key combination detected");
#line 385 "../src/main-window.vala"
			_tmp17_ = user_list;
#line 385 "../src/main-window.vala"
			_tmp18_ = user_list;
#line 385 "../src/main-window.vala"
			_tmp19_ = user_list_get_show_hidden_users (_tmp18_);
#line 385 "../src/main-window.vala"
			_tmp20_ = _tmp19_;
#line 385 "../src/main-window.vala"
			user_list_set_show_hidden_users (_tmp17_, !_tmp20_);
#line 386 "../src/main-window.vala"
			result = TRUE;
#line 386 "../src/main-window.vala"
			_g_object_unref0 (user_list);
#line 386 "../src/main-window.vala"
			_g_object_unref0 (top);
#line 386 "../src/main-window.vala"
			return result;
#line 1646 "main-window.c"
		}
#line 374 "../src/main-window.vala"
		_g_object_unref0 (user_list);
#line 1650 "main-window.c"
	} else {
		ListStack* _tmp21_;
		GreeterList* _tmp22_;
		GreeterList* _tmp23_;
		gboolean _tmp24_;
#line 389 "../src/main-window.vala"
		_tmp21_ = self->stack;
#line 389 "../src/main-window.vala"
		_tmp22_ = list_stack_top (_tmp21_);
#line 389 "../src/main-window.vala"
		_tmp23_ = _tmp22_;
#line 389 "../src/main-window.vala"
		_tmp24_ = IS_SESSION_LIST (_tmp23_);
#line 389 "../src/main-window.vala"
		_g_object_unref0 (_tmp23_);
#line 389 "../src/main-window.vala"
		if (_tmp24_) {
#line 391 "../src/main-window.vala"
			switch (event->keyval) {
#line 391 "../src/main-window.vala"
				case GDK_KEY_Escape:
#line 391 "../src/main-window.vala"
				case GDK_KEY_Left:
#line 391 "../src/main-window.vala"
				case GDK_KEY_KP_Left:
#line 1676 "main-window.c"
				{
#line 395 "../src/main-window.vala"
					main_window_pop_list (self);
#line 396 "../src/main-window.vala"
					result = TRUE;
#line 396 "../src/main-window.vala"
					_g_object_unref0 (top);
#line 396 "../src/main-window.vala"
					return result;
#line 1686 "main-window.c"
				}
				default:
#line 391 "../src/main-window.vala"
				break;
#line 1691 "main-window.c"
			}
		}
	}
#line 400 "../src/main-window.vala"
	switch (event->keyval) {
#line 400 "../src/main-window.vala"
		case GDK_KEY_Escape:
#line 1699 "main-window.c"
		{
			GtkBox* _tmp25_;
			gboolean _tmp26_;
			gboolean _tmp27_;
			ShutdownDialog* _tmp29_;
#line 403 "../src/main-window.vala"
			_tmp25_ = self->priv->login_box;
#line 403 "../src/main-window.vala"
			_tmp26_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp25_);
#line 403 "../src/main-window.vala"
			_tmp27_ = _tmp26_;
#line 403 "../src/main-window.vala"
			if (_tmp27_) {
#line 1713 "main-window.c"
				GreeterList* _tmp28_;
#line 404 "../src/main-window.vala"
				_tmp28_ = top;
#line 404 "../src/main-window.vala"
				greeter_list_cancel_authentication (_tmp28_);
#line 1719 "main-window.c"
			}
#line 405 "../src/main-window.vala"
			_tmp29_ = self->priv->shutdown_dialog;
#line 405 "../src/main-window.vala"
			if (_tmp29_ != NULL) {
#line 1725 "main-window.c"
				ShutdownDialog* _tmp30_;
#line 406 "../src/main-window.vala"
				_tmp30_ = self->priv->shutdown_dialog;
#line 406 "../src/main-window.vala"
				shutdown_dialog_cancel (_tmp30_);
#line 1731 "main-window.c"
			}
#line 407 "../src/main-window.vala"
			result = TRUE;
#line 407 "../src/main-window.vala"
			_g_object_unref0 (top);
#line 407 "../src/main-window.vala"
			return result;
#line 1739 "main-window.c"
		}
#line 400 "../src/main-window.vala"
		case GDK_KEY_Page_Up:
#line 400 "../src/main-window.vala"
		case GDK_KEY_KP_Page_Up:
#line 1745 "main-window.c"
		{
			GtkBox* _tmp31_;
			gboolean _tmp32_;
			gboolean _tmp33_;
#line 410 "../src/main-window.vala"
			_tmp31_ = self->priv->login_box;
#line 410 "../src/main-window.vala"
			_tmp32_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp31_);
#line 410 "../src/main-window.vala"
			_tmp33_ = _tmp32_;
#line 410 "../src/main-window.vala"
			if (_tmp33_) {
#line 1758 "main-window.c"
				GreeterList* _tmp34_;
#line 411 "../src/main-window.vala"
				_tmp34_ = top;
#line 411 "../src/main-window.vala"
				greeter_list_scroll (_tmp34_, GREETER_LIST_SCROLL_TARGET_START);
#line 1764 "main-window.c"
			}
#line 412 "../src/main-window.vala"
			result = TRUE;
#line 412 "../src/main-window.vala"
			_g_object_unref0 (top);
#line 412 "../src/main-window.vala"
			return result;
#line 1772 "main-window.c"
		}
#line 400 "../src/main-window.vala"
		case GDK_KEY_Page_Down:
#line 400 "../src/main-window.vala"
		case GDK_KEY_KP_Page_Down:
#line 1778 "main-window.c"
		{
			GtkBox* _tmp35_;
			gboolean _tmp36_;
			gboolean _tmp37_;
#line 415 "../src/main-window.vala"
			_tmp35_ = self->priv->login_box;
#line 415 "../src/main-window.vala"
			_tmp36_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp35_);
#line 415 "../src/main-window.vala"
			_tmp37_ = _tmp36_;
#line 415 "../src/main-window.vala"
			if (_tmp37_) {
#line 1791 "main-window.c"
				GreeterList* _tmp38_;
#line 416 "../src/main-window.vala"
				_tmp38_ = top;
#line 416 "../src/main-window.vala"
				greeter_list_scroll (_tmp38_, GREETER_LIST_SCROLL_TARGET_END);
#line 1797 "main-window.c"
			}
#line 417 "../src/main-window.vala"
			result = TRUE;
#line 417 "../src/main-window.vala"
			_g_object_unref0 (top);
#line 417 "../src/main-window.vala"
			return result;
#line 1805 "main-window.c"
		}
#line 400 "../src/main-window.vala"
		case GDK_KEY_Up:
#line 400 "../src/main-window.vala"
		case GDK_KEY_KP_Up:
#line 1811 "main-window.c"
		{
			GtkBox* _tmp39_;
			gboolean _tmp40_;
			gboolean _tmp41_;
#line 420 "../src/main-window.vala"
			_tmp39_ = self->priv->login_box;
#line 420 "../src/main-window.vala"
			_tmp40_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp39_);
#line 420 "../src/main-window.vala"
			_tmp41_ = _tmp40_;
#line 420 "../src/main-window.vala"
			if (_tmp41_) {
#line 1824 "main-window.c"
				GreeterList* _tmp42_;
#line 421 "../src/main-window.vala"
				_tmp42_ = top;
#line 421 "../src/main-window.vala"
				greeter_list_scroll (_tmp42_, GREETER_LIST_SCROLL_TARGET_UP);
#line 1830 "main-window.c"
			}
#line 422 "../src/main-window.vala"
			result = TRUE;
#line 422 "../src/main-window.vala"
			_g_object_unref0 (top);
#line 422 "../src/main-window.vala"
			return result;
#line 1838 "main-window.c"
		}
#line 400 "../src/main-window.vala"
		case GDK_KEY_Down:
#line 400 "../src/main-window.vala"
		case GDK_KEY_KP_Down:
#line 1844 "main-window.c"
		{
			GtkBox* _tmp43_;
			gboolean _tmp44_;
			gboolean _tmp45_;
#line 425 "../src/main-window.vala"
			_tmp43_ = self->priv->login_box;
#line 425 "../src/main-window.vala"
			_tmp44_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp43_);
#line 425 "../src/main-window.vala"
			_tmp45_ = _tmp44_;
#line 425 "../src/main-window.vala"
			if (_tmp45_) {
#line 1857 "main-window.c"
				GreeterList* _tmp46_;
#line 426 "../src/main-window.vala"
				_tmp46_ = top;
#line 426 "../src/main-window.vala"
				greeter_list_scroll (_tmp46_, GREETER_LIST_SCROLL_TARGET_DOWN);
#line 1863 "main-window.c"
			}
#line 427 "../src/main-window.vala"
			result = TRUE;
#line 427 "../src/main-window.vala"
			_g_object_unref0 (top);
#line 427 "../src/main-window.vala"
			return result;
#line 1871 "main-window.c"
		}
#line 400 "../src/main-window.vala"
		case GDK_KEY_F10:
#line 1875 "main-window.c"
		{
			GtkBox* _tmp47_;
			gboolean _tmp48_;
			gboolean _tmp49_;
#line 429 "../src/main-window.vala"
			_tmp47_ = self->priv->login_box;
#line 429 "../src/main-window.vala"
			_tmp48_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp47_);
#line 429 "../src/main-window.vala"
			_tmp49_ = _tmp48_;
#line 429 "../src/main-window.vala"
			if (_tmp49_) {
#line 1888 "main-window.c"
				MenuBar* _tmp50_;
#line 430 "../src/main-window.vala"
				_tmp50_ = self->menubar;
#line 430 "../src/main-window.vala"
				gtk_menu_shell_select_first ((GtkMenuShell*) _tmp50_, FALSE);
#line 1894 "main-window.c"
			}
#line 431 "../src/main-window.vala"
			result = TRUE;
#line 431 "../src/main-window.vala"
			_g_object_unref0 (top);
#line 431 "../src/main-window.vala"
			return result;
#line 1902 "main-window.c"
		}
#line 400 "../src/main-window.vala"
		case GDK_KEY_PowerOff:
#line 1906 "main-window.c"
		{
#line 433 "../src/main-window.vala"
			main_window_show_shutdown_dialog (self, SHUTDOWN_DIALOG_TYPE_SHUTDOWN);
#line 434 "../src/main-window.vala"
			result = TRUE;
#line 434 "../src/main-window.vala"
			_g_object_unref0 (top);
#line 434 "../src/main-window.vala"
			return result;
#line 1916 "main-window.c"
		}
#line 400 "../src/main-window.vala"
		case GDK_KEY_Print:
#line 1920 "main-window.c"
		{
			GdkWindow* root = NULL;
			GdkWindow* _tmp51_;
			GdkWindow* _tmp52_;
			GdkPixbuf* screenshot = NULL;
			GdkWindow* _tmp53_;
			GdkWindow* _tmp54_;
			GdkWindow* _tmp55_;
			GdkPixbuf* _tmp56_;
#line 436 "../src/main-window.vala"
			g_debug ("main-window.vala:436: Taking screenshot");
#line 437 "../src/main-window.vala"
			_tmp51_ = gdk_get_default_root_window ();
#line 437 "../src/main-window.vala"
			_tmp52_ = _g_object_ref0 (_tmp51_);
#line 437 "../src/main-window.vala"
			root = _tmp52_;
#line 438 "../src/main-window.vala"
			_tmp53_ = root;
#line 438 "../src/main-window.vala"
			_tmp54_ = root;
#line 438 "../src/main-window.vala"
			_tmp55_ = root;
#line 438 "../src/main-window.vala"
			_tmp56_ = gdk_pixbuf_get_from_window (_tmp53_, 0, 0, gdk_window_get_width (_tmp54_), gdk_window_get_height (_tmp55_));
#line 438 "../src/main-window.vala"
			screenshot = _tmp56_;
#line 1948 "main-window.c"
			{
				GdkPixbuf* _tmp57_;
#line 441 "../src/main-window.vala"
				_tmp57_ = screenshot;
#line 441 "../src/main-window.vala"
				gdk_pixbuf_save (_tmp57_, "Screenshot.png", "png", &_inner_error0_, NULL, NULL);
#line 441 "../src/main-window.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1957 "main-window.c"
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp58_;
				const gchar* _tmp59_;
#line 439 "../src/main-window.vala"
				e = _inner_error0_;
#line 439 "../src/main-window.vala"
				_inner_error0_ = NULL;
#line 445 "../src/main-window.vala"
				_tmp58_ = e;
#line 445 "../src/main-window.vala"
				_tmp59_ = _tmp58_->message;
#line 445 "../src/main-window.vala"
				g_warning ("main-window.vala:445: Failed to save screenshot: %s", _tmp59_);
#line 439 "../src/main-window.vala"
				_g_error_free0 (e);
#line 1979 "main-window.c"
			}
			__finally0:
#line 439 "../src/main-window.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1984 "main-window.c"
				gboolean _tmp60_ = FALSE;
#line 439 "../src/main-window.vala"
				_g_object_unref0 (screenshot);
#line 439 "../src/main-window.vala"
				_g_object_unref0 (root);
#line 439 "../src/main-window.vala"
				_g_object_unref0 (top);
#line 439 "../src/main-window.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 439 "../src/main-window.vala"
				g_clear_error (&_inner_error0_);
#line 439 "../src/main-window.vala"
				return _tmp60_;
#line 1998 "main-window.c"
			}
#line 447 "../src/main-window.vala"
			result = TRUE;
#line 447 "../src/main-window.vala"
			_g_object_unref0 (screenshot);
#line 447 "../src/main-window.vala"
			_g_object_unref0 (root);
#line 447 "../src/main-window.vala"
			_g_object_unref0 (top);
#line 447 "../src/main-window.vala"
			return result;
#line 2010 "main-window.c"
		}
#line 400 "../src/main-window.vala"
		case GDK_KEY_z:
#line 2014 "main-window.c"
		{
			gboolean _tmp61_ = FALSE;
			SlickGreeter* _tmp62_;
#line 449 "../src/main-window.vala"
			_tmp62_ = slick_greeter_singleton;
#line 449 "../src/main-window.vala"
			if (_tmp62_->test_mode) {
#line 449 "../src/main-window.vala"
				_tmp61_ = (event->state & GDK_MOD1_MASK) != 0;
#line 2024 "main-window.c"
			} else {
#line 449 "../src/main-window.vala"
				_tmp61_ = FALSE;
#line 2028 "main-window.c"
			}
#line 449 "../src/main-window.vala"
			if (_tmp61_) {
#line 451 "../src/main-window.vala"
				main_window_show_shutdown_dialog (self, SHUTDOWN_DIALOG_TYPE_SHUTDOWN);
#line 452 "../src/main-window.vala"
				result = TRUE;
#line 452 "../src/main-window.vala"
				_g_object_unref0 (top);
#line 452 "../src/main-window.vala"
				return result;
#line 2040 "main-window.c"
			}
#line 454 "../src/main-window.vala"
			break;
#line 2044 "main-window.c"
		}
#line 400 "../src/main-window.vala"
		case GDK_KEY_Z:
#line 2048 "main-window.c"
		{
			gboolean _tmp63_ = FALSE;
			SlickGreeter* _tmp64_;
#line 456 "../src/main-window.vala"
			_tmp64_ = slick_greeter_singleton;
#line 456 "../src/main-window.vala"
			if (_tmp64_->test_mode) {
#line 456 "../src/main-window.vala"
				_tmp63_ = (event->state & GDK_MOD1_MASK) != 0;
#line 2058 "main-window.c"
			} else {
#line 456 "../src/main-window.vala"
				_tmp63_ = FALSE;
#line 2062 "main-window.c"
			}
#line 456 "../src/main-window.vala"
			if (_tmp63_) {
#line 458 "../src/main-window.vala"
				main_window_show_shutdown_dialog (self, SHUTDOWN_DIALOG_TYPE_RESTART);
#line 459 "../src/main-window.vala"
				result = TRUE;
#line 459 "../src/main-window.vala"
				_g_object_unref0 (top);
#line 459 "../src/main-window.vala"
				return result;
#line 2074 "main-window.c"
			}
#line 461 "../src/main-window.vala"
			break;
#line 2078 "main-window.c"
		}
		default:
#line 400 "../src/main-window.vala"
		break;
#line 2083 "main-window.c"
	}
#line 464 "../src/main-window.vala"
	result = GTK_WIDGET_CLASS (main_window_parent_class)->key_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), event);
#line 464 "../src/main-window.vala"
	_g_object_unref0 (top);
#line 464 "../src/main-window.vala"
	return result;
#line 2091 "main-window.c"
}

void
main_window_set_keyboard_state (MainWindow* self)
{
	MenuBar* _tmp0_;
#line 467 "../src/main-window.vala"
	g_return_if_fail (self != NULL);
#line 469 "../src/main-window.vala"
	_tmp0_ = self->menubar;
#line 469 "../src/main-window.vala"
	menu_bar_set_keyboard_state (_tmp0_);
#line 2104 "main-window.c"
}

static void
_main_window_close_shutdown_dialog_shutdown_dialog_closed (ShutdownDialog* _sender,
                                                           gpointer self)
{
#line 481 "../src/main-window.vala"
	main_window_close_shutdown_dialog ((MainWindow*) self);
#line 2113 "main-window.c"
}

void
main_window_show_shutdown_dialog (MainWindow* self,
                                  ShutdownDialogType type)
{
	ShutdownDialog* _tmp0_;
	GtkBox* _tmp2_;
	Background* _tmp3_;
	ShutdownDialog* _tmp4_;
	ShutdownDialog* _tmp5_;
	Background* _tmp6_;
	ShutdownDialog* _tmp7_;
	Monitor* _tmp8_;
	ShutdownDialog* _tmp9_;
#line 472 "../src/main-window.vala"
	g_return_if_fail (self != NULL);
#line 474 "../src/main-window.vala"
	_tmp0_ = self->priv->shutdown_dialog;
#line 474 "../src/main-window.vala"
	if (_tmp0_ != NULL) {
#line 2135 "main-window.c"
		ShutdownDialog* _tmp1_;
#line 475 "../src/main-window.vala"
		_tmp1_ = self->priv->shutdown_dialog;
#line 475 "../src/main-window.vala"
		gtk_widget_destroy ((GtkWidget*) _tmp1_);
#line 2141 "main-window.c"
	}
#line 478 "../src/main-window.vala"
	_tmp2_ = self->priv->login_box;
#line 478 "../src/main-window.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, FALSE);
#line 480 "../src/main-window.vala"
	_tmp3_ = self->priv->background;
#line 480 "../src/main-window.vala"
	_tmp4_ = shutdown_dialog_new (type, _tmp3_);
#line 480 "../src/main-window.vala"
	g_object_ref_sink (_tmp4_);
#line 480 "../src/main-window.vala"
	_g_object_unref0 (self->priv->shutdown_dialog);
#line 480 "../src/main-window.vala"
	self->priv->shutdown_dialog = _tmp4_;
#line 481 "../src/main-window.vala"
	_tmp5_ = self->priv->shutdown_dialog;
#line 481 "../src/main-window.vala"
	g_signal_connect_object (_tmp5_, "closed", (GCallback) _main_window_close_shutdown_dialog_shutdown_dialog_closed, self, 0);
#line 482 "../src/main-window.vala"
	_tmp6_ = self->priv->background;
#line 482 "../src/main-window.vala"
	_tmp7_ = self->priv->shutdown_dialog;
#line 482 "../src/main-window.vala"
	gtk_container_add ((GtkContainer*) _tmp6_, (GtkWidget*) _tmp7_);
#line 483 "../src/main-window.vala"
	_tmp8_ = self->priv->active_monitor;
#line 483 "../src/main-window.vala"
	main_window_move_to_monitor (self, _tmp8_);
#line 484 "../src/main-window.vala"
	_tmp9_ = self->priv->shutdown_dialog;
#line 484 "../src/main-window.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp9_, TRUE);
#line 2175 "main-window.c"
}

void
main_window_close_shutdown_dialog (MainWindow* self)
{
	ShutdownDialog* _tmp0_;
	ShutdownDialog* _tmp1_;
	GtkBox* _tmp2_;
#line 487 "../src/main-window.vala"
	g_return_if_fail (self != NULL);
#line 489 "../src/main-window.vala"
	_tmp0_ = self->priv->shutdown_dialog;
#line 489 "../src/main-window.vala"
	if (_tmp0_ == NULL) {
#line 490 "../src/main-window.vala"
		return;
#line 2192 "main-window.c"
	}
#line 492 "../src/main-window.vala"
	_tmp1_ = self->priv->shutdown_dialog;
#line 492 "../src/main-window.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp1_);
#line 493 "../src/main-window.vala"
	_g_object_unref0 (self->priv->shutdown_dialog);
#line 493 "../src/main-window.vala"
	self->priv->shutdown_dialog = NULL;
#line 495 "../src/main-window.vala"
	_tmp2_ = self->priv->login_box;
#line 495 "../src/main-window.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, TRUE);
#line 2206 "main-window.c"
}

MainWindow*
main_window_construct (GType object_type)
{
	MainWindow * self = NULL;
#line 21 "../src/main-window.vala"
	self = (MainWindow*) g_object_new (object_type, NULL);
#line 21 "../src/main-window.vala"
	return self;
#line 2217 "main-window.c"
}

MainWindow*
main_window_new (void)
{
#line 21 "../src/main-window.vala"
	return main_window_construct (TYPE_MAIN_WINDOW);
#line 2225 "main-window.c"
}

static void
_main_window_pop_list_gtk_button_clicked (GtkButton* _sender,
                                          gpointer self)
{
#line 148 "../src/main-window.vala"
	main_window_pop_list ((MainWindow*) self);
#line 2234 "main-window.c"
}

static void
_main_window_monitors_changed_cb_gdk_screen_monitors_changed (GdkScreen* _sender,
                                                              gpointer self)
{
#line 180 "../src/main-window.vala"
	main_window_monitors_changed_cb ((MainWindow*) self, _sender);
#line 2243 "main-window.c"
}

static GObject *
main_window_constructor (GType type,
                         guint n_construct_properties,
                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MainWindow * self;
	GdkEventMask _tmp0_;
	GdkEventMask _tmp1_;
	GtkAccelGroup* accel_group = NULL;
	GtkAccelGroup* _tmp2_;
	GtkAccelGroup* _tmp3_;
	GdkRGBA bg_color = {0};
	gchar* _tmp4_;
	gchar* _tmp5_;
	GdkRGBA _tmp6_;
	AtkObject* _tmp7_;
	Background* _tmp8_;
	Background* _tmp9_;
	Background* _tmp10_;
	GtkBox* _tmp11_;
	GtkBox* _tmp12_;
	Background* _tmp13_;
	GtkBox* _tmp14_;
	GtkEventBox* menubox = NULL;
	GtkEventBox* _tmp15_;
	GtkAlignment* menualign = NULL;
	GtkAlignment* _tmp16_;
	gchar* shadow_path = NULL;
	gchar* _tmp17_;
	gchar* shadow_style = NULL;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	GtkEventBox* _tmp34_;
	GtkEventBox* _tmp35_;
	GtkAlignment* _tmp36_;
	GtkEventBox* _tmp37_;
	GtkAlignment* _tmp38_;
	GtkBox* _tmp39_;
	GtkEventBox* _tmp40_;
	GtkAlignment* _tmp41_;
	GtkEventBox* _tmp42_;
	Background* _tmp43_;
	GtkAccelGroup* _tmp44_;
	MenuBar* _tmp45_;
	MenuBar* _tmp46_;
	GtkAlignment* _tmp47_;
	MenuBar* _tmp48_;
	MenuBar* _tmp49_;
	GtkBox* _tmp50_;
	GtkBox* _tmp51_;
	GtkBox* _tmp52_;
	GtkBox* _tmp53_;
	GtkBox* _tmp54_;
	gchar* content_align = NULL;
	gchar* _tmp55_;
	gfloat x_align = 0.0F;
	const gchar* _tmp56_;
	GtkAlignment* align = NULL;
	GtkAlignment* _tmp58_;
	const gchar* _tmp59_;
	GtkAlignment* _tmp61_;
	GtkBox* _tmp62_;
	GtkAlignment* _tmp63_;
	GtkBox* _tmp64_;
	GtkBox* _tmp65_;
	GtkBox* _tmp66_;
	GtkAlignment* _tmp67_;
	GtkBox* _tmp68_;
	GtkAlignment* _tmp69_;
	GtkAlignment* _tmp70_;
	GtkAlignment* _tmp71_;
	GtkAlignment* _tmp72_;
	GtkAlignment* _tmp73_;
	GtkBox* _tmp74_;
	GtkAlignment* _tmp75_;
	FlatButton* _tmp76_;
	GtkButton* _tmp77_;
	AtkObject* _tmp78_;
	GtkButton* _tmp79_;
	GtkImage* image = NULL;
	gchar* _tmp80_;
	gchar* _tmp81_;
	GtkImage* _tmp82_;
	GtkImage* _tmp83_;
	GtkImage* _tmp84_;
	GtkButton* _tmp85_;
	GtkButton* _tmp86_;
	GtkImage* _tmp87_;
	GtkButton* _tmp88_;
	GtkAlignment* _tmp89_;
	GtkButton* _tmp90_;
	GtkAlignment* _tmp91_;
	GtkAlignment* _tmp92_;
	GtkBox* _tmp93_;
	GtkAlignment* _tmp94_;
	ListStack* _tmp95_;
	ListStack* _tmp96_;
	GtkAlignment* _tmp97_;
	ListStack* _tmp98_;
	gchar* _tmp99_;
	const gchar* _tmp100_;
	SlickGreeter* _tmp101_;
	GtkBox* _tmp118_;
	gboolean _tmp119_;
	gboolean _tmp120_;
	GError* _inner_error0_ = NULL;
#line 43 "../src/main-window.vala"
	parent_class = G_OBJECT_CLASS (main_window_parent_class);
#line 43 "../src/main-window.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 43 "../src/main-window.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAIN_WINDOW, MainWindow);
#line 45 "../src/main-window.vala"
	_tmp0_ = gtk_widget_get_events ((GtkWidget*) self);
#line 45 "../src/main-window.vala"
	_tmp1_ = _tmp0_;
#line 45 "../src/main-window.vala"
	gtk_widget_set_events ((GtkWidget*) self, _tmp1_ | GDK_POINTER_MOTION_MASK);
#line 47 "../src/main-window.vala"
	_tmp2_ = gtk_accel_group_new ();
#line 47 "../src/main-window.vala"
	accel_group = _tmp2_;
#line 48 "../src/main-window.vala"
	_tmp3_ = accel_group;
#line 48 "../src/main-window.vala"
	gtk_window_add_accel_group ((GtkWindow*) self, _tmp3_);
#line 50 "../src/main-window.vala"
	memset (&bg_color, 0, sizeof (GdkRGBA));
#line 51 "../src/main-window.vala"
	_tmp4_ = ug_settings_get_string (UG_SETTINGS_KEY_BACKGROUND_COLOR);
#line 51 "../src/main-window.vala"
	_tmp5_ = _tmp4_;
#line 51 "../src/main-window.vala"
	gdk_rgba_parse (&bg_color, _tmp5_);
#line 51 "../src/main-window.vala"
	_g_free0 (_tmp5_);
#line 52 "../src/main-window.vala"
	_tmp6_ = bg_color;
#line 52 "../src/main-window.vala"
	gtk_widget_override_background_color ((GtkWidget*) self, GTK_STATE_FLAG_NORMAL, &_tmp6_);
#line 53 "../src/main-window.vala"
	_tmp7_ = gtk_widget_get_accessible ((GtkWidget*) self);
#line 53 "../src/main-window.vala"
	atk_object_set_name (_tmp7_, _ ("Login Screen"));
#line 54 "../src/main-window.vala"
	gtk_window_set_has_resize_grip ((GtkWindow*) self, FALSE);
#line 55 "../src/main-window.vala"
	slick_greeter_add_style_class ((GtkWidget*) self);
#line 57 "../src/main-window.vala"
	_tmp8_ = background_new ();
#line 57 "../src/main-window.vala"
	g_object_ref_sink (_tmp8_);
#line 57 "../src/main-window.vala"
	_g_object_unref0 (self->priv->background);
#line 57 "../src/main-window.vala"
	self->priv->background = _tmp8_;
#line 58 "../src/main-window.vala"
	_tmp9_ = self->priv->background;
#line 58 "../src/main-window.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp9_);
#line 59 "../src/main-window.vala"
	_tmp10_ = self->priv->background;
#line 59 "../src/main-window.vala"
	slick_greeter_add_style_class ((GtkWidget*) _tmp10_);
#line 61 "../src/main-window.vala"
	_tmp11_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
#line 61 "../src/main-window.vala"
	g_object_ref_sink (_tmp11_);
#line 61 "../src/main-window.vala"
	_g_object_unref0 (self->priv->login_box);
#line 61 "../src/main-window.vala"
	self->priv->login_box = _tmp11_;
#line 62 "../src/main-window.vala"
	_tmp12_ = self->priv->login_box;
#line 62 "../src/main-window.vala"
	gtk_widget_show ((GtkWidget*) _tmp12_);
#line 63 "../src/main-window.vala"
	_tmp13_ = self->priv->background;
#line 63 "../src/main-window.vala"
	_tmp14_ = self->priv->login_box;
#line 63 "../src/main-window.vala"
	gtk_container_add ((GtkContainer*) _tmp13_, (GtkWidget*) _tmp14_);
#line 66 "../src/main-window.vala"
	_tmp15_ = (GtkEventBox*) gtk_event_box_new ();
#line 66 "../src/main-window.vala"
	g_object_ref_sink (_tmp15_);
#line 66 "../src/main-window.vala"
	menubox = _tmp15_;
#line 67 "../src/main-window.vala"
	_tmp16_ = (GtkAlignment*) gtk_alignment_new (0.0f, 0.0f, 1.0f, 0.0f);
#line 67 "../src/main-window.vala"
	g_object_ref_sink (_tmp16_);
#line 67 "../src/main-window.vala"
	menualign = _tmp16_;
#line 68 "../src/main-window.vala"
	_tmp17_ = g_build_filename (PKGDATADIR, "shadow.png", NULL, NULL);
#line 68 "../src/main-window.vala"
	shadow_path = _tmp17_;
#line 70 "../src/main-window.vala"
	_tmp18_ = g_strdup ("");
#line 70 "../src/main-window.vala"
	shadow_style = _tmp18_;
#line 71 "../src/main-window.vala"
	_tmp19_ = shadow_path;
#line 71 "../src/main-window.vala"
	if (g_file_test (_tmp19_, G_FILE_TEST_EXISTS)) {
#line 2454 "main-window.c"
		const gchar* _tmp20_;
		gchar* _tmp21_;
#line 73 "../src/main-window.vala"
		_tmp20_ = shadow_path;
#line 73 "../src/main-window.vala"
		_tmp21_ = g_strdup_printf ("background-image: url('%s');background-repeat: repeat;", _tmp20_);
#line 73 "../src/main-window.vala"
		_g_free0 (shadow_style);
#line 73 "../src/main-window.vala"
		shadow_style = _tmp21_;
#line 2465 "main-window.c"
	}
	{
		GtkCssProvider* style = NULL;
		GtkCssProvider* _tmp22_;
		GtkCssProvider* _tmp23_;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		GtkStyleContext* context = NULL;
		GtkEventBox* _tmp27_;
		GtkStyleContext* _tmp28_;
		GtkStyleContext* _tmp29_;
		GtkStyleContext* _tmp30_;
		GtkCssProvider* _tmp31_;
#line 77 "../src/main-window.vala"
		_tmp22_ = gtk_css_provider_new ();
#line 77 "../src/main-window.vala"
		style = _tmp22_;
#line 78 "../src/main-window.vala"
		_tmp23_ = style;
#line 78 "../src/main-window.vala"
		_tmp24_ = shadow_style;
#line 78 "../src/main-window.vala"
		_tmp25_ = g_strdup_printf ("* {background-color: transparent;%s}", _tmp24_);
#line 78 "../src/main-window.vala"
		_tmp26_ = _tmp25_;
#line 78 "../src/main-window.vala"
		gtk_css_provider_load_from_data (_tmp23_, _tmp26_, (gssize) -1, &_inner_error0_);
#line 78 "../src/main-window.vala"
		_g_free0 (_tmp26_);
#line 78 "../src/main-window.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 78 "../src/main-window.vala"
			_g_object_unref0 (style);
#line 2500 "main-window.c"
			goto __catch0_g_error;
		}
#line 79 "../src/main-window.vala"
		_tmp27_ = menubox;
#line 79 "../src/main-window.vala"
		_tmp28_ = gtk_widget_get_style_context ((GtkWidget*) _tmp27_);
#line 79 "../src/main-window.vala"
		_tmp29_ = _g_object_ref0 (_tmp28_);
#line 79 "../src/main-window.vala"
		context = _tmp29_;
#line 80 "../src/main-window.vala"
		_tmp30_ = context;
#line 80 "../src/main-window.vala"
		_tmp31_ = style;
#line 80 "../src/main-window.vala"
		gtk_style_context_add_provider (_tmp30_, (GtkStyleProvider*) _tmp31_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
#line 75 "../src/main-window.vala"
		_g_object_unref0 (context);
#line 75 "../src/main-window.vala"
		_g_object_unref0 (style);
#line 2521 "main-window.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp32_;
		const gchar* _tmp33_;
#line 75 "../src/main-window.vala"
		e = _inner_error0_;
#line 75 "../src/main-window.vala"
		_inner_error0_ = NULL;
#line 85 "../src/main-window.vala"
		_tmp32_ = e;
#line 85 "../src/main-window.vala"
		_tmp33_ = _tmp32_->message;
#line 85 "../src/main-window.vala"
		g_debug ("main-window.vala:85: Internal error loading menubox style: %s", _tmp33_);
#line 75 "../src/main-window.vala"
		_g_error_free0 (e);
#line 2541 "main-window.c"
	}
	__finally0:
#line 75 "../src/main-window.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 75 "../src/main-window.vala"
		_g_free0 (shadow_style);
#line 75 "../src/main-window.vala"
		_g_free0 (shadow_path);
#line 75 "../src/main-window.vala"
		_g_object_unref0 (menualign);
#line 75 "../src/main-window.vala"
		_g_object_unref0 (menubox);
#line 75 "../src/main-window.vala"
		_g_object_unref0 (accel_group);
#line 75 "../src/main-window.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 75 "../src/main-window.vala"
		g_clear_error (&_inner_error0_);
#line 2560 "main-window.c"
	}
#line 87 "../src/main-window.vala"
	_tmp34_ = menubox;
#line 87 "../src/main-window.vala"
	gtk_widget_set_size_request ((GtkWidget*) _tmp34_, -1, MAIN_WINDOW_MENUBAR_HEIGHT);
#line 88 "../src/main-window.vala"
	_tmp35_ = menubox;
#line 88 "../src/main-window.vala"
	gtk_widget_show ((GtkWidget*) _tmp35_);
#line 89 "../src/main-window.vala"
	_tmp36_ = menualign;
#line 89 "../src/main-window.vala"
	gtk_widget_show ((GtkWidget*) _tmp36_);
#line 90 "../src/main-window.vala"
	_tmp37_ = menubox;
#line 90 "../src/main-window.vala"
	_tmp38_ = menualign;
#line 90 "../src/main-window.vala"
	gtk_container_add ((GtkContainer*) _tmp37_, (GtkWidget*) _tmp38_);
#line 91 "../src/main-window.vala"
	_tmp39_ = self->priv->login_box;
#line 91 "../src/main-window.vala"
	_tmp40_ = menubox;
#line 91 "../src/main-window.vala"
	gtk_container_add ((GtkContainer*) _tmp39_, (GtkWidget*) _tmp40_);
#line 92 "../src/main-window.vala"
	_tmp41_ = menualign;
#line 92 "../src/main-window.vala"
	slick_greeter_add_style_class ((GtkWidget*) _tmp41_);
#line 93 "../src/main-window.vala"
	_tmp42_ = menubox;
#line 93 "../src/main-window.vala"
	slick_greeter_add_style_class ((GtkWidget*) _tmp42_);
#line 95 "../src/main-window.vala"
	_tmp43_ = self->priv->background;
#line 95 "../src/main-window.vala"
	_tmp44_ = accel_group;
#line 95 "../src/main-window.vala"
	_tmp45_ = menu_bar_new (_tmp43_, _tmp44_, self);
#line 95 "../src/main-window.vala"
	g_object_ref_sink (_tmp45_);
#line 95 "../src/main-window.vala"
	_g_object_unref0 (self->menubar);
#line 95 "../src/main-window.vala"
	self->menubar = _tmp45_;
#line 96 "../src/main-window.vala"
	_tmp46_ = self->menubar;
#line 96 "../src/main-window.vala"
	gtk_widget_show ((GtkWidget*) _tmp46_);
#line 97 "../src/main-window.vala"
	_tmp47_ = menualign;
#line 97 "../src/main-window.vala"
	_tmp48_ = self->menubar;
#line 97 "../src/main-window.vala"
	gtk_container_add ((GtkContainer*) _tmp47_, (GtkWidget*) _tmp48_);
#line 98 "../src/main-window.vala"
	_tmp49_ = self->menubar;
#line 98 "../src/main-window.vala"
	slick_greeter_add_style_class ((GtkWidget*) _tmp49_);
#line 100 "../src/main-window.vala"
	_tmp50_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
#line 100 "../src/main-window.vala"
	g_object_ref_sink (_tmp50_);
#line 100 "../src/main-window.vala"
	_g_object_unref0 (self->priv->content_box);
#line 100 "../src/main-window.vala"
	self->priv->content_box = _tmp50_;
#line 101 "../src/main-window.vala"
	_tmp51_ = self->priv->content_box;
#line 101 "../src/main-window.vala"
	g_object_set ((GtkWidget*) _tmp51_, "expand", TRUE, NULL);
#line 102 "../src/main-window.vala"
	_tmp52_ = self->priv->content_box;
#line 102 "../src/main-window.vala"
	gtk_widget_show ((GtkWidget*) _tmp52_);
#line 103 "../src/main-window.vala"
	_tmp53_ = self->priv->login_box;
#line 103 "../src/main-window.vala"
	_tmp54_ = self->priv->content_box;
#line 103 "../src/main-window.vala"
	gtk_container_add ((GtkContainer*) _tmp53_, (GtkWidget*) _tmp54_);
#line 105 "../src/main-window.vala"
	_tmp55_ = ug_settings_get_string (UG_SETTINGS_KEY_CONTENT_ALIGN);
#line 105 "../src/main-window.vala"
	content_align = _tmp55_;
#line 106 "../src/main-window.vala"
	x_align = 0.5f;
#line 108 "../src/main-window.vala"
	_tmp56_ = content_align;
#line 108 "../src/main-window.vala"
	if (g_strcmp0 (_tmp56_, "left") == 0) {
#line 110 "../src/main-window.vala"
		x_align = 0.0f;
#line 2654 "main-window.c"
	} else {
		const gchar* _tmp57_;
#line 112 "../src/main-window.vala"
		_tmp57_ = content_align;
#line 112 "../src/main-window.vala"
		if (g_strcmp0 (_tmp57_, "right") == 0) {
#line 114 "../src/main-window.vala"
			x_align = 1.0f;
#line 2663 "main-window.c"
		}
	}
#line 117 "../src/main-window.vala"
	_tmp58_ = (GtkAlignment*) gtk_alignment_new (x_align, 0.0f, 0.0f, 1.0f);
#line 117 "../src/main-window.vala"
	g_object_ref_sink (_tmp58_);
#line 117 "../src/main-window.vala"
	align = _tmp58_;
#line 119 "../src/main-window.vala"
	_tmp59_ = content_align;
#line 119 "../src/main-window.vala"
	if (g_strcmp0 (_tmp59_, "center") == 0) {
#line 2676 "main-window.c"
		GtkAlignment* _tmp60_;
#line 122 "../src/main-window.vala"
		_tmp60_ = align;
#line 122 "../src/main-window.vala"
		gtk_widget_set_margin_right ((GtkWidget*) _tmp60_, grid_size);
#line 2682 "main-window.c"
	}
#line 125 "../src/main-window.vala"
	_tmp61_ = align;
#line 125 "../src/main-window.vala"
	gtk_widget_show ((GtkWidget*) _tmp61_);
#line 126 "../src/main-window.vala"
	_tmp62_ = self->priv->content_box;
#line 126 "../src/main-window.vala"
	_tmp63_ = align;
#line 126 "../src/main-window.vala"
	gtk_container_add ((GtkContainer*) _tmp62_, (GtkWidget*) _tmp63_);
#line 128 "../src/main-window.vala"
	_tmp64_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
#line 128 "../src/main-window.vala"
	g_object_ref_sink (_tmp64_);
#line 128 "../src/main-window.vala"
	_g_object_unref0 (self->priv->hbox);
#line 128 "../src/main-window.vala"
	self->priv->hbox = _tmp64_;
#line 129 "../src/main-window.vala"
	_tmp65_ = self->priv->hbox;
#line 129 "../src/main-window.vala"
	g_object_set ((GtkWidget*) _tmp65_, "expand", TRUE, NULL);
#line 130 "../src/main-window.vala"
	_tmp66_ = self->priv->hbox;
#line 130 "../src/main-window.vala"
	gtk_widget_show ((GtkWidget*) _tmp66_);
#line 131 "../src/main-window.vala"
	_tmp67_ = align;
#line 131 "../src/main-window.vala"
	_tmp68_ = self->priv->hbox;
#line 131 "../src/main-window.vala"
	gtk_container_add ((GtkContainer*) _tmp67_, (GtkWidget*) _tmp68_);
#line 133 "../src/main-window.vala"
	_tmp69_ = (GtkAlignment*) gtk_alignment_new (0.5f, 0.5f, 0.0f, 0.0f);
#line 133 "../src/main-window.vala"
	g_object_ref_sink (_tmp69_);
#line 133 "../src/main-window.vala"
	_g_object_unref0 (align);
#line 133 "../src/main-window.vala"
	align = _tmp69_;
#line 135 "../src/main-window.vala"
	_tmp70_ = align;
#line 135 "../src/main-window.vala"
	gtk_container_set_resize_mode ((GtkContainer*) _tmp70_, GTK_RESIZE_QUEUE);
#line 136 "../src/main-window.vala"
	_tmp71_ = align;
#line 136 "../src/main-window.vala"
	gtk_widget_set_size_request ((GtkWidget*) _tmp71_, grid_size, -1);
#line 137 "../src/main-window.vala"
	_tmp72_ = align;
#line 137 "../src/main-window.vala"
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp72_, MAIN_WINDOW_MENUBAR_HEIGHT);
#line 138 "../src/main-window.vala"
	_tmp73_ = align;
#line 138 "../src/main-window.vala"
	gtk_widget_show ((GtkWidget*) _tmp73_);
#line 139 "../src/main-window.vala"
	_tmp74_ = self->priv->hbox;
#line 139 "../src/main-window.vala"
	_tmp75_ = align;
#line 139 "../src/main-window.vala"
	gtk_container_add ((GtkContainer*) _tmp74_, (GtkWidget*) _tmp75_);
#line 141 "../src/main-window.vala"
	_tmp76_ = flat_button_new ();
#line 141 "../src/main-window.vala"
	g_object_ref_sink (_tmp76_);
#line 141 "../src/main-window.vala"
	_g_object_unref0 (self->priv->back_button);
#line 141 "../src/main-window.vala"
	self->priv->back_button = (GtkButton*) _tmp76_;
#line 142 "../src/main-window.vala"
	_tmp77_ = self->priv->back_button;
#line 142 "../src/main-window.vala"
	_tmp78_ = gtk_widget_get_accessible ((GtkWidget*) _tmp77_);
#line 142 "../src/main-window.vala"
	atk_object_set_name (_tmp78_, _ ("Back"));
#line 143 "../src/main-window.vala"
	_tmp79_ = self->priv->back_button;
#line 143 "../src/main-window.vala"
	gtk_button_set_focus_on_click (_tmp79_, FALSE);
#line 144 "../src/main-window.vala"
	_tmp80_ = g_build_filename (PKGDATADIR, "arrow_left.svg", NULL, NULL);
#line 144 "../src/main-window.vala"
	_tmp81_ = _tmp80_;
#line 144 "../src/main-window.vala"
	_tmp82_ = (GtkImage*) gtk_image_new_from_file (_tmp81_);
#line 144 "../src/main-window.vala"
	g_object_ref_sink (_tmp82_);
#line 144 "../src/main-window.vala"
	_tmp83_ = _tmp82_;
#line 144 "../src/main-window.vala"
	_g_free0 (_tmp81_);
#line 144 "../src/main-window.vala"
	image = _tmp83_;
#line 145 "../src/main-window.vala"
	_tmp84_ = image;
#line 145 "../src/main-window.vala"
	gtk_widget_show ((GtkWidget*) _tmp84_);
#line 146 "../src/main-window.vala"
	_tmp85_ = self->priv->back_button;
#line 146 "../src/main-window.vala"
	gtk_widget_set_size_request ((GtkWidget*) _tmp85_, grid_size - (GREETER_LIST_BORDER * 2), grid_size - (GREETER_LIST_BORDER * 2));
#line 147 "../src/main-window.vala"
	_tmp86_ = self->priv->back_button;
#line 147 "../src/main-window.vala"
	_tmp87_ = image;
#line 147 "../src/main-window.vala"
	gtk_container_add ((GtkContainer*) _tmp86_, (GtkWidget*) _tmp87_);
#line 148 "../src/main-window.vala"
	_tmp88_ = self->priv->back_button;
#line 148 "../src/main-window.vala"
	g_signal_connect_object (_tmp88_, "clicked", (GCallback) _main_window_pop_list_gtk_button_clicked, self, 0);
#line 149 "../src/main-window.vala"
	_tmp89_ = align;
#line 149 "../src/main-window.vala"
	_tmp90_ = self->priv->back_button;
#line 149 "../src/main-window.vala"
	gtk_container_add ((GtkContainer*) _tmp89_, (GtkWidget*) _tmp90_);
#line 151 "../src/main-window.vala"
	_tmp91_ = (GtkAlignment*) gtk_alignment_new (0.0f, 0.5f, 0.0f, 1.0f);
#line 151 "../src/main-window.vala"
	g_object_ref_sink (_tmp91_);
#line 151 "../src/main-window.vala"
	_g_object_unref0 (align);
#line 151 "../src/main-window.vala"
	align = _tmp91_;
#line 152 "../src/main-window.vala"
	_tmp92_ = align;
#line 152 "../src/main-window.vala"
	gtk_widget_show ((GtkWidget*) _tmp92_);
#line 153 "../src/main-window.vala"
	_tmp93_ = self->priv->hbox;
#line 153 "../src/main-window.vala"
	_tmp94_ = align;
#line 153 "../src/main-window.vala"
	gtk_container_add ((GtkContainer*) _tmp93_, (GtkWidget*) _tmp94_);
#line 155 "../src/main-window.vala"
	_tmp95_ = list_stack_new ();
#line 155 "../src/main-window.vala"
	g_object_ref_sink (_tmp95_);
#line 155 "../src/main-window.vala"
	_g_object_unref0 (self->stack);
#line 155 "../src/main-window.vala"
	self->stack = _tmp95_;
#line 156 "../src/main-window.vala"
	_tmp96_ = self->stack;
#line 156 "../src/main-window.vala"
	gtk_widget_show ((GtkWidget*) _tmp96_);
#line 157 "../src/main-window.vala"
	_tmp97_ = align;
#line 157 "../src/main-window.vala"
	_tmp98_ = self->stack;
#line 157 "../src/main-window.vala"
	gtk_container_add ((GtkContainer*) _tmp97_, (GtkWidget*) _tmp98_);
#line 159 "../src/main-window.vala"
	main_window_add_user_list (self);
#line 161 "../src/main-window.vala"
	_monitor_unref0 (self->priv->primary_monitor);
#line 161 "../src/main-window.vala"
	self->priv->primary_monitor = NULL;
#line 162 "../src/main-window.vala"
	self->priv->do_resize = FALSE;
#line 164 "../src/main-window.vala"
	_tmp99_ = ug_settings_get_string (UG_SETTINGS_KEY_ONLY_ON_MONITOR);
#line 164 "../src/main-window.vala"
	_g_free0 (self->priv->only_on_monitor);
#line 164 "../src/main-window.vala"
	self->priv->only_on_monitor = _tmp99_;
#line 165 "../src/main-window.vala"
	_tmp100_ = self->priv->only_on_monitor;
#line 165 "../src/main-window.vala"
	self->priv->monitor_setting_ok = g_strcmp0 (_tmp100_, "auto") == 0;
#line 167 "../src/main-window.vala"
	_tmp101_ = slick_greeter_singleton;
#line 167 "../src/main-window.vala"
	if (_tmp101_->test_mode) {
#line 2860 "main-window.c"
		Monitor* _tmp102_;
		Monitor* _tmp103_;
		Background* _tmp104_;
		GList* _tmp105_;
		GList* _tmp106_;
		gconstpointer _tmp107_;
		Background* _tmp108_;
		gint _tmp109_;
		gint _tmp110_;
		Background* _tmp111_;
		gint _tmp112_;
		gint _tmp113_;
#line 170 "../src/main-window.vala"
		(self->priv->monitors == NULL) ? NULL : (self->priv->monitors = (_g_list_free__monitor_unref0_ (self->priv->monitors), NULL));
#line 170 "../src/main-window.vala"
		self->priv->monitors = NULL;
#line 171 "../src/main-window.vala"
		_tmp102_ = monitor_new (0, 0, 800, 600);
#line 171 "../src/main-window.vala"
		self->priv->monitors = g_list_append (self->priv->monitors, _tmp102_);
#line 172 "../src/main-window.vala"
		_tmp103_ = monitor_new (800, 120, 640, 480);
#line 172 "../src/main-window.vala"
		self->priv->monitors = g_list_append (self->priv->monitors, _tmp103_);
#line 173 "../src/main-window.vala"
		_tmp104_ = self->priv->background;
#line 173 "../src/main-window.vala"
		_tmp105_ = self->priv->monitors;
#line 173 "../src/main-window.vala"
		background_set_monitors (_tmp104_, _tmp105_);
#line 174 "../src/main-window.vala"
		_tmp106_ = self->priv->monitors;
#line 174 "../src/main-window.vala"
		_tmp107_ = g_list_nth_data (_tmp106_, (guint) 0);
#line 174 "../src/main-window.vala"
		main_window_move_to_monitor (self, (Monitor*) _tmp107_);
#line 175 "../src/main-window.vala"
		_tmp108_ = self->priv->background;
#line 175 "../src/main-window.vala"
		_tmp109_ = background_get_width (_tmp108_);
#line 175 "../src/main-window.vala"
		_tmp110_ = _tmp109_;
#line 175 "../src/main-window.vala"
		_tmp111_ = self->priv->background;
#line 175 "../src/main-window.vala"
		_tmp112_ = background_get_height (_tmp111_);
#line 175 "../src/main-window.vala"
		_tmp113_ = _tmp112_;
#line 175 "../src/main-window.vala"
		gtk_window_resize ((GtkWindow*) self, _tmp110_, _tmp113_);
#line 2911 "main-window.c"
	} else {
		GdkScreen* screen = NULL;
		GdkScreen* _tmp114_;
		GdkScreen* _tmp115_;
		GdkScreen* _tmp116_;
		GdkScreen* _tmp117_;
#line 179 "../src/main-window.vala"
		_tmp114_ = gtk_window_get_screen ((GtkWindow*) self);
#line 179 "../src/main-window.vala"
		_tmp115_ = _g_object_ref0 (_tmp114_);
#line 179 "../src/main-window.vala"
		screen = _tmp115_;
#line 180 "../src/main-window.vala"
		_tmp116_ = screen;
#line 180 "../src/main-window.vala"
		g_signal_connect_object (_tmp116_, "monitors-changed", (GCallback) _main_window_monitors_changed_cb_gdk_screen_monitors_changed, self, 0);
#line 181 "../src/main-window.vala"
		_tmp117_ = screen;
#line 181 "../src/main-window.vala"
		main_window_monitors_changed_cb (self, _tmp117_);
#line 167 "../src/main-window.vala"
		_g_object_unref0 (screen);
#line 2934 "main-window.c"
	}
#line 191 "../src/main-window.vala"
	_tmp118_ = self->priv->login_box;
#line 191 "../src/main-window.vala"
	_tmp119_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp118_);
#line 191 "../src/main-window.vala"
	_tmp120_ = _tmp119_;
#line 191 "../src/main-window.vala"
	if (_tmp120_) {
#line 2944 "main-window.c"
		GtkBox* _tmp121_;
#line 192 "../src/main-window.vala"
		_tmp121_ = self->priv->login_box;
#line 192 "../src/main-window.vala"
		gtk_widget_show ((GtkWidget*) _tmp121_);
#line 2950 "main-window.c"
	}
#line 43 "../src/main-window.vala"
	_g_object_unref0 (image);
#line 43 "../src/main-window.vala"
	_g_object_unref0 (align);
#line 43 "../src/main-window.vala"
	_g_free0 (content_align);
#line 43 "../src/main-window.vala"
	_g_free0 (shadow_style);
#line 43 "../src/main-window.vala"
	_g_free0 (shadow_path);
#line 43 "../src/main-window.vala"
	_g_object_unref0 (menualign);
#line 43 "../src/main-window.vala"
	_g_object_unref0 (menubox);
#line 43 "../src/main-window.vala"
	_g_object_unref0 (accel_group);
#line 43 "../src/main-window.vala"
	return obj;
#line 2970 "main-window.c"
}

static void
main_window_class_init (MainWindowClass * klass,
                        gpointer klass_data)
{
#line 21 "../src/main-window.vala"
	main_window_parent_class = g_type_class_peek_parent (klass);
#line 21 "../src/main-window.vala"
	g_type_class_adjust_private_offset (klass, &MainWindow_private_offset);
#line 21 "../src/main-window.vala"
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, GtkAllocation*)) main_window_real_size_allocate;
#line 21 "../src/main-window.vala"
	((GtkWidgetClass *) klass)->realize = (void (*) (GtkWidget*)) main_window_real_realize;
#line 21 "../src/main-window.vala"
	((GtkWidgetClass *) klass)->motion_notify_event = (gboolean (*) (GtkWidget*, GdkEventMotion*)) main_window_real_motion_notify_event;
#line 21 "../src/main-window.vala"
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget*, GdkEventKey*)) main_window_real_key_press_event;
#line 21 "../src/main-window.vala"
	G_OBJECT_CLASS (klass)->constructor = main_window_constructor;
#line 21 "../src/main-window.vala"
	G_OBJECT_CLASS (klass)->finalize = main_window_finalize;
#line 2993 "main-window.c"
}

static void
main_window_instance_init (MainWindow * self,
                           gpointer klass)
{
#line 21 "../src/main-window.vala"
	self->priv = main_window_get_instance_private (self);
#line 35 "../src/main-window.vala"
	self->priv->shutdown_dialog = NULL;
#line 3004 "main-window.c"
}

static void
main_window_finalize (GObject * obj)
{
	MainWindow * self;
#line 21 "../src/main-window.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAIN_WINDOW, MainWindow);
#line 23 "../src/main-window.vala"
	_g_object_unref0 (self->menubar);
#line 25 "../src/main-window.vala"
	(self->priv->monitors == NULL) ? NULL : (self->priv->monitors = (_g_list_free__monitor_unref0_ (self->priv->monitors), NULL));
#line 26 "../src/main-window.vala"
	_monitor_unref0 (self->priv->primary_monitor);
#line 27 "../src/main-window.vala"
	_monitor_unref0 (self->priv->active_monitor);
#line 28 "../src/main-window.vala"
	_g_free0 (self->priv->only_on_monitor);
#line 30 "../src/main-window.vala"
	_g_object_unref0 (self->priv->background);
#line 31 "../src/main-window.vala"
	_g_object_unref0 (self->priv->login_box);
#line 32 "../src/main-window.vala"
	_g_object_unref0 (self->priv->hbox);
#line 33 "../src/main-window.vala"
	_g_object_unref0 (self->priv->content_box);
#line 34 "../src/main-window.vala"
	_g_object_unref0 (self->priv->back_button);
#line 35 "../src/main-window.vala"
	_g_object_unref0 (self->priv->shutdown_dialog);
#line 38 "../src/main-window.vala"
	_g_object_unref0 (self->stack);
#line 21 "../src/main-window.vala"
	G_OBJECT_CLASS (main_window_parent_class)->finalize (obj);
#line 3039 "main-window.c"
}

static GType
main_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MainWindow), 0, (GInstanceInitFunc) main_window_instance_init, NULL };
	GType main_window_type_id;
	main_window_type_id = g_type_register_static (gtk_window_get_type (), "MainWindow", &g_define_type_info, 0);
	MainWindow_private_offset = g_type_add_instance_private (main_window_type_id, sizeof (MainWindowPrivate));
	return main_window_type_id;
}

GType
main_window_get_type (void)
{
	static volatile gsize main_window_type_id__once = 0;
	if (g_once_init_enter (&main_window_type_id__once)) {
		GType main_window_type_id;
		main_window_type_id = main_window_get_type_once ();
		g_once_init_leave (&main_window_type_id__once, main_window_type_id);
	}
	return main_window_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

