/* automatically generated by rust-bindgen 0.72.0 */

#![allow(clippy::all)]
#![allow(improper_ctypes)]
#![allow(unused_unsafe)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![allow(non_upper_case_globals)]
#![allow(unnecessary_transmutes)]
use compiler::bindings::*;

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    fn extract_bit(byte: u8, index: usize) -> bool {
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        Self::extract_bit(byte, index)
    }
    #[inline]
    pub unsafe fn raw_get_bit(this: *const Self, index: usize) -> bool {
        debug_assert!(index / 8 < core::mem::size_of::<Storage>());
        let byte_index = index / 8;
        let byte = unsafe {
            *(core::ptr::addr_of!((*this).storage) as *const u8).offset(byte_index as isize)
        };
        Self::extract_bit(byte, index)
    }
    #[inline]
    fn change_bit(byte: u8, index: usize, val: bool) -> u8 {
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            byte | mask
        } else {
            byte & !mask
        }
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        *byte = Self::change_bit(*byte, index, val);
    }
    #[inline]
    pub unsafe fn raw_set_bit(this: *mut Self, index: usize, val: bool) {
        debug_assert!(index / 8 < core::mem::size_of::<Storage>());
        let byte_index = index / 8;
        let byte = unsafe {
            (core::ptr::addr_of_mut!((*this).storage) as *mut u8).offset(byte_index as isize)
        };
        unsafe { *byte = Self::change_bit(*byte, index, val) };
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub unsafe fn raw_get(this: *const Self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < core::mem::size_of::<Storage>());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= core::mem::size_of::<Storage>());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if unsafe { Self::raw_get_bit(this, i + bit_offset) } {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
    #[inline]
    pub unsafe fn raw_set(this: *mut Self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < core::mem::size_of::<Storage>());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= core::mem::size_of::<Storage>());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            unsafe { Self::raw_set_bit(this, index + bit_offset, val_bit_is_set) };
        }
    }
}
#[repr(C)]
pub struct __BindgenUnionField<T>(::std::marker::PhantomData<T>);
impl<T> __BindgenUnionField<T> {
    #[inline]
    pub const fn new() -> Self {
        __BindgenUnionField(::std::marker::PhantomData)
    }
    #[inline]
    pub unsafe fn as_ref(&self) -> &T {
        ::std::mem::transmute(self)
    }
    #[inline]
    pub unsafe fn as_mut(&mut self) -> &mut T {
        ::std::mem::transmute(self)
    }
}
impl<T> ::std::default::Default for __BindgenUnionField<T> {
    #[inline]
    fn default() -> Self {
        Self::new()
    }
}
impl<T> ::std::clone::Clone for __BindgenUnionField<T> {
    #[inline]
    fn clone(&self) -> Self {
        *self
    }
}
impl<T> ::std::marker::Copy for __BindgenUnionField<T> {}
impl<T> ::std::fmt::Debug for __BindgenUnionField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__BindgenUnionField")
    }
}
impl<T> ::std::hash::Hash for __BindgenUnionField<T> {
    fn hash<H: ::std::hash::Hasher>(&self, _state: &mut H) {}
}
impl<T> ::std::cmp::PartialEq for __BindgenUnionField<T> {
    fn eq(&self, _other: &__BindgenUnionField<T>) -> bool {
        true
    }
}
impl<T> ::std::cmp::Eq for __BindgenUnionField<T> {}
pub const NAK_SUBGROUP_SIZE: u32 = 32;
pub const NAK_QMD_ALIGN_B: u32 = 256;
pub const NAK_MAX_QMD_SIZE_B: u32 = 384;
pub const NAK_MAX_QMD_DWORDS: u32 = 96;
pub const NVIDIA_VENDOR_ID: u32 = 4318;
pub const DRM_NAME: &[u8; 4] = b"drm\0";
pub const DRM_MIN_ORDER: u32 = 5;
pub const DRM_MAX_ORDER: u32 = 22;
pub const DRM_RAM_PERCENT: u32 = 10;
pub const DRM_CAP_DUMB_BUFFER: u32 = 1;
pub const DRM_CAP_VBLANK_HIGH_CRTC: u32 = 2;
pub const DRM_CAP_DUMB_PREFERRED_DEPTH: u32 = 3;
pub const DRM_CAP_DUMB_PREFER_SHADOW: u32 = 4;
pub const DRM_CAP_PRIME: u32 = 5;
pub const DRM_PRIME_CAP_IMPORT: u32 = 1;
pub const DRM_PRIME_CAP_EXPORT: u32 = 2;
pub const DRM_CAP_TIMESTAMP_MONOTONIC: u32 = 6;
pub const DRM_CAP_ASYNC_PAGE_FLIP: u32 = 7;
pub const DRM_CAP_CURSOR_WIDTH: u32 = 8;
pub const DRM_CAP_CURSOR_HEIGHT: u32 = 9;
pub const DRM_CAP_ADDFB2_MODIFIERS: u32 = 16;
pub const DRM_CAP_PAGE_FLIP_TARGET: u32 = 17;
pub const DRM_CAP_CRTC_IN_VBLANK_EVENT: u32 = 18;
pub const DRM_CAP_SYNCOBJ: u32 = 19;
pub const DRM_CAP_SYNCOBJ_TIMELINE: u32 = 20;
pub const DRM_CAP_ATOMIC_ASYNC_PAGE_FLIP: u32 = 21;
pub const DRM_CLIENT_CAP_STEREO_3D: u32 = 1;
pub const DRM_CLIENT_CAP_UNIVERSAL_PLANES: u32 = 2;
pub const DRM_CLIENT_CAP_ATOMIC: u32 = 3;
pub const DRM_CLIENT_CAP_ASPECT_RATIO: u32 = 4;
pub const DRM_CLIENT_CAP_WRITEBACK_CONNECTORS: u32 = 5;
pub const DRM_CLIENT_CAP_CURSOR_PLANE_HOTSPOT: u32 = 6;
pub const DRM_SYNCOBJ_CREATE_SIGNALED: u32 = 1;
pub const DRM_SYNCOBJ_FD_TO_HANDLE_FLAGS_IMPORT_SYNC_FILE: u32 = 1;
pub const DRM_SYNCOBJ_FD_TO_HANDLE_FLAGS_TIMELINE: u32 = 2;
pub const DRM_SYNCOBJ_HANDLE_TO_FD_FLAGS_EXPORT_SYNC_FILE: u32 = 1;
pub const DRM_SYNCOBJ_HANDLE_TO_FD_FLAGS_TIMELINE: u32 = 2;
pub const DRM_SYNCOBJ_WAIT_FLAGS_WAIT_ALL: u32 = 1;
pub const DRM_SYNCOBJ_WAIT_FLAGS_WAIT_FOR_SUBMIT: u32 = 2;
pub const DRM_SYNCOBJ_WAIT_FLAGS_WAIT_AVAILABLE: u32 = 4;
pub const DRM_SYNCOBJ_WAIT_FLAGS_WAIT_DEADLINE: u32 = 8;
pub const DRM_SYNCOBJ_QUERY_FLAGS_LAST_SUBMITTED: u32 = 1;
pub const DRM_CRTC_SEQUENCE_RELATIVE: u32 = 1;
pub const DRM_CRTC_SEQUENCE_NEXT_ON_MISS: u32 = 2;
pub const DRM_CLIENT_NAME_MAX_LEN: u32 = 64;
pub const DRM_CONNECTOR_NAME_LEN: u32 = 32;
pub const DRM_DISPLAY_MODE_LEN: u32 = 32;
pub const DRM_PROP_NAME_LEN: u32 = 32;
pub const DRM_MODE_TYPE_BUILTIN: u32 = 1;
pub const DRM_MODE_TYPE_CLOCK_C: u32 = 3;
pub const DRM_MODE_TYPE_CRTC_C: u32 = 5;
pub const DRM_MODE_TYPE_PREFERRED: u32 = 8;
pub const DRM_MODE_TYPE_DEFAULT: u32 = 16;
pub const DRM_MODE_TYPE_USERDEF: u32 = 32;
pub const DRM_MODE_TYPE_DRIVER: u32 = 64;
pub const DRM_MODE_TYPE_ALL: u32 = 104;
pub const DRM_MODE_FLAG_PHSYNC: u32 = 1;
pub const DRM_MODE_FLAG_NHSYNC: u32 = 2;
pub const DRM_MODE_FLAG_PVSYNC: u32 = 4;
pub const DRM_MODE_FLAG_NVSYNC: u32 = 8;
pub const DRM_MODE_FLAG_INTERLACE: u32 = 16;
pub const DRM_MODE_FLAG_DBLSCAN: u32 = 32;
pub const DRM_MODE_FLAG_CSYNC: u32 = 64;
pub const DRM_MODE_FLAG_PCSYNC: u32 = 128;
pub const DRM_MODE_FLAG_NCSYNC: u32 = 256;
pub const DRM_MODE_FLAG_HSKEW: u32 = 512;
pub const DRM_MODE_FLAG_BCAST: u32 = 1024;
pub const DRM_MODE_FLAG_PIXMUX: u32 = 2048;
pub const DRM_MODE_FLAG_DBLCLK: u32 = 4096;
pub const DRM_MODE_FLAG_CLKDIV2: u32 = 8192;
pub const DRM_MODE_FLAG_3D_MASK: u32 = 507904;
pub const DRM_MODE_FLAG_3D_NONE: u32 = 0;
pub const DRM_MODE_FLAG_3D_FRAME_PACKING: u32 = 16384;
pub const DRM_MODE_FLAG_3D_FIELD_ALTERNATIVE: u32 = 32768;
pub const DRM_MODE_FLAG_3D_LINE_ALTERNATIVE: u32 = 49152;
pub const DRM_MODE_FLAG_3D_SIDE_BY_SIDE_FULL: u32 = 65536;
pub const DRM_MODE_FLAG_3D_L_DEPTH: u32 = 81920;
pub const DRM_MODE_FLAG_3D_L_DEPTH_GFX_GFX_DEPTH: u32 = 98304;
pub const DRM_MODE_FLAG_3D_TOP_AND_BOTTOM: u32 = 114688;
pub const DRM_MODE_FLAG_3D_SIDE_BY_SIDE_HALF: u32 = 131072;
pub const DRM_MODE_PICTURE_ASPECT_NONE: u32 = 0;
pub const DRM_MODE_PICTURE_ASPECT_4_3: u32 = 1;
pub const DRM_MODE_PICTURE_ASPECT_16_9: u32 = 2;
pub const DRM_MODE_PICTURE_ASPECT_64_27: u32 = 3;
pub const DRM_MODE_PICTURE_ASPECT_256_135: u32 = 4;
pub const DRM_MODE_CONTENT_TYPE_NO_DATA: u32 = 0;
pub const DRM_MODE_CONTENT_TYPE_GRAPHICS: u32 = 1;
pub const DRM_MODE_CONTENT_TYPE_PHOTO: u32 = 2;
pub const DRM_MODE_CONTENT_TYPE_CINEMA: u32 = 3;
pub const DRM_MODE_CONTENT_TYPE_GAME: u32 = 4;
pub const DRM_MODE_FLAG_PIC_AR_MASK: u32 = 7864320;
pub const DRM_MODE_FLAG_PIC_AR_NONE: u32 = 0;
pub const DRM_MODE_FLAG_PIC_AR_4_3: u32 = 524288;
pub const DRM_MODE_FLAG_PIC_AR_16_9: u32 = 1048576;
pub const DRM_MODE_FLAG_PIC_AR_64_27: u32 = 1572864;
pub const DRM_MODE_FLAG_PIC_AR_256_135: u32 = 2097152;
pub const DRM_MODE_FLAG_ALL: u32 = 521215;
pub const DRM_MODE_DPMS_ON: u32 = 0;
pub const DRM_MODE_DPMS_STANDBY: u32 = 1;
pub const DRM_MODE_DPMS_SUSPEND: u32 = 2;
pub const DRM_MODE_DPMS_OFF: u32 = 3;
pub const DRM_MODE_SCALE_NONE: u32 = 0;
pub const DRM_MODE_SCALE_FULLSCREEN: u32 = 1;
pub const DRM_MODE_SCALE_CENTER: u32 = 2;
pub const DRM_MODE_SCALE_ASPECT: u32 = 3;
pub const DRM_MODE_DITHERING_OFF: u32 = 0;
pub const DRM_MODE_DITHERING_ON: u32 = 1;
pub const DRM_MODE_DITHERING_AUTO: u32 = 2;
pub const DRM_MODE_DIRTY_OFF: u32 = 0;
pub const DRM_MODE_DIRTY_ON: u32 = 1;
pub const DRM_MODE_DIRTY_ANNOTATE: u32 = 2;
pub const DRM_MODE_LINK_STATUS_GOOD: u32 = 0;
pub const DRM_MODE_LINK_STATUS_BAD: u32 = 1;
pub const DRM_MODE_ROTATE_0: u32 = 1;
pub const DRM_MODE_ROTATE_90: u32 = 2;
pub const DRM_MODE_ROTATE_180: u32 = 4;
pub const DRM_MODE_ROTATE_270: u32 = 8;
pub const DRM_MODE_ROTATE_MASK: u32 = 15;
pub const DRM_MODE_REFLECT_X: u32 = 16;
pub const DRM_MODE_REFLECT_Y: u32 = 32;
pub const DRM_MODE_REFLECT_MASK: u32 = 48;
pub const DRM_MODE_CONTENT_PROTECTION_UNDESIRED: u32 = 0;
pub const DRM_MODE_CONTENT_PROTECTION_DESIRED: u32 = 1;
pub const DRM_MODE_CONTENT_PROTECTION_ENABLED: u32 = 2;
pub const DRM_MODE_PRESENT_TOP_FIELD: u32 = 1;
pub const DRM_MODE_PRESENT_BOTTOM_FIELD: u32 = 2;
pub const DRM_MODE_ENCODER_NONE: u32 = 0;
pub const DRM_MODE_ENCODER_DAC: u32 = 1;
pub const DRM_MODE_ENCODER_TMDS: u32 = 2;
pub const DRM_MODE_ENCODER_LVDS: u32 = 3;
pub const DRM_MODE_ENCODER_TVDAC: u32 = 4;
pub const DRM_MODE_ENCODER_VIRTUAL: u32 = 5;
pub const DRM_MODE_ENCODER_DSI: u32 = 6;
pub const DRM_MODE_ENCODER_DPMST: u32 = 7;
pub const DRM_MODE_ENCODER_DPI: u32 = 8;
pub const DRM_MODE_CONNECTOR_Unknown: u32 = 0;
pub const DRM_MODE_CONNECTOR_VGA: u32 = 1;
pub const DRM_MODE_CONNECTOR_DVII: u32 = 2;
pub const DRM_MODE_CONNECTOR_DVID: u32 = 3;
pub const DRM_MODE_CONNECTOR_DVIA: u32 = 4;
pub const DRM_MODE_CONNECTOR_Composite: u32 = 5;
pub const DRM_MODE_CONNECTOR_SVIDEO: u32 = 6;
pub const DRM_MODE_CONNECTOR_LVDS: u32 = 7;
pub const DRM_MODE_CONNECTOR_Component: u32 = 8;
pub const DRM_MODE_CONNECTOR_9PinDIN: u32 = 9;
pub const DRM_MODE_CONNECTOR_DisplayPort: u32 = 10;
pub const DRM_MODE_CONNECTOR_HDMIA: u32 = 11;
pub const DRM_MODE_CONNECTOR_HDMIB: u32 = 12;
pub const DRM_MODE_CONNECTOR_TV: u32 = 13;
pub const DRM_MODE_CONNECTOR_eDP: u32 = 14;
pub const DRM_MODE_CONNECTOR_VIRTUAL: u32 = 15;
pub const DRM_MODE_CONNECTOR_DSI: u32 = 16;
pub const DRM_MODE_CONNECTOR_DPI: u32 = 17;
pub const DRM_MODE_CONNECTOR_WRITEBACK: u32 = 18;
pub const DRM_MODE_CONNECTOR_SPI: u32 = 19;
pub const DRM_MODE_CONNECTOR_USB: u32 = 20;
pub const DRM_MODE_PROP_PENDING: u32 = 1;
pub const DRM_MODE_PROP_RANGE: u32 = 2;
pub const DRM_MODE_PROP_IMMUTABLE: u32 = 4;
pub const DRM_MODE_PROP_ENUM: u32 = 8;
pub const DRM_MODE_PROP_BLOB: u32 = 16;
pub const DRM_MODE_PROP_BITMASK: u32 = 32;
pub const DRM_MODE_PROP_LEGACY_TYPE: u32 = 58;
pub const DRM_MODE_PROP_EXTENDED_TYPE: u32 = 65472;
pub const DRM_MODE_PROP_ATOMIC: u32 = 2147483648;
pub const DRM_MODE_OBJECT_CRTC: u32 = 3435973836;
pub const DRM_MODE_OBJECT_CONNECTOR: u32 = 3233857728;
pub const DRM_MODE_OBJECT_ENCODER: u32 = 3772834016;
pub const DRM_MODE_OBJECT_MODE: u32 = 3739147998;
pub const DRM_MODE_OBJECT_PROPERTY: u32 = 2964369584;
pub const DRM_MODE_OBJECT_FB: u32 = 4227595259;
pub const DRM_MODE_OBJECT_BLOB: u32 = 3149642683;
pub const DRM_MODE_OBJECT_PLANE: u32 = 4008636142;
pub const DRM_MODE_OBJECT_ANY: u32 = 0;
pub const DRM_MODE_FB_INTERLACED: u32 = 1;
pub const DRM_MODE_FB_MODIFIERS: u32 = 2;
pub const DRM_MODE_FB_DIRTY_ANNOTATE_COPY: u32 = 1;
pub const DRM_MODE_FB_DIRTY_ANNOTATE_FILL: u32 = 2;
pub const DRM_MODE_FB_DIRTY_FLAGS: u32 = 3;
pub const DRM_MODE_FB_DIRTY_MAX_CLIPS: u32 = 256;
pub const DRM_MODE_CURSOR_BO: u32 = 1;
pub const DRM_MODE_CURSOR_MOVE: u32 = 2;
pub const DRM_MODE_CURSOR_FLAGS: u32 = 3;
pub const DRM_MODE_PAGE_FLIP_EVENT: u32 = 1;
pub const DRM_MODE_PAGE_FLIP_ASYNC: u32 = 2;
pub const DRM_MODE_PAGE_FLIP_TARGET_ABSOLUTE: u32 = 4;
pub const DRM_MODE_PAGE_FLIP_TARGET_RELATIVE: u32 = 8;
pub const DRM_MODE_PAGE_FLIP_TARGET: u32 = 12;
pub const DRM_MODE_PAGE_FLIP_FLAGS: u32 = 15;
pub const DRM_MODE_ATOMIC_TEST_ONLY: u32 = 256;
pub const DRM_MODE_ATOMIC_NONBLOCK: u32 = 512;
pub const DRM_MODE_ATOMIC_ALLOW_MODESET: u32 = 1024;
pub const DRM_MODE_ATOMIC_FLAGS: u32 = 1795;
pub const DRM_IOCTL_BASE: u8 = 100u8;
pub const DRM_COMMAND_BASE: u32 = 64;
pub const DRM_COMMAND_END: u32 = 160;
pub const DRM_EVENT_VBLANK: u32 = 1;
pub const DRM_EVENT_FLIP_COMPLETE: u32 = 2;
pub const DRM_EVENT_CRTC_SEQUENCE: u32 = 3;
pub const DRM_MAX_MINOR: u32 = 64;
pub const DRM_IOC_VOID: u32 = 0;
pub const DRM_IOC_READ: u32 = 2;
pub const DRM_IOC_WRITE: u32 = 1;
pub const DRM_IOC_READWRITE: u32 = 3;
pub const DRM_DEV_UID: u32 = 0;
pub const DRM_DEV_GID: u32 = 0;
pub const DRM_DIR_NAME: &[u8; 9] = b"/dev/dri\0";
pub const DRM_PRIMARY_MINOR_NAME: &[u8; 5] = b"card\0";
pub const DRM_CONTROL_MINOR_NAME: &[u8; 9] = b"controlD\0";
pub const DRM_RENDER_MINOR_NAME: &[u8; 8] = b"renderD\0";
pub const DRM_PROC_NAME: &[u8; 11] = b"/proc/dri/\0";
pub const DRM_DEV_NAME: &[u8; 10] = b"%s/card%d\0";
pub const DRM_CONTROL_DEV_NAME: &[u8; 14] = b"%s/controlD%d\0";
pub const DRM_RENDER_DEV_NAME: &[u8; 13] = b"%s/renderD%d\0";
pub const DRM_ERR_NO_DEVICE: i32 = -1001;
pub const DRM_ERR_NO_ACCESS: i32 = -1002;
pub const DRM_ERR_NOT_ROOT: i32 = -1003;
pub const DRM_ERR_INVALID: i32 = -1004;
pub const DRM_ERR_NO_FD: i32 = -1005;
pub const DRM_AGP_NO_HANDLE: u32 = 0;
pub const DRM_VBLANK_HIGH_CRTC_SHIFT: u32 = 1;
pub const DRM_LOCK_HELD: u32 = 2147483648;
pub const DRM_LOCK_CONT: u32 = 1073741824;
pub const DRM_NODE_PRIMARY: u32 = 0;
pub const DRM_NODE_CONTROL: u32 = 1;
pub const DRM_NODE_RENDER: u32 = 2;
pub const DRM_NODE_MAX: u32 = 3;
pub const DRM_EVENT_CONTEXT_VERSION: u32 = 4;
pub const DRM_BUS_PCI: u32 = 0;
pub const DRM_BUS_USB: u32 = 1;
pub const DRM_BUS_PLATFORM: u32 = 2;
pub const DRM_BUS_HOST1X: u32 = 3;
pub const DRM_BUS_FAUX: u32 = 4;
pub const DRM_PLATFORM_DEVICE_NAME_LEN: u32 = 512;
pub const DRM_HOST1X_DEVICE_NAME_LEN: u32 = 512;
pub const DRM_FAUX_DEVICE_NAME_LEN: u32 = 512;
pub const DRM_DEVICE_GET_PCI_REVISION: u32 = 1;
pub const DRM_NOUVEAU_EVENT_NVIF: u32 = 2147483648;
pub const DRM_NOUVEAU_SYNC_SYNCOBJ: u32 = 0;
pub const DRM_NOUVEAU_SYNC_TIMELINE_SYNCOBJ: u32 = 1;
pub const DRM_NOUVEAU_SYNC_TYPE_MASK: u32 = 15;
pub const DRM_NOUVEAU_VM_BIND_OP_MAP: u32 = 0;
pub const DRM_NOUVEAU_VM_BIND_OP_UNMAP: u32 = 1;
pub const DRM_NOUVEAU_VM_BIND_SPARSE: u32 = 256;
pub const DRM_NOUVEAU_VM_BIND_RUN_ASYNC: u32 = 1;
pub const DRM_NOUVEAU_EXEC_PUSH_NO_PREFETCH: u32 = 1;
pub const DRM_NOUVEAU_GETPARAM: u32 = 0;
pub const DRM_NOUVEAU_SETPARAM: u32 = 1;
pub const DRM_NOUVEAU_CHANNEL_ALLOC: u32 = 2;
pub const DRM_NOUVEAU_CHANNEL_FREE: u32 = 3;
pub const DRM_NOUVEAU_GROBJ_ALLOC: u32 = 4;
pub const DRM_NOUVEAU_NOTIFIEROBJ_ALLOC: u32 = 5;
pub const DRM_NOUVEAU_GPUOBJ_FREE: u32 = 6;
pub const DRM_NOUVEAU_NVIF: u32 = 7;
pub const DRM_NOUVEAU_SVM_INIT: u32 = 8;
pub const DRM_NOUVEAU_SVM_BIND: u32 = 9;
pub const DRM_NOUVEAU_VM_INIT: u32 = 16;
pub const DRM_NOUVEAU_VM_BIND: u32 = 17;
pub const DRM_NOUVEAU_EXEC: u32 = 18;
pub const DRM_NOUVEAU_GEM_NEW: u32 = 64;
pub const DRM_NOUVEAU_GEM_PUSHBUF: u32 = 65;
pub const DRM_NOUVEAU_GEM_CPU_PREP: u32 = 66;
pub const DRM_NOUVEAU_GEM_CPU_FINI: u32 = 67;
pub const DRM_NOUVEAU_GEM_INFO: u32 = 68;
pub type __uint64_t = ::std::os::raw::c_ulonglong;
pub type __dev_t = __uint64_t;
pub type __gid_t = ::std::os::raw::c_uint;
pub type __mode_t = ::std::os::raw::c_uint;
pub type uint_fast32_t = ::std::os::raw::c_uint;
pub type __gnuc_va_list = __builtin_va_list;
pub type va_list = __gnuc_va_list;
pub type dev_t = __dev_t;
pub type gid_t = __gid_t;
pub type mode_t = __mode_t;
#[doc = "< No layout is specified."]
pub const FRAG_DEPTH_LAYOUT_NONE: gl_frag_depth_layout = 0;
pub const FRAG_DEPTH_LAYOUT_ANY: gl_frag_depth_layout = 1;
pub const FRAG_DEPTH_LAYOUT_GREATER: gl_frag_depth_layout = 2;
pub const FRAG_DEPTH_LAYOUT_LESS: gl_frag_depth_layout = 3;
pub const FRAG_DEPTH_LAYOUT_UNCHANGED: gl_frag_depth_layout = 4;
#[doc = " \\brief Layout qualifiers for gl_FragDepth.\n\n Extension AMD_conservative_depth allows gl_FragDepth to be redeclared with\n a layout qualifier.\n\n \\see enum ir_depth_layout"]
pub type gl_frag_depth_layout = ::std::os::raw::c_uint;
#[doc = "< No layout is specified."]
pub const FRAG_STENCIL_LAYOUT_NONE: gl_frag_stencil_layout = 0;
pub const FRAG_STENCIL_LAYOUT_ANY: gl_frag_stencil_layout = 1;
pub const FRAG_STENCIL_LAYOUT_GREATER: gl_frag_stencil_layout = 2;
pub const FRAG_STENCIL_LAYOUT_LESS: gl_frag_stencil_layout = 3;
pub const FRAG_STENCIL_LAYOUT_UNCHANGED: gl_frag_stencil_layout = 4;
#[doc = " \\brief Layout qualifiers for AMD_shader_early_and_late_fragment_tests."]
pub type gl_frag_stencil_layout = ::std::os::raw::c_uint;
pub const DERIVATIVE_GROUP_NONE: gl_derivative_group = 0;
pub const DERIVATIVE_GROUP_QUADS: gl_derivative_group = 1;
pub const DERIVATIVE_GROUP_LINEAR: gl_derivative_group = 2;
#[doc = " Arrangements for grouping invocations from NV_compute_shader_derivatives.\n\n   The extension provides new layout qualifiers that support two different\n   arrangements of compute shader invocations for the purpose of derivative\n   computation.  When specifying\n\n     layout(derivative_group_quadsNV) in;\n\n   compute shader invocations are grouped into 2x2x1 arrays whose four local\n   invocation ID values follow the pattern:\n\n       +-----------------+------------------+\n       | (2x+0, 2y+0, z) |  (2x+1, 2y+0, z) |\n       +-----------------+------------------+\n       | (2x+0, 2y+1, z) |  (2x+1, 2y+1, z) |\n       +-----------------+------------------+\n\n   where Y increases from bottom to top.  When specifying\n\n     layout(derivative_group_linearNV) in;\n\n   compute shader invocations are grouped into 2x2x1 arrays whose four local\n   invocation index values follow the pattern:\n\n       +------+------+\n       | 4n+0 | 4n+1 |\n       +------+------+\n       | 4n+2 | 4n+3 |\n       +------+------+\n\n   If neither layout qualifier is specified, derivatives in compute shaders\n   return zero, which is consistent with the handling of built-in texture\n   functions like texture() in GLSL 4.50 compute shaders."]
pub type gl_derivative_group = ::std::os::raw::c_uint;
unsafe extern "C" {
    pub fn nak_compiler_create(dev: *const nv_device_info) -> *mut nak_compiler;
}
unsafe extern "C" {
    pub fn nak_compiler_destroy(nak: *mut nak_compiler);
}
unsafe extern "C" {
    pub fn nak_debug_flags(nak: *const nak_compiler) -> u64;
}
unsafe extern "C" {
    pub fn nak_nir_options(nak: *const nak_compiler) -> *const nir_shader_compiler_options;
}
unsafe extern "C" {
    pub fn nak_preprocess_nir(nir: *mut nir_shader, nak: *const nak_compiler);
}
unsafe extern "C" {
    pub fn nak_nir_lower_image_addrs(nir: *mut nir_shader, nak: *const nak_compiler) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nak_sample_location {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nak_sample_location"][::std::mem::size_of::<nak_sample_location>() - 1usize];
    ["Alignment of nak_sample_location"][::std::mem::align_of::<nak_sample_location>() - 1usize];
};
impl nak_sample_location {
    #[inline]
    pub fn x_u4(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_x_u4(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn x_u4_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                4u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_x_u4_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                4u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn y_u4(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_y_u4(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn y_u4_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                4usize,
                4u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_y_u4_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                4usize,
                4u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(x_u4: u8, y_u4: u8) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 4u8, {
            let x_u4: u8 = unsafe { ::std::mem::transmute(x_u4) };
            x_u4 as u64
        });
        __bindgen_bitfield_unit.set(4usize, 4u8, {
            let y_u4: u8 = unsafe { ::std::mem::transmute(y_u4) };
            y_u4 as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nak_sample_mask {
    pub sample_mask: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nak_sample_mask"][::std::mem::size_of::<nak_sample_mask>() - 2usize];
    ["Alignment of nak_sample_mask"][::std::mem::align_of::<nak_sample_mask>() - 2usize];
    ["Offset of field: nak_sample_mask::sample_mask"]
        [::std::mem::offset_of!(nak_sample_mask, sample_mask) - 0usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nak_fs_key {
    pub zs_self_dep: bool,
    #[doc = " True if sample shading is forced on via an API knob such as\n VkPipelineMultisampleStateCreateInfo::minSampleShading"]
    pub force_sample_shading: bool,
    pub uses_underestimate: bool,
    #[doc = " The constant buffer index and offset at which the sample locations and\n pass sample masks tables lives."]
    pub sample_info_cb: u8,
    #[doc = " The offset into sample_info_cb at which the sample locations live.  The\n sample locations table is an array of nak_sample_location where each\n sample location is two 4-bit unorm values packed into an 8-bit value\n with the bottom 4 bits for x and the top 4 bits for y."]
    pub sample_locations_offset: u32,
    #[doc = " The offset into sample_info_cb at which the sample masks table lives.\n The sample masks table is an array of nak_sample_mask where each entry\n represents the set of samples covered by that pass corresponding to that\n sample in a multi-pass fragment shader invocaiton."]
    pub sample_masks_offset: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nak_fs_key"][::std::mem::size_of::<nak_fs_key>() - 12usize];
    ["Alignment of nak_fs_key"][::std::mem::align_of::<nak_fs_key>() - 4usize];
    ["Offset of field: nak_fs_key::zs_self_dep"]
        [::std::mem::offset_of!(nak_fs_key, zs_self_dep) - 0usize];
    ["Offset of field: nak_fs_key::force_sample_shading"]
        [::std::mem::offset_of!(nak_fs_key, force_sample_shading) - 1usize];
    ["Offset of field: nak_fs_key::uses_underestimate"]
        [::std::mem::offset_of!(nak_fs_key, uses_underestimate) - 2usize];
    ["Offset of field: nak_fs_key::sample_info_cb"]
        [::std::mem::offset_of!(nak_fs_key, sample_info_cb) - 3usize];
    ["Offset of field: nak_fs_key::sample_locations_offset"]
        [::std::mem::offset_of!(nak_fs_key, sample_locations_offset) - 4usize];
    ["Offset of field: nak_fs_key::sample_masks_offset"]
        [::std::mem::offset_of!(nak_fs_key, sample_masks_offset) - 8usize];
};
unsafe extern "C" {
    pub fn nak_postprocess_nir(
        nir: *mut nir_shader,
        nak: *const nak_compiler,
        robust2_modes: nir_variable_mode,
        fs_key: *const nak_fs_key,
    );
}
pub const NAK_TS_DOMAIN_ISOLINE: nak_ts_domain = 0;
pub const NAK_TS_DOMAIN_TRIANGLE: nak_ts_domain = 1;
pub const NAK_TS_DOMAIN_QUAD: nak_ts_domain = 2;
pub type nak_ts_domain = ::std::os::raw::c_uchar;
pub const NAK_TS_SPACING_INTEGER: nak_ts_spacing = 0;
pub const NAK_TS_SPACING_FRACT_ODD: nak_ts_spacing = 1;
pub const NAK_TS_SPACING_FRACT_EVEN: nak_ts_spacing = 2;
pub type nak_ts_spacing = ::std::os::raw::c_uchar;
pub const NAK_TS_PRIMS_POINTS: nak_ts_prims = 0;
pub const NAK_TS_PRIMS_LINES: nak_ts_prims = 1;
pub const NAK_TS_PRIMS_TRIANGLES_CW: nak_ts_prims = 2;
pub const NAK_TS_PRIMS_TRIANGLES_CCW: nak_ts_prims = 3;
pub type nak_ts_prims = ::std::os::raw::c_uchar;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nak_xfb_info {
    pub stride: [u32; 4usize],
    pub stream: [u8; 4usize],
    pub attr_count: [u8; 4usize],
    pub attr_index: [[u8; 128usize]; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nak_xfb_info"][::std::mem::size_of::<nak_xfb_info>() - 536usize];
    ["Alignment of nak_xfb_info"][::std::mem::align_of::<nak_xfb_info>() - 4usize];
    ["Offset of field: nak_xfb_info::stride"]
        [::std::mem::offset_of!(nak_xfb_info, stride) - 0usize];
    ["Offset of field: nak_xfb_info::stream"]
        [::std::mem::offset_of!(nak_xfb_info, stream) - 16usize];
    ["Offset of field: nak_xfb_info::attr_count"]
        [::std::mem::offset_of!(nak_xfb_info, attr_count) - 20usize];
    ["Offset of field: nak_xfb_info::attr_index"]
        [::std::mem::offset_of!(nak_xfb_info, attr_index) - 24usize];
};
impl Default for nak_xfb_info {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
pub struct nak_shader_info {
    pub stage: gl_shader_stage,
    #[doc = " Shader model"]
    pub sm: u8,
    #[doc = " Number of GPRs used"]
    pub num_gprs: u8,
    #[doc = " Number of control barriers used\n\n These are barriers in the sense of glsl barrier(), not reconvergence\n barriers. In CUDA, these barriers have an index, but we currently\n only use index zero for vulkan, which means this will be at most 1."]
    pub num_control_barriers: u8,
    pub _pad0: u8,
    #[doc = " Maximum number of warps per SM based on static information"]
    pub max_warps_per_sm: u32,
    #[doc = " Number of instructions used"]
    pub num_instrs: u32,
    #[doc = " Number of cycles used by fixed-latency instructions"]
    pub num_static_cycles: u32,
    #[doc = " Number of spills from GPRs to Memory"]
    pub num_spills_to_mem: u32,
    #[doc = " Number of fills from Memory to GPRs"]
    pub num_fills_from_mem: u32,
    #[doc = " Number of spills between register files"]
    pub num_spills_to_reg: u32,
    #[doc = " Number of fills between register files"]
    pub num_fills_from_reg: u32,
    #[doc = " Size of shader local (scratch) memory"]
    pub slm_size: u32,
    #[doc = " Size of call/return stack in bytes/warp"]
    pub crs_size: u32,
    pub __bindgen_anon_1: nak_shader_info__bindgen_ty_1,
    pub vtg: nak_shader_info__bindgen_ty_2,
    #[doc = " Shader header for 3D stages"]
    pub hdr: [u32; 32usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union nak_shader_info__bindgen_ty_1 {
    pub cs: nak_shader_info__bindgen_ty_1__bindgen_ty_1,
    pub fs: nak_shader_info__bindgen_ty_1__bindgen_ty_2,
    pub ts: nak_shader_info__bindgen_ty_1__bindgen_ty_3,
    pub _pad: [u8; 12usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nak_shader_info__bindgen_ty_1__bindgen_ty_1 {
    pub local_size: [u16; 3usize],
    pub smem_size: u16,
    pub _pad: [u8; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nak_shader_info__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::size_of::<nak_shader_info__bindgen_ty_1__bindgen_ty_1>() - 12usize];
    ["Alignment of nak_shader_info__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::align_of::<nak_shader_info__bindgen_ty_1__bindgen_ty_1>() - 2usize];
    ["Offset of field: nak_shader_info__bindgen_ty_1__bindgen_ty_1::local_size"]
        [::std::mem::offset_of!(nak_shader_info__bindgen_ty_1__bindgen_ty_1, local_size) - 0usize];
    ["Offset of field: nak_shader_info__bindgen_ty_1__bindgen_ty_1::smem_size"]
        [::std::mem::offset_of!(nak_shader_info__bindgen_ty_1__bindgen_ty_1, smem_size) - 6usize];
    ["Offset of field: nak_shader_info__bindgen_ty_1__bindgen_ty_1::_pad"]
        [::std::mem::offset_of!(nak_shader_info__bindgen_ty_1__bindgen_ty_1, _pad) - 8usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nak_shader_info__bindgen_ty_1__bindgen_ty_2 {
    pub writes_depth: bool,
    pub reads_sample_mask: bool,
    pub post_depth_coverage: bool,
    pub uses_sample_shading: bool,
    pub early_fragment_tests: bool,
    pub _pad: [u8; 7usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nak_shader_info__bindgen_ty_1__bindgen_ty_2"]
        [::std::mem::size_of::<nak_shader_info__bindgen_ty_1__bindgen_ty_2>() - 12usize];
    ["Alignment of nak_shader_info__bindgen_ty_1__bindgen_ty_2"]
        [::std::mem::align_of::<nak_shader_info__bindgen_ty_1__bindgen_ty_2>() - 1usize];
    ["Offset of field: nak_shader_info__bindgen_ty_1__bindgen_ty_2::writes_depth"][::std::mem::offset_of!(
        nak_shader_info__bindgen_ty_1__bindgen_ty_2,
        writes_depth
    ) - 0usize];
    ["Offset of field: nak_shader_info__bindgen_ty_1__bindgen_ty_2::reads_sample_mask"][::std::mem::offset_of!(
        nak_shader_info__bindgen_ty_1__bindgen_ty_2,
        reads_sample_mask
    ) - 1usize];
    ["Offset of field: nak_shader_info__bindgen_ty_1__bindgen_ty_2::post_depth_coverage"][::std::mem::offset_of!(
        nak_shader_info__bindgen_ty_1__bindgen_ty_2,
        post_depth_coverage
    )
        - 2usize];
    ["Offset of field: nak_shader_info__bindgen_ty_1__bindgen_ty_2::uses_sample_shading"][::std::mem::offset_of!(
        nak_shader_info__bindgen_ty_1__bindgen_ty_2,
        uses_sample_shading
    )
        - 3usize];
    ["Offset of field: nak_shader_info__bindgen_ty_1__bindgen_ty_2::early_fragment_tests"][::std::mem::offset_of!(
        nak_shader_info__bindgen_ty_1__bindgen_ty_2,
        early_fragment_tests
    )
        - 4usize];
    ["Offset of field: nak_shader_info__bindgen_ty_1__bindgen_ty_2::_pad"]
        [::std::mem::offset_of!(nak_shader_info__bindgen_ty_1__bindgen_ty_2, _pad) - 5usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nak_shader_info__bindgen_ty_1__bindgen_ty_3 {
    pub domain: nak_ts_domain,
    pub spacing: nak_ts_spacing,
    pub prims: nak_ts_prims,
    pub _pad: [u8; 9usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nak_shader_info__bindgen_ty_1__bindgen_ty_3"]
        [::std::mem::size_of::<nak_shader_info__bindgen_ty_1__bindgen_ty_3>() - 12usize];
    ["Alignment of nak_shader_info__bindgen_ty_1__bindgen_ty_3"]
        [::std::mem::align_of::<nak_shader_info__bindgen_ty_1__bindgen_ty_3>() - 1usize];
    ["Offset of field: nak_shader_info__bindgen_ty_1__bindgen_ty_3::domain"]
        [::std::mem::offset_of!(nak_shader_info__bindgen_ty_1__bindgen_ty_3, domain) - 0usize];
    ["Offset of field: nak_shader_info__bindgen_ty_1__bindgen_ty_3::spacing"]
        [::std::mem::offset_of!(nak_shader_info__bindgen_ty_1__bindgen_ty_3, spacing) - 1usize];
    ["Offset of field: nak_shader_info__bindgen_ty_1__bindgen_ty_3::prims"]
        [::std::mem::offset_of!(nak_shader_info__bindgen_ty_1__bindgen_ty_3, prims) - 2usize];
    ["Offset of field: nak_shader_info__bindgen_ty_1__bindgen_ty_3::_pad"]
        [::std::mem::offset_of!(nak_shader_info__bindgen_ty_1__bindgen_ty_3, _pad) - 3usize];
};
impl Default for nak_shader_info__bindgen_ty_1__bindgen_ty_3 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nak_shader_info__bindgen_ty_1"]
        [::std::mem::size_of::<nak_shader_info__bindgen_ty_1>() - 12usize];
    ["Alignment of nak_shader_info__bindgen_ty_1"]
        [::std::mem::align_of::<nak_shader_info__bindgen_ty_1>() - 2usize];
    ["Offset of field: nak_shader_info__bindgen_ty_1::cs"]
        [::std::mem::offset_of!(nak_shader_info__bindgen_ty_1, cs) - 0usize];
    ["Offset of field: nak_shader_info__bindgen_ty_1::fs"]
        [::std::mem::offset_of!(nak_shader_info__bindgen_ty_1, fs) - 0usize];
    ["Offset of field: nak_shader_info__bindgen_ty_1::ts"]
        [::std::mem::offset_of!(nak_shader_info__bindgen_ty_1, ts) - 0usize];
    ["Offset of field: nak_shader_info__bindgen_ty_1::_pad"]
        [::std::mem::offset_of!(nak_shader_info__bindgen_ty_1, _pad) - 0usize];
};
impl Default for nak_shader_info__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nak_shader_info__bindgen_ty_2 {
    pub writes_layer: bool,
    pub writes_point_size: bool,
    pub writes_vprs_table_index: bool,
    pub clip_enable: u8,
    pub cull_enable: u8,
    pub _pad: [u8; 3usize],
    pub xfb: nak_xfb_info,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nak_shader_info__bindgen_ty_2"]
        [::std::mem::size_of::<nak_shader_info__bindgen_ty_2>() - 544usize];
    ["Alignment of nak_shader_info__bindgen_ty_2"]
        [::std::mem::align_of::<nak_shader_info__bindgen_ty_2>() - 4usize];
    ["Offset of field: nak_shader_info__bindgen_ty_2::writes_layer"]
        [::std::mem::offset_of!(nak_shader_info__bindgen_ty_2, writes_layer) - 0usize];
    ["Offset of field: nak_shader_info__bindgen_ty_2::writes_point_size"]
        [::std::mem::offset_of!(nak_shader_info__bindgen_ty_2, writes_point_size) - 1usize];
    ["Offset of field: nak_shader_info__bindgen_ty_2::writes_vprs_table_index"]
        [::std::mem::offset_of!(nak_shader_info__bindgen_ty_2, writes_vprs_table_index) - 2usize];
    ["Offset of field: nak_shader_info__bindgen_ty_2::clip_enable"]
        [::std::mem::offset_of!(nak_shader_info__bindgen_ty_2, clip_enable) - 3usize];
    ["Offset of field: nak_shader_info__bindgen_ty_2::cull_enable"]
        [::std::mem::offset_of!(nak_shader_info__bindgen_ty_2, cull_enable) - 4usize];
    ["Offset of field: nak_shader_info__bindgen_ty_2::_pad"]
        [::std::mem::offset_of!(nak_shader_info__bindgen_ty_2, _pad) - 5usize];
    ["Offset of field: nak_shader_info__bindgen_ty_2::xfb"]
        [::std::mem::offset_of!(nak_shader_info__bindgen_ty_2, xfb) - 8usize];
};
impl Default for nak_shader_info__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nak_shader_info"][::std::mem::size_of::<nak_shader_info>() - 728usize];
    ["Alignment of nak_shader_info"][::std::mem::align_of::<nak_shader_info>() - 4usize];
    ["Offset of field: nak_shader_info::stage"]
        [::std::mem::offset_of!(nak_shader_info, stage) - 0usize];
    ["Offset of field: nak_shader_info::sm"][::std::mem::offset_of!(nak_shader_info, sm) - 4usize];
    ["Offset of field: nak_shader_info::num_gprs"]
        [::std::mem::offset_of!(nak_shader_info, num_gprs) - 5usize];
    ["Offset of field: nak_shader_info::num_control_barriers"]
        [::std::mem::offset_of!(nak_shader_info, num_control_barriers) - 6usize];
    ["Offset of field: nak_shader_info::_pad0"]
        [::std::mem::offset_of!(nak_shader_info, _pad0) - 7usize];
    ["Offset of field: nak_shader_info::max_warps_per_sm"]
        [::std::mem::offset_of!(nak_shader_info, max_warps_per_sm) - 8usize];
    ["Offset of field: nak_shader_info::num_instrs"]
        [::std::mem::offset_of!(nak_shader_info, num_instrs) - 12usize];
    ["Offset of field: nak_shader_info::num_static_cycles"]
        [::std::mem::offset_of!(nak_shader_info, num_static_cycles) - 16usize];
    ["Offset of field: nak_shader_info::num_spills_to_mem"]
        [::std::mem::offset_of!(nak_shader_info, num_spills_to_mem) - 20usize];
    ["Offset of field: nak_shader_info::num_fills_from_mem"]
        [::std::mem::offset_of!(nak_shader_info, num_fills_from_mem) - 24usize];
    ["Offset of field: nak_shader_info::num_spills_to_reg"]
        [::std::mem::offset_of!(nak_shader_info, num_spills_to_reg) - 28usize];
    ["Offset of field: nak_shader_info::num_fills_from_reg"]
        [::std::mem::offset_of!(nak_shader_info, num_fills_from_reg) - 32usize];
    ["Offset of field: nak_shader_info::slm_size"]
        [::std::mem::offset_of!(nak_shader_info, slm_size) - 36usize];
    ["Offset of field: nak_shader_info::crs_size"]
        [::std::mem::offset_of!(nak_shader_info, crs_size) - 40usize];
    ["Offset of field: nak_shader_info::vtg"]
        [::std::mem::offset_of!(nak_shader_info, vtg) - 56usize];
    ["Offset of field: nak_shader_info::hdr"]
        [::std::mem::offset_of!(nak_shader_info, hdr) - 600usize];
};
impl Default for nak_shader_info {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
pub struct nak_shader_bin {
    pub info: nak_shader_info,
    pub code_size: u32,
    pub code: *const ::std::os::raw::c_void,
    pub asm_str: *const ::std::os::raw::c_char,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nak_shader_bin"][::std::mem::size_of::<nak_shader_bin>() - 740usize];
    ["Alignment of nak_shader_bin"][::std::mem::align_of::<nak_shader_bin>() - 4usize];
    ["Offset of field: nak_shader_bin::info"]
        [::std::mem::offset_of!(nak_shader_bin, info) - 0usize];
    ["Offset of field: nak_shader_bin::code_size"]
        [::std::mem::offset_of!(nak_shader_bin, code_size) - 728usize];
    ["Offset of field: nak_shader_bin::code"]
        [::std::mem::offset_of!(nak_shader_bin, code) - 732usize];
    ["Offset of field: nak_shader_bin::asm_str"]
        [::std::mem::offset_of!(nak_shader_bin, asm_str) - 736usize];
};
impl Default for nak_shader_bin {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nak_shader_bin_destroy(bin: *mut nak_shader_bin);
}
unsafe extern "C" {
    pub fn nak_compile_shader(
        nir: *mut nir_shader,
        dump_asm: bool,
        nak: *const nak_compiler,
        robust2_modes: nir_variable_mode,
        fs_key: *const nak_fs_key,
    ) -> *mut nak_shader_bin;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nak_qmd_cbuf {
    pub index: u32,
    pub size: u32,
    pub addr: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nak_qmd_cbuf"][::std::mem::size_of::<nak_qmd_cbuf>() - 16usize];
    ["Alignment of nak_qmd_cbuf"][::std::mem::align_of::<nak_qmd_cbuf>() - 4usize];
    ["Offset of field: nak_qmd_cbuf::index"][::std::mem::offset_of!(nak_qmd_cbuf, index) - 0usize];
    ["Offset of field: nak_qmd_cbuf::size"][::std::mem::offset_of!(nak_qmd_cbuf, size) - 4usize];
    ["Offset of field: nak_qmd_cbuf::addr"][::std::mem::offset_of!(nak_qmd_cbuf, addr) - 8usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nak_qmd_info {
    pub addr: u64,
    pub smem_size: u16,
    pub smem_max: u16,
    pub global_size: [u32; 3usize],
    pub num_cbufs: u32,
    pub cbufs: [nak_qmd_cbuf; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nak_qmd_info"][::std::mem::size_of::<nak_qmd_info>() - 156usize];
    ["Alignment of nak_qmd_info"][::std::mem::align_of::<nak_qmd_info>() - 4usize];
    ["Offset of field: nak_qmd_info::addr"][::std::mem::offset_of!(nak_qmd_info, addr) - 0usize];
    ["Offset of field: nak_qmd_info::smem_size"]
        [::std::mem::offset_of!(nak_qmd_info, smem_size) - 8usize];
    ["Offset of field: nak_qmd_info::smem_max"]
        [::std::mem::offset_of!(nak_qmd_info, smem_max) - 10usize];
    ["Offset of field: nak_qmd_info::global_size"]
        [::std::mem::offset_of!(nak_qmd_info, global_size) - 12usize];
    ["Offset of field: nak_qmd_info::num_cbufs"]
        [::std::mem::offset_of!(nak_qmd_info, num_cbufs) - 24usize];
    ["Offset of field: nak_qmd_info::cbufs"][::std::mem::offset_of!(nak_qmd_info, cbufs) - 28usize];
};
unsafe extern "C" {
    pub fn nak_qmd_size_B(dev: *const nv_device_info) -> u32;
}
unsafe extern "C" {
    pub fn nak_fill_qmd(
        dev: *const nv_device_info,
        info: *const nak_shader_info,
        qmd_info: *const nak_qmd_info,
        qmd_out: *mut ::std::os::raw::c_void,
        qmd_size: usize,
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nak_qmd_dispatch_size_layout {
    pub x_start: u16,
    pub x_end: u16,
    pub y_start: u16,
    pub y_end: u16,
    pub z_start: u16,
    pub z_end: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nak_qmd_dispatch_size_layout"]
        [::std::mem::size_of::<nak_qmd_dispatch_size_layout>() - 12usize];
    ["Alignment of nak_qmd_dispatch_size_layout"]
        [::std::mem::align_of::<nak_qmd_dispatch_size_layout>() - 2usize];
    ["Offset of field: nak_qmd_dispatch_size_layout::x_start"]
        [::std::mem::offset_of!(nak_qmd_dispatch_size_layout, x_start) - 0usize];
    ["Offset of field: nak_qmd_dispatch_size_layout::x_end"]
        [::std::mem::offset_of!(nak_qmd_dispatch_size_layout, x_end) - 2usize];
    ["Offset of field: nak_qmd_dispatch_size_layout::y_start"]
        [::std::mem::offset_of!(nak_qmd_dispatch_size_layout, y_start) - 4usize];
    ["Offset of field: nak_qmd_dispatch_size_layout::y_end"]
        [::std::mem::offset_of!(nak_qmd_dispatch_size_layout, y_end) - 6usize];
    ["Offset of field: nak_qmd_dispatch_size_layout::z_start"]
        [::std::mem::offset_of!(nak_qmd_dispatch_size_layout, z_start) - 8usize];
    ["Offset of field: nak_qmd_dispatch_size_layout::z_end"]
        [::std::mem::offset_of!(nak_qmd_dispatch_size_layout, z_end) - 10usize];
};
unsafe extern "C" {
    pub fn nak_get_qmd_dispatch_size_layout(
        dev: *const nv_device_info,
    ) -> nak_qmd_dispatch_size_layout;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nak_qmd_cbuf_desc_layout {
    pub addr_shift: u16,
    pub addr_lo_start: u16,
    pub addr_lo_end: u16,
    pub addr_hi_start: u16,
    pub addr_hi_end: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nak_qmd_cbuf_desc_layout"]
        [::std::mem::size_of::<nak_qmd_cbuf_desc_layout>() - 10usize];
    ["Alignment of nak_qmd_cbuf_desc_layout"]
        [::std::mem::align_of::<nak_qmd_cbuf_desc_layout>() - 2usize];
    ["Offset of field: nak_qmd_cbuf_desc_layout::addr_shift"]
        [::std::mem::offset_of!(nak_qmd_cbuf_desc_layout, addr_shift) - 0usize];
    ["Offset of field: nak_qmd_cbuf_desc_layout::addr_lo_start"]
        [::std::mem::offset_of!(nak_qmd_cbuf_desc_layout, addr_lo_start) - 2usize];
    ["Offset of field: nak_qmd_cbuf_desc_layout::addr_lo_end"]
        [::std::mem::offset_of!(nak_qmd_cbuf_desc_layout, addr_lo_end) - 4usize];
    ["Offset of field: nak_qmd_cbuf_desc_layout::addr_hi_start"]
        [::std::mem::offset_of!(nak_qmd_cbuf_desc_layout, addr_hi_start) - 6usize];
    ["Offset of field: nak_qmd_cbuf_desc_layout::addr_hi_end"]
        [::std::mem::offset_of!(nak_qmd_cbuf_desc_layout, addr_hi_end) - 8usize];
};
unsafe extern "C" {
    pub fn nak_get_qmd_cbuf_desc_layout(
        dev: *const nv_device_info,
        idx: u8,
    ) -> nak_qmd_cbuf_desc_layout;
}
pub type __u16 = ::std::os::raw::c_ushort;
pub type __s32 = ::std::os::raw::c_int;
pub type __u32 = ::std::os::raw::c_uint;
pub type __s64 = ::std::os::raw::c_longlong;
pub type __u64 = ::std::os::raw::c_ulonglong;
pub type __kernel_size_t = ::std::os::raw::c_uint;
pub type blake3_hash = [u8; 32usize];
#[repr(C)]
pub struct shader_info__bindgen_ty_1 {
    pub vs: __BindgenUnionField<shader_info__bindgen_ty_1__bindgen_ty_1>,
    pub gs: __BindgenUnionField<shader_info__bindgen_ty_1__bindgen_ty_2>,
    pub fs: __BindgenUnionField<shader_info__bindgen_ty_1__bindgen_ty_3>,
    pub cs: __BindgenUnionField<shader_info__bindgen_ty_1__bindgen_ty_4>,
    pub tess: __BindgenUnionField<shader_info__bindgen_ty_1__bindgen_ty_5>,
    pub mesh: __BindgenUnionField<shader_info__bindgen_ty_1__bindgen_ty_6>,
    pub bindgen_union_field: [u32; 14usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct shader_info__bindgen_ty_1__bindgen_ty_1 {
    pub double_inputs: u64,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of shader_info__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::size_of::<shader_info__bindgen_ty_1__bindgen_ty_1>() - 12usize];
    ["Alignment of shader_info__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::align_of::<shader_info__bindgen_ty_1__bindgen_ty_1>() - 4usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_1::double_inputs"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1__bindgen_ty_1, double_inputs) - 0usize];
};
impl shader_info__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn blit_sgprs_amd(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_blit_sgprs_amd(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn blit_sgprs_amd_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                4u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_blit_sgprs_amd_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                4u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn tes_agx(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_tes_agx(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn tes_agx_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                4usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_tes_agx_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                4usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn window_space_position(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_window_space_position(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn window_space_position_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                5usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_window_space_position_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                5usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn needs_edge_flag(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_needs_edge_flag(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn needs_edge_flag_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                6usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_needs_edge_flag_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                6usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        blit_sgprs_amd: u8,
        tes_agx: bool,
        window_space_position: bool,
        needs_edge_flag: bool,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 4u8, {
            let blit_sgprs_amd: u8 = unsafe { ::std::mem::transmute(blit_sgprs_amd) };
            blit_sgprs_amd as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let tes_agx: u8 = unsafe { ::std::mem::transmute(tes_agx) };
            tes_agx as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let window_space_position: u8 = unsafe { ::std::mem::transmute(window_space_position) };
            window_space_position as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let needs_edge_flag: u8 = unsafe { ::std::mem::transmute(needs_edge_flag) };
            needs_edge_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
pub struct shader_info__bindgen_ty_1__bindgen_ty_2 {
    #[doc = " The output primitive type"]
    pub output_primitive: mesa_prim,
    #[doc = " The input primitive type"]
    pub input_primitive: mesa_prim,
    #[doc = " The maximum number of vertices the geometry shader might write."]
    pub vertices_out: u16,
    #[doc = " 1 .. MAX_GEOMETRY_SHADER_INVOCATIONS"]
    pub invocations: u8,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of shader_info__bindgen_ty_1__bindgen_ty_2"]
        [::std::mem::size_of::<shader_info__bindgen_ty_1__bindgen_ty_2>() - 6usize];
    ["Alignment of shader_info__bindgen_ty_1__bindgen_ty_2"]
        [::std::mem::align_of::<shader_info__bindgen_ty_1__bindgen_ty_2>() - 2usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_2::output_primitive"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_2,
        output_primitive
    ) - 0usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_2::input_primitive"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1__bindgen_ty_2, input_primitive) - 1usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_2::vertices_out"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1__bindgen_ty_2, vertices_out) - 2usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_2::invocations"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1__bindgen_ty_2, invocations) - 4usize];
};
impl Default for shader_info__bindgen_ty_1__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl shader_info__bindgen_ty_1__bindgen_ty_2 {
    #[inline]
    pub fn vertices_in(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 3u8) as u8) }
    }
    #[inline]
    pub fn set_vertices_in(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn vertices_in_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                3u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_vertices_in_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn uses_end_primitive(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_end_primitive(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn uses_end_primitive_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_uses_end_primitive_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn active_stream_mask(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_active_stream_mask(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn active_stream_mask_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                4usize,
                4u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_active_stream_mask_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                4usize,
                4u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        vertices_in: u8,
        uses_end_primitive: bool,
        active_stream_mask: u8,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 3u8, {
            let vertices_in: u8 = unsafe { ::std::mem::transmute(vertices_in) };
            vertices_in as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let uses_end_primitive: u8 = unsafe { ::std::mem::transmute(uses_end_primitive) };
            uses_end_primitive as u64
        });
        __bindgen_bitfield_unit.set(4usize, 4u8, {
            let active_stream_mask: u8 = unsafe { ::std::mem::transmute(active_stream_mask) };
            active_stream_mask as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct shader_info__bindgen_ty_1__bindgen_ty_3 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 5usize]>,
    pub advanced_blend_modes: ::std::os::raw::c_uint,
    pub _bitfield_align_2: [u8; 0],
    pub _bitfield_2: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of shader_info__bindgen_ty_1__bindgen_ty_3"]
        [::std::mem::size_of::<shader_info__bindgen_ty_1__bindgen_ty_3>() - 16usize];
    ["Alignment of shader_info__bindgen_ty_1__bindgen_ty_3"]
        [::std::mem::align_of::<shader_info__bindgen_ty_1__bindgen_ty_3>() - 4usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_3::advanced_blend_modes"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_3,
        advanced_blend_modes
    ) - 8usize];
};
impl Default for shader_info__bindgen_ty_1__bindgen_ty_3 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl shader_info__bindgen_ty_1__bindgen_ty_3 {
    #[inline]
    pub fn uses_discard(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_discard(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn uses_discard_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_uses_discard_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn uses_fbfetch_output(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_fbfetch_output(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn uses_fbfetch_output_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                1usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_uses_fbfetch_output_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn fbfetch_coherent(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_fbfetch_coherent(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn fbfetch_coherent_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                2usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_fbfetch_coherent_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                2usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn color_is_dual_source(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_color_is_dual_source(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn color_is_dual_source_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_color_is_dual_source_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn require_full_quads(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_require_full_quads(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn require_full_quads_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                4usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_require_full_quads_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                4usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn quad_derivatives(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_quad_derivatives(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn quad_derivatives_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                5usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_quad_derivatives_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                5usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn needs_coarse_quad_helper_invocations(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_needs_coarse_quad_helper_invocations(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn needs_coarse_quad_helper_invocations_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                6usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_needs_coarse_quad_helper_invocations_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                6usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn needs_full_quad_helper_invocations(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_needs_full_quad_helper_invocations(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn needs_full_quad_helper_invocations_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                7usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_needs_full_quad_helper_invocations_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                7usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn uses_sample_qualifier(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_sample_qualifier(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn uses_sample_qualifier_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                8usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_uses_sample_qualifier_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                8usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn uses_sample_shading(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_sample_shading(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn uses_sample_shading_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                9usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_uses_sample_shading_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                9usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn early_fragment_tests(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_early_fragment_tests(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn early_fragment_tests_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                10usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_early_fragment_tests_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                10usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn inner_coverage(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_inner_coverage(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn inner_coverage_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                11usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_inner_coverage_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                11usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn post_depth_coverage(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_post_depth_coverage(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn post_depth_coverage_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                12usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_post_depth_coverage_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                12usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn pixel_center_integer(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_pixel_center_integer(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn pixel_center_integer_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                13usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_pixel_center_integer_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                13usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn origin_upper_left(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_origin_upper_left(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn origin_upper_left_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                14usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_origin_upper_left_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                14usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn pixel_interlock_ordered(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_pixel_interlock_ordered(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn pixel_interlock_ordered_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                15usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_pixel_interlock_ordered_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                15usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn pixel_interlock_unordered(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_pixel_interlock_unordered(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn pixel_interlock_unordered_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                16usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_pixel_interlock_unordered_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                16usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn sample_interlock_ordered(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_sample_interlock_ordered(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn sample_interlock_ordered_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                17usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_sample_interlock_ordered_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                17usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn sample_interlock_unordered(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(18usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_sample_interlock_unordered(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(18usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn sample_interlock_unordered_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                18usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_sample_interlock_unordered_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                18usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn untyped_color_outputs(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(19usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_untyped_color_outputs(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(19usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn untyped_color_outputs_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                19usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_untyped_color_outputs_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                19usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn depth_layout(&self) -> gl_frag_depth_layout {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(20usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_depth_layout(&mut self, val: gl_frag_depth_layout) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(20usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn depth_layout_raw(this: *const Self) -> gl_frag_depth_layout {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                20usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_depth_layout_raw(this: *mut Self, val: gl_frag_depth_layout) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                20usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn color0_interp(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(23usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_color0_interp(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(23usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn color0_interp_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                23usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_color0_interp_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                23usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn color0_sample(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(26usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_color0_sample(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(26usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn color0_sample_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                26usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_color0_sample_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                26usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn color0_centroid(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(27usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_color0_centroid(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(27usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn color0_centroid_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                27usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_color0_centroid_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                27usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn color1_interp(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(28usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_color1_interp(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(28usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn color1_interp_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                28usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_color1_interp_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                28usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn color1_sample(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(31usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_color1_sample(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(31usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn color1_sample_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                31usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_color1_sample_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                31usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn color1_centroid(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(32usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_color1_centroid(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(32usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn color1_centroid_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                32usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_color1_centroid_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                32usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        uses_discard: bool,
        uses_fbfetch_output: bool,
        fbfetch_coherent: bool,
        color_is_dual_source: bool,
        require_full_quads: bool,
        quad_derivatives: bool,
        needs_coarse_quad_helper_invocations: bool,
        needs_full_quad_helper_invocations: bool,
        uses_sample_qualifier: bool,
        uses_sample_shading: bool,
        early_fragment_tests: bool,
        inner_coverage: bool,
        post_depth_coverage: bool,
        pixel_center_integer: bool,
        origin_upper_left: bool,
        pixel_interlock_ordered: bool,
        pixel_interlock_unordered: bool,
        sample_interlock_ordered: bool,
        sample_interlock_unordered: bool,
        untyped_color_outputs: bool,
        depth_layout: gl_frag_depth_layout,
        color0_interp: ::std::os::raw::c_uint,
        color0_sample: bool,
        color0_centroid: bool,
        color1_interp: ::std::os::raw::c_uint,
        color1_sample: bool,
        color1_centroid: bool,
    ) -> __BindgenBitfieldUnit<[u8; 5usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 5usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let uses_discard: u8 = unsafe { ::std::mem::transmute(uses_discard) };
            uses_discard as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let uses_fbfetch_output: u8 = unsafe { ::std::mem::transmute(uses_fbfetch_output) };
            uses_fbfetch_output as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let fbfetch_coherent: u8 = unsafe { ::std::mem::transmute(fbfetch_coherent) };
            fbfetch_coherent as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let color_is_dual_source: u8 = unsafe { ::std::mem::transmute(color_is_dual_source) };
            color_is_dual_source as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let require_full_quads: u8 = unsafe { ::std::mem::transmute(require_full_quads) };
            require_full_quads as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let quad_derivatives: u8 = unsafe { ::std::mem::transmute(quad_derivatives) };
            quad_derivatives as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let needs_coarse_quad_helper_invocations: u8 =
                unsafe { ::std::mem::transmute(needs_coarse_quad_helper_invocations) };
            needs_coarse_quad_helper_invocations as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let needs_full_quad_helper_invocations: u8 =
                unsafe { ::std::mem::transmute(needs_full_quad_helper_invocations) };
            needs_full_quad_helper_invocations as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let uses_sample_qualifier: u8 = unsafe { ::std::mem::transmute(uses_sample_qualifier) };
            uses_sample_qualifier as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let uses_sample_shading: u8 = unsafe { ::std::mem::transmute(uses_sample_shading) };
            uses_sample_shading as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let early_fragment_tests: u8 = unsafe { ::std::mem::transmute(early_fragment_tests) };
            early_fragment_tests as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let inner_coverage: u8 = unsafe { ::std::mem::transmute(inner_coverage) };
            inner_coverage as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let post_depth_coverage: u8 = unsafe { ::std::mem::transmute(post_depth_coverage) };
            post_depth_coverage as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let pixel_center_integer: u8 = unsafe { ::std::mem::transmute(pixel_center_integer) };
            pixel_center_integer as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let origin_upper_left: u8 = unsafe { ::std::mem::transmute(origin_upper_left) };
            origin_upper_left as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let pixel_interlock_ordered: u8 =
                unsafe { ::std::mem::transmute(pixel_interlock_ordered) };
            pixel_interlock_ordered as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let pixel_interlock_unordered: u8 =
                unsafe { ::std::mem::transmute(pixel_interlock_unordered) };
            pixel_interlock_unordered as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let sample_interlock_ordered: u8 =
                unsafe { ::std::mem::transmute(sample_interlock_ordered) };
            sample_interlock_ordered as u64
        });
        __bindgen_bitfield_unit.set(18usize, 1u8, {
            let sample_interlock_unordered: u8 =
                unsafe { ::std::mem::transmute(sample_interlock_unordered) };
            sample_interlock_unordered as u64
        });
        __bindgen_bitfield_unit.set(19usize, 1u8, {
            let untyped_color_outputs: u8 = unsafe { ::std::mem::transmute(untyped_color_outputs) };
            untyped_color_outputs as u64
        });
        __bindgen_bitfield_unit.set(20usize, 3u8, {
            let depth_layout: u32 = unsafe { ::std::mem::transmute(depth_layout) };
            depth_layout as u64
        });
        __bindgen_bitfield_unit.set(23usize, 3u8, {
            let color0_interp: u32 = unsafe { ::std::mem::transmute(color0_interp) };
            color0_interp as u64
        });
        __bindgen_bitfield_unit.set(26usize, 1u8, {
            let color0_sample: u8 = unsafe { ::std::mem::transmute(color0_sample) };
            color0_sample as u64
        });
        __bindgen_bitfield_unit.set(27usize, 1u8, {
            let color0_centroid: u8 = unsafe { ::std::mem::transmute(color0_centroid) };
            color0_centroid as u64
        });
        __bindgen_bitfield_unit.set(28usize, 3u8, {
            let color1_interp: u32 = unsafe { ::std::mem::transmute(color1_interp) };
            color1_interp as u64
        });
        __bindgen_bitfield_unit.set(31usize, 1u8, {
            let color1_sample: u8 = unsafe { ::std::mem::transmute(color1_sample) };
            color1_sample as u64
        });
        __bindgen_bitfield_unit.set(32usize, 1u8, {
            let color1_centroid: u8 = unsafe { ::std::mem::transmute(color1_centroid) };
            color1_centroid as u64
        });
        __bindgen_bitfield_unit
    }
    #[inline]
    pub fn early_and_late_fragment_tests(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_early_and_late_fragment_tests(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_2.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn early_and_late_fragment_tests_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                0usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_early_and_late_fragment_tests_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn stencil_front_layout(&self) -> gl_frag_stencil_layout {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(1usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_stencil_front_layout(&mut self, val: gl_frag_stencil_layout) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(1usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn stencil_front_layout_raw(this: *const Self) -> gl_frag_stencil_layout {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                1usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_stencil_front_layout_raw(this: *mut Self, val: gl_frag_stencil_layout) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                1usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn stencil_back_layout(&self) -> gl_frag_stencil_layout {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(4usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_stencil_back_layout(&mut self, val: gl_frag_stencil_layout) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(4usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn stencil_back_layout_raw(this: *const Self) -> gl_frag_stencil_layout {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                4usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_stencil_back_layout_raw(this: *mut Self, val: gl_frag_stencil_layout) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                4usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_2(
        early_and_late_fragment_tests: bool,
        stencil_front_layout: gl_frag_stencil_layout,
        stencil_back_layout: gl_frag_stencil_layout,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let early_and_late_fragment_tests: u8 =
                unsafe { ::std::mem::transmute(early_and_late_fragment_tests) };
            early_and_late_fragment_tests as u64
        });
        __bindgen_bitfield_unit.set(1usize, 3u8, {
            let stencil_front_layout: u32 = unsafe { ::std::mem::transmute(stencil_front_layout) };
            stencil_front_layout as u64
        });
        __bindgen_bitfield_unit.set(4usize, 3u8, {
            let stencil_back_layout: u32 = unsafe { ::std::mem::transmute(stencil_back_layout) };
            stencil_back_layout as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct shader_info__bindgen_ty_1__bindgen_ty_4 {
    pub workgroup_size_hint: [u16; 3usize],
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    #[doc = " Number of bytes of shared imageblock memory per thread. Currently,\n this requires that the workgroup size is 32x32x1 and that\n shared_size = 0. These requirements could be lifted in the future.\n However, there is no current OpenGL/Vulkan API support for\n imageblocks. This is only used internally to accelerate blit/copy."]
    pub image_block_size_per_thread_agx: u8,
    #[doc = " pointer size is:\n   AddressingModelLogical:    0    (default)\n   AddressingModelPhysical32: 32\n   AddressingModelPhysical64: 64"]
    pub ptr_size: ::std::os::raw::c_uint,
    #[doc = " Index provided by VkPipelineShaderStageNodeCreateInfoAMDX or ShaderIndexAMDX"]
    pub shader_index: u32,
    #[doc = " Maximum size required by any output node payload array"]
    pub node_payloads_size: u32,
    #[doc = " Static workgroup count for overwriting the enqueued workgroup count. (0 if dynamic)"]
    pub workgroup_count: [u32; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of shader_info__bindgen_ty_1__bindgen_ty_4"]
        [::std::mem::size_of::<shader_info__bindgen_ty_1__bindgen_ty_4>() - 32usize];
    ["Alignment of shader_info__bindgen_ty_1__bindgen_ty_4"]
        [::std::mem::align_of::<shader_info__bindgen_ty_1__bindgen_ty_4>() - 4usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_4::workgroup_size_hint"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_4,
        workgroup_size_hint
    ) - 0usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_4::image_block_size_per_thread_agx"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_4,
        image_block_size_per_thread_agx
    )
        - 7usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_4::ptr_size"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1__bindgen_ty_4, ptr_size) - 8usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_4::shader_index"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1__bindgen_ty_4, shader_index) - 12usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_4::node_payloads_size"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_4,
        node_payloads_size
    ) - 16usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_4::workgroup_count"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_4,
        workgroup_count
    ) - 20usize];
};
impl shader_info__bindgen_ty_1__bindgen_ty_4 {
    #[inline]
    pub fn user_data_components_amd(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_user_data_components_amd(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn user_data_components_amd_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                4u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_user_data_components_amd_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                4u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn has_variable_shared_mem(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_has_variable_shared_mem(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn has_variable_shared_mem_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                4usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_has_variable_shared_mem_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                4usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn has_cooperative_matrix(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_has_cooperative_matrix(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn has_cooperative_matrix_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                5usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_has_cooperative_matrix_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                5usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        user_data_components_amd: u8,
        has_variable_shared_mem: bool,
        has_cooperative_matrix: bool,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 4u8, {
            let user_data_components_amd: u8 =
                unsafe { ::std::mem::transmute(user_data_components_amd) };
            user_data_components_amd as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let has_variable_shared_mem: u8 =
                unsafe { ::std::mem::transmute(has_variable_shared_mem) };
            has_variable_shared_mem as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let has_cooperative_matrix: u8 =
                unsafe { ::std::mem::transmute(has_cooperative_matrix) };
            has_cooperative_matrix as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
pub struct shader_info__bindgen_ty_1__bindgen_ty_5 {
    pub _primitive_mode: tess_primitive_mode,
    #[doc = " The number of vertices in the TCS output patch."]
    pub tcs_vertices_out: u8,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub tcs_same_invocation_inputs_read: u64,
    pub tcs_cross_invocation_inputs_read: u64,
    pub tcs_cross_invocation_outputs_read: u64,
    pub tcs_cross_invocation_outputs_written: u64,
    pub tcs_outputs_read_by_tes: u64,
    pub tcs_patch_outputs_read_by_tes: u32,
    pub tcs_outputs_read_by_tes_16bit: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of shader_info__bindgen_ty_1__bindgen_ty_5"]
        [::std::mem::size_of::<shader_info__bindgen_ty_1__bindgen_ty_5>() - 56usize];
    ["Alignment of shader_info__bindgen_ty_1__bindgen_ty_5"]
        [::std::mem::align_of::<shader_info__bindgen_ty_1__bindgen_ty_5>() - 4usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_5::_primitive_mode"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1__bindgen_ty_5, _primitive_mode) - 0usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_5::tcs_vertices_out"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_5,
        tcs_vertices_out
    ) - 4usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_5::tcs_same_invocation_inputs_read"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_5,
        tcs_same_invocation_inputs_read
    )
        - 8usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_5::tcs_cross_invocation_inputs_read"] [:: std :: mem :: offset_of ! (shader_info__bindgen_ty_1__bindgen_ty_5 , tcs_cross_invocation_inputs_read) - 16usize] ;
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_5::tcs_cross_invocation_outputs_read"] [:: std :: mem :: offset_of ! (shader_info__bindgen_ty_1__bindgen_ty_5 , tcs_cross_invocation_outputs_read) - 24usize] ;
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_5::tcs_cross_invocation_outputs_written"] [:: std :: mem :: offset_of ! (shader_info__bindgen_ty_1__bindgen_ty_5 , tcs_cross_invocation_outputs_written) - 32usize] ;
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_5::tcs_outputs_read_by_tes"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_5,
        tcs_outputs_read_by_tes
    )
        - 40usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_5::tcs_patch_outputs_read_by_tes"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_5,
        tcs_patch_outputs_read_by_tes
    )
        - 48usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_5::tcs_outputs_read_by_tes_16bit"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_5,
        tcs_outputs_read_by_tes_16bit
    )
        - 52usize];
};
impl Default for shader_info__bindgen_ty_1__bindgen_ty_5 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl shader_info__bindgen_ty_1__bindgen_ty_5 {
    #[inline]
    pub fn spacing(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_spacing(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn spacing_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                2u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_spacing_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn ccw(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_ccw(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn ccw_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                2usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_ccw_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                2usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn point_mode(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_point_mode(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn point_mode_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_point_mode_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        spacing: ::std::os::raw::c_uint,
        ccw: bool,
        point_mode: bool,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let spacing: u32 = unsafe { ::std::mem::transmute(spacing) };
            spacing as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let ccw: u8 = unsafe { ::std::mem::transmute(ccw) };
            ccw as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let point_mode: u8 = unsafe { ::std::mem::transmute(point_mode) };
            point_mode as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
pub struct shader_info__bindgen_ty_1__bindgen_ty_6 {
    pub ms_cross_invocation_output_access: u64,
    pub ts_mesh_dispatch_dimensions: [u32; 3usize],
    pub max_vertices_out: u16,
    pub max_primitives_out: u16,
    pub primitive_type: mesa_prim,
    pub nv: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of shader_info__bindgen_ty_1__bindgen_ty_6"]
        [::std::mem::size_of::<shader_info__bindgen_ty_1__bindgen_ty_6>() - 28usize];
    ["Alignment of shader_info__bindgen_ty_1__bindgen_ty_6"]
        [::std::mem::align_of::<shader_info__bindgen_ty_1__bindgen_ty_6>() - 4usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_6::ms_cross_invocation_output_access"] [:: std :: mem :: offset_of ! (shader_info__bindgen_ty_1__bindgen_ty_6 , ms_cross_invocation_output_access) - 0usize] ;
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_6::ts_mesh_dispatch_dimensions"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_6,
        ts_mesh_dispatch_dimensions
    )
        - 8usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_6::max_vertices_out"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_6,
        max_vertices_out
    ) - 20usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_6::max_primitives_out"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_6,
        max_primitives_out
    ) - 22usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_6::primitive_type"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1__bindgen_ty_6, primitive_type) - 24usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_6::nv"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1__bindgen_ty_6, nv) - 25usize];
};
impl Default for shader_info__bindgen_ty_1__bindgen_ty_6 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of shader_info__bindgen_ty_1"]
        [::std::mem::size_of::<shader_info__bindgen_ty_1>() - 56usize];
    ["Alignment of shader_info__bindgen_ty_1"]
        [::std::mem::align_of::<shader_info__bindgen_ty_1>() - 4usize];
    ["Offset of field: shader_info__bindgen_ty_1::vs"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1, vs) - 0usize];
    ["Offset of field: shader_info__bindgen_ty_1::gs"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1, gs) - 0usize];
    ["Offset of field: shader_info__bindgen_ty_1::fs"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1, fs) - 0usize];
    ["Offset of field: shader_info__bindgen_ty_1::cs"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1, cs) - 0usize];
    ["Offset of field: shader_info__bindgen_ty_1::tess"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1, tess) - 0usize];
    ["Offset of field: shader_info__bindgen_ty_1::mesh"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1, mesh) - 0usize];
};
impl Default for shader_info__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hash_entry {
    pub hash: u32,
    pub key: *const ::std::os::raw::c_void,
    pub data: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of hash_entry"][::std::mem::size_of::<hash_entry>() - 12usize];
    ["Alignment of hash_entry"][::std::mem::align_of::<hash_entry>() - 4usize];
    ["Offset of field: hash_entry::hash"][::std::mem::offset_of!(hash_entry, hash) - 0usize];
    ["Offset of field: hash_entry::key"][::std::mem::offset_of!(hash_entry, key) - 4usize];
    ["Offset of field: hash_entry::data"][::std::mem::offset_of!(hash_entry, data) - 8usize];
};
impl Default for hash_entry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hash_table {
    pub table: *mut hash_entry,
    pub key_hash_function:
        ::std::option::Option<unsafe extern "C" fn(key: *const ::std::os::raw::c_void) -> u32>,
    pub key_equals_function: ::std::option::Option<
        unsafe extern "C" fn(
            a: *const ::std::os::raw::c_void,
            b: *const ::std::os::raw::c_void,
        ) -> bool,
    >,
    pub deleted_key: *const ::std::os::raw::c_void,
    pub size: u32,
    pub rehash: u32,
    pub size_magic: u64,
    pub rehash_magic: u64,
    pub max_entries: u32,
    pub size_index: u32,
    pub entries: u32,
    pub deleted_entries: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of hash_table"][::std::mem::size_of::<hash_table>() - 56usize];
    ["Alignment of hash_table"][::std::mem::align_of::<hash_table>() - 4usize];
    ["Offset of field: hash_table::table"][::std::mem::offset_of!(hash_table, table) - 0usize];
    ["Offset of field: hash_table::key_hash_function"]
        [::std::mem::offset_of!(hash_table, key_hash_function) - 4usize];
    ["Offset of field: hash_table::key_equals_function"]
        [::std::mem::offset_of!(hash_table, key_equals_function) - 8usize];
    ["Offset of field: hash_table::deleted_key"]
        [::std::mem::offset_of!(hash_table, deleted_key) - 12usize];
    ["Offset of field: hash_table::size"][::std::mem::offset_of!(hash_table, size) - 16usize];
    ["Offset of field: hash_table::rehash"][::std::mem::offset_of!(hash_table, rehash) - 20usize];
    ["Offset of field: hash_table::size_magic"]
        [::std::mem::offset_of!(hash_table, size_magic) - 24usize];
    ["Offset of field: hash_table::rehash_magic"]
        [::std::mem::offset_of!(hash_table, rehash_magic) - 32usize];
    ["Offset of field: hash_table::max_entries"]
        [::std::mem::offset_of!(hash_table, max_entries) - 40usize];
    ["Offset of field: hash_table::size_index"]
        [::std::mem::offset_of!(hash_table, size_index) - 44usize];
    ["Offset of field: hash_table::entries"][::std::mem::offset_of!(hash_table, entries) - 48usize];
    ["Offset of field: hash_table::deleted_entries"]
        [::std::mem::offset_of!(hash_table, deleted_entries) - 52usize];
};
impl Default for hash_table {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct list_head {
    pub prev: *mut list_head,
    pub next: *mut list_head,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of list_head"][::std::mem::size_of::<list_head>() - 8usize];
    ["Alignment of list_head"][::std::mem::align_of::<list_head>() - 4usize];
    ["Offset of field: list_head::prev"][::std::mem::offset_of!(list_head, prev) - 0usize];
    ["Offset of field: list_head::next"][::std::mem::offset_of!(list_head, next) - 4usize];
};
impl Default for list_head {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct set_entry {
    pub hash: u32,
    pub key: *const ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set_entry"][::std::mem::size_of::<set_entry>() - 8usize];
    ["Alignment of set_entry"][::std::mem::align_of::<set_entry>() - 4usize];
    ["Offset of field: set_entry::hash"][::std::mem::offset_of!(set_entry, hash) - 0usize];
    ["Offset of field: set_entry::key"][::std::mem::offset_of!(set_entry, key) - 4usize];
};
impl Default for set_entry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct set {
    pub mem_ctx: *mut ::std::os::raw::c_void,
    pub table: *mut set_entry,
    pub key_hash_function:
        ::std::option::Option<unsafe extern "C" fn(key: *const ::std::os::raw::c_void) -> u32>,
    pub key_equals_function: ::std::option::Option<
        unsafe extern "C" fn(
            a: *const ::std::os::raw::c_void,
            b: *const ::std::os::raw::c_void,
        ) -> bool,
    >,
    pub size: u32,
    pub rehash: u32,
    pub size_magic: u64,
    pub rehash_magic: u64,
    pub max_entries: u32,
    pub size_index: u32,
    pub entries: u32,
    pub deleted_entries: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set"][::std::mem::size_of::<set>() - 56usize];
    ["Alignment of set"][::std::mem::align_of::<set>() - 4usize];
    ["Offset of field: set::mem_ctx"][::std::mem::offset_of!(set, mem_ctx) - 0usize];
    ["Offset of field: set::table"][::std::mem::offset_of!(set, table) - 4usize];
    ["Offset of field: set::key_hash_function"]
        [::std::mem::offset_of!(set, key_hash_function) - 8usize];
    ["Offset of field: set::key_equals_function"]
        [::std::mem::offset_of!(set, key_equals_function) - 12usize];
    ["Offset of field: set::size"][::std::mem::offset_of!(set, size) - 16usize];
    ["Offset of field: set::rehash"][::std::mem::offset_of!(set, rehash) - 20usize];
    ["Offset of field: set::size_magic"][::std::mem::offset_of!(set, size_magic) - 24usize];
    ["Offset of field: set::rehash_magic"][::std::mem::offset_of!(set, rehash_magic) - 32usize];
    ["Offset of field: set::max_entries"][::std::mem::offset_of!(set, max_entries) - 40usize];
    ["Offset of field: set::size_index"][::std::mem::offset_of!(set, size_index) - 44usize];
    ["Offset of field: set::entries"][::std::mem::offset_of!(set, entries) - 48usize];
    ["Offset of field: set::deleted_entries"]
        [::std::mem::offset_of!(set, deleted_entries) - 52usize];
};
impl Default for set {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const NV_DEVICE_TYPE_IGP: nv_device_type = 0;
pub const NV_DEVICE_TYPE_DIS: nv_device_type = 1;
pub const NV_DEVICE_TYPE_SOC: nv_device_type = 2;
pub type nv_device_type = ::std::os::raw::c_uchar;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nv_device_info {
    pub type_: nv_device_type,
    pub device_id: u16,
    pub chipset: u16,
    pub device_name: [::std::os::raw::c_char; 64usize],
    pub chipset_name: [::std::os::raw::c_char; 16usize],
    pub pci: nv_device_info__bindgen_ty_1,
    #[doc = "< Shader model"]
    pub sm: u8,
    pub gpc_count: u8,
    pub tpc_count: u16,
    pub mp_per_tpc: u8,
    pub max_warps_per_mp: u8,
    pub cls_copy: u16,
    pub cls_eng2d: u16,
    pub cls_eng3d: u16,
    pub cls_m2mf: u16,
    pub cls_compute: u16,
    pub vram_size_B: u64,
    pub bar_size_B: u64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nv_device_info__bindgen_ty_1 {
    pub domain: u16,
    pub bus: u8,
    pub dev: u8,
    pub func: u8,
    pub revision_id: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nv_device_info__bindgen_ty_1"]
        [::std::mem::size_of::<nv_device_info__bindgen_ty_1>() - 6usize];
    ["Alignment of nv_device_info__bindgen_ty_1"]
        [::std::mem::align_of::<nv_device_info__bindgen_ty_1>() - 2usize];
    ["Offset of field: nv_device_info__bindgen_ty_1::domain"]
        [::std::mem::offset_of!(nv_device_info__bindgen_ty_1, domain) - 0usize];
    ["Offset of field: nv_device_info__bindgen_ty_1::bus"]
        [::std::mem::offset_of!(nv_device_info__bindgen_ty_1, bus) - 2usize];
    ["Offset of field: nv_device_info__bindgen_ty_1::dev"]
        [::std::mem::offset_of!(nv_device_info__bindgen_ty_1, dev) - 3usize];
    ["Offset of field: nv_device_info__bindgen_ty_1::func"]
        [::std::mem::offset_of!(nv_device_info__bindgen_ty_1, func) - 4usize];
    ["Offset of field: nv_device_info__bindgen_ty_1::revision_id"]
        [::std::mem::offset_of!(nv_device_info__bindgen_ty_1, revision_id) - 5usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nv_device_info"][::std::mem::size_of::<nv_device_info>() - 124usize];
    ["Alignment of nv_device_info"][::std::mem::align_of::<nv_device_info>() - 4usize];
    ["Offset of field: nv_device_info::type_"]
        [::std::mem::offset_of!(nv_device_info, type_) - 0usize];
    ["Offset of field: nv_device_info::device_id"]
        [::std::mem::offset_of!(nv_device_info, device_id) - 2usize];
    ["Offset of field: nv_device_info::chipset"]
        [::std::mem::offset_of!(nv_device_info, chipset) - 4usize];
    ["Offset of field: nv_device_info::device_name"]
        [::std::mem::offset_of!(nv_device_info, device_name) - 6usize];
    ["Offset of field: nv_device_info::chipset_name"]
        [::std::mem::offset_of!(nv_device_info, chipset_name) - 70usize];
    ["Offset of field: nv_device_info::pci"][::std::mem::offset_of!(nv_device_info, pci) - 86usize];
    ["Offset of field: nv_device_info::sm"][::std::mem::offset_of!(nv_device_info, sm) - 92usize];
    ["Offset of field: nv_device_info::gpc_count"]
        [::std::mem::offset_of!(nv_device_info, gpc_count) - 93usize];
    ["Offset of field: nv_device_info::tpc_count"]
        [::std::mem::offset_of!(nv_device_info, tpc_count) - 94usize];
    ["Offset of field: nv_device_info::mp_per_tpc"]
        [::std::mem::offset_of!(nv_device_info, mp_per_tpc) - 96usize];
    ["Offset of field: nv_device_info::max_warps_per_mp"]
        [::std::mem::offset_of!(nv_device_info, max_warps_per_mp) - 97usize];
    ["Offset of field: nv_device_info::cls_copy"]
        [::std::mem::offset_of!(nv_device_info, cls_copy) - 98usize];
    ["Offset of field: nv_device_info::cls_eng2d"]
        [::std::mem::offset_of!(nv_device_info, cls_eng2d) - 100usize];
    ["Offset of field: nv_device_info::cls_eng3d"]
        [::std::mem::offset_of!(nv_device_info, cls_eng3d) - 102usize];
    ["Offset of field: nv_device_info::cls_m2mf"]
        [::std::mem::offset_of!(nv_device_info, cls_m2mf) - 104usize];
    ["Offset of field: nv_device_info::cls_compute"]
        [::std::mem::offset_of!(nv_device_info, cls_compute) - 106usize];
    ["Offset of field: nv_device_info::vram_size_B"]
        [::std::mem::offset_of!(nv_device_info, vram_size_B) - 108usize];
    ["Offset of field: nv_device_info::bar_size_B"]
        [::std::mem::offset_of!(nv_device_info, bar_size_B) - 116usize];
};
impl Default for nv_device_info {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nak_should_print_nir() -> bool;
}
#[repr(C)]
pub struct nak_compiler {
    pub sm: u8,
    pub warps_per_sm: u8,
    pub nir_options: nir_shader_compiler_options,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nak_compiler"][::std::mem::size_of::<nak_compiler>() - 228usize];
    ["Alignment of nak_compiler"][::std::mem::align_of::<nak_compiler>() - 4usize];
    ["Offset of field: nak_compiler::sm"][::std::mem::offset_of!(nak_compiler, sm) - 0usize];
    ["Offset of field: nak_compiler::warps_per_sm"]
        [::std::mem::offset_of!(nak_compiler, warps_per_sm) - 1usize];
    ["Offset of field: nak_compiler::nir_options"]
        [::std::mem::offset_of!(nak_compiler, nir_options) - 4usize];
};
impl Default for nak_compiler {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const NAK_ATTR_TESS_LOD_LEFT: nak_attr = 0;
pub const NAK_ATTR_TESS_LOD_RIGHT: nak_attr = 4;
pub const NAK_ATTR_TESS_LOD_BOTTOM: nak_attr = 8;
pub const NAK_ATTR_TESS_LOD_TOP: nak_attr = 12;
pub const NAK_ATTR_TESS_LOD: nak_attr = 0;
pub const NAK_ATTR_TESS_INTERRIOR_U: nak_attr = 16;
pub const NAK_ATTR_TESS_INTERRIOR_V: nak_attr = 20;
pub const NAK_ATTR_TESS_INTERRIOR: nak_attr = 16;
pub const NAK_ATTR_PATCH_START: nak_attr = 32;
pub const NAK_ATTR_VPRS_TABLE_INDEX: nak_attr = 92;
pub const NAK_ATTR_PRIMITIVE_ID: nak_attr = 96;
pub const NAK_ATTR_RT_ARRAY_INDEX: nak_attr = 100;
pub const NAK_ATTR_VIEWPORT_INDEX: nak_attr = 104;
pub const NAK_ATTR_POINT_SIZE: nak_attr = 108;
pub const NAK_ATTR_POSITION_X: nak_attr = 112;
pub const NAK_ATTR_POSITION_Y: nak_attr = 116;
pub const NAK_ATTR_POSITION_Z: nak_attr = 120;
pub const NAK_ATTR_POSITION_W: nak_attr = 124;
pub const NAK_ATTR_POSITION: nak_attr = 112;
pub const NAK_ATTR_GENERIC_START: nak_attr = 128;
pub const NAK_ATTR_CLIP_CULL_DIST_0: nak_attr = 704;
pub const NAK_ATTR_CLIP_CULL_DIST_1: nak_attr = 708;
pub const NAK_ATTR_CLIP_CULL_DIST_2: nak_attr = 712;
pub const NAK_ATTR_CLIP_CULL_DIST_3: nak_attr = 716;
pub const NAK_ATTR_CLIP_CULL_DIST_4: nak_attr = 720;
pub const NAK_ATTR_CLIP_CULL_DIST_5: nak_attr = 724;
pub const NAK_ATTR_CLIP_CULL_DIST_6: nak_attr = 728;
pub const NAK_ATTR_CLIP_CULL_DIST_7: nak_attr = 732;
pub const NAK_ATTR_CLIP_CULL_DIST: nak_attr = 704;
pub const NAK_ATTR_POINT_SPRITE_S: nak_attr = 736;
pub const NAK_ATTR_POINT_SPRITE_T: nak_attr = 740;
pub const NAK_ATTR_POINT_SPRITE: nak_attr = 736;
pub const NAK_ATTR_FOG_COORD: nak_attr = 744;
pub const NAK_ATTR_TESS_COORD_X: nak_attr = 752;
pub const NAK_ATTR_TESS_COORD_Y: nak_attr = 756;
pub const NAK_ATTR_TESS_COORD: nak_attr = 752;
pub const NAK_ATTR_INSTANCE_ID: nak_attr = 760;
pub const NAK_ATTR_VERTEX_ID: nak_attr = 764;
pub const NAK_ATTR_BARY_COORD_NO_PERSP_X: nak_attr = 936;
pub const NAK_ATTR_BARY_COORD_NO_PERSP_Y: nak_attr = 940;
pub const NAK_ATTR_BARY_COORD_NO_PERSP_Z: nak_attr = 944;
pub const NAK_ATTR_BARY_COORD_NO_PERSP: nak_attr = 936;
pub const NAK_ATTR_BARY_COORD_X: nak_attr = 948;
pub const NAK_ATTR_BARY_COORD_Y: nak_attr = 952;
pub const NAK_ATTR_BARY_COORD_Z: nak_attr = 956;
pub const NAK_ATTR_BARY_COORD: nak_attr = 948;
pub const NAK_ATTR_FRONT_FACE: nak_attr = 1020;
pub type nak_attr = ::std::os::raw::c_ushort;
unsafe extern "C" {
    pub fn nak_varying_attr_addr(nak: *const nak_compiler, slot: gl_varying_slot) -> u16;
}
unsafe extern "C" {
    pub fn nak_sysval_attr_addr(nak: *const nak_compiler, sysval: gl_system_value) -> u16;
}
pub const NAK_SV_LANE_ID: nak_sv = 0;
pub const NAK_SV_VIRTCFG: nak_sv = 2;
pub const NAK_SV_VIRTID: nak_sv = 3;
pub const NAK_SV_PRIM_TYPE: nak_sv = 16;
pub const NAK_SV_INVOCATION_ID: nak_sv = 17;
pub const NAK_SV_THREAD_KILL: nak_sv = 19;
pub const NAK_SV_INVOCATION_INFO: nak_sv = 29;
pub const NAK_SV_COMBINED_TID: nak_sv = 32;
pub const NAK_SV_TID_X: nak_sv = 33;
pub const NAK_SV_TID_Y: nak_sv = 34;
pub const NAK_SV_TID_Z: nak_sv = 35;
pub const NAK_SV_TID: nak_sv = 33;
pub const NAK_SV_CTAID_X: nak_sv = 37;
pub const NAK_SV_CTAID_Y: nak_sv = 38;
pub const NAK_SV_CTAID_Z: nak_sv = 39;
pub const NAK_SV_CTAID: nak_sv = 37;
pub const NAK_SV_LANEMASK_EQ: nak_sv = 56;
pub const NAK_SV_LANEMASK_LT: nak_sv = 57;
pub const NAK_SV_LANEMASK_LE: nak_sv = 58;
pub const NAK_SV_LANEMASK_GT: nak_sv = 59;
pub const NAK_SV_LANEMASK_GE: nak_sv = 60;
pub const NAK_SV_CLOCK_LO: nak_sv = 80;
pub const NAK_SV_CLOCK_HI: nak_sv = 81;
pub const NAK_SV_CLOCK: nak_sv = 80;
pub const NAK_SV_VARIABLE_RATE: nak_sv = 132;
pub type nak_sv = ::std::os::raw::c_uchar;
unsafe extern "C" {
    pub fn nak_nir_workgroup_has_one_subgroup(nir: *const nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nak_nir_load_sysval(
        b: *mut nir_builder,
        idx: nak_sv,
        access: gl_access_qualifier,
    ) -> *mut nir_def;
}
unsafe extern "C" {
    pub fn nak_xfb_from_nir(nak: *const nak_compiler, nir_xfb: *const nir_xfb_info)
        -> nak_xfb_info;
}
#[repr(C)]
pub struct nak_io_addr_offset {
    pub base: nir_scalar,
    pub offset: i32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nak_io_addr_offset"][::std::mem::size_of::<nak_io_addr_offset>() - 12usize];
    ["Alignment of nak_io_addr_offset"][::std::mem::align_of::<nak_io_addr_offset>() - 4usize];
    ["Offset of field: nak_io_addr_offset::base"]
        [::std::mem::offset_of!(nak_io_addr_offset, base) - 0usize];
    ["Offset of field: nak_io_addr_offset::offset"]
        [::std::mem::offset_of!(nak_io_addr_offset, offset) - 8usize];
};
impl Default for nak_io_addr_offset {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nak_get_io_addr_offset(addr: *mut nir_def, imm_bits: u8) -> nak_io_addr_offset;
}
#[doc = " Indicates that this is a bindless texture"]
pub const NAK_NIR_TEX_REF_TYPE_BINDLESS: nak_nir_tex_ref_type = 0;
#[doc = " Indicates that this is a bound texture\n\n The binding index provided in texture_index."]
pub const NAK_NIR_TEX_REF_TYPE_BOUND: nak_nir_tex_ref_type = 1;
#[doc = " Indicates that this is a cbuf texture\n\n texture_index is (idx << 16) | offset."]
pub const NAK_NIR_TEX_REF_TYPE_CBUF: nak_nir_tex_ref_type = 2;
pub type nak_nir_tex_ref_type = ::std::os::raw::c_uint;
pub const NAK_NIR_LOD_MODE_AUTO: nak_nir_lod_mode = 0;
pub const NAK_NIR_LOD_MODE_ZERO: nak_nir_lod_mode = 1;
pub const NAK_NIR_LOD_MODE_BIAS: nak_nir_lod_mode = 2;
pub const NAK_NIR_LOD_MODE_LOD: nak_nir_lod_mode = 3;
pub const NAK_NIR_LOD_MODE_CLAMP: nak_nir_lod_mode = 4;
pub const NAK_NIR_LOD_MODE_BIAS_CLAMP: nak_nir_lod_mode = 5;
pub type nak_nir_lod_mode = ::std::os::raw::c_uint;
pub const NAK_NIR_OFFSET_MODE_NONE: nak_nir_offset_mode = 0;
pub const NAK_NIR_OFFSET_MODE_AOFFI: nak_nir_offset_mode = 1;
pub const NAK_NIR_OFFSET_MODE_PER_PX: nak_nir_offset_mode = 2;
pub type nak_nir_offset_mode = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nak_nir_tex_flags {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nak_nir_tex_flags"][::std::mem::size_of::<nak_nir_tex_flags>() - 4usize];
    ["Alignment of nak_nir_tex_flags"][::std::mem::align_of::<nak_nir_tex_flags>() - 4usize];
};
impl Default for nak_nir_tex_flags {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl nak_nir_tex_flags {
    #[inline]
    pub fn ref_type(&self) -> nak_nir_tex_ref_type {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_ref_type(&mut self, val: nak_nir_tex_ref_type) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn ref_type_raw(this: *const Self) -> nak_nir_tex_ref_type {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                2u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_ref_type_raw(this: *mut Self, val: nak_nir_tex_ref_type) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lod_mode(&self) -> nak_nir_lod_mode {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_lod_mode(&mut self, val: nak_nir_lod_mode) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lod_mode_raw(this: *const Self) -> nak_nir_lod_mode {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                2usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_lod_mode_raw(this: *mut Self, val: nak_nir_lod_mode) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                2usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn offset_mode(&self) -> nak_nir_offset_mode {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_offset_mode(&mut self, val: nak_nir_offset_mode) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn offset_mode_raw(this: *const Self) -> nak_nir_offset_mode {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                5usize,
                2u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_offset_mode_raw(this: *mut Self, val: nak_nir_offset_mode) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                5usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn has_z_cmpr(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_has_z_cmpr(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn has_z_cmpr_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                7usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_has_z_cmpr_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                7usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn is_sparse(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_is_sparse(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn is_sparse_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                8usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_is_sparse_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                8usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn nodep(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_nodep(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn nodep_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                9usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_nodep_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                9usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn pad(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 22u8) as u32) }
    }
    #[inline]
    pub fn set_pad(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 22u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn pad_raw(this: *const Self) -> u32 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                10usize,
                22u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_pad_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                10usize,
                22u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        ref_type: nak_nir_tex_ref_type,
        lod_mode: nak_nir_lod_mode,
        offset_mode: nak_nir_offset_mode,
        has_z_cmpr: bool,
        is_sparse: bool,
        nodep: bool,
        pad: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let ref_type: u32 = unsafe { ::std::mem::transmute(ref_type) };
            ref_type as u64
        });
        __bindgen_bitfield_unit.set(2usize, 3u8, {
            let lod_mode: u32 = unsafe { ::std::mem::transmute(lod_mode) };
            lod_mode as u64
        });
        __bindgen_bitfield_unit.set(5usize, 2u8, {
            let offset_mode: u32 = unsafe { ::std::mem::transmute(offset_mode) };
            offset_mode as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let has_z_cmpr: u8 = unsafe { ::std::mem::transmute(has_z_cmpr) };
            has_z_cmpr as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let is_sparse: u8 = unsafe { ::std::mem::transmute(is_sparse) };
            is_sparse as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let nodep: u8 = unsafe { ::std::mem::transmute(nodep) };
            nodep as u64
        });
        __bindgen_bitfield_unit.set(10usize, 22u8, {
            let pad: u32 = unsafe { ::std::mem::transmute(pad) };
            pad as u64
        });
        __bindgen_bitfield_unit
    }
}
unsafe extern "C" {
    pub fn nak_nir_lower_scan_reduce(shader: *mut nir_shader, nak: *const nak_compiler) -> bool;
}
unsafe extern "C" {
    pub fn nak_nir_lower_tex(nir: *mut nir_shader, nak: *const nak_compiler) -> bool;
}
unsafe extern "C" {
    pub fn nak_nir_lower_gs_intrinsics(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nak_nir_lower_algebraic_late(nir: *mut nir_shader, nak: *const nak_compiler) -> bool;
}
unsafe extern "C" {
    pub fn nak_nir_lower_kepler_shared_atomics(shader: *mut nir_shader) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nak_nir_attr_io_flags {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nak_nir_attr_io_flags"][::std::mem::size_of::<nak_nir_attr_io_flags>() - 4usize];
    ["Alignment of nak_nir_attr_io_flags"]
        [::std::mem::align_of::<nak_nir_attr_io_flags>() - 4usize];
};
impl nak_nir_attr_io_flags {
    #[inline]
    pub fn output(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_output(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn output_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_output_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn patch(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_patch(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn patch_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                1usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_patch_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn phys(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_phys(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn phys_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                2usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_phys_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                2usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn pad(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 29u8) as u32) }
    }
    #[inline]
    pub fn set_pad(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 29u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn pad_raw(this: *const Self) -> u32 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                29u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_pad_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                29u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        output: bool,
        patch: bool,
        phys: bool,
        pad: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let output: u8 = unsafe { ::std::mem::transmute(output) };
            output as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let patch: u8 = unsafe { ::std::mem::transmute(patch) };
            patch as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let phys: u8 = unsafe { ::std::mem::transmute(phys) };
            phys as u64
        });
        __bindgen_bitfield_unit.set(3usize, 29u8, {
            let pad: u32 = unsafe { ::std::mem::transmute(pad) };
            pad as u64
        });
        __bindgen_bitfield_unit
    }
}
pub const NAK_SUCLAMP_MODE_STORED_DESCRIPTOR: nak_suclamp_mode = 0;
pub const NAK_SUCLAMP_MODE_PITCH_LINEAR: nak_suclamp_mode = 1;
pub const NAK_SUCLAMP_MODE_BLOCK_LINEAR: nak_suclamp_mode = 2;
pub type nak_suclamp_mode = ::std::os::raw::c_uint;
pub const NAK_SUCLAMP_ROUND_R1: nak_suclamp_round = 0;
pub const NAK_SUCLAMP_ROUND_R2: nak_suclamp_round = 1;
pub const NAK_SUCLAMP_ROUND_R4: nak_suclamp_round = 2;
pub const NAK_SUCLAMP_ROUND_R8: nak_suclamp_round = 3;
pub const NAK_SUCLAMP_ROUND_R16: nak_suclamp_round = 4;
pub type nak_suclamp_round = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nak_nir_suclamp_flags {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nak_nir_suclamp_flags"][::std::mem::size_of::<nak_nir_suclamp_flags>() - 4usize];
    ["Alignment of nak_nir_suclamp_flags"]
        [::std::mem::align_of::<nak_nir_suclamp_flags>() - 4usize];
};
impl Default for nak_nir_suclamp_flags {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl nak_nir_suclamp_flags {
    #[inline]
    pub fn mode(&self) -> nak_suclamp_mode {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_mode(&mut self, val: nak_suclamp_mode) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn mode_raw(this: *const Self) -> nak_suclamp_mode {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                2u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_mode_raw(this: *mut Self, val: nak_suclamp_mode) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn round(&self) -> nak_suclamp_round {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_round(&mut self, val: nak_suclamp_round) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn round_raw(this: *const Self) -> nak_suclamp_round {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                2usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_round_raw(this: *mut Self, val: nak_suclamp_round) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                2usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn is_s32(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_is_s32(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn is_s32_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                5usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_is_s32_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                5usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn is_2d(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_is_2d(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn is_2d_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                6usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_is_2d_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                6usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn pad(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 25u8) as u32) }
    }
    #[inline]
    pub fn set_pad(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 25u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn pad_raw(this: *const Self) -> u32 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                7usize,
                25u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_pad_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                7usize,
                25u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        mode: nak_suclamp_mode,
        round: nak_suclamp_round,
        is_s32: bool,
        is_2d: bool,
        pad: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let mode: u32 = unsafe { ::std::mem::transmute(mode) };
            mode as u64
        });
        __bindgen_bitfield_unit.set(2usize, 3u8, {
            let round: u32 = unsafe { ::std::mem::transmute(round) };
            round as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let is_s32: u8 = unsafe { ::std::mem::transmute(is_s32) };
            is_s32 as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let is_2d: u8 = unsafe { ::std::mem::transmute(is_2d) };
            is_2d as u64
        });
        __bindgen_bitfield_unit.set(7usize, 25u8, {
            let pad: u32 = unsafe { ::std::mem::transmute(pad) };
            pad as u64
        });
        __bindgen_bitfield_unit
    }
}
pub const NAK_SUGA_OFF_MODE_U32: nak_su_ga_offset_mode = 0;
pub const NAK_SUGA_OFF_MODE_S32: nak_su_ga_offset_mode = 1;
pub const NAK_SUGA_OFF_MODE_U8: nak_su_ga_offset_mode = 2;
pub const NAK_SUGA_OFF_MODE_S8: nak_su_ga_offset_mode = 3;
pub type nak_su_ga_offset_mode = ::std::os::raw::c_uint;
pub const NAK_IMAD_TYPE_U32: nak_imad_src_type = 0;
pub const NAK_IMAD_TYPE_U24: nak_imad_src_type = 1;
pub const NAK_IMAD_TYPE_U16_LO: nak_imad_src_type = 2;
pub const NAK_IMAD_TYPE_U16_HI: nak_imad_src_type = 3;
pub const NAK_IMAD_TYPE_S32: nak_imad_src_type = 4;
pub const NAK_IMAD_TYPE_S24: nak_imad_src_type = 5;
pub const NAK_IMAD_TYPE_S16_LO: nak_imad_src_type = 6;
pub const NAK_IMAD_TYPE_S16_HI: nak_imad_src_type = 7;
pub type nak_imad_src_type = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nak_nir_imadsp_flags {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nak_nir_imadsp_flags"][::std::mem::size_of::<nak_nir_imadsp_flags>() - 4usize];
    ["Alignment of nak_nir_imadsp_flags"][::std::mem::align_of::<nak_nir_imadsp_flags>() - 4usize];
};
impl Default for nak_nir_imadsp_flags {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl nak_nir_imadsp_flags {
    #[inline]
    pub fn src0(&self) -> nak_imad_src_type {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_src0(&mut self, val: nak_imad_src_type) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn src0_raw(this: *const Self) -> nak_imad_src_type {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_src0_raw(this: *mut Self, val: nak_imad_src_type) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn src1(&self) -> nak_imad_src_type {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_src1(&mut self, val: nak_imad_src_type) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn src1_raw(this: *const Self) -> nak_imad_src_type {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_src1_raw(this: *mut Self, val: nak_imad_src_type) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn src2(&self) -> nak_imad_src_type {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_src2(&mut self, val: nak_imad_src_type) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn src2_raw(this: *const Self) -> nak_imad_src_type {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                6usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_src2_raw(this: *mut Self, val: nak_imad_src_type) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                6usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn params_from_src1(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_params_from_src1(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn params_from_src1_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                9usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_params_from_src1_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                9usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn pad(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 22u8) as u32) }
    }
    #[inline]
    pub fn set_pad(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 22u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn pad_raw(this: *const Self) -> u32 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                10usize,
                22u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_pad_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                10usize,
                22u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        src0: nak_imad_src_type,
        src1: nak_imad_src_type,
        src2: nak_imad_src_type,
        params_from_src1: bool,
        pad: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 3u8, {
            let src0: u32 = unsafe { ::std::mem::transmute(src0) };
            src0 as u64
        });
        __bindgen_bitfield_unit.set(3usize, 3u8, {
            let src1: u32 = unsafe { ::std::mem::transmute(src1) };
            src1 as u64
        });
        __bindgen_bitfield_unit.set(6usize, 3u8, {
            let src2: u32 = unsafe { ::std::mem::transmute(src2) };
            src2 as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let params_from_src1: u8 = unsafe { ::std::mem::transmute(params_from_src1) };
            params_from_src1 as u64
        });
        __bindgen_bitfield_unit.set(10usize, 22u8, {
            let pad: u32 = unsafe { ::std::mem::transmute(pad) };
            pad as u64
        });
        __bindgen_bitfield_unit
    }
}
unsafe extern "C" {
    pub fn nak_nir_lower_vtg_io(nir: *mut nir_shader, nak: *const nak_compiler) -> bool;
}
pub const NAK_INTERP_MODE_PERSPECTIVE: nak_interp_mode = 0;
pub const NAK_INTERP_MODE_SCREEN_LINEAR: nak_interp_mode = 1;
pub const NAK_INTERP_MODE_CONSTANT: nak_interp_mode = 2;
pub type nak_interp_mode = ::std::os::raw::c_uint;
pub const NAK_INTERP_FREQ_PASS: nak_interp_freq = 0;
pub const NAK_INTERP_FREQ_PASS_MUL_W: nak_interp_freq = 1;
pub const NAK_INTERP_FREQ_CONSTANT: nak_interp_freq = 2;
pub const NAK_INTERP_FREQ_STATE: nak_interp_freq = 3;
pub type nak_interp_freq = ::std::os::raw::c_uint;
pub const NAK_INTERP_LOC_DEFAULT: nak_interp_loc = 0;
pub const NAK_INTERP_LOC_CENTROID: nak_interp_loc = 1;
pub const NAK_INTERP_LOC_OFFSET: nak_interp_loc = 2;
pub type nak_interp_loc = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nak_nir_ipa_flags {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nak_nir_ipa_flags"][::std::mem::size_of::<nak_nir_ipa_flags>() - 4usize];
    ["Alignment of nak_nir_ipa_flags"][::std::mem::align_of::<nak_nir_ipa_flags>() - 4usize];
};
impl Default for nak_nir_ipa_flags {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl nak_nir_ipa_flags {
    #[inline]
    pub fn interp_mode(&self) -> nak_interp_mode {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_interp_mode(&mut self, val: nak_interp_mode) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn interp_mode_raw(this: *const Self) -> nak_interp_mode {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                2u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_interp_mode_raw(this: *mut Self, val: nak_interp_mode) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn interp_freq(&self) -> nak_interp_freq {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_interp_freq(&mut self, val: nak_interp_freq) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn interp_freq_raw(this: *const Self) -> nak_interp_freq {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                2usize,
                2u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_interp_freq_raw(this: *mut Self, val: nak_interp_freq) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                2usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn interp_loc(&self) -> nak_interp_loc {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_interp_loc(&mut self, val: nak_interp_loc) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn interp_loc_raw(this: *const Self) -> nak_interp_loc {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                4usize,
                2u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_interp_loc_raw(this: *mut Self, val: nak_interp_loc) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                4usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn pad(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 26u8) as u32) }
    }
    #[inline]
    pub fn set_pad(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 26u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn pad_raw(this: *const Self) -> u32 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                6usize,
                26u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_pad_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                6usize,
                26u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        interp_mode: nak_interp_mode,
        interp_freq: nak_interp_freq,
        interp_loc: nak_interp_loc,
        pad: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let interp_mode: u32 = unsafe { ::std::mem::transmute(interp_mode) };
            interp_mode as u64
        });
        __bindgen_bitfield_unit.set(2usize, 2u8, {
            let interp_freq: u32 = unsafe { ::std::mem::transmute(interp_freq) };
            interp_freq as u64
        });
        __bindgen_bitfield_unit.set(4usize, 2u8, {
            let interp_loc: u32 = unsafe { ::std::mem::transmute(interp_loc) };
            interp_loc as u64
        });
        __bindgen_bitfield_unit.set(6usize, 26u8, {
            let pad: u32 = unsafe { ::std::mem::transmute(pad) };
            pad as u64
        });
        __bindgen_bitfield_unit
    }
}
pub const NAK_CMAT_TYPE_M8N8K16_INT: nak_cmat_type = 0;
pub const NAK_CMAT_TYPE_M16N8K16_INT: nak_cmat_type = 1;
pub const NAK_CMAT_TYPE_M16N8K32_INT: nak_cmat_type = 2;
pub const NAK_CMAT_TYPE_M16N8K8_FLOAT: nak_cmat_type = 3;
pub const NAK_CMAT_TYPE_M16N8K16_FLOAT: nak_cmat_type = 4;
pub const NAK_CMAT_TYPE_M16N16K32_INT_SW: nak_cmat_type = 5;
pub const NAK_CMAT_TYPE_M16N16K16_FLOAT_SW: nak_cmat_type = 6;
pub type nak_cmat_type = ::std::os::raw::c_uint;
#[repr(C)]
pub struct nak_nir_cmat_mul_add_flags {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nak_nir_cmat_mul_add_flags"]
        [::std::mem::size_of::<nak_nir_cmat_mul_add_flags>() - 4usize];
    ["Alignment of nak_nir_cmat_mul_add_flags"]
        [::std::mem::align_of::<nak_nir_cmat_mul_add_flags>() - 4usize];
};
impl Default for nak_nir_cmat_mul_add_flags {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl nak_nir_cmat_mul_add_flags {
    #[inline]
    pub fn cmat_type(&self) -> nak_cmat_type {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_cmat_type(&mut self, val: nak_cmat_type) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn cmat_type_raw(this: *const Self) -> nak_cmat_type {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_cmat_type_raw(this: *mut Self, val: nak_cmat_type) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn a_type(&self) -> glsl_base_type {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 5u8) as u32) }
    }
    #[inline]
    pub fn set_a_type(&mut self, val: glsl_base_type) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 5u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn a_type_raw(this: *const Self) -> glsl_base_type {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                5u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_a_type_raw(this: *mut Self, val: glsl_base_type) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                5u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn b_type(&self) -> glsl_base_type {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 5u8) as u32) }
    }
    #[inline]
    pub fn set_b_type(&mut self, val: glsl_base_type) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 5u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn b_type_raw(this: *const Self) -> glsl_base_type {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                8usize,
                5u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_b_type_raw(this: *mut Self, val: glsl_base_type) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                8usize,
                5u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn sat(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_sat(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn sat_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                13usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_sat_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                13usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn pad(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 18u8) as u32) }
    }
    #[inline]
    pub fn set_pad(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 18u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn pad_raw(this: *const Self) -> u32 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                14usize,
                18u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_pad_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                14usize,
                18u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        cmat_type: nak_cmat_type,
        a_type: glsl_base_type,
        b_type: glsl_base_type,
        sat: bool,
        pad: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 3u8, {
            let cmat_type: u32 = unsafe { ::std::mem::transmute(cmat_type) };
            cmat_type as u64
        });
        __bindgen_bitfield_unit.set(3usize, 5u8, {
            let a_type: u32 = unsafe { ::std::mem::transmute(a_type) };
            a_type as u64
        });
        __bindgen_bitfield_unit.set(8usize, 5u8, {
            let b_type: u32 = unsafe { ::std::mem::transmute(b_type) };
            b_type as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let sat: u8 = unsafe { ::std::mem::transmute(sat) };
            sat as u64
        });
        __bindgen_bitfield_unit.set(14usize, 18u8, {
            let pad: u32 = unsafe { ::std::mem::transmute(pad) };
            pad as u64
        });
        __bindgen_bitfield_unit
    }
}
unsafe extern "C" {
    pub fn nak_nir_lower_fs_inputs(
        nir: *mut nir_shader,
        nak: *const nak_compiler,
        fs_key: *const nak_fs_key,
    ) -> bool;
}
pub const NAK_FS_OUT_COLOR0: nak_fs_out = 0;
pub const NAK_FS_OUT_COLOR1: nak_fs_out = 16;
pub const NAK_FS_OUT_COLOR2: nak_fs_out = 32;
pub const NAK_FS_OUT_COLOR3: nak_fs_out = 48;
pub const NAK_FS_OUT_COLOR4: nak_fs_out = 64;
pub const NAK_FS_OUT_COLOR5: nak_fs_out = 80;
pub const NAK_FS_OUT_COLOR6: nak_fs_out = 96;
pub const NAK_FS_OUT_COLOR7: nak_fs_out = 112;
pub const NAK_FS_OUT_SAMPLE_MASK: nak_fs_out = 128;
pub const NAK_FS_OUT_DEPTH: nak_fs_out = 132;
pub type nak_fs_out = ::std::os::raw::c_uint;
unsafe extern "C" {
    pub fn nak_nir_rematerialize_load_const(nir: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nak_nir_mark_lcssa_invariants(nir: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nak_nir_lower_non_uniform_ldcx(nir: *mut nir_shader, nak: *const nak_compiler) -> bool;
}
unsafe extern "C" {
    pub fn nak_nir_add_barriers(nir: *mut nir_shader, nak: *const nak_compiler) -> bool;
}
unsafe extern "C" {
    pub fn nak_nir_lower_cf(nir: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nak_nir_lower_cmat(shader: *mut nir_shader, nak: *const nak_compiler) -> bool;
}
unsafe extern "C" {
    #[doc = " Check if, for nak's purposes, a block is divergent\n\n Note that this differs from block->divergent because in nir's terms, the\n start block of a loop with divergent continues can be non-divergent but nak\n will always consider this divergent. This matters because nak does not allow\n writing uregs from these blocks."]
    pub fn nak_block_is_divergent(block: *const nir_block) -> bool;
}
unsafe extern "C" {
    pub fn nak_optimize_nir(nir: *mut nir_shader, nak: *const nak_compiler);
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct simple_mtx_t {
    pub val: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of simple_mtx_t"][::std::mem::size_of::<simple_mtx_t>() - 4usize];
    ["Alignment of simple_mtx_t"][::std::mem::align_of::<simple_mtx_t>() - 4usize];
    ["Offset of field: simple_mtx_t::val"][::std::mem::offset_of!(simple_mtx_t, val) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nouveau_ws_device {
    pub fd: ::std::os::raw::c_int,
    pub info: nv_device_info,
    pub max_push: u32,
    pub bos_lock: simple_mtx_t,
    pub bos: *mut hash_table,
    pub has_vm_bind: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nouveau_ws_device"][::std::mem::size_of::<nouveau_ws_device>() - 144usize];
    ["Alignment of nouveau_ws_device"][::std::mem::align_of::<nouveau_ws_device>() - 4usize];
    ["Offset of field: nouveau_ws_device::fd"]
        [::std::mem::offset_of!(nouveau_ws_device, fd) - 0usize];
    ["Offset of field: nouveau_ws_device::info"]
        [::std::mem::offset_of!(nouveau_ws_device, info) - 4usize];
    ["Offset of field: nouveau_ws_device::max_push"]
        [::std::mem::offset_of!(nouveau_ws_device, max_push) - 128usize];
    ["Offset of field: nouveau_ws_device::bos_lock"]
        [::std::mem::offset_of!(nouveau_ws_device, bos_lock) - 132usize];
    ["Offset of field: nouveau_ws_device::bos"]
        [::std::mem::offset_of!(nouveau_ws_device, bos) - 136usize];
    ["Offset of field: nouveau_ws_device::has_vm_bind"]
        [::std::mem::offset_of!(nouveau_ws_device, has_vm_bind) - 140usize];
};
impl Default for nouveau_ws_device {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nouveau_ws_device_new(drm_device: *mut _drmDevice) -> *mut nouveau_ws_device;
}
unsafe extern "C" {
    pub fn nouveau_ws_device_destroy(arg1: *mut nouveau_ws_device);
}
unsafe extern "C" {
    pub fn nouveau_ws_device_vram_used(arg1: *mut nouveau_ws_device) -> u64;
}
unsafe extern "C" {
    pub fn nouveau_ws_device_timestamp(device: *mut nouveau_ws_device) -> u64;
}
unsafe extern "C" {
    pub fn nouveau_ws_device_has_tiled_bo(device: *mut nouveau_ws_device) -> bool;
}
pub type atomic_uint_fast32_t = uint_fast32_t;
pub const NOUVEAU_WS_BO_VRAM: nouveau_ws_bo_flags = 1;
pub const NOUVEAU_WS_BO_GART: nouveau_ws_bo_flags = 2;
pub const NOUVEAU_WS_BO_MAP: nouveau_ws_bo_flags = 4;
pub const NOUVEAU_WS_BO_NO_SHARE: nouveau_ws_bo_flags = 8;
pub type nouveau_ws_bo_flags = ::std::os::raw::c_uint;
pub const NOUVEAU_WS_BO_RD: nouveau_ws_bo_map_flags = 1;
pub const NOUVEAU_WS_BO_WR: nouveau_ws_bo_map_flags = 2;
pub const NOUVEAU_WS_BO_RDWR: nouveau_ws_bo_map_flags = 3;
pub type nouveau_ws_bo_map_flags = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nouveau_ws_bo {
    pub dev: *mut nouveau_ws_device,
    pub size: u64,
    pub map_handle: u64,
    pub handle: u32,
    pub flags: nouveau_ws_bo_flags,
    pub refcnt: atomic_uint_fast32_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nouveau_ws_bo"][::std::mem::size_of::<nouveau_ws_bo>() - 32usize];
    ["Alignment of nouveau_ws_bo"][::std::mem::align_of::<nouveau_ws_bo>() - 4usize];
    ["Offset of field: nouveau_ws_bo::dev"][::std::mem::offset_of!(nouveau_ws_bo, dev) - 0usize];
    ["Offset of field: nouveau_ws_bo::size"][::std::mem::offset_of!(nouveau_ws_bo, size) - 4usize];
    ["Offset of field: nouveau_ws_bo::map_handle"]
        [::std::mem::offset_of!(nouveau_ws_bo, map_handle) - 12usize];
    ["Offset of field: nouveau_ws_bo::handle"]
        [::std::mem::offset_of!(nouveau_ws_bo, handle) - 20usize];
    ["Offset of field: nouveau_ws_bo::flags"]
        [::std::mem::offset_of!(nouveau_ws_bo, flags) - 24usize];
    ["Offset of field: nouveau_ws_bo::refcnt"]
        [::std::mem::offset_of!(nouveau_ws_bo, refcnt) - 28usize];
};
impl Default for nouveau_ws_bo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nouveau_ws_bo_bind_vma(
        dev: *mut nouveau_ws_device,
        bo: *mut nouveau_ws_bo,
        addr: u64,
        range: u64,
        bo_offset: u64,
        pte_kind: u32,
    );
}
unsafe extern "C" {
    pub fn nouveau_ws_bo_unbind_vma(dev: *mut nouveau_ws_device, offset: u64, range: u64);
}
unsafe extern "C" {
    pub fn nouveau_ws_bo_new(
        arg1: *mut nouveau_ws_device,
        size: u64,
        align: u64,
        arg2: nouveau_ws_bo_flags,
    ) -> *mut nouveau_ws_bo;
}
unsafe extern "C" {
    pub fn nouveau_ws_bo_new_mapped(
        arg1: *mut nouveau_ws_device,
        size: u64,
        align: u64,
        arg2: nouveau_ws_bo_flags,
        map_flags: nouveau_ws_bo_map_flags,
        map_out: *mut *mut ::std::os::raw::c_void,
    ) -> *mut nouveau_ws_bo;
}
unsafe extern "C" {
    pub fn nouveau_ws_bo_new_tiled(
        arg1: *mut nouveau_ws_device,
        size: u64,
        align: u64,
        pte_kind: u8,
        tile_mode: u16,
        arg2: nouveau_ws_bo_flags,
    ) -> *mut nouveau_ws_bo;
}
unsafe extern "C" {
    pub fn nouveau_ws_bo_from_dma_buf(
        arg1: *mut nouveau_ws_device,
        fd: ::std::os::raw::c_int,
    ) -> *mut nouveau_ws_bo;
}
unsafe extern "C" {
    pub fn nouveau_ws_bo_destroy(arg1: *mut nouveau_ws_bo);
}
unsafe extern "C" {
    pub fn nouveau_ws_bo_map(
        arg1: *mut nouveau_ws_bo,
        arg2: nouveau_ws_bo_map_flags,
    ) -> *mut ::std::os::raw::c_void;
}
unsafe extern "C" {
    pub fn nouveau_ws_bo_unmap(bo: *mut nouveau_ws_bo, ptr: *mut ::std::os::raw::c_void);
}
unsafe extern "C" {
    pub fn nouveau_ws_bo_wait(arg1: *mut nouveau_ws_bo, flags: nouveau_ws_bo_map_flags) -> bool;
}
unsafe extern "C" {
    pub fn nouveau_ws_bo_dma_buf(
        arg1: *mut nouveau_ws_bo,
        fd: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nouveau_ws_object {
    pub cls: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nouveau_ws_object"][::std::mem::size_of::<nouveau_ws_object>() - 2usize];
    ["Alignment of nouveau_ws_object"][::std::mem::align_of::<nouveau_ws_object>() - 2usize];
    ["Offset of field: nouveau_ws_object::cls"]
        [::std::mem::offset_of!(nouveau_ws_object, cls) - 0usize];
};
pub const NOUVEAU_WS_ENGINE_COPY: nouveau_ws_engines = 1;
pub const NOUVEAU_WS_ENGINE_2D: nouveau_ws_engines = 2;
pub const NOUVEAU_WS_ENGINE_3D: nouveau_ws_engines = 4;
pub const NOUVEAU_WS_ENGINE_M2MF: nouveau_ws_engines = 8;
pub const NOUVEAU_WS_ENGINE_COMPUTE: nouveau_ws_engines = 16;
pub type nouveau_ws_engines = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nouveau_ws_context {
    pub dev: *mut nouveau_ws_device,
    pub channel: ::std::os::raw::c_int,
    pub copy: nouveau_ws_object,
    pub eng2d: nouveau_ws_object,
    pub eng3d: nouveau_ws_object,
    pub m2mf: nouveau_ws_object,
    pub compute: nouveau_ws_object,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nouveau_ws_context"][::std::mem::size_of::<nouveau_ws_context>() - 20usize];
    ["Alignment of nouveau_ws_context"][::std::mem::align_of::<nouveau_ws_context>() - 4usize];
    ["Offset of field: nouveau_ws_context::dev"]
        [::std::mem::offset_of!(nouveau_ws_context, dev) - 0usize];
    ["Offset of field: nouveau_ws_context::channel"]
        [::std::mem::offset_of!(nouveau_ws_context, channel) - 4usize];
    ["Offset of field: nouveau_ws_context::copy"]
        [::std::mem::offset_of!(nouveau_ws_context, copy) - 8usize];
    ["Offset of field: nouveau_ws_context::eng2d"]
        [::std::mem::offset_of!(nouveau_ws_context, eng2d) - 10usize];
    ["Offset of field: nouveau_ws_context::eng3d"]
        [::std::mem::offset_of!(nouveau_ws_context, eng3d) - 12usize];
    ["Offset of field: nouveau_ws_context::m2mf"]
        [::std::mem::offset_of!(nouveau_ws_context, m2mf) - 14usize];
    ["Offset of field: nouveau_ws_context::compute"]
        [::std::mem::offset_of!(nouveau_ws_context, compute) - 16usize];
};
impl Default for nouveau_ws_context {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nouveau_ws_context_create(
        arg1: *mut nouveau_ws_device,
        engines: nouveau_ws_engines,
        out: *mut *mut nouveau_ws_context,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn nouveau_ws_context_killed(arg1: *mut nouveau_ws_context) -> bool;
}
unsafe extern "C" {
    pub fn nouveau_ws_context_destroy(arg1: *mut nouveau_ws_context);
}
pub type drm_handle_t = ::std::os::raw::c_uint;
pub type drm_context_t = ::std::os::raw::c_uint;
pub type drm_drawable_t = ::std::os::raw::c_uint;
pub type drm_magic_t = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_clip_rect {
    pub x1: ::std::os::raw::c_ushort,
    pub y1: ::std::os::raw::c_ushort,
    pub x2: ::std::os::raw::c_ushort,
    pub y2: ::std::os::raw::c_ushort,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_clip_rect"][::std::mem::size_of::<drm_clip_rect>() - 8usize];
    ["Alignment of drm_clip_rect"][::std::mem::align_of::<drm_clip_rect>() - 2usize];
    ["Offset of field: drm_clip_rect::x1"][::std::mem::offset_of!(drm_clip_rect, x1) - 0usize];
    ["Offset of field: drm_clip_rect::y1"][::std::mem::offset_of!(drm_clip_rect, y1) - 2usize];
    ["Offset of field: drm_clip_rect::x2"][::std::mem::offset_of!(drm_clip_rect, x2) - 4usize];
    ["Offset of field: drm_clip_rect::y2"][::std::mem::offset_of!(drm_clip_rect, y2) - 6usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_drawable_info {
    pub num_rects: ::std::os::raw::c_uint,
    pub rects: *mut drm_clip_rect,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_drawable_info"][::std::mem::size_of::<drm_drawable_info>() - 8usize];
    ["Alignment of drm_drawable_info"][::std::mem::align_of::<drm_drawable_info>() - 4usize];
    ["Offset of field: drm_drawable_info::num_rects"]
        [::std::mem::offset_of!(drm_drawable_info, num_rects) - 0usize];
    ["Offset of field: drm_drawable_info::rects"]
        [::std::mem::offset_of!(drm_drawable_info, rects) - 4usize];
};
impl Default for drm_drawable_info {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_tex_region {
    pub next: ::std::os::raw::c_uchar,
    pub prev: ::std::os::raw::c_uchar,
    pub in_use: ::std::os::raw::c_uchar,
    pub padding: ::std::os::raw::c_uchar,
    pub age: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_tex_region"][::std::mem::size_of::<drm_tex_region>() - 8usize];
    ["Alignment of drm_tex_region"][::std::mem::align_of::<drm_tex_region>() - 4usize];
    ["Offset of field: drm_tex_region::next"]
        [::std::mem::offset_of!(drm_tex_region, next) - 0usize];
    ["Offset of field: drm_tex_region::prev"]
        [::std::mem::offset_of!(drm_tex_region, prev) - 1usize];
    ["Offset of field: drm_tex_region::in_use"]
        [::std::mem::offset_of!(drm_tex_region, in_use) - 2usize];
    ["Offset of field: drm_tex_region::padding"]
        [::std::mem::offset_of!(drm_tex_region, padding) - 3usize];
    ["Offset of field: drm_tex_region::age"][::std::mem::offset_of!(drm_tex_region, age) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_hw_lock {
    pub lock: ::std::os::raw::c_uint,
    pub padding: [::std::os::raw::c_char; 60usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_hw_lock"][::std::mem::size_of::<drm_hw_lock>() - 64usize];
    ["Alignment of drm_hw_lock"][::std::mem::align_of::<drm_hw_lock>() - 4usize];
    ["Offset of field: drm_hw_lock::lock"][::std::mem::offset_of!(drm_hw_lock, lock) - 0usize];
    ["Offset of field: drm_hw_lock::padding"]
        [::std::mem::offset_of!(drm_hw_lock, padding) - 4usize];
};
impl Default for drm_hw_lock {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_version {
    pub version_major: ::std::os::raw::c_int,
    pub version_minor: ::std::os::raw::c_int,
    pub version_patchlevel: ::std::os::raw::c_int,
    pub name_len: __kernel_size_t,
    pub name: *mut ::std::os::raw::c_char,
    pub date_len: __kernel_size_t,
    pub date: *mut ::std::os::raw::c_char,
    pub desc_len: __kernel_size_t,
    pub desc: *mut ::std::os::raw::c_char,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_version"][::std::mem::size_of::<drm_version>() - 36usize];
    ["Alignment of drm_version"][::std::mem::align_of::<drm_version>() - 4usize];
    ["Offset of field: drm_version::version_major"]
        [::std::mem::offset_of!(drm_version, version_major) - 0usize];
    ["Offset of field: drm_version::version_minor"]
        [::std::mem::offset_of!(drm_version, version_minor) - 4usize];
    ["Offset of field: drm_version::version_patchlevel"]
        [::std::mem::offset_of!(drm_version, version_patchlevel) - 8usize];
    ["Offset of field: drm_version::name_len"]
        [::std::mem::offset_of!(drm_version, name_len) - 12usize];
    ["Offset of field: drm_version::name"][::std::mem::offset_of!(drm_version, name) - 16usize];
    ["Offset of field: drm_version::date_len"]
        [::std::mem::offset_of!(drm_version, date_len) - 20usize];
    ["Offset of field: drm_version::date"][::std::mem::offset_of!(drm_version, date) - 24usize];
    ["Offset of field: drm_version::desc_len"]
        [::std::mem::offset_of!(drm_version, desc_len) - 28usize];
    ["Offset of field: drm_version::desc"][::std::mem::offset_of!(drm_version, desc) - 32usize];
};
impl Default for drm_version {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_unique {
    pub unique_len: __kernel_size_t,
    pub unique: *mut ::std::os::raw::c_char,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_unique"][::std::mem::size_of::<drm_unique>() - 8usize];
    ["Alignment of drm_unique"][::std::mem::align_of::<drm_unique>() - 4usize];
    ["Offset of field: drm_unique::unique_len"]
        [::std::mem::offset_of!(drm_unique, unique_len) - 0usize];
    ["Offset of field: drm_unique::unique"][::std::mem::offset_of!(drm_unique, unique) - 4usize];
};
impl Default for drm_unique {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_list {
    pub count: ::std::os::raw::c_int,
    pub version: *mut drm_version,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_list"][::std::mem::size_of::<drm_list>() - 8usize];
    ["Alignment of drm_list"][::std::mem::align_of::<drm_list>() - 4usize];
    ["Offset of field: drm_list::count"][::std::mem::offset_of!(drm_list, count) - 0usize];
    ["Offset of field: drm_list::version"][::std::mem::offset_of!(drm_list, version) - 4usize];
};
impl Default for drm_list {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_block {
    pub unused: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_block"][::std::mem::size_of::<drm_block>() - 4usize];
    ["Alignment of drm_block"][::std::mem::align_of::<drm_block>() - 4usize];
    ["Offset of field: drm_block::unused"][::std::mem::offset_of!(drm_block, unused) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_control {
    pub func: drm_control__bindgen_ty_1,
    pub irq: ::std::os::raw::c_int,
}
pub const DRM_ADD_COMMAND: drm_control__bindgen_ty_1 = 0;
pub const DRM_RM_COMMAND: drm_control__bindgen_ty_1 = 1;
pub const DRM_INST_HANDLER: drm_control__bindgen_ty_1 = 2;
pub const DRM_UNINST_HANDLER: drm_control__bindgen_ty_1 = 3;
pub type drm_control__bindgen_ty_1 = ::std::os::raw::c_uint;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_control"][::std::mem::size_of::<drm_control>() - 8usize];
    ["Alignment of drm_control"][::std::mem::align_of::<drm_control>() - 4usize];
    ["Offset of field: drm_control::func"][::std::mem::offset_of!(drm_control, func) - 0usize];
    ["Offset of field: drm_control::irq"][::std::mem::offset_of!(drm_control, irq) - 4usize];
};
impl Default for drm_control {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const _DRM_FRAME_BUFFER: drm_map_type = 0;
pub const _DRM_REGISTERS: drm_map_type = 1;
pub const _DRM_SHM: drm_map_type = 2;
pub const _DRM_AGP: drm_map_type = 3;
pub const _DRM_SCATTER_GATHER: drm_map_type = 4;
pub const _DRM_CONSISTENT: drm_map_type = 5;
pub type drm_map_type = ::std::os::raw::c_uint;
pub const _DRM_RESTRICTED: drm_map_flags = 1;
pub const _DRM_READ_ONLY: drm_map_flags = 2;
pub const _DRM_LOCKED: drm_map_flags = 4;
pub const _DRM_KERNEL: drm_map_flags = 8;
pub const _DRM_WRITE_COMBINING: drm_map_flags = 16;
pub const _DRM_CONTAINS_LOCK: drm_map_flags = 32;
pub const _DRM_REMOVABLE: drm_map_flags = 64;
pub const _DRM_DRIVER: drm_map_flags = 128;
pub type drm_map_flags = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_ctx_priv_map {
    pub ctx_id: ::std::os::raw::c_uint,
    pub handle: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_ctx_priv_map"][::std::mem::size_of::<drm_ctx_priv_map>() - 8usize];
    ["Alignment of drm_ctx_priv_map"][::std::mem::align_of::<drm_ctx_priv_map>() - 4usize];
    ["Offset of field: drm_ctx_priv_map::ctx_id"]
        [::std::mem::offset_of!(drm_ctx_priv_map, ctx_id) - 0usize];
    ["Offset of field: drm_ctx_priv_map::handle"]
        [::std::mem::offset_of!(drm_ctx_priv_map, handle) - 4usize];
};
impl Default for drm_ctx_priv_map {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_map {
    pub offset: ::std::os::raw::c_ulong,
    pub size: ::std::os::raw::c_ulong,
    pub type_: drm_map_type,
    pub flags: drm_map_flags,
    pub handle: *mut ::std::os::raw::c_void,
    pub mtrr: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_map"][::std::mem::size_of::<drm_map>() - 24usize];
    ["Alignment of drm_map"][::std::mem::align_of::<drm_map>() - 4usize];
    ["Offset of field: drm_map::offset"][::std::mem::offset_of!(drm_map, offset) - 0usize];
    ["Offset of field: drm_map::size"][::std::mem::offset_of!(drm_map, size) - 4usize];
    ["Offset of field: drm_map::type_"][::std::mem::offset_of!(drm_map, type_) - 8usize];
    ["Offset of field: drm_map::flags"][::std::mem::offset_of!(drm_map, flags) - 12usize];
    ["Offset of field: drm_map::handle"][::std::mem::offset_of!(drm_map, handle) - 16usize];
    ["Offset of field: drm_map::mtrr"][::std::mem::offset_of!(drm_map, mtrr) - 20usize];
};
impl Default for drm_map {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_client {
    pub idx: ::std::os::raw::c_int,
    pub auth: ::std::os::raw::c_int,
    pub pid: ::std::os::raw::c_ulong,
    pub uid: ::std::os::raw::c_ulong,
    pub magic: ::std::os::raw::c_ulong,
    pub iocs: ::std::os::raw::c_ulong,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_client"][::std::mem::size_of::<drm_client>() - 24usize];
    ["Alignment of drm_client"][::std::mem::align_of::<drm_client>() - 4usize];
    ["Offset of field: drm_client::idx"][::std::mem::offset_of!(drm_client, idx) - 0usize];
    ["Offset of field: drm_client::auth"][::std::mem::offset_of!(drm_client, auth) - 4usize];
    ["Offset of field: drm_client::pid"][::std::mem::offset_of!(drm_client, pid) - 8usize];
    ["Offset of field: drm_client::uid"][::std::mem::offset_of!(drm_client, uid) - 12usize];
    ["Offset of field: drm_client::magic"][::std::mem::offset_of!(drm_client, magic) - 16usize];
    ["Offset of field: drm_client::iocs"][::std::mem::offset_of!(drm_client, iocs) - 20usize];
};
pub const _DRM_STAT_LOCK: drm_stat_type = 0;
pub const _DRM_STAT_OPENS: drm_stat_type = 1;
pub const _DRM_STAT_CLOSES: drm_stat_type = 2;
pub const _DRM_STAT_IOCTLS: drm_stat_type = 3;
pub const _DRM_STAT_LOCKS: drm_stat_type = 4;
pub const _DRM_STAT_UNLOCKS: drm_stat_type = 5;
pub const _DRM_STAT_VALUE: drm_stat_type = 6;
pub const _DRM_STAT_BYTE: drm_stat_type = 7;
pub const _DRM_STAT_COUNT: drm_stat_type = 8;
pub const _DRM_STAT_IRQ: drm_stat_type = 9;
pub const _DRM_STAT_PRIMARY: drm_stat_type = 10;
pub const _DRM_STAT_SECONDARY: drm_stat_type = 11;
pub const _DRM_STAT_DMA: drm_stat_type = 12;
pub const _DRM_STAT_SPECIAL: drm_stat_type = 13;
pub const _DRM_STAT_MISSED: drm_stat_type = 14;
pub type drm_stat_type = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_stats {
    pub count: ::std::os::raw::c_ulong,
    pub data: [drm_stats__bindgen_ty_1; 15usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_stats__bindgen_ty_1 {
    pub value: ::std::os::raw::c_ulong,
    pub type_: drm_stat_type,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_stats__bindgen_ty_1"][::std::mem::size_of::<drm_stats__bindgen_ty_1>() - 8usize];
    ["Alignment of drm_stats__bindgen_ty_1"]
        [::std::mem::align_of::<drm_stats__bindgen_ty_1>() - 4usize];
    ["Offset of field: drm_stats__bindgen_ty_1::value"]
        [::std::mem::offset_of!(drm_stats__bindgen_ty_1, value) - 0usize];
    ["Offset of field: drm_stats__bindgen_ty_1::type_"]
        [::std::mem::offset_of!(drm_stats__bindgen_ty_1, type_) - 4usize];
};
impl Default for drm_stats__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_stats"][::std::mem::size_of::<drm_stats>() - 124usize];
    ["Alignment of drm_stats"][::std::mem::align_of::<drm_stats>() - 4usize];
    ["Offset of field: drm_stats::count"][::std::mem::offset_of!(drm_stats, count) - 0usize];
    ["Offset of field: drm_stats::data"][::std::mem::offset_of!(drm_stats, data) - 4usize];
};
impl Default for drm_stats {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const _DRM_LOCK_READY: drm_lock_flags = 1;
pub const _DRM_LOCK_QUIESCENT: drm_lock_flags = 2;
pub const _DRM_LOCK_FLUSH: drm_lock_flags = 4;
pub const _DRM_LOCK_FLUSH_ALL: drm_lock_flags = 8;
pub const _DRM_HALT_ALL_QUEUES: drm_lock_flags = 16;
pub const _DRM_HALT_CUR_QUEUES: drm_lock_flags = 32;
pub type drm_lock_flags = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_lock {
    pub context: ::std::os::raw::c_int,
    pub flags: drm_lock_flags,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_lock"][::std::mem::size_of::<drm_lock>() - 8usize];
    ["Alignment of drm_lock"][::std::mem::align_of::<drm_lock>() - 4usize];
    ["Offset of field: drm_lock::context"][::std::mem::offset_of!(drm_lock, context) - 0usize];
    ["Offset of field: drm_lock::flags"][::std::mem::offset_of!(drm_lock, flags) - 4usize];
};
impl Default for drm_lock {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const _DRM_DMA_BLOCK: drm_dma_flags = 1;
pub const _DRM_DMA_WHILE_LOCKED: drm_dma_flags = 2;
pub const _DRM_DMA_PRIORITY: drm_dma_flags = 4;
pub const _DRM_DMA_WAIT: drm_dma_flags = 16;
pub const _DRM_DMA_SMALLER_OK: drm_dma_flags = 32;
pub const _DRM_DMA_LARGER_OK: drm_dma_flags = 64;
pub type drm_dma_flags = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_buf_desc {
    pub count: ::std::os::raw::c_int,
    pub size: ::std::os::raw::c_int,
    pub low_mark: ::std::os::raw::c_int,
    pub high_mark: ::std::os::raw::c_int,
    pub flags: drm_buf_desc__bindgen_ty_1,
    pub agp_start: ::std::os::raw::c_ulong,
}
pub const _DRM_PAGE_ALIGN: drm_buf_desc__bindgen_ty_1 = 1;
pub const _DRM_AGP_BUFFER: drm_buf_desc__bindgen_ty_1 = 2;
pub const _DRM_SG_BUFFER: drm_buf_desc__bindgen_ty_1 = 4;
pub const _DRM_FB_BUFFER: drm_buf_desc__bindgen_ty_1 = 8;
pub const _DRM_PCI_BUFFER_RO: drm_buf_desc__bindgen_ty_1 = 16;
pub type drm_buf_desc__bindgen_ty_1 = ::std::os::raw::c_uint;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_buf_desc"][::std::mem::size_of::<drm_buf_desc>() - 24usize];
    ["Alignment of drm_buf_desc"][::std::mem::align_of::<drm_buf_desc>() - 4usize];
    ["Offset of field: drm_buf_desc::count"][::std::mem::offset_of!(drm_buf_desc, count) - 0usize];
    ["Offset of field: drm_buf_desc::size"][::std::mem::offset_of!(drm_buf_desc, size) - 4usize];
    ["Offset of field: drm_buf_desc::low_mark"]
        [::std::mem::offset_of!(drm_buf_desc, low_mark) - 8usize];
    ["Offset of field: drm_buf_desc::high_mark"]
        [::std::mem::offset_of!(drm_buf_desc, high_mark) - 12usize];
    ["Offset of field: drm_buf_desc::flags"][::std::mem::offset_of!(drm_buf_desc, flags) - 16usize];
    ["Offset of field: drm_buf_desc::agp_start"]
        [::std::mem::offset_of!(drm_buf_desc, agp_start) - 20usize];
};
impl Default for drm_buf_desc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_buf_info {
    pub count: ::std::os::raw::c_int,
    pub list: *mut drm_buf_desc,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_buf_info"][::std::mem::size_of::<drm_buf_info>() - 8usize];
    ["Alignment of drm_buf_info"][::std::mem::align_of::<drm_buf_info>() - 4usize];
    ["Offset of field: drm_buf_info::count"][::std::mem::offset_of!(drm_buf_info, count) - 0usize];
    ["Offset of field: drm_buf_info::list"][::std::mem::offset_of!(drm_buf_info, list) - 4usize];
};
impl Default for drm_buf_info {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_buf_free {
    pub count: ::std::os::raw::c_int,
    pub list: *mut ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_buf_free"][::std::mem::size_of::<drm_buf_free>() - 8usize];
    ["Alignment of drm_buf_free"][::std::mem::align_of::<drm_buf_free>() - 4usize];
    ["Offset of field: drm_buf_free::count"][::std::mem::offset_of!(drm_buf_free, count) - 0usize];
    ["Offset of field: drm_buf_free::list"][::std::mem::offset_of!(drm_buf_free, list) - 4usize];
};
impl Default for drm_buf_free {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_buf_pub {
    pub idx: ::std::os::raw::c_int,
    pub total: ::std::os::raw::c_int,
    pub used: ::std::os::raw::c_int,
    pub address: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_buf_pub"][::std::mem::size_of::<drm_buf_pub>() - 16usize];
    ["Alignment of drm_buf_pub"][::std::mem::align_of::<drm_buf_pub>() - 4usize];
    ["Offset of field: drm_buf_pub::idx"][::std::mem::offset_of!(drm_buf_pub, idx) - 0usize];
    ["Offset of field: drm_buf_pub::total"][::std::mem::offset_of!(drm_buf_pub, total) - 4usize];
    ["Offset of field: drm_buf_pub::used"][::std::mem::offset_of!(drm_buf_pub, used) - 8usize];
    ["Offset of field: drm_buf_pub::address"]
        [::std::mem::offset_of!(drm_buf_pub, address) - 12usize];
};
impl Default for drm_buf_pub {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_buf_map {
    pub count: ::std::os::raw::c_int,
    pub virtual_: *mut ::std::os::raw::c_void,
    pub list: *mut drm_buf_pub,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_buf_map"][::std::mem::size_of::<drm_buf_map>() - 12usize];
    ["Alignment of drm_buf_map"][::std::mem::align_of::<drm_buf_map>() - 4usize];
    ["Offset of field: drm_buf_map::count"][::std::mem::offset_of!(drm_buf_map, count) - 0usize];
    ["Offset of field: drm_buf_map::virtual_"]
        [::std::mem::offset_of!(drm_buf_map, virtual_) - 4usize];
    ["Offset of field: drm_buf_map::list"][::std::mem::offset_of!(drm_buf_map, list) - 8usize];
};
impl Default for drm_buf_map {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_dma {
    pub context: ::std::os::raw::c_int,
    pub send_count: ::std::os::raw::c_int,
    pub send_indices: *mut ::std::os::raw::c_int,
    pub send_sizes: *mut ::std::os::raw::c_int,
    pub flags: drm_dma_flags,
    pub request_count: ::std::os::raw::c_int,
    pub request_size: ::std::os::raw::c_int,
    pub request_indices: *mut ::std::os::raw::c_int,
    pub request_sizes: *mut ::std::os::raw::c_int,
    pub granted_count: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_dma"][::std::mem::size_of::<drm_dma>() - 40usize];
    ["Alignment of drm_dma"][::std::mem::align_of::<drm_dma>() - 4usize];
    ["Offset of field: drm_dma::context"][::std::mem::offset_of!(drm_dma, context) - 0usize];
    ["Offset of field: drm_dma::send_count"][::std::mem::offset_of!(drm_dma, send_count) - 4usize];
    ["Offset of field: drm_dma::send_indices"]
        [::std::mem::offset_of!(drm_dma, send_indices) - 8usize];
    ["Offset of field: drm_dma::send_sizes"][::std::mem::offset_of!(drm_dma, send_sizes) - 12usize];
    ["Offset of field: drm_dma::flags"][::std::mem::offset_of!(drm_dma, flags) - 16usize];
    ["Offset of field: drm_dma::request_count"]
        [::std::mem::offset_of!(drm_dma, request_count) - 20usize];
    ["Offset of field: drm_dma::request_size"]
        [::std::mem::offset_of!(drm_dma, request_size) - 24usize];
    ["Offset of field: drm_dma::request_indices"]
        [::std::mem::offset_of!(drm_dma, request_indices) - 28usize];
    ["Offset of field: drm_dma::request_sizes"]
        [::std::mem::offset_of!(drm_dma, request_sizes) - 32usize];
    ["Offset of field: drm_dma::granted_count"]
        [::std::mem::offset_of!(drm_dma, granted_count) - 36usize];
};
impl Default for drm_dma {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const _DRM_CONTEXT_PRESERVED: drm_ctx_flags = 1;
pub const _DRM_CONTEXT_2DONLY: drm_ctx_flags = 2;
pub type drm_ctx_flags = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_ctx {
    pub handle: drm_context_t,
    pub flags: drm_ctx_flags,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_ctx"][::std::mem::size_of::<drm_ctx>() - 8usize];
    ["Alignment of drm_ctx"][::std::mem::align_of::<drm_ctx>() - 4usize];
    ["Offset of field: drm_ctx::handle"][::std::mem::offset_of!(drm_ctx, handle) - 0usize];
    ["Offset of field: drm_ctx::flags"][::std::mem::offset_of!(drm_ctx, flags) - 4usize];
};
impl Default for drm_ctx {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_ctx_res {
    pub count: ::std::os::raw::c_int,
    pub contexts: *mut drm_ctx,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_ctx_res"][::std::mem::size_of::<drm_ctx_res>() - 8usize];
    ["Alignment of drm_ctx_res"][::std::mem::align_of::<drm_ctx_res>() - 4usize];
    ["Offset of field: drm_ctx_res::count"][::std::mem::offset_of!(drm_ctx_res, count) - 0usize];
    ["Offset of field: drm_ctx_res::contexts"]
        [::std::mem::offset_of!(drm_ctx_res, contexts) - 4usize];
};
impl Default for drm_ctx_res {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_draw {
    pub handle: drm_drawable_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_draw"][::std::mem::size_of::<drm_draw>() - 4usize];
    ["Alignment of drm_draw"][::std::mem::align_of::<drm_draw>() - 4usize];
    ["Offset of field: drm_draw::handle"][::std::mem::offset_of!(drm_draw, handle) - 0usize];
};
pub const DRM_DRAWABLE_CLIPRECTS: drm_drawable_info_type_t = 0;
pub type drm_drawable_info_type_t = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_update_draw {
    pub handle: drm_drawable_t,
    pub type_: ::std::os::raw::c_uint,
    pub num: ::std::os::raw::c_uint,
    pub data: ::std::os::raw::c_ulonglong,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_update_draw"][::std::mem::size_of::<drm_update_draw>() - 20usize];
    ["Alignment of drm_update_draw"][::std::mem::align_of::<drm_update_draw>() - 4usize];
    ["Offset of field: drm_update_draw::handle"]
        [::std::mem::offset_of!(drm_update_draw, handle) - 0usize];
    ["Offset of field: drm_update_draw::type_"]
        [::std::mem::offset_of!(drm_update_draw, type_) - 4usize];
    ["Offset of field: drm_update_draw::num"]
        [::std::mem::offset_of!(drm_update_draw, num) - 8usize];
    ["Offset of field: drm_update_draw::data"]
        [::std::mem::offset_of!(drm_update_draw, data) - 12usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_auth {
    pub magic: drm_magic_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_auth"][::std::mem::size_of::<drm_auth>() - 4usize];
    ["Alignment of drm_auth"][::std::mem::align_of::<drm_auth>() - 4usize];
    ["Offset of field: drm_auth::magic"][::std::mem::offset_of!(drm_auth, magic) - 0usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_irq_busid {
    pub irq: ::std::os::raw::c_int,
    pub busnum: ::std::os::raw::c_int,
    pub devnum: ::std::os::raw::c_int,
    pub funcnum: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_irq_busid"][::std::mem::size_of::<drm_irq_busid>() - 16usize];
    ["Alignment of drm_irq_busid"][::std::mem::align_of::<drm_irq_busid>() - 4usize];
    ["Offset of field: drm_irq_busid::irq"][::std::mem::offset_of!(drm_irq_busid, irq) - 0usize];
    ["Offset of field: drm_irq_busid::busnum"]
        [::std::mem::offset_of!(drm_irq_busid, busnum) - 4usize];
    ["Offset of field: drm_irq_busid::devnum"]
        [::std::mem::offset_of!(drm_irq_busid, devnum) - 8usize];
    ["Offset of field: drm_irq_busid::funcnum"]
        [::std::mem::offset_of!(drm_irq_busid, funcnum) - 12usize];
};
pub const _DRM_VBLANK_ABSOLUTE: drm_vblank_seq_type = 0;
pub const _DRM_VBLANK_RELATIVE: drm_vblank_seq_type = 1;
pub const _DRM_VBLANK_HIGH_CRTC_MASK: drm_vblank_seq_type = 62;
pub const _DRM_VBLANK_EVENT: drm_vblank_seq_type = 67108864;
pub const _DRM_VBLANK_FLIP: drm_vblank_seq_type = 134217728;
pub const _DRM_VBLANK_NEXTONMISS: drm_vblank_seq_type = 268435456;
pub const _DRM_VBLANK_SECONDARY: drm_vblank_seq_type = 536870912;
pub const _DRM_VBLANK_SIGNAL: drm_vblank_seq_type = 1073741824;
pub type drm_vblank_seq_type = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_wait_vblank_request {
    pub type_: drm_vblank_seq_type,
    pub sequence: ::std::os::raw::c_uint,
    pub signal: ::std::os::raw::c_ulong,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_wait_vblank_request"][::std::mem::size_of::<drm_wait_vblank_request>() - 12usize];
    ["Alignment of drm_wait_vblank_request"]
        [::std::mem::align_of::<drm_wait_vblank_request>() - 4usize];
    ["Offset of field: drm_wait_vblank_request::type_"]
        [::std::mem::offset_of!(drm_wait_vblank_request, type_) - 0usize];
    ["Offset of field: drm_wait_vblank_request::sequence"]
        [::std::mem::offset_of!(drm_wait_vblank_request, sequence) - 4usize];
    ["Offset of field: drm_wait_vblank_request::signal"]
        [::std::mem::offset_of!(drm_wait_vblank_request, signal) - 8usize];
};
impl Default for drm_wait_vblank_request {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_wait_vblank_reply {
    pub type_: drm_vblank_seq_type,
    pub sequence: ::std::os::raw::c_uint,
    pub tval_sec: ::std::os::raw::c_long,
    pub tval_usec: ::std::os::raw::c_long,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_wait_vblank_reply"][::std::mem::size_of::<drm_wait_vblank_reply>() - 16usize];
    ["Alignment of drm_wait_vblank_reply"]
        [::std::mem::align_of::<drm_wait_vblank_reply>() - 4usize];
    ["Offset of field: drm_wait_vblank_reply::type_"]
        [::std::mem::offset_of!(drm_wait_vblank_reply, type_) - 0usize];
    ["Offset of field: drm_wait_vblank_reply::sequence"]
        [::std::mem::offset_of!(drm_wait_vblank_reply, sequence) - 4usize];
    ["Offset of field: drm_wait_vblank_reply::tval_sec"]
        [::std::mem::offset_of!(drm_wait_vblank_reply, tval_sec) - 8usize];
    ["Offset of field: drm_wait_vblank_reply::tval_usec"]
        [::std::mem::offset_of!(drm_wait_vblank_reply, tval_usec) - 12usize];
};
impl Default for drm_wait_vblank_reply {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union drm_wait_vblank {
    pub request: drm_wait_vblank_request,
    pub reply: drm_wait_vblank_reply,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_wait_vblank"][::std::mem::size_of::<drm_wait_vblank>() - 16usize];
    ["Alignment of drm_wait_vblank"][::std::mem::align_of::<drm_wait_vblank>() - 4usize];
    ["Offset of field: drm_wait_vblank::request"]
        [::std::mem::offset_of!(drm_wait_vblank, request) - 0usize];
    ["Offset of field: drm_wait_vblank::reply"]
        [::std::mem::offset_of!(drm_wait_vblank, reply) - 0usize];
};
impl Default for drm_wait_vblank {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_modeset_ctl {
    pub crtc: __u32,
    pub cmd: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_modeset_ctl"][::std::mem::size_of::<drm_modeset_ctl>() - 8usize];
    ["Alignment of drm_modeset_ctl"][::std::mem::align_of::<drm_modeset_ctl>() - 4usize];
    ["Offset of field: drm_modeset_ctl::crtc"]
        [::std::mem::offset_of!(drm_modeset_ctl, crtc) - 0usize];
    ["Offset of field: drm_modeset_ctl::cmd"]
        [::std::mem::offset_of!(drm_modeset_ctl, cmd) - 4usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_agp_mode {
    pub mode: ::std::os::raw::c_ulong,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_agp_mode"][::std::mem::size_of::<drm_agp_mode>() - 4usize];
    ["Alignment of drm_agp_mode"][::std::mem::align_of::<drm_agp_mode>() - 4usize];
    ["Offset of field: drm_agp_mode::mode"][::std::mem::offset_of!(drm_agp_mode, mode) - 0usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_agp_buffer {
    pub size: ::std::os::raw::c_ulong,
    pub handle: ::std::os::raw::c_ulong,
    pub type_: ::std::os::raw::c_ulong,
    pub physical: ::std::os::raw::c_ulong,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_agp_buffer"][::std::mem::size_of::<drm_agp_buffer>() - 16usize];
    ["Alignment of drm_agp_buffer"][::std::mem::align_of::<drm_agp_buffer>() - 4usize];
    ["Offset of field: drm_agp_buffer::size"]
        [::std::mem::offset_of!(drm_agp_buffer, size) - 0usize];
    ["Offset of field: drm_agp_buffer::handle"]
        [::std::mem::offset_of!(drm_agp_buffer, handle) - 4usize];
    ["Offset of field: drm_agp_buffer::type_"]
        [::std::mem::offset_of!(drm_agp_buffer, type_) - 8usize];
    ["Offset of field: drm_agp_buffer::physical"]
        [::std::mem::offset_of!(drm_agp_buffer, physical) - 12usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_agp_binding {
    pub handle: ::std::os::raw::c_ulong,
    pub offset: ::std::os::raw::c_ulong,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_agp_binding"][::std::mem::size_of::<drm_agp_binding>() - 8usize];
    ["Alignment of drm_agp_binding"][::std::mem::align_of::<drm_agp_binding>() - 4usize];
    ["Offset of field: drm_agp_binding::handle"]
        [::std::mem::offset_of!(drm_agp_binding, handle) - 0usize];
    ["Offset of field: drm_agp_binding::offset"]
        [::std::mem::offset_of!(drm_agp_binding, offset) - 4usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_agp_info {
    pub agp_version_major: ::std::os::raw::c_int,
    pub agp_version_minor: ::std::os::raw::c_int,
    pub mode: ::std::os::raw::c_ulong,
    pub aperture_base: ::std::os::raw::c_ulong,
    pub aperture_size: ::std::os::raw::c_ulong,
    pub memory_allowed: ::std::os::raw::c_ulong,
    pub memory_used: ::std::os::raw::c_ulong,
    pub id_vendor: ::std::os::raw::c_ushort,
    pub id_device: ::std::os::raw::c_ushort,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_agp_info"][::std::mem::size_of::<drm_agp_info>() - 32usize];
    ["Alignment of drm_agp_info"][::std::mem::align_of::<drm_agp_info>() - 4usize];
    ["Offset of field: drm_agp_info::agp_version_major"]
        [::std::mem::offset_of!(drm_agp_info, agp_version_major) - 0usize];
    ["Offset of field: drm_agp_info::agp_version_minor"]
        [::std::mem::offset_of!(drm_agp_info, agp_version_minor) - 4usize];
    ["Offset of field: drm_agp_info::mode"][::std::mem::offset_of!(drm_agp_info, mode) - 8usize];
    ["Offset of field: drm_agp_info::aperture_base"]
        [::std::mem::offset_of!(drm_agp_info, aperture_base) - 12usize];
    ["Offset of field: drm_agp_info::aperture_size"]
        [::std::mem::offset_of!(drm_agp_info, aperture_size) - 16usize];
    ["Offset of field: drm_agp_info::memory_allowed"]
        [::std::mem::offset_of!(drm_agp_info, memory_allowed) - 20usize];
    ["Offset of field: drm_agp_info::memory_used"]
        [::std::mem::offset_of!(drm_agp_info, memory_used) - 24usize];
    ["Offset of field: drm_agp_info::id_vendor"]
        [::std::mem::offset_of!(drm_agp_info, id_vendor) - 28usize];
    ["Offset of field: drm_agp_info::id_device"]
        [::std::mem::offset_of!(drm_agp_info, id_device) - 30usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_scatter_gather {
    pub size: ::std::os::raw::c_ulong,
    pub handle: ::std::os::raw::c_ulong,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_scatter_gather"][::std::mem::size_of::<drm_scatter_gather>() - 8usize];
    ["Alignment of drm_scatter_gather"][::std::mem::align_of::<drm_scatter_gather>() - 4usize];
    ["Offset of field: drm_scatter_gather::size"]
        [::std::mem::offset_of!(drm_scatter_gather, size) - 0usize];
    ["Offset of field: drm_scatter_gather::handle"]
        [::std::mem::offset_of!(drm_scatter_gather, handle) - 4usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_set_version {
    pub drm_di_major: ::std::os::raw::c_int,
    pub drm_di_minor: ::std::os::raw::c_int,
    pub drm_dd_major: ::std::os::raw::c_int,
    pub drm_dd_minor: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_set_version"][::std::mem::size_of::<drm_set_version>() - 16usize];
    ["Alignment of drm_set_version"][::std::mem::align_of::<drm_set_version>() - 4usize];
    ["Offset of field: drm_set_version::drm_di_major"]
        [::std::mem::offset_of!(drm_set_version, drm_di_major) - 0usize];
    ["Offset of field: drm_set_version::drm_di_minor"]
        [::std::mem::offset_of!(drm_set_version, drm_di_minor) - 4usize];
    ["Offset of field: drm_set_version::drm_dd_major"]
        [::std::mem::offset_of!(drm_set_version, drm_dd_major) - 8usize];
    ["Offset of field: drm_set_version::drm_dd_minor"]
        [::std::mem::offset_of!(drm_set_version, drm_dd_minor) - 12usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_gem_close {
    pub handle: __u32,
    pub pad: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_gem_close"][::std::mem::size_of::<drm_gem_close>() - 8usize];
    ["Alignment of drm_gem_close"][::std::mem::align_of::<drm_gem_close>() - 4usize];
    ["Offset of field: drm_gem_close::handle"]
        [::std::mem::offset_of!(drm_gem_close, handle) - 0usize];
    ["Offset of field: drm_gem_close::pad"][::std::mem::offset_of!(drm_gem_close, pad) - 4usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_gem_flink {
    pub handle: __u32,
    pub name: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_gem_flink"][::std::mem::size_of::<drm_gem_flink>() - 8usize];
    ["Alignment of drm_gem_flink"][::std::mem::align_of::<drm_gem_flink>() - 4usize];
    ["Offset of field: drm_gem_flink::handle"]
        [::std::mem::offset_of!(drm_gem_flink, handle) - 0usize];
    ["Offset of field: drm_gem_flink::name"][::std::mem::offset_of!(drm_gem_flink, name) - 4usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_gem_open {
    pub name: __u32,
    pub handle: __u32,
    pub size: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_gem_open"][::std::mem::size_of::<drm_gem_open>() - 16usize];
    ["Alignment of drm_gem_open"][::std::mem::align_of::<drm_gem_open>() - 4usize];
    ["Offset of field: drm_gem_open::name"][::std::mem::offset_of!(drm_gem_open, name) - 0usize];
    ["Offset of field: drm_gem_open::handle"]
        [::std::mem::offset_of!(drm_gem_open, handle) - 4usize];
    ["Offset of field: drm_gem_open::size"][::std::mem::offset_of!(drm_gem_open, size) - 8usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_get_cap {
    pub capability: __u64,
    pub value: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_get_cap"][::std::mem::size_of::<drm_get_cap>() - 16usize];
    ["Alignment of drm_get_cap"][::std::mem::align_of::<drm_get_cap>() - 4usize];
    ["Offset of field: drm_get_cap::capability"]
        [::std::mem::offset_of!(drm_get_cap, capability) - 0usize];
    ["Offset of field: drm_get_cap::value"][::std::mem::offset_of!(drm_get_cap, value) - 8usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_set_client_cap {
    pub capability: __u64,
    pub value: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_set_client_cap"][::std::mem::size_of::<drm_set_client_cap>() - 16usize];
    ["Alignment of drm_set_client_cap"][::std::mem::align_of::<drm_set_client_cap>() - 4usize];
    ["Offset of field: drm_set_client_cap::capability"]
        [::std::mem::offset_of!(drm_set_client_cap, capability) - 0usize];
    ["Offset of field: drm_set_client_cap::value"]
        [::std::mem::offset_of!(drm_set_client_cap, value) - 8usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_prime_handle {
    pub handle: __u32,
    pub flags: __u32,
    pub fd: __s32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_prime_handle"][::std::mem::size_of::<drm_prime_handle>() - 12usize];
    ["Alignment of drm_prime_handle"][::std::mem::align_of::<drm_prime_handle>() - 4usize];
    ["Offset of field: drm_prime_handle::handle"]
        [::std::mem::offset_of!(drm_prime_handle, handle) - 0usize];
    ["Offset of field: drm_prime_handle::flags"]
        [::std::mem::offset_of!(drm_prime_handle, flags) - 4usize];
    ["Offset of field: drm_prime_handle::fd"]
        [::std::mem::offset_of!(drm_prime_handle, fd) - 8usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_syncobj_create {
    pub handle: __u32,
    pub flags: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_syncobj_create"][::std::mem::size_of::<drm_syncobj_create>() - 8usize];
    ["Alignment of drm_syncobj_create"][::std::mem::align_of::<drm_syncobj_create>() - 4usize];
    ["Offset of field: drm_syncobj_create::handle"]
        [::std::mem::offset_of!(drm_syncobj_create, handle) - 0usize];
    ["Offset of field: drm_syncobj_create::flags"]
        [::std::mem::offset_of!(drm_syncobj_create, flags) - 4usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_syncobj_destroy {
    pub handle: __u32,
    pub pad: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_syncobj_destroy"][::std::mem::size_of::<drm_syncobj_destroy>() - 8usize];
    ["Alignment of drm_syncobj_destroy"][::std::mem::align_of::<drm_syncobj_destroy>() - 4usize];
    ["Offset of field: drm_syncobj_destroy::handle"]
        [::std::mem::offset_of!(drm_syncobj_destroy, handle) - 0usize];
    ["Offset of field: drm_syncobj_destroy::pad"]
        [::std::mem::offset_of!(drm_syncobj_destroy, pad) - 4usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_syncobj_handle {
    pub handle: __u32,
    pub flags: __u32,
    pub fd: __s32,
    pub pad: __u32,
    pub point: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_syncobj_handle"][::std::mem::size_of::<drm_syncobj_handle>() - 24usize];
    ["Alignment of drm_syncobj_handle"][::std::mem::align_of::<drm_syncobj_handle>() - 4usize];
    ["Offset of field: drm_syncobj_handle::handle"]
        [::std::mem::offset_of!(drm_syncobj_handle, handle) - 0usize];
    ["Offset of field: drm_syncobj_handle::flags"]
        [::std::mem::offset_of!(drm_syncobj_handle, flags) - 4usize];
    ["Offset of field: drm_syncobj_handle::fd"]
        [::std::mem::offset_of!(drm_syncobj_handle, fd) - 8usize];
    ["Offset of field: drm_syncobj_handle::pad"]
        [::std::mem::offset_of!(drm_syncobj_handle, pad) - 12usize];
    ["Offset of field: drm_syncobj_handle::point"]
        [::std::mem::offset_of!(drm_syncobj_handle, point) - 16usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_syncobj_transfer {
    pub src_handle: __u32,
    pub dst_handle: __u32,
    pub src_point: __u64,
    pub dst_point: __u64,
    pub flags: __u32,
    pub pad: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_syncobj_transfer"][::std::mem::size_of::<drm_syncobj_transfer>() - 32usize];
    ["Alignment of drm_syncobj_transfer"][::std::mem::align_of::<drm_syncobj_transfer>() - 4usize];
    ["Offset of field: drm_syncobj_transfer::src_handle"]
        [::std::mem::offset_of!(drm_syncobj_transfer, src_handle) - 0usize];
    ["Offset of field: drm_syncobj_transfer::dst_handle"]
        [::std::mem::offset_of!(drm_syncobj_transfer, dst_handle) - 4usize];
    ["Offset of field: drm_syncobj_transfer::src_point"]
        [::std::mem::offset_of!(drm_syncobj_transfer, src_point) - 8usize];
    ["Offset of field: drm_syncobj_transfer::dst_point"]
        [::std::mem::offset_of!(drm_syncobj_transfer, dst_point) - 16usize];
    ["Offset of field: drm_syncobj_transfer::flags"]
        [::std::mem::offset_of!(drm_syncobj_transfer, flags) - 24usize];
    ["Offset of field: drm_syncobj_transfer::pad"]
        [::std::mem::offset_of!(drm_syncobj_transfer, pad) - 28usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_syncobj_wait {
    pub handles: __u64,
    pub timeout_nsec: __s64,
    pub count_handles: __u32,
    pub flags: __u32,
    pub first_signaled: __u32,
    pub pad: __u32,
    pub deadline_nsec: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_syncobj_wait"][::std::mem::size_of::<drm_syncobj_wait>() - 40usize];
    ["Alignment of drm_syncobj_wait"][::std::mem::align_of::<drm_syncobj_wait>() - 4usize];
    ["Offset of field: drm_syncobj_wait::handles"]
        [::std::mem::offset_of!(drm_syncobj_wait, handles) - 0usize];
    ["Offset of field: drm_syncobj_wait::timeout_nsec"]
        [::std::mem::offset_of!(drm_syncobj_wait, timeout_nsec) - 8usize];
    ["Offset of field: drm_syncobj_wait::count_handles"]
        [::std::mem::offset_of!(drm_syncobj_wait, count_handles) - 16usize];
    ["Offset of field: drm_syncobj_wait::flags"]
        [::std::mem::offset_of!(drm_syncobj_wait, flags) - 20usize];
    ["Offset of field: drm_syncobj_wait::first_signaled"]
        [::std::mem::offset_of!(drm_syncobj_wait, first_signaled) - 24usize];
    ["Offset of field: drm_syncobj_wait::pad"]
        [::std::mem::offset_of!(drm_syncobj_wait, pad) - 28usize];
    ["Offset of field: drm_syncobj_wait::deadline_nsec"]
        [::std::mem::offset_of!(drm_syncobj_wait, deadline_nsec) - 32usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_syncobj_timeline_wait {
    pub handles: __u64,
    pub points: __u64,
    pub timeout_nsec: __s64,
    pub count_handles: __u32,
    pub flags: __u32,
    pub first_signaled: __u32,
    pub pad: __u32,
    pub deadline_nsec: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_syncobj_timeline_wait"]
        [::std::mem::size_of::<drm_syncobj_timeline_wait>() - 48usize];
    ["Alignment of drm_syncobj_timeline_wait"]
        [::std::mem::align_of::<drm_syncobj_timeline_wait>() - 4usize];
    ["Offset of field: drm_syncobj_timeline_wait::handles"]
        [::std::mem::offset_of!(drm_syncobj_timeline_wait, handles) - 0usize];
    ["Offset of field: drm_syncobj_timeline_wait::points"]
        [::std::mem::offset_of!(drm_syncobj_timeline_wait, points) - 8usize];
    ["Offset of field: drm_syncobj_timeline_wait::timeout_nsec"]
        [::std::mem::offset_of!(drm_syncobj_timeline_wait, timeout_nsec) - 16usize];
    ["Offset of field: drm_syncobj_timeline_wait::count_handles"]
        [::std::mem::offset_of!(drm_syncobj_timeline_wait, count_handles) - 24usize];
    ["Offset of field: drm_syncobj_timeline_wait::flags"]
        [::std::mem::offset_of!(drm_syncobj_timeline_wait, flags) - 28usize];
    ["Offset of field: drm_syncobj_timeline_wait::first_signaled"]
        [::std::mem::offset_of!(drm_syncobj_timeline_wait, first_signaled) - 32usize];
    ["Offset of field: drm_syncobj_timeline_wait::pad"]
        [::std::mem::offset_of!(drm_syncobj_timeline_wait, pad) - 36usize];
    ["Offset of field: drm_syncobj_timeline_wait::deadline_nsec"]
        [::std::mem::offset_of!(drm_syncobj_timeline_wait, deadline_nsec) - 40usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_syncobj_eventfd {
    pub handle: __u32,
    pub flags: __u32,
    pub point: __u64,
    pub fd: __s32,
    pub pad: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_syncobj_eventfd"][::std::mem::size_of::<drm_syncobj_eventfd>() - 24usize];
    ["Alignment of drm_syncobj_eventfd"][::std::mem::align_of::<drm_syncobj_eventfd>() - 4usize];
    ["Offset of field: drm_syncobj_eventfd::handle"]
        [::std::mem::offset_of!(drm_syncobj_eventfd, handle) - 0usize];
    ["Offset of field: drm_syncobj_eventfd::flags"]
        [::std::mem::offset_of!(drm_syncobj_eventfd, flags) - 4usize];
    ["Offset of field: drm_syncobj_eventfd::point"]
        [::std::mem::offset_of!(drm_syncobj_eventfd, point) - 8usize];
    ["Offset of field: drm_syncobj_eventfd::fd"]
        [::std::mem::offset_of!(drm_syncobj_eventfd, fd) - 16usize];
    ["Offset of field: drm_syncobj_eventfd::pad"]
        [::std::mem::offset_of!(drm_syncobj_eventfd, pad) - 20usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_syncobj_array {
    pub handles: __u64,
    pub count_handles: __u32,
    pub pad: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_syncobj_array"][::std::mem::size_of::<drm_syncobj_array>() - 16usize];
    ["Alignment of drm_syncobj_array"][::std::mem::align_of::<drm_syncobj_array>() - 4usize];
    ["Offset of field: drm_syncobj_array::handles"]
        [::std::mem::offset_of!(drm_syncobj_array, handles) - 0usize];
    ["Offset of field: drm_syncobj_array::count_handles"]
        [::std::mem::offset_of!(drm_syncobj_array, count_handles) - 8usize];
    ["Offset of field: drm_syncobj_array::pad"]
        [::std::mem::offset_of!(drm_syncobj_array, pad) - 12usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_syncobj_timeline_array {
    pub handles: __u64,
    pub points: __u64,
    pub count_handles: __u32,
    pub flags: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_syncobj_timeline_array"]
        [::std::mem::size_of::<drm_syncobj_timeline_array>() - 24usize];
    ["Alignment of drm_syncobj_timeline_array"]
        [::std::mem::align_of::<drm_syncobj_timeline_array>() - 4usize];
    ["Offset of field: drm_syncobj_timeline_array::handles"]
        [::std::mem::offset_of!(drm_syncobj_timeline_array, handles) - 0usize];
    ["Offset of field: drm_syncobj_timeline_array::points"]
        [::std::mem::offset_of!(drm_syncobj_timeline_array, points) - 8usize];
    ["Offset of field: drm_syncobj_timeline_array::count_handles"]
        [::std::mem::offset_of!(drm_syncobj_timeline_array, count_handles) - 16usize];
    ["Offset of field: drm_syncobj_timeline_array::flags"]
        [::std::mem::offset_of!(drm_syncobj_timeline_array, flags) - 20usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_crtc_get_sequence {
    pub crtc_id: __u32,
    pub active: __u32,
    pub sequence: __u64,
    pub sequence_ns: __s64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_crtc_get_sequence"][::std::mem::size_of::<drm_crtc_get_sequence>() - 24usize];
    ["Alignment of drm_crtc_get_sequence"]
        [::std::mem::align_of::<drm_crtc_get_sequence>() - 4usize];
    ["Offset of field: drm_crtc_get_sequence::crtc_id"]
        [::std::mem::offset_of!(drm_crtc_get_sequence, crtc_id) - 0usize];
    ["Offset of field: drm_crtc_get_sequence::active"]
        [::std::mem::offset_of!(drm_crtc_get_sequence, active) - 4usize];
    ["Offset of field: drm_crtc_get_sequence::sequence"]
        [::std::mem::offset_of!(drm_crtc_get_sequence, sequence) - 8usize];
    ["Offset of field: drm_crtc_get_sequence::sequence_ns"]
        [::std::mem::offset_of!(drm_crtc_get_sequence, sequence_ns) - 16usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_crtc_queue_sequence {
    pub crtc_id: __u32,
    pub flags: __u32,
    pub sequence: __u64,
    pub user_data: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_crtc_queue_sequence"][::std::mem::size_of::<drm_crtc_queue_sequence>() - 24usize];
    ["Alignment of drm_crtc_queue_sequence"]
        [::std::mem::align_of::<drm_crtc_queue_sequence>() - 4usize];
    ["Offset of field: drm_crtc_queue_sequence::crtc_id"]
        [::std::mem::offset_of!(drm_crtc_queue_sequence, crtc_id) - 0usize];
    ["Offset of field: drm_crtc_queue_sequence::flags"]
        [::std::mem::offset_of!(drm_crtc_queue_sequence, flags) - 4usize];
    ["Offset of field: drm_crtc_queue_sequence::sequence"]
        [::std::mem::offset_of!(drm_crtc_queue_sequence, sequence) - 8usize];
    ["Offset of field: drm_crtc_queue_sequence::user_data"]
        [::std::mem::offset_of!(drm_crtc_queue_sequence, user_data) - 16usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_set_client_name {
    pub name_len: __u64,
    pub name: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_set_client_name"][::std::mem::size_of::<drm_set_client_name>() - 16usize];
    ["Alignment of drm_set_client_name"][::std::mem::align_of::<drm_set_client_name>() - 4usize];
    ["Offset of field: drm_set_client_name::name_len"]
        [::std::mem::offset_of!(drm_set_client_name, name_len) - 0usize];
    ["Offset of field: drm_set_client_name::name"]
        [::std::mem::offset_of!(drm_set_client_name, name) - 8usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_modeinfo {
    pub clock: __u32,
    pub hdisplay: __u16,
    pub hsync_start: __u16,
    pub hsync_end: __u16,
    pub htotal: __u16,
    pub hskew: __u16,
    pub vdisplay: __u16,
    pub vsync_start: __u16,
    pub vsync_end: __u16,
    pub vtotal: __u16,
    pub vscan: __u16,
    pub vrefresh: __u32,
    pub flags: __u32,
    pub type_: __u32,
    pub name: [::std::os::raw::c_char; 32usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_modeinfo"][::std::mem::size_of::<drm_mode_modeinfo>() - 68usize];
    ["Alignment of drm_mode_modeinfo"][::std::mem::align_of::<drm_mode_modeinfo>() - 4usize];
    ["Offset of field: drm_mode_modeinfo::clock"]
        [::std::mem::offset_of!(drm_mode_modeinfo, clock) - 0usize];
    ["Offset of field: drm_mode_modeinfo::hdisplay"]
        [::std::mem::offset_of!(drm_mode_modeinfo, hdisplay) - 4usize];
    ["Offset of field: drm_mode_modeinfo::hsync_start"]
        [::std::mem::offset_of!(drm_mode_modeinfo, hsync_start) - 6usize];
    ["Offset of field: drm_mode_modeinfo::hsync_end"]
        [::std::mem::offset_of!(drm_mode_modeinfo, hsync_end) - 8usize];
    ["Offset of field: drm_mode_modeinfo::htotal"]
        [::std::mem::offset_of!(drm_mode_modeinfo, htotal) - 10usize];
    ["Offset of field: drm_mode_modeinfo::hskew"]
        [::std::mem::offset_of!(drm_mode_modeinfo, hskew) - 12usize];
    ["Offset of field: drm_mode_modeinfo::vdisplay"]
        [::std::mem::offset_of!(drm_mode_modeinfo, vdisplay) - 14usize];
    ["Offset of field: drm_mode_modeinfo::vsync_start"]
        [::std::mem::offset_of!(drm_mode_modeinfo, vsync_start) - 16usize];
    ["Offset of field: drm_mode_modeinfo::vsync_end"]
        [::std::mem::offset_of!(drm_mode_modeinfo, vsync_end) - 18usize];
    ["Offset of field: drm_mode_modeinfo::vtotal"]
        [::std::mem::offset_of!(drm_mode_modeinfo, vtotal) - 20usize];
    ["Offset of field: drm_mode_modeinfo::vscan"]
        [::std::mem::offset_of!(drm_mode_modeinfo, vscan) - 22usize];
    ["Offset of field: drm_mode_modeinfo::vrefresh"]
        [::std::mem::offset_of!(drm_mode_modeinfo, vrefresh) - 24usize];
    ["Offset of field: drm_mode_modeinfo::flags"]
        [::std::mem::offset_of!(drm_mode_modeinfo, flags) - 28usize];
    ["Offset of field: drm_mode_modeinfo::type_"]
        [::std::mem::offset_of!(drm_mode_modeinfo, type_) - 32usize];
    ["Offset of field: drm_mode_modeinfo::name"]
        [::std::mem::offset_of!(drm_mode_modeinfo, name) - 36usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_card_res {
    pub fb_id_ptr: __u64,
    pub crtc_id_ptr: __u64,
    pub connector_id_ptr: __u64,
    pub encoder_id_ptr: __u64,
    pub count_fbs: __u32,
    pub count_crtcs: __u32,
    pub count_connectors: __u32,
    pub count_encoders: __u32,
    pub min_width: __u32,
    pub max_width: __u32,
    pub min_height: __u32,
    pub max_height: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_card_res"][::std::mem::size_of::<drm_mode_card_res>() - 64usize];
    ["Alignment of drm_mode_card_res"][::std::mem::align_of::<drm_mode_card_res>() - 4usize];
    ["Offset of field: drm_mode_card_res::fb_id_ptr"]
        [::std::mem::offset_of!(drm_mode_card_res, fb_id_ptr) - 0usize];
    ["Offset of field: drm_mode_card_res::crtc_id_ptr"]
        [::std::mem::offset_of!(drm_mode_card_res, crtc_id_ptr) - 8usize];
    ["Offset of field: drm_mode_card_res::connector_id_ptr"]
        [::std::mem::offset_of!(drm_mode_card_res, connector_id_ptr) - 16usize];
    ["Offset of field: drm_mode_card_res::encoder_id_ptr"]
        [::std::mem::offset_of!(drm_mode_card_res, encoder_id_ptr) - 24usize];
    ["Offset of field: drm_mode_card_res::count_fbs"]
        [::std::mem::offset_of!(drm_mode_card_res, count_fbs) - 32usize];
    ["Offset of field: drm_mode_card_res::count_crtcs"]
        [::std::mem::offset_of!(drm_mode_card_res, count_crtcs) - 36usize];
    ["Offset of field: drm_mode_card_res::count_connectors"]
        [::std::mem::offset_of!(drm_mode_card_res, count_connectors) - 40usize];
    ["Offset of field: drm_mode_card_res::count_encoders"]
        [::std::mem::offset_of!(drm_mode_card_res, count_encoders) - 44usize];
    ["Offset of field: drm_mode_card_res::min_width"]
        [::std::mem::offset_of!(drm_mode_card_res, min_width) - 48usize];
    ["Offset of field: drm_mode_card_res::max_width"]
        [::std::mem::offset_of!(drm_mode_card_res, max_width) - 52usize];
    ["Offset of field: drm_mode_card_res::min_height"]
        [::std::mem::offset_of!(drm_mode_card_res, min_height) - 56usize];
    ["Offset of field: drm_mode_card_res::max_height"]
        [::std::mem::offset_of!(drm_mode_card_res, max_height) - 60usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_crtc {
    pub set_connectors_ptr: __u64,
    pub count_connectors: __u32,
    pub crtc_id: __u32,
    pub fb_id: __u32,
    pub x: __u32,
    pub y: __u32,
    pub gamma_size: __u32,
    pub mode_valid: __u32,
    pub mode: drm_mode_modeinfo,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_crtc"][::std::mem::size_of::<drm_mode_crtc>() - 104usize];
    ["Alignment of drm_mode_crtc"][::std::mem::align_of::<drm_mode_crtc>() - 4usize];
    ["Offset of field: drm_mode_crtc::set_connectors_ptr"]
        [::std::mem::offset_of!(drm_mode_crtc, set_connectors_ptr) - 0usize];
    ["Offset of field: drm_mode_crtc::count_connectors"]
        [::std::mem::offset_of!(drm_mode_crtc, count_connectors) - 8usize];
    ["Offset of field: drm_mode_crtc::crtc_id"]
        [::std::mem::offset_of!(drm_mode_crtc, crtc_id) - 12usize];
    ["Offset of field: drm_mode_crtc::fb_id"]
        [::std::mem::offset_of!(drm_mode_crtc, fb_id) - 16usize];
    ["Offset of field: drm_mode_crtc::x"][::std::mem::offset_of!(drm_mode_crtc, x) - 20usize];
    ["Offset of field: drm_mode_crtc::y"][::std::mem::offset_of!(drm_mode_crtc, y) - 24usize];
    ["Offset of field: drm_mode_crtc::gamma_size"]
        [::std::mem::offset_of!(drm_mode_crtc, gamma_size) - 28usize];
    ["Offset of field: drm_mode_crtc::mode_valid"]
        [::std::mem::offset_of!(drm_mode_crtc, mode_valid) - 32usize];
    ["Offset of field: drm_mode_crtc::mode"][::std::mem::offset_of!(drm_mode_crtc, mode) - 36usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_set_plane {
    pub plane_id: __u32,
    pub crtc_id: __u32,
    pub fb_id: __u32,
    pub flags: __u32,
    pub crtc_x: __s32,
    pub crtc_y: __s32,
    pub crtc_w: __u32,
    pub crtc_h: __u32,
    pub src_x: __u32,
    pub src_y: __u32,
    pub src_h: __u32,
    pub src_w: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_set_plane"][::std::mem::size_of::<drm_mode_set_plane>() - 48usize];
    ["Alignment of drm_mode_set_plane"][::std::mem::align_of::<drm_mode_set_plane>() - 4usize];
    ["Offset of field: drm_mode_set_plane::plane_id"]
        [::std::mem::offset_of!(drm_mode_set_plane, plane_id) - 0usize];
    ["Offset of field: drm_mode_set_plane::crtc_id"]
        [::std::mem::offset_of!(drm_mode_set_plane, crtc_id) - 4usize];
    ["Offset of field: drm_mode_set_plane::fb_id"]
        [::std::mem::offset_of!(drm_mode_set_plane, fb_id) - 8usize];
    ["Offset of field: drm_mode_set_plane::flags"]
        [::std::mem::offset_of!(drm_mode_set_plane, flags) - 12usize];
    ["Offset of field: drm_mode_set_plane::crtc_x"]
        [::std::mem::offset_of!(drm_mode_set_plane, crtc_x) - 16usize];
    ["Offset of field: drm_mode_set_plane::crtc_y"]
        [::std::mem::offset_of!(drm_mode_set_plane, crtc_y) - 20usize];
    ["Offset of field: drm_mode_set_plane::crtc_w"]
        [::std::mem::offset_of!(drm_mode_set_plane, crtc_w) - 24usize];
    ["Offset of field: drm_mode_set_plane::crtc_h"]
        [::std::mem::offset_of!(drm_mode_set_plane, crtc_h) - 28usize];
    ["Offset of field: drm_mode_set_plane::src_x"]
        [::std::mem::offset_of!(drm_mode_set_plane, src_x) - 32usize];
    ["Offset of field: drm_mode_set_plane::src_y"]
        [::std::mem::offset_of!(drm_mode_set_plane, src_y) - 36usize];
    ["Offset of field: drm_mode_set_plane::src_h"]
        [::std::mem::offset_of!(drm_mode_set_plane, src_h) - 40usize];
    ["Offset of field: drm_mode_set_plane::src_w"]
        [::std::mem::offset_of!(drm_mode_set_plane, src_w) - 44usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_get_plane {
    pub plane_id: __u32,
    pub crtc_id: __u32,
    pub fb_id: __u32,
    pub possible_crtcs: __u32,
    pub gamma_size: __u32,
    pub count_format_types: __u32,
    pub format_type_ptr: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_get_plane"][::std::mem::size_of::<drm_mode_get_plane>() - 32usize];
    ["Alignment of drm_mode_get_plane"][::std::mem::align_of::<drm_mode_get_plane>() - 4usize];
    ["Offset of field: drm_mode_get_plane::plane_id"]
        [::std::mem::offset_of!(drm_mode_get_plane, plane_id) - 0usize];
    ["Offset of field: drm_mode_get_plane::crtc_id"]
        [::std::mem::offset_of!(drm_mode_get_plane, crtc_id) - 4usize];
    ["Offset of field: drm_mode_get_plane::fb_id"]
        [::std::mem::offset_of!(drm_mode_get_plane, fb_id) - 8usize];
    ["Offset of field: drm_mode_get_plane::possible_crtcs"]
        [::std::mem::offset_of!(drm_mode_get_plane, possible_crtcs) - 12usize];
    ["Offset of field: drm_mode_get_plane::gamma_size"]
        [::std::mem::offset_of!(drm_mode_get_plane, gamma_size) - 16usize];
    ["Offset of field: drm_mode_get_plane::count_format_types"]
        [::std::mem::offset_of!(drm_mode_get_plane, count_format_types) - 20usize];
    ["Offset of field: drm_mode_get_plane::format_type_ptr"]
        [::std::mem::offset_of!(drm_mode_get_plane, format_type_ptr) - 24usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_get_plane_res {
    pub plane_id_ptr: __u64,
    pub count_planes: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_get_plane_res"][::std::mem::size_of::<drm_mode_get_plane_res>() - 12usize];
    ["Alignment of drm_mode_get_plane_res"]
        [::std::mem::align_of::<drm_mode_get_plane_res>() - 4usize];
    ["Offset of field: drm_mode_get_plane_res::plane_id_ptr"]
        [::std::mem::offset_of!(drm_mode_get_plane_res, plane_id_ptr) - 0usize];
    ["Offset of field: drm_mode_get_plane_res::count_planes"]
        [::std::mem::offset_of!(drm_mode_get_plane_res, count_planes) - 8usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_get_encoder {
    pub encoder_id: __u32,
    pub encoder_type: __u32,
    pub crtc_id: __u32,
    pub possible_crtcs: __u32,
    pub possible_clones: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_get_encoder"][::std::mem::size_of::<drm_mode_get_encoder>() - 20usize];
    ["Alignment of drm_mode_get_encoder"][::std::mem::align_of::<drm_mode_get_encoder>() - 4usize];
    ["Offset of field: drm_mode_get_encoder::encoder_id"]
        [::std::mem::offset_of!(drm_mode_get_encoder, encoder_id) - 0usize];
    ["Offset of field: drm_mode_get_encoder::encoder_type"]
        [::std::mem::offset_of!(drm_mode_get_encoder, encoder_type) - 4usize];
    ["Offset of field: drm_mode_get_encoder::crtc_id"]
        [::std::mem::offset_of!(drm_mode_get_encoder, crtc_id) - 8usize];
    ["Offset of field: drm_mode_get_encoder::possible_crtcs"]
        [::std::mem::offset_of!(drm_mode_get_encoder, possible_crtcs) - 12usize];
    ["Offset of field: drm_mode_get_encoder::possible_clones"]
        [::std::mem::offset_of!(drm_mode_get_encoder, possible_clones) - 16usize];
};
pub const DRM_MODE_SUBCONNECTOR_Automatic: drm_mode_subconnector = 0;
pub const DRM_MODE_SUBCONNECTOR_Unknown: drm_mode_subconnector = 0;
pub const DRM_MODE_SUBCONNECTOR_VGA: drm_mode_subconnector = 1;
pub const DRM_MODE_SUBCONNECTOR_DVID: drm_mode_subconnector = 3;
pub const DRM_MODE_SUBCONNECTOR_DVIA: drm_mode_subconnector = 4;
pub const DRM_MODE_SUBCONNECTOR_Composite: drm_mode_subconnector = 5;
pub const DRM_MODE_SUBCONNECTOR_SVIDEO: drm_mode_subconnector = 6;
pub const DRM_MODE_SUBCONNECTOR_Component: drm_mode_subconnector = 8;
pub const DRM_MODE_SUBCONNECTOR_SCART: drm_mode_subconnector = 9;
pub const DRM_MODE_SUBCONNECTOR_DisplayPort: drm_mode_subconnector = 10;
pub const DRM_MODE_SUBCONNECTOR_HDMIA: drm_mode_subconnector = 11;
pub const DRM_MODE_SUBCONNECTOR_Native: drm_mode_subconnector = 15;
pub const DRM_MODE_SUBCONNECTOR_Wireless: drm_mode_subconnector = 18;
pub type drm_mode_subconnector = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_get_connector {
    pub encoders_ptr: __u64,
    pub modes_ptr: __u64,
    pub props_ptr: __u64,
    pub prop_values_ptr: __u64,
    pub count_modes: __u32,
    pub count_props: __u32,
    pub count_encoders: __u32,
    pub encoder_id: __u32,
    pub connector_id: __u32,
    pub connector_type: __u32,
    pub connector_type_id: __u32,
    pub connection: __u32,
    pub mm_width: __u32,
    pub mm_height: __u32,
    pub subpixel: __u32,
    pub pad: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_get_connector"][::std::mem::size_of::<drm_mode_get_connector>() - 80usize];
    ["Alignment of drm_mode_get_connector"]
        [::std::mem::align_of::<drm_mode_get_connector>() - 4usize];
    ["Offset of field: drm_mode_get_connector::encoders_ptr"]
        [::std::mem::offset_of!(drm_mode_get_connector, encoders_ptr) - 0usize];
    ["Offset of field: drm_mode_get_connector::modes_ptr"]
        [::std::mem::offset_of!(drm_mode_get_connector, modes_ptr) - 8usize];
    ["Offset of field: drm_mode_get_connector::props_ptr"]
        [::std::mem::offset_of!(drm_mode_get_connector, props_ptr) - 16usize];
    ["Offset of field: drm_mode_get_connector::prop_values_ptr"]
        [::std::mem::offset_of!(drm_mode_get_connector, prop_values_ptr) - 24usize];
    ["Offset of field: drm_mode_get_connector::count_modes"]
        [::std::mem::offset_of!(drm_mode_get_connector, count_modes) - 32usize];
    ["Offset of field: drm_mode_get_connector::count_props"]
        [::std::mem::offset_of!(drm_mode_get_connector, count_props) - 36usize];
    ["Offset of field: drm_mode_get_connector::count_encoders"]
        [::std::mem::offset_of!(drm_mode_get_connector, count_encoders) - 40usize];
    ["Offset of field: drm_mode_get_connector::encoder_id"]
        [::std::mem::offset_of!(drm_mode_get_connector, encoder_id) - 44usize];
    ["Offset of field: drm_mode_get_connector::connector_id"]
        [::std::mem::offset_of!(drm_mode_get_connector, connector_id) - 48usize];
    ["Offset of field: drm_mode_get_connector::connector_type"]
        [::std::mem::offset_of!(drm_mode_get_connector, connector_type) - 52usize];
    ["Offset of field: drm_mode_get_connector::connector_type_id"]
        [::std::mem::offset_of!(drm_mode_get_connector, connector_type_id) - 56usize];
    ["Offset of field: drm_mode_get_connector::connection"]
        [::std::mem::offset_of!(drm_mode_get_connector, connection) - 60usize];
    ["Offset of field: drm_mode_get_connector::mm_width"]
        [::std::mem::offset_of!(drm_mode_get_connector, mm_width) - 64usize];
    ["Offset of field: drm_mode_get_connector::mm_height"]
        [::std::mem::offset_of!(drm_mode_get_connector, mm_height) - 68usize];
    ["Offset of field: drm_mode_get_connector::subpixel"]
        [::std::mem::offset_of!(drm_mode_get_connector, subpixel) - 72usize];
    ["Offset of field: drm_mode_get_connector::pad"]
        [::std::mem::offset_of!(drm_mode_get_connector, pad) - 76usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_property_enum {
    pub value: __u64,
    pub name: [::std::os::raw::c_char; 32usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_property_enum"][::std::mem::size_of::<drm_mode_property_enum>() - 40usize];
    ["Alignment of drm_mode_property_enum"]
        [::std::mem::align_of::<drm_mode_property_enum>() - 4usize];
    ["Offset of field: drm_mode_property_enum::value"]
        [::std::mem::offset_of!(drm_mode_property_enum, value) - 0usize];
    ["Offset of field: drm_mode_property_enum::name"]
        [::std::mem::offset_of!(drm_mode_property_enum, name) - 8usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_get_property {
    pub values_ptr: __u64,
    pub enum_blob_ptr: __u64,
    pub prop_id: __u32,
    pub flags: __u32,
    pub name: [::std::os::raw::c_char; 32usize],
    pub count_values: __u32,
    pub count_enum_blobs: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_get_property"][::std::mem::size_of::<drm_mode_get_property>() - 64usize];
    ["Alignment of drm_mode_get_property"]
        [::std::mem::align_of::<drm_mode_get_property>() - 4usize];
    ["Offset of field: drm_mode_get_property::values_ptr"]
        [::std::mem::offset_of!(drm_mode_get_property, values_ptr) - 0usize];
    ["Offset of field: drm_mode_get_property::enum_blob_ptr"]
        [::std::mem::offset_of!(drm_mode_get_property, enum_blob_ptr) - 8usize];
    ["Offset of field: drm_mode_get_property::prop_id"]
        [::std::mem::offset_of!(drm_mode_get_property, prop_id) - 16usize];
    ["Offset of field: drm_mode_get_property::flags"]
        [::std::mem::offset_of!(drm_mode_get_property, flags) - 20usize];
    ["Offset of field: drm_mode_get_property::name"]
        [::std::mem::offset_of!(drm_mode_get_property, name) - 24usize];
    ["Offset of field: drm_mode_get_property::count_values"]
        [::std::mem::offset_of!(drm_mode_get_property, count_values) - 56usize];
    ["Offset of field: drm_mode_get_property::count_enum_blobs"]
        [::std::mem::offset_of!(drm_mode_get_property, count_enum_blobs) - 60usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_connector_set_property {
    pub value: __u64,
    pub prop_id: __u32,
    pub connector_id: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_connector_set_property"]
        [::std::mem::size_of::<drm_mode_connector_set_property>() - 16usize];
    ["Alignment of drm_mode_connector_set_property"]
        [::std::mem::align_of::<drm_mode_connector_set_property>() - 4usize];
    ["Offset of field: drm_mode_connector_set_property::value"]
        [::std::mem::offset_of!(drm_mode_connector_set_property, value) - 0usize];
    ["Offset of field: drm_mode_connector_set_property::prop_id"]
        [::std::mem::offset_of!(drm_mode_connector_set_property, prop_id) - 8usize];
    ["Offset of field: drm_mode_connector_set_property::connector_id"]
        [::std::mem::offset_of!(drm_mode_connector_set_property, connector_id) - 12usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_obj_get_properties {
    pub props_ptr: __u64,
    pub prop_values_ptr: __u64,
    pub count_props: __u32,
    pub obj_id: __u32,
    pub obj_type: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_obj_get_properties"]
        [::std::mem::size_of::<drm_mode_obj_get_properties>() - 28usize];
    ["Alignment of drm_mode_obj_get_properties"]
        [::std::mem::align_of::<drm_mode_obj_get_properties>() - 4usize];
    ["Offset of field: drm_mode_obj_get_properties::props_ptr"]
        [::std::mem::offset_of!(drm_mode_obj_get_properties, props_ptr) - 0usize];
    ["Offset of field: drm_mode_obj_get_properties::prop_values_ptr"]
        [::std::mem::offset_of!(drm_mode_obj_get_properties, prop_values_ptr) - 8usize];
    ["Offset of field: drm_mode_obj_get_properties::count_props"]
        [::std::mem::offset_of!(drm_mode_obj_get_properties, count_props) - 16usize];
    ["Offset of field: drm_mode_obj_get_properties::obj_id"]
        [::std::mem::offset_of!(drm_mode_obj_get_properties, obj_id) - 20usize];
    ["Offset of field: drm_mode_obj_get_properties::obj_type"]
        [::std::mem::offset_of!(drm_mode_obj_get_properties, obj_type) - 24usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_obj_set_property {
    pub value: __u64,
    pub prop_id: __u32,
    pub obj_id: __u32,
    pub obj_type: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_obj_set_property"]
        [::std::mem::size_of::<drm_mode_obj_set_property>() - 20usize];
    ["Alignment of drm_mode_obj_set_property"]
        [::std::mem::align_of::<drm_mode_obj_set_property>() - 4usize];
    ["Offset of field: drm_mode_obj_set_property::value"]
        [::std::mem::offset_of!(drm_mode_obj_set_property, value) - 0usize];
    ["Offset of field: drm_mode_obj_set_property::prop_id"]
        [::std::mem::offset_of!(drm_mode_obj_set_property, prop_id) - 8usize];
    ["Offset of field: drm_mode_obj_set_property::obj_id"]
        [::std::mem::offset_of!(drm_mode_obj_set_property, obj_id) - 12usize];
    ["Offset of field: drm_mode_obj_set_property::obj_type"]
        [::std::mem::offset_of!(drm_mode_obj_set_property, obj_type) - 16usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_get_blob {
    pub blob_id: __u32,
    pub length: __u32,
    pub data: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_get_blob"][::std::mem::size_of::<drm_mode_get_blob>() - 16usize];
    ["Alignment of drm_mode_get_blob"][::std::mem::align_of::<drm_mode_get_blob>() - 4usize];
    ["Offset of field: drm_mode_get_blob::blob_id"]
        [::std::mem::offset_of!(drm_mode_get_blob, blob_id) - 0usize];
    ["Offset of field: drm_mode_get_blob::length"]
        [::std::mem::offset_of!(drm_mode_get_blob, length) - 4usize];
    ["Offset of field: drm_mode_get_blob::data"]
        [::std::mem::offset_of!(drm_mode_get_blob, data) - 8usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_fb_cmd {
    pub fb_id: __u32,
    pub width: __u32,
    pub height: __u32,
    pub pitch: __u32,
    pub bpp: __u32,
    pub depth: __u32,
    pub handle: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_fb_cmd"][::std::mem::size_of::<drm_mode_fb_cmd>() - 28usize];
    ["Alignment of drm_mode_fb_cmd"][::std::mem::align_of::<drm_mode_fb_cmd>() - 4usize];
    ["Offset of field: drm_mode_fb_cmd::fb_id"]
        [::std::mem::offset_of!(drm_mode_fb_cmd, fb_id) - 0usize];
    ["Offset of field: drm_mode_fb_cmd::width"]
        [::std::mem::offset_of!(drm_mode_fb_cmd, width) - 4usize];
    ["Offset of field: drm_mode_fb_cmd::height"]
        [::std::mem::offset_of!(drm_mode_fb_cmd, height) - 8usize];
    ["Offset of field: drm_mode_fb_cmd::pitch"]
        [::std::mem::offset_of!(drm_mode_fb_cmd, pitch) - 12usize];
    ["Offset of field: drm_mode_fb_cmd::bpp"]
        [::std::mem::offset_of!(drm_mode_fb_cmd, bpp) - 16usize];
    ["Offset of field: drm_mode_fb_cmd::depth"]
        [::std::mem::offset_of!(drm_mode_fb_cmd, depth) - 20usize];
    ["Offset of field: drm_mode_fb_cmd::handle"]
        [::std::mem::offset_of!(drm_mode_fb_cmd, handle) - 24usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_fb_cmd2 {
    pub fb_id: __u32,
    pub width: __u32,
    pub height: __u32,
    pub pixel_format: __u32,
    pub flags: __u32,
    pub handles: [__u32; 4usize],
    pub pitches: [__u32; 4usize],
    pub offsets: [__u32; 4usize],
    pub modifier: [__u64; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_fb_cmd2"][::std::mem::size_of::<drm_mode_fb_cmd2>() - 100usize];
    ["Alignment of drm_mode_fb_cmd2"][::std::mem::align_of::<drm_mode_fb_cmd2>() - 4usize];
    ["Offset of field: drm_mode_fb_cmd2::fb_id"]
        [::std::mem::offset_of!(drm_mode_fb_cmd2, fb_id) - 0usize];
    ["Offset of field: drm_mode_fb_cmd2::width"]
        [::std::mem::offset_of!(drm_mode_fb_cmd2, width) - 4usize];
    ["Offset of field: drm_mode_fb_cmd2::height"]
        [::std::mem::offset_of!(drm_mode_fb_cmd2, height) - 8usize];
    ["Offset of field: drm_mode_fb_cmd2::pixel_format"]
        [::std::mem::offset_of!(drm_mode_fb_cmd2, pixel_format) - 12usize];
    ["Offset of field: drm_mode_fb_cmd2::flags"]
        [::std::mem::offset_of!(drm_mode_fb_cmd2, flags) - 16usize];
    ["Offset of field: drm_mode_fb_cmd2::handles"]
        [::std::mem::offset_of!(drm_mode_fb_cmd2, handles) - 20usize];
    ["Offset of field: drm_mode_fb_cmd2::pitches"]
        [::std::mem::offset_of!(drm_mode_fb_cmd2, pitches) - 36usize];
    ["Offset of field: drm_mode_fb_cmd2::offsets"]
        [::std::mem::offset_of!(drm_mode_fb_cmd2, offsets) - 52usize];
    ["Offset of field: drm_mode_fb_cmd2::modifier"]
        [::std::mem::offset_of!(drm_mode_fb_cmd2, modifier) - 68usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_fb_dirty_cmd {
    pub fb_id: __u32,
    pub flags: __u32,
    pub color: __u32,
    pub num_clips: __u32,
    pub clips_ptr: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_fb_dirty_cmd"][::std::mem::size_of::<drm_mode_fb_dirty_cmd>() - 24usize];
    ["Alignment of drm_mode_fb_dirty_cmd"]
        [::std::mem::align_of::<drm_mode_fb_dirty_cmd>() - 4usize];
    ["Offset of field: drm_mode_fb_dirty_cmd::fb_id"]
        [::std::mem::offset_of!(drm_mode_fb_dirty_cmd, fb_id) - 0usize];
    ["Offset of field: drm_mode_fb_dirty_cmd::flags"]
        [::std::mem::offset_of!(drm_mode_fb_dirty_cmd, flags) - 4usize];
    ["Offset of field: drm_mode_fb_dirty_cmd::color"]
        [::std::mem::offset_of!(drm_mode_fb_dirty_cmd, color) - 8usize];
    ["Offset of field: drm_mode_fb_dirty_cmd::num_clips"]
        [::std::mem::offset_of!(drm_mode_fb_dirty_cmd, num_clips) - 12usize];
    ["Offset of field: drm_mode_fb_dirty_cmd::clips_ptr"]
        [::std::mem::offset_of!(drm_mode_fb_dirty_cmd, clips_ptr) - 16usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_mode_cmd {
    pub connector_id: __u32,
    pub mode: drm_mode_modeinfo,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_mode_cmd"][::std::mem::size_of::<drm_mode_mode_cmd>() - 72usize];
    ["Alignment of drm_mode_mode_cmd"][::std::mem::align_of::<drm_mode_mode_cmd>() - 4usize];
    ["Offset of field: drm_mode_mode_cmd::connector_id"]
        [::std::mem::offset_of!(drm_mode_mode_cmd, connector_id) - 0usize];
    ["Offset of field: drm_mode_mode_cmd::mode"]
        [::std::mem::offset_of!(drm_mode_mode_cmd, mode) - 4usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_cursor {
    pub flags: __u32,
    pub crtc_id: __u32,
    pub x: __s32,
    pub y: __s32,
    pub width: __u32,
    pub height: __u32,
    pub handle: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_cursor"][::std::mem::size_of::<drm_mode_cursor>() - 28usize];
    ["Alignment of drm_mode_cursor"][::std::mem::align_of::<drm_mode_cursor>() - 4usize];
    ["Offset of field: drm_mode_cursor::flags"]
        [::std::mem::offset_of!(drm_mode_cursor, flags) - 0usize];
    ["Offset of field: drm_mode_cursor::crtc_id"]
        [::std::mem::offset_of!(drm_mode_cursor, crtc_id) - 4usize];
    ["Offset of field: drm_mode_cursor::x"][::std::mem::offset_of!(drm_mode_cursor, x) - 8usize];
    ["Offset of field: drm_mode_cursor::y"][::std::mem::offset_of!(drm_mode_cursor, y) - 12usize];
    ["Offset of field: drm_mode_cursor::width"]
        [::std::mem::offset_of!(drm_mode_cursor, width) - 16usize];
    ["Offset of field: drm_mode_cursor::height"]
        [::std::mem::offset_of!(drm_mode_cursor, height) - 20usize];
    ["Offset of field: drm_mode_cursor::handle"]
        [::std::mem::offset_of!(drm_mode_cursor, handle) - 24usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_cursor2 {
    pub flags: __u32,
    pub crtc_id: __u32,
    pub x: __s32,
    pub y: __s32,
    pub width: __u32,
    pub height: __u32,
    pub handle: __u32,
    pub hot_x: __s32,
    pub hot_y: __s32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_cursor2"][::std::mem::size_of::<drm_mode_cursor2>() - 36usize];
    ["Alignment of drm_mode_cursor2"][::std::mem::align_of::<drm_mode_cursor2>() - 4usize];
    ["Offset of field: drm_mode_cursor2::flags"]
        [::std::mem::offset_of!(drm_mode_cursor2, flags) - 0usize];
    ["Offset of field: drm_mode_cursor2::crtc_id"]
        [::std::mem::offset_of!(drm_mode_cursor2, crtc_id) - 4usize];
    ["Offset of field: drm_mode_cursor2::x"][::std::mem::offset_of!(drm_mode_cursor2, x) - 8usize];
    ["Offset of field: drm_mode_cursor2::y"][::std::mem::offset_of!(drm_mode_cursor2, y) - 12usize];
    ["Offset of field: drm_mode_cursor2::width"]
        [::std::mem::offset_of!(drm_mode_cursor2, width) - 16usize];
    ["Offset of field: drm_mode_cursor2::height"]
        [::std::mem::offset_of!(drm_mode_cursor2, height) - 20usize];
    ["Offset of field: drm_mode_cursor2::handle"]
        [::std::mem::offset_of!(drm_mode_cursor2, handle) - 24usize];
    ["Offset of field: drm_mode_cursor2::hot_x"]
        [::std::mem::offset_of!(drm_mode_cursor2, hot_x) - 28usize];
    ["Offset of field: drm_mode_cursor2::hot_y"]
        [::std::mem::offset_of!(drm_mode_cursor2, hot_y) - 32usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_crtc_lut {
    pub crtc_id: __u32,
    pub gamma_size: __u32,
    pub red: __u64,
    pub green: __u64,
    pub blue: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_crtc_lut"][::std::mem::size_of::<drm_mode_crtc_lut>() - 32usize];
    ["Alignment of drm_mode_crtc_lut"][::std::mem::align_of::<drm_mode_crtc_lut>() - 4usize];
    ["Offset of field: drm_mode_crtc_lut::crtc_id"]
        [::std::mem::offset_of!(drm_mode_crtc_lut, crtc_id) - 0usize];
    ["Offset of field: drm_mode_crtc_lut::gamma_size"]
        [::std::mem::offset_of!(drm_mode_crtc_lut, gamma_size) - 4usize];
    ["Offset of field: drm_mode_crtc_lut::red"]
        [::std::mem::offset_of!(drm_mode_crtc_lut, red) - 8usize];
    ["Offset of field: drm_mode_crtc_lut::green"]
        [::std::mem::offset_of!(drm_mode_crtc_lut, green) - 16usize];
    ["Offset of field: drm_mode_crtc_lut::blue"]
        [::std::mem::offset_of!(drm_mode_crtc_lut, blue) - 24usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_color_ctm {
    pub matrix: [__u64; 9usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_color_ctm"][::std::mem::size_of::<drm_color_ctm>() - 72usize];
    ["Alignment of drm_color_ctm"][::std::mem::align_of::<drm_color_ctm>() - 4usize];
    ["Offset of field: drm_color_ctm::matrix"]
        [::std::mem::offset_of!(drm_color_ctm, matrix) - 0usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_color_lut {
    pub red: __u16,
    pub green: __u16,
    pub blue: __u16,
    pub reserved: __u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_color_lut"][::std::mem::size_of::<drm_color_lut>() - 8usize];
    ["Alignment of drm_color_lut"][::std::mem::align_of::<drm_color_lut>() - 2usize];
    ["Offset of field: drm_color_lut::red"][::std::mem::offset_of!(drm_color_lut, red) - 0usize];
    ["Offset of field: drm_color_lut::green"]
        [::std::mem::offset_of!(drm_color_lut, green) - 2usize];
    ["Offset of field: drm_color_lut::blue"][::std::mem::offset_of!(drm_color_lut, blue) - 4usize];
    ["Offset of field: drm_color_lut::reserved"]
        [::std::mem::offset_of!(drm_color_lut, reserved) - 6usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_plane_size_hint {
    pub width: __u16,
    pub height: __u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_plane_size_hint"][::std::mem::size_of::<drm_plane_size_hint>() - 4usize];
    ["Alignment of drm_plane_size_hint"][::std::mem::align_of::<drm_plane_size_hint>() - 2usize];
    ["Offset of field: drm_plane_size_hint::width"]
        [::std::mem::offset_of!(drm_plane_size_hint, width) - 0usize];
    ["Offset of field: drm_plane_size_hint::height"]
        [::std::mem::offset_of!(drm_plane_size_hint, height) - 2usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_crtc_page_flip {
    pub crtc_id: __u32,
    pub fb_id: __u32,
    pub flags: __u32,
    pub reserved: __u32,
    pub user_data: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_crtc_page_flip"][::std::mem::size_of::<drm_mode_crtc_page_flip>() - 24usize];
    ["Alignment of drm_mode_crtc_page_flip"]
        [::std::mem::align_of::<drm_mode_crtc_page_flip>() - 4usize];
    ["Offset of field: drm_mode_crtc_page_flip::crtc_id"]
        [::std::mem::offset_of!(drm_mode_crtc_page_flip, crtc_id) - 0usize];
    ["Offset of field: drm_mode_crtc_page_flip::fb_id"]
        [::std::mem::offset_of!(drm_mode_crtc_page_flip, fb_id) - 4usize];
    ["Offset of field: drm_mode_crtc_page_flip::flags"]
        [::std::mem::offset_of!(drm_mode_crtc_page_flip, flags) - 8usize];
    ["Offset of field: drm_mode_crtc_page_flip::reserved"]
        [::std::mem::offset_of!(drm_mode_crtc_page_flip, reserved) - 12usize];
    ["Offset of field: drm_mode_crtc_page_flip::user_data"]
        [::std::mem::offset_of!(drm_mode_crtc_page_flip, user_data) - 16usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_crtc_page_flip_target {
    pub crtc_id: __u32,
    pub fb_id: __u32,
    pub flags: __u32,
    pub sequence: __u32,
    pub user_data: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_crtc_page_flip_target"]
        [::std::mem::size_of::<drm_mode_crtc_page_flip_target>() - 24usize];
    ["Alignment of drm_mode_crtc_page_flip_target"]
        [::std::mem::align_of::<drm_mode_crtc_page_flip_target>() - 4usize];
    ["Offset of field: drm_mode_crtc_page_flip_target::crtc_id"]
        [::std::mem::offset_of!(drm_mode_crtc_page_flip_target, crtc_id) - 0usize];
    ["Offset of field: drm_mode_crtc_page_flip_target::fb_id"]
        [::std::mem::offset_of!(drm_mode_crtc_page_flip_target, fb_id) - 4usize];
    ["Offset of field: drm_mode_crtc_page_flip_target::flags"]
        [::std::mem::offset_of!(drm_mode_crtc_page_flip_target, flags) - 8usize];
    ["Offset of field: drm_mode_crtc_page_flip_target::sequence"]
        [::std::mem::offset_of!(drm_mode_crtc_page_flip_target, sequence) - 12usize];
    ["Offset of field: drm_mode_crtc_page_flip_target::user_data"]
        [::std::mem::offset_of!(drm_mode_crtc_page_flip_target, user_data) - 16usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_create_dumb {
    pub height: __u32,
    pub width: __u32,
    pub bpp: __u32,
    pub flags: __u32,
    pub handle: __u32,
    pub pitch: __u32,
    pub size: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_create_dumb"][::std::mem::size_of::<drm_mode_create_dumb>() - 32usize];
    ["Alignment of drm_mode_create_dumb"][::std::mem::align_of::<drm_mode_create_dumb>() - 4usize];
    ["Offset of field: drm_mode_create_dumb::height"]
        [::std::mem::offset_of!(drm_mode_create_dumb, height) - 0usize];
    ["Offset of field: drm_mode_create_dumb::width"]
        [::std::mem::offset_of!(drm_mode_create_dumb, width) - 4usize];
    ["Offset of field: drm_mode_create_dumb::bpp"]
        [::std::mem::offset_of!(drm_mode_create_dumb, bpp) - 8usize];
    ["Offset of field: drm_mode_create_dumb::flags"]
        [::std::mem::offset_of!(drm_mode_create_dumb, flags) - 12usize];
    ["Offset of field: drm_mode_create_dumb::handle"]
        [::std::mem::offset_of!(drm_mode_create_dumb, handle) - 16usize];
    ["Offset of field: drm_mode_create_dumb::pitch"]
        [::std::mem::offset_of!(drm_mode_create_dumb, pitch) - 20usize];
    ["Offset of field: drm_mode_create_dumb::size"]
        [::std::mem::offset_of!(drm_mode_create_dumb, size) - 24usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_map_dumb {
    pub handle: __u32,
    pub pad: __u32,
    pub offset: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_map_dumb"][::std::mem::size_of::<drm_mode_map_dumb>() - 16usize];
    ["Alignment of drm_mode_map_dumb"][::std::mem::align_of::<drm_mode_map_dumb>() - 4usize];
    ["Offset of field: drm_mode_map_dumb::handle"]
        [::std::mem::offset_of!(drm_mode_map_dumb, handle) - 0usize];
    ["Offset of field: drm_mode_map_dumb::pad"]
        [::std::mem::offset_of!(drm_mode_map_dumb, pad) - 4usize];
    ["Offset of field: drm_mode_map_dumb::offset"]
        [::std::mem::offset_of!(drm_mode_map_dumb, offset) - 8usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_destroy_dumb {
    pub handle: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_destroy_dumb"][::std::mem::size_of::<drm_mode_destroy_dumb>() - 4usize];
    ["Alignment of drm_mode_destroy_dumb"]
        [::std::mem::align_of::<drm_mode_destroy_dumb>() - 4usize];
    ["Offset of field: drm_mode_destroy_dumb::handle"]
        [::std::mem::offset_of!(drm_mode_destroy_dumb, handle) - 0usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_atomic {
    pub flags: __u32,
    pub count_objs: __u32,
    pub objs_ptr: __u64,
    pub count_props_ptr: __u64,
    pub props_ptr: __u64,
    pub prop_values_ptr: __u64,
    pub reserved: __u64,
    pub user_data: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_atomic"][::std::mem::size_of::<drm_mode_atomic>() - 56usize];
    ["Alignment of drm_mode_atomic"][::std::mem::align_of::<drm_mode_atomic>() - 4usize];
    ["Offset of field: drm_mode_atomic::flags"]
        [::std::mem::offset_of!(drm_mode_atomic, flags) - 0usize];
    ["Offset of field: drm_mode_atomic::count_objs"]
        [::std::mem::offset_of!(drm_mode_atomic, count_objs) - 4usize];
    ["Offset of field: drm_mode_atomic::objs_ptr"]
        [::std::mem::offset_of!(drm_mode_atomic, objs_ptr) - 8usize];
    ["Offset of field: drm_mode_atomic::count_props_ptr"]
        [::std::mem::offset_of!(drm_mode_atomic, count_props_ptr) - 16usize];
    ["Offset of field: drm_mode_atomic::props_ptr"]
        [::std::mem::offset_of!(drm_mode_atomic, props_ptr) - 24usize];
    ["Offset of field: drm_mode_atomic::prop_values_ptr"]
        [::std::mem::offset_of!(drm_mode_atomic, prop_values_ptr) - 32usize];
    ["Offset of field: drm_mode_atomic::reserved"]
        [::std::mem::offset_of!(drm_mode_atomic, reserved) - 40usize];
    ["Offset of field: drm_mode_atomic::user_data"]
        [::std::mem::offset_of!(drm_mode_atomic, user_data) - 48usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_format_modifier_blob {
    pub version: __u32,
    pub flags: __u32,
    pub count_formats: __u32,
    pub formats_offset: __u32,
    pub count_modifiers: __u32,
    pub modifiers_offset: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_format_modifier_blob"]
        [::std::mem::size_of::<drm_format_modifier_blob>() - 24usize];
    ["Alignment of drm_format_modifier_blob"]
        [::std::mem::align_of::<drm_format_modifier_blob>() - 4usize];
    ["Offset of field: drm_format_modifier_blob::version"]
        [::std::mem::offset_of!(drm_format_modifier_blob, version) - 0usize];
    ["Offset of field: drm_format_modifier_blob::flags"]
        [::std::mem::offset_of!(drm_format_modifier_blob, flags) - 4usize];
    ["Offset of field: drm_format_modifier_blob::count_formats"]
        [::std::mem::offset_of!(drm_format_modifier_blob, count_formats) - 8usize];
    ["Offset of field: drm_format_modifier_blob::formats_offset"]
        [::std::mem::offset_of!(drm_format_modifier_blob, formats_offset) - 12usize];
    ["Offset of field: drm_format_modifier_blob::count_modifiers"]
        [::std::mem::offset_of!(drm_format_modifier_blob, count_modifiers) - 16usize];
    ["Offset of field: drm_format_modifier_blob::modifiers_offset"]
        [::std::mem::offset_of!(drm_format_modifier_blob, modifiers_offset) - 20usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_format_modifier {
    pub formats: __u64,
    pub offset: __u32,
    pub pad: __u32,
    pub modifier: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_format_modifier"][::std::mem::size_of::<drm_format_modifier>() - 24usize];
    ["Alignment of drm_format_modifier"][::std::mem::align_of::<drm_format_modifier>() - 4usize];
    ["Offset of field: drm_format_modifier::formats"]
        [::std::mem::offset_of!(drm_format_modifier, formats) - 0usize];
    ["Offset of field: drm_format_modifier::offset"]
        [::std::mem::offset_of!(drm_format_modifier, offset) - 8usize];
    ["Offset of field: drm_format_modifier::pad"]
        [::std::mem::offset_of!(drm_format_modifier, pad) - 12usize];
    ["Offset of field: drm_format_modifier::modifier"]
        [::std::mem::offset_of!(drm_format_modifier, modifier) - 16usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_create_blob {
    pub data: __u64,
    pub length: __u32,
    pub blob_id: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_create_blob"][::std::mem::size_of::<drm_mode_create_blob>() - 16usize];
    ["Alignment of drm_mode_create_blob"][::std::mem::align_of::<drm_mode_create_blob>() - 4usize];
    ["Offset of field: drm_mode_create_blob::data"]
        [::std::mem::offset_of!(drm_mode_create_blob, data) - 0usize];
    ["Offset of field: drm_mode_create_blob::length"]
        [::std::mem::offset_of!(drm_mode_create_blob, length) - 8usize];
    ["Offset of field: drm_mode_create_blob::blob_id"]
        [::std::mem::offset_of!(drm_mode_create_blob, blob_id) - 12usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_destroy_blob {
    pub blob_id: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_destroy_blob"][::std::mem::size_of::<drm_mode_destroy_blob>() - 4usize];
    ["Alignment of drm_mode_destroy_blob"]
        [::std::mem::align_of::<drm_mode_destroy_blob>() - 4usize];
    ["Offset of field: drm_mode_destroy_blob::blob_id"]
        [::std::mem::offset_of!(drm_mode_destroy_blob, blob_id) - 0usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_create_lease {
    pub object_ids: __u64,
    pub object_count: __u32,
    pub flags: __u32,
    pub lessee_id: __u32,
    pub fd: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_create_lease"][::std::mem::size_of::<drm_mode_create_lease>() - 24usize];
    ["Alignment of drm_mode_create_lease"]
        [::std::mem::align_of::<drm_mode_create_lease>() - 4usize];
    ["Offset of field: drm_mode_create_lease::object_ids"]
        [::std::mem::offset_of!(drm_mode_create_lease, object_ids) - 0usize];
    ["Offset of field: drm_mode_create_lease::object_count"]
        [::std::mem::offset_of!(drm_mode_create_lease, object_count) - 8usize];
    ["Offset of field: drm_mode_create_lease::flags"]
        [::std::mem::offset_of!(drm_mode_create_lease, flags) - 12usize];
    ["Offset of field: drm_mode_create_lease::lessee_id"]
        [::std::mem::offset_of!(drm_mode_create_lease, lessee_id) - 16usize];
    ["Offset of field: drm_mode_create_lease::fd"]
        [::std::mem::offset_of!(drm_mode_create_lease, fd) - 20usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_list_lessees {
    pub count_lessees: __u32,
    pub pad: __u32,
    pub lessees_ptr: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_list_lessees"][::std::mem::size_of::<drm_mode_list_lessees>() - 16usize];
    ["Alignment of drm_mode_list_lessees"]
        [::std::mem::align_of::<drm_mode_list_lessees>() - 4usize];
    ["Offset of field: drm_mode_list_lessees::count_lessees"]
        [::std::mem::offset_of!(drm_mode_list_lessees, count_lessees) - 0usize];
    ["Offset of field: drm_mode_list_lessees::pad"]
        [::std::mem::offset_of!(drm_mode_list_lessees, pad) - 4usize];
    ["Offset of field: drm_mode_list_lessees::lessees_ptr"]
        [::std::mem::offset_of!(drm_mode_list_lessees, lessees_ptr) - 8usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_get_lease {
    pub count_objects: __u32,
    pub pad: __u32,
    pub objects_ptr: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_get_lease"][::std::mem::size_of::<drm_mode_get_lease>() - 16usize];
    ["Alignment of drm_mode_get_lease"][::std::mem::align_of::<drm_mode_get_lease>() - 4usize];
    ["Offset of field: drm_mode_get_lease::count_objects"]
        [::std::mem::offset_of!(drm_mode_get_lease, count_objects) - 0usize];
    ["Offset of field: drm_mode_get_lease::pad"]
        [::std::mem::offset_of!(drm_mode_get_lease, pad) - 4usize];
    ["Offset of field: drm_mode_get_lease::objects_ptr"]
        [::std::mem::offset_of!(drm_mode_get_lease, objects_ptr) - 8usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_revoke_lease {
    pub lessee_id: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_revoke_lease"][::std::mem::size_of::<drm_mode_revoke_lease>() - 4usize];
    ["Alignment of drm_mode_revoke_lease"]
        [::std::mem::align_of::<drm_mode_revoke_lease>() - 4usize];
    ["Offset of field: drm_mode_revoke_lease::lessee_id"]
        [::std::mem::offset_of!(drm_mode_revoke_lease, lessee_id) - 0usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_rect {
    pub x1: __s32,
    pub y1: __s32,
    pub x2: __s32,
    pub y2: __s32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_rect"][::std::mem::size_of::<drm_mode_rect>() - 16usize];
    ["Alignment of drm_mode_rect"][::std::mem::align_of::<drm_mode_rect>() - 4usize];
    ["Offset of field: drm_mode_rect::x1"][::std::mem::offset_of!(drm_mode_rect, x1) - 0usize];
    ["Offset of field: drm_mode_rect::y1"][::std::mem::offset_of!(drm_mode_rect, y1) - 4usize];
    ["Offset of field: drm_mode_rect::x2"][::std::mem::offset_of!(drm_mode_rect, x2) - 8usize];
    ["Offset of field: drm_mode_rect::y2"][::std::mem::offset_of!(drm_mode_rect, y2) - 12usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_mode_closefb {
    pub fb_id: __u32,
    pub pad: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_closefb"][::std::mem::size_of::<drm_mode_closefb>() - 8usize];
    ["Alignment of drm_mode_closefb"][::std::mem::align_of::<drm_mode_closefb>() - 4usize];
    ["Offset of field: drm_mode_closefb::fb_id"]
        [::std::mem::offset_of!(drm_mode_closefb, fb_id) - 0usize];
    ["Offset of field: drm_mode_closefb::pad"]
        [::std::mem::offset_of!(drm_mode_closefb, pad) - 4usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_event {
    pub type_: __u32,
    pub length: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_event"][::std::mem::size_of::<drm_event>() - 8usize];
    ["Alignment of drm_event"][::std::mem::align_of::<drm_event>() - 4usize];
    ["Offset of field: drm_event::type_"][::std::mem::offset_of!(drm_event, type_) - 0usize];
    ["Offset of field: drm_event::length"][::std::mem::offset_of!(drm_event, length) - 4usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_event_vblank {
    pub base: drm_event,
    pub user_data: __u64,
    pub tv_sec: __u32,
    pub tv_usec: __u32,
    pub sequence: __u32,
    pub crtc_id: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_event_vblank"][::std::mem::size_of::<drm_event_vblank>() - 32usize];
    ["Alignment of drm_event_vblank"][::std::mem::align_of::<drm_event_vblank>() - 4usize];
    ["Offset of field: drm_event_vblank::base"]
        [::std::mem::offset_of!(drm_event_vblank, base) - 0usize];
    ["Offset of field: drm_event_vblank::user_data"]
        [::std::mem::offset_of!(drm_event_vblank, user_data) - 8usize];
    ["Offset of field: drm_event_vblank::tv_sec"]
        [::std::mem::offset_of!(drm_event_vblank, tv_sec) - 16usize];
    ["Offset of field: drm_event_vblank::tv_usec"]
        [::std::mem::offset_of!(drm_event_vblank, tv_usec) - 20usize];
    ["Offset of field: drm_event_vblank::sequence"]
        [::std::mem::offset_of!(drm_event_vblank, sequence) - 24usize];
    ["Offset of field: drm_event_vblank::crtc_id"]
        [::std::mem::offset_of!(drm_event_vblank, crtc_id) - 28usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_event_crtc_sequence {
    pub base: drm_event,
    pub user_data: __u64,
    pub time_ns: __s64,
    pub sequence: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_event_crtc_sequence"][::std::mem::size_of::<drm_event_crtc_sequence>() - 32usize];
    ["Alignment of drm_event_crtc_sequence"]
        [::std::mem::align_of::<drm_event_crtc_sequence>() - 4usize];
    ["Offset of field: drm_event_crtc_sequence::base"]
        [::std::mem::offset_of!(drm_event_crtc_sequence, base) - 0usize];
    ["Offset of field: drm_event_crtc_sequence::user_data"]
        [::std::mem::offset_of!(drm_event_crtc_sequence, user_data) - 8usize];
    ["Offset of field: drm_event_crtc_sequence::time_ns"]
        [::std::mem::offset_of!(drm_event_crtc_sequence, time_ns) - 16usize];
    ["Offset of field: drm_event_crtc_sequence::sequence"]
        [::std::mem::offset_of!(drm_event_crtc_sequence, sequence) - 24usize];
};
pub type drm_clip_rect_t = drm_clip_rect;
pub type drm_drawable_info_t = drm_drawable_info;
pub type drm_tex_region_t = drm_tex_region;
pub type drm_hw_lock_t = drm_hw_lock;
pub type drm_version_t = drm_version;
pub type drm_unique_t = drm_unique;
pub type drm_list_t = drm_list;
pub type drm_block_t = drm_block;
pub type drm_control_t = drm_control;
pub use self::drm_map_flags as drm_map_flags_t;
pub use self::drm_map_type as drm_map_type_t;
pub type drm_ctx_priv_map_t = drm_ctx_priv_map;
pub type drm_map_t = drm_map;
pub type drm_client_t = drm_client;
pub use self::drm_stat_type as drm_stat_type_t;
pub type drm_stats_t = drm_stats;
pub use self::drm_lock_flags as drm_lock_flags_t;
pub type drm_lock_t = drm_lock;
pub use self::drm_dma_flags as drm_dma_flags_t;
pub type drm_buf_desc_t = drm_buf_desc;
pub type drm_buf_info_t = drm_buf_info;
pub type drm_buf_free_t = drm_buf_free;
pub type drm_buf_pub_t = drm_buf_pub;
pub type drm_buf_map_t = drm_buf_map;
pub type drm_dma_t = drm_dma;
pub type drm_wait_vblank_t = drm_wait_vblank;
pub type drm_agp_mode_t = drm_agp_mode;
pub use self::drm_ctx_flags as drm_ctx_flags_t;
pub type drm_ctx_t = drm_ctx;
pub type drm_ctx_res_t = drm_ctx_res;
pub type drm_draw_t = drm_draw;
pub type drm_update_draw_t = drm_update_draw;
pub type drm_auth_t = drm_auth;
pub type drm_irq_busid_t = drm_irq_busid;
pub use self::drm_vblank_seq_type as drm_vblank_seq_type_t;
pub type drm_agp_buffer_t = drm_agp_buffer;
pub type drm_agp_binding_t = drm_agp_binding;
pub type drm_agp_info_t = drm_agp_info;
pub type drm_scatter_gather_t = drm_scatter_gather;
pub type drm_set_version_t = drm_set_version;
pub type drmSize = ::std::os::raw::c_uint;
pub type drmSizePtr = *mut ::std::os::raw::c_uint;
pub type drmAddress = *mut ::std::os::raw::c_void;
pub type drmAddressPtr = *mut *mut ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _drmServerInfo {
    pub debug_print: ::std::option::Option<
        unsafe extern "C" fn(
            format: *const ::std::os::raw::c_char,
            ap: va_list,
        ) -> ::std::os::raw::c_int,
    >,
    pub load_module: ::std::option::Option<
        unsafe extern "C" fn(name: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int,
    >,
    pub get_perms: ::std::option::Option<unsafe extern "C" fn(arg1: *mut gid_t, arg2: *mut mode_t)>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmServerInfo"][::std::mem::size_of::<_drmServerInfo>() - 12usize];
    ["Alignment of _drmServerInfo"][::std::mem::align_of::<_drmServerInfo>() - 4usize];
    ["Offset of field: _drmServerInfo::debug_print"]
        [::std::mem::offset_of!(_drmServerInfo, debug_print) - 0usize];
    ["Offset of field: _drmServerInfo::load_module"]
        [::std::mem::offset_of!(_drmServerInfo, load_module) - 4usize];
    ["Offset of field: _drmServerInfo::get_perms"]
        [::std::mem::offset_of!(_drmServerInfo, get_perms) - 8usize];
};
pub type drmServerInfo = _drmServerInfo;
pub type drmServerInfoPtr = *mut _drmServerInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drmHashEntry {
    pub fd: ::std::os::raw::c_int,
    pub f: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: *mut ::std::os::raw::c_void,
            arg3: *mut ::std::os::raw::c_void,
        ),
    >,
    pub tagTable: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drmHashEntry"][::std::mem::size_of::<drmHashEntry>() - 12usize];
    ["Alignment of drmHashEntry"][::std::mem::align_of::<drmHashEntry>() - 4usize];
    ["Offset of field: drmHashEntry::fd"][::std::mem::offset_of!(drmHashEntry, fd) - 0usize];
    ["Offset of field: drmHashEntry::f"][::std::mem::offset_of!(drmHashEntry, f) - 4usize];
    ["Offset of field: drmHashEntry::tagTable"]
        [::std::mem::offset_of!(drmHashEntry, tagTable) - 8usize];
};
impl Default for drmHashEntry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn drmIoctl(
        fd: ::std::os::raw::c_int,
        request: ::std::os::raw::c_ulong,
        arg: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmGetHashTable() -> *mut ::std::os::raw::c_void;
}
unsafe extern "C" {
    pub fn drmGetEntry(fd: ::std::os::raw::c_int) -> *mut drmHashEntry;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmVersion {
    pub version_major: ::std::os::raw::c_int,
    pub version_minor: ::std::os::raw::c_int,
    pub version_patchlevel: ::std::os::raw::c_int,
    pub name_len: ::std::os::raw::c_int,
    pub name: *mut ::std::os::raw::c_char,
    pub date_len: ::std::os::raw::c_int,
    pub date: *mut ::std::os::raw::c_char,
    pub desc_len: ::std::os::raw::c_int,
    pub desc: *mut ::std::os::raw::c_char,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmVersion"][::std::mem::size_of::<_drmVersion>() - 36usize];
    ["Alignment of _drmVersion"][::std::mem::align_of::<_drmVersion>() - 4usize];
    ["Offset of field: _drmVersion::version_major"]
        [::std::mem::offset_of!(_drmVersion, version_major) - 0usize];
    ["Offset of field: _drmVersion::version_minor"]
        [::std::mem::offset_of!(_drmVersion, version_minor) - 4usize];
    ["Offset of field: _drmVersion::version_patchlevel"]
        [::std::mem::offset_of!(_drmVersion, version_patchlevel) - 8usize];
    ["Offset of field: _drmVersion::name_len"]
        [::std::mem::offset_of!(_drmVersion, name_len) - 12usize];
    ["Offset of field: _drmVersion::name"][::std::mem::offset_of!(_drmVersion, name) - 16usize];
    ["Offset of field: _drmVersion::date_len"]
        [::std::mem::offset_of!(_drmVersion, date_len) - 20usize];
    ["Offset of field: _drmVersion::date"][::std::mem::offset_of!(_drmVersion, date) - 24usize];
    ["Offset of field: _drmVersion::desc_len"]
        [::std::mem::offset_of!(_drmVersion, desc_len) - 28usize];
    ["Offset of field: _drmVersion::desc"][::std::mem::offset_of!(_drmVersion, desc) - 32usize];
};
impl Default for _drmVersion {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type drmVersion = _drmVersion;
pub type drmVersionPtr = *mut _drmVersion;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmStats {
    pub count: ::std::os::raw::c_ulong,
    pub data: [_drmStats__bindgen_ty_1; 15usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmStats__bindgen_ty_1 {
    pub value: ::std::os::raw::c_ulong,
    pub long_format: *const ::std::os::raw::c_char,
    pub long_name: *const ::std::os::raw::c_char,
    pub rate_format: *const ::std::os::raw::c_char,
    pub rate_name: *const ::std::os::raw::c_char,
    pub isvalue: ::std::os::raw::c_int,
    pub mult_names: *const ::std::os::raw::c_char,
    pub mult: ::std::os::raw::c_int,
    pub verbose: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmStats__bindgen_ty_1"][::std::mem::size_of::<_drmStats__bindgen_ty_1>() - 36usize];
    ["Alignment of _drmStats__bindgen_ty_1"]
        [::std::mem::align_of::<_drmStats__bindgen_ty_1>() - 4usize];
    ["Offset of field: _drmStats__bindgen_ty_1::value"]
        [::std::mem::offset_of!(_drmStats__bindgen_ty_1, value) - 0usize];
    ["Offset of field: _drmStats__bindgen_ty_1::long_format"]
        [::std::mem::offset_of!(_drmStats__bindgen_ty_1, long_format) - 4usize];
    ["Offset of field: _drmStats__bindgen_ty_1::long_name"]
        [::std::mem::offset_of!(_drmStats__bindgen_ty_1, long_name) - 8usize];
    ["Offset of field: _drmStats__bindgen_ty_1::rate_format"]
        [::std::mem::offset_of!(_drmStats__bindgen_ty_1, rate_format) - 12usize];
    ["Offset of field: _drmStats__bindgen_ty_1::rate_name"]
        [::std::mem::offset_of!(_drmStats__bindgen_ty_1, rate_name) - 16usize];
    ["Offset of field: _drmStats__bindgen_ty_1::isvalue"]
        [::std::mem::offset_of!(_drmStats__bindgen_ty_1, isvalue) - 20usize];
    ["Offset of field: _drmStats__bindgen_ty_1::mult_names"]
        [::std::mem::offset_of!(_drmStats__bindgen_ty_1, mult_names) - 24usize];
    ["Offset of field: _drmStats__bindgen_ty_1::mult"]
        [::std::mem::offset_of!(_drmStats__bindgen_ty_1, mult) - 28usize];
    ["Offset of field: _drmStats__bindgen_ty_1::verbose"]
        [::std::mem::offset_of!(_drmStats__bindgen_ty_1, verbose) - 32usize];
};
impl Default for _drmStats__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmStats"][::std::mem::size_of::<_drmStats>() - 544usize];
    ["Alignment of _drmStats"][::std::mem::align_of::<_drmStats>() - 4usize];
    ["Offset of field: _drmStats::count"][::std::mem::offset_of!(_drmStats, count) - 0usize];
    ["Offset of field: _drmStats::data"][::std::mem::offset_of!(_drmStats, data) - 4usize];
};
impl Default for _drmStats {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type drmStatsT = _drmStats;
pub const DRM_FRAME_BUFFER: drmMapType = 0;
pub const DRM_REGISTERS: drmMapType = 1;
pub const DRM_SHM: drmMapType = 2;
pub const DRM_AGP: drmMapType = 3;
pub const DRM_SCATTER_GATHER: drmMapType = 4;
pub const DRM_CONSISTENT: drmMapType = 5;
pub type drmMapType = ::std::os::raw::c_uint;
pub const DRM_RESTRICTED: drmMapFlags = 1;
pub const DRM_READ_ONLY: drmMapFlags = 2;
pub const DRM_LOCKED: drmMapFlags = 4;
pub const DRM_KERNEL: drmMapFlags = 8;
pub const DRM_WRITE_COMBINING: drmMapFlags = 16;
pub const DRM_CONTAINS_LOCK: drmMapFlags = 32;
pub const DRM_REMOVABLE: drmMapFlags = 64;
pub type drmMapFlags = ::std::os::raw::c_uint;
pub const DRM_DMA_BLOCK: drmDMAFlags = 1;
pub const DRM_DMA_WHILE_LOCKED: drmDMAFlags = 2;
pub const DRM_DMA_PRIORITY: drmDMAFlags = 4;
pub const DRM_DMA_WAIT: drmDMAFlags = 16;
pub const DRM_DMA_SMALLER_OK: drmDMAFlags = 32;
pub const DRM_DMA_LARGER_OK: drmDMAFlags = 64;
pub type drmDMAFlags = ::std::os::raw::c_uint;
pub const DRM_PAGE_ALIGN: drmBufDescFlags = 1;
pub const DRM_AGP_BUFFER: drmBufDescFlags = 2;
pub const DRM_SG_BUFFER: drmBufDescFlags = 4;
pub const DRM_FB_BUFFER: drmBufDescFlags = 8;
pub const DRM_PCI_BUFFER_RO: drmBufDescFlags = 16;
pub type drmBufDescFlags = ::std::os::raw::c_uint;
pub const DRM_LOCK_READY: drmLockFlags = 1;
pub const DRM_LOCK_QUIESCENT: drmLockFlags = 2;
pub const DRM_LOCK_FLUSH: drmLockFlags = 4;
pub const DRM_LOCK_FLUSH_ALL: drmLockFlags = 8;
pub const DRM_HALT_ALL_QUEUES: drmLockFlags = 16;
pub const DRM_HALT_CUR_QUEUES: drmLockFlags = 32;
pub type drmLockFlags = ::std::os::raw::c_uint;
pub const DRM_CONTEXT_PRESERVED: drm_context_tFlags = 1;
pub const DRM_CONTEXT_2DONLY: drm_context_tFlags = 2;
pub type drm_context_tFlags = ::std::os::raw::c_uint;
pub type drm_context_tFlagsPtr = *mut drm_context_tFlags;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _drmBufDesc {
    pub count: ::std::os::raw::c_int,
    pub size: ::std::os::raw::c_int,
    pub low_mark: ::std::os::raw::c_int,
    pub high_mark: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmBufDesc"][::std::mem::size_of::<_drmBufDesc>() - 16usize];
    ["Alignment of _drmBufDesc"][::std::mem::align_of::<_drmBufDesc>() - 4usize];
    ["Offset of field: _drmBufDesc::count"][::std::mem::offset_of!(_drmBufDesc, count) - 0usize];
    ["Offset of field: _drmBufDesc::size"][::std::mem::offset_of!(_drmBufDesc, size) - 4usize];
    ["Offset of field: _drmBufDesc::low_mark"]
        [::std::mem::offset_of!(_drmBufDesc, low_mark) - 8usize];
    ["Offset of field: _drmBufDesc::high_mark"]
        [::std::mem::offset_of!(_drmBufDesc, high_mark) - 12usize];
};
pub type drmBufDesc = _drmBufDesc;
pub type drmBufDescPtr = *mut _drmBufDesc;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmBufInfo {
    pub count: ::std::os::raw::c_int,
    pub list: drmBufDescPtr,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmBufInfo"][::std::mem::size_of::<_drmBufInfo>() - 8usize];
    ["Alignment of _drmBufInfo"][::std::mem::align_of::<_drmBufInfo>() - 4usize];
    ["Offset of field: _drmBufInfo::count"][::std::mem::offset_of!(_drmBufInfo, count) - 0usize];
    ["Offset of field: _drmBufInfo::list"][::std::mem::offset_of!(_drmBufInfo, list) - 4usize];
};
impl Default for _drmBufInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type drmBufInfo = _drmBufInfo;
pub type drmBufInfoPtr = *mut _drmBufInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmBuf {
    pub idx: ::std::os::raw::c_int,
    pub total: ::std::os::raw::c_int,
    pub used: ::std::os::raw::c_int,
    pub address: drmAddress,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmBuf"][::std::mem::size_of::<_drmBuf>() - 16usize];
    ["Alignment of _drmBuf"][::std::mem::align_of::<_drmBuf>() - 4usize];
    ["Offset of field: _drmBuf::idx"][::std::mem::offset_of!(_drmBuf, idx) - 0usize];
    ["Offset of field: _drmBuf::total"][::std::mem::offset_of!(_drmBuf, total) - 4usize];
    ["Offset of field: _drmBuf::used"][::std::mem::offset_of!(_drmBuf, used) - 8usize];
    ["Offset of field: _drmBuf::address"][::std::mem::offset_of!(_drmBuf, address) - 12usize];
};
impl Default for _drmBuf {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type drmBuf = _drmBuf;
pub type drmBufPtr = *mut _drmBuf;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmBufMap {
    pub count: ::std::os::raw::c_int,
    pub list: drmBufPtr,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmBufMap"][::std::mem::size_of::<_drmBufMap>() - 8usize];
    ["Alignment of _drmBufMap"][::std::mem::align_of::<_drmBufMap>() - 4usize];
    ["Offset of field: _drmBufMap::count"][::std::mem::offset_of!(_drmBufMap, count) - 0usize];
    ["Offset of field: _drmBufMap::list"][::std::mem::offset_of!(_drmBufMap, list) - 4usize];
};
impl Default for _drmBufMap {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type drmBufMap = _drmBufMap;
pub type drmBufMapPtr = *mut _drmBufMap;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmLock {
    pub lock: ::std::os::raw::c_uint,
    pub padding: [::std::os::raw::c_char; 60usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmLock"][::std::mem::size_of::<_drmLock>() - 64usize];
    ["Alignment of _drmLock"][::std::mem::align_of::<_drmLock>() - 4usize];
    ["Offset of field: _drmLock::lock"][::std::mem::offset_of!(_drmLock, lock) - 0usize];
    ["Offset of field: _drmLock::padding"][::std::mem::offset_of!(_drmLock, padding) - 4usize];
};
impl Default for _drmLock {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type drmLock = _drmLock;
pub type drmLockPtr = *mut _drmLock;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmDMAReq {
    pub context: drm_context_t,
    pub send_count: ::std::os::raw::c_int,
    pub send_list: *mut ::std::os::raw::c_int,
    pub send_sizes: *mut ::std::os::raw::c_int,
    pub flags: drmDMAFlags,
    pub request_count: ::std::os::raw::c_int,
    pub request_size: ::std::os::raw::c_int,
    pub request_list: *mut ::std::os::raw::c_int,
    pub request_sizes: *mut ::std::os::raw::c_int,
    pub granted_count: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmDMAReq"][::std::mem::size_of::<_drmDMAReq>() - 40usize];
    ["Alignment of _drmDMAReq"][::std::mem::align_of::<_drmDMAReq>() - 4usize];
    ["Offset of field: _drmDMAReq::context"][::std::mem::offset_of!(_drmDMAReq, context) - 0usize];
    ["Offset of field: _drmDMAReq::send_count"]
        [::std::mem::offset_of!(_drmDMAReq, send_count) - 4usize];
    ["Offset of field: _drmDMAReq::send_list"]
        [::std::mem::offset_of!(_drmDMAReq, send_list) - 8usize];
    ["Offset of field: _drmDMAReq::send_sizes"]
        [::std::mem::offset_of!(_drmDMAReq, send_sizes) - 12usize];
    ["Offset of field: _drmDMAReq::flags"][::std::mem::offset_of!(_drmDMAReq, flags) - 16usize];
    ["Offset of field: _drmDMAReq::request_count"]
        [::std::mem::offset_of!(_drmDMAReq, request_count) - 20usize];
    ["Offset of field: _drmDMAReq::request_size"]
        [::std::mem::offset_of!(_drmDMAReq, request_size) - 24usize];
    ["Offset of field: _drmDMAReq::request_list"]
        [::std::mem::offset_of!(_drmDMAReq, request_list) - 28usize];
    ["Offset of field: _drmDMAReq::request_sizes"]
        [::std::mem::offset_of!(_drmDMAReq, request_sizes) - 32usize];
    ["Offset of field: _drmDMAReq::granted_count"]
        [::std::mem::offset_of!(_drmDMAReq, granted_count) - 36usize];
};
impl Default for _drmDMAReq {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type drmDMAReq = _drmDMAReq;
pub type drmDMAReqPtr = *mut _drmDMAReq;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmRegion {
    pub handle: drm_handle_t,
    pub offset: ::std::os::raw::c_uint,
    pub size: drmSize,
    pub map: drmAddress,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmRegion"][::std::mem::size_of::<_drmRegion>() - 16usize];
    ["Alignment of _drmRegion"][::std::mem::align_of::<_drmRegion>() - 4usize];
    ["Offset of field: _drmRegion::handle"][::std::mem::offset_of!(_drmRegion, handle) - 0usize];
    ["Offset of field: _drmRegion::offset"][::std::mem::offset_of!(_drmRegion, offset) - 4usize];
    ["Offset of field: _drmRegion::size"][::std::mem::offset_of!(_drmRegion, size) - 8usize];
    ["Offset of field: _drmRegion::map"][::std::mem::offset_of!(_drmRegion, map) - 12usize];
};
impl Default for _drmRegion {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type drmRegion = _drmRegion;
pub type drmRegionPtr = *mut _drmRegion;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _drmTextureRegion {
    pub next: ::std::os::raw::c_uchar,
    pub prev: ::std::os::raw::c_uchar,
    pub in_use: ::std::os::raw::c_uchar,
    pub padding: ::std::os::raw::c_uchar,
    pub age: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmTextureRegion"][::std::mem::size_of::<_drmTextureRegion>() - 8usize];
    ["Alignment of _drmTextureRegion"][::std::mem::align_of::<_drmTextureRegion>() - 4usize];
    ["Offset of field: _drmTextureRegion::next"]
        [::std::mem::offset_of!(_drmTextureRegion, next) - 0usize];
    ["Offset of field: _drmTextureRegion::prev"]
        [::std::mem::offset_of!(_drmTextureRegion, prev) - 1usize];
    ["Offset of field: _drmTextureRegion::in_use"]
        [::std::mem::offset_of!(_drmTextureRegion, in_use) - 2usize];
    ["Offset of field: _drmTextureRegion::padding"]
        [::std::mem::offset_of!(_drmTextureRegion, padding) - 3usize];
    ["Offset of field: _drmTextureRegion::age"]
        [::std::mem::offset_of!(_drmTextureRegion, age) - 4usize];
};
pub type drmTextureRegion = _drmTextureRegion;
pub type drmTextureRegionPtr = *mut _drmTextureRegion;
pub const DRM_VBLANK_ABSOLUTE: drmVBlankSeqType = 0;
pub const DRM_VBLANK_RELATIVE: drmVBlankSeqType = 1;
pub const DRM_VBLANK_HIGH_CRTC_MASK: drmVBlankSeqType = 62;
pub const DRM_VBLANK_EVENT: drmVBlankSeqType = 67108864;
pub const DRM_VBLANK_FLIP: drmVBlankSeqType = 134217728;
pub const DRM_VBLANK_NEXTONMISS: drmVBlankSeqType = 268435456;
pub const DRM_VBLANK_SECONDARY: drmVBlankSeqType = 536870912;
pub const DRM_VBLANK_SIGNAL: drmVBlankSeqType = 1073741824;
pub type drmVBlankSeqType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmVBlankReq {
    pub type_: drmVBlankSeqType,
    pub sequence: ::std::os::raw::c_uint,
    pub signal: ::std::os::raw::c_ulong,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmVBlankReq"][::std::mem::size_of::<_drmVBlankReq>() - 12usize];
    ["Alignment of _drmVBlankReq"][::std::mem::align_of::<_drmVBlankReq>() - 4usize];
    ["Offset of field: _drmVBlankReq::type_"]
        [::std::mem::offset_of!(_drmVBlankReq, type_) - 0usize];
    ["Offset of field: _drmVBlankReq::sequence"]
        [::std::mem::offset_of!(_drmVBlankReq, sequence) - 4usize];
    ["Offset of field: _drmVBlankReq::signal"]
        [::std::mem::offset_of!(_drmVBlankReq, signal) - 8usize];
};
impl Default for _drmVBlankReq {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type drmVBlankReq = _drmVBlankReq;
pub type drmVBlankReqPtr = *mut _drmVBlankReq;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmVBlankReply {
    pub type_: drmVBlankSeqType,
    pub sequence: ::std::os::raw::c_uint,
    pub tval_sec: ::std::os::raw::c_long,
    pub tval_usec: ::std::os::raw::c_long,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmVBlankReply"][::std::mem::size_of::<_drmVBlankReply>() - 16usize];
    ["Alignment of _drmVBlankReply"][::std::mem::align_of::<_drmVBlankReply>() - 4usize];
    ["Offset of field: _drmVBlankReply::type_"]
        [::std::mem::offset_of!(_drmVBlankReply, type_) - 0usize];
    ["Offset of field: _drmVBlankReply::sequence"]
        [::std::mem::offset_of!(_drmVBlankReply, sequence) - 4usize];
    ["Offset of field: _drmVBlankReply::tval_sec"]
        [::std::mem::offset_of!(_drmVBlankReply, tval_sec) - 8usize];
    ["Offset of field: _drmVBlankReply::tval_usec"]
        [::std::mem::offset_of!(_drmVBlankReply, tval_usec) - 12usize];
};
impl Default for _drmVBlankReply {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type drmVBlankReply = _drmVBlankReply;
pub type drmVBlankReplyPtr = *mut _drmVBlankReply;
#[repr(C)]
#[derive(Copy, Clone)]
pub union _drmVBlank {
    pub request: drmVBlankReq,
    pub reply: drmVBlankReply,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmVBlank"][::std::mem::size_of::<_drmVBlank>() - 16usize];
    ["Alignment of _drmVBlank"][::std::mem::align_of::<_drmVBlank>() - 4usize];
    ["Offset of field: _drmVBlank::request"][::std::mem::offset_of!(_drmVBlank, request) - 0usize];
    ["Offset of field: _drmVBlank::reply"][::std::mem::offset_of!(_drmVBlank, reply) - 0usize];
};
impl Default for _drmVBlank {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type drmVBlank = _drmVBlank;
pub type drmVBlankPtr = *mut _drmVBlank;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _drmSetVersion {
    pub drm_di_major: ::std::os::raw::c_int,
    pub drm_di_minor: ::std::os::raw::c_int,
    pub drm_dd_major: ::std::os::raw::c_int,
    pub drm_dd_minor: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmSetVersion"][::std::mem::size_of::<_drmSetVersion>() - 16usize];
    ["Alignment of _drmSetVersion"][::std::mem::align_of::<_drmSetVersion>() - 4usize];
    ["Offset of field: _drmSetVersion::drm_di_major"]
        [::std::mem::offset_of!(_drmSetVersion, drm_di_major) - 0usize];
    ["Offset of field: _drmSetVersion::drm_di_minor"]
        [::std::mem::offset_of!(_drmSetVersion, drm_di_minor) - 4usize];
    ["Offset of field: _drmSetVersion::drm_dd_major"]
        [::std::mem::offset_of!(_drmSetVersion, drm_dd_major) - 8usize];
    ["Offset of field: _drmSetVersion::drm_dd_minor"]
        [::std::mem::offset_of!(_drmSetVersion, drm_dd_minor) - 12usize];
};
pub type drmSetVersion = _drmSetVersion;
pub type drmSetVersionPtr = *mut _drmSetVersion;
unsafe extern "C" {
    pub fn drmAvailable() -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmOpen(
        name: *const ::std::os::raw::c_char,
        busid: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmOpenWithType(
        name: *const ::std::os::raw::c_char,
        busid: *const ::std::os::raw::c_char,
        type_: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmOpenControl(minor: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmOpenRender(minor: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmClose(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmGetVersion(fd: ::std::os::raw::c_int) -> drmVersionPtr;
}
unsafe extern "C" {
    pub fn drmGetLibVersion(fd: ::std::os::raw::c_int) -> drmVersionPtr;
}
unsafe extern "C" {
    pub fn drmGetCap(
        fd: ::std::os::raw::c_int,
        capability: u64,
        value: *mut u64,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmFreeVersion(arg1: drmVersionPtr);
}
unsafe extern "C" {
    pub fn drmGetMagic(fd: ::std::os::raw::c_int, magic: *mut drm_magic_t)
        -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmGetBusid(fd: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn drmGetInterruptFromBusID(
        fd: ::std::os::raw::c_int,
        busnum: ::std::os::raw::c_int,
        devnum: ::std::os::raw::c_int,
        funcnum: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmGetMap(
        fd: ::std::os::raw::c_int,
        idx: ::std::os::raw::c_int,
        offset: *mut drm_handle_t,
        size: *mut drmSize,
        type_: *mut drmMapType,
        flags: *mut drmMapFlags,
        handle: *mut drm_handle_t,
        mtrr: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmGetClient(
        fd: ::std::os::raw::c_int,
        idx: ::std::os::raw::c_int,
        auth: *mut ::std::os::raw::c_int,
        pid: *mut ::std::os::raw::c_int,
        uid: *mut ::std::os::raw::c_int,
        magic: *mut ::std::os::raw::c_ulong,
        iocs: *mut ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmGetStats(fd: ::std::os::raw::c_int, stats: *mut drmStatsT) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmSetInterfaceVersion(
        fd: ::std::os::raw::c_int,
        version: *mut drmSetVersion,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmCommandNone(
        fd: ::std::os::raw::c_int,
        drmCommandIndex: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmCommandRead(
        fd: ::std::os::raw::c_int,
        drmCommandIndex: ::std::os::raw::c_ulong,
        data: *mut ::std::os::raw::c_void,
        size: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmCommandWrite(
        fd: ::std::os::raw::c_int,
        drmCommandIndex: ::std::os::raw::c_ulong,
        data: *mut ::std::os::raw::c_void,
        size: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmCommandWriteRead(
        fd: ::std::os::raw::c_int,
        drmCommandIndex: ::std::os::raw::c_ulong,
        data: *mut ::std::os::raw::c_void,
        size: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmFreeBusid(busid: *const ::std::os::raw::c_char);
}
unsafe extern "C" {
    pub fn drmSetBusid(
        fd: ::std::os::raw::c_int,
        busid: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmAuthMagic(fd: ::std::os::raw::c_int, magic: drm_magic_t) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmAddMap(
        fd: ::std::os::raw::c_int,
        offset: drm_handle_t,
        size: drmSize,
        type_: drmMapType,
        flags: drmMapFlags,
        handle: *mut drm_handle_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmRmMap(fd: ::std::os::raw::c_int, handle: drm_handle_t) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmAddContextPrivateMapping(
        fd: ::std::os::raw::c_int,
        ctx_id: drm_context_t,
        handle: drm_handle_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmAddBufs(
        fd: ::std::os::raw::c_int,
        count: ::std::os::raw::c_int,
        size: ::std::os::raw::c_int,
        flags: drmBufDescFlags,
        agp_offset: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmMarkBufs(fd: ::std::os::raw::c_int, low: f64, high: f64) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmCreateContext(
        fd: ::std::os::raw::c_int,
        handle: *mut drm_context_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmSetContextFlags(
        fd: ::std::os::raw::c_int,
        context: drm_context_t,
        flags: drm_context_tFlags,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmGetContextFlags(
        fd: ::std::os::raw::c_int,
        context: drm_context_t,
        flags: drm_context_tFlagsPtr,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmAddContextTag(
        fd: ::std::os::raw::c_int,
        context: drm_context_t,
        tag: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmDelContextTag(
        fd: ::std::os::raw::c_int,
        context: drm_context_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmGetContextTag(
        fd: ::std::os::raw::c_int,
        context: drm_context_t,
    ) -> *mut ::std::os::raw::c_void;
}
unsafe extern "C" {
    pub fn drmGetReservedContextList(
        fd: ::std::os::raw::c_int,
        count: *mut ::std::os::raw::c_int,
    ) -> *mut drm_context_t;
}
unsafe extern "C" {
    pub fn drmFreeReservedContextList(arg1: *mut drm_context_t);
}
unsafe extern "C" {
    pub fn drmSwitchToContext(
        fd: ::std::os::raw::c_int,
        context: drm_context_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmDestroyContext(
        fd: ::std::os::raw::c_int,
        handle: drm_context_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmCreateDrawable(
        fd: ::std::os::raw::c_int,
        handle: *mut drm_drawable_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmDestroyDrawable(
        fd: ::std::os::raw::c_int,
        handle: drm_drawable_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmUpdateDrawableInfo(
        fd: ::std::os::raw::c_int,
        handle: drm_drawable_t,
        type_: drm_drawable_info_type_t,
        num: ::std::os::raw::c_uint,
        data: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmCtlInstHandler(
        fd: ::std::os::raw::c_int,
        irq: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmCtlUninstHandler(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmSetClientCap(
        fd: ::std::os::raw::c_int,
        capability: u64,
        value: u64,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmCrtcGetSequence(
        fd: ::std::os::raw::c_int,
        crtcId: u32,
        sequence: *mut u64,
        ns: *mut u64,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmCrtcQueueSequence(
        fd: ::std::os::raw::c_int,
        crtcId: u32,
        flags: u32,
        sequence: u64,
        sequence_queued: *mut u64,
        user_data: u64,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmMap(
        fd: ::std::os::raw::c_int,
        handle: drm_handle_t,
        size: drmSize,
        address: drmAddressPtr,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmUnmap(address: drmAddress, size: drmSize) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmGetBufInfo(fd: ::std::os::raw::c_int) -> drmBufInfoPtr;
}
unsafe extern "C" {
    pub fn drmMapBufs(fd: ::std::os::raw::c_int) -> drmBufMapPtr;
}
unsafe extern "C" {
    pub fn drmUnmapBufs(bufs: drmBufMapPtr) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmDMA(fd: ::std::os::raw::c_int, request: drmDMAReqPtr) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmFreeBufs(
        fd: ::std::os::raw::c_int,
        count: ::std::os::raw::c_int,
        list: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmGetLock(
        fd: ::std::os::raw::c_int,
        context: drm_context_t,
        flags: drmLockFlags,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmUnlock(fd: ::std::os::raw::c_int, context: drm_context_t) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmFinish(
        fd: ::std::os::raw::c_int,
        context: ::std::os::raw::c_int,
        flags: drmLockFlags,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmGetContextPrivateMapping(
        fd: ::std::os::raw::c_int,
        ctx_id: drm_context_t,
        handle: *mut drm_handle_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmAgpAcquire(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmAgpRelease(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmAgpEnable(
        fd: ::std::os::raw::c_int,
        mode: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmAgpAlloc(
        fd: ::std::os::raw::c_int,
        size: ::std::os::raw::c_ulong,
        type_: ::std::os::raw::c_ulong,
        address: *mut ::std::os::raw::c_ulong,
        handle: *mut drm_handle_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmAgpFree(fd: ::std::os::raw::c_int, handle: drm_handle_t) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmAgpBind(
        fd: ::std::os::raw::c_int,
        handle: drm_handle_t,
        offset: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmAgpUnbind(fd: ::std::os::raw::c_int, handle: drm_handle_t) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmAgpVersionMajor(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmAgpVersionMinor(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmAgpGetMode(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_ulong;
}
unsafe extern "C" {
    pub fn drmAgpBase(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_ulong;
}
unsafe extern "C" {
    pub fn drmAgpSize(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_ulong;
}
unsafe extern "C" {
    pub fn drmAgpMemoryUsed(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_ulong;
}
unsafe extern "C" {
    pub fn drmAgpMemoryAvail(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_ulong;
}
unsafe extern "C" {
    pub fn drmAgpVendorId(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn drmAgpDeviceId(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn drmScatterGatherAlloc(
        fd: ::std::os::raw::c_int,
        size: ::std::os::raw::c_ulong,
        handle: *mut drm_handle_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmScatterGatherFree(
        fd: ::std::os::raw::c_int,
        handle: drm_handle_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmWaitVBlank(fd: ::std::os::raw::c_int, vbl: drmVBlankPtr) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmSetServerInfo(info: drmServerInfoPtr);
}
unsafe extern "C" {
    pub fn drmError(
        err: ::std::os::raw::c_int,
        label: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmMalloc(size: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_void;
}
unsafe extern "C" {
    pub fn drmFree(pt: *mut ::std::os::raw::c_void);
}
unsafe extern "C" {
    pub fn drmHashCreate() -> *mut ::std::os::raw::c_void;
}
unsafe extern "C" {
    pub fn drmHashDestroy(t: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmHashLookup(
        t: *mut ::std::os::raw::c_void,
        key: ::std::os::raw::c_ulong,
        value: *mut *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmHashInsert(
        t: *mut ::std::os::raw::c_void,
        key: ::std::os::raw::c_ulong,
        value: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmHashDelete(
        t: *mut ::std::os::raw::c_void,
        key: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmHashFirst(
        t: *mut ::std::os::raw::c_void,
        key: *mut ::std::os::raw::c_ulong,
        value: *mut *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmHashNext(
        t: *mut ::std::os::raw::c_void,
        key: *mut ::std::os::raw::c_ulong,
        value: *mut *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmRandomCreate(seed: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void;
}
unsafe extern "C" {
    pub fn drmRandomDestroy(state: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmRandom(state: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_ulong;
}
unsafe extern "C" {
    pub fn drmRandomDouble(state: *mut ::std::os::raw::c_void) -> f64;
}
unsafe extern "C" {
    pub fn drmSLCreate() -> *mut ::std::os::raw::c_void;
}
unsafe extern "C" {
    pub fn drmSLDestroy(l: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmSLLookup(
        l: *mut ::std::os::raw::c_void,
        key: ::std::os::raw::c_ulong,
        value: *mut *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmSLInsert(
        l: *mut ::std::os::raw::c_void,
        key: ::std::os::raw::c_ulong,
        value: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmSLDelete(
        l: *mut ::std::os::raw::c_void,
        key: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmSLNext(
        l: *mut ::std::os::raw::c_void,
        key: *mut ::std::os::raw::c_ulong,
        value: *mut *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmSLFirst(
        l: *mut ::std::os::raw::c_void,
        key: *mut ::std::os::raw::c_ulong,
        value: *mut *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmSLDump(l: *mut ::std::os::raw::c_void);
}
unsafe extern "C" {
    pub fn drmSLLookupNeighbors(
        l: *mut ::std::os::raw::c_void,
        key: ::std::os::raw::c_ulong,
        prev_key: *mut ::std::os::raw::c_ulong,
        prev_value: *mut *mut ::std::os::raw::c_void,
        next_key: *mut ::std::os::raw::c_ulong,
        next_value: *mut *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmOpenOnce(
        unused: *mut ::std::os::raw::c_void,
        BusID: *const ::std::os::raw::c_char,
        newlyopened: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmOpenOnceWithType(
        BusID: *const ::std::os::raw::c_char,
        newlyopened: *mut ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmCloseOnce(fd: ::std::os::raw::c_int);
}
unsafe extern "C" {
    pub fn drmMsg(format: *const ::std::os::raw::c_char, ...);
}
unsafe extern "C" {
    pub fn drmSetMaster(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmDropMaster(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmIsMaster(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _drmEventContext {
    pub version: ::std::os::raw::c_int,
    pub vblank_handler: ::std::option::Option<
        unsafe extern "C" fn(
            fd: ::std::os::raw::c_int,
            sequence: ::std::os::raw::c_uint,
            tv_sec: ::std::os::raw::c_uint,
            tv_usec: ::std::os::raw::c_uint,
            user_data: *mut ::std::os::raw::c_void,
        ),
    >,
    pub page_flip_handler: ::std::option::Option<
        unsafe extern "C" fn(
            fd: ::std::os::raw::c_int,
            sequence: ::std::os::raw::c_uint,
            tv_sec: ::std::os::raw::c_uint,
            tv_usec: ::std::os::raw::c_uint,
            user_data: *mut ::std::os::raw::c_void,
        ),
    >,
    pub page_flip_handler2: ::std::option::Option<
        unsafe extern "C" fn(
            fd: ::std::os::raw::c_int,
            sequence: ::std::os::raw::c_uint,
            tv_sec: ::std::os::raw::c_uint,
            tv_usec: ::std::os::raw::c_uint,
            crtc_id: ::std::os::raw::c_uint,
            user_data: *mut ::std::os::raw::c_void,
        ),
    >,
    pub sequence_handler: ::std::option::Option<
        unsafe extern "C" fn(fd: ::std::os::raw::c_int, sequence: u64, ns: u64, user_data: u64),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmEventContext"][::std::mem::size_of::<_drmEventContext>() - 20usize];
    ["Alignment of _drmEventContext"][::std::mem::align_of::<_drmEventContext>() - 4usize];
    ["Offset of field: _drmEventContext::version"]
        [::std::mem::offset_of!(_drmEventContext, version) - 0usize];
    ["Offset of field: _drmEventContext::vblank_handler"]
        [::std::mem::offset_of!(_drmEventContext, vblank_handler) - 4usize];
    ["Offset of field: _drmEventContext::page_flip_handler"]
        [::std::mem::offset_of!(_drmEventContext, page_flip_handler) - 8usize];
    ["Offset of field: _drmEventContext::page_flip_handler2"]
        [::std::mem::offset_of!(_drmEventContext, page_flip_handler2) - 12usize];
    ["Offset of field: _drmEventContext::sequence_handler"]
        [::std::mem::offset_of!(_drmEventContext, sequence_handler) - 16usize];
};
pub type drmEventContext = _drmEventContext;
pub type drmEventContextPtr = *mut _drmEventContext;
unsafe extern "C" {
    pub fn drmHandleEvent(
        fd: ::std::os::raw::c_int,
        evctx: drmEventContextPtr,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmGetDeviceNameFromFd(fd: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn drmGetDeviceNameFromFd2(fd: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn drmGetNodeTypeFromFd(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmPrimeHandleToFD(
        fd: ::std::os::raw::c_int,
        handle: u32,
        flags: u32,
        prime_fd: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmPrimeFDToHandle(
        fd: ::std::os::raw::c_int,
        prime_fd: ::std::os::raw::c_int,
        handle: *mut u32,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmCloseBufferHandle(fd: ::std::os::raw::c_int, handle: u32) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmGetPrimaryDeviceNameFromFd(fd: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn drmGetRenderDeviceNameFromFd(fd: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _drmPciBusInfo {
    pub domain: u16,
    pub bus: u8,
    pub dev: u8,
    pub func: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmPciBusInfo"][::std::mem::size_of::<_drmPciBusInfo>() - 6usize];
    ["Alignment of _drmPciBusInfo"][::std::mem::align_of::<_drmPciBusInfo>() - 2usize];
    ["Offset of field: _drmPciBusInfo::domain"]
        [::std::mem::offset_of!(_drmPciBusInfo, domain) - 0usize];
    ["Offset of field: _drmPciBusInfo::bus"][::std::mem::offset_of!(_drmPciBusInfo, bus) - 2usize];
    ["Offset of field: _drmPciBusInfo::dev"][::std::mem::offset_of!(_drmPciBusInfo, dev) - 3usize];
    ["Offset of field: _drmPciBusInfo::func"]
        [::std::mem::offset_of!(_drmPciBusInfo, func) - 4usize];
};
pub type drmPciBusInfo = _drmPciBusInfo;
pub type drmPciBusInfoPtr = *mut _drmPciBusInfo;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _drmPciDeviceInfo {
    pub vendor_id: u16,
    pub device_id: u16,
    pub subvendor_id: u16,
    pub subdevice_id: u16,
    pub revision_id: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmPciDeviceInfo"][::std::mem::size_of::<_drmPciDeviceInfo>() - 10usize];
    ["Alignment of _drmPciDeviceInfo"][::std::mem::align_of::<_drmPciDeviceInfo>() - 2usize];
    ["Offset of field: _drmPciDeviceInfo::vendor_id"]
        [::std::mem::offset_of!(_drmPciDeviceInfo, vendor_id) - 0usize];
    ["Offset of field: _drmPciDeviceInfo::device_id"]
        [::std::mem::offset_of!(_drmPciDeviceInfo, device_id) - 2usize];
    ["Offset of field: _drmPciDeviceInfo::subvendor_id"]
        [::std::mem::offset_of!(_drmPciDeviceInfo, subvendor_id) - 4usize];
    ["Offset of field: _drmPciDeviceInfo::subdevice_id"]
        [::std::mem::offset_of!(_drmPciDeviceInfo, subdevice_id) - 6usize];
    ["Offset of field: _drmPciDeviceInfo::revision_id"]
        [::std::mem::offset_of!(_drmPciDeviceInfo, revision_id) - 8usize];
};
pub type drmPciDeviceInfo = _drmPciDeviceInfo;
pub type drmPciDeviceInfoPtr = *mut _drmPciDeviceInfo;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _drmUsbBusInfo {
    pub bus: u8,
    pub dev: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmUsbBusInfo"][::std::mem::size_of::<_drmUsbBusInfo>() - 2usize];
    ["Alignment of _drmUsbBusInfo"][::std::mem::align_of::<_drmUsbBusInfo>() - 1usize];
    ["Offset of field: _drmUsbBusInfo::bus"][::std::mem::offset_of!(_drmUsbBusInfo, bus) - 0usize];
    ["Offset of field: _drmUsbBusInfo::dev"][::std::mem::offset_of!(_drmUsbBusInfo, dev) - 1usize];
};
pub type drmUsbBusInfo = _drmUsbBusInfo;
pub type drmUsbBusInfoPtr = *mut _drmUsbBusInfo;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _drmUsbDeviceInfo {
    pub vendor: u16,
    pub product: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmUsbDeviceInfo"][::std::mem::size_of::<_drmUsbDeviceInfo>() - 4usize];
    ["Alignment of _drmUsbDeviceInfo"][::std::mem::align_of::<_drmUsbDeviceInfo>() - 2usize];
    ["Offset of field: _drmUsbDeviceInfo::vendor"]
        [::std::mem::offset_of!(_drmUsbDeviceInfo, vendor) - 0usize];
    ["Offset of field: _drmUsbDeviceInfo::product"]
        [::std::mem::offset_of!(_drmUsbDeviceInfo, product) - 2usize];
};
pub type drmUsbDeviceInfo = _drmUsbDeviceInfo;
pub type drmUsbDeviceInfoPtr = *mut _drmUsbDeviceInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmPlatformBusInfo {
    pub fullname: [::std::os::raw::c_char; 512usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmPlatformBusInfo"][::std::mem::size_of::<_drmPlatformBusInfo>() - 512usize];
    ["Alignment of _drmPlatformBusInfo"][::std::mem::align_of::<_drmPlatformBusInfo>() - 1usize];
    ["Offset of field: _drmPlatformBusInfo::fullname"]
        [::std::mem::offset_of!(_drmPlatformBusInfo, fullname) - 0usize];
};
impl Default for _drmPlatformBusInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type drmPlatformBusInfo = _drmPlatformBusInfo;
pub type drmPlatformBusInfoPtr = *mut _drmPlatformBusInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmPlatformDeviceInfo {
    pub compatible: *mut *mut ::std::os::raw::c_char,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmPlatformDeviceInfo"][::std::mem::size_of::<_drmPlatformDeviceInfo>() - 4usize];
    ["Alignment of _drmPlatformDeviceInfo"]
        [::std::mem::align_of::<_drmPlatformDeviceInfo>() - 4usize];
    ["Offset of field: _drmPlatformDeviceInfo::compatible"]
        [::std::mem::offset_of!(_drmPlatformDeviceInfo, compatible) - 0usize];
};
impl Default for _drmPlatformDeviceInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type drmPlatformDeviceInfo = _drmPlatformDeviceInfo;
pub type drmPlatformDeviceInfoPtr = *mut _drmPlatformDeviceInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmHost1xBusInfo {
    pub fullname: [::std::os::raw::c_char; 512usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmHost1xBusInfo"][::std::mem::size_of::<_drmHost1xBusInfo>() - 512usize];
    ["Alignment of _drmHost1xBusInfo"][::std::mem::align_of::<_drmHost1xBusInfo>() - 1usize];
    ["Offset of field: _drmHost1xBusInfo::fullname"]
        [::std::mem::offset_of!(_drmHost1xBusInfo, fullname) - 0usize];
};
impl Default for _drmHost1xBusInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type drmHost1xBusInfo = _drmHost1xBusInfo;
pub type drmHost1xBusInfoPtr = *mut _drmHost1xBusInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmHost1xDeviceInfo {
    pub compatible: *mut *mut ::std::os::raw::c_char,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmHost1xDeviceInfo"][::std::mem::size_of::<_drmHost1xDeviceInfo>() - 4usize];
    ["Alignment of _drmHost1xDeviceInfo"][::std::mem::align_of::<_drmHost1xDeviceInfo>() - 4usize];
    ["Offset of field: _drmHost1xDeviceInfo::compatible"]
        [::std::mem::offset_of!(_drmHost1xDeviceInfo, compatible) - 0usize];
};
impl Default for _drmHost1xDeviceInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type drmHost1xDeviceInfo = _drmHost1xDeviceInfo;
pub type drmHost1xDeviceInfoPtr = *mut _drmHost1xDeviceInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmFauxBusInfo {
    pub name: [::std::os::raw::c_char; 512usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmFauxBusInfo"][::std::mem::size_of::<_drmFauxBusInfo>() - 512usize];
    ["Alignment of _drmFauxBusInfo"][::std::mem::align_of::<_drmFauxBusInfo>() - 1usize];
    ["Offset of field: _drmFauxBusInfo::name"]
        [::std::mem::offset_of!(_drmFauxBusInfo, name) - 0usize];
};
impl Default for _drmFauxBusInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type drmFauxBusInfo = _drmFauxBusInfo;
pub type drmFauxBusInfoPtr = *mut _drmFauxBusInfo;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _drmDevice {
    pub nodes: *mut *mut ::std::os::raw::c_char,
    pub available_nodes: ::std::os::raw::c_int,
    pub bustype: ::std::os::raw::c_int,
    pub businfo: _drmDevice__bindgen_ty_1,
    pub deviceinfo: _drmDevice__bindgen_ty_2,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _drmDevice__bindgen_ty_1 {
    pub pci: drmPciBusInfoPtr,
    pub usb: drmUsbBusInfoPtr,
    pub platform: drmPlatformBusInfoPtr,
    pub host1x: drmHost1xBusInfoPtr,
    pub faux: drmFauxBusInfoPtr,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmDevice__bindgen_ty_1"]
        [::std::mem::size_of::<_drmDevice__bindgen_ty_1>() - 4usize];
    ["Alignment of _drmDevice__bindgen_ty_1"]
        [::std::mem::align_of::<_drmDevice__bindgen_ty_1>() - 4usize];
    ["Offset of field: _drmDevice__bindgen_ty_1::pci"]
        [::std::mem::offset_of!(_drmDevice__bindgen_ty_1, pci) - 0usize];
    ["Offset of field: _drmDevice__bindgen_ty_1::usb"]
        [::std::mem::offset_of!(_drmDevice__bindgen_ty_1, usb) - 0usize];
    ["Offset of field: _drmDevice__bindgen_ty_1::platform"]
        [::std::mem::offset_of!(_drmDevice__bindgen_ty_1, platform) - 0usize];
    ["Offset of field: _drmDevice__bindgen_ty_1::host1x"]
        [::std::mem::offset_of!(_drmDevice__bindgen_ty_1, host1x) - 0usize];
    ["Offset of field: _drmDevice__bindgen_ty_1::faux"]
        [::std::mem::offset_of!(_drmDevice__bindgen_ty_1, faux) - 0usize];
};
impl Default for _drmDevice__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _drmDevice__bindgen_ty_2 {
    pub pci: drmPciDeviceInfoPtr,
    pub usb: drmUsbDeviceInfoPtr,
    pub platform: drmPlatformDeviceInfoPtr,
    pub host1x: drmHost1xDeviceInfoPtr,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmDevice__bindgen_ty_2"]
        [::std::mem::size_of::<_drmDevice__bindgen_ty_2>() - 4usize];
    ["Alignment of _drmDevice__bindgen_ty_2"]
        [::std::mem::align_of::<_drmDevice__bindgen_ty_2>() - 4usize];
    ["Offset of field: _drmDevice__bindgen_ty_2::pci"]
        [::std::mem::offset_of!(_drmDevice__bindgen_ty_2, pci) - 0usize];
    ["Offset of field: _drmDevice__bindgen_ty_2::usb"]
        [::std::mem::offset_of!(_drmDevice__bindgen_ty_2, usb) - 0usize];
    ["Offset of field: _drmDevice__bindgen_ty_2::platform"]
        [::std::mem::offset_of!(_drmDevice__bindgen_ty_2, platform) - 0usize];
    ["Offset of field: _drmDevice__bindgen_ty_2::host1x"]
        [::std::mem::offset_of!(_drmDevice__bindgen_ty_2, host1x) - 0usize];
};
impl Default for _drmDevice__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmDevice"][::std::mem::size_of::<_drmDevice>() - 20usize];
    ["Alignment of _drmDevice"][::std::mem::align_of::<_drmDevice>() - 4usize];
    ["Offset of field: _drmDevice::nodes"][::std::mem::offset_of!(_drmDevice, nodes) - 0usize];
    ["Offset of field: _drmDevice::available_nodes"]
        [::std::mem::offset_of!(_drmDevice, available_nodes) - 4usize];
    ["Offset of field: _drmDevice::bustype"][::std::mem::offset_of!(_drmDevice, bustype) - 8usize];
    ["Offset of field: _drmDevice::businfo"][::std::mem::offset_of!(_drmDevice, businfo) - 12usize];
    ["Offset of field: _drmDevice::deviceinfo"]
        [::std::mem::offset_of!(_drmDevice, deviceinfo) - 16usize];
};
impl Default for _drmDevice {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type drmDevice = _drmDevice;
pub type drmDevicePtr = *mut _drmDevice;
unsafe extern "C" {
    pub fn drmGetDevice(
        fd: ::std::os::raw::c_int,
        device: *mut drmDevicePtr,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmFreeDevice(device: *mut drmDevicePtr);
}
unsafe extern "C" {
    pub fn drmGetDevices(
        devices: *mut drmDevicePtr,
        max_devices: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmFreeDevices(devices: *mut drmDevicePtr, count: ::std::os::raw::c_int);
}
unsafe extern "C" {
    pub fn drmGetDevice2(
        fd: ::std::os::raw::c_int,
        flags: u32,
        device: *mut drmDevicePtr,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmGetDevices2(
        flags: u32,
        devices: *mut drmDevicePtr,
        max_devices: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmGetDeviceFromDevId(
        dev_id: dev_t,
        flags: u32,
        device: *mut drmDevicePtr,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmGetNodeTypeFromDevId(devid: dev_t) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmDevicesEqual(a: drmDevicePtr, b: drmDevicePtr) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmSyncobjCreate(
        fd: ::std::os::raw::c_int,
        flags: u32,
        handle: *mut u32,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmSyncobjDestroy(fd: ::std::os::raw::c_int, handle: u32) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmSyncobjHandleToFD(
        fd: ::std::os::raw::c_int,
        handle: u32,
        obj_fd: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmSyncobjFDToHandle(
        fd: ::std::os::raw::c_int,
        obj_fd: ::std::os::raw::c_int,
        handle: *mut u32,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmSyncobjImportSyncFile(
        fd: ::std::os::raw::c_int,
        handle: u32,
        sync_file_fd: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmSyncobjExportSyncFile(
        fd: ::std::os::raw::c_int,
        handle: u32,
        sync_file_fd: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmSyncobjWait(
        fd: ::std::os::raw::c_int,
        handles: *mut u32,
        num_handles: ::std::os::raw::c_uint,
        timeout_nsec: i64,
        flags: ::std::os::raw::c_uint,
        first_signaled: *mut u32,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmSyncobjReset(
        fd: ::std::os::raw::c_int,
        handles: *const u32,
        handle_count: u32,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmSyncobjSignal(
        fd: ::std::os::raw::c_int,
        handles: *const u32,
        handle_count: u32,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmSyncobjTimelineSignal(
        fd: ::std::os::raw::c_int,
        handles: *const u32,
        points: *mut u64,
        handle_count: u32,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmSyncobjTimelineWait(
        fd: ::std::os::raw::c_int,
        handles: *mut u32,
        points: *mut u64,
        num_handles: ::std::os::raw::c_uint,
        timeout_nsec: i64,
        flags: ::std::os::raw::c_uint,
        first_signaled: *mut u32,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmSyncobjQuery(
        fd: ::std::os::raw::c_int,
        handles: *mut u32,
        points: *mut u64,
        handle_count: u32,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmSyncobjQuery2(
        fd: ::std::os::raw::c_int,
        handles: *mut u32,
        points: *mut u64,
        handle_count: u32,
        flags: u32,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmSyncobjTransfer(
        fd: ::std::os::raw::c_int,
        dst_handle: u32,
        dst_point: u64,
        src_handle: u32,
        src_point: u64,
        flags: u32,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmSyncobjEventfd(
        fd: ::std::os::raw::c_int,
        handle: u32,
        point: u64,
        ev_fd: ::std::os::raw::c_int,
        flags: u32,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn drmGetFormatModifierVendor(modifier: u64) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn drmGetFormatModifierName(modifier: u64) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn drmGetFormatName(format: u32) -> *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_nouveau_getparam {
    pub param: __u64,
    pub value: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_nouveau_getparam"][::std::mem::size_of::<drm_nouveau_getparam>() - 16usize];
    ["Alignment of drm_nouveau_getparam"][::std::mem::align_of::<drm_nouveau_getparam>() - 4usize];
    ["Offset of field: drm_nouveau_getparam::param"]
        [::std::mem::offset_of!(drm_nouveau_getparam, param) - 0usize];
    ["Offset of field: drm_nouveau_getparam::value"]
        [::std::mem::offset_of!(drm_nouveau_getparam, value) - 8usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_nouveau_channel_alloc {
    pub fb_ctxdma_handle: __u32,
    pub tt_ctxdma_handle: __u32,
    pub channel: __s32,
    pub pushbuf_domains: __u32,
    pub notifier_handle: __u32,
    pub subchan: [drm_nouveau_channel_alloc__bindgen_ty_1; 8usize],
    pub nr_subchan: __u32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_nouveau_channel_alloc__bindgen_ty_1 {
    pub handle: __u32,
    pub grclass: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_nouveau_channel_alloc__bindgen_ty_1"]
        [::std::mem::size_of::<drm_nouveau_channel_alloc__bindgen_ty_1>() - 8usize];
    ["Alignment of drm_nouveau_channel_alloc__bindgen_ty_1"]
        [::std::mem::align_of::<drm_nouveau_channel_alloc__bindgen_ty_1>() - 4usize];
    ["Offset of field: drm_nouveau_channel_alloc__bindgen_ty_1::handle"]
        [::std::mem::offset_of!(drm_nouveau_channel_alloc__bindgen_ty_1, handle) - 0usize];
    ["Offset of field: drm_nouveau_channel_alloc__bindgen_ty_1::grclass"]
        [::std::mem::offset_of!(drm_nouveau_channel_alloc__bindgen_ty_1, grclass) - 4usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_nouveau_channel_alloc"]
        [::std::mem::size_of::<drm_nouveau_channel_alloc>() - 88usize];
    ["Alignment of drm_nouveau_channel_alloc"]
        [::std::mem::align_of::<drm_nouveau_channel_alloc>() - 4usize];
    ["Offset of field: drm_nouveau_channel_alloc::fb_ctxdma_handle"]
        [::std::mem::offset_of!(drm_nouveau_channel_alloc, fb_ctxdma_handle) - 0usize];
    ["Offset of field: drm_nouveau_channel_alloc::tt_ctxdma_handle"]
        [::std::mem::offset_of!(drm_nouveau_channel_alloc, tt_ctxdma_handle) - 4usize];
    ["Offset of field: drm_nouveau_channel_alloc::channel"]
        [::std::mem::offset_of!(drm_nouveau_channel_alloc, channel) - 8usize];
    ["Offset of field: drm_nouveau_channel_alloc::pushbuf_domains"]
        [::std::mem::offset_of!(drm_nouveau_channel_alloc, pushbuf_domains) - 12usize];
    ["Offset of field: drm_nouveau_channel_alloc::notifier_handle"]
        [::std::mem::offset_of!(drm_nouveau_channel_alloc, notifier_handle) - 16usize];
    ["Offset of field: drm_nouveau_channel_alloc::subchan"]
        [::std::mem::offset_of!(drm_nouveau_channel_alloc, subchan) - 20usize];
    ["Offset of field: drm_nouveau_channel_alloc::nr_subchan"]
        [::std::mem::offset_of!(drm_nouveau_channel_alloc, nr_subchan) - 84usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_nouveau_channel_free {
    pub channel: __s32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_nouveau_channel_free"]
        [::std::mem::size_of::<drm_nouveau_channel_free>() - 4usize];
    ["Alignment of drm_nouveau_channel_free"]
        [::std::mem::align_of::<drm_nouveau_channel_free>() - 4usize];
    ["Offset of field: drm_nouveau_channel_free::channel"]
        [::std::mem::offset_of!(drm_nouveau_channel_free, channel) - 0usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_nouveau_notifierobj_alloc {
    pub channel: __u32,
    pub handle: __u32,
    pub size: __u32,
    pub offset: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_nouveau_notifierobj_alloc"]
        [::std::mem::size_of::<drm_nouveau_notifierobj_alloc>() - 16usize];
    ["Alignment of drm_nouveau_notifierobj_alloc"]
        [::std::mem::align_of::<drm_nouveau_notifierobj_alloc>() - 4usize];
    ["Offset of field: drm_nouveau_notifierobj_alloc::channel"]
        [::std::mem::offset_of!(drm_nouveau_notifierobj_alloc, channel) - 0usize];
    ["Offset of field: drm_nouveau_notifierobj_alloc::handle"]
        [::std::mem::offset_of!(drm_nouveau_notifierobj_alloc, handle) - 4usize];
    ["Offset of field: drm_nouveau_notifierobj_alloc::size"]
        [::std::mem::offset_of!(drm_nouveau_notifierobj_alloc, size) - 8usize];
    ["Offset of field: drm_nouveau_notifierobj_alloc::offset"]
        [::std::mem::offset_of!(drm_nouveau_notifierobj_alloc, offset) - 12usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_nouveau_gpuobj_free {
    pub channel: __s32,
    pub handle: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_nouveau_gpuobj_free"][::std::mem::size_of::<drm_nouveau_gpuobj_free>() - 8usize];
    ["Alignment of drm_nouveau_gpuobj_free"]
        [::std::mem::align_of::<drm_nouveau_gpuobj_free>() - 4usize];
    ["Offset of field: drm_nouveau_gpuobj_free::channel"]
        [::std::mem::offset_of!(drm_nouveau_gpuobj_free, channel) - 0usize];
    ["Offset of field: drm_nouveau_gpuobj_free::handle"]
        [::std::mem::offset_of!(drm_nouveau_gpuobj_free, handle) - 4usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_nouveau_gem_info {
    pub handle: __u32,
    pub domain: __u32,
    pub size: __u64,
    pub offset: __u64,
    pub map_handle: __u64,
    pub tile_mode: __u32,
    pub tile_flags: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_nouveau_gem_info"][::std::mem::size_of::<drm_nouveau_gem_info>() - 40usize];
    ["Alignment of drm_nouveau_gem_info"][::std::mem::align_of::<drm_nouveau_gem_info>() - 4usize];
    ["Offset of field: drm_nouveau_gem_info::handle"]
        [::std::mem::offset_of!(drm_nouveau_gem_info, handle) - 0usize];
    ["Offset of field: drm_nouveau_gem_info::domain"]
        [::std::mem::offset_of!(drm_nouveau_gem_info, domain) - 4usize];
    ["Offset of field: drm_nouveau_gem_info::size"]
        [::std::mem::offset_of!(drm_nouveau_gem_info, size) - 8usize];
    ["Offset of field: drm_nouveau_gem_info::offset"]
        [::std::mem::offset_of!(drm_nouveau_gem_info, offset) - 16usize];
    ["Offset of field: drm_nouveau_gem_info::map_handle"]
        [::std::mem::offset_of!(drm_nouveau_gem_info, map_handle) - 24usize];
    ["Offset of field: drm_nouveau_gem_info::tile_mode"]
        [::std::mem::offset_of!(drm_nouveau_gem_info, tile_mode) - 32usize];
    ["Offset of field: drm_nouveau_gem_info::tile_flags"]
        [::std::mem::offset_of!(drm_nouveau_gem_info, tile_flags) - 36usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_nouveau_gem_new {
    pub info: drm_nouveau_gem_info,
    pub channel_hint: __u32,
    pub align: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_nouveau_gem_new"][::std::mem::size_of::<drm_nouveau_gem_new>() - 48usize];
    ["Alignment of drm_nouveau_gem_new"][::std::mem::align_of::<drm_nouveau_gem_new>() - 4usize];
    ["Offset of field: drm_nouveau_gem_new::info"]
        [::std::mem::offset_of!(drm_nouveau_gem_new, info) - 0usize];
    ["Offset of field: drm_nouveau_gem_new::channel_hint"]
        [::std::mem::offset_of!(drm_nouveau_gem_new, channel_hint) - 40usize];
    ["Offset of field: drm_nouveau_gem_new::align"]
        [::std::mem::offset_of!(drm_nouveau_gem_new, align) - 44usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_nouveau_gem_pushbuf_bo_presumed {
    pub valid: __u32,
    pub domain: __u32,
    pub offset: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_nouveau_gem_pushbuf_bo_presumed"]
        [::std::mem::size_of::<drm_nouveau_gem_pushbuf_bo_presumed>() - 16usize];
    ["Alignment of drm_nouveau_gem_pushbuf_bo_presumed"]
        [::std::mem::align_of::<drm_nouveau_gem_pushbuf_bo_presumed>() - 4usize];
    ["Offset of field: drm_nouveau_gem_pushbuf_bo_presumed::valid"]
        [::std::mem::offset_of!(drm_nouveau_gem_pushbuf_bo_presumed, valid) - 0usize];
    ["Offset of field: drm_nouveau_gem_pushbuf_bo_presumed::domain"]
        [::std::mem::offset_of!(drm_nouveau_gem_pushbuf_bo_presumed, domain) - 4usize];
    ["Offset of field: drm_nouveau_gem_pushbuf_bo_presumed::offset"]
        [::std::mem::offset_of!(drm_nouveau_gem_pushbuf_bo_presumed, offset) - 8usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_nouveau_gem_pushbuf_bo {
    pub user_priv: __u64,
    pub handle: __u32,
    pub read_domains: __u32,
    pub write_domains: __u32,
    pub valid_domains: __u32,
    pub presumed: drm_nouveau_gem_pushbuf_bo_presumed,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_nouveau_gem_pushbuf_bo"]
        [::std::mem::size_of::<drm_nouveau_gem_pushbuf_bo>() - 40usize];
    ["Alignment of drm_nouveau_gem_pushbuf_bo"]
        [::std::mem::align_of::<drm_nouveau_gem_pushbuf_bo>() - 4usize];
    ["Offset of field: drm_nouveau_gem_pushbuf_bo::user_priv"]
        [::std::mem::offset_of!(drm_nouveau_gem_pushbuf_bo, user_priv) - 0usize];
    ["Offset of field: drm_nouveau_gem_pushbuf_bo::handle"]
        [::std::mem::offset_of!(drm_nouveau_gem_pushbuf_bo, handle) - 8usize];
    ["Offset of field: drm_nouveau_gem_pushbuf_bo::read_domains"]
        [::std::mem::offset_of!(drm_nouveau_gem_pushbuf_bo, read_domains) - 12usize];
    ["Offset of field: drm_nouveau_gem_pushbuf_bo::write_domains"]
        [::std::mem::offset_of!(drm_nouveau_gem_pushbuf_bo, write_domains) - 16usize];
    ["Offset of field: drm_nouveau_gem_pushbuf_bo::valid_domains"]
        [::std::mem::offset_of!(drm_nouveau_gem_pushbuf_bo, valid_domains) - 20usize];
    ["Offset of field: drm_nouveau_gem_pushbuf_bo::presumed"]
        [::std::mem::offset_of!(drm_nouveau_gem_pushbuf_bo, presumed) - 24usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_nouveau_gem_pushbuf_reloc {
    pub reloc_bo_index: __u32,
    pub reloc_bo_offset: __u32,
    pub bo_index: __u32,
    pub flags: __u32,
    pub data: __u32,
    pub vor: __u32,
    pub tor: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_nouveau_gem_pushbuf_reloc"]
        [::std::mem::size_of::<drm_nouveau_gem_pushbuf_reloc>() - 28usize];
    ["Alignment of drm_nouveau_gem_pushbuf_reloc"]
        [::std::mem::align_of::<drm_nouveau_gem_pushbuf_reloc>() - 4usize];
    ["Offset of field: drm_nouveau_gem_pushbuf_reloc::reloc_bo_index"]
        [::std::mem::offset_of!(drm_nouveau_gem_pushbuf_reloc, reloc_bo_index) - 0usize];
    ["Offset of field: drm_nouveau_gem_pushbuf_reloc::reloc_bo_offset"]
        [::std::mem::offset_of!(drm_nouveau_gem_pushbuf_reloc, reloc_bo_offset) - 4usize];
    ["Offset of field: drm_nouveau_gem_pushbuf_reloc::bo_index"]
        [::std::mem::offset_of!(drm_nouveau_gem_pushbuf_reloc, bo_index) - 8usize];
    ["Offset of field: drm_nouveau_gem_pushbuf_reloc::flags"]
        [::std::mem::offset_of!(drm_nouveau_gem_pushbuf_reloc, flags) - 12usize];
    ["Offset of field: drm_nouveau_gem_pushbuf_reloc::data"]
        [::std::mem::offset_of!(drm_nouveau_gem_pushbuf_reloc, data) - 16usize];
    ["Offset of field: drm_nouveau_gem_pushbuf_reloc::vor"]
        [::std::mem::offset_of!(drm_nouveau_gem_pushbuf_reloc, vor) - 20usize];
    ["Offset of field: drm_nouveau_gem_pushbuf_reloc::tor"]
        [::std::mem::offset_of!(drm_nouveau_gem_pushbuf_reloc, tor) - 24usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_nouveau_gem_pushbuf_push {
    pub bo_index: __u32,
    pub pad: __u32,
    pub offset: __u64,
    pub length: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_nouveau_gem_pushbuf_push"]
        [::std::mem::size_of::<drm_nouveau_gem_pushbuf_push>() - 24usize];
    ["Alignment of drm_nouveau_gem_pushbuf_push"]
        [::std::mem::align_of::<drm_nouveau_gem_pushbuf_push>() - 4usize];
    ["Offset of field: drm_nouveau_gem_pushbuf_push::bo_index"]
        [::std::mem::offset_of!(drm_nouveau_gem_pushbuf_push, bo_index) - 0usize];
    ["Offset of field: drm_nouveau_gem_pushbuf_push::pad"]
        [::std::mem::offset_of!(drm_nouveau_gem_pushbuf_push, pad) - 4usize];
    ["Offset of field: drm_nouveau_gem_pushbuf_push::offset"]
        [::std::mem::offset_of!(drm_nouveau_gem_pushbuf_push, offset) - 8usize];
    ["Offset of field: drm_nouveau_gem_pushbuf_push::length"]
        [::std::mem::offset_of!(drm_nouveau_gem_pushbuf_push, length) - 16usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_nouveau_gem_pushbuf {
    pub channel: __u32,
    pub nr_buffers: __u32,
    pub buffers: __u64,
    pub nr_relocs: __u32,
    pub nr_push: __u32,
    pub relocs: __u64,
    pub push: __u64,
    pub suffix0: __u32,
    pub suffix1: __u32,
    pub vram_available: __u64,
    pub gart_available: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_nouveau_gem_pushbuf"][::std::mem::size_of::<drm_nouveau_gem_pushbuf>() - 64usize];
    ["Alignment of drm_nouveau_gem_pushbuf"]
        [::std::mem::align_of::<drm_nouveau_gem_pushbuf>() - 4usize];
    ["Offset of field: drm_nouveau_gem_pushbuf::channel"]
        [::std::mem::offset_of!(drm_nouveau_gem_pushbuf, channel) - 0usize];
    ["Offset of field: drm_nouveau_gem_pushbuf::nr_buffers"]
        [::std::mem::offset_of!(drm_nouveau_gem_pushbuf, nr_buffers) - 4usize];
    ["Offset of field: drm_nouveau_gem_pushbuf::buffers"]
        [::std::mem::offset_of!(drm_nouveau_gem_pushbuf, buffers) - 8usize];
    ["Offset of field: drm_nouveau_gem_pushbuf::nr_relocs"]
        [::std::mem::offset_of!(drm_nouveau_gem_pushbuf, nr_relocs) - 16usize];
    ["Offset of field: drm_nouveau_gem_pushbuf::nr_push"]
        [::std::mem::offset_of!(drm_nouveau_gem_pushbuf, nr_push) - 20usize];
    ["Offset of field: drm_nouveau_gem_pushbuf::relocs"]
        [::std::mem::offset_of!(drm_nouveau_gem_pushbuf, relocs) - 24usize];
    ["Offset of field: drm_nouveau_gem_pushbuf::push"]
        [::std::mem::offset_of!(drm_nouveau_gem_pushbuf, push) - 32usize];
    ["Offset of field: drm_nouveau_gem_pushbuf::suffix0"]
        [::std::mem::offset_of!(drm_nouveau_gem_pushbuf, suffix0) - 40usize];
    ["Offset of field: drm_nouveau_gem_pushbuf::suffix1"]
        [::std::mem::offset_of!(drm_nouveau_gem_pushbuf, suffix1) - 44usize];
    ["Offset of field: drm_nouveau_gem_pushbuf::vram_available"]
        [::std::mem::offset_of!(drm_nouveau_gem_pushbuf, vram_available) - 48usize];
    ["Offset of field: drm_nouveau_gem_pushbuf::gart_available"]
        [::std::mem::offset_of!(drm_nouveau_gem_pushbuf, gart_available) - 56usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_nouveau_gem_cpu_prep {
    pub handle: __u32,
    pub flags: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_nouveau_gem_cpu_prep"]
        [::std::mem::size_of::<drm_nouveau_gem_cpu_prep>() - 8usize];
    ["Alignment of drm_nouveau_gem_cpu_prep"]
        [::std::mem::align_of::<drm_nouveau_gem_cpu_prep>() - 4usize];
    ["Offset of field: drm_nouveau_gem_cpu_prep::handle"]
        [::std::mem::offset_of!(drm_nouveau_gem_cpu_prep, handle) - 0usize];
    ["Offset of field: drm_nouveau_gem_cpu_prep::flags"]
        [::std::mem::offset_of!(drm_nouveau_gem_cpu_prep, flags) - 4usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_nouveau_gem_cpu_fini {
    pub handle: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_nouveau_gem_cpu_fini"]
        [::std::mem::size_of::<drm_nouveau_gem_cpu_fini>() - 4usize];
    ["Alignment of drm_nouveau_gem_cpu_fini"]
        [::std::mem::align_of::<drm_nouveau_gem_cpu_fini>() - 4usize];
    ["Offset of field: drm_nouveau_gem_cpu_fini::handle"]
        [::std::mem::offset_of!(drm_nouveau_gem_cpu_fini, handle) - 0usize];
};
#[doc = " struct drm_nouveau_sync - sync object\n\n This structure serves as synchronization mechanism for (potentially)\n asynchronous operations such as EXEC or VM_BIND."]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_nouveau_sync {
    #[doc = " @flags: the flags for a sync object\n\n The first 8 bits are used to determine the type of the sync object."]
    pub flags: __u32,
    #[doc = " @handle: the handle of the sync object"]
    pub handle: __u32,
    #[doc = " @timeline_value:\n\n The timeline point of the sync object in case the syncobj is of\n type DRM_NOUVEAU_SYNC_TIMELINE_SYNCOBJ."]
    pub timeline_value: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_nouveau_sync"][::std::mem::size_of::<drm_nouveau_sync>() - 16usize];
    ["Alignment of drm_nouveau_sync"][::std::mem::align_of::<drm_nouveau_sync>() - 4usize];
    ["Offset of field: drm_nouveau_sync::flags"]
        [::std::mem::offset_of!(drm_nouveau_sync, flags) - 0usize];
    ["Offset of field: drm_nouveau_sync::handle"]
        [::std::mem::offset_of!(drm_nouveau_sync, handle) - 4usize];
    ["Offset of field: drm_nouveau_sync::timeline_value"]
        [::std::mem::offset_of!(drm_nouveau_sync, timeline_value) - 8usize];
};
#[doc = " struct drm_nouveau_vm_init - GPU VA space init structure\n\n Used to initialize the GPU's VA space for a user client, telling the kernel\n which portion of the VA space is managed by the UMD and kernel respectively.\n\n For the UMD to use the VM_BIND uAPI, this must be called before any BOs or\n channels are created; if called afterwards DRM_IOCTL_NOUVEAU_VM_INIT fails\n with -ENOSYS."]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_nouveau_vm_init {
    #[doc = " @kernel_managed_addr: start address of the kernel managed VA space\n region"]
    pub kernel_managed_addr: __u64,
    #[doc = " @kernel_managed_size: size of the kernel managed VA space region in\n bytes"]
    pub kernel_managed_size: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_nouveau_vm_init"][::std::mem::size_of::<drm_nouveau_vm_init>() - 16usize];
    ["Alignment of drm_nouveau_vm_init"][::std::mem::align_of::<drm_nouveau_vm_init>() - 4usize];
    ["Offset of field: drm_nouveau_vm_init::kernel_managed_addr"]
        [::std::mem::offset_of!(drm_nouveau_vm_init, kernel_managed_addr) - 0usize];
    ["Offset of field: drm_nouveau_vm_init::kernel_managed_size"]
        [::std::mem::offset_of!(drm_nouveau_vm_init, kernel_managed_size) - 8usize];
};
#[doc = " struct drm_nouveau_vm_bind_op - VM_BIND operation\n\n This structure represents a single VM_BIND operation. UMDs should pass\n an array of this structure via struct drm_nouveau_vm_bind's &op_ptr field."]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_nouveau_vm_bind_op {
    #[doc = " @op: the operation type\n\n Supported values:\n\n %DRM_NOUVEAU_VM_BIND_OP_MAP - Map a GEM object to the GPU's VA\n space. Optionally, the &DRM_NOUVEAU_VM_BIND_SPARSE flag can be\n passed to instruct the kernel to create sparse mappings for the\n given range.\n\n %DRM_NOUVEAU_VM_BIND_OP_UNMAP - Unmap an existing mapping in the\n GPU's VA space. If the region the mapping is located in is a\n sparse region, new sparse mappings are created where the unmapped\n (memory backed) mapping was mapped previously. To remove a sparse\n region the &DRM_NOUVEAU_VM_BIND_SPARSE must be set."]
    pub op: __u32,
    #[doc = " @flags: the flags for a &drm_nouveau_vm_bind_op\n\n Supported values:\n\n %DRM_NOUVEAU_VM_BIND_SPARSE - Indicates that an allocated VA\n space region should be sparse."]
    pub flags: __u32,
    #[doc = " @handle: the handle of the DRM GEM object to map"]
    pub handle: __u32,
    #[doc = " @pad: 32 bit padding, should be 0"]
    pub pad: __u32,
    #[doc = " @addr:\n\n the address the VA space region or (memory backed) mapping should be mapped to"]
    pub addr: __u64,
    #[doc = " @bo_offset: the offset within the BO backing the mapping"]
    pub bo_offset: __u64,
    #[doc = " @range: the size of the requested mapping in bytes"]
    pub range: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_nouveau_vm_bind_op"][::std::mem::size_of::<drm_nouveau_vm_bind_op>() - 40usize];
    ["Alignment of drm_nouveau_vm_bind_op"]
        [::std::mem::align_of::<drm_nouveau_vm_bind_op>() - 4usize];
    ["Offset of field: drm_nouveau_vm_bind_op::op"]
        [::std::mem::offset_of!(drm_nouveau_vm_bind_op, op) - 0usize];
    ["Offset of field: drm_nouveau_vm_bind_op::flags"]
        [::std::mem::offset_of!(drm_nouveau_vm_bind_op, flags) - 4usize];
    ["Offset of field: drm_nouveau_vm_bind_op::handle"]
        [::std::mem::offset_of!(drm_nouveau_vm_bind_op, handle) - 8usize];
    ["Offset of field: drm_nouveau_vm_bind_op::pad"]
        [::std::mem::offset_of!(drm_nouveau_vm_bind_op, pad) - 12usize];
    ["Offset of field: drm_nouveau_vm_bind_op::addr"]
        [::std::mem::offset_of!(drm_nouveau_vm_bind_op, addr) - 16usize];
    ["Offset of field: drm_nouveau_vm_bind_op::bo_offset"]
        [::std::mem::offset_of!(drm_nouveau_vm_bind_op, bo_offset) - 24usize];
    ["Offset of field: drm_nouveau_vm_bind_op::range"]
        [::std::mem::offset_of!(drm_nouveau_vm_bind_op, range) - 32usize];
};
#[doc = " struct drm_nouveau_vm_bind - structure for DRM_IOCTL_NOUVEAU_VM_BIND"]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_nouveau_vm_bind {
    #[doc = " @op_count: the number of &drm_nouveau_vm_bind_op"]
    pub op_count: __u32,
    #[doc = " @flags: the flags for a &drm_nouveau_vm_bind ioctl\n\n Supported values:\n\n %DRM_NOUVEAU_VM_BIND_RUN_ASYNC - Indicates that the given VM_BIND\n operation should be executed asynchronously by the kernel.\n\n If this flag is not supplied the kernel executes the associated\n operations synchronously and doesn't accept any &drm_nouveau_sync\n objects."]
    pub flags: __u32,
    #[doc = " @wait_count: the number of wait &drm_nouveau_syncs"]
    pub wait_count: __u32,
    #[doc = " @sig_count: the number of &drm_nouveau_syncs to signal when finished"]
    pub sig_count: __u32,
    #[doc = " @wait_ptr: pointer to &drm_nouveau_syncs to wait for"]
    pub wait_ptr: __u64,
    #[doc = " @sig_ptr: pointer to &drm_nouveau_syncs to signal when finished"]
    pub sig_ptr: __u64,
    #[doc = " @op_ptr: pointer to the &drm_nouveau_vm_bind_ops to execute"]
    pub op_ptr: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_nouveau_vm_bind"][::std::mem::size_of::<drm_nouveau_vm_bind>() - 40usize];
    ["Alignment of drm_nouveau_vm_bind"][::std::mem::align_of::<drm_nouveau_vm_bind>() - 4usize];
    ["Offset of field: drm_nouveau_vm_bind::op_count"]
        [::std::mem::offset_of!(drm_nouveau_vm_bind, op_count) - 0usize];
    ["Offset of field: drm_nouveau_vm_bind::flags"]
        [::std::mem::offset_of!(drm_nouveau_vm_bind, flags) - 4usize];
    ["Offset of field: drm_nouveau_vm_bind::wait_count"]
        [::std::mem::offset_of!(drm_nouveau_vm_bind, wait_count) - 8usize];
    ["Offset of field: drm_nouveau_vm_bind::sig_count"]
        [::std::mem::offset_of!(drm_nouveau_vm_bind, sig_count) - 12usize];
    ["Offset of field: drm_nouveau_vm_bind::wait_ptr"]
        [::std::mem::offset_of!(drm_nouveau_vm_bind, wait_ptr) - 16usize];
    ["Offset of field: drm_nouveau_vm_bind::sig_ptr"]
        [::std::mem::offset_of!(drm_nouveau_vm_bind, sig_ptr) - 24usize];
    ["Offset of field: drm_nouveau_vm_bind::op_ptr"]
        [::std::mem::offset_of!(drm_nouveau_vm_bind, op_ptr) - 32usize];
};
#[doc = " struct drm_nouveau_exec_push - EXEC push operation\n\n This structure represents a single EXEC push operation. UMDs should pass an\n array of this structure via struct drm_nouveau_exec's &push_ptr field."]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_nouveau_exec_push {
    #[doc = " @va: the virtual address of the push buffer mapping"]
    pub va: __u64,
    #[doc = " @va_len: the length of the push buffer mapping"]
    pub va_len: __u32,
    #[doc = " @flags: the flags for this push buffer mapping"]
    pub flags: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_nouveau_exec_push"][::std::mem::size_of::<drm_nouveau_exec_push>() - 16usize];
    ["Alignment of drm_nouveau_exec_push"]
        [::std::mem::align_of::<drm_nouveau_exec_push>() - 4usize];
    ["Offset of field: drm_nouveau_exec_push::va"]
        [::std::mem::offset_of!(drm_nouveau_exec_push, va) - 0usize];
    ["Offset of field: drm_nouveau_exec_push::va_len"]
        [::std::mem::offset_of!(drm_nouveau_exec_push, va_len) - 8usize];
    ["Offset of field: drm_nouveau_exec_push::flags"]
        [::std::mem::offset_of!(drm_nouveau_exec_push, flags) - 12usize];
};
#[doc = " struct drm_nouveau_exec - structure for DRM_IOCTL_NOUVEAU_EXEC"]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_nouveau_exec {
    #[doc = " @channel: the channel to execute the push buffer in"]
    pub channel: __u32,
    #[doc = " @push_count: the number of &drm_nouveau_exec_push ops"]
    pub push_count: __u32,
    #[doc = " @wait_count: the number of wait &drm_nouveau_syncs"]
    pub wait_count: __u32,
    #[doc = " @sig_count: the number of &drm_nouveau_syncs to signal when finished"]
    pub sig_count: __u32,
    #[doc = " @wait_ptr: pointer to &drm_nouveau_syncs to wait for"]
    pub wait_ptr: __u64,
    #[doc = " @sig_ptr: pointer to &drm_nouveau_syncs to signal when finished"]
    pub sig_ptr: __u64,
    #[doc = " @push_ptr: pointer to &drm_nouveau_exec_push ops"]
    pub push_ptr: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_nouveau_exec"][::std::mem::size_of::<drm_nouveau_exec>() - 40usize];
    ["Alignment of drm_nouveau_exec"][::std::mem::align_of::<drm_nouveau_exec>() - 4usize];
    ["Offset of field: drm_nouveau_exec::channel"]
        [::std::mem::offset_of!(drm_nouveau_exec, channel) - 0usize];
    ["Offset of field: drm_nouveau_exec::push_count"]
        [::std::mem::offset_of!(drm_nouveau_exec, push_count) - 4usize];
    ["Offset of field: drm_nouveau_exec::wait_count"]
        [::std::mem::offset_of!(drm_nouveau_exec, wait_count) - 8usize];
    ["Offset of field: drm_nouveau_exec::sig_count"]
        [::std::mem::offset_of!(drm_nouveau_exec, sig_count) - 12usize];
    ["Offset of field: drm_nouveau_exec::wait_ptr"]
        [::std::mem::offset_of!(drm_nouveau_exec, wait_ptr) - 16usize];
    ["Offset of field: drm_nouveau_exec::sig_ptr"]
        [::std::mem::offset_of!(drm_nouveau_exec, sig_ptr) - 24usize];
    ["Offset of field: drm_nouveau_exec::push_ptr"]
        [::std::mem::offset_of!(drm_nouveau_exec, push_ptr) - 32usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_nouveau_svm_init {
    pub unmanaged_addr: __u64,
    pub unmanaged_size: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_nouveau_svm_init"][::std::mem::size_of::<drm_nouveau_svm_init>() - 16usize];
    ["Alignment of drm_nouveau_svm_init"][::std::mem::align_of::<drm_nouveau_svm_init>() - 4usize];
    ["Offset of field: drm_nouveau_svm_init::unmanaged_addr"]
        [::std::mem::offset_of!(drm_nouveau_svm_init, unmanaged_addr) - 0usize];
    ["Offset of field: drm_nouveau_svm_init::unmanaged_size"]
        [::std::mem::offset_of!(drm_nouveau_svm_init, unmanaged_size) - 8usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drm_nouveau_svm_bind {
    pub header: __u64,
    pub va_start: __u64,
    pub va_end: __u64,
    pub npages: __u64,
    pub stride: __u64,
    pub result: __u64,
    pub reserved0: __u64,
    pub reserved1: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_nouveau_svm_bind"][::std::mem::size_of::<drm_nouveau_svm_bind>() - 64usize];
    ["Alignment of drm_nouveau_svm_bind"][::std::mem::align_of::<drm_nouveau_svm_bind>() - 4usize];
    ["Offset of field: drm_nouveau_svm_bind::header"]
        [::std::mem::offset_of!(drm_nouveau_svm_bind, header) - 0usize];
    ["Offset of field: drm_nouveau_svm_bind::va_start"]
        [::std::mem::offset_of!(drm_nouveau_svm_bind, va_start) - 8usize];
    ["Offset of field: drm_nouveau_svm_bind::va_end"]
        [::std::mem::offset_of!(drm_nouveau_svm_bind, va_end) - 16usize];
    ["Offset of field: drm_nouveau_svm_bind::npages"]
        [::std::mem::offset_of!(drm_nouveau_svm_bind, npages) - 24usize];
    ["Offset of field: drm_nouveau_svm_bind::stride"]
        [::std::mem::offset_of!(drm_nouveau_svm_bind, stride) - 32usize];
    ["Offset of field: drm_nouveau_svm_bind::result"]
        [::std::mem::offset_of!(drm_nouveau_svm_bind, result) - 40usize];
    ["Offset of field: drm_nouveau_svm_bind::reserved0"]
        [::std::mem::offset_of!(drm_nouveau_svm_bind, reserved0) - 48usize];
    ["Offset of field: drm_nouveau_svm_bind::reserved1"]
        [::std::mem::offset_of!(drm_nouveau_svm_bind, reserved1) - 56usize];
};
pub const DRM_RS_IOCTL_NOUVEAU_EXEC: drm_rs_ioctls = 3223872594;
pub type drm_rs_ioctls = ::std::os::raw::c_uint;
pub type __builtin_va_list = *mut ::std::os::raw::c_char;
