#line 1 "dfa_x86.cpp"
//
// Copyright (c) 2003, 2017, Oracle and/or its affiliates. All rights reserved.
// DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
//
// This code is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License version 2 only, as
// published by the Free Software Foundation.
//
// This code is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// version 2 for more details (a copy is included in the LICENSE file that
// accompanied this code).
//
// You should have received a copy of the GNU General Public License version
// 2 along with this work; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
//
// Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
// or visit www.oracle.com if you need additional information or have any
// questions.
//
//

// Machine Generated File.  Do Not Edit!

#include "precompiled.hpp"
#include "adfiles/ad_x86.hpp"
#include "opto/cfgnode.hpp"
#include "opto/intrinsicnode.hpp"
#include "opto/matcher.hpp"
#include "opto/narrowptrnode.hpp"
#include "opto/opcodes.hpp"
#include "opto/convertnode.hpp"

//------------------------- Source -----------------------------------------

//------------------------- Attributes -------------------------------------

// AttributeForm 
static const int op_cost = 0;

// AttributeForm 
static const int ins_cost = 100;

// AttributeForm 
static const int ins_size = 8;

// AttributeForm 
static const int ins_short_branch = 0;

// AttributeForm 
static const int ins_alignment = 1;

//------------------------- Macros -----------------------------------------
#define DFA_PRODUCTION(result, rule, cost)\
  _cost[ (result) ] = cost; _rule[ (result) ] = rule;

#define DFA_PRODUCTION__SET_VALID(result, rule, cost)\
  DFA_PRODUCTION( (result), (rule), (cost) ); STATE__SET_VALID( (result) );

//------------------------- DFA --------------------------------------------
// DFA is a large switch with case statements for each ideal opcode encountered
// in any match rule in the ad file.  Each case has a series of if's to handle
// the match or fail decisions.  The matches test the cost function of that
// rule, and prune any cases which are higher cost for the same reduction.
// In order to generate the DFA we walk the table of ideal opcode/MatchList
// pairs generated by the ADLC front end to build the contents of the case
// statements (a series of if statements).


void  State::_sub_Op_RegN(const Node *n){
    {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RAX_REGN, rax_RegN_rule, c)
    }
    {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RREGN, rRegN_rule, c)
    }
}
void  State::_sub_Op_RegI(const Node *n){
    {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, no_rax_rdx_RegI_rule, c)
    }
    {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, no_rcx_RegI_rule, c)
    }
    {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RDI_REGI, rdi_RegI_rule, c)
        DFA_PRODUCTION__SET_VALID(RREGI, rRegI_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, rax_RegI_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, rbx_RegI_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, rcx_RegI_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, rdx_RegI_rule, c)
    }
    {
      unsigned int c = 0;
    }
    {
      unsigned int c = 0;
    }
    {
      unsigned int c = 0;
    }
    {
      unsigned int c = 0;
    }
    {
      unsigned int c = 0;
    }
}
void  State::_sub_Op_RegP(const Node *n){
    {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(REX_REGP, rex_RegP_rule, c)
    }
    {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(R15_REGP, r15_RegP_rule, c)
        DFA_PRODUCTION__SET_VALID(ANY_REGP, any_RegP_rule, c)
        DFA_PRODUCTION__SET_VALID(INDIRECT, indirect_rule, c)
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c)
        DFA_PRODUCTION__SET_VALID(RREGP, rRegP_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGP, rax_RegP_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGP, rbx_RegP_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, no_rax_RegP_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, no_rbp_RegP_rule, c)
        DFA_PRODUCTION__SET_VALID(RSI_REGP, rsi_RegP_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, no_rax_rbx_RegP_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGP, rdi_RegP_rule, c)
    }
    {
      unsigned int c = 0;
    }
    {
      unsigned int c = 0;
    }
    {
      unsigned int c = 0;
    }
    {
      unsigned int c = 0;
    }
    {
      unsigned int c = 0;
    }
    {
      unsigned int c = 0;
    }
    {
      unsigned int c = 0;
    }
    {
      unsigned int c = 0;
    }
    {
      unsigned int c = 0;
    }
}
void  State::_sub_Op_RegF(const Node *n){
    {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(VLREGF, vlRegF_rule, c)
        DFA_PRODUCTION__SET_VALID(REGF, MoveVL2F_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+100+95)
    }
    {
      unsigned int c = 0;
        DFA_PRODUCTION(LEGREGF, legRegF_rule, c)	  // overwrites higher cost rule
    }
    {
      unsigned int c = 0;
        DFA_PRODUCTION(REGF, regF_rule, c)	  // overwrites higher cost rule
        DFA_PRODUCTION(STACKSLOTF, storeSSF_rule, c+95)	  // overwrites higher cost rule
    }
}
void  State::_sub_Op_RegD(const Node *n){
    {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(VLREGD, vlRegD_rule, c)
        DFA_PRODUCTION__SET_VALID(REGD, MoveVL2D_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+100+95)
    }
    {
      unsigned int c = 0;
        DFA_PRODUCTION(LEGREGD, legRegD_rule, c)	  // overwrites higher cost rule
    }
    {
      unsigned int c = 0;
        DFA_PRODUCTION(REGD, regD_rule, c)	  // overwrites higher cost rule
        DFA_PRODUCTION(STACKSLOTD, storeSSD_rule, c+95)	  // overwrites higher cost rule
    }
}
void  State::_sub_Op_RegL(const Node *n){
    {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RDX_REGL, rdx_RegL_rule, c)
        DFA_PRODUCTION__SET_VALID(RREGL, rRegL_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, no_rax_rdx_RegL_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, no_rax_RegL_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, no_rcx_RegL_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGL, rax_RegL_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGL, rcx_RegL_rule, c)
    }
    {
      unsigned int c = 0;
    }
    {
      unsigned int c = 0;
    }
    {
      unsigned int c = 0;
    }
    {
      unsigned int c = 0;
    }
    {
      unsigned int c = 0;
    }
    {
      unsigned int c = 0;
    }
}
void  State::_sub_Op_RegFlags(const Node *n){
    if(         
#line 3748 "src/hotspot/cpu/x86/x86_64.ad"
false
#line 238 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RFLAGSREGUCF, rFlagsRegUCF_rule, c)
    }
    {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RFLAGSREGU, rFlagsRegU_rule, c)
    }
    {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, rFlagsReg_rule, c)
    }
}
void  State::_sub_Op_VecS(const Node *n){
    {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(LEGVECS, legVecS_rule, c)
        DFA_PRODUCTION__SET_VALID(VECS, MoveLeg2VecS_rule, c+100)
    }
    {
      unsigned int c = 0;
        DFA_PRODUCTION(VECS, vecS_rule, c)	  // overwrites higher cost rule
    }
}
void  State::_sub_Op_VecD(const Node *n){
    {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(LEGVECD, legVecD_rule, c)
        DFA_PRODUCTION__SET_VALID(VECD, MoveLeg2VecD_rule, c+100)
    }
    {
      unsigned int c = 0;
        DFA_PRODUCTION(VECD, vecD_rule, c)	  // overwrites higher cost rule
    }
}
void  State::_sub_Op_VecX(const Node *n){
    if(         
#line 4508 "src/hotspot/cpu/x86/x86_64.ad"
UseAVX == 3
#line 278 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RXMM31, rxmm31_rule, c)
    }
    if(         
#line 4504 "src/hotspot/cpu/x86/x86_64.ad"
UseAVX == 3
#line 286 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RXMM30, rxmm30_rule, c)
    }
    if(         
#line 4500 "src/hotspot/cpu/x86/x86_64.ad"
UseAVX == 3
#line 294 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RXMM29, rxmm29_rule, c)
    }
    if(         
#line 4496 "src/hotspot/cpu/x86/x86_64.ad"
UseAVX == 3
#line 302 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RXMM28, rxmm28_rule, c)
    }
    if(         
#line 4492 "src/hotspot/cpu/x86/x86_64.ad"
UseAVX == 3
#line 310 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RXMM27, rxmm27_rule, c)
    }
    if(         
#line 4488 "src/hotspot/cpu/x86/x86_64.ad"
UseAVX == 3
#line 318 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RXMM26, rxmm26_rule, c)
    }
    if(         
#line 4484 "src/hotspot/cpu/x86/x86_64.ad"
UseAVX == 3
#line 326 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RXMM25, rxmm25_rule, c)
    }
    if(         
#line 4480 "src/hotspot/cpu/x86/x86_64.ad"
UseAVX == 3
#line 334 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RXMM24, rxmm24_rule, c)
    }
    if(         
#line 4476 "src/hotspot/cpu/x86/x86_64.ad"
UseAVX == 3
#line 342 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RXMM23, rxmm23_rule, c)
    }
    if(         
#line 4472 "src/hotspot/cpu/x86/x86_64.ad"
UseAVX == 3
#line 350 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RXMM22, rxmm22_rule, c)
    }
    if(         
#line 4468 "src/hotspot/cpu/x86/x86_64.ad"
UseAVX == 3
#line 358 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RXMM21, rxmm21_rule, c)
    }
    if(         
#line 4464 "src/hotspot/cpu/x86/x86_64.ad"
UseAVX == 3
#line 366 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RXMM20, rxmm20_rule, c)
    }
    if(         
#line 4460 "src/hotspot/cpu/x86/x86_64.ad"
UseAVX == 3
#line 374 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RXMM19, rxmm19_rule, c)
    }
    if(         
#line 4456 "src/hotspot/cpu/x86/x86_64.ad"
UseAVX == 3
#line 382 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RXMM18, rxmm18_rule, c)
    }
    if(         
#line 4452 "src/hotspot/cpu/x86/x86_64.ad"
UseAVX == 3
#line 390 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RXMM17, rxmm17_rule, c)
    }
    if(         
#line 4448 "src/hotspot/cpu/x86/x86_64.ad"
UseAVX == 3
#line 398 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RXMM16, rxmm16_rule, c)
    }
    if(         
#line 4444 "src/hotspot/cpu/x86/x86_64.ad"
(UseSSE > 0) && (UseAVX <= 2)
#line 406 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RXMM15, rxmm15_rule, c)
    }
    if(         
#line 4440 "src/hotspot/cpu/x86/x86_64.ad"
(UseSSE > 0) && (UseAVX <= 2)
#line 414 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RXMM14, rxmm14_rule, c)
    }
    if(         
#line 4436 "src/hotspot/cpu/x86/x86_64.ad"
(UseSSE > 0) && (UseAVX <= 2)
#line 422 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RXMM13, rxmm13_rule, c)
    }
    if(         
#line 4432 "src/hotspot/cpu/x86/x86_64.ad"
(UseSSE > 0) && (UseAVX <= 2)
#line 430 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RXMM12, rxmm12_rule, c)
    }
    if(         
#line 4428 "src/hotspot/cpu/x86/x86_64.ad"
(UseSSE > 0) && (UseAVX <= 2)
#line 438 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RXMM11, rxmm11_rule, c)
    }
    if(         
#line 4424 "src/hotspot/cpu/x86/x86_64.ad"
(UseSSE > 0) && (UseAVX <= 2)
#line 446 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RXMM10, rxmm10_rule, c)
    }
    if(         
#line 4420 "src/hotspot/cpu/x86/x86_64.ad"
(UseSSE > 0) && (UseAVX <= 2)
#line 454 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RXMM9, rxmm9_rule, c)
    }
    if(         
#line 4416 "src/hotspot/cpu/x86/x86_64.ad"
(UseSSE > 0) && (UseAVX <= 2)
#line 462 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RXMM8, rxmm8_rule, c)
    }
    if(         
#line 4412 "src/hotspot/cpu/x86/x86_64.ad"
(UseSSE > 0) && (UseAVX <= 2)
#line 470 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RXMM7, rxmm7_rule, c)
    }
    if(         
#line 4408 "src/hotspot/cpu/x86/x86_64.ad"
(UseSSE > 0) && (UseAVX <= 2)
#line 478 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RXMM6, rxmm6_rule, c)
    }
    if(         
#line 4404 "src/hotspot/cpu/x86/x86_64.ad"
(UseSSE > 0) && (UseAVX <= 2)
#line 486 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RXMM5, rxmm5_rule, c)
    }
    if(         
#line 4400 "src/hotspot/cpu/x86/x86_64.ad"
(UseSSE > 0) && (UseAVX <= 2)
#line 494 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RXMM4, rxmm4_rule, c)
    }
    if(         
#line 4396 "src/hotspot/cpu/x86/x86_64.ad"
(UseSSE > 0) && (UseAVX <= 2)
#line 502 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RXMM3, rxmm3_rule, c)
    }
    if(         
#line 4392 "src/hotspot/cpu/x86/x86_64.ad"
(UseSSE > 0) && (UseAVX <= 2)
#line 510 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RXMM2, rxmm2_rule, c)
    }
    if(         
#line 4388 "src/hotspot/cpu/x86/x86_64.ad"
(UseSSE > 0) && (UseAVX <= 2)
#line 518 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RXMM1, rxmm1_rule, c)
    }
    if(         
#line 4384 "src/hotspot/cpu/x86/x86_64.ad"
(UseSSE > 0) && (UseAVX<= 2)
#line 526 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(RXMM0, rxmm0_rule, c)
    }
    {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(LEGVECX, legVecX_rule, c)
        DFA_PRODUCTION__SET_VALID(VECX, MoveLeg2VecX_rule, c+100)
    }
    {
      unsigned int c = 0;
        DFA_PRODUCTION(VECX, vecX_rule, c)	  // overwrites higher cost rule
    }
}
void  State::_sub_Op_VecY(const Node *n){
    {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(LEGVECY, legVecY_rule, c)
        DFA_PRODUCTION__SET_VALID(VECY, MoveLeg2VecY_rule, c+100)
    }
    {
      unsigned int c = 0;
        DFA_PRODUCTION(VECY, vecY_rule, c)	  // overwrites higher cost rule
    }
}
void  State::_sub_Op_VecZ(const Node *n){
    {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(LEGVECZ, legVecZ_rule, c)
        DFA_PRODUCTION__SET_VALID(VECZ, MoveLeg2VecZ_rule, c+100)
    }
    {
      unsigned int c = 0;
        DFA_PRODUCTION(VECZ, vecZ_rule, c)	  // overwrites higher cost rule
    }
}
void  State::_sub_Op_AbsD(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VLREGD) &&
        (
#line 2752 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 568 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VLREGD]+150;
        DFA_PRODUCTION__SET_VALID(VLREGD, absD_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(REGD, MoveVL2D_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+100+95)
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) &&
        (
#line 2740 "src/hotspot/cpu/x86/x86.ad"
(UseSSE>=2) && (UseAVX == 0)
#line 580 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+150;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, absD_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
}
void  State::_sub_Op_AbsF(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VLREGF) &&
        (
#line 2727 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 602 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VLREGF]+150;
        DFA_PRODUCTION__SET_VALID(VLREGF, absF_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(REGF, MoveVL2F_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+100+95)
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) &&
        (
#line 2716 "src/hotspot/cpu/x86/x86.ad"
(UseSSE>=1) && (UseAVX == 0)
#line 614 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+150;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, absF_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
}
void  State::_sub_Op_AbsI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, absI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, absI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, absI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, absI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, absI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, absI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, absI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, absI_rReg_rule, c)
    }
}
void  State::_sub_Op_AbsL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGL) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+100;
        DFA_PRODUCTION__SET_VALID(RREGL, absL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, absL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, absL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, absL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGL, absL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGL, absL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGL, absL_rReg_rule, c)
    }
}
void  State::_sub_Op_AddD(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], IMMD) &&
        (
#line 2278 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 663 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[IMMD]+150;
        DFA_PRODUCTION__SET_VALID(REGD, addD_reg_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADD_MEMORY_) && STATE__VALID_CHILD(_kids[1], REGD) &&
        (
#line 2266 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 675 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADD_MEMORY_]+_kids[1]->_cost[REGD]+150;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, addD_reg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], _LOADD_MEMORY_) &&
        (
#line 2266 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 695 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[_LOADD_MEMORY_]+150;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, addD_reg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], REGD) &&
        (
#line 2254 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 715 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[REGD]+150;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, addD_reg_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], IMMD) &&
        (
#line 2243 "src/hotspot/cpu/x86/x86.ad"
(UseSSE>=2) && (UseAVX == 0)
#line 735 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[IMMD]+150;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, addD_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADD_MEMORY_) && STATE__VALID_CHILD(_kids[1], REGD) &&
        (
#line 2231 "src/hotspot/cpu/x86/x86.ad"
(UseSSE>=2) && (UseAVX == 0)
#line 755 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADD_MEMORY_]+_kids[1]->_cost[REGD]+150;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, addD_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], _LOADD_MEMORY_) &&
        (
#line 2231 "src/hotspot/cpu/x86/x86.ad"
(UseSSE>=2) && (UseAVX == 0)
#line 775 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[_LOADD_MEMORY_]+150;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, addD_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], REGD) &&
        (
#line 2219 "src/hotspot/cpu/x86/x86.ad"
(UseSSE>=2) && (UseAVX == 0)
#line 795 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[REGD]+150;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, addD_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
}
void  State::_sub_Op_AddF(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], IMMF) &&
        (
#line 2207 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 817 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[IMMF]+150;
        DFA_PRODUCTION__SET_VALID(REGF, addF_reg_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADF_MEMORY_) && STATE__VALID_CHILD(_kids[1], REGF) &&
        (
#line 2195 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 829 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADF_MEMORY_]+_kids[1]->_cost[REGF]+150;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, addF_reg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], _LOADF_MEMORY_) &&
        (
#line 2195 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 849 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[_LOADF_MEMORY_]+150;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, addF_reg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], REGF) &&
        (
#line 2183 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 869 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[REGF]+150;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, addF_reg_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], IMMF) &&
        (
#line 2172 "src/hotspot/cpu/x86/x86.ad"
(UseSSE>=1) && (UseAVX == 0)
#line 889 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[IMMF]+150;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, addF_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADF_MEMORY_) && STATE__VALID_CHILD(_kids[1], REGF) &&
        (
#line 2160 "src/hotspot/cpu/x86/x86.ad"
(UseSSE>=1) && (UseAVX == 0)
#line 909 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADF_MEMORY_]+_kids[1]->_cost[REGF]+150;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, addF_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], _LOADF_MEMORY_) &&
        (
#line 2160 "src/hotspot/cpu/x86/x86.ad"
(UseSSE>=1) && (UseAVX == 0)
#line 929 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[_LOADF_MEMORY_]+150;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, addF_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], REGF) &&
        (
#line 2148 "src/hotspot/cpu/x86/x86.ad"
(UseSSE>=1) && (UseAVX == 0)
#line 949 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[REGF]+150;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, addF_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
}
void  State::_sub_Op_AddI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _SUBI_RREGI_RREGI) && STATE__VALID_CHILD(_kids[1], _ANDI_RREGI__CMPLTMASK_RREGI_RREGI) &&
        /*p*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[1]->_kids[0]->_leaf) && /*q*/(_kids[0]->_kids[1]->_leaf == _kids[1]->_kids[1]->_kids[1]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_SUBI_RREGI_RREGI]+_kids[1]->_cost[_ANDI_RREGI__CMPLTMASK_RREGI_RREGI]+300;
        DFA_PRODUCTION__SET_VALID(RREGI, cadd_cmpLTMask_2_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, cadd_cmpLTMask_2_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, cadd_cmpLTMask_2_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, cadd_cmpLTMask_2_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, cadd_cmpLTMask_2_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, cadd_cmpLTMask_2_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, cadd_cmpLTMask_2_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, cadd_cmpLTMask_2_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _ANDI_RREGI__CMPLTMASK_RREGI_RREGI) && STATE__VALID_CHILD(_kids[1], _SUBI_RREGI_RREGI) &&
        /*p*/(_kids[0]->_kids[1]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) && /*q*/(_kids[0]->_kids[1]->_kids[1]->_leaf == _kids[1]->_kids[1]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_ANDI_RREGI__CMPLTMASK_RREGI_RREGI]+_kids[1]->_cost[_SUBI_RREGI_RREGI]+300;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, cadd_cmpLTMask_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, cadd_cmpLTMask_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, cadd_cmpLTMask_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, cadd_cmpLTMask_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, cadd_cmpLTMask_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, cadd_cmpLTMask_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, cadd_cmpLTMask_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, cadd_cmpLTMask_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _SUBI_RREGI_RREGI) && STATE__VALID_CHILD(_kids[1], _ANDI__CMPLTMASK_RREGI_RREGI_RREGI) &&
        /*p*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) && /*q*/(_kids[0]->_kids[1]->_leaf == _kids[1]->_kids[0]->_kids[1]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_SUBI_RREGI_RREGI]+_kids[1]->_cost[_ANDI__CMPLTMASK_RREGI_RREGI_RREGI]+300;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, cadd_cmpLTMask_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, cadd_cmpLTMask_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, cadd_cmpLTMask_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, cadd_cmpLTMask_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, cadd_cmpLTMask_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, cadd_cmpLTMask_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, cadd_cmpLTMask_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, cadd_cmpLTMask_1_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _ANDI__CMPLTMASK_RREGI_RREGI_RREGI) && STATE__VALID_CHILD(_kids[1], _SUBI_RREGI_RREGI) &&
        /*p*/(_kids[0]->_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) && /*q*/(_kids[0]->_kids[0]->_kids[1]->_leaf == _kids[1]->_kids[1]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_ANDI__CMPLTMASK_RREGI_RREGI_RREGI]+_kids[1]->_cost[_SUBI_RREGI_RREGI]+300;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, cadd_cmpLTMask_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, cadd_cmpLTMask_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, cadd_cmpLTMask_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, cadd_cmpLTMask_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, cadd_cmpLTMask_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, cadd_cmpLTMask_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, cadd_cmpLTMask_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, cadd_cmpLTMask_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI_M1) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI_M1];
        DFA_PRODUCTION__SET_VALID(_ADDI_RREGI_IMMI_M1, _AddI_rRegI_immI_M1_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMI_M1) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[IMMI_M1];
        DFA_PRODUCTION__SET_VALID(_ADDI__LOADI_MEMORY__IMMI_M1, _AddI__LoadI_memory__immI_M1_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI_M1) &&
        (
#line 7560 "src/hotspot/cpu/x86/x86_64.ad"
UseIncDec
#line 1085 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI_M1]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, decI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, decI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, decI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, decI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, decI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, decI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, decI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, decI_rReg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMI1) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[IMMI1];
        DFA_PRODUCTION__SET_VALID(_ADDI__LOADI_MEMORY__IMMI1, _AddI__LoadI_memory__immI1_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI1) &&
        (
#line 7534 "src/hotspot/cpu/x86/x86_64.ad"
UseIncDec
#line 1124 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI1]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, incI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, incI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, incI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, incI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, incI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, incI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, incI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, incI_rReg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMI) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[IMMI];
        DFA_PRODUCTION__SET_VALID(_ADDI__LOADI_MEMORY__IMMI, _AddI__LoadI_memory__immI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], _LOADI_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[_LOADI_MEMORY_];
        DFA_PRODUCTION__SET_VALID(_ADDI_RREGI__LOADI_MEMORY_, _AddI_rRegI__LoadI_memory__rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[RREGI];
        DFA_PRODUCTION__SET_VALID(_ADDI__LOADI_MEMORY__RREGI, _AddI__LoadI_memory__rRegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[RREGI]+125;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, addI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, addI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, addI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, addI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, addI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, addI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, addI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, addI_rReg_mem_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], _LOADI_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[_LOADI_MEMORY_]+125;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, addI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, addI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, addI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, addI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, addI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, addI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, addI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, addI_rReg_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, addI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, addI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, addI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, addI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, addI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, addI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, addI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, addI_rReg_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, addI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, addI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, addI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, addI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, addI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, addI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, addI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, addI_rReg_rule, c)
      }
    }
}
void  State::_sub_Op_AddL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], IMML_M1) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[IMML_M1];
        DFA_PRODUCTION__SET_VALID(_ADDL_RREGL_IMML_M1, _AddL_rRegL_immL_M1_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMML_M1) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+_kids[1]->_cost[IMML_M1];
        DFA_PRODUCTION__SET_VALID(_ADDL__LOADL_MEMORY__IMML_M1, _AddL__LoadL_memory__immL_M1_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], IMML_M1) &&
        (
#line 7682 "src/hotspot/cpu/x86/x86_64.ad"
UseIncDec
#line 1301 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[IMML_M1]+100;
        DFA_PRODUCTION__SET_VALID(RREGL, decL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, decL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, decL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, decL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGL, decL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGL, decL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGL, decL_rReg_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMML1) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+_kids[1]->_cost[IMML1];
        DFA_PRODUCTION__SET_VALID(_ADDL__LOADL_MEMORY__IMML1, _AddL__LoadL_memory__immL1_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMML1) &&
        (
#line 7656 "src/hotspot/cpu/x86/x86_64.ad"
UseIncDec
#line 1321 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMML1]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, incL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, incL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, incL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, incL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, incL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, incL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, incL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, incL_rReg_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMML32) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+_kids[1]->_cost[IMML32];
        DFA_PRODUCTION__SET_VALID(_ADDL__LOADL_MEMORY__IMML32, _AddL__LoadL_memory__immL32_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], _LOADL_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[_LOADL_MEMORY_];
        DFA_PRODUCTION__SET_VALID(_ADDL_RREGL__LOADL_MEMORY_, _AddL_rRegL__LoadL_memory__rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], RREGL) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+_kids[1]->_cost[RREGL];
        DFA_PRODUCTION__SET_VALID(_ADDL__LOADL_MEMORY__RREGL, _AddL__LoadL_memory__rRegL_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], RREGL) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+_kids[1]->_cost[RREGL]+125;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, addL_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, addL_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, addL_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, addL_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, addL_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, addL_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, addL_rReg_mem_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], _LOADL_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[_LOADL_MEMORY_]+125;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, addL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, addL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, addL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, addL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, addL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, addL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, addL_rReg_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], IMML32) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[IMML32]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, addL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, addL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, addL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, addL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, addL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, addL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, addL_rReg_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], RREGL) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[RREGL]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, addL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, addL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, addL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, addL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, addL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, addL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, addL_rReg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LSHIFTL_RREGL_IMMI2) && STATE__VALID_CHILD(_kids[1], IMML32) ) {
      unsigned int c = _kids[0]->_cost[_LSHIFTL_RREGL_IMMI2]+_kids[1]->_cost[IMML32];
        DFA_PRODUCTION__SET_VALID(_ADDL__LSHIFTL_RREGL_IMMI2_IMML32, _AddL__LShiftL_rRegL_immI2_immL32_rule, c)
    }
}
void  State::_sub_Op_AddP(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGP) && STATE__VALID_CHILD(_kids[1], _SUBI_IMMI0_RREGI) ) {
      unsigned int c = _kids[0]->_cost[RREGP]+_kids[1]->_cost[_SUBI_IMMI0_RREGI]+100;
        DFA_PRODUCTION__SET_VALID(RREGP, subP_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+100)
        DFA_PRODUCTION__SET_VALID(ANY_REGP, subP_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(INDIRECT, subP_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGP, subP_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGP, subP_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, subP_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, subP_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RSI_REGP, subP_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, subP_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGP, subP_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(R15_REGP, subP_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(REX_REGP, subP_rReg_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGP) && STATE__VALID_CHILD(_kids[1], IMML32) ) {
      unsigned int c = _kids[0]->_cost[RREGP]+_kids[1]->_cost[IMML32]+100;
      if (STATE__NOT_YET_VALID(RREGP) || _cost[RREGP] > c) {
        DFA_PRODUCTION__SET_VALID(RREGP, addP_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTP) || _cost[STACKSLOTP] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(ANY_REGP) || _cost[ANY_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(ANY_REGP, addP_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(INDIRECT) || _cost[INDIRECT] > c) {
        DFA_PRODUCTION__SET_VALID(INDIRECT, addP_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGP) || _cost[RAX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGP, addP_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGP) || _cost[RBX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGP, addP_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGP) || _cost[NO_RAX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, addP_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RBP_REGP) || _cost[NO_RBP_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, addP_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RSI_REGP) || _cost[RSI_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(RSI_REGP, addP_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RBX_REGP) || _cost[NO_RAX_RBX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, addP_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGP) || _cost[RDI_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGP, addP_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(R15_REGP) || _cost[R15_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(R15_REGP, addP_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(REX_REGP) || _cost[REX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(REX_REGP, addP_rReg_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGP) && STATE__VALID_CHILD(_kids[1], RREGL) ) {
      unsigned int c = _kids[0]->_cost[RREGP]+_kids[1]->_cost[RREGL]+100;
      if (STATE__NOT_YET_VALID(RREGP) || _cost[RREGP] > c) {
        DFA_PRODUCTION__SET_VALID(RREGP, addP_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTP) || _cost[STACKSLOTP] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(ANY_REGP) || _cost[ANY_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(ANY_REGP, addP_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(INDIRECT) || _cost[INDIRECT] > c) {
        DFA_PRODUCTION__SET_VALID(INDIRECT, addP_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGP) || _cost[RAX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGP, addP_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGP) || _cost[RBX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGP, addP_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGP) || _cost[NO_RAX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, addP_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RBP_REGP) || _cost[NO_RBP_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, addP_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RSI_REGP) || _cost[RSI_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(RSI_REGP, addP_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RBX_REGP) || _cost[NO_RAX_RBX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, addP_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGP) || _cost[RDI_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGP, addP_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(R15_REGP) || _cost[R15_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(R15_REGP, addP_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(REX_REGP) || _cost[REX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(REX_REGP, addP_rReg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _ADDP__DECODEN_RREGN___LSHIFTL__CONVI2L_RREGI__IMMI2) && STATE__VALID_CHILD(_kids[1], IMML32) &&
        
#line 4203 "src/hotspot/cpu/x86/x86_64.ad"
Universe::narrow_oop_shift() == 0 && n->in(2)->in(3)->in(1)->as_Type()->type()->is_long()->_lo >= 0
#line 1571 "dfa_x86.cpp"
 ) {
      unsigned int c = _kids[0]->_cost[_ADDP__DECODEN_RREGN___LSHIFTL__CONVI2L_RREGI__IMMI2]+_kids[1]->_cost[IMML32]+10;
        DFA_PRODUCTION__SET_VALID(INDPOSINDEXSCALEOFFSETNARROW, indPosIndexScaleOffsetNarrow_rule, c)
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indPosIndexScaleOffsetNarrow_rule, c)
      }
      if (STATE__NOT_YET_VALID(RREGP) || _cost[RREGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RREGP, leaPPosIdxScaleOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTP) || _cost[STACKSLOTP] > c+110+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+110+100)
      }
      if (STATE__NOT_YET_VALID(ANY_REGP) || _cost[ANY_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(ANY_REGP, leaPPosIdxScaleOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(INDIRECT) || _cost[INDIRECT] > c+110) {
        DFA_PRODUCTION__SET_VALID(INDIRECT, leaPPosIdxScaleOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c+110) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RAX_REGP) || _cost[RAX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RAX_REGP, leaPPosIdxScaleOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RBX_REGP) || _cost[RBX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RBX_REGP, leaPPosIdxScaleOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGP) || _cost[NO_RAX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, leaPPosIdxScaleOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RBP_REGP) || _cost[NO_RBP_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, leaPPosIdxScaleOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RSI_REGP) || _cost[RSI_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RSI_REGP, leaPPosIdxScaleOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RBX_REGP) || _cost[NO_RAX_RBX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, leaPPosIdxScaleOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RDI_REGP) || _cost[RDI_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RDI_REGP, leaPPosIdxScaleOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(R15_REGP) || _cost[R15_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(R15_REGP, leaPPosIdxScaleOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(REX_REGP) || _cost[REX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(REX_REGP, leaPPosIdxScaleOffNarrow_rule, c+110)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _DECODEN_RREGN_) && STATE__VALID_CHILD(_kids[1], _LSHIFTL__CONVI2L_RREGI__IMMI2) ) {
      unsigned int c = _kids[0]->_cost[_DECODEN_RREGN_]+_kids[1]->_cost[_LSHIFTL__CONVI2L_RREGI__IMMI2];
        DFA_PRODUCTION__SET_VALID(_ADDP__DECODEN_RREGN___LSHIFTL__CONVI2L_RREGI__IMMI2, _AddP__DecodeN_rRegN___LShiftL__ConvI2L_rRegI__immI2_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _ADDP__DECODEN_RREGN___CONVI2L_RREGI_) && STATE__VALID_CHILD(_kids[1], IMML32) &&
        
#line 4186 "src/hotspot/cpu/x86/x86_64.ad"
Universe::narrow_oop_shift() == 0 && n->in(2)->in(3)->as_Type()->type()->is_long()->_lo >= 0
#line 1629 "dfa_x86.cpp"
 ) {
      unsigned int c = _kids[0]->_cost[_ADDP__DECODEN_RREGN___CONVI2L_RREGI_]+_kids[1]->_cost[IMML32]+10;
        DFA_PRODUCTION__SET_VALID(INDPOSINDEXOFFSETNARROW, indPosIndexOffsetNarrow_rule, c)
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indPosIndexOffsetNarrow_rule, c)
      }
      if (STATE__NOT_YET_VALID(RREGP) || _cost[RREGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RREGP, leaPPosIdxOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTP) || _cost[STACKSLOTP] > c+110+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+110+100)
      }
      if (STATE__NOT_YET_VALID(ANY_REGP) || _cost[ANY_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(ANY_REGP, leaPPosIdxOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(INDIRECT) || _cost[INDIRECT] > c+110) {
        DFA_PRODUCTION__SET_VALID(INDIRECT, leaPPosIdxOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c+110) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RAX_REGP) || _cost[RAX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RAX_REGP, leaPPosIdxOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RBX_REGP) || _cost[RBX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RBX_REGP, leaPPosIdxOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGP) || _cost[NO_RAX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, leaPPosIdxOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RBP_REGP) || _cost[NO_RBP_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, leaPPosIdxOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RSI_REGP) || _cost[RSI_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RSI_REGP, leaPPosIdxOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RBX_REGP) || _cost[NO_RAX_RBX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, leaPPosIdxOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RDI_REGP) || _cost[RDI_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RDI_REGP, leaPPosIdxOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(R15_REGP) || _cost[R15_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(R15_REGP, leaPPosIdxOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(REX_REGP) || _cost[REX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(REX_REGP, leaPPosIdxOffNarrow_rule, c+110)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _DECODEN_RREGN_) && STATE__VALID_CHILD(_kids[1], _CONVI2L_RREGI_) ) {
      unsigned int c = _kids[0]->_cost[_DECODEN_RREGN_]+_kids[1]->_cost[_CONVI2L_RREGI_];
        DFA_PRODUCTION__SET_VALID(_ADDP__DECODEN_RREGN___CONVI2L_RREGI_, _AddP__DecodeN_rRegN___ConvI2L_rRegI__rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _ADDP__DECODEN_RREGN___LSHIFTL_RREGL_IMMI2) && STATE__VALID_CHILD(_kids[1], IMML32) &&
        
#line 4168 "src/hotspot/cpu/x86/x86_64.ad"
Universe::narrow_oop_shift() == 0
#line 1687 "dfa_x86.cpp"
 ) {
      unsigned int c = _kids[0]->_cost[_ADDP__DECODEN_RREGN___LSHIFTL_RREGL_IMMI2]+_kids[1]->_cost[IMML32]+10;
        DFA_PRODUCTION__SET_VALID(INDINDEXSCALEOFFSETNARROW, indIndexScaleOffsetNarrow_rule, c)
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indIndexScaleOffsetNarrow_rule, c)
      }
      if (STATE__NOT_YET_VALID(RREGP) || _cost[RREGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RREGP, leaPIdxScaleOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTP) || _cost[STACKSLOTP] > c+110+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+110+100)
      }
      if (STATE__NOT_YET_VALID(ANY_REGP) || _cost[ANY_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(ANY_REGP, leaPIdxScaleOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(INDIRECT) || _cost[INDIRECT] > c+110) {
        DFA_PRODUCTION__SET_VALID(INDIRECT, leaPIdxScaleOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c+110) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RAX_REGP) || _cost[RAX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RAX_REGP, leaPIdxScaleOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RBX_REGP) || _cost[RBX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RBX_REGP, leaPIdxScaleOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGP) || _cost[NO_RAX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, leaPIdxScaleOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RBP_REGP) || _cost[NO_RBP_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, leaPIdxScaleOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RSI_REGP) || _cost[RSI_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RSI_REGP, leaPIdxScaleOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RBX_REGP) || _cost[NO_RAX_RBX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, leaPIdxScaleOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RDI_REGP) || _cost[RDI_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RDI_REGP, leaPIdxScaleOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(R15_REGP) || _cost[R15_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(R15_REGP, leaPIdxScaleOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(REX_REGP) || _cost[REX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(REX_REGP, leaPIdxScaleOffNarrow_rule, c+110)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _DECODEN_RREGN_) && STATE__VALID_CHILD(_kids[1], _LSHIFTL_RREGL_IMMI2) ) {
      unsigned int c = _kids[0]->_cost[_DECODEN_RREGN_]+_kids[1]->_cost[_LSHIFTL_RREGL_IMMI2];
        DFA_PRODUCTION__SET_VALID(_ADDP__DECODEN_RREGN___LSHIFTL_RREGL_IMMI2, _AddP__DecodeN_rRegN___LShiftL_rRegL_immI2_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _DECODEN_RREGN_) && STATE__VALID_CHILD(_kids[1], _LSHIFTL_RREGL_IMMI2) &&
        
#line 4151 "src/hotspot/cpu/x86/x86_64.ad"
Universe::narrow_oop_shift() == 0
#line 1745 "dfa_x86.cpp"
 ) {
      unsigned int c = _kids[0]->_cost[_DECODEN_RREGN_]+_kids[1]->_cost[_LSHIFTL_RREGL_IMMI2]+10;
        DFA_PRODUCTION__SET_VALID(INDINDEXSCALENARROW, indIndexScaleNarrow_rule, c)
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indIndexScaleNarrow_rule, c)
      }
      if (STATE__NOT_YET_VALID(RREGP) || _cost[RREGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RREGP, leaPIdxScaleNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTP) || _cost[STACKSLOTP] > c+110+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+110+100)
      }
      if (STATE__NOT_YET_VALID(ANY_REGP) || _cost[ANY_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(ANY_REGP, leaPIdxScaleNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(INDIRECT) || _cost[INDIRECT] > c+110) {
        DFA_PRODUCTION__SET_VALID(INDIRECT, leaPIdxScaleNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c+110) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RAX_REGP) || _cost[RAX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RAX_REGP, leaPIdxScaleNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RBX_REGP) || _cost[RBX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RBX_REGP, leaPIdxScaleNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGP) || _cost[NO_RAX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, leaPIdxScaleNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RBP_REGP) || _cost[NO_RBP_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, leaPIdxScaleNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RSI_REGP) || _cost[RSI_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RSI_REGP, leaPIdxScaleNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RBX_REGP) || _cost[NO_RAX_RBX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, leaPIdxScaleNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RDI_REGP) || _cost[RDI_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RDI_REGP, leaPIdxScaleNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(R15_REGP) || _cost[R15_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(R15_REGP, leaPIdxScaleNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(REX_REGP) || _cost[REX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(REX_REGP, leaPIdxScaleNarrow_rule, c+110)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _DECODEN_RREGN_) && STATE__VALID_CHILD(_kids[1], RREGL) &&
        
#line 4134 "src/hotspot/cpu/x86/x86_64.ad"
Universe::narrow_oop_shift() == 0
#line 1799 "dfa_x86.cpp"
 ) {
      unsigned int c = _kids[0]->_cost[_DECODEN_RREGN_]+_kids[1]->_cost[RREGL]+10;
        DFA_PRODUCTION__SET_VALID(INDINDEXNARROW, indIndexNarrow_rule, c)
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indIndexNarrow_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _ADDP__DECODEN_RREGN__RREGL) && STATE__VALID_CHILD(_kids[1], IMML32) &&
        
#line 4117 "src/hotspot/cpu/x86/x86_64.ad"
Universe::narrow_oop_shift() == 0
#line 1811 "dfa_x86.cpp"
 ) {
      unsigned int c = _kids[0]->_cost[_ADDP__DECODEN_RREGN__RREGL]+_kids[1]->_cost[IMML32]+10;
        DFA_PRODUCTION__SET_VALID(INDINDEXOFFSETNARROW, indIndexOffsetNarrow_rule, c)
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indIndexOffsetNarrow_rule, c)
      }
      if (STATE__NOT_YET_VALID(RREGP) || _cost[RREGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RREGP, leaPIdxOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTP) || _cost[STACKSLOTP] > c+110+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+110+100)
      }
      if (STATE__NOT_YET_VALID(ANY_REGP) || _cost[ANY_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(ANY_REGP, leaPIdxOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(INDIRECT) || _cost[INDIRECT] > c+110) {
        DFA_PRODUCTION__SET_VALID(INDIRECT, leaPIdxOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c+110) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RAX_REGP) || _cost[RAX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RAX_REGP, leaPIdxOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RBX_REGP) || _cost[RBX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RBX_REGP, leaPIdxOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGP) || _cost[NO_RAX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, leaPIdxOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RBP_REGP) || _cost[NO_RBP_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, leaPIdxOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RSI_REGP) || _cost[RSI_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RSI_REGP, leaPIdxOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RBX_REGP) || _cost[NO_RAX_RBX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, leaPIdxOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RDI_REGP) || _cost[RDI_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RDI_REGP, leaPIdxOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(R15_REGP) || _cost[R15_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(R15_REGP, leaPIdxOffNarrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(REX_REGP) || _cost[REX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(REX_REGP, leaPIdxOffNarrow_rule, c+110)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _DECODEN_RREGN_) && STATE__VALID_CHILD(_kids[1], RREGL) ) {
      unsigned int c = _kids[0]->_cost[_DECODEN_RREGN_]+_kids[1]->_cost[RREGL];
        DFA_PRODUCTION__SET_VALID(_ADDP__DECODEN_RREGN__RREGL, _AddP__DecodeN_rRegN__rRegL_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _DECODEN_RREGN_) && STATE__VALID_CHILD(_kids[1], IMML32) &&
        
#line 4101 "src/hotspot/cpu/x86/x86_64.ad"
Universe::narrow_oop_shift() == 0
#line 1869 "dfa_x86.cpp"
 ) {
      unsigned int c = _kids[0]->_cost[_DECODEN_RREGN_]+_kids[1]->_cost[IMML32];
        DFA_PRODUCTION__SET_VALID(INDOFFSET32NARROW, indOffset32Narrow_rule, c)
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indOffset32Narrow_rule, c)
      }
      if (STATE__NOT_YET_VALID(RREGP) || _cost[RREGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RREGP, leaP32Narrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTP) || _cost[STACKSLOTP] > c+110+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+110+100)
      }
      if (STATE__NOT_YET_VALID(ANY_REGP) || _cost[ANY_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(ANY_REGP, leaP32Narrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(INDIRECT) || _cost[INDIRECT] > c+110) {
        DFA_PRODUCTION__SET_VALID(INDIRECT, leaP32Narrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c+110) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RAX_REGP) || _cost[RAX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RAX_REGP, leaP32Narrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RBX_REGP) || _cost[RBX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RBX_REGP, leaP32Narrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGP) || _cost[NO_RAX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, leaP32Narrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RBP_REGP) || _cost[NO_RBP_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, leaP32Narrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RSI_REGP) || _cost[RSI_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RSI_REGP, leaP32Narrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RBX_REGP) || _cost[NO_RAX_RBX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, leaP32Narrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RDI_REGP) || _cost[RDI_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RDI_REGP, leaP32Narrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(R15_REGP) || _cost[R15_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(R15_REGP, leaP32Narrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(REX_REGP) || _cost[REX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(REX_REGP, leaP32Narrow_rule, c+110)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _DECODEN_RREGN_) && STATE__VALID_CHILD(_kids[1], IMML8) &&
        
#line 4085 "src/hotspot/cpu/x86/x86_64.ad"
Universe::narrow_oop_shift() == 0
#line 1923 "dfa_x86.cpp"
 ) {
      unsigned int c = _kids[0]->_cost[_DECODEN_RREGN_]+_kids[1]->_cost[IMML8];
        DFA_PRODUCTION__SET_VALID(INDOFFSET8NARROW, indOffset8Narrow_rule, c)
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indOffset8Narrow_rule, c)
      }
      if (STATE__NOT_YET_VALID(RREGP) || _cost[RREGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RREGP, leaP8Narrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTP) || _cost[STACKSLOTP] > c+110+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+110+100)
      }
      if (STATE__NOT_YET_VALID(ANY_REGP) || _cost[ANY_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(ANY_REGP, leaP8Narrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(INDIRECT) || _cost[INDIRECT] > c+110) {
        DFA_PRODUCTION__SET_VALID(INDIRECT, leaP8Narrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c+110) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RAX_REGP) || _cost[RAX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RAX_REGP, leaP8Narrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RBX_REGP) || _cost[RBX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RBX_REGP, leaP8Narrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGP) || _cost[NO_RAX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, leaP8Narrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RBP_REGP) || _cost[NO_RBP_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, leaP8Narrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RSI_REGP) || _cost[RSI_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RSI_REGP, leaP8Narrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RBX_REGP) || _cost[NO_RAX_RBX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, leaP8Narrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RDI_REGP) || _cost[RDI_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RDI_REGP, leaP8Narrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(R15_REGP) || _cost[R15_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(R15_REGP, leaP8Narrow_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(REX_REGP) || _cost[REX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(REX_REGP, leaP8Narrow_rule, c+110)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _DECODEN_RREGN_) && STATE__VALID_CHILD(_kids[1], IMML32) &&
        
#line 4052 "src/hotspot/cpu/x86/x86_64.ad"
UseCompressedOops && (Universe::narrow_oop_shift() == Address::times_8)
#line 1977 "dfa_x86.cpp"
 ) {
      unsigned int c = _kids[0]->_cost[_DECODEN_RREGN_]+_kids[1]->_cost[IMML32]+10;
        DFA_PRODUCTION__SET_VALID(INDCOMPRESSEDOOPOFFSET, indCompressedOopOffset_rule, c)
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indCompressedOopOffset_rule, c)
      }
      if (STATE__NOT_YET_VALID(RREGP) || _cost[RREGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RREGP, leaPCompressedOopOffset_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTP) || _cost[STACKSLOTP] > c+110+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+110+100)
      }
      if (STATE__NOT_YET_VALID(ANY_REGP) || _cost[ANY_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(ANY_REGP, leaPCompressedOopOffset_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(INDIRECT) || _cost[INDIRECT] > c+110) {
        DFA_PRODUCTION__SET_VALID(INDIRECT, leaPCompressedOopOffset_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c+110) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RAX_REGP) || _cost[RAX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RAX_REGP, leaPCompressedOopOffset_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RBX_REGP) || _cost[RBX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RBX_REGP, leaPCompressedOopOffset_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGP) || _cost[NO_RAX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, leaPCompressedOopOffset_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RBP_REGP) || _cost[NO_RBP_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, leaPCompressedOopOffset_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RSI_REGP) || _cost[RSI_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RSI_REGP, leaPCompressedOopOffset_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RBX_REGP) || _cost[NO_RAX_RBX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, leaPCompressedOopOffset_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RDI_REGP) || _cost[RDI_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RDI_REGP, leaPCompressedOopOffset_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(R15_REGP) || _cost[R15_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(R15_REGP, leaPCompressedOopOffset_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(REX_REGP) || _cost[REX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(REX_REGP, leaPCompressedOopOffset_rule, c+110)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _ADDP_ANY_REGP__LSHIFTL__CONVI2L_RREGI__IMMI2) && STATE__VALID_CHILD(_kids[1], IMML32) &&
        
#line 4035 "src/hotspot/cpu/x86/x86_64.ad"
n->in(2)->in(3)->in(1)->as_Type()->type()->is_long()->_lo >= 0
#line 2031 "dfa_x86.cpp"
 ) {
      unsigned int c = _kids[0]->_cost[_ADDP_ANY_REGP__LSHIFTL__CONVI2L_RREGI__IMMI2]+_kids[1]->_cost[IMML32]+10;
        DFA_PRODUCTION__SET_VALID(INDPOSINDEXSCALEOFFSET, indPosIndexScaleOffset_rule, c)
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indPosIndexScaleOffset_rule, c)
      }
      if (STATE__NOT_YET_VALID(RREGP) || _cost[RREGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RREGP, leaPPosIdxScaleOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTP) || _cost[STACKSLOTP] > c+110+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+110+100)
      }
      if (STATE__NOT_YET_VALID(ANY_REGP) || _cost[ANY_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(ANY_REGP, leaPPosIdxScaleOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(INDIRECT) || _cost[INDIRECT] > c+110) {
        DFA_PRODUCTION__SET_VALID(INDIRECT, leaPPosIdxScaleOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c+110) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RAX_REGP) || _cost[RAX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RAX_REGP, leaPPosIdxScaleOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RBX_REGP) || _cost[RBX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RBX_REGP, leaPPosIdxScaleOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGP) || _cost[NO_RAX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, leaPPosIdxScaleOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RBP_REGP) || _cost[NO_RBP_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, leaPPosIdxScaleOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RSI_REGP) || _cost[RSI_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RSI_REGP, leaPPosIdxScaleOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RBX_REGP) || _cost[NO_RAX_RBX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, leaPPosIdxScaleOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RDI_REGP) || _cost[RDI_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RDI_REGP, leaPPosIdxScaleOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(R15_REGP) || _cost[R15_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(R15_REGP, leaPPosIdxScaleOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(REX_REGP) || _cost[REX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(REX_REGP, leaPPosIdxScaleOff_rule, c+110)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], ANY_REGP) && STATE__VALID_CHILD(_kids[1], _LSHIFTL__CONVI2L_RREGI__IMMI2) ) {
      unsigned int c = _kids[0]->_cost[ANY_REGP]+_kids[1]->_cost[_LSHIFTL__CONVI2L_RREGI__IMMI2];
        DFA_PRODUCTION__SET_VALID(_ADDP_ANY_REGP__LSHIFTL__CONVI2L_RREGI__IMMI2, _AddP_any_RegP__LShiftL__ConvI2L_rRegI__immI2_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _ADDP_ANY_REGP__CONVI2L_RREGI_) && STATE__VALID_CHILD(_kids[1], IMML32) &&
        
#line 4018 "src/hotspot/cpu/x86/x86_64.ad"
n->in(2)->in(3)->as_Type()->type()->is_long()->_lo >= 0
#line 2089 "dfa_x86.cpp"
 ) {
      unsigned int c = _kids[0]->_cost[_ADDP_ANY_REGP__CONVI2L_RREGI_]+_kids[1]->_cost[IMML32]+10;
        DFA_PRODUCTION__SET_VALID(INDPOSINDEXOFFSET, indPosIndexOffset_rule, c)
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indPosIndexOffset_rule, c)
      }
      if (STATE__NOT_YET_VALID(RREGP) || _cost[RREGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RREGP, leaPPosIdxOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTP) || _cost[STACKSLOTP] > c+110+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+110+100)
      }
      if (STATE__NOT_YET_VALID(ANY_REGP) || _cost[ANY_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(ANY_REGP, leaPPosIdxOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(INDIRECT) || _cost[INDIRECT] > c+110) {
        DFA_PRODUCTION__SET_VALID(INDIRECT, leaPPosIdxOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c+110) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RAX_REGP) || _cost[RAX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RAX_REGP, leaPPosIdxOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RBX_REGP) || _cost[RBX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RBX_REGP, leaPPosIdxOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGP) || _cost[NO_RAX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, leaPPosIdxOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RBP_REGP) || _cost[NO_RBP_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, leaPPosIdxOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RSI_REGP) || _cost[RSI_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RSI_REGP, leaPPosIdxOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RBX_REGP) || _cost[NO_RAX_RBX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, leaPPosIdxOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RDI_REGP) || _cost[RDI_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RDI_REGP, leaPPosIdxOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(R15_REGP) || _cost[R15_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(R15_REGP, leaPPosIdxOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(REX_REGP) || _cost[REX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(REX_REGP, leaPPosIdxOff_rule, c+110)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], ANY_REGP) && STATE__VALID_CHILD(_kids[1], _CONVI2L_RREGI_) ) {
      unsigned int c = _kids[0]->_cost[ANY_REGP]+_kids[1]->_cost[_CONVI2L_RREGI_];
        DFA_PRODUCTION__SET_VALID(_ADDP_ANY_REGP__CONVI2L_RREGI_, _AddP_any_RegP__ConvI2L_rRegI__rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _ADDP_ANY_REGP__LSHIFTL_RREGL_IMMI2) && STATE__VALID_CHILD(_kids[1], IMML32) ) {
      unsigned int c = _kids[0]->_cost[_ADDP_ANY_REGP__LSHIFTL_RREGL_IMMI2]+_kids[1]->_cost[IMML32]+10;
        DFA_PRODUCTION__SET_VALID(INDINDEXSCALEOFFSET, indIndexScaleOffset_rule, c)
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indIndexScaleOffset_rule, c)
      }
      if (STATE__NOT_YET_VALID(RREGP) || _cost[RREGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RREGP, leaPIdxScaleOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTP) || _cost[STACKSLOTP] > c+110+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+110+100)
      }
      if (STATE__NOT_YET_VALID(ANY_REGP) || _cost[ANY_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(ANY_REGP, leaPIdxScaleOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(INDIRECT) || _cost[INDIRECT] > c+110) {
        DFA_PRODUCTION__SET_VALID(INDIRECT, leaPIdxScaleOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c+110) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RAX_REGP) || _cost[RAX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RAX_REGP, leaPIdxScaleOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RBX_REGP) || _cost[RBX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RBX_REGP, leaPIdxScaleOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGP) || _cost[NO_RAX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, leaPIdxScaleOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RBP_REGP) || _cost[NO_RBP_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, leaPIdxScaleOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RSI_REGP) || _cost[RSI_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RSI_REGP, leaPIdxScaleOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RBX_REGP) || _cost[NO_RAX_RBX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, leaPIdxScaleOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RDI_REGP) || _cost[RDI_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RDI_REGP, leaPIdxScaleOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(R15_REGP) || _cost[R15_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(R15_REGP, leaPIdxScaleOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(REX_REGP) || _cost[REX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(REX_REGP, leaPIdxScaleOff_rule, c+110)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], ANY_REGP) && STATE__VALID_CHILD(_kids[1], _LSHIFTL_RREGL_IMMI2) ) {
      unsigned int c = _kids[0]->_cost[ANY_REGP]+_kids[1]->_cost[_LSHIFTL_RREGL_IMMI2];
        DFA_PRODUCTION__SET_VALID(_ADDP_ANY_REGP__LSHIFTL_RREGL_IMMI2, _AddP_any_RegP__LShiftL_rRegL_immI2_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], ANY_REGP) && STATE__VALID_CHILD(_kids[1], _LSHIFTL__CONVI2L_RREGI__IMMI2) &&
        
#line 3985 "src/hotspot/cpu/x86/x86_64.ad"
n->in(3)->in(1)->as_Type()->type()->is_long()->_lo >= 0
#line 2200 "dfa_x86.cpp"
 ) {
      unsigned int c = _kids[0]->_cost[ANY_REGP]+_kids[1]->_cost[_LSHIFTL__CONVI2L_RREGI__IMMI2]+10;
        DFA_PRODUCTION__SET_VALID(INDPOSINDEXSCALE, indPosIndexScale_rule, c)
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indPosIndexScale_rule, c)
      }
      if (STATE__NOT_YET_VALID(RREGP) || _cost[RREGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RREGP, leaPPosIdxScale_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTP) || _cost[STACKSLOTP] > c+110+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+110+100)
      }
      if (STATE__NOT_YET_VALID(ANY_REGP) || _cost[ANY_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(ANY_REGP, leaPPosIdxScale_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(INDIRECT) || _cost[INDIRECT] > c+110) {
        DFA_PRODUCTION__SET_VALID(INDIRECT, leaPPosIdxScale_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c+110) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RAX_REGP) || _cost[RAX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RAX_REGP, leaPPosIdxScale_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RBX_REGP) || _cost[RBX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RBX_REGP, leaPPosIdxScale_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGP) || _cost[NO_RAX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, leaPPosIdxScale_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RBP_REGP) || _cost[NO_RBP_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, leaPPosIdxScale_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RSI_REGP) || _cost[RSI_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RSI_REGP, leaPPosIdxScale_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RBX_REGP) || _cost[NO_RAX_RBX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, leaPPosIdxScale_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RDI_REGP) || _cost[RDI_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RDI_REGP, leaPPosIdxScale_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(R15_REGP) || _cost[R15_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(R15_REGP, leaPPosIdxScale_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(REX_REGP) || _cost[REX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(REX_REGP, leaPPosIdxScale_rule, c+110)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], ANY_REGP) && STATE__VALID_CHILD(_kids[1], _LSHIFTL_RREGL_IMMI2) ) {
      unsigned int c = _kids[0]->_cost[ANY_REGP]+_kids[1]->_cost[_LSHIFTL_RREGL_IMMI2]+10;
        DFA_PRODUCTION__SET_VALID(INDINDEXSCALE, indIndexScale_rule, c)
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indIndexScale_rule, c)
      }
      if (STATE__NOT_YET_VALID(RREGP) || _cost[RREGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RREGP, leaPIdxScale_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTP) || _cost[STACKSLOTP] > c+110+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+110+100)
      }
      if (STATE__NOT_YET_VALID(ANY_REGP) || _cost[ANY_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(ANY_REGP, leaPIdxScale_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(INDIRECT) || _cost[INDIRECT] > c+110) {
        DFA_PRODUCTION__SET_VALID(INDIRECT, leaPIdxScale_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c+110) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RAX_REGP) || _cost[RAX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RAX_REGP, leaPIdxScale_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RBX_REGP) || _cost[RBX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RBX_REGP, leaPIdxScale_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGP) || _cost[NO_RAX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, leaPIdxScale_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RBP_REGP) || _cost[NO_RBP_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, leaPIdxScale_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RSI_REGP) || _cost[RSI_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RSI_REGP, leaPIdxScale_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RBX_REGP) || _cost[NO_RAX_RBX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, leaPIdxScale_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RDI_REGP) || _cost[RDI_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RDI_REGP, leaPIdxScale_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(R15_REGP) || _cost[R15_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(R15_REGP, leaPIdxScale_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(REX_REGP) || _cost[REX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(REX_REGP, leaPIdxScale_rule, c+110)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], ANY_REGP) && STATE__VALID_CHILD(_kids[1], RREGL) ) {
      unsigned int c = _kids[0]->_cost[ANY_REGP]+_kids[1]->_cost[RREGL]+10;
        DFA_PRODUCTION__SET_VALID(INDINDEX, indIndex_rule, c)
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indIndex_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _ADDP_ANY_REGP_RREGL) && STATE__VALID_CHILD(_kids[1], IMML32) ) {
      unsigned int c = _kids[0]->_cost[_ADDP_ANY_REGP_RREGL]+_kids[1]->_cost[IMML32]+10;
        DFA_PRODUCTION__SET_VALID(INDINDEXOFFSET, indIndexOffset_rule, c)
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indIndexOffset_rule, c)
      }
      if (STATE__NOT_YET_VALID(RREGP) || _cost[RREGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RREGP, leaPIdxOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTP) || _cost[STACKSLOTP] > c+110+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+110+100)
      }
      if (STATE__NOT_YET_VALID(ANY_REGP) || _cost[ANY_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(ANY_REGP, leaPIdxOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(INDIRECT) || _cost[INDIRECT] > c+110) {
        DFA_PRODUCTION__SET_VALID(INDIRECT, leaPIdxOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c+110) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RAX_REGP) || _cost[RAX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RAX_REGP, leaPIdxOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RBX_REGP) || _cost[RBX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RBX_REGP, leaPIdxOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGP) || _cost[NO_RAX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, leaPIdxOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RBP_REGP) || _cost[NO_RBP_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, leaPIdxOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RSI_REGP) || _cost[RSI_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RSI_REGP, leaPIdxOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RBX_REGP) || _cost[NO_RAX_RBX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, leaPIdxOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RDI_REGP) || _cost[RDI_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RDI_REGP, leaPIdxOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(R15_REGP) || _cost[R15_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(R15_REGP, leaPIdxOff_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(REX_REGP) || _cost[REX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(REX_REGP, leaPIdxOff_rule, c+110)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], ANY_REGP) && STATE__VALID_CHILD(_kids[1], RREGL) ) {
      unsigned int c = _kids[0]->_cost[ANY_REGP]+_kids[1]->_cost[RREGL];
        DFA_PRODUCTION__SET_VALID(_ADDP_ANY_REGP_RREGL, _AddP_any_RegP_rRegL_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], ANY_REGP) && STATE__VALID_CHILD(_kids[1], IMML32) ) {
      unsigned int c = _kids[0]->_cost[ANY_REGP]+_kids[1]->_cost[IMML32];
        DFA_PRODUCTION__SET_VALID(INDOFFSET32, indOffset32_rule, c)
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indOffset32_rule, c)
      }
      if (STATE__NOT_YET_VALID(RREGP) || _cost[RREGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RREGP, leaP32_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTP) || _cost[STACKSLOTP] > c+110+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+110+100)
      }
      if (STATE__NOT_YET_VALID(ANY_REGP) || _cost[ANY_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(ANY_REGP, leaP32_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(INDIRECT) || _cost[INDIRECT] > c+110) {
        DFA_PRODUCTION__SET_VALID(INDIRECT, leaP32_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c+110) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RAX_REGP) || _cost[RAX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RAX_REGP, leaP32_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RBX_REGP) || _cost[RBX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RBX_REGP, leaP32_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGP) || _cost[NO_RAX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, leaP32_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RBP_REGP) || _cost[NO_RBP_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, leaP32_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RSI_REGP) || _cost[RSI_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RSI_REGP, leaP32_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RBX_REGP) || _cost[NO_RAX_RBX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, leaP32_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RDI_REGP) || _cost[RDI_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RDI_REGP, leaP32_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(R15_REGP) || _cost[R15_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(R15_REGP, leaP32_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(REX_REGP) || _cost[REX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(REX_REGP, leaP32_rule, c+110)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], ANY_REGP) && STATE__VALID_CHILD(_kids[1], IMML8) ) {
      unsigned int c = _kids[0]->_cost[ANY_REGP]+_kids[1]->_cost[IMML8];
        DFA_PRODUCTION__SET_VALID(INDOFFSET8, indOffset8_rule, c)
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indOffset8_rule, c)
      }
      if (STATE__NOT_YET_VALID(RREGP) || _cost[RREGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RREGP, leaP8_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTP) || _cost[STACKSLOTP] > c+110+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+110+100)
      }
      if (STATE__NOT_YET_VALID(ANY_REGP) || _cost[ANY_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(ANY_REGP, leaP8_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(INDIRECT) || _cost[INDIRECT] > c+110) {
        DFA_PRODUCTION__SET_VALID(INDIRECT, leaP8_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c+110) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RAX_REGP) || _cost[RAX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RAX_REGP, leaP8_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RBX_REGP) || _cost[RBX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RBX_REGP, leaP8_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGP) || _cost[NO_RAX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, leaP8_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RBP_REGP) || _cost[NO_RBP_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, leaP8_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RSI_REGP) || _cost[RSI_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RSI_REGP, leaP8_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RBX_REGP) || _cost[NO_RAX_RBX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, leaP8_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(RDI_REGP) || _cost[RDI_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(RDI_REGP, leaP8_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(R15_REGP) || _cost[R15_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(R15_REGP, leaP8_rule, c+110)
      }
      if (STATE__NOT_YET_VALID(REX_REGP) || _cost[REX_REGP] > c+110) {
        DFA_PRODUCTION__SET_VALID(REX_REGP, leaP8_rule, c+110)
      }
    }
}
void  State::_sub_Op_AndI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _LOADB_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMI8) ) {
      unsigned int c = _kids[0]->_cost[_LOADB_MEMORY_]+_kids[1]->_cost[IMMI8];
        DFA_PRODUCTION__SET_VALID(_ANDI__LOADB_MEMORY__IMMI8, _AndI__LoadB_memory__immI8_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI];
        DFA_PRODUCTION__SET_VALID(_ANDI_RREGI_IMMI, _AndI_rRegI_immI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], _CMPLTMASK_RREGI_RREGI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[_CMPLTMASK_RREGI_RREGI]+300;
        DFA_PRODUCTION__SET_VALID(RREGI, and_cmpLTMask_0_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, and_cmpLTMask_0_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, and_cmpLTMask_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, and_cmpLTMask_0_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, and_cmpLTMask_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, and_cmpLTMask_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, and_cmpLTMask_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, and_cmpLTMask_0_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _CMPLTMASK_RREGI_RREGI) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[_CMPLTMASK_RREGI_RREGI]+_kids[1]->_cost[RREGI]+300;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, and_cmpLTMask_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, and_cmpLTMask_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, and_cmpLTMask_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, and_cmpLTMask_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, and_cmpLTMask_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, and_cmpLTMask_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, and_cmpLTMask_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, and_cmpLTMask_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], _CMPLTMASK_RREGI_RREGI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[_CMPLTMASK_RREGI_RREGI];
        DFA_PRODUCTION__SET_VALID(_ANDI_RREGI__CMPLTMASK_RREGI_RREGI, _AndI_rRegI__CmpLTMask_rRegI_rRegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _CMPLTMASK_RREGI_RREGI) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[_CMPLTMASK_RREGI_RREGI]+_kids[1]->_cost[RREGI];
        DFA_PRODUCTION__SET_VALID(_ANDI__CMPLTMASK_RREGI_RREGI_RREGI, _AndI__CmpLTMask_rRegI_rRegI_rRegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], _ADDI__LOADI_MEMORY__IMMI_M1) &&
        (
#line 9751 "src/hotspot/cpu/x86/x86_64.ad"
UseBMI1Instructions
#line 2521 "dfa_x86.cpp"
) && /*src*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[_ADDI__LOADI_MEMORY__IMMI_M1]+125;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, blsrI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, blsrI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, blsrI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, blsrI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, blsrI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, blsrI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, blsrI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, blsrI_rReg_mem_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _ADDI__LOADI_MEMORY__IMMI_M1) && STATE__VALID_CHILD(_kids[1], _LOADI_MEMORY_) &&
        (
#line 9751 "src/hotspot/cpu/x86/x86_64.ad"
UseBMI1Instructions
#line 2556 "dfa_x86.cpp"
) && /*src*/(_kids[0]->_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_ADDI__LOADI_MEMORY__IMMI_M1]+_kids[1]->_cost[_LOADI_MEMORY_]+125;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, blsrI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, blsrI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, blsrI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, blsrI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, blsrI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, blsrI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, blsrI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, blsrI_rReg_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], _ADDI_RREGI_IMMI_M1) &&
        (
#line 9736 "src/hotspot/cpu/x86/x86_64.ad"
UseBMI1Instructions
#line 2591 "dfa_x86.cpp"
) && /*src*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[_ADDI_RREGI_IMMI_M1]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, blsrI_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, blsrI_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, blsrI_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, blsrI_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, blsrI_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, blsrI_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, blsrI_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, blsrI_rReg_rReg_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _ADDI_RREGI_IMMI_M1) && STATE__VALID_CHILD(_kids[1], RREGI) &&
        (
#line 9736 "src/hotspot/cpu/x86/x86_64.ad"
UseBMI1Instructions
#line 2626 "dfa_x86.cpp"
) && /*src*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_ADDI_RREGI_IMMI_M1]+_kids[1]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, blsrI_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, blsrI_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, blsrI_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, blsrI_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, blsrI_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, blsrI_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, blsrI_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, blsrI_rReg_rReg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], _SUBI_IMMI0__LOADI_MEMORY_) &&
        (
#line 9691 "src/hotspot/cpu/x86/x86_64.ad"
UseBMI1Instructions
#line 2661 "dfa_x86.cpp"
) && /*src*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[1]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[_SUBI_IMMI0__LOADI_MEMORY_]+125;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, blsiI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, blsiI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, blsiI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, blsiI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, blsiI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, blsiI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, blsiI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, blsiI_rReg_mem_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _SUBI_IMMI0__LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], _LOADI_MEMORY_) &&
        (
#line 9691 "src/hotspot/cpu/x86/x86_64.ad"
UseBMI1Instructions
#line 2696 "dfa_x86.cpp"
) && /*src*/(_kids[0]->_kids[1]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_SUBI_IMMI0__LOADI_MEMORY_]+_kids[1]->_cost[_LOADI_MEMORY_]+125;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, blsiI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, blsiI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, blsiI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, blsiI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, blsiI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, blsiI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, blsiI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, blsiI_rReg_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], _SUBI_IMMI0_RREGI) &&
        (
#line 9678 "src/hotspot/cpu/x86/x86_64.ad"
UseBMI1Instructions
#line 2731 "dfa_x86.cpp"
) && /*src*/(_kids[0]->_leaf == _kids[1]->_kids[1]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[_SUBI_IMMI0_RREGI]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, blsiI_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, blsiI_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, blsiI_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, blsiI_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, blsiI_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, blsiI_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, blsiI_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, blsiI_rReg_rReg_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _SUBI_IMMI0_RREGI) && STATE__VALID_CHILD(_kids[1], RREGI) &&
        (
#line 9678 "src/hotspot/cpu/x86/x86_64.ad"
UseBMI1Instructions
#line 2766 "dfa_x86.cpp"
) && /*src*/(_kids[0]->_kids[1]->_leaf == _kids[1]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_SUBI_IMMI0_RREGI]+_kids[1]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, blsiI_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, blsiI_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, blsiI_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, blsiI_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, blsiI_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, blsiI_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, blsiI_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, blsiI_rReg_rReg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], _XORI_RREGI_IMMI_M1) &&
        (
#line 9665 "src/hotspot/cpu/x86/x86_64.ad"
UseBMI1Instructions
#line 2801 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[_XORI_RREGI_IMMI_M1]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, andnI_rReg_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, andnI_rReg_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, andnI_rReg_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, andnI_rReg_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, andnI_rReg_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, andnI_rReg_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, andnI_rReg_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, andnI_rReg_rReg_rReg_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _XORI_RREGI_IMMI_M1) && STATE__VALID_CHILD(_kids[1], RREGI) &&
        (
#line 9665 "src/hotspot/cpu/x86/x86_64.ad"
UseBMI1Instructions
#line 2836 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_XORI_RREGI_IMMI_M1]+_kids[1]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, andnI_rReg_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, andnI_rReg_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, andnI_rReg_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, andnI_rReg_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, andnI_rReg_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, andnI_rReg_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, andnI_rReg_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, andnI_rReg_rReg_rReg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], _XORI_RREGI_IMMI_M1) &&
        (
#line 9651 "src/hotspot/cpu/x86/x86_64.ad"
UseBMI1Instructions
#line 2871 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[_XORI_RREGI_IMMI_M1]+125;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, andnI_rReg_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, andnI_rReg_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, andnI_rReg_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, andnI_rReg_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, andnI_rReg_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, andnI_rReg_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, andnI_rReg_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, andnI_rReg_rReg_mem_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _XORI_RREGI_IMMI_M1) && STATE__VALID_CHILD(_kids[1], _LOADI_MEMORY_) &&
        (
#line 9651 "src/hotspot/cpu/x86/x86_64.ad"
UseBMI1Instructions
#line 2906 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_XORI_RREGI_IMMI_M1]+_kids[1]->_cost[_LOADI_MEMORY_]+125;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, andnI_rReg_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, andnI_rReg_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, andnI_rReg_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, andnI_rReg_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, andnI_rReg_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, andnI_rReg_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, andnI_rReg_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, andnI_rReg_rReg_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMI) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[IMMI];
        DFA_PRODUCTION__SET_VALID(_ANDI__LOADI_MEMORY__IMMI, _AndI__LoadI_memory__immI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], _LOADI_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[_LOADI_MEMORY_];
        DFA_PRODUCTION__SET_VALID(_ANDI_RREGI__LOADI_MEMORY_, _AndI_rRegI__LoadI_memory__rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[RREGI];
        DFA_PRODUCTION__SET_VALID(_ANDI__LOADI_MEMORY__RREGI, _AndI__LoadI_memory__rRegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[RREGI]+125;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, andI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, andI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, andI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, andI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, andI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, andI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, andI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, andI_rReg_mem_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], _LOADI_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[_LOADI_MEMORY_]+125;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, andI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, andI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, andI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, andI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, andI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, andI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, andI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, andI_rReg_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, andI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, andI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, andI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, andI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, andI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, andI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, andI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, andI_rReg_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI_65535) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI_65535];
        DFA_PRODUCTION__SET_VALID(_ANDI_RREGI_IMMI_65535, _AndI_rRegI_immI_65535_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI_65535) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI_65535]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, andI_rReg_imm65535_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, andI_rReg_imm65535_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, andI_rReg_imm65535_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, andI_rReg_imm65535_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, andI_rReg_imm65535_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, andI_rReg_imm65535_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, andI_rReg_imm65535_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, andI_rReg_imm65535_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI_255) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI_255];
        DFA_PRODUCTION__SET_VALID(_ANDI_RREGI_IMMI_255, _AndI_rRegI_immI_255_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI_255) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI_255]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, andI_rReg_imm255_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, andI_rReg_imm255_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, andI_rReg_imm255_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, andI_rReg_imm255_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, andI_rReg_imm255_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, andI_rReg_imm255_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, andI_rReg_imm255_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, andI_rReg_imm255_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, andI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, andI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, andI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, andI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, andI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, andI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, andI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, andI_rReg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMU31) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[IMMU31];
        DFA_PRODUCTION__SET_VALID(_ANDI__LOADI_MEMORY__IMMU31, _AndI__LoadI_memory__immU31_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMI_65535) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[IMMI_65535];
        DFA_PRODUCTION__SET_VALID(_ANDI__LOADI_MEMORY__IMMI_65535, _AndI__LoadI_memory__immI_65535_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMI_255) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[IMMI_255];
        DFA_PRODUCTION__SET_VALID(_ANDI__LOADI_MEMORY__IMMI_255, _AndI__LoadI_memory__immI_255_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMI_65535) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[IMMI_65535]+125;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, loadI2US_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, loadI2US_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, loadI2US_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, loadI2US_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, loadI2US_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, loadI2US_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, loadI2US_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, loadI2US_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMI_255) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[IMMI_255]+125;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, loadI2UB_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, loadI2UB_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, loadI2UB_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, loadI2UB_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, loadI2UB_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, loadI2UB_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, loadI2UB_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, loadI2UB_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADUS_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMI) ) {
      unsigned int c = _kids[0]->_cost[_LOADUS_MEMORY_]+_kids[1]->_cost[IMMI];
        DFA_PRODUCTION__SET_VALID(_ANDI__LOADUS_MEMORY__IMMI, _AndI__LoadUS_memory__immI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADUS_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMI_255) ) {
      unsigned int c = _kids[0]->_cost[_LOADUS_MEMORY_]+_kids[1]->_cost[IMMI_255];
        DFA_PRODUCTION__SET_VALID(_ANDI__LOADUS_MEMORY__IMMI_255, _AndI__LoadUS_memory__immI_255_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADUB_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMI) ) {
      unsigned int c = _kids[0]->_cost[_LOADUB_MEMORY_]+_kids[1]->_cost[IMMI];
        DFA_PRODUCTION__SET_VALID(_ANDI__LOADUB_MEMORY__IMMI, _AndI__LoadUB_memory__immI_rule, c)
    }
}
void  State::_sub_Op_AndL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], _CASTP2X_RREGP_) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+_kids[1]->_cost[_CASTP2X_RREGP_];
        DFA_PRODUCTION__SET_VALID(_ANDL__LOADL_MEMORY___CASTP2X_RREGP_, _AndL__LoadL_memory___CastP2X_rRegP__rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _CASTP2X_RREGP_) && STATE__VALID_CHILD(_kids[1], _LOADL_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[_CASTP2X_RREGP_]+_kids[1]->_cost[_LOADL_MEMORY_];
        DFA_PRODUCTION__SET_VALID(_ANDL__CASTP2X_RREGP___LOADL_MEMORY_, _AndL__CastP2X_rRegP___LoadL_memory__rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], IMML32) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[IMML32];
        DFA_PRODUCTION__SET_VALID(_ANDL_RREGL_IMML32, _AndL_rRegL_immL32_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], IMML_32BITS) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[IMML_32BITS]+100;
        DFA_PRODUCTION__SET_VALID(RREGL, zerox_long_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, zerox_long_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, zerox_long_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, zerox_long_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGL, zerox_long_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGL, zerox_long_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGL, zerox_long_reg_reg_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _CONVI2L_RREGI_) && STATE__VALID_CHILD(_kids[1], IMML_32BITS) ) {
      unsigned int c = _kids[0]->_cost[_CONVI2L_RREGI_]+_kids[1]->_cost[IMML_32BITS]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, convI2L_reg_reg_zex_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, convI2L_reg_reg_zex_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, convI2L_reg_reg_zex_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, convI2L_reg_reg_zex_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, convI2L_reg_reg_zex_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, convI2L_reg_reg_zex_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, convI2L_reg_reg_zex_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], _ADDL__LOADL_MEMORY__IMML_M1) &&
        (
#line 10098 "src/hotspot/cpu/x86/x86_64.ad"
UseBMI1Instructions
#line 3277 "dfa_x86.cpp"
) && /*src*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+_kids[1]->_cost[_ADDL__LOADL_MEMORY__IMML_M1]+125;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, blsrL_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, blsrL_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, blsrL_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, blsrL_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, blsrL_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, blsrL_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, blsrL_rReg_mem_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _ADDL__LOADL_MEMORY__IMML_M1) && STATE__VALID_CHILD(_kids[1], _LOADL_MEMORY_) &&
        (
#line 10098 "src/hotspot/cpu/x86/x86_64.ad"
UseBMI1Instructions
#line 3309 "dfa_x86.cpp"
) && /*src*/(_kids[0]->_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_ADDL__LOADL_MEMORY__IMML_M1]+_kids[1]->_cost[_LOADL_MEMORY_]+125;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, blsrL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, blsrL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, blsrL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, blsrL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, blsrL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, blsrL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, blsrL_rReg_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], _ADDL_RREGL_IMML_M1) &&
        (
#line 10083 "src/hotspot/cpu/x86/x86_64.ad"
UseBMI1Instructions
#line 3341 "dfa_x86.cpp"
) && /*src*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[_ADDL_RREGL_IMML_M1]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, blsrL_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, blsrL_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, blsrL_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, blsrL_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, blsrL_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, blsrL_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, blsrL_rReg_rReg_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _ADDL_RREGL_IMML_M1) && STATE__VALID_CHILD(_kids[1], RREGL) &&
        (
#line 10083 "src/hotspot/cpu/x86/x86_64.ad"
UseBMI1Instructions
#line 3373 "dfa_x86.cpp"
) && /*src*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_ADDL_RREGL_IMML_M1]+_kids[1]->_cost[RREGL]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, blsrL_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, blsrL_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, blsrL_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, blsrL_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, blsrL_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, blsrL_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, blsrL_rReg_rReg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], _SUBL_IMML0__LOADL_MEMORY_) &&
        (
#line 10038 "src/hotspot/cpu/x86/x86_64.ad"
UseBMI1Instructions
#line 3405 "dfa_x86.cpp"
) && /*src*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[1]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+_kids[1]->_cost[_SUBL_IMML0__LOADL_MEMORY_]+125;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, blsiL_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, blsiL_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, blsiL_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, blsiL_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, blsiL_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, blsiL_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, blsiL_rReg_mem_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _SUBL_IMML0__LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], _LOADL_MEMORY_) &&
        (
#line 10038 "src/hotspot/cpu/x86/x86_64.ad"
UseBMI1Instructions
#line 3437 "dfa_x86.cpp"
) && /*src*/(_kids[0]->_kids[1]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_SUBL_IMML0__LOADL_MEMORY_]+_kids[1]->_cost[_LOADL_MEMORY_]+125;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, blsiL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, blsiL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, blsiL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, blsiL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, blsiL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, blsiL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, blsiL_rReg_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], _SUBL_IMML0_RREGL) &&
        (
#line 10025 "src/hotspot/cpu/x86/x86_64.ad"
UseBMI1Instructions
#line 3469 "dfa_x86.cpp"
) && /*src*/(_kids[0]->_leaf == _kids[1]->_kids[1]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[_SUBL_IMML0_RREGL]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, blsiL_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, blsiL_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, blsiL_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, blsiL_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, blsiL_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, blsiL_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, blsiL_rReg_rReg_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _SUBL_IMML0_RREGL) && STATE__VALID_CHILD(_kids[1], RREGL) &&
        (
#line 10025 "src/hotspot/cpu/x86/x86_64.ad"
UseBMI1Instructions
#line 3501 "dfa_x86.cpp"
) && /*src*/(_kids[0]->_kids[1]->_leaf == _kids[1]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_SUBL_IMML0_RREGL]+_kids[1]->_cost[RREGL]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, blsiL_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, blsiL_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, blsiL_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, blsiL_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, blsiL_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, blsiL_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, blsiL_rReg_rReg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], _XORL_RREGL_IMML_M1) &&
        (
#line 10012 "src/hotspot/cpu/x86/x86_64.ad"
UseBMI1Instructions
#line 3533 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[_XORL_RREGL_IMML_M1]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, andnL_rReg_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, andnL_rReg_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, andnL_rReg_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, andnL_rReg_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, andnL_rReg_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, andnL_rReg_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, andnL_rReg_rReg_rReg_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _XORL_RREGL_IMML_M1) && STATE__VALID_CHILD(_kids[1], RREGL) &&
        (
#line 10012 "src/hotspot/cpu/x86/x86_64.ad"
UseBMI1Instructions
#line 3565 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_XORL_RREGL_IMML_M1]+_kids[1]->_cost[RREGL]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, andnL_rReg_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, andnL_rReg_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, andnL_rReg_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, andnL_rReg_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, andnL_rReg_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, andnL_rReg_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, andnL_rReg_rReg_rReg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], _XORL_RREGL_IMML_M1) &&
        (
#line 9998 "src/hotspot/cpu/x86/x86_64.ad"
UseBMI1Instructions
#line 3597 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+_kids[1]->_cost[_XORL_RREGL_IMML_M1]+125;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, andnL_rReg_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, andnL_rReg_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, andnL_rReg_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, andnL_rReg_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, andnL_rReg_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, andnL_rReg_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, andnL_rReg_rReg_mem_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _XORL_RREGL_IMML_M1) && STATE__VALID_CHILD(_kids[1], _LOADL_MEMORY_) &&
        (
#line 9998 "src/hotspot/cpu/x86/x86_64.ad"
UseBMI1Instructions
#line 3629 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_XORL_RREGL_IMML_M1]+_kids[1]->_cost[_LOADL_MEMORY_]+125;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, andnL_rReg_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, andnL_rReg_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, andnL_rReg_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, andnL_rReg_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, andnL_rReg_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, andnL_rReg_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, andnL_rReg_rReg_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMML32) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+_kids[1]->_cost[IMML32];
        DFA_PRODUCTION__SET_VALID(_ANDL__LOADL_MEMORY__IMML32, _AndL__LoadL_memory__immL32_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], _LOADL_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[_LOADL_MEMORY_];
        DFA_PRODUCTION__SET_VALID(_ANDL_RREGL__LOADL_MEMORY_, _AndL_rRegL__LoadL_memory__rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], RREGL) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+_kids[1]->_cost[RREGL];
        DFA_PRODUCTION__SET_VALID(_ANDL__LOADL_MEMORY__RREGL, _AndL__LoadL_memory__rRegL_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], RREGL) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+_kids[1]->_cost[RREGL]+125;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, andL_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, andL_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, andL_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, andL_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, andL_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, andL_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, andL_rReg_mem_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], _LOADL_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[_LOADL_MEMORY_]+125;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, andL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, andL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, andL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, andL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, andL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, andL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, andL_rReg_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], IMML32) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[IMML32]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, andL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, andL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, andL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, andL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, andL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, andL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, andL_rReg_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], IMML_65535) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[IMML_65535]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, andL_rReg_imm65535_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, andL_rReg_imm65535_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, andL_rReg_imm65535_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, andL_rReg_imm65535_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, andL_rReg_imm65535_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, andL_rReg_imm65535_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, andL_rReg_imm65535_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], IMML_255) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[IMML_255]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, andL_rReg_imm255_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, andL_rReg_imm255_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, andL_rReg_imm255_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, andL_rReg_imm255_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, andL_rReg_imm255_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, andL_rReg_imm255_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, andL_rReg_imm255_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], RREGL) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[RREGL]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, andL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, andL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, andL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, andL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, andL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, andL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, andL_rReg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _CONVI2L__LOADI_MEMORY__) && STATE__VALID_CHILD(_kids[1], IMML_32BITS) ) {
      unsigned int c = _kids[0]->_cost[_CONVI2L__LOADI_MEMORY__]+_kids[1]->_cost[IMML_32BITS]+125;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, loadUI2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, loadUI2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, loadUI2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, loadUI2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, loadUI2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, loadUI2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, loadUI2L_rule, c)
      }
    }
}
void  State::_sub_Op_AryEq(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RDI_REGP) && STATE__VALID_CHILD(_kids[1], RSI_REGP) &&
        (
#line 11562 "src/hotspot/cpu/x86/x86_64.ad"
((AryEqNode*)n)->encoding() == StrIntrinsicNode::UU
#line 3864 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RDI_REGP]+_kids[1]->_cost[RSI_REGP]+100;
        DFA_PRODUCTION__SET_VALID(RAX_REGI, array_equalsC_rule, c)
        DFA_PRODUCTION__SET_VALID(RREGI, array_equalsC_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, array_equalsC_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, array_equalsC_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, array_equalsC_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, array_equalsC_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, array_equalsC_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, array_equalsC_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RDI_REGP) && STATE__VALID_CHILD(_kids[1], RSI_REGP) &&
        (
#line 11546 "src/hotspot/cpu/x86/x86_64.ad"
((AryEqNode*)n)->encoding() == StrIntrinsicNode::LL
#line 3881 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RDI_REGP]+_kids[1]->_cost[RSI_REGP]+100;
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, array_equalsB_rule, c)
      }
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, array_equalsB_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, array_equalsB_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, array_equalsB_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, array_equalsB_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, array_equalsB_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, array_equalsB_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, array_equalsB_rule, c)
      }
    }
}
void  State::_sub_Op_Binary(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[_LOADVECTOR_MEMORY_];
        DFA_PRODUCTION__SET_VALID(_BINARY_VECZ__LOADVECTOR_MEMORY_, _Binary_vecZ__LoadVector_memory__rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECZ) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECZ];
        DFA_PRODUCTION__SET_VALID(_BINARY_VECZ_VECZ, _Binary_vecZ_vecZ_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[_LOADVECTOR_MEMORY_];
        DFA_PRODUCTION__SET_VALID(_BINARY_VECY__LOADVECTOR_MEMORY_, _Binary_vecY__LoadVector_memory__rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECY) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECY];
        DFA_PRODUCTION__SET_VALID(_BINARY_VECY_VECY, _Binary_vecY_vecY_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[_LOADVECTOR_MEMORY_];
        DFA_PRODUCTION__SET_VALID(_BINARY_VECX__LOADVECTOR_MEMORY_, _Binary_vecX__LoadVector_memory__rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX];
        DFA_PRODUCTION__SET_VALID(_BINARY_VECX_VECX, _Binary_vecX_vecX_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], LEGVECY) && STATE__VALID_CHILD(_kids[1], LEGVECY) ) {
      unsigned int c = _kids[0]->_cost[LEGVECY]+_kids[1]->_cost[LEGVECY];
        DFA_PRODUCTION__SET_VALID(_BINARY_LEGVECY_LEGVECY, _Binary_legVecY_legVecY_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], CMPOP_VCMPPD) && STATE__VALID_CHILD(_kids[1], IMMI8) ) {
      unsigned int c = _kids[0]->_cost[CMPOP_VCMPPD]+_kids[1]->_cost[IMMI8];
        DFA_PRODUCTION__SET_VALID(_BINARY_CMPOP_VCMPPD_IMMI8, _Binary_cmpOp_vcmppd_immI8_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RDI_REGP) && STATE__VALID_CHILD(_kids[1], RSI_REGP) ) {
      unsigned int c = _kids[0]->_cost[RDI_REGP]+_kids[1]->_cost[RSI_REGP];
        DFA_PRODUCTION__SET_VALID(_BINARY_RDI_REGP_RSI_REGP, _Binary_rdi_RegP_rsi_RegP_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RSI_REGP) && STATE__VALID_CHILD(_kids[1], RAX_REGI) ) {
      unsigned int c = _kids[0]->_cost[RSI_REGP]+_kids[1]->_cost[RAX_REGI];
        DFA_PRODUCTION__SET_VALID(_BINARY_RSI_REGP_RAX_REGI, _Binary_rsi_RegP_rax_RegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RSI_REGP) && STATE__VALID_CHILD(_kids[1], IMMI) ) {
      unsigned int c = _kids[0]->_cost[RSI_REGP]+_kids[1]->_cost[IMMI];
        DFA_PRODUCTION__SET_VALID(_BINARY_RSI_REGP_IMMI, _Binary_rsi_RegP_immI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RDI_REGP) && STATE__VALID_CHILD(_kids[1], RDX_REGI) ) {
      unsigned int c = _kids[0]->_cost[RDI_REGP]+_kids[1]->_cost[RDX_REGI];
        DFA_PRODUCTION__SET_VALID(_BINARY_RDI_REGP_RDX_REGI, _Binary_rdi_RegP_rdx_RegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RSI_REGP) && STATE__VALID_CHILD(_kids[1], RDX_REGI) ) {
      unsigned int c = _kids[0]->_cost[RSI_REGP]+_kids[1]->_cost[RDX_REGI];
        DFA_PRODUCTION__SET_VALID(_BINARY_RSI_REGP_RDX_REGI, _Binary_rsi_RegP_rdx_RegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RDI_REGP) && STATE__VALID_CHILD(_kids[1], RCX_REGI) ) {
      unsigned int c = _kids[0]->_cost[RDI_REGP]+_kids[1]->_cost[RCX_REGI];
        DFA_PRODUCTION__SET_VALID(_BINARY_RDI_REGP_RCX_REGI, _Binary_rdi_RegP_rcx_RegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RAX_REGN) && STATE__VALID_CHILD(_kids[1], RREGN) ) {
      unsigned int c = _kids[0]->_cost[RAX_REGN]+_kids[1]->_cost[RREGN];
        DFA_PRODUCTION__SET_VALID(_BINARY_RAX_REGN_RREGN, _Binary_rax_RegN_rRegN_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RAX_REGL) && STATE__VALID_CHILD(_kids[1], RREGL) ) {
      unsigned int c = _kids[0]->_cost[RAX_REGL]+_kids[1]->_cost[RREGL];
        DFA_PRODUCTION__SET_VALID(_BINARY_RAX_REGL_RREGL, _Binary_rax_RegL_rRegL_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RAX_REGI) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[RAX_REGI]+_kids[1]->_cost[RREGI];
        DFA_PRODUCTION__SET_VALID(_BINARY_RAX_REGI_RREGI, _Binary_rax_RegI_rRegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RAX_REGP) && STATE__VALID_CHILD(_kids[1], RREGP) ) {
      unsigned int c = _kids[0]->_cost[RAX_REGP]+_kids[1]->_cost[RREGP];
        DFA_PRODUCTION__SET_VALID(_BINARY_RAX_REGP_RREGP, _Binary_rax_RegP_rRegP_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], REGD) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[REGD];
        DFA_PRODUCTION__SET_VALID(_BINARY_REGD_REGD, _Binary_regD_regD_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], REGF) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[REGF];
        DFA_PRODUCTION__SET_VALID(_BINARY_REGF_REGF, _Binary_regF_regF_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], _LOADL_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[_LOADL_MEMORY_];
        DFA_PRODUCTION__SET_VALID(_BINARY_RREGL__LOADL_MEMORY_, _Binary_rRegL__LoadL_memory__rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], RREGL) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[RREGL];
        DFA_PRODUCTION__SET_VALID(_BINARY_RREGL_RREGL, _Binary_rRegL_rRegL_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGP) && STATE__VALID_CHILD(_kids[1], RREGP) ) {
      unsigned int c = _kids[0]->_cost[RREGP]+_kids[1]->_cost[RREGP];
        DFA_PRODUCTION__SET_VALID(_BINARY_RREGP_RREGP, _Binary_rRegP_rRegP_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGN) && STATE__VALID_CHILD(_kids[1], RREGN) ) {
      unsigned int c = _kids[0]->_cost[RREGN]+_kids[1]->_cost[RREGN];
        DFA_PRODUCTION__SET_VALID(_BINARY_RREGN_RREGN, _Binary_rRegN_rRegN_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], _LOADI_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[_LOADI_MEMORY_];
        DFA_PRODUCTION__SET_VALID(_BINARY_RREGI__LOADI_MEMORY_, _Binary_rRegI__LoadI_memory__rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], CMPOPUCF) && STATE__VALID_CHILD(_kids[1], RFLAGSREGUCF) ) {
      unsigned int c = _kids[0]->_cost[CMPOPUCF]+_kids[1]->_cost[RFLAGSREGUCF];
        DFA_PRODUCTION__SET_VALID(_BINARY_CMPOPUCF_RFLAGSREGUCF, _Binary_cmpOpUCF_rFlagsRegUCF_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], CMPOPU) && STATE__VALID_CHILD(_kids[1], RFLAGSREGU) ) {
      unsigned int c = _kids[0]->_cost[CMPOPU]+_kids[1]->_cost[RFLAGSREGU];
        DFA_PRODUCTION__SET_VALID(_BINARY_CMPOPU_RFLAGSREGU, _Binary_cmpOpU_rFlagsRegU_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[RREGI];
        DFA_PRODUCTION__SET_VALID(_BINARY_RREGI_RREGI, _Binary_rRegI_rRegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], CMPOP) && STATE__VALID_CHILD(_kids[1], RFLAGSREG) ) {
      unsigned int c = _kids[0]->_cost[CMPOP]+_kids[1]->_cost[RFLAGSREG];
        DFA_PRODUCTION__SET_VALID(_BINARY_CMPOP_RFLAGSREG, _Binary_cmpOp_rFlagsReg_rule, c)
    }
}
void  State::_sub_Op_Bool(const Node *n){
    if(         
#line 2098 "src/hotspot/cpu/x86/x86.ad"
n->as_Bool()->_test._test != BoolTest::overflow &&
            n->as_Bool()->_test._test != BoolTest::no_overflow
#line 4036 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(CMPOP_VCMPPD, cmpOp_vcmppd_rule, c)
    }
    if(         
#line 4366 "src/hotspot/cpu/x86/x86_64.ad"
n->as_Bool()->_test._test == BoolTest::ne ||
            n->as_Bool()->_test._test == BoolTest::eq
#line 4045 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(CMPOPUCF2, cmpOpUCF2_rule, c)
    }
    if(         
#line 4345 "src/hotspot/cpu/x86/x86_64.ad"
n->as_Bool()->_test._test == BoolTest::lt ||
            n->as_Bool()->_test._test == BoolTest::ge ||
            n->as_Bool()->_test._test == BoolTest::le ||
            n->as_Bool()->_test._test == BoolTest::gt
#line 4056 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(CMPOPUCF, cmpOpUCF_rule, c)
    }
    {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(CMPOPU, cmpOpU_rule, c)
    }
    {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(CMPOP, cmpOp_rule, c)
    }
}
void  State::_sub_Op_ReverseBytesI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, bytes_reverse_int_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, bytes_reverse_int_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, bytes_reverse_int_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, bytes_reverse_int_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, bytes_reverse_int_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, bytes_reverse_int_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, bytes_reverse_int_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, bytes_reverse_int_rule, c)
    }
}
void  State::_sub_Op_ReverseBytesL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGL) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+100;
        DFA_PRODUCTION__SET_VALID(RREGL, bytes_reverse_long_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, bytes_reverse_long_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, bytes_reverse_long_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, bytes_reverse_long_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGL, bytes_reverse_long_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGL, bytes_reverse_long_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGL, bytes_reverse_long_rule, c)
    }
}
void  State::_sub_Op_ReverseBytesUS(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, bytes_reverse_unsigned_short_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, bytes_reverse_unsigned_short_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, bytes_reverse_unsigned_short_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, bytes_reverse_unsigned_short_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, bytes_reverse_unsigned_short_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, bytes_reverse_unsigned_short_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, bytes_reverse_unsigned_short_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, bytes_reverse_unsigned_short_rule, c)
    }
}
void  State::_sub_Op_ReverseBytesS(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, bytes_reverse_short_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, bytes_reverse_short_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, bytes_reverse_short_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, bytes_reverse_short_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, bytes_reverse_short_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, bytes_reverse_short_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, bytes_reverse_short_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, bytes_reverse_short_rule, c)
    }
}
void  State::_sub_Op_CallDynamicJava(const Node *n){
    {
      unsigned int c = 300;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, CallDynamicJavaDirect_rule, c)
    }
}
void  State::_sub_Op_CallLeaf(const Node *n){
    {
      unsigned int c = 300;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, CallLeafDirect_rule, c)
    }
}
void  State::_sub_Op_CallLeafNoFP(const Node *n){
    {
      unsigned int c = 300;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, CallLeafNoFPDirect_rule, c)
    }
}
void  State::_sub_Op_CallRuntime(const Node *n){
    {
      unsigned int c = 300;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, CallRuntimeDirect_rule, c)
    }
}
void  State::_sub_Op_CallStaticJava(const Node *n){
    {
      unsigned int c = 300;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, CallStaticJavaDirect_rule, c)
    }
}
void  State::_sub_Op_CastII(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGI) ) {
      unsigned int c = _kids[0]->_cost[RREGI];
        DFA_PRODUCTION__SET_VALID(RREGI, castII_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, castII_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, castII_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, castII_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, castII_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, castII_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, castII_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, castII_rule, c)
    }
}
void  State::_sub_Op_CastX2P(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGL) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+100;
        DFA_PRODUCTION__SET_VALID(RREGP, castX2P_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+100)
        DFA_PRODUCTION__SET_VALID(ANY_REGP, castX2P_rule, c)
        DFA_PRODUCTION__SET_VALID(INDIRECT, castX2P_rule, c)
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGP, castX2P_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGP, castX2P_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, castX2P_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, castX2P_rule, c)
        DFA_PRODUCTION__SET_VALID(RSI_REGP, castX2P_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, castX2P_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGP, castX2P_rule, c)
        DFA_PRODUCTION__SET_VALID(R15_REGP, castX2P_rule, c)
        DFA_PRODUCTION__SET_VALID(REX_REGP, castX2P_rule, c)
    }
}
void  State::_sub_Op_CastP2X(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], ANY_REGP) ) {
      unsigned int c = _kids[0]->_cost[ANY_REGP];
        DFA_PRODUCTION__SET_VALID(_CASTP2X_ANY_REGP_, _CastP2X_any_RegP__rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _DECODEN_RREGN_) ) {
      unsigned int c = _kids[0]->_cost[_DECODEN_RREGN_];
        DFA_PRODUCTION__SET_VALID(_CASTP2X__DECODEN_RREGN__, _CastP2X__DecodeN_rRegN___rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGP) ) {
      unsigned int c = _kids[0]->_cost[RREGP];
        DFA_PRODUCTION__SET_VALID(_CASTP2X_RREGP_, _CastP2X_rRegP__rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGP) ) {
      unsigned int c = _kids[0]->_cost[RREGP]+100;
        DFA_PRODUCTION__SET_VALID(RREGL, castP2X_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, castP2X_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, castP2X_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, castP2X_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGL, castP2X_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGL, castP2X_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGL, castP2X_rule, c)
    }
}
void  State::_sub_Op_CastPP(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGP) ) {
      unsigned int c = _kids[0]->_cost[RREGP]+100;
        DFA_PRODUCTION__SET_VALID(RREGP, castPP_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+100)
        DFA_PRODUCTION__SET_VALID(ANY_REGP, castPP_rule, c)
        DFA_PRODUCTION__SET_VALID(INDIRECT, castPP_rule, c)
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGP, castPP_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGP, castPP_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, castPP_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, castPP_rule, c)
        DFA_PRODUCTION__SET_VALID(RSI_REGP, castPP_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, castPP_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGP, castPP_rule, c)
        DFA_PRODUCTION__SET_VALID(R15_REGP, castPP_rule, c)
        DFA_PRODUCTION__SET_VALID(REX_REGP, castPP_rule, c)
    }
}
void  State::_sub_Op_CheckCastPP(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGP) ) {
      unsigned int c = _kids[0]->_cost[RREGP]+100;
        DFA_PRODUCTION__SET_VALID(RREGP, checkCastPP_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+100)
        DFA_PRODUCTION__SET_VALID(ANY_REGP, checkCastPP_rule, c)
        DFA_PRODUCTION__SET_VALID(INDIRECT, checkCastPP_rule, c)
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGP, checkCastPP_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGP, checkCastPP_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, checkCastPP_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, checkCastPP_rule, c)
        DFA_PRODUCTION__SET_VALID(RSI_REGP, checkCastPP_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, checkCastPP_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGP, checkCastPP_rule, c)
        DFA_PRODUCTION__SET_VALID(R15_REGP, checkCastPP_rule, c)
        DFA_PRODUCTION__SET_VALID(REX_REGP, checkCastPP_rule, c)
    }
}
void  State::_sub_Op_ClearArray(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RCX_REGL) && STATE__VALID_CHILD(_kids[1], RDI_REGP) &&
        (
#line 11263 "src/hotspot/cpu/x86/x86_64.ad"
((ClearArrayNode*)n)->is_large()
#line 4256 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RCX_REGL]+_kids[1]->_cost[RDI_REGP]+100;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, rep_stos_large_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RCX_REGL) && STATE__VALID_CHILD(_kids[1], RDI_REGP) &&
        (
#line 11204 "src/hotspot/cpu/x86/x86_64.ad"
!((ClearArrayNode*)n)->is_large()
#line 4265 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RCX_REGL]+_kids[1]->_cost[RDI_REGP]+100;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, rep_stos_rule, c)
      }
    }
}
void  State::_sub_Op_CMoveD(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _BINARY_CMPOPUCF_RFLAGSREGUCF) && STATE__VALID_CHILD(_kids[1], _BINARY_REGD_REGD) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_CMPOPUCF_RFLAGSREGUCF]+_kids[1]->_cost[_BINARY_REGD_REGD]+200;
        DFA_PRODUCTION__SET_VALID(REGD, cmovD_regUCF_rule, c)
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
    }
    if( STATE__VALID_CHILD(_kids[0], _BINARY_CMPOPU_RFLAGSREGU) && STATE__VALID_CHILD(_kids[1], _BINARY_REGD_REGD) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_CMPOPU_RFLAGSREGU]+_kids[1]->_cost[_BINARY_REGD_REGD]+200;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, cmovD_regU_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _BINARY_CMPOP_RFLAGSREG) && STATE__VALID_CHILD(_kids[1], _BINARY_REGD_REGD) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_CMPOP_RFLAGSREG]+_kids[1]->_cost[_BINARY_REGD_REGD]+200;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, cmovD_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
}
void  State::_sub_Op_CMoveVD(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _BINARY_CMPOP_VCMPPD_IMMI8) && STATE__VALID_CHILD(_kids[1], _BINARY_LEGVECY_LEGVECY) &&
        (
#line 8067 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 4317 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_CMPOP_VCMPPD_IMMI8]+_kids[1]->_cost[_BINARY_LEGVECY_LEGVECY]+100;
        DFA_PRODUCTION__SET_VALID(LEGVECY, vcmov4D_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(VECY, MoveLeg2VecY_rule, c+100)
    }
}
void  State::_sub_Op_CMoveF(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _BINARY_CMPOPUCF_RFLAGSREGUCF) && STATE__VALID_CHILD(_kids[1], _BINARY_REGF_REGF) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_CMPOPUCF_RFLAGSREGUCF]+_kids[1]->_cost[_BINARY_REGF_REGF]+200;
        DFA_PRODUCTION__SET_VALID(REGF, cmovF_regUCF_rule, c)
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
    }
    if( STATE__VALID_CHILD(_kids[0], _BINARY_CMPOPU_RFLAGSREGU) && STATE__VALID_CHILD(_kids[1], _BINARY_REGF_REGF) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_CMPOPU_RFLAGSREGU]+_kids[1]->_cost[_BINARY_REGF_REGF]+200;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, cmovF_regU_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _BINARY_CMPOP_RFLAGSREG) && STATE__VALID_CHILD(_kids[1], _BINARY_REGF_REGF) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_CMPOP_RFLAGSREG]+_kids[1]->_cost[_BINARY_REGF_REGF]+200;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, cmovF_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
}
void  State::_sub_Op_CMoveVF(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _BINARY_CMPOP_VCMPPD_IMMI8) && STATE__VALID_CHILD(_kids[1], _BINARY_LEGVECY_LEGVECY) &&
        (
#line 8051 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 8
#line 4368 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_CMPOP_VCMPPD_IMMI8]+_kids[1]->_cost[_BINARY_LEGVECY_LEGVECY]+100;
        DFA_PRODUCTION__SET_VALID(LEGVECY, vcmov8F_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(VECY, MoveLeg2VecY_rule, c+100)
    }
}
void  State::_sub_Op_CMoveI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _BINARY_CMPOPUCF_RFLAGSREGUCF) && STATE__VALID_CHILD(_kids[1], _BINARY_RREGI__LOADI_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_CMPOPUCF_RFLAGSREGUCF]+_kids[1]->_cost[_BINARY_RREGI__LOADI_MEMORY_]+250;
        DFA_PRODUCTION__SET_VALID(RREGI, cmovI_memUCF_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, cmovI_memUCF_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, cmovI_memUCF_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, cmovI_memUCF_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, cmovI_memUCF_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, cmovI_memUCF_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, cmovI_memUCF_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, cmovI_memUCF_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _BINARY_CMPOPU_RFLAGSREGU) && STATE__VALID_CHILD(_kids[1], _BINARY_RREGI__LOADI_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_CMPOPU_RFLAGSREGU]+_kids[1]->_cost[_BINARY_RREGI__LOADI_MEMORY_]+250;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, cmovI_memU_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, cmovI_memU_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, cmovI_memU_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, cmovI_memU_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, cmovI_memU_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, cmovI_memU_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, cmovI_memU_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, cmovI_memU_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _BINARY_CMPOP_RFLAGSREG) && STATE__VALID_CHILD(_kids[1], _BINARY_RREGI__LOADI_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_CMPOP_RFLAGSREG]+_kids[1]->_cost[_BINARY_RREGI__LOADI_MEMORY_]+250;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, cmovI_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, cmovI_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, cmovI_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, cmovI_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, cmovI_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, cmovI_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, cmovI_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, cmovI_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _BINARY_CMPOPUCF_RFLAGSREGUCF) && STATE__VALID_CHILD(_kids[1], _BINARY_RREGI_RREGI) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_CMPOPUCF_RFLAGSREGUCF]+_kids[1]->_cost[_BINARY_RREGI_RREGI]+200;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, cmovI_regUCF_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, cmovI_regUCF_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, cmovI_regUCF_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, cmovI_regUCF_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, cmovI_regUCF_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, cmovI_regUCF_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, cmovI_regUCF_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, cmovI_regUCF_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _BINARY_CMPOPU_RFLAGSREGU) && STATE__VALID_CHILD(_kids[1], _BINARY_RREGI_RREGI) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_CMPOPU_RFLAGSREGU]+_kids[1]->_cost[_BINARY_RREGI_RREGI]+200;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, cmovI_regU_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, cmovI_regU_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, cmovI_regU_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, cmovI_regU_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, cmovI_regU_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, cmovI_regU_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, cmovI_regU_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, cmovI_regU_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _BINARY_CMPOP_RFLAGSREG) && STATE__VALID_CHILD(_kids[1], _BINARY_RREGI_RREGI) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_CMPOP_RFLAGSREG]+_kids[1]->_cost[_BINARY_RREGI_RREGI]+200;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, cmovI_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, cmovI_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, cmovI_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, cmovI_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, cmovI_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, cmovI_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, cmovI_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, cmovI_reg_rule, c)
      }
    }
}
void  State::_sub_Op_CMoveL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _BINARY_CMPOPUCF_RFLAGSREGUCF) && STATE__VALID_CHILD(_kids[1], _BINARY_RREGL__LOADL_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_CMPOPUCF_RFLAGSREGUCF]+_kids[1]->_cost[_BINARY_RREGL__LOADL_MEMORY_]+200;
        DFA_PRODUCTION__SET_VALID(RREGL, cmovL_memUCF_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, cmovL_memUCF_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, cmovL_memUCF_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, cmovL_memUCF_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGL, cmovL_memUCF_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGL, cmovL_memUCF_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGL, cmovL_memUCF_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _BINARY_CMPOPU_RFLAGSREGU) && STATE__VALID_CHILD(_kids[1], _BINARY_RREGL__LOADL_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_CMPOPU_RFLAGSREGU]+_kids[1]->_cost[_BINARY_RREGL__LOADL_MEMORY_]+200;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, cmovL_memU_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, cmovL_memU_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, cmovL_memU_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, cmovL_memU_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, cmovL_memU_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, cmovL_memU_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, cmovL_memU_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _BINARY_CMPOPUCF_RFLAGSREGUCF) && STATE__VALID_CHILD(_kids[1], _BINARY_RREGL_RREGL) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_CMPOPUCF_RFLAGSREGUCF]+_kids[1]->_cost[_BINARY_RREGL_RREGL]+200;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, cmovL_regUCF_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, cmovL_regUCF_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, cmovL_regUCF_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, cmovL_regUCF_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, cmovL_regUCF_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, cmovL_regUCF_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, cmovL_regUCF_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _BINARY_CMPOPU_RFLAGSREGU) && STATE__VALID_CHILD(_kids[1], _BINARY_RREGL_RREGL) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_CMPOPU_RFLAGSREGU]+_kids[1]->_cost[_BINARY_RREGL_RREGL]+200;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, cmovL_regU_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, cmovL_regU_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, cmovL_regU_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, cmovL_regU_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, cmovL_regU_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, cmovL_regU_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, cmovL_regU_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _BINARY_CMPOP_RFLAGSREG) && STATE__VALID_CHILD(_kids[1], _BINARY_RREGL__LOADL_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_CMPOP_RFLAGSREG]+_kids[1]->_cost[_BINARY_RREGL__LOADL_MEMORY_]+200;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, cmovL_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, cmovL_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, cmovL_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, cmovL_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, cmovL_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, cmovL_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, cmovL_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _BINARY_CMPOP_RFLAGSREG) && STATE__VALID_CHILD(_kids[1], _BINARY_RREGL_RREGL) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_CMPOP_RFLAGSREG]+_kids[1]->_cost[_BINARY_RREGL_RREGL]+200;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, cmovL_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, cmovL_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, cmovL_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, cmovL_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, cmovL_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, cmovL_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, cmovL_reg_rule, c)
      }
    }
}
void  State::_sub_Op_CMoveP(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _BINARY_CMPOPUCF_RFLAGSREGUCF) && STATE__VALID_CHILD(_kids[1], _BINARY_RREGP_RREGP) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_CMPOPUCF_RFLAGSREGUCF]+_kids[1]->_cost[_BINARY_RREGP_RREGP]+200;
        DFA_PRODUCTION__SET_VALID(RREGP, cmovP_regUCF_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+100)
        DFA_PRODUCTION__SET_VALID(ANY_REGP, cmovP_regUCF_rule, c)
        DFA_PRODUCTION__SET_VALID(INDIRECT, cmovP_regUCF_rule, c)
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGP, cmovP_regUCF_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGP, cmovP_regUCF_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, cmovP_regUCF_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, cmovP_regUCF_rule, c)
        DFA_PRODUCTION__SET_VALID(RSI_REGP, cmovP_regUCF_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, cmovP_regUCF_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGP, cmovP_regUCF_rule, c)
        DFA_PRODUCTION__SET_VALID(R15_REGP, cmovP_regUCF_rule, c)
        DFA_PRODUCTION__SET_VALID(REX_REGP, cmovP_regUCF_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _BINARY_CMPOPU_RFLAGSREGU) && STATE__VALID_CHILD(_kids[1], _BINARY_RREGP_RREGP) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_CMPOPU_RFLAGSREGU]+_kids[1]->_cost[_BINARY_RREGP_RREGP]+200;
      if (STATE__NOT_YET_VALID(RREGP) || _cost[RREGP] > c) {
        DFA_PRODUCTION__SET_VALID(RREGP, cmovP_regU_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTP) || _cost[STACKSLOTP] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(ANY_REGP) || _cost[ANY_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(ANY_REGP, cmovP_regU_rule, c)
      }
      if (STATE__NOT_YET_VALID(INDIRECT) || _cost[INDIRECT] > c) {
        DFA_PRODUCTION__SET_VALID(INDIRECT, cmovP_regU_rule, c)
      }
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGP) || _cost[RAX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGP, cmovP_regU_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGP) || _cost[RBX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGP, cmovP_regU_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGP) || _cost[NO_RAX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, cmovP_regU_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RBP_REGP) || _cost[NO_RBP_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, cmovP_regU_rule, c)
      }
      if (STATE__NOT_YET_VALID(RSI_REGP) || _cost[RSI_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(RSI_REGP, cmovP_regU_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RBX_REGP) || _cost[NO_RAX_RBX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, cmovP_regU_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGP) || _cost[RDI_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGP, cmovP_regU_rule, c)
      }
      if (STATE__NOT_YET_VALID(R15_REGP) || _cost[R15_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(R15_REGP, cmovP_regU_rule, c)
      }
      if (STATE__NOT_YET_VALID(REX_REGP) || _cost[REX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(REX_REGP, cmovP_regU_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _BINARY_CMPOP_RFLAGSREG) && STATE__VALID_CHILD(_kids[1], _BINARY_RREGP_RREGP) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_CMPOP_RFLAGSREG]+_kids[1]->_cost[_BINARY_RREGP_RREGP]+200;
      if (STATE__NOT_YET_VALID(RREGP) || _cost[RREGP] > c) {
        DFA_PRODUCTION__SET_VALID(RREGP, cmovP_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTP) || _cost[STACKSLOTP] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(ANY_REGP) || _cost[ANY_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(ANY_REGP, cmovP_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(INDIRECT) || _cost[INDIRECT] > c) {
        DFA_PRODUCTION__SET_VALID(INDIRECT, cmovP_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGP) || _cost[RAX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGP, cmovP_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGP) || _cost[RBX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGP, cmovP_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGP) || _cost[NO_RAX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, cmovP_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RBP_REGP) || _cost[NO_RBP_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, cmovP_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RSI_REGP) || _cost[RSI_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(RSI_REGP, cmovP_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RBX_REGP) || _cost[NO_RAX_RBX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, cmovP_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGP) || _cost[RDI_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGP, cmovP_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(R15_REGP) || _cost[R15_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(R15_REGP, cmovP_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(REX_REGP) || _cost[REX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(REX_REGP, cmovP_reg_rule, c)
      }
    }
}
void  State::_sub_Op_CMoveN(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _BINARY_CMPOPUCF_RFLAGSREGUCF) && STATE__VALID_CHILD(_kids[1], _BINARY_RREGN_RREGN) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_CMPOPUCF_RFLAGSREGUCF]+_kids[1]->_cost[_BINARY_RREGN_RREGN]+200;
        DFA_PRODUCTION__SET_VALID(RREGN, cmovN_regUCF_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGN, cmovN_regUCF_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _BINARY_CMPOPU_RFLAGSREGU) && STATE__VALID_CHILD(_kids[1], _BINARY_RREGN_RREGN) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_CMPOPU_RFLAGSREGU]+_kids[1]->_cost[_BINARY_RREGN_RREGN]+200;
      if (STATE__NOT_YET_VALID(RREGN) || _cost[RREGN] > c) {
        DFA_PRODUCTION__SET_VALID(RREGN, cmovN_regU_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGN) || _cost[RAX_REGN] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGN, cmovN_regU_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _BINARY_CMPOP_RFLAGSREG) && STATE__VALID_CHILD(_kids[1], _BINARY_RREGN_RREGN) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_CMPOP_RFLAGSREG]+_kids[1]->_cost[_BINARY_RREGN_RREGN]+200;
      if (STATE__NOT_YET_VALID(RREGN) || _cost[RREGN] > c) {
        DFA_PRODUCTION__SET_VALID(RREGN, cmovN_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGN) || _cost[RAX_REGN] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGN, cmovN_reg_rule, c)
      }
    }
}
void  State::_sub_Op_CmpN(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _LOADN_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMN0) &&
        (
#line 12095 "src/hotspot/cpu/x86/x86_64.ad"
Universe::narrow_oop_base() == NULL && (Universe::narrow_klass_base() == NULL)
#line 4826 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADN_MEMORY_]+_kids[1]->_cost[IMMN0]+100;
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, testN_mem_reg0_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADN_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMN0) &&
        (
#line 12082 "src/hotspot/cpu/x86/x86_64.ad"
Universe::narrow_oop_base() != NULL
#line 4835 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADN_MEMORY_]+_kids[1]->_cost[IMMN0]+500;
      if (STATE__NOT_YET_VALID(RFLAGSREG) || _cost[RFLAGSREG] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, testN_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGN) && STATE__VALID_CHILD(_kids[1], IMMN0) ) {
      unsigned int c = _kids[0]->_cost[RREGN]+_kids[1]->_cost[IMMN0]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREG) || _cost[RFLAGSREG] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, testN_reg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMMNKLASS) && STATE__VALID_CHILD(_kids[1], _LOADNKLASS_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[IMMNKLASS]+_kids[1]->_cost[_LOADNKLASS_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(RFLAGSREGU, compN_mem_imm_klass_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGN) && STATE__VALID_CHILD(_kids[1], IMMNKLASS) ) {
      unsigned int c = _kids[0]->_cost[RREGN]+_kids[1]->_cost[IMMNKLASS]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREGU) || _cost[RFLAGSREGU] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREGU, compN_rReg_imm_klass_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMMN) && STATE__VALID_CHILD(_kids[1], _LOADN_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[IMMN]+_kids[1]->_cost[_LOADN_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREGU) || _cost[RFLAGSREGU] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREGU, compN_mem_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGN) && STATE__VALID_CHILD(_kids[1], IMMN) ) {
      unsigned int c = _kids[0]->_cost[RREGN]+_kids[1]->_cost[IMMN]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREGU) || _cost[RFLAGSREGU] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREGU, compN_rReg_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGN) && STATE__VALID_CHILD(_kids[1], _LOADN_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[RREGN]+_kids[1]->_cost[_LOADN_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREGU) || _cost[RFLAGSREGU] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREGU, compN_rReg_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGN) && STATE__VALID_CHILD(_kids[1], RREGN) ) {
      unsigned int c = _kids[0]->_cost[RREGN]+_kids[1]->_cost[RREGN]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREGU) || _cost[RFLAGSREGU] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREGU, compN_rReg_rule, c)
      }
    }
}
void  State::_sub_Op_CmpD(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], IMMD) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[IMMD]+100;
        DFA_PRODUCTION__SET_VALID(RFLAGSREGUCF, cmpD_cc_immCF_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], IMMD) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[IMMD]+145;
        DFA_PRODUCTION__SET_VALID(RFLAGSREGU, cmpD_cc_imm_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], _LOADD_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[_LOADD_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREGUCF) || _cost[RFLAGSREGUCF] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREGUCF, cmpD_cc_memCF_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], _LOADD_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[_LOADD_MEMORY_]+145;
      if (STATE__NOT_YET_VALID(RFLAGSREGU) || _cost[RFLAGSREGU] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREGU, cmpD_cc_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], REGD) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[REGD]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREGUCF) || _cost[RFLAGSREGUCF] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREGUCF, cmpD_cc_reg_CF_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], REGD) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[REGD]+145;
      if (STATE__NOT_YET_VALID(RFLAGSREGU) || _cost[RFLAGSREGU] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREGU, cmpD_cc_reg_rule, c)
      }
    }
}
void  State::_sub_Op_CmpD3(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], IMMD) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[IMMD]+275;
        DFA_PRODUCTION__SET_VALID(RREGI, cmpD_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, cmpD_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, cmpD_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, cmpD_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, cmpD_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, cmpD_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, cmpD_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, cmpD_imm_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], _LOADD_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[_LOADD_MEMORY_]+275;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, cmpD_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, cmpD_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, cmpD_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, cmpD_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, cmpD_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, cmpD_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, cmpD_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, cmpD_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], REGD) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[REGD]+275;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, cmpD_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, cmpD_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, cmpD_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, cmpD_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, cmpD_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, cmpD_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, cmpD_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, cmpD_reg_rule, c)
      }
    }
}
void  State::_sub_Op_CmpF(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], IMMF) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[IMMF]+100;
        DFA_PRODUCTION__SET_VALID(RFLAGSREGUCF, cmpF_cc_immCF_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], IMMF) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[IMMF]+145;
        DFA_PRODUCTION__SET_VALID(RFLAGSREGU, cmpF_cc_imm_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], _LOADF_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[_LOADF_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREGUCF) || _cost[RFLAGSREGUCF] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREGUCF, cmpF_cc_memCF_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], _LOADF_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[_LOADF_MEMORY_]+145;
      if (STATE__NOT_YET_VALID(RFLAGSREGU) || _cost[RFLAGSREGU] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREGU, cmpF_cc_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], REGF) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[REGF]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREGUCF) || _cost[RFLAGSREGUCF] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREGUCF, cmpF_cc_reg_CF_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], REGF) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[REGF]+145;
      if (STATE__NOT_YET_VALID(RFLAGSREGU) || _cost[RFLAGSREGU] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREGU, cmpF_cc_reg_rule, c)
      }
    }
}
void  State::_sub_Op_CmpF3(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], IMMF) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[IMMF]+275;
        DFA_PRODUCTION__SET_VALID(RREGI, cmpF_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, cmpF_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, cmpF_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, cmpF_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, cmpF_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, cmpF_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, cmpF_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, cmpF_imm_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], _LOADF_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[_LOADF_MEMORY_]+275;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, cmpF_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, cmpF_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, cmpF_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, cmpF_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, cmpF_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, cmpF_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, cmpF_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, cmpF_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], REGF) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[REGF]+275;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, cmpF_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, cmpF_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, cmpF_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, cmpF_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, cmpF_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, cmpF_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, cmpF_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, cmpF_reg_rule, c)
      }
    }
}
void  State::_sub_Op_CmpI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _ANDI__LOADB_MEMORY__IMMI8) && STATE__VALID_CHILD(_kids[1], IMMI0) ) {
      unsigned int c = _kids[0]->_cost[_ANDI__LOADB_MEMORY__IMMI8]+_kids[1]->_cost[IMMI0]+125;
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, testB_mem_imm_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADB_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMI8) ) {
      unsigned int c = _kids[0]->_cost[_LOADB_MEMORY_]+_kids[1]->_cost[IMMI8]+125;
      if (STATE__NOT_YET_VALID(RFLAGSREG) || _cost[RFLAGSREG] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, compB_mem_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _ANDI__LOADI_MEMORY__RREGI) && STATE__VALID_CHILD(_kids[1], IMMI0) ) {
      unsigned int c = _kids[0]->_cost[_ANDI__LOADI_MEMORY__RREGI]+_kids[1]->_cost[IMMI0]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREG) || _cost[RFLAGSREG] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, testI_reg_mem_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _ANDI_RREGI__LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMI0) ) {
      unsigned int c = _kids[0]->_cost[_ANDI_RREGI__LOADI_MEMORY_]+_kids[1]->_cost[IMMI0]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREG) || _cost[RFLAGSREG] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, testI_reg_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _ANDI_RREGI_IMMI) && STATE__VALID_CHILD(_kids[1], IMMI0) ) {
      unsigned int c = _kids[0]->_cost[_ANDI_RREGI_IMMI]+_kids[1]->_cost[IMMI0]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREG) || _cost[RFLAGSREG] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, testI_reg_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI0) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI0]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREG) || _cost[RFLAGSREG] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, testI_reg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], _LOADI_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[_LOADI_MEMORY_]+500;
      if (STATE__NOT_YET_VALID(RFLAGSREG) || _cost[RFLAGSREG] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, compI_rReg_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREG) || _cost[RFLAGSREG] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, compI_rReg_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREG) || _cost[RFLAGSREG] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, compI_rReg_rule, c)
      }
    }
}
void  State::_sub_Op_CmpL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _ANDL__LOADL_MEMORY___CASTP2X_RREGP_) && STATE__VALID_CHILD(_kids[1], IMML0) ) {
      unsigned int c = _kids[0]->_cost[_ANDL__LOADL_MEMORY___CASTP2X_RREGP_]+_kids[1]->_cost[IMML0]+100;
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, testL_reg_mem2_0_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _ANDL__CASTP2X_RREGP___LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMML0) ) {
      unsigned int c = _kids[0]->_cost[_ANDL__CASTP2X_RREGP___LOADL_MEMORY_]+_kids[1]->_cost[IMML0]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREG) || _cost[RFLAGSREG] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, testL_reg_mem2_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _ANDL__LOADL_MEMORY__RREGL) && STATE__VALID_CHILD(_kids[1], IMML0) ) {
      unsigned int c = _kids[0]->_cost[_ANDL__LOADL_MEMORY__RREGL]+_kids[1]->_cost[IMML0]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREG) || _cost[RFLAGSREG] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, testL_reg_mem_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _ANDL_RREGL__LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMML0) ) {
      unsigned int c = _kids[0]->_cost[_ANDL_RREGL__LOADL_MEMORY_]+_kids[1]->_cost[IMML0]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREG) || _cost[RFLAGSREG] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, testL_reg_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _ANDL_RREGL_IMML32) && STATE__VALID_CHILD(_kids[1], IMML0) ) {
      unsigned int c = _kids[0]->_cost[_ANDL_RREGL_IMML32]+_kids[1]->_cost[IMML0]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREG) || _cost[RFLAGSREG] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, testL_reg_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], IMML0) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[IMML0]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREG) || _cost[RFLAGSREG] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, testL_reg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], _LOADL_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[_LOADL_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREG) || _cost[RFLAGSREG] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, compL_rReg_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], IMML32) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[IMML32]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREG) || _cost[RFLAGSREG] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, compL_rReg_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], RREGL) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[RREGL]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREG) || _cost[RFLAGSREG] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, compL_rReg_rule, c)
      }
    }
}
void  State::_sub_Op_CmpL3(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], RREGL) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[RREGL]+275;
        DFA_PRODUCTION__SET_VALID(RREGI, cmpL3_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, cmpL3_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, cmpL3_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, cmpL3_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, cmpL3_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, cmpL3_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, cmpL3_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, cmpL3_reg_reg_rule, c)
    }
}
void  State::_sub_Op_CmpLTMask(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[RREGI];
        DFA_PRODUCTION__SET_VALID(_CMPLTMASK_RREGI_RREGI, _CmpLTMask_rRegI_rRegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI0) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI0]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, cmpLTMask0_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, cmpLTMask0_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, cmpLTMask0_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, cmpLTMask0_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, cmpLTMask0_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, cmpLTMask0_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, cmpLTMask0_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, cmpLTMask0_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[RREGI]+400;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, cmpLTMask_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, cmpLTMask_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, cmpLTMask_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, cmpLTMask_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, cmpLTMask_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, cmpLTMask_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, cmpLTMask_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, cmpLTMask_rule, c)
      }
    }
}
void  State::_sub_Op_CmpP(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _PARTIALSUBTYPECHECK_RSI_REGP_RAX_REGP) && STATE__VALID_CHILD(_kids[1], IMMP0) ) {
      unsigned int c = _kids[0]->_cost[_PARTIALSUBTYPECHECK_RSI_REGP_RAX_REGP]+_kids[1]->_cost[IMMP0]+1000;
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, partialSubtypeCheck_vs_Zero_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADP_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMP0) &&
        (
#line 12000 "src/hotspot/cpu/x86/x86_64.ad"
UseCompressedOops && (Universe::narrow_oop_base() == NULL) && (Universe::narrow_klass_base() == NULL)
#line 5278 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADP_MEMORY_]+_kids[1]->_cost[IMMP0]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREG) || _cost[RFLAGSREG] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, testP_mem_reg0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADP_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMP0) &&
        (
#line 11987 "src/hotspot/cpu/x86/x86_64.ad"
!UseCompressedOops || (Universe::narrow_oop_base() != NULL)
#line 5289 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADP_MEMORY_]+_kids[1]->_cost[IMMP0]+500;
      if (STATE__NOT_YET_VALID(RFLAGSREG) || _cost[RFLAGSREG] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, testP_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGP) && STATE__VALID_CHILD(_kids[1], IMMP0) ) {
      unsigned int c = _kids[0]->_cost[RREGP]+_kids[1]->_cost[IMMP0]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREG) || _cost[RFLAGSREG] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, testP_reg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGP) && STATE__VALID_CHILD(_kids[1], _LOADP_MEMORY_) &&
        (
#line 11962 "src/hotspot/cpu/x86/x86_64.ad"
n->in(2)->in(2)->bottom_type()->reloc() == relocInfo::none
#line 5306 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGP]+_kids[1]->_cost[_LOADP_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(RFLAGSREGU, compP_mem_rReg_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGP) && STATE__VALID_CHILD(_kids[1], _LOADP_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[RREGP]+_kids[1]->_cost[_LOADP_MEMORY_]+500;
      if (STATE__NOT_YET_VALID(RFLAGSREGU) || _cost[RFLAGSREGU] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREGU, compP_rReg_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGP) && STATE__VALID_CHILD(_kids[1], RREGP) ) {
      unsigned int c = _kids[0]->_cost[RREGP]+_kids[1]->_cost[RREGP]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREGU) || _cost[RFLAGSREGU] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREGU, compP_rReg_rule, c)
      }
    }
}
void  State::_sub_Op_CmpU(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI0) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI0]+100;
        DFA_PRODUCTION__SET_VALID(RFLAGSREGU, testU_reg_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], _LOADI_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[_LOADI_MEMORY_]+500;
      if (STATE__NOT_YET_VALID(RFLAGSREGU) || _cost[RFLAGSREGU] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREGU, compU_rReg_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREGU) || _cost[RFLAGSREGU] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREGU, compU_rReg_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREGU) || _cost[RFLAGSREGU] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREGU, compU_rReg_rule, c)
      }
    }
}
void  State::_sub_Op_CmpUL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], IMML0) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[IMML0]+100;
        DFA_PRODUCTION__SET_VALID(RFLAGSREGU, testUL_reg_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], _LOADL_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[_LOADL_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREGU) || _cost[RFLAGSREGU] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREGU, compUL_rReg_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], IMML32) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[IMML32]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREGU) || _cost[RFLAGSREGU] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREGU, compUL_rReg_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], RREGL) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[RREGL]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREGU) || _cost[RFLAGSREGU] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREGU, compUL_rReg_rule, c)
      }
    }
}
void  State::_sub_Op_CompareAndSwapB(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _BINARY_RAX_REGI_RREGI) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_BINARY_RAX_REGI_RREGI]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, compareAndSwapB_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, compareAndSwapB_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, compareAndSwapB_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, compareAndSwapB_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, compareAndSwapB_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, compareAndSwapB_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, compareAndSwapB_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, compareAndSwapB_rule, c)
    }
}
void  State::_sub_Op_CompareAndSwapS(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _BINARY_RAX_REGI_RREGI) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_BINARY_RAX_REGI_RREGI]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, compareAndSwapS_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, compareAndSwapS_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, compareAndSwapS_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, compareAndSwapS_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, compareAndSwapS_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, compareAndSwapS_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, compareAndSwapS_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, compareAndSwapS_rule, c)
    }
}
void  State::_sub_Op_CompareAndSwapI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _BINARY_RAX_REGI_RREGI) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_BINARY_RAX_REGI_RREGI]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, compareAndSwapI_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, compareAndSwapI_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, compareAndSwapI_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, compareAndSwapI_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, compareAndSwapI_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, compareAndSwapI_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, compareAndSwapI_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, compareAndSwapI_rule, c)
    }
}
void  State::_sub_Op_CompareAndSwapL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _BINARY_RAX_REGL_RREGL) &&
        (
#line 7879 "src/hotspot/cpu/x86/x86_64.ad"
VM_Version::supports_cx8()
#line 5419 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_BINARY_RAX_REGL_RREGL]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, compareAndSwapL_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, compareAndSwapL_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, compareAndSwapL_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, compareAndSwapL_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, compareAndSwapL_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, compareAndSwapL_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, compareAndSwapL_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, compareAndSwapL_rule, c)
    }
}
void  State::_sub_Op_CompareAndSwapP(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _BINARY_RAX_REGP_RREGP) &&
        (
#line 7854 "src/hotspot/cpu/x86/x86_64.ad"
VM_Version::supports_cx8()
#line 5438 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_BINARY_RAX_REGP_RREGP]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, compareAndSwapP_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, compareAndSwapP_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, compareAndSwapP_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, compareAndSwapP_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, compareAndSwapP_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, compareAndSwapP_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, compareAndSwapP_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, compareAndSwapP_rule, c)
    }
}
void  State::_sub_Op_CompareAndSwapN(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _BINARY_RAX_REGN_RREGN) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_BINARY_RAX_REGN_RREGN]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, compareAndSwapN_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, compareAndSwapN_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, compareAndSwapN_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, compareAndSwapN_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, compareAndSwapN_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, compareAndSwapN_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, compareAndSwapN_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, compareAndSwapN_rule, c)
    }
}
void  State::_sub_Op_WeakCompareAndSwapB(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _BINARY_RAX_REGI_RREGI) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_BINARY_RAX_REGI_RREGI]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, compareAndSwapB_0_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, compareAndSwapB_0_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, compareAndSwapB_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, compareAndSwapB_0_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, compareAndSwapB_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, compareAndSwapB_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, compareAndSwapB_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, compareAndSwapB_0_rule, c)
    }
}
void  State::_sub_Op_WeakCompareAndSwapS(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _BINARY_RAX_REGI_RREGI) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_BINARY_RAX_REGI_RREGI]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, compareAndSwapS_0_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, compareAndSwapS_0_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, compareAndSwapS_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, compareAndSwapS_0_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, compareAndSwapS_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, compareAndSwapS_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, compareAndSwapS_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, compareAndSwapS_0_rule, c)
    }
}
void  State::_sub_Op_WeakCompareAndSwapI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _BINARY_RAX_REGI_RREGI) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_BINARY_RAX_REGI_RREGI]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, compareAndSwapI_0_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, compareAndSwapI_0_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, compareAndSwapI_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, compareAndSwapI_0_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, compareAndSwapI_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, compareAndSwapI_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, compareAndSwapI_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, compareAndSwapI_0_rule, c)
    }
}
void  State::_sub_Op_WeakCompareAndSwapL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _BINARY_RAX_REGL_RREGL) &&
        (
#line 7879 "src/hotspot/cpu/x86/x86_64.ad"
VM_Version::supports_cx8()
#line 5513 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_BINARY_RAX_REGL_RREGL]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, compareAndSwapL_0_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, compareAndSwapL_0_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, compareAndSwapL_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, compareAndSwapL_0_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, compareAndSwapL_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, compareAndSwapL_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, compareAndSwapL_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, compareAndSwapL_0_rule, c)
    }
}
void  State::_sub_Op_WeakCompareAndSwapP(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _BINARY_RAX_REGP_RREGP) &&
        (
#line 7854 "src/hotspot/cpu/x86/x86_64.ad"
VM_Version::supports_cx8()
#line 5532 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_BINARY_RAX_REGP_RREGP]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, compareAndSwapP_0_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, compareAndSwapP_0_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, compareAndSwapP_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, compareAndSwapP_0_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, compareAndSwapP_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, compareAndSwapP_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, compareAndSwapP_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, compareAndSwapP_0_rule, c)
    }
}
void  State::_sub_Op_WeakCompareAndSwapN(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _BINARY_RAX_REGN_RREGN) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_BINARY_RAX_REGN_RREGN]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, compareAndSwapN_0_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, compareAndSwapN_0_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, compareAndSwapN_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, compareAndSwapN_0_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, compareAndSwapN_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, compareAndSwapN_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, compareAndSwapN_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, compareAndSwapN_0_rule, c)
    }
}
void  State::_sub_Op_CompareAndExchangeB(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _BINARY_RAX_REGI_RREGI) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_BINARY_RAX_REGI_RREGI]+100;
        DFA_PRODUCTION__SET_VALID(RAX_REGI, compareAndExchangeB_rule, c)
        DFA_PRODUCTION__SET_VALID(RREGI, compareAndExchangeB_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, compareAndExchangeB_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, compareAndExchangeB_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, compareAndExchangeB_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, compareAndExchangeB_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, compareAndExchangeB_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, compareAndExchangeB_rule, c)
    }
}
void  State::_sub_Op_CompareAndExchangeS(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _BINARY_RAX_REGI_RREGI) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_BINARY_RAX_REGI_RREGI]+100;
        DFA_PRODUCTION__SET_VALID(RAX_REGI, compareAndExchangeS_rule, c)
        DFA_PRODUCTION__SET_VALID(RREGI, compareAndExchangeS_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, compareAndExchangeS_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, compareAndExchangeS_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, compareAndExchangeS_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, compareAndExchangeS_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, compareAndExchangeS_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, compareAndExchangeS_rule, c)
    }
}
void  State::_sub_Op_CompareAndExchangeI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _BINARY_RAX_REGI_RREGI) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_BINARY_RAX_REGI_RREGI]+100;
        DFA_PRODUCTION__SET_VALID(RAX_REGI, compareAndExchangeI_rule, c)
        DFA_PRODUCTION__SET_VALID(RREGI, compareAndExchangeI_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, compareAndExchangeI_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, compareAndExchangeI_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, compareAndExchangeI_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, compareAndExchangeI_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, compareAndExchangeI_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, compareAndExchangeI_rule, c)
    }
}
void  State::_sub_Op_CompareAndExchangeL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _BINARY_RAX_REGL_RREGL) &&
        (
#line 8058 "src/hotspot/cpu/x86/x86_64.ad"
VM_Version::supports_cx8()
#line 5607 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_BINARY_RAX_REGL_RREGL]+100;
        DFA_PRODUCTION__SET_VALID(RAX_REGL, compareAndExchangeL_rule, c)
        DFA_PRODUCTION__SET_VALID(RREGL, compareAndExchangeL_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, compareAndExchangeL_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, compareAndExchangeL_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, compareAndExchangeL_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGL, compareAndExchangeL_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGL, compareAndExchangeL_rule, c)
    }
}
void  State::_sub_Op_CompareAndExchangeP(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _BINARY_RAX_REGP_RREGP) &&
        (
#line 8096 "src/hotspot/cpu/x86/x86_64.ad"
VM_Version::supports_cx8()
#line 5625 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_BINARY_RAX_REGP_RREGP]+100;
        DFA_PRODUCTION__SET_VALID(RAX_REGP, compareAndExchangeP_rule, c)
        DFA_PRODUCTION__SET_VALID(ANY_REGP, compareAndExchangeP_rule, c)
        DFA_PRODUCTION__SET_VALID(INDIRECT, compareAndExchangeP_rule, c)
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c)
        DFA_PRODUCTION__SET_VALID(RREGP, compareAndExchangeP_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RBX_REGP, compareAndExchangeP_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, compareAndExchangeP_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, compareAndExchangeP_rule, c)
        DFA_PRODUCTION__SET_VALID(RSI_REGP, compareAndExchangeP_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, compareAndExchangeP_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGP, compareAndExchangeP_rule, c)
        DFA_PRODUCTION__SET_VALID(R15_REGP, compareAndExchangeP_rule, c)
        DFA_PRODUCTION__SET_VALID(REX_REGP, compareAndExchangeP_rule, c)
    }
}
void  State::_sub_Op_CompareAndExchangeN(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _BINARY_RAX_REGN_RREGN) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_BINARY_RAX_REGN_RREGN]+100;
        DFA_PRODUCTION__SET_VALID(RAX_REGN, compareAndExchangeN_rule, c)
    }
}
void  State::_sub_Op_GetAndAddB(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[RREGI]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, xaddB_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, xaddB_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, xaddB_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, xaddB_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, xaddB_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, xaddB_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, xaddB_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, xaddB_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], IMMI) &&
        (
#line 8112 "src/hotspot/cpu/x86/x86_64.ad"
n->as_LoadStore()->result_not_used()
#line 5667 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[IMMI]+100;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, xaddB_no_res_rule, c)
    }
}
void  State::_sub_Op_GetAndAddS(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[RREGI]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, xaddS_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, xaddS_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, xaddS_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, xaddS_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, xaddS_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, xaddS_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, xaddS_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, xaddS_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], IMMI) &&
        (
#line 8135 "src/hotspot/cpu/x86/x86_64.ad"
n->as_LoadStore()->result_not_used()
#line 5690 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[IMMI]+100;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, xaddS_no_res_rule, c)
    }
}
void  State::_sub_Op_GetAndAddI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[RREGI]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, xaddI_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, xaddI_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, xaddI_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, xaddI_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, xaddI_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, xaddI_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, xaddI_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, xaddI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], IMMI) &&
        (
#line 8158 "src/hotspot/cpu/x86/x86_64.ad"
n->as_LoadStore()->result_not_used()
#line 5713 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[IMMI]+100;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, xaddI_no_res_rule, c)
    }
}
void  State::_sub_Op_GetAndAddL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], RREGL) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[RREGL]+100;
        DFA_PRODUCTION__SET_VALID(RREGL, xaddL_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, xaddL_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, xaddL_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, xaddL_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGL, xaddL_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGL, xaddL_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGL, xaddL_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], IMML32) &&
        (
#line 8181 "src/hotspot/cpu/x86/x86_64.ad"
n->as_LoadStore()->result_not_used()
#line 5735 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[IMML32]+100;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, xaddL_no_res_rule, c)
    }
}
void  State::_sub_Op_GetAndSetB(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[RREGI]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, xchgB_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, xchgB_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, xchgB_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, xchgB_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, xchgB_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, xchgB_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, xchgB_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, xchgB_rule, c)
    }
}
void  State::_sub_Op_GetAndSetS(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[RREGI]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, xchgS_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, xchgS_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, xchgS_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, xchgS_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, xchgS_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, xchgS_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, xchgS_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, xchgS_rule, c)
    }
}
void  State::_sub_Op_GetAndSetI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[RREGI]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, xchgI_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, xchgI_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, xchgI_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, xchgI_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, xchgI_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, xchgI_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, xchgI_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, xchgI_rule, c)
    }
}
void  State::_sub_Op_GetAndSetL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], RREGL) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[RREGL]+100;
        DFA_PRODUCTION__SET_VALID(RREGL, xchgL_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, xchgL_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, xchgL_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, xchgL_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGL, xchgL_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGL, xchgL_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGL, xchgL_rule, c)
    }
}
void  State::_sub_Op_GetAndSetP(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], RREGP) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[RREGP]+100;
        DFA_PRODUCTION__SET_VALID(RREGP, xchgP_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+100)
        DFA_PRODUCTION__SET_VALID(ANY_REGP, xchgP_rule, c)
        DFA_PRODUCTION__SET_VALID(INDIRECT, xchgP_rule, c)
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGP, xchgP_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGP, xchgP_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, xchgP_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, xchgP_rule, c)
        DFA_PRODUCTION__SET_VALID(RSI_REGP, xchgP_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, xchgP_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGP, xchgP_rule, c)
        DFA_PRODUCTION__SET_VALID(R15_REGP, xchgP_rule, c)
        DFA_PRODUCTION__SET_VALID(REX_REGP, xchgP_rule, c)
    }
}
void  State::_sub_Op_GetAndSetN(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], RREGN) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[RREGN]+100;
        DFA_PRODUCTION__SET_VALID(RREGN, xchgN_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGN, xchgN_rule, c)
    }
}
void  State::_sub_Op_ConN(const Node *n){
    if(         
#line 3164 "src/hotspot/cpu/x86/x86_64.ad"
n->get_narrowcon() == 0
#line 5826 "dfa_x86.cpp"
 ) {
      unsigned int c = 5;
        DFA_PRODUCTION__SET_VALID(IMMN0, immN0_rule, c)
        DFA_PRODUCTION__SET_VALID(RREGN, loadConN0_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGN, loadConN0_rule, c+100)
    }
    {
      unsigned int c = 10;
        DFA_PRODUCTION__SET_VALID(IMMN, immN_rule, c)
      if (STATE__NOT_YET_VALID(RREGN) || _cost[RREGN] > c+125) {
        DFA_PRODUCTION__SET_VALID(RREGN, loadConN_rule, c+125)
      }
      if (STATE__NOT_YET_VALID(RAX_REGN) || _cost[RAX_REGN] > c+125) {
        DFA_PRODUCTION__SET_VALID(RAX_REGN, loadConN_rule, c+125)
      }
    }
   if ( /* RREGN KNOWN_VALID || */ _cost[RREGN] > 125) {
     DFA_PRODUCTION(RREGN, loadConN_rule, 125)
   }
   if ( /* RAX_REGN KNOWN_VALID || */ _cost[RAX_REGN] > 125) {
     DFA_PRODUCTION(RAX_REGN, loadConN_rule, 125)
   }
}
void  State::_sub_Op_ConNKlass(const Node *n){
    {
      unsigned int c = 10;
        DFA_PRODUCTION__SET_VALID(IMMNKLASS, immNKlass_rule, c)
        DFA_PRODUCTION__SET_VALID(RREGN, loadConNKlass_rule, c+125)
        DFA_PRODUCTION__SET_VALID(RAX_REGN, loadConNKlass_rule, c+125)
    }
     DFA_PRODUCTION(RREGN, loadConNKlass_rule, 125)	  // overwrites higher cost rule
     DFA_PRODUCTION(RAX_REGN, loadConNKlass_rule, 125)	  // overwrites higher cost rule
}
void  State::_sub_Op_ConD(const Node *n){
    {
      unsigned int c = 15;
        DFA_PRODUCTION__SET_VALID(IMMD, immD_rule, c)
        DFA_PRODUCTION__SET_VALID(REGD, loadConD_rule, c+125)
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+125+100)
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+125+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+125+95)
    }
    if(         
#line 3315 "src/hotspot/cpu/x86/x86_64.ad"
jlong_cast(n->getd()) == 0
#line 5872 "dfa_x86.cpp"
 ) {
      unsigned int c = 5;
        DFA_PRODUCTION__SET_VALID(IMMD0, immD0_rule, c)
        DFA_PRODUCTION(REGD, loadConD0_rule, c+100)	  // overwrites higher cost rule
        DFA_PRODUCTION(VLREGD, MoveD2VL_rule, c+100+100)	  // overwrites higher cost rule
        DFA_PRODUCTION(LEGREGD, MoveD2LEG_rule, c+100+100)	  // overwrites higher cost rule
        DFA_PRODUCTION(STACKSLOTD, storeSSD_rule, c+100+95)	  // overwrites higher cost rule
    }
   if ( /* REGD KNOWN_VALID || */ _cost[REGD] > 125) {
     DFA_PRODUCTION(REGD, loadConD_rule, 125)
   }
   if ( /* VLREGD KNOWN_VALID || */ _cost[VLREGD] > 125+100) {
     DFA_PRODUCTION(VLREGD, MoveD2VL_rule, 125+100)
   }
   if ( /* LEGREGD KNOWN_VALID || */ _cost[LEGREGD] > 125+100) {
     DFA_PRODUCTION(LEGREGD, MoveD2LEG_rule, 125+100)
   }
   if ( /* STACKSLOTD KNOWN_VALID || */ _cost[STACKSLOTD] > 125+95) {
     DFA_PRODUCTION(STACKSLOTD, storeSSD_rule, 125+95)
   }
}
void  State::_sub_Op_ConF(const Node *n){
    {
      unsigned int c = 15;
        DFA_PRODUCTION__SET_VALID(IMMF, immF_rule, c)
        DFA_PRODUCTION__SET_VALID(REGF, loadConF_rule, c+125)
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+125+100)
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+125+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+125+95)
    }
    if(         
#line 3294 "src/hotspot/cpu/x86/x86_64.ad"
jint_cast(n->getf()) == 0
#line 5906 "dfa_x86.cpp"
 ) {
      unsigned int c = 5;
        DFA_PRODUCTION__SET_VALID(IMMF0, immF0_rule, c)
        DFA_PRODUCTION(REGF, loadConF0_rule, c+100)	  // overwrites higher cost rule
        DFA_PRODUCTION(VLREGF, MoveF2VL_rule, c+100+100)	  // overwrites higher cost rule
        DFA_PRODUCTION(LEGREGF, MoveF2LEG_rule, c+100+100)	  // overwrites higher cost rule
        DFA_PRODUCTION(STACKSLOTF, storeSSF_rule, c+100+95)	  // overwrites higher cost rule
    }
   if ( /* REGF KNOWN_VALID || */ _cost[REGF] > 125) {
     DFA_PRODUCTION(REGF, loadConF_rule, 125)
   }
   if ( /* VLREGF KNOWN_VALID || */ _cost[VLREGF] > 125+100) {
     DFA_PRODUCTION(VLREGF, MoveF2VL_rule, 125+100)
   }
   if ( /* LEGREGF KNOWN_VALID || */ _cost[LEGREGF] > 125+100) {
     DFA_PRODUCTION(LEGREGF, MoveF2LEG_rule, 125+100)
   }
   if ( /* STACKSLOTF KNOWN_VALID || */ _cost[STACKSLOTF] > 125+95) {
     DFA_PRODUCTION(STACKSLOTF, storeSSF_rule, 125+95)
   }
}
void  State::_sub_Op_ConI(const Node *n){
    int _n_get_int__ = n->get_int();
    if(         
#line 3367 "src/hotspot/cpu/x86/x86_64.ad"
_n_get_int__ == 65535
#line 5933 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(IMMI_65535, immI_65535_rule, c)
    }
    if(         
#line 3357 "src/hotspot/cpu/x86/x86_64.ad"
_n_get_int__ == 255
#line 5941 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(IMMI_255, immI_255_rule, c)
    }
    if(         
#line 3347 "src/hotspot/cpu/x86/x86_64.ad"
_n_get_int__ == 24
#line 5949 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(IMMI_24, immI_24_rule, c)
    }
    if(         
#line 3338 "src/hotspot/cpu/x86/x86_64.ad"
_n_get_int__ == 16
#line 5957 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(IMMI_16, immI_16_rule, c)
    }
    if(         
#line 3116 "src/hotspot/cpu/x86/x86_64.ad"
 _n_get_int__ == 64 
#line 5965 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(IMMI_64, immI_64_rule, c)
    }
    if(         
#line 3105 "src/hotspot/cpu/x86/x86_64.ad"
 _n_get_int__ == 32 
#line 5973 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(IMMI_32, immI_32_rule, c)
    }
    if(         
#line 3094 "src/hotspot/cpu/x86/x86_64.ad"
_n_get_int__ >= 0
#line 5981 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(IMMU31, immU31_rule, c)
    }
    if(         
#line 3083 "src/hotspot/cpu/x86/x86_64.ad"
(-32768 <= _n_get_int__) && (_n_get_int__ <= 32767)
#line 5989 "dfa_x86.cpp"
 ) {
      unsigned int c = 10;
        DFA_PRODUCTION__SET_VALID(IMMI16, immI16_rule, c)
    }
    if(         
#line 3073 "src/hotspot/cpu/x86/x86_64.ad"
(0 <= _n_get_int__) && (_n_get_int__ <= 255)
#line 5997 "dfa_x86.cpp"
 ) {
      unsigned int c = 5;
        DFA_PRODUCTION__SET_VALID(IMMU8, immU8_rule, c)
    }
    if(         
#line 3063 "src/hotspot/cpu/x86/x86_64.ad"
(-0x80 <= _n_get_int__) && (_n_get_int__ < 0x80)
#line 6005 "dfa_x86.cpp"
 ) {
      unsigned int c = 5;
        DFA_PRODUCTION__SET_VALID(IMMI8, immI8_rule, c)
        DFA_PRODUCTION__SET_VALID(VECS, vshiftcntimm_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100+100)
    }
    if(         
#line 3054 "src/hotspot/cpu/x86/x86_64.ad"
0 <= _n_get_int__ && (_n_get_int__ <= 3)
#line 6015 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(IMMI2, immI2_rule, c)
    }
    if(         
#line 3043 "src/hotspot/cpu/x86/x86_64.ad"
_n_get_int__ == -1
#line 6023 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(IMMI_M1, immI_M1_rule, c)
    }
    if(         
#line 3032 "src/hotspot/cpu/x86/x86_64.ad"
_n_get_int__ == 1
#line 6031 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(IMMI1, immI1_rule, c)
    }
    if(         
#line 3021 "src/hotspot/cpu/x86/x86_64.ad"
_n_get_int__ == 0
#line 6039 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(IMMI0, immI0_rule, c)
        DFA_PRODUCTION__SET_VALID(RREGI, loadConI0_rule, c+50)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+50+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, loadConI0_rule, c+50)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, loadConI0_rule, c+50)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, loadConI0_rule, c+50)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, loadConI0_rule, c+50)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, loadConI0_rule, c+50)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, loadConI0_rule, c+50)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, loadConI0_rule, c+50)
    }
    {
      unsigned int c = 10;
        DFA_PRODUCTION__SET_VALID(IMMI, immI_rule, c)
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c+100) {
        DFA_PRODUCTION__SET_VALID(RREGI, loadConI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c+100) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, loadConI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c+100) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, loadConI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c+100) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, loadConI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c+100) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, loadConI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c+100) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, loadConI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c+100) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, loadConI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c+100) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, loadConI_rule, c+100)
      }
    }
   if ( /* RREGI KNOWN_VALID || */ _cost[RREGI] > 100) {
     DFA_PRODUCTION(RREGI, loadConI_rule, 100)
   }
   if ( /* STACKSLOTI KNOWN_VALID || */ _cost[STACKSLOTI] > 100+100) {
     DFA_PRODUCTION(STACKSLOTI, storeSSI_rule, 100+100)
   }
   if ( /* RAX_REGI KNOWN_VALID || */ _cost[RAX_REGI] > 100) {
     DFA_PRODUCTION(RAX_REGI, loadConI_rule, 100)
   }
   if ( /* NO_RCX_REGI KNOWN_VALID || */ _cost[NO_RCX_REGI] > 100) {
     DFA_PRODUCTION(NO_RCX_REGI, loadConI_rule, 100)
   }
   if ( /* RBX_REGI KNOWN_VALID || */ _cost[RBX_REGI] > 100) {
     DFA_PRODUCTION(RBX_REGI, loadConI_rule, 100)
   }
   if ( /* NO_RAX_RDX_REGI KNOWN_VALID || */ _cost[NO_RAX_RDX_REGI] > 100) {
     DFA_PRODUCTION(NO_RAX_RDX_REGI, loadConI_rule, 100)
   }
   if ( /* RCX_REGI KNOWN_VALID || */ _cost[RCX_REGI] > 100) {
     DFA_PRODUCTION(RCX_REGI, loadConI_rule, 100)
   }
   if ( /* RDX_REGI KNOWN_VALID || */ _cost[RDX_REGI] > 100) {
     DFA_PRODUCTION(RDX_REGI, loadConI_rule, 100)
   }
   if ( /* RDI_REGI KNOWN_VALID || */ _cost[RDI_REGI] > 100) {
     DFA_PRODUCTION(RDI_REGI, loadConI_rule, 100)
   }
}
void  State::_sub_Op_ConL(const Node *n){
    jlong _n_get_long__ = n->get_long();
    if(         
#line 3387 "src/hotspot/cpu/x86/x86_64.ad"
_n_get_long__ == 65535
#line 6117 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(IMML_65535, immL_65535_rule, c)
    }
    if(         
#line 3377 "src/hotspot/cpu/x86/x86_64.ad"
_n_get_long__ == 255
#line 6125 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(IMML_255, immL_255_rule, c)
    }
    if(         
#line 3283 "src/hotspot/cpu/x86/x86_64.ad"
_n_get_long__ == 0xFFFFFFFFL
#line 6133 "dfa_x86.cpp"
 ) {
      unsigned int c = 20;
        DFA_PRODUCTION__SET_VALID(IMML_32BITS, immL_32bits_rule, c)
    }
    if(         
#line 3272 "src/hotspot/cpu/x86/x86_64.ad"
0 <= _n_get_long__ && _n_get_long__ < 0x80
#line 6141 "dfa_x86.cpp"
 ) {
      unsigned int c = 10;
        DFA_PRODUCTION__SET_VALID(IMML_127, immL_127_rule, c)
    }
    if(         
#line 3261 "src/hotspot/cpu/x86/x86_64.ad"
_n_get_long__ == 10
#line 6149 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(IMML10, immL10_rule, c)
    }
    if(         
#line 3251 "src/hotspot/cpu/x86/x86_64.ad"
_n_get_long__ == -1
#line 6157 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(IMML_M1, immL_M1_rule, c)
    }
    if(         
#line 3241 "src/hotspot/cpu/x86/x86_64.ad"
_n_get_long__ == 1
#line 6165 "dfa_x86.cpp"
 ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(IMML1, immL1_rule, c)
    }
    if(         
#line 3230 "src/hotspot/cpu/x86/x86_64.ad"
_n_get_long__ == 0L
#line 6173 "dfa_x86.cpp"
 ) {
      unsigned int c = 10;
        DFA_PRODUCTION__SET_VALID(IMML0, immL0_rule, c)
        DFA_PRODUCTION__SET_VALID(RREGL, loadConL0_rule, c+50)
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+50+100)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, loadConL0_rule, c+50)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, loadConL0_rule, c+50)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, loadConL0_rule, c+50)
        DFA_PRODUCTION__SET_VALID(RAX_REGL, loadConL0_rule, c+50)
        DFA_PRODUCTION__SET_VALID(RCX_REGL, loadConL0_rule, c+50)
        DFA_PRODUCTION__SET_VALID(RDX_REGL, loadConL0_rule, c+50)
    }
    if(         
#line 3219 "src/hotspot/cpu/x86/x86_64.ad"
_n_get_long__ == (int) (_n_get_long__)
#line 6189 "dfa_x86.cpp"
 ) {
      unsigned int c = 15;
        DFA_PRODUCTION__SET_VALID(IMML32, immL32_rule, c)
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c+70) {
        DFA_PRODUCTION__SET_VALID(RREGL, loadConL32_rule, c+70)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+70+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+70+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c+70) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, loadConL32_rule, c+70)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c+70) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, loadConL32_rule, c+70)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c+70) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, loadConL32_rule, c+70)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c+70) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, loadConL32_rule, c+70)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c+70) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, loadConL32_rule, c+70)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c+70) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, loadConL32_rule, c+70)
      }
    }
    if(         
#line 3208 "src/hotspot/cpu/x86/x86_64.ad"
_n_get_long__ == (unsigned int) (_n_get_long__)
#line 6221 "dfa_x86.cpp"
 ) {
      unsigned int c = 10;
        DFA_PRODUCTION__SET_VALID(IMMUL32, immUL32_rule, c)
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c+60) {
        DFA_PRODUCTION__SET_VALID(RREGL, loadConUL32_rule, c+60)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+60+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+60+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c+60) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, loadConUL32_rule, c+60)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c+60) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, loadConUL32_rule, c+60)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c+60) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, loadConUL32_rule, c+60)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c+60) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, loadConUL32_rule, c+60)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c+60) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, loadConUL32_rule, c+60)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c+60) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, loadConUL32_rule, c+60)
      }
    }
    if(         
#line 3197 "src/hotspot/cpu/x86/x86_64.ad"
-0x80L <= _n_get_long__ && _n_get_long__ < 0x80L
#line 6253 "dfa_x86.cpp"
 ) {
      unsigned int c = 5;
        DFA_PRODUCTION__SET_VALID(IMML8, immL8_rule, c)
    }
    {
      unsigned int c = 20;
        DFA_PRODUCTION__SET_VALID(IMML, immL_rule, c)
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c+150) {
        DFA_PRODUCTION__SET_VALID(RREGL, loadConL_rule, c+150)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+150+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+150+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c+150) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, loadConL_rule, c+150)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c+150) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, loadConL_rule, c+150)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c+150) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, loadConL_rule, c+150)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c+150) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, loadConL_rule, c+150)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c+150) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, loadConL_rule, c+150)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c+150) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, loadConL_rule, c+150)
      }
    }
   if ( /* RREGL KNOWN_VALID || */ _cost[RREGL] > 150) {
     DFA_PRODUCTION(RREGL, loadConL_rule, 150)
   }
   if ( /* STACKSLOTL KNOWN_VALID || */ _cost[STACKSLOTL] > 150+100) {
     DFA_PRODUCTION(STACKSLOTL, storeSSL_rule, 150+100)
   }
   if ( /* NO_RAX_RDX_REGL KNOWN_VALID || */ _cost[NO_RAX_RDX_REGL] > 150) {
     DFA_PRODUCTION(NO_RAX_RDX_REGL, loadConL_rule, 150)
   }
   if ( /* NO_RAX_REGL KNOWN_VALID || */ _cost[NO_RAX_REGL] > 150) {
     DFA_PRODUCTION(NO_RAX_REGL, loadConL_rule, 150)
   }
   if ( /* NO_RCX_REGL KNOWN_VALID || */ _cost[NO_RCX_REGL] > 150) {
     DFA_PRODUCTION(NO_RCX_REGL, loadConL_rule, 150)
   }
   if ( /* RAX_REGL KNOWN_VALID || */ _cost[RAX_REGL] > 150) {
     DFA_PRODUCTION(RAX_REGL, loadConL_rule, 150)
   }
   if ( /* RCX_REGL KNOWN_VALID || */ _cost[RCX_REGL] > 150) {
     DFA_PRODUCTION(RCX_REGL, loadConL_rule, 150)
   }
   if ( /* RDX_REGL KNOWN_VALID || */ _cost[RDX_REGL] > 150) {
     DFA_PRODUCTION(RDX_REGL, loadConL_rule, 150)
   }
}
void  State::_sub_Op_ConP(const Node *n){
    if(         
#line 3174 "src/hotspot/cpu/x86/x86_64.ad"
n->as_Type()->type()->reloc() == relocInfo::none
            && (n->get_ptr() >> 31) == 0
#line 6316 "dfa_x86.cpp"
 ) {
      unsigned int c = 5;
        DFA_PRODUCTION__SET_VALID(IMMP31, immP31_rule, c)
        DFA_PRODUCTION__SET_VALID(RREGP, loadConP31_rule, c+60)
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+60+100)
        DFA_PRODUCTION__SET_VALID(ANY_REGP, loadConP31_rule, c+60)
        DFA_PRODUCTION__SET_VALID(INDIRECT, loadConP31_rule, c+60)
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c+60)
        DFA_PRODUCTION__SET_VALID(RAX_REGP, loadConP31_rule, c+60)
        DFA_PRODUCTION__SET_VALID(RBX_REGP, loadConP31_rule, c+60)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, loadConP31_rule, c+60)
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, loadConP31_rule, c+60)
        DFA_PRODUCTION__SET_VALID(RSI_REGP, loadConP31_rule, c+60)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, loadConP31_rule, c+60)
        DFA_PRODUCTION__SET_VALID(RDI_REGP, loadConP31_rule, c+60)
        DFA_PRODUCTION__SET_VALID(R15_REGP, loadConP31_rule, c+60)
        DFA_PRODUCTION__SET_VALID(REX_REGP, loadConP31_rule, c+60)
    }
    if(         
#line 3137 "src/hotspot/cpu/x86/x86_64.ad"
n->get_ptr() == 0
#line 6338 "dfa_x86.cpp"
 ) {
      unsigned int c = 5;
        DFA_PRODUCTION__SET_VALID(IMMP0, immP0_rule, c)
      if (STATE__NOT_YET_VALID(RREGP) || _cost[RREGP] > c+50) {
        DFA_PRODUCTION__SET_VALID(RREGP, loadConP0_rule, c+50)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTP) || _cost[STACKSLOTP] > c+50+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+50+100)
      }
      if (STATE__NOT_YET_VALID(ANY_REGP) || _cost[ANY_REGP] > c+50) {
        DFA_PRODUCTION__SET_VALID(ANY_REGP, loadConP0_rule, c+50)
      }
      if (STATE__NOT_YET_VALID(INDIRECT) || _cost[INDIRECT] > c+50) {
        DFA_PRODUCTION__SET_VALID(INDIRECT, loadConP0_rule, c+50)
      }
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c+50) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c+50)
      }
      if (STATE__NOT_YET_VALID(RAX_REGP) || _cost[RAX_REGP] > c+50) {
        DFA_PRODUCTION__SET_VALID(RAX_REGP, loadConP0_rule, c+50)
      }
      if (STATE__NOT_YET_VALID(RBX_REGP) || _cost[RBX_REGP] > c+50) {
        DFA_PRODUCTION__SET_VALID(RBX_REGP, loadConP0_rule, c+50)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGP) || _cost[NO_RAX_REGP] > c+50) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, loadConP0_rule, c+50)
      }
      if (STATE__NOT_YET_VALID(NO_RBP_REGP) || _cost[NO_RBP_REGP] > c+50) {
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, loadConP0_rule, c+50)
      }
      if (STATE__NOT_YET_VALID(RSI_REGP) || _cost[RSI_REGP] > c+50) {
        DFA_PRODUCTION__SET_VALID(RSI_REGP, loadConP0_rule, c+50)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RBX_REGP) || _cost[NO_RAX_RBX_REGP] > c+50) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, loadConP0_rule, c+50)
      }
      if (STATE__NOT_YET_VALID(RDI_REGP) || _cost[RDI_REGP] > c+50) {
        DFA_PRODUCTION__SET_VALID(RDI_REGP, loadConP0_rule, c+50)
      }
      if (STATE__NOT_YET_VALID(R15_REGP) || _cost[R15_REGP] > c+50) {
        DFA_PRODUCTION__SET_VALID(R15_REGP, loadConP0_rule, c+50)
      }
      if (STATE__NOT_YET_VALID(REX_REGP) || _cost[REX_REGP] > c+50) {
        DFA_PRODUCTION__SET_VALID(REX_REGP, loadConP0_rule, c+50)
      }
    }
    {
      unsigned int c = 10;
        DFA_PRODUCTION__SET_VALID(IMMP, immP_rule, c)
      if (STATE__NOT_YET_VALID(RREGP) || _cost[RREGP] > c+100) {
        DFA_PRODUCTION__SET_VALID(RREGP, loadConP_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTP) || _cost[STACKSLOTP] > c+100+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+100+100)
      }
      if (STATE__NOT_YET_VALID(ANY_REGP) || _cost[ANY_REGP] > c+100) {
        DFA_PRODUCTION__SET_VALID(ANY_REGP, loadConP_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(INDIRECT) || _cost[INDIRECT] > c+100) {
        DFA_PRODUCTION__SET_VALID(INDIRECT, loadConP_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c+100) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGP) || _cost[RAX_REGP] > c+100) {
        DFA_PRODUCTION__SET_VALID(RAX_REGP, loadConP_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RBX_REGP) || _cost[RBX_REGP] > c+100) {
        DFA_PRODUCTION__SET_VALID(RBX_REGP, loadConP_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGP) || _cost[NO_RAX_REGP] > c+100) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, loadConP_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RBP_REGP) || _cost[NO_RBP_REGP] > c+100) {
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, loadConP_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RSI_REGP) || _cost[RSI_REGP] > c+100) {
        DFA_PRODUCTION__SET_VALID(RSI_REGP, loadConP_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RBX_REGP) || _cost[NO_RAX_RBX_REGP] > c+100) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, loadConP_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RDI_REGP) || _cost[RDI_REGP] > c+100) {
        DFA_PRODUCTION__SET_VALID(RDI_REGP, loadConP_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(R15_REGP) || _cost[R15_REGP] > c+100) {
        DFA_PRODUCTION__SET_VALID(R15_REGP, loadConP_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(REX_REGP) || _cost[REX_REGP] > c+100) {
        DFA_PRODUCTION__SET_VALID(REX_REGP, loadConP_rule, c+100)
      }
    }
   if ( /* RREGP KNOWN_VALID || */ _cost[RREGP] > 100) {
     DFA_PRODUCTION(RREGP, loadConP_rule, 100)
   }
   if ( /* STACKSLOTP KNOWN_VALID || */ _cost[STACKSLOTP] > 100+100) {
     DFA_PRODUCTION(STACKSLOTP, storeSSP_rule, 100+100)
   }
   if ( /* ANY_REGP KNOWN_VALID || */ _cost[ANY_REGP] > 100) {
     DFA_PRODUCTION(ANY_REGP, loadConP_rule, 100)
   }
   if ( /* INDIRECT KNOWN_VALID || */ _cost[INDIRECT] > 100) {
     DFA_PRODUCTION(INDIRECT, loadConP_rule, 100)
   }
   if ( /* MEMORY KNOWN_VALID || */ _cost[MEMORY] > 100) {
     DFA_PRODUCTION(MEMORY, indirect_rule, 100)
   }
   if ( /* RAX_REGP KNOWN_VALID || */ _cost[RAX_REGP] > 100) {
     DFA_PRODUCTION(RAX_REGP, loadConP_rule, 100)
   }
   if ( /* RBX_REGP KNOWN_VALID || */ _cost[RBX_REGP] > 100) {
     DFA_PRODUCTION(RBX_REGP, loadConP_rule, 100)
   }
   if ( /* NO_RAX_REGP KNOWN_VALID || */ _cost[NO_RAX_REGP] > 100) {
     DFA_PRODUCTION(NO_RAX_REGP, loadConP_rule, 100)
   }
   if ( /* NO_RBP_REGP KNOWN_VALID || */ _cost[NO_RBP_REGP] > 100) {
     DFA_PRODUCTION(NO_RBP_REGP, loadConP_rule, 100)
   }
   if ( /* RSI_REGP KNOWN_VALID || */ _cost[RSI_REGP] > 100) {
     DFA_PRODUCTION(RSI_REGP, loadConP_rule, 100)
   }
   if ( /* NO_RAX_RBX_REGP KNOWN_VALID || */ _cost[NO_RAX_RBX_REGP] > 100) {
     DFA_PRODUCTION(NO_RAX_RBX_REGP, loadConP_rule, 100)
   }
   if ( /* RDI_REGP KNOWN_VALID || */ _cost[RDI_REGP] > 100) {
     DFA_PRODUCTION(RDI_REGP, loadConP_rule, 100)
   }
   if ( /* R15_REGP KNOWN_VALID || */ _cost[R15_REGP] > 100) {
     DFA_PRODUCTION(R15_REGP, loadConP_rule, 100)
   }
   if ( /* REX_REGP KNOWN_VALID || */ _cost[REX_REGP] > 100) {
     DFA_PRODUCTION(REX_REGP, loadConP_rule, 100)
   }
}
void  State::_sub_Op_Conv2B(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGP) ) {
      unsigned int c = _kids[0]->_cost[RREGP]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, convP2B_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, convP2B_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, convP2B_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, convP2B_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, convP2B_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, convP2B_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, convP2B_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, convP2B_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, convI2B_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, convI2B_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, convI2B_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, convI2B_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, convI2B_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, convI2B_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, convI2B_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, convI2B_rule, c)
      }
    }
}
void  State::_sub_Op_ConvD2F(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _LOADD_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[_LOADD_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(REGF, convD2F_reg_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) ) {
      unsigned int c = _kids[0]->_cost[REGD]+100;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, convD2F_reg_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
}
void  State::_sub_Op_ConvD2I(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], REGD) ) {
      unsigned int c = _kids[0]->_cost[REGD]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, convD2I_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, convD2I_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, convD2I_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, convD2I_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, convD2I_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, convD2I_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, convD2I_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, convD2I_reg_reg_rule, c)
    }
}
void  State::_sub_Op_ConvD2L(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], REGD) ) {
      unsigned int c = _kids[0]->_cost[REGD]+100;
        DFA_PRODUCTION__SET_VALID(RREGL, convD2L_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, convD2L_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, convD2L_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, convD2L_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGL, convD2L_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGL, convD2L_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGL, convD2L_reg_reg_rule, c)
    }
}
void  State::_sub_Op_ConvF2D(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _LOADF_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[_LOADF_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(REGD, convF2D_reg_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) ) {
      unsigned int c = _kids[0]->_cost[REGF]+100;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, convF2D_reg_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
}
void  State::_sub_Op_ConvF2I(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], REGF) ) {
      unsigned int c = _kids[0]->_cost[REGF]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, convF2I_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, convF2I_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, convF2I_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, convF2I_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, convF2I_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, convF2I_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, convF2I_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, convF2I_reg_reg_rule, c)
    }
}
void  State::_sub_Op_ConvF2L(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], REGF) ) {
      unsigned int c = _kids[0]->_cost[REGF]+100;
        DFA_PRODUCTION__SET_VALID(RREGL, convF2L_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, convF2L_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, convF2L_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, convF2L_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGL, convF2L_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGL, convF2L_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGL, convF2L_reg_reg_rule, c)
    }
}
void  State::_sub_Op_ConvI2D(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGI) &&
        (
#line 10909 "src/hotspot/cpu/x86/x86_64.ad"
UseXmmI2D
#line 6625 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
        DFA_PRODUCTION__SET_VALID(REGD, convXI2D_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, convI2D_reg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) &&
        (
#line 10872 "src/hotspot/cpu/x86/x86_64.ad"
!UseXmmI2D
#line 6652 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, convI2D_reg_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
}
void  State::_sub_Op_ConvI2F(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGI) &&
        (
#line 10895 "src/hotspot/cpu/x86/x86_64.ad"
UseXmmI2F
#line 6674 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
        DFA_PRODUCTION__SET_VALID(REGF, convXI2F_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, convI2F_reg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) &&
        (
#line 10849 "src/hotspot/cpu/x86/x86_64.ad"
!UseXmmI2F
#line 6701 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, convI2F_reg_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
}
void  State::_sub_Op_ConvI2L(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+125;
        DFA_PRODUCTION__SET_VALID(RREGL, convI2L_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, convI2L_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, convI2L_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, convI2L_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGL, convI2L_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGL, convI2L_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGL, convI2L_reg_reg_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _ANDI_RREGI_IMMI_65535) ) {
      unsigned int c = _kids[0]->_cost[_ANDI_RREGI_IMMI_65535]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, andI2L_rReg_imm65535_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, andI2L_rReg_imm65535_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, andI2L_rReg_imm65535_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, andI2L_rReg_imm65535_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, andI2L_rReg_imm65535_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, andI2L_rReg_imm65535_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, andI2L_rReg_imm65535_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _ANDI_RREGI_IMMI_255) ) {
      unsigned int c = _kids[0]->_cost[_ANDI_RREGI_IMMI_255]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, andI2L_rReg_imm255_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, andI2L_rReg_imm255_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, andI2L_rReg_imm255_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, andI2L_rReg_imm255_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, andI2L_rReg_imm255_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, andI2L_rReg_imm255_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, andI2L_rReg_imm255_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_];
        DFA_PRODUCTION__SET_VALID(_CONVI2L__LOADI_MEMORY__, _ConvI2L__LoadI_memory___rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _ANDI__LOADI_MEMORY__IMMU31) ) {
      unsigned int c = _kids[0]->_cost[_ANDI__LOADI_MEMORY__IMMU31]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, loadI2L_immU31_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, loadI2L_immU31_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, loadI2L_immU31_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, loadI2L_immU31_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, loadI2L_immU31_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, loadI2L_immU31_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, loadI2L_immU31_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _ANDI__LOADI_MEMORY__IMMI_65535) ) {
      unsigned int c = _kids[0]->_cost[_ANDI__LOADI_MEMORY__IMMI_65535]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, loadI2L_immI_65535_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, loadI2L_immI_65535_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, loadI2L_immI_65535_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, loadI2L_immI_65535_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, loadI2L_immI_65535_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, loadI2L_immI_65535_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, loadI2L_immI_65535_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _ANDI__LOADI_MEMORY__IMMI_255) ) {
      unsigned int c = _kids[0]->_cost[_ANDI__LOADI_MEMORY__IMMI_255]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, loadI2L_immI_255_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, loadI2L_immI_255_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, loadI2L_immI_255_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, loadI2L_immI_255_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, loadI2L_immI_255_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, loadI2L_immI_255_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, loadI2L_immI_255_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+125;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, loadI2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, loadI2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, loadI2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, loadI2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, loadI2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, loadI2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, loadI2L_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _ANDI__LOADUS_MEMORY__IMMI) ) {
      unsigned int c = _kids[0]->_cost[_ANDI__LOADUS_MEMORY__IMMI]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, loadUS2L_immI_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, loadUS2L_immI_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, loadUS2L_immI_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, loadUS2L_immI_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, loadUS2L_immI_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, loadUS2L_immI_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, loadUS2L_immI_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _ANDI__LOADUS_MEMORY__IMMI_255) ) {
      unsigned int c = _kids[0]->_cost[_ANDI__LOADUS_MEMORY__IMMI_255]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, loadUS2L_immI_255_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, loadUS2L_immI_255_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, loadUS2L_immI_255_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, loadUS2L_immI_255_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, loadUS2L_immI_255_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, loadUS2L_immI_255_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, loadUS2L_immI_255_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADUS_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[_LOADUS_MEMORY_]+125;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, loadUS2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, loadUS2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, loadUS2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, loadUS2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, loadUS2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, loadUS2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, loadUS2L_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADS_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[_LOADS_MEMORY_]+125;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, loadS2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, loadS2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, loadS2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, loadS2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, loadS2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, loadS2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, loadS2L_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _ANDI__LOADUB_MEMORY__IMMI) ) {
      unsigned int c = _kids[0]->_cost[_ANDI__LOADUB_MEMORY__IMMI]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, loadUB2L_immI_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, loadUB2L_immI_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, loadUB2L_immI_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, loadUB2L_immI_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, loadUB2L_immI_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, loadUB2L_immI_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, loadUB2L_immI_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADUB_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[_LOADUB_MEMORY_]+125;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, loadUB2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, loadUB2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, loadUB2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, loadUB2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, loadUB2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, loadUB2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, loadUB2L_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADB_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[_LOADB_MEMORY_]+125;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, loadB2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, loadB2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, loadB2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, loadB2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, loadB2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, loadB2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, loadB2L_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) ) {
      unsigned int c = _kids[0]->_cost[RREGI];
        DFA_PRODUCTION__SET_VALID(_CONVI2L_RREGI_, _ConvI2L_rRegI__rule, c)
    }
}
void  State::_sub_Op_ConvL2D(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(REGD, convL2D_reg_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+100;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, convL2D_reg_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
}
void  State::_sub_Op_ConvL2F(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(REGF, convL2F_reg_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+100;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, convL2F_reg_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
}
void  State::_sub_Op_ConvL2I(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGL) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, convL2I_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, convL2I_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, convL2I_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, convL2I_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, convL2I_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, convL2I_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, convL2I_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, convL2I_reg_reg_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _CASTP2X__DECODEN_RREGN__) &&
        (
#line 6995 "src/hotspot/cpu/x86/x86_64.ad"
Universe::narrow_oop_shift() == 0
#line 7155 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_CASTP2X__DECODEN_RREGN__]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, convN2I_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, convN2I_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, convN2I_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, convN2I_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, convN2I_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, convN2I_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, convN2I_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, convN2I_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _CASTP2X_RREGP_) ) {
      unsigned int c = _kids[0]->_cost[_CASTP2X_RREGP_]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, convP2I_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, convP2I_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, convP2I_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, convP2I_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, convP2I_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, convP2I_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, convP2I_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, convP2I_rule, c)
      }
    }
}
void  State::_sub_Op_CountedLoopEnd(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], CMPOPUCF) && STATE__VALID_CHILD(_kids[1], RFLAGSREGUCF) &&
        (
#line 12429 "src/hotspot/cpu/x86/x86_64.ad"
n->has_vector_mask_set()
#line 7222 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[CMPOPUCF]+_kids[1]->_cost[RFLAGSREGUCF]+300;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, jmpLoopEndUCF_and_restoreMask_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], CMPOPU) && STATE__VALID_CHILD(_kids[1], RFLAGSREGU) &&
        (
#line 12412 "src/hotspot/cpu/x86/x86_64.ad"
n->has_vector_mask_set()
#line 7231 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[CMPOPU]+_kids[1]->_cost[RFLAGSREGU]+400;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, jmpLoopEndU_and_restoreMask_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], CMPOP) && STATE__VALID_CHILD(_kids[1], RFLAGSREG) &&
        (
#line 12394 "src/hotspot/cpu/x86/x86_64.ad"
n->has_vector_mask_set()
#line 7242 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[CMPOP]+_kids[1]->_cost[RFLAGSREG]+400;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, jmpLoopEnd_and_restoreMask_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], CMPOPUCF) && STATE__VALID_CHILD(_kids[1], RFLAGSREGUCF) &&
        (
#line 12376 "src/hotspot/cpu/x86/x86_64.ad"
!n->has_vector_mask_set()
#line 7253 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[CMPOPUCF]+_kids[1]->_cost[RFLAGSREGUCF]+200;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, jmpLoopEndUCF_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], CMPOPU) && STATE__VALID_CHILD(_kids[1], RFLAGSREGU) &&
        (
#line 12361 "src/hotspot/cpu/x86/x86_64.ad"
!n->has_vector_mask_set()
#line 7264 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[CMPOPU]+_kids[1]->_cost[RFLAGSREGU]+300;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, jmpLoopEndU_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], CMPOP) && STATE__VALID_CHILD(_kids[1], RFLAGSREG) &&
        (
#line 12345 "src/hotspot/cpu/x86/x86_64.ad"
!n->has_vector_mask_set()
#line 7275 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[CMPOP]+_kids[1]->_cost[RFLAGSREG]+300;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, jmpLoopEnd_rule, c)
      }
    }
}
void  State::_sub_Op_CountLeadingZerosI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGI) &&
        (
#line 6682 "src/hotspot/cpu/x86/x86_64.ad"
!UseCountLeadingZerosInstruction
#line 7288 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, countLeadingZerosI_bsr_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, countLeadingZerosI_bsr_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, countLeadingZerosI_bsr_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, countLeadingZerosI_bsr_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, countLeadingZerosI_bsr_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, countLeadingZerosI_bsr_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, countLeadingZerosI_bsr_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, countLeadingZerosI_bsr_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) &&
        (
#line 6670 "src/hotspot/cpu/x86/x86_64.ad"
UseCountLeadingZerosInstruction
#line 7305 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, countLeadingZerosI_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, countLeadingZerosI_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, countLeadingZerosI_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, countLeadingZerosI_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, countLeadingZerosI_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, countLeadingZerosI_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, countLeadingZerosI_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, countLeadingZerosI_rule, c)
      }
    }
}
void  State::_sub_Op_CountLeadingZerosL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGL) &&
        (
#line 6719 "src/hotspot/cpu/x86/x86_64.ad"
!UseCountLeadingZerosInstruction
#line 7342 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, countLeadingZerosL_bsr_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, countLeadingZerosL_bsr_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, countLeadingZerosL_bsr_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, countLeadingZerosL_bsr_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, countLeadingZerosL_bsr_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, countLeadingZerosL_bsr_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, countLeadingZerosL_bsr_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, countLeadingZerosL_bsr_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) &&
        (
#line 6707 "src/hotspot/cpu/x86/x86_64.ad"
UseCountLeadingZerosInstruction
#line 7359 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, countLeadingZerosL_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, countLeadingZerosL_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, countLeadingZerosL_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, countLeadingZerosL_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, countLeadingZerosL_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, countLeadingZerosL_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, countLeadingZerosL_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, countLeadingZerosL_rule, c)
      }
    }
}
void  State::_sub_Op_CountTrailingZerosI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGI) &&
        (
#line 6756 "src/hotspot/cpu/x86/x86_64.ad"
!UseCountTrailingZerosInstruction
#line 7396 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, countTrailingZerosI_bsf_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, countTrailingZerosI_bsf_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, countTrailingZerosI_bsf_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, countTrailingZerosI_bsf_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, countTrailingZerosI_bsf_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, countTrailingZerosI_bsf_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, countTrailingZerosI_bsf_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, countTrailingZerosI_bsf_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) &&
        (
#line 6744 "src/hotspot/cpu/x86/x86_64.ad"
UseCountTrailingZerosInstruction
#line 7413 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, countTrailingZerosI_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, countTrailingZerosI_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, countTrailingZerosI_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, countTrailingZerosI_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, countTrailingZerosI_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, countTrailingZerosI_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, countTrailingZerosI_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, countTrailingZerosI_rule, c)
      }
    }
}
void  State::_sub_Op_CountTrailingZerosL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGL) &&
        (
#line 6788 "src/hotspot/cpu/x86/x86_64.ad"
!UseCountTrailingZerosInstruction
#line 7450 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, countTrailingZerosL_bsf_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, countTrailingZerosL_bsf_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, countTrailingZerosL_bsf_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, countTrailingZerosL_bsf_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, countTrailingZerosL_bsf_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, countTrailingZerosL_bsf_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, countTrailingZerosL_bsf_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, countTrailingZerosL_bsf_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) &&
        (
#line 6776 "src/hotspot/cpu/x86/x86_64.ad"
UseCountTrailingZerosInstruction
#line 7467 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, countTrailingZerosL_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, countTrailingZerosL_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, countTrailingZerosL_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, countTrailingZerosL_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, countTrailingZerosL_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, countTrailingZerosL_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, countTrailingZerosL_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, countTrailingZerosL_rule, c)
      }
    }
}
void  State::_sub_Op_CreateEx(const Node *n){
    {
      unsigned int c = 100;
        DFA_PRODUCTION__SET_VALID(RAX_REGP, CreateException_rule, c)
        DFA_PRODUCTION__SET_VALID(ANY_REGP, CreateException_rule, c)
        DFA_PRODUCTION__SET_VALID(INDIRECT, CreateException_rule, c)
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c)
        DFA_PRODUCTION__SET_VALID(RREGP, CreateException_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RBX_REGP, CreateException_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, CreateException_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, CreateException_rule, c)
        DFA_PRODUCTION__SET_VALID(RSI_REGP, CreateException_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, CreateException_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGP, CreateException_rule, c)
        DFA_PRODUCTION__SET_VALID(R15_REGP, CreateException_rule, c)
        DFA_PRODUCTION__SET_VALID(REX_REGP, CreateException_rule, c)
    }
}
void  State::_sub_Op_DecodeN(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGN) &&
        (
#line 7051 "src/hotspot/cpu/x86/x86_64.ad"
n->bottom_type()->is_ptr()->ptr() == TypePtr::NotNull ||
            n->bottom_type()->is_ptr()->ptr() == TypePtr::Constant
#line 7524 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGN]+100;
        DFA_PRODUCTION__SET_VALID(RREGP, decodeHeapOop_not_null_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+100)
        DFA_PRODUCTION__SET_VALID(ANY_REGP, decodeHeapOop_not_null_rule, c)
        DFA_PRODUCTION__SET_VALID(INDIRECT, decodeHeapOop_not_null_rule, c)
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGP, decodeHeapOop_not_null_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGP, decodeHeapOop_not_null_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, decodeHeapOop_not_null_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, decodeHeapOop_not_null_rule, c)
        DFA_PRODUCTION__SET_VALID(RSI_REGP, decodeHeapOop_not_null_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, decodeHeapOop_not_null_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGP, decodeHeapOop_not_null_rule, c)
        DFA_PRODUCTION__SET_VALID(R15_REGP, decodeHeapOop_not_null_rule, c)
        DFA_PRODUCTION__SET_VALID(REX_REGP, decodeHeapOop_not_null_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGN) &&
        (
#line 7034 "src/hotspot/cpu/x86/x86_64.ad"
n->bottom_type()->is_ptr()->ptr() != TypePtr::NotNull &&
            n->bottom_type()->is_ptr()->ptr() != TypePtr::Constant
#line 7547 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGN]+100;
      if (STATE__NOT_YET_VALID(RREGP) || _cost[RREGP] > c) {
        DFA_PRODUCTION__SET_VALID(RREGP, decodeHeapOop_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTP) || _cost[STACKSLOTP] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(ANY_REGP) || _cost[ANY_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(ANY_REGP, decodeHeapOop_rule, c)
      }
      if (STATE__NOT_YET_VALID(INDIRECT) || _cost[INDIRECT] > c) {
        DFA_PRODUCTION__SET_VALID(INDIRECT, decodeHeapOop_rule, c)
      }
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGP) || _cost[RAX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGP, decodeHeapOop_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGP) || _cost[RBX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGP, decodeHeapOop_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGP) || _cost[NO_RAX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, decodeHeapOop_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RBP_REGP) || _cost[NO_RBP_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, decodeHeapOop_rule, c)
      }
      if (STATE__NOT_YET_VALID(RSI_REGP) || _cost[RSI_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(RSI_REGP, decodeHeapOop_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RBX_REGP) || _cost[NO_RAX_RBX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, decodeHeapOop_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGP) || _cost[RDI_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGP, decodeHeapOop_rule, c)
      }
      if (STATE__NOT_YET_VALID(R15_REGP) || _cost[R15_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(R15_REGP, decodeHeapOop_rule, c)
      }
      if (STATE__NOT_YET_VALID(REX_REGP) || _cost[REX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(REX_REGP, decodeHeapOop_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGN) &&
        
#line 4069 "src/hotspot/cpu/x86/x86_64.ad"
Universe::narrow_oop_shift() == 0
#line 7597 "dfa_x86.cpp"
 ) {
      unsigned int c = _kids[0]->_cost[RREGN];
        DFA_PRODUCTION__SET_VALID(INDIRECTNARROW, indirectNarrow_rule, c)
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indirectNarrow_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGN) ) {
      unsigned int c = _kids[0]->_cost[RREGN];
        DFA_PRODUCTION__SET_VALID(_DECODEN_RREGN_, _DecodeN_rRegN__rule, c)
    }
}
void  State::_sub_Op_DecodeNKlass(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGN) ) {
      unsigned int c = _kids[0]->_cost[RREGN]+100;
        DFA_PRODUCTION__SET_VALID(RREGP, decodeKlass_not_null_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+100)
        DFA_PRODUCTION__SET_VALID(ANY_REGP, decodeKlass_not_null_rule, c)
        DFA_PRODUCTION__SET_VALID(INDIRECT, decodeKlass_not_null_rule, c)
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGP, decodeKlass_not_null_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGP, decodeKlass_not_null_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, decodeKlass_not_null_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, decodeKlass_not_null_rule, c)
        DFA_PRODUCTION__SET_VALID(RSI_REGP, decodeKlass_not_null_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, decodeKlass_not_null_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGP, decodeKlass_not_null_rule, c)
        DFA_PRODUCTION__SET_VALID(R15_REGP, decodeKlass_not_null_rule, c)
        DFA_PRODUCTION__SET_VALID(REX_REGP, decodeKlass_not_null_rule, c)
    }
}
void  State::_sub_Op_DivD(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], IMMD) &&
        (
#line 2704 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 7634 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[IMMD]+150;
        DFA_PRODUCTION__SET_VALID(REGD, divD_reg_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], _LOADD_MEMORY_) &&
        (
#line 2692 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 7646 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[_LOADD_MEMORY_]+150;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, divD_reg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], REGD) &&
        (
#line 2680 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 7666 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[REGD]+150;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, divD_reg_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], IMMD) &&
        (
#line 2669 "src/hotspot/cpu/x86/x86.ad"
(UseSSE>=2) && (UseAVX == 0)
#line 7686 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[IMMD]+150;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, divD_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], _LOADD_MEMORY_) &&
        (
#line 2657 "src/hotspot/cpu/x86/x86.ad"
(UseSSE>=2) && (UseAVX == 0)
#line 7706 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[_LOADD_MEMORY_]+150;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, divD_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], REGD) &&
        (
#line 2645 "src/hotspot/cpu/x86/x86.ad"
(UseSSE>=2) && (UseAVX == 0)
#line 7726 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[REGD]+150;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, divD_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
}
void  State::_sub_Op_DivF(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], IMMF) &&
        (
#line 2633 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 7748 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[IMMF]+150;
        DFA_PRODUCTION__SET_VALID(REGF, divF_reg_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], _LOADF_MEMORY_) &&
        (
#line 2621 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 7760 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[_LOADF_MEMORY_]+150;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, divF_reg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], REGF) &&
        (
#line 2609 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 7780 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[REGF]+150;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, divF_reg_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], IMMF) &&
        (
#line 2598 "src/hotspot/cpu/x86/x86.ad"
(UseSSE>=1) && (UseAVX == 0)
#line 7800 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[IMMF]+150;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, divF_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], _LOADF_MEMORY_) &&
        (
#line 2586 "src/hotspot/cpu/x86/x86.ad"
(UseSSE>=1) && (UseAVX == 0)
#line 7820 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[_LOADF_MEMORY_]+150;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, divF_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], REGF) &&
        (
#line 2574 "src/hotspot/cpu/x86/x86.ad"
(UseSSE>=1) && (UseAVX == 0)
#line 7840 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[REGF]+150;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, divF_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
}
void  State::_sub_Op_DivI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RAX_REGI) && STATE__VALID_CHILD(_kids[1], NO_RAX_RDX_REGI) ) {
      unsigned int c = _kids[0]->_cost[RAX_REGI]+_kids[1]->_cost[NO_RAX_RDX_REGI]+30*100+10*100;
        DFA_PRODUCTION__SET_VALID(RAX_REGI, divI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RREGI, divI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, divI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, divI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, divI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, divI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, divI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, divI_rReg_rule, c)
    }
}
void  State::_sub_Op_DivL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], NO_RAX_REGL) && STATE__VALID_CHILD(_kids[1], IMML10) ) {
      unsigned int c = _kids[0]->_cost[NO_RAX_REGL]+_kids[1]->_cost[IMML10]+(5+8)*100;
        DFA_PRODUCTION__SET_VALID(RDX_REGL, divL_10_rule, c)
        DFA_PRODUCTION__SET_VALID(RREGL, divL_10_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, divL_10_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, divL_10_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, divL_10_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGL, divL_10_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGL, divL_10_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RAX_REGL) && STATE__VALID_CHILD(_kids[1], NO_RAX_RDX_REGL) ) {
      unsigned int c = _kids[0]->_cost[RAX_REGL]+_kids[1]->_cost[NO_RAX_RDX_REGL]+30*100+10*100;
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, divL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, divL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, divL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, divL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, divL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, divL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, divL_rReg_rule, c)
      }
    }
}
void  State::_sub_Op_DivModI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RAX_REGI) && STATE__VALID_CHILD(_kids[1], NO_RAX_RDX_REGI) ) {
      unsigned int c = _kids[0]->_cost[RAX_REGI]+_kids[1]->_cost[NO_RAX_RDX_REGI]+30*100+10*100;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, divModI_rReg_divmod_rule, c)
    }
}
void  State::_sub_Op_DivModL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RAX_REGL) && STATE__VALID_CHILD(_kids[1], NO_RAX_RDX_REGL) ) {
      unsigned int c = _kids[0]->_cost[RAX_REGL]+_kids[1]->_cost[NO_RAX_RDX_REGL]+30*100+10*100;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, divModL_rReg_divmod_rule, c)
    }
}
void  State::_sub_Op_EncodeISOArray(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RSI_REGP) && STATE__VALID_CHILD(_kids[1], _BINARY_RDI_REGP_RDX_REGI) ) {
      unsigned int c = _kids[0]->_cost[RSI_REGP]+_kids[1]->_cost[_BINARY_RDI_REGP_RDX_REGI]+100;
        DFA_PRODUCTION__SET_VALID(RAX_REGI, encode_iso_array_rule, c)
        DFA_PRODUCTION__SET_VALID(RREGI, encode_iso_array_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, encode_iso_array_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, encode_iso_array_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, encode_iso_array_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, encode_iso_array_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, encode_iso_array_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, encode_iso_array_rule, c)
    }
}
void  State::_sub_Op_EncodeP(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGP) &&
        (
#line 7023 "src/hotspot/cpu/x86/x86_64.ad"
n->bottom_type()->make_ptr()->ptr() == TypePtr::NotNull
#line 7942 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGP]+100;
        DFA_PRODUCTION__SET_VALID(RREGN, encodeHeapOop_not_null_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGN, encodeHeapOop_not_null_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGP) &&
        (
#line 7007 "src/hotspot/cpu/x86/x86_64.ad"
n->bottom_type()->make_ptr()->ptr() != TypePtr::NotNull
#line 7952 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGP]+100;
      if (STATE__NOT_YET_VALID(RREGN) || _cost[RREGN] > c) {
        DFA_PRODUCTION__SET_VALID(RREGN, encodeHeapOop_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGN) || _cost[RAX_REGN] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGN, encodeHeapOop_rule, c)
      }
    }
}
void  State::_sub_Op_EncodePKlass(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGP) ) {
      unsigned int c = _kids[0]->_cost[RREGP]+100;
        DFA_PRODUCTION__SET_VALID(RREGN, encodeKlass_not_null_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGN, encodeKlass_not_null_rule, c)
    }
}
void  State::_sub_Op_FastLock(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGP) && STATE__VALID_CHILD(_kids[1], RBX_REGP) &&
        (
#line 12733 "src/hotspot/cpu/x86/x86_64.ad"
!Compile::current()->use_rtm()
#line 7975 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGP]+_kids[1]->_cost[RBX_REGP]+300;
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, cmpFastLock_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGP) && STATE__VALID_CHILD(_kids[1], RBX_REGP) &&
        (
#line 12717 "src/hotspot/cpu/x86/x86_64.ad"
Compile::current()->use_rtm()
#line 7984 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGP]+_kids[1]->_cost[RBX_REGP]+300;
      if (STATE__NOT_YET_VALID(RFLAGSREG) || _cost[RFLAGSREG] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, cmpFastLockRTM_rule, c)
      }
    }
}
void  State::_sub_Op_FastUnlock(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGP) && STATE__VALID_CHILD(_kids[1], RAX_REGP) ) {
      unsigned int c = _kids[0]->_cost[RREGP]+_kids[1]->_cost[RAX_REGP]+300;
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, cmpFastUnlock_rule, c)
    }
}
void  State::_sub_Op_FmaD(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], _BINARY_REGD_REGD) &&
        (
#line 3008 "src/hotspot/cpu/x86/x86.ad"
UseFMA
#line 8003 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[_BINARY_REGD_REGD]+150;
        DFA_PRODUCTION__SET_VALID(REGD, fmaD_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
    }
}
void  State::_sub_Op_FmaF(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], _BINARY_REGF_REGF) &&
        (
#line 3020 "src/hotspot/cpu/x86/x86.ad"
UseFMA
#line 8017 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[_BINARY_REGF_REGF]+150;
        DFA_PRODUCTION__SET_VALID(REGF, fmaF_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
    }
}
void  State::_sub_Op_Goto(const Node *n){
    {
      unsigned int c = 300;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, jmpDir_rule, c)
    }
}
void  State::_sub_Op_Halt(const Node *n){
    {
      unsigned int c = 100;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, ShouldNotReachHere_rule, c)
    }
}
void  State::_sub_Op_HasNegatives(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RSI_REGP) && STATE__VALID_CHILD(_kids[1], RCX_REGI) ) {
      unsigned int c = _kids[0]->_cost[RSI_REGP]+_kids[1]->_cost[RCX_REGI]+100;
        DFA_PRODUCTION__SET_VALID(RAX_REGI, has_negatives_rule, c)
        DFA_PRODUCTION__SET_VALID(RREGI, has_negatives_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, has_negatives_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, has_negatives_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, has_negatives_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, has_negatives_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, has_negatives_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, has_negatives_rule, c)
    }
}
void  State::_sub_Op_If(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], CMPOPUCF2) && STATE__VALID_CHILD(_kids[1], RFLAGSREGUCF) ) {
      unsigned int c = _kids[0]->_cost[CMPOPUCF2]+_kids[1]->_cost[RFLAGSREGUCF]+200;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, jmpConUCF2_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], CMPOPUCF) && STATE__VALID_CHILD(_kids[1], RFLAGSREGUCF) ) {
      unsigned int c = _kids[0]->_cost[CMPOPUCF]+_kids[1]->_cost[RFLAGSREGUCF]+200;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, jmpConUCF_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], CMPOPU) && STATE__VALID_CHILD(_kids[1], RFLAGSREGU) ) {
      unsigned int c = _kids[0]->_cost[CMPOPU]+_kids[1]->_cost[RFLAGSREGU]+300;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, jmpConU_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], CMPOP) && STATE__VALID_CHILD(_kids[1], RFLAGSREG) ) {
      unsigned int c = _kids[0]->_cost[CMPOP]+_kids[1]->_cost[RFLAGSREG]+300;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, jmpCon_rule, c)
      }
    }
}
void  State::_sub_Op_Jump(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGL) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+350;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, jumpXtnd_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _ADDL__LSHIFTL_RREGL_IMMI2_IMML32) ) {
      unsigned int c = _kids[0]->_cost[_ADDL__LSHIFTL_RREGL_IMMI2_IMML32]+350;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, jumpXtnd_addr_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LSHIFTL_RREGL_IMMI2) &&
        (
#line 7101 "src/hotspot/cpu/x86/x86_64.ad"
false
#line 8091 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LSHIFTL_RREGL_IMMI2]+350;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, jumpXtnd_offset_rule, c)
      }
    }
}
void  State::_sub_Op_LShiftI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], NO_RCX_REGI) && STATE__VALID_CHILD(_kids[1], _SUBI_IMMI_32_RCX_REGI) ) {
      unsigned int c = _kids[0]->_cost[NO_RCX_REGI]+_kids[1]->_cost[_SUBI_IMMI_32_RCX_REGI];
        DFA_PRODUCTION__SET_VALID(_LSHIFTI_NO_RCX_REGI__SUBI_IMMI_32_RCX_REGI, _LShiftI_no_rcx_RegI__SubI_immI_32_rcx_RegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], NO_RCX_REGI) && STATE__VALID_CHILD(_kids[1], _SUBI_IMMI0_RCX_REGI) ) {
      unsigned int c = _kids[0]->_cost[NO_RCX_REGI]+_kids[1]->_cost[_SUBI_IMMI0_RCX_REGI];
        DFA_PRODUCTION__SET_VALID(_LSHIFTI_NO_RCX_REGI__SUBI_IMMI0_RCX_REGI, _LShiftI_no_rcx_RegI__SubI_immI0_rcx_RegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI_M1) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI_M1];
        DFA_PRODUCTION__SET_VALID(_LSHIFTI_RREGI_IMMI_M1, _LShiftI_rRegI_immI_M1_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], NO_RCX_REGI) && STATE__VALID_CHILD(_kids[1], RCX_REGI) ) {
      unsigned int c = _kids[0]->_cost[NO_RCX_REGI]+_kids[1]->_cost[RCX_REGI];
        DFA_PRODUCTION__SET_VALID(_LSHIFTI_NO_RCX_REGI_RCX_REGI, _LShiftI_no_rcx_RegI_rcx_RegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI8) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI8];
        DFA_PRODUCTION__SET_VALID(_LSHIFTI_RREGI_IMMI8, _LShiftI_rRegI_immI8_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI1) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI1];
        DFA_PRODUCTION__SET_VALID(_LSHIFTI_RREGI_IMMI1, _LShiftI_rRegI_immI1_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI_16) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI_16];
        DFA_PRODUCTION__SET_VALID(_LSHIFTI_RREGI_IMMI_16, _LShiftI_rRegI_immI_16_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI_24) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI_24];
        DFA_PRODUCTION__SET_VALID(_LSHIFTI_RREGI_IMMI_24, _LShiftI_rRegI_immI_24_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], RCX_REGI) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[RCX_REGI];
        DFA_PRODUCTION__SET_VALID(_LSHIFTI__LOADI_MEMORY__RCX_REGI, _LShiftI__LoadI_memory__rcx_RegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], RCX_REGI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[RCX_REGI]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, salI_rReg_CL_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, salI_rReg_CL_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, salI_rReg_CL_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, salI_rReg_CL_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, salI_rReg_CL_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, salI_rReg_CL_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, salI_rReg_CL_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, salI_rReg_CL_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMI8) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[IMMI8];
        DFA_PRODUCTION__SET_VALID(_LSHIFTI__LOADI_MEMORY__IMMI8, _LShiftI__LoadI_memory__immI8_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI8) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI8]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, salI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, salI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, salI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, salI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, salI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, salI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, salI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, salI_rReg_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMI1) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[IMMI1];
        DFA_PRODUCTION__SET_VALID(_LSHIFTI__LOADI_MEMORY__IMMI1, _LShiftI__LoadI_memory__immI1_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI1) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI1]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, salI_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, salI_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, salI_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, salI_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, salI_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, salI_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, salI_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, salI_rReg_1_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMI_16) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[IMMI_16];
        DFA_PRODUCTION__SET_VALID(_LSHIFTI__LOADI_MEMORY__IMMI_16, _LShiftI__LoadI_memory__immI_16_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMI_24) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[IMMI_24];
        DFA_PRODUCTION__SET_VALID(_LSHIFTI__LOADI_MEMORY__IMMI_24, _LShiftI__LoadI_memory__immI_24_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADUS_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMI_24) ) {
      unsigned int c = _kids[0]->_cost[_LOADUS_MEMORY_]+_kids[1]->_cost[IMMI_24];
        DFA_PRODUCTION__SET_VALID(_LSHIFTI__LOADUS_MEMORY__IMMI_24, _LShiftI__LoadUS_memory__immI_24_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADS_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMI_24) ) {
      unsigned int c = _kids[0]->_cost[_LOADS_MEMORY_]+_kids[1]->_cost[IMMI_24];
        DFA_PRODUCTION__SET_VALID(_LSHIFTI__LOADS_MEMORY__IMMI_24, _LShiftI__LoadS_memory__immI_24_rule, c)
    }
}
void  State::_sub_Op_LShiftL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], NO_RCX_REGL) && STATE__VALID_CHILD(_kids[1], _SUBI_IMMI_64_RCX_REGI) ) {
      unsigned int c = _kids[0]->_cost[NO_RCX_REGL]+_kids[1]->_cost[_SUBI_IMMI_64_RCX_REGI];
        DFA_PRODUCTION__SET_VALID(_LSHIFTL_NO_RCX_REGL__SUBI_IMMI_64_RCX_REGI, _LShiftL_no_rcx_RegL__SubI_immI_64_rcx_RegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], NO_RCX_REGL) && STATE__VALID_CHILD(_kids[1], _SUBI_IMMI0_RCX_REGI) ) {
      unsigned int c = _kids[0]->_cost[NO_RCX_REGL]+_kids[1]->_cost[_SUBI_IMMI0_RCX_REGI];
        DFA_PRODUCTION__SET_VALID(_LSHIFTL_NO_RCX_REGL__SUBI_IMMI0_RCX_REGI, _LShiftL_no_rcx_RegL__SubI_immI0_rcx_RegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], IMMI_M1) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[IMMI_M1];
        DFA_PRODUCTION__SET_VALID(_LSHIFTL_RREGL_IMMI_M1, _LShiftL_rRegL_immI_M1_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], NO_RCX_REGL) && STATE__VALID_CHILD(_kids[1], RCX_REGI) ) {
      unsigned int c = _kids[0]->_cost[NO_RCX_REGL]+_kids[1]->_cost[RCX_REGI];
        DFA_PRODUCTION__SET_VALID(_LSHIFTL_NO_RCX_REGL_RCX_REGI, _LShiftL_no_rcx_RegL_rcx_RegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], IMMI8) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[IMMI8];
        DFA_PRODUCTION__SET_VALID(_LSHIFTL_RREGL_IMMI8, _LShiftL_rRegL_immI8_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], IMMI1) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[IMMI1];
        DFA_PRODUCTION__SET_VALID(_LSHIFTL_RREGL_IMMI1, _LShiftL_rRegL_immI1_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], RCX_REGI) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+_kids[1]->_cost[RCX_REGI];
        DFA_PRODUCTION__SET_VALID(_LSHIFTL__LOADL_MEMORY__RCX_REGI, _LShiftL__LoadL_memory__rcx_RegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], RCX_REGI) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[RCX_REGI]+100;
        DFA_PRODUCTION__SET_VALID(RREGL, salL_rReg_CL_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, salL_rReg_CL_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, salL_rReg_CL_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, salL_rReg_CL_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGL, salL_rReg_CL_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGL, salL_rReg_CL_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGL, salL_rReg_CL_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMI8) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+_kids[1]->_cost[IMMI8];
        DFA_PRODUCTION__SET_VALID(_LSHIFTL__LOADL_MEMORY__IMMI8, _LShiftL__LoadL_memory__immI8_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], IMMI8) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[IMMI8]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, salL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, salL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, salL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, salL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, salL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, salL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, salL_rReg_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMI1) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+_kids[1]->_cost[IMMI1];
        DFA_PRODUCTION__SET_VALID(_LSHIFTL__LOADL_MEMORY__IMMI1, _LShiftL__LoadL_memory__immI1_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], IMMI1) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[IMMI1]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, salL_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, salL_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, salL_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, salL_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, salL_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, salL_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, salL_rReg_1_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _CONVI2L_RREGI_) && STATE__VALID_CHILD(_kids[1], IMMI2) ) {
      unsigned int c = _kids[0]->_cost[_CONVI2L_RREGI_]+_kids[1]->_cost[IMMI2];
        DFA_PRODUCTION__SET_VALID(_LSHIFTL__CONVI2L_RREGI__IMMI2, _LShiftL__ConvI2L_rRegI__immI2_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], IMMI2) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[IMMI2];
        DFA_PRODUCTION__SET_VALID(_LSHIFTL_RREGL_IMMI2, _LShiftL_rRegL_immI2_rule, c)
    }
}
void  State::_sub_Op_LoadB(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) ) {
      unsigned int c = _kids[0]->_cost[MEMORY];
        DFA_PRODUCTION__SET_VALID(_LOADB_MEMORY_, _LoadB_memory__rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+125;
        DFA_PRODUCTION__SET_VALID(RREGI, loadB_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, loadB_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, loadB_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, loadB_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, loadB_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, loadB_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, loadB_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, loadB_rule, c)
    }
}
void  State::_sub_Op_LoadUB(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) ) {
      unsigned int c = _kids[0]->_cost[MEMORY];
        DFA_PRODUCTION__SET_VALID(_LOADUB_MEMORY_, _LoadUB_memory__rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+125;
        DFA_PRODUCTION__SET_VALID(RREGI, loadUB_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, loadUB_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, loadUB_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, loadUB_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, loadUB_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, loadUB_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, loadUB_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, loadUB_rule, c)
    }
}
void  State::_sub_Op_LoadUS(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) ) {
      unsigned int c = _kids[0]->_cost[MEMORY];
        DFA_PRODUCTION__SET_VALID(_LOADUS_MEMORY_, _LoadUS_memory__rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+125;
        DFA_PRODUCTION__SET_VALID(RREGI, loadUS_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, loadUS_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, loadUS_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, loadUS_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, loadUS_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, loadUS_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, loadUS_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, loadUS_rule, c)
    }
}
void  State::_sub_Op_LoadD(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) ) {
      unsigned int c = _kids[0]->_cost[MEMORY];
        DFA_PRODUCTION__SET_VALID(_LOADD_MEMORY_, _LoadD_memory__rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) &&
        (
#line 5519 "src/hotspot/cpu/x86/x86_64.ad"
UseXmmLoadAndClearUpper
#line 8407 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+145;
        DFA_PRODUCTION__SET_VALID(REGD, loadD_rule, c)
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) &&
        (
#line 5506 "src/hotspot/cpu/x86/x86_64.ad"
!UseXmmLoadAndClearUpper
#line 8419 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+145;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, loadD_partial_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
}
void  State::_sub_Op_LoadF(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) ) {
      unsigned int c = _kids[0]->_cost[MEMORY];
        DFA_PRODUCTION__SET_VALID(_LOADF_MEMORY_, _LoadF_memory__rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+145;
        DFA_PRODUCTION__SET_VALID(REGF, loadF_rule, c)
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
    }
}
void  State::_sub_Op_LoadI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) ) {
      unsigned int c = _kids[0]->_cost[MEMORY];
        DFA_PRODUCTION__SET_VALID(_LOADI_MEMORY_, _LoadI_memory__rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+125;
        DFA_PRODUCTION__SET_VALID(RREGI, loadI_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, loadI_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, loadI_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, loadI_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, loadI_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, loadI_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, loadI_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, loadI_rule, c)
    }
}
void  State::_sub_Op_LoadKlass(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+125;
        DFA_PRODUCTION__SET_VALID(RREGP, loadKlass_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+100)
        DFA_PRODUCTION__SET_VALID(ANY_REGP, loadKlass_rule, c)
        DFA_PRODUCTION__SET_VALID(INDIRECT, loadKlass_rule, c)
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGP, loadKlass_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGP, loadKlass_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, loadKlass_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, loadKlass_rule, c)
        DFA_PRODUCTION__SET_VALID(RSI_REGP, loadKlass_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, loadKlass_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGP, loadKlass_rule, c)
        DFA_PRODUCTION__SET_VALID(R15_REGP, loadKlass_rule, c)
        DFA_PRODUCTION__SET_VALID(REX_REGP, loadKlass_rule, c)
    }
}
void  State::_sub_Op_LoadNKlass(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) ) {
      unsigned int c = _kids[0]->_cost[MEMORY];
        DFA_PRODUCTION__SET_VALID(_LOADNKLASS_MEMORY_, _LoadNKlass_memory__rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+125;
        DFA_PRODUCTION__SET_VALID(RREGN, loadNKlass_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGN, loadNKlass_rule, c)
    }
}
void  State::_sub_Op_LoadL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) ) {
      unsigned int c = _kids[0]->_cost[MEMORY];
        DFA_PRODUCTION__SET_VALID(_LOADL_MEMORY_, _LoadL_memory__rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+125;
        DFA_PRODUCTION__SET_VALID(RREGL, loadL_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, loadL_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, loadL_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, loadL_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGL, loadL_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGL, loadL_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGL, loadL_rule, c)
    }
}
void  State::_sub_Op_LoadPLocked(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+125;
        DFA_PRODUCTION__SET_VALID(RREGP, loadPLocked_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+100)
        DFA_PRODUCTION__SET_VALID(ANY_REGP, loadPLocked_rule, c)
        DFA_PRODUCTION__SET_VALID(INDIRECT, loadPLocked_rule, c)
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGP, loadPLocked_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGP, loadPLocked_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, loadPLocked_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, loadPLocked_rule, c)
        DFA_PRODUCTION__SET_VALID(RSI_REGP, loadPLocked_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, loadPLocked_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGP, loadPLocked_rule, c)
        DFA_PRODUCTION__SET_VALID(R15_REGP, loadPLocked_rule, c)
        DFA_PRODUCTION__SET_VALID(REX_REGP, loadPLocked_rule, c)
    }
}
void  State::_sub_Op_LoadP(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) ) {
      unsigned int c = _kids[0]->_cost[MEMORY];
        DFA_PRODUCTION__SET_VALID(_LOADP_MEMORY_, _LoadP_memory__rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+125;
        DFA_PRODUCTION__SET_VALID(RREGP, loadP_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+100)
        DFA_PRODUCTION__SET_VALID(ANY_REGP, loadP_rule, c)
        DFA_PRODUCTION__SET_VALID(INDIRECT, loadP_rule, c)
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGP, loadP_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGP, loadP_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, loadP_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, loadP_rule, c)
        DFA_PRODUCTION__SET_VALID(RSI_REGP, loadP_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, loadP_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGP, loadP_rule, c)
        DFA_PRODUCTION__SET_VALID(R15_REGP, loadP_rule, c)
        DFA_PRODUCTION__SET_VALID(REX_REGP, loadP_rule, c)
    }
}
void  State::_sub_Op_LoadN(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) ) {
      unsigned int c = _kids[0]->_cost[MEMORY];
        DFA_PRODUCTION__SET_VALID(_LOADN_MEMORY_, _LoadN_memory__rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+125;
        DFA_PRODUCTION__SET_VALID(RREGN, loadN_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGN, loadN_rule, c)
    }
}
void  State::_sub_Op_LoadRange(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+125;
        DFA_PRODUCTION__SET_VALID(RREGI, loadRange_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, loadRange_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, loadRange_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, loadRange_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, loadRange_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, loadRange_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, loadRange_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, loadRange_rule, c)
    }
}
void  State::_sub_Op_LoadS(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) ) {
      unsigned int c = _kids[0]->_cost[MEMORY];
        DFA_PRODUCTION__SET_VALID(_LOADS_MEMORY_, _LoadS_memory__rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+125;
        DFA_PRODUCTION__SET_VALID(RREGI, loadS_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, loadS_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, loadS_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, loadS_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, loadS_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, loadS_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, loadS_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, loadS_rule, c)
    }
}
void  State::_sub_Op_LoadBarrierSlowReg(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) &&
        (
#line 13029 "src/hotspot/cpu/x86/x86_64.ad"
(UseAVX == 3) && (MaxVectorSize >= 16)
#line 8604 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+100;
        DFA_PRODUCTION__SET_VALID(RREGP, loadBarrierSlowRegZmm_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+100)
        DFA_PRODUCTION__SET_VALID(ANY_REGP, loadBarrierSlowRegZmm_rule, c)
        DFA_PRODUCTION__SET_VALID(INDIRECT, loadBarrierSlowRegZmm_rule, c)
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGP, loadBarrierSlowRegZmm_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGP, loadBarrierSlowRegZmm_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, loadBarrierSlowRegZmm_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, loadBarrierSlowRegZmm_rule, c)
        DFA_PRODUCTION__SET_VALID(RSI_REGP, loadBarrierSlowRegZmm_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, loadBarrierSlowRegZmm_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGP, loadBarrierSlowRegZmm_rule, c)
        DFA_PRODUCTION__SET_VALID(R15_REGP, loadBarrierSlowRegZmm_rule, c)
        DFA_PRODUCTION__SET_VALID(REX_REGP, loadBarrierSlowRegZmm_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) &&
        (
#line 12990 "src/hotspot/cpu/x86/x86_64.ad"
(UseSSE > 0) && (UseAVX <= 2) && (MaxVectorSize >= 16)
#line 8626 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+100;
      if (STATE__NOT_YET_VALID(RREGP) || _cost[RREGP] > c) {
        DFA_PRODUCTION__SET_VALID(RREGP, loadBarrierSlowRegXmmAndYmm_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTP) || _cost[STACKSLOTP] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(ANY_REGP) || _cost[ANY_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(ANY_REGP, loadBarrierSlowRegXmmAndYmm_rule, c)
      }
      if (STATE__NOT_YET_VALID(INDIRECT) || _cost[INDIRECT] > c) {
        DFA_PRODUCTION__SET_VALID(INDIRECT, loadBarrierSlowRegXmmAndYmm_rule, c)
      }
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGP) || _cost[RAX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGP, loadBarrierSlowRegXmmAndYmm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGP) || _cost[RBX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGP, loadBarrierSlowRegXmmAndYmm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGP) || _cost[NO_RAX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, loadBarrierSlowRegXmmAndYmm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RBP_REGP) || _cost[NO_RBP_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, loadBarrierSlowRegXmmAndYmm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RSI_REGP) || _cost[RSI_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(RSI_REGP, loadBarrierSlowRegXmmAndYmm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RBX_REGP) || _cost[NO_RAX_RBX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, loadBarrierSlowRegXmmAndYmm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGP) || _cost[RDI_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGP, loadBarrierSlowRegXmmAndYmm_rule, c)
      }
      if (STATE__NOT_YET_VALID(R15_REGP) || _cost[R15_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(R15_REGP, loadBarrierSlowRegXmmAndYmm_rule, c)
      }
      if (STATE__NOT_YET_VALID(REX_REGP) || _cost[REX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(REX_REGP, loadBarrierSlowRegXmmAndYmm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) &&
        (
#line 12959 "src/hotspot/cpu/x86/x86_64.ad"
MaxVectorSize < 16
#line 8676 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+100;
      if (STATE__NOT_YET_VALID(RREGP) || _cost[RREGP] > c) {
        DFA_PRODUCTION__SET_VALID(RREGP, loadBarrierSlowRegNoVec_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTP) || _cost[STACKSLOTP] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(ANY_REGP) || _cost[ANY_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(ANY_REGP, loadBarrierSlowRegNoVec_rule, c)
      }
      if (STATE__NOT_YET_VALID(INDIRECT) || _cost[INDIRECT] > c) {
        DFA_PRODUCTION__SET_VALID(INDIRECT, loadBarrierSlowRegNoVec_rule, c)
      }
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGP) || _cost[RAX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGP, loadBarrierSlowRegNoVec_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGP) || _cost[RBX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGP, loadBarrierSlowRegNoVec_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGP) || _cost[NO_RAX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, loadBarrierSlowRegNoVec_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RBP_REGP) || _cost[NO_RBP_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, loadBarrierSlowRegNoVec_rule, c)
      }
      if (STATE__NOT_YET_VALID(RSI_REGP) || _cost[RSI_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(RSI_REGP, loadBarrierSlowRegNoVec_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RBX_REGP) || _cost[NO_RAX_RBX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, loadBarrierSlowRegNoVec_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGP) || _cost[RDI_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGP, loadBarrierSlowRegNoVec_rule, c)
      }
      if (STATE__NOT_YET_VALID(R15_REGP) || _cost[R15_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(R15_REGP, loadBarrierSlowRegNoVec_rule, c)
      }
      if (STATE__NOT_YET_VALID(REX_REGP) || _cost[REX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(REX_REGP, loadBarrierSlowRegNoVec_rule, c)
      }
    }
}
void  State::_sub_Op_LoadBarrierWeakSlowReg(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) &&
        (
#line 13138 "src/hotspot/cpu/x86/x86_64.ad"
(UseAVX == 3) && (MaxVectorSize >= 16)
#line 8728 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+100;
        DFA_PRODUCTION__SET_VALID(RREGP, loadBarrierWeakSlowRegZmm_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+100)
        DFA_PRODUCTION__SET_VALID(ANY_REGP, loadBarrierWeakSlowRegZmm_rule, c)
        DFA_PRODUCTION__SET_VALID(INDIRECT, loadBarrierWeakSlowRegZmm_rule, c)
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGP, loadBarrierWeakSlowRegZmm_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGP, loadBarrierWeakSlowRegZmm_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, loadBarrierWeakSlowRegZmm_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, loadBarrierWeakSlowRegZmm_rule, c)
        DFA_PRODUCTION__SET_VALID(RSI_REGP, loadBarrierWeakSlowRegZmm_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, loadBarrierWeakSlowRegZmm_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGP, loadBarrierWeakSlowRegZmm_rule, c)
        DFA_PRODUCTION__SET_VALID(R15_REGP, loadBarrierWeakSlowRegZmm_rule, c)
        DFA_PRODUCTION__SET_VALID(REX_REGP, loadBarrierWeakSlowRegZmm_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) &&
        (
#line 13099 "src/hotspot/cpu/x86/x86_64.ad"
(UseSSE > 0) && (UseAVX <= 2) && (MaxVectorSize >= 16)
#line 8750 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+100;
      if (STATE__NOT_YET_VALID(RREGP) || _cost[RREGP] > c) {
        DFA_PRODUCTION__SET_VALID(RREGP, loadBarrierWeakSlowRegXmmAndYmm_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTP) || _cost[STACKSLOTP] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(ANY_REGP) || _cost[ANY_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(ANY_REGP, loadBarrierWeakSlowRegXmmAndYmm_rule, c)
      }
      if (STATE__NOT_YET_VALID(INDIRECT) || _cost[INDIRECT] > c) {
        DFA_PRODUCTION__SET_VALID(INDIRECT, loadBarrierWeakSlowRegXmmAndYmm_rule, c)
      }
      if (STATE__NOT_YET_VALID(MEMORY) || _cost[MEMORY] > c) {
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGP) || _cost[RAX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGP, loadBarrierWeakSlowRegXmmAndYmm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGP) || _cost[RBX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGP, loadBarrierWeakSlowRegXmmAndYmm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGP) || _cost[NO_RAX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, loadBarrierWeakSlowRegXmmAndYmm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RBP_REGP) || _cost[NO_RBP_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, loadBarrierWeakSlowRegXmmAndYmm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RSI_REGP) || _cost[RSI_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(RSI_REGP, loadBarrierWeakSlowRegXmmAndYmm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RBX_REGP) || _cost[NO_RAX_RBX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, loadBarrierWeakSlowRegXmmAndYmm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGP) || _cost[RDI_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGP, loadBarrierWeakSlowRegXmmAndYmm_rule, c)
      }
      if (STATE__NOT_YET_VALID(R15_REGP) || _cost[R15_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(R15_REGP, loadBarrierWeakSlowRegXmmAndYmm_rule, c)
      }
      if (STATE__NOT_YET_VALID(REX_REGP) || _cost[REX_REGP] > c) {
        DFA_PRODUCTION__SET_VALID(REX_REGP, loadBarrierWeakSlowRegXmmAndYmm_rule, c)
      }
    }
}
void  State::_sub_Op_MaxD(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], LEGREGD) && STATE__VALID_CHILD(_kids[1], LEGREGD) &&
        (
#line 5637 "src/hotspot/cpu/x86/x86_64.ad"
UseAVX > 0 && n->is_reduction()
#line 8802 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[LEGREGD]+_kids[1]->_cost[LEGREGD]+100;
        DFA_PRODUCTION__SET_VALID(LEGREGD, maxD_reduction_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(REGD, MoveLEG2D_rule, c+100)
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+100+95)
    }
    if( STATE__VALID_CHILD(_kids[0], LEGREGD) && STATE__VALID_CHILD(_kids[1], LEGREGD) &&
        (
#line 5615 "src/hotspot/cpu/x86/x86_64.ad"
UseAVX > 0 && !n->is_reduction()
#line 8814 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[LEGREGD]+_kids[1]->_cost[LEGREGD]+100;
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, maxD_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(REGD, MoveLEG2D_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+100+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+100+95)
      }
    }
}
void  State::_sub_Op_MaxF(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], LEGREGF) && STATE__VALID_CHILD(_kids[1], LEGREGF) &&
        (
#line 5601 "src/hotspot/cpu/x86/x86_64.ad"
UseAVX > 0 && n->is_reduction()
#line 8836 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[LEGREGF]+_kids[1]->_cost[LEGREGF]+100;
        DFA_PRODUCTION__SET_VALID(LEGREGF, maxF_reduction_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(REGF, MoveLEG2F_rule, c+100)
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+100+95)
    }
    if( STATE__VALID_CHILD(_kids[0], LEGREGF) && STATE__VALID_CHILD(_kids[1], LEGREGF) &&
        (
#line 5579 "src/hotspot/cpu/x86/x86_64.ad"
UseAVX > 0 && !n->is_reduction()
#line 8848 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[LEGREGF]+_kids[1]->_cost[LEGREGF]+100;
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, maxF_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(REGF, MoveLEG2F_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+100+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+100+95)
      }
    }
}
void  State::_sub_Op_MaxI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[RREGI]+200;
        DFA_PRODUCTION__SET_VALID(RREGI, maxI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, maxI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, maxI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, maxI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, maxI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, maxI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, maxI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, maxI_rReg_rule, c)
    }
}
void  State::_sub_Op_MemBarAcquire(const Node *n){
    {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, membar_acquire_rule, c)
    }
}
void  State::_sub_Op_LoadFence(const Node *n){
    {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, membar_acquire_0_rule, c)
    }
}
void  State::_sub_Op_SetVectMaskI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGI) &&
        (
#line 2135 "src/hotspot/cpu/x86/x86.ad"
Matcher::has_predicated_vectors()
#line 8896 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, setMask_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, setMask_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, setMask_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, setMask_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, setMask_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, setMask_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, setMask_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, setMask_rule, c)
    }
}
void  State::_sub_Op_MemBarAcquireLock(const Node *n){
    {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, membar_acquire_lock_rule, c)
    }
}
void  State::_sub_Op_MemBarRelease(const Node *n){
    {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, membar_release_rule, c)
    }
}
void  State::_sub_Op_StoreFence(const Node *n){
    {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, membar_release_0_rule, c)
    }
}
void  State::_sub_Op_MemBarReleaseLock(const Node *n){
    {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, membar_release_lock_rule, c)
    }
}
void  State::_sub_Op_MemBarVolatile(const Node *n){
    if(         (
#line 6932 "src/hotspot/cpu/x86/x86_64.ad"
Matcher::post_store_load_barrier(n)
#line 8938 "dfa_x86.cpp"
) ) {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, unnecessary_membar_volatile_rule, c)
    }
    {
      unsigned int c = 400;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, membar_volatile_rule, c)
      }
    }
}
void  State::_sub_Op_MemBarStoreStore(const Node *n){
    {
      unsigned int c = 0;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, membar_storestore_rule, c)
    }
}
void  State::_sub_Op_MinD(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], LEGREGD) && STATE__VALID_CHILD(_kids[1], LEGREGD) &&
        (
#line 5709 "src/hotspot/cpu/x86/x86_64.ad"
UseAVX > 0 && n->is_reduction()
#line 8961 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[LEGREGD]+_kids[1]->_cost[LEGREGD]+100;
        DFA_PRODUCTION__SET_VALID(LEGREGD, minD_reduction_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(REGD, MoveLEG2D_rule, c+100)
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+100+95)
    }
    if( STATE__VALID_CHILD(_kids[0], LEGREGD) && STATE__VALID_CHILD(_kids[1], LEGREGD) &&
        (
#line 5687 "src/hotspot/cpu/x86/x86_64.ad"
UseAVX > 0 && !n->is_reduction()
#line 8973 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[LEGREGD]+_kids[1]->_cost[LEGREGD]+100;
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, minD_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(REGD, MoveLEG2D_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+100+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+100+95)
      }
    }
}
void  State::_sub_Op_MinF(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], LEGREGF) && STATE__VALID_CHILD(_kids[1], LEGREGF) &&
        (
#line 5673 "src/hotspot/cpu/x86/x86_64.ad"
UseAVX > 0 && n->is_reduction()
#line 8995 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[LEGREGF]+_kids[1]->_cost[LEGREGF]+100;
        DFA_PRODUCTION__SET_VALID(LEGREGF, minF_reduction_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(REGF, MoveLEG2F_rule, c+100)
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+100+95)
    }
    if( STATE__VALID_CHILD(_kids[0], LEGREGF) && STATE__VALID_CHILD(_kids[1], LEGREGF) &&
        (
#line 5651 "src/hotspot/cpu/x86/x86_64.ad"
UseAVX > 0 && !n->is_reduction()
#line 9007 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[LEGREGF]+_kids[1]->_cost[LEGREGF]+100;
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, minF_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(REGF, MoveLEG2F_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+100+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+100+95)
      }
    }
}
void  State::_sub_Op_MinI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[RREGI]+200;
        DFA_PRODUCTION__SET_VALID(RREGI, minI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, minI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, minI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, minI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, minI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, minI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, minI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, minI_rReg_rule, c)
    }
}
void  State::_sub_Op_ModI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RAX_REGI) && STATE__VALID_CHILD(_kids[1], NO_RAX_RDX_REGI) ) {
      unsigned int c = _kids[0]->_cost[RAX_REGI]+_kids[1]->_cost[NO_RAX_RDX_REGI]+300;
        DFA_PRODUCTION__SET_VALID(RDX_REGI, modI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RREGI, modI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, modI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, modI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, modI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, modI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, modI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, modI_rReg_rule, c)
    }
}
void  State::_sub_Op_ModL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RAX_REGL) && STATE__VALID_CHILD(_kids[1], NO_RAX_RDX_REGL) ) {
      unsigned int c = _kids[0]->_cost[RAX_REGL]+_kids[1]->_cost[NO_RAX_RDX_REGL]+300;
        DFA_PRODUCTION__SET_VALID(RDX_REGL, modL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RREGL, modL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, modL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, modL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, modL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGL, modL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGL, modL_rReg_rule, c)
    }
}
void  State::_sub_Op_MoveI2F(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
        DFA_PRODUCTION__SET_VALID(REGF, MoveI2F_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, MoveI2F_reg_stack_rule, c)
      }
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c+125) {
        DFA_PRODUCTION__SET_VALID(REGF, loadSSF_rule, c+125)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+125+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+125+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+125+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+125+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], STACKSLOTI) ) {
      unsigned int c = _kids[0]->_cost[STACKSLOTI]+125;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, MoveI2F_stack_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
}
void  State::_sub_Op_MoveF2I(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], REGF) ) {
      unsigned int c = _kids[0]->_cost[REGF]+85;
        DFA_PRODUCTION__SET_VALID(RREGI, MoveF2I_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, MoveF2I_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, MoveF2I_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, MoveF2I_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, MoveF2I_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, MoveF2I_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, MoveF2I_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, MoveF2I_reg_reg_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) ) {
      unsigned int c = _kids[0]->_cost[REGF]+95;
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, MoveF2I_reg_stack_rule, c)
      }
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c+125) {
        DFA_PRODUCTION__SET_VALID(RREGI, loadSSI_rule, c+125)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c+125) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, loadSSI_rule, c+125)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c+125) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, loadSSI_rule, c+125)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c+125) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, loadSSI_rule, c+125)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c+125) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, loadSSI_rule, c+125)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c+125) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, loadSSI_rule, c+125)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c+125) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, loadSSI_rule, c+125)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c+125) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, loadSSI_rule, c+125)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], STACKSLOTF) ) {
      unsigned int c = _kids[0]->_cost[STACKSLOTF]+125;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, MoveF2I_stack_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, MoveF2I_stack_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, MoveF2I_stack_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, MoveF2I_stack_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, MoveF2I_stack_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, MoveF2I_stack_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, MoveF2I_stack_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, MoveF2I_stack_reg_rule, c)
      }
    }
}
void  State::_sub_Op_MoveL2D(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGL) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+100;
        DFA_PRODUCTION__SET_VALID(REGD, MoveL2D_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+100;
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, MoveL2D_reg_stack_rule, c)
      }
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c+125) {
        DFA_PRODUCTION__SET_VALID(REGD, loadSSD_rule, c+125)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+125+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+125+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+125+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+125+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], STACKSLOTL) &&
        (
#line 11093 "src/hotspot/cpu/x86/x86_64.ad"
UseXmmLoadAndClearUpper
#line 9205 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[STACKSLOTL]+125;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, MoveL2D_stack_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], STACKSLOTL) &&
        (
#line 11080 "src/hotspot/cpu/x86/x86_64.ad"
!UseXmmLoadAndClearUpper
#line 9225 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[STACKSLOTL]+125;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, MoveL2D_stack_reg_partial_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
}
void  State::_sub_Op_MoveD2L(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], REGD) ) {
      unsigned int c = _kids[0]->_cost[REGD]+85;
        DFA_PRODUCTION__SET_VALID(RREGL, MoveD2L_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, MoveD2L_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, MoveD2L_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, MoveD2L_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGL, MoveD2L_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGL, MoveD2L_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGL, MoveD2L_reg_reg_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) ) {
      unsigned int c = _kids[0]->_cost[REGD]+95;
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, MoveD2L_reg_stack_rule, c)
      }
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c+125) {
        DFA_PRODUCTION__SET_VALID(RREGL, loadSSL_rule, c+125)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c+125) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, loadSSL_rule, c+125)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c+125) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, loadSSL_rule, c+125)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c+125) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, loadSSL_rule, c+125)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c+125) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, loadSSL_rule, c+125)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c+125) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, loadSSL_rule, c+125)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c+125) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, loadSSL_rule, c+125)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], STACKSLOTD) ) {
      unsigned int c = _kids[0]->_cost[STACKSLOTD]+125;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, MoveD2L_stack_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, MoveD2L_stack_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, MoveD2L_stack_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, MoveD2L_stack_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, MoveD2L_stack_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, MoveD2L_stack_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, MoveD2L_stack_reg_rule, c)
      }
    }
}
void  State::_sub_Op_MulD(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], IMMD) &&
        (
#line 2562 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 9314 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[IMMD]+150;
        DFA_PRODUCTION__SET_VALID(REGD, mulD_reg_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADD_MEMORY_) && STATE__VALID_CHILD(_kids[1], REGD) &&
        (
#line 2550 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 9326 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADD_MEMORY_]+_kids[1]->_cost[REGD]+150;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, mulD_reg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], _LOADD_MEMORY_) &&
        (
#line 2550 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 9346 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[_LOADD_MEMORY_]+150;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, mulD_reg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], REGD) &&
        (
#line 2538 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 9366 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[REGD]+150;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, mulD_reg_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], IMMD) &&
        (
#line 2527 "src/hotspot/cpu/x86/x86.ad"
(UseSSE>=2) && (UseAVX == 0)
#line 9386 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[IMMD]+150;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, mulD_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADD_MEMORY_) && STATE__VALID_CHILD(_kids[1], REGD) &&
        (
#line 2515 "src/hotspot/cpu/x86/x86.ad"
(UseSSE>=2) && (UseAVX == 0)
#line 9406 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADD_MEMORY_]+_kids[1]->_cost[REGD]+150;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, mulD_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], _LOADD_MEMORY_) &&
        (
#line 2515 "src/hotspot/cpu/x86/x86.ad"
(UseSSE>=2) && (UseAVX == 0)
#line 9426 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[_LOADD_MEMORY_]+150;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, mulD_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], REGD) &&
        (
#line 2503 "src/hotspot/cpu/x86/x86.ad"
(UseSSE>=2) && (UseAVX == 0)
#line 9446 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[REGD]+150;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, mulD_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
}
void  State::_sub_Op_MulF(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], IMMF) &&
        (
#line 2491 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 9468 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[IMMF]+150;
        DFA_PRODUCTION__SET_VALID(REGF, mulF_reg_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADF_MEMORY_) && STATE__VALID_CHILD(_kids[1], REGF) &&
        (
#line 2479 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 9480 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADF_MEMORY_]+_kids[1]->_cost[REGF]+150;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, mulF_reg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], _LOADF_MEMORY_) &&
        (
#line 2479 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 9500 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[_LOADF_MEMORY_]+150;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, mulF_reg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], REGF) &&
        (
#line 2467 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 9520 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[REGF]+150;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, mulF_reg_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], IMMF) &&
        (
#line 2456 "src/hotspot/cpu/x86/x86.ad"
(UseSSE>=1) && (UseAVX == 0)
#line 9540 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[IMMF]+150;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, mulF_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADF_MEMORY_) && STATE__VALID_CHILD(_kids[1], REGF) &&
        (
#line 2444 "src/hotspot/cpu/x86/x86.ad"
(UseSSE>=1) && (UseAVX == 0)
#line 9560 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADF_MEMORY_]+_kids[1]->_cost[REGF]+150;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, mulF_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], _LOADF_MEMORY_) &&
        (
#line 2444 "src/hotspot/cpu/x86/x86.ad"
(UseSSE>=1) && (UseAVX == 0)
#line 9580 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[_LOADF_MEMORY_]+150;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, mulF_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], REGF) &&
        (
#line 2432 "src/hotspot/cpu/x86/x86.ad"
(UseSSE>=1) && (UseAVX == 0)
#line 9600 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[REGF]+150;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, mulF_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
}
void  State::_sub_Op_MulHiL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], NO_RAX_REGL) && STATE__VALID_CHILD(_kids[1], RAX_REGL) ) {
      unsigned int c = _kids[0]->_cost[NO_RAX_REGL]+_kids[1]->_cost[RAX_REGL]+300;
        DFA_PRODUCTION__SET_VALID(RDX_REGL, mulHiL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RREGL, mulHiL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, mulHiL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, mulHiL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, mulHiL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGL, mulHiL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGL, mulHiL_rReg_rule, c)
    }
}
void  State::_sub_Op_MulI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMI) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[IMMI]+300;
        DFA_PRODUCTION__SET_VALID(RREGI, mulI_mem_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, mulI_mem_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, mulI_mem_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, mulI_mem_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, mulI_mem_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, mulI_mem_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, mulI_mem_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, mulI_mem_imm_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[RREGI]+350;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, mulI_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, mulI_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, mulI_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, mulI_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, mulI_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, mulI_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, mulI_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, mulI_mem_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], _LOADI_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[_LOADI_MEMORY_]+350;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, mulI_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, mulI_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, mulI_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, mulI_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, mulI_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, mulI_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, mulI_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, mulI_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI]+300;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, mulI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, mulI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, mulI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, mulI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, mulI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, mulI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, mulI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, mulI_rReg_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[RREGI]+300;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, mulI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, mulI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, mulI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, mulI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, mulI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, mulI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, mulI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, mulI_rReg_rule, c)
      }
    }
}
void  State::_sub_Op_MulL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMML32) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+_kids[1]->_cost[IMML32]+300;
        DFA_PRODUCTION__SET_VALID(RREGL, mulL_mem_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, mulL_mem_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, mulL_mem_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, mulL_mem_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGL, mulL_mem_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGL, mulL_mem_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGL, mulL_mem_imm_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], RREGL) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+_kids[1]->_cost[RREGL]+350;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, mulL_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, mulL_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, mulL_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, mulL_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, mulL_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, mulL_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, mulL_mem_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], _LOADL_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[_LOADL_MEMORY_]+350;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, mulL_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, mulL_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, mulL_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, mulL_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, mulL_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, mulL_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, mulL_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], IMML32) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[IMML32]+300;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, mulL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, mulL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, mulL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, mulL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, mulL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, mulL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, mulL_rReg_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], RREGL) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[RREGL]+300;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, mulL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, mulL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, mulL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, mulL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, mulL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, mulL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, mulL_rReg_rule, c)
      }
    }
}
void  State::_sub_Op_NegD(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VLREGD) &&
        (
#line 2801 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 9890 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VLREGD]+150;
        DFA_PRODUCTION__SET_VALID(VLREGD, negD_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(REGD, MoveVL2D_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+100+95)
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) &&
        (
#line 2789 "src/hotspot/cpu/x86/x86.ad"
(UseSSE>=2) && (UseAVX == 0)
#line 9902 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+150;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, negD_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
}
void  State::_sub_Op_NegF(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VLREGF) &&
        (
#line 2777 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 9924 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VLREGF]+150;
        DFA_PRODUCTION__SET_VALID(VLREGF, negF_reg_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(REGF, MoveVL2F_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+100+95)
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) &&
        (
#line 2766 "src/hotspot/cpu/x86/x86.ad"
(UseSSE>=1) && (UseAVX == 0)
#line 9936 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+150;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, negF_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
}
void  State::_sub_Op_OnSpinWait(const Node *n){
    {
      unsigned int c = 200;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, onspinwait_rule, c)
    }
}
void  State::_sub_Op_OrI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMI) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[IMMI];
        DFA_PRODUCTION__SET_VALID(_ORI__LOADI_MEMORY__IMMI, _OrI__LoadI_memory__immI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], _LOADI_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[_LOADI_MEMORY_];
        DFA_PRODUCTION__SET_VALID(_ORI_RREGI__LOADI_MEMORY_, _OrI_rRegI__LoadI_memory__rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[RREGI];
        DFA_PRODUCTION__SET_VALID(_ORI__LOADI_MEMORY__RREGI, _OrI__LoadI_memory__rRegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[RREGI]+125;
        DFA_PRODUCTION__SET_VALID(RREGI, orI_rReg_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, orI_rReg_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, orI_rReg_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, orI_rReg_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, orI_rReg_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, orI_rReg_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, orI_rReg_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, orI_rReg_mem_0_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], _LOADI_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[_LOADI_MEMORY_]+125;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, orI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, orI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, orI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, orI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, orI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, orI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, orI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, orI_rReg_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, orI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, orI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, orI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, orI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, orI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, orI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, orI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, orI_rReg_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, orI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, orI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, orI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, orI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, orI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, orI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, orI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, orI_rReg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LSHIFTI_NO_RCX_REGI__SUBI_IMMI_32_RCX_REGI) && STATE__VALID_CHILD(_kids[1], _URSHIFTI_NO_RCX_REGI_RCX_REGI) &&
        /*dst*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) && /*shift*/(_kids[0]->_kids[1]->_kids[1]->_leaf == _kids[1]->_kids[1]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_LSHIFTI_NO_RCX_REGI__SUBI_IMMI_32_RCX_REGI]+_kids[1]->_cost[_URSHIFTI_NO_RCX_REGI_RCX_REGI]+100;
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, rorI_rReg_Var_C32_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _URSHIFTI_NO_RCX_REGI_RCX_REGI) && STATE__VALID_CHILD(_kids[1], _LSHIFTI_NO_RCX_REGI__SUBI_IMMI_32_RCX_REGI) &&
        /*dst*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) && /*shift*/(_kids[0]->_kids[1]->_leaf == _kids[1]->_kids[1]->_kids[1]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_URSHIFTI_NO_RCX_REGI_RCX_REGI]+_kids[1]->_cost[_LSHIFTI_NO_RCX_REGI__SUBI_IMMI_32_RCX_REGI]+100;
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, rorI_rReg_Var_C32_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LSHIFTI_NO_RCX_REGI__SUBI_IMMI0_RCX_REGI) && STATE__VALID_CHILD(_kids[1], _URSHIFTI_NO_RCX_REGI_RCX_REGI) &&
        /*dst*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) && /*shift*/(_kids[0]->_kids[1]->_kids[1]->_leaf == _kids[1]->_kids[1]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_LSHIFTI_NO_RCX_REGI__SUBI_IMMI0_RCX_REGI]+_kids[1]->_cost[_URSHIFTI_NO_RCX_REGI_RCX_REGI]+100;
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, rorI_rReg_Var_C0_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _URSHIFTI_NO_RCX_REGI_RCX_REGI) && STATE__VALID_CHILD(_kids[1], _LSHIFTI_NO_RCX_REGI__SUBI_IMMI0_RCX_REGI) &&
        /*dst*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) && /*shift*/(_kids[0]->_kids[1]->_leaf == _kids[1]->_kids[1]->_kids[1]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_URSHIFTI_NO_RCX_REGI_RCX_REGI]+_kids[1]->_cost[_LSHIFTI_NO_RCX_REGI__SUBI_IMMI0_RCX_REGI]+100;
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, rorI_rReg_Var_C0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LSHIFTI_RREGI_IMMI_M1) && STATE__VALID_CHILD(_kids[1], _URSHIFTI_RREGI_IMMI1) &&
        /*dst*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_LSHIFTI_RREGI_IMMI_M1]+_kids[1]->_cost[_URSHIFTI_RREGI_IMMI1]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, rorI_rReg_i1_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, rorI_rReg_i1_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, rorI_rReg_i1_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, rorI_rReg_i1_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, rorI_rReg_i1_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, rorI_rReg_i1_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, rorI_rReg_i1_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, rorI_rReg_i1_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _URSHIFTI_RREGI_IMMI1) && STATE__VALID_CHILD(_kids[1], _LSHIFTI_RREGI_IMMI_M1) &&
        /*dst*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_URSHIFTI_RREGI_IMMI1]+_kids[1]->_cost[_LSHIFTI_RREGI_IMMI_M1]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, rorI_rReg_i1_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, rorI_rReg_i1_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, rorI_rReg_i1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, rorI_rReg_i1_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, rorI_rReg_i1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, rorI_rReg_i1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, rorI_rReg_i1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, rorI_rReg_i1_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _URSHIFTI_NO_RCX_REGI__SUBI_IMMI_32_RCX_REGI) && STATE__VALID_CHILD(_kids[1], _LSHIFTI_NO_RCX_REGI_RCX_REGI) &&
        /*dst*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) && /*shift*/(_kids[0]->_kids[1]->_kids[1]->_leaf == _kids[1]->_kids[1]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_URSHIFTI_NO_RCX_REGI__SUBI_IMMI_32_RCX_REGI]+_kids[1]->_cost[_LSHIFTI_NO_RCX_REGI_RCX_REGI]+100;
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, rolI_rReg_Var_C32_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LSHIFTI_NO_RCX_REGI_RCX_REGI) && STATE__VALID_CHILD(_kids[1], _URSHIFTI_NO_RCX_REGI__SUBI_IMMI_32_RCX_REGI) &&
        /*dst*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) && /*shift*/(_kids[0]->_kids[1]->_leaf == _kids[1]->_kids[1]->_kids[1]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_LSHIFTI_NO_RCX_REGI_RCX_REGI]+_kids[1]->_cost[_URSHIFTI_NO_RCX_REGI__SUBI_IMMI_32_RCX_REGI]+100;
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, rolI_rReg_Var_C32_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _URSHIFTI_NO_RCX_REGI__SUBI_IMMI0_RCX_REGI) && STATE__VALID_CHILD(_kids[1], _LSHIFTI_NO_RCX_REGI_RCX_REGI) &&
        /*dst*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) && /*shift*/(_kids[0]->_kids[1]->_kids[1]->_leaf == _kids[1]->_kids[1]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_URSHIFTI_NO_RCX_REGI__SUBI_IMMI0_RCX_REGI]+_kids[1]->_cost[_LSHIFTI_NO_RCX_REGI_RCX_REGI]+100;
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, rolI_rReg_Var_C0_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LSHIFTI_NO_RCX_REGI_RCX_REGI) && STATE__VALID_CHILD(_kids[1], _URSHIFTI_NO_RCX_REGI__SUBI_IMMI0_RCX_REGI) &&
        /*dst*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) && /*shift*/(_kids[0]->_kids[1]->_leaf == _kids[1]->_kids[1]->_kids[1]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_LSHIFTI_NO_RCX_REGI_RCX_REGI]+_kids[1]->_cost[_URSHIFTI_NO_RCX_REGI__SUBI_IMMI0_RCX_REGI]+100;
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, rolI_rReg_Var_C0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _URSHIFTI_RREGI_IMMI8) && STATE__VALID_CHILD(_kids[1], _LSHIFTI_RREGI_IMMI8) &&
        (
#line 9289 "src/hotspot/cpu/x86/x86_64.ad"
0 == ((n->in(1)->in(2)->get_int() + n->in(2)->in(2)->get_int()) & 0x1f)
#line 10196 "dfa_x86.cpp"
) && /*dst*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_URSHIFTI_RREGI_IMMI8]+_kids[1]->_cost[_LSHIFTI_RREGI_IMMI8]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, rolI_rReg_i8_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, rolI_rReg_i8_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, rolI_rReg_i8_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, rolI_rReg_i8_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, rolI_rReg_i8_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, rolI_rReg_i8_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, rolI_rReg_i8_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, rolI_rReg_i8_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LSHIFTI_RREGI_IMMI8) && STATE__VALID_CHILD(_kids[1], _URSHIFTI_RREGI_IMMI8) &&
        (
#line 9289 "src/hotspot/cpu/x86/x86_64.ad"
0 == ((n->in(1)->in(2)->get_int() + n->in(2)->in(2)->get_int()) & 0x1f)
#line 10231 "dfa_x86.cpp"
) && /*dst*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_LSHIFTI_RREGI_IMMI8]+_kids[1]->_cost[_URSHIFTI_RREGI_IMMI8]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, rolI_rReg_i8_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, rolI_rReg_i8_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, rolI_rReg_i8_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, rolI_rReg_i8_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, rolI_rReg_i8_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, rolI_rReg_i8_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, rolI_rReg_i8_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, rolI_rReg_i8_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _URSHIFTI_RREGI_IMMI_M1) && STATE__VALID_CHILD(_kids[1], _LSHIFTI_RREGI_IMMI1) &&
        /*dst*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_URSHIFTI_RREGI_IMMI_M1]+_kids[1]->_cost[_LSHIFTI_RREGI_IMMI1]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, rolI_rReg_i1_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, rolI_rReg_i1_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, rolI_rReg_i1_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, rolI_rReg_i1_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, rolI_rReg_i1_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, rolI_rReg_i1_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, rolI_rReg_i1_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, rolI_rReg_i1_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LSHIFTI_RREGI_IMMI1) && STATE__VALID_CHILD(_kids[1], _URSHIFTI_RREGI_IMMI_M1) &&
        /*dst*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_LSHIFTI_RREGI_IMMI1]+_kids[1]->_cost[_URSHIFTI_RREGI_IMMI_M1]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, rolI_rReg_i1_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, rolI_rReg_i1_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, rolI_rReg_i1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, rolI_rReg_i1_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, rolI_rReg_i1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, rolI_rReg_i1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, rolI_rReg_i1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, rolI_rReg_i1_rule, c)
      }
    }
}
void  State::_sub_Op_OrL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMML32) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+_kids[1]->_cost[IMML32];
        DFA_PRODUCTION__SET_VALID(_ORL__LOADL_MEMORY__IMML32, _OrL__LoadL_memory__immL32_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], _LOADL_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[_LOADL_MEMORY_];
        DFA_PRODUCTION__SET_VALID(_ORL_RREGL__LOADL_MEMORY_, _OrL_rRegL__LoadL_memory__rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], RREGL) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+_kids[1]->_cost[RREGL];
        DFA_PRODUCTION__SET_VALID(_ORL__LOADL_MEMORY__RREGL, _OrL__LoadL_memory__rRegL_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], RREGL) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+_kids[1]->_cost[RREGL]+125;
        DFA_PRODUCTION__SET_VALID(RREGL, orL_rReg_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, orL_rReg_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, orL_rReg_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, orL_rReg_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGL, orL_rReg_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGL, orL_rReg_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGL, orL_rReg_mem_0_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], _LOADL_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[_LOADL_MEMORY_]+125;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, orL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, orL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, orL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, orL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, orL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, orL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, orL_rReg_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], IMML32) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[IMML32]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, orL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, orL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, orL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, orL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, orL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, orL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, orL_rReg_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _CASTP2X_ANY_REGP_) && STATE__VALID_CHILD(_kids[1], RREGL) ) {
      unsigned int c = _kids[0]->_cost[_CASTP2X_ANY_REGP_]+_kids[1]->_cost[RREGL]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, orL_rReg_castP2X_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, orL_rReg_castP2X_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, orL_rReg_castP2X_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, orL_rReg_castP2X_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, orL_rReg_castP2X_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, orL_rReg_castP2X_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, orL_rReg_castP2X_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], _CASTP2X_ANY_REGP_) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[_CASTP2X_ANY_REGP_]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, orL_rReg_castP2X_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, orL_rReg_castP2X_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, orL_rReg_castP2X_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, orL_rReg_castP2X_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, orL_rReg_castP2X_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, orL_rReg_castP2X_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, orL_rReg_castP2X_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], RREGL) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[RREGL]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, orL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, orL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, orL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, orL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, orL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, orL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, orL_rReg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LSHIFTL_NO_RCX_REGL__SUBI_IMMI_64_RCX_REGI) && STATE__VALID_CHILD(_kids[1], _URSHIFTL_NO_RCX_REGL_RCX_REGI) &&
        /*dst*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) && /*shift*/(_kids[0]->_kids[1]->_kids[1]->_leaf == _kids[1]->_kids[1]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_LSHIFTL_NO_RCX_REGL__SUBI_IMMI_64_RCX_REGI]+_kids[1]->_cost[_URSHIFTL_NO_RCX_REGL_RCX_REGI]+100;
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, rorL_rReg_Var_C64_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _URSHIFTL_NO_RCX_REGL_RCX_REGI) && STATE__VALID_CHILD(_kids[1], _LSHIFTL_NO_RCX_REGL__SUBI_IMMI_64_RCX_REGI) &&
        /*dst*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) && /*shift*/(_kids[0]->_kids[1]->_leaf == _kids[1]->_kids[1]->_kids[1]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_URSHIFTL_NO_RCX_REGL_RCX_REGI]+_kids[1]->_cost[_LSHIFTL_NO_RCX_REGL__SUBI_IMMI_64_RCX_REGI]+100;
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, rorL_rReg_Var_C64_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LSHIFTL_NO_RCX_REGL__SUBI_IMMI0_RCX_REGI) && STATE__VALID_CHILD(_kids[1], _URSHIFTL_NO_RCX_REGL_RCX_REGI) &&
        /*dst*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) && /*shift*/(_kids[0]->_kids[1]->_kids[1]->_leaf == _kids[1]->_kids[1]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_LSHIFTL_NO_RCX_REGL__SUBI_IMMI0_RCX_REGI]+_kids[1]->_cost[_URSHIFTL_NO_RCX_REGL_RCX_REGI]+100;
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, rorL_rReg_Var_C0_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _URSHIFTL_NO_RCX_REGL_RCX_REGI) && STATE__VALID_CHILD(_kids[1], _LSHIFTL_NO_RCX_REGL__SUBI_IMMI0_RCX_REGI) &&
        /*dst*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) && /*shift*/(_kids[0]->_kids[1]->_leaf == _kids[1]->_kids[1]->_kids[1]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_URSHIFTL_NO_RCX_REGL_RCX_REGI]+_kids[1]->_cost[_LSHIFTL_NO_RCX_REGL__SUBI_IMMI0_RCX_REGI]+100;
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, rorL_rReg_Var_C0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LSHIFTL_RREGL_IMMI_M1) && STATE__VALID_CHILD(_kids[1], _URSHIFTL_RREGL_IMMI1) &&
        /*dst*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_LSHIFTL_RREGL_IMMI_M1]+_kids[1]->_cost[_URSHIFTL_RREGL_IMMI1]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, rorL_rReg_i1_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, rorL_rReg_i1_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, rorL_rReg_i1_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, rorL_rReg_i1_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, rorL_rReg_i1_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, rorL_rReg_i1_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, rorL_rReg_i1_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _URSHIFTL_RREGL_IMMI1) && STATE__VALID_CHILD(_kids[1], _LSHIFTL_RREGL_IMMI_M1) &&
        /*dst*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_URSHIFTL_RREGL_IMMI1]+_kids[1]->_cost[_LSHIFTL_RREGL_IMMI_M1]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, rorL_rReg_i1_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, rorL_rReg_i1_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, rorL_rReg_i1_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, rorL_rReg_i1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, rorL_rReg_i1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, rorL_rReg_i1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, rorL_rReg_i1_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _URSHIFTL_NO_RCX_REGL__SUBI_IMMI_64_RCX_REGI) && STATE__VALID_CHILD(_kids[1], _LSHIFTL_NO_RCX_REGL_RCX_REGI) &&
        /*dst*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) && /*shift*/(_kids[0]->_kids[1]->_kids[1]->_leaf == _kids[1]->_kids[1]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_URSHIFTL_NO_RCX_REGL__SUBI_IMMI_64_RCX_REGI]+_kids[1]->_cost[_LSHIFTL_NO_RCX_REGL_RCX_REGI]+100;
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, rolL_rReg_Var_C64_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LSHIFTL_NO_RCX_REGL_RCX_REGI) && STATE__VALID_CHILD(_kids[1], _URSHIFTL_NO_RCX_REGL__SUBI_IMMI_64_RCX_REGI) &&
        /*dst*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) && /*shift*/(_kids[0]->_kids[1]->_leaf == _kids[1]->_kids[1]->_kids[1]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_LSHIFTL_NO_RCX_REGL_RCX_REGI]+_kids[1]->_cost[_URSHIFTL_NO_RCX_REGL__SUBI_IMMI_64_RCX_REGI]+100;
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, rolL_rReg_Var_C64_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _URSHIFTL_NO_RCX_REGL__SUBI_IMMI0_RCX_REGI) && STATE__VALID_CHILD(_kids[1], _LSHIFTL_NO_RCX_REGL_RCX_REGI) &&
        /*dst*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) && /*shift*/(_kids[0]->_kids[1]->_kids[1]->_leaf == _kids[1]->_kids[1]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_URSHIFTL_NO_RCX_REGL__SUBI_IMMI0_RCX_REGI]+_kids[1]->_cost[_LSHIFTL_NO_RCX_REGL_RCX_REGI]+100;
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, rolL_rReg_Var_C0_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LSHIFTL_NO_RCX_REGL_RCX_REGI) && STATE__VALID_CHILD(_kids[1], _URSHIFTL_NO_RCX_REGL__SUBI_IMMI0_RCX_REGI) &&
        /*dst*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) && /*shift*/(_kids[0]->_kids[1]->_leaf == _kids[1]->_kids[1]->_kids[1]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_LSHIFTL_NO_RCX_REGL_RCX_REGI]+_kids[1]->_cost[_URSHIFTL_NO_RCX_REGL__SUBI_IMMI0_RCX_REGI]+100;
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, rolL_rReg_Var_C0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _URSHIFTL_RREGL_IMMI8) && STATE__VALID_CHILD(_kids[1], _LSHIFTL_RREGL_IMMI8) &&
        (
#line 9434 "src/hotspot/cpu/x86/x86_64.ad"
0 == ((n->in(1)->in(2)->get_int() + n->in(2)->in(2)->get_int()) & 0x3f)
#line 10600 "dfa_x86.cpp"
) && /*dst*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_URSHIFTL_RREGL_IMMI8]+_kids[1]->_cost[_LSHIFTL_RREGL_IMMI8]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, rolL_rReg_i8_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, rolL_rReg_i8_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, rolL_rReg_i8_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, rolL_rReg_i8_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, rolL_rReg_i8_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, rolL_rReg_i8_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, rolL_rReg_i8_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LSHIFTL_RREGL_IMMI8) && STATE__VALID_CHILD(_kids[1], _URSHIFTL_RREGL_IMMI8) &&
        (
#line 9434 "src/hotspot/cpu/x86/x86_64.ad"
0 == ((n->in(1)->in(2)->get_int() + n->in(2)->in(2)->get_int()) & 0x3f)
#line 10632 "dfa_x86.cpp"
) && /*dst*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_LSHIFTL_RREGL_IMMI8]+_kids[1]->_cost[_URSHIFTL_RREGL_IMMI8]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, rolL_rReg_i8_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, rolL_rReg_i8_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, rolL_rReg_i8_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, rolL_rReg_i8_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, rolL_rReg_i8_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, rolL_rReg_i8_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, rolL_rReg_i8_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _URSHIFTL_RREGL_IMMI_M1) && STATE__VALID_CHILD(_kids[1], _LSHIFTL_RREGL_IMMI1) &&
        /*dst*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_URSHIFTL_RREGL_IMMI_M1]+_kids[1]->_cost[_LSHIFTL_RREGL_IMMI1]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, rolL_rReg_i1_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, rolL_rReg_i1_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, rolL_rReg_i1_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, rolL_rReg_i1_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, rolL_rReg_i1_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, rolL_rReg_i1_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, rolL_rReg_i1_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LSHIFTL_RREGL_IMMI1) && STATE__VALID_CHILD(_kids[1], _URSHIFTL_RREGL_IMMI_M1) &&
        /*dst*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_LSHIFTL_RREGL_IMMI1]+_kids[1]->_cost[_URSHIFTL_RREGL_IMMI_M1]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, rolL_rReg_i1_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, rolL_rReg_i1_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, rolL_rReg_i1_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, rolL_rReg_i1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, rolL_rReg_i1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, rolL_rReg_i1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, rolL_rReg_i1_rule, c)
      }
    }
}
void  State::_sub_Op_OverflowAddI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RAX_REGI) && STATE__VALID_CHILD(_kids[1], IMMI) ) {
      unsigned int c = _kids[0]->_cost[RAX_REGI]+_kids[1]->_cost[IMMI]+100;
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, overflowAddI_rReg_imm_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RAX_REGI) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[RAX_REGI]+_kids[1]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREG) || _cost[RFLAGSREG] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, overflowAddI_rReg_rule, c)
      }
    }
}
void  State::_sub_Op_OverflowSubI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], IMMI0) && STATE__VALID_CHILD(_kids[1], RAX_REGI) ) {
      unsigned int c = _kids[0]->_cost[IMMI0]+_kids[1]->_cost[RAX_REGI]+100;
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, overflowNegI_rReg_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREG) || _cost[RFLAGSREG] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, overflowSubI_rReg_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREG) || _cost[RFLAGSREG] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, overflowSubI_rReg_rule, c)
      }
    }
}
void  State::_sub_Op_OverflowMulI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI]+100;
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, overflowMulI_rReg_imm_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RAX_REGI) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[RAX_REGI]+_kids[1]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREG) || _cost[RFLAGSREG] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, overflowMulI_rReg_rule, c)
      }
    }
}
void  State::_sub_Op_OverflowAddL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RAX_REGL) && STATE__VALID_CHILD(_kids[1], IMML32) ) {
      unsigned int c = _kids[0]->_cost[RAX_REGL]+_kids[1]->_cost[IMML32]+100;
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, overflowAddL_rReg_imm_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RAX_REGL) && STATE__VALID_CHILD(_kids[1], RREGL) ) {
      unsigned int c = _kids[0]->_cost[RAX_REGL]+_kids[1]->_cost[RREGL]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREG) || _cost[RFLAGSREG] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, overflowAddL_rReg_rule, c)
      }
    }
}
void  State::_sub_Op_OverflowSubL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], IMML0) && STATE__VALID_CHILD(_kids[1], RAX_REGL) ) {
      unsigned int c = _kids[0]->_cost[IMML0]+_kids[1]->_cost[RAX_REGL]+100;
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, overflowNegL_rReg_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], IMML32) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[IMML32]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREG) || _cost[RFLAGSREG] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, overflowSubL_rReg_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], RREGL) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[RREGL]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREG) || _cost[RFLAGSREG] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, overflowSubL_rReg_rule, c)
      }
    }
}
void  State::_sub_Op_OverflowMulL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], IMML32) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[IMML32]+100;
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, overflowMulL_rReg_imm_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RAX_REGL) && STATE__VALID_CHILD(_kids[1], RREGL) ) {
      unsigned int c = _kids[0]->_cost[RAX_REGL]+_kids[1]->_cost[RREGL]+100;
      if (STATE__NOT_YET_VALID(RFLAGSREG) || _cost[RFLAGSREG] > c) {
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, overflowMulL_rReg_rule, c)
      }
    }
}
void  State::_sub_Op_PartialSubtypeCheck(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RSI_REGP) && STATE__VALID_CHILD(_kids[1], RAX_REGP) ) {
      unsigned int c = _kids[0]->_cost[RSI_REGP]+_kids[1]->_cost[RAX_REGP];
        DFA_PRODUCTION__SET_VALID(_PARTIALSUBTYPECHECK_RSI_REGP_RAX_REGP, _PartialSubtypeCheck_rsi_RegP_rax_RegP_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RSI_REGP) && STATE__VALID_CHILD(_kids[1], RAX_REGP) ) {
      unsigned int c = _kids[0]->_cost[RSI_REGP]+_kids[1]->_cost[RAX_REGP]+1100;
        DFA_PRODUCTION__SET_VALID(RDI_REGP, partialSubtypeCheck_rule, c)
        DFA_PRODUCTION__SET_VALID(ANY_REGP, partialSubtypeCheck_rule, c)
        DFA_PRODUCTION__SET_VALID(INDIRECT, partialSubtypeCheck_rule, c)
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c)
        DFA_PRODUCTION__SET_VALID(RREGP, partialSubtypeCheck_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGP, partialSubtypeCheck_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGP, partialSubtypeCheck_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, partialSubtypeCheck_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, partialSubtypeCheck_rule, c)
        DFA_PRODUCTION__SET_VALID(RSI_REGP, partialSubtypeCheck_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, partialSubtypeCheck_rule, c)
        DFA_PRODUCTION__SET_VALID(R15_REGP, partialSubtypeCheck_rule, c)
        DFA_PRODUCTION__SET_VALID(REX_REGP, partialSubtypeCheck_rule, c)
    }
}
void  State::_sub_Op_PopCountI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) &&
        (
#line 6823 "src/hotspot/cpu/x86/x86_64.ad"
UsePopCountInstruction
#line 10829 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, popCountI_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, popCountI_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, popCountI_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, popCountI_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, popCountI_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, popCountI_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, popCountI_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, popCountI_mem_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) &&
        (
#line 6811 "src/hotspot/cpu/x86/x86_64.ad"
UsePopCountInstruction
#line 10846 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, popCountI_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, popCountI_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, popCountI_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, popCountI_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, popCountI_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, popCountI_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, popCountI_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, popCountI_rule, c)
      }
    }
}
void  State::_sub_Op_PopCountL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) &&
        (
#line 6849 "src/hotspot/cpu/x86/x86_64.ad"
UsePopCountInstruction
#line 10883 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, popCountL_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, popCountL_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, popCountL_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, popCountL_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, popCountL_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, popCountL_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, popCountL_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, popCountL_mem_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) &&
        (
#line 6836 "src/hotspot/cpu/x86/x86_64.ad"
UsePopCountInstruction
#line 10900 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, popCountL_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, popCountL_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, popCountL_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, popCountL_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, popCountL_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, popCountL_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, popCountL_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, popCountL_rule, c)
      }
    }
}
void  State::_sub_Op_PopCountVI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VECZ) &&
        (
#line 9826 "src/hotspot/cpu/x86/x86.ad"
VM_Version::supports_vpopcntdq() && UsePopCountInstruction && n->as_Vector()->length() == 16
#line 10937 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vpopcount16I_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) &&
        (
#line 9815 "src/hotspot/cpu/x86/x86.ad"
VM_Version::supports_vpopcntdq() && UsePopCountInstruction && n->as_Vector()->length() == 8
#line 10947 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vpopcount8I_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) &&
        (
#line 9804 "src/hotspot/cpu/x86/x86.ad"
VM_Version::supports_vpopcntdq() && UsePopCountInstruction && n->as_Vector()->length() == 4
#line 10957 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vpopcount4I_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) &&
        (
#line 9793 "src/hotspot/cpu/x86/x86.ad"
VM_Version::supports_vpopcntdq() && UsePopCountInstruction && n->as_Vector()->length() == 2
#line 10967 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+100;
        DFA_PRODUCTION__SET_VALID(VECD, vpopcount2I_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
}
void  State::_sub_Op_PrefetchAllocation(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) &&
        (
#line 6197 "src/hotspot/cpu/x86/x86_64.ad"
AllocatePrefetchInstr==2
#line 10979 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+125;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, prefetchAllocT2_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) &&
        (
#line 6185 "src/hotspot/cpu/x86/x86_64.ad"
AllocatePrefetchInstr==1
#line 10988 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+125;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, prefetchAllocT0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) &&
        (
#line 6173 "src/hotspot/cpu/x86/x86_64.ad"
AllocatePrefetchInstr==0
#line 10999 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+125;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, prefetchAllocNTA_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) &&
        (
#line 6161 "src/hotspot/cpu/x86/x86_64.ad"
AllocatePrefetchInstr==3
#line 11010 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+125;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, prefetchAlloc_rule, c)
      }
    }
}
void  State::_sub_Op_RShiftI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _LSHIFTI_RREGI_IMMI_16) && STATE__VALID_CHILD(_kids[1], IMMI_16) &&
        /*sixteen*/(_kids[0]->_kids[1]->_leaf == _kids[1]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_LSHIFTI_RREGI_IMMI_16]+_kids[1]->_cost[IMMI_16]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, i2s_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, i2s_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, i2s_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, i2s_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, i2s_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, i2s_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, i2s_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, i2s_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LSHIFTI_RREGI_IMMI_24) && STATE__VALID_CHILD(_kids[1], IMMI_24) &&
        /*twentyfour*/(_kids[0]->_kids[1]->_leaf == _kids[1]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_LSHIFTI_RREGI_IMMI_24]+_kids[1]->_cost[IMMI_24]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, i2b_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, i2b_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, i2b_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, i2b_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, i2b_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, i2b_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, i2b_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, i2b_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], RCX_REGI) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[RCX_REGI];
        DFA_PRODUCTION__SET_VALID(_RSHIFTI__LOADI_MEMORY__RCX_REGI, _RShiftI__LoadI_memory__rcx_RegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], RCX_REGI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[RCX_REGI]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, sarI_rReg_CL_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, sarI_rReg_CL_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, sarI_rReg_CL_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, sarI_rReg_CL_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, sarI_rReg_CL_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, sarI_rReg_CL_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, sarI_rReg_CL_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, sarI_rReg_CL_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMI8) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[IMMI8];
        DFA_PRODUCTION__SET_VALID(_RSHIFTI__LOADI_MEMORY__IMMI8, _RShiftI__LoadI_memory__immI8_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI8) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI8]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, sarI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, sarI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, sarI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, sarI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, sarI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, sarI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, sarI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, sarI_rReg_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMI1) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[IMMI1];
        DFA_PRODUCTION__SET_VALID(_RSHIFTI__LOADI_MEMORY__IMMI1, _RShiftI__LoadI_memory__immI1_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI1) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI1]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, sarI_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, sarI_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, sarI_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, sarI_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, sarI_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, sarI_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, sarI_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, sarI_rReg_1_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LSHIFTI__LOADI_MEMORY__IMMI_16) && STATE__VALID_CHILD(_kids[1], IMMI_16) &&
        /*sixteen*/(_kids[0]->_kids[1]->_leaf == _kids[1]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_LSHIFTI__LOADI_MEMORY__IMMI_16]+_kids[1]->_cost[IMMI_16]+125;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, loadI2S_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, loadI2S_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, loadI2S_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, loadI2S_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, loadI2S_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, loadI2S_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, loadI2S_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, loadI2S_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LSHIFTI__LOADI_MEMORY__IMMI_24) && STATE__VALID_CHILD(_kids[1], IMMI_24) &&
        /*twentyfour*/(_kids[0]->_kids[1]->_leaf == _kids[1]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_LSHIFTI__LOADI_MEMORY__IMMI_24]+_kids[1]->_cost[IMMI_24]+125;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, loadI2B_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, loadI2B_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, loadI2B_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, loadI2B_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, loadI2B_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, loadI2B_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, loadI2B_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, loadI2B_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LSHIFTI__LOADUS_MEMORY__IMMI_24) && STATE__VALID_CHILD(_kids[1], IMMI_24) &&
        /*twentyfour*/(_kids[0]->_kids[1]->_leaf == _kids[1]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_LSHIFTI__LOADUS_MEMORY__IMMI_24]+_kids[1]->_cost[IMMI_24]+125;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, loadUS2B_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, loadUS2B_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, loadUS2B_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, loadUS2B_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, loadUS2B_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, loadUS2B_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, loadUS2B_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, loadUS2B_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LSHIFTI__LOADS_MEMORY__IMMI_24) && STATE__VALID_CHILD(_kids[1], IMMI_24) &&
        /*twentyfour*/(_kids[0]->_kids[1]->_leaf == _kids[1]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_LSHIFTI__LOADS_MEMORY__IMMI_24]+_kids[1]->_cost[IMMI_24]+125;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, loadS2B_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, loadS2B_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, loadS2B_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, loadS2B_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, loadS2B_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, loadS2B_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, loadS2B_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, loadS2B_rule, c)
      }
    }
}
void  State::_sub_Op_RShiftL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], RCX_REGI) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+_kids[1]->_cost[RCX_REGI];
        DFA_PRODUCTION__SET_VALID(_RSHIFTL__LOADL_MEMORY__RCX_REGI, _RShiftL__LoadL_memory__rcx_RegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], RCX_REGI) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[RCX_REGI]+100;
        DFA_PRODUCTION__SET_VALID(RREGL, sarL_rReg_CL_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, sarL_rReg_CL_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, sarL_rReg_CL_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, sarL_rReg_CL_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGL, sarL_rReg_CL_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGL, sarL_rReg_CL_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGL, sarL_rReg_CL_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMI8) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+_kids[1]->_cost[IMMI8];
        DFA_PRODUCTION__SET_VALID(_RSHIFTL__LOADL_MEMORY__IMMI8, _RShiftL__LoadL_memory__immI8_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], IMMI8) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[IMMI8]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, sarL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, sarL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, sarL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, sarL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, sarL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, sarL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, sarL_rReg_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMI1) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+_kids[1]->_cost[IMMI1];
        DFA_PRODUCTION__SET_VALID(_RSHIFTL__LOADL_MEMORY__IMMI1, _RShiftL__LoadL_memory__immI1_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], IMMI1) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[IMMI1]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, sarL_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, sarL_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, sarL_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, sarL_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, sarL_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, sarL_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, sarL_rReg_1_rule, c)
      }
    }
}
void  State::_sub_Op_Rethrow(const Node *n){
    {
      unsigned int c = 100;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, RethrowException_rule, c)
    }
}
void  State::_sub_Op_Return(const Node *n){
    {
      unsigned int c = 100;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, Ret_rule, c)
    }
}
void  State::_sub_Op_RoundDouble(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], REGD) ) {
      unsigned int c = _kids[0]->_cost[REGD];
        DFA_PRODUCTION__SET_VALID(REGD, roundDouble_nop_rule, c)
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
    }
}
void  State::_sub_Op_RoundDoubleMode(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], IMMD) && STATE__VALID_CHILD(_kids[1], IMMU8) &&
        (
#line 2909 "src/hotspot/cpu/x86/x86.ad"
UseSSE>=4
#line 11395 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMD]+_kids[1]->_cost[IMMU8]+150;
        DFA_PRODUCTION__SET_VALID(LEGREGD, roundD_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(REGD, MoveLEG2D_rule, c+100)
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+100+95)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADD_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMU8) &&
        (
#line 2898 "src/hotspot/cpu/x86/x86.ad"
UseSSE>=4
#line 11407 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADD_MEMORY_]+_kids[1]->_cost[IMMU8]+150;
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, roundD_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(REGD, MoveLEG2D_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+100+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+100+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], LEGREGD) && STATE__VALID_CHILD(_kids[1], IMMU8) &&
        (
#line 2887 "src/hotspot/cpu/x86/x86.ad"
UseSSE>=4
#line 11427 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[LEGREGD]+_kids[1]->_cost[IMMU8]+150;
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, roundD_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(REGD, MoveLEG2D_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+100+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+100+95)
      }
    }
}
void  State::_sub_Op_RoundDoubleModeV(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMU8) &&
        (
#line 2977 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 8
#line 11449 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[IMMU8]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vround8D_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], IMMU8) &&
        (
#line 2966 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 8
#line 11459 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[IMMU8]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vround8D_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMU8) &&
        (
#line 2954 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 11473 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[IMMU8]+100;
        DFA_PRODUCTION__SET_VALID(LEGVECY, vround4D_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(VECY, MoveLeg2VecY_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], LEGVECY) && STATE__VALID_CHILD(_kids[1], LEGVECY) &&
        (
#line 2943 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 11483 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[LEGVECY]+_kids[1]->_cost[LEGVECY]+100;
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, vround4D_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(VECY, MoveLeg2VecY_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMU8) &&
        (
#line 2932 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 2
#line 11497 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[IMMU8]+100;
        DFA_PRODUCTION__SET_VALID(LEGVECX, vround2D_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(VECX, MoveLeg2VecX_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], LEGVECX) && STATE__VALID_CHILD(_kids[1], IMMU8) &&
        (
#line 2921 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 2
#line 11507 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[LEGVECX]+_kids[1]->_cost[IMMU8]+100;
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, vround2D_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(VECX, MoveLeg2VecX_rule, c+100)
      }
    }
}
void  State::_sub_Op_RoundFloat(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], REGF) ) {
      unsigned int c = _kids[0]->_cost[REGF];
        DFA_PRODUCTION__SET_VALID(REGF, roundFloat_nop_rule, c)
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
    }
}
void  State::_sub_Op_SafePoint(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], REX_REGP) &&
        (
#line 12793 "src/hotspot/cpu/x86/x86_64.ad"
SafepointMechanism::uses_thread_local_poll()
#line 11532 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REX_REGP]+125;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, safePoint_poll_tls_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGP) &&
        (
#line 12777 "src/hotspot/cpu/x86/x86_64.ad"
Assembler::is_polling_page_far() && SafepointMechanism::uses_global_page_poll()
#line 11541 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGP]+125;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, safePoint_poll_far_rule, c)
      }
    }
    if(         (
#line 12761 "src/hotspot/cpu/x86/x86_64.ad"
!Assembler::is_polling_page_far() && SafepointMechanism::uses_global_page_poll()
#line 11551 "dfa_x86.cpp"
) ) {
      unsigned int c = 125;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, safePoint_poll_rule, c)
      }
    }
}
void  State::_sub_Op_ShenandoahCompareAndExchangeP(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _BINARY_RAX_REGP_RREGP) &&
        (
#line 97 "src/hotspot/cpu/x86/gc/shenandoah/shenandoah_x86_64.ad"
VM_Version::supports_cx8()
#line 11564 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_BINARY_RAX_REGP_RREGP]+1000;
        DFA_PRODUCTION__SET_VALID(RAX_REGP, compareAndExchangeP_shenandoah_rule, c)
        DFA_PRODUCTION__SET_VALID(ANY_REGP, compareAndExchangeP_shenandoah_rule, c)
        DFA_PRODUCTION__SET_VALID(INDIRECT, compareAndExchangeP_shenandoah_rule, c)
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c)
        DFA_PRODUCTION__SET_VALID(RREGP, compareAndExchangeP_shenandoah_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RBX_REGP, compareAndExchangeP_shenandoah_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, compareAndExchangeP_shenandoah_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, compareAndExchangeP_shenandoah_rule, c)
        DFA_PRODUCTION__SET_VALID(RSI_REGP, compareAndExchangeP_shenandoah_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, compareAndExchangeP_shenandoah_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGP, compareAndExchangeP_shenandoah_rule, c)
        DFA_PRODUCTION__SET_VALID(R15_REGP, compareAndExchangeP_shenandoah_rule, c)
        DFA_PRODUCTION__SET_VALID(REX_REGP, compareAndExchangeP_shenandoah_rule, c)
    }
}
void  State::_sub_Op_ShenandoahCompareAndExchangeN(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _BINARY_RAX_REGN_RREGN) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_BINARY_RAX_REGN_RREGN]+100;
        DFA_PRODUCTION__SET_VALID(RAX_REGN, compareAndExchangeN_shenandoah_rule, c)
    }
}
void  State::_sub_Op_ShenandoahCompareAndSwapN(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _BINARY_RAX_REGN_RREGN) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_BINARY_RAX_REGN_RREGN]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, compareAndSwapN_shenandoah_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, compareAndSwapN_shenandoah_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, compareAndSwapN_shenandoah_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, compareAndSwapN_shenandoah_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, compareAndSwapN_shenandoah_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, compareAndSwapN_shenandoah_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, compareAndSwapN_shenandoah_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, compareAndSwapN_shenandoah_rule, c)
    }
}
void  State::_sub_Op_ShenandoahCompareAndSwapP(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _BINARY_RAX_REGP_RREGP) &&
        (
#line 35 "src/hotspot/cpu/x86/gc/shenandoah/shenandoah_x86_64.ad"
VM_Version::supports_cx8()
#line 11608 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_BINARY_RAX_REGP_RREGP]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, compareAndSwapP_shenandoah_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, compareAndSwapP_shenandoah_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, compareAndSwapP_shenandoah_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, compareAndSwapP_shenandoah_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, compareAndSwapP_shenandoah_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, compareAndSwapP_shenandoah_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, compareAndSwapP_shenandoah_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, compareAndSwapP_shenandoah_rule, c)
    }
}
void  State::_sub_Op_ShenandoahWeakCompareAndSwapN(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _BINARY_RAX_REGN_RREGN) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_BINARY_RAX_REGN_RREGN]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, compareAndSwapN_shenandoah_0_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, compareAndSwapN_shenandoah_0_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, compareAndSwapN_shenandoah_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, compareAndSwapN_shenandoah_0_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, compareAndSwapN_shenandoah_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, compareAndSwapN_shenandoah_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, compareAndSwapN_shenandoah_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, compareAndSwapN_shenandoah_0_rule, c)
    }
}
void  State::_sub_Op_ShenandoahWeakCompareAndSwapP(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _BINARY_RAX_REGP_RREGP) &&
        (
#line 35 "src/hotspot/cpu/x86/gc/shenandoah/shenandoah_x86_64.ad"
VM_Version::supports_cx8()
#line 11641 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_BINARY_RAX_REGP_RREGP]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, compareAndSwapP_shenandoah_0_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, compareAndSwapP_shenandoah_0_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, compareAndSwapP_shenandoah_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, compareAndSwapP_shenandoah_0_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, compareAndSwapP_shenandoah_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, compareAndSwapP_shenandoah_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, compareAndSwapP_shenandoah_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, compareAndSwapP_shenandoah_0_rule, c)
    }
}
void  State::_sub_Op_SqrtD(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], IMMD) &&
        (
#line 2874 "src/hotspot/cpu/x86/x86.ad"
UseSSE>=2
#line 11660 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMD]+150;
        DFA_PRODUCTION__SET_VALID(REGD, sqrtD_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADD_MEMORY_) &&
        (
#line 2862 "src/hotspot/cpu/x86/x86.ad"
UseSSE>=2
#line 11672 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADD_MEMORY_]+150;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, sqrtD_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) &&
        (
#line 2850 "src/hotspot/cpu/x86/x86.ad"
UseSSE>=2
#line 11692 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+150;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, sqrtD_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
}
void  State::_sub_Op_SqrtF(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], IMMF) &&
        (
#line 2838 "src/hotspot/cpu/x86/x86.ad"
UseSSE>=1
#line 11714 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMF]+150;
        DFA_PRODUCTION__SET_VALID(REGF, sqrtF_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADF_MEMORY_) &&
        (
#line 2826 "src/hotspot/cpu/x86/x86.ad"
UseSSE>=1
#line 11726 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADF_MEMORY_]+150;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, sqrtF_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) &&
        (
#line 2814 "src/hotspot/cpu/x86/x86.ad"
UseSSE>=1
#line 11746 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+150;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, sqrtF_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
}
void  State::_sub_Op_StoreB(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], IMMI8) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[IMMI8]+150;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, storeImmB_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], IMMI0) &&
        (
#line 6441 "src/hotspot/cpu/x86/x86_64.ad"
UseCompressedOops && (Universe::narrow_oop_base() == NULL) && (Universe::narrow_klass_base() == NULL)
#line 11772 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[IMMI0]+125;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, storeImmB0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[RREGI]+125;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, storeB_rule, c)
      }
    }
}
void  State::_sub_Op_StoreC(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], IMMI16) &&
        (
#line 6428 "src/hotspot/cpu/x86/x86_64.ad"
UseStoreImmI16
#line 11791 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[IMMI16]+150;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, storeImmI16_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], IMMI0) &&
        (
#line 6415 "src/hotspot/cpu/x86/x86_64.ad"
UseCompressedOops && (Universe::narrow_oop_base() == NULL) && (Universe::narrow_klass_base() == NULL)
#line 11800 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[IMMI0]+125;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, storeImmC0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[RREGI]+125;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, storeC_rule, c)
      }
    }
}
void  State::_sub_Op_StoreCM(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], IMMI0) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[IMMI0]+150;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, storeImmCM0_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], IMMI0) &&
        (
#line 6466 "src/hotspot/cpu/x86/x86_64.ad"
UseCompressedOops && (Universe::narrow_oop_base() == NULL) && (Universe::narrow_klass_base() == NULL)
#line 11823 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[IMMI0]+125;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, storeImmCM0_reg_rule, c)
      }
    }
}
void  State::_sub_Op_StorePConditional(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _BINARY_RAX_REGP_RREGP) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_BINARY_RAX_REGP_RREGP]+100;
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, storePConditional_rule, c)
    }
}
void  State::_sub_Op_StoreIConditional(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _BINARY_RAX_REGI_RREGI) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_BINARY_RAX_REGI_RREGI]+100;
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, storeIConditional_rule, c)
    }
}
void  State::_sub_Op_StoreLConditional(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _BINARY_RAX_REGL_RREGL) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_BINARY_RAX_REGL_RREGL]+100;
        DFA_PRODUCTION__SET_VALID(RFLAGSREG, storeLConditional_rule, c)
    }
}
void  State::_sub_Op_StoreD(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], IMMD0) &&
        (
#line 6554 "src/hotspot/cpu/x86/x86_64.ad"
UseCompressedOops && (Universe::narrow_oop_base() == NULL) && (Universe::narrow_klass_base() == NULL)
#line 11854 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[IMMD0]+25;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, storeD0_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], IMMD0) &&
        (
#line 6542 "src/hotspot/cpu/x86/x86_64.ad"
!UseCompressedOops || (Universe::narrow_oop_base() != NULL)
#line 11863 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[IMMD0]+50;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, storeD0_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], REGD) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[REGD]+95;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, storeD_rule, c)
      }
    }
}
void  State::_sub_Op_StoreF(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], IMMF) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[IMMF]+50;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, storeF_imm_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], IMMF0) &&
        (
#line 6504 "src/hotspot/cpu/x86/x86_64.ad"
UseCompressedOops && (Universe::narrow_oop_base() == NULL) && (Universe::narrow_klass_base() == NULL)
#line 11886 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[IMMF0]+25;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, storeF0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], REGF) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[REGF]+95;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, storeF_rule, c)
      }
    }
}
void  State::_sub_Op_StoreI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _XORI__LOADI_MEMORY__IMMI) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_XORI__LOADI_MEMORY__IMMI]+125;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, xorI_mem_imm_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _XORI_RREGI__LOADI_MEMORY_) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[1]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_XORI_RREGI__LOADI_MEMORY_]+150;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, xorI_mem_rReg_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _XORI__LOADI_MEMORY__RREGI) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_XORI__LOADI_MEMORY__RREGI]+150;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, xorI_mem_rReg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _ORI__LOADI_MEMORY__IMMI) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_ORI__LOADI_MEMORY__IMMI]+125;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, orI_mem_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _ORI_RREGI__LOADI_MEMORY_) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[1]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_ORI_RREGI__LOADI_MEMORY_]+150;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, orI_mem_rReg_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _ORI__LOADI_MEMORY__RREGI) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_ORI__LOADI_MEMORY__RREGI]+150;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, orI_mem_rReg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _ANDI__LOADI_MEMORY__IMMI) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_ANDI__LOADI_MEMORY__IMMI]+125;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, andI_mem_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _ANDI_RREGI__LOADI_MEMORY_) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[1]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_ANDI_RREGI__LOADI_MEMORY_]+150;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, andI_mem_rReg_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _ANDI__LOADI_MEMORY__RREGI) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_ANDI__LOADI_MEMORY__RREGI]+150;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, andI_mem_rReg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _URSHIFTI__LOADI_MEMORY__RCX_REGI) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_URSHIFTI__LOADI_MEMORY__RCX_REGI]+100;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, shrI_mem_CL_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _URSHIFTI__LOADI_MEMORY__IMMI8) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_URSHIFTI__LOADI_MEMORY__IMMI8]+100;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, shrI_mem_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _URSHIFTI__LOADI_MEMORY__IMMI1) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_URSHIFTI__LOADI_MEMORY__IMMI1]+100;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, shrI_mem_1_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _RSHIFTI__LOADI_MEMORY__RCX_REGI) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_RSHIFTI__LOADI_MEMORY__RCX_REGI]+100;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, sarI_mem_CL_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _RSHIFTI__LOADI_MEMORY__IMMI8) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_RSHIFTI__LOADI_MEMORY__IMMI8]+100;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, sarI_mem_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _RSHIFTI__LOADI_MEMORY__IMMI1) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_RSHIFTI__LOADI_MEMORY__IMMI1]+100;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, sarI_mem_1_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _LSHIFTI__LOADI_MEMORY__RCX_REGI) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_LSHIFTI__LOADI_MEMORY__RCX_REGI]+100;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, salI_mem_CL_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _LSHIFTI__LOADI_MEMORY__IMMI8) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_LSHIFTI__LOADI_MEMORY__IMMI8]+100;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, salI_mem_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _LSHIFTI__LOADI_MEMORY__IMMI1) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_LSHIFTI__LOADI_MEMORY__IMMI1]+100;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, salI_mem_1_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _SUBI_IMMI0__LOADI_MEMORY_) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[1]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_SUBI_IMMI0__LOADI_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, negI_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _SUBI__LOADI_MEMORY__IMMI) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_SUBI__LOADI_MEMORY__IMMI]+125;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, subI_mem_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _SUBI__LOADI_MEMORY__RREGI) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_SUBI__LOADI_MEMORY__RREGI]+150;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, subI_mem_rReg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _ADDI__LOADI_MEMORY__IMMI_M1) &&
        (
#line 7573 "src/hotspot/cpu/x86/x86_64.ad"
UseIncDec
#line 12050 "dfa_x86.cpp"
) && /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_ADDI__LOADI_MEMORY__IMMI_M1]+125;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, decI_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _ADDI__LOADI_MEMORY__IMMI1) &&
        (
#line 7546 "src/hotspot/cpu/x86/x86_64.ad"
UseIncDec
#line 12061 "dfa_x86.cpp"
) && /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_ADDI__LOADI_MEMORY__IMMI1]+125;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, incI_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _ADDI__LOADI_MEMORY__IMMI) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_ADDI__LOADI_MEMORY__IMMI]+125;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, addI_mem_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _ADDI_RREGI__LOADI_MEMORY_) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[1]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_ADDI_RREGI__LOADI_MEMORY_]+150;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, addI_mem_rReg_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _ADDI__LOADI_MEMORY__RREGI) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_ADDI__LOADI_MEMORY__RREGI]+150;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, addI_mem_rReg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], IMMI) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[IMMI]+150;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, storeImmI_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], IMMI0) &&
        (
#line 6365 "src/hotspot/cpu/x86/x86_64.ad"
UseCompressedOops && (Universe::narrow_oop_base() == NULL) && (Universe::narrow_klass_base() == NULL)
#line 12099 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[IMMI0]+125;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, storeImmI0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[RREGI]+125;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, storeI_rule, c)
      }
    }
}
void  State::_sub_Op_StoreL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _XORL__LOADL_MEMORY__IMML32) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_XORL__LOADL_MEMORY__IMML32]+125;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, xorL_mem_imm_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _XORL_RREGL__LOADL_MEMORY_) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[1]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_XORL_RREGL__LOADL_MEMORY_]+150;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, xorL_mem_rReg_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _XORL__LOADL_MEMORY__RREGL) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_XORL__LOADL_MEMORY__RREGL]+150;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, xorL_mem_rReg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _ORL__LOADL_MEMORY__IMML32) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_ORL__LOADL_MEMORY__IMML32]+125;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, orL_mem_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _ORL_RREGL__LOADL_MEMORY_) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[1]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_ORL_RREGL__LOADL_MEMORY_]+150;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, orL_mem_rReg_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _ORL__LOADL_MEMORY__RREGL) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_ORL__LOADL_MEMORY__RREGL]+150;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, orL_mem_rReg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _ANDL__LOADL_MEMORY__IMML32) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_ANDL__LOADL_MEMORY__IMML32]+125;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, andL_mem_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _ANDL_RREGL__LOADL_MEMORY_) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[1]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_ANDL_RREGL__LOADL_MEMORY_]+150;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, andL_mem_rReg_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _ANDL__LOADL_MEMORY__RREGL) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_ANDL__LOADL_MEMORY__RREGL]+150;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, andL_mem_rReg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _URSHIFTL__LOADL_MEMORY__RCX_REGI) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_URSHIFTL__LOADL_MEMORY__RCX_REGI]+100;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, shrL_mem_CL_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _URSHIFTL__LOADL_MEMORY__IMMI8) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_URSHIFTL__LOADL_MEMORY__IMMI8]+100;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, shrL_mem_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _URSHIFTL__LOADL_MEMORY__IMMI1) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_URSHIFTL__LOADL_MEMORY__IMMI1]+100;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, shrL_mem_1_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _RSHIFTL__LOADL_MEMORY__RCX_REGI) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_RSHIFTL__LOADL_MEMORY__RCX_REGI]+100;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, sarL_mem_CL_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _RSHIFTL__LOADL_MEMORY__IMMI8) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_RSHIFTL__LOADL_MEMORY__IMMI8]+100;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, sarL_mem_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _RSHIFTL__LOADL_MEMORY__IMMI1) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_RSHIFTL__LOADL_MEMORY__IMMI1]+100;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, sarL_mem_1_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _LSHIFTL__LOADL_MEMORY__RCX_REGI) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_LSHIFTL__LOADL_MEMORY__RCX_REGI]+100;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, salL_mem_CL_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _LSHIFTL__LOADL_MEMORY__IMMI8) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_LSHIFTL__LOADL_MEMORY__IMMI8]+100;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, salL_mem_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _LSHIFTL__LOADL_MEMORY__IMMI1) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_LSHIFTL__LOADL_MEMORY__IMMI1]+100;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, salL_mem_1_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _SUBL_IMML0__LOADL_MEMORY_) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[1]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_SUBL_IMML0__LOADL_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, negL_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _SUBL__LOADL_MEMORY__IMML32) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_SUBL__LOADL_MEMORY__IMML32]+125;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, subL_mem_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _SUBL__LOADL_MEMORY__RREGL) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_SUBL__LOADL_MEMORY__RREGL]+150;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, subL_mem_rReg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _ADDL__LOADL_MEMORY__IMML_M1) &&
        (
#line 7695 "src/hotspot/cpu/x86/x86_64.ad"
UseIncDec
#line 12263 "dfa_x86.cpp"
) && /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_ADDL__LOADL_MEMORY__IMML_M1]+125;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, decL_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _ADDL__LOADL_MEMORY__IMML1) &&
        (
#line 7668 "src/hotspot/cpu/x86/x86_64.ad"
UseIncDec
#line 12274 "dfa_x86.cpp"
) && /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_ADDL__LOADL_MEMORY__IMML1]+125;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, incL_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _ADDL__LOADL_MEMORY__IMML32) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_ADDL__LOADL_MEMORY__IMML32]+125;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, addL_mem_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _ADDL_RREGL__LOADL_MEMORY_) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[1]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_ADDL_RREGL__LOADL_MEMORY_]+150;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, addL_mem_rReg_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], _ADDL__LOADL_MEMORY__RREGL) &&
        /*dst*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[_ADDL__LOADL_MEMORY__RREGL]+150;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, addL_mem_rReg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], IMML32) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[IMML32]+150;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, storeImmL_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], IMML0) &&
        (
#line 6390 "src/hotspot/cpu/x86/x86_64.ad"
UseCompressedOops && (Universe::narrow_oop_base() == NULL) && (Universe::narrow_klass_base() == NULL)
#line 12312 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[IMML0]+125;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, storeImmL0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], RREGL) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[RREGL]+125;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, storeL_rule, c)
      }
    }
}
void  State::_sub_Op_StoreP(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], IMMP31) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[IMMP31]+150;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, storeImmP_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], IMMP0) &&
        (
#line 6272 "src/hotspot/cpu/x86/x86_64.ad"
UseCompressedOops && (Universe::narrow_oop_base() == NULL) && (Universe::narrow_klass_base() == NULL)
#line 12335 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[IMMP0]+125;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, storeImmP0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], ANY_REGP) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[ANY_REGP]+125;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, storeP_rule, c)
      }
    }
}
void  State::_sub_Op_StoreN(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], IMMN) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[IMMN]+150;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, storeImmN_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], IMMN0) &&
        (
#line 6322 "src/hotspot/cpu/x86/x86_64.ad"
Universe::narrow_oop_base() == NULL && Universe::narrow_klass_base() == NULL
#line 12358 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[IMMN0]+125;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, storeImmN0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], RREGN) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[RREGN]+125;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, storeN_rule, c)
      }
    }
}
void  State::_sub_Op_StoreNKlass(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], IMMNKLASS) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[IMMNKLASS]+150;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, storeImmNKlass_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], RREGN) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[RREGN]+125;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, storeNKlass_rule, c)
      }
    }
}
void  State::_sub_Op_StrComp(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _BINARY_RSI_REGP_RDX_REGI) && STATE__VALID_CHILD(_kids[1], _BINARY_RDI_REGP_RCX_REGI) &&
        (
#line 11361 "src/hotspot/cpu/x86/x86_64.ad"
((StrCompNode*)n)->encoding() == StrIntrinsicNode::UL
#line 12389 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_RSI_REGP_RDX_REGI]+_kids[1]->_cost[_BINARY_RDI_REGP_RCX_REGI]+100;
        DFA_PRODUCTION__SET_VALID(RAX_REGI, string_compareUL_rule, c)
        DFA_PRODUCTION__SET_VALID(RREGI, string_compareUL_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, string_compareUL_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, string_compareUL_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, string_compareUL_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, string_compareUL_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, string_compareUL_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, string_compareUL_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _BINARY_RDI_REGP_RCX_REGI) && STATE__VALID_CHILD(_kids[1], _BINARY_RSI_REGP_RDX_REGI) &&
        (
#line 11345 "src/hotspot/cpu/x86/x86_64.ad"
((StrCompNode*)n)->encoding() == StrIntrinsicNode::LU
#line 12406 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_RDI_REGP_RCX_REGI]+_kids[1]->_cost[_BINARY_RSI_REGP_RDX_REGI]+100;
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, string_compareLU_rule, c)
      }
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, string_compareLU_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, string_compareLU_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, string_compareLU_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, string_compareLU_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, string_compareLU_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, string_compareLU_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, string_compareLU_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _BINARY_RDI_REGP_RCX_REGI) && STATE__VALID_CHILD(_kids[1], _BINARY_RSI_REGP_RDX_REGI) &&
        (
#line 11329 "src/hotspot/cpu/x86/x86_64.ad"
((StrCompNode*)n)->encoding() == StrIntrinsicNode::UU
#line 12441 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_RDI_REGP_RCX_REGI]+_kids[1]->_cost[_BINARY_RSI_REGP_RDX_REGI]+100;
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, string_compareU_rule, c)
      }
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, string_compareU_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, string_compareU_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, string_compareU_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, string_compareU_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, string_compareU_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, string_compareU_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, string_compareU_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _BINARY_RDI_REGP_RCX_REGI) && STATE__VALID_CHILD(_kids[1], _BINARY_RSI_REGP_RDX_REGI) &&
        (
#line 11313 "src/hotspot/cpu/x86/x86_64.ad"
((StrCompNode*)n)->encoding() == StrIntrinsicNode::LL
#line 12476 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_RDI_REGP_RCX_REGI]+_kids[1]->_cost[_BINARY_RSI_REGP_RDX_REGI]+100;
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, string_compareL_rule, c)
      }
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, string_compareL_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, string_compareL_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, string_compareL_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, string_compareL_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, string_compareL_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, string_compareL_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, string_compareL_rule, c)
      }
    }
}
void  State::_sub_Op_StrCompressedCopy(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RSI_REGP) && STATE__VALID_CHILD(_kids[1], _BINARY_RDI_REGP_RDX_REGI) ) {
      unsigned int c = _kids[0]->_cost[RSI_REGP]+_kids[1]->_cost[_BINARY_RDI_REGP_RDX_REGI]+100;
        DFA_PRODUCTION__SET_VALID(RAX_REGI, string_compress_rule, c)
        DFA_PRODUCTION__SET_VALID(RREGI, string_compress_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, string_compress_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, string_compress_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, string_compress_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, string_compress_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, string_compress_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, string_compress_rule, c)
    }
}
void  State::_sub_Op_StrEquals(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _BINARY_RDI_REGP_RSI_REGP) && STATE__VALID_CHILD(_kids[1], RCX_REGI) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_RDI_REGP_RSI_REGP]+_kids[1]->_cost[RCX_REGI]+100;
        DFA_PRODUCTION__SET_VALID(RAX_REGI, string_equals_rule, c)
        DFA_PRODUCTION__SET_VALID(RREGI, string_equals_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, string_equals_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, string_equals_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, string_equals_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, string_equals_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, string_equals_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, string_equals_rule, c)
    }
}
void  State::_sub_Op_StrIndexOf(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _BINARY_RDI_REGP_RDX_REGI) && STATE__VALID_CHILD(_kids[1], _BINARY_RSI_REGP_RAX_REGI) &&
        (
#line 11498 "src/hotspot/cpu/x86/x86_64.ad"
UseSSE42Intrinsics && (((StrIndexOfNode*)n)->encoding() == StrIntrinsicNode::UL)
#line 12541 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_RDI_REGP_RDX_REGI]+_kids[1]->_cost[_BINARY_RSI_REGP_RAX_REGI]+100;
        DFA_PRODUCTION__SET_VALID(RBX_REGI, string_indexofUL_rule, c)
        DFA_PRODUCTION__SET_VALID(RREGI, string_indexofUL_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, string_indexofUL_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, string_indexofUL_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, string_indexofUL_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, string_indexofUL_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, string_indexofUL_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, string_indexofUL_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _BINARY_RDI_REGP_RDX_REGI) && STATE__VALID_CHILD(_kids[1], _BINARY_RSI_REGP_RAX_REGI) &&
        (
#line 11481 "src/hotspot/cpu/x86/x86_64.ad"
UseSSE42Intrinsics && (((StrIndexOfNode*)n)->encoding() == StrIntrinsicNode::UU)
#line 12558 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_RDI_REGP_RDX_REGI]+_kids[1]->_cost[_BINARY_RSI_REGP_RAX_REGI]+100;
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, string_indexofU_rule, c)
      }
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, string_indexofU_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, string_indexofU_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, string_indexofU_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, string_indexofU_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, string_indexofU_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, string_indexofU_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, string_indexofU_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _BINARY_RDI_REGP_RDX_REGI) && STATE__VALID_CHILD(_kids[1], _BINARY_RSI_REGP_RAX_REGI) &&
        (
#line 11464 "src/hotspot/cpu/x86/x86_64.ad"
UseSSE42Intrinsics && (((StrIndexOfNode*)n)->encoding() == StrIntrinsicNode::LL)
#line 12593 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_RDI_REGP_RDX_REGI]+_kids[1]->_cost[_BINARY_RSI_REGP_RAX_REGI]+100;
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, string_indexofL_rule, c)
      }
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, string_indexofL_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, string_indexofL_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, string_indexofL_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, string_indexofL_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, string_indexofL_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, string_indexofL_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, string_indexofL_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _BINARY_RDI_REGP_RDX_REGI) && STATE__VALID_CHILD(_kids[1], _BINARY_RSI_REGP_IMMI) &&
        (
#line 11436 "src/hotspot/cpu/x86/x86_64.ad"
UseSSE42Intrinsics && (((StrIndexOfNode*)n)->encoding() == StrIntrinsicNode::UL)
#line 12628 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_RDI_REGP_RDX_REGI]+_kids[1]->_cost[_BINARY_RSI_REGP_IMMI]+100;
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, string_indexof_conUL_rule, c)
      }
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, string_indexof_conUL_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, string_indexof_conUL_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, string_indexof_conUL_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, string_indexof_conUL_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, string_indexof_conUL_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, string_indexof_conUL_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, string_indexof_conUL_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _BINARY_RDI_REGP_RDX_REGI) && STATE__VALID_CHILD(_kids[1], _BINARY_RSI_REGP_IMMI) &&
        (
#line 11407 "src/hotspot/cpu/x86/x86_64.ad"
UseSSE42Intrinsics && (((StrIndexOfNode*)n)->encoding() == StrIntrinsicNode::UU)
#line 12663 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_RDI_REGP_RDX_REGI]+_kids[1]->_cost[_BINARY_RSI_REGP_IMMI]+100;
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, string_indexof_conU_rule, c)
      }
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, string_indexof_conU_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, string_indexof_conU_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, string_indexof_conU_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, string_indexof_conU_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, string_indexof_conU_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, string_indexof_conU_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, string_indexof_conU_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _BINARY_RDI_REGP_RDX_REGI) && STATE__VALID_CHILD(_kids[1], _BINARY_RSI_REGP_IMMI) &&
        (
#line 11378 "src/hotspot/cpu/x86/x86_64.ad"
UseSSE42Intrinsics && (((StrIndexOfNode*)n)->encoding() == StrIntrinsicNode::LL)
#line 12698 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_RDI_REGP_RDX_REGI]+_kids[1]->_cost[_BINARY_RSI_REGP_IMMI]+100;
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, string_indexof_conL_rule, c)
      }
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, string_indexof_conL_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, string_indexof_conL_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, string_indexof_conL_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, string_indexof_conL_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, string_indexof_conL_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, string_indexof_conL_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, string_indexof_conL_rule, c)
      }
    }
}
void  State::_sub_Op_StrIndexOfChar(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _BINARY_RDI_REGP_RDX_REGI) && STATE__VALID_CHILD(_kids[1], RAX_REGI) &&
        (
#line 11515 "src/hotspot/cpu/x86/x86_64.ad"
UseSSE42Intrinsics
#line 12735 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_BINARY_RDI_REGP_RDX_REGI]+_kids[1]->_cost[RAX_REGI]+100;
        DFA_PRODUCTION__SET_VALID(RBX_REGI, string_indexofU_char_rule, c)
        DFA_PRODUCTION__SET_VALID(RREGI, string_indexofU_char_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, string_indexofU_char_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, string_indexofU_char_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, string_indexofU_char_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, string_indexofU_char_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, string_indexofU_char_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, string_indexofU_char_rule, c)
    }
}
void  State::_sub_Op_StrInflatedCopy(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RSI_REGP) && STATE__VALID_CHILD(_kids[1], _BINARY_RDI_REGP_RDX_REGI) ) {
      unsigned int c = _kids[0]->_cost[RSI_REGP]+_kids[1]->_cost[_BINARY_RDI_REGP_RDX_REGI]+100;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, string_inflate_rule, c)
    }
}
void  State::_sub_Op_SubD(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], IMMD) &&
        (
#line 2420 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 12760 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[IMMD]+150;
        DFA_PRODUCTION__SET_VALID(REGD, subD_reg_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], _LOADD_MEMORY_) &&
        (
#line 2408 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 12772 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[_LOADD_MEMORY_]+150;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, subD_reg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], REGD) &&
        (
#line 2396 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 12792 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[REGD]+150;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, subD_reg_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], IMMD) &&
        (
#line 2385 "src/hotspot/cpu/x86/x86.ad"
(UseSSE>=2) && (UseAVX == 0)
#line 12812 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[IMMD]+150;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, subD_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], _LOADD_MEMORY_) &&
        (
#line 2373 "src/hotspot/cpu/x86/x86.ad"
(UseSSE>=2) && (UseAVX == 0)
#line 12832 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[_LOADD_MEMORY_]+150;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, subD_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], REGD) &&
        (
#line 2361 "src/hotspot/cpu/x86/x86.ad"
(UseSSE>=2) && (UseAVX == 0)
#line 12852 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[REGD]+150;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, subD_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
}
void  State::_sub_Op_SubF(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], IMMF) &&
        (
#line 2349 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 12874 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[IMMF]+150;
        DFA_PRODUCTION__SET_VALID(REGF, subF_reg_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], _LOADF_MEMORY_) &&
        (
#line 2337 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 12886 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[_LOADF_MEMORY_]+150;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, subF_reg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], REGF) &&
        (
#line 2325 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 12906 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[REGF]+150;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, subF_reg_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], IMMF) &&
        (
#line 2314 "src/hotspot/cpu/x86/x86.ad"
(UseSSE>=1) && (UseAVX == 0)
#line 12926 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[IMMF]+150;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, subF_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], _LOADF_MEMORY_) &&
        (
#line 2302 "src/hotspot/cpu/x86/x86.ad"
(UseSSE>=1) && (UseAVX == 0)
#line 12946 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[_LOADF_MEMORY_]+150;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, subF_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], REGF) &&
        (
#line 2290 "src/hotspot/cpu/x86/x86.ad"
(UseSSE>=1) && (UseAVX == 0)
#line 12966 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[REGF]+150;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, subF_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
}
void  State::_sub_Op_SubI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[RREGI];
        DFA_PRODUCTION__SET_VALID(_SUBI_RREGI_RREGI, _SubI_rRegI_rRegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI_64) && STATE__VALID_CHILD(_kids[1], RCX_REGI) ) {
      unsigned int c = _kids[0]->_cost[IMMI_64]+_kids[1]->_cost[RCX_REGI];
        DFA_PRODUCTION__SET_VALID(_SUBI_IMMI_64_RCX_REGI, _SubI_immI_64_rcx_RegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI_32) && STATE__VALID_CHILD(_kids[1], RCX_REGI) ) {
      unsigned int c = _kids[0]->_cost[IMMI_32]+_kids[1]->_cost[RCX_REGI];
        DFA_PRODUCTION__SET_VALID(_SUBI_IMMI_32_RCX_REGI, _SubI_immI_32_rcx_RegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI0) && STATE__VALID_CHILD(_kids[1], RCX_REGI) ) {
      unsigned int c = _kids[0]->_cost[IMMI0]+_kids[1]->_cost[RCX_REGI];
        DFA_PRODUCTION__SET_VALID(_SUBI_IMMI0_RCX_REGI, _SubI_immI0_rcx_RegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI0) && STATE__VALID_CHILD(_kids[1], _LOADI_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[IMMI0]+_kids[1]->_cost[_LOADI_MEMORY_];
        DFA_PRODUCTION__SET_VALID(_SUBI_IMMI0__LOADI_MEMORY_, _SubI_immI0__LoadI_memory__rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI0) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[IMMI0]+_kids[1]->_cost[RREGI]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, negI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, negI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, negI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, negI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, negI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, negI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, negI_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, negI_rReg_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI0) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[IMMI0]+_kids[1]->_cost[RREGI];
        DFA_PRODUCTION__SET_VALID(_SUBI_IMMI0_RREGI, _SubI_immI0_rRegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMI) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[IMMI];
        DFA_PRODUCTION__SET_VALID(_SUBI__LOADI_MEMORY__IMMI, _SubI__LoadI_memory__immI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[RREGI];
        DFA_PRODUCTION__SET_VALID(_SUBI__LOADI_MEMORY__RREGI, _SubI__LoadI_memory__rRegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], _LOADI_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[_LOADI_MEMORY_]+125;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, subI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, subI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, subI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, subI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, subI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, subI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, subI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, subI_rReg_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, subI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, subI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, subI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, subI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, subI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, subI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, subI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, subI_rReg_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, subI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, subI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, subI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, subI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, subI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, subI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, subI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, subI_rReg_rule, c)
      }
    }
}
void  State::_sub_Op_SubL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], IMML0) && STATE__VALID_CHILD(_kids[1], RREGL) ) {
      unsigned int c = _kids[0]->_cost[IMML0]+_kids[1]->_cost[RREGL];
        DFA_PRODUCTION__SET_VALID(_SUBL_IMML0_RREGL, _SubL_immL0_rRegL_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], IMML0) && STATE__VALID_CHILD(_kids[1], _LOADL_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[IMML0]+_kids[1]->_cost[_LOADL_MEMORY_];
        DFA_PRODUCTION__SET_VALID(_SUBL_IMML0__LOADL_MEMORY_, _SubL_immL0__LoadL_memory__rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], IMML0) && STATE__VALID_CHILD(_kids[1], RREGL) ) {
      unsigned int c = _kids[0]->_cost[IMML0]+_kids[1]->_cost[RREGL]+100;
        DFA_PRODUCTION__SET_VALID(RREGL, negL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, negL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, negL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, negL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGL, negL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGL, negL_rReg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGL, negL_rReg_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMML32) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+_kids[1]->_cost[IMML32];
        DFA_PRODUCTION__SET_VALID(_SUBL__LOADL_MEMORY__IMML32, _SubL__LoadL_memory__immL32_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], RREGL) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+_kids[1]->_cost[RREGL];
        DFA_PRODUCTION__SET_VALID(_SUBL__LOADL_MEMORY__RREGL, _SubL__LoadL_memory__rRegL_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], _LOADL_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[_LOADL_MEMORY_]+125;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, subL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, subL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, subL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, subL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, subL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, subL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, subL_rReg_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMML32) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMML32]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, subL_rReg_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, subL_rReg_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, subL_rReg_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, subL_rReg_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, subL_rReg_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, subL_rReg_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, subL_rReg_imm_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, subL_rReg_imm_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], RREGL) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[RREGL]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, subL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, subL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, subL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, subL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, subL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, subL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, subL_rReg_rule, c)
      }
    }
}
void  State::_sub_Op_TailCall(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], NO_RBP_REGP) && STATE__VALID_CHILD(_kids[1], RBX_REGP) ) {
      unsigned int c = _kids[0]->_cost[NO_RBP_REGP]+_kids[1]->_cost[RBX_REGP]+300;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, TailCalljmpInd_rule, c)
    }
}
void  State::_sub_Op_TailJump(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], NO_RBP_REGP) && STATE__VALID_CHILD(_kids[1], RAX_REGP) ) {
      unsigned int c = _kids[0]->_cost[NO_RBP_REGP]+_kids[1]->_cost[RAX_REGP]+300;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, tailjmpInd_rule, c)
    }
}
void  State::_sub_Op_ThreadLocal(const Node *n){
    {
      unsigned int c = 100;
        DFA_PRODUCTION__SET_VALID(R15_REGP, tlsLoadP_rule, c)
        DFA_PRODUCTION__SET_VALID(ANY_REGP, tlsLoadP_rule, c)
        DFA_PRODUCTION__SET_VALID(INDIRECT, tlsLoadP_rule, c)
        DFA_PRODUCTION__SET_VALID(MEMORY, indirect_rule, c)
        DFA_PRODUCTION__SET_VALID(RREGP, tlsLoadP_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTP, storeSSP_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGP, tlsLoadP_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGP, tlsLoadP_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGP, tlsLoadP_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RBP_REGP, tlsLoadP_rule, c)
        DFA_PRODUCTION__SET_VALID(RSI_REGP, tlsLoadP_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RBX_REGP, tlsLoadP_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGP, tlsLoadP_rule, c)
        DFA_PRODUCTION__SET_VALID(REX_REGP, tlsLoadP_rule, c)
    }
}
void  State::_sub_Op_URShiftI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], NO_RCX_REGI) && STATE__VALID_CHILD(_kids[1], RCX_REGI) ) {
      unsigned int c = _kids[0]->_cost[NO_RCX_REGI]+_kids[1]->_cost[RCX_REGI];
        DFA_PRODUCTION__SET_VALID(_URSHIFTI_NO_RCX_REGI_RCX_REGI, _URShiftI_no_rcx_RegI_rcx_RegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI1) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI1];
        DFA_PRODUCTION__SET_VALID(_URSHIFTI_RREGI_IMMI1, _URShiftI_rRegI_immI1_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], NO_RCX_REGI) && STATE__VALID_CHILD(_kids[1], _SUBI_IMMI_32_RCX_REGI) ) {
      unsigned int c = _kids[0]->_cost[NO_RCX_REGI]+_kids[1]->_cost[_SUBI_IMMI_32_RCX_REGI];
        DFA_PRODUCTION__SET_VALID(_URSHIFTI_NO_RCX_REGI__SUBI_IMMI_32_RCX_REGI, _URShiftI_no_rcx_RegI__SubI_immI_32_rcx_RegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], NO_RCX_REGI) && STATE__VALID_CHILD(_kids[1], _SUBI_IMMI0_RCX_REGI) ) {
      unsigned int c = _kids[0]->_cost[NO_RCX_REGI]+_kids[1]->_cost[_SUBI_IMMI0_RCX_REGI];
        DFA_PRODUCTION__SET_VALID(_URSHIFTI_NO_RCX_REGI__SUBI_IMMI0_RCX_REGI, _URShiftI_no_rcx_RegI__SubI_immI0_rcx_RegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI8) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI8];
        DFA_PRODUCTION__SET_VALID(_URSHIFTI_RREGI_IMMI8, _URShiftI_rRegI_immI8_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI_M1) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI_M1];
        DFA_PRODUCTION__SET_VALID(_URSHIFTI_RREGI_IMMI_M1, _URShiftI_rRegI_immI_M1_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], RCX_REGI) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[RCX_REGI];
        DFA_PRODUCTION__SET_VALID(_URSHIFTI__LOADI_MEMORY__RCX_REGI, _URShiftI__LoadI_memory__rcx_RegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], RCX_REGI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[RCX_REGI]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, shrI_rReg_CL_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, shrI_rReg_CL_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, shrI_rReg_CL_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, shrI_rReg_CL_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, shrI_rReg_CL_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, shrI_rReg_CL_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, shrI_rReg_CL_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, shrI_rReg_CL_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMI8) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[IMMI8];
        DFA_PRODUCTION__SET_VALID(_URSHIFTI__LOADI_MEMORY__IMMI8, _URShiftI__LoadI_memory__immI8_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI8) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI8]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, shrI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, shrI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, shrI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, shrI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, shrI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, shrI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, shrI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, shrI_rReg_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMI1) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[IMMI1];
        DFA_PRODUCTION__SET_VALID(_URSHIFTI__LOADI_MEMORY__IMMI1, _URShiftI__LoadI_memory__immI1_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI1) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI1]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, shrI_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, shrI_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, shrI_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, shrI_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, shrI_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, shrI_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, shrI_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, shrI_rReg_1_rule, c)
      }
    }
}
void  State::_sub_Op_URShiftL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], NO_RCX_REGL) && STATE__VALID_CHILD(_kids[1], RCX_REGI) ) {
      unsigned int c = _kids[0]->_cost[NO_RCX_REGL]+_kids[1]->_cost[RCX_REGI];
        DFA_PRODUCTION__SET_VALID(_URSHIFTL_NO_RCX_REGL_RCX_REGI, _URShiftL_no_rcx_RegL_rcx_RegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], IMMI1) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[IMMI1];
        DFA_PRODUCTION__SET_VALID(_URSHIFTL_RREGL_IMMI1, _URShiftL_rRegL_immI1_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], NO_RCX_REGL) && STATE__VALID_CHILD(_kids[1], _SUBI_IMMI_64_RCX_REGI) ) {
      unsigned int c = _kids[0]->_cost[NO_RCX_REGL]+_kids[1]->_cost[_SUBI_IMMI_64_RCX_REGI];
        DFA_PRODUCTION__SET_VALID(_URSHIFTL_NO_RCX_REGL__SUBI_IMMI_64_RCX_REGI, _URShiftL_no_rcx_RegL__SubI_immI_64_rcx_RegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], NO_RCX_REGL) && STATE__VALID_CHILD(_kids[1], _SUBI_IMMI0_RCX_REGI) ) {
      unsigned int c = _kids[0]->_cost[NO_RCX_REGL]+_kids[1]->_cost[_SUBI_IMMI0_RCX_REGI];
        DFA_PRODUCTION__SET_VALID(_URSHIFTL_NO_RCX_REGL__SUBI_IMMI0_RCX_REGI, _URShiftL_no_rcx_RegL__SubI_immI0_rcx_RegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], IMMI8) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[IMMI8];
        DFA_PRODUCTION__SET_VALID(_URSHIFTL_RREGL_IMMI8, _URShiftL_rRegL_immI8_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], IMMI_M1) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[IMMI_M1];
        DFA_PRODUCTION__SET_VALID(_URSHIFTL_RREGL_IMMI_M1, _URShiftL_rRegL_immI_M1_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], RCX_REGI) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+_kids[1]->_cost[RCX_REGI];
        DFA_PRODUCTION__SET_VALID(_URSHIFTL__LOADL_MEMORY__RCX_REGI, _URShiftL__LoadL_memory__rcx_RegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], RCX_REGI) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[RCX_REGI]+100;
        DFA_PRODUCTION__SET_VALID(RREGL, shrL_rReg_CL_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, shrL_rReg_CL_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, shrL_rReg_CL_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, shrL_rReg_CL_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGL, shrL_rReg_CL_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGL, shrL_rReg_CL_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGL, shrL_rReg_CL_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMI8) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+_kids[1]->_cost[IMMI8];
        DFA_PRODUCTION__SET_VALID(_URSHIFTL__LOADL_MEMORY__IMMI8, _URShiftL__LoadL_memory__immI8_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], IMMI8) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[IMMI8]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, shrL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, shrL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, shrL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, shrL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, shrL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, shrL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, shrL_rReg_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMI1) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+_kids[1]->_cost[IMMI1];
        DFA_PRODUCTION__SET_VALID(_URSHIFTL__LOADL_MEMORY__IMMI1, _URShiftL__LoadL_memory__immI1_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], IMMI1) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[IMMI1]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, shrL_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, shrL_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, shrL_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, shrL_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, shrL_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, shrL_rReg_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, shrL_rReg_1_rule, c)
      }
    }
}
void  State::_sub_Op_XorI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMMI) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[IMMI];
        DFA_PRODUCTION__SET_VALID(_XORI__LOADI_MEMORY__IMMI, _XorI__LoadI_memory__immI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], _LOADI_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[_LOADI_MEMORY_];
        DFA_PRODUCTION__SET_VALID(_XORI_RREGI__LOADI_MEMORY_, _XorI_rRegI__LoadI_memory__rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[RREGI];
        DFA_PRODUCTION__SET_VALID(_XORI__LOADI_MEMORY__RREGI, _XorI__LoadI_memory__rRegI_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[RREGI]+125;
        DFA_PRODUCTION__SET_VALID(RREGI, xorI_rReg_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, xorI_rReg_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, xorI_rReg_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, xorI_rReg_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, xorI_rReg_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, xorI_rReg_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, xorI_rReg_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, xorI_rReg_mem_0_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], _LOADI_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[_LOADI_MEMORY_]+125;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, xorI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, xorI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, xorI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, xorI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, xorI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, xorI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, xorI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, xorI_rReg_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, xorI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, xorI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, xorI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, xorI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, xorI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, xorI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, xorI_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, xorI_rReg_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI_M1) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI_M1]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, xorI_rReg_im1_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, xorI_rReg_im1_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, xorI_rReg_im1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, xorI_rReg_im1_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, xorI_rReg_im1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, xorI_rReg_im1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, xorI_rReg_im1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, xorI_rReg_im1_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], RREGI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, xorI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, xorI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, xorI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, xorI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, xorI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, xorI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, xorI_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, xorI_rReg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], _ADDI_RREGI_IMMI_M1) &&
        (
#line 9721 "src/hotspot/cpu/x86/x86_64.ad"
UseBMI1Instructions
#line 13607 "dfa_x86.cpp"
) && /*src*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[_ADDI_RREGI_IMMI_M1]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, blsmskI_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, blsmskI_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, blsmskI_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, blsmskI_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, blsmskI_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, blsmskI_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, blsmskI_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, blsmskI_rReg_rReg_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _ADDI_RREGI_IMMI_M1) && STATE__VALID_CHILD(_kids[1], RREGI) &&
        (
#line 9721 "src/hotspot/cpu/x86/x86_64.ad"
UseBMI1Instructions
#line 13642 "dfa_x86.cpp"
) && /*src*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_ADDI_RREGI_IMMI_M1]+_kids[1]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, blsmskI_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, blsmskI_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, blsmskI_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, blsmskI_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, blsmskI_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, blsmskI_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, blsmskI_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, blsmskI_rReg_rReg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) && STATE__VALID_CHILD(_kids[1], _ADDI__LOADI_MEMORY__IMMI_M1) &&
        (
#line 9706 "src/hotspot/cpu/x86/x86_64.ad"
UseBMI1Instructions
#line 13677 "dfa_x86.cpp"
) && /*src*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+_kids[1]->_cost[_ADDI__LOADI_MEMORY__IMMI_M1]+125;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, blsmskI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, blsmskI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, blsmskI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, blsmskI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, blsmskI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, blsmskI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, blsmskI_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, blsmskI_rReg_mem_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _ADDI__LOADI_MEMORY__IMMI_M1) && STATE__VALID_CHILD(_kids[1], _LOADI_MEMORY_) &&
        (
#line 9706 "src/hotspot/cpu/x86/x86_64.ad"
UseBMI1Instructions
#line 13712 "dfa_x86.cpp"
) && /*src*/(_kids[0]->_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_ADDI__LOADI_MEMORY__IMMI_M1]+_kids[1]->_cost[_LOADI_MEMORY_]+125;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, blsmskI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, blsmskI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, blsmskI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, blsmskI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, blsmskI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, blsmskI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, blsmskI_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, blsmskI_rReg_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], IMMI_M1) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[IMMI_M1];
        DFA_PRODUCTION__SET_VALID(_XORI_RREGI_IMMI_M1, _XorI_rRegI_immI_M1_rule, c)
    }
}
void  State::_sub_Op_XorL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], IMML32) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+_kids[1]->_cost[IMML32];
        DFA_PRODUCTION__SET_VALID(_XORL__LOADL_MEMORY__IMML32, _XorL__LoadL_memory__immL32_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], _LOADL_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[_LOADL_MEMORY_];
        DFA_PRODUCTION__SET_VALID(_XORL_RREGL__LOADL_MEMORY_, _XorL_rRegL__LoadL_memory__rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], RREGL) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+_kids[1]->_cost[RREGL];
        DFA_PRODUCTION__SET_VALID(_XORL__LOADL_MEMORY__RREGL, _XorL__LoadL_memory__rRegL_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], RREGL) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+_kids[1]->_cost[RREGL]+125;
        DFA_PRODUCTION__SET_VALID(RREGL, xorL_rReg_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, xorL_rReg_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, xorL_rReg_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, xorL_rReg_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGL, xorL_rReg_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGL, xorL_rReg_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGL, xorL_rReg_mem_0_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], _LOADL_MEMORY_) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[_LOADL_MEMORY_]+125;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, xorL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, xorL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, xorL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, xorL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, xorL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, xorL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, xorL_rReg_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], IMML32) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[IMML32]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, xorL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, xorL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, xorL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, xorL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, xorL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, xorL_rReg_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, xorL_rReg_imm_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], IMML_M1) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[IMML_M1]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, xorL_rReg_im1_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, xorL_rReg_im1_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, xorL_rReg_im1_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, xorL_rReg_im1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, xorL_rReg_im1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, xorL_rReg_im1_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, xorL_rReg_im1_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], RREGL) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[RREGL]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, xorL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, xorL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, xorL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, xorL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, xorL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, xorL_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, xorL_rReg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], _ADDL_RREGL_IMML_M1) &&
        (
#line 10068 "src/hotspot/cpu/x86/x86_64.ad"
UseBMI1Instructions
#line 13884 "dfa_x86.cpp"
) && /*src*/(_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[_ADDL_RREGL_IMML_M1]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, blsmskL_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, blsmskL_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, blsmskL_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, blsmskL_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, blsmskL_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, blsmskL_rReg_rReg_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, blsmskL_rReg_rReg_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _ADDL_RREGL_IMML_M1) && STATE__VALID_CHILD(_kids[1], RREGL) &&
        (
#line 10068 "src/hotspot/cpu/x86/x86_64.ad"
UseBMI1Instructions
#line 13916 "dfa_x86.cpp"
) && /*src*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_ADDL_RREGL_IMML_M1]+_kids[1]->_cost[RREGL]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, blsmskL_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, blsmskL_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, blsmskL_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, blsmskL_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, blsmskL_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, blsmskL_rReg_rReg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, blsmskL_rReg_rReg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) && STATE__VALID_CHILD(_kids[1], _ADDL__LOADL_MEMORY__IMML_M1) &&
        (
#line 10053 "src/hotspot/cpu/x86/x86_64.ad"
UseBMI1Instructions
#line 13948 "dfa_x86.cpp"
) && /*src*/(_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+_kids[1]->_cost[_ADDL__LOADL_MEMORY__IMML_M1]+125;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, blsmskL_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, blsmskL_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, blsmskL_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, blsmskL_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, blsmskL_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, blsmskL_rReg_mem_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, blsmskL_rReg_mem_0_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _ADDL__LOADL_MEMORY__IMML_M1) && STATE__VALID_CHILD(_kids[1], _LOADL_MEMORY_) &&
        (
#line 10053 "src/hotspot/cpu/x86/x86_64.ad"
UseBMI1Instructions
#line 13980 "dfa_x86.cpp"
) && /*src*/(_kids[0]->_kids[0]->_kids[0]->_leaf == _kids[1]->_kids[0]->_leaf) ) {
      unsigned int c = _kids[0]->_cost[_ADDL__LOADL_MEMORY__IMML_M1]+_kids[1]->_cost[_LOADL_MEMORY_]+125;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, blsmskL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, blsmskL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, blsmskL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, blsmskL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, blsmskL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, blsmskL_rReg_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, blsmskL_rReg_mem_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], IMML_M1) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[IMML_M1];
        DFA_PRODUCTION__SET_VALID(_XORL_RREGL_IMML_M1, _XorL_rRegL_immL_M1_rule, c)
    }
}
void  State::_sub_Op_AddVB(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 6173 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && VM_Version::supports_avx512bw() && n->as_Vector()->length() == 64
#line 14018 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECZ]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vadd64B_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 6173 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && VM_Version::supports_avx512bw() && n->as_Vector()->length() == 64
#line 14028 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vadd64B_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 6162 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && VM_Version::supports_avx512bw() && n->as_Vector()->length() == 64
#line 14042 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECZ]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vadd64B_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 6151 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 32
#line 14056 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECY]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vadd32B_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 6151 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 32
#line 14066 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vadd32B_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 6140 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 32
#line 14080 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECY]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vadd32B_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 6129 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 16
#line 14094 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECX]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vadd16B_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 6129 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 16
#line 14104 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vadd16B_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 6118 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0  && n->as_Vector()->length() == 16
#line 14118 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vadd16B_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 6108 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length() == 16
#line 14132 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vadd16B_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 6096 "src/hotspot/cpu/x86/x86.ad"
(UseAVX > 0) && (n->as_Vector()->length() == 8) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 14147 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECD]+100;
        DFA_PRODUCTION__SET_VALID(VECD, vadd8B_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 6096 "src/hotspot/cpu/x86/x86.ad"
(UseAVX > 0) && (n->as_Vector()->length() == 8) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 14158 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vadd8B_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 6084 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 8
#line 14172 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vadd8B_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 6074 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length() == 8
#line 14186 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vadd8B_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 6062 "src/hotspot/cpu/x86/x86.ad"
(UseAVX > 0) && (n->as_Vector()->length() == 4) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 14201 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECS, vadd4B_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECS) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 6062 "src/hotspot/cpu/x86/x86.ad"
(UseAVX > 0) && (n->as_Vector()->length() == 4) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 14212 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECS]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECS) || _cost[VECS] > c) {
        DFA_PRODUCTION__SET_VALID(VECS, vadd4B_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECS) || _cost[LEGVECS] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECS) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 6050 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 14226 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECS]+_kids[1]->_cost[VECS]+100;
      if (STATE__NOT_YET_VALID(VECS) || _cost[VECS] > c) {
        DFA_PRODUCTION__SET_VALID(VECS, vadd4B_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECS) || _cost[LEGVECS] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECS) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 6040 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length() == 4
#line 14240 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECS]+_kids[1]->_cost[VECS]+100;
      if (STATE__NOT_YET_VALID(VECS) || _cost[VECS] > c) {
        DFA_PRODUCTION__SET_VALID(VECS, vadd4B_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECS) || _cost[LEGVECS] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
      }
    }
}
void  State::_sub_Op_AddVS(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 6316 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && VM_Version::supports_avx512bw() && n->as_Vector()->length() == 32
#line 14256 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECZ]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vadd32S_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 6316 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && VM_Version::supports_avx512bw() && n->as_Vector()->length() == 32
#line 14266 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vadd32S_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 6305 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && VM_Version::supports_avx512bw() && n->as_Vector()->length() == 32
#line 14280 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECZ]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vadd32S_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 6294 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 16
#line 14294 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECY]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vadd16S_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 6294 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 16
#line 14304 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vadd16S_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 6283 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 16
#line 14318 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECY]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vadd16S_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 6272 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 8
#line 14332 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECX]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vadd8S_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 6272 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 8
#line 14342 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vadd8S_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 6261 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 8
#line 14356 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vadd8S_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 6251 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length() == 8
#line 14370 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vadd8S_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 6239 "src/hotspot/cpu/x86/x86.ad"
(UseAVX == 0) && (n->as_Vector()->length() == 4) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 14385 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECD]+100;
        DFA_PRODUCTION__SET_VALID(VECD, vadd4S_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 6239 "src/hotspot/cpu/x86/x86.ad"
(UseAVX == 0) && (n->as_Vector()->length() == 4) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 14396 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vadd4S_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 6228 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 14410 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vadd4S_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 6218 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length() == 4
#line 14424 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vadd4S_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 6206 "src/hotspot/cpu/x86/x86.ad"
(UseAVX > 0) && (n->as_Vector()->length() == 2) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 14439 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECS, vadd2S_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECS) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 6206 "src/hotspot/cpu/x86/x86.ad"
(UseAVX > 0) && (n->as_Vector()->length() == 2) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 14450 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECS]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECS) || _cost[VECS] > c) {
        DFA_PRODUCTION__SET_VALID(VECS, vadd2S_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECS) || _cost[LEGVECS] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECS) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 6195 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0  && n->as_Vector()->length() == 2
#line 14464 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECS]+_kids[1]->_cost[VECS]+100;
      if (STATE__NOT_YET_VALID(VECS) || _cost[VECS] > c) {
        DFA_PRODUCTION__SET_VALID(VECS, vadd2S_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECS) || _cost[LEGVECS] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECS) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 6185 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length() == 2
#line 14478 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECS]+_kids[1]->_cost[VECS]+100;
      if (STATE__NOT_YET_VALID(VECS) || _cost[VECS] > c) {
        DFA_PRODUCTION__SET_VALID(VECS, vadd2S_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECS) || _cost[LEGVECS] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
      }
    }
}
void  State::_sub_Op_AddVI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 6426 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 16
#line 14494 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECZ]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vadd16I_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 6426 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 16
#line 14504 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vadd16I_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 6415 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 16
#line 14518 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECZ]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vadd16I_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 6404 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 8
#line 14532 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECY]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vadd8I_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 6404 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 8
#line 14542 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vadd8I_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 6393 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 8
#line 14556 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECY]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vadd8I_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 6382 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 14570 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECX]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vadd4I_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 6382 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 14580 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vadd4I_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 6371 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 14594 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vadd4I_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 6361 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length() == 4
#line 14608 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vadd4I_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 6349 "src/hotspot/cpu/x86/x86.ad"
(UseAVX > 0) && (n->as_Vector()->length() == 2) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 14623 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECD]+100;
        DFA_PRODUCTION__SET_VALID(VECD, vadd2I_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 6349 "src/hotspot/cpu/x86/x86.ad"
(UseAVX > 0) && (n->as_Vector()->length() == 2) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 14634 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vadd2I_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 6338 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 2
#line 14648 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vadd2I_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 6328 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length() == 2
#line 14662 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vadd2I_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
}
void  State::_sub_Op_AddReductionVI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], LEGVECZ) &&
        (
#line 5161 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2
#line 14678 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[LEGVECZ]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, rvadd16I_reduction_reg_evex_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, rvadd16I_reduction_reg_evex_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, rvadd16I_reduction_reg_evex_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, rvadd16I_reduction_reg_evex_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, rvadd16I_reduction_reg_evex_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, rvadd16I_reduction_reg_evex_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, rvadd16I_reduction_reg_evex_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, rvadd16I_reduction_reg_evex_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 5133 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2
#line 14695 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[VECY]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, rvadd8I_reduction_reg_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, rvadd8I_reduction_reg_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, rvadd8I_reduction_reg_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, rvadd8I_reduction_reg_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, rvadd8I_reduction_reg_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, rvadd8I_reduction_reg_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, rvadd8I_reduction_reg_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, rvadd8I_reduction_reg_evex_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 5109 "src/hotspot/cpu/x86/x86.ad"
VM_Version::supports_avxonly()
#line 14730 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[VECY]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, rvadd8I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, rvadd8I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, rvadd8I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, rvadd8I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, rvadd8I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, rvadd8I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, rvadd8I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, rvadd8I_reduction_reg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 5085 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2
#line 14765 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, rvadd4I_reduction_reg_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, rvadd4I_reduction_reg_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, rvadd4I_reduction_reg_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, rvadd4I_reduction_reg_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, rvadd4I_reduction_reg_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, rvadd4I_reduction_reg_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, rvadd4I_reduction_reg_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, rvadd4I_reduction_reg_evex_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 5065 "src/hotspot/cpu/x86/x86.ad"
VM_Version::supports_avxonly()
#line 14800 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, rvadd4I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, rvadd4I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, rvadd4I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, rvadd4I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, rvadd4I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, rvadd4I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, rvadd4I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, rvadd4I_reduction_reg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 5044 "src/hotspot/cpu/x86/x86.ad"
UseSSE > 2 && UseAVX == 0
#line 14835 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, rsadd4I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, rsadd4I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, rsadd4I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, rsadd4I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, rsadd4I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, rsadd4I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, rsadd4I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, rsadd4I_reduction_reg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 5024 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2
#line 14870 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, rvadd2I_reduction_reg_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, rvadd2I_reduction_reg_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, rvadd2I_reduction_reg_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, rvadd2I_reduction_reg_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, rvadd2I_reduction_reg_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, rvadd2I_reduction_reg_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, rvadd2I_reduction_reg_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, rvadd2I_reduction_reg_evex_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 5006 "src/hotspot/cpu/x86/x86.ad"
VM_Version::supports_avxonly()
#line 14905 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, rvadd2I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, rvadd2I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, rvadd2I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, rvadd2I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, rvadd2I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, rvadd2I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, rvadd2I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, rvadd2I_reduction_reg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 4987 "src/hotspot/cpu/x86/x86.ad"
UseSSE > 2 && UseAVX == 0
#line 14940 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, rsadd2I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, rsadd2I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, rsadd2I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, rsadd2I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, rsadd2I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, rsadd2I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, rsadd2I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, rsadd2I_reduction_reg_rule, c)
      }
    }
}
void  State::_sub_Op_AddVL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 6503 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 8
#line 14977 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECZ]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vadd8L_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 6503 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 8
#line 14987 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vadd8L_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 6492 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 8
#line 15001 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECZ]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vadd8L_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 6481 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 4
#line 15015 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECY]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vadd4L_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 6481 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 4
#line 15025 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vadd4L_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 6470 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 4
#line 15039 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECY]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vadd4L_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 6459 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 2
#line 15053 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECX]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vadd2L_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 6459 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 2
#line 15063 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vadd2L_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 6448 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 2
#line 15077 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vadd2L_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 6438 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length() == 2
#line 15091 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vadd2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
}
void  State::_sub_Op_AddReductionVL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], LEGVECZ) &&
        (
#line 5235 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2
#line 15107 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[LEGVECZ]+100;
        DFA_PRODUCTION__SET_VALID(RREGL, rvadd8L_reduction_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, rvadd8L_reduction_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, rvadd8L_reduction_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, rvadd8L_reduction_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGL, rvadd8L_reduction_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGL, rvadd8L_reduction_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGL, rvadd8L_reduction_reg_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 5212 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2
#line 15123 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[VECY]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, rvadd4L_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, rvadd4L_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, rvadd4L_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, rvadd4L_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, rvadd4L_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, rvadd4L_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, rvadd4L_reduction_reg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 5193 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2
#line 15155 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, rvadd2L_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, rvadd2L_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, rvadd2L_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, rvadd2L_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, rvadd2L_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, rvadd2L_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, rvadd2L_reduction_reg_rule, c)
      }
    }
}
void  State::_sub_Op_AddVF(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 6613 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 16
#line 15189 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECZ]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vadd16F_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 6613 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 16
#line 15199 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vadd16F_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 6602 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 16
#line 15213 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECZ]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vadd16F_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 6591 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 8
#line 15227 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECY]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vadd8F_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 6591 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 8
#line 15237 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vadd8F_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 6580 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 8
#line 15251 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECY]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vadd8F_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 6569 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 15265 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECX]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vadd4F_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 6569 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 15275 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vadd4F_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 6558 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 15289 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vadd4F_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 6548 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length() == 4
#line 15303 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vadd4F_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 6536 "src/hotspot/cpu/x86/x86.ad"
(UseAVX == 0) && (n->as_Vector()->length() == 2) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 15318 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECD]+100;
        DFA_PRODUCTION__SET_VALID(VECD, vadd2F_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 6536 "src/hotspot/cpu/x86/x86.ad"
(UseAVX == 0) && (n->as_Vector()->length() == 2) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 15329 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vadd2F_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 6525 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 2
#line 15343 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vadd2F_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 6515 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length() == 2
#line 15357 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vadd2F_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
}
void  State::_sub_Op_AddReductionVF(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], LEGVECZ) &&
        (
#line 5378 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2
#line 15373 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[LEGVECZ]+100;
        DFA_PRODUCTION__SET_VALID(REGF, radd16F_reduction_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 5339 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 15385 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[VECY]+100;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, radd8F_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 5316 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 15405 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, rvadd4F_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 5293 "src/hotspot/cpu/x86/x86.ad"
UseSSE >= 1 && UseAVX == 0
#line 15425 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, rsadd4F_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 5278 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 15445 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, rvadd2F_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 5263 "src/hotspot/cpu/x86/x86.ad"
UseSSE >= 1 && UseAVX == 0
#line 15465 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, rsadd2F_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
}
void  State::_sub_Op_AddVD(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 6690 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 8
#line 15487 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECZ]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vadd8D_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 6690 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 8
#line 15497 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vadd8D_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 6679 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 8
#line 15511 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECZ]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vadd8D_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 6668 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 15525 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECY]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vadd4D_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 6668 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 15535 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vadd4D_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 6657 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 15549 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECY]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vadd4D_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 6646 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 2
#line 15563 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECX]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vadd2D_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 6646 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 2
#line 15573 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vadd2D_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 6635 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 2
#line 15587 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vadd2D_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 6625 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length() == 2
#line 15601 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vadd2D_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
}
void  State::_sub_Op_AddReductionVD(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], LEGVECZ) &&
        (
#line 5502 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2
#line 15617 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[LEGVECZ]+100;
        DFA_PRODUCTION__SET_VALID(REGD, rvadd8D_reduction_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 5479 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 15629 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[VECY]+100;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, rvadd4D_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 5464 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 15649 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, rvadd2D_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 5449 "src/hotspot/cpu/x86/x86.ad"
UseSSE >= 1 && UseAVX == 0
#line 15669 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, rsadd2D_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
}
void  State::_sub_Op_SubVB(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 6835 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && VM_Version::supports_avx512bw() && n->as_Vector()->length() == 64
#line 15691 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vsub64B_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 6824 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && VM_Version::supports_avx512bw() && n->as_Vector()->length() == 64
#line 15701 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECZ]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vsub64B_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 6813 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 32
#line 15715 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vsub32B_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 6802 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 32
#line 15725 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECY]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vsub32B_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 6791 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 16
#line 15739 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vsub16B_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 6780 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 16
#line 15749 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vsub16B_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 6770 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length() == 16
#line 15763 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vsub16B_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 6758 "src/hotspot/cpu/x86/x86.ad"
(UseAVX > 0) && (n->as_Vector()->length() == 8) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 15778 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECD, vsub8B_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 6747 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 8
#line 15788 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vsub8B_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 6737 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length() == 8
#line 15802 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vsub8B_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECS) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 6725 "src/hotspot/cpu/x86/x86.ad"
(UseAVX == 0) && (n->as_Vector()->length() == 4) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 15817 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECS]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECS, vsub4B_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECS) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 6714 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 15827 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECS]+_kids[1]->_cost[VECS]+100;
      if (STATE__NOT_YET_VALID(VECS) || _cost[VECS] > c) {
        DFA_PRODUCTION__SET_VALID(VECS, vsub4B_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECS) || _cost[LEGVECS] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECS) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 6704 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length() == 4
#line 15841 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECS]+_kids[1]->_cost[VECS]+100;
      if (STATE__NOT_YET_VALID(VECS) || _cost[VECS] > c) {
        DFA_PRODUCTION__SET_VALID(VECS, vsub4B_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECS) || _cost[LEGVECS] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
      }
    }
}
void  State::_sub_Op_SubVS(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 6978 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && VM_Version::supports_avx512bw() && n->as_Vector()->length() == 32
#line 15857 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vsub32S_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 6967 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && VM_Version::supports_avx512bw() && n->as_Vector()->length() == 32
#line 15867 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECZ]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vsub32S_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 6956 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 16
#line 15881 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vsub16S_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 6945 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 16
#line 15891 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECY]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vsub16S_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 6934 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 8
#line 15905 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vsub8S_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 6923 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 8
#line 15915 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vsub8S_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 6913 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length() == 8
#line 15929 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vsub8S_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 6901 "src/hotspot/cpu/x86/x86.ad"
(UseAVX > 0) && (n->as_Vector()->length() == 4) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 15944 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECD, vsub4S_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 6890 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 15954 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vsub4S_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 6880 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length() == 4
#line 15968 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vsub4S_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECS) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 6868 "src/hotspot/cpu/x86/x86.ad"
(UseAVX == 0) && (n->as_Vector()->length() == 2) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 15983 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECS]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECS, vsub2S_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECS) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 6857 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 2
#line 15993 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECS]+_kids[1]->_cost[VECS]+100;
      if (STATE__NOT_YET_VALID(VECS) || _cost[VECS] > c) {
        DFA_PRODUCTION__SET_VALID(VECS, vsub2S_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECS) || _cost[LEGVECS] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECS) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 6847 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length() == 2
#line 16007 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECS]+_kids[1]->_cost[VECS]+100;
      if (STATE__NOT_YET_VALID(VECS) || _cost[VECS] > c) {
        DFA_PRODUCTION__SET_VALID(VECS, vsub2S_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECS) || _cost[LEGVECS] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
      }
    }
}
void  State::_sub_Op_SubVI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 7088 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 16
#line 16023 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vsub16I_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 7077 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 16
#line 16033 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECZ]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vsub16I_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 7066 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 8
#line 16047 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vsub8I_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 7055 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 8
#line 16057 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECY]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vsub8I_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 7044 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 16071 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vsub4I_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 7033 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 16081 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vsub4I_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 7023 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length() == 4
#line 16095 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vsub4I_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 7011 "src/hotspot/cpu/x86/x86.ad"
(UseAVX > 0) && (n->as_Vector()->length() == 2) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 16110 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECD, vsub2I_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 7000 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 2
#line 16120 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vsub2I_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 6990 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length() == 2
#line 16134 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vsub2I_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
}
void  State::_sub_Op_SubVL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 7165 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 8
#line 16150 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vsub8L_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 7154 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 8
#line 16160 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECZ]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vsub8L_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 7143 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 4
#line 16174 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vsub4L_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 7132 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 4
#line 16184 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECY]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vsub4L_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 7121 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 2
#line 16198 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vsub2L_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 7110 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 2
#line 16208 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vsub2L_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 7100 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length() == 2
#line 16222 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vsub2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
}
void  State::_sub_Op_SubVF(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 7275 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 16
#line 16238 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vsub16F_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 7264 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 16
#line 16248 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECZ]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vsub16F_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 7253 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 8
#line 16262 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vsub8F_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 7242 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 8
#line 16272 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECY]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vsub8F_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 7231 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 16286 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vsub4F_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 7220 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 16296 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vsub4F_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 7210 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length() == 4
#line 16310 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vsub4F_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 7198 "src/hotspot/cpu/x86/x86.ad"
(UseAVX == 0) && (n->as_Vector()->length() == 2) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 16325 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECD, vsub2F_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 7187 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 2
#line 16335 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vsub2F_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 7177 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length() == 2
#line 16349 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vsub2F_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
}
void  State::_sub_Op_SubVD(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 7352 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 8
#line 16365 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vsub8D_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 7341 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 8
#line 16375 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECZ]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vsub8D_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 7330 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 16389 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vsub4D_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 7319 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 16399 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECY]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vsub4D_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 7308 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 2
#line 16413 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vsub2D_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 7297 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 2
#line 16423 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vsub2D_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 7287 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length() == 2
#line 16437 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vsub2D_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
}
void  State::_sub_Op_MulVB(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 7503 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 64
#line 16453 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECZ]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vmul64B_reg_avx_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 7465 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 32
#line 16463 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECY]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vmul32B_reg_avx_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 7441 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 16
#line 16473 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vmul16B_reg_avx_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 7408 "src/hotspot/cpu/x86/x86.ad"
UseSSE > 3 && n->as_Vector()->length() == 16
#line 16483 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, mul16B_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 7387 "src/hotspot/cpu/x86/x86.ad"
UseSSE > 3 && n->as_Vector()->length() == 8
#line 16497 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECD]+100;
        DFA_PRODUCTION__SET_VALID(VECD, mul8B_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECS) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 7366 "src/hotspot/cpu/x86/x86.ad"
UseSSE > 3 && n->as_Vector()->length() == 4
#line 16507 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECS]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECS, mul4B_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
    }
}
void  State::_sub_Op_MulVS(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 7677 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && VM_Version::supports_avx512bw() && n->as_Vector()->length() == 32
#line 16519 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECZ]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vmul32S_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 7677 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && VM_Version::supports_avx512bw() && n->as_Vector()->length() == 32
#line 16529 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vmul32S_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 7666 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && VM_Version::supports_avx512bw() && n->as_Vector()->length() == 32
#line 16543 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECZ]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vmul32S_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 7655 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 16
#line 16557 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECY]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vmul16S_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 7655 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 16
#line 16567 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vmul16S_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 7644 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 16
#line 16581 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECY]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vmul16S_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 7633 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 8
#line 16595 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECX]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vmul8S_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 7633 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 8
#line 16605 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vmul8S_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 7622 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 8
#line 16619 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vmul8S_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 7612 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length() == 8
#line 16633 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vmul8S_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 7600 "src/hotspot/cpu/x86/x86.ad"
(UseAVX > 0) && (n->as_Vector()->length() == 4) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 16648 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECD]+100;
        DFA_PRODUCTION__SET_VALID(VECD, vmul4S_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 7600 "src/hotspot/cpu/x86/x86.ad"
(UseAVX > 0) && (n->as_Vector()->length() == 4) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 16659 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vmul4S_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 7589 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 16673 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vmul4S_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 7579 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length() == 4
#line 16687 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vmul4S_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 7567 "src/hotspot/cpu/x86/x86.ad"
(UseAVX > 0) && (n->as_Vector()->length() == 2) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 16702 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECS, vmul2S_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECS) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 7567 "src/hotspot/cpu/x86/x86.ad"
(UseAVX > 0) && (n->as_Vector()->length() == 2) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 16713 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECS]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECS) || _cost[VECS] > c) {
        DFA_PRODUCTION__SET_VALID(VECS, vmul2S_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECS) || _cost[LEGVECS] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECS) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 7556 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 2
#line 16727 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECS]+_kids[1]->_cost[VECS]+100;
      if (STATE__NOT_YET_VALID(VECS) || _cost[VECS] > c) {
        DFA_PRODUCTION__SET_VALID(VECS, vmul2S_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECS) || _cost[LEGVECS] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECS) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 7546 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length() == 2
#line 16741 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECS]+_kids[1]->_cost[VECS]+100;
      if (STATE__NOT_YET_VALID(VECS) || _cost[VECS] > c) {
        DFA_PRODUCTION__SET_VALID(VECS, vmul2S_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECS) || _cost[LEGVECS] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
      }
    }
}
void  State::_sub_Op_MulVI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 7853 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 16
#line 16757 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECZ]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vmul16I_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 7853 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 16
#line 16767 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vmul16I_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 7842 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 16
#line 16781 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECZ]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vmul16I_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 7831 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 8
#line 16795 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECY]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vmul8I_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 7831 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 8
#line 16805 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vmul8I_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 7820 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 8
#line 16819 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECY]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vmul8I_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 7743 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 16833 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECX]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vmul4I_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 7743 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 16843 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vmul4I_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 7732 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 16857 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vmul4I_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 7722 "src/hotspot/cpu/x86/x86.ad"
UseSSE > 3 && n->as_Vector()->length() == 4
#line 16871 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vmul4I_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 7710 "src/hotspot/cpu/x86/x86.ad"
(UseAVX > 0) && (n->as_Vector()->length() == 2) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 16886 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECD]+100;
        DFA_PRODUCTION__SET_VALID(VECD, vmul2I_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 7710 "src/hotspot/cpu/x86/x86.ad"
(UseAVX > 0) && (n->as_Vector()->length() == 2) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 16897 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vmul2I_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 7699 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 2
#line 16911 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vmul2I_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 7689 "src/hotspot/cpu/x86/x86.ad"
UseSSE > 3 && n->as_Vector()->length() == 2
#line 16925 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vmul2I_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
}
void  State::_sub_Op_MulReductionVI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], LEGVECZ) &&
        (
#line 5655 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2
#line 16941 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[LEGVECZ]+100;
        DFA_PRODUCTION__SET_VALID(RREGI, rvmul16I_reduction_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
        DFA_PRODUCTION__SET_VALID(RAX_REGI, rvmul16I_reduction_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, rvmul16I_reduction_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RBX_REGI, rvmul16I_reduction_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, rvmul16I_reduction_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGI, rvmul16I_reduction_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGI, rvmul16I_reduction_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDI_REGI, rvmul16I_reduction_reg_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 5627 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1
#line 16958 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[VECY]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, rvmul8I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, rvmul8I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, rvmul8I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, rvmul8I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, rvmul8I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, rvmul8I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, rvmul8I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, rvmul8I_reduction_reg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 5603 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 16993 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, rvmul4I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, rvmul4I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, rvmul4I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, rvmul4I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, rvmul4I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, rvmul4I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, rvmul4I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, rvmul4I_reduction_reg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 5580 "src/hotspot/cpu/x86/x86.ad"
UseSSE > 3 && UseAVX == 0
#line 17028 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, rsmul4I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, rsmul4I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, rsmul4I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, rsmul4I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, rsmul4I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, rsmul4I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, rsmul4I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, rsmul4I_reduction_reg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 5560 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 17063 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, rvmul2I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, rvmul2I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, rvmul2I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, rvmul2I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, rvmul2I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, rvmul2I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, rvmul2I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, rvmul2I_reduction_reg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 5541 "src/hotspot/cpu/x86/x86.ad"
UseSSE > 3 && UseAVX == 0
#line 17098 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(RREGI) || _cost[RREGI] > c) {
        DFA_PRODUCTION__SET_VALID(RREGI, rsmul2I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTI) || _cost[STACKSLOTI] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTI, storeSSI_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(RAX_REGI) || _cost[RAX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGI, rsmul2I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGI) || _cost[NO_RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGI, rsmul2I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RBX_REGI) || _cost[RBX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RBX_REGI, rsmul2I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGI) || _cost[NO_RAX_RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGI, rsmul2I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGI) || _cost[RCX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGI, rsmul2I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGI) || _cost[RDX_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGI, rsmul2I_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDI_REGI) || _cost[RDI_REGI] > c) {
        DFA_PRODUCTION__SET_VALID(RDI_REGI, rsmul2I_reduction_reg_rule, c)
      }
    }
}
void  State::_sub_Op_MulVL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 7809 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 8 && VM_Version::supports_avx512dq()
#line 17135 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECZ]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vmul8L_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 7809 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 8 && VM_Version::supports_avx512dq()
#line 17145 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vmul8L_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 7798 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 8 && VM_Version::supports_avx512dq()
#line 17159 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECZ]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vmul8L_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 7787 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 4 && VM_Version::supports_avx512dq()
#line 17173 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECY]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vmul4L_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 7787 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 4 && VM_Version::supports_avx512dq()
#line 17183 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vmul4L_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 7776 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 4 && VM_Version::supports_avx512dq()
#line 17197 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECY]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vmul4L_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 7765 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 2 && VM_Version::supports_avx512dq()
#line 17211 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECX]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vmul2L_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 7765 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 2 && VM_Version::supports_avx512dq()
#line 17221 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vmul2L_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 7754 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 2 && VM_Version::supports_avx512dq()
#line 17235 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vmul2L_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
}
void  State::_sub_Op_MulReductionVL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], LEGVECZ) &&
        (
#line 5729 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && VM_Version::supports_avx512dq()
#line 17251 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[LEGVECZ]+100;
        DFA_PRODUCTION__SET_VALID(RREGL, rvmul8L_reduction_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, rvmul8L_reduction_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, rvmul8L_reduction_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, rvmul8L_reduction_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RAX_REGL, rvmul8L_reduction_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RCX_REGL, rvmul8L_reduction_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(RDX_REGL, rvmul8L_reduction_reg_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 5706 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && VM_Version::supports_avx512dq()
#line 17267 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[VECY]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, rvmul4L_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, rvmul4L_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, rvmul4L_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, rvmul4L_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, rvmul4L_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, rvmul4L_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, rvmul4L_reduction_reg_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 5687 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && VM_Version::supports_avx512dq()
#line 17299 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(RREGL) || _cost[RREGL] > c) {
        DFA_PRODUCTION__SET_VALID(RREGL, rvmul2L_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTL) || _cost[STACKSLOTL] > c+100) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTL, storeSSL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_RDX_REGL) || _cost[NO_RAX_RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_RDX_REGL, rvmul2L_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RAX_REGL) || _cost[NO_RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RAX_REGL, rvmul2L_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(NO_RCX_REGL) || _cost[NO_RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(NO_RCX_REGL, rvmul2L_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RAX_REGL) || _cost[RAX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RAX_REGL, rvmul2L_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RCX_REGL) || _cost[RCX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RCX_REGL, rvmul2L_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(RDX_REGL) || _cost[RDX_REGL] > c) {
        DFA_PRODUCTION__SET_VALID(RDX_REGL, rvmul2L_reduction_reg_rule, c)
      }
    }
}
void  State::_sub_Op_MulVF(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 7963 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 16
#line 17333 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECZ]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vmul16F_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 7963 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 16
#line 17343 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vmul16F_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 7952 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 16
#line 17357 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECZ]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vmul16F_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 7941 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 8
#line 17371 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECY]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vmul8F_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 7941 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 8
#line 17381 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vmul8F_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 7930 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 8
#line 17395 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECY]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vmul8F_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 7919 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 17409 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECX]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vmul4F_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 7919 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 17419 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vmul4F_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 7908 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 17433 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vmul4F_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 7898 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length() == 4
#line 17447 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vmul4F_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 7886 "src/hotspot/cpu/x86/x86.ad"
(UseAVX > 0) && (n->as_Vector()->length() == 2) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 17462 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECD]+100;
        DFA_PRODUCTION__SET_VALID(VECD, vmul2F_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 7886 "src/hotspot/cpu/x86/x86.ad"
(UseAVX > 0) && (n->as_Vector()->length() == 2) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 17473 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vmul2F_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 7875 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 2
#line 17487 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vmul2F_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 7865 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length() == 2
#line 17501 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vmul2F_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
}
void  State::_sub_Op_MulReductionVF(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], LEGVECZ) &&
        (
#line 5872 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2
#line 17517 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[LEGVECZ]+100;
        DFA_PRODUCTION__SET_VALID(REGF, rvmul16F_reduction_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 5833 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 17529 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[VECY]+100;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, rvmul8F_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 5810 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 17549 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, rvmul4F_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 5787 "src/hotspot/cpu/x86/x86.ad"
UseSSE >= 1 && UseAVX == 0
#line 17569 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, rsmul4F_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 5772 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 17589 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, rvmul2F_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 5757 "src/hotspot/cpu/x86/x86.ad"
UseSSE >= 1 && UseAVX == 0
#line 17609 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(REGF) || _cost[REGF] > c) {
        DFA_PRODUCTION__SET_VALID(REGF, rsmul2F_reduction_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGF) || _cost[VLREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGF, MoveF2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGF) || _cost[LEGREGF] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGF, MoveF2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTF) || _cost[STACKSLOTF] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTF, storeSSF_rule, c+95)
      }
    }
}
void  State::_sub_Op_MulVD(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 8040 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 8
#line 17631 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECZ]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vmul8D_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 8040 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 8
#line 17641 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vmul8D_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 8029 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 8
#line 17655 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECZ]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vmul8D_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 8018 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 17669 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECY]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vmul4D_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 8018 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 17679 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vmul4D_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 8007 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 17693 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECY]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vmul4D_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 7996 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 2
#line 17707 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECX]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vmul2D_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 7996 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 2
#line 17717 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vmul2D_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 7985 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 2
#line 17731 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vmul2D_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 7975 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length() == 2
#line 17745 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vmul2D_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
}
void  State::_sub_Op_MulReductionVD(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], LEGVECZ) &&
        (
#line 5996 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2
#line 17761 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[LEGVECZ]+100;
        DFA_PRODUCTION__SET_VALID(REGD, rvmul8D_reduction_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 5973 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 17773 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[VECY]+100;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, rvmul4D_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 5958 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0
#line 17793 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, rvmul2D_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGD) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 5943 "src/hotspot/cpu/x86/x86.ad"
UseSSE >= 1 && UseAVX == 0
#line 17813 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGD]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(REGD) || _cost[REGD] > c) {
        DFA_PRODUCTION__SET_VALID(REGD, rsmul2D_reduction_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(VLREGD) || _cost[VLREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(VLREGD, MoveD2VL_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(LEGREGD) || _cost[LEGREGD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGREGD, MoveD2LEG_rule, c+100)
      }
      if (STATE__NOT_YET_VALID(STACKSLOTD) || _cost[STACKSLOTD] > c+95) {
        DFA_PRODUCTION__SET_VALID(STACKSLOTD, storeSSD_rule, c+95)
      }
    }
}
void  State::_sub_Op_FmaVD(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], _BINARY_VECZ__LOADVECTOR_MEMORY_) &&
        (
#line 9701 "src/hotspot/cpu/x86/x86.ad"
UseFMA && n->as_Vector()->length() == 8
#line 17835 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[_BINARY_VECZ__LOADVECTOR_MEMORY_]+150;
        DFA_PRODUCTION__SET_VALID(VECZ, vfma8D_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], _BINARY_VECZ_VECZ) &&
        (
#line 9688 "src/hotspot/cpu/x86/x86.ad"
UseFMA && n->as_Vector()->length() == 8
#line 17845 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[_BINARY_VECZ_VECZ]+150;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vfma8D_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], _BINARY_VECY__LOADVECTOR_MEMORY_) &&
        (
#line 9675 "src/hotspot/cpu/x86/x86.ad"
UseFMA && n->as_Vector()->length() == 4
#line 17859 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[_BINARY_VECY__LOADVECTOR_MEMORY_]+150;
        DFA_PRODUCTION__SET_VALID(VECY, vfma4D_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], _BINARY_VECY_VECY) &&
        (
#line 9662 "src/hotspot/cpu/x86/x86.ad"
UseFMA && n->as_Vector()->length() == 4
#line 17869 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[_BINARY_VECY_VECY]+150;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vfma4D_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], _BINARY_VECX__LOADVECTOR_MEMORY_) &&
        (
#line 9648 "src/hotspot/cpu/x86/x86.ad"
UseFMA && n->as_Vector()->length() == 2
#line 17883 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[_BINARY_VECX__LOADVECTOR_MEMORY_]+150;
        DFA_PRODUCTION__SET_VALID(VECX, vfma2D_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], _BINARY_VECX_VECX) &&
        (
#line 9635 "src/hotspot/cpu/x86/x86.ad"
UseFMA && n->as_Vector()->length() == 2
#line 17893 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[_BINARY_VECX_VECX]+150;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vfma2D_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
}
void  State::_sub_Op_FmaVF(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], _BINARY_VECZ__LOADVECTOR_MEMORY_) &&
        (
#line 9779 "src/hotspot/cpu/x86/x86.ad"
UseFMA && n->as_Vector()->length() == 16
#line 17909 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[_BINARY_VECZ__LOADVECTOR_MEMORY_]+150;
        DFA_PRODUCTION__SET_VALID(VECZ, vfma16F_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], _BINARY_VECZ_VECZ) &&
        (
#line 9766 "src/hotspot/cpu/x86/x86.ad"
UseFMA && n->as_Vector()->length() == 16
#line 17919 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[_BINARY_VECZ_VECZ]+150;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vfma16F_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], _BINARY_VECY__LOADVECTOR_MEMORY_) &&
        (
#line 9753 "src/hotspot/cpu/x86/x86.ad"
UseFMA && n->as_Vector()->length() == 8
#line 17933 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[_BINARY_VECY__LOADVECTOR_MEMORY_]+150;
        DFA_PRODUCTION__SET_VALID(VECY, vfma8F_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], _BINARY_VECY_VECY) &&
        (
#line 9740 "src/hotspot/cpu/x86/x86.ad"
UseFMA && n->as_Vector()->length() == 8
#line 17943 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[_BINARY_VECY_VECY]+150;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vfma8F_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], _BINARY_VECX__LOADVECTOR_MEMORY_) &&
        (
#line 9727 "src/hotspot/cpu/x86/x86.ad"
UseFMA && n->as_Vector()->length() == 4
#line 17957 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[_BINARY_VECX__LOADVECTOR_MEMORY_]+150;
        DFA_PRODUCTION__SET_VALID(VECX, vfma4F_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], _BINARY_VECX_VECX) &&
        (
#line 9714 "src/hotspot/cpu/x86/x86.ad"
UseFMA && n->as_Vector()->length() == 4
#line 17967 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[_BINARY_VECX_VECX]+150;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vfma4F_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
}
void  State::_sub_Op_DivVF(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 8184 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 16
#line 17983 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vdiv16F_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 8173 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 16
#line 17993 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECZ]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vdiv16F_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 8162 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 8
#line 18007 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vdiv8F_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 8151 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 8
#line 18017 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECY]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vdiv8F_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 8140 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 18031 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vdiv4F_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 8129 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 18041 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vdiv4F_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 8119 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length() == 4
#line 18055 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vdiv4F_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 8107 "src/hotspot/cpu/x86/x86.ad"
(UseAVX > 0) && (n->as_Vector()->length() == 2) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 18070 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECD, vdiv2F_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 8096 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 2
#line 18080 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vdiv2F_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 8086 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length() == 2
#line 18094 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vdiv2F_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
}
void  State::_sub_Op_DivVD(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 8261 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 8
#line 18110 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vdiv8D_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 8250 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 8
#line 18120 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECZ]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vdiv8D_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 8239 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 18134 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vdiv4D_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 8228 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 18144 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECY]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vdiv4D_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 8217 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 2
#line 18158 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vdiv2D_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 8206 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 2
#line 18168 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vdiv2D_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 8196 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length() == 2
#line 18182 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vdiv2D_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
}
void  State::_sub_Op_AbsVB(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VECZ) &&
        (
#line 9390 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 64
#line 18198 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vabs64B_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) &&
        (
#line 9379 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 32
#line 18208 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vabs32B_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) &&
        (
#line 9369 "src/hotspot/cpu/x86/x86.ad"
UseSSE > 2 && n->as_Vector()->length() == 16
#line 18218 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vabs16B_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) &&
        (
#line 9359 "src/hotspot/cpu/x86/x86.ad"
UseSSE > 2 && n->as_Vector()->length() == 8
#line 18228 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+100;
        DFA_PRODUCTION__SET_VALID(VECD, vabs8B_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECS) &&
        (
#line 9349 "src/hotspot/cpu/x86/x86.ad"
UseSSE > 2 && n->as_Vector()->length() == 4
#line 18238 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECS, vabs4B_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
    }
}
void  State::_sub_Op_AbsVS(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VECZ) &&
        (
#line 9442 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 32
#line 18250 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vabs32S_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) &&
        (
#line 9431 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 16
#line 18260 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vabs16S_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) &&
        (
#line 9421 "src/hotspot/cpu/x86/x86.ad"
UseSSE > 2 && n->as_Vector()->length() == 8
#line 18270 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vabs8S_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) &&
        (
#line 9411 "src/hotspot/cpu/x86/x86.ad"
UseSSE > 2 && n->as_Vector()->length() == 4
#line 18280 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+100;
        DFA_PRODUCTION__SET_VALID(VECD, vabs4S_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) &&
        (
#line 9401 "src/hotspot/cpu/x86/x86.ad"
UseSSE > 2 && n->as_Vector()->length() == 2
#line 18290 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vabs2S_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
}
void  State::_sub_Op_AbsVI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VECZ) &&
        (
#line 9484 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 16
#line 18306 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vabs16I_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) &&
        (
#line 9473 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 8
#line 18316 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vabs8I_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) &&
        (
#line 9463 "src/hotspot/cpu/x86/x86.ad"
UseSSE > 2 && n->as_Vector()->length() == 4
#line 18326 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vabs4I_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) &&
        (
#line 9453 "src/hotspot/cpu/x86/x86.ad"
UseSSE > 2 && n->as_Vector()->length() == 2
#line 18336 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+100;
        DFA_PRODUCTION__SET_VALID(VECD, vabs2I_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
}
void  State::_sub_Op_AbsVL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VECZ) &&
        (
#line 9517 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 8
#line 18348 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vabs8L_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) &&
        (
#line 9506 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 4
#line 18358 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vabs4L_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) &&
        (
#line 9495 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 2
#line 18368 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vabs2L_reg_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
}
void  State::_sub_Op_AbsVF(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VECZ) &&
        (
#line 9617 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 16
#line 18380 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+150;
        DFA_PRODUCTION__SET_VALID(VECZ, vabsneg16F_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) &&
        (
#line 9602 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 8
#line 18390 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+150;
        DFA_PRODUCTION__SET_VALID(VECY, vabsneg8F_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) &&
        (
#line 9588 "src/hotspot/cpu/x86/x86.ad"
UseSSE > 0 && n->as_Vector()->length() == 4
#line 18400 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+150;
        DFA_PRODUCTION__SET_VALID(VECX, vabsneg4F_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) &&
        (
#line 9573 "src/hotspot/cpu/x86/x86.ad"
UseSSE > 0 && n->as_Vector()->length() == 2
#line 18410 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+100;
        DFA_PRODUCTION__SET_VALID(VECD, vabsneg2F_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
}
void  State::_sub_Op_AbsVD(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VECZ) &&
        (
#line 9559 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 8
#line 18422 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vabsneg8D_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) &&
        (
#line 9545 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 18432 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vabsneg4D_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) &&
        (
#line 9530 "src/hotspot/cpu/x86/x86.ad"
UseSSE >= 2 && n->as_Vector()->length() == 2
#line 18442 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vabsneg2D_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
}
void  State::_sub_Op_NegVF(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VECZ) &&
        (
#line 9617 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 16
#line 18454 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+150;
        DFA_PRODUCTION__SET_VALID(VECZ, vabsneg16F_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) &&
        (
#line 9602 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 8
#line 18464 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+150;
        DFA_PRODUCTION__SET_VALID(VECY, vabsneg8F_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) &&
        (
#line 9588 "src/hotspot/cpu/x86/x86.ad"
UseSSE > 0 && n->as_Vector()->length() == 4
#line 18474 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+150;
        DFA_PRODUCTION__SET_VALID(VECX, vabsneg4F_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) &&
        (
#line 9573 "src/hotspot/cpu/x86/x86.ad"
UseSSE > 0 && n->as_Vector()->length() == 2
#line 18484 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+100;
        DFA_PRODUCTION__SET_VALID(VECD, vabsneg2F_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
}
void  State::_sub_Op_NegVD(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VECZ) &&
        (
#line 9559 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 8
#line 18496 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vabsneg8D_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) &&
        (
#line 9545 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 18506 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vabsneg4D_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) &&
        (
#line 9530 "src/hotspot/cpu/x86/x86.ad"
UseSSE >= 2 && n->as_Vector()->length() == 2
#line 18516 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vabsneg2D_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
}
void  State::_sub_Op_SqrtVD(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) &&
        (
#line 8330 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 8
#line 18528 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vsqrt8D_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) &&
        (
#line 8319 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 8
#line 18538 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vsqrt8D_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) &&
        (
#line 8308 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 18552 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vsqrt4D_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) &&
        (
#line 8297 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 18562 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vsqrt4D_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) &&
        (
#line 8286 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 2
#line 18576 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vsqrt2D_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) &&
        (
#line 8275 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 2
#line 18586 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vsqrt2D_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
}
void  State::_sub_Op_SqrtVF(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) &&
        (
#line 8419 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 16
#line 18602 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vsqrt16F_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) &&
        (
#line 8408 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 16
#line 18612 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vsqrt16F_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) &&
        (
#line 8397 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 8
#line 18626 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vsqrt8F_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) &&
        (
#line 8386 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 8
#line 18636 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vsqrt8F_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) &&
        (
#line 8375 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 18650 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vsqrt4F_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) &&
        (
#line 8364 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 4
#line 18660 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vsqrt4F_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) &&
        (
#line 8352 "src/hotspot/cpu/x86/x86.ad"
(UseAVX > 0) && (n->as_Vector()->length() == 2) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 18675 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECD, vsqrt2F_mem_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) &&
        (
#line 8341 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length() == 2
#line 18685 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vsqrt2F_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
}
void  State::_sub_Op_LShiftCntV(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
        DFA_PRODUCTION__SET_VALID(VECS, vshiftcnt_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
    }
}
void  State::_sub_Op_RShiftCntV(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], RREGI) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
        DFA_PRODUCTION__SET_VALID(VECS, vshiftcnt_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
    }
}
void  State::_sub_Op_LShiftVB(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8590 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 64
#line 18715 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vshift64B_avx_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8558 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 32
#line 18725 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vshift32B_avx_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8534 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 16
#line 18735 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vshift16B_avx_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8503 "src/hotspot/cpu/x86/x86.ad"
UseSSE > 3  && UseAVX <= 1 && n->as_Vector()->length() == 16
#line 18745 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECS]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vshift16B_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8480 "src/hotspot/cpu/x86/x86.ad"
UseSSE > 3 && n->as_Vector()->length() == 8
#line 18759 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECD, vshift8B_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECS) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8457 "src/hotspot/cpu/x86/x86.ad"
UseSSE > 3 && n->as_Vector()->length() == 4
#line 18769 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECS]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECS, vshift4B_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
    }
}
void  State::_sub_Op_LShiftVS(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8712 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && VM_Version::supports_avx512bw() && n->as_Vector()->length() == 32
#line 18781 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vshift32S_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8697 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 16
#line 18791 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vshift16S_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8676 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 8
#line 18801 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vshift8S_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8654 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 4
#line 18811 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECD, vshift4S_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECS) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8633 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 2
#line 18821 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECS]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECS, vshist2S_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
    }
}
void  State::_sub_Op_LShiftVI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8785 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 16
#line 18833 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vshift16I_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8770 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 8
#line 18843 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vshift8I_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8749 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 4
#line 18853 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vshift4I_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8728 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 2
#line 18863 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECD, vshift2I_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
}
void  State::_sub_Op_LShiftVL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8835 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 8
#line 18875 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vshift8L_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8821 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 4
#line 18885 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vshift4L_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8801 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 2
#line 18895 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vshift2L_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
}
void  State::_sub_Op_RShiftVB(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8590 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 64
#line 18907 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vshift64B_avx_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8558 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 32
#line 18917 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vshift32B_avx_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8534 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 16
#line 18927 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vshift16B_avx_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8503 "src/hotspot/cpu/x86/x86.ad"
UseSSE > 3  && UseAVX <= 1 && n->as_Vector()->length() == 16
#line 18937 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECS]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vshift16B_0_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8480 "src/hotspot/cpu/x86/x86.ad"
UseSSE > 3 && n->as_Vector()->length() == 8
#line 18951 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECD, vshift8B_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECS) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8457 "src/hotspot/cpu/x86/x86.ad"
UseSSE > 3 && n->as_Vector()->length() == 4
#line 18961 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECS]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECS, vshift4B_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
    }
}
void  State::_sub_Op_RShiftVS(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8712 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && VM_Version::supports_avx512bw() && n->as_Vector()->length() == 32
#line 18973 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vshift32S_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8697 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 16
#line 18983 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vshift16S_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8676 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 8
#line 18993 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vshift8S_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8654 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 4
#line 19003 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECD, vshift4S_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECS) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8633 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 2
#line 19013 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECS]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECS, vshist2S_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
    }
}
void  State::_sub_Op_RShiftVI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8785 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 16
#line 19025 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vshift16I_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8770 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 8
#line 19035 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vshift8I_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8749 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 4
#line 19045 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vshift4I_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8728 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 2
#line 19055 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECD, vshift2I_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
}
void  State::_sub_Op_RShiftVL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8904 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 4
#line 19067 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vsra4L_reg_evex_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8884 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 4
#line 19077 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECS]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vsra4L_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8873 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 2
#line 19091 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vsra2L_reg_evex_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8852 "src/hotspot/cpu/x86/x86.ad"
UseSSE >= 2 && n->as_Vector()->length() == 2
#line 19101 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECS]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vsra2L_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8835 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 8
#line 19115 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vshift8L_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
}
void  State::_sub_Op_URShiftVB(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8590 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 64
#line 19127 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vshift64B_avx_1_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8558 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 32
#line 19137 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vshift32B_avx_1_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8534 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 16
#line 19147 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vshift16B_avx_1_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8503 "src/hotspot/cpu/x86/x86.ad"
UseSSE > 3  && UseAVX <= 1 && n->as_Vector()->length() == 16
#line 19157 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECS]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vshift16B_1_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8480 "src/hotspot/cpu/x86/x86.ad"
UseSSE > 3 && n->as_Vector()->length() == 8
#line 19171 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECD, vshift8B_1_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECS) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8457 "src/hotspot/cpu/x86/x86.ad"
UseSSE > 3 && n->as_Vector()->length() == 4
#line 19181 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECS]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECS, vshift4B_1_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
    }
}
void  State::_sub_Op_URShiftVS(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8712 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && VM_Version::supports_avx512bw() && n->as_Vector()->length() == 32
#line 19193 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vshift32S_1_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8697 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 16
#line 19203 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vshift16S_1_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8676 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 8
#line 19213 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vshift8S_1_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8654 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 4
#line 19223 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECD, vshift4S_1_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECS) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8633 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 2
#line 19233 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECS]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECS, vshist2S_1_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
    }
}
void  State::_sub_Op_URShiftVI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8785 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 16
#line 19245 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vshift16I_1_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8770 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 8
#line 19255 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vshift8I_1_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8749 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 4
#line 19265 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vshift4I_1_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8728 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 2
#line 19275 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECD, vshift2I_1_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
}
void  State::_sub_Op_URShiftVL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8835 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length() == 8
#line 19287 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vshift8L_1_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8821 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length() == 4
#line 19297 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vshift4L_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8801 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 2
#line 19307 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vshift2L_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
}
void  State::_sub_Op_AndV(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 9048 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length_in_bytes() == 64
#line 19319 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECZ]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vand64B_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 9048 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length_in_bytes() == 64
#line 19329 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vand64B_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 9037 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length_in_bytes() == 64
#line 19343 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECZ]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vand64B_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 9026 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length_in_bytes() == 32
#line 19357 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECY]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vand32B_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 9026 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length_in_bytes() == 32
#line 19367 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vand32B_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 9015 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length_in_bytes() == 32
#line 19381 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECY]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vand32B_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 9004 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length_in_bytes() == 16
#line 19395 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECX]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vand16B_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 9004 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length_in_bytes() == 16
#line 19405 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vand16B_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 8993 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length_in_bytes() == 16
#line 19419 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vand16B_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 8983 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length_in_bytes() == 16
#line 19433 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vand16B_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 8971 "src/hotspot/cpu/x86/x86.ad"
(UseAVX > 0) && (n->as_Vector()->length_in_bytes() == 8) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 19448 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECD]+100;
        DFA_PRODUCTION__SET_VALID(VECD, vand8B_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 8971 "src/hotspot/cpu/x86/x86.ad"
(UseAVX > 0) && (n->as_Vector()->length_in_bytes() == 8) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 19459 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vand8B_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 8960 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length_in_bytes() == 8
#line 19473 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vand8B_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 8950 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length_in_bytes() == 8
#line 19487 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vand8B_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8938 "src/hotspot/cpu/x86/x86.ad"
(UseAVX > 0) && (n->as_Vector()->length_in_bytes() == 4) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 19502 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECS, vand4B_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECS) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 8938 "src/hotspot/cpu/x86/x86.ad"
(UseAVX > 0) && (n->as_Vector()->length_in_bytes() == 4) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 19513 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECS]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECS) || _cost[VECS] > c) {
        DFA_PRODUCTION__SET_VALID(VECS, vand4B_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECS) || _cost[LEGVECS] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECS) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8927 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length_in_bytes() == 4
#line 19527 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECS]+_kids[1]->_cost[VECS]+100;
      if (STATE__NOT_YET_VALID(VECS) || _cost[VECS] > c) {
        DFA_PRODUCTION__SET_VALID(VECS, vand4B_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECS) || _cost[LEGVECS] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECS) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 8917 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length_in_bytes() == 4
#line 19541 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECS]+_kids[1]->_cost[VECS]+100;
      if (STATE__NOT_YET_VALID(VECS) || _cost[VECS] > c) {
        DFA_PRODUCTION__SET_VALID(VECS, vand4B_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECS) || _cost[LEGVECS] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
      }
    }
}
void  State::_sub_Op_OrV(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 9192 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length_in_bytes() == 64
#line 19557 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECZ]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vor64B_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 9192 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length_in_bytes() == 64
#line 19567 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vor64B_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 9181 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length_in_bytes() == 64
#line 19581 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECZ]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vor64B_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 9170 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length_in_bytes() == 32
#line 19595 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECY]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vor32B_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 9170 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length_in_bytes() == 32
#line 19605 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vor32B_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 9159 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length_in_bytes() == 32
#line 19619 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECY]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vor32B_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 9148 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length_in_bytes() == 16
#line 19633 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECX]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vor16B_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 9148 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length_in_bytes() == 16
#line 19643 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vor16B_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 9137 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length_in_bytes() == 16
#line 19657 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vor16B_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 9127 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length_in_bytes() == 16
#line 19671 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vor16B_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 9115 "src/hotspot/cpu/x86/x86.ad"
(UseAVX > 0) && (n->as_Vector()->length_in_bytes() == 8) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 19686 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECD]+100;
        DFA_PRODUCTION__SET_VALID(VECD, vor8B_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 9115 "src/hotspot/cpu/x86/x86.ad"
(UseAVX > 0) && (n->as_Vector()->length_in_bytes() == 8) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 19697 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vor8B_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 9104 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length_in_bytes() == 8
#line 19711 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vor8B_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 9094 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length_in_bytes() == 8
#line 19725 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vor8B_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 9082 "src/hotspot/cpu/x86/x86.ad"
(UseAVX > 0) && (n->as_Vector()->length_in_bytes() == 4) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 19740 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECS, vor4B_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECS) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 9082 "src/hotspot/cpu/x86/x86.ad"
(UseAVX > 0) && (n->as_Vector()->length_in_bytes() == 4) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 19751 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECS]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECS) || _cost[VECS] > c) {
        DFA_PRODUCTION__SET_VALID(VECS, vor4B_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECS) || _cost[LEGVECS] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECS) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 9071 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length_in_bytes() == 4
#line 19765 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECS]+_kids[1]->_cost[VECS]+100;
      if (STATE__NOT_YET_VALID(VECS) || _cost[VECS] > c) {
        DFA_PRODUCTION__SET_VALID(VECS, vor4B_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECS) || _cost[LEGVECS] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECS) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 9061 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length_in_bytes() == 4
#line 19779 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECS]+_kids[1]->_cost[VECS]+100;
      if (STATE__NOT_YET_VALID(VECS) || _cost[VECS] > c) {
        DFA_PRODUCTION__SET_VALID(VECS, vor4B_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECS) || _cost[LEGVECS] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
      }
    }
}
void  State::_sub_Op_XorV(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 9336 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length_in_bytes() == 64
#line 19795 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECZ]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, vxor64B_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 9336 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length_in_bytes() == 64
#line 19805 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vxor64B_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECZ) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 9325 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 2 && n->as_Vector()->length_in_bytes() == 64
#line 19819 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECZ]+_kids[1]->_cost[VECZ]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, vxor64B_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 9314 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length_in_bytes() == 32
#line 19833 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECY]+100;
        DFA_PRODUCTION__SET_VALID(VECY, vxor32B_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 9314 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length_in_bytes() == 32
#line 19843 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vxor32B_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECY) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 9303 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 1 && n->as_Vector()->length_in_bytes() == 32
#line 19857 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECY]+_kids[1]->_cost[VECY]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, vxor32B_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 9292 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length_in_bytes() == 16
#line 19871 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECX]+100;
        DFA_PRODUCTION__SET_VALID(VECX, vxor16B_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 9292 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length_in_bytes() == 16
#line 19881 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vxor16B_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 9281 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length_in_bytes() == 16
#line 19895 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vxor16B_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECX) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 9271 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length_in_bytes() == 16
#line 19909 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECX]+_kids[1]->_cost[VECX]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, vxor16B_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 9259 "src/hotspot/cpu/x86/x86.ad"
(UseAVX > 0) && (n->as_Vector()->length_in_bytes() == 8) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 19924 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECD]+100;
        DFA_PRODUCTION__SET_VALID(VECD, vxor8B_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 9259 "src/hotspot/cpu/x86/x86.ad"
(UseAVX > 0) && (n->as_Vector()->length_in_bytes() == 8) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 19935 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vxor8B_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 9248 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length_in_bytes() == 8
#line 19949 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vxor8B_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECD) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 9238 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length_in_bytes() == 8
#line 19963 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECD]+_kids[1]->_cost[VECD]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, vxor8B_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADVECTOR_MEMORY_) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 9226 "src/hotspot/cpu/x86/x86.ad"
(UseAVX > 0) && (n->as_Vector()->length_in_bytes() == 4) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 19978 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADVECTOR_MEMORY_]+_kids[1]->_cost[VECS]+100;
        DFA_PRODUCTION__SET_VALID(VECS, vxor4B_mem_0_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VECS) && STATE__VALID_CHILD(_kids[1], _LOADVECTOR_MEMORY_) &&
        (
#line 9226 "src/hotspot/cpu/x86/x86.ad"
(UseAVX > 0) && (n->as_Vector()->length_in_bytes() == 4) &&
    (vector_length_in_bytes(n->in(1)) > 8)
#line 19989 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECS]+_kids[1]->_cost[_LOADVECTOR_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECS) || _cost[VECS] > c) {
        DFA_PRODUCTION__SET_VALID(VECS, vxor4B_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECS) || _cost[LEGVECS] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECS) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 9215 "src/hotspot/cpu/x86/x86.ad"
UseAVX > 0 && n->as_Vector()->length_in_bytes() == 4
#line 20003 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECS]+_kids[1]->_cost[VECS]+100;
      if (STATE__NOT_YET_VALID(VECS) || _cost[VECS] > c) {
        DFA_PRODUCTION__SET_VALID(VECS, vxor4B_reg_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECS) || _cost[LEGVECS] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VECS) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 9205 "src/hotspot/cpu/x86/x86.ad"
UseAVX == 0 && n->as_Vector()->length_in_bytes() == 4
#line 20017 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VECS]+_kids[1]->_cost[VECS]+100;
      if (STATE__NOT_YET_VALID(VECS) || _cost[VECS] > c) {
        DFA_PRODUCTION__SET_VALID(VECS, vxor4B_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECS) || _cost[LEGVECS] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
      }
    }
}
void  State::_sub_Op_LoadVector(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) &&
        (
#line 3196 "src/hotspot/cpu/x86/x86.ad"
n->as_LoadVector()->memory_size() == 64 && n->as_LoadVector()->element_size() > 4
#line 20033 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+125;
        DFA_PRODUCTION__SET_VALID(VECZ, loadV64_qword_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) &&
        (
#line 3183 "src/hotspot/cpu/x86/x86.ad"
n->as_LoadVector()->memory_size() == 64 && n->as_LoadVector()->element_size() <= 4
#line 20043 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+125;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, loadV64_dword_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) &&
        (
#line 3141 "src/hotspot/cpu/x86/x86.ad"
n->as_LoadVector()->memory_size() == 32
#line 20057 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+125;
        DFA_PRODUCTION__SET_VALID(VECY, loadV32_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) &&
        (
#line 3099 "src/hotspot/cpu/x86/x86.ad"
n->as_LoadVector()->memory_size() == 16
#line 20067 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+125;
        DFA_PRODUCTION__SET_VALID(VECX, loadV16_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) &&
        (
#line 3067 "src/hotspot/cpu/x86/x86.ad"
n->as_LoadVector()->memory_size() == 8
#line 20077 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+125;
        DFA_PRODUCTION__SET_VALID(VECD, loadV8_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) &&
        (
#line 3035 "src/hotspot/cpu/x86/x86.ad"
n->as_LoadVector()->memory_size() == 4
#line 20087 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+125;
        DFA_PRODUCTION__SET_VALID(VECS, loadV4_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) ) {
      unsigned int c = _kids[0]->_cost[MEMORY];
        DFA_PRODUCTION__SET_VALID(_LOADVECTOR_MEMORY_, _LoadVector_memory__rule, c)
    }
}
void  State::_sub_Op_StoreVector(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 3285 "src/hotspot/cpu/x86/x86.ad"
n->as_StoreVector()->memory_size() == 64 && n->as_StoreVector()->element_size() > 4
#line 20103 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[VECZ]+145;
        DFA_PRODUCTION__SET_VALID(UNIVERSE, storeV64_qword_rule, c)
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], VECZ) &&
        (
#line 3273 "src/hotspot/cpu/x86/x86.ad"
n->as_StoreVector()->memory_size() == 64 && n->as_StoreVector()->element_size() <= 4
#line 20112 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[VECZ]+145;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, storeV64_dword_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], VECY) &&
        (
#line 3262 "src/hotspot/cpu/x86/x86.ad"
n->as_StoreVector()->memory_size() == 32
#line 20123 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[VECY]+145;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, storeV32_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], VECX) &&
        (
#line 3251 "src/hotspot/cpu/x86/x86.ad"
n->as_StoreVector()->memory_size() == 16
#line 20134 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[VECX]+145;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, storeV16_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], VECD) &&
        (
#line 3240 "src/hotspot/cpu/x86/x86.ad"
n->as_StoreVector()->memory_size() == 8
#line 20145 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[VECD]+145;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, storeV8_rule, c)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], MEMORY) && STATE__VALID_CHILD(_kids[1], VECS) &&
        (
#line 3229 "src/hotspot/cpu/x86/x86.ad"
n->as_StoreVector()->memory_size() == 4
#line 20156 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[MEMORY]+_kids[1]->_cost[VECS]+145;
      if (STATE__NOT_YET_VALID(UNIVERSE) || _cost[UNIVERSE] > c) {
        DFA_PRODUCTION__SET_VALID(UNIVERSE, storeV4_rule, c)
      }
    }
}
void  State::_sub_Op_ReplicateB(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], IMMI0) &&
        (
#line 4473 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 64 && UseAVX > 2
#line 20169 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI0]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, Repl64B_zero_evex_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI) &&
        (
#line 4460 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 64 && UseAVX > 2 && VM_Version::supports_avx512bw()
#line 20179 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, Repl64B_imm_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI) &&
        (
#line 4447 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 32 && UseAVX > 2 && VM_Version::supports_avx512vlbw()
#line 20193 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI]+100;
        DFA_PRODUCTION__SET_VALID(VECY, Repl32B_imm_evex_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI) &&
        (
#line 4434 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 16 && UseAVX > 2 && VM_Version::supports_avx512vlbw()
#line 20203 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI]+100;
        DFA_PRODUCTION__SET_VALID(VECX, Repl16B_imm_evex_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADB_MEMORY_) &&
        (
#line 4423 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 64 && UseAVX > 2 && VM_Version::supports_avx512bw()
#line 20213 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADB_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, Repl64B_mem_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) &&
        (
#line 4412 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 64 && UseAVX > 2 && VM_Version::supports_avx512bw()
#line 20227 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, Repl64B_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADB_MEMORY_) &&
        (
#line 4401 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 32 && UseAVX > 2 && VM_Version::supports_avx512vlbw()
#line 20241 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADB_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, Repl32B_mem_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) &&
        (
#line 4390 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 32 && UseAVX > 2 && VM_Version::supports_avx512vlbw()
#line 20255 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, Repl32B_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADB_MEMORY_) &&
        (
#line 4379 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 16 && UseAVX > 2 && VM_Version::supports_avx512vlbw()
#line 20269 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADB_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, Repl16B_mem_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) &&
        (
#line 4368 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 16 && UseAVX > 2 && VM_Version::supports_avx512vlbw()
#line 20283 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, Repl16B_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADB_MEMORY_) &&
        (
#line 4357 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 8 && UseAVX > 2 && VM_Version::supports_avx512vlbw()
#line 20297 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADB_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECD, Repl8B_mem_evex_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADB_MEMORY_) &&
        (
#line 4346 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 4 && UseAVX > 2 && VM_Version::supports_avx512vlbw()
#line 20307 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADB_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECS, Repl4B_mem_evex_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI0) &&
        (
#line 4085 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 32
#line 20317 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI0]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, Repl32B_zero_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI0) &&
        (
#line 4075 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 16
#line 20331 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI0]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, Repl16B_zero_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI0) &&
        (
#line 4065 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 8
#line 20345 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI0]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, Repl8B_zero_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI0) &&
        (
#line 4055 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 4
#line 20359 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI0]+100;
      if (STATE__NOT_YET_VALID(VECS) || _cost[VECS] > c) {
        DFA_PRODUCTION__SET_VALID(VECS, Repl4B_zero_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECS) || _cost[LEGVECS] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI) &&
        (
#line 4044 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 8
#line 20373 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, Repl8B_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI) &&
        (
#line 4034 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 4
#line 20387 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI]+100;
      if (STATE__NOT_YET_VALID(VECS) || _cost[VECS] > c) {
        DFA_PRODUCTION__SET_VALID(VECS, Repl4B_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECS) || _cost[LEGVECS] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) &&
        (
#line 4019 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 8
#line 20401 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, Repl8B_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) &&
        (
#line 4005 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 4
#line 20415 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(VECS) || _cost[VECS] > c) {
        DFA_PRODUCTION__SET_VALID(VECS, Repl4B_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECS) || _cost[LEGVECS] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI) &&
        (
#line 3379 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 64 && !VM_Version::supports_avx512vlbw()
#line 20429 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI]+100;
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, Repl64B_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(VECZ, MoveLeg2VecZ_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI) &&
        (
#line 3365 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 32 && !VM_Version::supports_avx512vlbw()
#line 20443 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, Repl32B_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI) &&
        (
#line 3353 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 16 && !VM_Version::supports_avx512vlbw()
#line 20457 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, Repl16B_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) &&
        (
#line 3333 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 64 && !VM_Version::supports_avx512vlbw()
#line 20471 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, Repl64B_rule, c)
      }
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(VECZ, MoveLeg2VecZ_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) &&
        (
#line 3315 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 32 && !VM_Version::supports_avx512vlbw()
#line 20485 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, Repl32B_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) &&
        (
#line 3299 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 16 && !VM_Version::supports_avx512vlbw()
#line 20499 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, Repl16B_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
}
void  State::_sub_Op_ReplicateS(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], IMMI0) &&
        (
#line 4612 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 32 && UseAVX > 2
#line 20515 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI0]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, Repl32S_zero_evex_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI) &&
        (
#line 4599 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 32 && UseAVX > 2 && VM_Version::supports_avx512bw()
#line 20525 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, Repl32S_imm_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI) &&
        (
#line 4586 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 16 && UseAVX > 2 && VM_Version::supports_avx512vlbw()
#line 20539 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI]+100;
        DFA_PRODUCTION__SET_VALID(VECY, Repl16S_imm_evex_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI) &&
        (
#line 4573 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 8 && UseAVX > 2 && VM_Version::supports_avx512vlbw()
#line 20549 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI]+100;
        DFA_PRODUCTION__SET_VALID(VECX, Repl8S_imm_evex_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADS_MEMORY_) &&
        (
#line 4562 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 32 && UseAVX > 2 && VM_Version::supports_avx512bw()
#line 20559 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADS_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, Repl32S_mem_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) &&
        (
#line 4551 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 32 && UseAVX > 2 && VM_Version::supports_avx512bw()
#line 20573 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, Repl32S_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADS_MEMORY_) &&
        (
#line 4540 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 16 && UseAVX > 2 && VM_Version::supports_avx512vlbw()
#line 20587 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADS_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, Repl16S_mem_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) &&
        (
#line 4529 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 16 && UseAVX > 2 && VM_Version::supports_avx512vlbw()
#line 20601 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, Repl16S_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADS_MEMORY_) &&
        (
#line 4518 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 8 && UseAVX > 2 && VM_Version::supports_avx512vlbw()
#line 20615 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADS_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, Repl8S_mem_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) &&
        (
#line 4507 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 8 && UseAVX > 2 && VM_Version::supports_avx512vlbw()
#line 20629 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, Repl8S_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADS_MEMORY_) &&
        (
#line 4496 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 4 && UseAVX > 2 && VM_Version::supports_avx512vlbw()
#line 20643 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADS_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECD, Repl4S_mem_evex_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) &&
        (
#line 4485 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 4 && UseAVX > 2 && VM_Version::supports_avx512vlbw()
#line 20653 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, Repl4S_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI0) &&
        (
#line 4162 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 16
#line 20667 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI0]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, Repl16S_zero_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI0) &&
        (
#line 4152 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 8
#line 20681 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI0]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, Repl8S_zero_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI0) &&
        (
#line 4142 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 4
#line 20695 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI0]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, Repl4S_zero_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI0) &&
        (
#line 4132 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 2
#line 20709 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI0]+100;
        DFA_PRODUCTION__SET_VALID(VECS, Repl2S_zero_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI) &&
        (
#line 4121 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 4
#line 20719 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, Repl4S_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI) &&
        (
#line 4111 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 2
#line 20733 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI]+100;
      if (STATE__NOT_YET_VALID(VECS) || _cost[VECS] > c) {
        DFA_PRODUCTION__SET_VALID(VECS, Repl2S_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECS) || _cost[LEGVECS] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) &&
        (
#line 4098 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 2
#line 20747 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(VECS) || _cost[VECS] > c) {
        DFA_PRODUCTION__SET_VALID(VECS, Repl2S_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECS) || _cost[LEGVECS] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECS, MoveVecS2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI) &&
        (
#line 3533 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 32 && !VM_Version::supports_avx512vlbw()
#line 20761 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI]+100;
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, Repl32S_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(VECZ, MoveLeg2VecZ_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADS_MEMORY_) &&
        (
#line 3517 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 32 && !VM_Version::supports_avx512vlbw()
#line 20775 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADS_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, Repl32S_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(VECZ, MoveLeg2VecZ_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) &&
        (
#line 3499 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 32 && !VM_Version::supports_avx512vlbw()
#line 20789 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, Repl32S_rule, c)
      }
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(VECZ, MoveLeg2VecZ_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI) &&
        (
#line 3485 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 16 && !VM_Version::supports_avx512vlbw()
#line 20803 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, Repl16S_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADS_MEMORY_) &&
        (
#line 3471 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 16 && !VM_Version::supports_avx512vlbw()
#line 20817 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADS_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, Repl16S_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) &&
        (
#line 3455 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 16 && !VM_Version::supports_avx512vlbw()
#line 20831 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, Repl16S_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI) &&
        (
#line 3443 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 8 && !VM_Version::supports_avx512vlbw()
#line 20845 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, Repl8S_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADS_MEMORY_) &&
        (
#line 3431 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 8 && UseAVX > 0 && !VM_Version::supports_avx512vlbw()
#line 20859 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADS_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, Repl8S_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) &&
        (
#line 3417 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 8 && !VM_Version::supports_avx512vlbw()
#line 20873 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, Repl8S_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADS_MEMORY_) &&
        (
#line 3407 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 4 && UseAVX > 0 && !VM_Version::supports_avx512vlbw()
#line 20887 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADS_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, Repl4S_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) &&
        (
#line 3395 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 4 && !VM_Version::supports_avx512vlbw()
#line 20901 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, Repl4S_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
}
void  State::_sub_Op_ReplicateI(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], IMMI0) &&
        (
#line 4729 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 16 && UseAVX > 2
#line 20917 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI0]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, Repl16I_zero_evex_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI) &&
        (
#line 4716 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 16 && UseAVX > 2
#line 20927 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, Repl16I_imm_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI) &&
        (
#line 4703 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 8 && UseAVX > 2 && VM_Version::supports_avx512vl()
#line 20941 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI]+100;
        DFA_PRODUCTION__SET_VALID(VECY, Repl8I_imm_evex_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI) &&
        (
#line 4690 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 4 && UseAVX > 2 && VM_Version::supports_avx512vl()
#line 20951 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI]+100;
        DFA_PRODUCTION__SET_VALID(VECX, Repl4I_imm_evex_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) &&
        (
#line 4679 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 16 && UseAVX > 2
#line 20961 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, Repl16I_mem_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) &&
        (
#line 4668 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 16 && UseAVX > 2
#line 20975 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, Repl16I_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) &&
        (
#line 4657 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 8 && UseAVX > 2 && VM_Version::supports_avx512vl()
#line 20989 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, Repl8I_mem_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) &&
        (
#line 4646 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 8 && UseAVX > 2 && VM_Version::supports_avx512vl()
#line 21003 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, Repl8I_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) &&
        (
#line 4635 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 4 && UseAVX > 2 && VM_Version::supports_avx512vl()
#line 21017 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, Repl4I_mem_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) &&
        (
#line 4624 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 4 && UseAVX > 2 && VM_Version::supports_avx512vl()
#line 21031 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, Repl4I_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI0) &&
        (
#line 4232 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 8
#line 21045 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI0]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, Repl8I_zero_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI0) &&
        (
#line 4222 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 4
#line 21059 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI0]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, Repl4I_zero_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI0) &&
        (
#line 4212 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 2
#line 21073 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI0]+100;
        DFA_PRODUCTION__SET_VALID(VECD, Repl2I_zero_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI) &&
        (
#line 4201 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 2
#line 21083 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, Repl2I_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) &&
        (
#line 4188 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 2
#line 21097 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, Repl2I_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) &&
        (
#line 4175 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 2
#line 21111 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, Repl2I_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI) &&
        (
#line 3653 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 16 && !VM_Version::supports_avx512vl()
#line 21125 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI]+100;
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, Repl16I_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(VECZ, MoveLeg2VecZ_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI) &&
        (
#line 3639 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 8 && !VM_Version::supports_avx512vl()
#line 21139 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, Repl8I_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMMI) &&
        (
#line 3627 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 4 && !VM_Version::supports_avx512vl()
#line 21153 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMI]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, Repl4I_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) &&
        (
#line 3613 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 16 && !VM_Version::supports_avx512vl()
#line 21167 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, Repl16I_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(VECZ, MoveLeg2VecZ_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) &&
        (
#line 3597 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 16 && !VM_Version::supports_avx512vl()
#line 21181 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, Repl16I_rule, c)
      }
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(VECZ, MoveLeg2VecZ_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) &&
        (
#line 3585 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 8 && !VM_Version::supports_avx512vl()
#line 21195 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, Repl8I_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) &&
        (
#line 3571 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 8 && !VM_Version::supports_avx512vl()
#line 21209 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, Repl8I_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADI_MEMORY_) &&
        (
#line 3561 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 4 && UseAVX > 0 && !VM_Version::supports_avx512vl()
#line 21223 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADI_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, Repl4I_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGI) &&
        (
#line 3549 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 4 && !VM_Version::supports_avx512vl()
#line 21237 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGI]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, Repl4I_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
}
void  State::_sub_Op_ReplicateL(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], IMML0) &&
        (
#line 4861 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 8 && UseAVX > 2
#line 21253 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMML0]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, Repl8L_zero_evex_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) &&
        (
#line 4850 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 8 && UseAVX > 2
#line 21263 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, Repl8L_mem_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) &&
        (
#line 4839 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 4 && UseAVX > 2 && VM_Version::supports_avx512vl()
#line 21277 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECY, Repl4L_mem_evex_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) &&
        (
#line 4828 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 2 && UseAVX > 2 && VM_Version::supports_avx512vl()
#line 21287 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECX, Repl2L_mem_evex_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], IMML) &&
        (
#line 4815 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 8 && UseAVX > 2
#line 21297 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMML]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, Repl8L_imm_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMML) &&
        (
#line 4802 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 4 && UseAVX > 2 && VM_Version::supports_avx512vl()
#line 21311 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMML]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, Repl4L_imm_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) &&
        (
#line 4754 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 8 && UseAVX > 2
#line 21325 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, Repl8L_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) &&
        (
#line 4743 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 4 && UseAVX > 2 && VM_Version::supports_avx512vl()
#line 21339 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, Repl4L_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMML0) &&
        (
#line 4300 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 4
#line 21353 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMML0]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, Repl4L_zero_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMML0) &&
        (
#line 4290 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 2
#line 21367 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMML0]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, Repl2L_zero_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMML) &&
        (
#line 4277 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 2
#line 21381 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMML]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, Repl2L_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) &&
        (
#line 4246 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 2
#line 21395 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, Repl2L_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) &&
        (
#line 3799 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 8 && !VM_Version::supports_avx512vl()
#line 21409 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, Repl8L_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(VECZ, MoveLeg2VecZ_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) &&
        (
#line 3785 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 4 && !VM_Version::supports_avx512vl()
#line 21423 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, Repl4L_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMML) &&
        (
#line 3769 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 8 && !VM_Version::supports_avx512vl()
#line 21437 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMML]+100;
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, Repl8L_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(VECZ, MoveLeg2VecZ_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMML) &&
        (
#line 3755 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 4 && !VM_Version::supports_avx512vl()
#line 21451 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMML]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, Repl4L_imm_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) &&
        (
#line 3698 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 8 && !VM_Version::supports_avx512vl()
#line 21465 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+100;
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, Repl8L_rule, c)
      }
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(VECZ, MoveLeg2VecZ_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], RREGL) &&
        (
#line 3684 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 4 && !VM_Version::supports_avx512vl()
#line 21479 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[RREGL]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, Repl4L_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADL_MEMORY_) &&
        (
#line 3670 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 2 && !VM_Version::supports_avx512vlbw()
#line 21493 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADL_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, Repl2L_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
}
void  State::_sub_Op_ReplicateF(const Node *n){
    if( STATE__VALID_CHILD(_kids[0], IMMF0) &&
        (
#line 4917 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 16 && UseAVX > 2
#line 21509 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMF0]+100;
        DFA_PRODUCTION__SET_VALID(VECZ, Repl16F_zero_evex_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADF_MEMORY_) &&
        (
#line 4906 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 16 && UseAVX > 2
#line 21519 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADF_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, Repl16F_mem_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) &&
        (
#line 4895 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 16 && UseAVX > 2
#line 21533 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+100;
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c) {
        DFA_PRODUCTION__SET_VALID(VECZ, Repl16F_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, MoveVecZ2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADF_MEMORY_) &&
        (
#line 4884 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 8 && UseAVX > 2 && VM_Version::supports_avx512vl()
#line 21547 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADF_MEMORY_]+100;
        DFA_PRODUCTION__SET_VALID(VECY, Repl8F_mem_evex_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], REGF) &&
        (
#line 4873 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 8 && UseAVX > 2 && VM_Version::supports_avx512vl()
#line 21557 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[REGF]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, Repl8F_evex_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VLREGF) &&
        (
#line 4323 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 4
#line 21571 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VLREGF]+100;
        DFA_PRODUCTION__SET_VALID(VECX, Repl4F_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], VLREGF) &&
        (
#line 4313 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 2
#line 21581 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VLREGF]+100;
        DFA_PRODUCTION__SET_VALID(VECD, Repl2F_rule, c)
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
    }
    if( STATE__VALID_CHILD(_kids[0], IMMF0) &&
        (
#line 3907 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 8 && UseAVX > 0
#line 21591 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMF0]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, Repl8F_zero_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMMF0) &&
        (
#line 3897 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 4
#line 21605 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMF0]+100;
      if (STATE__NOT_YET_VALID(VECX) || _cost[VECX] > c) {
        DFA_PRODUCTION__SET_VALID(VECX, Repl4F_zero_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECX) || _cost[LEGVECX] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECX, MoveVecX2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], IMMF0) &&
        (
#line 3887 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 2
#line 21619 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[IMMF0]+100;
      if (STATE__NOT_YET_VALID(VECD) || _cost[VECD] > c) {
        DFA_PRODUCTION__SET_VALID(VECD, Repl2F_zero_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECD) || _cost[LEGVECD] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECD, MoveVecD2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADF_MEMORY_) &&
        (
#line 3873 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 16 && !VM_Version::supports_avx512vl()
#line 21633 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADF_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, Repl16F_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(VECZ, MoveLeg2VecZ_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VLREGF) &&
        (
#line 3859 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 16 && UseAVX > 0 && !VM_Version::supports_avx512vl()
#line 21647 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VLREGF]+100;
      if (STATE__NOT_YET_VALID(LEGVECZ) || _cost[LEGVECZ] > c) {
        DFA_PRODUCTION__SET_VALID(LEGVECZ, Repl16F_rule, c)
      }
      if (STATE__NOT_YET_VALID(VECZ) || _cost[VECZ] > c+100) {
        DFA_PRODUCTION__SET_VALID(VECZ, MoveLeg2VecZ_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADF_MEMORY_) &&
        (
#line 3847 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 8 && !VM_Version::supports_avx512vl()
#line 21661 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[_LOADF_MEMORY_]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, Repl8F_mem_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], VLREGF) &&
        (
#line 3835 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 8 && UseAVX > 0 && !VM_Version::supports_avx512vl()
#line 21675 "dfa_x86.cpp"
) ) {
      unsigned int c = _kids[0]->_cost[VLREGF]+100;
      if (STATE__NOT_YET_VALID(VECY) || _cost[VECY] > c) {
        DFA_PRODUCTION__SET_VALID(VECY, Repl8F_rule, c)
      }
      if (STATE__NOT_YET_VALID(LEGVECY) || _cost[LEGVECY] > c+100) {
        DFA_PRODUCTION__SET_VALID(LEGVECY, MoveVecY2Leg_rule, c+100)
      }
    }
    if( STATE__VALID_CHILD(_kids[0], _LOADF_MEMORY_) &&
        (
#line 3825 "src/hotspot/cpu/x86/x86.ad"
n->as_Vector()->length() == 4 && UseAVX > 0 && !VM_Ver