// Copyright 2018 Istio Authors
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        (unknown)
// source: mcp/v1alpha1/metadata.proto

// $mode: none

package v1alpha1

import (
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Metadata information that all resources within the Mesh Configuration Protocol must have.
type Metadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Fully qualified name of the resource. Unique in context of a collection.
	//
	// The fully qualified name consists of a directory and basename. The directory identifies
	// the resources location in a resource hierarchy. The basename identifies the specific
	// resource name within the context of that directory.
	//
	// The directory and basename are composed of one or more segments. Segments must be
	// valid [DNS labels](https://tools.ietf.org/html/rfc1123). "/" is the delimiter between
	// segments
	//
	// The rightmost segment is the basename. All segments to the
	// left of the basename form the directory. Segments moving towards the left
	// represent higher positions in the resource hierarchy, similar to reverse
	// DNS notation. e.g.
	//
	//	/<org>/<team>/<subteam>/<resource basename>
	//
	// An empty directory indicates a resource that is located at the root of the
	// hierarchy, e.g.
	//
	//	/<globally scoped resource>
	//
	// On Kubernetes the resource hierarchy is two-levels: namespaces and
	// cluster-scoped (i.e. global).
	//
	// Namespace resources fully qualified name is of the form:
	//
	//	"<k8s namespace>/<k8s resource name>"
	//
	// Cluster scoped resources are located at the root of the hierarchy and are of the form:
	//
	//	"/<k8s resource name>"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The creation timestamp of the resource.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Resource version. This is used to determine when resources change across
	// resource updates. It should be treated as opaque by consumers/sinks.
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
	// Map of string keys and values that can be used to organize and categorize
	// resources within a collection.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Map of string keys and values that can be used by source and sink to communicate
	// arbitrary metadata about this resource.
	Annotations   map[string]string `protobuf:"bytes,5,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Metadata) Reset() {
	*x = Metadata{}
	mi := &file_mcp_v1alpha1_metadata_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Metadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Metadata) ProtoMessage() {}

func (x *Metadata) ProtoReflect() protoreflect.Message {
	mi := &file_mcp_v1alpha1_metadata_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Metadata.ProtoReflect.Descriptor instead.
func (*Metadata) Descriptor() ([]byte, []int) {
	return file_mcp_v1alpha1_metadata_proto_rawDescGZIP(), []int{0}
}

func (x *Metadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Metadata) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Metadata) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *Metadata) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Metadata) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

var File_mcp_v1alpha1_metadata_proto protoreflect.FileDescriptor

const file_mcp_v1alpha1_metadata_proto_rawDesc = "" +
	"\n" +
	"\x1bmcp/v1alpha1/metadata.proto\x12\x12istio.mcp.v1alpha1\x1a\x1fgoogle/protobuf/timestamp.proto\"\x83\x03\n" +
	"\bMetadata\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12;\n" +
	"\vcreate_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\n" +
	"createTime\x12\x18\n" +
	"\aversion\x18\x03 \x01(\tR\aversion\x12@\n" +
	"\x06labels\x18\x04 \x03(\v2(.istio.mcp.v1alpha1.Metadata.LabelsEntryR\x06labels\x12O\n" +
	"\vannotations\x18\x05 \x03(\v2-.istio.mcp.v1alpha1.Metadata.AnnotationsEntryR\vannotations\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\x1a>\n" +
	"\x10AnnotationsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01B\x1bZ\x19istio.io/api/mcp/v1alpha1b\x06proto3"

var (
	file_mcp_v1alpha1_metadata_proto_rawDescOnce sync.Once
	file_mcp_v1alpha1_metadata_proto_rawDescData []byte
)

func file_mcp_v1alpha1_metadata_proto_rawDescGZIP() []byte {
	file_mcp_v1alpha1_metadata_proto_rawDescOnce.Do(func() {
		file_mcp_v1alpha1_metadata_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_mcp_v1alpha1_metadata_proto_rawDesc), len(file_mcp_v1alpha1_metadata_proto_rawDesc)))
	})
	return file_mcp_v1alpha1_metadata_proto_rawDescData
}

var file_mcp_v1alpha1_metadata_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_mcp_v1alpha1_metadata_proto_goTypes = []any{
	(*Metadata)(nil),            // 0: istio.mcp.v1alpha1.Metadata
	nil,                         // 1: istio.mcp.v1alpha1.Metadata.LabelsEntry
	nil,                         // 2: istio.mcp.v1alpha1.Metadata.AnnotationsEntry
	(*timestamp.Timestamp)(nil), // 3: google.protobuf.Timestamp
}
var file_mcp_v1alpha1_metadata_proto_depIdxs = []int32{
	3, // 0: istio.mcp.v1alpha1.Metadata.create_time:type_name -> google.protobuf.Timestamp
	1, // 1: istio.mcp.v1alpha1.Metadata.labels:type_name -> istio.mcp.v1alpha1.Metadata.LabelsEntry
	2, // 2: istio.mcp.v1alpha1.Metadata.annotations:type_name -> istio.mcp.v1alpha1.Metadata.AnnotationsEntry
	3, // [3:3] is the sub-list for method output_type
	3, // [3:3] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_mcp_v1alpha1_metadata_proto_init() }
func file_mcp_v1alpha1_metadata_proto_init() {
	if File_mcp_v1alpha1_metadata_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_mcp_v1alpha1_metadata_proto_rawDesc), len(file_mcp_v1alpha1_metadata_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_mcp_v1alpha1_metadata_proto_goTypes,
		DependencyIndexes: file_mcp_v1alpha1_metadata_proto_depIdxs,
		MessageInfos:      file_mcp_v1alpha1_metadata_proto_msgTypes,
	}.Build()
	File_mcp_v1alpha1_metadata_proto = out.File
	file_mcp_v1alpha1_metadata_proto_goTypes = nil
	file_mcp_v1alpha1_metadata_proto_depIdxs = nil
}
