{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @PangoAttrIterator@ is used to iterate through a @PangoAttrList@.
-- 
-- A new iterator is created with 'GI.Pango.Structs.AttrList.attrListGetIterator'.
-- Once the iterator is created, it can be advanced through the style
-- changes in the text using 'GI.Pango.Structs.AttrIterator.attrIteratorNext'. At each
-- style change, the range of the current style segment and the attributes
-- currently in effect can be queried.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Structs.AttrIterator
    ( 

-- * Exported types
    AttrIterator(..)                        ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [copy]("GI.Pango.Structs.AttrIterator#g:method:copy"), [destroy]("GI.Pango.Structs.AttrIterator#g:method:destroy"), [get]("GI.Pango.Structs.AttrIterator#g:method:get"), [next]("GI.Pango.Structs.AttrIterator#g:method:next"), [range]("GI.Pango.Structs.AttrIterator#g:method:range").
-- 
-- ==== Getters
-- [getAttrs]("GI.Pango.Structs.AttrIterator#g:method:getAttrs"), [getFont]("GI.Pango.Structs.AttrIterator#g:method:getFont").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveAttrIteratorMethod               ,
#endif

-- ** copy #method:copy#

#if defined(ENABLE_OVERLOADING)
    AttrIteratorCopyMethodInfo              ,
#endif
    attrIteratorCopy                        ,


-- ** destroy #method:destroy#

#if defined(ENABLE_OVERLOADING)
    AttrIteratorDestroyMethodInfo           ,
#endif
    attrIteratorDestroy                     ,


-- ** get #method:get#

#if defined(ENABLE_OVERLOADING)
    AttrIteratorGetMethodInfo               ,
#endif
    attrIteratorGet                         ,


-- ** getAttrs #method:getAttrs#

#if defined(ENABLE_OVERLOADING)
    AttrIteratorGetAttrsMethodInfo          ,
#endif
    attrIteratorGetAttrs                    ,


-- ** getFont #method:getFont#

#if defined(ENABLE_OVERLOADING)
    AttrIteratorGetFontMethodInfo           ,
#endif
    attrIteratorGetFont                     ,


-- ** next #method:next#

#if defined(ENABLE_OVERLOADING)
    AttrIteratorNextMethodInfo              ,
#endif
    attrIteratorNext                        ,


-- ** range #method:range#

#if defined(ENABLE_OVERLOADING)
    AttrIteratorRangeMethodInfo             ,
#endif
    attrIteratorRange                       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.Pango.Callbacks as Pango.Callbacks
import {-# SOURCE #-} qualified GI.Pango.Enums as Pango.Enums
import {-# SOURCE #-} qualified GI.Pango.Flags as Pango.Flags
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrClass as Pango.AttrClass
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrColor as Pango.AttrColor
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFloat as Pango.AttrFloat
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFontDesc as Pango.AttrFontDesc
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFontFeatures as Pango.AttrFontFeatures
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrInt as Pango.AttrInt
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrLanguage as Pango.AttrLanguage
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrShape as Pango.AttrShape
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrSize as Pango.AttrSize
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrString as Pango.AttrString
import {-# SOURCE #-} qualified GI.Pango.Structs.Attribute as Pango.Attribute
import {-# SOURCE #-} qualified GI.Pango.Structs.Color as Pango.Color
import {-# SOURCE #-} qualified GI.Pango.Structs.FontDescription as Pango.FontDescription
import {-# SOURCE #-} qualified GI.Pango.Structs.Language as Pango.Language
import {-# SOURCE #-} qualified GI.Pango.Structs.Rectangle as Pango.Rectangle

#else
import {-# SOURCE #-} qualified GI.Pango.Enums as Pango.Enums
import {-# SOURCE #-} qualified GI.Pango.Structs.Attribute as Pango.Attribute
import {-# SOURCE #-} qualified GI.Pango.Structs.FontDescription as Pango.FontDescription
import {-# SOURCE #-} qualified GI.Pango.Structs.Language as Pango.Language

#endif

-- | Memory-managed wrapper type.
newtype AttrIterator = AttrIterator (SP.ManagedPtr AttrIterator)
    deriving (Eq)

instance SP.ManagedPtrNewtype AttrIterator where
    toManagedPtr (AttrIterator p) = p

foreign import ccall "pango_attr_iterator_get_type" c_pango_attr_iterator_get_type :: 
    IO GType

type instance O.ParentTypes AttrIterator = '[]
instance O.HasParentTypes AttrIterator

instance B.Types.TypedObject AttrIterator where
    glibType = c_pango_attr_iterator_get_type

instance B.Types.GBoxed AttrIterator

-- | Convert t'AttrIterator' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe AttrIterator) where
    gvalueGType_ = c_pango_attr_iterator_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr AttrIterator)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr AttrIterator)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed AttrIterator ptr
        else return P.Nothing
        
    


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList AttrIterator
type instance O.AttributeList AttrIterator = AttrIteratorAttributeList
type AttrIteratorAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method AttrIterator::copy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iterator"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "AttrIterator" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoAttrIterator`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Pango" , name = "AttrIterator" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_attr_iterator_copy" pango_attr_iterator_copy :: 
    Ptr AttrIterator ->                     -- iterator : TInterface (Name {namespace = "Pango", name = "AttrIterator"})
    IO (Ptr AttrIterator)

-- | Copy a @PangoAttrIterator@.
attrIteratorCopy ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    AttrIterator
    -- ^ /@iterator@/: a @PangoAttrIterator@
    -> m AttrIterator
    -- ^ __Returns:__ the newly allocated
    --   @PangoAttrIterator@, which should be freed with
    --   'GI.Pango.Structs.AttrIterator.attrIteratorDestroy'
attrIteratorCopy iterator = liftIO $ do
    iterator' <- unsafeManagedPtrGetPtr iterator
    result <- pango_attr_iterator_copy iterator'
    checkUnexpectedReturnNULL "attrIteratorCopy" result
    result' <- (wrapBoxed AttrIterator) result
    touchManagedPtr iterator
    return result'

#if defined(ENABLE_OVERLOADING)
data AttrIteratorCopyMethodInfo
instance (signature ~ (m AttrIterator), MonadIO m) => O.OverloadedMethod AttrIteratorCopyMethodInfo AttrIterator signature where
    overloadedMethod = attrIteratorCopy

instance O.OverloadedMethodInfo AttrIteratorCopyMethodInfo AttrIterator where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.AttrIterator.attrIteratorCopy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-AttrIterator.html#v:attrIteratorCopy"
        })


#endif

-- method AttrIterator::destroy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iterator"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "AttrIterator" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoAttrIterator`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_attr_iterator_destroy" pango_attr_iterator_destroy :: 
    Ptr AttrIterator ->                     -- iterator : TInterface (Name {namespace = "Pango", name = "AttrIterator"})
    IO ()

-- | Destroy a @PangoAttrIterator@ and free all associated memory.
attrIteratorDestroy ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    AttrIterator
    -- ^ /@iterator@/: a @PangoAttrIterator@
    -> m ()
attrIteratorDestroy iterator = liftIO $ do
    iterator' <- unsafeManagedPtrGetPtr iterator
    pango_attr_iterator_destroy iterator'
    touchManagedPtr iterator
    return ()

#if defined(ENABLE_OVERLOADING)
data AttrIteratorDestroyMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod AttrIteratorDestroyMethodInfo AttrIterator signature where
    overloadedMethod = attrIteratorDestroy

instance O.OverloadedMethodInfo AttrIteratorDestroyMethodInfo AttrIterator where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.AttrIterator.attrIteratorDestroy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-AttrIterator.html#v:attrIteratorDestroy"
        })


#endif

-- method AttrIterator::get
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iterator"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "AttrIterator" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoAttrIterator`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "type"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "AttrType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the type of attribute to find"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Attribute" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_attr_iterator_get" pango_attr_iterator_get :: 
    Ptr AttrIterator ->                     -- iterator : TInterface (Name {namespace = "Pango", name = "AttrIterator"})
    CUInt ->                                -- type : TInterface (Name {namespace = "Pango", name = "AttrType"})
    IO (Ptr Pango.Attribute.Attribute)

-- | Find the current attribute of a particular type
-- at the iterator location.
-- 
-- When multiple attributes of the same type overlap,
-- the attribute whose range starts closest to the
-- current location is used.
attrIteratorGet ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    AttrIterator
    -- ^ /@iterator@/: a @PangoAttrIterator@
    -> Pango.Enums.AttrType
    -- ^ /@type@/: the type of attribute to find
    -> m (Maybe Pango.Attribute.Attribute)
    -- ^ __Returns:__ the current
    --   attribute of the given type, or 'P.Nothing' if no attribute
    --   of that type applies to the current location.
attrIteratorGet iterator type_ = liftIO $ do
    iterator' <- unsafeManagedPtrGetPtr iterator
    let type_' = (fromIntegral . fromEnum) type_
    result <- pango_attr_iterator_get iterator' type_'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newBoxed Pango.Attribute.Attribute) result'
        return result''
    touchManagedPtr iterator
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data AttrIteratorGetMethodInfo
instance (signature ~ (Pango.Enums.AttrType -> m (Maybe Pango.Attribute.Attribute)), MonadIO m) => O.OverloadedMethod AttrIteratorGetMethodInfo AttrIterator signature where
    overloadedMethod = attrIteratorGet

instance O.OverloadedMethodInfo AttrIteratorGetMethodInfo AttrIterator where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.AttrIterator.attrIteratorGet",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-AttrIterator.html#v:attrIteratorGet"
        })


#endif

-- method AttrIterator::get_attrs
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iterator"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "AttrIterator" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoAttrIterator`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGSList
--                  (TInterface Name { namespace = "Pango" , name = "Attribute" }))
-- throws : False
-- Skip return : False

foreign import ccall "pango_attr_iterator_get_attrs" pango_attr_iterator_get_attrs :: 
    Ptr AttrIterator ->                     -- iterator : TInterface (Name {namespace = "Pango", name = "AttrIterator"})
    IO (Ptr (GSList (Ptr Pango.Attribute.Attribute)))

-- | Gets a list of all attributes at the current position of the
-- iterator.
-- 
-- /Since: 1.2/
attrIteratorGetAttrs ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    AttrIterator
    -- ^ /@iterator@/: a @PangoAttrIterator@
    -> m [Pango.Attribute.Attribute]
    -- ^ __Returns:__ 
    --   a list of all attributes for the current range. To free
    --   this value, call 'GI.Pango.Structs.Attribute.attributeDestroy' on each
    --   value and @/g_slist_free()/@ on the list.
attrIteratorGetAttrs iterator = liftIO $ do
    iterator' <- unsafeManagedPtrGetPtr iterator
    result <- pango_attr_iterator_get_attrs iterator'
    result' <- unpackGSList result
    result'' <- mapM (wrapBoxed Pango.Attribute.Attribute) result'
    g_slist_free result
    touchManagedPtr iterator
    return result''

#if defined(ENABLE_OVERLOADING)
data AttrIteratorGetAttrsMethodInfo
instance (signature ~ (m [Pango.Attribute.Attribute]), MonadIO m) => O.OverloadedMethod AttrIteratorGetAttrsMethodInfo AttrIterator signature where
    overloadedMethod = attrIteratorGetAttrs

instance O.OverloadedMethodInfo AttrIteratorGetAttrsMethodInfo AttrIterator where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.AttrIterator.attrIteratorGetAttrs",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-AttrIterator.html#v:attrIteratorGetAttrs"
        })


#endif

-- method AttrIterator::get_font
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iterator"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "AttrIterator" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoAttrIterator`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a `PangoFontDescription` to fill in with the current\n  values. The family name in this structure will be set using\n  [method@Pango.FontDescription.set_family_static] using\n  values from an attribute in the `PangoAttrList` associated\n  with the iterator, so if you plan to keep it around, you\n  must call:\n  `pango_font_description_set_family (desc, pango_font_description_get_family (desc))`."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "language"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Language" }
--           , direction = DirectionOut
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store language tag\n  for item, or %NULL if none is found."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "extra_attrs"
--           , argType =
--               TGSList
--                 (TInterface Name { namespace = "Pango" , name = "Attribute" })
--           , direction = DirectionOut
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "\n  location in which to store a list of non-font attributes\n  at the the current position; only the highest priority\n  value of each attribute will be added to this list. In\n  order to free this value, you must call\n  [method@Pango.Attribute.destroy] on each member."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_attr_iterator_get_font" pango_attr_iterator_get_font :: 
    Ptr AttrIterator ->                     -- iterator : TInterface (Name {namespace = "Pango", name = "AttrIterator"})
    Ptr Pango.FontDescription.FontDescription -> -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    Ptr (Ptr Pango.Language.Language) ->    -- language : TInterface (Name {namespace = "Pango", name = "Language"})
    Ptr (Ptr (GSList (Ptr Pango.Attribute.Attribute))) -> -- extra_attrs : TGSList (TInterface (Name {namespace = "Pango", name = "Attribute"}))
    IO ()

-- | Get the font and other attributes at the current
-- iterator position.
attrIteratorGetFont ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    AttrIterator
    -- ^ /@iterator@/: a @PangoAttrIterator@
    -> Pango.FontDescription.FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@ to fill in with the current
    --   values. The family name in this structure will be set using
    --   'GI.Pango.Structs.FontDescription.fontDescriptionSetFamilyStatic' using
    --   values from an attribute in the @PangoAttrList@ associated
    --   with the iterator, so if you plan to keep it around, you
    --   must call:
    --   @pango_font_description_set_family (desc, pango_font_description_get_family (desc))@.
    -> m ((Maybe Pango.Language.Language, [Pango.Attribute.Attribute]))
attrIteratorGetFont iterator desc = liftIO $ do
    iterator' <- unsafeManagedPtrGetPtr iterator
    desc' <- unsafeManagedPtrGetPtr desc
    language <- callocMem :: IO (Ptr (Ptr Pango.Language.Language))
    extraAttrs <- callocMem :: IO (Ptr (Ptr (GSList (Ptr Pango.Attribute.Attribute))))
    pango_attr_iterator_get_font iterator' desc' language extraAttrs
    language' <- peek language
    maybeLanguage' <- convertIfNonNull language' $ \language'' -> do
        language''' <- (wrapBoxed Pango.Language.Language) language''
        return language'''
    extraAttrs' <- peek extraAttrs
    extraAttrs'' <- unpackGSList extraAttrs'
    extraAttrs''' <- mapM (wrapBoxed Pango.Attribute.Attribute) extraAttrs''
    g_slist_free extraAttrs'
    touchManagedPtr iterator
    touchManagedPtr desc
    freeMem language
    freeMem extraAttrs
    return (maybeLanguage', extraAttrs''')

#if defined(ENABLE_OVERLOADING)
data AttrIteratorGetFontMethodInfo
instance (signature ~ (Pango.FontDescription.FontDescription -> m ((Maybe Pango.Language.Language, [Pango.Attribute.Attribute]))), MonadIO m) => O.OverloadedMethod AttrIteratorGetFontMethodInfo AttrIterator signature where
    overloadedMethod = attrIteratorGetFont

instance O.OverloadedMethodInfo AttrIteratorGetFontMethodInfo AttrIterator where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.AttrIterator.attrIteratorGetFont",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-AttrIterator.html#v:attrIteratorGetFont"
        })


#endif

-- method AttrIterator::next
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iterator"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "AttrIterator" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoAttrIterator`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "pango_attr_iterator_next" pango_attr_iterator_next :: 
    Ptr AttrIterator ->                     -- iterator : TInterface (Name {namespace = "Pango", name = "AttrIterator"})
    IO CInt

-- | Advance the iterator until the next change of style.
attrIteratorNext ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    AttrIterator
    -- ^ /@iterator@/: a @PangoAttrIterator@
    -> m Bool
    -- ^ __Returns:__ 'P.False' if the iterator is at the end
    --   of the list, otherwise 'P.True'
attrIteratorNext iterator = liftIO $ do
    iterator' <- unsafeManagedPtrGetPtr iterator
    result <- pango_attr_iterator_next iterator'
    let result' = (/= 0) result
    touchManagedPtr iterator
    return result'

#if defined(ENABLE_OVERLOADING)
data AttrIteratorNextMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod AttrIteratorNextMethodInfo AttrIterator signature where
    overloadedMethod = attrIteratorNext

instance O.OverloadedMethodInfo AttrIteratorNextMethodInfo AttrIterator where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.AttrIterator.attrIteratorNext",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-AttrIterator.html#v:attrIteratorNext"
        })


#endif

-- method AttrIterator::range
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iterator"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "AttrIterator" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a PangoAttrIterator"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "start"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store the start of the range"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "end"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store the end of the range"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_attr_iterator_range" pango_attr_iterator_range :: 
    Ptr AttrIterator ->                     -- iterator : TInterface (Name {namespace = "Pango", name = "AttrIterator"})
    Ptr Int32 ->                            -- start : TBasicType TInt
    Ptr Int32 ->                            -- end : TBasicType TInt
    IO ()

-- | Get the range of the current segment.
-- 
-- Note that the stored return values are signed, not unsigned
-- like the values in @PangoAttribute@. To deal with this API
-- oversight, stored return values that wouldn\'t fit into
-- a signed integer are clamped to @/G_MAXINT/@.
attrIteratorRange ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    AttrIterator
    -- ^ /@iterator@/: a PangoAttrIterator
    -> m ((Int32, Int32))
attrIteratorRange iterator = liftIO $ do
    iterator' <- unsafeManagedPtrGetPtr iterator
    start <- allocMem :: IO (Ptr Int32)
    end <- allocMem :: IO (Ptr Int32)
    pango_attr_iterator_range iterator' start end
    start' <- peek start
    end' <- peek end
    touchManagedPtr iterator
    freeMem start
    freeMem end
    return (start', end')

#if defined(ENABLE_OVERLOADING)
data AttrIteratorRangeMethodInfo
instance (signature ~ (m ((Int32, Int32))), MonadIO m) => O.OverloadedMethod AttrIteratorRangeMethodInfo AttrIterator signature where
    overloadedMethod = attrIteratorRange

instance O.OverloadedMethodInfo AttrIteratorRangeMethodInfo AttrIterator where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.AttrIterator.attrIteratorRange",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-AttrIterator.html#v:attrIteratorRange"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveAttrIteratorMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveAttrIteratorMethod "copy" o = AttrIteratorCopyMethodInfo
    ResolveAttrIteratorMethod "destroy" o = AttrIteratorDestroyMethodInfo
    ResolveAttrIteratorMethod "get" o = AttrIteratorGetMethodInfo
    ResolveAttrIteratorMethod "next" o = AttrIteratorNextMethodInfo
    ResolveAttrIteratorMethod "range" o = AttrIteratorRangeMethodInfo
    ResolveAttrIteratorMethod "getAttrs" o = AttrIteratorGetAttrsMethodInfo
    ResolveAttrIteratorMethod "getFont" o = AttrIteratorGetFontMethodInfo
    ResolveAttrIteratorMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveAttrIteratorMethod t AttrIterator, O.OverloadedMethod info AttrIterator p) => OL.IsLabel t (AttrIterator -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveAttrIteratorMethod t AttrIterator, O.OverloadedMethod info AttrIterator p, R.HasField t AttrIterator p) => R.HasField t AttrIterator p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveAttrIteratorMethod t AttrIterator, O.OverloadedMethodInfo info AttrIterator) => OL.IsLabel t (O.MethodProxy info AttrIterator) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


