{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Arranges children in a single row or column.
-- 
-- Whether it is a row or column depends on the value of its
-- [Orientable:orientation]("GI.Gtk.Interfaces.Orientable#g:attr:orientation") property. Within the other dimension
-- all children all allocated the same size. The @GtkBoxLayout@ will respect
-- the [Widget:halign]("GI.Gtk.Objects.Widget#g:attr:halign") and [Widget:valign]("GI.Gtk.Objects.Widget#g:attr:valign")
-- properties of each child widget.
-- 
-- If you want all children to be assigned the same size, you can use
-- the [BoxLayout:homogeneous]("GI.Gtk.Objects.BoxLayout#g:attr:homogeneous") property.
-- 
-- If you want to specify the amount of space placed between each child,
-- you can use the [BoxLayout:spacing]("GI.Gtk.Objects.BoxLayout#g:attr:spacing") property.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.BoxLayout
    ( 

-- * Exported types
    BoxLayout(..)                           ,
    IsBoxLayout                             ,
    toBoxLayout                             ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [allocate]("GI.Gtk.Objects.LayoutManager#g:method:allocate"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [layoutChanged]("GI.Gtk.Objects.LayoutManager#g:method:layoutChanged"), [measure]("GI.Gtk.Objects.LayoutManager#g:method:measure"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getBaselineChild]("GI.Gtk.Objects.BoxLayout#g:method:getBaselineChild"), [getBaselinePosition]("GI.Gtk.Objects.BoxLayout#g:method:getBaselinePosition"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getHomogeneous]("GI.Gtk.Objects.BoxLayout#g:method:getHomogeneous"), [getLayoutChild]("GI.Gtk.Objects.LayoutManager#g:method:getLayoutChild"), [getOrientation]("GI.Gtk.Interfaces.Orientable#g:method:getOrientation"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRequestMode]("GI.Gtk.Objects.LayoutManager#g:method:getRequestMode"), [getSpacing]("GI.Gtk.Objects.BoxLayout#g:method:getSpacing"), [getWidget]("GI.Gtk.Objects.LayoutManager#g:method:getWidget").
-- 
-- ==== Setters
-- [setBaselineChild]("GI.Gtk.Objects.BoxLayout#g:method:setBaselineChild"), [setBaselinePosition]("GI.Gtk.Objects.BoxLayout#g:method:setBaselinePosition"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setHomogeneous]("GI.Gtk.Objects.BoxLayout#g:method:setHomogeneous"), [setOrientation]("GI.Gtk.Interfaces.Orientable#g:method:setOrientation"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setSpacing]("GI.Gtk.Objects.BoxLayout#g:method:setSpacing").

#if defined(ENABLE_OVERLOADING)
    ResolveBoxLayoutMethod                  ,
#endif

-- ** getBaselineChild #method:getBaselineChild#

#if defined(ENABLE_OVERLOADING)
    BoxLayoutGetBaselineChildMethodInfo     ,
#endif
    boxLayoutGetBaselineChild               ,


-- ** getBaselinePosition #method:getBaselinePosition#

#if defined(ENABLE_OVERLOADING)
    BoxLayoutGetBaselinePositionMethodInfo  ,
#endif
    boxLayoutGetBaselinePosition            ,


-- ** getHomogeneous #method:getHomogeneous#

#if defined(ENABLE_OVERLOADING)
    BoxLayoutGetHomogeneousMethodInfo       ,
#endif
    boxLayoutGetHomogeneous                 ,


-- ** getSpacing #method:getSpacing#

#if defined(ENABLE_OVERLOADING)
    BoxLayoutGetSpacingMethodInfo           ,
#endif
    boxLayoutGetSpacing                     ,


-- ** new #method:new#

    boxLayoutNew                            ,


-- ** setBaselineChild #method:setBaselineChild#

#if defined(ENABLE_OVERLOADING)
    BoxLayoutSetBaselineChildMethodInfo     ,
#endif
    boxLayoutSetBaselineChild               ,


-- ** setBaselinePosition #method:setBaselinePosition#

#if defined(ENABLE_OVERLOADING)
    BoxLayoutSetBaselinePositionMethodInfo  ,
#endif
    boxLayoutSetBaselinePosition            ,


-- ** setHomogeneous #method:setHomogeneous#

#if defined(ENABLE_OVERLOADING)
    BoxLayoutSetHomogeneousMethodInfo       ,
#endif
    boxLayoutSetHomogeneous                 ,


-- ** setSpacing #method:setSpacing#

#if defined(ENABLE_OVERLOADING)
    BoxLayoutSetSpacingMethodInfo           ,
#endif
    boxLayoutSetSpacing                     ,




 -- * Properties


-- ** baselineChild #attr:baselineChild#
-- | The child that determines the baseline of the box
-- in vertical layout.
-- 
-- If the child does baseline positioning, then its baseline
-- is lined up with the baseline of the box. If it doesn\'t, then
-- the bottom edge of the child is used.
-- 
-- /Since: 4.12/

#if defined(ENABLE_OVERLOADING)
    BoxLayoutBaselineChildPropertyInfo      ,
#endif
#if defined(ENABLE_OVERLOADING)
    boxLayoutBaselineChild                  ,
#endif
    constructBoxLayoutBaselineChild         ,
    getBoxLayoutBaselineChild               ,
    setBoxLayoutBaselineChild               ,


-- ** baselinePosition #attr:baselinePosition#
-- | The position of the allocated baseline within the extra space
-- allocated to each child.
-- 
-- This property is only relevant for horizontal layouts containing
-- at least one child with a baseline alignment.

#if defined(ENABLE_OVERLOADING)
    BoxLayoutBaselinePositionPropertyInfo   ,
#endif
#if defined(ENABLE_OVERLOADING)
    boxLayoutBaselinePosition               ,
#endif
    constructBoxLayoutBaselinePosition      ,
    getBoxLayoutBaselinePosition            ,
    setBoxLayoutBaselinePosition            ,


-- ** homogeneous #attr:homogeneous#
-- | Whether the box layout should distribute the available space
-- equally among the children.

#if defined(ENABLE_OVERLOADING)
    BoxLayoutHomogeneousPropertyInfo        ,
#endif
#if defined(ENABLE_OVERLOADING)
    boxLayoutHomogeneous                    ,
#endif
    constructBoxLayoutHomogeneous           ,
    getBoxLayoutHomogeneous                 ,
    setBoxLayoutHomogeneous                 ,


-- ** spacing #attr:spacing#
-- | The space to put between the children.

#if defined(ENABLE_OVERLOADING)
    BoxLayoutSpacingPropertyInfo            ,
#endif
#if defined(ENABLE_OVERLOADING)
    boxLayoutSpacing                        ,
#endif
    constructBoxLayoutSpacing               ,
    getBoxLayoutSpacing                     ,
    setBoxLayoutSpacing                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Orientable as Gtk.Orientable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Orientable as Gtk.Orientable
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager

#endif

-- | Memory-managed wrapper type.
newtype BoxLayout = BoxLayout (SP.ManagedPtr BoxLayout)
    deriving (Eq)

instance SP.ManagedPtrNewtype BoxLayout where
    toManagedPtr (BoxLayout p) = p

foreign import ccall "gtk_box_layout_get_type"
    c_gtk_box_layout_get_type :: IO B.Types.GType

instance B.Types.TypedObject BoxLayout where
    glibType = c_gtk_box_layout_get_type

instance B.Types.GObject BoxLayout

-- | Type class for types which can be safely cast to t'BoxLayout', for instance with `toBoxLayout`.
class (SP.GObject o, O.IsDescendantOf BoxLayout o) => IsBoxLayout o
instance (SP.GObject o, O.IsDescendantOf BoxLayout o) => IsBoxLayout o

instance O.HasParentTypes BoxLayout
type instance O.ParentTypes BoxLayout = '[Gtk.LayoutManager.LayoutManager, GObject.Object.Object, Gtk.Orientable.Orientable]

-- | Cast to t'BoxLayout', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toBoxLayout :: (MIO.MonadIO m, IsBoxLayout o) => o -> m BoxLayout
toBoxLayout = MIO.liftIO . B.ManagedPtr.unsafeCastTo BoxLayout

-- | Convert t'BoxLayout' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe BoxLayout) where
    gvalueGType_ = c_gtk_box_layout_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr BoxLayout)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr BoxLayout)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject BoxLayout ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveBoxLayoutMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveBoxLayoutMethod "allocate" o = Gtk.LayoutManager.LayoutManagerAllocateMethodInfo
    ResolveBoxLayoutMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveBoxLayoutMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveBoxLayoutMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveBoxLayoutMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveBoxLayoutMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveBoxLayoutMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveBoxLayoutMethod "layoutChanged" o = Gtk.LayoutManager.LayoutManagerLayoutChangedMethodInfo
    ResolveBoxLayoutMethod "measure" o = Gtk.LayoutManager.LayoutManagerMeasureMethodInfo
    ResolveBoxLayoutMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveBoxLayoutMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveBoxLayoutMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveBoxLayoutMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveBoxLayoutMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveBoxLayoutMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveBoxLayoutMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveBoxLayoutMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveBoxLayoutMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveBoxLayoutMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveBoxLayoutMethod "getBaselineChild" o = BoxLayoutGetBaselineChildMethodInfo
    ResolveBoxLayoutMethod "getBaselinePosition" o = BoxLayoutGetBaselinePositionMethodInfo
    ResolveBoxLayoutMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveBoxLayoutMethod "getHomogeneous" o = BoxLayoutGetHomogeneousMethodInfo
    ResolveBoxLayoutMethod "getLayoutChild" o = Gtk.LayoutManager.LayoutManagerGetLayoutChildMethodInfo
    ResolveBoxLayoutMethod "getOrientation" o = Gtk.Orientable.OrientableGetOrientationMethodInfo
    ResolveBoxLayoutMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveBoxLayoutMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveBoxLayoutMethod "getRequestMode" o = Gtk.LayoutManager.LayoutManagerGetRequestModeMethodInfo
    ResolveBoxLayoutMethod "getSpacing" o = BoxLayoutGetSpacingMethodInfo
    ResolveBoxLayoutMethod "getWidget" o = Gtk.LayoutManager.LayoutManagerGetWidgetMethodInfo
    ResolveBoxLayoutMethod "setBaselineChild" o = BoxLayoutSetBaselineChildMethodInfo
    ResolveBoxLayoutMethod "setBaselinePosition" o = BoxLayoutSetBaselinePositionMethodInfo
    ResolveBoxLayoutMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveBoxLayoutMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveBoxLayoutMethod "setHomogeneous" o = BoxLayoutSetHomogeneousMethodInfo
    ResolveBoxLayoutMethod "setOrientation" o = Gtk.Orientable.OrientableSetOrientationMethodInfo
    ResolveBoxLayoutMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveBoxLayoutMethod "setSpacing" o = BoxLayoutSetSpacingMethodInfo
    ResolveBoxLayoutMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveBoxLayoutMethod t BoxLayout, O.OverloadedMethod info BoxLayout p) => OL.IsLabel t (BoxLayout -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveBoxLayoutMethod t BoxLayout, O.OverloadedMethod info BoxLayout p, R.HasField t BoxLayout p) => R.HasField t BoxLayout p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveBoxLayoutMethod t BoxLayout, O.OverloadedMethodInfo info BoxLayout) => OL.IsLabel t (O.MethodProxy info BoxLayout) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "baseline-child"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@baseline-child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' boxLayout #baselineChild
-- @
getBoxLayoutBaselineChild :: (MonadIO m, IsBoxLayout o) => o -> m Int32
getBoxLayoutBaselineChild obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "baseline-child"

-- | Set the value of the “@baseline-child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' boxLayout [ #baselineChild 'Data.GI.Base.Attributes.:=' value ]
-- @
setBoxLayoutBaselineChild :: (MonadIO m, IsBoxLayout o) => o -> Int32 -> m ()
setBoxLayoutBaselineChild obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "baseline-child" val

-- | Construct a t'GValueConstruct' with valid value for the “@baseline-child@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructBoxLayoutBaselineChild :: (IsBoxLayout o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructBoxLayoutBaselineChild val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "baseline-child" val

#if defined(ENABLE_OVERLOADING)
data BoxLayoutBaselineChildPropertyInfo
instance AttrInfo BoxLayoutBaselineChildPropertyInfo where
    type AttrAllowedOps BoxLayoutBaselineChildPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint BoxLayoutBaselineChildPropertyInfo = IsBoxLayout
    type AttrSetTypeConstraint BoxLayoutBaselineChildPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint BoxLayoutBaselineChildPropertyInfo = (~) Int32
    type AttrTransferType BoxLayoutBaselineChildPropertyInfo = Int32
    type AttrGetType BoxLayoutBaselineChildPropertyInfo = Int32
    type AttrLabel BoxLayoutBaselineChildPropertyInfo = "baseline-child"
    type AttrOrigin BoxLayoutBaselineChildPropertyInfo = BoxLayout
    attrGet = getBoxLayoutBaselineChild
    attrSet = setBoxLayoutBaselineChild
    attrTransfer _ v = do
        return v
    attrConstruct = constructBoxLayoutBaselineChild
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BoxLayout.baselineChild"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-BoxLayout.html#g:attr:baselineChild"
        })
#endif

-- VVV Prop "baseline-position"
   -- Type: TInterface (Name {namespace = "Gtk", name = "BaselinePosition"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@baseline-position@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' boxLayout #baselinePosition
-- @
getBoxLayoutBaselinePosition :: (MonadIO m, IsBoxLayout o) => o -> m Gtk.Enums.BaselinePosition
getBoxLayoutBaselinePosition obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "baseline-position"

-- | Set the value of the “@baseline-position@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' boxLayout [ #baselinePosition 'Data.GI.Base.Attributes.:=' value ]
-- @
setBoxLayoutBaselinePosition :: (MonadIO m, IsBoxLayout o) => o -> Gtk.Enums.BaselinePosition -> m ()
setBoxLayoutBaselinePosition obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "baseline-position" val

-- | Construct a t'GValueConstruct' with valid value for the “@baseline-position@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructBoxLayoutBaselinePosition :: (IsBoxLayout o, MIO.MonadIO m) => Gtk.Enums.BaselinePosition -> m (GValueConstruct o)
constructBoxLayoutBaselinePosition val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "baseline-position" val

#if defined(ENABLE_OVERLOADING)
data BoxLayoutBaselinePositionPropertyInfo
instance AttrInfo BoxLayoutBaselinePositionPropertyInfo where
    type AttrAllowedOps BoxLayoutBaselinePositionPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint BoxLayoutBaselinePositionPropertyInfo = IsBoxLayout
    type AttrSetTypeConstraint BoxLayoutBaselinePositionPropertyInfo = (~) Gtk.Enums.BaselinePosition
    type AttrTransferTypeConstraint BoxLayoutBaselinePositionPropertyInfo = (~) Gtk.Enums.BaselinePosition
    type AttrTransferType BoxLayoutBaselinePositionPropertyInfo = Gtk.Enums.BaselinePosition
    type AttrGetType BoxLayoutBaselinePositionPropertyInfo = Gtk.Enums.BaselinePosition
    type AttrLabel BoxLayoutBaselinePositionPropertyInfo = "baseline-position"
    type AttrOrigin BoxLayoutBaselinePositionPropertyInfo = BoxLayout
    attrGet = getBoxLayoutBaselinePosition
    attrSet = setBoxLayoutBaselinePosition
    attrTransfer _ v = do
        return v
    attrConstruct = constructBoxLayoutBaselinePosition
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BoxLayout.baselinePosition"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-BoxLayout.html#g:attr:baselinePosition"
        })
#endif

-- VVV Prop "homogeneous"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@homogeneous@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' boxLayout #homogeneous
-- @
getBoxLayoutHomogeneous :: (MonadIO m, IsBoxLayout o) => o -> m Bool
getBoxLayoutHomogeneous obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "homogeneous"

-- | Set the value of the “@homogeneous@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' boxLayout [ #homogeneous 'Data.GI.Base.Attributes.:=' value ]
-- @
setBoxLayoutHomogeneous :: (MonadIO m, IsBoxLayout o) => o -> Bool -> m ()
setBoxLayoutHomogeneous obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "homogeneous" val

-- | Construct a t'GValueConstruct' with valid value for the “@homogeneous@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructBoxLayoutHomogeneous :: (IsBoxLayout o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructBoxLayoutHomogeneous val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "homogeneous" val

#if defined(ENABLE_OVERLOADING)
data BoxLayoutHomogeneousPropertyInfo
instance AttrInfo BoxLayoutHomogeneousPropertyInfo where
    type AttrAllowedOps BoxLayoutHomogeneousPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint BoxLayoutHomogeneousPropertyInfo = IsBoxLayout
    type AttrSetTypeConstraint BoxLayoutHomogeneousPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint BoxLayoutHomogeneousPropertyInfo = (~) Bool
    type AttrTransferType BoxLayoutHomogeneousPropertyInfo = Bool
    type AttrGetType BoxLayoutHomogeneousPropertyInfo = Bool
    type AttrLabel BoxLayoutHomogeneousPropertyInfo = "homogeneous"
    type AttrOrigin BoxLayoutHomogeneousPropertyInfo = BoxLayout
    attrGet = getBoxLayoutHomogeneous
    attrSet = setBoxLayoutHomogeneous
    attrTransfer _ v = do
        return v
    attrConstruct = constructBoxLayoutHomogeneous
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BoxLayout.homogeneous"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-BoxLayout.html#g:attr:homogeneous"
        })
#endif

-- VVV Prop "spacing"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@spacing@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' boxLayout #spacing
-- @
getBoxLayoutSpacing :: (MonadIO m, IsBoxLayout o) => o -> m Int32
getBoxLayoutSpacing obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "spacing"

-- | Set the value of the “@spacing@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' boxLayout [ #spacing 'Data.GI.Base.Attributes.:=' value ]
-- @
setBoxLayoutSpacing :: (MonadIO m, IsBoxLayout o) => o -> Int32 -> m ()
setBoxLayoutSpacing obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "spacing" val

-- | Construct a t'GValueConstruct' with valid value for the “@spacing@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructBoxLayoutSpacing :: (IsBoxLayout o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructBoxLayoutSpacing val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "spacing" val

#if defined(ENABLE_OVERLOADING)
data BoxLayoutSpacingPropertyInfo
instance AttrInfo BoxLayoutSpacingPropertyInfo where
    type AttrAllowedOps BoxLayoutSpacingPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint BoxLayoutSpacingPropertyInfo = IsBoxLayout
    type AttrSetTypeConstraint BoxLayoutSpacingPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint BoxLayoutSpacingPropertyInfo = (~) Int32
    type AttrTransferType BoxLayoutSpacingPropertyInfo = Int32
    type AttrGetType BoxLayoutSpacingPropertyInfo = Int32
    type AttrLabel BoxLayoutSpacingPropertyInfo = "spacing"
    type AttrOrigin BoxLayoutSpacingPropertyInfo = BoxLayout
    attrGet = getBoxLayoutSpacing
    attrSet = setBoxLayoutSpacing
    attrTransfer _ v = do
        return v
    attrConstruct = constructBoxLayoutSpacing
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BoxLayout.spacing"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-BoxLayout.html#g:attr:spacing"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList BoxLayout
type instance O.AttributeList BoxLayout = BoxLayoutAttributeList
type BoxLayoutAttributeList = ('[ '("baselineChild", BoxLayoutBaselineChildPropertyInfo), '("baselinePosition", BoxLayoutBaselinePositionPropertyInfo), '("homogeneous", BoxLayoutHomogeneousPropertyInfo), '("orientation", Gtk.Orientable.OrientableOrientationPropertyInfo), '("spacing", BoxLayoutSpacingPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
boxLayoutBaselineChild :: AttrLabelProxy "baselineChild"
boxLayoutBaselineChild = AttrLabelProxy

boxLayoutBaselinePosition :: AttrLabelProxy "baselinePosition"
boxLayoutBaselinePosition = AttrLabelProxy

boxLayoutHomogeneous :: AttrLabelProxy "homogeneous"
boxLayoutHomogeneous = AttrLabelProxy

boxLayoutSpacing :: AttrLabelProxy "spacing"
boxLayoutSpacing = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList BoxLayout = BoxLayoutSignalList
type BoxLayoutSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method BoxLayout::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "orientation"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Orientation" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the orientation for the new layout"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "BoxLayout" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_box_layout_new" gtk_box_layout_new :: 
    CUInt ->                                -- orientation : TInterface (Name {namespace = "Gtk", name = "Orientation"})
    IO (Ptr BoxLayout)

-- | Creates a new @GtkBoxLayout@.
boxLayoutNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gtk.Enums.Orientation
    -- ^ /@orientation@/: the orientation for the new layout
    -> m BoxLayout
    -- ^ __Returns:__ a new box layout
boxLayoutNew orientation = liftIO $ do
    let orientation' = (fromIntegral . fromEnum) orientation
    result <- gtk_box_layout_new orientation'
    checkUnexpectedReturnNULL "boxLayoutNew" result
    result' <- (wrapObject BoxLayout) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method BoxLayout::get_baseline_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box_layout"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "BoxLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkBoxLayout`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_box_layout_get_baseline_child" gtk_box_layout_get_baseline_child :: 
    Ptr BoxLayout ->                        -- box_layout : TInterface (Name {namespace = "Gtk", name = "BoxLayout"})
    IO Int32

-- | Gets the value set by 'GI.Gtk.Objects.BoxLayout.boxLayoutSetBaselineChild'.
-- 
-- /Since: 4.12/
boxLayoutGetBaselineChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsBoxLayout a) =>
    a
    -- ^ /@boxLayout@/: a @GtkBoxLayout@
    -> m Int32
    -- ^ __Returns:__ the index of the child that determines the baseline
    --     in vertical layout, or -1
boxLayoutGetBaselineChild boxLayout = liftIO $ do
    boxLayout' <- unsafeManagedPtrCastPtr boxLayout
    result <- gtk_box_layout_get_baseline_child boxLayout'
    touchManagedPtr boxLayout
    return result

#if defined(ENABLE_OVERLOADING)
data BoxLayoutGetBaselineChildMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsBoxLayout a) => O.OverloadedMethod BoxLayoutGetBaselineChildMethodInfo a signature where
    overloadedMethod = boxLayoutGetBaselineChild

instance O.OverloadedMethodInfo BoxLayoutGetBaselineChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BoxLayout.boxLayoutGetBaselineChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-BoxLayout.html#v:boxLayoutGetBaselineChild"
        })


#endif

-- method BoxLayout::get_baseline_position
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box_layout"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "BoxLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkBoxLayout`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "BaselinePosition" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_box_layout_get_baseline_position" gtk_box_layout_get_baseline_position :: 
    Ptr BoxLayout ->                        -- box_layout : TInterface (Name {namespace = "Gtk", name = "BoxLayout"})
    IO CUInt

-- | Gets the value set by 'GI.Gtk.Objects.BoxLayout.boxLayoutSetBaselinePosition'.
boxLayoutGetBaselinePosition ::
    (B.CallStack.HasCallStack, MonadIO m, IsBoxLayout a) =>
    a
    -- ^ /@boxLayout@/: a @GtkBoxLayout@
    -> m Gtk.Enums.BaselinePosition
    -- ^ __Returns:__ the baseline position
boxLayoutGetBaselinePosition boxLayout = liftIO $ do
    boxLayout' <- unsafeManagedPtrCastPtr boxLayout
    result <- gtk_box_layout_get_baseline_position boxLayout'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr boxLayout
    return result'

#if defined(ENABLE_OVERLOADING)
data BoxLayoutGetBaselinePositionMethodInfo
instance (signature ~ (m Gtk.Enums.BaselinePosition), MonadIO m, IsBoxLayout a) => O.OverloadedMethod BoxLayoutGetBaselinePositionMethodInfo a signature where
    overloadedMethod = boxLayoutGetBaselinePosition

instance O.OverloadedMethodInfo BoxLayoutGetBaselinePositionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BoxLayout.boxLayoutGetBaselinePosition",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-BoxLayout.html#v:boxLayoutGetBaselinePosition"
        })


#endif

-- method BoxLayout::get_homogeneous
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box_layout"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "BoxLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkBoxLayout`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_box_layout_get_homogeneous" gtk_box_layout_get_homogeneous :: 
    Ptr BoxLayout ->                        -- box_layout : TInterface (Name {namespace = "Gtk", name = "BoxLayout"})
    IO CInt

-- | Returns whether the layout is set to be homogeneous.
boxLayoutGetHomogeneous ::
    (B.CallStack.HasCallStack, MonadIO m, IsBoxLayout a) =>
    a
    -- ^ /@boxLayout@/: a @GtkBoxLayout@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the layout is homogeneous
boxLayoutGetHomogeneous boxLayout = liftIO $ do
    boxLayout' <- unsafeManagedPtrCastPtr boxLayout
    result <- gtk_box_layout_get_homogeneous boxLayout'
    let result' = (/= 0) result
    touchManagedPtr boxLayout
    return result'

#if defined(ENABLE_OVERLOADING)
data BoxLayoutGetHomogeneousMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsBoxLayout a) => O.OverloadedMethod BoxLayoutGetHomogeneousMethodInfo a signature where
    overloadedMethod = boxLayoutGetHomogeneous

instance O.OverloadedMethodInfo BoxLayoutGetHomogeneousMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BoxLayout.boxLayoutGetHomogeneous",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-BoxLayout.html#v:boxLayoutGetHomogeneous"
        })


#endif

-- method BoxLayout::get_spacing
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box_layout"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "BoxLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkBoxLayout`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_box_layout_get_spacing" gtk_box_layout_get_spacing :: 
    Ptr BoxLayout ->                        -- box_layout : TInterface (Name {namespace = "Gtk", name = "BoxLayout"})
    IO Word32

-- | Returns the space that /@boxLayout@/ puts between children.
boxLayoutGetSpacing ::
    (B.CallStack.HasCallStack, MonadIO m, IsBoxLayout a) =>
    a
    -- ^ /@boxLayout@/: a @GtkBoxLayout@
    -> m Word32
    -- ^ __Returns:__ the spacing of the layout
boxLayoutGetSpacing boxLayout = liftIO $ do
    boxLayout' <- unsafeManagedPtrCastPtr boxLayout
    result <- gtk_box_layout_get_spacing boxLayout'
    touchManagedPtr boxLayout
    return result

#if defined(ENABLE_OVERLOADING)
data BoxLayoutGetSpacingMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsBoxLayout a) => O.OverloadedMethod BoxLayoutGetSpacingMethodInfo a signature where
    overloadedMethod = boxLayoutGetSpacing

instance O.OverloadedMethodInfo BoxLayoutGetSpacingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BoxLayout.boxLayoutGetSpacing",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-BoxLayout.html#v:boxLayoutGetSpacing"
        })


#endif

-- method BoxLayout::set_baseline_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box_layout"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "BoxLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkBoxLayout`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the child position, or -1"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_box_layout_set_baseline_child" gtk_box_layout_set_baseline_child :: 
    Ptr BoxLayout ->                        -- box_layout : TInterface (Name {namespace = "Gtk", name = "BoxLayout"})
    Int32 ->                                -- child : TBasicType TInt
    IO ()

-- | Sets the index of the child that determines the baseline
-- in vertical layout.
-- 
-- /Since: 4.12/
boxLayoutSetBaselineChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsBoxLayout a) =>
    a
    -- ^ /@boxLayout@/: a @GtkBoxLayout@
    -> Int32
    -- ^ /@child@/: the child position, or -1
    -> m ()
boxLayoutSetBaselineChild boxLayout child = liftIO $ do
    boxLayout' <- unsafeManagedPtrCastPtr boxLayout
    gtk_box_layout_set_baseline_child boxLayout' child
    touchManagedPtr boxLayout
    return ()

#if defined(ENABLE_OVERLOADING)
data BoxLayoutSetBaselineChildMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsBoxLayout a) => O.OverloadedMethod BoxLayoutSetBaselineChildMethodInfo a signature where
    overloadedMethod = boxLayoutSetBaselineChild

instance O.OverloadedMethodInfo BoxLayoutSetBaselineChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BoxLayout.boxLayoutSetBaselineChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-BoxLayout.html#v:boxLayoutSetBaselineChild"
        })


#endif

-- method BoxLayout::set_baseline_position
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box_layout"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "BoxLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkBoxLayout`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "BaselinePosition" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkBaselinePosition`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_box_layout_set_baseline_position" gtk_box_layout_set_baseline_position :: 
    Ptr BoxLayout ->                        -- box_layout : TInterface (Name {namespace = "Gtk", name = "BoxLayout"})
    CUInt ->                                -- position : TInterface (Name {namespace = "Gtk", name = "BaselinePosition"})
    IO ()

-- | Sets the baseline position of a box layout.
-- 
-- The baseline position affects only horizontal boxes with at least one
-- baseline aligned child. If there is more vertical space available than
-- requested, and the baseline is not allocated by the parent then the
-- given /@position@/ is used to allocate the baseline within the extra
-- space available.
boxLayoutSetBaselinePosition ::
    (B.CallStack.HasCallStack, MonadIO m, IsBoxLayout a) =>
    a
    -- ^ /@boxLayout@/: a @GtkBoxLayout@
    -> Gtk.Enums.BaselinePosition
    -- ^ /@position@/: a @GtkBaselinePosition@
    -> m ()
boxLayoutSetBaselinePosition boxLayout position = liftIO $ do
    boxLayout' <- unsafeManagedPtrCastPtr boxLayout
    let position' = (fromIntegral . fromEnum) position
    gtk_box_layout_set_baseline_position boxLayout' position'
    touchManagedPtr boxLayout
    return ()

#if defined(ENABLE_OVERLOADING)
data BoxLayoutSetBaselinePositionMethodInfo
instance (signature ~ (Gtk.Enums.BaselinePosition -> m ()), MonadIO m, IsBoxLayout a) => O.OverloadedMethod BoxLayoutSetBaselinePositionMethodInfo a signature where
    overloadedMethod = boxLayoutSetBaselinePosition

instance O.OverloadedMethodInfo BoxLayoutSetBaselinePositionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BoxLayout.boxLayoutSetBaselinePosition",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-BoxLayout.html#v:boxLayoutSetBaselinePosition"
        })


#endif

-- method BoxLayout::set_homogeneous
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box_layout"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "BoxLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkBoxLayout`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "homogeneous"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to set the box layout as homogeneous"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_box_layout_set_homogeneous" gtk_box_layout_set_homogeneous :: 
    Ptr BoxLayout ->                        -- box_layout : TInterface (Name {namespace = "Gtk", name = "BoxLayout"})
    CInt ->                                 -- homogeneous : TBasicType TBoolean
    IO ()

-- | Sets whether the box layout will allocate the same
-- size to all children.
boxLayoutSetHomogeneous ::
    (B.CallStack.HasCallStack, MonadIO m, IsBoxLayout a) =>
    a
    -- ^ /@boxLayout@/: a @GtkBoxLayout@
    -> Bool
    -- ^ /@homogeneous@/: 'P.True' to set the box layout as homogeneous
    -> m ()
boxLayoutSetHomogeneous boxLayout homogeneous = liftIO $ do
    boxLayout' <- unsafeManagedPtrCastPtr boxLayout
    let homogeneous' = (P.fromIntegral . P.fromEnum) homogeneous
    gtk_box_layout_set_homogeneous boxLayout' homogeneous'
    touchManagedPtr boxLayout
    return ()

#if defined(ENABLE_OVERLOADING)
data BoxLayoutSetHomogeneousMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsBoxLayout a) => O.OverloadedMethod BoxLayoutSetHomogeneousMethodInfo a signature where
    overloadedMethod = boxLayoutSetHomogeneous

instance O.OverloadedMethodInfo BoxLayoutSetHomogeneousMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BoxLayout.boxLayoutSetHomogeneous",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-BoxLayout.html#v:boxLayoutSetHomogeneous"
        })


#endif

-- method BoxLayout::set_spacing
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box_layout"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "BoxLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkBoxLayout`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "spacing"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the spacing to apply between children"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_box_layout_set_spacing" gtk_box_layout_set_spacing :: 
    Ptr BoxLayout ->                        -- box_layout : TInterface (Name {namespace = "Gtk", name = "BoxLayout"})
    Word32 ->                               -- spacing : TBasicType TUInt
    IO ()

-- | Sets how much spacing to put between children.
boxLayoutSetSpacing ::
    (B.CallStack.HasCallStack, MonadIO m, IsBoxLayout a) =>
    a
    -- ^ /@boxLayout@/: a @GtkBoxLayout@
    -> Word32
    -- ^ /@spacing@/: the spacing to apply between children
    -> m ()
boxLayoutSetSpacing boxLayout spacing = liftIO $ do
    boxLayout' <- unsafeManagedPtrCastPtr boxLayout
    gtk_box_layout_set_spacing boxLayout' spacing
    touchManagedPtr boxLayout
    return ()

#if defined(ENABLE_OVERLOADING)
data BoxLayoutSetSpacingMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsBoxLayout a) => O.OverloadedMethod BoxLayoutSetSpacingMethodInfo a signature where
    overloadedMethod = boxLayoutSetSpacing

instance O.OverloadedMethodInfo BoxLayoutSetSpacingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BoxLayout.boxLayoutSetSpacing",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-BoxLayout.html#v:boxLayoutSetSpacing"
        })


#endif


