{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A subclass of t'GI.Dbusmenu.Objects.Client.Client' to add functionality with regarding
-- building GTK items out of the abstract tree.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.DbusmenuGtk3.Objects.Client
    ( 

-- * Exported types
    Client(..)                              ,
    IsClient                                ,
    toClient                                ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [addTypeHandler]("GI.Dbusmenu.Objects.Client#g:method:addTypeHandler"), [addTypeHandlerFull]("GI.Dbusmenu.Objects.Client#g:method:addTypeHandlerFull"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [menuitemGet]("GI.DbusmenuGtk3.Objects.Client#g:method:menuitemGet"), [menuitemGetSubmenu]("GI.DbusmenuGtk3.Objects.Client#g:method:menuitemGetSubmenu"), [newitemBase]("GI.DbusmenuGtk3.Objects.Client#g:method:newitemBase"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccelGroup]("GI.DbusmenuGtk3.Objects.Client#g:method:getAccelGroup"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getIconPaths]("GI.Dbusmenu.Objects.Client#g:method:getIconPaths"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRoot]("GI.Dbusmenu.Objects.Client#g:method:getRoot"), [getStatus]("GI.Dbusmenu.Objects.Client#g:method:getStatus"), [getTextDirection]("GI.Dbusmenu.Objects.Client#g:method:getTextDirection").
-- 
-- ==== Setters
-- [setAccelGroup]("GI.DbusmenuGtk3.Objects.Client#g:method:setAccelGroup"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveClientMethod                     ,
#endif

-- ** getAccelGroup #method:getAccelGroup#

#if defined(ENABLE_OVERLOADING)
    ClientGetAccelGroupMethodInfo           ,
#endif
    clientGetAccelGroup                     ,


-- ** menuitemGet #method:menuitemGet#

#if defined(ENABLE_OVERLOADING)
    ClientMenuitemGetMethodInfo             ,
#endif
    clientMenuitemGet                       ,


-- ** menuitemGetSubmenu #method:menuitemGetSubmenu#

#if defined(ENABLE_OVERLOADING)
    ClientMenuitemGetSubmenuMethodInfo      ,
#endif
    clientMenuitemGetSubmenu                ,


-- ** new #method:new#

    clientNew                               ,


-- ** newitemBase #method:newitemBase#

#if defined(ENABLE_OVERLOADING)
    ClientNewitemBaseMethodInfo             ,
#endif
    clientNewitemBase                       ,


-- ** setAccelGroup #method:setAccelGroup#

#if defined(ENABLE_OVERLOADING)
    ClientSetAccelGroupMethodInfo           ,
#endif
    clientSetAccelGroup                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Dbusmenu.Objects.Client as Dbusmenu.Client
import qualified GI.Dbusmenu.Objects.Menuitem as Dbusmenu.Menuitem
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gtk.Objects.AccelGroup as Gtk.AccelGroup
import qualified GI.Gtk.Objects.Menu as Gtk.Menu
import qualified GI.Gtk.Objects.MenuItem as Gtk.MenuItem

#else
import qualified GI.Dbusmenu.Objects.Client as Dbusmenu.Client
import qualified GI.Dbusmenu.Objects.Menuitem as Dbusmenu.Menuitem
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gtk.Objects.AccelGroup as Gtk.AccelGroup
import qualified GI.Gtk.Objects.Menu as Gtk.Menu
import qualified GI.Gtk.Objects.MenuItem as Gtk.MenuItem

#endif

-- | Memory-managed wrapper type.
newtype Client = Client (SP.ManagedPtr Client)
    deriving (Eq)

instance SP.ManagedPtrNewtype Client where
    toManagedPtr (Client p) = p

foreign import ccall "dbusmenu_gtkclient_get_type"
    c_dbusmenu_gtkclient_get_type :: IO B.Types.GType

instance B.Types.TypedObject Client where
    glibType = c_dbusmenu_gtkclient_get_type

instance B.Types.GObject Client

-- | Type class for types which can be safely cast to t'Client', for instance with `toClient`.
class (SP.GObject o, O.IsDescendantOf Client o) => IsClient o
instance (SP.GObject o, O.IsDescendantOf Client o) => IsClient o

instance O.HasParentTypes Client
type instance O.ParentTypes Client = '[Dbusmenu.Client.Client, GObject.Object.Object]

-- | Cast to t'Client', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toClient :: (MIO.MonadIO m, IsClient o) => o -> m Client
toClient = MIO.liftIO . B.ManagedPtr.unsafeCastTo Client

-- | Convert t'Client' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Client) where
    gvalueGType_ = c_dbusmenu_gtkclient_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Client)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Client)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Client ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveClientMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveClientMethod "addTypeHandler" o = Dbusmenu.Client.ClientAddTypeHandlerMethodInfo
    ResolveClientMethod "addTypeHandlerFull" o = Dbusmenu.Client.ClientAddTypeHandlerFullMethodInfo
    ResolveClientMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveClientMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveClientMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveClientMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveClientMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveClientMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveClientMethod "menuitemGet" o = ClientMenuitemGetMethodInfo
    ResolveClientMethod "menuitemGetSubmenu" o = ClientMenuitemGetSubmenuMethodInfo
    ResolveClientMethod "newitemBase" o = ClientNewitemBaseMethodInfo
    ResolveClientMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveClientMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveClientMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveClientMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveClientMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveClientMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveClientMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveClientMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveClientMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveClientMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveClientMethod "getAccelGroup" o = ClientGetAccelGroupMethodInfo
    ResolveClientMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveClientMethod "getIconPaths" o = Dbusmenu.Client.ClientGetIconPathsMethodInfo
    ResolveClientMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveClientMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveClientMethod "getRoot" o = Dbusmenu.Client.ClientGetRootMethodInfo
    ResolveClientMethod "getStatus" o = Dbusmenu.Client.ClientGetStatusMethodInfo
    ResolveClientMethod "getTextDirection" o = Dbusmenu.Client.ClientGetTextDirectionMethodInfo
    ResolveClientMethod "setAccelGroup" o = ClientSetAccelGroupMethodInfo
    ResolveClientMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveClientMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveClientMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveClientMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveClientMethod t Client, O.OverloadedMethod info Client p) => OL.IsLabel t (Client -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveClientMethod t Client, O.OverloadedMethod info Client p, R.HasField t Client p) => R.HasField t Client p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveClientMethod t Client, O.OverloadedMethodInfo info Client) => OL.IsLabel t (O.MethodProxy info Client) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Client
type instance O.AttributeList Client = ClientAttributeList
type ClientAttributeList = ('[ '("dbusName", Dbusmenu.Client.ClientDbusNamePropertyInfo), '("dbusObject", Dbusmenu.Client.ClientDbusObjectPropertyInfo), '("groupEvents", Dbusmenu.Client.ClientGroupEventsPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Client = ClientSignalList
type ClientSignalList = ('[ '("eventResult", Dbusmenu.Client.ClientEventResultSignalInfo), '("iconThemeDirsChanged", Dbusmenu.Client.ClientIconThemeDirsChangedSignalInfo), '("itemActivate", Dbusmenu.Client.ClientItemActivateSignalInfo), '("layoutUpdated", Dbusmenu.Client.ClientLayoutUpdatedSignalInfo), '("newMenuitem", Dbusmenu.Client.ClientNewMenuitemSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("rootChanged", Dbusmenu.Client.ClientRootChangedSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Client::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "dbus_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Name of the #DbusmenuServer on DBus"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dbus_object"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Name of the object on the #DbusmenuServer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "DbusmenuGtk3" , name = "Client" })
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_gtkclient_new" dbusmenu_gtkclient_new :: 
    CString ->                              -- dbus_name : TBasicType TUTF8
    CString ->                              -- dbus_object : TBasicType TUTF8
    IO (Ptr Client)

-- | Creates a new t'GI.DbusmenuGtk3.Objects.Client.Client' object and creates a t'GI.Dbusmenu.Objects.Client.Client'
-- that connects across DBus to a t'GI.Dbusmenu.Objects.Server.Server'.
clientNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@dbusName@/: Name of the t'GI.Dbusmenu.Objects.Server.Server' on DBus
    -> T.Text
    -- ^ /@dbusObject@/: Name of the object on the t'GI.Dbusmenu.Objects.Server.Server'
    -> m Client
    -- ^ __Returns:__ A new t'GI.DbusmenuGtk3.Objects.Client.Client' sync\'d with a server
clientNew dbusName dbusObject = liftIO $ do
    dbusName' <- textToCString dbusName
    dbusObject' <- textToCString dbusObject
    result <- dbusmenu_gtkclient_new dbusName' dbusObject'
    checkUnexpectedReturnNULL "clientNew" result
    result' <- (wrapObject Client) result
    freeMem dbusName'
    freeMem dbusObject'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Client::get_accel_group
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "DbusmenuGtk3" , name = "Client" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Client to query for an accelerator group"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "AccelGroup" })
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_gtkclient_get_accel_group" dbusmenu_gtkclient_get_accel_group :: 
    Ptr Client ->                           -- client : TInterface (Name {namespace = "DbusmenuGtk3", name = "Client"})
    IO (Ptr Gtk.AccelGroup.AccelGroup)

-- | Gets the accel group for this client.
clientGetAccelGroup ::
    (B.CallStack.HasCallStack, MonadIO m, IsClient a) =>
    a
    -- ^ /@client@/: Client to query for an accelerator group
    -> m Gtk.AccelGroup.AccelGroup
    -- ^ __Returns:__ Either a valid group or @/NULL/@ on error or
    -- 	none set.
clientGetAccelGroup client = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    result <- dbusmenu_gtkclient_get_accel_group client'
    checkUnexpectedReturnNULL "clientGetAccelGroup" result
    result' <- (newObject Gtk.AccelGroup.AccelGroup) result
    touchManagedPtr client
    return result'

#if defined(ENABLE_OVERLOADING)
data ClientGetAccelGroupMethodInfo
instance (signature ~ (m Gtk.AccelGroup.AccelGroup), MonadIO m, IsClient a) => O.OverloadedMethod ClientGetAccelGroupMethodInfo a signature where
    overloadedMethod = clientGetAccelGroup

instance O.OverloadedMethodInfo ClientGetAccelGroupMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.DbusmenuGtk3.Objects.Client.clientGetAccelGroup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenugtk3-0.4.15/docs/GI-DbusmenuGtk3-Objects-Client.html#v:clientGetAccelGroup"
        })


#endif

-- method Client::menuitem_get
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "DbusmenuGtk3" , name = "Client" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #DbusmenuGtkClient with the item in it."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "item"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "#DbusmenuMenuitem to get associated #GtkMenuItem on."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "MenuItem" })
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_gtkclient_menuitem_get" dbusmenu_gtkclient_menuitem_get :: 
    Ptr Client ->                           -- client : TInterface (Name {namespace = "DbusmenuGtk3", name = "Client"})
    Ptr Dbusmenu.Menuitem.Menuitem ->       -- item : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    IO (Ptr Gtk.MenuItem.MenuItem)

-- | This grabs the t'GI.Gtk.Objects.MenuItem.MenuItem' that is associated with the
-- t'GI.Dbusmenu.Objects.Menuitem.Menuitem'.
clientMenuitemGet ::
    (B.CallStack.HasCallStack, MonadIO m, IsClient a, Dbusmenu.Menuitem.IsMenuitem b) =>
    a
    -- ^ /@client@/: A t'GI.DbusmenuGtk3.Objects.Client.Client' with the item in it.
    -> b
    -- ^ /@item@/: t'GI.Dbusmenu.Objects.Menuitem.Menuitem' to get associated t'GI.Gtk.Objects.MenuItem.MenuItem' on.
    -> m Gtk.MenuItem.MenuItem
    -- ^ __Returns:__ The t'GI.Gtk.Objects.MenuItem.MenuItem' that can be played with.
clientMenuitemGet client item = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    item' <- unsafeManagedPtrCastPtr item
    result <- dbusmenu_gtkclient_menuitem_get client' item'
    checkUnexpectedReturnNULL "clientMenuitemGet" result
    result' <- (newObject Gtk.MenuItem.MenuItem) result
    touchManagedPtr client
    touchManagedPtr item
    return result'

#if defined(ENABLE_OVERLOADING)
data ClientMenuitemGetMethodInfo
instance (signature ~ (b -> m Gtk.MenuItem.MenuItem), MonadIO m, IsClient a, Dbusmenu.Menuitem.IsMenuitem b) => O.OverloadedMethod ClientMenuitemGetMethodInfo a signature where
    overloadedMethod = clientMenuitemGet

instance O.OverloadedMethodInfo ClientMenuitemGetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.DbusmenuGtk3.Objects.Client.clientMenuitemGet",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenugtk3-0.4.15/docs/GI-DbusmenuGtk3-Objects-Client.html#v:clientMenuitemGet"
        })


#endif

-- method Client::menuitem_get_submenu
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "DbusmenuGtk3" , name = "Client" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #DbusmenuGtkClient with the item in it."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "item"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "#DbusmenuMenuitem to get associated #GtkMenu on."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Menu" })
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_gtkclient_menuitem_get_submenu" dbusmenu_gtkclient_menuitem_get_submenu :: 
    Ptr Client ->                           -- client : TInterface (Name {namespace = "DbusmenuGtk3", name = "Client"})
    Ptr Dbusmenu.Menuitem.Menuitem ->       -- item : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    IO (Ptr Gtk.Menu.Menu)

-- | This grabs the submenu associated with the menuitem.
clientMenuitemGetSubmenu ::
    (B.CallStack.HasCallStack, MonadIO m, IsClient a, Dbusmenu.Menuitem.IsMenuitem b) =>
    a
    -- ^ /@client@/: A t'GI.DbusmenuGtk3.Objects.Client.Client' with the item in it.
    -> b
    -- ^ /@item@/: t'GI.Dbusmenu.Objects.Menuitem.Menuitem' to get associated t'GI.Gtk.Objects.Menu.Menu' on.
    -> m Gtk.Menu.Menu
    -- ^ __Returns:__ The t'GI.Gtk.Objects.Menu.Menu' if there is one.
clientMenuitemGetSubmenu client item = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    item' <- unsafeManagedPtrCastPtr item
    result <- dbusmenu_gtkclient_menuitem_get_submenu client' item'
    checkUnexpectedReturnNULL "clientMenuitemGetSubmenu" result
    result' <- (newObject Gtk.Menu.Menu) result
    touchManagedPtr client
    touchManagedPtr item
    return result'

#if defined(ENABLE_OVERLOADING)
data ClientMenuitemGetSubmenuMethodInfo
instance (signature ~ (b -> m Gtk.Menu.Menu), MonadIO m, IsClient a, Dbusmenu.Menuitem.IsMenuitem b) => O.OverloadedMethod ClientMenuitemGetSubmenuMethodInfo a signature where
    overloadedMethod = clientMenuitemGetSubmenu

instance O.OverloadedMethodInfo ClientMenuitemGetSubmenuMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.DbusmenuGtk3.Objects.Client.clientMenuitemGetSubmenu",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenugtk3-0.4.15/docs/GI-DbusmenuGtk3-Objects-Client.html#v:clientMenuitemGetSubmenu"
        })


#endif

-- method Client::newitem_base
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "DbusmenuGtk3" , name = "Client" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The client handling everything on this connection"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "item"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The #DbusmenuMenuitem to attach the GTK-isms to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "gmi"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MenuItem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A #GtkMenuItem representing the GTK world's view of this menuitem"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parent"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The parent #DbusmenuMenuitem"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_gtkclient_newitem_base" dbusmenu_gtkclient_newitem_base :: 
    Ptr Client ->                           -- client : TInterface (Name {namespace = "DbusmenuGtk3", name = "Client"})
    Ptr Dbusmenu.Menuitem.Menuitem ->       -- item : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    Ptr Gtk.MenuItem.MenuItem ->            -- gmi : TInterface (Name {namespace = "Gtk", name = "MenuItem"})
    Ptr Dbusmenu.Menuitem.Menuitem ->       -- parent : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    IO ()

-- | This function provides some of the basic connectivity for being in
-- the GTK world.  Things like visibility and sensitivity of the item are
-- handled here so that the subclasses don\'t have to.  If you\'re building
-- your on GTK menu item you can use this function to apply those basic
-- attributes so that you don\'t have to deal with them either.
-- 
-- This also handles passing the \"activate\" signal back to the
-- t'GI.Dbusmenu.Objects.Menuitem.Menuitem' side of thing.
clientNewitemBase ::
    (B.CallStack.HasCallStack, MonadIO m, IsClient a, Dbusmenu.Menuitem.IsMenuitem b, Gtk.MenuItem.IsMenuItem c, Dbusmenu.Menuitem.IsMenuitem d) =>
    a
    -- ^ /@client@/: The client handling everything on this connection
    -> b
    -- ^ /@item@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' to attach the GTK-isms to
    -> c
    -- ^ /@gmi@/: A t'GI.Gtk.Objects.MenuItem.MenuItem' representing the GTK world\'s view of this menuitem
    -> d
    -- ^ /@parent@/: The parent t'GI.Dbusmenu.Objects.Menuitem.Menuitem'
    -> m ()
clientNewitemBase client item gmi parent = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    item' <- unsafeManagedPtrCastPtr item
    gmi' <- unsafeManagedPtrCastPtr gmi
    parent' <- unsafeManagedPtrCastPtr parent
    dbusmenu_gtkclient_newitem_base client' item' gmi' parent'
    touchManagedPtr client
    touchManagedPtr item
    touchManagedPtr gmi
    touchManagedPtr parent
    return ()

#if defined(ENABLE_OVERLOADING)
data ClientNewitemBaseMethodInfo
instance (signature ~ (b -> c -> d -> m ()), MonadIO m, IsClient a, Dbusmenu.Menuitem.IsMenuitem b, Gtk.MenuItem.IsMenuItem c, Dbusmenu.Menuitem.IsMenuitem d) => O.OverloadedMethod ClientNewitemBaseMethodInfo a signature where
    overloadedMethod = clientNewitemBase

instance O.OverloadedMethodInfo ClientNewitemBaseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.DbusmenuGtk3.Objects.Client.clientNewitemBase",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenugtk3-0.4.15/docs/GI-DbusmenuGtk3-Objects-Client.html#v:clientNewitemBase"
        })


#endif

-- method Client::set_accel_group
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "DbusmenuGtk3" , name = "Client" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "To set the group on"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "agroup"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AccelGroup" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The new acceleration group"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_gtkclient_set_accel_group" dbusmenu_gtkclient_set_accel_group :: 
    Ptr Client ->                           -- client : TInterface (Name {namespace = "DbusmenuGtk3", name = "Client"})
    Ptr Gtk.AccelGroup.AccelGroup ->        -- agroup : TInterface (Name {namespace = "Gtk", name = "AccelGroup"})
    IO ()

-- | Sets the acceleration group for the menu items with accelerators
-- on this client.
clientSetAccelGroup ::
    (B.CallStack.HasCallStack, MonadIO m, IsClient a, Gtk.AccelGroup.IsAccelGroup b) =>
    a
    -- ^ /@client@/: To set the group on
    -> b
    -- ^ /@agroup@/: The new acceleration group
    -> m ()
clientSetAccelGroup client agroup = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    agroup' <- unsafeManagedPtrCastPtr agroup
    dbusmenu_gtkclient_set_accel_group client' agroup'
    touchManagedPtr client
    touchManagedPtr agroup
    return ()

#if defined(ENABLE_OVERLOADING)
data ClientSetAccelGroupMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsClient a, Gtk.AccelGroup.IsAccelGroup b) => O.OverloadedMethod ClientSetAccelGroupMethodInfo a signature where
    overloadedMethod = clientSetAccelGroup

instance O.OverloadedMethodInfo ClientSetAccelGroupMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.DbusmenuGtk3.Objects.Client.clientSetAccelGroup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenugtk3-0.4.15/docs/GI-DbusmenuGtk3-Objects-Client.html#v:clientSetAccelGroup"
        })


#endif


