/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, filter, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_filter_fft_filter_fff = R"doc(Fast FFT filter with float input, float output and float taps.

This block implements a real-value decimating filter using the fast convolution method via an FFT. The decimation factor is an integer that is greater than or equal to 1.


The filter takes a set of real-valued taps to use in the filtering operation. These taps can be defined as anything that satisfies the user's filtering needs. For standard filters such as lowpass, highpass, bandpass, etc., the filter.firdes and filter.optfir classes provide convenient generating methods.


This filter is implemented by using the FFTW package to perform the required FFTs. An optional argument, nthreads, may be passed to the constructor (or set using the set_nthreads member function) to split the FFT among N number of threads. This can improve performance on very large FFTs (that is, if the number of taps used is very large) if you have enough threads/cores to support it.

Constructor Specific Documentation:

Build an FFT filter block.

Args:
    decimation : >= 1
    taps : float filter taps
    nthreads : number of threads for the FFT to use)doc";


static const char* __doc_gr_filter_fft_filter_fff_fft_filter_fff_0 = R"doc()doc";


static const char* __doc_gr_filter_fft_filter_fff_fft_filter_fff_1 = R"doc()doc";


static const char* __doc_gr_filter_fft_filter_fff_make = R"doc(Fast FFT filter with float input, float output and float taps.

This block implements a real-value decimating filter using the fast convolution method via an FFT. The decimation factor is an integer that is greater than or equal to 1.


The filter takes a set of real-valued taps to use in the filtering operation. These taps can be defined as anything that satisfies the user's filtering needs. For standard filters such as lowpass, highpass, bandpass, etc., the filter.firdes and filter.optfir classes provide convenient generating methods.


This filter is implemented by using the FFTW package to perform the required FFTs. An optional argument, nthreads, may be passed to the constructor (or set using the set_nthreads member function) to split the FFT among N number of threads. This can improve performance on very large FFTs (that is, if the number of taps used is very large) if you have enough threads/cores to support it.

Constructor Specific Documentation:

Build an FFT filter block.

Args:
    decimation : >= 1
    taps : float filter taps
    nthreads : number of threads for the FFT to use)doc";


static const char* __doc_gr_filter_fft_filter_fff_set_taps = R"doc()doc";


static const char* __doc_gr_filter_fft_filter_fff_taps = R"doc()doc";


static const char* __doc_gr_filter_fft_filter_fff_set_nthreads = R"doc(Set number of threads to use.)doc";


static const char* __doc_gr_filter_fft_filter_fff_nthreads = R"doc(Get number of threads being used.)doc";
