/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_tags_strobe = R"doc(Send tags at defined interval.

Sends a tag with key 'strobe' and a user-defined value (as a PMT) every  number of samples. Useful for testing/debugging the tags system.


Because tags are sent with a data stream, this is a source block that acts identical to a null_source block.

Constructor Specific Documentation:

Make a tags stobe block to send tags with value  every  number of samples.

Args:
    sizeof_stream_item : size of the stream items in bytes.
    value : The value of the tags to send, as a PMT.
    nsamps : the number of samples between each tag.
    key : The tag key to sent)doc";


static const char* __doc_gr_blocks_tags_strobe_tags_strobe_0 = R"doc()doc";


static const char* __doc_gr_blocks_tags_strobe_tags_strobe_1 = R"doc()doc";


static const char* __doc_gr_blocks_tags_strobe_make = R"doc(Send tags at defined interval.

Sends a tag with key 'strobe' and a user-defined value (as a PMT) every  number of samples. Useful for testing/debugging the tags system.


Because tags are sent with a data stream, this is a source block that acts identical to a null_source block.

Constructor Specific Documentation:

Make a tags stobe block to send tags with value  every  number of samples.

Args:
    sizeof_stream_item : size of the stream items in bytes.
    value : The value of the tags to send, as a PMT.
    nsamps : the number of samples between each tag.
    key : The tag key to sent)doc";


static const char* __doc_gr_blocks_tags_strobe_set_value = R"doc(Reset the value of the tags being sent.)doc";


static const char* __doc_gr_blocks_tags_strobe_set_key = R"doc(Change the tag key we are sending)doc";


static const char* __doc_gr_blocks_tags_strobe_value = R"doc(Get the value of the tags being sent.)doc";


static const char* __doc_gr_blocks_tags_strobe_key = R"doc(Get the key of the tags being sent.)doc";


static const char* __doc_gr_blocks_tags_strobe_set_nsamps = R"doc(Reset the sending interval.)doc";


static const char* __doc_gr_blocks_tags_strobe_nsamps = R"doc(Get the number of samples between the tag strobe.)doc";
