/* machine.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from machine.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "common.h"
#include <stdlib.h>
#include <string.h>
#include <handy.h>
#include <cairo-gobject.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <glib/gstdio.h>

#define BOXES_MACHINE_AUTOSAVE_TIMEOUT ((guint) 60)
#define BOXES_MACHINE_SCREENSHOT_WIDTH 180
#define BOXES_MACHINE_SCREENSHOT_HEIGHT 134
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOXES_TYPE_UI (boxes_ui_get_type ())
#define BOXES_UI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_UI, BoxesUI))
#define BOXES_IS_UI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_UI))
#define BOXES_UI_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BOXES_TYPE_UI, BoxesUIIface))

typedef struct _BoxesUI BoxesUI;
typedef struct _BoxesUIIface BoxesUIIface;
typedef enum  {
	BOXES_UI_STATE_NONE,
	BOXES_UI_STATE_COLLECTION,
	BOXES_UI_STATE_CREDS,
	BOXES_UI_STATE_DISPLAY,
	BOXES_UI_STATE_WIZARD,
	BOXES_UI_STATE_PROPERTIES,
	BOXES_UI_STATE_TROUBLESHOOT
} BoxesUIState;

#define BOXES_TYPE_UI_STATE (boxes_ui_state_get_type ())

#define BOXES_TYPE_COLLECTION_ITEM (boxes_collection_item_get_type ())
#define BOXES_COLLECTION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItem))
#define BOXES_COLLECTION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItemClass))
#define BOXES_IS_COLLECTION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_COLLECTION_ITEM))
#define BOXES_IS_COLLECTION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_COLLECTION_ITEM))
#define BOXES_COLLECTION_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItemClass))

typedef struct _BoxesCollectionItem BoxesCollectionItem;
typedef struct _BoxesCollectionItemClass BoxesCollectionItemClass;
typedef struct _BoxesCollectionItemPrivate BoxesCollectionItemPrivate;

#define BOXES_TYPE_MACHINE (boxes_machine_get_type ())
#define BOXES_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_MACHINE, BoxesMachine))
#define BOXES_MACHINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_MACHINE, BoxesMachineClass))
#define BOXES_IS_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_MACHINE))
#define BOXES_IS_MACHINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_MACHINE))
#define BOXES_MACHINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_MACHINE, BoxesMachineClass))

typedef struct _BoxesMachine BoxesMachine;
typedef struct _BoxesMachineClass BoxesMachineClass;
typedef struct _BoxesMachinePrivate BoxesMachinePrivate;
typedef enum  {
	BOXES_MACHINE_CONNECT_FLAGS_NONE = 0,
	BOXES_MACHINE_CONNECT_FLAGS_IGNORE_SAVED_STATE = 1 << 0
} BoxesMachineConnectFlags;

#define BOXES_MACHINE_TYPE_CONNECT_FLAGS (boxes_machine_connect_flags_get_type ())
typedef enum  {
	BOXES_MACHINE_MACHINE_STATE_UNKNOWN,
	BOXES_MACHINE_MACHINE_STATE_STOPPED,
	BOXES_MACHINE_MACHINE_STATE_FORCE_STOPPED,
	BOXES_MACHINE_MACHINE_STATE_RUNNING,
	BOXES_MACHINE_MACHINE_STATE_PAUSED,
	BOXES_MACHINE_MACHINE_STATE_SAVED,
	BOXES_MACHINE_MACHINE_STATE_SLEEPING
} BoxesMachineMachineState;

#define BOXES_MACHINE_TYPE_MACHINE_STATE (boxes_machine_machine_state_get_type ())

#define BOXES_TYPE_APP_WINDOW (boxes_app_window_get_type ())
#define BOXES_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_APP_WINDOW, BoxesAppWindow))
#define BOXES_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_APP_WINDOW, BoxesAppWindowClass))
#define BOXES_IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_APP_WINDOW))
#define BOXES_IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_APP_WINDOW))
#define BOXES_APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_APP_WINDOW, BoxesAppWindowClass))

typedef struct _BoxesAppWindow BoxesAppWindow;
typedef struct _BoxesAppWindowClass BoxesAppWindowClass;

#define BOXES_TYPE_DISPLAY (boxes_display_get_type ())
#define BOXES_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_DISPLAY, BoxesDisplay))
#define BOXES_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_DISPLAY, BoxesDisplayClass))
#define BOXES_IS_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_DISPLAY))
#define BOXES_IS_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_DISPLAY))
#define BOXES_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_DISPLAY, BoxesDisplayClass))

typedef struct _BoxesDisplay BoxesDisplay;
typedef struct _BoxesDisplayClass BoxesDisplayClass;
enum  {
	BOXES_MACHINE_0_PROPERTY,
	BOXES_MACHINE_PIXBUF_PROPERTY,
	BOXES_MACHINE_STATUS_PROPERTY,
	BOXES_MACHINE_SUSPEND_AT_EXIT_PROPERTY,
	BOXES_MACHINE_CAN_SAVE_PROPERTY,
	BOXES_MACHINE_CAN_RESTART_PROPERTY,
	BOXES_MACHINE_CAN_CLONE_PROPERTY,
	BOXES_MACHINE_CAN_DELETE_PROPERTY,
	BOXES_MACHINE_UNDER_CONSTRUCTION_PROPERTY,
	BOXES_MACHINE_SHOULD_AUTOSAVE_PROPERTY,
	BOXES_MACHINE_IS_CONNECTED_PROPERTY,
	BOXES_MACHINE_IS_RUNNING_PROPERTY,
	BOXES_MACHINE_IS_ON_PROPERTY,
	BOXES_MACHINE_IS_STOPPED_PROPERTY,
	BOXES_MACHINE_IS_LOCAL_PROPERTY,
	BOXES_MACHINE_CONNECTING_CANCELLABLE_PROPERTY,
	BOXES_MACHINE_STATE_PROPERTY,
	BOXES_MACHINE_WINDOW_PROPERTY,
	BOXES_MACHINE_DELETED_PROPERTY,
	BOXES_MACHINE_DISPLAY_PROPERTY,
	BOXES_MACHINE_NUM_PROPERTIES
};
static GParamSpec* boxes_machine_properties[BOXES_MACHINE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _BoxesAppWindowPrivate BoxesAppWindowPrivate;

#define BOXES_TYPE_SEARCHBAR (boxes_searchbar_get_type ())
#define BOXES_SEARCHBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_SEARCHBAR, BoxesSearchbar))
#define BOXES_SEARCHBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_SEARCHBAR, BoxesSearchbarClass))
#define BOXES_IS_SEARCHBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_SEARCHBAR))
#define BOXES_IS_SEARCHBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_SEARCHBAR))
#define BOXES_SEARCHBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_SEARCHBAR, BoxesSearchbarClass))

typedef struct _BoxesSearchbar BoxesSearchbar;
typedef struct _BoxesSearchbarClass BoxesSearchbarClass;

#define BOXES_TYPE_TOPBAR (boxes_topbar_get_type ())
#define BOXES_TOPBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_TOPBAR, BoxesTopbar))
#define BOXES_TOPBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_TOPBAR, BoxesTopbarClass))
#define BOXES_IS_TOPBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_TOPBAR))
#define BOXES_IS_TOPBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_TOPBAR))
#define BOXES_TOPBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_TOPBAR, BoxesTopbarClass))

typedef struct _BoxesTopbar BoxesTopbar;
typedef struct _BoxesTopbarClass BoxesTopbarClass;

#define BOXES_TYPE_TOAST_OVERLAY (boxes_toast_overlay_get_type ())
#define BOXES_TOAST_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_TOAST_OVERLAY, BoxesToastOverlay))
#define BOXES_TOAST_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_TOAST_OVERLAY, BoxesToastOverlayClass))
#define BOXES_IS_TOAST_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_TOAST_OVERLAY))
#define BOXES_IS_TOAST_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_TOAST_OVERLAY))
#define BOXES_TOAST_OVERLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_TOAST_OVERLAY, BoxesToastOverlayClass))

typedef struct _BoxesToastOverlay BoxesToastOverlay;
typedef struct _BoxesToastOverlayClass BoxesToastOverlayClass;

#define BOXES_TYPE_DISPLAY_PAGE (boxes_display_page_get_type ())
#define BOXES_DISPLAY_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_DISPLAY_PAGE, BoxesDisplayPage))
#define BOXES_DISPLAY_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_DISPLAY_PAGE, BoxesDisplayPageClass))
#define BOXES_IS_DISPLAY_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_DISPLAY_PAGE))
#define BOXES_IS_DISPLAY_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_DISPLAY_PAGE))
#define BOXES_DISPLAY_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_DISPLAY_PAGE, BoxesDisplayPageClass))

typedef struct _BoxesDisplayPage BoxesDisplayPage;
typedef struct _BoxesDisplayPageClass BoxesDisplayPageClass;

#define BOXES_TYPE_TROUBLESHOOT_VIEW (boxes_troubleshoot_view_get_type ())
#define BOXES_TROUBLESHOOT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_TROUBLESHOOT_VIEW, BoxesTroubleshootView))
#define BOXES_TROUBLESHOOT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_TROUBLESHOOT_VIEW, BoxesTroubleshootViewClass))
#define BOXES_IS_TROUBLESHOOT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_TROUBLESHOOT_VIEW))
#define BOXES_IS_TROUBLESHOOT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_TROUBLESHOOT_VIEW))
#define BOXES_TROUBLESHOOT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_TROUBLESHOOT_VIEW, BoxesTroubleshootViewClass))

typedef struct _BoxesTroubleshootView BoxesTroubleshootView;
typedef struct _BoxesTroubleshootViewClass BoxesTroubleshootViewClass;

#define BOXES_TYPE_APP (boxes_app_get_type ())
#define BOXES_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_APP, BoxesApp))
#define BOXES_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_APP, BoxesAppClass))
#define BOXES_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_APP))
#define BOXES_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_APP))
#define BOXES_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_APP, BoxesAppClass))

typedef struct _BoxesApp BoxesApp;
typedef struct _BoxesAppClass BoxesAppClass;
typedef struct _BoxesMachineSaveData BoxesMachineSaveData;
typedef struct _BoxesMachineSaveRealData BoxesMachineSaveRealData;
typedef struct _BoxesMachineTakeScreenshotData BoxesMachineTakeScreenshotData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BoxesMachineUpdateScreenshotData BoxesMachineUpdateScreenshotData;
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
typedef struct _Block39Data Block39Data;
typedef void (*BoxesToastOKFunc) (gpointer user_data);
typedef void (*BoxesToastDismissFunc) (gpointer user_data);

#define BOXES_TYPE_TOAST (boxes_toast_get_type ())
#define BOXES_TOAST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_TOAST, BoxesToast))
#define BOXES_TOAST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_TOAST, BoxesToastClass))
#define BOXES_IS_TOAST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_TOAST))
#define BOXES_IS_TOAST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_TOAST))
#define BOXES_TOAST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_TOAST, BoxesToastClass))

typedef struct _BoxesToast BoxesToast;
typedef struct _BoxesToastClass BoxesToastClass;
typedef struct _BoxesToastPrivate BoxesToastPrivate;

#define BOXES_TYPE_LIBVIRT_MACHINE (boxes_libvirt_machine_get_type ())
#define BOXES_LIBVIRT_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_LIBVIRT_MACHINE, BoxesLibvirtMachine))
#define BOXES_LIBVIRT_MACHINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_LIBVIRT_MACHINE, BoxesLibvirtMachineClass))
#define BOXES_IS_LIBVIRT_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_LIBVIRT_MACHINE))
#define BOXES_IS_LIBVIRT_MACHINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_LIBVIRT_MACHINE))
#define BOXES_LIBVIRT_MACHINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_LIBVIRT_MACHINE, BoxesLibvirtMachineClass))

typedef struct _BoxesLibvirtMachine BoxesLibvirtMachine;
typedef struct _BoxesLibvirtMachineClass BoxesLibvirtMachineClass;

#define BOXES_TYPE_PREFERENCES_WINDOW (boxes_preferences_window_get_type ())
#define BOXES_PREFERENCES_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_PREFERENCES_WINDOW, BoxesPreferencesWindow))
#define BOXES_PREFERENCES_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_PREFERENCES_WINDOW, BoxesPreferencesWindowClass))
#define BOXES_IS_PREFERENCES_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_PREFERENCES_WINDOW))
#define BOXES_IS_PREFERENCES_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_PREFERENCES_WINDOW))
#define BOXES_PREFERENCES_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_PREFERENCES_WINDOW, BoxesPreferencesWindowClass))

typedef struct _BoxesPreferencesWindow BoxesPreferencesWindow;
typedef struct _BoxesPreferencesWindowClass BoxesPreferencesWindowClass;
typedef struct _BoxesMachineTryConnectDisplayData BoxesMachineTryConnectDisplayData;
typedef struct _BoxesMachineTrySaveData BoxesMachineTrySaveData;
typedef struct _BoxesDisplayPrivate BoxesDisplayPrivate;
typedef gint (*BoxesDisplayOpenFDFunc) (gpointer user_data);
enum  {
	BOXES_MACHINE_GOT_ERROR_SIGNAL,
	BOXES_MACHINE_NUM_SIGNALS
};
static guint boxes_machine_signals[BOXES_MACHINE_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _BoxesUIIface {
	GTypeInterface parent_iface;
	BoxesUIState (*get_previous_ui_state) (BoxesUI* self);
	void (*set_previous_ui_state) (BoxesUI* self, BoxesUIState value);
	BoxesUIState (*get_ui_state) (BoxesUI* self);
	void (*set_ui_state) (BoxesUI* self, BoxesUIState value);
};

struct _BoxesCollectionItem {
	GObject parent_instance;
	BoxesCollectionItemPrivate * priv;
};

struct _BoxesCollectionItemClass {
	GObjectClass parent_class;
	gint (*compare) (BoxesCollectionItem* self, BoxesCollectionItem* other);
};

struct _BoxesMachine {
	BoxesCollectionItem parent_instance;
	BoxesMachinePrivate * priv;
	BoxesCollectionSource* source;
	BoxesBoxConfig* config;
	gboolean stay_on_display;
};

struct _BoxesMachineClass {
	BoxesCollectionItemClass parent_class;
	void (*save_real) (BoxesMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*save_real_finish) (BoxesMachine* self, GAsyncResult* _res_, GError** error);
	void (*take_screenshot) (BoxesMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GdkPixbuf* (*take_screenshot_finish) (BoxesMachine* self, GAsyncResult* _res_, GError** error);
	void (*connect_display) (BoxesMachine* self, BoxesMachineConnectFlags flags, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*connect_display_finish) (BoxesMachine* self, GAsyncResult* _res_, GError** error);
	void (*restart) (BoxesMachine* self);
	void (*clone) (BoxesMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*clone_finish) (BoxesMachine* self, GAsyncResult* _res_);
	void (*disconnect_display) (BoxesMachine* self);
	void (*update_status) (BoxesMachine* self);
	void (*delete) (BoxesMachine* self, gboolean by_user);
	gboolean (*get_suspend_at_exit) (BoxesMachine* self);
	gboolean (*get_can_save) (BoxesMachine* self);
	gboolean (*get_can_restart) (BoxesMachine* self);
	gboolean (*get_can_clone) (BoxesMachine* self);
	gboolean (*get_should_autosave) (BoxesMachine* self);
	gboolean (*get_is_local) (BoxesMachine* self);
};

struct _BoxesMachinePrivate {
	GdkPixbuf* _pixbuf;
	gchar* _status;
	gboolean _can_delete;
	gboolean _under_construction;
	gulong show_id;
	gulong hide_id;
	gulong disconnected_id;
	gulong ui_state_id;
	gulong got_error_id;
	guint screenshot_id;
	gboolean updating_screenshot;
	guint autosave_timeout_id;
	GCancellable* _connecting_cancellable;
	GdkPixbuf* orig_pixbuf;
	BoxesMachineMachineState _state;
	BoxesAppWindow* _window;
	gboolean _deleted;
	BoxesDisplay* _display;
	gboolean saving;
	gint screenshot_counter;
	GBinding* name_status_bind;
};

struct _BoxesAppWindow {
	HdyApplicationWindow parent_instance;
	BoxesAppWindowPrivate * priv;
	BoxesSearchbar* searchbar;
	BoxesTopbar* topbar;
	BoxesToastOverlay* toast_overlay;
	BoxesDisplayPage* display_page;
	HdyStatusPage* empty_boxes;
	BoxesTroubleshootView* troubleshoot_view;
	GtkStack* below_bin;
	GSettings* settings;
};

struct _BoxesAppWindowClass {
	HdyApplicationWindowClass parent_class;
};

struct _BoxesMachineSaveData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BoxesMachine* self;
	BoxesMachineMachineState _tmp0_;
	BoxesMachineMachineState _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GError* _inner_error1_;
	GError* _inner_error0_;
};

struct _BoxesMachineSaveRealData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BoxesMachine* self;
};

struct _BoxesMachineTakeScreenshotData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BoxesMachine* self;
	GdkPixbuf* result;
	BoxesDisplay* _tmp0_;
	BoxesDisplay* _tmp1_;
	GdkPixbuf* _tmp2_;
	BoxesDisplay* _tmp3_;
	BoxesDisplay* _tmp4_;
	GdkPixbuf* _tmp5_;
	GdkPixbuf* _tmp6_;
	GError* _inner_error0_;
};

struct _BoxesMachineUpdateScreenshotData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BoxesMachine* self;
	gboolean force_save;
	gboolean first_check;
	GdkPixbuf* large_screenshot;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	GdkPixbuf* _tmp5_;
	GdkPixbuf* _tmp6_;
	gboolean _tmp7_;
	gint _tmp8_;
	GdkPixbuf* _tmp9_;
	GError* _inner_error0_;
};

struct _Block39Data {
	int _ref_count_;
	BoxesMachine* self;
	BoxesMachineConnectFlags flags;
	gpointer _async_data_;
};

struct _BoxesToast {
	GtkBox parent_instance;
	BoxesToastPrivate * priv;
	BoxesToastOKFunc undo_func;
	gpointer undo_func_target;
	GDestroyNotify undo_func_target_destroy_notify;
	BoxesToastDismissFunc dismiss_func;
	gpointer dismiss_func_target;
	GDestroyNotify dismiss_func_target_destroy_notify;
};

struct _BoxesToastClass {
	GtkBoxClass parent_class;
};

struct _BoxesMachineTryConnectDisplayData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BoxesMachine* self;
	BoxesMachineConnectFlags flags;
	Block39Data* _data39_;
	GError* e;
	BoxesToastOKFunc restart_func;
	gpointer restart_func_target;
	GDestroyNotify restart_func_target_destroy_notify;
	BoxesToastDismissFunc dismiss_func;
	gpointer dismiss_func_target;
	GDestroyNotify dismiss_func_target_destroy_notify;
	gchar* message;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GError* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	BoxesAppWindow* _tmp5_;
	BoxesAppWindow* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	BoxesToastOKFunc _tmp10_;
	gpointer _tmp10__target;
	GDestroyNotify _tmp10__target_destroy_notify;
	BoxesToastDismissFunc _tmp11_;
	gpointer _tmp11__target;
	GDestroyNotify _tmp11__target_destroy_notify;
	BoxesToast* _tmp12_;
	BoxesToast* _tmp13_;
	GError* _vala1_e;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	GError* _tmp16_;
	const gchar* _tmp17_;
	BoxesAppWindow* _tmp18_;
	BoxesAppWindow* _tmp19_;
	gchar* msg;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	BoxesToastOKFunc troubleshoot;
	gpointer troubleshoot_target;
	GDestroyNotify troubleshoot_target_destroy_notify;
	BoxesAppWindow* _tmp23_;
	BoxesAppWindow* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	BoxesToastOKFunc _tmp28_;
	gpointer _tmp28__target;
	GDestroyNotify _tmp28__target_destroy_notify;
	BoxesToast* _tmp29_;
	BoxesToast* _tmp30_;
	BoxesAppWindow* _tmp31_;
	BoxesAppWindow* _tmp32_;
	const gchar* _tmp33_;
	BoxesToast* _tmp34_;
	BoxesToast* _tmp35_;
	BoxesAppWindow* _tmp36_;
	BoxesAppWindow* _tmp37_;
	GError* _vala2_e;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	GError* _tmp40_;
	const gchar* _tmp41_;
	BoxesAppWindow* _tmp42_;
	BoxesAppWindow* _tmp43_;
	gchar* _vala1_message;
	const gchar* _tmp44_;
	const gchar* _tmp45_;
	GError* _tmp46_;
	const gchar* _tmp47_;
	gchar* _tmp48_;
	BoxesAppWindow* _tmp49_;
	BoxesAppWindow* _tmp50_;
	const gchar* _tmp51_;
	BoxesToast* _tmp52_;
	BoxesToast* _tmp53_;
	GError* _inner_error0_;
};

struct _BoxesMachineTrySaveData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BoxesMachine* self;
	GError* _error_;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GError* _tmp2_;
	const gchar* _tmp3_;
	GError* _inner_error0_;
};

struct _BoxesDisplay {
	GObject parent_instance;
	BoxesDisplayPrivate * priv;
	gboolean connected;
	GHashTable* displays;
};

struct _BoxesDisplayClass {
	GObjectClass parent_class;
	GtkWidget* (*get_display) (BoxesDisplay* self, gint n);
	GdkPixbuf* (*get_pixbuf) (BoxesDisplay* self, gint n, GError** error);
	void (*set_enable_audio) (BoxesDisplay* self, gboolean enable);
	gboolean (*should_keep_alive) (BoxesDisplay* self);
	void (*connect_it) (BoxesDisplay* self, BoxesDisplayOpenFDFunc open_fd, gpointer open_fd_target, GDestroyNotify open_fd_target_destroy_notify, GError** error);
	void (*disconnect_it) (BoxesDisplay* self);
	void (*collect_logs) (BoxesDisplay* self, GString* builder);
	void (*transfer_files) (BoxesDisplay* self, GList* uris);
	void (*send_keys) (BoxesDisplay* self, guint* keyvals, gint keyvals_length1);
	const gchar* (*get_protocol) (BoxesDisplay* self);
	gchar* (*get_uri) (BoxesDisplay* self);
	gboolean (*get_can_transfer_files) (BoxesDisplay* self);
};

static gint BoxesMachine_private_offset;
static gpointer boxes_machine_parent_class = NULL;
static cairo_surface_t* boxes_machine_grid_surface;
static cairo_surface_t* boxes_machine_grid_surface = NULL;
VALA_EXTERN BoxesApp* boxes_app_app;

VALA_EXTERN GType boxes_ui_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType boxes_ui_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesUI, g_object_unref)
VALA_EXTERN GType boxes_collection_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesCollectionItem, g_object_unref)
VALA_EXTERN GType boxes_machine_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesMachine, g_object_unref)
VALA_EXTERN GType boxes_machine_connect_flags_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType boxes_machine_machine_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType boxes_app_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesAppWindow, g_object_unref)
VALA_EXTERN GType boxes_display_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesDisplay, g_object_unref)
VALA_EXTERN void boxes_machine_save_real (BoxesMachine* self,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_);
VALA_EXTERN void boxes_machine_save_real_finish (BoxesMachine* self,
                                     GAsyncResult* _res_,
                                     GError** error);
VALA_EXTERN void boxes_machine_take_screenshot (BoxesMachine* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN GdkPixbuf* boxes_machine_take_screenshot_finish (BoxesMachine* self,
                                                 GAsyncResult* _res_,
                                                 GError** error);
VALA_EXTERN void boxes_machine_restart (BoxesMachine* self);
VALA_EXTERN void boxes_machine_disconnect_display (BoxesMachine* self);
VALA_EXTERN void boxes_machine_update_status (BoxesMachine* self);
VALA_EXTERN void boxes_machine_delete (BoxesMachine* self,
                           gboolean by_user);
VALA_EXTERN gint boxes_collection_item_compare (BoxesCollectionItem* self,
                                    BoxesCollectionItem* other);
VALA_EXTERN gboolean boxes_machine_get_suspend_at_exit (BoxesMachine* self);
VALA_EXTERN gboolean boxes_machine_get_can_save (BoxesMachine* self);
VALA_EXTERN gboolean boxes_machine_get_should_autosave (BoxesMachine* self);
VALA_EXTERN gboolean boxes_machine_get_is_local (BoxesMachine* self);
VALA_EXTERN void boxes_machine_show_display (BoxesMachine* self);
VALA_EXTERN BoxesAppWindow* boxes_machine_get_window (BoxesMachine* self);
VALA_EXTERN BoxesUIState boxes_ui_get_ui_state (BoxesUI* self);
VALA_EXTERN void boxes_ui_set_state (BoxesUI* self,
                         BoxesUIState new_state);
VALA_EXTERN BoxesDisplay* boxes_machine_get_display (BoxesMachine* self);
VALA_EXTERN GtkWidget* boxes_display_get_display (BoxesDisplay* self,
                                      gint n);
VALA_EXTERN void boxes_widget_remove (GtkWidget* widget);
VALA_EXTERN GType boxes_searchbar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesSearchbar, g_object_unref)
VALA_EXTERN GType boxes_topbar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesTopbar, g_object_unref)
VALA_EXTERN GType boxes_toast_overlay_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesToastOverlay, g_object_unref)
VALA_EXTERN GType boxes_display_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesDisplayPage, g_object_unref)
VALA_EXTERN GType boxes_troubleshoot_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesTroubleshootView, g_object_unref)
VALA_EXTERN void boxes_display_page_show_display (BoxesDisplayPage* self,
                                      BoxesDisplay* display,
                                      GtkWidget* widget);
VALA_EXTERN const gchar* boxes_collection_item_get_name (BoxesCollectionItem* self);
VALA_EXTERN void boxes_topbar_set_status (BoxesTopbar* self,
                              const gchar* value);
VALA_EXTERN void boxes_display_page_replace_display (BoxesDisplayPage* self,
                                         BoxesDisplay* display,
                                         GtkWidget* widget);
VALA_EXTERN BoxesMachine* boxes_machine_construct (GType object_type,
                                       BoxesCollectionSource* source,
                                       const gchar* name,
                                       const gchar* uuid);
VALA_EXTERN BoxesCollectionItem* boxes_collection_item_construct (GType object_type);
VALA_EXTERN void boxes_collection_item_set_name (BoxesCollectionItem* self,
                                     const gchar* value);
VALA_EXTERN void boxes_machine_set_connecting_cancellable (BoxesMachine* self,
                                               GCancellable* value);
static void boxes_machine_ui_state_changed (BoxesMachine* self);
static void _boxes_machine_ui_state_changed_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
VALA_EXTERN GType boxes_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesApp, g_object_unref)
VALA_EXTERN BoxesAppWindow* boxes_app_get_main_window (BoxesApp* self);
static void __lambda134_ (BoxesMachine* self);
VALA_EXTERN void boxes_machine_set_screenshot_enable (BoxesMachine* self,
                                          gboolean enable);
static void ___lambda134__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void boxes_machine_create_display_config (BoxesMachine* self,
                                          const gchar* uuid);
static void __lambda135_ (BoxesMachine* self);
VALA_EXTERN gboolean boxes_machine_get_under_construction (BoxesMachine* self);
VALA_EXTERN void boxes_app_inhibit (BoxesApp* self,
                        GtkWindow* window,
                        GtkApplicationInhibitFlags* flags,
                        const gchar* reason);
VALA_EXTERN void boxes_app_uninhibit (BoxesApp* self);
static void ___lambda135__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
VALA_EXTERN void boxes_machine_load_screenshot (BoxesMachine* self);
VALA_EXTERN BoxesMachineMachineState boxes_machine_get_state (BoxesMachine* self);
static gchar* boxes_machine_get_screenshot_filename (BoxesMachine* self,
                                              GError** error);
static void boxes_machine_set_screenshot (BoxesMachine* self,
                                   GdkPixbuf* large_screenshot,
                                   gboolean save);
static void boxes_machine_update_screenshot (BoxesMachine* self,
                                      gboolean force_save,
                                      gboolean first_check,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static void boxes_machine_update_screenshot_finish (BoxesMachine* self,
                                             GAsyncResult* _res_);
static gboolean ___lambda40_ (BoxesMachine* self);
static gboolean ____lambda40__gsource_func (gpointer self);
static void boxes_machine_save_data_free (gpointer _data);
VALA_EXTERN void boxes_machine_save (BoxesMachine* self,
                         GAsyncReadyCallback _callback_,
                         gpointer _user_data_);
VALA_EXTERN void boxes_machine_save_finish (BoxesMachine* self,
                                GAsyncResult* _res_,
                                GError** error);
static gboolean boxes_machine_save_co (BoxesMachineSaveData* _data_);
static void boxes_machine_save_ready (GObject* source_object,
                               GAsyncResult* _res_,
                               gpointer _user_data_);
VALA_EXTERN void boxes_machine_schedule_autosave (BoxesMachine* self);
static gboolean __lambda8_ (BoxesMachine* self);
static void boxes_machine_try_save (BoxesMachine* self,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_);
static void boxes_machine_try_save_finish (BoxesMachine* self,
                                    GAsyncResult* _res_);
static gboolean ___lambda8__gsource_func (gpointer self);
VALA_EXTERN void boxes_machine_unschedule_autosave (BoxesMachine* self);
static void boxes_machine_real_save_real_data_free (gpointer _data);
static void boxes_machine_real_save_real (BoxesMachine* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
static gboolean boxes_machine_real_save_real_co (BoxesMachineSaveRealData* _data_);
static void boxes_machine_real_take_screenshot_data_free (gpointer _data);
static void boxes_machine_real_take_screenshot (BoxesMachine* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static gboolean boxes_machine_real_take_screenshot_co (BoxesMachineTakeScreenshotData* _data_);
VALA_EXTERN GdkPixbuf* boxes_display_get_pixbuf (BoxesDisplay* self,
                                     gint n,
                                     GError** error);
VALA_EXTERN void boxes_machine_connect_display (BoxesMachine* self,
                                    BoxesMachineConnectFlags flags,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN void boxes_machine_connect_display_finish (BoxesMachine* self,
                                           GAsyncResult* _res_,
                                           GError** error);
static void boxes_machine_real_restart (BoxesMachine* self);
VALA_EXTERN void boxes_machine_clone (BoxesMachine* self,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_);
VALA_EXTERN void boxes_machine_clone_finish (BoxesMachine* self,
                                 GAsyncResult* _res_);
static void boxes_machine_real_disconnect_display (BoxesMachine* self);
VALA_EXTERN BoxesCollectionItem* boxes_app_window_get_current_item (BoxesAppWindow* self);
VALA_EXTERN GtkWidget* boxes_display_page_remove_display (BoxesDisplayPage* self);
VALA_EXTERN gboolean boxes_display_should_keep_alive (BoxesDisplay* self);
VALA_EXTERN void boxes_display_disconnect_it (BoxesDisplay* self);
VALA_EXTERN void boxes_machine_set_display (BoxesMachine* self,
                                BoxesDisplay* value);
VALA_EXTERN void boxes_display_set_enable_audio (BoxesDisplay* self,
                                     gboolean enable);
VALA_EXTERN void boxes_machine_set_window (BoxesMachine* self,
                               BoxesAppWindow* value);
static void boxes_machine_real_update_status (BoxesMachine* self);
VALA_EXTERN void boxes_machine_set_status (BoxesMachine* self,
                               const gchar* value);
static void boxes_machine_save_pixbuf_as_screenshot (BoxesMachine* self,
                                              GdkPixbuf* pixbuf);
static gint boxes_machine_pixbuf_energy (BoxesMachine* self,
                                  GdkPixbuf* pixbuf);
static GdkPixbuf* boxes_machine_draw_vm (BoxesMachine* self,
                                  GdkPixbuf* pixbuf,
                                  gint width,
                                  gint height);
VALA_EXTERN void boxes_machine_set_pixbuf (BoxesMachine* self,
                               GdkPixbuf* value);
static GdkPixbuf* boxes_machine_draw_stopped_vm (gint width,
                                          gint height);
static void boxes_machine_update_screenshot_data_free (gpointer _data);
static gboolean boxes_machine_update_screenshot_co (BoxesMachineUpdateScreenshotData* _data_);
static void boxes_machine_update_screenshot_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
VALA_EXTERN gboolean boxes_machine_get_is_running (BoxesMachine* self);
static void boxes_machine_real_delete (BoxesMachine* self,
                                gboolean by_user);
static void boxes_machine_set_deleted (BoxesMachine* self,
                                gboolean value);
static void boxes_machine_try_connect_display (BoxesMachine* self,
                                        BoxesMachineConnectFlags flags,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static void boxes_machine_try_connect_display_finish (BoxesMachine* self,
                                               GAsyncResult* _res_);
VALA_EXTERN BoxesUIState boxes_ui_get_previous_ui_state (BoxesUI* self);
static void boxes_machine_try_connect_display_data_free (gpointer _data);
static gboolean boxes_machine_try_connect_display_co (BoxesMachineTryConnectDisplayData* _data_);
static Block39Data* block39_data_ref (Block39Data* _data39_);
static void block39_data_unref (void * _userdata_);
static void boxes_machine_try_connect_display_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void ___lambda131_ (Block39Data* _data39_);
static void ____lambda131__boxes_toast_ok_func (gpointer self);
static void ___lambda132_ (BoxesMachine* self);
static void ____lambda132__boxes_toast_dismiss_func (gpointer self);
VALA_EXTERN GType boxes_toast_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesToast, g_object_unref)
VALA_EXTERN void boxes_app_window_display_toast (BoxesAppWindow* self,
                                     BoxesToast* toast);
VALA_EXTERN BoxesToast* boxes_toast_new (const gchar* message);
VALA_EXTERN BoxesToast* boxes_toast_construct (GType object_type,
                                   const gchar* message);
VALA_EXTERN void boxes_toast_set_message (BoxesToast* self,
                              const gchar* value);
VALA_EXTERN void boxes_toast_set_action (BoxesToast* self,
                             const gchar* value);
VALA_EXTERN GType boxes_libvirt_machine_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesLibvirtMachine, g_object_unref)
static void ____lambda133_ (BoxesMachine* self);
VALA_EXTERN void boxes_app_window_set_current_item (BoxesAppWindow* self,
                                        BoxesCollectionItem* value);
VALA_EXTERN GType boxes_preferences_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesPreferencesWindow, g_object_unref)
VALA_EXTERN BoxesPreferencesWindow* boxes_preferences_window_new (void);
VALA_EXTERN BoxesPreferencesWindow* boxes_preferences_window_construct (GType object_type);
VALA_EXTERN void boxes_preferences_window_set_machine (BoxesPreferencesWindow* self,
                                           BoxesMachine* value);
VALA_EXTERN void boxes_preferences_window_show_troubleshoot_logs (BoxesPreferencesWindow* self);
static void _____lambda133__boxes_toast_ok_func (gpointer self);
static gint boxes_machine_real_compare (BoxesCollectionItem* base,
                                 BoxesCollectionItem* other);
static void boxes_machine_try_save_data_free (gpointer _data);
static gboolean boxes_machine_try_save_co (BoxesMachineTrySaveData* _data_);
static void boxes_machine_try_save_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_);
VALA_EXTERN GdkPixbuf* boxes_machine_get_pixbuf (BoxesMachine* self);
VALA_EXTERN const gchar* boxes_machine_get_status (BoxesMachine* self);
VALA_EXTERN gboolean boxes_machine_get_can_restart (BoxesMachine* self);
VALA_EXTERN gboolean boxes_machine_get_can_clone (BoxesMachine* self);
VALA_EXTERN gboolean boxes_machine_get_can_delete (BoxesMachine* self);
VALA_EXTERN void boxes_machine_set_can_delete (BoxesMachine* self,
                                   gboolean value);
VALA_EXTERN void boxes_machine_set_under_construction (BoxesMachine* self,
                                           gboolean value);
VALA_EXTERN gboolean boxes_machine_get_is_connected (BoxesMachine* self);
VALA_EXTERN gboolean boxes_machine_get_is_on (BoxesMachine* self);
VALA_EXTERN gboolean boxes_machine_get_is_stopped (BoxesMachine* self);
VALA_EXTERN GCancellable* boxes_machine_get_connecting_cancellable (BoxesMachine* self);
VALA_EXTERN void boxes_machine_set_state (BoxesMachine* self,
                              BoxesMachineMachineState value);
VALA_EXTERN gboolean boxes_machine_get_deleted (BoxesMachine* self);
static void _boxes_machine_display___lambda127_ (BoxesMachine* self,
                                          gint id);
static void __boxes_machine_display___lambda127__boxes_display_show (BoxesDisplay* _sender,
                                                              gint display_id,
                                                              gpointer self);
static void _boxes_machine_display___lambda128_ (BoxesMachine* self,
                                          gint id);
static void __boxes_machine_display___lambda128__boxes_display_hide (BoxesDisplay* _sender,
                                                              gint display_id,
                                                              gpointer self);
static void _boxes_machine_display___lambda129_ (BoxesMachine* self,
                                          const gchar* message);
static void __boxes_machine_display___lambda129__boxes_display_got_error (BoxesDisplay* _sender,
                                                                   const gchar* message,
                                                                   gpointer self);
static void _boxes_machine_display___lambda130_ (BoxesMachine* self,
                                          gboolean failed);
static void __boxes_machine_display___lambda130__boxes_display_disconnected (BoxesDisplay* _sender,
                                                                      gboolean connection_failed,
                                                                      gpointer self);
static void boxes_machine_finalize (GObject * obj);
static GType boxes_machine_get_type_once (void);
static void _vala_boxes_machine_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_boxes_machine_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);

static GRegex* _tmp_regex_0 = NULL;

static inline gpointer
boxes_machine_get_instance_private (BoxesMachine* self)
{
	return G_STRUCT_MEMBER_P (self, BoxesMachine_private_offset);
}

static GType
boxes_machine_machine_state_get_type_once (void)
{
	static const GEnumValue values[] = {{BOXES_MACHINE_MACHINE_STATE_UNKNOWN, "BOXES_MACHINE_MACHINE_STATE_UNKNOWN", "unknown"}, {BOXES_MACHINE_MACHINE_STATE_STOPPED, "BOXES_MACHINE_MACHINE_STATE_STOPPED", "stopped"}, {BOXES_MACHINE_MACHINE_STATE_FORCE_STOPPED, "BOXES_MACHINE_MACHINE_STATE_FORCE_STOPPED", "force-stopped"}, {BOXES_MACHINE_MACHINE_STATE_RUNNING, "BOXES_MACHINE_MACHINE_STATE_RUNNING", "running"}, {BOXES_MACHINE_MACHINE_STATE_PAUSED, "BOXES_MACHINE_MACHINE_STATE_PAUSED", "paused"}, {BOXES_MACHINE_MACHINE_STATE_SAVED, "BOXES_MACHINE_MACHINE_STATE_SAVED", "saved"}, {BOXES_MACHINE_MACHINE_STATE_SLEEPING, "BOXES_MACHINE_MACHINE_STATE_SLEEPING", "sleeping"}, {0, NULL, NULL}};
	GType boxes_machine_machine_state_type_id;
	boxes_machine_machine_state_type_id = g_enum_register_static ("BoxesMachineMachineState", values);
	return boxes_machine_machine_state_type_id;
}

GType
boxes_machine_machine_state_get_type (void)
{
	static volatile gsize boxes_machine_machine_state_type_id__once = 0;
	if (g_once_init_enter (&boxes_machine_machine_state_type_id__once)) {
		GType boxes_machine_machine_state_type_id;
		boxes_machine_machine_state_type_id = boxes_machine_machine_state_get_type_once ();
		g_once_init_leave (&boxes_machine_machine_state_type_id__once, boxes_machine_machine_state_type_id);
	}
	return boxes_machine_machine_state_type_id__once;
}

static GType
boxes_machine_connect_flags_get_type_once (void)
{
	static const GFlagsValue values[] = {{BOXES_MACHINE_CONNECT_FLAGS_NONE, "BOXES_MACHINE_CONNECT_FLAGS_NONE", "none"}, {BOXES_MACHINE_CONNECT_FLAGS_IGNORE_SAVED_STATE, "BOXES_MACHINE_CONNECT_FLAGS_IGNORE_SAVED_STATE", "ignore-saved-state"}, {0, NULL, NULL}};
	GType boxes_machine_connect_flags_type_id;
	boxes_machine_connect_flags_type_id = g_flags_register_static ("BoxesMachineConnectFlags", values);
	return boxes_machine_connect_flags_type_id;
}

GType
boxes_machine_connect_flags_get_type (void)
{
	static volatile gsize boxes_machine_connect_flags_type_id__once = 0;
	if (g_once_init_enter (&boxes_machine_connect_flags_type_id__once)) {
		GType boxes_machine_connect_flags_type_id;
		boxes_machine_connect_flags_type_id = boxes_machine_connect_flags_get_type_once ();
		g_once_init_leave (&boxes_machine_connect_flags_type_id__once, boxes_machine_connect_flags_type_id);
	}
	return boxes_machine_connect_flags_type_id__once;
}

void
boxes_machine_show_display (BoxesMachine* self)
{
	BoxesAppWindow* _tmp0_;
	BoxesAppWindow* _tmp1_;
	BoxesUIState _tmp2_;
	BoxesUIState _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = boxes_machine_get_window (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = boxes_ui_get_ui_state ((BoxesUI*) _tmp1_);
	_tmp3_ = _tmp2_;
	switch (_tmp3_) {
		case BOXES_UI_STATE_CREDS:
		{
			BoxesAppWindow* _tmp4_;
			BoxesAppWindow* _tmp5_;
			_tmp4_ = boxes_machine_get_window (self);
			_tmp5_ = _tmp4_;
			boxes_ui_set_state ((BoxesUI*) _tmp5_, BOXES_UI_STATE_DISPLAY);
			boxes_machine_show_display (self);
			break;
		}
		case BOXES_UI_STATE_DISPLAY:
		{
			GtkWidget* widget = NULL;
			BoxesDisplay* _tmp6_;
			BoxesDisplay* _tmp7_;
			GtkWidget* _tmp8_;
			GtkWidget* _tmp9_;
			BoxesAppWindow* _tmp10_;
			BoxesAppWindow* _tmp11_;
			BoxesDisplayPage* _tmp12_;
			BoxesDisplay* _tmp13_;
			BoxesDisplay* _tmp14_;
			GtkWidget* _tmp15_;
			BoxesAppWindow* _tmp16_;
			BoxesAppWindow* _tmp17_;
			BoxesTopbar* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			GtkWidget* _tmp21_;
			_tmp6_ = boxes_machine_get_display (self);
			_tmp7_ = _tmp6_;
			_tmp8_ = boxes_display_get_display (_tmp7_, 0);
			widget = _tmp8_;
			_tmp9_ = widget;
			boxes_widget_remove (_tmp9_);
			_tmp10_ = boxes_machine_get_window (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = _tmp11_->display_page;
			_tmp13_ = boxes_machine_get_display (self);
			_tmp14_ = _tmp13_;
			_tmp15_ = widget;
			boxes_display_page_show_display (_tmp12_, _tmp14_, _tmp15_);
			_tmp16_ = boxes_machine_get_window (self);
			_tmp17_ = _tmp16_;
			_tmp18_ = _tmp17_->topbar;
			_tmp19_ = boxes_collection_item_get_name ((BoxesCollectionItem*) self);
			_tmp20_ = _tmp19_;
			boxes_topbar_set_status (_tmp18_, _tmp20_);
			_tmp21_ = widget;
			gtk_widget_grab_focus (_tmp21_);
			_g_object_unref0 (widget);
			break;
		}
		case BOXES_UI_STATE_PROPERTIES:
		{
			GtkWidget* widget = NULL;
			BoxesDisplay* _tmp22_;
			BoxesDisplay* _tmp23_;
			GtkWidget* _tmp24_;
			GtkWidget* _tmp25_;
			BoxesAppWindow* _tmp26_;
			BoxesAppWindow* _tmp27_;
			BoxesDisplayPage* _tmp28_;
			BoxesDisplay* _tmp29_;
			BoxesDisplay* _tmp30_;
			GtkWidget* _tmp31_;
			_tmp22_ = boxes_machine_get_display (self);
			_tmp23_ = _tmp22_;
			_tmp24_ = boxes_display_get_display (_tmp23_, 0);
			widget = _tmp24_;
			_tmp25_ = widget;
			boxes_widget_remove (_tmp25_);
			_tmp26_ = boxes_machine_get_window (self);
			_tmp27_ = _tmp26_;
			_tmp28_ = _tmp27_->display_page;
			_tmp29_ = boxes_machine_get_display (self);
			_tmp30_ = _tmp29_;
			_tmp31_ = widget;
			boxes_display_page_replace_display (_tmp28_, _tmp30_, _tmp31_);
			_g_object_unref0 (widget);
			break;
		}
		default:
		{
			break;
		}
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_boxes_machine_ui_state_changed_g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	boxes_machine_ui_state_changed ((BoxesMachine*) self);
}

static void
__lambda134_ (BoxesMachine* self)
{
	BoxesApp* _tmp0_;
	BoxesAppWindow* _tmp1_;
	BoxesAppWindow* _tmp2_;
	BoxesUIState _tmp3_;
	BoxesUIState _tmp4_;
	_tmp0_ = boxes_app_app;
	_tmp1_ = boxes_app_get_main_window (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = boxes_ui_get_ui_state ((BoxesUI*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == BOXES_UI_STATE_DISPLAY) {
		boxes_machine_set_screenshot_enable (self, FALSE);
	} else {
		boxes_machine_set_screenshot_enable (self, TRUE);
	}
}

static void
___lambda134__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	__lambda134_ ((BoxesMachine*) self);
}

static void
__lambda135_ (BoxesMachine* self)
{
	gboolean _tmp0_;
	_tmp0_ = self->priv->_under_construction;
	if (_tmp0_) {
		gchar* inhibit_reason = NULL;
		gchar* _tmp1_;
		BoxesApp* _tmp2_;
		const gchar* _tmp3_;
		_tmp1_ = g_strdup (_ ("Machine is under construction"));
		inhibit_reason = _tmp1_;
		_tmp2_ = boxes_app_app;
		_tmp3_ = inhibit_reason;
		boxes_app_inhibit (_tmp2_, NULL, NULL, _tmp3_);
		_g_free0 (inhibit_reason);
	} else {
		BoxesApp* _tmp4_;
		_tmp4_ = boxes_app_app;
		boxes_app_uninhibit (_tmp4_);
	}
}

static void
___lambda135__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	__lambda135_ ((BoxesMachine*) self);
}

BoxesMachine*
boxes_machine_construct (GType object_type,
                         BoxesCollectionSource* source,
                         const gchar* name,
                         const gchar* uuid)
{
	BoxesMachine * self = NULL;
	BoxesCollectionSource* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	BoxesApp* _tmp3_;
	BoxesAppWindow* _tmp4_;
	BoxesAppWindow* _tmp5_;
	gulong _tmp6_;
	g_return_val_if_fail (source != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	self = (BoxesMachine*) boxes_collection_item_construct (object_type);
	boxes_collection_item_set_name ((BoxesCollectionItem*) self, name);
	_tmp0_ = _g_object_ref0 (source);
	_g_object_unref0 (self->source);
	self->source = _tmp0_;
	_tmp1_ = g_cancellable_new ();
	_tmp2_ = _tmp1_;
	boxes_machine_set_connecting_cancellable (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	g_signal_connect_object ((GObject*) self, "notify::ui-state", (GCallback) _boxes_machine_ui_state_changed_g_object_notify, self, 0);
	_tmp3_ = boxes_app_app;
	_tmp4_ = boxes_app_get_main_window (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_signal_connect_object ((GObject*) _tmp5_, "notify::ui-state", (GCallback) ___lambda134__g_object_notify, self, 0);
	self->priv->ui_state_id = _tmp6_;
	boxes_machine_create_display_config (self, uuid);
	g_signal_connect_object ((GObject*) self, "notify::under-construction", (GCallback) ___lambda135__g_object_notify, self, 0);
	return self;
}

void
boxes_machine_load_screenshot (BoxesMachine* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GdkPixbuf* _tmp0_ = NULL;
		gboolean _tmp1_ = FALSE;
		BoxesMachineMachineState _tmp2_;
		BoxesMachineMachineState _tmp3_;
		GdkPixbuf* screenshot = NULL;
		GdkPixbuf* _tmp9_;
		GdkPixbuf* _tmp10_;
		_tmp2_ = boxes_machine_get_state (self);
		_tmp3_ = _tmp2_;
		if (_tmp3_ != BOXES_MACHINE_MACHINE_STATE_STOPPED) {
			BoxesMachineMachineState _tmp4_;
			BoxesMachineMachineState _tmp5_;
			_tmp4_ = boxes_machine_get_state (self);
			_tmp5_ = _tmp4_;
			_tmp1_ = _tmp5_ != BOXES_MACHINE_MACHINE_STATE_FORCE_STOPPED;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
			GdkPixbuf* _tmp8_;
			_tmp7_ = boxes_machine_get_screenshot_filename (self, &_inner_error0_);
			_tmp6_ = _tmp7_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_tmp0_);
				goto __catch0_g_error;
			}
			_tmp8_ = gdk_pixbuf_new_from_file (_tmp6_, &_inner_error0_);
			_g_object_unref0 (_tmp0_);
			_tmp0_ = _tmp8_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (_tmp6_);
				_g_object_unref0 (_tmp0_);
				goto __catch0_g_error;
			}
			_g_free0 (_tmp6_);
		} else {
			_g_object_unref0 (_tmp0_);
			_tmp0_ = NULL;
		}
		_tmp9_ = _g_object_ref0 (_tmp0_);
		screenshot = _tmp9_;
		_tmp10_ = screenshot;
		boxes_machine_set_screenshot (self, _tmp10_, FALSE);
		_g_object_unref0 (screenshot);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gboolean
___lambda40_ (BoxesMachine* self)
{
	gboolean result;
	boxes_machine_update_screenshot (self, FALSE, FALSE, NULL, NULL);
	result = TRUE;
	return result;
}

static gboolean
____lambda40__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda40_ ((BoxesMachine*) self);
	return result;
}

void
boxes_machine_set_screenshot_enable (BoxesMachine* self,
                                     gboolean enable)
{
	g_return_if_fail (self != NULL);
	if (enable) {
		gint interval = 0;
		BoxesApp* _tmp0_;
		BoxesAppWindow* _tmp1_;
		BoxesAppWindow* _tmp2_;
		GSettings* _tmp3_;
		if (self->priv->screenshot_id != ((guint) 0)) {
			return;
		}
		boxes_machine_update_screenshot (self, FALSE, TRUE, NULL, NULL);
		_tmp0_ = boxes_app_app;
		_tmp1_ = boxes_app_get_main_window (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_->settings;
		interval = g_settings_get_int (_tmp3_, "screenshot-interval");
		self->priv->screenshot_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) interval, ____lambda40__gsource_func, g_object_ref (self), g_object_unref);
	} else {
		if (self->priv->screenshot_id != ((guint) 0)) {
			g_source_remove (self->priv->screenshot_id);
		}
		self->priv->screenshot_id = (guint) 0;
	}
}

static gchar*
boxes_machine_get_screenshot_filename (BoxesMachine* self,
                                       GError** error)
{
	BoxesBoxConfig* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	BoxesBoxConfig* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->config;
	_tmp1_ = boxes_box_config_get_uuid (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ == NULL;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		GError* _tmp5_;
		_tmp5_ = g_error_new_literal (BOXES_ERROR, BOXES_ERROR_INVALID, "no uuid, cannot build screenshot filename");
		_inner_error0_ = _tmp5_;
		if (_inner_error0_->domain == BOXES_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp6_ = self->config;
	_tmp7_ = boxes_box_config_get_uuid (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp10_ = boxes_get_screenshot_filename (_tmp9_);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	result = _tmp11_;
	return result;
}

static void
boxes_machine_save_data_free (gpointer _data)
{
	BoxesMachineSaveData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesMachineSaveData, _data_);
}

void
boxes_machine_save (BoxesMachine* self,
                    GAsyncReadyCallback _callback_,
                    gpointer _user_data_)
{
	BoxesMachineSaveData* _data_;
	BoxesMachine* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BoxesMachineSaveData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_machine_save_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	boxes_machine_save_co (_data_);
}

void
boxes_machine_save_finish (BoxesMachine* self,
                           GAsyncResult* _res_,
                           GError** error)
{
	BoxesMachineSaveData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
boxes_machine_save_ready (GObject* source_object,
                          GAsyncResult* _res_,
                          gpointer _user_data_)
{
	BoxesMachineSaveData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_machine_save_co (_data_);
}

static gboolean
boxes_machine_save_co (BoxesMachineSaveData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = boxes_machine_get_state (_data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	if (_data_->_tmp1_ == BOXES_MACHINE_MACHINE_STATE_SAVED) {
		_data_->_tmp2_ = boxes_collection_item_get_name ((BoxesCollectionItem*) _data_->self);
		_data_->_tmp3_ = _data_->_tmp2_;
		g_debug ("machine.vala:300: Not saving '%s' since it's already in saved state.", _data_->_tmp3_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->self->priv->saving = TRUE;
	boxes_machine_update_status (_data_->self);
	{
		_data_->_state_ = 1;
		boxes_machine_save_real (_data_->self, boxes_machine_save_ready, _data_);
		return FALSE;
		_state_1:
		boxes_machine_save_real_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __finally0;
		}
	}
	__finally0:
	{
		_data_->self->priv->saving = FALSE;
		boxes_machine_update_status (_data_->self);
	}
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
__lambda8_ (BoxesMachine* self)
{
	gboolean result;
	boxes_machine_try_save (self, NULL, NULL);
	self->priv->autosave_timeout_id = (guint) 0;
	result = FALSE;
	return result;
}

static gboolean
___lambda8__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda8_ ((BoxesMachine*) self);
	return result;
}

void
boxes_machine_schedule_autosave (BoxesMachine* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = boxes_machine_get_should_autosave (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = boxes_collection_item_get_name ((BoxesCollectionItem*) self);
	_tmp3_ = _tmp2_;
	g_debug ("machine.vala:319: Scheduling autosave for '%s'", _tmp3_);
	self->priv->autosave_timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, BOXES_MACHINE_AUTOSAVE_TIMEOUT, ___lambda8__gsource_func, g_object_ref (self), g_object_unref);
}

void
boxes_machine_unschedule_autosave (BoxesMachine* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->priv->autosave_timeout_id == ((guint) 0)) {
		return;
	}
	_tmp0_ = boxes_collection_item_get_name ((BoxesCollectionItem*) self);
	_tmp1_ = _tmp0_;
	g_debug ("machine.vala:332: Unscheduling autosave for '%s'", _tmp1_);
	g_source_remove (self->priv->autosave_timeout_id);
	self->priv->autosave_timeout_id = (guint) 0;
}

static void
boxes_machine_real_save_real_data_free (gpointer _data)
{
	BoxesMachineSaveRealData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesMachineSaveRealData, _data_);
}

static void
boxes_machine_real_save_real (BoxesMachine* self,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	BoxesMachineSaveRealData* _data_;
	BoxesMachine* _tmp0_;
	_data_ = g_slice_new0 (BoxesMachineSaveRealData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_machine_real_save_real_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	boxes_machine_real_save_real_co (_data_);
}

static void
boxes_machine_real_save_real_finish (BoxesMachine* self,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	BoxesMachineSaveRealData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
boxes_machine_real_save_real_co (BoxesMachineSaveRealData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
boxes_machine_save_real (BoxesMachine* self,
                         GAsyncReadyCallback _callback_,
                         gpointer _user_data_)
{
	BoxesMachineClass* _klass_;
	_klass_ = BOXES_MACHINE_GET_CLASS (self);
	if (_klass_->save_real) {
		_klass_->save_real (self, _callback_, _user_data_);
	}
}

void
boxes_machine_save_real_finish (BoxesMachine* self,
                                GAsyncResult* _res_,
                                GError** error)
{
	BoxesMachineClass* _klass_;
	_klass_ = BOXES_MACHINE_GET_CLASS (self);
	if (_klass_->save_real_finish) {
		_klass_->save_real_finish (self, _res_, error);
	}
}

static void
boxes_machine_real_take_screenshot_data_free (gpointer _data)
{
	BoxesMachineTakeScreenshotData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesMachineTakeScreenshotData, _data_);
}

static void
boxes_machine_real_take_screenshot (BoxesMachine* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	BoxesMachineTakeScreenshotData* _data_;
	BoxesMachine* _tmp0_;
	_data_ = g_slice_new0 (BoxesMachineTakeScreenshotData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_machine_real_take_screenshot_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	boxes_machine_real_take_screenshot_co (_data_);
}

static GdkPixbuf*
boxes_machine_real_take_screenshot_finish (BoxesMachine* self,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	GdkPixbuf* result;
	BoxesMachineTakeScreenshotData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
boxes_machine_real_take_screenshot_co (BoxesMachineTakeScreenshotData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = boxes_machine_get_display (_data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	if (_data_->_tmp1_ == NULL) {
		_data_->result = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = boxes_machine_get_display (_data_->self);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = boxes_display_get_pixbuf (_data_->_tmp4_, 0, &_data_->_inner_error0_);
	_data_->_tmp2_ = _data_->_tmp5_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->_tmp2_;
	_data_->_tmp2_ = NULL;
	_data_->result = _data_->_tmp6_;
	_g_object_unref0 (_data_->_tmp2_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
boxes_machine_take_screenshot (BoxesMachine* self,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	BoxesMachineClass* _klass_;
	_klass_ = BOXES_MACHINE_GET_CLASS (self);
	if (_klass_->take_screenshot) {
		_klass_->take_screenshot (self, _callback_, _user_data_);
	}
}

GdkPixbuf*
boxes_machine_take_screenshot_finish (BoxesMachine* self,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	BoxesMachineClass* _klass_;
	_klass_ = BOXES_MACHINE_GET_CLASS (self);
	if (_klass_->take_screenshot_finish) {
		return _klass_->take_screenshot_finish (self, _res_, error);
	}
	return NULL;
}

void
boxes_machine_connect_display (BoxesMachine* self,
                               BoxesMachineConnectFlags flags,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	BoxesMachineClass* _klass_;
	_klass_ = BOXES_MACHINE_GET_CLASS (self);
	if (_klass_->connect_display) {
		_klass_->connect_display (self, flags, _callback_, _user_data_);
	}
}

void
boxes_machine_connect_display_finish (BoxesMachine* self,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	BoxesMachineClass* _klass_;
	_klass_ = BOXES_MACHINE_GET_CLASS (self);
	if (_klass_->connect_display_finish) {
		_klass_->connect_display_finish (self, _res_, error);
	}
}

static void
boxes_machine_real_restart (BoxesMachine* self)
{
	g_critical ("Type `%s' does not implement abstract method `boxes_machine_restart'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
boxes_machine_restart (BoxesMachine* self)
{
	BoxesMachineClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BOXES_MACHINE_GET_CLASS (self);
	if (_klass_->restart) {
		_klass_->restart (self);
	}
}

void
boxes_machine_clone (BoxesMachine* self,
                     GAsyncReadyCallback _callback_,
                     gpointer _user_data_)
{
	BoxesMachineClass* _klass_;
	_klass_ = BOXES_MACHINE_GET_CLASS (self);
	if (_klass_->clone) {
		_klass_->clone (self, _callback_, _user_data_);
	}
}

void
boxes_machine_clone_finish (BoxesMachine* self,
                            GAsyncResult* _res_)
{
	BoxesMachineClass* _klass_;
	_klass_ = BOXES_MACHINE_GET_CLASS (self);
	if (_klass_->clone_finish) {
		_klass_->clone_finish (self, _res_);
	}
}

static void
boxes_machine_real_disconnect_display (BoxesMachine* self)
{
	BoxesDisplay* _tmp0_;
	BoxesDisplay* _tmp1_;
	gboolean _tmp2_ = FALSE;
	BoxesMachineMachineState _tmp3_;
	BoxesMachineMachineState _tmp4_;
	BoxesAppWindow* _tmp14_;
	BoxesAppWindow* _tmp15_;
	BoxesCollectionItem* _tmp16_;
	BoxesCollectionItem* _tmp17_;
	BoxesDisplay* _tmp23_;
	BoxesDisplay* _tmp24_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = boxes_machine_get_display (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = boxes_machine_get_state (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != BOXES_MACHINE_MACHINE_STATE_STOPPED) {
		BoxesMachineMachineState _tmp5_;
		BoxesMachineMachineState _tmp6_;
		_tmp5_ = boxes_machine_get_state (self);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ != BOXES_MACHINE_MACHINE_STATE_FORCE_STOPPED;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		{
			GdkPixbuf* pixbuf = NULL;
			BoxesDisplay* _tmp7_;
			BoxesDisplay* _tmp8_;
			GdkPixbuf* _tmp9_;
			GdkPixbuf* _tmp10_;
			_tmp7_ = boxes_machine_get_display (self);
			_tmp8_ = _tmp7_;
			_tmp9_ = boxes_display_get_pixbuf (_tmp8_, 0, &_inner_error0_);
			pixbuf = _tmp9_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp10_ = pixbuf;
			if (_tmp10_ != NULL) {
				GdkPixbuf* _tmp11_;
				_tmp11_ = pixbuf;
				boxes_machine_set_screenshot (self, _tmp11_, TRUE);
			}
			_g_object_unref0 (pixbuf);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* _error_ = NULL;
			GError* _tmp12_;
			const gchar* _tmp13_;
			_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp12_ = _error_;
			_tmp13_ = _tmp12_->message;
			g_warning ("machine.vala:367: %s", _tmp13_);
			_g_error_free0 (_error_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp14_ = boxes_machine_get_window (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = boxes_app_window_get_current_item (_tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp17_ == G_TYPE_CHECK_INSTANCE_CAST (self, BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItem)) {
		BoxesAppWindow* _tmp18_;
		BoxesAppWindow* _tmp19_;
		BoxesDisplayPage* _tmp20_;
		GtkWidget* _tmp21_;
		GtkWidget* _tmp22_;
		_tmp18_ = boxes_machine_get_window (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = _tmp19_->display_page;
		_tmp21_ = boxes_display_page_remove_display (_tmp20_);
		_tmp22_ = _tmp21_;
		_g_object_unref0 (_tmp22_);
	}
	_tmp23_ = boxes_machine_get_display (self);
	_tmp24_ = _tmp23_;
	if (!boxes_display_should_keep_alive (_tmp24_)) {
		BoxesDisplay* _tmp25_;
		BoxesDisplay* _tmp26_;
		_tmp25_ = boxes_machine_get_display (self);
		_tmp26_ = _tmp25_;
		boxes_display_disconnect_it (_tmp26_);
		boxes_machine_set_display (self, NULL);
	} else {
		BoxesDisplay* _tmp27_;
		BoxesDisplay* _tmp28_;
		_tmp27_ = boxes_machine_get_display (self);
		_tmp28_ = _tmp27_;
		boxes_display_set_enable_audio (_tmp28_, FALSE);
	}
	boxes_machine_set_window (self, NULL);
}

void
boxes_machine_disconnect_display (BoxesMachine* self)
{
	BoxesMachineClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BOXES_MACHINE_GET_CLASS (self);
	if (_klass_->disconnect_display) {
		_klass_->disconnect_display (self);
	}
}

static void
boxes_machine_create_display_config (BoxesMachine* self,
                                     const gchar* uuid)
{
	BoxesBoxConfig* _tmp0_;
	gchar* group = NULL;
	gchar* _tmp1_;
	BoxesCollectionSource* _tmp6_;
	const gchar* _tmp7_;
	BoxesBoxConfig* _tmp8_;
	BoxesBoxConfig* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp19_ = FALSE;
	BoxesBoxConfig* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gboolean _tmp29_;
	BoxesBoxConfig* _tmp33_;
	BoxesBoxConfig* _tmp34_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->config;
	_vala_return_if_fail (_tmp0_ == NULL, "this.config == null");
	_tmp1_ = g_strdup ("display");
	group = _tmp1_;
	if (uuid != NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = group;
		_tmp3_ = g_strconcat (" ", uuid, NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strconcat (_tmp2_, _tmp4_, NULL);
		_g_free0 (group);
		group = _tmp5_;
		_g_free0 (_tmp4_);
	}
	_tmp6_ = self->source;
	_tmp7_ = group;
	_tmp8_ = boxes_box_config_new_with_group (_tmp6_, _tmp7_);
	_g_object_unref0 (self->config);
	self->config = _tmp8_;
	_tmp9_ = self->config;
	_tmp10_ = boxes_box_config_get_last_seen_name (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp13_ = boxes_collection_item_get_name ((BoxesCollectionItem*) self);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strcmp0 (_tmp12_, _tmp14_) != 0;
	_g_free0 (_tmp12_);
	if (_tmp15_) {
		BoxesBoxConfig* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		_tmp16_ = self->config;
		_tmp17_ = boxes_collection_item_get_name ((BoxesCollectionItem*) self);
		_tmp18_ = _tmp17_;
		boxes_box_config_set_last_seen_name (_tmp16_, _tmp18_);
	}
	if (uuid != NULL) {
		BoxesBoxConfig* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp20_ = self->config;
		_tmp21_ = boxes_box_config_get_uuid (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_;
		_tmp19_ = g_strcmp0 (_tmp23_, uuid) != 0;
		_g_free0 (_tmp23_);
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		BoxesBoxConfig* _tmp24_;
		_tmp24_ = self->config;
		boxes_box_config_set_uuid (_tmp24_, uuid);
	}
	_tmp25_ = self->config;
	_tmp26_ = boxes_box_config_get_uuid (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = _tmp27_;
	_tmp29_ = _tmp28_ == NULL;
	_g_free0 (_tmp28_);
	if (_tmp29_) {
		BoxesBoxConfig* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		_tmp30_ = self->config;
		_tmp31_ = g_uuid_string_random ();
		_tmp32_ = _tmp31_;
		boxes_box_config_set_uuid (_tmp30_, _tmp32_);
		_g_free0 (_tmp32_);
	}
	_tmp33_ = self->config;
	boxes_iconfig_save ((BoxesIConfig*) _tmp33_);
	_tmp34_ = self->config;
	_vala_warn_if_fail (_tmp34_ != NULL, "this.config != null");
	_g_free0 (group);
}

static void
boxes_machine_real_update_status (BoxesMachine* self)
{
	if (self->priv->saving) {
		boxes_machine_set_status (self, _ ("Saving…"));
	} else {
		boxes_machine_set_status (self, NULL);
	}
}

void
boxes_machine_update_status (BoxesMachine* self)
{
	BoxesMachineClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BOXES_MACHINE_GET_CLASS (self);
	if (_klass_->update_status) {
		_klass_->update_status (self);
	}
}

static void
boxes_machine_save_pixbuf_as_screenshot (BoxesMachine* self,
                                         GdkPixbuf* pixbuf)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		_tmp1_ = boxes_machine_get_screenshot_filename (self, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		gdk_pixbuf_save (pixbuf, _tmp0_, "png", &_inner_error0_, NULL);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp0_);
			goto __catch0_g_error;
		}
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = _error_;
		_tmp3_ = _tmp2_->message;
		g_warning ("machine.vala:416: %s", _tmp3_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gint
boxes_machine_pixbuf_energy (BoxesMachine* self,
                             GdkPixbuf* pixbuf)
{
	guint8* pixels = NULL;
	guint8* _tmp0_;
	gint pixels_length1;
	gint _pixels_size_;
	gint w = 0;
	gint h = 0;
	gint rowstride = 0;
	gint n_channels = 0;
	gint energy = 0;
	gint row_start = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (pixbuf != NULL, 0);
	_tmp0_ = gdk_pixbuf_get_pixels (pixbuf);
	pixels = _tmp0_;
	pixels_length1 = -1;
	_pixels_size_ = pixels_length1;
	w = gdk_pixbuf_get_width (pixbuf);
	h = gdk_pixbuf_get_height (pixbuf);
	rowstride = gdk_pixbuf_get_rowstride (pixbuf);
	n_channels = gdk_pixbuf_get_n_channels (pixbuf);
	energy = 0;
	row_start = 0;
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint row_energy = 0;
				gint i = 0;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = y;
					y = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(y < h)) {
					break;
				}
				row_energy = 0;
				i = row_start;
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint max = 0;
							guint8* _tmp5_;
							gint _tmp5__length1;
							guint8 _tmp6_;
							guint8* _tmp7_;
							gint _tmp7__length1;
							guint8 _tmp8_;
							guint8* _tmp9_;
							gint _tmp9__length1;
							guint8 _tmp10_;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = x;
								x = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							if (!(x < w)) {
								break;
							}
							_tmp5_ = pixels;
							_tmp5__length1 = pixels_length1;
							_tmp6_ = _tmp5_[i + 0];
							_tmp7_ = pixels;
							_tmp7__length1 = pixels_length1;
							_tmp8_ = _tmp7_[i + 1];
							_tmp9_ = pixels;
							_tmp9__length1 = pixels_length1;
							_tmp10_ = _tmp9_[i + 2];
							max = MAX (MAX ((gint) _tmp6_, (gint) _tmp8_), (gint) _tmp10_);
							row_energy += max * max;
							i += n_channels;
						}
					}
				}
				energy += row_energy / w;
				row_start += rowstride;
			}
		}
	}
	result = energy / h;
	return result;
}

static void
boxes_machine_set_screenshot (BoxesMachine* self,
                              GdkPixbuf* large_screenshot,
                              gboolean save)
{
	g_return_if_fail (self != NULL);
	if (large_screenshot != NULL) {
		gint pw = 0;
		gint ph = 0;
		gdouble s = 0.0;
		gint w = 0;
		gint h = 0;
		GdkPixbuf* small_screenshot = NULL;
		gboolean _tmp0_;
		gboolean _tmp1_;
		GdkPixbuf* _tmp2_;
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
		GdkPixbuf* _tmp5_;
		GdkPixbuf* _tmp6_;
		GdkPixbuf* _tmp7_;
		GdkPixbuf* _tmp8_;
		GdkPixbuf* _tmp9_;
		pw = gdk_pixbuf_get_width (large_screenshot);
		ph = gdk_pixbuf_get_height (large_screenshot);
		s = MIN (((gdouble) BOXES_MACHINE_SCREENSHOT_WIDTH) / pw, ((gdouble) BOXES_MACHINE_SCREENSHOT_HEIGHT) / ph);
		w = (gint) (pw * s);
		h = (gint) (ph * s);
		_tmp0_ = gdk_pixbuf_get_has_alpha (large_screenshot);
		_tmp1_ = _tmp0_;
		_tmp2_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, _tmp1_, 8, w, h);
		small_screenshot = _tmp2_;
		_tmp3_ = small_screenshot;
		gdk_pixbuf_scale (large_screenshot, _tmp3_, 0, 0, w, h, (gdouble) 0, (gdouble) 0, s, s, GDK_INTERP_HYPER);
		_tmp4_ = small_screenshot;
		if (boxes_machine_pixbuf_energy (self, _tmp4_) < 50) {
			_g_object_unref0 (small_screenshot);
			return;
		}
		_tmp5_ = small_screenshot;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_g_object_unref0 (self->priv->orig_pixbuf);
		self->priv->orig_pixbuf = _tmp6_;
		_tmp7_ = small_screenshot;
		_tmp8_ = boxes_machine_draw_vm (self, _tmp7_, BOXES_MACHINE_SCREENSHOT_WIDTH, BOXES_MACHINE_SCREENSHOT_HEIGHT);
		_tmp9_ = _tmp8_;
		boxes_machine_set_pixbuf (self, _tmp9_);
		_g_object_unref0 (_tmp9_);
		if (save) {
			GdkPixbuf* _tmp10_;
			_tmp10_ = small_screenshot;
			boxes_machine_save_pixbuf_as_screenshot (self, _tmp10_);
		}
		_g_object_unref0 (small_screenshot);
	} else {
		GdkPixbuf* _tmp11_;
		GdkPixbuf* _tmp12_;
		_g_object_unref0 (self->priv->orig_pixbuf);
		self->priv->orig_pixbuf = NULL;
		_tmp11_ = boxes_machine_draw_stopped_vm (BOXES_MACHINE_SCREENSHOT_WIDTH, BOXES_MACHINE_SCREENSHOT_HEIGHT);
		_tmp12_ = _tmp11_;
		boxes_machine_set_pixbuf (self, _tmp12_);
		_g_object_unref0 (_tmp12_);
	}
}

static void
boxes_machine_update_screenshot_data_free (gpointer _data)
{
	BoxesMachineUpdateScreenshotData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesMachineUpdateScreenshotData, _data_);
}

static void
boxes_machine_update_screenshot (BoxesMachine* self,
                                 gboolean force_save,
                                 gboolean first_check,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	BoxesMachineUpdateScreenshotData* _data_;
	BoxesMachine* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BoxesMachineUpdateScreenshotData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_machine_update_screenshot_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->force_save = force_save;
	_data_->first_check = first_check;
	boxes_machine_update_screenshot_co (_data_);
}

static void
boxes_machine_update_screenshot_finish (BoxesMachine* self,
                                        GAsyncResult* _res_)
{
	BoxesMachineUpdateScreenshotData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
boxes_machine_update_screenshot_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	BoxesMachineUpdateScreenshotData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_machine_update_screenshot_co (_data_);
}

static gboolean
boxes_machine_update_screenshot_co (BoxesMachineUpdateScreenshotData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->self->priv->updating_screenshot) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->self->priv->updating_screenshot = TRUE;
	_data_->large_screenshot = NULL;
	{
		_data_->_state_ = 1;
		boxes_machine_take_screenshot (_data_->self, boxes_machine_update_screenshot_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = boxes_machine_take_screenshot_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->large_screenshot);
		_data_->large_screenshot = _data_->_tmp2_;
		if (_data_->first_check) {
			_data_->_state_ = 2;
			boxes_machine_take_screenshot (_data_->self, boxes_machine_update_screenshot_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp4_ = boxes_machine_take_screenshot_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp3_ = _data_->_tmp4_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->_tmp0_);
				goto __catch0_g_error;
			}
			_data_->_tmp5_ = _data_->_tmp3_;
			_data_->_tmp3_ = NULL;
			_g_object_unref0 (_data_->large_screenshot);
			_data_->large_screenshot = _data_->_tmp5_;
			_g_object_unref0 (_data_->_tmp3_);
		}
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->large_screenshot);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->large_screenshot;
	if (_data_->_tmp6_ != NULL) {
		if (_data_->force_save) {
			_data_->_tmp7_ = TRUE;
		} else {
			_data_->_tmp8_ = _data_->self->priv->screenshot_counter;
			_data_->self->priv->screenshot_counter = _data_->_tmp8_ + 1;
			_data_->_tmp7_ = (_data_->_tmp8_ % 12) == 0;
		}
		_data_->_tmp9_ = _data_->large_screenshot;
		boxes_machine_set_screenshot (_data_->self, _data_->_tmp9_, _data_->_tmp7_);
	}
	_data_->self->priv->updating_screenshot = FALSE;
	_g_object_unref0 (_data_->large_screenshot);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static GdkPixbuf*
boxes_machine_draw_vm (BoxesMachine* self,
                       GdkPixbuf* pixbuf,
                       gint width,
                       gint height)
{
	cairo_surface_t* surface = NULL;
	cairo_surface_t* _tmp0_;
	cairo_t* context = NULL;
	cairo_surface_t* _tmp1_;
	cairo_t* _tmp2_;
	gint pw = 0;
	gint ph = 0;
	gint x = 0;
	gint y = 0;
	cairo_t* _tmp3_;
	cairo_t* _tmp4_;
	cairo_t* _tmp5_;
	cairo_t* _tmp6_;
	cairo_t* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	cairo_surface_t* _tmp21_;
	GdkPixbuf* _tmp22_;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (pixbuf != NULL, NULL);
	_tmp0_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, width, height);
	surface = _tmp0_;
	_tmp1_ = surface;
	_tmp2_ = cairo_create (_tmp1_);
	context = _tmp2_;
	pw = gdk_pixbuf_get_width (pixbuf);
	ph = gdk_pixbuf_get_height (pixbuf);
	x = (width - pw) / 2;
	y = (height - ph) / 2;
	_tmp3_ = context;
	cairo_rectangle (_tmp3_, (gdouble) x, (gdouble) y, (gdouble) pw, (gdouble) ph);
	_tmp4_ = context;
	cairo_clip (_tmp4_);
	_tmp5_ = context;
	gdk_cairo_set_source_pixbuf (_tmp5_, pixbuf, (gdouble) x, (gdouble) y);
	_tmp6_ = context;
	cairo_set_operator (_tmp6_, CAIRO_OPERATOR_SOURCE);
	_tmp7_ = context;
	cairo_paint (_tmp7_);
	_tmp8_ = boxes_machine_get_is_running (self);
	_tmp9_ = _tmp8_;
	if (!_tmp9_) {
		cairo_t* _tmp10_;
		cairo_t* _tmp11_;
		cairo_t* _tmp12_;
		cairo_t* _tmp13_;
		cairo_pattern_t* grid = NULL;
		cairo_surface_t* _tmp14_;
		cairo_pattern_t* _tmp15_;
		cairo_pattern_t* _tmp16_;
		cairo_t* _tmp17_;
		cairo_t* _tmp18_;
		cairo_t* _tmp19_;
		cairo_pattern_t* _tmp20_;
		_tmp10_ = context;
		cairo_set_source_rgba (_tmp10_, (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
		_tmp11_ = context;
		cairo_set_operator (_tmp11_, CAIRO_OPERATOR_HSL_SATURATION);
		_tmp12_ = context;
		cairo_paint (_tmp12_);
		_tmp13_ = context;
		cairo_scale (_tmp13_, 2.0, 2.0);
		_tmp14_ = boxes_machine_grid_surface;
		_tmp15_ = cairo_pattern_create_for_surface (_tmp14_);
		grid = _tmp15_;
		_tmp16_ = grid;
		cairo_pattern_set_extend (_tmp16_, CAIRO_EXTEND_REPEAT);
		_tmp17_ = context;
		cairo_set_source_rgba (_tmp17_, 0.2, 0.2, 0.2, (gdouble) 1);
		_tmp18_ = context;
		cairo_set_operator (_tmp18_, CAIRO_OPERATOR_ADD);
		_tmp19_ = context;
		_tmp20_ = grid;
		cairo_mask (_tmp19_, _tmp20_);
		_cairo_pattern_destroy0 (grid);
	}
	_tmp21_ = surface;
	_tmp22_ = gdk_pixbuf_get_from_surface (_tmp21_, 0, 0, width, height);
	result = _tmp22_;
	_cairo_destroy0 (context);
	_cairo_surface_destroy0 (surface);
	return result;
}

static GdkPixbuf*
boxes_machine_draw_stopped_vm (gint width,
                               gint height)
{
	cairo_surface_t* surface = NULL;
	cairo_surface_t* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* result;
	_tmp0_ = cairo_image_surface_create (CAIRO_FORMAT_RGB24, width, height);
	surface = _tmp0_;
	_tmp1_ = gdk_pixbuf_get_from_surface (surface, 0, 0, width, height);
	result = _tmp1_;
	_cairo_surface_destroy0 (surface);
	return result;
}

static void
boxes_machine_real_delete (BoxesMachine* self,
                           gboolean by_user)
{
	BoxesBoxConfig* _tmp3_;
	GError* _inner_error0_ = NULL;
	boxes_machine_set_deleted (self, TRUE);
	boxes_machine_set_screenshot_enable (self, FALSE);
	if (self->priv->ui_state_id != ((gulong) 0)) {
		BoxesApp* _tmp0_;
		BoxesAppWindow* _tmp1_;
		BoxesAppWindow* _tmp2_;
		_tmp0_ = boxes_app_app;
		_tmp1_ = boxes_app_get_main_window (_tmp0_);
		_tmp2_ = _tmp1_;
		g_signal_handler_disconnect ((GObject*) _tmp2_, self->priv->ui_state_id);
		self->priv->ui_state_id = (gulong) 0;
	}
	_tmp3_ = self->config;
	boxes_box_config_delete (_tmp3_);
	{
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp5_ = boxes_machine_get_screenshot_filename (self, &_inner_error0_);
		_tmp4_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == BOXES_ERROR) {
				goto __catch0_boxes_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		g_unlink (_tmp4_);
		_g_free0 (_tmp4_);
	}
	goto __finally0;
	__catch0_boxes_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_debug ("machine.vala:553: Could not delete screenshot: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
boxes_machine_delete (BoxesMachine* self,
                      gboolean by_user)
{
	BoxesMachineClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BOXES_MACHINE_GET_CLASS (self);
	if (_klass_->delete) {
		_klass_->delete (self, by_user);
	}
}

static void
boxes_machine_ui_state_changed (BoxesMachine* self)
{
	GBinding* _tmp0_;
	BoxesUIState _tmp8_;
	BoxesUIState _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->name_status_bind;
	if (_tmp0_ != NULL) {
		BoxesTopbar* topbar = NULL;
		GBinding* _tmp1_;
		GObject* _tmp2_;
		GObject* _tmp3_;
		BoxesTopbar* _tmp4_;
		BoxesTopbar* _tmp5_;
		GBinding* _tmp6_;
		GBinding* _tmp7_;
		_tmp1_ = self->priv->name_status_bind;
		_tmp2_ = g_binding_get_target (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _g_object_ref0 (BOXES_IS_TOPBAR (_tmp3_) ? ((BoxesTopbar*) _tmp3_) : NULL);
		topbar = _tmp4_;
		_tmp5_ = topbar;
		boxes_topbar_set_status (_tmp5_, NULL);
		_tmp6_ = self->priv->name_status_bind;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		g_binding_unbind (_tmp7_);
		_g_object_unref0 (self->priv->name_status_bind);
		self->priv->name_status_bind = NULL;
		_g_object_unref0 (topbar);
	}
	_tmp8_ = boxes_ui_get_ui_state ((BoxesUI*) self);
	_tmp9_ = _tmp8_;
	switch (_tmp9_) {
		case BOXES_UI_STATE_CREDS:
		{
			BoxesAppWindow* _tmp10_;
			BoxesAppWindow* _tmp11_;
			GtkStack* _tmp12_;
			_tmp10_ = boxes_machine_get_window (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = _tmp11_->below_bin;
			gtk_stack_set_visible_child_name (_tmp12_, "connecting-page");
			boxes_machine_try_connect_display (self, BOXES_MACHINE_CONNECT_FLAGS_NONE, NULL, NULL);
			break;
		}
		case BOXES_UI_STATE_DISPLAY:
		{
			BoxesUIState _tmp13_;
			BoxesUIState _tmp14_;
			BoxesAppWindow* _tmp18_;
			BoxesAppWindow* _tmp19_;
			BoxesCollectionItem* _tmp20_;
			BoxesCollectionItem* _tmp21_;
			_tmp13_ = boxes_ui_get_previous_ui_state ((BoxesUI*) self);
			_tmp14_ = _tmp13_;
			if (_tmp14_ == BOXES_UI_STATE_PROPERTIES) {
				BoxesAppWindow* _tmp15_;
				BoxesAppWindow* _tmp16_;
				GtkStack* _tmp17_;
				_tmp15_ = boxes_machine_get_window (self);
				_tmp16_ = _tmp15_;
				_tmp17_ = _tmp16_->below_bin;
				gtk_stack_set_visible_child_name (_tmp17_, "display-page");
			}
			_tmp18_ = boxes_machine_get_window (self);
			_tmp19_ = _tmp18_;
			_tmp20_ = boxes_app_window_get_current_item (_tmp19_);
			_tmp21_ = _tmp20_;
			if (_tmp21_ == G_TYPE_CHECK_INSTANCE_CAST (self, BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItem)) {
				BoxesAppWindow* _tmp22_;
				BoxesAppWindow* _tmp23_;
				BoxesTopbar* _tmp24_;
				GBinding* _tmp25_;
				GBinding* _tmp26_;
				_tmp22_ = boxes_machine_get_window (self);
				_tmp23_ = _tmp22_;
				_tmp24_ = _tmp23_->topbar;
				_tmp25_ = g_object_bind_property_with_closures ((GObject*) self, "name", (GObject*) _tmp24_, "status", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
				_tmp26_ = _g_object_ref0 (_tmp25_);
				_g_object_unref0 (self->priv->name_status_bind);
				self->priv->name_status_bind = _tmp26_;
			}
			break;
		}
		case BOXES_UI_STATE_COLLECTION:
		{
			boxes_machine_disconnect_display (self);
			break;
		}
		default:
		{
			break;
		}
	}
}

static void
boxes_machine_try_connect_display_data_free (gpointer _data)
{
	BoxesMachineTryConnectDisplayData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesMachineTryConnectDisplayData, _data_);
}

static void
boxes_machine_try_connect_display (BoxesMachine* self,
                                   BoxesMachineConnectFlags flags,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	BoxesMachineTryConnectDisplayData* _data_;
	BoxesMachine* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BoxesMachineTryConnectDisplayData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_machine_try_connect_display_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->flags = flags;
	boxes_machine_try_connect_display_co (_data_);
}

static void
boxes_machine_try_connect_display_finish (BoxesMachine* self,
                                          GAsyncResult* _res_)
{
	BoxesMachineTryConnectDisplayData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block39Data*
block39_data_ref (Block39Data* _data39_)
{
	g_atomic_int_inc (&_data39_->_ref_count_);
	return _data39_;
}

static void
block39_data_unref (void * _userdata_)
{
	Block39Data* _data39_;
	_data39_ = (Block39Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data39_->_ref_count_)) {
		BoxesMachine* self;
		self = _data39_->self;
		_g_object_unref0 (self);
		g_slice_free (Block39Data, _data39_);
	}
}

static void
boxes_machine_try_connect_display_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	BoxesMachineTryConnectDisplayData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_machine_try_connect_display_co (_data_);
}

static void
___lambda131_ (Block39Data* _data39_)
{
	BoxesMachine* self;
	self = _data39_->self;
	boxes_machine_try_connect_display (self, _data39_->flags | BOXES_MACHINE_CONNECT_FLAGS_IGNORE_SAVED_STATE, NULL, NULL);
}

static void
____lambda131__boxes_toast_ok_func (gpointer self)
{
	___lambda131_ (self);
}

static void
___lambda132_ (BoxesMachine* self)
{
	BoxesAppWindow* _tmp0_;
	BoxesAppWindow* _tmp1_;
	_tmp0_ = boxes_machine_get_window (self);
	_tmp1_ = _tmp0_;
	boxes_ui_set_state ((BoxesUI*) _tmp1_, BOXES_UI_STATE_COLLECTION);
}

static void
____lambda132__boxes_toast_dismiss_func (gpointer self)
{
	___lambda132_ ((BoxesMachine*) self);
}

static void
____lambda133_ (BoxesMachine* self)
{
	BoxesAppWindow* _tmp0_;
	BoxesAppWindow* _tmp1_;
	BoxesPreferencesWindow* preferences = NULL;
	BoxesMachine* _tmp2_;
	BoxesAppWindow* _tmp3_;
	BoxesAppWindow* _tmp4_;
	GtkWindow* _tmp5_;
	BoxesPreferencesWindow* _tmp6_ = NULL;
	_tmp0_ = boxes_machine_get_window (self);
	_tmp1_ = _tmp0_;
	boxes_app_window_set_current_item (_tmp1_, (BoxesCollectionItem*) self);
	_tmp2_ = _g_object_ref0 ((BoxesMachine*) (BOXES_IS_LIBVIRT_MACHINE (self) ? ((BoxesLibvirtMachine*) self) : NULL));
	_tmp3_ = boxes_machine_get_window (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 ((GtkWindow*) _tmp4_);
	_tmp6_ = boxes_preferences_window_new ();
	boxes_preferences_window_set_machine (_tmp6_, _tmp2_);
	_g_object_unref0 (_tmp2_);
	gtk_window_set_transient_for ((GtkWindow*) _tmp6_, _tmp5_);
	_g_object_unref0 (_tmp5_);
	g_object_ref_sink (_tmp6_);
	preferences = _tmp6_;
	boxes_preferences_window_show_troubleshoot_logs (preferences);
	_g_object_unref0 (preferences);
}

static void
_____lambda133__boxes_toast_ok_func (gpointer self)
{
	____lambda133_ ((BoxesMachine*) self);
}

static gboolean
boxes_machine_try_connect_display_co (BoxesMachineTryConnectDisplayData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data39_ = g_slice_new0 (Block39Data);
	_data_->_data39_->_ref_count_ = 1;
	_data_->_data39_->self = g_object_ref (_data_->self);
	_data_->_data39_->flags = _data_->flags;
	_data_->_data39_->_async_data_ = _data_;
	{
		_data_->_state_ = 1;
		boxes_machine_connect_display (_data_->self, _data_->_data39_->flags, boxes_machine_try_connect_display_ready, _data_);
		return FALSE;
		_state_1:
		boxes_machine_connect_display_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (g_error_matches (_data_->_inner_error0_, BOXES_ERROR, BOXES_ERROR_RESTORE_FAILED)) {
				goto __catch0_boxes_error_restore_failed;
			}
			if (g_error_matches (_data_->_inner_error0_, BOXES_ERROR, BOXES_ERROR_START_FAILED)) {
				goto __catch0_boxes_error_start_failed;
			}
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				goto __catch0_g_io_error_cancelled;
			}
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_boxes_error_restore_failed:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->restart_func = ____lambda131__boxes_toast_ok_func;
		_data_->restart_func_target = block39_data_ref (_data_->_data39_);
		_data_->restart_func_target_destroy_notify = block39_data_unref;
		_data_->dismiss_func = ____lambda132__boxes_toast_dismiss_func;
		_data_->dismiss_func_target = g_object_ref (_data_->self);
		_data_->dismiss_func_target_destroy_notify = g_object_unref;
		_data_->_tmp0_ = boxes_collection_item_get_name ((BoxesCollectionItem*) _data_->self);
		_data_->_tmp1_ = _data_->_tmp0_;
		_data_->_tmp2_ = _data_->e;
		_data_->_tmp3_ = _data_->_tmp2_->message;
		_data_->_tmp4_ = g_strdup_printf (_ ("“%s” could not be restored from disk: %s"), _data_->_tmp1_, _data_->_tmp3_);
		_data_->message = _data_->_tmp4_;
		_data_->_tmp5_ = boxes_machine_get_window (_data_->self);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = _data_->message;
		_data_->_tmp8_ = g_strdup (_data_->_tmp7_);
		_data_->_tmp9_ = g_strdup (_ ("Restart"));
		_data_->_tmp10_ = _data_->restart_func;
		_data_->_tmp10__target = _data_->restart_func_target;
		_data_->_tmp10__target_destroy_notify = _data_->restart_func_target_destroy_notify;
		_data_->restart_func = NULL;
		_data_->restart_func_target = NULL;
		_data_->restart_func_target_destroy_notify = NULL;
		_data_->_tmp11_ = _data_->dismiss_func;
		_data_->_tmp11__target = _data_->dismiss_func_target;
		_data_->_tmp11__target_destroy_notify = _data_->dismiss_func_target_destroy_notify;
		_data_->dismiss_func = NULL;
		_data_->dismiss_func_target = NULL;
		_data_->dismiss_func_target_destroy_notify = NULL;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = boxes_toast_new (NULL);
		boxes_toast_set_message (_data_->_tmp12_, _data_->_tmp8_);
		_g_free0 (_data_->_tmp8_);
		boxes_toast_set_action (_data_->_tmp12_, _data_->_tmp9_);
		_g_free0 (_data_->_tmp9_);
		(_data_->_tmp12_->undo_func_target_destroy_notify == NULL) ? NULL : (_data_->_tmp12_->undo_func_target_destroy_notify (_data_->_tmp12_->undo_func_target), NULL);
		_data_->_tmp12_->undo_func = NULL;
		_data_->_tmp12_->undo_func_target = NULL;
		_data_->_tmp12_->undo_func_target_destroy_notify = NULL;
		_data_->_tmp12_->undo_func = _data_->_tmp10_;
		_data_->_tmp12_->undo_func_target = _data_->_tmp10__target;
		_data_->_tmp12_->undo_func_target_destroy_notify = _data_->_tmp10__target_destroy_notify;
		(_data_->_tmp12_->dismiss_func_target_destroy_notify == NULL) ? NULL : (_data_->_tmp12_->dismiss_func_target_destroy_notify (_data_->_tmp12_->dismiss_func_target), NULL);
		_data_->_tmp12_->dismiss_func = NULL;
		_data_->_tmp12_->dismiss_func_target = NULL;
		_data_->_tmp12_->dismiss_func_target_destroy_notify = NULL;
		_data_->_tmp12_->dismiss_func = _data_->_tmp11_;
		_data_->_tmp12_->dismiss_func_target = _data_->_tmp11__target;
		_data_->_tmp12_->dismiss_func_target_destroy_notify = _data_->_tmp11__target_destroy_notify;
		g_object_ref_sink (_data_->_tmp12_);
		_data_->_tmp13_ = _data_->_tmp12_;
		boxes_app_window_display_toast (_data_->_tmp6_, _data_->_tmp13_);
		_g_object_unref0 (_data_->_tmp13_);
		_g_free0 (_data_->message);
		(_data_->dismiss_func_target_destroy_notify == NULL) ? NULL : (_data_->dismiss_func_target_destroy_notify (_data_->dismiss_func_target), NULL);
		_data_->dismiss_func = NULL;
		_data_->dismiss_func_target = NULL;
		_data_->dismiss_func_target_destroy_notify = NULL;
		(_data_->restart_func_target_destroy_notify == NULL) ? NULL : (_data_->restart_func_target_destroy_notify (_data_->restart_func_target), NULL);
		_data_->restart_func = NULL;
		_data_->restart_func_target = NULL;
		_data_->restart_func_target_destroy_notify = NULL;
		_g_error_free0 (_data_->e);
	}
	goto __finally0;
	__catch0_boxes_error_start_failed:
	{
		_data_->_vala1_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp14_ = boxes_collection_item_get_name ((BoxesCollectionItem*) _data_->self);
		_data_->_tmp15_ = _data_->_tmp14_;
		_data_->_tmp16_ = _data_->_vala1_e;
		_data_->_tmp17_ = _data_->_tmp16_->message;
		g_warning ("machine.vala:611: Failed to start %s: %s", _data_->_tmp15_, _data_->_tmp17_);
		_data_->_tmp18_ = boxes_machine_get_window (_data_->self);
		_data_->_tmp19_ = _data_->_tmp18_;
		boxes_ui_set_state ((BoxesUI*) _data_->_tmp19_, BOXES_UI_STATE_COLLECTION);
		_data_->_tmp20_ = boxes_collection_item_get_name ((BoxesCollectionItem*) _data_->self);
		_data_->_tmp21_ = _data_->_tmp20_;
		_data_->_tmp22_ = g_strdup_printf (_ ("Failed to start “%s”"), _data_->_tmp21_);
		_data_->msg = _data_->_tmp22_;
		if (BOXES_IS_LIBVIRT_MACHINE (_data_->self)) {
			_data_->troubleshoot = _____lambda133__boxes_toast_ok_func;
			_data_->troubleshoot_target = g_object_ref (_data_->self);
			_data_->troubleshoot_target_destroy_notify = g_object_unref;
			_data_->_tmp23_ = boxes_machine_get_window (_data_->self);
			_data_->_tmp24_ = _data_->_tmp23_;
			_data_->_tmp25_ = _data_->msg;
			_data_->_tmp26_ = g_strdup (_data_->_tmp25_);
			_data_->_tmp27_ = g_strdup (_ ("Troubleshooting Log"));
			_data_->_tmp28_ = _data_->troubleshoot;
			_data_->_tmp28__target = _data_->troubleshoot_target;
			_data_->_tmp28__target_destroy_notify = _data_->troubleshoot_target_destroy_notify;
			_data_->troubleshoot = NULL;
			_data_->troubleshoot_target = NULL;
			_data_->troubleshoot_target_destroy_notify = NULL;
			_data_->_tmp29_ = NULL;
			_data_->_tmp29_ = boxes_toast_new (NULL);
			boxes_toast_set_message (_data_->_tmp29_, _data_->_tmp26_);
			_g_free0 (_data_->_tmp26_);
			boxes_toast_set_action (_data_->_tmp29_, _data_->_tmp27_);
			_g_free0 (_data_->_tmp27_);
			(_data_->_tmp29_->undo_func_target_destroy_notify == NULL) ? NULL : (_data_->_tmp29_->undo_func_target_destroy_notify (_data_->_tmp29_->undo_func_target), NULL);
			_data_->_tmp29_->undo_func = NULL;
			_data_->_tmp29_->undo_func_target = NULL;
			_data_->_tmp29_->undo_func_target_destroy_notify = NULL;
			_data_->_tmp29_->undo_func = _data_->_tmp28_;
			_data_->_tmp29_->undo_func_target = _data_->_tmp28__target;
			_data_->_tmp29_->undo_func_target_destroy_notify = _data_->_tmp28__target_destroy_notify;
			g_object_ref_sink (_data_->_tmp29_);
			_data_->_tmp30_ = _data_->_tmp29_;
			boxes_app_window_display_toast (_data_->_tmp24_, _data_->_tmp30_);
			_g_object_unref0 (_data_->_tmp30_);
			(_data_->troubleshoot_target_destroy_notify == NULL) ? NULL : (_data_->troubleshoot_target_destroy_notify (_data_->troubleshoot_target), NULL);
			_data_->troubleshoot = NULL;
			_data_->troubleshoot_target = NULL;
			_data_->troubleshoot_target_destroy_notify = NULL;
		} else {
			_data_->_tmp31_ = boxes_machine_get_window (_data_->self);
			_data_->_tmp32_ = _data_->_tmp31_;
			_data_->_tmp33_ = _data_->msg;
			_data_->_tmp34_ = boxes_toast_new (_data_->_tmp33_);
			g_object_ref_sink (_data_->_tmp34_);
			_data_->_tmp35_ = _data_->_tmp34_;
			boxes_app_window_display_toast (_data_->_tmp32_, _data_->_tmp35_);
			_g_object_unref0 (_data_->_tmp35_);
		}
		_g_free0 (_data_->msg);
		_g_error_free0 (_data_->_vala1_e);
	}
	goto __finally0;
	__catch0_g_io_error_cancelled:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->_tmp36_ = boxes_machine_get_window (_data_->self);
		_data_->_tmp37_ = _data_->_tmp36_;
		boxes_ui_set_state ((BoxesUI*) _data_->_tmp37_, BOXES_UI_STATE_COLLECTION);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_vala2_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp38_ = boxes_collection_item_get_name ((BoxesCollectionItem*) _data_->self);
		_data_->_tmp39_ = _data_->_tmp38_;
		_data_->_tmp40_ = _data_->_vala2_e;
		_data_->_tmp41_ = _data_->_tmp40_->message;
		g_warning ("machine.vala:637: Failed to connect to %s: %s", _data_->_tmp39_, _data_->_tmp41_);
		_data_->_tmp42_ = boxes_machine_get_window (_data_->self);
		_data_->_tmp43_ = _data_->_tmp42_;
		boxes_ui_set_state ((BoxesUI*) _data_->_tmp43_, BOXES_UI_STATE_COLLECTION);
		_data_->_tmp44_ = boxes_collection_item_get_name ((BoxesCollectionItem*) _data_->self);
		_data_->_tmp45_ = _data_->_tmp44_;
		_data_->_tmp46_ = _data_->_vala2_e;
		_data_->_tmp47_ = _data_->_tmp46_->message;
		_data_->_tmp48_ = g_strdup_printf (_ ("Connection to “%s” failed: %s"), _data_->_tmp45_, _data_->_tmp47_);
		_data_->_vala1_message = _data_->_tmp48_;
		_data_->_tmp49_ = boxes_machine_get_window (_data_->self);
		_data_->_tmp50_ = _data_->_tmp49_;
		_data_->_tmp51_ = _data_->_vala1_message;
		_data_->_tmp52_ = boxes_toast_new (_data_->_tmp51_);
		g_object_ref_sink (_data_->_tmp52_);
		_data_->_tmp53_ = _data_->_tmp52_;
		boxes_app_window_display_toast (_data_->_tmp50_, _data_->_tmp53_);
		_g_object_unref0 (_data_->_tmp53_);
		_g_free0 (_data_->_vala1_message);
		_g_error_free0 (_data_->_vala2_e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		block39_data_unref (_data_->_data39_);
		_data_->_data39_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	block39_data_unref (_data_->_data39_);
	_data_->_data39_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gint
boxes_machine_real_compare (BoxesCollectionItem* base,
                            BoxesCollectionItem* other)
{
	BoxesMachine * self;
	gint result;
	self = (BoxesMachine*) base;
	g_return_val_if_fail (other != NULL, 0);
	if (BOXES_IS_MACHINE (other)) {
		BoxesMachine* machine = NULL;
		BoxesMachine* _tmp0_;
		BoxesBoxConfig* _tmp1_;
		BoxesMachine* _tmp2_;
		BoxesBoxConfig* _tmp3_;
		_tmp0_ = _g_object_ref0 (BOXES_IS_MACHINE (other) ? ((BoxesMachine*) other) : NULL);
		machine = _tmp0_;
		_tmp1_ = self->config;
		_tmp2_ = machine;
		_tmp3_ = _tmp2_->config;
		result = boxes_box_config_compare (_tmp1_, _tmp3_);
		_g_object_unref0 (machine);
		return result;
	} else {
		result = -1;
		return result;
	}
}

static void
boxes_machine_try_save_data_free (gpointer _data)
{
	BoxesMachineTrySaveData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesMachineTrySaveData, _data_);
}

static void
boxes_machine_try_save (BoxesMachine* self,
                        GAsyncReadyCallback _callback_,
                        gpointer _user_data_)
{
	BoxesMachineTrySaveData* _data_;
	BoxesMachine* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BoxesMachineTrySaveData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_machine_try_save_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	boxes_machine_try_save_co (_data_);
}

static void
boxes_machine_try_save_finish (BoxesMachine* self,
                               GAsyncResult* _res_)
{
	BoxesMachineTrySaveData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
boxes_machine_try_save_ready (GObject* source_object,
                              GAsyncResult* _res_,
                              gpointer _user_data_)
{
	BoxesMachineTrySaveData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_machine_try_save_co (_data_);
}

static gboolean
boxes_machine_try_save_co (BoxesMachineTrySaveData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		boxes_machine_save (_data_->self, boxes_machine_try_save_ready, _data_);
		return FALSE;
		_state_1:
		boxes_machine_save_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp0_ = boxes_collection_item_get_name ((BoxesCollectionItem*) _data_->self);
		_data_->_tmp1_ = _data_->_tmp0_;
		_data_->_tmp2_ = _data_->_error_;
		_data_->_tmp3_ = _data_->_tmp2_->message;
		g_warning ("machine.vala:659: Failed to save '%s': %s", _data_->_tmp1_, _data_->_tmp3_);
		_g_error_free0 (_data_->_error_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

GdkPixbuf*
boxes_machine_get_pixbuf (BoxesMachine* self)
{
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_pixbuf;
	result = _tmp0_;
	return result;
}

void
boxes_machine_set_pixbuf (BoxesMachine* self,
                          GdkPixbuf* value)
{
	GdkPixbuf* old_value;
	g_return_if_fail (self != NULL);
	old_value = boxes_machine_get_pixbuf (self);
	if (old_value != value) {
		GdkPixbuf* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_pixbuf);
		self->priv->_pixbuf = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, boxes_machine_properties[BOXES_MACHINE_PIXBUF_PROPERTY]);
	}
}

const gchar*
boxes_machine_get_status (BoxesMachine* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_status;
	result = _tmp0_;
	return result;
}

void
boxes_machine_set_status (BoxesMachine* self,
                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = boxes_machine_get_status (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_status);
		self->priv->_status = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, boxes_machine_properties[BOXES_MACHINE_STATUS_PROPERTY]);
	}
}

gboolean
boxes_machine_get_suspend_at_exit (BoxesMachine* self)
{
	BoxesMachineClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = BOXES_MACHINE_GET_CLASS (self);
	if (_klass_->get_suspend_at_exit) {
		return _klass_->get_suspend_at_exit (self);
	}
	return FALSE;
}

static gboolean
boxes_machine_real_get_suspend_at_exit (BoxesMachine* base)
{
	gboolean result;
	BoxesMachine* self;
	self = base;
	result = FALSE;
	return result;
}

gboolean
boxes_machine_get_can_save (BoxesMachine* self)
{
	BoxesMachineClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = BOXES_MACHINE_GET_CLASS (self);
	if (_klass_->get_can_save) {
		return _klass_->get_can_save (self);
	}
	return FALSE;
}

static gboolean
boxes_machine_real_get_can_save (BoxesMachine* base)
{
	gboolean result;
	BoxesMachine* self;
	self = base;
	result = FALSE;
	return result;
}

gboolean
boxes_machine_get_can_restart (BoxesMachine* self)
{
	BoxesMachineClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = BOXES_MACHINE_GET_CLASS (self);
	if (_klass_->get_can_restart) {
		return _klass_->get_can_restart (self);
	}
	return FALSE;
}

gboolean
boxes_machine_get_can_clone (BoxesMachine* self)
{
	BoxesMachineClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = BOXES_MACHINE_GET_CLASS (self);
	if (_klass_->get_can_clone) {
		return _klass_->get_can_clone (self);
	}
	return FALSE;
}

gboolean
boxes_machine_get_can_delete (BoxesMachine* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_can_delete;
	return result;
}

void
boxes_machine_set_can_delete (BoxesMachine* self,
                              gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = boxes_machine_get_can_delete (self);
	if (old_value != value) {
		self->priv->_can_delete = value;
		g_object_notify_by_pspec ((GObject *) self, boxes_machine_properties[BOXES_MACHINE_CAN_DELETE_PROPERTY]);
	}
}

gboolean
boxes_machine_get_under_construction (BoxesMachine* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_under_construction;
	return result;
}

void
boxes_machine_set_under_construction (BoxesMachine* self,
                                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = boxes_machine_get_under_construction (self);
	if (old_value != value) {
		self->priv->_under_construction = value;
		g_object_notify_by_pspec ((GObject *) self, boxes_machine_properties[BOXES_MACHINE_UNDER_CONSTRUCTION_PROPERTY]);
	}
}

gboolean
boxes_machine_get_should_autosave (BoxesMachine* self)
{
	BoxesMachineClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = BOXES_MACHINE_GET_CLASS (self);
	if (_klass_->get_should_autosave) {
		return _klass_->get_should_autosave (self);
	}
	return FALSE;
}

static gboolean
boxes_machine_real_get_should_autosave (BoxesMachine* base)
{
	gboolean result;
	BoxesMachine* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = base;
	_tmp2_ = boxes_machine_get_can_save (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = boxes_machine_get_is_running (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = self->priv->autosave_timeout_id == ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
boxes_machine_get_is_connected (BoxesMachine* self)
{
	gboolean result;
	BoxesDisplay* _tmp0_;
	BoxesDisplay* _tmp1_;
	BoxesDisplay* _tmp2_;
	BoxesDisplay* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = boxes_machine_get_display (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp2_ = boxes_machine_get_display (self);
	_tmp3_ = _tmp2_;
	result = _tmp3_->connected;
	return result;
}

gboolean
boxes_machine_get_is_running (BoxesMachine* self)
{
	gboolean result;
	BoxesMachineMachineState _tmp0_;
	BoxesMachineMachineState _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = boxes_machine_get_state (self);
	_tmp1_ = _tmp0_;
	result = _tmp1_ == BOXES_MACHINE_MACHINE_STATE_RUNNING;
	return result;
}

gboolean
boxes_machine_get_is_on (BoxesMachine* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	BoxesMachineMachineState _tmp2_;
	BoxesMachineMachineState _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp2_ = boxes_machine_get_state (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == BOXES_MACHINE_MACHINE_STATE_RUNNING) {
		_tmp1_ = TRUE;
	} else {
		BoxesMachineMachineState _tmp4_;
		BoxesMachineMachineState _tmp5_;
		_tmp4_ = boxes_machine_get_state (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_ == BOXES_MACHINE_MACHINE_STATE_PAUSED;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		BoxesMachineMachineState _tmp6_;
		BoxesMachineMachineState _tmp7_;
		_tmp6_ = boxes_machine_get_state (self);
		_tmp7_ = _tmp6_;
		_tmp0_ = _tmp7_ == BOXES_MACHINE_MACHINE_STATE_SLEEPING;
	}
	result = _tmp0_;
	return result;
}

gboolean
boxes_machine_get_is_stopped (BoxesMachine* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	BoxesMachineMachineState _tmp1_;
	BoxesMachineMachineState _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = boxes_machine_get_state (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == BOXES_MACHINE_MACHINE_STATE_FORCE_STOPPED) {
		_tmp0_ = TRUE;
	} else {
		BoxesMachineMachineState _tmp3_;
		BoxesMachineMachineState _tmp4_;
		_tmp3_ = boxes_machine_get_state (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == BOXES_MACHINE_MACHINE_STATE_STOPPED;
	}
	result = _tmp0_;
	return result;
}

gboolean
boxes_machine_get_is_local (BoxesMachine* self)
{
	BoxesMachineClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = BOXES_MACHINE_GET_CLASS (self);
	if (_klass_->get_is_local) {
		return _klass_->get_is_local (self);
	}
	return FALSE;
}

static inline GRegex*
_thread_safe_regex_init (GRegex** re,
                         const gchar * pattern,
                         GRegexCompileFlags compile_flags)
{
	if (g_once_init_enter ((volatile gsize*) re)) {
		GRegex* val = g_regex_new (pattern, compile_flags, 0, NULL);
		g_once_init_leave ((volatile gsize*) re, (gsize) val);
	}
	return *re;
}

static gboolean
boxes_machine_real_get_is_local (BoxesMachine* base)
{
	gboolean result;
	BoxesMachine* self;
	BoxesCollectionSource* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	self = base;
	_tmp0_ = self->source;
	_tmp1_ = boxes_collection_source_get_uri (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = g_regex_match (_thread_safe_regex_init (&_tmp_regex_0, ":\\/\\/(127\\.\\d+\\.\\d+\\.\\d+|localhost)", 0 | G_REGEX_CASELESS), _tmp3_, 0, NULL);
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

GCancellable*
boxes_machine_get_connecting_cancellable (BoxesMachine* self)
{
	GCancellable* result;
	GCancellable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_connecting_cancellable;
	result = _tmp0_;
	return result;
}

void
boxes_machine_set_connecting_cancellable (BoxesMachine* self,
                                          GCancellable* value)
{
	GCancellable* old_value;
	g_return_if_fail (self != NULL);
	old_value = boxes_machine_get_connecting_cancellable (self);
	if (old_value != value) {
		GCancellable* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_connecting_cancellable);
		self->priv->_connecting_cancellable = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, boxes_machine_properties[BOXES_MACHINE_CONNECTING_CANCELLABLE_PROPERTY]);
	}
}

BoxesMachineMachineState
boxes_machine_get_state (BoxesMachine* self)
{
	BoxesMachineMachineState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

void
boxes_machine_set_state (BoxesMachine* self,
                         BoxesMachineMachineState value)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	BoxesMachineMachineState _tmp2_;
	BoxesMachineMachineState _tmp3_;
	GEnumValue* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	BoxesDisplay* _tmp16_;
	BoxesDisplay* _tmp17_;
	g_return_if_fail (self != NULL);
	self->priv->_state = value;
	_tmp0_ = boxes_collection_item_get_name ((BoxesCollectionItem*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = boxes_machine_get_state (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_enum_get_value (g_type_class_ref (BOXES_MACHINE_TYPE_MACHINE_STATE), _tmp3_);
	g_debug ("machine.vala:105: State of '%s' changed to %s", _tmp1_, (_tmp4_ != NULL) ? _tmp4_->value_name : NULL);
	if (value == BOXES_MACHINE_MACHINE_STATE_STOPPED) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = value == BOXES_MACHINE_MACHINE_STATE_FORCE_STOPPED;
	}
	if (_tmp5_) {
		boxes_machine_set_screenshot (self, NULL, FALSE);
	} else {
		GdkPixbuf* _tmp6_;
		_tmp6_ = self->priv->orig_pixbuf;
		if (_tmp6_ != NULL) {
			GdkPixbuf* _tmp7_;
			GdkPixbuf* _tmp8_;
			GdkPixbuf* _tmp9_;
			_tmp7_ = self->priv->orig_pixbuf;
			_tmp8_ = boxes_machine_draw_vm (self, _tmp7_, BOXES_MACHINE_SCREENSHOT_WIDTH, BOXES_MACHINE_SCREENSHOT_HEIGHT);
			_tmp9_ = _tmp8_;
			boxes_machine_set_pixbuf (self, _tmp9_);
			_g_object_unref0 (_tmp9_);
		}
	}
	_tmp16_ = boxes_machine_get_display (self);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != NULL) {
		_tmp15_ = !self->stay_on_display;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		BoxesAppWindow* _tmp18_;
		BoxesAppWindow* _tmp19_;
		_tmp18_ = boxes_machine_get_window (self);
		_tmp19_ = _tmp18_;
		_tmp14_ = _tmp19_ != NULL;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		BoxesAppWindow* _tmp20_;
		BoxesAppWindow* _tmp21_;
		BoxesCollectionItem* _tmp22_;
		BoxesCollectionItem* _tmp23_;
		_tmp20_ = boxes_machine_get_window (self);
		_tmp21_ = _tmp20_;
		_tmp22_ = boxes_app_window_get_current_item (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp13_ = _tmp23_ == G_TYPE_CHECK_INSTANCE_CAST (self, BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItem);
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		_tmp12_ = value != BOXES_MACHINE_MACHINE_STATE_RUNNING;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		BoxesAppWindow* _tmp24_;
		BoxesAppWindow* _tmp25_;
		BoxesUIState _tmp26_;
		BoxesUIState _tmp27_;
		_tmp24_ = boxes_machine_get_window (self);
		_tmp25_ = _tmp24_;
		_tmp26_ = boxes_ui_get_ui_state ((BoxesUI*) _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp11_ = _tmp27_ != BOXES_UI_STATE_PROPERTIES;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		_tmp10_ = value != BOXES_MACHINE_MACHINE_STATE_UNKNOWN;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		BoxesAppWindow* _tmp28_;
		BoxesAppWindow* _tmp29_;
		_tmp28_ = boxes_machine_get_window (self);
		_tmp29_ = _tmp28_;
		boxes_ui_set_state ((BoxesUI*) _tmp29_, BOXES_UI_STATE_COLLECTION);
	}
	g_object_notify_by_pspec ((GObject *) self, boxes_machine_properties[BOXES_MACHINE_STATE_PROPERTY]);
}

BoxesAppWindow*
boxes_machine_get_window (BoxesMachine* self)
{
	BoxesAppWindow* result;
	BoxesAppWindow* _tmp0_ = NULL;
	BoxesAppWindow* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->_window;
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		BoxesApp* _tmp2_;
		BoxesAppWindow* _tmp3_;
		BoxesAppWindow* _tmp4_;
		_tmp2_ = boxes_app_app;
		_tmp3_ = boxes_app_get_main_window (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}

void
boxes_machine_set_window (BoxesMachine* self,
                          BoxesAppWindow* value)
{
	g_return_if_fail (self != NULL);
	self->priv->_window = value;
	g_object_notify_by_pspec ((GObject *) self, boxes_machine_properties[BOXES_MACHINE_WINDOW_PROPERTY]);
}

gboolean
boxes_machine_get_deleted (BoxesMachine* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_deleted;
	return result;
}

static void
boxes_machine_set_deleted (BoxesMachine* self,
                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = boxes_machine_get_deleted (self);
	if (old_value != value) {
		self->priv->_deleted = value;
		g_object_notify_by_pspec ((GObject *) self, boxes_machine_properties[BOXES_MACHINE_DELETED_PROPERTY]);
	}
}

BoxesDisplay*
boxes_machine_get_display (BoxesMachine* self)
{
	BoxesDisplay* result;
	BoxesDisplay* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	result = _tmp0_;
	return result;
}

static void
_boxes_machine_display___lambda127_ (BoxesMachine* self,
                                     gint id)
{
	gboolean _tmp0_ = FALSE;
	BoxesAppWindow* _tmp1_;
	BoxesAppWindow* _tmp2_;
	_tmp1_ = boxes_machine_get_window (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		BoxesAppWindow* _tmp3_;
		BoxesAppWindow* _tmp4_;
		BoxesCollectionItem* _tmp5_;
		BoxesCollectionItem* _tmp6_;
		_tmp3_ = boxes_machine_get_window (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = boxes_app_window_get_current_item (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ == G_TYPE_CHECK_INSTANCE_CAST (self, BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItem);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		boxes_machine_show_display (self);
	}
}

static void
__boxes_machine_display___lambda127__boxes_display_show (BoxesDisplay* _sender,
                                                         gint display_id,
                                                         gpointer self)
{
	_boxes_machine_display___lambda127_ ((BoxesMachine*) self, display_id);
}

static void
_boxes_machine_display___lambda128_ (BoxesMachine* self,
                                     gint id)
{
	gboolean _tmp0_ = FALSE;
	BoxesAppWindow* _tmp1_;
	BoxesAppWindow* _tmp2_;
	_tmp1_ = boxes_machine_get_window (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		BoxesAppWindow* _tmp3_;
		BoxesAppWindow* _tmp4_;
		BoxesCollectionItem* _tmp5_;
		BoxesCollectionItem* _tmp6_;
		_tmp3_ = boxes_machine_get_window (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = boxes_app_window_get_current_item (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ == G_TYPE_CHECK_INSTANCE_CAST (self, BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItem);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		BoxesAppWindow* _tmp7_;
		BoxesAppWindow* _tmp8_;
		BoxesDisplayPage* _tmp9_;
		GtkWidget* _tmp10_;
		GtkWidget* _tmp11_;
		_tmp7_ = boxes_machine_get_window (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_->display_page;
		_tmp10_ = boxes_display_page_remove_display (_tmp9_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp11_);
	}
}

static void
__boxes_machine_display___lambda128__boxes_display_hide (BoxesDisplay* _sender,
                                                         gint display_id,
                                                         gpointer self)
{
	_boxes_machine_display___lambda128_ ((BoxesMachine*) self, display_id);
}

static void
_boxes_machine_display___lambda129_ (BoxesMachine* self,
                                     const gchar* message)
{
	g_return_if_fail (message != NULL);
	g_signal_emit (self, boxes_machine_signals[BOXES_MACHINE_GOT_ERROR_SIGNAL], 0, message);
}

static void
__boxes_machine_display___lambda129__boxes_display_got_error (BoxesDisplay* _sender,
                                                              const gchar* message,
                                                              gpointer self)
{
	_boxes_machine_display___lambda129_ ((BoxesMachine*) self, message);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
_boxes_machine_display___lambda130_ (BoxesMachine* self,
                                     gboolean failed)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	BoxesAppWindow* _tmp5_;
	BoxesAppWindow* _tmp6_;
	gboolean _tmp7_ = FALSE;
	BoxesAppWindow* _tmp8_;
	BoxesAppWindow* _tmp9_;
	BoxesUIState _tmp10_;
	BoxesUIState _tmp11_;
	_tmp0_ = boxes_collection_item_get_name ((BoxesCollectionItem*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = g_strconcat ("display ", _tmp2_, " disconnected", NULL);
	_tmp4_ = _tmp3_;
	g_message ("machine.vala:201: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = boxes_machine_get_window (self);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == NULL) {
		return;
	}
	_tmp8_ = boxes_machine_get_window (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = boxes_ui_get_ui_state ((BoxesUI*) _tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ == BOXES_UI_STATE_CREDS) {
		_tmp7_ = TRUE;
	} else {
		BoxesAppWindow* _tmp12_;
		BoxesAppWindow* _tmp13_;
		BoxesUIState _tmp14_;
		BoxesUIState _tmp15_;
		_tmp12_ = boxes_machine_get_window (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = boxes_ui_get_ui_state ((BoxesUI*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp7_ = _tmp15_ == BOXES_UI_STATE_DISPLAY;
	}
	if (_tmp7_) {
		gboolean _tmp16_ = FALSE;
		if (!self->stay_on_display) {
			BoxesAppWindow* _tmp17_;
			BoxesAppWindow* _tmp18_;
			BoxesCollectionItem* _tmp19_;
			BoxesCollectionItem* _tmp20_;
			_tmp17_ = boxes_machine_get_window (self);
			_tmp18_ = _tmp17_;
			_tmp19_ = boxes_app_window_get_current_item (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp16_ = _tmp20_ == G_TYPE_CHECK_INSTANCE_CAST (self, BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItem);
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			BoxesAppWindow* _tmp21_;
			BoxesAppWindow* _tmp22_;
			_tmp21_ = boxes_machine_get_window (self);
			_tmp22_ = _tmp21_;
			boxes_ui_set_state ((BoxesUI*) _tmp22_, BOXES_UI_STATE_COLLECTION);
		}
		if (failed) {
			gchar* message = NULL;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			BoxesAppWindow* _tmp26_;
			BoxesAppWindow* _tmp27_;
			const gchar* _tmp28_;
			BoxesToast* _tmp29_;
			BoxesToast* _tmp30_;
			_tmp23_ = boxes_collection_item_get_name ((BoxesCollectionItem*) self);
			_tmp24_ = _tmp23_;
			_tmp25_ = g_strdup_printf (_ ("Connection to “%s” failed"), _tmp24_);
			message = _tmp25_;
			_tmp26_ = boxes_machine_get_window (self);
			_tmp27_ = _tmp26_;
			_tmp28_ = message;
			_tmp29_ = boxes_toast_new (_tmp28_);
			g_object_ref_sink (_tmp29_);
			_tmp30_ = _tmp29_;
			boxes_app_window_display_toast (_tmp27_, _tmp30_);
			_g_object_unref0 (_tmp30_);
			_g_free0 (message);
		}
	}
	boxes_machine_load_screenshot (self);
	if (!self->stay_on_display) {
		boxes_machine_disconnect_display (self);
	}
}

static void
__boxes_machine_display___lambda130__boxes_display_disconnected (BoxesDisplay* _sender,
                                                                 gboolean connection_failed,
                                                                 gpointer self)
{
	_boxes_machine_display___lambda130_ ((BoxesMachine*) self, connection_failed);
}

void
boxes_machine_set_display (BoxesMachine* self,
                           BoxesDisplay* value)
{
	BoxesDisplay* _tmp0_;
	BoxesDisplay* _tmp5_;
	BoxesDisplay* _tmp6_;
	BoxesAppWindow* _tmp7_;
	BoxesAppWindow* _tmp8_;
	BoxesTopbar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	BoxesDisplay* _tmp14_;
	gulong _tmp15_;
	BoxesDisplay* _tmp16_;
	gulong _tmp17_;
	BoxesDisplay* _tmp18_;
	gulong _tmp19_;
	BoxesDisplay* _tmp20_;
	gulong _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_display;
	if (_tmp0_ != NULL) {
		BoxesDisplay* _tmp1_;
		BoxesDisplay* _tmp2_;
		BoxesDisplay* _tmp3_;
		BoxesDisplay* _tmp4_;
		_tmp1_ = self->priv->_display;
		g_signal_handler_disconnect ((GObject*) _tmp1_, self->priv->show_id);
		self->priv->show_id = (gulong) 0;
		_tmp2_ = self->priv->_display;
		g_signal_handler_disconnect ((GObject*) _tmp2_, self->priv->hide_id);
		self->priv->hide_id = (gulong) 0;
		_tmp3_ = self->priv->_display;
		g_signal_handler_disconnect ((GObject*) _tmp3_, self->priv->disconnected_id);
		self->priv->disconnected_id = (gulong) 0;
		_tmp4_ = self->priv->_display;
		g_signal_handler_disconnect ((GObject*) _tmp4_, self->priv->got_error_id);
		self->priv->got_error_id = (gulong) 0;
	}
	_tmp5_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_display);
	self->priv->_display = _tmp5_;
	_tmp6_ = self->priv->_display;
	if (_tmp6_ == NULL) {
		return;
	}
	_tmp7_ = boxes_machine_get_window (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_->topbar;
	_tmp10_ = boxes_collection_item_get_name ((BoxesCollectionItem*) self);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf (_ ("Connecting to %s"), _tmp11_);
	_tmp13_ = _tmp12_;
	boxes_topbar_set_status (_tmp9_, _tmp13_);
	_g_free0 (_tmp13_);
	_tmp14_ = self->priv->_display;
	_tmp15_ = g_signal_connect_object (_tmp14_, "show", (GCallback) __boxes_machine_display___lambda127__boxes_display_show, self, 0);
	self->priv->show_id = _tmp15_;
	_tmp16_ = self->priv->_display;
	_tmp17_ = g_signal_connect_object (_tmp16_, "hide", (GCallback) __boxes_machine_display___lambda128__boxes_display_hide, self, 0);
	self->priv->hide_id = _tmp17_;
	_tmp18_ = self->priv->_display;
	_tmp19_ = g_signal_connect_object (_tmp18_, "got-error", (GCallback) __boxes_machine_display___lambda129__boxes_display_got_error, self, 0);
	self->priv->got_error_id = _tmp19_;
	_tmp20_ = self->priv->_display;
	_tmp21_ = g_signal_connect_object (_tmp20_, "disconnected", (GCallback) __boxes_machine_display___lambda130__boxes_display_disconnected, self, 0);
	self->priv->disconnected_id = _tmp21_;
	g_object_notify_by_pspec ((GObject *) self, boxes_machine_properties[BOXES_MACHINE_DISPLAY_PROPERTY]);
}

static void
boxes_machine_class_init (BoxesMachineClass * klass,
                          gpointer klass_data)
{
	cairo_surface_t* _tmp0_;
	cairo_t* cr = NULL;
	cairo_surface_t* _tmp1_;
	cairo_t* _tmp2_;
	cairo_t* _tmp3_;
	cairo_t* _tmp4_;
	cairo_t* _tmp5_;
	cairo_t* _tmp6_;
	cairo_t* _tmp7_;
	cairo_t* _tmp8_;
	cairo_t* _tmp9_;
	cairo_t* _tmp10_;
	boxes_machine_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BoxesMachine_private_offset);
	((BoxesMachineClass *) klass)->save_real = (void (*) (BoxesMachine*, GAsyncReadyCallback, gpointer)) boxes_machine_real_save_real;
	((BoxesMachineClass *) klass)->save_real_finish = (void (*) (BoxesMachine*, GAsyncResult*, GError**)) boxes_machine_real_save_real_finish;
	((BoxesMachineClass *) klass)->take_screenshot = (void (*) (BoxesMachine*, GAsyncReadyCallback, gpointer)) boxes_machine_real_take_screenshot;
	((BoxesMachineClass *) klass)->take_screenshot_finish = (GdkPixbuf* (*) (BoxesMachine*, GAsyncResult*, GError**)) boxes_machine_real_take_screenshot_finish;
	((BoxesMachineClass *) klass)->restart = (void (*) (BoxesMachine*)) boxes_machine_real_restart;
	((BoxesMachineClass *) klass)->disconnect_display = (void (*) (BoxesMachine*)) boxes_machine_real_disconnect_display;
	((BoxesMachineClass *) klass)->update_status = (void (*) (BoxesMachine*)) boxes_machine_real_update_status;
	((BoxesMachineClass *) klass)->delete = (void (*) (BoxesMachine*, gboolean)) boxes_machine_real_delete;
	((BoxesCollectionItemClass *) klass)->compare = (gint (*) (BoxesCollectionItem*, BoxesCollectionItem*)) boxes_machine_real_compare;
	BOXES_MACHINE_CLASS (klass)->get_suspend_at_exit = (gboolean (*) (BoxesMachine*)) boxes_machine_real_get_suspend_at_exit;
	BOXES_MACHINE_CLASS (klass)->get_can_save = (gboolean (*) (BoxesMachine*)) boxes_machine_real_get_can_save;
	BOXES_MACHINE_CLASS (klass)->get_should_autosave = (gboolean (*) (BoxesMachine*)) boxes_machine_real_get_should_autosave;
	BOXES_MACHINE_CLASS (klass)->get_is_local = (gboolean (*) (BoxesMachine*)) boxes_machine_real_get_is_local;
	G_OBJECT_CLASS (klass)->get_property = _vala_boxes_machine_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_boxes_machine_set_property;
	G_OBJECT_CLASS (klass)->finalize = boxes_machine_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_MACHINE_PIXBUF_PROPERTY, boxes_machine_properties[BOXES_MACHINE_PIXBUF_PROPERTY] = g_param_spec_object ("pixbuf", "pixbuf", "pixbuf", gdk_pixbuf_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_MACHINE_STATUS_PROPERTY, boxes_machine_properties[BOXES_MACHINE_STATUS_PROPERTY] = g_param_spec_string ("status", "status", "status", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_MACHINE_SUSPEND_AT_EXIT_PROPERTY, boxes_machine_properties[BOXES_MACHINE_SUSPEND_AT_EXIT_PROPERTY] = g_param_spec_boolean ("suspend-at-exit", "suspend-at-exit", "suspend-at-exit", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_MACHINE_CAN_SAVE_PROPERTY, boxes_machine_properties[BOXES_MACHINE_CAN_SAVE_PROPERTY] = g_param_spec_boolean ("can-save", "can-save", "can-save", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_MACHINE_CAN_RESTART_PROPERTY, boxes_machine_properties[BOXES_MACHINE_CAN_RESTART_PROPERTY] = g_param_spec_boolean ("can-restart", "can-restart", "can-restart", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_MACHINE_CAN_CLONE_PROPERTY, boxes_machine_properties[BOXES_MACHINE_CAN_CLONE_PROPERTY] = g_param_spec_boolean ("can-clone", "can-clone", "can-clone", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_MACHINE_CAN_DELETE_PROPERTY, boxes_machine_properties[BOXES_MACHINE_CAN_DELETE_PROPERTY] = g_param_spec_boolean ("can-delete", "can-delete", "can-delete", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_MACHINE_UNDER_CONSTRUCTION_PROPERTY, boxes_machine_properties[BOXES_MACHINE_UNDER_CONSTRUCTION_PROPERTY] = g_param_spec_boolean ("under-construction", "under-construction", "under-construction", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_MACHINE_SHOULD_AUTOSAVE_PROPERTY, boxes_machine_properties[BOXES_MACHINE_SHOULD_AUTOSAVE_PROPERTY] = g_param_spec_boolean ("should-autosave", "should-autosave", "should-autosave", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_MACHINE_IS_CONNECTED_PROPERTY, boxes_machine_properties[BOXES_MACHINE_IS_CONNECTED_PROPERTY] = g_param_spec_boolean ("is-connected", "is-connected", "is-connected", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_MACHINE_IS_RUNNING_PROPERTY, boxes_machine_properties[BOXES_MACHINE_IS_RUNNING_PROPERTY] = g_param_spec_boolean ("is-running", "is-running", "is-running", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_MACHINE_IS_ON_PROPERTY, boxes_machine_properties[BOXES_MACHINE_IS_ON_PROPERTY] = g_param_spec_boolean ("is-on", "is-on", "is-on", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_MACHINE_IS_STOPPED_PROPERTY, boxes_machine_properties[BOXES_MACHINE_IS_STOPPED_PROPERTY] = g_param_spec_boolean ("is-stopped", "is-stopped", "is-stopped", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_MACHINE_IS_LOCAL_PROPERTY, boxes_machine_properties[BOXES_MACHINE_IS_LOCAL_PROPERTY] = g_param_spec_boolean ("is-local", "is-local", "is-local", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_MACHINE_CONNECTING_CANCELLABLE_PROPERTY, boxes_machine_properties[BOXES_MACHINE_CONNECTING_CANCELLABLE_PROPERTY] = g_param_spec_object ("connecting-cancellable", "connecting-cancellable", "connecting-cancellable", g_cancellable_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_MACHINE_STATE_PROPERTY, boxes_machine_properties[BOXES_MACHINE_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", BOXES_MACHINE_TYPE_MACHINE_STATE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_MACHINE_WINDOW_PROPERTY, boxes_machine_properties[BOXES_MACHINE_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", BOXES_TYPE_APP_WINDOW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_MACHINE_DELETED_PROPERTY, boxes_machine_properties[BOXES_MACHINE_DELETED_PROPERTY] = g_param_spec_boolean ("deleted", "deleted", "deleted", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_MACHINE_DISPLAY_PROPERTY, boxes_machine_properties[BOXES_MACHINE_DISPLAY_PROPERTY] = g_param_spec_object ("display", "display", "display", BOXES_TYPE_DISPLAY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	boxes_machine_signals[BOXES_MACHINE_GOT_ERROR_SIGNAL] = g_signal_new ("got-error", BOXES_TYPE_MACHINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	_tmp0_ = cairo_image_surface_create (CAIRO_FORMAT_A8, 2, 2);
	_cairo_surface_destroy0 (boxes_machine_grid_surface);
	boxes_machine_grid_surface = _tmp0_;
	_tmp1_ = boxes_machine_grid_surface;
	_tmp2_ = cairo_create (_tmp1_);
	cr = _tmp2_;
	_tmp3_ = cr;
	cairo_set_source_rgba (_tmp3_, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	_tmp4_ = cr;
	cairo_paint (_tmp4_);
	_tmp5_ = cr;
	cairo_set_source_rgba (_tmp5_, (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	_tmp6_ = cr;
	cairo_set_operator (_tmp6_, CAIRO_OPERATOR_SOURCE);
	_tmp7_ = cr;
	cairo_rectangle (_tmp7_, (gdouble) 0, (gdouble) 0, (gdouble) 1, (gdouble) 1);
	_tmp8_ = cr;
	cairo_fill (_tmp8_);
	_tmp9_ = cr;
	cairo_rectangle (_tmp9_, (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	_tmp10_ = cr;
	cairo_fill (_tmp10_);
	_cairo_destroy0 (cr);
}

static void
boxes_machine_instance_init (BoxesMachine * self,
                             gpointer klass)
{
	self->priv = boxes_machine_get_instance_private (self);
	self->priv->_can_delete = TRUE;
	self->priv->_under_construction = FALSE;
}

static void
boxes_machine_finalize (GObject * obj)
{
	BoxesMachine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_MACHINE, BoxesMachine);
	_g_object_unref0 (self->source);
	_g_object_unref0 (self->config);
	_g_object_unref0 (self->priv->_pixbuf);
	_g_free0 (self->priv->_status);
	_g_object_unref0 (self->priv->_connecting_cancellable);
	_g_object_unref0 (self->priv->orig_pixbuf);
	_g_object_unref0 (self->priv->_display);
	_g_object_unref0 (self->priv->name_status_bind);
	G_OBJECT_CLASS (boxes_machine_parent_class)->finalize (obj);
}

static GType
boxes_machine_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BoxesMachineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_machine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesMachine), 0, (GInstanceInitFunc) boxes_machine_instance_init, NULL };
	GType boxes_machine_type_id;
	boxes_machine_type_id = g_type_register_static (BOXES_TYPE_COLLECTION_ITEM, "BoxesMachine", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	BoxesMachine_private_offset = g_type_add_instance_private (boxes_machine_type_id, sizeof (BoxesMachinePrivate));
	return boxes_machine_type_id;
}

GType
boxes_machine_get_type (void)
{
	static volatile gsize boxes_machine_type_id__once = 0;
	if (g_once_init_enter (&boxes_machine_type_id__once)) {
		GType boxes_machine_type_id;
		boxes_machine_type_id = boxes_machine_get_type_once ();
		g_once_init_leave (&boxes_machine_type_id__once, boxes_machine_type_id);
	}
	return boxes_machine_type_id__once;
}

static void
_vala_boxes_machine_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	BoxesMachine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_MACHINE, BoxesMachine);
	switch (property_id) {
		case BOXES_MACHINE_PIXBUF_PROPERTY:
		g_value_set_object (value, boxes_machine_get_pixbuf (self));
		break;
		case BOXES_MACHINE_STATUS_PROPERTY:
		g_value_set_string (value, boxes_machine_get_status (self));
		break;
		case BOXES_MACHINE_SUSPEND_AT_EXIT_PROPERTY:
		g_value_set_boolean (value, boxes_machine_get_suspend_at_exit (self));
		break;
		case BOXES_MACHINE_CAN_SAVE_PROPERTY:
		g_value_set_boolean (value, boxes_machine_get_can_save (self));
		break;
		case BOXES_MACHINE_CAN_DELETE_PROPERTY:
		g_value_set_boolean (value, boxes_machine_get_can_delete (self));
		break;
		case BOXES_MACHINE_UNDER_CONSTRUCTION_PROPERTY:
		g_value_set_boolean (value, boxes_machine_get_under_construction (self));
		break;
		case BOXES_MACHINE_SHOULD_AUTOSAVE_PROPERTY:
		g_value_set_boolean (value, boxes_machine_get_should_autosave (self));
		break;
		case BOXES_MACHINE_IS_CONNECTED_PROPERTY:
		g_value_set_boolean (value, boxes_machine_get_is_connected (self));
		break;
		case BOXES_MACHINE_IS_RUNNING_PROPERTY:
		g_value_set_boolean (value, boxes_machine_get_is_running (self));
		break;
		case BOXES_MACHINE_IS_ON_PROPERTY:
		g_value_set_boolean (value, boxes_machine_get_is_on (self));
		break;
		case BOXES_MACHINE_IS_STOPPED_PROPERTY:
		g_value_set_boolean (value, boxes_machine_get_is_stopped (self));
		break;
		case BOXES_MACHINE_IS_LOCAL_PROPERTY:
		g_value_set_boolean (value, boxes_machine_get_is_local (self));
		break;
		case BOXES_MACHINE_CONNECTING_CANCELLABLE_PROPERTY:
		g_value_set_object (value, boxes_machine_get_connecting_cancellable (self));
		break;
		case BOXES_MACHINE_STATE_PROPERTY:
		g_value_set_enum (value, boxes_machine_get_state (self));
		break;
		case BOXES_MACHINE_WINDOW_PROPERTY:
		g_value_set_object (value, boxes_machine_get_window (self));
		break;
		case BOXES_MACHINE_DELETED_PROPERTY:
		g_value_set_boolean (value, boxes_machine_get_deleted (self));
		break;
		case BOXES_MACHINE_DISPLAY_PROPERTY:
		g_value_set_object (value, boxes_machine_get_display (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_boxes_machine_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	BoxesMachine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_MACHINE, BoxesMachine);
	switch (property_id) {
		case BOXES_MACHINE_PIXBUF_PROPERTY:
		boxes_machine_set_pixbuf (self, g_value_get_object (value));
		break;
		case BOXES_MACHINE_STATUS_PROPERTY:
		boxes_machine_set_status (self, g_value_get_string (value));
		break;
		case BOXES_MACHINE_CAN_DELETE_PROPERTY:
		boxes_machine_set_can_delete (self, g_value_get_boolean (value));
		break;
		case BOXES_MACHINE_UNDER_CONSTRUCTION_PROPERTY:
		boxes_machine_set_under_construction (self, g_value_get_boolean (value));
		break;
		case BOXES_MACHINE_CONNECTING_CANCELLABLE_PROPERTY:
		boxes_machine_set_connecting_cancellable (self, g_value_get_object (value));
		break;
		case BOXES_MACHINE_STATE_PROPERTY:
		boxes_machine_set_state (self, g_value_get_enum (value));
		break;
		case BOXES_MACHINE_WINDOW_PROPERTY:
		boxes_machine_set_window (self, g_value_get_object (value));
		break;
		case BOXES_MACHINE_DELETED_PROPERTY:
		boxes_machine_set_deleted (self, g_value_get_boolean (value));
		break;
		case BOXES_MACHINE_DISPLAY_PROPERTY:
		boxes_machine_set_display (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

