/* mime-disposition-type.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from mime-disposition-type.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

VALA_EXTERN GearyMimeDispositionType geary_mime_disposition_type_from_int (gint i);

/**
 * A representation of a MIME Content-Disposition type field.
 *
 * Note that NONE only indicates that the Content-Disposition type field was not present.
 * RFC 2183 Section 2.8 specifies that unknown type fields should be treated as attachments,
 * which is true in this code as well.
 *
 * These values may be persisted on disk and should not be modified unless you know what
 * you're doing.  (Legacy code requires that NONE be -1.)
 *
 * See [[https://tools.ietf.org/html/rfc2183#section-2]]
 */
/**
     * Convert the disposition-type field into an internal representation.
     *
     * Empty or blank fields result in {@link UNSPECIFIED}.  Unknown fields are converted to
     * {@link ATTACHMENT} as per RFC 2183 Section 2.8.  However, since the caller may want to
     * make a decision about unknown vs. unspecified type fields, is_unknown is returned as well.
     */
GearyMimeDispositionType
geary_mime_disposition_type_deserialize (const gchar* str,
                                         gboolean* is_unknown)
{
	gboolean _vala_is_unknown = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	GearyMimeDispositionType result;
	_vala_is_unknown = FALSE;
	if (geary_string_is_empty_or_whitespace (str)) {
		result = GEARY_MIME_DISPOSITION_TYPE_UNSPECIFIED;
		if (is_unknown) {
			*is_unknown = _vala_is_unknown;
		}
		return result;
	}
	_tmp0_ = geary_ascii_strdown (str);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	g_free (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("inline")))) {
		switch (0) {
			default:
			{
				result = GEARY_MIME_DISPOSITION_TYPE_INLINE;
				if (is_unknown) {
					*is_unknown = _vala_is_unknown;
				}
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("attachment")))) {
		switch (0) {
			default:
			{
				result = GEARY_MIME_DISPOSITION_TYPE_ATTACHMENT;
				if (is_unknown) {
					*is_unknown = _vala_is_unknown;
				}
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				_vala_is_unknown = TRUE;
				result = GEARY_MIME_DISPOSITION_TYPE_ATTACHMENT;
				if (is_unknown) {
					*is_unknown = _vala_is_unknown;
				}
				return result;
			}
		}
	}
}

/**
     * Returns null if value is {@link UNSPECIFIED}
     */
gchar*
geary_mime_disposition_type_serialize (GearyMimeDispositionType self)
{
	gchar* result;
	switch (self) {
		case GEARY_MIME_DISPOSITION_TYPE_UNSPECIFIED:
		{
			result = NULL;
			return result;
		}
		case GEARY_MIME_DISPOSITION_TYPE_ATTACHMENT:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("attachment");
			result = _tmp0_;
			return result;
		}
		case GEARY_MIME_DISPOSITION_TYPE_INLINE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("inline");
			result = _tmp1_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

GearyMimeDispositionType
geary_mime_disposition_type_from_int (gint i)
{
	GearyMimeDispositionType result;
	switch (i) {
		case GEARY_MIME_DISPOSITION_TYPE_INLINE:
		{
			result = GEARY_MIME_DISPOSITION_TYPE_INLINE;
			return result;
		}
		case GEARY_MIME_DISPOSITION_TYPE_UNSPECIFIED:
		{
			result = GEARY_MIME_DISPOSITION_TYPE_UNSPECIFIED;
			return result;
		}
		default:
		case GEARY_MIME_DISPOSITION_TYPE_ATTACHMENT:
		{
			result = GEARY_MIME_DISPOSITION_TYPE_ATTACHMENT;
			return result;
		}
	}
}

 G_GNUC_NO_INLINE static GType
geary_mime_disposition_type_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_MIME_DISPOSITION_TYPE_UNSPECIFIED, "GEARY_MIME_DISPOSITION_TYPE_UNSPECIFIED", "unspecified"}, {GEARY_MIME_DISPOSITION_TYPE_ATTACHMENT, "GEARY_MIME_DISPOSITION_TYPE_ATTACHMENT", "attachment"}, {GEARY_MIME_DISPOSITION_TYPE_INLINE, "GEARY_MIME_DISPOSITION_TYPE_INLINE", "inline"}, {0, NULL, NULL}};
	GType geary_mime_disposition_type_type_id;
	geary_mime_disposition_type_type_id = g_enum_register_static ("GearyMimeDispositionType", values);
	return geary_mime_disposition_type_type_id;
}

GType
geary_mime_disposition_type_get_type (void)
{
	static gsize geary_mime_disposition_type_type_id__once = 0;
	if (g_once_init_enter (&geary_mime_disposition_type_type_id__once)) {
		GType geary_mime_disposition_type_type_id;
		geary_mime_disposition_type_type_id = geary_mime_disposition_type_get_type_once ();
		g_once_init_leave (&geary_mime_disposition_type_type_id__once, geary_mime_disposition_type_type_id);
	}
	return geary_mime_disposition_type_type_id__once;
}

