/* certificate-warning-dialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from certificate-warning-dialog.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-client-46.0.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include "geary-engine.h"
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>

#define CERTIFICATE_WARNING_DIALOG_BULLET "&#8226; "
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _ParamSpecCertificateWarningDialog ParamSpecCertificateWarningDialog;

struct _CertificateWarningDialogPrivate {
	GtkDialog* dialog;
};

struct _ParamSpecCertificateWarningDialog {
	GParamSpec parent_instance;
};

static gint CertificateWarningDialog_private_offset;
static gpointer certificate_warning_dialog_parent_class = NULL;

static gchar* certificate_warning_dialog_generate_warning_list (GTlsCertificateFlags warnings);
static void certificate_warning_dialog_finalize (CertificateWarningDialog * obj);
static GType certificate_warning_dialog_get_type_once (void);

static inline gpointer
certificate_warning_dialog_get_instance_private (CertificateWarningDialog* self)
{
	return G_STRUCT_MEMBER_P (self, CertificateWarningDialog_private_offset);
}

static GType
certificate_warning_dialog_result_get_type_once (void)
{
	static const GEnumValue values[] = {{CERTIFICATE_WARNING_DIALOG_RESULT_DONT_TRUST, "CERTIFICATE_WARNING_DIALOG_RESULT_DONT_TRUST", "dont-trust"}, {CERTIFICATE_WARNING_DIALOG_RESULT_TRUST, "CERTIFICATE_WARNING_DIALOG_RESULT_TRUST", "trust"}, {CERTIFICATE_WARNING_DIALOG_RESULT_ALWAYS_TRUST, "CERTIFICATE_WARNING_DIALOG_RESULT_ALWAYS_TRUST", "always-trust"}, {0, NULL, NULL}};
	GType certificate_warning_dialog_result_type_id;
	certificate_warning_dialog_result_type_id = g_enum_register_static ("CertificateWarningDialogResult", values);
	return certificate_warning_dialog_result_type_id;
}

GType
certificate_warning_dialog_result_get_type (void)
{
	static volatile gsize certificate_warning_dialog_result_type_id__once = 0;
	if (g_once_init_enter (&certificate_warning_dialog_result_type_id__once)) {
		GType certificate_warning_dialog_result_type_id;
		certificate_warning_dialog_result_type_id = certificate_warning_dialog_result_get_type_once ();
		g_once_init_leave (&certificate_warning_dialog_result_type_id__once, certificate_warning_dialog_result_type_id);
	}
	return certificate_warning_dialog_result_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

CertificateWarningDialog*
certificate_warning_dialog_construct (GType object_type,
                                      GtkWindow* parent,
                                      GearyAccountInformation* account,
                                      GearyServiceInformation* service,
                                      GearyEndpoint* endpoint,
                                      gboolean is_validation)
{
	CertificateWarningDialog* self = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_;
	GtkBuilder* _tmp1_;
	GObject* _tmp2_;
	GtkDialog* _tmp3_;
	GtkDialog* _tmp4_;
	GtkDialog* _tmp5_;
	GtkLabel* title_label = NULL;
	GtkBuilder* _tmp6_;
	GObject* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* top_label = NULL;
	GtkBuilder* _tmp9_;
	GObject* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* warnings_label = NULL;
	GtkBuilder* _tmp12_;
	GObject* _tmp13_;
	GtkLabel* _tmp14_;
	GtkLabel* trust_label = NULL;
	GtkBuilder* _tmp15_;
	GObject* _tmp16_;
	GtkLabel* _tmp17_;
	GtkLabel* dont_trust_label = NULL;
	GtkBuilder* _tmp18_;
	GObject* _tmp19_;
	GtkLabel* _tmp20_;
	GtkLabel* contact_label = NULL;
	GtkBuilder* _tmp21_;
	GObject* _tmp22_;
	GtkLabel* _tmp23_;
	GtkLabel* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	GtkLabel* _tmp29_;
	GearyProtocol _tmp30_;
	GearyProtocol _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	guint16 _tmp36_;
	guint16 _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	GtkLabel* _tmp40_;
	GTlsCertificateFlags _tmp41_;
	GTlsCertificateFlags _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	GtkLabel* _tmp45_;
	GtkLabel* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	GtkLabel* _tmp51_;
	GtkLabel* _tmp64_;
	GtkLabel* _tmp65_;
	g_return_val_if_fail ((parent == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (parent, gtk_window_get_type ()), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT_INFORMATION), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (service, GEARY_TYPE_SERVICE_INFORMATION), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (endpoint, GEARY_TYPE_ENDPOINT), NULL);
	self = (CertificateWarningDialog*) g_type_create_instance (object_type);
	_tmp0_ = gio_util_create_builder ("certificate_warning_dialog.glade");
	builder = _tmp0_;
	_tmp1_ = builder;
	_tmp2_ = gtk_builder_get_object (_tmp1_, "CertificateWarningDialog");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_dialog_get_type (), GtkDialog));
	_g_object_unref0 (self->priv->dialog);
	self->priv->dialog = _tmp3_;
	_tmp4_ = self->priv->dialog;
	gtk_window_set_transient_for (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_window_get_type (), GtkWindow), parent);
	_tmp5_ = self->priv->dialog;
	gtk_window_set_modal (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_window_get_type (), GtkWindow), TRUE);
	_tmp6_ = builder;
	_tmp7_ = gtk_builder_get_object (_tmp6_, "untrusted_connection_label");
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_label_get_type (), GtkLabel));
	title_label = _tmp8_;
	_tmp9_ = builder;
	_tmp10_ = gtk_builder_get_object (_tmp9_, "top_label");
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_label_get_type (), GtkLabel));
	top_label = _tmp11_;
	_tmp12_ = builder;
	_tmp13_ = gtk_builder_get_object (_tmp12_, "warnings_label");
	_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_label_get_type (), GtkLabel));
	warnings_label = _tmp14_;
	_tmp15_ = builder;
	_tmp16_ = gtk_builder_get_object (_tmp15_, "trust_label");
	_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_label_get_type (), GtkLabel));
	trust_label = _tmp17_;
	_tmp18_ = builder;
	_tmp19_ = gtk_builder_get_object (_tmp18_, "dont_trust_label");
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_label_get_type (), GtkLabel));
	dont_trust_label = _tmp20_;
	_tmp21_ = builder;
	_tmp22_ = gtk_builder_get_object (_tmp21_, "contact_label");
	_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_label_get_type (), GtkLabel));
	contact_label = _tmp23_;
	_tmp24_ = title_label;
	_tmp25_ = geary_account_information_get_display_name (account);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_strdup_printf (_ ("Untrusted Connection: %s"), _tmp26_);
	_tmp28_ = _tmp27_;
	gtk_label_set_label (_tmp24_, _tmp28_);
	_g_free0 (_tmp28_);
	_tmp29_ = top_label;
	_tmp30_ = geary_service_information_get_protocol (service);
	_tmp31_ = _tmp30_;
	_tmp32_ = geary_protocol_to_value (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = geary_service_information_get_host (service);
	_tmp35_ = _tmp34_;
	_tmp36_ = geary_service_information_get_port (service);
	_tmp37_ = _tmp36_;
	_tmp38_ = g_strdup_printf (_ ("The identity of the %s mail server at %s:%u could not be verified."), _tmp33_, _tmp35_, (guint) _tmp37_);
	_tmp39_ = _tmp38_;
	gtk_label_set_label (_tmp29_, _tmp39_);
	_g_free0 (_tmp39_);
	_g_free0 (_tmp33_);
	_tmp40_ = warnings_label;
	_tmp41_ = geary_endpoint_get_tls_validation_warnings (endpoint);
	_tmp42_ = _tmp41_;
	_tmp43_ = certificate_warning_dialog_generate_warning_list (_tmp42_);
	_tmp44_ = _tmp43_;
	gtk_label_set_label (_tmp40_, _tmp44_);
	_g_free0 (_tmp44_);
	_tmp45_ = warnings_label;
	gtk_label_set_use_markup (_tmp45_, TRUE);
	_tmp46_ = trust_label;
	_tmp47_ = g_strconcat ("<b>", _ ("Selecting “Trust This Server” or “Always Trust This Server” may cause " \
"your username and password to be transmitted insecurely."), NULL);
	_tmp48_ = _tmp47_;
	_tmp49_ = g_strconcat (_tmp48_, "</b>", NULL);
	_tmp50_ = _tmp49_;
	gtk_label_set_label (_tmp46_, _tmp50_);
	_g_free0 (_tmp50_);
	_g_free0 (_tmp48_);
	_tmp51_ = trust_label;
	gtk_label_set_use_markup (_tmp51_, TRUE);
	if (is_validation) {
		GtkLabel* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		_tmp52_ = dont_trust_label;
		_tmp53_ = g_strconcat ("<b>", _ ("Selecting “Don’t Trust This Server” will cause Geary not to access thi" \
"s server."), NULL);
		_tmp54_ = _tmp53_;
		_tmp55_ = g_strconcat (_tmp54_, "</b> ", NULL);
		_tmp56_ = _tmp55_;
		_tmp57_ = g_strconcat (_tmp56_, _ ("Geary will not add or update this email account."), NULL);
		_tmp58_ = _tmp57_;
		gtk_label_set_label (_tmp52_, _tmp58_);
		_g_free0 (_tmp58_);
		_g_free0 (_tmp56_);
		_g_free0 (_tmp54_);
	} else {
		GtkLabel* _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
		gchar* _tmp62_;
		gchar* _tmp63_;
		_tmp59_ = dont_trust_label;
		_tmp60_ = g_strconcat ("<b>", _ ("Selecting “Don’t Trust This Server” will cause Geary to stop accessing" \
" this account."), NULL);
		_tmp61_ = _tmp60_;
		_tmp62_ = g_strconcat (_tmp61_, "</b> ", NULL);
		_tmp63_ = _tmp62_;
		gtk_label_set_label (_tmp59_, _tmp63_);
		_g_free0 (_tmp63_);
		_g_free0 (_tmp61_);
	}
	_tmp64_ = dont_trust_label;
	gtk_label_set_use_markup (_tmp64_, TRUE);
	_tmp65_ = contact_label;
	gtk_label_set_label (_tmp65_, _ ("Contact your system administrator or email service provider if you hav" \
"e any question about these issues."));
	_g_object_unref0 (contact_label);
	_g_object_unref0 (dont_trust_label);
	_g_object_unref0 (trust_label);
	_g_object_unref0 (warnings_label);
	_g_object_unref0 (top_label);
	_g_object_unref0 (title_label);
	_g_object_unref0 (builder);
	return self;
}

CertificateWarningDialog*
certificate_warning_dialog_new (GtkWindow* parent,
                                GearyAccountInformation* account,
                                GearyServiceInformation* service,
                                GearyEndpoint* endpoint,
                                gboolean is_validation)
{
	return certificate_warning_dialog_construct (TYPE_CERTIFICATE_WARNING_DIALOG, parent, account, service, endpoint, is_validation);
}

static gchar*
certificate_warning_dialog_generate_warning_list (GTlsCertificateFlags warnings)
{
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* result;
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	if ((warnings & G_TLS_CERTIFICATE_UNKNOWN_CA) != 0) {
		GString* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = builder;
		_tmp2_ = g_strconcat (CERTIFICATE_WARNING_DIALOG_BULLET, _ ("The server’s certificate is not signed by a known authority"), NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat (_tmp3_, "\n", NULL);
		_tmp5_ = _tmp4_;
		g_string_append (_tmp1_, _tmp5_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
	}
	if ((warnings & G_TLS_CERTIFICATE_BAD_IDENTITY) != 0) {
		GString* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp6_ = builder;
		_tmp7_ = g_strconcat (CERTIFICATE_WARNING_DIALOG_BULLET, _ ("The server’s identity does not match the identity in the certificate"), NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (_tmp8_, "\n", NULL);
		_tmp10_ = _tmp9_;
		g_string_append (_tmp6_, _tmp10_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
	}
	if ((warnings & G_TLS_CERTIFICATE_EXPIRED) != 0) {
		GString* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp11_ = builder;
		_tmp12_ = g_strconcat (CERTIFICATE_WARNING_DIALOG_BULLET, _ ("The server’s certificate has expired"), NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat (_tmp13_, "\n", NULL);
		_tmp15_ = _tmp14_;
		g_string_append (_tmp11_, _tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
	}
	if ((warnings & G_TLS_CERTIFICATE_NOT_ACTIVATED) != 0) {
		GString* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp16_ = builder;
		_tmp17_ = g_strconcat (CERTIFICATE_WARNING_DIALOG_BULLET, _ ("The server’s certificate has not been activated"), NULL);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strconcat (_tmp18_, "\n", NULL);
		_tmp20_ = _tmp19_;
		g_string_append (_tmp16_, _tmp20_);
		_g_free0 (_tmp20_);
		_g_free0 (_tmp18_);
	}
	if ((warnings & G_TLS_CERTIFICATE_REVOKED) != 0) {
		GString* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp21_ = builder;
		_tmp22_ = g_strconcat (CERTIFICATE_WARNING_DIALOG_BULLET, _ ("The server’s certificate has been revoked and is now invalid"), NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strconcat (_tmp23_, "\n", NULL);
		_tmp25_ = _tmp24_;
		g_string_append (_tmp21_, _tmp25_);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp23_);
	}
	if ((warnings & G_TLS_CERTIFICATE_INSECURE) != 0) {
		GString* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		_tmp26_ = builder;
		_tmp27_ = g_strconcat (CERTIFICATE_WARNING_DIALOG_BULLET, _ ("The server’s certificate is considered insecure"), NULL);
		_tmp28_ = _tmp27_;
		_tmp29_ = g_strconcat (_tmp28_, "\n", NULL);
		_tmp30_ = _tmp29_;
		g_string_append (_tmp26_, _tmp30_);
		_g_free0 (_tmp30_);
		_g_free0 (_tmp28_);
	}
	if ((warnings & G_TLS_CERTIFICATE_GENERIC_ERROR) != 0) {
		GString* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		_tmp31_ = builder;
		_tmp32_ = g_strconcat (CERTIFICATE_WARNING_DIALOG_BULLET, _ ("An error has occurred processing the server’s certificate"), NULL);
		_tmp33_ = _tmp32_;
		_tmp34_ = g_strconcat (_tmp33_, "\n", NULL);
		_tmp35_ = _tmp34_;
		g_string_append (_tmp31_, _tmp35_);
		_g_free0 (_tmp35_);
		_g_free0 (_tmp33_);
	}
	_tmp36_ = builder;
	_tmp37_ = _tmp36_->str;
	_tmp38_ = g_strdup (_tmp37_);
	result = _tmp38_;
	_g_string_free0 (builder);
	return result;
}

CertificateWarningDialogResult
certificate_warning_dialog_run (CertificateWarningDialog* self)
{
	GtkDialog* _tmp0_;
	gint response = 0;
	GtkDialog* _tmp1_;
	GtkDialog* _tmp2_;
	CertificateWarningDialogResult result;
	g_return_val_if_fail (IS_CERTIFICATE_WARNING_DIALOG (self), 0);
	_tmp0_ = self->priv->dialog;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = self->priv->dialog;
	response = gtk_dialog_run (_tmp1_);
	_tmp2_ = self->priv->dialog;
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget));
	switch (response) {
		case 1:
		{
			result = CERTIFICATE_WARNING_DIALOG_RESULT_TRUST;
			return result;
		}
		case 2:
		{
			result = CERTIFICATE_WARNING_DIALOG_RESULT_ALWAYS_TRUST;
			return result;
		}
		default:
		{
			result = CERTIFICATE_WARNING_DIALOG_RESULT_DONT_TRUST;
			return result;
		}
	}
}

static void
value_certificate_warning_dialog_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_certificate_warning_dialog_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		certificate_warning_dialog_unref (value->data[0].v_pointer);
	}
}

static void
value_certificate_warning_dialog_copy_value (const GValue* src_value,
                                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = certificate_warning_dialog_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_certificate_warning_dialog_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_certificate_warning_dialog_collect_value (GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		CertificateWarningDialog * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = certificate_warning_dialog_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_certificate_warning_dialog_lcopy_value (const GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	CertificateWarningDialog ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = certificate_warning_dialog_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_certificate_warning_dialog (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags)
{
	ParamSpecCertificateWarningDialog* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CERTIFICATE_WARNING_DIALOG), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_certificate_warning_dialog (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CERTIFICATE_WARNING_DIALOG), NULL);
	return value->data[0].v_pointer;
}

void
value_set_certificate_warning_dialog (GValue* value,
                                      gpointer v_object)
{
	CertificateWarningDialog * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CERTIFICATE_WARNING_DIALOG));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CERTIFICATE_WARNING_DIALOG));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		certificate_warning_dialog_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		certificate_warning_dialog_unref (old);
	}
}

void
value_take_certificate_warning_dialog (GValue* value,
                                       gpointer v_object)
{
	CertificateWarningDialog * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CERTIFICATE_WARNING_DIALOG));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CERTIFICATE_WARNING_DIALOG));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		certificate_warning_dialog_unref (old);
	}
}

static void
certificate_warning_dialog_class_init (CertificateWarningDialogClass * klass,
                                       gpointer klass_data)
{
	certificate_warning_dialog_parent_class = g_type_class_peek_parent (klass);
	((CertificateWarningDialogClass *) klass)->finalize = certificate_warning_dialog_finalize;
	g_type_class_adjust_private_offset (klass, &CertificateWarningDialog_private_offset);
}

static void
certificate_warning_dialog_instance_init (CertificateWarningDialog * self,
                                          gpointer klass)
{
	self->priv = certificate_warning_dialog_get_instance_private (self);
	self->ref_count = 1;
}

static void
certificate_warning_dialog_finalize (CertificateWarningDialog * obj)
{
	CertificateWarningDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CERTIFICATE_WARNING_DIALOG, CertificateWarningDialog);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->dialog);
}

static GType
certificate_warning_dialog_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_certificate_warning_dialog_init, value_certificate_warning_dialog_free_value, value_certificate_warning_dialog_copy_value, value_certificate_warning_dialog_peek_pointer, "p", value_certificate_warning_dialog_collect_value, "p", value_certificate_warning_dialog_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (CertificateWarningDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) certificate_warning_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CertificateWarningDialog), 0, (GInstanceInitFunc) certificate_warning_dialog_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType certificate_warning_dialog_type_id;
	certificate_warning_dialog_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CertificateWarningDialog", &g_define_type_info, &g_define_type_fundamental_info, 0);
	CertificateWarningDialog_private_offset = g_type_add_instance_private (certificate_warning_dialog_type_id, sizeof (CertificateWarningDialogPrivate));
	return certificate_warning_dialog_type_id;
}

GType
certificate_warning_dialog_get_type (void)
{
	static volatile gsize certificate_warning_dialog_type_id__once = 0;
	if (g_once_init_enter (&certificate_warning_dialog_type_id__once)) {
		GType certificate_warning_dialog_type_id;
		certificate_warning_dialog_type_id = certificate_warning_dialog_get_type_once ();
		g_once_init_leave (&certificate_warning_dialog_type_id__once, certificate_warning_dialog_type_id);
	}
	return certificate_warning_dialog_type_id__once;
}

gpointer
certificate_warning_dialog_ref (gpointer instance)
{
	CertificateWarningDialog * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
certificate_warning_dialog_unref (gpointer instance)
{
	CertificateWarningDialog * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CERTIFICATE_WARNING_DIALOG_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

