/* application-command.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from application-command.vala, do not modify */

/*
 * Copyright 2018 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-client-46.0.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	APPLICATION_COMMAND_0_PROPERTY,
	APPLICATION_COMMAND_CAN_UNDO_PROPERTY,
	APPLICATION_COMMAND_CAN_REDO_PROPERTY,
	APPLICATION_COMMAND_UNDO_LABEL_PROPERTY,
	APPLICATION_COMMAND_REDO_LABEL_PROPERTY,
	APPLICATION_COMMAND_EXECUTED_LABEL_PROPERTY,
	APPLICATION_COMMAND_EXECUTED_NOTIFICATION_BRIEF_PROPERTY,
	APPLICATION_COMMAND_UNDONE_LABEL_PROPERTY,
	APPLICATION_COMMAND_NUM_PROPERTIES
};
static GParamSpec* application_command_properties[APPLICATION_COMMAND_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ApplicationCommandRedoData ApplicationCommandRedoData;
enum  {
	APPLICATION_COMMAND_EXECUTED_SIGNAL,
	APPLICATION_COMMAND_UNDONE_SIGNAL,
	APPLICATION_COMMAND_REDONE_SIGNAL,
	APPLICATION_COMMAND_NUM_SIGNALS
};
static guint application_command_signals[APPLICATION_COMMAND_NUM_SIGNALS] = {0};
enum  {
	APPLICATION_COMMAND_SEQUENCE_0_PROPERTY,
	APPLICATION_COMMAND_SEQUENCE_NUM_PROPERTIES
};
static GParamSpec* application_command_sequence_properties[APPLICATION_COMMAND_SEQUENCE_NUM_PROPERTIES];
typedef struct _ApplicationCommandSequenceExecuteData ApplicationCommandSequenceExecuteData;
typedef struct _ApplicationCommandSequenceUndoData ApplicationCommandSequenceUndoData;
typedef struct _ApplicationCommandSequenceRedoData ApplicationCommandSequenceRedoData;
enum  {
	APPLICATION_PROPERTY_COMMAND_0_PROPERTY,
	APPLICATION_PROPERTY_COMMAND_T_TYPE,
	APPLICATION_PROPERTY_COMMAND_T_DUP_FUNC,
	APPLICATION_PROPERTY_COMMAND_T_DESTROY_FUNC,
	APPLICATION_PROPERTY_COMMAND_NUM_PROPERTIES
};
static GParamSpec* application_property_command_properties[APPLICATION_PROPERTY_COMMAND_NUM_PROPERTIES];
typedef struct _ApplicationPropertyCommandExecuteData ApplicationPropertyCommandExecuteData;
typedef struct _ApplicationPropertyCommandUndoData ApplicationPropertyCommandUndoData;
enum  {
	APPLICATION_COMMAND_STACK_0_PROPERTY,
	APPLICATION_COMMAND_STACK_CAN_UNDO_PROPERTY,
	APPLICATION_COMMAND_STACK_CAN_REDO_PROPERTY,
	APPLICATION_COMMAND_STACK_NUM_PROPERTIES
};
static GParamSpec* application_command_stack_properties[APPLICATION_COMMAND_STACK_NUM_PROPERTIES];
typedef struct _ApplicationCommandStackExecuteData ApplicationCommandStackExecuteData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ApplicationCommandStackUndoData ApplicationCommandStackUndoData;
typedef struct _ApplicationCommandStackRedoData ApplicationCommandStackRedoData;
enum  {
	APPLICATION_COMMAND_STACK_EXECUTED_SIGNAL,
	APPLICATION_COMMAND_STACK_UNDONE_SIGNAL,
	APPLICATION_COMMAND_STACK_REDONE_SIGNAL,
	APPLICATION_COMMAND_STACK_NUM_SIGNALS
};
static guint application_command_stack_signals[APPLICATION_COMMAND_STACK_NUM_SIGNALS] = {0};

struct _ApplicationCommandPrivate {
	gchar* _undo_label;
	gchar* _redo_label;
	gchar* _executed_label;
	gboolean _executed_notification_brief;
	gchar* _undone_label;
};

struct _ApplicationCommandRedoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationCommand* self;
	GCancellable* cancellable;
	GError* _inner_error0_;
};

struct _ApplicationCommandSequencePrivate {
	GeeList* commands;
};

struct _ApplicationCommandSequenceExecuteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationCommandSequence* self;
	GCancellable* cancellable;
	GeeList* _command_list;
	GeeList* _tmp0_;
	gint _command_size;
	GeeList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _command_index;
	gint _tmp4_;
	gint _tmp5_;
	ApplicationCommand* command;
	GeeList* _tmp6_;
	gpointer _tmp7_;
	ApplicationCommand* _tmp8_;
	GError* _inner_error0_;
};

struct _ApplicationCommandSequenceUndoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationCommandSequence* self;
	GCancellable* cancellable;
	GeeList* _command_list;
	GeeList* _tmp0_;
	gint _command_size;
	GeeList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _command_index;
	gint _tmp4_;
	gint _tmp5_;
	ApplicationCommand* command;
	GeeList* _tmp6_;
	gpointer _tmp7_;
	ApplicationCommand* _tmp8_;
	GError* _inner_error0_;
};

struct _ApplicationCommandSequenceRedoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationCommandSequence* self;
	GCancellable* cancellable;
	GeeList* _command_list;
	GeeList* _tmp0_;
	gint _command_size;
	GeeList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _command_index;
	gint _tmp4_;
	gint _tmp5_;
	ApplicationCommand* command;
	GeeList* _tmp6_;
	gpointer _tmp7_;
	ApplicationCommand* _tmp8_;
	GError* _inner_error0_;
};

struct _ApplicationPropertyCommandPrivate {
	GType t_type;
	GBoxedCopyFunc t_dup_func;
	GDestroyNotify t_destroy_func;
	GObject* object;
	gchar* property_name;
	gpointer new_value;
	gpointer old_value;
};

struct _ApplicationPropertyCommandExecuteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationPropertyCommand* self;
	GCancellable* cancellable;
	GObject* _tmp0_;
	const gchar* _tmp1_;
	gconstpointer _tmp2_;
};

struct _ApplicationPropertyCommandUndoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationPropertyCommand* self;
	GCancellable* cancellable;
	GObject* _tmp0_;
	const gchar* _tmp1_;
	gconstpointer _tmp2_;
};

struct _ApplicationCommandStackPrivate {
	gboolean _can_undo;
	gboolean _can_redo;
};

struct _ApplicationCommandStackExecuteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationCommandStack* self;
	ApplicationCommand* target;
	GCancellable* cancellable;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GeeDeque* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GeeDeque* _tmp5_;
	GError* _inner_error0_;
};

struct _ApplicationCommandStackUndoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationCommandStack* self;
	GCancellable* cancellable;
	GeeDeque* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ApplicationCommand* target;
	GeeDeque* _tmp3_;
	gpointer _tmp4_;
	GeeDeque* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	ApplicationCommand* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ApplicationCommand* _tmp11_;
	GError* err;
	GeeDeque* _tmp12_;
	GError* _tmp13_;
	GError* _tmp14_;
	ApplicationCommand* _tmp15_;
	GeeDeque* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	ApplicationCommand* _tmp19_;
	ApplicationCommand* _tmp20_;
	GError* _inner_error0_;
};

struct _ApplicationCommandStackRedoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationCommandStack* self;
	GCancellable* cancellable;
	GeeDeque* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ApplicationCommand* target;
	GeeDeque* _tmp3_;
	gpointer _tmp4_;
	GeeDeque* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	ApplicationCommand* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ApplicationCommand* _tmp11_;
	GError* err;
	GeeDeque* _tmp12_;
	GError* _tmp13_;
	GError* _tmp14_;
	ApplicationCommand* _tmp15_;
	GeeDeque* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	ApplicationCommand* _tmp19_;
	ApplicationCommand* _tmp20_;
	GError* _inner_error0_;
};

static gint ApplicationCommand_private_offset;
static gpointer application_command_parent_class = NULL;
static gint ApplicationCommandSequence_private_offset;
static gpointer application_command_sequence_parent_class = NULL;
static gint ApplicationPropertyCommand_private_offset;
static gpointer application_property_command_parent_class = NULL;
static gint ApplicationCommandStack_private_offset;
static gpointer application_command_stack_parent_class = NULL;

static void application_command_real_executed (ApplicationCommand* self);
static void application_command_real_undone (ApplicationCommand* self);
static void application_command_real_redone (ApplicationCommand* self);
static void application_command_real_redo_data_free (gpointer _data);
static void application_command_real_redo (ApplicationCommand* self,
                                    GCancellable* cancellable,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
static gboolean application_command_real_redo_co (ApplicationCommandRedoData* _data_);
static void application_command_redo_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_);
static gboolean application_command_real_equal_to (ApplicationCommand* self,
                                            ApplicationCommand* other);
static gchar* application_command_real_to_string (ApplicationCommand* self);
static void application_command_finalize (GObject * obj);
static GType application_command_get_type_once (void);
static void _vala_application_command_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_application_command_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void application_command_sequence_real_executed (ApplicationCommand* base);
static void application_command_sequence_real_undone (ApplicationCommand* base);
static GeeList* application_command_sequence_reversed_commands (ApplicationCommandSequence* self);
static void application_command_sequence_real_redone (ApplicationCommand* base);
static void application_command_sequence_real_execute_data_free (gpointer _data);
static void application_command_sequence_real_execute (ApplicationCommand* base,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static gboolean application_command_sequence_real_execute_co (ApplicationCommandSequenceExecuteData* _data_);
static void application_command_sequence_execute_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static void application_command_sequence_real_undo_data_free (gpointer _data);
static void application_command_sequence_real_undo (ApplicationCommand* base,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static gboolean application_command_sequence_real_undo_co (ApplicationCommandSequenceUndoData* _data_);
static void application_command_sequence_undo_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void application_command_sequence_real_redo_data_free (gpointer _data);
static void application_command_sequence_real_redo (ApplicationCommand* base,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static gboolean application_command_sequence_real_redo_co (ApplicationCommandSequenceRedoData* _data_);
static void application_command_sequence_redo_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void application_command_sequence_finalize (GObject * obj);
static GType application_command_sequence_get_type_once (void);
static void application_property_command_real_execute_data_free (gpointer _data);
static void application_property_command_real_execute (ApplicationCommand* base,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static gboolean application_property_command_real_execute_co (ApplicationPropertyCommandExecuteData* _data_);
static void application_property_command_real_undo_data_free (gpointer _data);
static void application_property_command_real_undo (ApplicationCommand* base,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static gboolean application_property_command_real_undo_co (ApplicationPropertyCommandUndoData* _data_);
static gchar* application_property_command_real_to_string (ApplicationCommand* base);
static void application_property_command_finalize (GObject * obj);
static GType application_property_command_get_type_once (void);
static void _vala_application_property_command_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_application_property_command_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
static void application_command_stack_set_can_undo (ApplicationCommandStack* self,
                                             gboolean value);
static void application_command_stack_set_can_redo (ApplicationCommandStack* self,
                                             gboolean value);
static void application_command_stack_real_execute_data_free (gpointer _data);
static void application_command_stack_real_execute (ApplicationCommandStack* self,
                                             ApplicationCommand* target,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static gboolean application_command_stack_real_execute_co (ApplicationCommandStackExecuteData* _data_);
static void application_command_stack_execute_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void application_command_stack_real_undo_data_free (gpointer _data);
static void application_command_stack_real_undo (ApplicationCommandStack* self,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static gboolean application_command_stack_real_undo_co (ApplicationCommandStackUndoData* _data_);
static void application_command_stack_undo_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static void application_command_stack_real_redo_data_free (gpointer _data);
static void application_command_stack_real_redo (ApplicationCommandStack* self,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static gboolean application_command_stack_real_redo_co (ApplicationCommandStackRedoData* _data_);
static void application_command_stack_redo_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static void application_command_stack_real_update_undo_stack (ApplicationCommandStack* self,
                                                       ApplicationCommand* target);
static void application_command_stack_real_update_redo_stack (ApplicationCommandStack* self,
                                                       ApplicationCommand* target);
static void application_command_stack_finalize (GObject * obj);
static GType application_command_stack_get_type_once (void);
static void _vala_application_command_stack_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_application_command_stack_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);

static inline gpointer
application_command_get_instance_private (ApplicationCommand* self)
{
	return G_STRUCT_MEMBER_P (self, ApplicationCommand_private_offset);
}

gboolean
application_command_get_can_undo (ApplicationCommand* self)
{
	ApplicationCommandClass* _klass_;
	g_return_val_if_fail (APPLICATION_IS_COMMAND (self), FALSE);
	_klass_ = APPLICATION_COMMAND_GET_CLASS (self);
	if (_klass_->get_can_undo) {
		return _klass_->get_can_undo (self);
	}
	return FALSE;
}

static gboolean
application_command_real_get_can_undo (ApplicationCommand* base)
{
	gboolean result;
	ApplicationCommand* self;
	self = base;
	result = TRUE;
	return result;
}

gboolean
application_command_get_can_redo (ApplicationCommand* self)
{
	ApplicationCommandClass* _klass_;
	g_return_val_if_fail (APPLICATION_IS_COMMAND (self), FALSE);
	_klass_ = APPLICATION_COMMAND_GET_CLASS (self);
	if (_klass_->get_can_redo) {
		return _klass_->get_can_redo (self);
	}
	return FALSE;
}

static gboolean
application_command_real_get_can_redo (ApplicationCommand* base)
{
	gboolean result;
	ApplicationCommand* self;
	self = base;
	result = TRUE;
	return result;
}

const gchar*
application_command_get_undo_label (ApplicationCommand* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_COMMAND (self), NULL);
	_tmp0_ = self->priv->_undo_label;
	result = _tmp0_;
	return result;
}

void
application_command_set_undo_label (ApplicationCommand* self,
                                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (APPLICATION_IS_COMMAND (self));
	old_value = application_command_get_undo_label (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_undo_label);
		self->priv->_undo_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_command_properties[APPLICATION_COMMAND_UNDO_LABEL_PROPERTY]);
	}
}

const gchar*
application_command_get_redo_label (ApplicationCommand* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_COMMAND (self), NULL);
	_tmp0_ = self->priv->_redo_label;
	result = _tmp0_;
	return result;
}

void
application_command_set_redo_label (ApplicationCommand* self,
                                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (APPLICATION_IS_COMMAND (self));
	old_value = application_command_get_redo_label (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_redo_label);
		self->priv->_redo_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_command_properties[APPLICATION_COMMAND_REDO_LABEL_PROPERTY]);
	}
}

const gchar*
application_command_get_executed_label (ApplicationCommand* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_COMMAND (self), NULL);
	_tmp0_ = self->priv->_executed_label;
	result = _tmp0_;
	return result;
}

void
application_command_set_executed_label (ApplicationCommand* self,
                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (APPLICATION_IS_COMMAND (self));
	old_value = application_command_get_executed_label (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_executed_label);
		self->priv->_executed_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_command_properties[APPLICATION_COMMAND_EXECUTED_LABEL_PROPERTY]);
	}
}

gboolean
application_command_get_executed_notification_brief (ApplicationCommand* self)
{
	gboolean result;
	g_return_val_if_fail (APPLICATION_IS_COMMAND (self), FALSE);
	result = self->priv->_executed_notification_brief;
	return result;
}

void
application_command_set_executed_notification_brief (ApplicationCommand* self,
                                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (APPLICATION_IS_COMMAND (self));
	old_value = application_command_get_executed_notification_brief (self);
	if (old_value != value) {
		self->priv->_executed_notification_brief = value;
		g_object_notify_by_pspec ((GObject *) self, application_command_properties[APPLICATION_COMMAND_EXECUTED_NOTIFICATION_BRIEF_PROPERTY]);
	}
}

const gchar*
application_command_get_undone_label (ApplicationCommand* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_COMMAND (self), NULL);
	_tmp0_ = self->priv->_undone_label;
	result = _tmp0_;
	return result;
}

void
application_command_set_undone_label (ApplicationCommand* self,
                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (APPLICATION_IS_COMMAND (self));
	old_value = application_command_get_undone_label (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_undone_label);
		self->priv->_undone_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_command_properties[APPLICATION_COMMAND_UNDONE_LABEL_PROPERTY]);
	}
}

static void
application_command_real_executed (ApplicationCommand* self)
{
}

static void
application_command_real_undone (ApplicationCommand* self)
{
}

static void
application_command_real_redone (ApplicationCommand* self)
{
}

void
application_command_execute (ApplicationCommand* self,
                             GCancellable* cancellable,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	ApplicationCommandClass* _klass_;
	_klass_ = APPLICATION_COMMAND_GET_CLASS (self);
	if (_klass_->execute) {
		_klass_->execute (self, cancellable, _callback_, _user_data_);
	}
}

void
application_command_execute_finish (ApplicationCommand* self,
                                    GAsyncResult* _res_,
                                    GError** error)
{
	ApplicationCommandClass* _klass_;
	_klass_ = APPLICATION_COMMAND_GET_CLASS (self);
	if (_klass_->execute_finish) {
		_klass_->execute_finish (self, _res_, error);
	}
}

void
application_command_undo (ApplicationCommand* self,
                          GCancellable* cancellable,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	ApplicationCommandClass* _klass_;
	_klass_ = APPLICATION_COMMAND_GET_CLASS (self);
	if (_klass_->undo) {
		_klass_->undo (self, cancellable, _callback_, _user_data_);
	}
}

void
application_command_undo_finish (ApplicationCommand* self,
                                 GAsyncResult* _res_,
                                 GError** error)
{
	ApplicationCommandClass* _klass_;
	_klass_ = APPLICATION_COMMAND_GET_CLASS (self);
	if (_klass_->undo_finish) {
		_klass_->undo_finish (self, _res_, error);
	}
}

static void
application_command_real_redo_data_free (gpointer _data)
{
	ApplicationCommandRedoData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationCommandRedoData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
application_command_real_redo (ApplicationCommand* self,
                               GCancellable* cancellable,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	ApplicationCommandRedoData* _data_;
	ApplicationCommand* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ApplicationCommandRedoData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_command_real_redo_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	application_command_real_redo_co (_data_);
}

static void
application_command_real_redo_finish (ApplicationCommand* self,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	ApplicationCommandRedoData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Called by {@link CommandStack} to redo the executed command.
     *
     * Applications should not call this method directly, rather they
     * should call {@link CommandStack.redo} so that it is managed
     * correctly.
     *
     * Command implementations should re-apply a user command that has
     * been un-done by a call to {@link undo}. By default, this method
     * simply calls {@link execute}, but implementations with more
     * complex requirements can override this. It will called zero or
     * more times, but only ever after a call to {@link undo} when
     * used sole with the command stack.
     */
static void
application_command_redo_ready (GObject* source_object,
                                GAsyncResult* _res_,
                                gpointer _user_data_)
{
	ApplicationCommandRedoData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_command_real_redo_co (_data_);
}

static gboolean
application_command_real_redo_co (ApplicationCommandRedoData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	application_command_execute (_data_->self, _data_->cancellable, application_command_redo_ready, _data_);
	return FALSE;
	_state_1:
	application_command_execute_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
application_command_redo (ApplicationCommand* self,
                          GCancellable* cancellable,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	ApplicationCommandClass* _klass_;
	_klass_ = APPLICATION_COMMAND_GET_CLASS (self);
	if (_klass_->redo) {
		_klass_->redo (self, cancellable, _callback_, _user_data_);
	}
}

void
application_command_redo_finish (ApplicationCommand* self,
                                 GAsyncResult* _res_,
                                 GError** error)
{
	ApplicationCommandClass* _klass_;
	_klass_ = APPLICATION_COMMAND_GET_CLASS (self);
	if (_klass_->redo_finish) {
		_klass_->redo_finish (self, _res_, error);
	}
}

/** Determines if this command is equal to another. */
static gboolean
application_command_real_equal_to (ApplicationCommand* self,
                                   ApplicationCommand* other)
{
	gboolean result;
	g_return_val_if_fail (APPLICATION_IS_COMMAND (other), FALSE);
	result = self == other;
	return result;
}

gboolean
application_command_equal_to (ApplicationCommand* self,
                              ApplicationCommand* other)
{
	ApplicationCommandClass* _klass_;
	g_return_val_if_fail (APPLICATION_IS_COMMAND (self), FALSE);
	_klass_ = APPLICATION_COMMAND_GET_CLASS (self);
	if (_klass_->equal_to) {
		return _klass_->equal_to (self, other);
	}
	return FALSE;
}

/** Returns a string representation of the command for debugging. */
static gchar*
application_command_real_to_string (ApplicationCommand* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = g_type_name (G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject)));
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
application_command_to_string (ApplicationCommand* self)
{
	ApplicationCommandClass* _klass_;
	g_return_val_if_fail (APPLICATION_IS_COMMAND (self), NULL);
	_klass_ = APPLICATION_COMMAND_GET_CLASS (self);
	if (_klass_->to_string) {
		return _klass_->to_string (self);
	}
	return NULL;
}

ApplicationCommand*
application_command_construct (GType object_type)
{
	ApplicationCommand * self = NULL;
	self = (ApplicationCommand*) g_object_new (object_type, NULL);
	return self;
}

static void
application_command_class_init (ApplicationCommandClass * klass,
                                gpointer klass_data)
{
	application_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ApplicationCommand_private_offset);
	((ApplicationCommandClass *) klass)->redo = (void (*) (ApplicationCommand*, GCancellable*, GAsyncReadyCallback, gpointer)) application_command_real_redo;
	((ApplicationCommandClass *) klass)->redo_finish = (void (*) (ApplicationCommand*, GAsyncResult*, GError**)) application_command_real_redo_finish;
	((ApplicationCommandClass *) klass)->equal_to = (gboolean (*) (ApplicationCommand*, ApplicationCommand*)) application_command_real_equal_to;
	((ApplicationCommandClass *) klass)->to_string = (gchar* (*) (ApplicationCommand*)) application_command_real_to_string;
	((ApplicationCommandClass *) klass)->executed = application_command_real_executed;
	((ApplicationCommandClass *) klass)->undone = application_command_real_undone;
	((ApplicationCommandClass *) klass)->redone = application_command_real_redone;
	APPLICATION_COMMAND_CLASS (klass)->get_can_undo = (gboolean (*) (ApplicationCommand*)) application_command_real_get_can_undo;
	APPLICATION_COMMAND_CLASS (klass)->get_can_redo = (gboolean (*) (ApplicationCommand*)) application_command_real_get_can_redo;
	G_OBJECT_CLASS (klass)->get_property = _vala_application_command_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_application_command_set_property;
	G_OBJECT_CLASS (klass)->finalize = application_command_finalize;
	/**
	     * Determines if a command can be undone.
	     *
	     * When passed to {@link CommandStack}, the stack will check this
	     * property after the command has been executed, and if false the
	     * non-undo-able command will not be put on the undo stack.
	     *
	     * Returns true by default, derived classes may override if their
	     * {@link undo} method should not be called.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_COMMAND_CAN_UNDO_PROPERTY, application_command_properties[APPLICATION_COMMAND_CAN_UNDO_PROPERTY] = g_param_spec_boolean ("can-undo", "can-undo", "can-undo", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Determines if a command can be redone.
	     *
	     * After this command has been undone by the stack, it will check
	     * this property and if false the non-redo-able command will not
	     * be put on the redo stack.
	     *
	     * Returns true by default, derived classes may override if their
	     * {@link undo} method should not be called.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_COMMAND_CAN_REDO_PROPERTY, application_command_properties[APPLICATION_COMMAND_CAN_REDO_PROPERTY] = g_param_spec_boolean ("can-redo", "can-redo", "can-redo", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * A human-readable label describing the effect of calling {@link undo}.
	     *
	     * This can be used in a user interface, perhaps as a tooltip for
	     * an Undo button, to indicate what will happen if the command is
	     * un-done. For example, "Conversation restored from Trash".
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_COMMAND_UNDO_LABEL_PROPERTY, application_command_properties[APPLICATION_COMMAND_UNDO_LABEL_PROPERTY] = g_param_spec_string ("undo-label", "undo-label", "undo-label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * A human-readable label describing the effect of calling {@link redo}.
	     *
	     * This can be used in a user interface, perhaps as a tooltip for
	     * a Redo button, to indicate what will happen if the command is
	     * re-done. For example, "Conversation restored from Trash".
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_COMMAND_REDO_LABEL_PROPERTY, application_command_properties[APPLICATION_COMMAND_REDO_LABEL_PROPERTY] = g_param_spec_string ("redo-label", "redo-label", "redo-label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * A human-readable label describing the result of calling {@link execute}.
	     *
	     * This can be used in a user interface to indicate the effects of
	     * the action just executed. For example, "Conversation moved to
	     * Trash".
	     *
	     * Since the effects of re-doing a command should be identical to
	     * that of executing it, this string can also be used to describe
	     * the effects of {@link redo}.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_COMMAND_EXECUTED_LABEL_PROPERTY, application_command_properties[APPLICATION_COMMAND_EXECUTED_LABEL_PROPERTY] = g_param_spec_string ("executed-label", "executed-label", "executed-label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * True if executed_label should be displayed only briefly to the user.
	     * Set this to true for very frequent notifications.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_COMMAND_EXECUTED_NOTIFICATION_BRIEF_PROPERTY, application_command_properties[APPLICATION_COMMAND_EXECUTED_NOTIFICATION_BRIEF_PROPERTY] = g_param_spec_boolean ("executed-notification-brief", "executed-notification-brief", "executed-notification-brief", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * A human-readable label describing the result of calling {@link undo}.
	     *
	     * This can be used in a user interface to indicate the effects of
	     * the action just executed. For example, "Conversation restored
	     * from Trash".
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_COMMAND_UNDONE_LABEL_PROPERTY, application_command_properties[APPLICATION_COMMAND_UNDONE_LABEL_PROPERTY] = g_param_spec_string ("undone-label", "undone-label", "undone-label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Emitted when the command was successfully executed.
	     *
	     * Command implementations must not manage this signal, it will be
	     * emitted by {@link CommandStack} as needed.
	     */
	application_command_signals[APPLICATION_COMMAND_EXECUTED_SIGNAL] = g_signal_new ("executed", APPLICATION_TYPE_COMMAND, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ApplicationCommandClass, executed), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	     * Emitted when the command was successfully undone.
	     *
	     * Command implementations must not manage this signal, it will be
	     * emitted by {@link CommandStack} as needed.
	     */
	application_command_signals[APPLICATION_COMMAND_UNDONE_SIGNAL] = g_signal_new ("undone", APPLICATION_TYPE_COMMAND, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ApplicationCommandClass, undone), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	     * Emitted when the command was successfully redone.
	     *
	     * Command implementations must not manage this signal, it will be
	     * emitted by {@link CommandStack} as needed.
	     */
	application_command_signals[APPLICATION_COMMAND_REDONE_SIGNAL] = g_signal_new ("redone", APPLICATION_TYPE_COMMAND, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ApplicationCommandClass, redone), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
application_command_instance_init (ApplicationCommand * self,
                                   gpointer klass)
{
	self->priv = application_command_get_instance_private (self);
	self->priv->_undo_label = NULL;
	self->priv->_redo_label = NULL;
	self->priv->_executed_label = NULL;
	self->priv->_executed_notification_brief = FALSE;
	self->priv->_undone_label = NULL;
}

static void
application_command_finalize (GObject * obj)
{
	ApplicationCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, APPLICATION_TYPE_COMMAND, ApplicationCommand);
	_g_free0 (self->priv->_undo_label);
	_g_free0 (self->priv->_redo_label);
	_g_free0 (self->priv->_executed_label);
	_g_free0 (self->priv->_undone_label);
	G_OBJECT_CLASS (application_command_parent_class)->finalize (obj);
}

/**
 * A generic application user command with undo and redo support.
 */
static GType
application_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ApplicationCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ApplicationCommand), 0, (GInstanceInitFunc) application_command_instance_init, NULL };
	GType application_command_type_id;
	application_command_type_id = g_type_register_static (G_TYPE_OBJECT, "ApplicationCommand", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	ApplicationCommand_private_offset = g_type_add_instance_private (application_command_type_id, sizeof (ApplicationCommandPrivate));
	return application_command_type_id;
}

GType
application_command_get_type (void)
{
	static volatile gsize application_command_type_id__once = 0;
	if (g_once_init_enter (&application_command_type_id__once)) {
		GType application_command_type_id;
		application_command_type_id = application_command_get_type_once ();
		g_once_init_leave (&application_command_type_id__once, application_command_type_id);
	}
	return application_command_type_id__once;
}

static void
_vala_application_command_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	ApplicationCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, APPLICATION_TYPE_COMMAND, ApplicationCommand);
	switch (property_id) {
		case APPLICATION_COMMAND_CAN_UNDO_PROPERTY:
		g_value_set_boolean (value, application_command_get_can_undo (self));
		break;
		case APPLICATION_COMMAND_CAN_REDO_PROPERTY:
		g_value_set_boolean (value, application_command_get_can_redo (self));
		break;
		case APPLICATION_COMMAND_UNDO_LABEL_PROPERTY:
		g_value_set_string (value, application_command_get_undo_label (self));
		break;
		case APPLICATION_COMMAND_REDO_LABEL_PROPERTY:
		g_value_set_string (value, application_command_get_redo_label (self));
		break;
		case APPLICATION_COMMAND_EXECUTED_LABEL_PROPERTY:
		g_value_set_string (value, application_command_get_executed_label (self));
		break;
		case APPLICATION_COMMAND_EXECUTED_NOTIFICATION_BRIEF_PROPERTY:
		g_value_set_boolean (value, application_command_get_executed_notification_brief (self));
		break;
		case APPLICATION_COMMAND_UNDONE_LABEL_PROPERTY:
		g_value_set_string (value, application_command_get_undone_label (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_application_command_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	ApplicationCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, APPLICATION_TYPE_COMMAND, ApplicationCommand);
	switch (property_id) {
		case APPLICATION_COMMAND_UNDO_LABEL_PROPERTY:
		application_command_set_undo_label (self, g_value_get_string (value));
		break;
		case APPLICATION_COMMAND_REDO_LABEL_PROPERTY:
		application_command_set_redo_label (self, g_value_get_string (value));
		break;
		case APPLICATION_COMMAND_EXECUTED_LABEL_PROPERTY:
		application_command_set_executed_label (self, g_value_get_string (value));
		break;
		case APPLICATION_COMMAND_EXECUTED_NOTIFICATION_BRIEF_PROPERTY:
		application_command_set_executed_notification_brief (self, g_value_get_boolean (value));
		break;
		case APPLICATION_COMMAND_UNDONE_LABEL_PROPERTY:
		application_command_set_undone_label (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
application_command_sequence_get_instance_private (ApplicationCommandSequence* self)
{
	return G_STRUCT_MEMBER_P (self, ApplicationCommandSequence_private_offset);
}

/**
     * Emitted when the command was successfully executed.
     *
     * Ensures the same signal is emitted on all commands in the
     * sequence, in order.
     */
static void
application_command_sequence_real_executed (ApplicationCommand* base)
{
	ApplicationCommandSequence * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_COMMAND_SEQUENCE, ApplicationCommandSequence);
	{
		GeeList* _command_list = NULL;
		GeeList* _tmp0_;
		gint _command_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _command_index = 0;
		_tmp0_ = self->priv->commands;
		_command_list = _tmp0_;
		_tmp1_ = _command_list;
		_tmp2_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp3_ = _tmp2_;
		_command_size = _tmp3_;
		_command_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ApplicationCommand* command = NULL;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			ApplicationCommand* _tmp8_;
			_command_index = _command_index + 1;
			_tmp4_ = _command_index;
			_tmp5_ = _command_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _command_list;
			_tmp7_ = gee_list_get (_tmp6_, _command_index);
			command = (ApplicationCommand*) _tmp7_;
			_tmp8_ = command;
			g_signal_emit (_tmp8_, application_command_signals[APPLICATION_COMMAND_EXECUTED_SIGNAL], 0);
			_g_object_unref0 (command);
		}
	}
}

/**
     * Emitted when the command was successfully undone.
     *
     * Ensures the same signal is emitted on all commands in the
     * sequence, in reverse order.
     */
static void
application_command_sequence_real_undone (ApplicationCommand* base)
{
	ApplicationCommandSequence * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_COMMAND_SEQUENCE, ApplicationCommandSequence);
	{
		GeeList* _command_list = NULL;
		GeeList* _tmp0_;
		gint _command_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _command_index = 0;
		_tmp0_ = application_command_sequence_reversed_commands (self);
		_command_list = _tmp0_;
		_tmp1_ = _command_list;
		_tmp2_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp3_ = _tmp2_;
		_command_size = _tmp3_;
		_command_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ApplicationCommand* command = NULL;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			ApplicationCommand* _tmp8_;
			_command_index = _command_index + 1;
			_tmp4_ = _command_index;
			_tmp5_ = _command_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _command_list;
			_tmp7_ = gee_list_get (_tmp6_, _command_index);
			command = (ApplicationCommand*) _tmp7_;
			_tmp8_ = command;
			g_signal_emit (_tmp8_, application_command_signals[APPLICATION_COMMAND_UNDONE_SIGNAL], 0);
			_g_object_unref0 (command);
		}
		_g_object_unref0 (_command_list);
	}
}

/**
     * Emitted when the command was successfully redone.
     *
     * Ensures the same signal is emitted on all commands in the
     * sequence, in order.
     */
static void
application_command_sequence_real_redone (ApplicationCommand* base)
{
	ApplicationCommandSequence * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_COMMAND_SEQUENCE, ApplicationCommandSequence);
	{
		GeeList* _command_list = NULL;
		GeeList* _tmp0_;
		gint _command_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _command_index = 0;
		_tmp0_ = self->priv->commands;
		_command_list = _tmp0_;
		_tmp1_ = _command_list;
		_tmp2_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp3_ = _tmp2_;
		_command_size = _tmp3_;
		_command_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ApplicationCommand* command = NULL;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			ApplicationCommand* _tmp8_;
			_command_index = _command_index + 1;
			_tmp4_ = _command_index;
			_tmp5_ = _command_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _command_list;
			_tmp7_ = gee_list_get (_tmp6_, _command_index);
			command = (ApplicationCommand*) _tmp7_;
			_tmp8_ = command;
			g_signal_emit (_tmp8_, application_command_signals[APPLICATION_COMMAND_REDONE_SIGNAL], 0);
			_g_object_unref0 (command);
		}
	}
}

ApplicationCommandSequence*
application_command_sequence_construct (GType object_type,
                                        ApplicationCommand** commands,
                                        gint commands_length1)
{
	ApplicationCommandSequence * self = NULL;
	self = (ApplicationCommandSequence*) application_command_construct (object_type);
	if (commands != NULL) {
		GeeList* _tmp0_;
		_tmp0_ = self->priv->commands;
		gee_collection_add_all_array (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), commands, (gint) commands_length1);
	}
	return self;
}

ApplicationCommandSequence*
application_command_sequence_new (ApplicationCommand** commands,
                                  gint commands_length1)
{
	return application_command_sequence_construct (APPLICATION_TYPE_COMMAND_SEQUENCE, commands, commands_length1);
}

static void
application_command_sequence_real_execute_data_free (gpointer _data)
{
	ApplicationCommandSequenceExecuteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationCommandSequenceExecuteData, _data_);
}

static void
application_command_sequence_real_execute (ApplicationCommand* base,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	ApplicationCommandSequence * self;
	ApplicationCommandSequenceExecuteData* _data_;
	ApplicationCommandSequence* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_COMMAND_SEQUENCE, ApplicationCommandSequence);
	_data_ = g_slice_new0 (ApplicationCommandSequenceExecuteData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_command_sequence_real_execute_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	application_command_sequence_real_execute_co (_data_);
}

static void
application_command_sequence_execute_finish (ApplicationCommand* base,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	ApplicationCommandSequenceExecuteData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Executes all commands in the sequence, sequentially.
     */
static void
application_command_sequence_execute_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	ApplicationCommandSequenceExecuteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_command_sequence_real_execute_co (_data_);
}

static gboolean
application_command_sequence_real_execute_co (ApplicationCommandSequenceExecuteData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->commands;
		_data_->_command_list = _data_->_tmp0_;
		_data_->_tmp1_ = _data_->_command_list;
		_data_->_tmp2_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_command_size = _data_->_tmp3_;
		_data_->_command_index = -1;
		while (TRUE) {
			_data_->_command_index = _data_->_command_index + 1;
			_data_->_tmp4_ = _data_->_command_index;
			_data_->_tmp5_ = _data_->_command_size;
			if (!(_data_->_tmp4_ < _data_->_tmp5_)) {
				break;
			}
			_data_->_tmp6_ = _data_->_command_list;
			_data_->_tmp7_ = gee_list_get (_data_->_tmp6_, _data_->_command_index);
			_data_->command = (ApplicationCommand*) _data_->_tmp7_;
			_data_->_tmp8_ = _data_->command;
			_data_->_state_ = 1;
			application_command_execute (_data_->_tmp8_, _data_->cancellable, application_command_sequence_execute_ready, _data_);
			return FALSE;
			_state_1:
			application_command_execute_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->command);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_object_unref0 (_data_->command);
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_command_sequence_real_undo_data_free (gpointer _data)
{
	ApplicationCommandSequenceUndoData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationCommandSequenceUndoData, _data_);
}

static void
application_command_sequence_real_undo (ApplicationCommand* base,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	ApplicationCommandSequence * self;
	ApplicationCommandSequenceUndoData* _data_;
	ApplicationCommandSequence* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_COMMAND_SEQUENCE, ApplicationCommandSequence);
	_data_ = g_slice_new0 (ApplicationCommandSequenceUndoData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_command_sequence_real_undo_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	application_command_sequence_real_undo_co (_data_);
}

static void
application_command_sequence_undo_finish (ApplicationCommand* base,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	ApplicationCommandSequenceUndoData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Un-does all commands in the sequence, in reverse order.
     */
static void
application_command_sequence_undo_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	ApplicationCommandSequenceUndoData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_command_sequence_real_undo_co (_data_);
}

static gboolean
application_command_sequence_real_undo_co (ApplicationCommandSequenceUndoData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = application_command_sequence_reversed_commands (_data_->self);
		_data_->_command_list = _data_->_tmp0_;
		_data_->_tmp1_ = _data_->_command_list;
		_data_->_tmp2_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_command_size = _data_->_tmp3_;
		_data_->_command_index = -1;
		while (TRUE) {
			_data_->_command_index = _data_->_command_index + 1;
			_data_->_tmp4_ = _data_->_command_index;
			_data_->_tmp5_ = _data_->_command_size;
			if (!(_data_->_tmp4_ < _data_->_tmp5_)) {
				break;
			}
			_data_->_tmp6_ = _data_->_command_list;
			_data_->_tmp7_ = gee_list_get (_data_->_tmp6_, _data_->_command_index);
			_data_->command = (ApplicationCommand*) _data_->_tmp7_;
			_data_->_tmp8_ = _data_->command;
			_data_->_state_ = 1;
			application_command_undo (_data_->_tmp8_, _data_->cancellable, application_command_sequence_undo_ready, _data_);
			return FALSE;
			_state_1:
			application_command_undo_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->command);
				_g_object_unref0 (_data_->_command_list);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_object_unref0 (_data_->command);
		}
		_g_object_unref0 (_data_->_command_list);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_command_sequence_real_redo_data_free (gpointer _data)
{
	ApplicationCommandSequenceRedoData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationCommandSequenceRedoData, _data_);
}

static void
application_command_sequence_real_redo (ApplicationCommand* base,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	ApplicationCommandSequence * self;
	ApplicationCommandSequenceRedoData* _data_;
	ApplicationCommandSequence* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_COMMAND_SEQUENCE, ApplicationCommandSequence);
	_data_ = g_slice_new0 (ApplicationCommandSequenceRedoData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_command_sequence_real_redo_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	application_command_sequence_real_redo_co (_data_);
}

static void
application_command_sequence_redo_finish (ApplicationCommand* base,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	ApplicationCommandSequenceRedoData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Re-does all commands in the sequence, sequentially.
     */
static void
application_command_sequence_redo_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	ApplicationCommandSequenceRedoData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_command_sequence_real_redo_co (_data_);
}

static gboolean
application_command_sequence_real_redo_co (ApplicationCommandSequenceRedoData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->commands;
		_data_->_command_list = _data_->_tmp0_;
		_data_->_tmp1_ = _data_->_command_list;
		_data_->_tmp2_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_command_size = _data_->_tmp3_;
		_data_->_command_index = -1;
		while (TRUE) {
			_data_->_command_index = _data_->_command_index + 1;
			_data_->_tmp4_ = _data_->_command_index;
			_data_->_tmp5_ = _data_->_command_size;
			if (!(_data_->_tmp4_ < _data_->_tmp5_)) {
				break;
			}
			_data_->_tmp6_ = _data_->_command_list;
			_data_->_tmp7_ = gee_list_get (_data_->_tmp6_, _data_->_command_index);
			_data_->command = (ApplicationCommand*) _data_->_tmp7_;
			_data_->_tmp8_ = _data_->command;
			_data_->_state_ = 1;
			application_command_redo (_data_->_tmp8_, _data_->cancellable, application_command_sequence_redo_ready, _data_);
			return FALSE;
			_state_1:
			application_command_redo_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->command);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_object_unref0 (_data_->command);
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static GeeList*
application_command_sequence_reversed_commands (ApplicationCommandSequence* self)
{
	GeeLinkedList* reversed = NULL;
	GeeLinkedList* _tmp0_;
	GeeList* result;
	g_return_val_if_fail (APPLICATION_IS_COMMAND_SEQUENCE (self), NULL);
	_tmp0_ = gee_linked_list_new (APPLICATION_TYPE_COMMAND, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	reversed = _tmp0_;
	{
		GeeList* _command_list = NULL;
		GeeList* _tmp1_;
		gint _command_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _command_index = 0;
		_tmp1_ = self->priv->commands;
		_command_list = _tmp1_;
		_tmp2_ = _command_list;
		_tmp3_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp4_ = _tmp3_;
		_command_size = _tmp4_;
		_command_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ApplicationCommand* command = NULL;
			GeeList* _tmp7_;
			gpointer _tmp8_;
			GeeLinkedList* _tmp9_;
			ApplicationCommand* _tmp10_;
			_command_index = _command_index + 1;
			_tmp5_ = _command_index;
			_tmp6_ = _command_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _command_list;
			_tmp8_ = gee_list_get (_tmp7_, _command_index);
			command = (ApplicationCommand*) _tmp8_;
			_tmp9_ = reversed;
			_tmp10_ = command;
			gee_abstract_list_insert (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0, _tmp10_);
			_g_object_unref0 (command);
		}
	}
	result = G_TYPE_CHECK_INSTANCE_CAST (reversed, GEE_TYPE_LIST, GeeList);
	return result;
}

static void
application_command_sequence_class_init (ApplicationCommandSequenceClass * klass,
                                         gpointer klass_data)
{
	application_command_sequence_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ApplicationCommandSequence_private_offset);
	((ApplicationCommandClass *) klass)->executed = (void (*) (ApplicationCommand*)) application_command_sequence_real_executed;
	((ApplicationCommandClass *) klass)->undone = (void (*) (ApplicationCommand*)) application_command_sequence_real_undone;
	((ApplicationCommandClass *) klass)->redone = (void (*) (ApplicationCommand*)) application_command_sequence_real_redone;
	((ApplicationCommandClass *) klass)->execute = (void (*) (ApplicationCommand*, GCancellable*, GAsyncReadyCallback, gpointer)) application_command_sequence_real_execute;
	((ApplicationCommandClass *) klass)->execute_finish = (void (*) (ApplicationCommand*, GAsyncResult*, GError**)) application_command_sequence_execute_finish;
	((ApplicationCommandClass *) klass)->undo = (void (*) (ApplicationCommand*, GCancellable*, GAsyncReadyCallback, gpointer)) application_command_sequence_real_undo;
	((ApplicationCommandClass *) klass)->undo_finish = (void (*) (ApplicationCommand*, GAsyncResult*, GError**)) application_command_sequence_undo_finish;
	((ApplicationCommandClass *) klass)->redo = (void (*) (ApplicationCommand*, GCancellable*, GAsyncReadyCallback, gpointer)) application_command_sequence_real_redo;
	((ApplicationCommandClass *) klass)->redo_finish = (void (*) (ApplicationCommand*, GAsyncResult*, GError**)) application_command_sequence_redo_finish;
	G_OBJECT_CLASS (klass)->finalize = application_command_sequence_finalize;
}

static void
application_command_sequence_instance_init (ApplicationCommandSequence * self,
                                            gpointer klass)
{
	GeeLinkedList* _tmp0_;
	self->priv = application_command_sequence_get_instance_private (self);
	_tmp0_ = gee_linked_list_new (APPLICATION_TYPE_COMMAND, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->commands = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
}

static void
application_command_sequence_finalize (GObject * obj)
{
	ApplicationCommandSequence * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, APPLICATION_TYPE_COMMAND_SEQUENCE, ApplicationCommandSequence);
	_g_object_unref0 (self->priv->commands);
	G_OBJECT_CLASS (application_command_sequence_parent_class)->finalize (obj);
}

/**
 * A command that executes a sequence of other commands.
 *
 * When initially executed or redone, commands will be processed
 * individually in the given order. When undone, commands will be
 * processed individually in reverse order.
 */
static GType
application_command_sequence_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ApplicationCommandSequenceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_command_sequence_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ApplicationCommandSequence), 0, (GInstanceInitFunc) application_command_sequence_instance_init, NULL };
	GType application_command_sequence_type_id;
	application_command_sequence_type_id = g_type_register_static (APPLICATION_TYPE_COMMAND, "ApplicationCommandSequence", &g_define_type_info, 0);
	ApplicationCommandSequence_private_offset = g_type_add_instance_private (application_command_sequence_type_id, sizeof (ApplicationCommandSequencePrivate));
	return application_command_sequence_type_id;
}

GType
application_command_sequence_get_type (void)
{
	static volatile gsize application_command_sequence_type_id__once = 0;
	if (g_once_init_enter (&application_command_sequence_type_id__once)) {
		GType application_command_sequence_type_id;
		application_command_sequence_type_id = application_command_sequence_get_type_once ();
		g_once_init_leave (&application_command_sequence_type_id__once, application_command_sequence_type_id);
	}
	return application_command_sequence_type_id__once;
}

static inline gpointer
application_property_command_get_instance_private (ApplicationPropertyCommand* self)
{
	return G_STRUCT_MEMBER_P (self, ApplicationPropertyCommand_private_offset);
}

ApplicationPropertyCommand*
application_property_command_construct (GType object_type,
                                        GType t_type,
                                        GBoxedCopyFunc t_dup_func,
                                        GDestroyNotify t_destroy_func,
                                        GObject* object,
                                        const gchar* property_name,
                                        gconstpointer new_value,
                                        const gchar* undo_label,
                                        const gchar* redo_label,
                                        const gchar* executed_label,
                                        const gchar* undone_label)
{
	ApplicationPropertyCommand * self = NULL;
	GObject* _tmp0_;
	gchar* _tmp1_;
	gpointer _tmp2_;
	GObject* _tmp3_;
	const gchar* _tmp4_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (object, G_TYPE_OBJECT), NULL);
	g_return_val_if_fail (property_name != NULL, NULL);
	self = (ApplicationPropertyCommand*) application_command_construct (object_type);
	self->priv->t_type = t_type;
	self->priv->t_dup_func = t_dup_func;
	self->priv->t_destroy_func = t_destroy_func;
	_tmp0_ = _g_object_ref0 (object);
	_g_object_unref0 (self->priv->object);
	self->priv->object = _tmp0_;
	_tmp1_ = g_strdup (property_name);
	_g_free0 (self->priv->property_name);
	self->priv->property_name = _tmp1_;
	_tmp2_ = ((new_value != NULL) && (t_dup_func != NULL)) ? t_dup_func ((gpointer) new_value) : ((gpointer) new_value);
	((self->priv->new_value == NULL) || (t_destroy_func == NULL)) ? NULL : (self->priv->new_value = (t_destroy_func (self->priv->new_value), NULL));
	self->priv->new_value = _tmp2_;
	_tmp3_ = self->priv->object;
	_tmp4_ = self->priv->property_name;
	g_object_get (_tmp3_, _tmp4_, &self->priv->old_value, NULL);
	if (undo_label != NULL) {
		gconstpointer _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = self->priv->old_value;
		_tmp6_ = g_strdup_printf (undo_label, _tmp5_);
		_tmp7_ = _tmp6_;
		application_command_set_undo_label (G_TYPE_CHECK_INSTANCE_CAST (self, APPLICATION_TYPE_COMMAND, ApplicationCommand), _tmp7_);
		_g_free0 (_tmp7_);
	}
	if (redo_label != NULL) {
		gconstpointer _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = self->priv->new_value;
		_tmp9_ = g_strdup_printf (redo_label, _tmp8_);
		_tmp10_ = _tmp9_;
		application_command_set_redo_label (G_TYPE_CHECK_INSTANCE_CAST (self, APPLICATION_TYPE_COMMAND, ApplicationCommand), _tmp10_);
		_g_free0 (_tmp10_);
	}
	if (executed_label != NULL) {
		gconstpointer _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp11_ = self->priv->new_value;
		_tmp12_ = g_strdup_printf (executed_label, _tmp11_);
		_tmp13_ = _tmp12_;
		application_command_set_executed_label (G_TYPE_CHECK_INSTANCE_CAST (self, APPLICATION_TYPE_COMMAND, ApplicationCommand), _tmp13_);
		_g_free0 (_tmp13_);
	}
	if (undone_label != NULL) {
		gconstpointer _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp14_ = self->priv->old_value;
		_tmp15_ = g_strdup_printf (undone_label, _tmp14_);
		_tmp16_ = _tmp15_;
		application_command_set_undone_label (G_TYPE_CHECK_INSTANCE_CAST (self, APPLICATION_TYPE_COMMAND, ApplicationCommand), _tmp16_);
		_g_free0 (_tmp16_);
	}
	return self;
}

ApplicationPropertyCommand*
application_property_command_new (GType t_type,
                                  GBoxedCopyFunc t_dup_func,
                                  GDestroyNotify t_destroy_func,
                                  GObject* object,
                                  const gchar* property_name,
                                  gconstpointer new_value,
                                  const gchar* undo_label,
                                  const gchar* redo_label,
                                  const gchar* executed_label,
                                  const gchar* undone_label)
{
	return application_property_command_construct (APPLICATION_TYPE_PROPERTY_COMMAND, t_type, t_dup_func, t_destroy_func, object, property_name, new_value, undo_label, redo_label, executed_label, undone_label);
}

static void
application_property_command_real_execute_data_free (gpointer _data)
{
	ApplicationPropertyCommandExecuteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationPropertyCommandExecuteData, _data_);
}

static void
application_property_command_real_execute (ApplicationCommand* base,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	ApplicationPropertyCommand * self;
	ApplicationPropertyCommandExecuteData* _data_;
	ApplicationPropertyCommand* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_PROPERTY_COMMAND, ApplicationPropertyCommand);
	_data_ = g_slice_new0 (ApplicationPropertyCommandExecuteData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_property_command_real_execute_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	application_property_command_real_execute_co (_data_);
}

static void
application_property_command_execute_finish (ApplicationCommand* base,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	ApplicationPropertyCommandExecuteData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
application_property_command_real_execute_co (ApplicationPropertyCommandExecuteData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->object;
	_data_->_tmp1_ = _data_->self->priv->property_name;
	_data_->_tmp2_ = _data_->self->priv->new_value;
	g_object_set (_data_->_tmp0_, _data_->_tmp1_, _data_->_tmp2_, NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_property_command_real_undo_data_free (gpointer _data)
{
	ApplicationPropertyCommandUndoData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationPropertyCommandUndoData, _data_);
}

static void
application_property_command_real_undo (ApplicationCommand* base,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	ApplicationPropertyCommand * self;
	ApplicationPropertyCommandUndoData* _data_;
	ApplicationPropertyCommand* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_PROPERTY_COMMAND, ApplicationPropertyCommand);
	_data_ = g_slice_new0 (ApplicationPropertyCommandUndoData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_property_command_real_undo_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	application_property_command_real_undo_co (_data_);
}

static void
application_property_command_undo_finish (ApplicationCommand* base,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	ApplicationPropertyCommandUndoData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
application_property_command_real_undo_co (ApplicationPropertyCommandUndoData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->object;
	_data_->_tmp1_ = _data_->self->priv->property_name;
	_data_->_tmp2_ = _data_->self->priv->old_value;
	g_object_set (_data_->_tmp0_, _data_->_tmp1_, _data_->_tmp2_, NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
application_property_command_real_to_string (ApplicationCommand* base)
{
	ApplicationPropertyCommand * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_PROPERTY_COMMAND, ApplicationPropertyCommand);
	_tmp0_ = APPLICATION_COMMAND_CLASS (application_property_command_parent_class)->to_string (G_TYPE_CHECK_INSTANCE_CAST (self, APPLICATION_TYPE_COMMAND, ApplicationCommand));
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->property_name;
	_tmp3_ = g_strdup_printf ("%s(%s)", _tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp1_);
	result = _tmp4_;
	return result;
}

static void
application_property_command_class_init (ApplicationPropertyCommandClass * klass,
                                         gpointer klass_data)
{
	application_property_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ApplicationPropertyCommand_private_offset);
	((ApplicationCommandClass *) klass)->execute = (void (*) (ApplicationCommand*, GCancellable*, GAsyncReadyCallback, gpointer)) application_property_command_real_execute;
	((ApplicationCommandClass *) klass)->execute_finish = (void (*) (ApplicationCommand*, GAsyncResult*, GError**)) application_property_command_execute_finish;
	((ApplicationCommandClass *) klass)->undo = (void (*) (ApplicationCommand*, GCancellable*, GAsyncReadyCallback, gpointer)) application_property_command_real_undo;
	((ApplicationCommandClass *) klass)->undo_finish = (void (*) (ApplicationCommand*, GAsyncResult*, GError**)) application_property_command_undo_finish;
	((ApplicationCommandClass *) klass)->to_string = (gchar* (*) (ApplicationCommand*)) application_property_command_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = _vala_application_property_command_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_application_property_command_set_property;
	G_OBJECT_CLASS (klass)->finalize = application_property_command_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_PROPERTY_COMMAND_T_TYPE, g_param_spec_gtype ("t-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_PROPERTY_COMMAND_T_DUP_FUNC, g_param_spec_pointer ("t-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_PROPERTY_COMMAND_T_DESTROY_FUNC, g_param_spec_pointer ("t-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
}

static void
application_property_command_instance_init (ApplicationPropertyCommand * self,
                                            gpointer klass)
{
	self->priv = application_property_command_get_instance_private (self);
}

static void
application_property_command_finalize (GObject * obj)
{
	ApplicationPropertyCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, APPLICATION_TYPE_PROPERTY_COMMAND, ApplicationPropertyCommand);
	_g_object_unref0 (self->priv->object);
	_g_free0 (self->priv->property_name);
	((self->priv->new_value == NULL) || (self->priv->t_destroy_func == NULL)) ? NULL : (self->priv->new_value = (self->priv->t_destroy_func (self->priv->new_value), NULL));
	((self->priv->old_value == NULL) || (self->priv->t_destroy_func == NULL)) ? NULL : (self->priv->old_value = (self->priv->t_destroy_func (self->priv->old_value), NULL));
	G_OBJECT_CLASS (application_property_command_parent_class)->finalize (obj);
}

/**
 * A command that updates a GObject instance property.
 *
 * This command will save the existing property value on execution
 * before updating it with the new given property, restore it on undo,
 * and re-execute on redo. The type parameter T must be the same type
 * as the property being updated and must be nullable if the property
 * is nullable.
 */
static GType
application_property_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ApplicationPropertyCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_property_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ApplicationPropertyCommand), 0, (GInstanceInitFunc) application_property_command_instance_init, NULL };
	GType application_property_command_type_id;
	application_property_command_type_id = g_type_register_static (APPLICATION_TYPE_COMMAND, "ApplicationPropertyCommand", &g_define_type_info, 0);
	ApplicationPropertyCommand_private_offset = g_type_add_instance_private (application_property_command_type_id, sizeof (ApplicationPropertyCommandPrivate));
	return application_property_command_type_id;
}

GType
application_property_command_get_type (void)
{
	static volatile gsize application_property_command_type_id__once = 0;
	if (g_once_init_enter (&application_property_command_type_id__once)) {
		GType application_property_command_type_id;
		application_property_command_type_id = application_property_command_get_type_once ();
		g_once_init_leave (&application_property_command_type_id__once, application_property_command_type_id);
	}
	return application_property_command_type_id__once;
}

static void
_vala_application_property_command_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	ApplicationPropertyCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, APPLICATION_TYPE_PROPERTY_COMMAND, ApplicationPropertyCommand);
	switch (property_id) {
		case APPLICATION_PROPERTY_COMMAND_T_TYPE:
		g_value_set_gtype (value, self->priv->t_type);
		break;
		case APPLICATION_PROPERTY_COMMAND_T_DUP_FUNC:
		g_value_set_pointer (value, self->priv->t_dup_func);
		break;
		case APPLICATION_PROPERTY_COMMAND_T_DESTROY_FUNC:
		g_value_set_pointer (value, self->priv->t_destroy_func);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_application_property_command_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	ApplicationPropertyCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, APPLICATION_TYPE_PROPERTY_COMMAND, ApplicationPropertyCommand);
	switch (property_id) {
		case APPLICATION_PROPERTY_COMMAND_T_TYPE:
		self->priv->t_type = g_value_get_gtype (value);
		break;
		case APPLICATION_PROPERTY_COMMAND_T_DUP_FUNC:
		self->priv->t_dup_func = g_value_get_pointer (value);
		break;
		case APPLICATION_PROPERTY_COMMAND_T_DESTROY_FUNC:
		self->priv->t_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
application_command_stack_get_instance_private (ApplicationCommandStack* self)
{
	return G_STRUCT_MEMBER_P (self, ApplicationCommandStack_private_offset);
}

gboolean
application_command_stack_get_can_undo (ApplicationCommandStack* self)
{
	gboolean result;
	g_return_val_if_fail (APPLICATION_IS_COMMAND_STACK (self), FALSE);
	result = self->priv->_can_undo;
	return result;
}

static void
application_command_stack_set_can_undo (ApplicationCommandStack* self,
                                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (APPLICATION_IS_COMMAND_STACK (self));
	old_value = application_command_stack_get_can_undo (self);
	if (old_value != value) {
		self->priv->_can_undo = value;
		g_object_notify_by_pspec ((GObject *) self, application_command_stack_properties[APPLICATION_COMMAND_STACK_CAN_UNDO_PROPERTY]);
	}
}

gboolean
application_command_stack_get_can_redo (ApplicationCommandStack* self)
{
	gboolean result;
	g_return_val_if_fail (APPLICATION_IS_COMMAND_STACK (self), FALSE);
	result = self->priv->_can_redo;
	return result;
}

static void
application_command_stack_set_can_redo (ApplicationCommandStack* self,
                                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (APPLICATION_IS_COMMAND_STACK (self));
	old_value = application_command_stack_get_can_redo (self);
	if (old_value != value) {
		self->priv->_can_redo = value;
		g_object_notify_by_pspec ((GObject *) self, application_command_stack_properties[APPLICATION_COMMAND_STACK_CAN_REDO_PROPERTY]);
	}
}

static void
application_command_stack_real_execute_data_free (gpointer _data)
{
	ApplicationCommandStackExecuteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->target);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationCommandStackExecuteData, _data_);
}

static void
application_command_stack_real_execute (ApplicationCommandStack* self,
                                        ApplicationCommand* target,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	ApplicationCommandStackExecuteData* _data_;
	ApplicationCommandStack* _tmp0_;
	ApplicationCommand* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (APPLICATION_IS_COMMAND (target));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ApplicationCommandStackExecuteData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_command_stack_real_execute_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (target);
	_g_object_unref0 (_data_->target);
	_data_->target = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	application_command_stack_real_execute_co (_data_);
}

static void
application_command_stack_real_execute_finish (ApplicationCommandStack* self,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	ApplicationCommandStackExecuteData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Executes an command and pushes it onto the undo stack.
     *
     * This calls {@link Command.execute} and if no error is thrown,
     * pushes the command onto the undo stack.
     */
static void
application_command_stack_execute_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	ApplicationCommandStackExecuteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_command_stack_real_execute_co (_data_);
}

static gboolean
application_command_stack_real_execute_co (ApplicationCommandStackExecuteData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = application_command_to_string (_data_->target);
	_data_->_tmp1_ = _data_->_tmp0_;
	g_debug ("application-command.vala:398: Executing: %s", _data_->_tmp1_);
	_g_free0 (_data_->_tmp1_);
	_data_->_state_ = 1;
	application_command_execute (_data_->target, _data_->cancellable, application_command_stack_execute_ready, _data_);
	return FALSE;
	_state_1:
	application_command_execute_finish (_data_->target, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	application_command_stack_update_undo_stack (_data_->self, _data_->target);
	_data_->_tmp2_ = _data_->self->undo_stack;
	_data_->_tmp3_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
	_data_->_tmp4_ = _data_->_tmp3_;
	application_command_stack_set_can_undo (_data_->self, !_data_->_tmp4_);
	_data_->_tmp5_ = _data_->self->redo_stack;
	gee_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
	application_command_stack_set_can_redo (_data_->self, FALSE);
	g_signal_emit (_data_->self, application_command_stack_signals[APPLICATION_COMMAND_STACK_EXECUTED_SIGNAL], 0, _data_->target);
	g_signal_emit (_data_->target, application_command_signals[APPLICATION_COMMAND_EXECUTED_SIGNAL], 0);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
application_command_stack_execute (ApplicationCommandStack* self,
                                   ApplicationCommand* target,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	ApplicationCommandStackClass* _klass_;
	_klass_ = APPLICATION_COMMAND_STACK_GET_CLASS (self);
	if (_klass_->execute) {
		_klass_->execute (self, target, cancellable, _callback_, _user_data_);
	}
}

void
application_command_stack_execute_finish (ApplicationCommandStack* self,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	ApplicationCommandStackClass* _klass_;
	_klass_ = APPLICATION_COMMAND_STACK_GET_CLASS (self);
	if (_klass_->execute_finish) {
		_klass_->execute_finish (self, _res_, error);
	}
}

static void
application_command_stack_real_undo_data_free (gpointer _data)
{
	ApplicationCommandStackUndoData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationCommandStackUndoData, _data_);
}

static void
application_command_stack_real_undo (ApplicationCommandStack* self,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	ApplicationCommandStackUndoData* _data_;
	ApplicationCommandStack* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ApplicationCommandStackUndoData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_command_stack_real_undo_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	application_command_stack_real_undo_co (_data_);
}

static void
application_command_stack_real_undo_finish (ApplicationCommandStack* self,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	ApplicationCommandStackUndoData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Pops a command off the undo stack and un-does is.
     *
     * This calls {@link Command.undo} on the topmost command on the
     * undo stack and if no error is thrown, pushes it on the redo
     * stack. If an error is thrown, the command is discarded and the
     * redo stack is emptied.
     */
static void
application_command_stack_undo_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	ApplicationCommandStackUndoData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_command_stack_real_undo_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
application_command_stack_real_undo_co (ApplicationCommandStackUndoData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->undo_stack;
	_data_->_tmp1_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_data_->_tmp2_ = _data_->_tmp1_;
	if (!_data_->_tmp2_) {
		_data_->_tmp3_ = _data_->self->undo_stack;
		_data_->_tmp4_ = gee_deque_poll_head (_data_->_tmp3_);
		_data_->target = (ApplicationCommand*) _data_->_tmp4_;
		_data_->_tmp5_ = _data_->self->undo_stack;
		_data_->_tmp6_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
		_data_->_tmp7_ = _data_->_tmp6_;
		if (_data_->_tmp7_) {
			application_command_stack_set_can_undo (_data_->self, FALSE);
		}
		_data_->_tmp8_ = _data_->target;
		_data_->_tmp9_ = application_command_to_string (_data_->_tmp8_);
		_data_->_tmp10_ = _data_->_tmp9_;
		g_debug ("application-command.vala:428: Undoing: %s", _data_->_tmp10_);
		_g_free0 (_data_->_tmp10_);
		{
			_data_->_tmp11_ = _data_->target;
			_data_->_state_ = 1;
			application_command_undo (_data_->_tmp11_, _data_->cancellable, application_command_stack_undo_ready, _data_);
			return FALSE;
			_state_1:
			application_command_undo_finish (_data_->_tmp11_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp12_ = _data_->self->redo_stack;
			gee_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp12_, GEE_TYPE_COLLECTION, GeeCollection));
			application_command_stack_set_can_redo (_data_->self, FALSE);
			_data_->_tmp13_ = _data_->err;
			_data_->_tmp14_ = _g_error_copy0 (_data_->_tmp13_);
			_data_->_inner_error0_ = _data_->_tmp14_;
			_g_error_free0 (_data_->err);
			goto __finally0;
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->target);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp15_ = _data_->target;
		application_command_stack_update_redo_stack (_data_->self, _data_->_tmp15_);
		_data_->_tmp16_ = _data_->self->redo_stack;
		_data_->_tmp17_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp16_, GEE_TYPE_COLLECTION, GeeCollection));
		_data_->_tmp18_ = _data_->_tmp17_;
		application_command_stack_set_can_redo (_data_->self, !_data_->_tmp18_);
		_data_->_tmp19_ = _data_->target;
		g_signal_emit (_data_->self, application_command_stack_signals[APPLICATION_COMMAND_STACK_UNDONE_SIGNAL], 0, _data_->_tmp19_);
		_data_->_tmp20_ = _data_->target;
		g_signal_emit (_data_->_tmp20_, application_command_signals[APPLICATION_COMMAND_UNDONE_SIGNAL], 0);
		_g_object_unref0 (_data_->target);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
application_command_stack_undo (ApplicationCommandStack* self,
                                GCancellable* cancellable,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	ApplicationCommandStackClass* _klass_;
	_klass_ = APPLICATION_COMMAND_STACK_GET_CLASS (self);
	if (_klass_->undo) {
		_klass_->undo (self, cancellable, _callback_, _user_data_);
	}
}

void
application_command_stack_undo_finish (ApplicationCommandStack* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	ApplicationCommandStackClass* _klass_;
	_klass_ = APPLICATION_COMMAND_STACK_GET_CLASS (self);
	if (_klass_->undo_finish) {
		_klass_->undo_finish (self, _res_, error);
	}
}

static void
application_command_stack_real_redo_data_free (gpointer _data)
{
	ApplicationCommandStackRedoData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationCommandStackRedoData, _data_);
}

static void
application_command_stack_real_redo (ApplicationCommandStack* self,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	ApplicationCommandStackRedoData* _data_;
	ApplicationCommandStack* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ApplicationCommandStackRedoData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_command_stack_real_redo_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	application_command_stack_real_redo_co (_data_);
}

static void
application_command_stack_real_redo_finish (ApplicationCommandStack* self,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	ApplicationCommandStackRedoData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Pops a command off the redo stack and re-applies it.
     *
     * This calls {@link Command.redo} on the topmost command on the
     * redo stack and if no error is thrown, pushes it on the undo
     * stack. If an error is thrown, the command is discarded and the
     * redo stack is emptied.
     */
static void
application_command_stack_redo_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	ApplicationCommandStackRedoData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_command_stack_real_redo_co (_data_);
}

static gboolean
application_command_stack_real_redo_co (ApplicationCommandStackRedoData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->redo_stack;
	_data_->_tmp1_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_data_->_tmp2_ = _data_->_tmp1_;
	if (!_data_->_tmp2_) {
		_data_->_tmp3_ = _data_->self->redo_stack;
		_data_->_tmp4_ = gee_deque_poll_head (_data_->_tmp3_);
		_data_->target = (ApplicationCommand*) _data_->_tmp4_;
		_data_->_tmp5_ = _data_->self->redo_stack;
		_data_->_tmp6_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
		_data_->_tmp7_ = _data_->_tmp6_;
		if (_data_->_tmp7_) {
			application_command_stack_set_can_redo (_data_->self, FALSE);
		}
		_data_->_tmp8_ = _data_->target;
		_data_->_tmp9_ = application_command_to_string (_data_->_tmp8_);
		_data_->_tmp10_ = _data_->_tmp9_;
		g_debug ("application-command.vala:462: Redoing: %s", _data_->_tmp10_);
		_g_free0 (_data_->_tmp10_);
		{
			_data_->_tmp11_ = _data_->target;
			_data_->_state_ = 1;
			application_command_redo (_data_->_tmp11_, _data_->cancellable, application_command_stack_redo_ready, _data_);
			return FALSE;
			_state_1:
			application_command_redo_finish (_data_->_tmp11_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp12_ = _data_->self->redo_stack;
			gee_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp12_, GEE_TYPE_COLLECTION, GeeCollection));
			application_command_stack_set_can_redo (_data_->self, FALSE);
			_data_->_tmp13_ = _data_->err;
			_data_->_tmp14_ = _g_error_copy0 (_data_->_tmp13_);
			_data_->_inner_error0_ = _data_->_tmp14_;
			_g_error_free0 (_data_->err);
			goto __finally0;
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->target);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp15_ = _data_->target;
		application_command_stack_update_undo_stack (_data_->self, _data_->_tmp15_);
		_data_->_tmp16_ = _data_->self->undo_stack;
		_data_->_tmp17_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp16_, GEE_TYPE_COLLECTION, GeeCollection));
		_data_->_tmp18_ = _data_->_tmp17_;
		application_command_stack_set_can_undo (_data_->self, !_data_->_tmp18_);
		_data_->_tmp19_ = _data_->target;
		g_signal_emit (_data_->self, application_command_stack_signals[APPLICATION_COMMAND_STACK_REDONE_SIGNAL], 0, _data_->_tmp19_);
		_data_->_tmp20_ = _data_->target;
		g_signal_emit (_data_->_tmp20_, application_command_signals[APPLICATION_COMMAND_REDONE_SIGNAL], 0);
		_g_object_unref0 (_data_->target);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
application_command_stack_redo (ApplicationCommandStack* self,
                                GCancellable* cancellable,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	ApplicationCommandStackClass* _klass_;
	_klass_ = APPLICATION_COMMAND_STACK_GET_CLASS (self);
	if (_klass_->redo) {
		_klass_->redo (self, cancellable, _callback_, _user_data_);
	}
}

void
application_command_stack_redo_finish (ApplicationCommandStack* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	ApplicationCommandStackClass* _klass_;
	_klass_ = APPLICATION_COMMAND_STACK_GET_CLASS (self);
	if (_klass_->redo_finish) {
		_klass_->redo_finish (self, _res_, error);
	}
}

/** Returns the command at the top of the undo stack, if any. */
ApplicationCommand*
application_command_stack_peek_undo (ApplicationCommandStack* self)
{
	ApplicationCommand* _tmp0_ = NULL;
	GeeDeque* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	ApplicationCommand* result;
	g_return_val_if_fail (APPLICATION_IS_COMMAND_STACK (self), NULL);
	_tmp1_ = self->undo_stack;
	_tmp2_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_g_object_unref0 (_tmp0_);
		_tmp0_ = NULL;
	} else {
		GeeDeque* _tmp4_;
		gpointer _tmp5_;
		_tmp4_ = self->undo_stack;
		_tmp5_ = gee_deque_peek_head (_tmp4_);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = (ApplicationCommand*) _tmp5_;
	}
	result = _tmp0_;
	return result;
}

/** Returns the command at the top of the redo stack, if any. */
ApplicationCommand*
application_command_stack_peek_redo (ApplicationCommandStack* self)
{
	ApplicationCommand* _tmp0_ = NULL;
	GeeDeque* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	ApplicationCommand* result;
	g_return_val_if_fail (APPLICATION_IS_COMMAND_STACK (self), NULL);
	_tmp1_ = self->redo_stack;
	_tmp2_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_g_object_unref0 (_tmp0_);
		_tmp0_ = NULL;
	} else {
		GeeDeque* _tmp4_;
		gpointer _tmp5_;
		_tmp4_ = self->redo_stack;
		_tmp5_ = gee_deque_peek_head (_tmp4_);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = (ApplicationCommand*) _tmp5_;
	}
	result = _tmp0_;
	return result;
}

/** Clears all commands from both the undo and redo stacks. */
void
application_command_stack_clear (ApplicationCommandStack* self)
{
	GeeDeque* _tmp0_;
	GeeDeque* _tmp1_;
	g_return_if_fail (APPLICATION_IS_COMMAND_STACK (self));
	_tmp0_ = self->undo_stack;
	gee_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	application_command_stack_set_can_undo (self, FALSE);
	_tmp1_ = self->redo_stack;
	gee_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
	application_command_stack_set_can_redo (self, FALSE);
}

/**
     * Updates the undo stack when a command is executed or re-done.
     *
     * By default, this pushes the command to the head of the undo
     * stack if {@link Command.can_undo} is true.
     */
static void
application_command_stack_real_update_undo_stack (ApplicationCommandStack* self,
                                                  ApplicationCommand* target)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (APPLICATION_IS_COMMAND (target));
	_tmp0_ = application_command_get_can_undo (target);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GeeDeque* _tmp2_;
		_tmp2_ = self->undo_stack;
		gee_deque_offer_head (_tmp2_, target);
	}
}

void
application_command_stack_update_undo_stack (ApplicationCommandStack* self,
                                             ApplicationCommand* target)
{
	ApplicationCommandStackClass* _klass_;
	g_return_if_fail (APPLICATION_IS_COMMAND_STACK (self));
	_klass_ = APPLICATION_COMMAND_STACK_GET_CLASS (self);
	if (_klass_->update_undo_stack) {
		_klass_->update_undo_stack (self, target);
	}
}

/**
     * Updates the redo stack when a command is undone.
     *
     * By default, this pushes the command to the head of the redo
     * stack if {@link Command.can_undo} is true.
     */
static void
application_command_stack_real_update_redo_stack (ApplicationCommandStack* self,
                                                  ApplicationCommand* target)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (APPLICATION_IS_COMMAND (target));
	_tmp0_ = application_command_get_can_redo (target);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GeeDeque* _tmp2_;
		_tmp2_ = self->redo_stack;
		gee_deque_offer_head (_tmp2_, target);
	}
}

void
application_command_stack_update_redo_stack (ApplicationCommandStack* self,
                                             ApplicationCommand* target)
{
	ApplicationCommandStackClass* _klass_;
	g_return_if_fail (APPLICATION_IS_COMMAND_STACK (self));
	_klass_ = APPLICATION_COMMAND_STACK_GET_CLASS (self);
	if (_klass_->update_redo_stack) {
		_klass_->update_redo_stack (self, target);
	}
}

ApplicationCommandStack*
application_command_stack_construct (GType object_type)
{
	ApplicationCommandStack * self = NULL;
	self = (ApplicationCommandStack*) g_object_new (object_type, NULL);
	return self;
}

ApplicationCommandStack*
application_command_stack_new (void)
{
	return application_command_stack_construct (APPLICATION_TYPE_COMMAND_STACK);
}

static void
application_command_stack_class_init (ApplicationCommandStackClass * klass,
                                      gpointer klass_data)
{
	application_command_stack_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ApplicationCommandStack_private_offset);
	((ApplicationCommandStackClass *) klass)->execute = (void (*) (ApplicationCommandStack*, ApplicationCommand*, GCancellable*, GAsyncReadyCallback, gpointer)) application_command_stack_real_execute;
	((ApplicationCommandStackClass *) klass)->execute_finish = (void (*) (ApplicationCommandStack*, GAsyncResult*, GError**)) application_command_stack_real_execute_finish;
	((ApplicationCommandStackClass *) klass)->undo = (void (*) (ApplicationCommandStack*, GCancellable*, GAsyncReadyCallback, gpointer)) application_command_stack_real_undo;
	((ApplicationCommandStackClass *) klass)->undo_finish = (void (*) (ApplicationCommandStack*, GAsyncResult*, GError**)) application_command_stack_real_undo_finish;
	((ApplicationCommandStackClass *) klass)->redo = (void (*) (ApplicationCommandStack*, GCancellable*, GAsyncReadyCallback, gpointer)) application_command_stack_real_redo;
	((ApplicationCommandStackClass *) klass)->redo_finish = (void (*) (ApplicationCommandStack*, GAsyncResult*, GError**)) application_command_stack_real_redo_finish;
	((ApplicationCommandStackClass *) klass)->update_undo_stack = (void (*) (ApplicationCommandStack*, ApplicationCommand*)) application_command_stack_real_update_undo_stack;
	((ApplicationCommandStackClass *) klass)->update_redo_stack = (void (*) (ApplicationCommandStack*, ApplicationCommand*)) application_command_stack_real_update_redo_stack;
	G_OBJECT_CLASS (klass)->get_property = _vala_application_command_stack_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_application_command_stack_set_property;
	G_OBJECT_CLASS (klass)->finalize = application_command_stack_finalize;
	/** Determines if there are any commands able to be un-done. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_COMMAND_STACK_CAN_UNDO_PROPERTY, application_command_stack_properties[APPLICATION_COMMAND_STACK_CAN_UNDO_PROPERTY] = g_param_spec_boolean ("can-undo", "can-undo", "can-undo", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Determines if there are any commands available to be re-done. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_COMMAND_STACK_CAN_REDO_PROPERTY, application_command_stack_properties[APPLICATION_COMMAND_STACK_CAN_REDO_PROPERTY] = g_param_spec_boolean ("can-redo", "can-redo", "can-redo", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Fired when a command is first executed */
	application_command_stack_signals[APPLICATION_COMMAND_STACK_EXECUTED_SIGNAL] = g_signal_new ("executed", APPLICATION_TYPE_COMMAND_STACK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, APPLICATION_TYPE_COMMAND);
	/** Fired when a command is un-done */
	application_command_stack_signals[APPLICATION_COMMAND_STACK_UNDONE_SIGNAL] = g_signal_new ("undone", APPLICATION_TYPE_COMMAND_STACK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, APPLICATION_TYPE_COMMAND);
	/** Fired when a command is re-executed */
	application_command_stack_signals[APPLICATION_COMMAND_STACK_REDONE_SIGNAL] = g_signal_new ("redone", APPLICATION_TYPE_COMMAND_STACK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, APPLICATION_TYPE_COMMAND);
}

static void
application_command_stack_instance_init (ApplicationCommandStack * self,
                                         gpointer klass)
{
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp1_;
	self->priv = application_command_stack_get_instance_private (self);
	_tmp0_ = gee_linked_list_new (APPLICATION_TYPE_COMMAND, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->undo_stack = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_DEQUE, GeeDeque);
	_tmp1_ = gee_linked_list_new (APPLICATION_TYPE_COMMAND, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->redo_stack = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_DEQUE, GeeDeque);
}

static void
application_command_stack_finalize (GObject * obj)
{
	ApplicationCommandStack * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, APPLICATION_TYPE_COMMAND_STACK, ApplicationCommandStack);
	_g_object_unref0 (self->undo_stack);
	_g_object_unref0 (self->redo_stack);
	G_OBJECT_CLASS (application_command_stack_parent_class)->finalize (obj);
}

/**
 * A stack of executed application commands.
 *
 * The command stack manages calling the {@link Command.execute},
 * {@link Command.undo}, and {@link Command.redo} methods on an
 * application's user commands. It enforces the strict ordering of
 * calls to those methods so that if a command is well implemented,
 * then the application will be in the same state after executing and
 * re-doing a command, and the application will return to the original
 * state after being undone, both for individual commands and between
 * after a number of commands have been executed.
 *
 * Applications should call {@link execute} to execute a command,
 * which will push it on to an undo stack after executing it. The
 * command at the top of the stack can be undone by calling {@link
 * undo}, which undoes the command, pops it from the undo stack and
 * pushes it on the redo stack. If a new command is executed when the
 * redo stack is non-empty, it will be emptied first.
 */
static GType
application_command_stack_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ApplicationCommandStackClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_command_stack_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ApplicationCommandStack), 0, (GInstanceInitFunc) application_command_stack_instance_init, NULL };
	GType application_command_stack_type_id;
	application_command_stack_type_id = g_type_register_static (G_TYPE_OBJECT, "ApplicationCommandStack", &g_define_type_info, 0);
	ApplicationCommandStack_private_offset = g_type_add_instance_private (application_command_stack_type_id, sizeof (ApplicationCommandStackPrivate));
	return application_command_stack_type_id;
}

GType
application_command_stack_get_type (void)
{
	static volatile gsize application_command_stack_type_id__once = 0;
	if (g_once_init_enter (&application_command_stack_type_id__once)) {
		GType application_command_stack_type_id;
		application_command_stack_type_id = application_command_stack_get_type_once ();
		g_once_init_leave (&application_command_stack_type_id__once, application_command_stack_type_id);
	}
	return application_command_stack_type_id__once;
}

static void
_vala_application_command_stack_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	ApplicationCommandStack * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, APPLICATION_TYPE_COMMAND_STACK, ApplicationCommandStack);
	switch (property_id) {
		case APPLICATION_COMMAND_STACK_CAN_UNDO_PROPERTY:
		g_value_set_boolean (value, application_command_stack_get_can_undo (self));
		break;
		case APPLICATION_COMMAND_STACK_CAN_REDO_PROPERTY:
		g_value_set_boolean (value, application_command_stack_get_can_redo (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_application_command_stack_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	ApplicationCommandStack * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, APPLICATION_TYPE_COMMAND_STACK, ApplicationCommandStack);
	switch (property_id) {
		case APPLICATION_COMMAND_STACK_CAN_UNDO_PROPERTY:
		application_command_stack_set_can_undo (self, g_value_get_boolean (value));
		break;
		case APPLICATION_COMMAND_STACK_CAN_REDO_PROPERTY:
		application_command_stack_set_can_redo (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

