/* A packrat parser generated by PackCC 1.8.0 */

#include "general.h"

#ifdef _MSC_VER
#undef _CRT_SECURE_NO_WARNINGS
#define _CRT_SECURE_NO_WARNINGS
#endif /* _MSC_VER */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef _MSC_VER
#if defined __GNUC__ && defined _WIN32 /* MinGW */
#ifndef PCC_USE_SYSTEM_STRNLEN
#define strnlen(str, maxlen) pcc_strnlen(str, maxlen)
static size_t pcc_strnlen(const char *str, size_t maxlen) {
    size_t i;
    for (i = 0; i < maxlen && str[i]; i++);
    return i;
}
#endif /* !PCC_USE_SYSTEM_STRNLEN */
#endif /* defined __GNUC__ && defined _WIN32 */
#endif /* !_MSC_VER */

#include "./peg/elm.h"

#include "elm_pre.h"
#include "routines.h"

/*
 * Include these lines to debug the parsing.
 * From https://github.com/arithy/packcc#macros
 * This will output parsing info to STDERR.tmp in the vent of a failed test.
 */

/*
static const char *dbg_str[] = { "Evaluating rule", "Matched rule", "Abandoning rule" };

#define PCC_DEBUG(auxil, event, rule, level, pos, buffer, length) \
    fprintf(stderr, "%*s%s %s @%zu [%.*s]\n", \
        (int)((level) * 2), "", dbg_str[event], rule, pos, (int)(length), buffer)
 */
#if !defined __has_attribute || defined _MSC_VER
#define __attribute__(x)
#endif

#ifdef _MSC_VER
#define MARK_FUNC_AS_USED __pragma(warning(suppress:4505))
#else
#define MARK_FUNC_AS_USED __attribute__((__unused__))
#endif

#ifdef _MSC_VER
#define MARK_VAR_AS_USED __pragma(warning(suppress:4189))
#else
#define MARK_VAR_AS_USED __attribute__((__unused__))
#endif

#ifndef PCC_BUFFER_MIN_SIZE
#define PCC_BUFFER_MIN_SIZE 256
#endif /* !PCC_BUFFER_MIN_SIZE */

#ifndef PCC_ARRAY_MIN_SIZE
#define PCC_ARRAY_MIN_SIZE 2
#endif /* !PCC_ARRAY_MIN_SIZE */

#ifndef PCC_POOL_MIN_SIZE
#define PCC_POOL_MIN_SIZE 65536
#endif /* !PCC_POOL_MIN_SIZE */

#define PCC_DBG_EVALUATE 0
#define PCC_DBG_MATCH    1
#define PCC_DBG_NOMATCH  2

#define PCC_VOID_VALUE (~(size_t)0)

typedef enum pcc_bool_tag {
    PCC_FALSE = 0,
    PCC_TRUE
} pcc_bool_t;

typedef struct pcc_char_array_tag {
    char *buf;
    size_t max;
    size_t len;
} pcc_char_array_t;

typedef struct pcc_range_tag {
    size_t start;
    size_t end;
} pcc_range_t;

typedef int pcc_value_t;

typedef struct parserCtx *pcc_auxil_t;

typedef pelm_context_t pcc_context_t;

typedef struct pcc_value_table_tag {
    pcc_value_t *buf;
    size_t max;
    size_t len;
} pcc_value_table_t;

typedef struct pcc_value_refer_table_tag {
    pcc_value_t **buf;
    size_t max;
    size_t len;
} pcc_value_refer_table_t;

typedef struct pcc_capture_tag {
    pcc_range_t range;
    char *string; /* mutable */
} pcc_capture_t;

typedef struct pcc_capture_table_tag {
    pcc_capture_t *buf;
    size_t max;
    size_t len;
} pcc_capture_table_t;

typedef struct pcc_capture_const_table_tag {
    const pcc_capture_t **buf;
    size_t max;
    size_t len;
} pcc_capture_const_table_t;

typedef struct pcc_thunk_tag pcc_thunk_t;
typedef struct pcc_thunk_array_tag pcc_thunk_array_t;

typedef void (*pcc_action_t)(pcc_context_t *, pcc_thunk_t *, pcc_value_t *);

typedef enum pcc_thunk_type_tag {
    PCC_THUNK_LEAF,
    PCC_THUNK_NODE
} pcc_thunk_type_t;

typedef struct pcc_thunk_leaf_tag {
    pcc_value_refer_table_t values;
    pcc_capture_const_table_t capts;
    pcc_capture_t capt0;
    pcc_action_t action;
} pcc_thunk_leaf_t;

typedef struct pcc_thunk_node_tag {
    const pcc_thunk_array_t *thunks; /* just a reference */
    pcc_value_t *value; /* just a reference */
} pcc_thunk_node_t;

typedef union pcc_thunk_data_tag {
    pcc_thunk_leaf_t leaf;
    pcc_thunk_node_t node;
} pcc_thunk_data_t;

struct pcc_thunk_tag {
    pcc_thunk_type_t type;
    pcc_thunk_data_t data;
};

struct pcc_thunk_array_tag {
    pcc_thunk_t **buf;
    size_t max;
    size_t len;
};

typedef struct pcc_thunk_chunk_tag {
    pcc_value_table_t values;
    pcc_capture_table_t capts;
    pcc_thunk_array_t thunks;
    size_t pos; /* the starting position in the character buffer */
} pcc_thunk_chunk_t;

typedef struct pcc_lr_entry_tag pcc_lr_entry_t;

typedef enum pcc_lr_answer_type_tag {
    PCC_LR_ANSWER_LR,
    PCC_LR_ANSWER_CHUNK
} pcc_lr_answer_type_t;

typedef union pcc_lr_answer_data_tag {
    pcc_lr_entry_t *lr;
    pcc_thunk_chunk_t *chunk;
} pcc_lr_answer_data_t;

typedef struct pcc_lr_answer_tag pcc_lr_answer_t;

struct pcc_lr_answer_tag {
    pcc_lr_answer_type_t type;
    pcc_lr_answer_data_t data;
    size_t pos; /* the absolute position in the input */
    pcc_lr_answer_t *hold;
};

typedef pcc_thunk_chunk_t *(*pcc_rule_t)(pcc_context_t *);

typedef struct pcc_rule_set_tag {
    pcc_rule_t *buf;
    size_t max;
    size_t len;
} pcc_rule_set_t;

typedef struct pcc_lr_head_tag pcc_lr_head_t;

struct pcc_lr_head_tag {
    pcc_rule_t rule;
    pcc_rule_set_t invol;
    pcc_rule_set_t eval;
    pcc_lr_head_t *hold;
};

typedef struct pcc_lr_memo_tag {
    pcc_rule_t rule;
    pcc_lr_answer_t *answer;
} pcc_lr_memo_t;

typedef struct pcc_lr_memo_map_tag {
    pcc_lr_memo_t *buf;
    size_t max;
    size_t len;
} pcc_lr_memo_map_t;

typedef struct pcc_lr_table_entry_tag {
    pcc_lr_head_t *head; /* just a reference */
    pcc_lr_memo_map_t memos;
    pcc_lr_answer_t *hold_a;
    pcc_lr_head_t *hold_h;
} pcc_lr_table_entry_t;

typedef struct pcc_lr_table_tag {
    pcc_lr_table_entry_t **buf;
    size_t max;
    size_t len;
    size_t ofs;
} pcc_lr_table_t;

struct pcc_lr_entry_tag {
    pcc_rule_t rule;
    pcc_thunk_chunk_t *seed; /* just a reference */
    pcc_lr_head_t *head; /* just a reference */
};

typedef struct pcc_lr_stack_tag {
    pcc_lr_entry_t **buf;
    size_t max;
    size_t len;
} pcc_lr_stack_t;

typedef struct pcc_memory_entry_tag pcc_memory_entry_t;
typedef struct pcc_memory_pool_tag pcc_memory_pool_t;

struct pcc_memory_entry_tag {
    pcc_memory_entry_t *next;
};

struct pcc_memory_pool_tag {
    pcc_memory_pool_t *next;
    size_t allocated;
    size_t unused;
};

typedef struct pcc_memory_recycler_tag {
    pcc_memory_pool_t *pool_list;
    pcc_memory_entry_t *entry_list;
    size_t element_size;
} pcc_memory_recycler_t;

struct pelm_context_tag {
    size_t pos; /* the position in the input of the first character currently buffered */
    size_t cur; /* the current parsing position in the character buffer */
    size_t level;
    pcc_char_array_t buffer;
    pcc_lr_table_t lrtable;
    pcc_lr_stack_t lrstack;
    pcc_thunk_array_t thunks;
    pcc_auxil_t auxil;
    pcc_memory_recycler_t thunk_chunk_recycler;
    pcc_memory_recycler_t lr_head_recycler;
    pcc_memory_recycler_t lr_answer_recycler;
};

#ifndef PCC_ERROR
#define PCC_ERROR(auxil) pcc_error()
MARK_FUNC_AS_USED
static void pcc_error(void) {
    fprintf(stderr, "Syntax error\n");
    exit(1);
}
#endif /* !PCC_ERROR */

#ifndef PCC_GETCHAR
#define PCC_GETCHAR(auxil) getchar()
#endif /* !PCC_GETCHAR */

#ifndef PCC_MALLOC
#define PCC_MALLOC(auxil, size) pcc_malloc_e(size)
static void *pcc_malloc_e(size_t size) {
    void *const p = malloc(size);
    if (p == NULL) {
        fprintf(stderr, "Out of memory\n");
        exit(1);
    }
    return p;
}
#endif /* !PCC_MALLOC */

#ifndef PCC_REALLOC
#define PCC_REALLOC(auxil, ptr, size) pcc_realloc_e(ptr, size)
static void *pcc_realloc_e(void *ptr, size_t size) {
    void *const p = realloc(ptr, size);
    if (p == NULL) {
        fprintf(stderr, "Out of memory\n");
        exit(1);
    }
    return p;
}
#endif /* !PCC_REALLOC */

#ifndef PCC_FREE
#define PCC_FREE(auxil, ptr) free(ptr)
#endif /* !PCC_FREE */

#ifndef PCC_DEBUG
#define PCC_DEBUG(auxil, event, rule, level, pos, buffer, length) ((void)0)
#endif /* !PCC_DEBUG */

static char *pcc_strndup_e(pcc_auxil_t auxil, const char *str, size_t len) {
    const size_t m = strnlen(str, len);
    char *const s = (char *)PCC_MALLOC(auxil, m + 1);
    memcpy(s, str, m);
    s[m] = '\0';
    return s;
}

static void pcc_char_array__init(pcc_auxil_t auxil, pcc_char_array_t *array) {
    array->len = 0;
    array->max = 0;
    array->buf = NULL;
}

static void pcc_char_array__add(pcc_auxil_t auxil, pcc_char_array_t *array, char ch) {
    if (array->max <= array->len) {
        const size_t n = array->len + 1;
        size_t m = array->max;
        if (m == 0) m = PCC_BUFFER_MIN_SIZE;
        while (m < n && m != 0) m <<= 1;
        if (m == 0) m = n;
        array->buf = (char *)PCC_REALLOC(auxil, array->buf, m);
        array->max = m;
    }
    array->buf[array->len++] = ch;
}

static void pcc_char_array__term(pcc_auxil_t auxil, pcc_char_array_t *array) {
    PCC_FREE(auxil, array->buf);
}

static void pcc_value_table__init(pcc_auxil_t auxil, pcc_value_table_t *table) {
    table->len = 0;
    table->max = 0;
    table->buf = NULL;
}

MARK_FUNC_AS_USED
static void pcc_value_table__resize(pcc_auxil_t auxil, pcc_value_table_t *table, size_t len) {
    if (table->max < len) {
        size_t m = table->max;
        if (m == 0) m = PCC_ARRAY_MIN_SIZE;
        while (m < len && m != 0) m <<= 1;
        if (m == 0) m = len;
        table->buf = (pcc_value_t *)PCC_REALLOC(auxil, table->buf, sizeof(pcc_value_t) * m);
        table->max = m;
    }
    table->len = len;
}

MARK_FUNC_AS_USED
static void pcc_value_table__clear(pcc_auxil_t auxil, pcc_value_table_t *table) {
    memset(table->buf, 0, sizeof(pcc_value_t) * table->len);
}

static void pcc_value_table__term(pcc_auxil_t auxil, pcc_value_table_t *table) {
    PCC_FREE(auxil, table->buf);
}

static void pcc_value_refer_table__init(pcc_auxil_t auxil, pcc_value_refer_table_t *table) {
    table->len = 0;
    table->max = 0;
    table->buf = NULL;
}

static void pcc_value_refer_table__resize(pcc_auxil_t auxil, pcc_value_refer_table_t *table, size_t len) {
    size_t i;
    if (table->max < len) {
        size_t m = table->max;
        if (m == 0) m = PCC_ARRAY_MIN_SIZE;
        while (m < len && m != 0) m <<= 1;
        if (m == 0) m = len;
        table->buf = (pcc_value_t **)PCC_REALLOC(auxil, table->buf, sizeof(pcc_value_t *) * m);
        table->max = m;
    }
    for (i = table->len; i < len; i++) table->buf[i] = NULL;
    table->len = len;
}

static void pcc_value_refer_table__term(pcc_auxil_t auxil, pcc_value_refer_table_t *table) {
    PCC_FREE(auxil, table->buf);
}

static void pcc_capture_table__init(pcc_auxil_t auxil, pcc_capture_table_t *table) {
    table->len = 0;
    table->max = 0;
    table->buf = NULL;
}

MARK_FUNC_AS_USED
static void pcc_capture_table__resize(pcc_auxil_t auxil, pcc_capture_table_t *table, size_t len) {
    size_t i;
    for (i = len; i < table->len; i++) PCC_FREE(auxil, table->buf[i].string);
    if (table->max < len) {
        size_t m = table->max;
        if (m == 0) m = PCC_ARRAY_MIN_SIZE;
        while (m < len && m != 0) m <<= 1;
        if (m == 0) m = len;
        table->buf = (pcc_capture_t *)PCC_REALLOC(auxil, table->buf, sizeof(pcc_capture_t) * m);
        table->max = m;
    }
    for (i = table->len; i < len; i++) {
        table->buf[i].range.start = 0;
        table->buf[i].range.end = 0;
        table->buf[i].string = NULL;
    }
    table->len = len;
}

static void pcc_capture_table__term(pcc_auxil_t auxil, pcc_capture_table_t *table) {
    while (table->len > 0) {
        table->len--;
        PCC_FREE(auxil, table->buf[table->len].string);
    }
    PCC_FREE(auxil, table->buf);
}

static void pcc_capture_const_table__init(pcc_auxil_t auxil, pcc_capture_const_table_t *table) {
    table->len = 0;
    table->max = 0;
    table->buf = NULL;
}

static void pcc_capture_const_table__resize(pcc_auxil_t auxil, pcc_capture_const_table_t *table, size_t len) {
    size_t i;
    if (table->max < len) {
        size_t m = table->max;
        if (m == 0) m = PCC_ARRAY_MIN_SIZE;
        while (m < len && m != 0) m <<= 1;
        if (m == 0) m = len;
        table->buf = (const pcc_capture_t **)PCC_REALLOC(auxil, (pcc_capture_t **)table->buf, sizeof(const pcc_capture_t *) * m);
        table->max = m;
    }
    for (i = table->len; i < len; i++) table->buf[i] = NULL;
    table->len = len;
}

static void pcc_capture_const_table__term(pcc_auxil_t auxil, pcc_capture_const_table_t *table) {
    PCC_FREE(auxil, (void *)table->buf);
}

MARK_FUNC_AS_USED
static pcc_thunk_t *pcc_thunk__create_leaf(pcc_auxil_t auxil, pcc_action_t action, size_t valuec, size_t captc) {
    pcc_thunk_t *const thunk = (pcc_thunk_t *)PCC_MALLOC(auxil, sizeof(pcc_thunk_t));
    thunk->type = PCC_THUNK_LEAF;
    pcc_value_refer_table__init(auxil, &thunk->data.leaf.values);
    pcc_value_refer_table__resize(auxil, &thunk->data.leaf.values, valuec);
    pcc_capture_const_table__init(auxil, &thunk->data.leaf.capts);
    pcc_capture_const_table__resize(auxil, &thunk->data.leaf.capts, captc);
    thunk->data.leaf.capt0.range.start = 0;
    thunk->data.leaf.capt0.range.end = 0;
    thunk->data.leaf.capt0.string = NULL;
    thunk->data.leaf.action = action;
    return thunk;
}

static pcc_thunk_t *pcc_thunk__create_node(pcc_auxil_t auxil, const pcc_thunk_array_t *thunks, pcc_value_t *value) {
    pcc_thunk_t *const thunk = (pcc_thunk_t *)PCC_MALLOC(auxil, sizeof(pcc_thunk_t));
    thunk->type = PCC_THUNK_NODE;
    thunk->data.node.thunks = thunks;
    thunk->data.node.value = value;
    return thunk;
}

static void pcc_thunk__destroy(pcc_auxil_t auxil, pcc_thunk_t *thunk) {
    if (thunk == NULL) return;
    switch (thunk->type) {
    case PCC_THUNK_LEAF:
        PCC_FREE(auxil, thunk->data.leaf.capt0.string);
        pcc_capture_const_table__term(auxil, &thunk->data.leaf.capts);
        pcc_value_refer_table__term(auxil, &thunk->data.leaf.values);
        break;
    case PCC_THUNK_NODE:
        break;
    default: /* unknown */
        break;
    }
    PCC_FREE(auxil, thunk);
}

static void pcc_thunk_array__init(pcc_auxil_t auxil, pcc_thunk_array_t *array) {
    array->len = 0;
    array->max = 0;
    array->buf = NULL;
}

static void pcc_thunk_array__add(pcc_auxil_t auxil, pcc_thunk_array_t *array, pcc_thunk_t *thunk) {
    if (array->max <= array->len) {
        const size_t n = array->len + 1;
        size_t m = array->max;
        if (m == 0) m = PCC_ARRAY_MIN_SIZE;
        while (m < n && m != 0) m <<= 1;
        if (m == 0) m = n;
        array->buf = (pcc_thunk_t **)PCC_REALLOC(auxil, array->buf, sizeof(pcc_thunk_t *) * m);
        array->max = m;
    }
    array->buf[array->len++] = thunk;
}

static void pcc_thunk_array__revert(pcc_auxil_t auxil, pcc_thunk_array_t *array, size_t len) {
    while (array->len > len) {
        array->len--;
        pcc_thunk__destroy(auxil, array->buf[array->len]);
    }
}

static void pcc_thunk_array__term(pcc_auxil_t auxil, pcc_thunk_array_t *array) {
    while (array->len > 0) {
        array->len--;
        pcc_thunk__destroy(auxil, array->buf[array->len]);
    }
    PCC_FREE(auxil, array->buf);
}

static void pcc_memory_recycler__init(pcc_auxil_t auxil, pcc_memory_recycler_t *recycler, size_t element_size) {
    recycler->pool_list = NULL;
    recycler->entry_list = NULL;
    recycler->element_size = element_size;
}

static void *pcc_memory_recycler__supply(pcc_auxil_t auxil, pcc_memory_recycler_t *recycler) {
    if (recycler->entry_list) {
        pcc_memory_entry_t *const tmp = recycler->entry_list;
        recycler->entry_list = tmp->next;
        return tmp;
    }
    if (!recycler->pool_list || recycler->pool_list->unused == 0) {
        size_t size = PCC_POOL_MIN_SIZE;
        if (recycler->pool_list) {
            size = recycler->pool_list->allocated << 1;
            if (size == 0) size = recycler->pool_list->allocated;
        }
        {
            pcc_memory_pool_t *const pool = (pcc_memory_pool_t *)PCC_MALLOC(
                auxil, sizeof(pcc_memory_pool_t) + recycler->element_size * size
            );
            pool->allocated = size;
            pool->unused = size;
            pool->next = recycler->pool_list;
            recycler->pool_list = pool;
        }
    }
    recycler->pool_list->unused--;
    return (char *)recycler->pool_list + sizeof(pcc_memory_pool_t) + recycler->element_size * recycler->pool_list->unused;
}

static void pcc_memory_recycler__recycle(pcc_auxil_t auxil, pcc_memory_recycler_t *recycler, void *ptr) {
    pcc_memory_entry_t *const tmp = (pcc_memory_entry_t *)ptr;
    tmp->next = recycler->entry_list;
    recycler->entry_list = tmp;
}

static void pcc_memory_recycler__term(pcc_auxil_t auxil, pcc_memory_recycler_t *recycler) {
    while (recycler->pool_list) {
        pcc_memory_pool_t *const tmp = recycler->pool_list;
        recycler->pool_list = tmp->next;
        PCC_FREE(auxil, tmp);
    }
}

MARK_FUNC_AS_USED
static pcc_thunk_chunk_t *pcc_thunk_chunk__create(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = (pcc_thunk_chunk_t *)pcc_memory_recycler__supply(ctx->auxil, &ctx->thunk_chunk_recycler);
    pcc_value_table__init(ctx->auxil, &chunk->values);
    pcc_capture_table__init(ctx->auxil, &chunk->capts);
    pcc_thunk_array__init(ctx->auxil, &chunk->thunks);
    chunk->pos = 0;
    return chunk;
}

static void pcc_thunk_chunk__destroy(pcc_context_t *ctx, pcc_thunk_chunk_t *chunk) {
    if (chunk == NULL) return;
    pcc_thunk_array__term(ctx->auxil, &chunk->thunks);
    pcc_capture_table__term(ctx->auxil, &chunk->capts);
    pcc_value_table__term(ctx->auxil, &chunk->values);
    pcc_memory_recycler__recycle(ctx->auxil, &ctx->thunk_chunk_recycler, chunk);
}

static void pcc_rule_set__init(pcc_auxil_t auxil, pcc_rule_set_t *set) {
    set->len = 0;
    set->max = 0;
    set->buf = NULL;
}

static size_t pcc_rule_set__index(pcc_auxil_t auxil, const pcc_rule_set_t *set, pcc_rule_t rule) {
    size_t i;
    for (i = 0; i < set->len; i++) {
        if (set->buf[i] == rule) return i;
    }
    return PCC_VOID_VALUE;
}

static pcc_bool_t pcc_rule_set__add(pcc_auxil_t auxil, pcc_rule_set_t *set, pcc_rule_t rule) {
    const size_t i = pcc_rule_set__index(auxil, set, rule);
    if (i != PCC_VOID_VALUE) return PCC_FALSE;
    if (set->max <= set->len) {
        const size_t n = set->len + 1;
        size_t m = set->max;
        if (m == 0) m = PCC_ARRAY_MIN_SIZE;
        while (m < n && m != 0) m <<= 1;
        if (m == 0) m = n;
        set->buf = (pcc_rule_t *)PCC_REALLOC(auxil, set->buf, sizeof(pcc_rule_t) * m);
        set->max = m;
    }
    set->buf[set->len++] = rule;
    return PCC_TRUE;
}

static pcc_bool_t pcc_rule_set__remove(pcc_auxil_t auxil, pcc_rule_set_t *set, pcc_rule_t rule) {
    const size_t i = pcc_rule_set__index(auxil, set, rule);
    if (i == PCC_VOID_VALUE) return PCC_FALSE;
    memmove(set->buf + i, set->buf + (i + 1), sizeof(pcc_rule_t) * (set->len - (i + 1)));
    return PCC_TRUE;
}

static void pcc_rule_set__clear(pcc_auxil_t auxil, pcc_rule_set_t *set) {
    set->len = 0;
}

static void pcc_rule_set__copy(pcc_auxil_t auxil, pcc_rule_set_t *set, const pcc_rule_set_t *src) {
    size_t i;
    pcc_rule_set__clear(auxil, set);
    for (i = 0; i < src->len; i++) {
        pcc_rule_set__add(auxil, set, src->buf[i]);
    }
}

static void pcc_rule_set__term(pcc_auxil_t auxil, pcc_rule_set_t *set) {
    PCC_FREE(auxil, set->buf);
}

static pcc_lr_head_t *pcc_lr_head__create(pcc_context_t *ctx, pcc_rule_t rule) {
    pcc_lr_head_t *const head = (pcc_lr_head_t *)pcc_memory_recycler__supply(ctx->auxil, &ctx->lr_head_recycler);
    head->rule = rule;
    pcc_rule_set__init(ctx->auxil, &head->invol);
    pcc_rule_set__init(ctx->auxil, &head->eval);
    head->hold = NULL;
    return head;
}

static void pcc_lr_head__destroy(pcc_context_t *ctx, pcc_lr_head_t *head) {
    if (head == NULL) return;
    pcc_lr_head__destroy(ctx, head->hold);
    pcc_rule_set__term(ctx->auxil, &head->eval);
    pcc_rule_set__term(ctx->auxil, &head->invol);
    pcc_memory_recycler__recycle(ctx->auxil, &ctx->lr_head_recycler, head);
}

static void pcc_lr_entry__destroy(pcc_auxil_t auxil, pcc_lr_entry_t *lr);

static pcc_lr_answer_t *pcc_lr_answer__create(pcc_context_t *ctx, pcc_lr_answer_type_t type, size_t pos) {
    pcc_lr_answer_t *answer = (pcc_lr_answer_t *)pcc_memory_recycler__supply(ctx->auxil, &ctx->lr_answer_recycler);
    answer->type = type;
    answer->pos = pos;
    answer->hold = NULL;
    switch (answer->type) {
    case PCC_LR_ANSWER_LR:
        answer->data.lr = NULL;
        break;
    case PCC_LR_ANSWER_CHUNK:
        answer->data.chunk = NULL;
        break;
    default: /* unknown */
        PCC_FREE(ctx->auxil, answer);
        answer = NULL;
    }
    return answer;
}

static void pcc_lr_answer__set_chunk(pcc_context_t *ctx, pcc_lr_answer_t *answer, pcc_thunk_chunk_t *chunk) {
    pcc_lr_answer_t *const a = pcc_lr_answer__create(ctx, answer->type, answer->pos);
    switch (answer->type) {
    case PCC_LR_ANSWER_LR:
        a->data.lr = answer->data.lr;
        break;
    case PCC_LR_ANSWER_CHUNK:
        a->data.chunk = answer->data.chunk;
        break;
    default: /* unknown */
        break;
    }
    a->hold = answer->hold;
    answer->hold = a;
    answer->type = PCC_LR_ANSWER_CHUNK;
    answer->data.chunk = chunk;
}

static void pcc_lr_answer__destroy(pcc_context_t *ctx, pcc_lr_answer_t *answer) {
    while (answer != NULL) {
        pcc_lr_answer_t *const a = answer->hold;
        switch (answer->type) {
        case PCC_LR_ANSWER_LR:
            pcc_lr_entry__destroy(ctx->auxil, answer->data.lr);
            break;
        case PCC_LR_ANSWER_CHUNK:
            pcc_thunk_chunk__destroy(ctx, answer->data.chunk);
            break;
        default: /* unknown */
            break;
        }
        pcc_memory_recycler__recycle(ctx->auxil, &ctx->lr_answer_recycler, answer);
        answer = a;
    }
}

static void pcc_lr_memo_map__init(pcc_auxil_t auxil, pcc_lr_memo_map_t *map) {
    map->len = 0;
    map->max = 0;
    map->buf = NULL;
}

static size_t pcc_lr_memo_map__index(pcc_context_t *ctx, pcc_lr_memo_map_t *map, pcc_rule_t rule) {
    size_t i;
    for (i = 0; i < map->len; i++) {
        if (map->buf[i].rule == rule) return i;
    }
    return PCC_VOID_VALUE;
}

static void pcc_lr_memo_map__put(pcc_context_t *ctx, pcc_lr_memo_map_t *map, pcc_rule_t rule, pcc_lr_answer_t *answer) {
    const size_t i = pcc_lr_memo_map__index(ctx, map, rule);
    if (i != PCC_VOID_VALUE) {
        pcc_lr_answer__destroy(ctx, map->buf[i].answer);
        map->buf[i].answer = answer;
    }
    else {
        if (map->max <= map->len) {
            const size_t n = map->len + 1;
            size_t m = map->max;
            if (m == 0) m = PCC_ARRAY_MIN_SIZE;
            while (m < n && m != 0) m <<= 1;
            if (m == 0) m = n;
            map->buf = (pcc_lr_memo_t *)PCC_REALLOC(ctx->auxil, map->buf, sizeof(pcc_lr_memo_t) * m);
            map->max = m;
        }
        map->buf[map->len].rule = rule;
        map->buf[map->len].answer = answer;
        map->len++;
    }
}

static pcc_lr_answer_t *pcc_lr_memo_map__get(pcc_context_t *ctx, pcc_lr_memo_map_t *map, pcc_rule_t rule) {
    const size_t i = pcc_lr_memo_map__index(ctx, map, rule);
    return (i != PCC_VOID_VALUE) ? map->buf[i].answer : NULL;
}

static void pcc_lr_memo_map__term(pcc_context_t *ctx, pcc_lr_memo_map_t *map) {
    while (map->len > 0) {
        map->len--;
        pcc_lr_answer__destroy(ctx, map->buf[map->len].answer);
    }
    PCC_FREE(ctx->auxil, map->buf);
}

static pcc_lr_table_entry_t *pcc_lr_table_entry__create(pcc_context_t *ctx) {
    pcc_lr_table_entry_t *const entry = (pcc_lr_table_entry_t *)PCC_MALLOC(ctx->auxil, sizeof(pcc_lr_table_entry_t));
    entry->head = NULL;
    pcc_lr_memo_map__init(ctx->auxil, &entry->memos);
    entry->hold_a = NULL;
    entry->hold_h = NULL;
    return entry;
}

static void pcc_lr_table_entry__destroy(pcc_context_t *ctx, pcc_lr_table_entry_t *entry) {
    if (entry == NULL) return;
    pcc_lr_head__destroy(ctx, entry->hold_h);
    pcc_lr_answer__destroy(ctx, entry->hold_a);
    pcc_lr_memo_map__term(ctx, &entry->memos);
    PCC_FREE(ctx->auxil, entry);
}

static void pcc_lr_table__init(pcc_auxil_t auxil, pcc_lr_table_t *table) {
    table->ofs = 0;
    table->len = 0;
    table->max = 0;
    table->buf = NULL;
}

static void pcc_lr_table__resize(pcc_context_t *ctx, pcc_lr_table_t *table, size_t len) {
    size_t i;
    for (i = len; i < table->len; i++) pcc_lr_table_entry__destroy(ctx, table->buf[i]);
    if (table->max < len) {
        size_t m = table->max;
        if (m == 0) m = PCC_ARRAY_MIN_SIZE;
        while (m < len && m != 0) m <<= 1;
        if (m == 0) m = len;
        table->buf = (pcc_lr_table_entry_t **)PCC_REALLOC(ctx->auxil, table->buf, sizeof(pcc_lr_table_entry_t *) * m);
        table->max = m;
    }
    for (i = table->len; i < len; i++) table->buf[i] = NULL;
    table->len = len;
}

static void pcc_lr_table__set_head(pcc_context_t *ctx, pcc_lr_table_t *table, size_t index, pcc_lr_head_t *head) {
    index += table->ofs;
    if (index >= table->len) pcc_lr_table__resize(ctx, table, index + 1);
    if (table->buf[index] == NULL) table->buf[index] = pcc_lr_table_entry__create(ctx);
    table->buf[index]->head = head;
}

static void pcc_lr_table__hold_head(pcc_context_t *ctx, pcc_lr_table_t *table, size_t index, pcc_lr_head_t *head) {
    index += table->ofs;
    if (index >= table->len) pcc_lr_table__resize(ctx, table, index + 1);
    if (table->buf[index] == NULL) table->buf[index] = pcc_lr_table_entry__create(ctx);
    head->hold = table->buf[index]->hold_h;
    table->buf[index]->hold_h = head;
}

static void pcc_lr_table__set_answer(pcc_context_t *ctx, pcc_lr_table_t *table, size_t index, pcc_rule_t rule, pcc_lr_answer_t *answer) {
    index += table->ofs;
    if (index >= table->len) pcc_lr_table__resize(ctx, table, index + 1);
    if (table->buf[index] == NULL) table->buf[index] = pcc_lr_table_entry__create(ctx);
    pcc_lr_memo_map__put(ctx, &table->buf[index]->memos, rule, answer);
}

static void pcc_lr_table__hold_answer(pcc_context_t *ctx, pcc_lr_table_t *table, size_t index, pcc_lr_answer_t *answer) {
    index += table->ofs;
    if (index >= table->len) pcc_lr_table__resize(ctx, table, index + 1);
    if (table->buf[index] == NULL) table->buf[index] = pcc_lr_table_entry__create(ctx);
    answer->hold = table->buf[index]->hold_a;
    table->buf[index]->hold_a = answer;
}

static pcc_lr_head_t *pcc_lr_table__get_head(pcc_context_t *ctx, pcc_lr_table_t *table, size_t index) {
    index += table->ofs;
    if (index >= table->len || table->buf[index] == NULL) return NULL;
    return table->buf[index]->head;
}

static pcc_lr_answer_t *pcc_lr_table__get_answer(pcc_context_t *ctx, pcc_lr_table_t *table, size_t index, pcc_rule_t rule) {
    index += table->ofs;
    if (index >= table->len || table->buf[index] == NULL) return NULL;
    return pcc_lr_memo_map__get(ctx, &table->buf[index]->memos, rule);
}

static void pcc_lr_table__shift(pcc_context_t *ctx, pcc_lr_table_t *table, size_t count) {
    size_t i;
    if (count > table->len - table->ofs) count = table->len - table->ofs;
    for (i = 0; i < count; i++) pcc_lr_table_entry__destroy(ctx, table->buf[table->ofs++]);
    if (table->ofs > (table->max >> 1)) {
        memmove(table->buf, table->buf + table->ofs, sizeof(pcc_lr_table_entry_t *) * (table->len - table->ofs));
        table->len -= table->ofs;
        table->ofs = 0;
    }
}

static void pcc_lr_table__term(pcc_context_t *ctx, pcc_lr_table_t *table) {
    while (table->len > table->ofs) {
        table->len--;
        pcc_lr_table_entry__destroy(ctx, table->buf[table->len]);
    }
    PCC_FREE(ctx->auxil, table->buf);
}

static pcc_lr_entry_t *pcc_lr_entry__create(pcc_auxil_t auxil, pcc_rule_t rule) {
    pcc_lr_entry_t *const lr = (pcc_lr_entry_t *)PCC_MALLOC(auxil, sizeof(pcc_lr_entry_t));
    lr->rule = rule;
    lr->seed = NULL;
    lr->head = NULL;
    return lr;
}

static void pcc_lr_entry__destroy(pcc_auxil_t auxil, pcc_lr_entry_t *lr) {
    PCC_FREE(auxil, lr);
}

static void pcc_lr_stack__init(pcc_auxil_t auxil, pcc_lr_stack_t *stack) {
    stack->len = 0;
    stack->max = 0;
    stack->buf = NULL;
}

static void pcc_lr_stack__push(pcc_auxil_t auxil, pcc_lr_stack_t *stack, pcc_lr_entry_t *lr) {
    if (stack->max <= stack->len) {
        const size_t n = stack->len + 1;
        size_t m = stack->max;
        if (m == 0) m = PCC_ARRAY_MIN_SIZE;
        while (m < n && m != 0) m <<= 1;
        if (m == 0) m = n;
        stack->buf = (pcc_lr_entry_t **)PCC_REALLOC(auxil, stack->buf, sizeof(pcc_lr_entry_t *) * m);
        stack->max = m;
    }
    stack->buf[stack->len++] = lr;
}

static pcc_lr_entry_t *pcc_lr_stack__pop(pcc_auxil_t auxil, pcc_lr_stack_t *stack) {
    return stack->buf[--stack->len];
}

static void pcc_lr_stack__term(pcc_auxil_t auxil, pcc_lr_stack_t *stack) {
    PCC_FREE(auxil, stack->buf);
}

static pcc_context_t *pcc_context__create(pcc_auxil_t auxil) {
    pcc_context_t *const ctx = (pcc_context_t *)PCC_MALLOC(auxil, sizeof(pcc_context_t));
    ctx->pos = 0;
    ctx->cur = 0;
    ctx->level = 0;
    pcc_char_array__init(auxil, &ctx->buffer);
    pcc_lr_table__init(auxil, &ctx->lrtable);
    pcc_lr_stack__init(auxil, &ctx->lrstack);
    pcc_thunk_array__init(auxil, &ctx->thunks);
    pcc_memory_recycler__init(auxil, &ctx->thunk_chunk_recycler, sizeof(pcc_thunk_chunk_t));
    pcc_memory_recycler__init(auxil, &ctx->lr_head_recycler, sizeof(pcc_lr_head_t));
    pcc_memory_recycler__init(auxil, &ctx->lr_answer_recycler, sizeof(pcc_lr_answer_t));
    ctx->auxil = auxil;
    return ctx;
}

static void pcc_context__destroy(pcc_context_t *ctx) {
    if (ctx == NULL) return;
    pcc_thunk_array__term(ctx->auxil, &ctx->thunks);
    pcc_lr_stack__term(ctx->auxil, &ctx->lrstack);
    pcc_lr_table__term(ctx, &ctx->lrtable);
    pcc_char_array__term(ctx->auxil, &ctx->buffer);
    pcc_memory_recycler__term(ctx->auxil, &ctx->thunk_chunk_recycler);
    pcc_memory_recycler__term(ctx->auxil, &ctx->lr_head_recycler);
    pcc_memory_recycler__term(ctx->auxil, &ctx->lr_answer_recycler);
    PCC_FREE(ctx->auxil, ctx);
}

static size_t pcc_refill_buffer(pcc_context_t *ctx, size_t num) {
    if (ctx->buffer.len >= ctx->cur + num) return ctx->buffer.len - ctx->cur;
    while (ctx->buffer.len < ctx->cur + num) {
        const int c = PCC_GETCHAR(ctx->auxil);
        if (c < 0) break;
        pcc_char_array__add(ctx->auxil, &ctx->buffer, (char)c);
    }
    return ctx->buffer.len - ctx->cur;
}

MARK_FUNC_AS_USED
static void pcc_commit_buffer(pcc_context_t *ctx) {
    memmove(ctx->buffer.buf, ctx->buffer.buf + ctx->cur, ctx->buffer.len - ctx->cur);
    ctx->buffer.len -= ctx->cur;
    ctx->pos += ctx->cur;
    pcc_lr_table__shift(ctx, &ctx->lrtable, ctx->cur);
    ctx->cur = 0;
}

MARK_FUNC_AS_USED
static const char *pcc_get_capture_string(pcc_context_t *ctx, const pcc_capture_t *capt) {
    if (capt->string == NULL)
        ((pcc_capture_t *)capt)->string =
            pcc_strndup_e(ctx->auxil, ctx->buffer.buf + capt->range.start, capt->range.end - capt->range.start);
    return capt->string;
}

static size_t pcc_get_char_as_utf32(pcc_context_t *ctx, int *out) { /* with checking UTF-8 validity */
    int c, u;
    size_t n;
    if (pcc_refill_buffer(ctx, 1) < 1) return 0;
    c = (int)(unsigned char)ctx->buffer.buf[ctx->cur];
    n = (c < 0x80) ? 1 :
        ((c & 0xe0) == 0xc0) ? 2 :
        ((c & 0xf0) == 0xe0) ? 3 :
        ((c & 0xf8) == 0xf0) ? 4 : 0;
    if (n < 1) return 0;
    if (pcc_refill_buffer(ctx, n) < n) return 0;
    switch (n) {
    case 1:
        u = c;
        break;
    case 2:
        u = c & 0x1f;
        c = (int)(unsigned char)ctx->buffer.buf[ctx->cur + 1];
        if ((c & 0xc0) != 0x80) return 0;
        u <<= 6; u |= c & 0x3f;
        if (u < 0x80) return 0;
        break;
    case 3:
        u = c & 0x0f;
        c = (int)(unsigned char)ctx->buffer.buf[ctx->cur + 1];
        if ((c & 0xc0) != 0x80) return 0;
        u <<= 6; u |= c & 0x3f;
        c = (int)(unsigned char)ctx->buffer.buf[ctx->cur + 2];
        if ((c & 0xc0) != 0x80) return 0;
        u <<= 6; u |= c & 0x3f;
        if (u < 0x800) return 0;
        break;
    case 4:
        u = c & 0x07;
        c = (int)(unsigned char)ctx->buffer.buf[ctx->cur + 1];
        if ((c & 0xc0) != 0x80) return 0;
        u <<= 6; u |= c & 0x3f;
        c = (int)(unsigned char)ctx->buffer.buf[ctx->cur + 2];
        if ((c & 0xc0) != 0x80) return 0;
        u <<= 6; u |= c & 0x3f;
        c = (int)(unsigned char)ctx->buffer.buf[ctx->cur + 3];
        if ((c & 0xc0) != 0x80) return 0;
        u <<= 6; u |= c & 0x3f;
        if (u < 0x10000 || u > 0x10ffff) return 0;
        break;
    default:
        return 0;
    }
    if (out) *out = u;
    return n;
}

MARK_FUNC_AS_USED
static pcc_bool_t pcc_apply_rule(pcc_context_t *ctx, pcc_rule_t rule, pcc_thunk_array_t *thunks, pcc_value_t *value) {
    static pcc_value_t null;
    pcc_thunk_chunk_t *c = NULL;
    const size_t p = ctx->pos + ctx->cur;
    pcc_bool_t b = PCC_TRUE;
    pcc_lr_answer_t *a = pcc_lr_table__get_answer(ctx, &ctx->lrtable, p, rule);
    pcc_lr_head_t *h = pcc_lr_table__get_head(ctx, &ctx->lrtable, p);
    if (h != NULL) {
        if (a == NULL && rule != h->rule && pcc_rule_set__index(ctx->auxil, &h->invol, rule) == PCC_VOID_VALUE) {
            b = PCC_FALSE;
            c = NULL;
        }
        else if (pcc_rule_set__remove(ctx->auxil, &h->eval, rule)) {
            b = PCC_FALSE;
            c = rule(ctx);
            a = pcc_lr_answer__create(ctx, PCC_LR_ANSWER_CHUNK, ctx->pos + ctx->cur);
            a->data.chunk = c;
            pcc_lr_table__hold_answer(ctx, &ctx->lrtable, p, a);
        }
    }
    if (b) {
        if (a != NULL) {
            ctx->cur = a->pos - ctx->pos;
            switch (a->type) {
            case PCC_LR_ANSWER_LR:
                if (a->data.lr->head == NULL) {
                    a->data.lr->head = pcc_lr_head__create(ctx, rule);
                    pcc_lr_table__hold_head(ctx, &ctx->lrtable, p, a->data.lr->head);
                }
                {
                    size_t i = ctx->lrstack.len;
                    while (i > 0) {
                        i--;
                        if (ctx->lrstack.buf[i]->head == a->data.lr->head) break;
                        ctx->lrstack.buf[i]->head = a->data.lr->head;
                        pcc_rule_set__add(ctx->auxil, &a->data.lr->head->invol, ctx->lrstack.buf[i]->rule);
                    }
                }
                c = a->data.lr->seed;
                break;
            case PCC_LR_ANSWER_CHUNK:
                c = a->data.chunk;
                break;
            default: /* unknown */
                break;
            }
        }
        else {
            pcc_lr_entry_t *const e = pcc_lr_entry__create(ctx->auxil, rule);
            pcc_lr_stack__push(ctx->auxil, &ctx->lrstack, e);
            a = pcc_lr_answer__create(ctx, PCC_LR_ANSWER_LR, p);
            a->data.lr = e;
            pcc_lr_table__set_answer(ctx, &ctx->lrtable, p, rule, a);
            c = rule(ctx);
            pcc_lr_stack__pop(ctx->auxil, &ctx->lrstack);
            a->pos = ctx->pos + ctx->cur;
            if (e->head == NULL) {
                pcc_lr_answer__set_chunk(ctx, a, c);
            }
            else {
                e->seed = c;
                h = a->data.lr->head;
                if (h->rule != rule) {
                    c = a->data.lr->seed;
                    a = pcc_lr_answer__create(ctx, PCC_LR_ANSWER_CHUNK, ctx->pos + ctx->cur);
                    a->data.chunk = c;
                    pcc_lr_table__hold_answer(ctx, &ctx->lrtable, p, a);
                }
                else {
                    pcc_lr_answer__set_chunk(ctx, a, a->data.lr->seed);
                    if (a->data.chunk == NULL) {
                        c = NULL;
                    }
                    else {
                        pcc_lr_table__set_head(ctx, &ctx->lrtable, p, h);
                        for (;;) {
                            ctx->cur = p - ctx->pos;
                            pcc_rule_set__copy(ctx->auxil, &h->eval, &h->invol);
                            c = rule(ctx);
                            if (c == NULL || ctx->pos + ctx->cur <= a->pos) break;
                            pcc_lr_answer__set_chunk(ctx, a, c);
                            a->pos = ctx->pos + ctx->cur;
                        }
                        pcc_thunk_chunk__destroy(ctx, c);
                        pcc_lr_table__set_head(ctx, &ctx->lrtable, p, NULL);
                        ctx->cur = a->pos - ctx->pos;
                        c = a->data.chunk;
                    }
                }
            }
        }
    }
    if (c == NULL) return PCC_FALSE;
    if (value == NULL) value = &null;
    memset(value, 0, sizeof(pcc_value_t)); /* in case */
    pcc_thunk_array__add(ctx->auxil, thunks, pcc_thunk__create_node(ctx->auxil, &c->thunks, value));
    return PCC_TRUE;
}

MARK_FUNC_AS_USED
static void pcc_do_action(pcc_context_t *ctx, const pcc_thunk_array_t *thunks, pcc_value_t *value) {
    size_t i;
    for (i = 0; i < thunks->len; i++) {
        pcc_thunk_t *const thunk = thunks->buf[i];
        switch (thunk->type) {
        case PCC_THUNK_LEAF:
            thunk->data.leaf.action(ctx, thunk, value);
            break;
        case PCC_THUNK_NODE:
            pcc_do_action(ctx, thunk->data.node.thunks, thunk->data.node.value);
            break;
        default: /* unknown */
            break;
        }
    }
}

static void pcc_action_file_0(pelm_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    ELM_INIT_MODULE_SCOPE;
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_moduleDeclaration_0(pelm_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
    elm_module_scope_index = makeElmTagSettingScope(auxil, _1, _1s, K_MODULE, ROLE_DEFINITION_INDEX);
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_typeAlias_0(pelm_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
    makeElmTag(auxil, _1, _1s, K_ALIAS, ROLE_DEFINITION_INDEX);
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_customType_0(pelm_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
    initElmConstructorFields(auxil, _1);
    makeElmTagSettingScope(auxil, _1, _1s, K_TYPE, ROLE_DEFINITION_INDEX);
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_customType_1(pelm_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
    POP_SCOPE(auxil);
    tidyElmConstructorFields(auxil);
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_constructorList_0(pelm_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
    initElmConstructorSubtypeFields(auxil);
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_constructorList_1(pelm_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
#define _2 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[1])
#define _2s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.start))
#define _2e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.end))
    int r = makeElmTag(auxil, _1, _1s, K_CONSTRUCTOR, ROLE_DEFINITION_INDEX);
    addElmConstructorTypeRef(auxil, r);
#undef _2e
#undef _2s
#undef _2
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_singleConstructorSubtypeSpec_0(pelm_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
    addElmConstructorSubtype(auxil, _1);
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_portDeclaration_0(pelm_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
#define _2 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[1])
#define _2s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.start))
#define _2e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.end))
    int r = makeElmTag(auxil, _1, _1s, K_PORT, ROLE_DEFINITION_INDEX);
    addElmTypeRef(r, _2);
#undef _2e
#undef _2s
#undef _2
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_importStatement_0(pelm_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
#define _2 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[1])
#define _2s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.start))
#define _2e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.end))
    // Make the namespace tag first, as it's in the file module's scope
    if (_2s > 0) {
        int r = makeElmTag(auxil, _2, _2s, K_NAMESPACE, ROLE_DEFINITION_INDEX);
        attachParserFieldToCorkEntry (r, ElmFields[F_MODULENAME].ftype, _1);
    }

    // Now make the tag for the imported module, as it lives outside
    // the scope of the file module
    ELM_SAVE_MODULE_SCOPE;
    makeElmTagSettingScope(auxil, _1, _1s, K_MODULE, ELM_MODULE_IMPORTED);
#undef _2e
#undef _2s
#undef _2
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_importStatement_1(pelm_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
#define _2 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[1])
#define _2s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.start))
#define _2e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.end))
    ELM_RESTORE_MODULE_SCOPE;
#undef _2e
#undef _2s
#undef _2
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_importedFunction_0(pelm_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
    makeElmTag(auxil, _1, _1s, K_FUNCTION, ELM_FUNCTION_EXPOSED);
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_importedType_0(pelm_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
    makeElmTagSettingScope(auxil, _1, _1s, K_TYPE, ELM_TYPE_EXPOSED);
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_importedType_1(pelm_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
    // We're done with the type and its constructors, so we can pop it
    POP_SCOPE(auxil);
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_importedTypeConstructor_0(pelm_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
    makeElmTag(auxil, _1, _1s, K_CONSTRUCTOR, ELM_CONSTRUCTOR_EXPOSED);
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_functionWithTypeAnnotation_0(pelm_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
#define _2 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[1])
#define _2s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.start))
#define _2e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.end))
#define _3 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[2])
#define _3s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[2]->range.start))
#define _3e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[2]->range.end))
#define _4 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[3])
#define _4s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[3]->range.start))
#define _4e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[3]->range.end))
    int r = makeElmTagSettingScope(auxil, _3, _3s, K_FUNCTION, ROLE_DEFINITION_INDEX);
    addElmTypeRef(r, _2);
    addElmSignature(r, _4);
#undef _4e
#undef _4s
#undef _4
#undef _3e
#undef _3s
#undef _3
#undef _2e
#undef _2s
#undef _2
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_functionWithTypeAnnotation_1(pelm_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
#define _2 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[1])
#define _2s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.start))
#define _2e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.end))
#define _3 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[2])
#define _3s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[2]->range.start))
#define _3e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[2]->range.end))
#define _4 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[3])
#define _4s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[3]->range.start))
#define _4e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[3]->range.end))
    POP_SCOPE(auxil);
#undef _4e
#undef _4s
#undef _4
#undef _3e
#undef _3s
#undef _3
#undef _2e
#undef _2s
#undef _2
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_functionDefinition_0(pelm_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
#define _2 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[1])
#define _2s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.start))
#define _2e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.end))
    int r = makeElmTagSettingScope(auxil, _1, _1s, K_FUNCTION, ROLE_DEFINITION_INDEX);
    addElmSignature(r, _2);
#undef _2e
#undef _2s
#undef _2
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_functionDefinition_1(pelm_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
#define _2 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[1])
#define _2s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.start))
#define _2e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.end))
    POP_SCOPE(auxil);
#undef _2e
#undef _2s
#undef _2
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_letInFunctionDefinition_0(pelm_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
#define _2 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[1])
#define _2s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.start))
#define _2e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.end))
    int r = makeElmTag(auxil, _1, _1s, K_FUNCTION, ROLE_DEFINITION_INDEX);
    addElmSignature(r, _2);
#undef _2e
#undef _2s
#undef _2
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_file(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_mainTopLevelStatements(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_topLevelStatement(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_moduleDeclaration(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_exposedList(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_exposedItem(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_exposedFieldOrType(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_exposedFunction(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_exposedItemIgnored(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_exposedTypeConstructorList(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_typeAlias(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_customType(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_typeParameterList(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_constructorList(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_constructorSubtypeList(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_singleConstructorSubtypeSpec(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_singleTypeSpec(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_recordTypeSpec(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_recordRestrictionPrefix(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_fieldSpec(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_tupleTypeSpec(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_parameterisedTypeSpec(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_functionTypeSpec(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_portDeclaration(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_importStatement(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_importedList(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_importedItem(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_importedFunction(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_importedType(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_importedItemIgnored(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_importedTypeConstructorList(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_importedTypeConstructor(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_functionWithTypeAnnotation(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_typeAnnotation(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_functionDefinition(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_functionParameterList(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_functionParameter(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_plainFunctionParameter(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_tupleFunctionParameter(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_recordFunctionParameter(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_constructorFunctionParameter(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_asClause(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_expression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_simpleExpression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_tupleExpression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_listExpression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_recordExpression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_recordExpressionAssignment(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_anonymousFunction(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_functionCall(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_letInBlock(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_letInLine(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_letInFunctionDefinition(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_letInFunctionParameters(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_letInFunctionBody(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_caseStatement(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_caseClauseList(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_caseClause(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_roughCasePatternChar(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_ifThenElseStatement(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_binaryOperator(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_ignoreRestOfStatement(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_multilineString(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_naiveIdentifier(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_upperStartIdentifier(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_lowerStartIdentifier(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_alphanumeric(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_nonKeywordIdentifier(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_keyword(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_dottedIdentifier(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_decimal(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_exponentialDecimal(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_simpleDecimal(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_simpleInteger(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_digits(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_hexNumber(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_oneLineString(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_characterLiteral(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_inStringChar(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_inStringPlainChar(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_inStringEscapedChar(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_inStringUnicodeChar(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_WS(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_NL(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_Non_NL(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_Non_WS_or_NL(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_EOF(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_delimitedComment(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_lineComment(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule__1_short(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule__1_(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule__0_(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_TLSS_short(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_TLSS(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_EOS(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule__NL_IND_(pcc_context_t *ctx);

static pcc_thunk_chunk_t *pcc_evaluate_rule_file(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "file", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_file_0, 0, 0);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_TLSS, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_moduleDeclaration, &chunk->thunks, NULL)) goto L0003;
        goto L0004;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0004:;
    }
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_TLSS, &chunk->thunks, NULL)) goto L0005;
        goto L0006;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0006:;
    }
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_mainTopLevelStatements, &chunk->thunks, NULL)) goto L0007;
        goto L0008;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0008:;
    }
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_TLSS, &chunk->thunks, NULL)) goto L0009;
        goto L0010;
    L0009:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0010:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EOF, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "file", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "file", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_mainTopLevelStatements(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "mainTopLevelStatements", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_topLevelStatement, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_TLSS, &chunk->thunks, NULL)) goto L0001;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_topLevelStatement, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "mainTopLevelStatements", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "mainTopLevelStatements", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_topLevelStatement(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "topLevelStatement", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_importStatement, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeAlias, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_customType, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_portDeclaration, &chunk->thunks, NULL)) goto L0005;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_functionWithTypeAnnotation, &chunk->thunks, NULL)) goto L0006;
        goto L0001;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_functionDefinition, &chunk->thunks, NULL)) goto L0007;
        goto L0001;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ignoreRestOfStatement, &chunk->thunks, NULL)) goto L0008;
        goto L0001;
    L0008:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "topLevelStatement", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "topLevelStatement", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_moduleDeclaration(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "moduleDeclaration", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 1);
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 4) < 4 ||
            (ctx->buffer.buf + ctx->cur)[0] != 'p' ||
            (ctx->buffer.buf + ctx->cur)[1] != 'o' ||
            (ctx->buffer.buf + ctx->cur)[2] != 'r' ||
            (ctx->buffer.buf + ctx->cur)[3] != 't'
        ) goto L0001;
        ctx->cur += 4;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__1_, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    if (
        pcc_refill_buffer(ctx, 6) < 6 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'm' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'o' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'd' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'u' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'l' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'e'
    ) goto L0000;
    ctx->cur += 6;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__1_, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_dottedIdentifier, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__1_, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 8) < 8 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'x' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'p' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'o' ||
        (ctx->buffer.buf + ctx->cur)[4] != 's' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[6] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[7] != 'g'
    ) goto L0000;
    ctx->cur += 8;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '('
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_exposedList, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != ')'
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EOS, &chunk->thunks, NULL)) goto L0000;
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_moduleDeclaration_0, 0, 1);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "moduleDeclaration", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "moduleDeclaration", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_exposedList(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "exposedList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_exposedItem, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (
                pcc_refill_buffer(ctx, 1) < 1 ||
                ctx->buffer.buf[ctx->cur] != ','
            ) goto L0001;
            ctx->cur++;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0001;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_exposedList, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "exposedList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "exposedList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_exposedItem(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "exposedItem", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_exposedFieldOrType, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_exposedFunction, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_exposedItemIgnored, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "exposedItem", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "exposedItem", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_exposedFieldOrType(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "exposedFieldOrType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 1);
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_upperStartIdentifier, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0001;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '('
        ) goto L0001;
        ctx->cur++;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0001;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_exposedTypeConstructorList, &chunk->thunks, NULL)) goto L0001;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0001;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != ')'
        ) goto L0001;
        ctx->cur++;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "exposedFieldOrType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "exposedFieldOrType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_exposedFunction(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "exposedFunction", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_lowerStartIdentifier, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "exposedFunction", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "exposedFunction", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_exposedItemIgnored(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "exposedItemIgnored", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p0 = ctx->cur;
        const size_t n0 = chunk->thunks.len;
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (
                pcc_refill_buffer(ctx, 1) < 1 ||
                ctx->buffer.buf[ctx->cur] != '.'
            ) goto L0001;
            ctx->cur++;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
        if (i < 1) {
            ctx->cur = p0;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
            goto L0000;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "exposedItemIgnored", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "exposedItemIgnored", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_exposedTypeConstructorList(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "exposedTypeConstructorList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_upperStartIdentifier, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_exposedItemIgnored, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (
                pcc_refill_buffer(ctx, 1) < 1 ||
                ctx->buffer.buf[ctx->cur] != ','
            ) goto L0004;
            ctx->cur++;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0004;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_exposedTypeConstructorList, &chunk->thunks, NULL)) goto L0004;
            if (ctx->cur == p) break;
            continue;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "exposedTypeConstructorList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "exposedTypeConstructorList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_typeAlias(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "typeAlias", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 1);
    if (
        pcc_refill_buffer(ctx, 4) < 4 ||
        (ctx->buffer.buf + ctx->cur)[0] != 't' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'y' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'p' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'e'
    ) goto L0000;
    ctx->cur += 4;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__1_, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 5) < 5 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'l' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[4] != 's'
    ) goto L0000;
    ctx->cur += 5;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__1_, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_upperStartIdentifier, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '='
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ignoreRestOfStatement, &chunk->thunks, NULL)) goto L0000;
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_typeAlias_0, 0, 1);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "typeAlias", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "typeAlias", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_customType(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "customType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 1);
    if (
        pcc_refill_buffer(ctx, 4) < 4 ||
        (ctx->buffer.buf + ctx->cur)[0] != 't' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'y' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'p' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'e'
    ) goto L0000;
    ctx->cur += 4;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__1_, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_upperStartIdentifier, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0001;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeParameterList, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '='
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_customType_0, 0, 1);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_constructorList, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EOS, &chunk->thunks, NULL)) goto L0000;
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_customType_1, 0, 1);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "customType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "customType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_typeParameterList(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "typeParameterList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_lowerStartIdentifier, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__1_, &chunk->thunks, NULL)) goto L0001;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_lowerStartIdentifier, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "typeParameterList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "typeParameterList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_constructorList(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "constructorList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 2);
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_upperStartIdentifier, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_constructorList_0, 0, 2);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        {
            const size_t p = ctx->cur;
            size_t q;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_constructorSubtypeList, &chunk->thunks, NULL)) goto L0001;
            q = ctx->cur;
            chunk->capts.buf[1].range.start = p;
            chunk->capts.buf[1].range.end = q;
        }
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_constructorList_1, 0, 2);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capts.buf[1] = &(chunk->capts.buf[1]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '|'
        ) goto L0003;
        ctx->cur++;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0003;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_constructorList, &chunk->thunks, NULL)) goto L0003;
        goto L0004;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0004:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "constructorList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "constructorList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_constructorSubtypeList(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "constructorSubtypeList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_singleConstructorSubtypeSpec, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0001;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_singleConstructorSubtypeSpec, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "constructorSubtypeList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "constructorSubtypeList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_singleConstructorSubtypeSpec(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "singleConstructorSubtypeSpec", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 1);
    {
        const size_t p = ctx->cur;
        size_t q;
        {
            MARK_VAR_AS_USED
            const size_t p = ctx->cur;
            MARK_VAR_AS_USED
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_recordTypeSpec, &chunk->thunks, NULL)) goto L0002;
            goto L0001;
        L0002:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_tupleTypeSpec, &chunk->thunks, NULL)) goto L0003;
            goto L0001;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_functionTypeSpec, &chunk->thunks, NULL)) goto L0004;
            goto L0001;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_dottedIdentifier, &chunk->thunks, NULL)) goto L0005;
            goto L0001;
        L0005:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0000;
        L0001:;
        }
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_singleConstructorSubtypeSpec_0, 0, 1);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "singleConstructorSubtypeSpec", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "singleConstructorSubtypeSpec", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_singleTypeSpec(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "singleTypeSpec", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_recordTypeSpec, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_tupleTypeSpec, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_functionTypeSpec, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_parameterisedTypeSpec, &chunk->thunks, NULL)) goto L0005;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "singleTypeSpec", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "singleTypeSpec", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_recordTypeSpec(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "recordTypeSpec", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '{'
        ) goto L0002;
        ctx->cur++;
        {
            MARK_VAR_AS_USED
            const size_t p = ctx->cur;
            MARK_VAR_AS_USED
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0003;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_recordRestrictionPrefix, &chunk->thunks, NULL)) goto L0003;
            goto L0004;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0004:;
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0002;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_fieldSpec, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0005;
                if (
                    pcc_refill_buffer(ctx, 1) < 1 ||
                    ctx->buffer.buf[ctx->cur] != ','
                ) goto L0005;
                ctx->cur++;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0005;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_fieldSpec, &chunk->thunks, NULL)) goto L0005;
                if (ctx->cur == p) break;
                continue;
            L0005:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0002;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '}'
        ) goto L0002;
        ctx->cur++;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '{'
        ) goto L0006;
        ctx->cur++;
        {
            MARK_VAR_AS_USED
            const size_t p = ctx->cur;
            MARK_VAR_AS_USED
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0007;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_recordRestrictionPrefix, &chunk->thunks, NULL)) goto L0007;
            goto L0008;
        L0007:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0008:;
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0006;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '}'
        ) goto L0006;
        ctx->cur++;
        goto L0001;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "recordTypeSpec", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "recordTypeSpec", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_recordRestrictionPrefix(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "recordRestrictionPrefix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_lowerStartIdentifier, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '|'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "recordRestrictionPrefix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "recordRestrictionPrefix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_fieldSpec(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "fieldSpec", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_lowerStartIdentifier, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != ':'
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_singleTypeSpec, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "fieldSpec", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "fieldSpec", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_tupleTypeSpec(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "tupleTypeSpec", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '('
        ) goto L0002;
        ctx->cur++;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0002;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_singleTypeSpec, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0003;
                if (
                    pcc_refill_buffer(ctx, 1) < 1 ||
                    ctx->buffer.buf[ctx->cur] != ','
                ) goto L0003;
                ctx->cur++;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0003;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_singleTypeSpec, &chunk->thunks, NULL)) goto L0003;
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0002;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != ')'
        ) goto L0002;
        ctx->cur++;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '('
        ) goto L0004;
        ctx->cur++;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0004;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != ')'
        ) goto L0004;
        ctx->cur++;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "tupleTypeSpec", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "tupleTypeSpec", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_parameterisedTypeSpec(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "parameterisedTypeSpec", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_dottedIdentifier, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__1_, &chunk->thunks, NULL)) goto L0001;
            {
                MARK_VAR_AS_USED
                const size_t p = ctx->cur;
                MARK_VAR_AS_USED
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_singleTypeSpec, &chunk->thunks, NULL)) goto L0003;
                goto L0002;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_lowerStartIdentifier, &chunk->thunks, NULL)) goto L0004;
                goto L0002;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                goto L0001;
            L0002:;
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "parameterisedTypeSpec", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "parameterisedTypeSpec", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_functionTypeSpec(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "functionTypeSpec", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_singleTypeSpec, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p0 = ctx->cur;
        const size_t n0 = chunk->thunks.len;
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0001;
            if (
                pcc_refill_buffer(ctx, 2) < 2 ||
                (ctx->buffer.buf + ctx->cur)[0] != '-' ||
                (ctx->buffer.buf + ctx->cur)[1] != '>'
            ) goto L0001;
            ctx->cur += 2;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0001;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_singleTypeSpec, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
        if (i < 1) {
            ctx->cur = p0;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
            goto L0000;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "functionTypeSpec", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "functionTypeSpec", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_portDeclaration(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "portDeclaration", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 2);
    if (
        pcc_refill_buffer(ctx, 4) < 4 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'p' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'o' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[3] != 't'
    ) goto L0000;
    ctx->cur += 4;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__1_, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_lowerStartIdentifier, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != ':'
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeAnnotation, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[1].range.start = p;
        chunk->capts.buf[1].range.end = q;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EOS, &chunk->thunks, NULL)) goto L0000;
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_portDeclaration_0, 0, 2);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capts.buf[1] = &(chunk->capts.buf[1]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "portDeclaration", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "portDeclaration", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_importStatement(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "importStatement", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 2);
    if (
        pcc_refill_buffer(ctx, 6) < 6 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'm' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'p' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'o' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[5] != 't'
    ) goto L0000;
    ctx->cur += 6;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__1_, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_dottedIdentifier, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__1_, &chunk->thunks, NULL)) goto L0001;
        if (
            pcc_refill_buffer(ctx, 2) < 2 ||
            (ctx->buffer.buf + ctx->cur)[0] != 'a' ||
            (ctx->buffer.buf + ctx->cur)[1] != 's'
        ) goto L0001;
        ctx->cur += 2;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__1_, &chunk->thunks, NULL)) goto L0001;
        {
            const size_t p = ctx->cur;
            size_t q;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_upperStartIdentifier, &chunk->thunks, NULL)) goto L0001;
            q = ctx->cur;
            chunk->capts.buf[1].range.start = p;
            chunk->capts.buf[1].range.end = q;
        }
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_importStatement_0, 0, 2);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capts.buf[1] = &(chunk->capts.buf[1]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__1_, &chunk->thunks, NULL)) goto L0003;
        if (
            pcc_refill_buffer(ctx, 8) < 8 ||
            (ctx->buffer.buf + ctx->cur)[0] != 'e' ||
            (ctx->buffer.buf + ctx->cur)[1] != 'x' ||
            (ctx->buffer.buf + ctx->cur)[2] != 'p' ||
            (ctx->buffer.buf + ctx->cur)[3] != 'o' ||
            (ctx->buffer.buf + ctx->cur)[4] != 's' ||
            (ctx->buffer.buf + ctx->cur)[5] != 'i' ||
            (ctx->buffer.buf + ctx->cur)[6] != 'n' ||
            (ctx->buffer.buf + ctx->cur)[7] != 'g'
        ) goto L0003;
        ctx->cur += 8;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0003;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '('
        ) goto L0003;
        ctx->cur++;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0003;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_importedList, &chunk->thunks, NULL)) goto L0003;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0003;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != ')'
        ) goto L0003;
        ctx->cur++;
        goto L0004;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0004:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EOS, &chunk->thunks, NULL)) goto L0000;
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_importStatement_1, 0, 2);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capts.buf[1] = &(chunk->capts.buf[1]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "importStatement", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "importStatement", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_importedList(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "importedList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_importedItem, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (
                pcc_refill_buffer(ctx, 1) < 1 ||
                ctx->buffer.buf[ctx->cur] != ','
            ) goto L0001;
            ctx->cur++;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0001;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_importedList, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "importedList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "importedList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_importedItem(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "importedItem", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_importedFunction, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_importedType, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_importedItemIgnored, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "importedItem", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "importedItem", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_importedFunction(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "importedFunction", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 1);
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_lowerStartIdentifier, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_importedFunction_0, 0, 1);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "importedFunction", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "importedFunction", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_importedType(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "importedType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 1);
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_upperStartIdentifier, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_importedType_0, 0, 1);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0001;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '('
        ) goto L0001;
        ctx->cur++;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0001;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_importedTypeConstructorList, &chunk->thunks, NULL)) goto L0001;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0001;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != ')'
        ) goto L0001;
        ctx->cur++;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_importedType_1, 0, 1);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "importedType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "importedType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_importedItemIgnored(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "importedItemIgnored", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p0 = ctx->cur;
        const size_t n0 = chunk->thunks.len;
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (
                pcc_refill_buffer(ctx, 1) < 1 ||
                ctx->buffer.buf[ctx->cur] != '.'
            ) goto L0001;
            ctx->cur++;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
        if (i < 1) {
            ctx->cur = p0;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
            goto L0000;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "importedItemIgnored", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "importedItemIgnored", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_importedTypeConstructorList(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "importedTypeConstructorList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_importedTypeConstructor, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_importedItemIgnored, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (
                pcc_refill_buffer(ctx, 1) < 1 ||
                ctx->buffer.buf[ctx->cur] != ','
            ) goto L0004;
            ctx->cur++;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0004;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_importedTypeConstructorList, &chunk->thunks, NULL)) goto L0004;
            if (ctx->cur == p) break;
            continue;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "importedTypeConstructorList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "importedTypeConstructorList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_importedTypeConstructor(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "importedTypeConstructor", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 1);
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_upperStartIdentifier, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_importedTypeConstructor_0, 0, 1);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "importedTypeConstructor", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "importedTypeConstructor", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_functionWithTypeAnnotation(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "functionWithTypeAnnotation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 4);
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_lowerStartIdentifier, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != ':'
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeAnnotation, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[1].range.start = p;
        chunk->capts.buf[1].range.end = q;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_TLSS, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        size_t q;
        {
            const size_t n = chunk->capts.buf[0].range.end - chunk->capts.buf[0].range.start;
            if (pcc_refill_buffer(ctx, n) < n) goto L0000;
            if (n > 0) {
                const char *const p = ctx->buffer.buf + ctx->cur;
                const char *const q = ctx->buffer.buf + chunk->capts.buf[0].range.start;
                size_t i;
                for (i = 0; i < n; i++) {
                    if (p[i] != q[i]) goto L0000;
                }
                ctx->cur += n;
            }
        }
        q = ctx->cur;
        chunk->capts.buf[2].range.start = p;
        chunk->capts.buf[2].range.end = q;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__1_, &chunk->thunks, NULL)) goto L0000;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        {
            const size_t p = ctx->cur;
            size_t q;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_functionParameterList, &chunk->thunks, NULL)) goto L0001;
            q = ctx->cur;
            chunk->capts.buf[3].range.start = p;
            chunk->capts.buf[3].range.end = q;
        }
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_functionWithTypeAnnotation_0, 0, 4);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capts.buf[1] = &(chunk->capts.buf[1]);
        thunk->data.leaf.capts.buf[2] = &(chunk->capts.buf[2]);
        thunk->data.leaf.capts.buf[3] = &(chunk->capts.buf[3]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '='
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EOS, &chunk->thunks, NULL)) goto L0000;
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_functionWithTypeAnnotation_1, 0, 4);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capts.buf[1] = &(chunk->capts.buf[1]);
        thunk->data.leaf.capts.buf[2] = &(chunk->capts.buf[2]);
        thunk->data.leaf.capts.buf[3] = &(chunk->capts.buf[3]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "functionWithTypeAnnotation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "functionWithTypeAnnotation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_typeAnnotation(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "typeAnnotation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_singleTypeSpec, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0001;
            if (
                pcc_refill_buffer(ctx, 2) < 2 ||
                (ctx->buffer.buf + ctx->cur)[0] != '-' ||
                (ctx->buffer.buf + ctx->cur)[1] != '>'
            ) goto L0001;
            ctx->cur += 2;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0001;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_singleTypeSpec, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "typeAnnotation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "typeAnnotation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_functionDefinition(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "functionDefinition", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 2);
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_nonKeywordIdentifier, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        {
            const size_t p = ctx->cur;
            size_t q;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_functionParameterList, &chunk->thunks, NULL)) goto L0001;
            q = ctx->cur;
            chunk->capts.buf[1].range.start = p;
            chunk->capts.buf[1].range.end = q;
        }
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_functionDefinition_0, 0, 2);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capts.buf[1] = &(chunk->capts.buf[1]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '='
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EOS, &chunk->thunks, NULL)) goto L0000;
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_functionDefinition_1, 0, 2);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capts.buf[1] = &(chunk->capts.buf[1]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "functionDefinition", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "functionDefinition", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_functionParameterList(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "functionParameterList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_functionParameter, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0001;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_functionParameter, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "functionParameterList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "functionParameterList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_functionParameter(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "functionParameter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_plainFunctionParameter, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_tupleFunctionParameter, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_recordFunctionParameter, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_constructorFunctionParameter, &chunk->thunks, NULL)) goto L0005;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "functionParameter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "functionParameter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_plainFunctionParameter(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "plainFunctionParameter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_lowerStartIdentifier, &chunk->thunks, NULL)) goto L0000;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0001;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_asClause, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "plainFunctionParameter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "plainFunctionParameter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_tupleFunctionParameter(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "tupleFunctionParameter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '('
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_functionParameter, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0001;
            if (
                pcc_refill_buffer(ctx, 1) < 1 ||
                ctx->buffer.buf[ctx->cur] != ','
            ) goto L0001;
            ctx->cur++;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0001;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_functionParameter, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != ')'
    ) goto L0000;
    ctx->cur++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0002;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_asClause, &chunk->thunks, NULL)) goto L0002;
        goto L0003;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0003:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "tupleFunctionParameter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "tupleFunctionParameter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_recordFunctionParameter(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "recordFunctionParameter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '{'
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_lowerStartIdentifier, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0001;
            if (
                pcc_refill_buffer(ctx, 1) < 1 ||
                ctx->buffer.buf[ctx->cur] != ','
            ) goto L0001;
            ctx->cur++;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0001;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_lowerStartIdentifier, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '}'
    ) goto L0000;
    ctx->cur++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0002;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_asClause, &chunk->thunks, NULL)) goto L0002;
        goto L0003;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0003:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "recordFunctionParameter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "recordFunctionParameter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_constructorFunctionParameter(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "constructorFunctionParameter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_upperStartIdentifier, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0001;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_functionParameter, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0002;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_asClause, &chunk->thunks, NULL)) goto L0002;
        goto L0003;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0003:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "constructorFunctionParameter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "constructorFunctionParameter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_asClause(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "asClause", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[1] != 's'
    ) goto L0000;
    ctx->cur += 2;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__1_, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_lowerStartIdentifier, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "asClause", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "asClause", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_expression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "expression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_letInBlock, &chunk->thunks, NULL)) goto L0001;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__NL_IND_, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleExpression, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0003;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_binaryOperator, &chunk->thunks, NULL)) goto L0003;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0003;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0003;
            if (ctx->cur == p) break;
            continue;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "expression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "expression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_simpleExpression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "simpleExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_hexNumber, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_decimal, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_multilineString, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_characterLiteral, &chunk->thunks, NULL)) goto L0005;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_oneLineString, &chunk->thunks, NULL)) goto L0006;
        goto L0001;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_tupleExpression, &chunk->thunks, NULL)) goto L0007;
        goto L0001;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_listExpression, &chunk->thunks, NULL)) goto L0008;
        goto L0001;
    L0008:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_recordExpression, &chunk->thunks, NULL)) goto L0009;
        goto L0001;
    L0009:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_caseStatement, &chunk->thunks, NULL)) goto L0010;
        goto L0001;
    L0010:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ifThenElseStatement, &chunk->thunks, NULL)) goto L0011;
        goto L0001;
    L0011:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_anonymousFunction, &chunk->thunks, NULL)) goto L0012;
        goto L0001;
    L0012:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_functionCall, &chunk->thunks, NULL)) goto L0013;
        goto L0001;
    L0013:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "simpleExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "simpleExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_tupleExpression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "tupleExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '('
        ) goto L0002;
        ctx->cur++;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0002;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0003;
                if (
                    pcc_refill_buffer(ctx, 1) < 1 ||
                    ctx->buffer.buf[ctx->cur] != ','
                ) goto L0003;
                ctx->cur++;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0003;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0003;
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0002;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != ')'
        ) goto L0002;
        ctx->cur++;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '('
        ) goto L0004;
        ctx->cur++;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0004;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != ')'
        ) goto L0004;
        ctx->cur++;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "tupleExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "tupleExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_listExpression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "listExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '['
        ) goto L0002;
        ctx->cur++;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0002;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0003;
                if (
                    pcc_refill_buffer(ctx, 1) < 1 ||
                    ctx->buffer.buf[ctx->cur] != ','
                ) goto L0003;
                ctx->cur++;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0003;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0003;
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0002;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != ']'
        ) goto L0002;
        ctx->cur++;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '['
        ) goto L0004;
        ctx->cur++;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0004;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != ']'
        ) goto L0004;
        ctx->cur++;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "listExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "listExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_recordExpression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "recordExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '{'
        ) goto L0002;
        ctx->cur++;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0002;
        {
            MARK_VAR_AS_USED
            const size_t p = ctx->cur;
            MARK_VAR_AS_USED
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_lowerStartIdentifier, &chunk->thunks, NULL)) goto L0003;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0003;
            if (
                pcc_refill_buffer(ctx, 1) < 1 ||
                ctx->buffer.buf[ctx->cur] != '|'
            ) goto L0003;
            ctx->cur++;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0003;
            goto L0004;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0004:;
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_recordExpressionAssignment, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0005;
                if (
                    pcc_refill_buffer(ctx, 1) < 1 ||
                    ctx->buffer.buf[ctx->cur] != ','
                ) goto L0005;
                ctx->cur++;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0005;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_recordExpressionAssignment, &chunk->thunks, NULL)) goto L0005;
                if (ctx->cur == p) break;
                continue;
            L0005:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0002;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '}'
        ) goto L0002;
        ctx->cur++;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '{'
        ) goto L0006;
        ctx->cur++;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0006;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '}'
        ) goto L0006;
        ctx->cur++;
        goto L0001;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "recordExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "recordExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_recordExpressionAssignment(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "recordExpressionAssignment", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_lowerStartIdentifier, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '='
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "recordExpressionAssignment", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "recordExpressionAssignment", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_anonymousFunction(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "anonymousFunction", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '\\'
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_functionParameterList, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != '-' ||
        (ctx->buffer.buf + ctx->cur)[1] != '>'
    ) goto L0000;
    ctx->cur += 2;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "anonymousFunction", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "anonymousFunction", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_functionCall(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "functionCall", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_dottedIdentifier, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '.'
        ) goto L0003;
        ctx->cur++;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_lowerStartIdentifier, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '('
        ) goto L0004;
        ctx->cur++;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_binaryOperator, &chunk->thunks, NULL)) goto L0004;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != ')'
        ) goto L0004;
        ctx->cur++;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__1_, &chunk->thunks, NULL)) goto L0005;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0005;
            if (ctx->cur == p) break;
            continue;
        L0005:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "functionCall", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "functionCall", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_letInBlock(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "letInBlock", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 3) < 3 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'l' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[2] != 't'
    ) goto L0000;
    ctx->cur += 3;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__NL_IND_, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_letInLine, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__NL_IND_, &chunk->thunks, NULL)) goto L0001;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_letInLine, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__NL_IND_, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'n'
    ) goto L0000;
    ctx->cur += 2;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "letInBlock", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "letInBlock", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_letInLine(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "letInLine", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_letInFunctionDefinition, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_letInBlock, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_letInFunctionBody, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "letInLine", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "letInLine", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_letInFunctionDefinition(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "letInFunctionDefinition", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 2);
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_nonKeywordIdentifier, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_WS, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        {
            const size_t p = ctx->cur;
            size_t q;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_letInFunctionParameters, &chunk->thunks, NULL)) goto L0002;
            q = ctx->cur;
            chunk->capts.buf[1].range.start = p;
            chunk->capts.buf[1].range.end = q;
        }
        goto L0003;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0003:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_WS, &chunk->thunks, NULL)) goto L0004;
            if (ctx->cur == p) break;
            continue;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '='
    ) goto L0000;
    ctx->cur++;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Non_NL, &chunk->thunks, NULL)) goto L0005;
            if (ctx->cur == p) break;
            continue;
        L0005:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_letInFunctionDefinition_0, 0, 2);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capts.buf[1] = &(chunk->capts.buf[1]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "letInFunctionDefinition", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "letInFunctionDefinition", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_letInFunctionParameters(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "letInFunctionParameters", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_nonKeywordIdentifier, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                const size_t p0 = ctx->cur;
                const size_t n0 = chunk->thunks.len;
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_WS, &chunk->thunks, NULL)) goto L0002;
                    if (ctx->cur == p) break;
                    continue;
                L0002:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
                if (i < 1) {
                    ctx->cur = p0;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
                    goto L0001;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_nonKeywordIdentifier, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "letInFunctionParameters", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "letInFunctionParameters", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_letInFunctionBody(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "letInFunctionBody", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        {
            MARK_VAR_AS_USED
            const size_t p = ctx->cur;
            MARK_VAR_AS_USED
            const size_t n = chunk->thunks.len;
            if (
                pcc_refill_buffer(ctx, 3) < 3 ||
                (ctx->buffer.buf + ctx->cur)[0] != 'l' ||
                (ctx->buffer.buf + ctx->cur)[1] != 'e' ||
                (ctx->buffer.buf + ctx->cur)[2] != 't'
            ) goto L0003;
            ctx->cur += 3;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (
                pcc_refill_buffer(ctx, 2) < 2 ||
                (ctx->buffer.buf + ctx->cur)[0] != 'i' ||
                (ctx->buffer.buf + ctx->cur)[1] != 'n'
            ) goto L0004;
            ctx->cur += 2;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    {
        const size_t p0 = ctx->cur;
        const size_t n0 = chunk->thunks.len;
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Non_NL, &chunk->thunks, NULL)) goto L0005;
            if (ctx->cur == p) break;
            continue;
        L0005:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
        if (i < 1) {
            ctx->cur = p0;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
            goto L0000;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "letInFunctionBody", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "letInFunctionBody", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_caseStatement(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "caseStatement", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 4) < 4 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'c' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[2] != 's' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'e'
    ) goto L0000;
    ctx->cur += 4;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__1_, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'o' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'f'
    ) goto L0000;
    ctx->cur += 2;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__1_, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_caseClauseList, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "caseStatement", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "caseStatement", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_caseClauseList(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "caseClauseList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_caseClause, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__1_, &chunk->thunks, NULL)) goto L0001;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_caseClause, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "caseClauseList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "caseClauseList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_caseClause(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "caseClause", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_roughCasePatternChar, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != '-' ||
        (ctx->buffer.buf + ctx->cur)[1] != '>'
    ) goto L0000;
    ctx->cur += 2;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__0_, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "caseClause", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "caseClause", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_roughCasePatternChar(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "roughCasePatternChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        {
            MARK_VAR_AS_USED
            const size_t p = ctx->cur;
            MARK_VAR_AS_USED
            const size_t n = chunk->thunks.len;
            if (
                pcc_refill_buffer(ctx, 2) < 2 ||
                (ctx->buffer.buf + ctx->cur)[0] != '-' ||
                (ctx->buffer.buf + ctx->cur)[1] != '>'
            ) goto L0003;
            ctx->cur += 2;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_TLSS, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_lineComment, &chunk->thunks, NULL)) goto L0005;
            goto L0002;
        L0005:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_delimitedComment, &chunk->thunks, NULL)) goto L0006;
            goto L0002;
        L0006:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0007;
            goto L0002;
        L0007:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    {
        int u;
        const size_t n = pcc_get_char_as_utf32(ctx, &u);
        if (n == 0) goto L0000;
        ctx->cur += n;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "roughCasePatternChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "roughCasePatternChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_ifThenElseStatement(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "ifThenElseStatement", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'f'
    ) goto L0000;
    ctx->cur += 2;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__1_, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__1_, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 4) < 4 ||
        (ctx->buffer.buf + ctx->cur)[0] != 't' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'h' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'n'
    ) goto L0000;
    ctx->cur += 4;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__1_, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__1_, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 4) < 4 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'l' ||
        (ctx->buffer.buf + ctx->cur)[2] != 's' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'e'
    ) goto L0000;
    ctx->cur += 4;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__1_, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "ifThenElseStatement", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "ifThenElseStatement", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_binaryOperator(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "binaryOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 2) < 2 ||
            (ctx->buffer.buf + ctx->cur)[0] != '>' ||
            (ctx->buffer.buf + ctx->cur)[1] != '>'
        ) goto L0002;
        ctx->cur += 2;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 2) < 2 ||
            (ctx->buffer.buf + ctx->cur)[0] != '<' ||
            (ctx->buffer.buf + ctx->cur)[1] != '<'
        ) goto L0003;
        ctx->cur += 2;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 2) < 2 ||
            (ctx->buffer.buf + ctx->cur)[0] != '|' ||
            (ctx->buffer.buf + ctx->cur)[1] != '>'
        ) goto L0004;
        ctx->cur += 2;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 2) < 2 ||
            (ctx->buffer.buf + ctx->cur)[0] != '<' ||
            (ctx->buffer.buf + ctx->cur)[1] != '|'
        ) goto L0005;
        ctx->cur += 2;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 2) < 2 ||
            (ctx->buffer.buf + ctx->cur)[0] != '/' ||
            (ctx->buffer.buf + ctx->cur)[1] != '/'
        ) goto L0006;
        ctx->cur += 2;
        goto L0001;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 2) < 2 ||
            (ctx->buffer.buf + ctx->cur)[0] != '+' ||
            (ctx->buffer.buf + ctx->cur)[1] != '+'
        ) goto L0007;
        ctx->cur += 2;
        goto L0001;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 2) < 2 ||
            (ctx->buffer.buf + ctx->cur)[0] != ':' ||
            (ctx->buffer.buf + ctx->cur)[1] != ':'
        ) goto L0008;
        ctx->cur += 2;
        goto L0001;
    L0008:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 2) < 2 ||
            (ctx->buffer.buf + ctx->cur)[0] != '=' ||
            (ctx->buffer.buf + ctx->cur)[1] != '='
        ) goto L0009;
        ctx->cur += 2;
        goto L0001;
    L0009:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 2) < 2 ||
            (ctx->buffer.buf + ctx->cur)[0] != '/' ||
            (ctx->buffer.buf + ctx->cur)[1] != '='
        ) goto L0010;
        ctx->cur += 2;
        goto L0001;
    L0010:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 2) < 2 ||
            (ctx->buffer.buf + ctx->cur)[0] != '&' ||
            (ctx->buffer.buf + ctx->cur)[1] != '&'
        ) goto L0011;
        ctx->cur += 2;
        goto L0001;
    L0011:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 2) < 2 ||
            (ctx->buffer.buf + ctx->cur)[0] != '|' ||
            (ctx->buffer.buf + ctx->cur)[1] != '|'
        ) goto L0012;
        ctx->cur += 2;
        goto L0001;
    L0012:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 2) < 2 ||
            (ctx->buffer.buf + ctx->cur)[0] != '<' ||
            (ctx->buffer.buf + ctx->cur)[1] != '='
        ) goto L0013;
        ctx->cur += 2;
        goto L0001;
    L0013:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 2) < 2 ||
            (ctx->buffer.buf + ctx->cur)[0] != '>' ||
            (ctx->buffer.buf + ctx->cur)[1] != '='
        ) goto L0014;
        ctx->cur += 2;
        goto L0001;
    L0014:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '<'
        ) goto L0015;
        ctx->cur++;
        goto L0001;
    L0015:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '>'
        ) goto L0016;
        ctx->cur++;
        goto L0001;
    L0016:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '+'
        ) goto L0017;
        ctx->cur++;
        goto L0001;
    L0017:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '-'
        ) goto L0018;
        ctx->cur++;
        goto L0001;
    L0018:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '*'
        ) goto L0019;
        ctx->cur++;
        goto L0001;
    L0019:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '/'
        ) goto L0020;
        ctx->cur++;
        goto L0001;
    L0020:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '^'
        ) goto L0021;
        ctx->cur++;
        goto L0001;
    L0021:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "binaryOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "binaryOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_ignoreRestOfStatement(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "ignoreRestOfStatement", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_multilineString, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        {
            const size_t p0 = ctx->cur;
            const size_t n0 = chunk->thunks.len;
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Non_WS_or_NL, &chunk->thunks, NULL)) goto L0004;
                if (ctx->cur == p) break;
                continue;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
            if (i < 1) {
                ctx->cur = p0;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
                goto L0003;
            }
        }
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__1_, &chunk->thunks, NULL)) goto L0005;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ignoreRestOfStatement, &chunk->thunks, NULL)) goto L0005;
            if (ctx->cur == p) break;
            continue;
        L0005:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "ignoreRestOfStatement", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "ignoreRestOfStatement", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_multilineString(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "multilineString", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 3) < 3 ||
        (ctx->buffer.buf + ctx->cur)[0] != '\"' ||
        (ctx->buffer.buf + ctx->cur)[1] != '\"' ||
        (ctx->buffer.buf + ctx->cur)[2] != '\"'
    ) goto L0000;
    ctx->cur += 3;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                const size_t p = ctx->cur;
                if (
                    pcc_refill_buffer(ctx, 3) < 3 ||
                    (ctx->buffer.buf + ctx->cur)[0] != '\"' ||
                    (ctx->buffer.buf + ctx->cur)[1] != '\"' ||
                    (ctx->buffer.buf + ctx->cur)[2] != '\"'
                ) goto L0002;
                ctx->cur += 3;
                ctx->cur = p;
                goto L0001;
            L0002:;
                ctx->cur = p;
            }
            {
                int u;
                const size_t n = pcc_get_char_as_utf32(ctx, &u);
                if (n == 0) goto L0001;
                ctx->cur += n;
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (
        pcc_refill_buffer(ctx, 3) < 3 ||
        (ctx->buffer.buf + ctx->cur)[0] != '\"' ||
        (ctx->buffer.buf + ctx->cur)[1] != '\"' ||
        (ctx->buffer.buf + ctx->cur)[2] != '\"'
    ) goto L0000;
    ctx->cur += 3;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "multilineString", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "multilineString", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_naiveIdentifier(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "naiveIdentifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int u;
        const size_t n = pcc_get_char_as_utf32(ctx, &u);
        if (n == 0) goto L0000;
        if (!(
            (u >= 0x000041 && u <= 0x00005a) ||
            (u >= 0x000061 && u <= 0x00007a) ||
            u == 0x00005f
        )) goto L0000;
        ctx->cur += n;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_alphanumeric, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "naiveIdentifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "naiveIdentifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_upperStartIdentifier(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "upperStartIdentifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int u;
        const size_t n = pcc_get_char_as_utf32(ctx, &u);
        if (n == 0) goto L0000;
        if (!(
            (u >= 0x000041 && u <= 0x00005a)
        )) goto L0000;
        ctx->cur += n;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_alphanumeric, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "upperStartIdentifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "upperStartIdentifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_lowerStartIdentifier(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "lowerStartIdentifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_keyword, &chunk->thunks, NULL)) goto L0001;
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    {
        int u;
        const size_t n = pcc_get_char_as_utf32(ctx, &u);
        if (n == 0) goto L0000;
        if (!(
            (u >= 0x000061 && u <= 0x00007a) ||
            u == 0x00005f
        )) goto L0000;
        ctx->cur += n;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_alphanumeric, &chunk->thunks, NULL)) goto L0002;
            if (ctx->cur == p) break;
            continue;
        L0002:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "lowerStartIdentifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "lowerStartIdentifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_alphanumeric(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "alphanumeric", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int u;
        const size_t n = pcc_get_char_as_utf32(ctx, &u);
        if (n == 0) goto L0000;
        if (!(
            (u >= 0x000041 && u <= 0x00005a) ||
            (u >= 0x000061 && u <= 0x00007a) ||
            (u >= 0x000030 && u <= 0x000039) ||
            u == 0x00005f
        )) goto L0000;
        ctx->cur += n;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "alphanumeric", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "alphanumeric", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_nonKeywordIdentifier(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "nonKeywordIdentifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_keyword, &chunk->thunks, NULL)) goto L0001;
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_naiveIdentifier, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "nonKeywordIdentifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "nonKeywordIdentifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_keyword(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "keyword", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 4) < 4 ||
            (ctx->buffer.buf + ctx->cur)[0] != 't' ||
            (ctx->buffer.buf + ctx->cur)[1] != 'y' ||
            (ctx->buffer.buf + ctx->cur)[2] != 'p' ||
            (ctx->buffer.buf + ctx->cur)[3] != 'e'
        ) goto L0002;
        ctx->cur += 4;
        {
            const size_t p = ctx->cur;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_alphanumeric, &chunk->thunks, NULL)) goto L0003;
            ctx->cur = p;
            goto L0002;
        L0003:;
            ctx->cur = p;
        }
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 6) < 6 ||
            (ctx->buffer.buf + ctx->cur)[0] != 'm' ||
            (ctx->buffer.buf + ctx->cur)[1] != 'o' ||
            (ctx->buffer.buf + ctx->cur)[2] != 'd' ||
            (ctx->buffer.buf + ctx->cur)[3] != 'u' ||
            (ctx->buffer.buf + ctx->cur)[4] != 'l' ||
            (ctx->buffer.buf + ctx->cur)[5] != 'e'
        ) goto L0004;
        ctx->cur += 6;
        {
            const size_t p = ctx->cur;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_alphanumeric, &chunk->thunks, NULL)) goto L0005;
            ctx->cur = p;
            goto L0004;
        L0005:;
            ctx->cur = p;
        }
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 4) < 4 ||
            (ctx->buffer.buf + ctx->cur)[0] != 'p' ||
            (ctx->buffer.buf + ctx->cur)[1] != 'o' ||
            (ctx->buffer.buf + ctx->cur)[2] != 'r' ||
            (ctx->buffer.buf + ctx->cur)[3] != 't'
        ) goto L0006;
        ctx->cur += 4;
        {
            const size_t p = ctx->cur;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_alphanumeric, &chunk->thunks, NULL)) goto L0007;
            ctx->cur = p;
            goto L0006;
        L0007:;
            ctx->cur = p;
        }
        goto L0001;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 5) < 5 ||
            (ctx->buffer.buf + ctx->cur)[0] != 'a' ||
            (ctx->buffer.buf + ctx->cur)[1] != 'l' ||
            (ctx->buffer.buf + ctx->cur)[2] != 'i' ||
            (ctx->buffer.buf + ctx->cur)[3] != 'a' ||
            (ctx->buffer.buf + ctx->cur)[4] != 's'
        ) goto L0008;
        ctx->cur += 5;
        {
            const size_t p = ctx->cur;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_alphanumeric, &chunk->thunks, NULL)) goto L0009;
            ctx->cur = p;
            goto L0008;
        L0009:;
            ctx->cur = p;
        }
        goto L0001;
    L0008:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 2) < 2 ||
            (ctx->buffer.buf + ctx->cur)[0] != 'a' ||
            (ctx->buffer.buf + ctx->cur)[1] != 's'
        ) goto L0010;
        ctx->cur += 2;
        {
            const size_t p = ctx->cur;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_alphanumeric, &chunk->thunks, NULL)) goto L0011;
            ctx->cur = p;
            goto L0010;
        L0011:;
            ctx->cur = p;
        }
        goto L0001;
    L0010:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 8) < 8 ||
            (ctx->buffer.buf + ctx->cur)[0] != 'e' ||
            (ctx->buffer.buf + ctx->cur)[1] != 'x' ||
            (ctx->buffer.buf + ctx->cur)[2] != 'p' ||
            (ctx->buffer.buf + ctx->cur)[3] != 'o' ||
            (ctx->buffer.buf + ctx->cur)[4] != 's' ||
            (ctx->buffer.buf + ctx->cur)[5] != 'i' ||
            (ctx->buffer.buf + ctx->cur)[6] != 'n' ||
            (ctx->buffer.buf + ctx->cur)[7] != 'g'
        ) goto L0012;
        ctx->cur += 8;
        {
            const size_t p = ctx->cur;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_alphanumeric, &chunk->thunks, NULL)) goto L0013;
            ctx->cur = p;
            goto L0012;
        L0013:;
            ctx->cur = p;
        }
        goto L0001;
    L0012:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 6) < 6 ||
            (ctx->buffer.buf + ctx->cur)[0] != 'i' ||
            (ctx->buffer.buf + ctx->cur)[1] != 'm' ||
            (ctx->buffer.buf + ctx->cur)[2] != 'p' ||
            (ctx->buffer.buf + ctx->cur)[3] != 'o' ||
            (ctx->buffer.buf + ctx->cur)[4] != 'r' ||
            (ctx->buffer.buf + ctx->cur)[5] != 't'
        ) goto L0014;
        ctx->cur += 6;
        {
            const size_t p = ctx->cur;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_alphanumeric, &chunk->thunks, NULL)) goto L0015;
            ctx->cur = p;
            goto L0014;
        L0015:;
            ctx->cur = p;
        }
        goto L0001;
    L0014:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 3) < 3 ||
            (ctx->buffer.buf + ctx->cur)[0] != 'l' ||
            (ctx->buffer.buf + ctx->cur)[1] != 'e' ||
            (ctx->buffer.buf + ctx->cur)[2] != 't'
        ) goto L0016;
        ctx->cur += 3;
        {
            const size_t p = ctx->cur;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_alphanumeric, &chunk->thunks, NULL)) goto L0017;
            ctx->cur = p;
            goto L0016;
        L0017:;
            ctx->cur = p;
        }
        goto L0001;
    L0016:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 2) < 2 ||
            (ctx->buffer.buf + ctx->cur)[0] != 'i' ||
            (ctx->buffer.buf + ctx->cur)[1] != 'n'
        ) goto L0018;
        ctx->cur += 2;
        {
            const size_t p = ctx->cur;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_alphanumeric, &chunk->thunks, NULL)) goto L0019;
            ctx->cur = p;
            goto L0018;
        L0019:;
            ctx->cur = p;
        }
        goto L0001;
    L0018:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 4) < 4 ||
            (ctx->buffer.buf + ctx->cur)[0] != 'c' ||
            (ctx->buffer.buf + ctx->cur)[1] != 'a' ||
            (ctx->buffer.buf + ctx->cur)[2] != 's' ||
            (ctx->buffer.buf + ctx->cur)[3] != 'e'
        ) goto L0020;
        ctx->cur += 4;
        {
            const size_t p = ctx->cur;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_alphanumeric, &chunk->thunks, NULL)) goto L0021;
            ctx->cur = p;
            goto L0020;
        L0021:;
            ctx->cur = p;
        }
        goto L0001;
    L0020:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 2) < 2 ||
            (ctx->buffer.buf + ctx->cur)[0] != 'o' ||
            (ctx->buffer.buf + ctx->cur)[1] != 'f'
        ) goto L0022;
        ctx->cur += 2;
        {
            const size_t p = ctx->cur;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_alphanumeric, &chunk->thunks, NULL)) goto L0023;
            ctx->cur = p;
            goto L0022;
        L0023:;
            ctx->cur = p;
        }
        goto L0001;
    L0022:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 2) < 2 ||
            (ctx->buffer.buf + ctx->cur)[0] != 'i' ||
            (ctx->buffer.buf + ctx->cur)[1] != 'f'
        ) goto L0024;
        ctx->cur += 2;
        {
            const size_t p = ctx->cur;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_alphanumeric, &chunk->thunks, NULL)) goto L0025;
            ctx->cur = p;
            goto L0024;
        L0025:;
            ctx->cur = p;
        }
        goto L0001;
    L0024:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 4) < 4 ||
            (ctx->buffer.buf + ctx->cur)[0] != 't' ||
            (ctx->buffer.buf + ctx->cur)[1] != 'h' ||
            (ctx->buffer.buf + ctx->cur)[2] != 'e' ||
            (ctx->buffer.buf + ctx->cur)[3] != 'n'
        ) goto L0026;
        ctx->cur += 4;
        {
            const size_t p = ctx->cur;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_alphanumeric, &chunk->thunks, NULL)) goto L0027;
            ctx->cur = p;
            goto L0026;
        L0027:;
            ctx->cur = p;
        }
        goto L0001;
    L0026:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 4) < 4 ||
            (ctx->buffer.buf + ctx->cur)[0] != 'e' ||
            (ctx->buffer.buf + ctx->cur)[1] != 'l' ||
            (ctx->buffer.buf + ctx->cur)[2] != 's' ||
            (ctx->buffer.buf + ctx->cur)[3] != 'e'
        ) goto L0028;
        ctx->cur += 4;
        {
            const size_t p = ctx->cur;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_alphanumeric, &chunk->thunks, NULL)) goto L0029;
            ctx->cur = p;
            goto L0028;
        L0029:;
            ctx->cur = p;
        }
        goto L0001;
    L0028:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "keyword", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "keyword", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_dottedIdentifier(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "dottedIdentifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_nonKeywordIdentifier, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (
                pcc_refill_buffer(ctx, 1) < 1 ||
                ctx->buffer.buf[ctx->cur] != '.'
            ) goto L0001;
            ctx->cur++;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_nonKeywordIdentifier, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "dottedIdentifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "dottedIdentifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_decimal(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "decimal", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_exponentialDecimal, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleDecimal, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "decimal", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "decimal", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_exponentialDecimal(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "exponentialDecimal", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleDecimal, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != 'e'
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleInteger, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "exponentialDecimal", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "exponentialDecimal", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_simpleDecimal(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "simpleDecimal", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleInteger, &chunk->thunks, NULL)) goto L0002;
        {
            MARK_VAR_AS_USED
            const size_t p = ctx->cur;
            MARK_VAR_AS_USED
            const size_t n = chunk->thunks.len;
            if (
                pcc_refill_buffer(ctx, 1) < 1 ||
                ctx->buffer.buf[ctx->cur] != '.'
            ) goto L0003;
            ctx->cur++;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_digits, &chunk->thunks, NULL)) goto L0003;
            goto L0004;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0004:;
        }
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '.'
        ) goto L0005;
        ctx->cur++;
        {
            const size_t p0 = ctx->cur;
            const size_t n0 = chunk->thunks.len;
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_digits, &chunk->thunks, NULL)) goto L0006;
                if (ctx->cur == p) break;
                continue;
            L0006:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
            if (i < 1) {
                ctx->cur = p0;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
                goto L0005;
            }
        }
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "simpleDecimal", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "simpleDecimal", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_simpleInteger(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "simpleInteger", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0001;
            if (!(
                u == 0x00002d ||
                u == 0x00002b
            )) goto L0001;
            ctx->cur += n;
        }
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_digits, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "simpleInteger", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "simpleInteger", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_digits(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "digits", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p0 = ctx->cur;
        const size_t n0 = chunk->thunks.len;
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int u;
                const size_t n = pcc_get_char_as_utf32(ctx, &u);
                if (n == 0) goto L0001;
                if (!(
                    (u >= 0x000030 && u <= 0x000039)
                )) goto L0001;
                ctx->cur += n;
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
        if (i < 1) {
            ctx->cur = p0;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
            goto L0000;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "digits", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "digits", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_hexNumber(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "hexNumber", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != '0' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'x'
    ) goto L0000;
    ctx->cur += 2;
    {
        const size_t p0 = ctx->cur;
        const size_t n0 = chunk->thunks.len;
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int u;
                const size_t n = pcc_get_char_as_utf32(ctx, &u);
                if (n == 0) goto L0001;
                if (!(
                    (u >= 0x000030 && u <= 0x000039) ||
                    (u >= 0x000041 && u <= 0x000046) ||
                    (u >= 0x000061 && u <= 0x000066)
                )) goto L0001;
                ctx->cur += n;
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
        if (i < 1) {
            ctx->cur = p0;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
            goto L0000;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "hexNumber", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "hexNumber", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_oneLineString(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "oneLineString", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '\"'
    ) goto L0000;
    ctx->cur++;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inStringChar, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '\"'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "oneLineString", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "oneLineString", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_characterLiteral(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "characterLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '\''
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inStringChar, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '\''
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "characterLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "characterLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_inStringChar(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "inStringChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        {
            MARK_VAR_AS_USED
            const size_t p = ctx->cur;
            MARK_VAR_AS_USED
            const size_t n = chunk->thunks.len;
            if (
                pcc_refill_buffer(ctx, 1) < 1 ||
                ctx->buffer.buf[ctx->cur] != '\"'
            ) goto L0003;
            ctx->cur++;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inStringUnicodeChar, &chunk->thunks, NULL)) goto L0006;
        goto L0005;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inStringEscapedChar, &chunk->thunks, NULL)) goto L0007;
        goto L0005;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inStringPlainChar, &chunk->thunks, NULL)) goto L0008;
        goto L0005;
    L0008:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0005:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "inStringChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "inStringChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_inStringPlainChar(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "inStringPlainChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        {
            MARK_VAR_AS_USED
            const size_t p = ctx->cur;
            MARK_VAR_AS_USED
            const size_t n = chunk->thunks.len;
            if (
                pcc_refill_buffer(ctx, 1) < 1 ||
                ctx->buffer.buf[ctx->cur] != '\"'
            ) goto L0003;
            ctx->cur++;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (
                pcc_refill_buffer(ctx, 1) < 1 ||
                ctx->buffer.buf[ctx->cur] != '\\'
            ) goto L0004;
            ctx->cur++;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0005;
            goto L0002;
        L0005:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    {
        int u;
        const size_t n = pcc_get_char_as_utf32(ctx, &u);
        if (n == 0) goto L0000;
        ctx->cur += n;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "inStringPlainChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "inStringPlainChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_inStringEscapedChar(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "inStringEscapedChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '\\'
    ) goto L0000;
    ctx->cur++;
    {
        const size_t p = ctx->cur;
        {
            MARK_VAR_AS_USED
            const size_t p = ctx->cur;
            MARK_VAR_AS_USED
            const size_t n = chunk->thunks.len;
            if (
                pcc_refill_buffer(ctx, 1) < 1 ||
                ctx->buffer.buf[ctx->cur] != 'u'
            ) goto L0003;
            ctx->cur++;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    {
        int u;
        const size_t n = pcc_get_char_as_utf32(ctx, &u);
        if (n == 0) goto L0000;
        ctx->cur += n;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "inStringEscapedChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "inStringEscapedChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_inStringUnicodeChar(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "inStringUnicodeChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 3) < 3 ||
        (ctx->buffer.buf + ctx->cur)[0] != '\\' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'u' ||
        (ctx->buffer.buf + ctx->cur)[2] != '{'
    ) goto L0000;
    ctx->cur += 3;
    {
        const size_t p0 = ctx->cur;
        const size_t n0 = chunk->thunks.len;
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int u;
                const size_t n = pcc_get_char_as_utf32(ctx, &u);
                if (n == 0) goto L0001;
                if (!(
                    (u >= 0x000030 && u <= 0x000039) ||
                    (u >= 0x000041 && u <= 0x000046) ||
                    (u >= 0x000061 && u <= 0x000066)
                )) goto L0001;
                ctx->cur += n;
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
        if (i < 1) {
            ctx->cur = p0;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
            goto L0000;
        }
    }
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '}'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "inStringUnicodeChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "inStringUnicodeChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_WS(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "WS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p0 = ctx->cur;
        const size_t n0 = chunk->thunks.len;
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int u;
                const size_t n = pcc_get_char_as_utf32(ctx, &u);
                if (n == 0) goto L0001;
                if (!(
                    u == 0x000020 ||
                    u == 0x000009
                )) goto L0001;
                ctx->cur += n;
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
        if (i < 1) {
            ctx->cur = p0;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
            goto L0000;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "WS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "WS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_NL(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "NL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '\n'
        ) goto L0002;
        ctx->cur++;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '\f'
        ) goto L0003;
        ctx->cur++;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '\r'
        ) goto L0004;
        ctx->cur++;
        {
            MARK_VAR_AS_USED
            const size_t p = ctx->cur;
            MARK_VAR_AS_USED
            const size_t n = chunk->thunks.len;
            if (
                pcc_refill_buffer(ctx, 1) < 1 ||
                ctx->buffer.buf[ctx->cur] != '\n'
            ) goto L0005;
            ctx->cur++;
            goto L0006;
        L0005:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0006:;
        }
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "NL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "NL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_Non_NL(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "Non_NL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int u;
        const size_t n = pcc_get_char_as_utf32(ctx, &u);
        if (n == 0) goto L0000;
        if (
            u == 0x00000a ||
            u == 0x00000d ||
            u == 0x00000c
        ) goto L0000;
        ctx->cur += n;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "Non_NL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "Non_NL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_Non_WS_or_NL(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "Non_WS_or_NL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int u;
        const size_t n = pcc_get_char_as_utf32(ctx, &u);
        if (n == 0) goto L0000;
        if (
            u == 0x000020 ||
            u == 0x000009 ||
            u == 0x00000a ||
            u == 0x00000d ||
            u == 0x00000c
        ) goto L0000;
        ctx->cur += n;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "Non_WS_or_NL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "Non_WS_or_NL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_EOF(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "EOF", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0001;
            ctx->cur += n;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "EOF", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "EOF", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_delimitedComment(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "delimitedComment", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != '{' ||
        (ctx->buffer.buf + ctx->cur)[1] != '-'
    ) goto L0000;
    ctx->cur += 2;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                MARK_VAR_AS_USED
                const size_t p = ctx->cur;
                MARK_VAR_AS_USED
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_delimitedComment, &chunk->thunks, NULL)) goto L0003;
                goto L0002;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                {
                    const size_t p = ctx->cur;
                    if (
                        pcc_refill_buffer(ctx, 2) < 2 ||
                        (ctx->buffer.buf + ctx->cur)[0] != '-' ||
                        (ctx->buffer.buf + ctx->cur)[1] != '}'
                    ) goto L0005;
                    ctx->cur += 2;
                    ctx->cur = p;
                    goto L0004;
                L0005:;
                    ctx->cur = p;
                }
                {
                    int u;
                    const size_t n = pcc_get_char_as_utf32(ctx, &u);
                    if (n == 0) goto L0004;
                    ctx->cur += n;
                }
                goto L0002;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                goto L0001;
            L0002:;
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != '-' ||
        (ctx->buffer.buf + ctx->cur)[1] != '}'
    ) goto L0000;
    ctx->cur += 2;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "delimitedComment", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "delimitedComment", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_lineComment(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "lineComment", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != '-' ||
        (ctx->buffer.buf + ctx->cur)[1] != '-'
    ) goto L0000;
    ctx->cur += 2;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Non_NL, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "lineComment", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "lineComment", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule__1_short(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "_1_short", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                MARK_VAR_AS_USED
                const size_t p = ctx->cur;
                MARK_VAR_AS_USED
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_lineComment, &chunk->thunks, NULL)) goto L0003;
                goto L0002;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0004;
                goto L0002;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                goto L0001;
            L0002:;
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_WS, &chunk->thunks, NULL)) goto L0006;
        goto L0005;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_delimitedComment, &chunk->thunks, NULL)) goto L0007;
        goto L0005;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0005:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "_1_short", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "_1_short", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule__1_(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "_1_", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p0 = ctx->cur;
        const size_t n0 = chunk->thunks.len;
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__1_short, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
        if (i < 1) {
            ctx->cur = p0;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
            goto L0000;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "_1_", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "_1_", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule__0_(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "_0_", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__1_, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "_0_", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_TLSS_short(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "TLSS_short", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                MARK_VAR_AS_USED
                const size_t p = ctx->cur;
                MARK_VAR_AS_USED
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_WS, &chunk->thunks, NULL)) goto L0003;
                goto L0002;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_lineComment, &chunk->thunks, NULL)) goto L0004;
                goto L0002;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_delimitedComment, &chunk->thunks, NULL)) goto L0005;
                goto L0002;
            L0005:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                goto L0001;
            L0002:;
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0007;
        goto L0006;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EOF, &chunk->thunks, NULL)) goto L0008;
        goto L0006;
    L0008:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0006:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "TLSS_short", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "TLSS_short", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_TLSS(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "TLSS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p0 = ctx->cur;
        const size_t n0 = chunk->thunks.len;
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_TLSS_short, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
        if (i < 1) {
            ctx->cur = p0;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
            goto L0000;
        }
    }
    {
        const size_t p = ctx->cur;
        {
            MARK_VAR_AS_USED
            const size_t p = ctx->cur;
            MARK_VAR_AS_USED
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_WS, &chunk->thunks, NULL)) goto L0004;
            goto L0003;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_lineComment, &chunk->thunks, NULL)) goto L0005;
            goto L0003;
        L0005:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_delimitedComment, &chunk->thunks, NULL)) goto L0006;
            goto L0003;
        L0006:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0002;
        L0003:;
        }
        ctx->cur = p;
        goto L0000;
    L0002:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "TLSS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "TLSS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_EOS(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "EOS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        {
            MARK_VAR_AS_USED
            const size_t p = ctx->cur;
            MARK_VAR_AS_USED
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_TLSS, &chunk->thunks, NULL)) goto L0004;
            goto L0003;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EOF, &chunk->thunks, NULL)) goto L0005;
            goto L0003;
        L0005:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0003:;
        }
        ctx->cur = p;
        goto L0002;
    L0001:;
        ctx->cur = p;
        goto L0000;
    L0002:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "EOS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "EOS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule__NL_IND_(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "_NL_IND_", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p0 = ctx->cur;
        const size_t n0 = chunk->thunks.len;
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_TLSS_short, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
        if (i < 1) {
            ctx->cur = p0;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
            goto L0000;
        }
    }
    {
        const size_t p0 = ctx->cur;
        const size_t n0 = chunk->thunks.len;
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_WS, &chunk->thunks, NULL)) goto L0002;
            if (ctx->cur == p) break;
            continue;
        L0002:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
        if (i < 1) {
            ctx->cur = p0;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
            goto L0000;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "_NL_IND_", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "_NL_IND_", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

pelm_context_t *pelm_create(struct parserCtx *auxil) {
    return pcc_context__create(auxil);
}

int pelm_parse(pelm_context_t *ctx, int *ret) {
    if (pcc_apply_rule(ctx, pcc_evaluate_rule_file, &ctx->thunks, ret))
        pcc_do_action(ctx, &ctx->thunks, ret);
    else
        PCC_ERROR(ctx->auxil);
    pcc_commit_buffer(ctx);
    pcc_thunk_array__revert(ctx->auxil, &ctx->thunks, 0);
    return pcc_refill_buffer(ctx, 1) >= 1;
}

void pelm_destroy(pelm_context_t *ctx) {
    pcc_context__destroy(ctx);
}

#include "elm_post.h"
