/* src/bazaar.p/bz-flathub-auth-provider.c
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "src/bazaar.p/bz-flathub-auth-provider.h"



struct _BzFlathubAuthProvider
{
  GObject parent_instance;

  char *method;
  char *name;
};

G_DEFINE_FINAL_TYPE (BzFlathubAuthProvider, bz_flathub_auth_provider, G_TYPE_OBJECT);

enum
{
  PROP_0,

  PROP_METHOD,
  PROP_NAME,

  LAST_PROP
};
static GParamSpec *props[LAST_PROP] = { 0 };

static void
bz_flathub_auth_provider_dispose (GObject *object)
{
  BzFlathubAuthProvider *self = BZ_FLATHUB_AUTH_PROVIDER (object);

  g_clear_pointer (&self->method, g_free);
  g_clear_pointer (&self->name, g_free);

  G_OBJECT_CLASS (bz_flathub_auth_provider_parent_class)->dispose (object);
}

static void
bz_flathub_auth_provider_get_property (GObject    *object,
                       guint       prop_id,
                       GValue     *value,
                       GParamSpec *pspec)
{
  BzFlathubAuthProvider *self = BZ_FLATHUB_AUTH_PROVIDER (object);

  switch (prop_id)
    {
    case PROP_METHOD:
      g_value_set_string (value, bz_flathub_auth_provider_get_method (self));
      break;
    case PROP_NAME:
      g_value_set_string (value, bz_flathub_auth_provider_get_name (self));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_flathub_auth_provider_set_property (GObject      *object,
                       guint         prop_id,
                       const GValue *value,
                       GParamSpec   *pspec)
{
  BzFlathubAuthProvider *self = BZ_FLATHUB_AUTH_PROVIDER (object);

  switch (prop_id)
    {
    case PROP_METHOD:
      bz_flathub_auth_provider_set_method (self, g_value_get_string (value));
      break;
    case PROP_NAME:
      bz_flathub_auth_provider_set_name (self, g_value_get_string (value));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_flathub_auth_provider_class_init (BzFlathubAuthProviderClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);



  object_class->set_property = bz_flathub_auth_provider_set_property;
  object_class->get_property = bz_flathub_auth_provider_get_property;
  object_class->dispose      = bz_flathub_auth_provider_dispose;

  props[PROP_METHOD] =
      g_param_spec_string (
          "method",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_NAME] =
      g_param_spec_string (
          "name",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  g_object_class_install_properties (object_class, LAST_PROP, props);
}

static void
bz_flathub_auth_provider_init (BzFlathubAuthProvider *self)
{
}

BzFlathubAuthProvider *
bz_flathub_auth_provider_new (void){
  return g_object_new (BZ_TYPE_FLATHUB_AUTH_PROVIDER, NULL);
}

const char *
bz_flathub_auth_provider_get_method (BzFlathubAuthProvider *self){
  g_return_val_if_fail (BZ_IS_FLATHUB_AUTH_PROVIDER (self), NULL);
  return self->method;
}

const char *
bz_flathub_auth_provider_get_name (BzFlathubAuthProvider *self){
  g_return_val_if_fail (BZ_IS_FLATHUB_AUTH_PROVIDER (self), NULL);
  return self->name;
}

void
bz_flathub_auth_provider_set_method (BzFlathubAuthProvider *self,
    const char *method){
  g_return_if_fail (BZ_IS_FLATHUB_AUTH_PROVIDER (self));

  if (method == self->method || (method != NULL && self->method != NULL && g_strcmp0(method, self->method) == 0))
    return;

  g_clear_pointer (&self->method, g_free);
  if (method != NULL)
    self->method = g_strdup (method);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_METHOD]);
}

void
bz_flathub_auth_provider_set_name (BzFlathubAuthProvider *self,
    const char *name){
  g_return_if_fail (BZ_IS_FLATHUB_AUTH_PROVIDER (self));

  if (name == self->name || (name != NULL && self->name != NULL && g_strcmp0(name, self->name) == 0))
    return;

  g_clear_pointer (&self->name, g_free);
  if (name != NULL)
    self->name = g_strdup (name);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_NAME]);
}

/* End of src/bazaar.p/bz-flathub-auth-provider.c */
