﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/ce/model/UpdateCostAllocationTagsStatusError.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace CostExplorer {
namespace Model {

UpdateCostAllocationTagsStatusError::UpdateCostAllocationTagsStatusError(JsonView jsonValue) { *this = jsonValue; }

UpdateCostAllocationTagsStatusError& UpdateCostAllocationTagsStatusError::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("TagKey")) {
    m_tagKey = jsonValue.GetString("TagKey");
    m_tagKeyHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Code")) {
    m_code = jsonValue.GetString("Code");
    m_codeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Message")) {
    m_message = jsonValue.GetString("Message");
    m_messageHasBeenSet = true;
  }
  return *this;
}

JsonValue UpdateCostAllocationTagsStatusError::Jsonize() const {
  JsonValue payload;

  if (m_tagKeyHasBeenSet) {
    payload.WithString("TagKey", m_tagKey);
  }

  if (m_codeHasBeenSet) {
    payload.WithString("Code", m_code);
  }

  if (m_messageHasBeenSet) {
    payload.WithString("Message", m_message);
  }

  return payload;
}

}  // namespace Model
}  // namespace CostExplorer
}  // namespace Aws
