﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/appintegrations/model/CreateApplicationRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::AppIntegrationsService::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String CreateApplicationRequest::SerializePayload() const {
  JsonValue payload;

  if (m_nameHasBeenSet) {
    payload.WithString("Name", m_name);
  }

  if (m_namespaceHasBeenSet) {
    payload.WithString("Namespace", m_namespace);
  }

  if (m_descriptionHasBeenSet) {
    payload.WithString("Description", m_description);
  }

  if (m_applicationSourceConfigHasBeenSet) {
    payload.WithObject("ApplicationSourceConfig", m_applicationSourceConfig.Jsonize());
  }

  if (m_clientTokenHasBeenSet) {
    payload.WithString("ClientToken", m_clientToken);
  }

  if (m_tagsHasBeenSet) {
    JsonValue tagsJsonMap;
    for (auto& tagsItem : m_tags) {
      tagsJsonMap.WithString(tagsItem.first, tagsItem.second);
    }
    payload.WithObject("Tags", std::move(tagsJsonMap));
  }

  if (m_permissionsHasBeenSet) {
    Aws::Utils::Array<JsonValue> permissionsJsonList(m_permissions.size());
    for (unsigned permissionsIndex = 0; permissionsIndex < permissionsJsonList.GetLength(); ++permissionsIndex) {
      permissionsJsonList[permissionsIndex].AsString(m_permissions[permissionsIndex]);
    }
    payload.WithArray("Permissions", std::move(permissionsJsonList));
  }

  if (m_initializationTimeoutHasBeenSet) {
    payload.WithInteger("InitializationTimeout", m_initializationTimeout);
  }

  if (m_applicationConfigHasBeenSet) {
    payload.WithObject("ApplicationConfig", m_applicationConfig.Jsonize());
  }

  if (m_iframeConfigHasBeenSet) {
    payload.WithObject("IframeConfig", m_iframeConfig.Jsonize());
  }

  if (m_applicationTypeHasBeenSet) {
    payload.WithString("ApplicationType", ApplicationTypeMapper::GetNameForApplicationType(m_applicationType));
  }

  return payload.View().WriteReadable();
}
