﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/apigatewayv2/ApiGatewayV2ErrorMarshaller.h>
#include <aws/apigatewayv2/ApiGatewayV2Errors.h>
#include <aws/core/client/AWSError.h>

using namespace Aws::Client;
using namespace Aws::ApiGatewayV2;

AWSError<CoreErrors> ApiGatewayV2ErrorMarshaller::FindErrorByName(const char* errorName) const {
  AWSError<CoreErrors> error = ApiGatewayV2ErrorMapper::GetErrorForName(errorName);
  if (error.GetErrorType() != CoreErrors::UNKNOWN) {
    return error;
  }

  return AWSErrorMarshaller::FindErrorByName(errorName);
}